/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.MessageQueue;
import net.grinder.communication.QueuedSender;
import net.grinder.communication.Sender;
import net.grinder.util.thread.ThreadSafeQueue;

public final class QueuedSenderDecorator
implements QueuedSender {
    private final Sender m_delegate;
    private final MessageQueue m_messageQueue = new MessageQueue(false);

    public QueuedSenderDecorator(Sender delegate) {
        this.m_delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws CommunicationException {
        Object object = this.m_messageQueue.getMonitor();
        synchronized (object) {
            this.queue(message);
            this.flush();
        }
    }

    public void queue(Message message) throws CommunicationException {
        try {
            this.m_messageQueue.queue(message);
        }
        catch (ThreadSafeQueue.ShutdownException e) {
            throw new CommunicationException("Shut down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws CommunicationException {
        try {
            Object object = this.m_messageQueue.getMonitor();
            synchronized (object) {
                Message message;
                while ((message = this.m_messageQueue.dequeue(false)) != null) {
                    this.m_delegate.send(message);
                }
            }
        }
        catch (ThreadSafeQueue.ShutdownException e) {
            throw new CommunicationException("Shut down");
        }
    }

    public void shutdown() {
        this.m_messageQueue.shutdown();
        this.m_delegate.shutdown();
    }
}

