/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.grinder.common.GrinderBuild;
import net.grinder.util.html.HTMLDocument;
import net.grinder.util.html.HTMLElement;

final class HTTPResponse {
    private String m_status = "500 Internal Server Error";
    private final Map m_responseHeaders = new HashMap();
    private final StringBuffer m_responseBody = new StringBuffer();

    public HTTPResponse() {
        this.setHeader("Proxy-agent", GrinderBuild.getName());
    }

    public void setHeader(String key, String value) {
        this.m_responseHeaders.put(key, value);
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public void setMessage(String title, HTMLElement text) {
        this.setHeader("Content-type", "text/html");
        this.setHeader("Connection", "close");
        HTMLDocument document = new HTMLDocument();
        document.getHead().addElement("title").addText(title);
        document.getBody().addElement("h1").addText(title);
        document.getBody().addText(text.toHTML());
        document.getBody().addElement("hr");
        document.getBody().addText(GrinderBuild.getName());
        document.getBody().addElement("br");
        document.getBody().addText(new Date().toString());
        this.m_responseBody.append(document.toHTML());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("HTTP/1.0 ");
        result.append(this.m_status);
        result.append("\r\n");
        Iterator iterator = this.m_responseHeaders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry header = iterator.next();
            result.append(header.getKey());
            result.append(": ");
            result.append(header.getValue());
            result.append("\r\n");
        }
        result.append("\r\n");
        result.append(this.m_responseBody);
        return result.toString();
    }
}

