/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsSetImplementation;
import net.grinder.util.Serialiser;

public final class StatisticsSetFactory {
    private final Serialiser m_serialiser = new Serialiser();
    private final StatisticsIndexMap m_statisticsIndexMap;

    StatisticsSetFactory(StatisticsIndexMap statisticsIndexMap) {
        this.m_statisticsIndexMap = statisticsIndexMap;
    }

    public StatisticsSet create() {
        return new StatisticsSetImplementation(this.m_statisticsIndexMap);
    }

    void writeStatisticsExternal(ObjectOutput out, StatisticsSetImplementation statistics) throws IOException {
        statistics.writeExternal(out, this.m_serialiser);
    }

    StatisticsSet readStatisticsExternal(ObjectInput in) throws IOException {
        return new StatisticsSetImplementation(this.m_statisticsIndexMap, in, this.m_serialiser);
    }
}

