/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.util.ArrayList;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.PeakStatisticExpression;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticExpressionFactory;
import net.grinder.statistics.StatisticsException;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;

final class StatisticExpressionFactoryImplementation
implements StatisticExpressionFactory {
    private final StatisticsIndexMap m_indexMap;

    StatisticExpressionFactoryImplementation(StatisticsIndexMap statisticsIndexMap) {
        this.m_indexMap = statisticsIndexMap;
    }

    public String normaliseExpressionString(String expression) throws StatisticsException {
        ParseContext parseContext = new ParseContext(expression);
        StringBuffer result = new StringBuffer(expression.length());
        this.normaliseExpressionString(parseContext, result);
        if (parseContext.hasMoreCharacters()) {
            ParseContext parseContext2 = parseContext;
            parseContext2.getClass();
            throw parseContext2.new ParseContext.ParseException("Additional characters found");
        }
        return result.toString();
    }

    private void normaliseExpressionString(ParseContext parseContext, StringBuffer result) throws StatisticsException {
        if (parseContext.peekCharacter() == '(') {
            result.append(parseContext.readCharacter());
            result.append(parseContext.readToken());
            while (parseContext.peekCharacter() != ')') {
                result.append(' ');
                this.normaliseExpressionString(parseContext, result);
            }
            result.append(parseContext.readCharacter());
        } else {
            result.append(parseContext.readToken());
        }
    }

    public StatisticExpression createExpression(String expression) throws StatisticsException {
        ParseContext parseContext = new ParseContext(expression);
        StatisticExpression result = this.readExpression(parseContext);
        if (parseContext.hasMoreCharacters()) {
            ParseContext parseContext2 = parseContext;
            parseContext2.getClass();
            throw parseContext2.new ParseContext.ParseException("Additional characters found");
        }
        return result;
    }

    private StatisticExpression readExpression(ParseContext parseContext) throws ParseContext.ParseException {
        if (parseContext.peekCharacter() == '(') {
            StatisticExpression result;
            parseContext.readCharacter();
            String operation = parseContext.readToken();
            if ("+".equals(operation)) {
                result = this.createSum(this.readOperands(parseContext));
            } else if ("-".equals(operation)) {
                StatisticExpression firstOperand = this.readExpression(parseContext);
                StatisticExpression[] others = this.readOperands(parseContext);
                result = others.length == 0 ? this.createNegation(firstOperand) : this.createMinus(firstOperand, others);
            } else if ("*".equals(operation)) {
                result = this.createProduct(this.readOperands(parseContext));
            } else if ("/".equals(operation)) {
                result = this.createDivision(this.readExpression(parseContext), this.readExpression(parseContext));
            } else if ("sum".equals(operation)) {
                result = this.createSampleSum(parseContext);
            } else if ("count".equals(operation)) {
                result = this.createSampleCount(parseContext);
            } else if ("variance".equals(operation)) {
                result = this.createSampleVariance(parseContext);
            } else if ("sqrt".equals(operation)) {
                result = this.createSquareRoot(this.readExpression(parseContext));
            } else {
                ParseContext parseContext2 = parseContext;
                parseContext2.getClass();
                throw parseContext2.new ParseContext.ParseException("Unknown operation '" + operation + "'");
            }
            if (parseContext.readCharacter() != ')') {
                ParseContext parseContext3 = parseContext;
                parseContext3.getClass();
                throw parseContext3.new ParseContext.ParseException("Expecting ')'");
            }
            return result;
        }
        String token = parseContext.readToken();
        try {
            return this.createConstant(Long.parseLong(token));
        }
        catch (NumberFormatException e) {
            try {
                return this.createConstant(Double.parseDouble(token));
            }
            catch (NumberFormatException e2) {
                StatisticsIndexMap.LongIndex longIndex = this.m_indexMap.getLongIndex(token);
                if (longIndex != null) {
                    return this.createPrimitive(longIndex);
                }
                StatisticsIndexMap.DoubleIndex doubleIndex = this.m_indexMap.getDoubleIndex(token);
                if (doubleIndex != null) {
                    return this.createPrimitive(doubleIndex);
                }
                ParseContext parseContext4 = parseContext;
                parseContext4.getClass();
                throw parseContext4.new ParseContext.ParseException("Unknown token '" + token + "'");
            }
        }
    }

    public StatisticExpression createConstant(final long value) {
        return new LongStatistic(){

            public long getValue(StatisticsSet statisticsSet) {
                return value;
            }
        };
    }

    public StatisticExpression createConstant(final double value) {
        return new DoubleStatistic(){

            public double getValue(StatisticsSet statisticsSet) {
                return value;
            }
        };
    }

    public StatisticExpression createPrimitive(StatisticsIndexMap.DoubleIndex index) {
        return new PrimitiveDoubleStatistic(index);
    }

    public StatisticExpression createPrimitive(StatisticsIndexMap.LongIndex index) {
        return new PrimitiveLongStatistic(index);
    }

    public StatisticExpression createSum(StatisticExpression[] operands) {
        return new FoldArgumentsExpressionFactory(0.0, operands){

            public double doDoubleOperation(double result, StatisticExpression operand, StatisticsSet statisticsSet) {
                return result + operand.getDoubleValue(statisticsSet);
            }

            public long doLongOperation(long result, StatisticExpression operand, StatisticsSet statisticsSet) {
                return result + operand.getLongValue(statisticsSet);
            }
        }.getExpression();
    }

    public StatisticExpression createNegation(final StatisticExpression operand) {
        if (operand.isDouble()) {
            return new DoubleStatistic(){

                protected double getValue(StatisticsSet statisticsSet) {
                    return -operand.getDoubleValue(statisticsSet);
                }
            };
        }
        return new LongStatistic(){

            protected long getValue(StatisticsSet statisticsSet) {
                return -operand.getLongValue(statisticsSet);
            }
        };
    }

    public StatisticExpression createMinus(StatisticExpression firstOperand, StatisticExpression[] otherOperands) {
        return new FoldArgumentsExpressionFactory(firstOperand, otherOperands){

            public double doDoubleOperation(double result, StatisticExpression operand, StatisticsSet statisticsSet) {
                return result - operand.getDoubleValue(statisticsSet);
            }

            public long doLongOperation(long result, StatisticExpression operand, StatisticsSet statisticsSet) {
                return result - operand.getLongValue(statisticsSet);
            }
        }.getExpression();
    }

    public StatisticExpression createProduct(StatisticExpression[] operands) {
        return new FoldArgumentsExpressionFactory(1.0, operands){

            public double doDoubleOperation(double result, StatisticExpression operand, StatisticsSet statisticsSet) {
                return result * operand.getDoubleValue(statisticsSet);
            }

            public long doLongOperation(long result, StatisticExpression operand, StatisticsSet statisticsSet) {
                return result * operand.getLongValue(statisticsSet);
            }
        }.getExpression();
    }

    public StatisticExpression createDivision(final StatisticExpression numerator, final StatisticExpression denominator) {
        return new DoubleStatistic(){

            public double getValue(StatisticsSet statisticsSet) {
                return numerator.getDoubleValue(statisticsSet) / denominator.getDoubleValue(statisticsSet);
            }
        };
    }

    private StatisticExpression createSampleSum(ParseContext parseContext) throws ParseContext.ParseException {
        StatisticExpression result;
        String token = parseContext.readToken();
        StatisticsIndexMap.DoubleSampleIndex doubleSampleIndex = this.m_indexMap.getDoubleSampleIndex(token);
        if (doubleSampleIndex != null) {
            result = this.createPrimitive(doubleSampleIndex.getSumIndex());
        } else {
            StatisticsIndexMap.LongSampleIndex longSampleIndex = this.m_indexMap.getLongSampleIndex(token);
            if (longSampleIndex != null) {
                result = this.createPrimitive(longSampleIndex.getSumIndex());
            } else {
                ParseContext parseContext2 = parseContext;
                parseContext2.getClass();
                throw parseContext2.new ParseContext.ParseException("Can't apply sum to unknown sample index '" + token + "'");
            }
        }
        return result;
    }

    private StatisticExpression createSampleCount(ParseContext parseContext) throws ParseContext.ParseException {
        StatisticExpression result;
        String token = parseContext.readToken();
        StatisticsIndexMap.DoubleSampleIndex doubleSampleIndex = this.m_indexMap.getDoubleSampleIndex(token);
        if (doubleSampleIndex != null) {
            result = this.createPrimitive(doubleSampleIndex.getCountIndex());
        } else {
            StatisticsIndexMap.LongSampleIndex longSampleIndex = this.m_indexMap.getLongSampleIndex(token);
            if (longSampleIndex != null) {
                result = this.createPrimitive(longSampleIndex.getCountIndex());
            } else {
                ParseContext parseContext2 = parseContext;
                parseContext2.getClass();
                throw parseContext2.new ParseContext.ParseException("Can't apply count to unknown sample index '" + token + "'");
            }
        }
        return result;
    }

    private StatisticExpression createSampleVariance(ParseContext parseContext) throws ParseContext.ParseException {
        StatisticExpression result;
        String token = parseContext.readToken();
        StatisticsIndexMap.DoubleSampleIndex doubleSampleIndex = this.m_indexMap.getDoubleSampleIndex(token);
        if (doubleSampleIndex != null) {
            result = this.createPrimitive(doubleSampleIndex.getVarianceIndex());
        } else {
            StatisticsIndexMap.LongSampleIndex longSampleIndex = this.m_indexMap.getLongSampleIndex(token);
            if (longSampleIndex != null) {
                result = this.createPrimitive(longSampleIndex.getVarianceIndex());
            } else {
                ParseContext parseContext2 = parseContext;
                parseContext2.getClass();
                throw parseContext2.new ParseContext.ParseException("Can't apply variance to unknown sample index '" + token + "'");
            }
        }
        return result;
    }

    public StatisticExpression createSquareRoot(final StatisticExpression operand) {
        return new DoubleStatistic(){

            public double getValue(StatisticsSet statisticsSet) {
                return Math.sqrt(operand.getDoubleValue(statisticsSet));
            }
        };
    }

    public PeakStatisticExpression createPeak(StatisticsIndexMap.DoubleIndex peakIndex, StatisticExpression monitoredStatistic) {
        return new PeakDoubleStatistic(peakIndex, monitoredStatistic);
    }

    public PeakStatisticExpression createPeak(StatisticsIndexMap.LongIndex peakIndex, StatisticExpression monitoredStatistic) {
        return new PeakLongStatistic(peakIndex, monitoredStatistic);
    }

    public ExpressionView createExpressionView(String displayName, String expressionString, boolean showForCompositeStatistics) throws StatisticsException {
        return new ExpressionView(displayName, this.normaliseExpressionString(expressionString), this.createExpression(expressionString), showForCompositeStatistics);
    }

    public ExpressionView createExpressionView(String displayName, StatisticExpression expression) {
        return new ExpressionView(displayName, null, expression, false);
    }

    private StatisticExpression[] readOperands(ParseContext parseContext) throws ParseContext.ParseException {
        ArrayList<StatisticExpression> arrayList = new ArrayList<StatisticExpression>();
        while (parseContext.peekCharacter() != ')') {
            arrayList.add(this.readExpression(parseContext));
        }
        return arrayList.toArray(new StatisticExpression[arrayList.size()]);
    }

    static final class ParseContext {
        private static final char EOS_SENTINEL = '\u0000';
        private final char[] m_expression;
        private int m_index;

        public ParseContext(String expression) {
            this.m_expression = expression.toCharArray();
            this.m_index = 0;
        }

        public boolean hasMoreCharacters() {
            this.eatWhiteSpace();
            return this.m_index < this.m_expression.length;
        }

        public char peekCharacter() {
            this.eatWhiteSpace();
            return this.peekCharacterNoEat();
        }

        private char peekCharacterNoEat() {
            if (this.m_index >= this.m_expression.length) {
                return '\u0000';
            }
            return this.m_expression[this.m_index];
        }

        public char readCharacter() {
            char result = this.peekCharacter();
            if (result != '\u0000') {
                ++this.m_index;
            }
            return result;
        }

        public String readToken() throws ParseException {
            this.eatWhiteSpace();
            int start = this.m_index;
            while (this.isTokenCharacter(this.peekCharacterNoEat())) {
                ++this.m_index;
            }
            int stringLength = this.m_index - start;
            if (stringLength == 0) {
                throw new ParseException("Expected a token", start);
            }
            return new String(this.m_expression, start, stringLength);
        }

        private boolean isTokenCharacter(char c) {
            return c != '\u0000' && c != '(' && c != ')' && !Character.isWhitespace(c);
        }

        private void eatWhiteSpace() {
            while (Character.isWhitespace(this.peekCharacterNoEat())) {
                ++this.m_index;
            }
        }

        public final class ParseException
        extends StatisticsException {
            private ParseException(String message) {
                this(message, this$0.m_index);
            }

            public ParseException(String message, int where) {
                super("Parse exception: " + message + ", at character " + where + " of '" + new String(ParseContext.this.m_expression) + "'");
            }
        }
    }

    private abstract class FoldArgumentsExpressionFactory {
        private final StatisticExpression m_expression;

        public FoldArgumentsExpressionFactory(double initialValue, StatisticExpression[] operands) {
            this(this$0.createConstant(initialValue), operands);
        }

        public FoldArgumentsExpressionFactory(StatisticExpression initialValue, StatisticExpression[] operands) {
            boolean doubleResult = false;
            for (int i = 0; i < operands.length && !doubleResult; ++i) {
                if (!operands[i].isDouble()) continue;
                doubleResult = true;
            }
            this.m_expression = doubleResult ? new DoubleStatistic(this, initialValue, operands){
                private final /* synthetic */ StatisticExpression val$initialValue;
                private final /* synthetic */ StatisticExpression[] val$operands;
                private final /* synthetic */ FoldArgumentsExpressionFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$initialValue = val$initialValue;
                    this.val$operands = val$operands;
                    super();
                }

                public final double getValue(StatisticsSet statisticsSet) {
                    double result = this.val$initialValue.getDoubleValue(statisticsSet);
                    for (int i = 0; i < this.val$operands.length; ++i) {
                        result = this.this$1.doDoubleOperation(result, this.val$operands[i], statisticsSet);
                    }
                    return result;
                }
            } : new LongStatistic(this, initialValue, operands){
                private final /* synthetic */ StatisticExpression val$initialValue;
                private final /* synthetic */ StatisticExpression[] val$operands;
                private final /* synthetic */ FoldArgumentsExpressionFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$initialValue = val$initialValue;
                    this.val$operands = val$operands;
                    super();
                }

                public final long getValue(StatisticsSet statisticsSet) {
                    long result = this.val$initialValue.getLongValue(statisticsSet);
                    for (int i = 0; i < this.val$operands.length; ++i) {
                        result = this.this$1.doLongOperation(result, this.val$operands[i], statisticsSet);
                    }
                    return result;
                }
            };
        }

        protected abstract double doDoubleOperation(double var1, StatisticExpression var3, StatisticsSet var4);

        protected abstract long doLongOperation(long var1, StatisticExpression var3, StatisticsSet var4);

        final StatisticExpression getExpression() {
            return this.m_expression;
        }
    }

    private static class PeakLongStatistic
    extends PrimitiveLongStatistic
    implements PeakStatisticExpression {
        private final StatisticExpression m_monitoredStatistic;

        public PeakLongStatistic(StatisticsIndexMap.LongIndex peakIndex, StatisticExpression monitoredStatistic) {
            super(peakIndex);
            this.m_monitoredStatistic = monitoredStatistic;
        }

        public void update(StatisticsSet monitoredStatistics, StatisticsSet peakStorageStatistics) {
            this.setValue(peakStorageStatistics, Math.max(this.getValue(peakStorageStatistics), this.m_monitoredStatistic.getLongValue(monitoredStatistics)));
        }
    }

    private static class PrimitiveLongStatistic
    extends LongStatistic {
        private final StatisticsIndexMap.LongIndex m_index;

        public PrimitiveLongStatistic(StatisticsIndexMap.LongIndex index) {
            this.m_index = index;
        }

        public final long getValue(StatisticsSet statisticsSet) {
            return statisticsSet.getValue(this.m_index);
        }

        protected final void setValue(StatisticsSet statisticsSet, long value) {
            statisticsSet.setValue(this.m_index, value);
        }
    }

    private static abstract class LongStatistic
    implements StatisticExpression {
        private LongStatistic() {
        }

        public final double getDoubleValue(StatisticsSet statisticsSet) {
            return this.getValue(statisticsSet);
        }

        public final long getLongValue(StatisticsSet statisticsSet) {
            return this.getValue(statisticsSet);
        }

        public final boolean isDouble() {
            return false;
        }

        protected abstract long getValue(StatisticsSet var1);
    }

    private static class PeakDoubleStatistic
    extends PrimitiveDoubleStatistic
    implements PeakStatisticExpression {
        private final StatisticExpression m_monitoredStatistic;

        public PeakDoubleStatistic(StatisticsIndexMap.DoubleIndex peakIndex, StatisticExpression monitoredStatistic) {
            super(peakIndex);
            this.m_monitoredStatistic = monitoredStatistic;
        }

        public void update(StatisticsSet monitoredStatistics, StatisticsSet peakStorageStatistics) {
            this.setValue(peakStorageStatistics, Math.max(this.getValue(peakStorageStatistics), this.m_monitoredStatistic.getDoubleValue(monitoredStatistics)));
        }
    }

    private static class PrimitiveDoubleStatistic
    extends DoubleStatistic {
        private final StatisticsIndexMap.DoubleIndex m_index;

        public PrimitiveDoubleStatistic(StatisticsIndexMap.DoubleIndex index) {
            this.m_index = index;
        }

        public final double getValue(StatisticsSet statisticsSet) {
            return statisticsSet.getValue(this.m_index);
        }

        protected final void setValue(StatisticsSet statisticsSet, double value) {
            statisticsSet.setValue(this.m_index, value);
        }
    }

    private static abstract class DoubleStatistic
    implements StatisticExpression {
        private DoubleStatistic() {
        }

        public final double getDoubleValue(StatisticsSet statisticsSet) {
            return this.getValue(statisticsSet);
        }

        public final long getLongValue(StatisticsSet statisticsSet) {
            return (long)this.getValue(statisticsSet);
        }

        public final boolean isDouble() {
            return true;
        }

        protected abstract double getValue(StatisticsSet var1);
    }
}

