/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.grinder.console.common.Resources;
import net.grinder.console.swingui.Colours;
import net.grinder.console.swingui.Graph;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.TestStatisticsQueries;

class LabelledGraph
extends JPanel {
    private static double s_peak = 0.0;
    private static double s_lastPeak = 0.0;
    private static Border s_thinBevelBorder;
    private static final Color[] s_colors;
    private final Color m_color;
    private final Graph m_graph;
    private final StatisticExpression m_tpsExpression;
    private final StatisticExpression m_peakTPSExpression;
    private final TestStatisticsQueries m_testStatisticsQueries;
    private final Label m_averageTimeLabel;
    private final Label m_averageTPSLabel;
    private final Label m_peakTPSLabel;
    private final Label m_testsLabel;
    private final Label m_errorsLabel;
    private final Dimension m_preferredSize = new Dimension(250, 110);

    public LabelledGraph(String title, Resources resources, StatisticExpression tpsExpression, StatisticExpression peakTPSExpression, TestStatisticsQueries testStatisticsQueries) {
        this(title, resources, null, tpsExpression, peakTPSExpression, testStatisticsQueries);
    }

    public LabelledGraph(String title, Resources resources, Color color, StatisticExpression tpsExpression, StatisticExpression peakTPSExpression, TestStatisticsQueries testStatisticsQueries) {
        this.m_tpsExpression = tpsExpression;
        this.m_peakTPSExpression = peakTPSExpression;
        this.m_testStatisticsQueries = testStatisticsQueries;
        String msUnit = resources.getString("ms.unit");
        String msUnits = resources.getString("ms.units");
        String tpsUnits = resources.getString("tps.units");
        String testUnit = resources.getString("test.unit");
        String testUnits = resources.getString("test.units");
        String errorUnit = resources.getString("error.unit");
        String errorUnits = resources.getString("error.units");
        String averageSuffix = resources.getString("graph.averageSuffix.label");
        String peakSuffix = resources.getString("graph.peakSuffix.label");
        this.m_averageTimeLabel = new Label(msUnit, msUnits, averageSuffix);
        this.m_averageTPSLabel = new Label(tpsUnits, tpsUnits, averageSuffix);
        this.m_peakTPSLabel = new Label(tpsUnits, tpsUnits, peakSuffix);
        this.m_testsLabel = new Label(testUnit, testUnits, "");
        this.m_errorsLabel = new Label(errorUnit, errorUnits, "");
        this.m_color = color;
        this.m_graph = new Graph(25);
        this.m_graph.setPreferredSize(null);
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BoxLayout(graphPanel, 1));
        graphPanel.add(this.m_graph);
        if (s_thinBevelBorder == null) {
            s_thinBevelBorder = BorderFactory.createBevelBorder(1, this.getBackground(), this.getBackground().brighter(), this.getBackground(), this.getBackground().darker());
        }
        graphPanel.setBorder(s_thinBevelBorder);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 0, 0));
        JLabel titleLabel = new JLabel();
        titleLabel.setText(title);
        titleLabel.setForeground(Colours.BLACK);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        labelPanel.add(this.m_averageTimeLabel);
        labelPanel.add(this.m_averageTPSLabel);
        labelPanel.add(this.m_peakTPSLabel);
        labelPanel.add(this.m_testsLabel);
        labelPanel.add(this.m_errorsLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)titleLabel, "North");
        this.add((Component)labelPanel, "West");
        this.add((Component)graphPanel, "Center");
        Border border = this.getBorder();
        EmptyBorder margin = new EmptyBorder(10, 10, 10, 10);
        this.setBorder(new CompoundBorder(border, margin));
    }

    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public void add(StatisticsSet intervalStatistics, StatisticsSet cumulativeStatistics, NumberFormat numberFormat) {
        double averageTime = this.m_testStatisticsQueries.getAverageTestTime(cumulativeStatistics);
        long errors = this.m_testStatisticsQueries.getNumberOfErrors(cumulativeStatistics);
        double peakTPS = this.m_peakTPSExpression.getDoubleValue(cumulativeStatistics);
        this.m_graph.setMaximum(peakTPS);
        this.m_graph.add(this.m_tpsExpression.getDoubleValue(intervalStatistics));
        this.m_graph.setColor(this.calculateColour(averageTime));
        if (!Double.isNaN(averageTime)) {
            this.m_averageTimeLabel.set(averageTime, numberFormat);
        } else {
            this.m_averageTimeLabel.set("----");
        }
        this.m_averageTPSLabel.set(this.m_tpsExpression.getDoubleValue(cumulativeStatistics), numberFormat);
        this.m_peakTPSLabel.set(peakTPS, numberFormat);
        this.m_testsLabel.set(this.m_testStatisticsQueries.getNumberOfTests(cumulativeStatistics));
        this.m_errorsLabel.set(errors);
        this.m_errorsLabel.setHighlight(errors > 0L);
    }

    Color calculateColour(double time) {
        int colorIndex;
        if (this.m_color != null) {
            return this.m_color;
        }
        if (time > s_peak) {
            s_peak = time;
        }
        if ((colorIndex = (int)((double)s_colors.length * (time / s_lastPeak))) >= s_colors.length) {
            return s_colors[s_colors.length - 1];
        }
        return s_colors[colorIndex];
    }

    public static void resetPeak() {
        s_lastPeak = s_peak;
        s_peak = 0.0;
    }

    static {
        s_colors = new Color[]{new Color(240, 255, 0), new Color(240, 240, 0), new Color(240, 224, 0), new Color(240, 208, 0), new Color(240, 192, 0), new Color(240, 176, 0), new Color(240, 160, 0), new Color(240, 144, 0), new Color(240, 128, 0), new Color(240, 112, 0), new Color(240, 96, 0), new Color(240, 80, 0), new Color(240, 64, 0), new Color(240, 48, 0), new Color(240, 32, 0), new Color(240, 16, 0), new Color(240, 0, 0)};
    }

    private static final class Label
    extends JLabel {
        private static final Font s_plainFont;
        private static final Font s_boldFont;
        private final String m_suffix;
        private final String m_unit;
        private final String m_units;

        public Label(String unit, String units, String suffix) {
            this.m_suffix = " " + suffix;
            this.m_unit = " " + unit;
            this.m_units = " " + units;
            this.setFont(s_plainFont);
            this.set(0L);
        }

        public void set(long value) {
            super.setText(Long.toString(value) + (value == 1L ? this.m_unit : this.m_units) + this.m_suffix);
        }

        public void set(double value, NumberFormat numberFormat) {
            super.setText(numberFormat.format(value) + this.m_units + this.m_suffix);
        }

        public void set(String value) {
            super.setText(value + this.m_units + this.m_suffix);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 120;
            d.height -= 3;
            return d;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void setHighlight(boolean highlight) {
            if (highlight) {
                this.setForeground(Colours.RED);
                this.setFont(s_boldFont);
            } else {
                this.setForeground(UIManager.getColor("Label.foreground"));
                this.setFont(s_plainFont);
            }
        }

        static {
            JLabel label = new JLabel();
            Font defaultFont = label.getFont();
            float size = defaultFont.getSize2D() - 1.0f;
            s_plainFont = defaultFont.deriveFont(0, size);
            s_boldFont = defaultFont.deriveFont(1, size);
        }
    }
}

