/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.grinder.common.GrinderProperties;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.util.Directory;

public final class ConsoleProperties {
    public static final String COLLECT_SAMPLES_PROPERTY = "grinder.console.numberToCollect";
    public static final String IGNORE_SAMPLES_PROPERTY = "grinder.console.numberToIgnore";
    public static final String SAMPLE_INTERVAL_PROPERTY = "grinder.console.sampleInterval";
    public static final String SIG_FIG_PROPERTY = "grinder.console.significantFigures";
    public static final String CONSOLE_HOST_PROPERTY = "grinder.console.consoleHost";
    public static final String CONSOLE_PORT_PROPERTY = "grinder.console.consolePort";
    public static final String RESET_CONSOLE_WITH_PROCESSES_PROPERTY = "grinder.console.resetConsoleWithProcesses";
    public static final String RESET_CONSOLE_WITH_PROCESSES_ASK_PROPERTY = "grinder.console.resetConsoleWithProcessesAsk";
    public static final String PROPERTIES_NOT_SET_ASK_PROPERTY = "grinder.console.propertiesNotSetAsk";
    public static final String START_WITH_UNSAVED_BUFFERS_ASK_PROPERTY = "grinder.console.startWithUnsavedBuffersAsk";
    public static final String STOP_PROCESSES_ASK_PROPERTY = "grinder.console.stopProcessesAsk";
    public static final String DISTRIBUTE_ON_START_ASK_PROPERTY = "grinder.console.distributeAutomaticallyAsk";
    public static final String PROPERTIES_FILE_PROPERTY = "grinder.console.propertiesFile";
    public static final String DISTRIBUTION_DIRECTORY_PROPERTY = "grinder.console.scriptDistributionDirectory";
    public static final String DISTRIBUTION_FILE_FILTER_EXPRESSION_PROPERTY = "grinder.console.distributionFileFilterExpression";
    public static final String SCAN_DISTRIBUTION_FILES_PERIOD_PROPERTY = "grinder.console.scanDistributionFilesPeriod";
    public static final String LOOK_AND_FEEL_PROPERTY = "grinder.console.lookAndFeel";
    public static final String EXTERNAL_EDITOR_COMMAND_PROPERTY = "grinder.console.externalEditorCommand";
    public static final String EXTERNAL_EDITOR_ARGUMENTS_PROPERTY = "grinder.console.externalEditorArguments";
    public static final String FRAME_BOUNDS_PROPERTY = "grinder.console.frameBounds";
    private final PropertyChangeSupport m_changeSupport = new PropertyChangeSupport(this);
    private final List m_propertyList = new ArrayList();
    private final IntProperty m_collectSampleCount = new IntProperty("grinder.console.numberToCollect", 0);
    private final IntProperty m_ignoreSampleCount = new IntProperty("grinder.console.numberToIgnore", 0);
    private final IntProperty m_sampleInterval = new IntProperty("grinder.console.sampleInterval", 1000);
    private final IntProperty m_significantFigures = new IntProperty("grinder.console.significantFigures", 3);
    private final BooleanProperty m_resetConsoleWithProcesses = new BooleanProperty("grinder.console.resetConsoleWithProcesses", false);
    private final FileProperty m_propertiesFile = new FileProperty("grinder.console.propertiesFile");
    private final DirectoryProperty m_distributionDirectory = new DirectoryProperty("grinder.console.scriptDistributionDirectory");
    private final PatternProperty m_distributionFileFilterPattern = new PatternProperty("grinder.console.distributionFileFilterExpression", "^CVS/$|^\\.svn/$|^.*~$|^(out_|error_|data_)\\w+-\\d+\\.log\\d*$");
    private final IntProperty m_scanDistributionFilesPeriod = new IntProperty("grinder.console.scanDistributionFilesPeriod", 6000);
    private final StringProperty m_lookAndFeel = new StringProperty("grinder.console.lookAndFeel", null);
    private final FileProperty m_externalEditorCommand = new FileProperty("grinder.console.externalEditorCommand");
    private final StringProperty m_externalEditorArguments = new StringProperty("grinder.console.externalEditorArguments", null);
    private final RectangleProperty m_frameBounds = new RectangleProperty("grinder.console.frameBounds");
    private final BooleanProperty m_resetConsoleWithProcessesAsk = new BooleanProperty("grinder.console.resetConsoleWithProcessesAsk", true);
    private final BooleanProperty m_propertiesNotSetAsk = new BooleanProperty("grinder.console.propertiesNotSetAsk", true);
    private final BooleanProperty m_startWithUnsavedBuffersAsk = new BooleanProperty("grinder.console.startWithUnsavedBuffersAsk", true);
    private final BooleanProperty m_stopProcessesAsk = new BooleanProperty("grinder.console.stopProcessesAsk", true);
    private final BooleanProperty m_distributeOnStartAsk = new BooleanProperty("grinder.console.distributeAutomaticallyAsk", true);
    private final StringProperty m_consoleHost = new StringProperty("grinder.console.consoleHost", "");
    private final IntProperty m_consolePort = new IntProperty("grinder.console.consolePort", 6372);
    private final Resources m_resources;
    private final GrinderProperties m_properties;

    public ConsoleProperties(Resources resources, File file) throws ConsoleException {
        this.m_resources = resources;
        try {
            this.m_properties = new GrinderProperties(file);
        }
        catch (GrinderProperties.PersistenceException e) {
            throw new DisplayMessageConsoleException(this.m_resources, "couldNotLoadOptionsError.text", e);
        }
        Iterator propertyIterator = this.m_propertyList.iterator();
        while (propertyIterator.hasNext()) {
            ((Property)propertyIterator.next()).setFromProperties();
        }
    }

    public ConsoleProperties(ConsoleProperties properties) {
        this.m_resources = properties.m_resources;
        this.m_properties = properties.m_properties;
        this.set(properties);
    }

    public void set(ConsoleProperties properties) {
        this.m_collectSampleCount.set(properties.getCollectSampleCount());
        this.m_ignoreSampleCount.set(properties.getIgnoreSampleCount());
        this.m_sampleInterval.set(properties.getSampleInterval());
        this.m_significantFigures.set(properties.getSignificantFigures());
        this.m_consoleHost.set(properties.getConsoleHost());
        this.m_consolePort.set(properties.getConsolePort());
        this.m_resetConsoleWithProcesses.set(properties.getResetConsoleWithProcesses());
        this.m_propertiesFile.set(properties.getPropertiesFile());
        this.m_distributionDirectory.set(properties.getDistributionDirectory());
        this.m_distributionFileFilterPattern.set(properties.getDistributionFileFilterPattern());
        this.m_scanDistributionFilesPeriod.set(properties.getScanDistributionFilesPeriod());
        this.m_lookAndFeel.set(properties.getLookAndFeel());
        this.m_externalEditorCommand.set(properties.getExternalEditorCommand());
        this.m_externalEditorArguments.set(properties.getExternalEditorArguments());
        this.m_frameBounds.set(properties.getFrameBounds());
        this.m_resetConsoleWithProcessesAsk.set(properties.getResetConsoleWithProcessesAsk());
        this.m_propertiesNotSetAsk.set(properties.getPropertiesNotSetAsk());
        this.m_startWithUnsavedBuffersAsk.set(properties.getStartWithUnsavedBuffersAsk());
        this.m_stopProcessesAsk.set(properties.getStopProcessesAsk());
        this.m_distributeOnStartAsk.set(properties.getDistributeOnStartAsk());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_changeSupport.addPropertyChangeListener(property, listener);
    }

    public void save() throws ConsoleException {
        Iterator propertyIterator = this.m_propertyList.iterator();
        while (propertyIterator.hasNext()) {
            ((Property)propertyIterator.next()).setToProperties();
        }
        try {
            this.m_properties.save();
        }
        catch (GrinderProperties.PersistenceException e) {
            throw new DisplayMessageConsoleException(this.m_resources, "couldNotSaveOptionsError.text", e);
        }
    }

    public int getCollectSampleCount() {
        return this.m_collectSampleCount.get();
    }

    public void setCollectSampleCount(int n) throws ConsoleException {
        if (n < 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "collectNegativeError.text");
        }
        this.m_collectSampleCount.set(n);
    }

    public int getIgnoreSampleCount() {
        return this.m_ignoreSampleCount.get();
    }

    public void setIgnoreSampleCount(int n) throws ConsoleException {
        if (n < 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "ignoreSamplesNegativeError.text");
        }
        this.m_ignoreSampleCount.set(n);
    }

    public int getSampleInterval() {
        return this.m_sampleInterval.get();
    }

    public void setSampleInterval(int interval) throws ConsoleException {
        if (interval <= 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "intervalLessThanOneError.text");
        }
        this.m_sampleInterval.set(interval);
    }

    public int getSignificantFigures() {
        return this.m_significantFigures.get();
    }

    public void setSignificantFigures(int n) throws ConsoleException {
        if (n <= 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "significantFiguresNegativeError.text");
        }
        this.m_significantFigures.set(n);
    }

    public String getConsoleHost() {
        return this.m_consoleHost.get();
    }

    public void setConsoleHost(String s) throws ConsoleException {
        if (s.length() > 0) {
            InetAddress newAddress;
            try {
                newAddress = InetAddress.getByName(s);
            }
            catch (UnknownHostException e) {
                throw new DisplayMessageConsoleException(this.m_resources, "unknownHostError.text");
            }
            if (newAddress.isMulticastAddress()) {
                throw new DisplayMessageConsoleException(this.m_resources, "invalidConsoleHostError.text");
            }
        }
        this.m_consoleHost.set(s);
    }

    public int getConsolePort() {
        return this.m_consolePort.get();
    }

    public void setConsolePort(int i) throws ConsoleException {
        if (i < 1 || i > 65535) {
            throw new DisplayMessageConsoleException(this.m_resources, "invalidPortNumberError.text", new Object[]{new Integer(1), new Integer(65535)});
        }
        this.m_consolePort.set(i);
    }

    public boolean getResetConsoleWithProcesses() {
        return this.m_resetConsoleWithProcesses.get();
    }

    public void setResetConsoleWithProcesses(boolean b) {
        this.m_resetConsoleWithProcesses.set(b);
    }

    public boolean getResetConsoleWithProcessesAsk() {
        return this.m_resetConsoleWithProcessesAsk.get();
    }

    public void setResetConsoleWithProcessesAsk(boolean value) throws ConsoleException {
        this.m_resetConsoleWithProcessesAsk.set(value);
        this.m_resetConsoleWithProcessesAsk.save();
    }

    public boolean getPropertiesNotSetAsk() {
        return this.m_propertiesNotSetAsk.get();
    }

    public void setPropertiesNotSetAsk(boolean value) throws ConsoleException {
        this.m_propertiesNotSetAsk.set(value);
        this.m_propertiesNotSetAsk.save();
    }

    public boolean getStartWithUnsavedBuffersAsk() {
        return this.m_startWithUnsavedBuffersAsk.get();
    }

    public void setStartWithUnsavedBuffersAsk(boolean value) throws ConsoleException {
        this.m_startWithUnsavedBuffersAsk.set(value);
        this.m_startWithUnsavedBuffersAsk.save();
    }

    public boolean getStopProcessesAsk() {
        return this.m_stopProcessesAsk.get();
    }

    public void setStopProcessesAsk(boolean value) throws ConsoleException {
        this.m_stopProcessesAsk.set(value);
        this.m_stopProcessesAsk.save();
    }

    public boolean getDistributeOnStartAsk() {
        return this.m_distributeOnStartAsk.get();
    }

    public void setDistributeOnStartAsk(boolean value) throws ConsoleException {
        this.m_distributeOnStartAsk.set(value);
        this.m_distributeOnStartAsk.save();
    }

    public File getPropertiesFile() {
        return this.m_propertiesFile.get();
    }

    public void setAndSavePropertiesFile(File propertiesFile) throws ConsoleException {
        this.m_propertiesFile.set(propertiesFile);
        this.m_propertiesFile.save();
    }

    public Directory getDistributionDirectory() {
        return this.m_distributionDirectory.get();
    }

    public void setAndSaveDistributionDirectory(Directory distributionDirectory) throws ConsoleException {
        this.m_distributionDirectory.set(distributionDirectory);
        this.m_distributionDirectory.save();
    }

    public Pattern getDistributionFileFilterPattern() {
        return this.m_distributionFileFilterPattern.get();
    }

    public void setDistributionFileFilterExpression(String expression) throws ConsoleException {
        this.m_distributionFileFilterPattern.set(expression);
    }

    public int getScanDistributionFilesPeriod() {
        return this.m_scanDistributionFilesPeriod.get();
    }

    public void setScanDistributionFilesPeriod(int i) throws ConsoleException {
        if (i < 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "scanDistributionFilesPeriodNegativeError.text");
        }
        this.m_scanDistributionFilesPeriod.set(i);
    }

    public String getLookAndFeel() {
        return this.m_lookAndFeel.get();
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.m_lookAndFeel.set(lookAndFeel);
    }

    public File getExternalEditorCommand() {
        return this.m_externalEditorCommand.get();
    }

    public void setExternalEditorCommand(File command) {
        this.m_externalEditorCommand.set(command);
    }

    public String getExternalEditorArguments() {
        return this.m_externalEditorArguments.get();
    }

    public void setExternalEditorArguments(String arguments) {
        this.m_externalEditorArguments.set(arguments);
    }

    public Rectangle getFrameBounds() {
        return this.m_frameBounds.get();
    }

    public void setAndSaveFrameBounds(Rectangle bounds) throws ConsoleException {
        this.m_frameBounds.set(bounds);
        this.m_frameBounds.save();
    }

    private final class RectangleProperty
    extends Property {
        public RectangleProperty(String propertyName) {
            super(propertyName, null);
        }

        public void setFromProperties() {
            String property = ConsoleProperties.this.m_properties.getProperty(this.getPropertyName(), null);
            if (property == null) {
                this.set(null);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(property, ",");
                try {
                    this.set(new Rectangle(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken())));
                }
                catch (NoSuchElementException e) {
                    this.set(null);
                }
                catch (NumberFormatException e) {
                    this.set(null);
                }
            }
        }

        public void setToProperties() {
            Rectangle value = this.get();
            if (value != this.getDefaultValue()) {
                ConsoleProperties.this.m_properties.setProperty(this.getPropertyName(), value.x + "," + value.y + "," + value.width + "," + value.height);
            } else {
                ConsoleProperties.this.m_properties.remove(this.getPropertyName());
            }
        }

        public Rectangle get() {
            return (Rectangle)this.getValue();
        }

        public void set(Rectangle rectangle) {
            this.setValue(rectangle);
        }
    }

    private final class BooleanProperty
    extends Property {
        public BooleanProperty(String propertyName, boolean defaultValue) {
            super(propertyName, defaultValue);
        }

        public void setFromProperties() {
            this.set(ConsoleProperties.this.m_properties.getBoolean(this.getPropertyName(), (Boolean)this.getDefaultValue()));
        }

        public void setToProperties() {
            ConsoleProperties.this.m_properties.setBoolean(this.getPropertyName(), this.get());
        }

        public boolean get() {
            return (Boolean)this.getValue();
        }

        public void set(boolean b) {
            this.setValue(b);
        }
    }

    private final class DirectoryProperty
    extends Property {
        public DirectoryProperty(String propertyName) {
            super(propertyName, new Directory());
        }

        public void setFromProperties() {
            this.set(ConsoleProperties.this.m_properties.getFile(this.getPropertyName(), null));
        }

        public void setToProperties() {
            ConsoleProperties.this.m_properties.setFile(this.getPropertyName(), this.get().getFile());
        }

        public Directory get() {
            return (Directory)this.getValue();
        }

        public void set(File file) {
            if (file == null) {
                this.set(new Directory());
            } else {
                try {
                    this.set(new Directory(file));
                }
                catch (Directory.DirectoryException e) {
                    this.set(new Directory());
                }
            }
        }

        public void set(Directory file) {
            this.setValue(file);
        }
    }

    private final class FileProperty
    extends Property {
        public FileProperty(String propertyName) {
            super(propertyName, null);
        }

        public void setFromProperties() {
            this.set(ConsoleProperties.this.m_properties.getFile(this.getPropertyName(), null));
        }

        public void setToProperties() {
            if (this.get() != this.getDefaultValue()) {
                ConsoleProperties.this.m_properties.setFile(this.getPropertyName(), this.get());
            } else {
                ConsoleProperties.this.m_properties.remove(this.getPropertyName());
            }
        }

        public File get() {
            return (File)this.getValue();
        }

        public void set(File file) {
            this.setValue(file);
        }
    }

    private final class IntProperty
    extends Property {
        public IntProperty(String propertyName, int defaultValue) {
            super(propertyName, new Integer(defaultValue));
        }

        public void setFromProperties() {
            this.set(ConsoleProperties.this.m_properties.getInt(this.getPropertyName(), (Integer)this.getDefaultValue()));
        }

        public void setToProperties() {
            ConsoleProperties.this.m_properties.setInt(this.getPropertyName(), this.get());
        }

        public int get() {
            return (Integer)this.getValue();
        }

        public void set(int i) {
            this.setValue(new Integer(i));
        }
    }

    private final class PatternProperty
    extends Property {
        public PatternProperty(String propertyName, String defaultExpression) {
            super(propertyName, Pattern.compile(defaultExpression));
        }

        public void setFromProperties() throws ConsoleException {
            this.set(ConsoleProperties.this.m_properties.getProperty(this.getPropertyName(), null));
        }

        public void setToProperties() {
            if (this.get() != this.getDefaultValue()) {
                ConsoleProperties.this.m_properties.setProperty(this.getPropertyName(), this.get().pattern());
            } else {
                ConsoleProperties.this.m_properties.remove(this.getPropertyName());
            }
        }

        public Pattern get() {
            return (Pattern)this.getValue();
        }

        public void set(String expression) throws ConsoleException {
            if (expression == null) {
                this.set((Pattern)this.getDefaultValue());
            } else {
                try {
                    this.set(Pattern.compile(expression));
                }
                catch (PatternSyntaxException e) {
                    throw new DisplayMessageConsoleException(ConsoleProperties.this.m_resources, "regularExpressionError.text", new Object[]{this.getPropertyName()}, e);
                }
            }
        }

        public void set(Pattern pattern) {
            this.setValue(pattern);
        }
    }

    private final class StringProperty
    extends Property {
        public StringProperty(String propertyName, String defaultValue) {
            super(propertyName, defaultValue);
        }

        public void setFromProperties() {
            this.set(ConsoleProperties.this.m_properties.getProperty(this.getPropertyName(), (String)this.getDefaultValue()));
        }

        public void setToProperties() {
            if (this.get() != this.getDefaultValue()) {
                ConsoleProperties.this.m_properties.setProperty(this.getPropertyName(), this.get());
            } else {
                ConsoleProperties.this.m_properties.remove(this.getPropertyName());
            }
        }

        public String get() {
            return (String)this.getValue();
        }

        public void set(String s) {
            this.setValue(s);
        }
    }

    private abstract class Property {
        private final String m_propertyName;
        private final Object m_defaultValue;
        private Object m_value;

        Property(String propertyName, Object defaultValue) {
            this.m_propertyName = propertyName;
            this.m_defaultValue = defaultValue;
            this.m_value = defaultValue;
            ConsoleProperties.this.m_propertyList.add(this);
        }

        abstract void setFromProperties() throws ConsoleException;

        abstract void setToProperties();

        public final void save() throws ConsoleException {
            this.setToProperties();
            try {
                ConsoleProperties.this.m_properties.saveSingleProperty(this.m_propertyName);
            }
            catch (GrinderProperties.PersistenceException e) {
                throw new DisplayMessageConsoleException(ConsoleProperties.this.m_resources, "couldNotSaveOptionsError.text", e);
            }
        }

        protected final String getPropertyName() {
            return this.m_propertyName;
        }

        protected final Object getDefaultValue() {
            return this.m_defaultValue;
        }

        protected final Object getValue() {
            return this.m_value;
        }

        protected final void setValue(Object value) {
            Object old = this.m_value;
            this.m_value = value;
            ConsoleProperties.this.m_changeSupport.firePropertyChange(this.getPropertyName(), old, this.m_value);
        }
    }
}

