/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CommunicationException;

public final class ConnectionType {
    public static final ConnectionType AGENT = new ConnectionType(0, "AGENT connection type");
    public static final ConnectionType WORKER = new ConnectionType(1, "WORKER connection type");
    public static final ConnectionType CONSOLE_CLIENT = new ConnectionType(2, "CONSOLE_CLIENT connection type");
    private final int m_identity;
    private final String m_description;

    /*
     * WARNING - void declaration
     */
    static ConnectionType read(InputStream in) throws CommunicationException {
        void var1_1;
        int i;
        try {
            i = in.read();
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Failed to read connection type", e);
        }
        switch (i) {
            case 0: {
                return AGENT;
            }
            case 1: {
                return WORKER;
            }
            case 2: {
                return CONSOLE_CLIENT;
            }
        }
        throw new CommunicationException("Unknown connection type (" + (int)var1_1 + ")");
    }

    private ConnectionType(int identity, String description) {
        this.m_identity = identity;
        this.m_description = description;
    }

    void write(OutputStream out) throws CommunicationException {
        try {
            out.write(this.m_identity);
            out.flush();
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Write failed", e);
        }
    }

    public int hashCode() {
        return this.m_identity;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != ConnectionType.class) {
            return false;
        }
        ConnectionType otherConnectionType = (ConnectionType)other;
        return this.m_identity == otherConnectionType.m_identity;
    }

    public String toString() {
        return this.m_description;
    }
}

