/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CloseCommunicationMessage;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.Sender;

abstract class AbstractSender
implements Sender {
    private volatile boolean m_shutdown = false;

    AbstractSender() {
    }

    public final void send(Message message) throws CommunicationException {
        if (this.m_shutdown) {
            throw new CommunicationException("Shut down");
        }
        try {
            this.writeMessage(message);
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Exception whilst sending message", e);
        }
    }

    protected abstract void writeMessage(Message var1) throws CommunicationException, IOException;

    protected static final void writeMessageToStream(Message message, OutputStream stream) throws IOException {
        ObjectOutputStream objectStream = new ObjectOutputStream(stream);
        objectStream.writeObject(message);
        objectStream.flush();
    }

    public void shutdown() {
        try {
            this.send(new CloseCommunicationMessage());
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
        this.m_shutdown = true;
    }

    public boolean isShutdown() {
        return this.m_shutdown;
    }
}

