/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Joiner;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.ImmutableEntry;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.ImmutableMapEntrySet;
import org.python.google.common.collect.ImmutableMapKeySet;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.RegularImmutableAsList;
import org.python.google.common.collect.UnmodifiableIterator;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient LinkedEntry<K, V>[] entries;
    private final transient LinkedEntry<K, V>[] table;
    private final transient int mask;
    private final transient int keySetHashCode;

    RegularImmutableMap(Map.Entry<?, ?> ... immutableEntries) {
        int tableSize;
        int size;
        int n = size = immutableEntries.length;
        this.entries = new LinkedEntry[n];
        int n2 = size;
        int n3 = Integer.highestOneBit(n2);
        if ((double)n2 / (double)n3 > 1.2) {
            CharMatcher.LookupTable.checkArgument((n3 <<= 1) > 0, "table too large: %s", n2);
        }
        n = tableSize = n3;
        this.table = new LinkedEntry[n];
        this.mask = tableSize - 1;
        int keySetHashCodeMutable = 0;
        for (int entryIndex = 0; entryIndex < size; ++entryIndex) {
            LinkedEntry<K, V> existing;
            Map.Entry<?, ?> entry = immutableEntries[entryIndex];
            Object key = entry.getKey();
            int keyHashCode = key.hashCode();
            keySetHashCodeMutable += keyHashCode;
            int tableIndex = Collections2.1.smear(keyHashCode) & this.mask;
            LinkedEntry<K, V> linkedEntry = existing = this.table[tableIndex];
            Object obj = entry.getValue();
            Object obj2 = key;
            ImmutableEntry linkedEntry2 = linkedEntry == null ? new TerminalEntry(obj2, obj) : new NonTerminalEntry(obj2, obj, linkedEntry);
            this.table[tableIndex] = linkedEntry2;
            this.entries[entryIndex] = linkedEntry2;
            while (existing != null) {
                CharMatcher.LookupTable.checkArgument(!key.equals(existing.getKey()), "duplicate key: %s", key);
                existing = existing.next();
            }
        }
        this.keySetHashCode = keySetHashCodeMutable;
    }

    @Override
    public final V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int index = Collections2.1.smear(key.hashCode()) & this.mask;
        for (LinkedEntry<K, V> entry = this.table[index]; entry != null; entry = entry.next()) {
            Object candidateKey = entry.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public final int size() {
        return this.entries.length;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        LinkedEntry<K, V>[] arr$ = this.entries;
        int len$ = this.entries.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LinkedEntry<K, V> entry = arr$[i$];
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, 0);
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet<K, V>(this, (ImmutableSet)this.entrySet(), this.keySetHashCode){
            private /* synthetic */ RegularImmutableMap this$0;
            {
                this.this$0 = regularImmutableMap;
                super(x0, x1);
            }

            @Override
            final ImmutableMap<K, V> map() {
                return this.this$0;
            }
        };
    }

    @Override
    public final String toString() {
        StringBuilder result = Collections2.newStringBuilderForCollection(this.size()).append('{');
        LinkedEntry<K, V>[] linkedEntryArray = this.entries;
        StringBuilder stringBuilder = result;
        Joiner joiner = Collections2.STANDARD_JOINER;
        joiner.appendTo(stringBuilder, Arrays.asList(linkedEntryArray));
        return result.append('}').toString();
    }

    final class EntrySet
    extends ImmutableMapEntrySet<K, V> {
        private /* synthetic */ RegularImmutableMap this$0;

        private EntrySet(RegularImmutableMap regularImmutableMap) {
            this.this$0 = regularImmutableMap;
        }

        @Override
        final ImmutableMap<K, V> map() {
            return this.this$0;
        }

        @Override
        public final UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        final ImmutableList<Map.Entry<K, V>> createAsList() {
            return new RegularImmutableAsList(this, this.this$0.entries);
        }

        /* synthetic */ EntrySet(RegularImmutableMap x0, byte by) {
            this(x0);
        }
    }

    @Immutable
    static final class TerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        TerminalEntry(K key, V value) {
            super(key, value);
        }

        @Override
        @Nullable
        public final LinkedEntry<K, V> next() {
            return null;
        }
    }

    @Immutable
    static final class NonTerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        private LinkedEntry<K, V> next;

        NonTerminalEntry(K key, V value, LinkedEntry<K, V> next) {
            super(key, value);
            this.next = next;
        }

        @Override
        public final LinkedEntry<K, V> next() {
            return this.next;
        }
    }

    static interface LinkedEntry<K, V>
    extends Map.Entry<K, V> {
        @Nullable
        public LinkedEntry<K, V> next();
    }
}

