/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.dom.DOMNodePool;
import org.apache.xerces.impl.xs.dom.DOMParser;
import org.apache.xerces.impl.xs.dom.ElementNSImpl;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAttributeGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAttributeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDComplexTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDElementTraverser;
import org.apache.xerces.impl.xs.traversers.XSDGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDKeyrefTraverser;
import org.apache.xerces.impl.xs.traversers.XSDNotationTraverser;
import org.apache.xerces.impl.xs.traversers.XSDSimpleTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDUniqueOrKeyTraverser;
import org.apache.xerces.impl.xs.traversers.XSDWildcardTraverser;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDHandler {
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final boolean DEBUG_NODE_POOL = false;
    static final int ATTRIBUTE_TYPE = 1;
    static final int ATTRIBUTEGROUP_TYPE = 2;
    static final int ELEMENT_TYPE = 3;
    static final int GROUP_TYPE = 4;
    static final int IDENTITYCONSTRAINT_TYPE = 5;
    static final int NOTATION_TYPE = 6;
    static final int TYPEDECL_TYPE = 7;
    public static final String REDEF_IDENTIFIER = "_fn3dktizrknc9pi";
    public String EMPTY_STRING;
    protected Hashtable fNotationRegistry = new Hashtable();
    protected XSDeclarationPool fDeclPool = null;
    private Hashtable fUnparsedAttributeRegistry = new Hashtable();
    private Hashtable fUnparsedAttributeGroupRegistry = new Hashtable();
    private Hashtable fUnparsedElementRegistry = new Hashtable();
    private Hashtable fUnparsedGroupRegistry = new Hashtable();
    private Hashtable fUnparsedIdentityConstraintRegistry = new Hashtable();
    private Hashtable fUnparsedNotationRegistry = new Hashtable();
    private Hashtable fUnparsedTypeRegistry = new Hashtable();
    private Hashtable fXSDocumentInfoRegistry = new Hashtable();
    private Hashtable fDependencyMap = new Hashtable();
    private Hashtable fImportMap = new Hashtable();
    private Vector fAllTNSs = new Vector();
    private Hashtable fLocationPairs = null;
    private Hashtable fTraversed = new Hashtable();
    private Hashtable fDoc2SystemId = new Hashtable();
    private XSDocumentInfo fRoot = null;
    private Hashtable fDoc2XSDocumentMap = new Hashtable();
    private Hashtable fRedefine2XSDMap = new Hashtable();
    private Hashtable fRedefine2NSSupport = new Hashtable();
    private Hashtable fRedefinedRestrictedAttributeGroupRegistry = new Hashtable();
    private Hashtable fRedefinedRestrictedGroupRegistry = new Hashtable();
    private boolean fLastSchemaWasDuplicate;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityResolver fEntityResolver;
    private XSAttributeChecker fAttributeChecker;
    private SymbolTable fSymbolTable;
    private XSGrammarBucket fGrammarBucket;
    private XSDDescription fSchemaGrammarDescription;
    private XMLGrammarPool fGrammarPool;
    XSDAttributeGroupTraverser fAttributeGroupTraverser;
    XSDAttributeTraverser fAttributeTraverser;
    XSDComplexTypeTraverser fComplexTypeTraverser;
    XSDElementTraverser fElementTraverser;
    XSDGroupTraverser fGroupTraverser;
    XSDKeyrefTraverser fKeyrefTraverser;
    XSDNotationTraverser fNotationTraverser;
    XSDSimpleTypeTraverser fSimpleTypeTraverser;
    XSDUniqueOrKeyTraverser fUniqueOrKeyTraverser;
    XSDWildcardTraverser fWildCardTraverser;
    DOMParser fSchemaParser;
    final DOMNodePool fDOMPool = new DOMNodePool();
    private static final int INIT_STACK_SIZE = 30;
    private static final int INC_STACK_SIZE = 10;
    private int fLocalElemStackPos = 0;
    private XSParticleDecl[] fParticle = new XSParticleDecl[30];
    private Element[] fLocalElementDecl = new Element[30];
    private int[] fAllContext = new int[30];
    private XSComplexTypeDecl[] fEnclosingCT = new XSComplexTypeDecl[30];
    private String[][] fLocalElemNamespaceContext = new String[30][1];
    private static final int INIT_KEYREF_STACK = 2;
    private static final int INC_KEYREF_STACK_AMOUNT = 2;
    private int fKeyrefStackPos = 0;
    private Element[] fKeyrefs = new Element[2];
    private XSElementDecl[] fKeyrefElems = new XSElementDecl[2];
    private String[][] fKeyrefNamespaceContext = new String[2][1];
    private static final String[][] NS_ERROR_CODES = new String[][]{{"src-include.2.1", "src-include.2.1"}, {"src-redefine.3.1", "src-redefine.3.1"}, {"src-import.3.1", "src-import.3.2"}, null, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}};
    private static final String[] ELE_ERROR_CODES = new String[]{"src-include.1", "src-redefine.2", "src-import.2", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4"};
    private Vector fReportedTNS = null;
    private static final String[] COMP_TYPE = new String[]{null, "attribute declaration", "attribute group", "elment declaration", "group", "identity constraint", "notation", "type definition"};
    private static final String[] DOC_ERROR_CODES = new String[]{"src-include.0", "src-redefine.0", "src-import.0", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4"};
    private SimpleLocator xl = new SimpleLocator();

    private String null2EmptyString(String string) {
        return string == null ? this.EMPTY_STRING : string;
    }

    private String emptyString2Null(String string) {
        return string == this.EMPTY_STRING ? null : string;
    }

    public XSDHandler(XSGrammarBucket xSGrammarBucket) {
        this.fGrammarBucket = xSGrammarBucket;
        this.fSchemaGrammarDescription = new XSDDescription();
    }

    public SchemaGrammar parseSchema(XMLInputSource xMLInputSource, XSDDescription xSDDescription, Hashtable hashtable) {
        Object object;
        String string;
        Element element;
        this.fLocationPairs = hashtable;
        SchemaGrammar schemaGrammar = this.findGrammar(xSDDescription);
        if (schemaGrammar != null) {
            return schemaGrammar;
        }
        this.fDOMPool.reset();
        if (this.fSchemaParser != null) {
            this.fSchemaParser.setPool(this.fDOMPool);
        }
        short s = xSDDescription.getContextType();
        String string2 = xSDDescription.getTargetNamespace();
        if (string2 != null) {
            string2 = this.fSymbolTable.addSymbol(string2);
        }
        this.prepareForParse();
        Document document = this.getSchema(string2, xMLInputSource, s == 3, s, null);
        if (document == null) {
            return null;
        }
        if (string2 == null && s == 3 && (string2 = DOMUtil.getAttrValue(element = DOMUtil.getRoot(document), SchemaSymbols.ATT_TARGETNAMESPACE)) != null && string2.length() > 0) {
            this.fSymbolTable.addSymbol(string2);
            xSDDescription.setTargetNamespace(string2);
            string = XMLEntityManager.expandSystemId(xSDDescription.getLiteralSystemId(), xSDDescription.getBaseSystemId());
            object = new XSDKey(string, s, string2);
            this.fTraversed.put(object, document);
            if (string != null) {
                this.fDoc2SystemId.put(document, string);
            }
        }
        this.prepareForTraverse();
        this.fRoot = this.constructTrees(document, xMLInputSource.getSystemId(), xSDDescription);
        if (this.fRoot == null) {
            return null;
        }
        this.buildGlobalNameRegistries();
        this.traverseSchemas();
        this.traverseLocalElements();
        this.resolveKeyRefs();
        int n = this.fAllTNSs.size() - 1;
        while (n >= 0) {
            string = (String)this.fAllTNSs.elementAt(n);
            object = (Vector)this.fImportMap.get(string);
            SchemaGrammar schemaGrammar2 = this.fGrammarBucket.getGrammar(this.emptyString2Null(string));
            if (schemaGrammar2 != null) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    SchemaGrammar schemaGrammar3 = this.fGrammarBucket.getGrammar((String)((Vector)object).elementAt(n3));
                    if (schemaGrammar3 != null) {
                        ((Vector)object).setElementAt(schemaGrammar3, n2++);
                    }
                    ++n3;
                }
                ((Vector)object).setSize(n2);
                schemaGrammar2.setImportedGrammars((Vector)object);
            }
            --n;
        }
        return this.fGrammarBucket.getGrammar(this.fRoot.fTargetNamespace);
    }

    protected SchemaGrammar findGrammar(XSDDescription xSDDescription) {
        SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(xSDDescription.getTargetNamespace());
        if (schemaGrammar == null && this.fGrammarPool != null && (schemaGrammar = (SchemaGrammar)this.fGrammarPool.retrieveGrammar(xSDDescription)) != null && !this.fGrammarBucket.putGrammar(schemaGrammar, true)) {
            this.reportSchemaWarning("GrammarConflict", null, null);
            schemaGrammar = null;
        }
        return schemaGrammar;
    }

    protected XSDocumentInfo constructTrees(Document document, String string, XSDDescription xSDDescription) {
        if (document == null) {
            return null;
        }
        String string2 = xSDDescription.getTargetNamespace();
        short s = xSDDescription.getContextType();
        XSDocumentInfo xSDocumentInfo = null;
        try {
            xSDocumentInfo = new XSDocumentInfo(document, this.fAttributeChecker, this.fSymbolTable);
        }
        catch (XMLSchemaException xMLSchemaException) {
            this.reportSchemaError(ELE_ERROR_CODES[s], new Object[]{string}, DOMUtil.getRoot(document));
            return null;
        }
        if (xSDocumentInfo.fTargetNamespace != null && xSDocumentInfo.fTargetNamespace.length() == 0) {
            this.reportSchemaWarning("EmptyTargetNamespace", new Object[]{string}, DOMUtil.getRoot(document));
            xSDocumentInfo.fTargetNamespace = null;
        }
        if (string2 != null) {
            int n = 0;
            if (s == 0 || s == 1) {
                if (xSDocumentInfo.fTargetNamespace == null) {
                    xSDocumentInfo.fTargetNamespace = string2;
                    xSDocumentInfo.fIsChameleonSchema = true;
                } else if (string2 != xSDocumentInfo.fTargetNamespace) {
                    this.reportSchemaError(NS_ERROR_CODES[s][n], new Object[]{string2, xSDocumentInfo.fTargetNamespace}, DOMUtil.getRoot(document));
                    return null;
                }
            } else if (s != 3 && string2 != xSDocumentInfo.fTargetNamespace) {
                this.reportSchemaError(NS_ERROR_CODES[s][n], new Object[]{string2, xSDocumentInfo.fTargetNamespace}, DOMUtil.getRoot(document));
                return null;
            }
        } else if (xSDocumentInfo.fTargetNamespace != null) {
            if (s == 3) {
                xSDDescription.setTargetNamespace(xSDocumentInfo.fTargetNamespace);
                string2 = xSDocumentInfo.fTargetNamespace;
            } else {
                int n = 1;
                this.reportSchemaError(NS_ERROR_CODES[s][n], new Object[]{string2, xSDocumentInfo.fTargetNamespace}, DOMUtil.getRoot(document));
                return null;
            }
        }
        xSDocumentInfo.addAllowedNS(xSDocumentInfo.fTargetNamespace);
        SchemaGrammar schemaGrammar = null;
        if (s == 0 || s == 1) {
            schemaGrammar = this.fGrammarBucket.getGrammar(xSDocumentInfo.fTargetNamespace);
        } else {
            schemaGrammar = new SchemaGrammar(xSDocumentInfo.fTargetNamespace, xSDDescription.makeClone());
            this.fGrammarBucket.putGrammar(schemaGrammar);
        }
        schemaGrammar.addDocument(null, (String)this.fDoc2SystemId.get(xSDocumentInfo));
        this.fDoc2XSDocumentMap.put(document, xSDocumentInfo);
        Vector<Object[]> vector = new Vector<Object[]>();
        Element element = DOMUtil.getRoot(document);
        Document document2 = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            block29: {
                Object object;
                String string3;
                String string4;
                block31: {
                    short s2;
                    String string5;
                    block30: {
                        string5 = null;
                        string4 = null;
                        string3 = DOMUtil.getLocalName(element2);
                        s2 = -1;
                        if (string3.equals(SchemaSymbols.ELT_ANNOTATION)) break block29;
                        if (!string3.equals(SchemaSymbols.ELT_IMPORT)) break block30;
                        s2 = 2;
                        object = this.fAttributeChecker.checkAttributes(element2, true, xSDocumentInfo);
                        string4 = (String)object[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                        string5 = (String)object[XSAttributeChecker.ATTIDX_NAMESPACE];
                        if (string5 != null) {
                            string5 = this.fSymbolTable.addSymbol(string5);
                        }
                        if (string5 == xSDocumentInfo.fTargetNamespace) {
                            this.reportSchemaError("src-import.1.1", new Object[]{string5}, element2);
                        }
                        this.fAttributeChecker.returnAttrArray((Object[])object, xSDocumentInfo);
                        if (xSDocumentInfo.isAllowedNS(string5)) break block29;
                        xSDocumentInfo.addAllowedNS(string5);
                        String string6 = this.null2EmptyString(xSDocumentInfo.fTargetNamespace);
                        Vector<String> vector2 = (Vector<String>)this.fImportMap.get(string6);
                        if (vector2 == null) {
                            this.fAllTNSs.addElement(string6);
                            vector2 = new Vector<String>();
                            this.fImportMap.put(string6, vector2);
                            vector2.addElement(string5);
                        } else if (!vector2.contains(string5)) {
                            vector2.addElement(string5);
                        }
                        this.fSchemaGrammarDescription.reset();
                        this.fSchemaGrammarDescription.setContextType((short)2);
                        this.fSchemaGrammarDescription.setBaseSystemId((String)this.fDoc2SystemId.get(document));
                        this.fSchemaGrammarDescription.setLocationHints(new String[]{string4});
                        this.fSchemaGrammarDescription.setTargetNamespace(string5);
                        if (this.findGrammar(this.fSchemaGrammarDescription) != null) break block29;
                        document2 = this.getSchema(this.fSchemaGrammarDescription, false, element2);
                        break block31;
                    }
                    if (!string3.equals(SchemaSymbols.ELT_INCLUDE) && !string3.equals(SchemaSymbols.ELT_REDEFINE)) break;
                    object = this.fAttributeChecker.checkAttributes(element2, true, xSDocumentInfo);
                    string4 = (String)object[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                    if (string3.equals(SchemaSymbols.ELT_REDEFINE)) {
                        this.fRedefine2NSSupport.put(element2, new SchemaNamespaceSupport(xSDocumentInfo.fNamespaceSupport));
                    }
                    this.fAttributeChecker.returnAttrArray((Object[])object, xSDocumentInfo);
                    if (string4 == null) {
                        this.reportSchemaError("s4s-att-must-appear", new Object[]{"<include> or <redefine>", "schemaLocation"}, element2);
                    }
                    boolean bl = false;
                    s2 = 0;
                    if (string3.equals(SchemaSymbols.ELT_REDEFINE)) {
                        bl = this.nonAnnotationContent(element2);
                        s2 = 1;
                    }
                    this.fSchemaGrammarDescription.reset();
                    this.fSchemaGrammarDescription.setContextType(s2);
                    this.fSchemaGrammarDescription.setBaseSystemId((String)this.fDoc2SystemId.get(document));
                    this.fSchemaGrammarDescription.setLocationHints(new String[]{string4});
                    this.fSchemaGrammarDescription.setTargetNamespace(string2);
                    document2 = this.getSchema(this.fSchemaGrammarDescription, bl, element2);
                    string5 = xSDocumentInfo.fTargetNamespace;
                }
                object = null;
                object = this.fLastSchemaWasDuplicate ? (XSDocumentInfo)this.fDoc2XSDocumentMap.get(document2) : this.constructTrees(document2, string4, this.fSchemaGrammarDescription);
                if (string3.equals(SchemaSymbols.ELT_REDEFINE) && object != null) {
                    this.fRedefine2XSDMap.put(element2, object);
                }
                if (document2 != null) {
                    if (object != null) {
                        vector.addElement((Object[])object);
                    }
                    document2 = null;
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        this.fDependencyMap.put(xSDocumentInfo, vector);
        return xSDocumentInfo;
    }

    protected void buildGlobalNameRegistries() {
        Stack<XSDocumentInfo> stack = new Stack<XSDocumentInfo>();
        stack.push(this.fRoot);
        while (!stack.empty()) {
            Object object;
            XSDocumentInfo xSDocumentInfo = (XSDocumentInfo)stack.pop();
            Document document = xSDocumentInfo.fSchemaDoc;
            if (DOMUtil.isHidden(document)) continue;
            Element element = DOMUtil.getRoot(document);
            boolean bl = true;
            Element element2 = DOMUtil.getFirstChildElement(element);
            while (element2 != null) {
                if (!DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    String string;
                    String string2;
                    if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_INCLUDE) || DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_IMPORT)) {
                        if (!bl) {
                            this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(element2)}, element2);
                        }
                        DOMUtil.setHidden(element2);
                    } else if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_REDEFINE)) {
                        if (!bl) {
                            this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(element2)}, element2);
                        }
                        object = DOMUtil.getFirstChildElement(element2);
                        while (object != null) {
                            string2 = DOMUtil.getAttrValue((Element)object, SchemaSymbols.ATT_NAME);
                            if (string2.length() != 0) {
                                String string3;
                                string = xSDocumentInfo.fTargetNamespace == null ? "," + string2 : xSDocumentInfo.fTargetNamespace + "," + string2;
                                String string4 = DOMUtil.getLocalName((Node)object);
                                if (string4.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                    this.checkForDuplicateNames(string, this.fUnparsedAttributeGroupRegistry, (Element)object, xSDocumentInfo);
                                    string3 = DOMUtil.getAttrValue((Element)object, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(xSDocumentInfo, (Element)object, SchemaSymbols.ELT_ATTRIBUTEGROUP, string2, string3);
                                } else if (string4.equals(SchemaSymbols.ELT_COMPLEXTYPE) || string4.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                    this.checkForDuplicateNames(string, this.fUnparsedTypeRegistry, (Element)object, xSDocumentInfo);
                                    string3 = DOMUtil.getAttrValue((Element)object, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    if (string4.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                                        this.renameRedefiningComponents(xSDocumentInfo, (Element)object, SchemaSymbols.ELT_COMPLEXTYPE, string2, string3);
                                    } else {
                                        this.renameRedefiningComponents(xSDocumentInfo, (Element)object, SchemaSymbols.ELT_SIMPLETYPE, string2, string3);
                                    }
                                } else if (string4.equals(SchemaSymbols.ELT_GROUP)) {
                                    this.checkForDuplicateNames(string, this.fUnparsedGroupRegistry, (Element)object, xSDocumentInfo);
                                    string3 = DOMUtil.getAttrValue((Element)object, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(xSDocumentInfo, (Element)object, SchemaSymbols.ELT_GROUP, string2, string3);
                                }
                            }
                            object = DOMUtil.getNextSiblingElement((Node)object);
                        }
                    } else {
                        bl = false;
                        object = DOMUtil.getAttrValue(element2, SchemaSymbols.ATT_NAME);
                        if (((String)object).length() != 0) {
                            string2 = xSDocumentInfo.fTargetNamespace == null ? "," + (String)object : xSDocumentInfo.fTargetNamespace + "," + (String)object;
                            string = DOMUtil.getLocalName(element2);
                            if (string.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                                this.checkForDuplicateNames(string2, this.fUnparsedAttributeRegistry, element2, xSDocumentInfo);
                            } else if (string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                this.checkForDuplicateNames(string2, this.fUnparsedAttributeGroupRegistry, element2, xSDocumentInfo);
                            } else if (string.equals(SchemaSymbols.ELT_COMPLEXTYPE) || string.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                this.checkForDuplicateNames(string2, this.fUnparsedTypeRegistry, element2, xSDocumentInfo);
                            } else if (string.equals(SchemaSymbols.ELT_ELEMENT)) {
                                this.checkForDuplicateNames(string2, this.fUnparsedElementRegistry, element2, xSDocumentInfo);
                            } else if (string.equals(SchemaSymbols.ELT_GROUP)) {
                                this.checkForDuplicateNames(string2, this.fUnparsedGroupRegistry, element2, xSDocumentInfo);
                            } else if (string.equals(SchemaSymbols.ELT_NOTATION)) {
                                this.checkForDuplicateNames(string2, this.fUnparsedNotationRegistry, element2, xSDocumentInfo);
                            }
                        }
                    }
                }
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            DOMUtil.setHidden(document);
            object = (Vector)this.fDependencyMap.get(xSDocumentInfo);
            int n = 0;
            while (n < ((Vector)object).size()) {
                stack.push((XSDocumentInfo)((Vector)object).elementAt(n));
                ++n;
            }
        }
    }

    protected void traverseSchemas() {
        this.setSchemasVisible(this.fRoot);
        Stack<XSDocumentInfo> stack = new Stack<XSDocumentInfo>();
        stack.push(this.fRoot);
        while (!stack.empty()) {
            Object object;
            XSDocumentInfo xSDocumentInfo = (XSDocumentInfo)stack.pop();
            Document document = xSDocumentInfo.fSchemaDoc;
            SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(xSDocumentInfo.fTargetNamespace);
            if (DOMUtil.isHidden(document)) continue;
            Element element = DOMUtil.getRoot(document);
            Element element2 = DOMUtil.getFirstVisibleChildElement(element);
            while (element2 != null) {
                DOMUtil.setHidden(element2);
                object = DOMUtil.getLocalName(element2);
                if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_REDEFINE)) {
                    xSDocumentInfo.backupNSSupport((SchemaNamespaceSupport)this.fRedefine2NSSupport.get(element2));
                    Element element3 = DOMUtil.getFirstVisibleChildElement(element2);
                    while (element3 != null) {
                        String string = DOMUtil.getLocalName(element3);
                        DOMUtil.setHidden(element3);
                        if (string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                            this.fAttributeGroupTraverser.traverseGlobal(element3, xSDocumentInfo, schemaGrammar);
                        } else if (string.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                            this.fComplexTypeTraverser.traverseGlobal(element3, xSDocumentInfo, schemaGrammar);
                        } else if (string.equals(SchemaSymbols.ELT_GROUP)) {
                            this.fGroupTraverser.traverseGlobal(element3, xSDocumentInfo, schemaGrammar);
                        } else if (string.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                            this.fSimpleTypeTraverser.traverseGlobal(element3, xSDocumentInfo, schemaGrammar);
                        } else if (string.equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.fElementTraverser.traverseAnnotationDecl(element3, null, true, xSDocumentInfo);
                        } else {
                            this.reportSchemaError("src-redefine", new Object[]{object}, element3);
                        }
                        element3 = DOMUtil.getNextVisibleSiblingElement(element3);
                    }
                    xSDocumentInfo.restoreNSSupport();
                } else if (((String)object).equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                    this.fAttributeTraverser.traverseGlobal(element2, xSDocumentInfo, schemaGrammar);
                } else if (((String)object).equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                    this.fAttributeGroupTraverser.traverseGlobal(element2, xSDocumentInfo, schemaGrammar);
                } else if (((String)object).equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                    this.fComplexTypeTraverser.traverseGlobal(element2, xSDocumentInfo, schemaGrammar);
                } else if (((String)object).equals(SchemaSymbols.ELT_ELEMENT)) {
                    this.fElementTraverser.traverseGlobal(element2, xSDocumentInfo, schemaGrammar);
                } else if (((String)object).equals(SchemaSymbols.ELT_GROUP)) {
                    this.fGroupTraverser.traverseGlobal(element2, xSDocumentInfo, schemaGrammar);
                } else if (((String)object).equals(SchemaSymbols.ELT_NOTATION)) {
                    this.fNotationTraverser.traverse(element2, xSDocumentInfo, schemaGrammar);
                } else if (((String)object).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                    this.fSimpleTypeTraverser.traverseGlobal(element2, xSDocumentInfo, schemaGrammar);
                } else if (((String)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.fElementTraverser.traverseAnnotationDecl(element2, null, true, xSDocumentInfo);
                } else {
                    this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(element2)}, element2);
                }
                element2 = DOMUtil.getNextVisibleSiblingElement(element2);
            }
            DOMUtil.setHidden(document);
            object = (Vector)this.fDependencyMap.get(xSDocumentInfo);
            int n = 0;
            while (n < ((Vector)object).size()) {
                stack.push((XSDocumentInfo)((Vector)object).elementAt(n));
                ++n;
            }
        }
    }

    private final boolean needReportTNSError(String string) {
        if (this.fReportedTNS == null) {
            this.fReportedTNS = new Vector();
        } else if (this.fReportedTNS.contains(string)) {
            return false;
        }
        this.fReportedTNS.addElement(string);
        return true;
    }

    protected Object getGlobalDecl(XSDocumentInfo xSDocumentInfo, int n, QName qName, Element element) {
        Object object;
        if (qName.uri != null && qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && n == 7 && (object = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(qName.localpart)) != null) {
            return object;
        }
        if (!xSDocumentInfo.isAllowedNS(qName.uri)) {
            if (xSDocumentInfo.needReportTNSError(qName.uri)) {
                this.reportSchemaError("src-resolve.4", new Object[]{this.fDoc2SystemId.get(xSDocumentInfo.fSchemaDoc), qName.uri}, element);
            }
            return null;
        }
        object = this.fGrammarBucket.getGrammar(qName.uri);
        if (object == null) {
            if (this.needReportTNSError(qName.uri)) {
                this.reportSchemaError("src-resolve", new Object[]{qName.rawname, COMP_TYPE[n]}, element);
            }
            return null;
        }
        XSObject xSObject = null;
        switch (n) {
            case 1: {
                xSObject = ((SchemaGrammar)object).getGlobalAttributeDecl(qName.localpart);
                break;
            }
            case 2: {
                xSObject = ((SchemaGrammar)object).getGlobalAttributeGroupDecl(qName.localpart);
                break;
            }
            case 3: {
                xSObject = ((SchemaGrammar)object).getGlobalElementDecl(qName.localpart);
                break;
            }
            case 4: {
                xSObject = ((SchemaGrammar)object).getGlobalGroupDecl(qName.localpart);
                break;
            }
            case 5: {
                xSObject = ((SchemaGrammar)object).getIDConstraintDecl(qName.localpart);
                break;
            }
            case 6: {
                xSObject = ((SchemaGrammar)object).getGlobalNotationDecl(qName.localpart);
                break;
            }
            case 7: {
                xSObject = ((SchemaGrammar)object).getGlobalTypeDecl(qName.localpart);
            }
        }
        if (xSObject != null) {
            return xSObject;
        }
        XSDocumentInfo xSDocumentInfo2 = null;
        Element element2 = null;
        String string = qName.uri == null ? "," + qName.localpart : qName.uri + "," + qName.localpart;
        switch (n) {
            case 1: {
                element2 = (Element)this.fUnparsedAttributeRegistry.get(string);
                break;
            }
            case 2: {
                element2 = (Element)this.fUnparsedAttributeGroupRegistry.get(string);
                break;
            }
            case 3: {
                element2 = (Element)this.fUnparsedElementRegistry.get(string);
                break;
            }
            case 4: {
                element2 = (Element)this.fUnparsedGroupRegistry.get(string);
                break;
            }
            case 5: {
                element2 = (Element)this.fUnparsedIdentityConstraintRegistry.get(string);
                break;
            }
            case 6: {
                element2 = (Element)this.fUnparsedNotationRegistry.get(string);
                break;
            }
            case 7: {
                element2 = (Element)this.fUnparsedTypeRegistry.get(string);
                break;
            }
            default: {
                this.reportSchemaError("Internal-Error", new Object[]{"XSDHandler asked to locate component of type " + n + "; it does not recognize this type!"}, element);
            }
        }
        if (element2 == null) {
            this.reportSchemaError("src-resolve", new Object[]{qName.rawname, COMP_TYPE[n]}, element);
            return null;
        }
        xSDocumentInfo2 = this.findXSDocumentForDecl(xSDocumentInfo, element2);
        if (xSDocumentInfo2 == null) {
            this.reportSchemaError("src-resolve.4", new Object[]{this.fDoc2SystemId.get(xSDocumentInfo.fSchemaDoc), qName.uri}, element);
            return null;
        }
        if (DOMUtil.isHidden(element2)) {
            this.reportSchemaError("st-props-correct.2", new Object[]{qName.prefix + ":" + qName.localpart}, element);
            return null;
        }
        DOMUtil.setHidden(element2);
        SchemaNamespaceSupport schemaNamespaceSupport = null;
        Element element3 = DOMUtil.getParent(element2);
        if (DOMUtil.getLocalName(element3).equals(SchemaSymbols.ELT_REDEFINE)) {
            schemaNamespaceSupport = (SchemaNamespaceSupport)this.fRedefine2NSSupport.get(element3);
        }
        xSDocumentInfo2.backupNSSupport(schemaNamespaceSupport);
        switch (n) {
            case 1: {
                xSObject = this.fAttributeTraverser.traverseGlobal(element2, xSDocumentInfo2, (SchemaGrammar)object);
                break;
            }
            case 2: {
                xSObject = this.fAttributeGroupTraverser.traverseGlobal(element2, xSDocumentInfo2, (SchemaGrammar)object);
                break;
            }
            case 3: {
                xSObject = this.fElementTraverser.traverseGlobal(element2, xSDocumentInfo2, (SchemaGrammar)object);
                break;
            }
            case 4: {
                xSObject = this.fGroupTraverser.traverseGlobal(element2, xSDocumentInfo2, (SchemaGrammar)object);
                break;
            }
            case 5: {
                xSObject = null;
                break;
            }
            case 6: {
                xSObject = this.fNotationTraverser.traverse(element2, xSDocumentInfo2, (SchemaGrammar)object);
                break;
            }
            case 7: {
                xSObject = DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_COMPLEXTYPE) ? this.fComplexTypeTraverser.traverseGlobal(element2, xSDocumentInfo2, (SchemaGrammar)object) : this.fSimpleTypeTraverser.traverseGlobal(element2, xSDocumentInfo2, (SchemaGrammar)object);
            }
        }
        xSDocumentInfo2.restoreNSSupport();
        return xSObject;
    }

    Object getGrpOrAttrGrpRedefinedByRestriction(int n, QName qName, XSDocumentInfo xSDocumentInfo, Element element) {
        String string = qName.uri != null ? qName.uri + "," + qName.localpart : "," + qName.localpart;
        String string2 = null;
        switch (n) {
            case 2: {
                string2 = (String)this.fRedefinedRestrictedAttributeGroupRegistry.get(string);
                break;
            }
            case 4: {
                string2 = (String)this.fRedefinedRestrictedGroupRegistry.get(string);
                break;
            }
            default: {
                return null;
            }
        }
        if (string2 == null) {
            return null;
        }
        int n2 = string2.indexOf(",");
        QName qName2 = new QName(this.EMPTY_STRING, string2.substring(n2 + 1), string2.substring(n2), n2 == 0 ? null : string2.substring(0, n2));
        Object object = this.getGlobalDecl(xSDocumentInfo, n, qName2, element);
        if (object == null) {
            switch (n) {
                case 2: {
                    this.reportSchemaError("src-redefine.7.2.1", new Object[]{qName.localpart}, element);
                    break;
                }
                case 4: {
                    this.reportSchemaError("src-redefine.6.2.1", new Object[]{qName.localpart}, element);
                }
            }
            return null;
        }
        return object;
    }

    protected void resolveKeyRefs() {
        int n = 0;
        while (n < this.fKeyrefStackPos) {
            Document document = DOMUtil.getDocument(this.fKeyrefs[n]);
            XSDocumentInfo xSDocumentInfo = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(document);
            xSDocumentInfo.fNamespaceSupport.makeGlobal();
            xSDocumentInfo.fNamespaceSupport.setEffectiveContext(this.fKeyrefNamespaceContext[n]);
            SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(xSDocumentInfo.fTargetNamespace);
            DOMUtil.setHidden(this.fKeyrefs[n]);
            this.fKeyrefTraverser.traverse(this.fKeyrefs[n], this.fKeyrefElems[n], xSDocumentInfo, schemaGrammar);
            ++n;
        }
    }

    protected Hashtable getIDRegistry() {
        return this.fUnparsedIdentityConstraintRegistry;
    }

    protected void storeKeyRef(Element element, XSDocumentInfo xSDocumentInfo, XSElementDecl xSElementDecl) {
        Object object;
        String string = DOMUtil.getAttrValue(element, SchemaSymbols.ATT_NAME);
        if (string.length() != 0) {
            object = xSDocumentInfo.fTargetNamespace == null ? "," + string : xSDocumentInfo.fTargetNamespace + "," + string;
            this.checkForDuplicateNames((String)object, this.fUnparsedIdentityConstraintRegistry, element, xSDocumentInfo);
        }
        if (this.fKeyrefStackPos == this.fKeyrefs.length) {
            object = new Element[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefs, 0, object, 0, this.fKeyrefStackPos);
            this.fKeyrefs = object;
            XSElementDecl[] xSElementDeclArray = new XSElementDecl[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefElems, 0, xSElementDeclArray, 0, this.fKeyrefStackPos);
            this.fKeyrefElems = xSElementDeclArray;
            String[][] stringArrayArray = new String[this.fKeyrefStackPos + 2][];
            System.arraycopy(this.fKeyrefNamespaceContext, 0, stringArrayArray, 0, this.fKeyrefStackPos);
            this.fKeyrefNamespaceContext = stringArrayArray;
        }
        this.fKeyrefs[this.fKeyrefStackPos] = element;
        this.fKeyrefElems[this.fKeyrefStackPos] = xSElementDecl;
        this.fKeyrefNamespaceContext[this.fKeyrefStackPos++] = xSDocumentInfo.fNamespaceSupport.getEffectiveLocalContext();
    }

    private Document getSchema(XSDDescription xSDDescription, boolean bl, Element element) {
        XMLInputSource xMLInputSource = null;
        try {
            xMLInputSource = XMLSchemaLoader.resolveDocument(xSDDescription, this.fLocationPairs, this.fEntityResolver);
        }
        catch (IOException iOException) {
            if (bl) {
                this.reportSchemaError(DOC_ERROR_CODES[xSDDescription.getContextType()], new Object[]{xSDDescription.getLocationHints()[0]}, element);
            }
            this.reportSchemaWarning(DOC_ERROR_CODES[xSDDescription.getContextType()], new Object[]{xSDDescription.getLocationHints()[0]}, element);
        }
        return this.getSchema(xSDDescription.getTargetNamespace(), xMLInputSource, bl, xSDDescription.getContextType(), element);
    }

    private Document getSchema(String string, XMLInputSource xMLInputSource, boolean bl, short s, Element element) {
        boolean bl2 = true;
        Document document = null;
        try {
            if (xMLInputSource != null && (xMLInputSource.getSystemId() != null || xMLInputSource.getByteStream() != null || xMLInputSource.getCharacterStream() != null)) {
                String string2 = XMLEntityManager.expandSystemId(xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId());
                XSDKey xSDKey = new XSDKey(string2, s, string);
                document = (Document)this.fTraversed.get(xSDKey);
                if (document != null) {
                    this.fLastSchemaWasDuplicate = true;
                    return document;
                }
                if (this.fSchemaParser == null) {
                    this.fSchemaParser = new DOMParser();
                    this.resetSchemaParserErrorHandler();
                    this.fSchemaParser.setPool(this.fDOMPool);
                }
                this.fSchemaParser.reset();
                this.fSchemaParser.parse(xMLInputSource);
                document = this.fSchemaParser.getDocument();
                this.fTraversed.put(xSDKey, document);
                if (string2 != null) {
                    this.fDoc2SystemId.put(document, string2);
                }
                this.fLastSchemaWasDuplicate = false;
                return document;
            }
            bl2 = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            this.reportSchemaError(DOC_ERROR_CODES[s], new Object[]{xMLInputSource.getSystemId()}, element);
        } else if (bl2) {
            this.reportSchemaWarning(DOC_ERROR_CODES[s], new Object[]{xMLInputSource.getSystemId()}, element);
        }
        this.fLastSchemaWasDuplicate = false;
        return null;
    }

    private void createTraversers() {
        this.fAttributeChecker = new XSAttributeChecker(this);
        this.fAttributeGroupTraverser = new XSDAttributeGroupTraverser(this, this.fAttributeChecker);
        this.fAttributeTraverser = new XSDAttributeTraverser(this, this.fAttributeChecker);
        this.fComplexTypeTraverser = new XSDComplexTypeTraverser(this, this.fAttributeChecker);
        this.fElementTraverser = new XSDElementTraverser(this, this.fAttributeChecker);
        this.fGroupTraverser = new XSDGroupTraverser(this, this.fAttributeChecker);
        this.fKeyrefTraverser = new XSDKeyrefTraverser(this, this.fAttributeChecker);
        this.fNotationTraverser = new XSDNotationTraverser(this, this.fAttributeChecker);
        this.fSimpleTypeTraverser = new XSDSimpleTypeTraverser(this, this.fAttributeChecker);
        this.fUniqueOrKeyTraverser = new XSDUniqueOrKeyTraverser(this, this.fAttributeChecker);
        this.fWildCardTraverser = new XSDWildcardTraverser(this, this.fAttributeChecker);
    }

    void prepareForParse() {
        this.fTraversed.clear();
        this.fDoc2SystemId.clear();
        this.fLastSchemaWasDuplicate = false;
    }

    void prepareForTraverse() {
        this.fUnparsedAttributeRegistry.clear();
        this.fUnparsedAttributeGroupRegistry.clear();
        this.fUnparsedElementRegistry.clear();
        this.fUnparsedGroupRegistry.clear();
        this.fUnparsedIdentityConstraintRegistry.clear();
        this.fUnparsedNotationRegistry.clear();
        this.fUnparsedTypeRegistry.clear();
        this.fXSDocumentInfoRegistry.clear();
        this.fDependencyMap.clear();
        this.fDoc2XSDocumentMap.clear();
        this.fRedefine2XSDMap.clear();
        this.fRedefine2NSSupport.clear();
        this.fAllTNSs.removeAllElements();
        this.fImportMap.clear();
        this.fRoot = null;
        int n = 0;
        while (n < this.fLocalElemStackPos) {
            this.fParticle[n] = null;
            this.fLocalElementDecl[n] = null;
            this.fLocalElemNamespaceContext[n] = null;
            ++n;
        }
        this.fLocalElemStackPos = 0;
        int n2 = 0;
        while (n2 < this.fKeyrefStackPos) {
            this.fKeyrefs[n2] = null;
            this.fKeyrefElems[n2] = null;
            this.fKeyrefNamespaceContext[n2] = null;
            ++n2;
        }
        this.fKeyrefStackPos = 0;
        if (this.fAttributeChecker == null) {
            this.createTraversers();
        }
        this.fAttributeChecker.reset(this.fSymbolTable);
        this.fAttributeGroupTraverser.reset(this.fSymbolTable);
        this.fAttributeTraverser.reset(this.fSymbolTable);
        this.fComplexTypeTraverser.reset(this.fSymbolTable);
        this.fElementTraverser.reset(this.fSymbolTable);
        this.fGroupTraverser.reset(this.fSymbolTable);
        this.fKeyrefTraverser.reset(this.fSymbolTable);
        this.fNotationTraverser.reset(this.fSymbolTable);
        this.fSimpleTypeTraverser.reset(this.fSymbolTable);
        this.fUniqueOrKeyTraverser.reset(this.fSymbolTable);
        this.fWildCardTraverser.reset(this.fSymbolTable);
        this.fRedefinedRestrictedAttributeGroupRegistry.clear();
        this.fRedefinedRestrictedGroupRegistry.clear();
    }

    public void setDeclPool(XSDeclarationPool xSDeclarationPool) {
        this.fDeclPool = xSDeclarationPool;
    }

    public void reset(XMLErrorReporter xMLErrorReporter, XMLEntityResolver xMLEntityResolver, SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityResolver = xMLEntityResolver;
        this.fSymbolTable = symbolTable;
        this.fGrammarPool = xMLGrammarPool;
        this.EMPTY_STRING = this.fSymbolTable.addSymbol("");
        this.resetSchemaParserErrorHandler();
    }

    void resetSchemaParserErrorHandler() {
        try {
            XMLErrorHandler xMLErrorHandler;
            if (this.fSchemaParser != null && (xMLErrorHandler = this.fErrorReporter.getErrorHandler()) == this.fSchemaParser.getProperty(ERROR_HANDLER)) {
                this.fSchemaParser.setProperty(ERROR_HANDLER, xMLErrorHandler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void traverseLocalElements() {
        this.fElementTraverser.fDeferTraversingLocalElements = false;
        int n = 0;
        while (n < this.fLocalElemStackPos) {
            Element element = this.fLocalElementDecl[n];
            XSDocumentInfo xSDocumentInfo = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(DOMUtil.getDocument(element));
            SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(xSDocumentInfo.fTargetNamespace);
            this.fElementTraverser.traverseLocal(this.fParticle[n], element, xSDocumentInfo, schemaGrammar, this.fAllContext[n], this.fEnclosingCT[n]);
            ++n;
        }
    }

    void fillInLocalElemInfo(Element element, XSDocumentInfo xSDocumentInfo, int n, XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl) {
        if (this.fParticle.length == this.fLocalElemStackPos) {
            XSParticleDecl[] xSParticleDeclArray = new XSParticleDecl[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fParticle, 0, xSParticleDeclArray, 0, this.fLocalElemStackPos);
            this.fParticle = xSParticleDeclArray;
            Element[] elementArray = new Element[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fLocalElementDecl, 0, elementArray, 0, this.fLocalElemStackPos);
            this.fLocalElementDecl = elementArray;
            int[] nArray = new int[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fAllContext, 0, nArray, 0, this.fLocalElemStackPos);
            this.fAllContext = nArray;
            XSComplexTypeDecl[] xSComplexTypeDeclArray = new XSComplexTypeDecl[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fEnclosingCT, 0, xSComplexTypeDeclArray, 0, this.fLocalElemStackPos);
            this.fEnclosingCT = xSComplexTypeDeclArray;
            String[][] stringArrayArray = new String[this.fLocalElemStackPos + 10][];
            System.arraycopy(this.fLocalElemNamespaceContext, 0, stringArrayArray, 0, this.fLocalElemStackPos);
            this.fLocalElemNamespaceContext = stringArrayArray;
        }
        this.fParticle[this.fLocalElemStackPos] = xSParticleDecl;
        this.fLocalElementDecl[this.fLocalElemStackPos] = element;
        this.fAllContext[this.fLocalElemStackPos] = n;
        this.fEnclosingCT[this.fLocalElemStackPos] = xSComplexTypeDecl;
        this.fLocalElemNamespaceContext[this.fLocalElemStackPos++] = xSDocumentInfo.fNamespaceSupport.getEffectiveLocalContext();
    }

    void checkForDuplicateNames(String string, Hashtable hashtable, Element element, XSDocumentInfo xSDocumentInfo) {
        Object var5_5 = null;
        Object v = hashtable.get(string);
        var5_5 = v;
        if (v == null) {
            hashtable.put(string, element);
        } else {
            Element element2 = var5_5;
            if (element2 == element) {
                return;
            }
            Element element3 = null;
            XSDocumentInfo xSDocumentInfo2 = null;
            boolean bl = true;
            element3 = DOMUtil.getParent(element2);
            if (DOMUtil.getLocalName(element3).equals(SchemaSymbols.ELT_REDEFINE)) {
                xSDocumentInfo2 = (XSDocumentInfo)this.fRedefine2XSDMap.get(element3);
            } else if (DOMUtil.getLocalName(DOMUtil.getParent(element)).equals(SchemaSymbols.ELT_REDEFINE)) {
                xSDocumentInfo2 = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(DOMUtil.getDocument(element2));
                bl = false;
            }
            if (xSDocumentInfo2 != null) {
                String string2 = string.substring(string.lastIndexOf(44) + 1) + REDEF_IDENTIFIER;
                if (xSDocumentInfo2 == xSDocumentInfo) {
                    element.setAttribute(SchemaSymbols.ATT_NAME, string2);
                    if (xSDocumentInfo.fTargetNamespace == null) {
                        hashtable.put("," + string2, element);
                    } else {
                        hashtable.put(xSDocumentInfo.fTargetNamespace + "," + string2, element);
                    }
                    if (xSDocumentInfo.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + string2, hashtable, element, xSDocumentInfo);
                    } else {
                        this.checkForDuplicateNames(xSDocumentInfo.fTargetNamespace + "," + string2, hashtable, element, xSDocumentInfo);
                    }
                } else if (bl) {
                    if (xSDocumentInfo.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + string2, hashtable, element, xSDocumentInfo);
                    } else {
                        this.checkForDuplicateNames(xSDocumentInfo.fTargetNamespace + "," + string2, hashtable, element, xSDocumentInfo);
                    }
                } else {
                    this.reportSchemaError("src-redefine.1", new Object[]{string}, element);
                }
            } else {
                this.reportSchemaError("sch-props-correct.2", new Object[]{string}, element);
            }
        }
    }

    private void renameRedefiningComponents(XSDocumentInfo xSDocumentInfo, Element element, String string, String string2, String string3) {
        SchemaNamespaceSupport schemaNamespaceSupport = xSDocumentInfo.fNamespaceSupport;
        if (string.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            Element element2 = DOMUtil.getFirstChildElement(element);
            if (element2 == null) {
                this.reportSchemaError("src-redefine.5", null, element);
            } else {
                String string4 = element2.getLocalName();
                if (string4.equals(SchemaSymbols.ELT_ANNOTATION)) {
                    element2 = DOMUtil.getNextSiblingElement(element2);
                    string4 = element2.getLocalName();
                }
                if (element2 == null) {
                    this.reportSchemaError("src-redefine.5", null, element);
                } else if (!string4.equals(SchemaSymbols.ELT_RESTRICTION)) {
                    this.reportSchemaError("src-redefine.5", null, element);
                } else {
                    Object[] objectArray = this.fAttributeChecker.checkAttributes(element2, false, xSDocumentInfo);
                    QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_BASE];
                    if (qName == null || qName.uri != xSDocumentInfo.fTargetNamespace || !qName.localpart.equals(string2)) {
                        this.reportSchemaError("src-redefine.5", null, element);
                    } else if (qName.prefix != null && qName.prefix.length() > 0) {
                        element2.setAttribute(SchemaSymbols.ATT_BASE, qName.prefix + ":" + string3);
                    } else {
                        element2.setAttribute(SchemaSymbols.ATT_BASE, string3);
                    }
                    this.fAttributeChecker.returnAttrArray(objectArray, xSDocumentInfo);
                }
            }
        } else if (string.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
            Element element3 = DOMUtil.getFirstChildElement(element);
            if (element3 == null) {
                this.reportSchemaError("src-redefine.5", null, element);
            } else {
                if (element3.getLocalName().equals(SchemaSymbols.ELT_ANNOTATION)) {
                    element3 = DOMUtil.getNextSiblingElement(element3);
                }
                if (element3 == null) {
                    this.reportSchemaError("src-redefine.5", null, element);
                } else {
                    Element element4 = DOMUtil.getFirstChildElement(element3);
                    if (element4 == null) {
                        this.reportSchemaError("src-redefine.5", null, element3);
                    } else {
                        String string5 = element4.getLocalName();
                        if (string5.equals(SchemaSymbols.ELT_ANNOTATION)) {
                            element4 = DOMUtil.getNextSiblingElement(element4);
                            string5 = element4.getLocalName();
                        }
                        if (element4 == null) {
                            this.reportSchemaError("src-redefine.5", null, element3);
                        } else if (!string5.equals(SchemaSymbols.ELT_RESTRICTION) && !string5.equals(SchemaSymbols.ELT_EXTENSION)) {
                            this.reportSchemaError("src-redefine.5", null, element4);
                        } else {
                            Object[] objectArray = this.fAttributeChecker.checkAttributes(element4, false, xSDocumentInfo);
                            QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_BASE];
                            if (qName == null || qName.uri != xSDocumentInfo.fTargetNamespace || !qName.localpart.equals(string2)) {
                                this.reportSchemaError("src-redefine.5", null, element4);
                            } else if (qName.prefix != null && qName.prefix.length() > 0) {
                                element4.setAttribute(SchemaSymbols.ATT_BASE, qName.prefix + ":" + string3);
                            } else {
                                element4.setAttribute(SchemaSymbols.ATT_BASE, string3);
                            }
                        }
                    }
                }
            }
        } else if (string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
            String string6 = xSDocumentInfo.fTargetNamespace == null ? "," + string2 : xSDocumentInfo.fTargetNamespace + "," + string2;
            int n = this.changeRedefineGroup(string6, string, string3, element, xSDocumentInfo);
            if (n > 1) {
                this.reportSchemaError("src-redefine.7.1", new Object[]{new Integer(n)}, element);
            } else if (n != 1) {
                if (xSDocumentInfo.fTargetNamespace == null) {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(string6, "," + string3);
                } else {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(string6, xSDocumentInfo.fTargetNamespace + "," + string3);
                }
            }
        } else if (string.equals(SchemaSymbols.ELT_GROUP)) {
            String string7 = xSDocumentInfo.fTargetNamespace == null ? "," + string2 : xSDocumentInfo.fTargetNamespace + "," + string2;
            int n = this.changeRedefineGroup(string7, string, string3, element, xSDocumentInfo);
            if (n > 1) {
                this.reportSchemaError("src-redefine.6.1.1", new Object[]{new Integer(n)}, element);
            } else if (n != 1) {
                if (xSDocumentInfo.fTargetNamespace == null) {
                    this.fRedefinedRestrictedGroupRegistry.put(string7, "," + string3);
                } else {
                    this.fRedefinedRestrictedGroupRegistry.put(string7, xSDocumentInfo.fTargetNamespace + "," + string3);
                }
            }
        } else {
            this.reportSchemaError("Internal-Error", new Object[]{"could not handle this particular <redefine>; please submit your schemas and instance document in a bug report!"}, element);
        }
    }

    private String findQName(String string, XSDocumentInfo xSDocumentInfo) {
        String string2;
        SchemaNamespaceSupport schemaNamespaceSupport = xSDocumentInfo.fNamespaceSupport;
        int n = string.indexOf(58);
        String string3 = this.EMPTY_STRING;
        if (n > 0) {
            string3 = string.substring(0, n);
        }
        String string4 = schemaNamespaceSupport.getURI(this.fSymbolTable.addSymbol(string3));
        String string5 = string2 = n == 0 ? string : string.substring(n + 1);
        if (string3 == this.EMPTY_STRING && string4 == null && xSDocumentInfo.fIsChameleonSchema) {
            string4 = xSDocumentInfo.fTargetNamespace;
        }
        if (string4 == null) {
            return "," + string2;
        }
        return string4 + "," + string2;
    }

    private int changeRedefineGroup(String string, String string2, String string3, Element element, XSDocumentInfo xSDocumentInfo) {
        SchemaNamespaceSupport schemaNamespaceSupport = xSDocumentInfo.fNamespaceSupport;
        int n = 0;
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string4 = element2.getLocalName();
            if (!string4.equals(string2)) {
                n += this.changeRedefineGroup(string, string2, string3, element2, xSDocumentInfo);
            } else {
                String string5;
                String string6 = element2.getAttribute(SchemaSymbols.ATT_REF);
                if (string6.length() != 0 && string.equals(string5 = this.findQName(string6, xSDocumentInfo))) {
                    String string7 = this.EMPTY_STRING;
                    String string8 = string6;
                    int n2 = string6.indexOf(":");
                    if (n2 > 0) {
                        string7 = string6.substring(0, n2);
                        element2.setAttribute(SchemaSymbols.ATT_REF, string7 + ":" + string3);
                    } else {
                        element2.setAttribute(SchemaSymbols.ATT_REF, string3);
                    }
                    ++n;
                    if (string2.equals(SchemaSymbols.ELT_GROUP)) {
                        String string9 = element2.getAttribute(SchemaSymbols.ATT_MINOCCURS);
                        String string10 = element2.getAttribute(SchemaSymbols.ATT_MAXOCCURS);
                        if (string10.length() != 0 && !string10.equals("1") || string9.length() != 0 && !string9.equals("1")) {
                            this.reportSchemaError("src-redefine.6.1.2", new Object[]{string6}, element2);
                        }
                    }
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        return n;
    }

    private XSDocumentInfo findXSDocumentForDecl(XSDocumentInfo xSDocumentInfo, Element element) {
        Document document = DOMUtil.getDocument(element);
        Object v = this.fDoc2XSDocumentMap.get(document);
        if (v == null) {
            return null;
        }
        XSDocumentInfo xSDocumentInfo2 = (XSDocumentInfo)v;
        return xSDocumentInfo2;
    }

    private boolean nonAnnotationContent(Element element) {
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            if (!DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                return true;
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        return false;
    }

    private void setSchemasVisible(XSDocumentInfo xSDocumentInfo) {
        if (DOMUtil.isHidden(xSDocumentInfo.fSchemaDoc)) {
            DOMUtil.setVisible(xSDocumentInfo.fSchemaDoc);
            Vector vector = (Vector)this.fDependencyMap.get(xSDocumentInfo);
            int n = 0;
            while (n < vector.size()) {
                this.setSchemasVisible((XSDocumentInfo)vector.elementAt(n));
                ++n;
            }
        }
    }

    public SimpleLocator element2Locator(Element element) {
        if (!(element instanceof ElementNSImpl)) {
            return null;
        }
        SimpleLocator simpleLocator = new SimpleLocator();
        return this.element2Locator(element, simpleLocator) ? simpleLocator : null;
    }

    public boolean element2Locator(Element element, SimpleLocator simpleLocator) {
        if (!(element instanceof ElementNSImpl) || simpleLocator == null) {
            return false;
        }
        ElementNSImpl elementNSImpl = (ElementNSImpl)element;
        Document document = elementNSImpl.getOwnerDocument();
        String string = (String)this.fDoc2SystemId.get(document);
        int n = elementNSImpl.getLineNumber();
        int n2 = elementNSImpl.getColumnNumber();
        simpleLocator.setValues(string, string, n, n2);
        return true;
    }

    void reportSchemaError(String string, Object[] objectArray, Element element) {
        if (this.element2Locator(element, this.xl)) {
            this.fErrorReporter.reportError(this.xl, "http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        } else {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        }
    }

    void reportSchemaWarning(String string, Object[] objectArray, Element element) {
        if (this.element2Locator(element, this.xl)) {
            this.fErrorReporter.reportError(this.xl, "http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)0);
        } else {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)0);
        }
    }

    private static class XSDKey {
        String systemId;
        short referType;
        String referNS;

        XSDKey(String string, short s, String string2) {
            this.systemId = string;
            this.referType = s;
            this.referNS = string2;
        }

        public int hashCode() {
            if (this.referType == 0 || this.referType == 1) {
                return this.systemId.hashCode();
            }
            return this.referNS == null ? 0 : this.referNS.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof XSDKey)) {
                return false;
            }
            XSDKey xSDKey = (XSDKey)object;
            if (this.referType == 0 || this.referType == 1 || xSDKey.referType == 0 || xSDKey.referType == 1) {
                return this.referType == xSDKey.referType && this.referNS == xSDKey.referNS && this.systemId != null && this.systemId.equals(xSDKey.systemId);
            }
            if (this.referType == 3 || xSDKey.referType == 3) {
                return false;
            }
            return this.referNS == xSDKey.referNS;
        }
    }
}

