/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMLocator;

public class DOMErrorImpl
implements DOMError {
    short fSeverity = 0;
    String fMessage = null;
    DOMLocator fLocation = null;
    Exception fException = null;

    public DOMErrorImpl() {
    }

    public DOMErrorImpl(short s, XMLParseException xMLParseException) {
        this.fSeverity = s;
        this.fException = xMLParseException;
        this.fMessage = xMLParseException.getMessage();
        this.fLocation = this.createDOMLocator(xMLParseException);
    }

    public short getSeverity() {
        return this.fSeverity;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public DOMLocator getLocation() {
        return this.fLocation;
    }

    private DOMLocator createDOMLocator(XMLParseException xMLParseException) {
        return new DOMLocatorImpl(xMLParseException.getLineNumber(), xMLParseException.getColumnNumber(), xMLParseException.getExpandedSystemId());
    }

    public void setSeverity(short s) {
        this.fSeverity = s;
    }

    public void setMessage(String string) {
        this.fMessage = string;
    }

    public void setLocator(DOMLocator dOMLocator) {
        this.fLocation = dOMLocator;
    }

    public void setException(Exception exception) {
        this.fException = exception;
    }

    public Object getRelatedException() {
        return this.fException;
    }

    public void reset() {
        this.fSeverity = 0;
        this.fMessage = null;
        this.fLocation = null;
        this.fException = null;
    }
}

