/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.URIResolver;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.apache.tools.ant.taskdefs.optional.TraXLiaison;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.EntityResolver;

public class XSLTProcess
extends MatchingTask
implements XSLTLogger {
    private File destDir = null;
    private File baseDir = null;
    private String xslFile = null;
    private String targetExtension = ".html";
    private Vector params = new Vector();
    private File inFile = null;
    private File outFile = null;
    private String processor;
    private Path classpath = null;
    private XSLTLiaison liaison;
    private boolean stylesheetLoaded = false;
    private boolean force = false;
    private FileUtils fileUtils;
    private Vector outputProperties = new Vector();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private static final String TRAX_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.TraXLiaison";
    private static final String XSLP_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.XslpLiaison";
    private static final String XALAN_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.XalanLiaison";
    private boolean performDirectoryScan = true;
    private boolean reuseLoadedStylesheet = true;

    public XSLTProcess() {
        this.fileUtils = FileUtils.newFileUtils();
    }

    public void setScanIncludedDirectories(boolean b) {
        this.performDirectoryScan = b;
    }

    public void setReloadStylesheet(boolean b) {
        this.reuseLoadedStylesheet = !b;
    }

    public void execute() throws BuildException {
        File savedBaseDir = this.baseDir;
        if (this.xslFile == null) {
            throw new BuildException("no stylesheet specified", this.getLocation());
        }
        try {
            if (this.baseDir == null) {
                this.baseDir = this.getProject().resolveFile(".");
            }
            this.liaison = this.getLiaison();
            if (this.liaison instanceof XSLTLoggerAware) {
                ((XSLTLoggerAware)((Object)this.liaison)).setLogger(this);
            }
            this.log("Using " + this.liaison.getClass().toString(), 3);
            File stylesheet = this.getProject().resolveFile(this.xslFile);
            if (!stylesheet.exists() && (stylesheet = this.fileUtils.resolveFile(this.baseDir, this.xslFile)).exists()) {
                this.log("DEPRECATED - the style attribute should be relative to the project's");
                this.log("             basedir, not the tasks's basedir.");
            }
            if (this.inFile != null && this.outFile != null) {
                this.process(this.inFile, this.outFile, stylesheet);
                Object var10_3 = null;
                this.liaison = null;
                this.stylesheetLoaded = false;
                this.baseDir = savedBaseDir;
                return;
            }
            if (this.destDir == null) {
                String msg = "destdir attributes must be set!";
                throw new BuildException(msg);
            }
            DirectoryScanner scanner = this.getDirectoryScanner(this.baseDir);
            this.log("Transforming into " + this.destDir, 2);
            String[] list = scanner.getIncludedFiles();
            int i = 0;
            while (i < list.length) {
                this.process(this.baseDir, list[i], this.destDir, stylesheet);
                ++i;
            }
            if (this.performDirectoryScan) {
                String[] dirs = scanner.getIncludedDirectories();
                int j = 0;
                while (j < dirs.length) {
                    list = new File(this.baseDir, dirs[j]).list();
                    int i2 = 0;
                    while (i2 < list.length) {
                        this.process(this.baseDir, list[i2], this.destDir, stylesheet);
                        ++i2;
                    }
                    ++j;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_5 = null;
            this.liaison = null;
            this.stylesheetLoaded = false;
            this.baseDir = savedBaseDir;
            throw throwable;
        }
        Object var10_4 = null;
        this.liaison = null;
        this.stylesheetLoaded = false;
        this.baseDir = savedBaseDir;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setExtension(String name) {
        this.targetExtension = name;
    }

    public void setStyle(String xslFile) {
        this.xslFile = xslFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    private void resolveProcessor(String proc) throws Exception {
        if (proc.equals("trax")) {
            Class clazz = this.loadClass(TRAX_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (proc.equals("xslp")) {
            this.log("DEPRECATED - xslp processor is deprecated. Use trax instead.");
            Class clazz = this.loadClass(XSLP_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (proc.equals("xalan")) {
            this.log("DEPRECATED - xalan processor is deprecated. Use trax instead.");
            Class clazz = this.loadClass(XALAN_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else {
            this.liaison = (XSLTLiaison)this.loadClass(proc).newInstance();
        }
    }

    private Class loadClass(String classname) throws Exception {
        if (this.classpath == null) {
            return Class.forName(classname);
        }
        AntClassLoader al = new AntClassLoader(this.getProject(), this.classpath);
        Class<?> c = al.loadClass(classname);
        AntClassLoader.initializeClass(c);
        return c;
    }

    public void setOut(File outFile) {
        this.outFile = outFile;
    }

    public void setIn(File inFile) {
        this.inFile = inFile;
    }

    private void process(File baseDir, String xmlFile, File destDir, File stylesheet) throws BuildException {
        String fileExt = this.targetExtension;
        File outFile = null;
        File inFile = null;
        try {
            long styleSheetLastModified = stylesheet.lastModified();
            inFile = new File(baseDir, xmlFile);
            if (inFile.isDirectory()) {
                this.log("Skipping " + inFile + " it is a directory.", 3);
                return;
            }
            int dotPos = xmlFile.lastIndexOf(46);
            outFile = dotPos > 0 ? new File(destDir, xmlFile.substring(0, xmlFile.lastIndexOf(46)) + fileExt) : new File(destDir, xmlFile + fileExt);
            if (this.force || inFile.lastModified() > outFile.lastModified() || styleSheetLastModified > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile);
                this.configureLiaison(stylesheet);
                this.liaison.transform(inFile, outFile);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException(ex);
        }
    }

    private void process(File inFile, File outFile, File stylesheet) throws BuildException {
        try {
            long styleSheetLastModified = stylesheet.lastModified();
            this.log("In file " + inFile + " time: " + inFile.lastModified(), 4);
            this.log("Out file " + outFile + " time: " + outFile.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + styleSheetLastModified, 4);
            if (this.force || inFile.lastModified() > outFile.lastModified() || styleSheetLastModified > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile, 2);
                this.configureLiaison(stylesheet);
                this.liaison.transform(inFile, outFile);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException(ex);
        }
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = this.fileUtils.getParentFile(targetFile);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    protected XSLTLiaison getLiaison() {
        if (this.liaison == null) {
            if (this.processor != null) {
                try {
                    this.resolveProcessor(this.processor);
                }
                catch (Exception e) {
                    throw new BuildException(e);
                }
            }
            try {
                this.resolveProcessor("trax");
            }
            catch (Throwable e1) {
                try {
                    this.resolveProcessor("xalan");
                }
                catch (Throwable e2) {
                    try {
                        this.resolveProcessor("xslp");
                    }
                    catch (Throwable e3) {
                        e3.printStackTrace();
                        e2.printStackTrace();
                        throw new BuildException(e1);
                    }
                }
            }
        }
        return this.liaison;
    }

    public Param createParam() {
        Param p = new Param();
        this.params.addElement(p);
        return p;
    }

    public OutputProperty createOutputProperty() {
        OutputProperty p = new OutputProperty();
        this.outputProperties.addElement(p);
        return p;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected void configureLiaison(File stylesheet) throws BuildException {
        if (this.stylesheetLoaded && this.reuseLoadedStylesheet) {
            return;
        }
        this.stylesheetLoaded = true;
        try {
            this.log("Loading stylesheet " + stylesheet, 2);
            this.liaison.setStylesheet(stylesheet);
            Enumeration e = this.params.elements();
            while (e.hasMoreElements()) {
                Param p = (Param)e.nextElement();
                this.liaison.addParam(p.getName(), p.getExpression());
            }
            if (this.liaison instanceof TraXLiaison) {
                this.configureTraXLiaison((TraXLiaison)this.liaison);
            }
        }
        catch (Exception ex) {
            this.log("Failed to transform using stylesheet " + stylesheet, 2);
            throw new BuildException(ex);
        }
    }

    protected void configureTraXLiaison(TraXLiaison liaison) {
        if (this.xmlCatalog != null) {
            liaison.setEntityResolver((EntityResolver)this.xmlCatalog);
            liaison.setURIResolver((URIResolver)this.xmlCatalog);
        }
        Enumeration props = this.outputProperties.elements();
        while (props.hasMoreElements()) {
            OutputProperty prop = (OutputProperty)props.nextElement();
            liaison.setOutputProperty(prop.getName(), prop.getValue());
        }
    }

    public static class OutputProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Param {
        private String name = null;
        private String expression = null;

        public void setName(String name) {
            this.name = name;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }
    }
}

