#define fn(...) (&InstructionDecoder_amdgpu_vega::__VA_ARGS__)
const operandFactory amdgpu_insn_entry::operandTable[] = {
	fn(NOTHING),
	fn(setSMEM),fn(setLoad<1>),//s_load_dword
	fn(setSMEM),fn(setLoad<2>),//s_load_dwordx2
	fn(setSMEM),fn(setLoad<4>),//s_load_dwordx4
	fn(setSMEM),fn(setLoad<8>),//s_load_dwordx8
	fn(setSMEM),fn(setLoad<16>),//s_load_dwordx16
	fn(setSMEM),fn(setLoad<1>),//s_buffer_load_dword
	fn(setSMEM),fn(setLoad<2>),//s_buffer_load_dwordx2
	fn(setSMEM),fn(setLoad<4>),//s_buffer_load_dwordx4
	fn(setSMEM),fn(setLoad<8>),//s_buffer_load_dwordx8
	fn(setSMEM),fn(setLoad<16>),//s_buffer_load_dwordx16
	fn(setSMEM),fn(setLoad<1>),//buffer_load_format_x
	fn(setSMEM),fn(setLoad<2>),//buffer_load_format_xy
	fn(setSMEM),fn(setLoad<3>),//buffer_load_format_xyz
	fn(setSMEM),fn(setLoad<4>),//buffer_load_format_xyzw
	fn(setSMEM),fn(setStore<1>),//buffer_store_format_x
	fn(setSMEM),fn(setStore<2>),//buffer_store_format_xy
	fn(setSMEM),fn(setStore<3>),//buffer_store_format_xyz
	fn(setSMEM),fn(setStore<4>),//buffer_store_format_xyzw
	fn(setSMEM),fn(setLoad<1>),//tbuffer_load_format_x
	fn(setSMEM),fn(setLoad<2>),//tbuffer_load_format_xy
	fn(setSMEM),fn(setLoad<3>),//tbuffer_load_format_xyz
	fn(setSMEM),fn(setLoad<4>),//tbuffer_load_format_xyzw
	fn(setSMEM),fn(setStore<1>),//tbuffer_store_format_x
	fn(setSMEM),fn(setStore<2>),//tbuffer_store_format_xy
	fn(setSMEM),fn(setStore<3>),//tbuffer_store_format_xyz
	fn(setSMEM),fn(setStore<4>),//tbuffer_store_format_xyzw
	fn(setBranch),//s_branch
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_scc0
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_scc1
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_vccz
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_vccnz
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_execz
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_execnz
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_cdbgsys
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_cdbguser
	fn(setBranch),fn(setConditionalBranch),//s_cbranch_cdbgsys_and_user
	fn(setBranch),fn(setCall),//s_call_b64
	fn(setBranch),fn(setModifyPC),//s_setpc_b64
	fn(setBranch),fn(setModifyPC),//s_swappc_b64
};
const amdgpu_insn_table amdgpu_insn_entry::sop2_insn_table = {
	{amdgpu_op_s_add_u32,"s_add_u32",0,&operandTable[0]} ,//0
	{amdgpu_op_s_sub_u32,"s_sub_u32",0,&operandTable[0]} ,//1
	{amdgpu_op_s_add_i32,"s_add_i32",0,&operandTable[0]} ,//2
	{amdgpu_op_s_sub_i32,"s_sub_i32",0,&operandTable[0]} ,//3
	{amdgpu_op_s_addc_u32,"s_addc_u32",0,&operandTable[0]} ,//4
	{amdgpu_op_s_subb_u32,"s_subb_u32",0,&operandTable[0]} ,//5
	{amdgpu_op_s_min_i32,"s_min_i32",0,&operandTable[0]} ,//6
	{amdgpu_op_s_min_u32,"s_min_u32",0,&operandTable[0]} ,//7
	{amdgpu_op_s_max_i32,"s_max_i32",0,&operandTable[0]} ,//8
	{amdgpu_op_s_max_u32,"s_max_u32",0,&operandTable[0]} ,//9
	{amdgpu_op_s_cslect_b32,"s_cslect_b32",0,&operandTable[0]} ,//10
	{amdgpu_op_s_cslect_b64,"s_cslect_b64",0,&operandTable[0]} ,//11
	{amdgpu_op_s_and_b32,"s_and_b32",0,&operandTable[0]} ,//12
	{amdgpu_op_s_and_b64,"s_and_b64",0,&operandTable[0]} ,//13
	{amdgpu_op_s_or_b32,"s_or_b32",0,&operandTable[0]} ,//14
	{amdgpu_op_s_or_b64,"s_or_b64",0,&operandTable[0]} ,//15
	{amdgpu_op_s_xor_b32,"s_xor_b32",0,&operandTable[0]} ,//16
	{amdgpu_op_s_xor_b64,"s_xor_b64",0,&operandTable[0]} ,//17
	{amdgpu_op_s_andn2_b32,"s_andn2_b32",0,&operandTable[0]} ,//18
	{amdgpu_op_s_andn2_b64,"s_andn2_b64",0,&operandTable[0]} ,//19
	{amdgpu_op_s_orn2_b32,"s_orn2_b32",0,&operandTable[0]} ,//20
	{amdgpu_op_s_orn2_b64,"s_orn2_b64",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nand_b32,"s_nand_b32",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nand_b64,"s_nand_b64",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nor_b32,"s_nor_b32",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nor_b64,"s_nor_b64",0,&operandTable[0]} ,//25
	{amdgpu_op_s_xnor_b32,"s_xnor_b32",0,&operandTable[0]} ,//26
	{amdgpu_op_s_xnor_b64,"s_xnor_b64",0,&operandTable[0]} ,//27
	{amdgpu_op_s_lshl_b32,"s_lshl_b32",0,&operandTable[0]} ,//28
	{amdgpu_op_s_lshl_b64,"s_lshl_b64",0,&operandTable[0]} ,//29
	{amdgpu_op_s_lshr_b32,"s_lshr_b32",0,&operandTable[0]} ,//30
	{amdgpu_op_s_lshr_b64,"s_lshr_b64",0,&operandTable[0]} ,//31
	{amdgpu_op_s_ashr_i32,"s_ashr_i32",0,&operandTable[0]} ,//32
	{amdgpu_op_s_ashr_i64,"s_ashr_i64",0,&operandTable[0]} ,//33
	{amdgpu_op_s_bfm_b32,"s_bfm_b32",0,&operandTable[0]} ,//34
	{amdgpu_op_s_bfm_b64,"s_bfm_b64",0,&operandTable[0]} ,//35
	{amdgpu_op_s_mul_i32,"s_mul_i32",0,&operandTable[0]} ,//36
	{amdgpu_op_s_bfe_u32,"s_bfe_u32",0,&operandTable[0]} ,//37
	{amdgpu_op_s_bfe_i32,"s_bfe_i32",0,&operandTable[0]} ,//38
	{amdgpu_op_s_bfe_u64,"s_bfe_u64",0,&operandTable[0]} ,//39
	{amdgpu_op_s_bfe_i64,"s_bfe_i64",0,&operandTable[0]} ,//40
	{amdgpu_op_s_cbranch_g_fork,"s_cbranch_g_fork",0,&operandTable[0]} ,//41
	{amdgpu_op_s_absdiff_i32,"s_absdiff_i32",0,&operandTable[0]} ,//42
	{amdgpu_op_s_rfe_restore_b64,"s_rfe_restore_b64",0,&operandTable[0]} ,//43
	{amdgpu_op_s_mul_hi_u32,"s_mul_hi_u32",0,&operandTable[0]} ,//44
	{amdgpu_op_s_mul_hi_i32,"s_mul_hi_i32",0,&operandTable[0]} ,//45
	{amdgpu_op_s_lshl1_add_u32,"s_lshl1_add_u32",0,&operandTable[0]} ,//46
	{amdgpu_op_s_lshsl2_add_u32,"s_lshsl2_add_u32",0,&operandTable[0]} ,//47
	{amdgpu_op_s_lshl3_add_u32,"s_lshl3_add_u32",0,&operandTable[0]} ,//48
	{amdgpu_op_s_lshl4_add_u32,"s_lshl4_add_u32",0,&operandTable[0]} ,//49
	{amdgpu_op_s_pack_ll_b32_b16,"s_pack_ll_b32_b16",0,&operandTable[0]} ,//50
	{amdgpu_op_s_pack_lh_b32_b16,"s_pack_lh_b32_b16",0,&operandTable[0]} ,//51
	{amdgpu_op_s_pack_hh_b32_B16,"s_pack_hh_b32_B16",0,&operandTable[0]} ,//52
}; // end s_pack_hh_b32_B16_insn_table

const amdgpu_insn_table amdgpu_insn_entry::sop1_insn_table = {
	{amdgpu_op_s_mov_b32,"s_mov_b32",0,&operandTable[0]} ,//0
	{amdgpu_op_s_mov_b64,"s_mov_b64",0,&operandTable[0]} ,//1
	{amdgpu_op_s_cmov_b32,"s_cmov_b32",0,&operandTable[0]} ,//2
	{amdgpu_op_s_cmov_b64,"s_cmov_b64",0,&operandTable[0]} ,//3
	{amdgpu_op_s_not_b32,"s_not_b32",0,&operandTable[0]} ,//4
	{amdgpu_op_s_not_b64,"s_not_b64",0,&operandTable[0]} ,//5
	{amdgpu_op_s_wqm_b32,"s_wqm_b32",0,&operandTable[0]} ,//6
	{amdgpu_op_s_wqm_b64,"s_wqm_b64",0,&operandTable[0]} ,//7
	{amdgpu_op_s_brev_b32,"s_brev_b32",0,&operandTable[0]} ,//8
	{amdgpu_op_s_brev_b64,"s_brev_b64",0,&operandTable[0]} ,//9
	{amdgpu_op_s_bcnt0_i32_b32,"s_bcnt0_i32_b32",0,&operandTable[0]} ,//10
	{amdgpu_op_s_bcnt0_i32_b64,"s_bcnt0_i32_b64",0,&operandTable[0]} ,//11
	{amdgpu_op_s_bcnt1_i32_b32,"s_bcnt1_i32_b32",0,&operandTable[0]} ,//12
	{amdgpu_op_s_bcnt1_i32_b64,"s_bcnt1_i32_b64",0,&operandTable[0]} ,//13
	{amdgpu_op_s_ff0_i32_b32,"s_ff0_i32_b32",0,&operandTable[0]} ,//14
	{amdgpu_op_s_ff0_i32_b64,"s_ff0_i32_b64",0,&operandTable[0]} ,//15
	{amdgpu_op_s_ff1_i32_b32,"s_ff1_i32_b32",0,&operandTable[0]} ,//16
	{amdgpu_op_s_ff1_i32_b64,"s_ff1_i32_b64",0,&operandTable[0]} ,//17
	{amdgpu_op_s_flbit_i32_b32,"s_flbit_i32_b32",0,&operandTable[0]} ,//18
	{amdgpu_op_s_flbit_i32_b64,"s_flbit_i32_b64",0,&operandTable[0]} ,//19
	{amdgpu_op_s_fltbit_i32,"s_fltbit_i32",0,&operandTable[0]} ,//20
	{amdgpu_op_s_fltbit_i32_i64,"s_fltbit_i32_i64",0,&operandTable[0]} ,//21
	{amdgpu_op_s_sext_i32_i8,"s_sext_i32_i8",0,&operandTable[0]} ,//22
	{amdgpu_op_s_sext_i32_i16,"s_sext_i32_i16",0,&operandTable[0]} ,//23
	{amdgpu_op_s_bitset0_b32,"s_bitset0_b32",0,&operandTable[0]} ,//24
	{amdgpu_op_s_bitset0_b64,"s_bitset0_b64",0,&operandTable[0]} ,//25
	{amdgpu_op_s_bitset1_b32,"s_bitset1_b32",0,&operandTable[0]} ,//26
	{amdgpu_op_s_bitset1_b64,"s_bitset1_b64",0,&operandTable[0]} ,//27
	{amdgpu_op_s_getpc_b64,"s_getpc_b64",0,&operandTable[0]} ,//28
	{amdgpu_op_s_setpc_b64,"s_setpc_b64",2,&operandTable[74]} ,//29
	{amdgpu_op_s_swappc_b64,"s_swappc_b64",2,&operandTable[76]} ,//30
	{amdgpu_op_s_rfe_b64,"s_rfe_b64",0,&operandTable[0]} ,//31
	{amdgpu_op_s_and_saveexec_b64,"s_and_saveexec_b64",0,&operandTable[0]} ,//32
	{amdgpu_op_s_or_savexec_b64,"s_or_savexec_b64",0,&operandTable[0]} ,//33
	{amdgpu_op_s_xor_savexec_b64,"s_xor_savexec_b64",0,&operandTable[0]} ,//34
	{amdgpu_op_s_andn2_savexec_b64,"s_andn2_savexec_b64",0,&operandTable[0]} ,//35
	{amdgpu_op_s_orn2_savexec_b64,"s_orn2_savexec_b64",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nand_savexec_b64,"s_nand_savexec_b64",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nor_savexec_b64,"s_nor_savexec_b64",0,&operandTable[0]} ,//38
	{amdgpu_op_s_xnor_savexec_b64,"s_xnor_savexec_b64",0,&operandTable[0]} ,//39
	{amdgpu_op_s_quadmask_b32,"s_quadmask_b32",0,&operandTable[0]} ,//40
	{amdgpu_op_s_quadmask_b64,"s_quadmask_b64",0,&operandTable[0]} ,//41
	{amdgpu_op_s_movrels_b32,"s_movrels_b32",0,&operandTable[0]} ,//42
	{amdgpu_op_s_movrels_b64,"s_movrels_b64",0,&operandTable[0]} ,//43
	{amdgpu_op_s_movreld_b32,"s_movreld_b32",0,&operandTable[0]} ,//44
	{amdgpu_op_s_movreld_b64,"s_movreld_b64",0,&operandTable[0]} ,//45
	{amdgpu_op_s_cbranch_join,"s_cbranch_join",0,&operandTable[0]} ,//46
	{amdgpu_op_s_invalid_1,"s_invalid_1",0,&operandTable[0]} ,//47
	{amdgpu_op_s_abs_i32,"s_abs_i32",0,&operandTable[0]} ,//48
	{amdgpu_op_s_invalid_2,"s_invalid_2",0,&operandTable[0]} ,//49
	{amdgpu_op_s_set_gpr_idx_idx,"s_set_gpr_idx_idx",0,&operandTable[0]} ,//50
	{amdgpu_op_s_andn1_saveexec_b64,"s_andn1_saveexec_b64",0,&operandTable[0]} ,//51
	{amdgpu_op_s_orn1_saveexec_b64,"s_orn1_saveexec_b64",0,&operandTable[0]} ,//52
	{amdgpu_op_s_andn1_wrexec_b64,"s_andn1_wrexec_b64",0,&operandTable[0]} ,//53
	{amdgpu_op_s_andn2_wrexec_b64,"s_andn2_wrexec_b64",0,&operandTable[0]} ,//54
	{amdgpu_op_s_bitreplicate_b64_b32,"s_bitreplicate_b64_b32",0,&operandTable[0]} ,//55
}; // end s_bitreplicate_b64_b32_insn_table

const amdgpu_insn_table amdgpu_insn_entry::sopk_insn_table = {
	{amdgpu_op_s_movk_i32,"s_movk_i32",0,&operandTable[0]} ,//0
	{amdgpu_op_s_cmovk_i32,"s_cmovk_i32",0,&operandTable[0]} ,//1
	{amdgpu_op_s_cmpk_eq_i32,"s_cmpk_eq_i32",0,&operandTable[0]} ,//2
	{amdgpu_op_s_cmpk_lg_i32,"s_cmpk_lg_i32",0,&operandTable[0]} ,//3
	{amdgpu_op_s_cmpk_gt_i32,"s_cmpk_gt_i32",0,&operandTable[0]} ,//4
	{amdgpu_op_s_cmpk_ge_i32,"s_cmpk_ge_i32",0,&operandTable[0]} ,//5
	{amdgpu_op_s_cmpk_lt_i32,"s_cmpk_lt_i32",0,&operandTable[0]} ,//6
	{amdgpu_op_s_cmpk_le_i32,"s_cmpk_le_i32",0,&operandTable[0]} ,//7
	{amdgpu_op_s_cmpk_eq_u32,"s_cmpk_eq_u32",0,&operandTable[0]} ,//8
	{amdgpu_op_s_cmpk_lg_u32,"s_cmpk_lg_u32",0,&operandTable[0]} ,//9
	{amdgpu_op_s_cmpk_gt_u32,"s_cmpk_gt_u32",0,&operandTable[0]} ,//10
	{amdgpu_op_s_cmpk_ge_u32,"s_cmpk_ge_u32",0,&operandTable[0]} ,//11
	{amdgpu_op_s_cmpk_lt_u32,"s_cmpk_lt_u32",0,&operandTable[0]} ,//12
	{amdgpu_op_s_cmpk_le_u32,"s_cmpk_le_u32",0,&operandTable[0]} ,//13
	{amdgpu_op_s_addk_i32,"s_addk_i32",0,&operandTable[0]} ,//14
	{amdgpu_op_s_mulk_i32,"s_mulk_i32",0,&operandTable[0]} ,//15
	{amdgpu_op_s_cbranch_i_fork,"s_cbranch_i_fork",0,&operandTable[0]} ,//16
	{amdgpu_op_s_getreg_b32,"s_getreg_b32",0,&operandTable[0]} ,//17
	{amdgpu_op_s_setreg_b32,"s_setreg_b32",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_setreg_imm32_b32,"s_setreg_imm32_b32",0,&operandTable[0]} ,//20
	{amdgpu_op_s_call_b64,"s_call_b64",2,&operandTable[72]} ,//21
}; // end s_call_b64_insn_table

const amdgpu_insn_table amdgpu_insn_entry::sopc_insn_table = {
	{amdgpu_op_s_cmp_ge_eq_i32,"s_cmp_ge_eq_i32",0,&operandTable[0]} ,//0
	{amdgpu_op_s_cmp_ge_eq_u32,"s_cmp_ge_eq_u32",0,&operandTable[0]} ,//1
	{amdgpu_op_s_cmp_lg_i32,"s_cmp_lg_i32",0,&operandTable[0]} ,//2
	{amdgpu_op_s_cmp_lg_u32,"s_cmp_lg_u32",0,&operandTable[0]} ,//3
	{amdgpu_op_s_cmp_gt_i32,"s_cmp_gt_i32",0,&operandTable[0]} ,//4
	{amdgpu_op_s_cmp_gt_u32,"s_cmp_gt_u32",0,&operandTable[0]} ,//5
	{amdgpu_op_s_cmp_ge_i32,"s_cmp_ge_i32",0,&operandTable[0]} ,//6
	{amdgpu_op_s_cmp_ge_u32,"s_cmp_ge_u32",0,&operandTable[0]} ,//7
	{amdgpu_op_s_cmp_lt_i32,"s_cmp_lt_i32",0,&operandTable[0]} ,//8
	{amdgpu_op_s_cmp_lt_u32,"s_cmp_lt_u32",0,&operandTable[0]} ,//9
	{amdgpu_op_s_cmp_le_i32,"s_cmp_le_i32",0,&operandTable[0]} ,//10
	{amdgpu_op_s_cmp_le_u32,"s_cmp_le_u32",0,&operandTable[0]} ,//11
	{amdgpu_op_s_bitcmp0_b32,"s_bitcmp0_b32",0,&operandTable[0]} ,//12
	{amdgpu_op_s_bitcmp1_b32,"s_bitcmp1_b32",0,&operandTable[0]} ,//13
	{amdgpu_op_s_bitcmp0_b64,"s_bitcmp0_b64",0,&operandTable[0]} ,//14
	{amdgpu_op_s_bitcmp1_b64,"s_bitcmp1_b64",0,&operandTable[0]} ,//15
	{amdgpu_op_s_setvkip,"s_setvkip",0,&operandTable[0]} ,//16
	{amdgpu_op_s_set_gpr_idx_on,"s_set_gpr_idx_on",0,&operandTable[0]} ,//17
	{amdgpu_op_s_cmp_eq_u64,"s_cmp_eq_u64",0,&operandTable[0]} ,//18
	{amdgpu_op_s_cmp_lg_u64,"s_cmp_lg_u64",0,&operandTable[0]} ,//19
}; // end s_cmp_lg_u64_insn_table

const amdgpu_insn_table amdgpu_insn_entry::sopp_insn_table = {
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//0
	{amdgpu_op_s_endpgm,"s_endpgm",0,&operandTable[0]} ,//1
	{amdgpu_op_s_branch,"s_branch",1,&operandTable[53]} ,//2
	{amdgpu_op_s_wakeup,"s_wakeup",0,&operandTable[0]} ,//3
	{amdgpu_op_s_cbranch_scc0,"s_cbranch_scc0",2,&operandTable[54]} ,//4
	{amdgpu_op_s_cbranch_scc1,"s_cbranch_scc1",2,&operandTable[56]} ,//5
	{amdgpu_op_s_cbranch_vccz,"s_cbranch_vccz",2,&operandTable[58]} ,//6
	{amdgpu_op_s_cbranch_vccnz,"s_cbranch_vccnz",2,&operandTable[60]} ,//7
	{amdgpu_op_s_cbranch_execz,"s_cbranch_execz",2,&operandTable[62]} ,//8
	{amdgpu_op_s_cbranch_execnz,"s_cbranch_execnz",2,&operandTable[64]} ,//9
	{amdgpu_op_s_barrier,"s_barrier",0,&operandTable[0]} ,//10
	{amdgpu_op_s_setkill,"s_setkill",0,&operandTable[0]} ,//11
	{amdgpu_op_s_waitcnt,"s_waitcnt",0,&operandTable[0]} ,//12
	{amdgpu_op_s_sethalt,"s_sethalt",0,&operandTable[0]} ,//13
	{amdgpu_op_s_sleep,"s_sleep",0,&operandTable[0]} ,//14
	{amdgpu_op_s_setprio,"s_setprio",0,&operandTable[0]} ,//15
	{amdgpu_op_s_sendmsg,"s_sendmsg",0,&operandTable[0]} ,//16
	{amdgpu_op_s_sendmsghalt,"s_sendmsghalt",0,&operandTable[0]} ,//17
	{amdgpu_op_s_trap,"s_trap",0,&operandTable[0]} ,//18
	{amdgpu_op_s_icache_inv,"s_icache_inv",0,&operandTable[0]} ,//19
	{amdgpu_op_s_incperflevel,"s_incperflevel",0,&operandTable[0]} ,//20
	{amdgpu_op_s_decperflevel,"s_decperflevel",0,&operandTable[0]} ,//21
	{amdgpu_op_s_ttracedata,"s_ttracedata",0,&operandTable[0]} ,//22
	{amdgpu_op_s_cbranch_cdbgsys,"s_cbranch_cdbgsys",2,&operandTable[66]} ,//23
	{amdgpu_op_s_cbranch_cdbguser,"s_cbranch_cdbguser",2,&operandTable[68]} ,//24
	{amdgpu_op_s_cbranch_cdbgsys_or_user,"s_cbranch_cdbgsys_or_user",0,&operandTable[0]} ,//25
	{amdgpu_op_s_cbranch_cdbgsys_and_user,"s_cbranch_cdbgsys_and_user",2,&operandTable[70]} ,//26
	{amdgpu_op_s_endpgm_saved,"s_endpgm_saved",0,&operandTable[0]} ,//27
	{amdgpu_op_s_set_gpr_idx_off,"s_set_gpr_idx_off",0,&operandTable[0]} ,//28
	{amdgpu_op_s_set_gpr_idx_mode,"s_set_gpr_idx_mode",0,&operandTable[0]} ,//29
	{amdgpu_op_s_endpgm_ordered_ps_done,"s_endpgm_ordered_ps_done",0,&operandTable[0]} ,//30
}; // end s_endpgm_ordered_ps_done_insn_table

const amdgpu_insn_table amdgpu_insn_entry::smem_insn_table = {
	{amdgpu_op_s_load_dword,"s_load_dword",2,&operandTable[1]} ,//0
	{amdgpu_op_s_load_dwordx2,"s_load_dwordx2",2,&operandTable[3]} ,//1
	{amdgpu_op_s_load_dwordx4,"s_load_dwordx4",2,&operandTable[5]} ,//2
	{amdgpu_op_s_load_dwordx8,"s_load_dwordx8",2,&operandTable[7]} ,//3
	{amdgpu_op_s_load_dwordx16,"s_load_dwordx16",2,&operandTable[9]} ,//4
	{amdgpu_op_s_scratch_load_dword,"s_scratch_load_dword",0,&operandTable[0]} ,//5
	{amdgpu_op_s_scratch_load_dwordx2,"s_scratch_load_dwordx2",0,&operandTable[0]} ,//6
	{amdgpu_op_s_scratch_load_dwordx4,"s_scratch_load_dwordx4",0,&operandTable[0]} ,//7
	{amdgpu_op_s_buffer_load_dword,"s_buffer_load_dword",2,&operandTable[11]} ,//8
	{amdgpu_op_s_buffer_load_dwordx2,"s_buffer_load_dwordx2",2,&operandTable[13]} ,//9
	{amdgpu_op_s_buffer_load_dwordx4,"s_buffer_load_dwordx4",2,&operandTable[15]} ,//10
	{amdgpu_op_s_buffer_load_dwordx8,"s_buffer_load_dwordx8",2,&operandTable[17]} ,//11
	{amdgpu_op_s_buffer_load_dwordx16,"s_buffer_load_dwordx16",2,&operandTable[19]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_s_store_dword,"s_store_dword",0,&operandTable[0]} ,//16
	{amdgpu_op_s_store_dwordx2,"s_store_dwordx2",0,&operandTable[0]} ,//17
	{amdgpu_op_s_store_dwordx4,"s_store_dwordx4",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//20
	{amdgpu_op_s_scratch_store_dword,"s_scratch_store_dword",0,&operandTable[0]} ,//21
	{amdgpu_op_s_scratch_store_dwordx2,"s_scratch_store_dwordx2",0,&operandTable[0]} ,//22
	{amdgpu_op_s_scratch_store_dwordx4,"s_scratch_store_dwordx4",0,&operandTable[0]} ,//23
	{amdgpu_op_s_buffer_store_dword,"s_buffer_store_dword",0,&operandTable[0]} ,//24
	{amdgpu_op_s_buffer_store_dwordx2,"s_buffer_store_dwordx2",0,&operandTable[0]} ,//25
	{amdgpu_op_s_buffer_store_dwordx4,"s_buffer_store_dwordx4",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_dcache_inv,"s_dcache_inv",0,&operandTable[0]} ,//32
	{amdgpu_op_s_dcache_wb,"s_dcache_wb",0,&operandTable[0]} ,//33
	{amdgpu_op_s_dcache_inv_vol,"s_dcache_inv_vol",0,&operandTable[0]} ,//34
	{amdgpu_op_s_dcache_wb_vol,"s_dcache_wb_vol",0,&operandTable[0]} ,//35
	{amdgpu_op_s_dcache_memtime,"s_dcache_memtime",0,&operandTable[0]} ,//36
	{amdgpu_op_s_dcache_memrealtime,"s_dcache_memrealtime",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//43
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//44
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//45
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//46
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//47
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//48
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//49
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//50
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//51
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//52
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//53
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//61
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//62
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//63
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//64
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//65
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//66
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//67
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//68
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//69
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//70
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//71
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//72
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//73
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//74
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//75
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//76
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//77
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//78
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//79
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//80
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//81
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//82
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//83
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//84
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//85
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//86
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//87
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//88
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//89
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//90
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//91
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//92
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//93
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//94
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//95
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//96
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//97
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//98
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//99
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//100
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//101
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//102
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//103
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//104
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//105
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//106
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//107
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//108
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//109
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//110
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//111
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//112
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//113
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//114
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//115
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//116
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//117
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//118
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//119
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//120
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//121
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//122
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//123
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//124
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//125
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//126
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//127
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//128
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//129
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//130
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//131
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//132
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//133
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//134
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//135
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//136
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//137
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//138
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//139
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//140
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//141
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//142
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//143
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//144
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//145
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//146
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//147
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//148
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//149
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//150
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//151
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//152
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//153
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//154
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//155
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//156
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//157
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//158
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//159
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//160
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//161
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//162
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//163
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//164
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//165
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//166
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//167
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//168
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//169
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//170
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//171
	{amdgpu_op_s_atomic_dec_x2,"s_atomic_dec_x2",0,&operandTable[0]} ,//172
}; // end s_atomic_dec_x2_insn_table

const amdgpu_insn_table amdgpu_insn_entry::vop2_insn_table = {
	{amdgpu_op_v_cndmask_b32,"v_cndmask_b32",0,&operandTable[0]} ,//0
	{amdgpu_op_v_add_f32,"v_add_f32",0,&operandTable[0]} ,//1
	{amdgpu_op_v_sub_f32,"v_sub_f32",0,&operandTable[0]} ,//2
	{amdgpu_op_v_subrev_f32,"v_subrev_f32",0,&operandTable[0]} ,//3
	{amdgpu_op_v_mul_legacy_f32,"v_mul_legacy_f32",0,&operandTable[0]} ,//4
	{amdgpu_op_v_mul_f32,"v_mul_f32",0,&operandTable[0]} ,//5
	{amdgpu_op_v_mul_i32_i24,"v_mul_i32_i24",0,&operandTable[0]} ,//6
	{amdgpu_op_v_mul_hi_i32_i24,"v_mul_hi_i32_i24",0,&operandTable[0]} ,//7
	{amdgpu_op_v_mul_u32_u24,"v_mul_u32_u24",0,&operandTable[0]} ,//8
	{amdgpu_op_v_mul_hi_u32_u24,"v_mul_hi_u32_u24",0,&operandTable[0]} ,//9
	{amdgpu_op_v_min_f32,"v_min_f32",0,&operandTable[0]} ,//10
	{amdgpu_op_v_max_f32,"v_max_f32",0,&operandTable[0]} ,//11
	{amdgpu_op_v_min_i32,"v_min_i32",0,&operandTable[0]} ,//12
	{amdgpu_op_v_max_i32,"v_max_i32",0,&operandTable[0]} ,//13
	{amdgpu_op_v_min_u32,"v_min_u32",0,&operandTable[0]} ,//14
	{amdgpu_op_v_max_u32,"v_max_u32",0,&operandTable[0]} ,//15
	{amdgpu_op_v_lshrrev_b32,"v_lshrrev_b32",0,&operandTable[0]} ,//16
	{amdgpu_op_v_ashrrev_i32,"v_ashrrev_i32",0,&operandTable[0]} ,//17
	{amdgpu_op_v_lshlrev_b32,"v_lshlrev_b32",0,&operandTable[0]} ,//18
	{amdgpu_op_v_add_b32,"v_add_b32",0,&operandTable[0]} ,//19
	{amdgpu_op_v_or_b32,"v_or_b32",0,&operandTable[0]} ,//20
	{amdgpu_op_v_xor_b32,"v_xor_b32",0,&operandTable[0]} ,//21
	{amdgpu_op_v_mac_b32,"v_mac_b32",0,&operandTable[0]} ,//22
	{amdgpu_op_v_madmk_f32,"v_madmk_f32",0,&operandTable[0]} ,//23
	{amdgpu_op_v_madak_f32,"v_madak_f32",0,&operandTable[0]} ,//24
	{amdgpu_op_v_add_co_u32,"v_add_co_u32",0,&operandTable[0]} ,//25
	{amdgpu_op_v_sub_co_u32,"v_sub_co_u32",0,&operandTable[0]} ,//26
	{amdgpu_op_v_subrev_co_u32,"v_subrev_co_u32",0,&operandTable[0]} ,//27
	{amdgpu_op_v_addc_co_u32,"v_addc_co_u32",0,&operandTable[0]} ,//28
	{amdgpu_op_v_subb_co_u32,"v_subb_co_u32",0,&operandTable[0]} ,//29
	{amdgpu_op_v_subbrev_co_u32,"v_subbrev_co_u32",0,&operandTable[0]} ,//30
	{amdgpu_op_v_add_f16,"v_add_f16",0,&operandTable[0]} ,//31
	{amdgpu_op_v_sub_f16,"v_sub_f16",0,&operandTable[0]} ,//32
	{amdgpu_op_v_subrev_f16,"v_subrev_f16",0,&operandTable[0]} ,//33
	{amdgpu_op_v_mul_f16,"v_mul_f16",0,&operandTable[0]} ,//34
	{amdgpu_op_v_mac_f16,"v_mac_f16",0,&operandTable[0]} ,//35
	{amdgpu_op_v_madmk_f16,"v_madmk_f16",0,&operandTable[0]} ,//36
	{amdgpu_op_v_madak_f16,"v_madak_f16",0,&operandTable[0]} ,//37
	{amdgpu_op_v_add_u16,"v_add_u16",0,&operandTable[0]} ,//38
	{amdgpu_op_v_sub_u16,"v_sub_u16",0,&operandTable[0]} ,//39
	{amdgpu_op_v_subrev_u16,"v_subrev_u16",0,&operandTable[0]} ,//40
	{amdgpu_op_v_mul_lo_u16,"v_mul_lo_u16",0,&operandTable[0]} ,//41
	{amdgpu_op_v_lshlrev_b16,"v_lshlrev_b16",0,&operandTable[0]} ,//42
	{amdgpu_op_v_lshrrev_b16,"v_lshrrev_b16",0,&operandTable[0]} ,//43
	{amdgpu_op_v_ashrrev_i16,"v_ashrrev_i16",0,&operandTable[0]} ,//44
	{amdgpu_op_v_max_f16,"v_max_f16",0,&operandTable[0]} ,//45
	{amdgpu_op_v_min_f16,"v_min_f16",0,&operandTable[0]} ,//46
	{amdgpu_op_v_max_u16,"v_max_u16",0,&operandTable[0]} ,//47
	{amdgpu_op_v_max_i16,"v_max_i16",0,&operandTable[0]} ,//48
	{amdgpu_op_v_min_u16,"v_min_u16",0,&operandTable[0]} ,//49
	{amdgpu_op_v_min_i16,"v_min_i16",0,&operandTable[0]} ,//50
	{amdgpu_op_v_ldexp_f16,"v_ldexp_f16",0,&operandTable[0]} ,//51
	{amdgpu_op_v_add_u32,"v_add_u32",0,&operandTable[0]} ,//52
	{amdgpu_op_v_sub_u32,"v_sub_u32",0,&operandTable[0]} ,//53
	{amdgpu_op_v_subrev_u32,"v_subrev_u32",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_v_xno2_b32,"v_xno2_b32",0,&operandTable[0]} ,//61
}; // end v_xno2_b32_insn_table

const amdgpu_insn_table amdgpu_insn_entry::vop1_insn_table = {
	{amdgpu_op_v_nop,"v_nop",0,&operandTable[0]} ,//0
	{amdgpu_op_v_mov_b32,"v_mov_b32",0,&operandTable[0]} ,//1
	{amdgpu_op_v_readfirstlane_b32,"v_readfirstlane_b32",0,&operandTable[0]} ,//2
	{amdgpu_op_v_cvt_i32_f64,"v_cvt_i32_f64",0,&operandTable[0]} ,//3
	{amdgpu_op_v_cvt_f64_i32,"v_cvt_f64_i32",0,&operandTable[0]} ,//4
	{amdgpu_op_v_cvt_f32_i32,"v_cvt_f32_i32",0,&operandTable[0]} ,//5
	{amdgpu_op_v_cvt_f32_u32,"v_cvt_f32_u32",0,&operandTable[0]} ,//6
	{amdgpu_op_v_cvt_u32_f32,"v_cvt_u32_f32",0,&operandTable[0]} ,//7
	{amdgpu_op_v_cvt_i32_f32,"v_cvt_i32_f32",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_v_cvt_f16_f32,"v_cvt_f16_f32",0,&operandTable[0]} ,//10
	{amdgpu_op_v_cvt_f32_f16,"v_cvt_f32_f16",0,&operandTable[0]} ,//11
	{amdgpu_op_v_cvt_rpi_i32_f32,"v_cvt_rpi_i32_f32",0,&operandTable[0]} ,//12
	{amdgpu_op_v_cvt_flr_i32_f32,"v_cvt_flr_i32_f32",0,&operandTable[0]} ,//13
	{amdgpu_op_v_cvt_off_f32_i4,"v_cvt_off_f32_i4",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//16
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//17
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//20
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//25
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//32
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//33
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//34
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//35
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//43
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//44
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//45
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//46
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//47
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//48
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//49
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//50
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//51
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//52
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//53
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//61
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//62
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//63
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//64
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//65
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//66
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//67
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//68
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//69
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//70
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//71
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//72
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//73
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//74
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//75
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//76
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//77
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//78
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//79
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//80
	{amdgpu_op_v_swap_b32,"v_swap_b32",0,&operandTable[0]} ,//81
}; // end v_swap_b32_insn_table

const amdgpu_insn_table amdgpu_insn_entry::vopc_insn_table = {
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//0
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//1
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//2
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//3
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//4
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//5
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//6
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//7
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//10
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//11
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_v_cmp_class_f32,"v_cmp_class_f32",0,&operandTable[0]} ,//16
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//17
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//20
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//25
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//32
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//33
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//34
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//35
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//43
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//44
	{amdgpu_op_v_cmp_neq_f16,"v_cmp_neq_f16",0,&operandTable[0]} ,//45
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//46
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//47
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//48
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//49
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//50
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//51
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//52
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//53
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//61
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//62
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//63
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//64
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//65
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//66
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//67
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//68
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//69
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//70
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//71
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//72
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//73
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//74
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//75
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//76
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//77
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//78
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//79
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//80
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//81
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//82
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//83
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//84
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//85
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//86
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//87
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//88
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//89
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//90
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//91
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//92
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//93
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//94
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//95
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//96
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//97
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//98
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//99
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//100
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//101
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//102
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//103
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//104
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//105
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//106
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//107
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//108
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//109
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//110
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//111
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//112
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//113
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//114
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//115
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//116
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//117
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//118
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//119
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//120
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//121
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//122
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//123
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//124
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//125
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//126
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//127
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//128
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//129
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//130
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//131
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//132
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//133
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//134
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//135
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//136
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//137
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//138
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//139
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//140
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//141
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//142
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//143
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//144
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//145
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//146
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//147
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//148
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//149
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//150
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//151
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//152
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//153
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//154
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//155
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//156
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//157
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//158
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//159
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//160
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//161
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//162
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//163
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//164
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//165
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//166
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//167
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//168
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//169
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//170
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//171
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//172
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//173
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//174
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//175
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//176
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//177
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//178
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//179
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//180
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//181
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//182
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//183
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//184
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//185
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//186
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//187
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//188
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//189
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//190
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//191
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//192
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//193
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//194
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//195
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//196
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//197
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//198
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//199
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//200
	{amdgpu_op_v_cmp_lt_u32,"v_cmp_lt_u32",0,&operandTable[0]} ,//201
	{amdgpu_op_v_cmp_eq_u32,"v_cmp_eq_u32",0,&operandTable[0]} ,//202
	{amdgpu_op_v_cmp_le_u32,"v_cmp_le_u32",0,&operandTable[0]} ,//203
	{amdgpu_op_v_cmp_gt_u32,"v_cmp_gt_u32",0,&operandTable[0]} ,//204
	{amdgpu_op_v_cmp_ne_u32,"v_cmp_ne_u32",0,&operandTable[0]} ,//205
	{amdgpu_op_v_cmp_ge_u32,"v_cmp_ge_u32",0,&operandTable[0]} ,//206
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//207
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//208
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//209
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//210
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//211
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//212
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//213
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//214
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//215
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//216
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//217
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//218
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//219
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//220
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//221
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//222
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//223
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//224
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//225
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//226
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//227
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//228
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//229
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//230
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//231
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//232
	{amdgpu_op_v_cmp_lt_u64,"v_cmp_lt_u64",0,&operandTable[0]} ,//233
	{amdgpu_op_v_cmp_eq_u64,"v_cmp_eq_u64",0,&operandTable[0]} ,//234
	{amdgpu_op_v_cmp_le_u64,"v_cmp_le_u64",0,&operandTable[0]} ,//235
	{amdgpu_op_v_cmp_gt_u64,"v_cmp_gt_u64",0,&operandTable[0]} ,//236
	{amdgpu_op_v_cmp_ne_u64,"v_cmp_ne_u64",0,&operandTable[0]} ,//237
	{amdgpu_op_v_cmp_ge_u64,"v_cmp_ge_u64",0,&operandTable[0]} ,//238
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//239
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//240
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//241
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//242
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//243
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//244
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//245
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//246
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//247
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//248
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//249
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//250
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//251
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//252
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//253
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//254
	{amdgpu_op_v_cmpx_t_u64,"v_cmpx_t_u64",0,&operandTable[0]} ,//255
}; // end v_cmpx_t_u64_insn_table

const amdgpu_insn_table amdgpu_insn_entry::vintrp_insn_table = {
	{amdgpu_op_v_interp_p1_f32,"v_interp_p1_f32",0,&operandTable[0]} ,//0
	{amdgpu_op_v_interp_p2_f32,"v_interp_p2_f32",0,&operandTable[0]} ,//1
	{amdgpu_op_v_interp_mov_f32,"v_interp_mov_f32",0,&operandTable[0]} ,//2
}; // end v_interp_mov_f32_insn_table

const amdgpu_insn_table amdgpu_insn_entry::ds_insn_table = {
	{amdgpu_op_ds_add_u32,"ds_add_u32",0,&operandTable[0]} ,//0
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//1
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//2
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//3
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//4
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//5
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//6
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//7
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//10
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//11
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//16
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//17
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//20
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//25
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//32
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//33
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//34
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//35
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//43
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//44
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//45
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//46
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//47
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//48
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//49
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//50
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//51
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//52
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//53
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//61
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//62
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//63
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//64
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//65
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//66
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//67
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//68
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//69
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//70
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//71
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//72
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//73
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//74
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//75
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//76
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//77
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//78
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//79
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//80
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//81
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//82
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//83
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//84
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//85
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//86
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//87
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//88
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//89
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//90
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//91
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//92
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//93
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//94
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//95
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//96
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//97
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//98
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//99
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//100
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//101
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//102
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//103
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//104
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//105
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//106
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//107
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//108
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//109
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//110
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//111
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//112
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//113
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//114
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//115
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//116
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//117
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//118
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//119
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//120
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//121
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//122
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//123
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//124
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//125
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//126
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//127
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//128
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//129
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//130
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//131
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//132
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//133
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//134
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//135
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//136
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//137
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//138
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//139
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//140
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//141
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//142
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//143
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//144
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//145
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//146
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//147
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//148
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//149
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//150
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//151
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//152
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//153
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//154
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//155
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//156
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//157
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//158
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//159
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//160
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//161
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//162
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//163
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//164
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//165
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//166
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//167
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//168
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//169
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//170
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//171
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//172
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//173
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//174
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//175
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//176
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//177
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//178
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//179
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//180
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//181
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//182
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//183
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//184
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//185
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//186
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//187
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//188
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//189
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//190
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//191
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//192
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//193
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//194
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//195
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//196
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//197
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//198
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//199
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//200
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//201
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//202
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//203
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//204
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//205
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//206
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//207
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//208
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//209
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//210
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//211
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//212
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//213
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//214
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//215
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//216
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//217
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//218
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//219
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//220
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//221
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//222
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//223
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//224
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//225
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//226
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//227
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//228
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//229
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//230
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//231
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//232
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//233
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//234
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//235
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//236
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//237
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//238
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//239
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//240
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//241
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//242
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//243
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//244
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//245
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//246
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//247
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//248
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//249
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//250
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//251
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//252
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//253
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//254
	{amdgpu_op_ds_read_b128,"ds_read_b128",0,&operandTable[0]} ,//255
}; // end ds_read_b128_insn_table

const amdgpu_insn_table amdgpu_insn_entry::mtbuf_insn_table = {
	{amdgpu_op_tbuffer_load_format_x,"tbuffer_load_format_x",2,&operandTable[37]} ,//0
	{amdgpu_op_tbuffer_load_format_xy,"tbuffer_load_format_xy",2,&operandTable[39]} ,//1
	{amdgpu_op_tbuffer_load_format_xyz,"tbuffer_load_format_xyz",2,&operandTable[41]} ,//2
	{amdgpu_op_tbuffer_load_format_xyzw,"tbuffer_load_format_xyzw",2,&operandTable[43]} ,//3
	{amdgpu_op_tbuffer_store_format_x,"tbuffer_store_format_x",2,&operandTable[45]} ,//4
	{amdgpu_op_tbuffer_store_format_xy,"tbuffer_store_format_xy",2,&operandTable[47]} ,//5
	{amdgpu_op_tbuffer_store_format_xyz,"tbuffer_store_format_xyz",2,&operandTable[49]} ,//6
	{amdgpu_op_tbuffer_store_format_xyzw,"tbuffer_store_format_xyzw",2,&operandTable[51]} ,//7
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//10
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//11
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_tbuffer_store_format_d16_xyzw,"tbuffer_store_format_d16_xyzw",0,&operandTable[0]} ,//15
}; // end tbuffer_store_format_d16_xyzw_insn_table

const amdgpu_insn_table amdgpu_insn_entry::mubuf_insn_table = {
	{amdgpu_op_buffer_load_format_x,"buffer_load_format_x",2,&operandTable[21]} ,//0
	{amdgpu_op_buffer_load_format_xy,"buffer_load_format_xy",2,&operandTable[23]} ,//1
	{amdgpu_op_buffer_load_format_xyz,"buffer_load_format_xyz",2,&operandTable[25]} ,//2
	{amdgpu_op_buffer_load_format_xyzw,"buffer_load_format_xyzw",2,&operandTable[27]} ,//3
	{amdgpu_op_buffer_store_format_x,"buffer_store_format_x",2,&operandTable[29]} ,//4
	{amdgpu_op_buffer_store_format_xy,"buffer_store_format_xy",2,&operandTable[31]} ,//5
	{amdgpu_op_buffer_store_format_xyz,"buffer_store_format_xyz",2,&operandTable[33]} ,//6
	{amdgpu_op_buffer_store_format_xyzw,"buffer_store_format_xyzw",2,&operandTable[35]} ,//7
	{amdgpu_op_buffer_load_dwordx4,"buffer_load_dwordx4",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//10
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//11
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//16
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//17
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//20
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//25
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//32
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//33
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//34
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//35
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//43
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//44
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//45
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//46
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//47
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//48
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//49
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//50
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//51
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//52
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//53
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//61
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//62
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//63
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//64
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//65
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//66
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//67
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//68
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//69
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//70
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//71
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//72
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//73
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//74
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//75
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//76
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//77
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//78
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//79
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//80
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//81
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//82
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//83
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//84
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//85
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//86
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//87
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//88
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//89
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//90
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//91
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//92
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//93
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//94
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//95
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//96
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//97
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//98
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//99
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//100
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//101
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//102
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//103
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//104
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//105
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//106
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//107
	{amdgpu_op_buffer_atomic_dec_x2,"buffer_atomic_dec_x2",0,&operandTable[0]} ,//108
}; // end buffer_atomic_dec_x2_insn_table

const amdgpu_insn_table amdgpu_insn_entry::vop3ab_insn_table = {
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//0
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//1
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//2
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//3
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//4
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//5
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//6
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//7
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//10
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//11
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_v_cmp_class_f32_e64,"v_cmp_class_f32_e64",0,&operandTable[0]} ,//16
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//17
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//20
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//25
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//32
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//33
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//34
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//35
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//43
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//44
	{amdgpu_op_v_cmp_neq_f16_e64,"v_cmp_neq_f16_e64",0,&operandTable[0]} ,//45
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//46
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//47
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//48
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//49
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//50
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//51
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//52
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//53
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//61
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//62
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//63
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//64
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//65
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//66
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//67
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//68
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//69
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//70
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//71
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//72
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//73
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//74
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//75
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//76
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//77
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//78
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//79
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//80
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//81
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//82
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//83
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//84
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//85
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//86
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//87
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//88
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//89
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//90
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//91
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//92
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//93
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//94
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//95
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//96
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//97
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//98
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//99
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//100
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//101
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//102
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//103
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//104
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//105
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//106
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//107
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//108
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//109
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//110
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//111
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//112
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//113
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//114
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//115
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//116
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//117
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//118
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//119
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//120
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//121
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//122
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//123
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//124
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//125
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//126
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//127
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//128
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//129
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//130
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//131
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//132
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//133
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//134
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//135
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//136
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//137
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//138
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//139
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//140
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//141
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//142
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//143
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//144
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//145
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//146
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//147
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//148
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//149
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//150
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//151
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//152
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//153
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//154
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//155
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//156
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//157
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//158
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//159
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//160
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//161
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//162
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//163
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//164
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//165
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//166
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//167
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//168
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//169
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//170
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//171
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//172
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//173
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//174
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//175
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//176
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//177
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//178
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//179
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//180
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//181
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//182
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//183
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//184
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//185
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//186
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//187
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//188
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//189
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//190
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//191
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//192
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//193
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//194
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//195
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//196
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//197
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//198
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//199
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//200
	{amdgpu_op_v_cmp_lt_u32_e64,"v_cmp_lt_u32_e64",0,&operandTable[0]} ,//201
	{amdgpu_op_v_cmp_eq_u32_e64,"v_cmp_eq_u32_e64",0,&operandTable[0]} ,//202
	{amdgpu_op_v_cmp_le_u32_e64,"v_cmp_le_u32_e64",0,&operandTable[0]} ,//203
	{amdgpu_op_v_cmp_gt_u32_e64,"v_cmp_gt_u32_e64",0,&operandTable[0]} ,//204
	{amdgpu_op_v_cmp_ne_u32_e64,"v_cmp_ne_u32_e64",0,&operandTable[0]} ,//205
	{amdgpu_op_v_cmp_ge_u32_e64,"v_cmp_ge_u32_e64",0,&operandTable[0]} ,//206
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//207
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//208
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//209
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//210
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//211
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//212
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//213
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//214
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//215
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//216
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//217
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//218
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//219
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//220
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//221
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//222
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//223
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//224
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//225
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//226
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//227
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//228
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//229
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//230
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//231
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//232
	{amdgpu_op_v_cmp_lt_u64_e64,"v_cmp_lt_u64_e64",0,&operandTable[0]} ,//233
	{amdgpu_op_v_cmp_eq_u64_e64,"v_cmp_eq_u64_e64",0,&operandTable[0]} ,//234
	{amdgpu_op_v_cmp_le_u64_e64,"v_cmp_le_u64_e64",0,&operandTable[0]} ,//235
	{amdgpu_op_v_cmp_gt_u64_e64,"v_cmp_gt_u64_e64",0,&operandTable[0]} ,//236
	{amdgpu_op_v_cmp_ne_u64_e64,"v_cmp_ne_u64_e64",0,&operandTable[0]} ,//237
	{amdgpu_op_v_cmp_ge_u64_e64,"v_cmp_ge_u64_e64",0,&operandTable[0]} ,//238
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//239
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//240
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//241
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//242
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//243
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//244
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//245
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//246
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//247
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//248
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//249
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//250
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//251
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//252
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//253
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//254
	{amdgpu_op_v_cmpx_t_u64_e64,"v_cmpx_t_u64_e64",0,&operandTable[0]} ,//255
	{amdgpu_op_v_cndmask_b32_e64,"v_cndmask_b32_e64",0,&operandTable[0]} ,//256
	{amdgpu_op_v_add_f32_e64,"v_add_f32_e64",0,&operandTable[0]} ,//257
	{amdgpu_op_v_sub_f32_e64,"v_sub_f32_e64",0,&operandTable[0]} ,//258
	{amdgpu_op_v_subrev_f32_e64,"v_subrev_f32_e64",0,&operandTable[0]} ,//259
	{amdgpu_op_v_mul_legacy_f32_e64,"v_mul_legacy_f32_e64",0,&operandTable[0]} ,//260
	{amdgpu_op_v_mul_f32_e64,"v_mul_f32_e64",0,&operandTable[0]} ,//261
	{amdgpu_op_v_mul_i32_i24_e64,"v_mul_i32_i24_e64",0,&operandTable[0]} ,//262
	{amdgpu_op_v_mul_hi_i32_i24_e64,"v_mul_hi_i32_i24_e64",0,&operandTable[0]} ,//263
	{amdgpu_op_v_mul_u32_u24_e64,"v_mul_u32_u24_e64",0,&operandTable[0]} ,//264
	{amdgpu_op_v_mul_hi_u32_u24_e64,"v_mul_hi_u32_u24_e64",0,&operandTable[0]} ,//265
	{amdgpu_op_v_min_f32_e64,"v_min_f32_e64",0,&operandTable[0]} ,//266
	{amdgpu_op_v_max_f32_e64,"v_max_f32_e64",0,&operandTable[0]} ,//267
	{amdgpu_op_v_min_i32_e64,"v_min_i32_e64",0,&operandTable[0]} ,//268
	{amdgpu_op_v_max_i32_e64,"v_max_i32_e64",0,&operandTable[0]} ,//269
	{amdgpu_op_v_min_u32_e64,"v_min_u32_e64",0,&operandTable[0]} ,//270
	{amdgpu_op_v_max_u32_e64,"v_max_u32_e64",0,&operandTable[0]} ,//271
	{amdgpu_op_v_lshrrev_b32_e64,"v_lshrrev_b32_e64",0,&operandTable[0]} ,//272
	{amdgpu_op_v_ashrrev_i32_e64,"v_ashrrev_i32_e64",0,&operandTable[0]} ,//273
	{amdgpu_op_v_lshlrev_b32_e64,"v_lshlrev_b32_e64",0,&operandTable[0]} ,//274
	{amdgpu_op_v_add_b32_e64,"v_add_b32_e64",0,&operandTable[0]} ,//275
	{amdgpu_op_v_or_b32_e64,"v_or_b32_e64",0,&operandTable[0]} ,//276
	{amdgpu_op_v_xor_b32_e64,"v_xor_b32_e64",0,&operandTable[0]} ,//277
	{amdgpu_op_v_mac_b32_e64,"v_mac_b32_e64",0,&operandTable[0]} ,//278
	{amdgpu_op_v_madmk_f32_e64,"v_madmk_f32_e64",0,&operandTable[0]} ,//279
	{amdgpu_op_v_madak_f32_e64,"v_madak_f32_e64",0,&operandTable[0]} ,//280
	{amdgpu_op_v_add_co_u32_e64,"v_add_co_u32_e64",0,&operandTable[0]} ,//281
	{amdgpu_op_v_sub_co_u32_e64,"v_sub_co_u32_e64",0,&operandTable[0]} ,//282
	{amdgpu_op_v_subrev_co_u32_e64,"v_subrev_co_u32_e64",0,&operandTable[0]} ,//283
	{amdgpu_op_v_addc_co_u32_e64,"v_addc_co_u32_e64",0,&operandTable[0]} ,//284
	{amdgpu_op_v_subb_co_u32_e64,"v_subb_co_u32_e64",0,&operandTable[0]} ,//285
	{amdgpu_op_v_subbrev_co_u32_e64,"v_subbrev_co_u32_e64",0,&operandTable[0]} ,//286
	{amdgpu_op_v_add_f16_e64,"v_add_f16_e64",0,&operandTable[0]} ,//287
	{amdgpu_op_v_sub_f16_e64,"v_sub_f16_e64",0,&operandTable[0]} ,//288
	{amdgpu_op_v_subrev_f16_e64,"v_subrev_f16_e64",0,&operandTable[0]} ,//289
	{amdgpu_op_v_mul_f16_e64,"v_mul_f16_e64",0,&operandTable[0]} ,//290
	{amdgpu_op_v_mac_f16_e64,"v_mac_f16_e64",0,&operandTable[0]} ,//291
	{amdgpu_op_v_madmk_f16_e64,"v_madmk_f16_e64",0,&operandTable[0]} ,//292
	{amdgpu_op_v_madak_f16_e64,"v_madak_f16_e64",0,&operandTable[0]} ,//293
	{amdgpu_op_v_add_u16_e64,"v_add_u16_e64",0,&operandTable[0]} ,//294
	{amdgpu_op_v_sub_u16_e64,"v_sub_u16_e64",0,&operandTable[0]} ,//295
	{amdgpu_op_v_subrev_u16_e64,"v_subrev_u16_e64",0,&operandTable[0]} ,//296
	{amdgpu_op_v_mul_lo_u16_e64,"v_mul_lo_u16_e64",0,&operandTable[0]} ,//297
	{amdgpu_op_v_lshlrev_b16_e64,"v_lshlrev_b16_e64",0,&operandTable[0]} ,//298
	{amdgpu_op_v_lshrrev_b16_e64,"v_lshrrev_b16_e64",0,&operandTable[0]} ,//299
	{amdgpu_op_v_ashrrev_i16_e64,"v_ashrrev_i16_e64",0,&operandTable[0]} ,//300
	{amdgpu_op_v_max_f16_e64,"v_max_f16_e64",0,&operandTable[0]} ,//301
	{amdgpu_op_v_min_f16_e64,"v_min_f16_e64",0,&operandTable[0]} ,//302
	{amdgpu_op_v_max_u16_e64,"v_max_u16_e64",0,&operandTable[0]} ,//303
	{amdgpu_op_v_max_i16_e64,"v_max_i16_e64",0,&operandTable[0]} ,//304
	{amdgpu_op_v_min_u16_e64,"v_min_u16_e64",0,&operandTable[0]} ,//305
	{amdgpu_op_v_min_i16_e64,"v_min_i16_e64",0,&operandTable[0]} ,//306
	{amdgpu_op_v_ldexp_f16_e64,"v_ldexp_f16_e64",0,&operandTable[0]} ,//307
	{amdgpu_op_v_add_u32_e64,"v_add_u32_e64",0,&operandTable[0]} ,//308
	{amdgpu_op_v_sub_u32_e64,"v_sub_u32_e64",0,&operandTable[0]} ,//309
	{amdgpu_op_v_subrev_u32_e64,"v_subrev_u32_e64",0,&operandTable[0]} ,//310
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//311
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//312
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//313
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//314
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//315
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//316
	{amdgpu_op_v_xno2_b32_e64,"v_xno2_b32_e64",0,&operandTable[0]} ,//317
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//318
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//319
	{amdgpu_op_v_nop_e64,"v_nop_e64",0,&operandTable[0]} ,//320
	{amdgpu_op_v_mov_b32_e64,"v_mov_b32_e64",0,&operandTable[0]} ,//321
	{amdgpu_op_v_readfirstlane_b32_e64,"v_readfirstlane_b32_e64",0,&operandTable[0]} ,//322
	{amdgpu_op_v_cvt_i32_f64_e64,"v_cvt_i32_f64_e64",0,&operandTable[0]} ,//323
	{amdgpu_op_v_cvt_f64_i32_e64,"v_cvt_f64_i32_e64",0,&operandTable[0]} ,//324
	{amdgpu_op_v_cvt_f32_i32_e64,"v_cvt_f32_i32_e64",0,&operandTable[0]} ,//325
	{amdgpu_op_v_cvt_f32_u32_e64,"v_cvt_f32_u32_e64",0,&operandTable[0]} ,//326
	{amdgpu_op_v_cvt_u32_f32_e64,"v_cvt_u32_f32_e64",0,&operandTable[0]} ,//327
	{amdgpu_op_v_cvt_i32_f32_e64,"v_cvt_i32_f32_e64",0,&operandTable[0]} ,//328
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//329
	{amdgpu_op_v_cvt_f16_f32_e64,"v_cvt_f16_f32_e64",0,&operandTable[0]} ,//330
	{amdgpu_op_v_cvt_f32_f16_e64,"v_cvt_f32_f16_e64",0,&operandTable[0]} ,//331
	{amdgpu_op_v_cvt_rpi_i32_f32_e64,"v_cvt_rpi_i32_f32_e64",0,&operandTable[0]} ,//332
	{amdgpu_op_v_cvt_flr_i32_f32_e64,"v_cvt_flr_i32_f32_e64",0,&operandTable[0]} ,//333
	{amdgpu_op_v_cvt_off_f32_i4_e64,"v_cvt_off_f32_i4_e64",0,&operandTable[0]} ,//334
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//335
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//336
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//337
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//338
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//339
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//340
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//341
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//342
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//343
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//344
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//345
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//346
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//347
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//348
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//349
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//350
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//351
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//352
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//353
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//354
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//355
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//356
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//357
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//358
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//359
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//360
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//361
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//362
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//363
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//364
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//365
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//366
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//367
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//368
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//369
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//370
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//371
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//372
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//373
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//374
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//375
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//376
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//377
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//378
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//379
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//380
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//381
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//382
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//383
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//384
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//385
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//386
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//387
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//388
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//389
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//390
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//391
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//392
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//393
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//394
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//395
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//396
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//397
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//398
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//399
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//400
	{amdgpu_op_v_swap_b32_e64,"v_swap_b32_e64",0,&operandTable[0]} ,//401
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//402
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//403
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//404
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//405
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//406
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//407
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//408
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//409
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//410
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//411
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//412
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//413
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//414
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//415
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//416
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//417
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//418
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//419
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//420
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//421
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//422
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//423
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//424
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//425
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//426
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//427
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//428
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//429
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//430
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//431
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//432
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//433
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//434
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//435
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//436
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//437
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//438
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//439
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//440
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//441
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//442
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//443
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//444
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//445
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//446
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//447
	{amdgpu_op_v_mad_legacy_f32,"v_mad_legacy_f32",0,&operandTable[0]} ,//448
	{amdgpu_op_v_mad_f32,"v_mad_f32",0,&operandTable[0]} ,//449
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//450
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//451
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//452
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//453
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//454
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//455
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//456
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//457
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//458
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//459
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//460
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//461
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//462
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//463
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//464
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//465
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//466
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//467
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//468
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//469
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//470
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//471
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//472
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//473
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//474
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//475
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//476
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//477
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//478
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//479
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//480
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//481
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//482
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//483
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//484
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//485
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//486
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//487
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//488
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//489
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//490
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//491
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//492
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//493
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//494
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//495
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//496
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//497
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//498
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//499
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//500
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//501
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//502
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//503
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//504
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//505
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//506
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//507
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//508
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//509
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//510
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//511
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//512
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//513
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//514
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//515
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//516
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//517
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//518
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//519
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//520
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//521
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//522
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//523
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//524
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//525
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//526
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//527
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//528
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//529
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//530
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//531
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//532
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//533
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//534
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//535
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//536
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//537
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//538
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//539
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//540
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//541
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//542
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//543
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//544
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//545
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//546
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//547
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//548
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//549
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//550
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//551
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//552
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//553
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//554
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//555
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//556
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//557
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//558
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//559
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//560
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//561
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//562
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//563
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//564
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//565
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//566
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//567
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//568
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//569
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//570
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//571
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//572
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//573
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//574
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//575
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//576
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//577
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//578
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//579
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//580
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//581
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//582
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//583
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//584
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//585
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//586
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//587
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//588
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//589
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//590
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//591
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//592
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//593
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//594
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//595
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//596
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//597
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//598
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//599
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//600
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//601
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//602
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//603
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//604
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//605
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//606
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//607
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//608
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//609
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//610
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//611
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//612
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//613
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//614
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//615
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//616
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//617
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//618
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//619
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//620
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//621
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//622
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//623
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//624
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//625
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//626
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//627
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//628
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//629
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//630
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//631
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//632
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//633
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//634
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//635
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//636
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//637
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//638
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//639
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//640
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//641
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//642
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//643
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//644
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//645
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//646
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//647
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//648
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//649
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//650
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//651
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//652
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//653
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//654
	{amdgpu_op_v_lshlrev_b64,"v_lshlrev_b64",0,&operandTable[0]} ,//655
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//656
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//657
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//658
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//659
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//660
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//661
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//662
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//663
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//664
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//665
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//666
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//667
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//668
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//669
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//670
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//671
	{amdgpu_op_v_pack_b32_f16,"v_pack_b32_f16",0,&operandTable[0]} ,//672
}; // end v_pack_b32_f16_insn_table

const amdgpu_insn_table amdgpu_insn_entry::vop3p_insn_table = {
	{amdgpu_op_v_pk_mad_i16,"v_pk_mad_i16",0,&operandTable[0]} ,//0
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//1
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//2
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//3
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//4
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//5
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//6
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//7
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//10
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//11
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//16
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//17
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//20
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//25
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//32
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//33
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//34
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//35
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_v_dot8_u32_u4,"v_dot8_u32_u4",0,&operandTable[0]} ,//43
}; // end v_dot8_u32_u4_insn_table

const amdgpu_insn_table amdgpu_insn_entry::flat_insn_table = {
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//0
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//1
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//2
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//3
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//4
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//5
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//6
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//7
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//8
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//9
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//10
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//11
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//12
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//13
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//14
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//15
	{amdgpu_op_load_ubyte,"load_ubyte",0,&operandTable[0]} ,//16
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//17
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//18
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//19
	{amdgpu_op_load_dword,"load_dword",0,&operandTable[0]} ,//20
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//21
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//22
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//23
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//24
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//25
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//26
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//27
	{amdgpu_op_store_dword,"store_dword",0,&operandTable[0]} ,//28
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//29
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//30
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//31
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//32
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//33
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//34
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//35
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//36
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//37
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//38
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//39
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//40
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//41
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//42
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//43
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//44
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//45
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//46
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//47
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//48
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//49
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//50
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//51
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//52
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//53
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//54
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//55
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//56
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//57
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//58
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//59
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//60
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//61
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//62
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//63
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//64
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//65
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//66
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//67
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//68
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//69
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//70
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//71
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//72
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//73
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//74
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//75
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//76
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//77
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//78
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//79
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//80
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//81
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//82
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//83
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//84
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//85
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//86
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//87
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//88
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//89
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//90
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//91
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//92
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//93
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//94
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//95
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//96
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//97
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//98
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//99
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//100
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//101
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//102
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//103
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//104
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//105
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//106
	{amdgpu_op_s_nop,"s_nop",0,&operandTable[0]} ,//107
	{amdgpu_op_atomic_dec_x2,"atomic_dec_x2",0,&operandTable[0]} ,//108
}; // end atomic_dec_x2_insn_table

