/* $Copyright:
 *
 * Copyright 1998-2000 by the Massachusetts Institute of Technology.
 * 
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Furthermore if you modify
 * this software you must label your software as modified software and not
 * distribute it in such a fashion that it might be confused with the
 * original MIT software. M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Individual source code files are copyright MIT, Cygnus Support,
 * OpenVision, Oracle, Sun Soft, FundsXpress, and others.
 * 
 * Project Athena, Athena, Athena MUSE, Discuss, Hesiod, Kerberos, Moira,
 * and Zephyr are trademarks of the Massachusetts Institute of Technology
 * (MIT).  No commercial use of these trademarks may be made without prior
 * written permission of MIT.
 * 
 * "Commercial use" means use of a name in a product or other for-profit
 * manner.  It does NOT prevent a commercial firm from referring to the MIT
 * trademarks in order to convey information (although in doing so,
 * recognition of their trademark status should be given).
 * $
 */

/* $Header: /cvs/src/sasl/mac/CommonKClient/mac_kclient3/Headers/KerberosSupport/ErrorLib.h,v 1.2 2001/12/04 02:05:56 rjs3 Exp $ */

/* 
 *
 * errorlib.h -- Functions to handle socket/dns lib errors.
 *
 */


#ifndef __ERRORLIB__
#define __ERRORLIB__

#include <KerberosSupport/KerberosConditionalMacros.h>

#if TARGET_RT_MAC_CFM
    #if TARGET_API_MAC_CARBON
        #include <CoreServices.h>
    #endif

    #include <MacTypes.h>
    #include <Files.h>
#else
    #include <CoreServices/CoreServices.h>
#endif

#include <errno.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif


/* ********************* */
/* The global error code */
/* ********************* */
extern OSStatus gMITLibError;


/* ****************************************************** */
/* length the buffer passed to GetErrorString() should be */
/* ****************************************************** */
#define kMaxErrorLength 512


/* ******************* */
/* type of error table */
/* ******************* */
#define kErrorTableResType 'ErrT'


/* *********************************************** */
/* Format of the error string for GetErrorString() */
/* *********************************************** */
enum ErrorFormat 
{
  kErrorLongFormat,
  kErrorShortFormat,
  kErrorManager,
  kErrorShortString,
  kErrorLongString
};
typedef enum ErrorFormat ErrorFormat;

/* ******************* */
/* Function prototypes */
/* ******************* */

#if !TARGET_RT_MAC_CFM
#   pragma d0_pointers on
#else
#   define ErrorLibraryIsPresent() ((Ptr) (RegisterErrorTable) != (Ptr) (kUnresolvedCFragSymbolAddress))
#endif

extern OSStatus GetMITLibError(void);
extern void SetMITLibError(OSStatus theError);
extern void ClearMITLibError(void);

extern OSStatus RegisterErrorTable(const FSSpec* inResFile, SInt16 inResID);
#if TARGET_API_MAC_CARBON
extern OSStatus RegisterErrorTableForBundle(CFStringRef inBundleID, SInt16 inResID);
#endif

extern OSStatus GetErrorLongFormat(OSStatus error, char *message, long messageLength);
extern OSStatus GetErrorShortFormat(OSStatus error, char *message, long messageLength);
extern OSStatus GetErrorManager(OSStatus error, char *message, long messageLength);
extern OSStatus GetErrorShortString(OSStatus error, char *message, long messageLength);
extern OSStatus GetErrorLongString(OSStatus error, char *message, long messageLength);

extern OSStatus GetErrorString(OSStatus error, char *message, long messageLength, ErrorFormat format);

#if !TARGET_RT_MAC_CFM
#   pragma d0_pointers reset
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif /* __ERRORLIB__ */
