//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.

//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.

#include "terminalparser.hpp"
#include <iostream>
#include "configuration.hpp"
using namespace Stikkit;
using namespace std;

TerminalParser::TerminalParser(int argc, char *argv[])
{
    this->argc = argc;
    this->argv = argv;
}

bool TerminalParser::Parse()
{
    int x = 1;
    while (x < this->argc)
    {
        bool valid = false;
        string text = string(this->argv[x]);
        if (text == "-h" || text == "--help")
        {
            DisplayHelp();
            return true;
        }
        if (text.length() > 1 && text[0] == ('-') && text[1] != ('-'))
        {
            text = text.substr(1);
            while (text.length())
            {
                if (this->ParseChar(text.at(0)))
                {
                    return true;
                } else if (text.at(0) == 'a')
                {
                    if (this->argc > x + 1 && !this->argv[x + 1][0] != '-')
                    {
                        x++;
                        Configuration::Author = this->argv[x];
                    } else
                    {
                        cerr << "Parameter -a requires an argument for it to work!" << endl;
                        return true;
                    }
                } else if (text.at(0) == 'b')
                {
                    if (this->argc > x + 1 && !this->argv[x + 1][0] != '-')
                    {
                        x++;
                        Configuration::URL = this->argv[x];
                    } else
                    {
                        cerr << "Parameter -b requires an argument for it to work!" << endl;
                        return true;
                    }
                } else if (text.at(0) == 't')
                {
                    if (this->argc > x + 1 && !this->argv[x + 1][0] != '-')
                    {
                        x++;
                        Configuration::Title = this->argv[x];
                    } else
                    {
                        cerr << "Parameter -t requires an argument for it to work!" << endl;
                        return true;
                    }
                } else if (text.at(0) == 'e')
                {
                    if (this->argc > x + 1 && !this->argv[x + 1][0] != '-')
                    {
                        x++;
                        Configuration::Expiry = this->argv[x];
                    } else
                    {
                        cerr << "Parameter -e requires an argument for it to work!" << endl;
                        return true;
                    }
                } else if (text.at(0) == 'i')
                {
                    if (this->argc > x + 1 && !this->argv[x + 1][0] != '-')
                    {
                        x++;
                        Configuration::Input = this->argv[x];
                    } else
                    {
                        cerr << "Parameter -i requires an argument for it to work!" << endl;
                        return true;
                    }
                } else if (text.at(0) == 'k')
                {
                    if (this->argc > x + 1 && !this->argv[x + 1][0] != '-')
                    {
                        x++;
                        Configuration::Apikey = this->argv[x];
                    } else
                    {
                        cerr << "Parameter -k requires an argument for it to work!" << endl;
                        return true;
                    }
                } else if (text.at(0) == 'l')
                {
                    if (this->argc > x + 1 && !this->argv[x + 1][0] != '-')
                    {
                        x++;
                        Configuration::Lang = this->argv[x];
                    } else
                    {
                        cerr << "Parameter -l requires an argument for it to work!" << endl;
                        return true;
                    }
                }
                text = text.substr(1);
            }
            valid = true;
        }
        if (text == "--version")
        {
            cout << "cpaste " << Configuration::Version << endl;
            return true;
        }
        if (!valid)
        {
            cerr << "This parameter isn't valid: " << text << endl;
            return true;
        }
        x++;
    }
    return false;
}

bool TerminalParser::ParseChar(char x)
{
    switch (x)
    {
        case 'v':
            Configuration::Verbosity++;
            return false;
        case 'h':
            this->DisplayHelp();
            return true;
        case 'p':
            Configuration::Private = true;
            return false;
        case 's':
            Configuration::NoExtras = true;
            return false;
    }
    return false;
}

void TerminalParser::DisplayHelp()
{
    cout << "cpaste - open source pastebin uploader for Stikked\n\n"\
            "Parameters:\n"\
            "  -a <name>:       Specify author name by default the current\n"\
            "                   OS username is used\n"\
            "  -b <url>:        Specify URL of Stikked server\n"\
            "  -i <file>:       Upload a content of specified file\n"\
            "  -v:              Increases verbosity\n"\
            "  -t <title>:      Set a title for a paste\n"\
            "  -p:              Mark a paste as private (not visible in recent pastes)\n"\
            "  -s:              Display only RAW url of paste and no extra text\n"\
            "  -e <minutes>:    Set expiry in minutes, parameter needs\n"\
            "                   to be a number, default: unlimited time\n"\
            "  -k <apikey>:     Set api key for current server\n"\
            "  -l <lang>:       Set paste lang for syntax highlighting\n"\
            "  --version:       Display a version\n"\
            "  -h | --help:     Display this help\n\n"\
            "Note: every argument in [brackets] is optional\n"\
            "      but argument in <brackets> is required\n\n"\
            "cpaste is based on Petr Bena's stikkit client\n\n"\
            "Stikkit is open source, contribute at https://github.com/benapetr/stikkit" << endl;
}
