# Manual - console-login-helper-messages

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**  *generated with [DocToc](https://github.com/thlorenz/doctoc)*

- [Architecture overview](#architecture-overview)
- [Installation](#installation)
  - [Packaging](#packaging)
  - [Integrating into a distribution](#integrating-into-a-distribution)
    - [Upstream tools' requirements](#upstream-tools-requirements)
- [Common operations](#common-operations)
  - [Enabling messages](#enabling-messages)
  - [Appending messages](#appending-messages)
  - [Disabling messages](#disabling-messages)
- [Troubleshooting](#troubleshooting)
  - [Recreating the symlinks](#recreating-the-symlinks)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Architecture overview

By default, `console-login-helper-messages` provides several units and scripts
for displaying helpful messages before or upon login. Currently, the following
messages are displayed:
- issuegen:
  - SSH keys (before login)
  - Network interface information (before login)
- motdgen:
  - OS release information (at login)
- profile:
  - Failed systemd units (at login)

The following default units and scripts are in charge of generating the information
that needs to be displayed in a MOTD or issue, and displaying the sourced information
upon and before login:
  - `console-login-helper-messages-gensnippet-ssh-keys.service` (SSH keys)
  - `etc/NetworkManager/dispatcher.d/90-console-login-helper-messages-gensnippet-if` (Network interface info)
  - `console-login-helper-messages-gensnippet-os-release.service` (OS release info)
  - `share/profile.sh` (Failed systemd units)

## Installation

To test out the latest RPMs in Fedora, run:

```
dnf install \
  console-login-helper-messages-issuegen \
  console-login-helper-messages-motdgen \
  console-login-helper-messages-profile
```

### Packaging

In Fedora, the console-login-helper-messages package is grouped via
subpackages in the following way:

| package                                | function |
| -------------------------------------- | -------- |
| console-login-helper-messages          | base directory layout for this packge (required by all subpackages) |
| console-login-helper-messages-issuegen | messages shown before login via serial console using issue (SSH keys, IP address for SSH) |
| console-login-helper-messages-motdgen  | messages shown using the motd paths at login (OS release information) |
| console-login-helper-messages-profile  | messages shown using /etc/profile.d script, shown on login to bash terminal (failed systemd units) |

The `install` target of the [Makefile](../Makefile) is the source of truth
on where files should be placed.

### Integrating into a distribution

The following must be met to ship `console-login-helper-messages` by
default as part of a distribution. These instructions apply to Fedora
only as packages are only available in Fedora, currently.

First, list the names of the subpackages to include in the manifest
of base packages for the distribution (this may vary depending on the
build system). **Each individual subpackage being included must be
requested**, e.g. to install all of `issuegen`, `motdgen`, and
`profile`, list the following:

```
- console-login-helper-messages-issuegen
- console-login-helper-messages-motdgen
- console-login-helper-messages-profile
```

Second, add a systemd preset to enable units for specific pieces of information
(see [all available units](/usr/lib/systemd/system)).
E.g.:

```
# /usr/lib/systemd/system-preset/40-console-login-helper-messages.preset

enable console-login-helper-messages-gensnippet-os-release.service
enable console-login-helper-messages-gensnippet-ssh-keys.service
```

#### Upstream tools' requirements
The following conditions must be met for displaying the issue and motd files
sourced by console-login-helper-messages:

| package          | version      | reason |
| ---------------- | ------------ | ------ |
| `util-linux`     | >= 2.36      | `agetty` and `login` programs need to be able to read from `issue.d` and `motd.d` directories |
| `pam`            | >= 1.3.1-15  | `pam_motd` PAM module needs to be able to read from `motd.d` directory |
| `selinux-policy` | >= 3.14.3-23 | allow `/run/motd.d` location to be usable |

To enable displaying issue snippets _before_ login (via the _console_),
let `/etc/issue.d` be one of the directories that
[`agetty`](https://man7.org/linux/man-pages/man8/agetty.8.html)
reads from. `agetty` reads from `/etc/issue.d` if `/etc/issue` exists. Thus, in
order for issue files generated by `console-login-helper-messages` to be
displayed properly, please ensure that `/etc/issue` exists.
Note: As of `systemd-246.6`, it is virtually impossible to remove `/etc/issue`
on systemd distros. https://github.com/systemd/systemd/commit/062666c7c452711f3e38efdec0c2b952ced64d06

To enable displaying MOTD snippets _after_ login via the _console_, in
`/etc/login.defs`, make sure that `/run/motd.d` is one of the directories that
[`login`](https://man7.org/linux/man-pages/man1/login.1.html)
reads from. The default value is
`"/usr/share/misc/motd:/run/motd:/etc/motd"`.

Example:
```
MOTD_FILE=/run/motd.d
```

To enable displaying MOTD snippets _after_ login via _ssh_, in `/etc/pam.d/login`,
make sure that `/run/motd.d` is one of the directories that
[pam_motd](https://man7.org/linux/man-pages/man8/pam_motd.8.html)
reads from. The default is `/etc/motd.d:/run/motd.d:/usr/lib/motd.d`, so no further
configuration is necessary if defaults have not been changed.

Example:
```
session  optional  pam_motd.so motd_dir=/run/motd.d
```

## Common operations

### Enabling messages

Generation of individual information snippets, such as OS release
information and SSH keys, can be enabled individually as follows:

```
# read by motdgen
systemctl enable console-login-helper-messages-gensnippet-os-release.service

# read by issuegen
systemctl enable console-login-helper-messages-gensnippet-ssh-keys.service
```

Network interface information is shown via a
[NetworkManager Dispatcher script](/etc/NetworkManager/dispatcher.d/90-console-login-helper-messages-gensnippet_if),
and will display in `issue` by default.

On systems where NetworkManager is unavailable, udev rules could be used to
detect new interfaces being added/removed. Udev rules are disabled by default and
do not support complex networking devices or network interfaces with custom names.

The `profile` messages are enabled by default by a symlink from
`/etc/profile.d` at install.

### Appending messages

Appending messages via console-login-helper-messages is no longer supported.
However, provided that the configurations described in
[Integrating into a distribution](#integrating-into-a-distribution) are configured
and the right versions of upstream tools are installed, then:

- To have a message appended to the MOTD, the files to append can be dropped
  in `/etc/motd.d/`.
- To have a message appended to the issue, the files to append can be dropped
  in `/etc/issue.d/`.

### Disabling messages

The default OS release information and SSH keys may be individually
disabled from showing in the motd/issue individually:

```
# disable OS release information from motd
systemctl disable console-login-helper-messages-gensnippet-os-release.service

# disable SSH keys from issue
systemctl disable console-login-helper-messages-gensnippet-ssh-keys.service
```

The `profile` messages (failed systemd units) can be disabled only by uninstalling
`console-login-helper-messages-profile`.

The network interface information can only be disabled by uninstalling
`console-login-helper-messages-issuegen`.

## Troubleshooting

### Recreating the symlinks

If a message is not showing, it could be because a symlink required to
show the message was deleted. To recreate the symlinks, the following
command can be used:

```
systemd-tmpfiles --create
```

Otherwise, please [open an issue](https://github.com/coreos/console-login-helper-messages/issues/new)
describing the problem.
