/* Mapping tables for ASIANUNI handling.
   Copyright (C) 1997, 1998, 1999, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Ulrich Drepper <drepper@cygnus.com>, 1997.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
   by: Salvador Sabanal, LinuxLab SAP AG <salvador.sabanal@sap.com> 
   Date: Nov. 19, 1999
*/

#include <stdint.h>
#include <wchar.h>

static const uint16_t to_ucs4_lat1[128] =
{
  [   0] = 0x0000, [   1] = 0x0001, [   2] = 0x0002, [   3] = 0x0003,
  [   4] = 0x0004, [   5] = 0x0005, [   6] = 0x0006, [   7] = 0x0007,
  [   8] = 0x0008, [   9] = 0x0009, [  10] = 0x000A, [  11] = 0x000B,
  [  12] = 0x000C, [  13] = 0x000D, [  14] = 0x000E, [  15] = 0x000F,
  [  16] = 0x0010, [  17] = 0x0011, [  18] = 0x0012, [  19] = 0x0013,
  [  20] = 0x0014, [  21] = 0x0015, [  22] = 0x0016, [  23] = 0x0017,
  [  24] = 0x0018, [  25] = 0x0019, [  26] = 0x001A, [  27] = 0x001B,
  [  28] = 0x001C, [  29] = 0x001D, [  30] = 0x001E, [  31] = 0x001F,
  [  32] = 0x0020, [  33] = 0x0021, [  34] = 0x0022, [  35] = 0x0023,
  [  36] = 0x0024, [  37] = 0x0025, [  38] = 0x0026, [  39] = 0x0027,
  [  40] = 0x0028, [  41] = 0x0029, [  42] = 0x002A, [  43] = 0x002B,
  [  44] = 0x002C, [  45] = 0x002D, [  46] = 0x002E, [  47] = 0x002F,
  [  48] = 0x0030, [  49] = 0x0031, [  50] = 0x0032, [  51] = 0x0033,
  [  52] = 0x0034, [  53] = 0x0035, [  54] = 0x0036, [  55] = 0x0037,
  [  56] = 0x0038, [  57] = 0x0039, [  58] = 0x003A, [  59] = 0x003B,
  [  60] = 0x003C, [  61] = 0x003D, [  62] = 0x003E, [  63] = 0x003F,
  [  64] = 0x0040, [  65] = 0x0041, [  66] = 0x0042, [  67] = 0x0043,
  [  68] = 0x0044, [  69] = 0x0045, [  70] = 0x0046, [  71] = 0x0047,
  [  72] = 0x0048, [  73] = 0x0049, [  74] = 0x004A, [  75] = 0x004B,
  [  76] = 0x004C, [  77] = 0x004D, [  78] = 0x004E, [  79] = 0x004F,
  [  80] = 0x0050, [  81] = 0x0051, [  82] = 0x0052, [  83] = 0x0053,
  [  84] = 0x0054, [  85] = 0x0055, [  86] = 0x0056, [  87] = 0x0057,
  [  88] = 0x0058, [  89] = 0x0059, [  90] = 0x005A, [  91] = 0x005B,
  [  92] = 0x005C, [  93] = 0x005D, [  94] = 0x005E, [  95] = 0x005F,
  [  96] = 0x0060, [  97] = 0x0061, [  98] = 0x0062, [  99] = 0x0063,
  [ 100] = 0x0064, [ 101] = 0x0065, [ 102] = 0x0066, [ 103] = 0x0067,
  [ 104] = 0x0068, [ 105] = 0x0069, [ 106] = 0x006A, [ 107] = 0x006B,
  [ 108] = 0x006C, [ 109] = 0x006D, [ 110] = 0x006E, [ 111] = 0x006F,
  [ 112] = 0x0070, [ 113] = 0x0071, [ 114] = 0x0072, [ 115] = 0x0073,
  [ 116] = 0x0074, [ 117] = 0x0075, [ 118] = 0x0076, [ 119] = 0x0077,
  [ 120] = 0x0078, [ 121] = 0x0079, [ 122] = 0x007A, [ 123] = 0x007B,
  [ 124] = 0x007C, [ 125] = 0x007D, [ 126] = 0x007E, [ 127] = 0x007F
};

static const uint16_t to_ucs4_asianuni[32191] =
{
  [   0] = 0x8140, [   1] = 0x8141, [   2] = 0x8142, [   3] = 0x8143,
  [   4] = 0x8144, [   5] = 0x8145, [   6] = 0x8146, [   7] = 0x8147,
  [   8] = 0x8148, [   9] = 0x8149, [  10] = 0x814A, [  11] = 0x814B,
  [  12] = 0x814C, [  13] = 0x814D, [  14] = 0x814E, [  15] = 0x814F,
  [  16] = 0x8150, [  17] = 0x8151, [  18] = 0x8152, [  19] = 0x8153,
  [  20] = 0x8154, [  21] = 0x8155, [  22] = 0x8156, [  23] = 0x8157,
  [  24] = 0x8158, [  25] = 0x8159, [  26] = 0x815A, [  27] = 0x815B,
  [  28] = 0x815C, [  29] = 0x815D, [  30] = 0x815E, [  31] = 0x815F,
  [  32] = 0x8160, [  33] = 0x8161, [  34] = 0x8162, [  35] = 0x8163,
  [  36] = 0x8164, [  37] = 0x8165, [  38] = 0x8166, [  39] = 0x8167,
  [  40] = 0x8168, [  41] = 0x8169, [  42] = 0x816A, [  43] = 0x816B,
  [  44] = 0x816C, [  45] = 0x816D, [  46] = 0x816E, [  47] = 0x816F,
  [  48] = 0x8170, [  49] = 0x8171, [  50] = 0x8172, [  51] = 0x8173,
  [  52] = 0x8174, [  53] = 0x8175, [  54] = 0x8176, [  55] = 0x8177,
  [  56] = 0x8178, [  57] = 0x8179, [  58] = 0x817A, [  59] = 0x817B,
  [  60] = 0x817C, [  61] = 0x817D, [  62] = 0x817E, [  64] = 0x8180,
  [  65] = 0x8181, [  66] = 0x8182, [  67] = 0x8183, [  68] = 0x8184,
  [  69] = 0x8185, [  70] = 0x8186, [  71] = 0x8187, [  72] = 0x8188,
  [  73] = 0x8189, [  74] = 0x818A, [  75] = 0x818B, [  76] = 0x818C,
  [  77] = 0x818D, [  78] = 0x818E, [  79] = 0x818F, [  80] = 0x8190,
  [  81] = 0x8191, [  82] = 0x8192, [  83] = 0x8193, [  84] = 0x8194,
  [  85] = 0x8195, [  86] = 0x8196, [  87] = 0x8197, [  88] = 0x8198,
  [  89] = 0x8199, [  90] = 0x819A, [  91] = 0x819B, [  92] = 0x819C,
  [  93] = 0x819D, [  94] = 0x819E, [  95] = 0x819F, [  96] = 0x81A0,
  [  97] = 0x81A1, [  98] = 0x81A2, [  99] = 0x81A3, [ 100] = 0x81A4,
  [ 101] = 0x81A5, [ 102] = 0x81A6, [ 103] = 0x81A7, [ 104] = 0x81A8,
  [ 105] = 0x81A9, [ 106] = 0x81AA, [ 107] = 0x81AB, [ 108] = 0x81AC,
  [ 109] = 0x81AD, [ 110] = 0x81AE, [ 111] = 0x81AF, [ 112] = 0x81B0,
  [ 113] = 0x81B1, [ 114] = 0x81B2, [ 115] = 0x81B3, [ 116] = 0x81B4,
  [ 117] = 0x81B5, [ 118] = 0x81B6, [ 119] = 0x81B7, [ 120] = 0x81B8,
  [ 121] = 0x81B9, [ 122] = 0x81BA, [ 123] = 0x81BB, [ 124] = 0x81BC,
  [ 125] = 0x81BD, [ 126] = 0x81BE, [ 127] = 0x81BF, [ 128] = 0x81C0,
  [ 129] = 0x81C1, [ 130] = 0x81C2, [ 131] = 0x81C3, [ 132] = 0x81C4,
  [ 133] = 0x81C5, [ 134] = 0x81C6, [ 135] = 0x81C7, [ 136] = 0x81C8,
  [ 137] = 0x81C9, [ 138] = 0x81CA, [ 139] = 0x81CB, [ 140] = 0x81CC,
  [ 141] = 0x81CD, [ 142] = 0x81CE, [ 143] = 0x81CF, [ 144] = 0x81D0,
  [ 145] = 0x81D1, [ 146] = 0x81D2, [ 147] = 0x81D3, [ 148] = 0x81D4,
  [ 149] = 0x81D5, [ 150] = 0x81D6, [ 151] = 0x81D7, [ 152] = 0x81D8,
  [ 153] = 0x81D9, [ 154] = 0x81DA, [ 155] = 0x81DB, [ 156] = 0x81DC,
  [ 157] = 0x81DD, [ 158] = 0x81DE, [ 159] = 0x81DF, [ 160] = 0x81E0,
  [ 161] = 0x81E1, [ 162] = 0x81E2, [ 163] = 0x81E3, [ 164] = 0x81E4,
  [ 165] = 0x81E5, [ 166] = 0x81E6, [ 167] = 0x81E7, [ 168] = 0x81E8,
  [ 169] = 0x81E9, [ 170] = 0x81EA, [ 171] = 0x81EB, [ 172] = 0x81EC,
  [ 173] = 0x81ED, [ 174] = 0x81EE, [ 175] = 0x81EF, [ 176] = 0x81F0,
  [ 177] = 0x81F1, [ 178] = 0x81F2, [ 179] = 0x81F3, [ 180] = 0x81F4,
  [ 181] = 0x81F5, [ 182] = 0x81F6, [ 183] = 0x81F7, [ 184] = 0x81F8,
  [ 185] = 0x81F9, [ 186] = 0x81FA, [ 187] = 0x81FB, [ 188] = 0x81FC,
  [ 189] = 0x81FD, [ 190] = 0x81FE, [ 256] = 0x8240, [ 257] = 0x8241,
  [ 258] = 0x8242, [ 259] = 0x8243, [ 260] = 0x8244, [ 261] = 0x8245,
  [ 262] = 0x8246, [ 263] = 0x8247, [ 264] = 0x8248, [ 265] = 0x8249,
  [ 266] = 0x824A, [ 267] = 0x824B, [ 268] = 0x824C, [ 269] = 0x824D,
  [ 270] = 0x824E, [ 271] = 0x824F, [ 272] = 0x8250, [ 273] = 0x8251,
  [ 274] = 0x8252, [ 275] = 0x8253, [ 276] = 0x8254, [ 277] = 0x8255,
  [ 278] = 0x8256, [ 279] = 0x8257, [ 280] = 0x8258, [ 281] = 0x8259,
  [ 282] = 0x825A, [ 283] = 0x825B, [ 284] = 0x825C, [ 285] = 0x825D,
  [ 286] = 0x825E, [ 287] = 0x825F, [ 288] = 0x8260, [ 289] = 0x8261,
  [ 290] = 0x8262, [ 291] = 0x8263, [ 292] = 0x8264, [ 293] = 0x8265,
  [ 294] = 0x8266, [ 295] = 0x8267, [ 296] = 0x8268, [ 297] = 0x8269,
  [ 298] = 0x826A, [ 299] = 0x826B, [ 300] = 0x826C, [ 301] = 0x826D,
  [ 302] = 0x826E, [ 303] = 0x826F, [ 304] = 0x8270, [ 305] = 0x8271,
  [ 306] = 0x8272, [ 307] = 0x8273, [ 308] = 0x8274, [ 309] = 0x8275,
  [ 310] = 0x8276, [ 311] = 0x8277, [ 312] = 0x8278, [ 313] = 0x8279,
  [ 314] = 0x827A, [ 315] = 0x827B, [ 316] = 0x827C, [ 317] = 0x827D,
  [ 318] = 0x827E, [ 320] = 0x8280, [ 321] = 0x8281, [ 322] = 0x8282,
  [ 323] = 0x8283, [ 324] = 0x8284, [ 325] = 0x8285, [ 326] = 0x8286,
  [ 327] = 0x8287, [ 328] = 0x8288, [ 329] = 0x8289, [ 330] = 0x828A,
  [ 331] = 0x828B, [ 332] = 0x828C, [ 333] = 0x828D, [ 334] = 0x828E,
  [ 335] = 0x828F, [ 336] = 0x8290, [ 337] = 0x8291, [ 338] = 0x8292,
  [ 339] = 0x8293, [ 340] = 0x8294, [ 341] = 0x8295, [ 342] = 0x8296,
  [ 343] = 0x8297, [ 344] = 0x8298, [ 345] = 0x8299, [ 346] = 0x829A,
  [ 347] = 0x829B, [ 348] = 0x829C, [ 349] = 0x829D, [ 350] = 0x829E,
  [ 351] = 0x829F, [ 352] = 0x82A0, [ 353] = 0x82A1, [ 354] = 0x82A2,
  [ 355] = 0x82A3, [ 356] = 0x82A4, [ 357] = 0x82A5, [ 358] = 0x82A6,
  [ 359] = 0x82A7, [ 360] = 0x82A8, [ 361] = 0x82A9, [ 362] = 0x82AA,
  [ 363] = 0x82AB, [ 364] = 0x82AC, [ 365] = 0x82AD, [ 366] = 0x82AE,
  [ 367] = 0x82AF, [ 368] = 0x82B0, [ 369] = 0x82B1, [ 370] = 0x82B2,
  [ 371] = 0x82B3, [ 372] = 0x82B4, [ 373] = 0x82B5, [ 374] = 0x82B6,
  [ 375] = 0x82B7, [ 376] = 0x82B8, [ 377] = 0x82B9, [ 378] = 0x82BA,
  [ 379] = 0x82BB, [ 380] = 0x82BC, [ 381] = 0x82BD, [ 382] = 0x82BE,
  [ 383] = 0x82BF, [ 384] = 0x82C0, [ 385] = 0x82C1, [ 386] = 0x82C2,
  [ 387] = 0x82C3, [ 388] = 0x82C4, [ 389] = 0x82C5, [ 390] = 0x82C6,
  [ 391] = 0x82C7, [ 392] = 0x82C8, [ 393] = 0x82C9, [ 394] = 0x82CA,
  [ 395] = 0x82CB, [ 396] = 0x82CC, [ 397] = 0x82CD, [ 398] = 0x82CE,
  [ 399] = 0x82CF, [ 400] = 0x82D0, [ 401] = 0x82D1, [ 402] = 0x82D2,
  [ 403] = 0x82D3, [ 404] = 0x82D4, [ 405] = 0x82D5, [ 406] = 0x82D6,
  [ 407] = 0x82D7, [ 408] = 0x82D8, [ 409] = 0x82D9, [ 410] = 0x82DA,
  [ 411] = 0x82DB, [ 412] = 0x82DC, [ 413] = 0x82DD, [ 414] = 0x82DE,
  [ 415] = 0x82DF, [ 416] = 0x82E0, [ 417] = 0x82E1, [ 418] = 0x82E2,
  [ 419] = 0x82E3, [ 420] = 0x82E4, [ 421] = 0x82E5, [ 422] = 0x82E6,
  [ 423] = 0x82E7, [ 424] = 0x82E8, [ 425] = 0x82E9, [ 426] = 0x82EA,
  [ 427] = 0x82EB, [ 428] = 0x82EC, [ 429] = 0x82ED, [ 430] = 0x82EE,
  [ 431] = 0x82EF, [ 432] = 0x82F0, [ 433] = 0x82F1, [ 434] = 0x82F2,
  [ 435] = 0x82F3, [ 436] = 0x82F4, [ 437] = 0x82F5, [ 438] = 0x82F6,
  [ 439] = 0x82F7, [ 440] = 0x82F8, [ 441] = 0x82F9, [ 442] = 0x82FA,
  [ 443] = 0x82FB, [ 444] = 0x82FC, [ 445] = 0x82FD, [ 446] = 0x82FE,
  [ 512] = 0x8340, [ 513] = 0x8341, [ 514] = 0x8342, [ 515] = 0x8343,
  [ 516] = 0x8344, [ 517] = 0x8345, [ 518] = 0x8346, [ 519] = 0x8347,
  [ 520] = 0x8348, [ 521] = 0x8349, [ 522] = 0x834A, [ 523] = 0x834B,
  [ 524] = 0x834C, [ 525] = 0x834D, [ 526] = 0x834E, [ 527] = 0x834F,
  [ 528] = 0x8350, [ 529] = 0x8351, [ 530] = 0x8352, [ 531] = 0x8353,
  [ 532] = 0x8354, [ 533] = 0x8355, [ 534] = 0x8356, [ 535] = 0x8357,
  [ 536] = 0x8358, [ 537] = 0x8359, [ 538] = 0x835A, [ 539] = 0x835B,
  [ 540] = 0x835C, [ 541] = 0x835D, [ 542] = 0x835E, [ 543] = 0x835F,
  [ 544] = 0x8360, [ 545] = 0x8361, [ 546] = 0x8362, [ 547] = 0x8363,
  [ 548] = 0x8364, [ 549] = 0x8365, [ 550] = 0x8366, [ 551] = 0x8367,
  [ 552] = 0x8368, [ 553] = 0x8369, [ 554] = 0x836A, [ 555] = 0x836B,
  [ 556] = 0x836C, [ 557] = 0x836D, [ 558] = 0x836E, [ 559] = 0x836F,
  [ 560] = 0x8370, [ 561] = 0x8371, [ 562] = 0x8372, [ 563] = 0x8373,
  [ 564] = 0x8374, [ 565] = 0x8375, [ 566] = 0x8376, [ 567] = 0x8377,
  [ 568] = 0x8378, [ 569] = 0x8379, [ 570] = 0x837A, [ 571] = 0x837B,
  [ 572] = 0x837C, [ 573] = 0x837D, [ 574] = 0x837E, [ 576] = 0x8380,
  [ 577] = 0x8381, [ 578] = 0x8382, [ 579] = 0x8383, [ 580] = 0x8384,
  [ 581] = 0x8385, [ 582] = 0x8386, [ 583] = 0x8387, [ 584] = 0x8388,
  [ 585] = 0x8389, [ 586] = 0x838A, [ 587] = 0x838B, [ 588] = 0x838C,
  [ 589] = 0x838D, [ 590] = 0x838E, [ 591] = 0x838F, [ 592] = 0x8390,
  [ 593] = 0x8391, [ 594] = 0x8392, [ 595] = 0x8393, [ 596] = 0x8394,
  [ 597] = 0x8395, [ 598] = 0x8396, [ 599] = 0x8397, [ 600] = 0x8398,
  [ 601] = 0x8399, [ 602] = 0x839A, [ 603] = 0x839B, [ 604] = 0x839C,
  [ 605] = 0x839D, [ 606] = 0x839E, [ 607] = 0x839F, [ 608] = 0x83A0,
  [ 609] = 0x83A1, [ 610] = 0x83A2, [ 611] = 0x83A3, [ 612] = 0x83A4,
  [ 613] = 0x83A5, [ 614] = 0x83A6, [ 615] = 0x83A7, [ 616] = 0x83A8,
  [ 617] = 0x83A9, [ 618] = 0x83AA, [ 619] = 0x83AB, [ 620] = 0x83AC,
  [ 621] = 0x83AD, [ 622] = 0x83AE, [ 623] = 0x83AF, [ 624] = 0x83B0,
  [ 625] = 0x83B1, [ 626] = 0x83B2, [ 627] = 0x83B3, [ 628] = 0x83B4,
  [ 629] = 0x83B5, [ 630] = 0x83B6, [ 631] = 0x83B7, [ 632] = 0x83B8,
  [ 633] = 0x83B9, [ 634] = 0x83BA, [ 635] = 0x83BB, [ 636] = 0x83BC,
  [ 637] = 0x83BD, [ 638] = 0x83BE, [ 639] = 0x83BF, [ 640] = 0x83C0,
  [ 641] = 0x83C1, [ 642] = 0x83C2, [ 643] = 0x83C3, [ 644] = 0x83C4,
  [ 645] = 0x83C5, [ 646] = 0x83C6, [ 647] = 0x83C7, [ 648] = 0x83C8,
  [ 649] = 0x83C9, [ 650] = 0x83CA, [ 651] = 0x83CB, [ 652] = 0x83CC,
  [ 653] = 0x83CD, [ 654] = 0x83CE, [ 655] = 0x83CF, [ 656] = 0x83D0,
  [ 657] = 0x83D1, [ 658] = 0x83D2, [ 659] = 0x83D3, [ 660] = 0x83D4,
  [ 661] = 0x83D5, [ 662] = 0x83D6, [ 663] = 0x83D7, [ 664] = 0x83D8,
  [ 665] = 0x83D9, [ 666] = 0x83DA, [ 667] = 0x83DB, [ 668] = 0x83DC,
  [ 669] = 0x83DD, [ 670] = 0x83DE, [ 671] = 0x83DF, [ 672] = 0x83E0,
  [ 673] = 0x83E1, [ 674] = 0x83E2, [ 675] = 0x83E3, [ 676] = 0x83E4,
  [ 677] = 0x83E5, [ 678] = 0x83E6, [ 679] = 0x83E7, [ 680] = 0x83E8,
  [ 681] = 0x83E9, [ 682] = 0x83EA, [ 683] = 0x83EB, [ 684] = 0x83EC,
  [ 685] = 0x83ED, [ 686] = 0x83EE, [ 687] = 0x83EF, [ 688] = 0x83F0,
  [ 689] = 0x83F1, [ 690] = 0x83F2, [ 691] = 0x83F3, [ 692] = 0x83F4,
  [ 693] = 0x83F5, [ 694] = 0x83F6, [ 695] = 0x83F7, [ 696] = 0x83F8,
  [ 697] = 0x83F9, [ 698] = 0x83FA, [ 699] = 0x83FB, [ 700] = 0x83FC,
  [ 701] = 0x83FD, [ 702] = 0x83FE, [ 768] = 0x8440, [ 769] = 0x8441,
  [ 770] = 0x8442, [ 771] = 0x8443, [ 772] = 0x8444, [ 773] = 0x8445,
  [ 774] = 0x8446, [ 775] = 0x8447, [ 776] = 0x8448, [ 777] = 0x8449,
  [ 778] = 0x844A, [ 779] = 0x844B, [ 780] = 0x844C, [ 781] = 0x844D,
  [ 782] = 0x844E, [ 783] = 0x844F, [ 784] = 0x8450, [ 785] = 0x8451,
  [ 786] = 0x8452, [ 787] = 0x8453, [ 788] = 0x8454, [ 789] = 0x8455,
  [ 790] = 0x8456, [ 791] = 0x8457, [ 792] = 0x8458, [ 793] = 0x8459,
  [ 794] = 0x845A, [ 795] = 0x845B, [ 796] = 0x845C, [ 797] = 0x845D,
  [ 798] = 0x845E, [ 799] = 0x845F, [ 800] = 0x8460, [ 801] = 0x8461,
  [ 802] = 0x8462, [ 803] = 0x8463, [ 804] = 0x8464, [ 805] = 0x8465,
  [ 806] = 0x8466, [ 807] = 0x8467, [ 808] = 0x8468, [ 809] = 0x8469,
  [ 810] = 0x846A, [ 811] = 0x846B, [ 812] = 0x846C, [ 813] = 0x846D,
  [ 814] = 0x846E, [ 815] = 0x846F, [ 816] = 0x8470, [ 817] = 0x8471,
  [ 818] = 0x8472, [ 819] = 0x8473, [ 820] = 0x8474, [ 821] = 0x8475,
  [ 822] = 0x8476, [ 823] = 0x8477, [ 824] = 0x8478, [ 825] = 0x8479,
  [ 826] = 0x847A, [ 827] = 0x847B, [ 828] = 0x847C, [ 829] = 0x847D,
  [ 830] = 0x847E, [ 832] = 0x8480, [ 833] = 0x8481, [ 834] = 0x8482,
  [ 835] = 0x8483, [ 836] = 0x8484, [ 837] = 0x8485, [ 838] = 0x8486,
  [ 839] = 0x8487, [ 840] = 0x8488, [ 841] = 0x8489, [ 842] = 0x848A,
  [ 843] = 0x848B, [ 844] = 0x848C, [ 845] = 0x848D, [ 846] = 0x848E,
  [ 847] = 0x848F, [ 848] = 0x8490, [ 849] = 0x8491, [ 850] = 0x8492,
  [ 851] = 0x8493, [ 852] = 0x8494, [ 853] = 0x8495, [ 854] = 0x8496,
  [ 855] = 0x8497, [ 856] = 0x8498, [ 857] = 0x8499, [ 858] = 0x849A,
  [ 859] = 0x849B, [ 860] = 0x849C, [ 861] = 0x849D, [ 862] = 0x849E,
  [ 863] = 0x849F, [ 864] = 0x84A0, [ 865] = 0x84A1, [ 866] = 0x84A2,
  [ 867] = 0x84A3, [ 868] = 0x84A4, [ 869] = 0x84A5, [ 870] = 0x84A6,
  [ 871] = 0x84A7, [ 872] = 0x84A8, [ 873] = 0x84A9, [ 874] = 0x84AA,
  [ 875] = 0x84AB, [ 876] = 0x84AC, [ 877] = 0x84AD, [ 878] = 0x84AE,
  [ 879] = 0x84AF, [ 880] = 0x84B0, [ 881] = 0x84B1, [ 882] = 0x84B2,
  [ 883] = 0x84B3, [ 884] = 0x84B4, [ 885] = 0x84B5, [ 886] = 0x84B6,
  [ 887] = 0x84B7, [ 888] = 0x84B8, [ 889] = 0x84B9, [ 890] = 0x84BA,
  [ 891] = 0x84BB, [ 892] = 0x84BC, [ 893] = 0x84BD, [ 894] = 0x84BE,
  [ 895] = 0x84BF, [ 896] = 0x84C0, [ 897] = 0x84C1, [ 898] = 0x84C2,
  [ 899] = 0x84C3, [ 900] = 0x84C4, [ 901] = 0x84C5, [ 902] = 0x84C6,
  [ 903] = 0x84C7, [ 904] = 0x84C8, [ 905] = 0x84C9, [ 906] = 0x84CA,
  [ 907] = 0x84CB, [ 908] = 0x84CC, [ 909] = 0x84CD, [ 910] = 0x84CE,
  [ 911] = 0x84CF, [ 912] = 0x84D0, [ 913] = 0x84D1, [ 914] = 0x84D2,
  [ 915] = 0x84D3, [ 916] = 0x84D4, [ 917] = 0x84D5, [ 918] = 0x84D6,
  [ 919] = 0x84D7, [ 920] = 0x84D8, [ 921] = 0x84D9, [ 922] = 0x84DA,
  [ 923] = 0x84DB, [ 924] = 0x84DC, [ 925] = 0x84DD, [ 926] = 0x84DE,
  [ 927] = 0x84DF, [ 928] = 0x84E0, [ 929] = 0x84E1, [ 930] = 0x84E2,
  [ 931] = 0x84E3, [ 932] = 0x84E4, [ 933] = 0x84E5, [ 934] = 0x84E6,
  [ 935] = 0x84E7, [ 936] = 0x84E8, [ 937] = 0x84E9, [ 938] = 0x84EA,
  [ 939] = 0x84EB, [ 940] = 0x84EC, [ 941] = 0x84ED, [ 942] = 0x84EE,
  [ 943] = 0x84EF, [ 944] = 0x84F0, [ 945] = 0x84F1, [ 946] = 0x84F2,
  [ 947] = 0x84F3, [ 948] = 0x84F4, [ 949] = 0x84F5, [ 950] = 0x84F6,
  [ 951] = 0x84F7, [ 952] = 0x84F8, [ 953] = 0x84F9, [ 954] = 0x84FA,
  [ 955] = 0x84FB, [ 956] = 0x84FC, [ 957] = 0x84FD, [ 958] = 0x84FE,
  [1024] = 0x8540, [1025] = 0x8541, [1026] = 0x8542, [1027] = 0x8543,
  [1028] = 0x8544, [1029] = 0x8545, [1030] = 0x8546, [1031] = 0x8547,
  [1032] = 0x8548, [1033] = 0x8549, [1034] = 0x854A, [1035] = 0x854B,
  [1036] = 0x854C, [1037] = 0x854D, [1038] = 0x854E, [1039] = 0x854F,
  [1040] = 0x8550, [1041] = 0x8551, [1042] = 0x8552, [1043] = 0x8553,
  [1044] = 0x8554, [1045] = 0x8555, [1046] = 0x8556, [1047] = 0x8557,
  [1048] = 0x8558, [1049] = 0x8559, [1050] = 0x855A, [1051] = 0x855B,
  [1052] = 0x855C, [1053] = 0x855D, [1054] = 0x855E, [1055] = 0x855F,
  [1056] = 0x8560, [1057] = 0x8561, [1058] = 0x8562, [1059] = 0x8563,
  [1060] = 0x8564, [1061] = 0x8565, [1062] = 0x8566, [1063] = 0x8567,
  [1064] = 0x8568, [1065] = 0x8569, [1066] = 0x856A, [1067] = 0x856B,
  [1068] = 0x856C, [1069] = 0x856D, [1070] = 0x856E, [1071] = 0x856F,
  [1072] = 0x8570, [1073] = 0x8571, [1074] = 0x8572, [1075] = 0x8573,
  [1076] = 0x8574, [1077] = 0x8575, [1078] = 0x8576, [1079] = 0x8577,
  [1080] = 0x8578, [1081] = 0x8579, [1082] = 0x857A, [1083] = 0x857B,
  [1084] = 0x857C, [1085] = 0x857D, [1086] = 0x857E, [1088] = 0x8580,
  [1089] = 0x8581, [1090] = 0x8582, [1091] = 0x8583, [1092] = 0x8584,
  [1093] = 0x8585, [1094] = 0x8586, [1095] = 0x8587, [1096] = 0x8588,
  [1097] = 0x8589, [1098] = 0x858A, [1099] = 0x858B, [1100] = 0x858C,
  [1101] = 0x858D, [1102] = 0x858E, [1103] = 0x858F, [1104] = 0x8590,
  [1105] = 0x8591, [1106] = 0x8592, [1107] = 0x8593, [1108] = 0x8594,
  [1109] = 0x8595, [1110] = 0x8596, [1111] = 0x8597, [1112] = 0x8598,
  [1113] = 0x8599, [1114] = 0x859A, [1115] = 0x859B, [1116] = 0x859C,
  [1117] = 0x859D, [1118] = 0x859E, [1119] = 0x859F, [1120] = 0x85A0,
  [1121] = 0x85A1, [1122] = 0x85A2, [1123] = 0x85A3, [1124] = 0x85A4,
  [1125] = 0x85A5, [1126] = 0x85A6, [1127] = 0x85A7, [1128] = 0x85A8,
  [1129] = 0x85A9, [1130] = 0x85AA, [1131] = 0x85AB, [1132] = 0x85AC,
  [1133] = 0x85AD, [1134] = 0x85AE, [1135] = 0x85AF, [1136] = 0x85B0,
  [1137] = 0x85B1, [1138] = 0x85B2, [1139] = 0x85B3, [1140] = 0x85B4,
  [1141] = 0x85B5, [1142] = 0x85B6, [1143] = 0x85B7, [1144] = 0x85B8,
  [1145] = 0x85B9, [1146] = 0x85BA, [1147] = 0x85BB, [1148] = 0x85BC,
  [1149] = 0x85BD, [1150] = 0x85BE, [1151] = 0x85BF, [1152] = 0x85C0,
  [1153] = 0x85C1, [1154] = 0x85C2, [1155] = 0x85C3, [1156] = 0x85C4,
  [1157] = 0x85C5, [1158] = 0x85C6, [1159] = 0x85C7, [1160] = 0x85C8,
  [1161] = 0x85C9, [1162] = 0x85CA, [1163] = 0x85CB, [1164] = 0x85CC,
  [1165] = 0x85CD, [1166] = 0x85CE, [1167] = 0x85CF, [1168] = 0x85D0,
  [1169] = 0x85D1, [1170] = 0x85D2, [1171] = 0x85D3, [1172] = 0x85D4,
  [1173] = 0x85D5, [1174] = 0x85D6, [1175] = 0x85D7, [1176] = 0x85D8,
  [1177] = 0x85D9, [1178] = 0x85DA, [1179] = 0x85DB, [1180] = 0x85DC,
  [1181] = 0x85DD, [1182] = 0x85DE, [1183] = 0x85DF, [1184] = 0x85E0,
  [1185] = 0x85E1, [1186] = 0x85E2, [1187] = 0x85E3, [1188] = 0x85E4,
  [1189] = 0x85E5, [1190] = 0x85E6, [1191] = 0x85E7, [1192] = 0x85E8,
  [1193] = 0x85E9, [1194] = 0x85EA, [1195] = 0x85EB, [1196] = 0x85EC,
  [1197] = 0x85ED, [1198] = 0x85EE, [1199] = 0x85EF, [1200] = 0x85F0,
  [1201] = 0x85F1, [1202] = 0x85F2, [1203] = 0x85F3, [1204] = 0x85F4,
  [1205] = 0x85F5, [1206] = 0x85F6, [1207] = 0x85F7, [1208] = 0x85F8,
  [1209] = 0x85F9, [1210] = 0x85FA, [1211] = 0x85FB, [1212] = 0x85FC,
  [1213] = 0x85FD, [1214] = 0x85FE, [1280] = 0x8640, [1281] = 0x8641,
  [1282] = 0x8642, [1283] = 0x8643, [1284] = 0x8644, [1285] = 0x8645,
  [1286] = 0x8646, [1287] = 0x8647, [1288] = 0x8648, [1289] = 0x8649,
  [1290] = 0x864A, [1291] = 0x864B, [1292] = 0x864C, [1293] = 0x864D,
  [1294] = 0x864E, [1295] = 0x864F, [1296] = 0x8650, [1297] = 0x8651,
  [1298] = 0x8652, [1299] = 0x8653, [1300] = 0x8654, [1301] = 0x8655,
  [1302] = 0x8656, [1303] = 0x8657, [1304] = 0x8658, [1305] = 0x8659,
  [1306] = 0x865A, [1307] = 0x865B, [1308] = 0x865C, [1309] = 0x865D,
  [1310] = 0x865E, [1311] = 0x865F, [1312] = 0x8660, [1313] = 0x8661,
  [1314] = 0x8662, [1315] = 0x8663, [1316] = 0x8664, [1317] = 0x8665,
  [1318] = 0x8666, [1319] = 0x8667, [1320] = 0x8668, [1321] = 0x8669,
  [1322] = 0x866A, [1323] = 0x866B, [1324] = 0x866C, [1325] = 0x866D,
  [1326] = 0x866E, [1327] = 0x866F, [1328] = 0x8670, [1329] = 0x8671,
  [1330] = 0x8672, [1331] = 0x8673, [1332] = 0x8674, [1333] = 0x8675,
  [1334] = 0x8676, [1335] = 0x8677, [1336] = 0x8678, [1337] = 0x8679,
  [1338] = 0x867A, [1339] = 0x867B, [1340] = 0x867C, [1341] = 0x867D,
  [1342] = 0x867E, [1344] = 0x8680, [1345] = 0x8681, [1346] = 0x8682,
  [1347] = 0x8683, [1348] = 0x8684, [1349] = 0x8685, [1350] = 0x8686,
  [1351] = 0x8687, [1352] = 0x8688, [1353] = 0x8689, [1354] = 0x868A,
  [1355] = 0x868B, [1356] = 0x868C, [1357] = 0x868D, [1358] = 0x868E,
  [1359] = 0x868F, [1360] = 0x8690, [1361] = 0x8691, [1362] = 0x8692,
  [1363] = 0x8693, [1364] = 0x8694, [1365] = 0x8695, [1366] = 0x8696,
  [1367] = 0x8697, [1368] = 0x8698, [1369] = 0x8699, [1370] = 0x869A,
  [1371] = 0x869B, [1372] = 0x869C, [1373] = 0x869D, [1374] = 0x869E,
  [1375] = 0x869F, [1376] = 0x86A0, [1377] = 0x86A1, [1378] = 0x86A2,
  [1379] = 0x86A3, [1380] = 0x86A4, [1381] = 0x86A5, [1382] = 0x86A6,
  [1383] = 0x86A7, [1384] = 0x86A8, [1385] = 0x86A9, [1386] = 0x86AA,
  [1387] = 0x86AB, [1388] = 0x86AC, [1389] = 0x86AD, [1390] = 0x86AE,
  [1391] = 0x86AF, [1392] = 0x86B0, [1393] = 0x86B1, [1394] = 0x86B2,
  [1395] = 0x86B3, [1396] = 0x86B4, [1397] = 0x86B5, [1398] = 0x86B6,
  [1399] = 0x86B7, [1400] = 0x86B8, [1401] = 0x86B9, [1402] = 0x86BA,
  [1403] = 0x86BB, [1404] = 0x86BC, [1405] = 0x86BD, [1406] = 0x86BE,
  [1407] = 0x86BF, [1408] = 0x86C0, [1409] = 0x86C1, [1410] = 0x86C2,
  [1411] = 0x86C3, [1412] = 0x86C4, [1413] = 0x86C5, [1414] = 0x86C6,
  [1415] = 0x86C7, [1416] = 0x86C8, [1417] = 0x86C9, [1418] = 0x86CA,
  [1419] = 0x86CB, [1420] = 0x86CC, [1421] = 0x86CD, [1422] = 0x86CE,
  [1423] = 0x86CF, [1424] = 0x86D0, [1425] = 0x86D1, [1426] = 0x86D2,
  [1427] = 0x86D3, [1428] = 0x86D4, [1429] = 0x86D5, [1430] = 0x86D6,
  [1431] = 0x86D7, [1432] = 0x86D8, [1433] = 0x86D9, [1434] = 0x86DA,
  [1435] = 0x86DB, [1436] = 0x86DC, [1437] = 0x86DD, [1438] = 0x86DE,
  [1439] = 0x86DF, [1440] = 0x86E0, [1441] = 0x86E1, [1442] = 0x86E2,
  [1443] = 0x86E3, [1444] = 0x86E4, [1445] = 0x86E5, [1446] = 0x86E6,
  [1447] = 0x86E7, [1448] = 0x86E8, [1449] = 0x86E9, [1450] = 0x86EA,
  [1451] = 0x86EB, [1452] = 0x86EC, [1453] = 0x86ED, [1454] = 0x86EE,
  [1455] = 0x86EF, [1456] = 0x86F0, [1457] = 0x86F1, [1458] = 0x86F2,
  [1459] = 0x86F3, [1460] = 0x86F4, [1461] = 0x86F5, [1462] = 0x86F6,
  [1463] = 0x86F7, [1464] = 0x86F8, [1465] = 0x86F9, [1466] = 0x86FA,
  [1467] = 0x86FB, [1468] = 0x86FC, [1469] = 0x86FD, [1470] = 0x86FE,
  [1536] = 0x8740, [1537] = 0x8741, [1538] = 0x8742, [1539] = 0x8743,
  [1540] = 0x8744, [1541] = 0x8745, [1542] = 0x8746, [1543] = 0x8747,
  [1544] = 0x8748, [1545] = 0x8749, [1546] = 0x874A, [1547] = 0x874B,
  [1548] = 0x874C, [1549] = 0x874D, [1550] = 0x874E, [1551] = 0x874F,
  [1552] = 0x8750, [1553] = 0x8751, [1554] = 0x8752, [1555] = 0x8753,
  [1556] = 0x8754, [1557] = 0x8755, [1558] = 0x8756, [1559] = 0x8757,
  [1560] = 0x8758, [1561] = 0x8759, [1562] = 0x875A, [1563] = 0x875B,
  [1564] = 0x875C, [1565] = 0x875D, [1566] = 0x875E, [1567] = 0x875F,
  [1568] = 0x8760, [1569] = 0x8761, [1570] = 0x8762, [1571] = 0x8763,
  [1572] = 0x8764, [1573] = 0x8765, [1574] = 0x8766, [1575] = 0x8767,
  [1576] = 0x8768, [1577] = 0x8769, [1578] = 0x876A, [1579] = 0x876B,
  [1580] = 0x876C, [1581] = 0x876D, [1582] = 0x876E, [1583] = 0x876F,
  [1584] = 0x8770, [1585] = 0x8771, [1586] = 0x8772, [1587] = 0x8773,
  [1588] = 0x8774, [1589] = 0x8775, [1590] = 0x8776, [1591] = 0x8777,
  [1592] = 0x8778, [1593] = 0x8779, [1594] = 0x877A, [1595] = 0x877B,
  [1596] = 0x877C, [1597] = 0x877D, [1598] = 0x877E, [1600] = 0x8780,
  [1601] = 0x8781, [1602] = 0x8782, [1603] = 0x8783, [1604] = 0x8784,
  [1605] = 0x8785, [1606] = 0x8786, [1607] = 0x8787, [1608] = 0x8788,
  [1609] = 0x8789, [1610] = 0x878A, [1611] = 0x878B, [1612] = 0x878C,
  [1613] = 0x878D, [1614] = 0x878E, [1615] = 0x878F, [1616] = 0x8790,
  [1617] = 0x8791, [1618] = 0x8792, [1619] = 0x8793, [1620] = 0x8794,
  [1621] = 0x8795, [1622] = 0x8796, [1623] = 0x8797, [1624] = 0x8798,
  [1625] = 0x8799, [1626] = 0x879A, [1627] = 0x879B, [1628] = 0x879C,
  [1629] = 0x879D, [1630] = 0x879E, [1631] = 0x879F, [1632] = 0x87A0,
  [1633] = 0x87A1, [1634] = 0x87A2, [1635] = 0x87A3, [1636] = 0x87A4,
  [1637] = 0x87A5, [1638] = 0x87A6, [1639] = 0x87A7, [1640] = 0x87A8,
  [1641] = 0x87A9, [1642] = 0x87AA, [1643] = 0x87AB, [1644] = 0x87AC,
  [1645] = 0x87AD, [1646] = 0x87AE, [1647] = 0x87AF, [1648] = 0x87B0,
  [1649] = 0x87B1, [1650] = 0x87B2, [1651] = 0x87B3, [1652] = 0x87B4,
  [1653] = 0x87B5, [1654] = 0x87B6, [1655] = 0x87B7, [1656] = 0x87B8,
  [1657] = 0x87B9, [1658] = 0x87BA, [1659] = 0x87BB, [1660] = 0x87BC,
  [1661] = 0x87BD, [1662] = 0x87BE, [1663] = 0x87BF, [1664] = 0x87C0,
  [1665] = 0x87C1, [1666] = 0x87C2, [1667] = 0x87C3, [1668] = 0x87C4,
  [1669] = 0x87C5, [1670] = 0x87C6, [1671] = 0x87C7, [1672] = 0x87C8,
  [1673] = 0x87C9, [1674] = 0x87CA, [1675] = 0x87CB, [1676] = 0x87CC,
  [1677] = 0x87CD, [1678] = 0x87CE, [1679] = 0x87CF, [1680] = 0x87D0,
  [1681] = 0x87D1, [1682] = 0x87D2, [1683] = 0x87D3, [1684] = 0x87D4,
  [1685] = 0x87D5, [1686] = 0x87D6, [1687] = 0x87D7, [1688] = 0x87D8,
  [1689] = 0x87D9, [1690] = 0x87DA, [1691] = 0x87DB, [1692] = 0x87DC,
  [1693] = 0x87DD, [1694] = 0x87DE, [1695] = 0x87DF, [1696] = 0x87E0,
  [1697] = 0x87E1, [1698] = 0x87E2, [1699] = 0x87E3, [1700] = 0x87E4,
  [1701] = 0x87E5, [1702] = 0x87E6, [1703] = 0x87E7, [1704] = 0x87E8,
  [1705] = 0x87E9, [1706] = 0x87EA, [1707] = 0x87EB, [1708] = 0x87EC,
  [1709] = 0x87ED, [1710] = 0x87EE, [1711] = 0x87EF, [1712] = 0x87F0,
  [1713] = 0x87F1, [1714] = 0x87F2, [1715] = 0x87F3, [1716] = 0x87F4,
  [1717] = 0x87F5, [1718] = 0x87F6, [1719] = 0x87F7, [1720] = 0x87F8,
  [1721] = 0x87F9, [1722] = 0x87FA, [1723] = 0x87FB, [1724] = 0x87FC,
  [1725] = 0x87FD, [1726] = 0x87FE, [1792] = 0x8840, [1793] = 0x8841,
  [1794] = 0x8842, [1795] = 0x8843, [1796] = 0x8844, [1797] = 0x8845,
  [1798] = 0x8846, [1799] = 0x8847, [1800] = 0x8848, [1801] = 0x8849,
  [1802] = 0x884A, [1803] = 0x884B, [1804] = 0x884C, [1805] = 0x884D,
  [1806] = 0x884E, [1807] = 0x884F, [1808] = 0x8850, [1809] = 0x8851,
  [1810] = 0x8852, [1811] = 0x8853, [1812] = 0x8854, [1813] = 0x8855,
  [1814] = 0x8856, [1815] = 0x8857, [1816] = 0x8858, [1817] = 0x8859,
  [1818] = 0x885A, [1819] = 0x885B, [1820] = 0x885C, [1821] = 0x885D,
  [1822] = 0x885E, [1823] = 0x885F, [1824] = 0x8860, [1825] = 0x8861,
  [1826] = 0x8862, [1827] = 0x8863, [1828] = 0x8864, [1829] = 0x8865,
  [1830] = 0x8866, [1831] = 0x8867, [1832] = 0x8868, [1833] = 0x8869,
  [1834] = 0x886A, [1835] = 0x886B, [1836] = 0x886C, [1837] = 0x886D,
  [1838] = 0x886E, [1839] = 0x886F, [1840] = 0x8870, [1841] = 0x8871,
  [1842] = 0x8872, [1843] = 0x8873, [1844] = 0x8874, [1845] = 0x8875,
  [1846] = 0x8876, [1847] = 0x8877, [1848] = 0x8878, [1849] = 0x8879,
  [1850] = 0x887A, [1851] = 0x887B, [1852] = 0x887C, [1853] = 0x887D,
  [1854] = 0x887E, [1856] = 0x8880, [1857] = 0x8881, [1858] = 0x8882,
  [1859] = 0x8883, [1860] = 0x8884, [1861] = 0x8885, [1862] = 0x8886,
  [1863] = 0x8887, [1864] = 0x8888, [1865] = 0x8889, [1866] = 0x888A,
  [1867] = 0x888B, [1868] = 0x888C, [1869] = 0x888D, [1870] = 0x888E,
  [1871] = 0x888F, [1872] = 0x8890, [1873] = 0x8891, [1874] = 0x8892,
  [1875] = 0x8893, [1876] = 0x8894, [1877] = 0x8895, [1878] = 0x8896,
  [1879] = 0x8897, [1880] = 0x8898, [1881] = 0x8899, [1882] = 0x889A,
  [1883] = 0x889B, [1884] = 0x889C, [1885] = 0x889D, [1886] = 0x889E,
  [1887] = 0x889F, [1888] = 0x88A0, [1889] = 0x88A1, [1890] = 0x88A2,
  [1891] = 0x88A3, [1892] = 0x88A4, [1893] = 0x88A5, [1894] = 0x88A6,
  [1895] = 0x88A7, [1896] = 0x88A8, [1897] = 0x88A9, [1898] = 0x88AA,
  [1899] = 0x88AB, [1900] = 0x88AC, [1901] = 0x88AD, [1902] = 0x88AE,
  [1903] = 0x88AF, [1904] = 0x88B0, [1905] = 0x88B1, [1906] = 0x88B2,
  [1907] = 0x88B3, [1908] = 0x88B4, [1909] = 0x88B5, [1910] = 0x88B6,
  [1911] = 0x88B7, [1912] = 0x88B8, [1913] = 0x88B9, [1914] = 0x88BA,
  [1915] = 0x88BB, [1916] = 0x88BC, [1917] = 0x88BD, [1918] = 0x88BE,
  [1919] = 0x88BF, [1920] = 0x88C0, [1921] = 0x88C1, [1922] = 0x88C2,
  [1923] = 0x88C3, [1924] = 0x88C4, [1925] = 0x88C5, [1926] = 0x88C6,
  [1927] = 0x88C7, [1928] = 0x88C8, [1929] = 0x88C9, [1930] = 0x88CA,
  [1931] = 0x88CB, [1932] = 0x88CC, [1933] = 0x88CD, [1934] = 0x88CE,
  [1935] = 0x88CF, [1936] = 0x88D0, [1937] = 0x88D1, [1938] = 0x88D2,
  [1939] = 0x88D3, [1940] = 0x88D4, [1941] = 0x88D5, [1942] = 0x88D6,
  [1943] = 0x88D7, [1944] = 0x88D8, [1945] = 0x88D9, [1946] = 0x88DA,
  [1947] = 0x88DB, [1948] = 0x88DC, [1949] = 0x88DD, [1950] = 0x88DE,
  [1951] = 0x88DF, [1952] = 0x88E0, [1953] = 0x88E1, [1954] = 0x88E2,
  [1955] = 0x88E3, [1956] = 0x88E4, [1957] = 0x88E5, [1958] = 0x88E6,
  [1959] = 0x88E7, [1960] = 0x88E8, [1961] = 0x88E9, [1962] = 0x88EA,
  [1963] = 0x88EB, [1964] = 0x88EC, [1965] = 0x88ED, [1966] = 0x88EE,
  [1967] = 0x88EF, [1968] = 0x88F0, [1969] = 0x88F1, [1970] = 0x88F2,
  [1971] = 0x88F3, [1972] = 0x88F4, [1973] = 0x88F5, [1974] = 0x88F6,
  [1975] = 0x88F7, [1976] = 0x88F8, [1977] = 0x88F9, [1978] = 0x88FA,
  [1979] = 0x88FB, [1980] = 0x88FC, [1981] = 0x88FD, [1982] = 0x88FE,
  [2048] = 0x8940, [2049] = 0x8941, [2050] = 0x8942, [2051] = 0x8943,
  [2052] = 0x8944, [2053] = 0x8945, [2054] = 0x8946, [2055] = 0x8947,
  [2056] = 0x8948, [2057] = 0x8949, [2058] = 0x894A, [2059] = 0x894B,
  [2060] = 0x894C, [2061] = 0x894D, [2062] = 0x894E, [2063] = 0x894F,
  [2064] = 0x8950, [2065] = 0x8951, [2066] = 0x8952, [2067] = 0x8953,
  [2068] = 0x8954, [2069] = 0x8955, [2070] = 0x8956, [2071] = 0x8957,
  [2072] = 0x8958, [2073] = 0x8959, [2074] = 0x895A, [2075] = 0x895B,
  [2076] = 0x895C, [2077] = 0x895D, [2078] = 0x895E, [2079] = 0x895F,
  [2080] = 0x8960, [2081] = 0x8961, [2082] = 0x8962, [2083] = 0x8963,
  [2084] = 0x8964, [2085] = 0x8965, [2086] = 0x8966, [2087] = 0x8967,
  [2088] = 0x8968, [2089] = 0x8969, [2090] = 0x896A, [2091] = 0x896B,
  [2092] = 0x896C, [2093] = 0x896D, [2094] = 0x896E, [2095] = 0x896F,
  [2096] = 0x8970, [2097] = 0x8971, [2098] = 0x8972, [2099] = 0x8973,
  [2100] = 0x8974, [2101] = 0x8975, [2102] = 0x8976, [2103] = 0x8977,
  [2104] = 0x8978, [2105] = 0x8979, [2106] = 0x897A, [2107] = 0x897B,
  [2108] = 0x897C, [2109] = 0x897D, [2110] = 0x897E, [2112] = 0x8980,
  [2113] = 0x8981, [2114] = 0x8982, [2115] = 0x8983, [2116] = 0x8984,
  [2117] = 0x8985, [2118] = 0x8986, [2119] = 0x8987, [2120] = 0x8988,
  [2121] = 0x8989, [2122] = 0x898A, [2123] = 0x898B, [2124] = 0x898C,
  [2125] = 0x898D, [2126] = 0x898E, [2127] = 0x898F, [2128] = 0x8990,
  [2129] = 0x8991, [2130] = 0x8992, [2131] = 0x8993, [2132] = 0x8994,
  [2133] = 0x8995, [2134] = 0x8996, [2135] = 0x8997, [2136] = 0x8998,
  [2137] = 0x8999, [2138] = 0x899A, [2139] = 0x899B, [2140] = 0x899C,
  [2141] = 0x899D, [2142] = 0x899E, [2143] = 0x899F, [2144] = 0x89A0,
  [2145] = 0x89A1, [2146] = 0x89A2, [2147] = 0x89A3, [2148] = 0x89A4,
  [2149] = 0x89A5, [2150] = 0x89A6, [2151] = 0x89A7, [2152] = 0x89A8,
  [2153] = 0x89A9, [2154] = 0x89AA, [2155] = 0x89AB, [2156] = 0x89AC,
  [2157] = 0x89AD, [2158] = 0x89AE, [2159] = 0x89AF, [2160] = 0x89B0,
  [2161] = 0x89B1, [2162] = 0x89B2, [2163] = 0x89B3, [2164] = 0x89B4,
  [2165] = 0x89B5, [2166] = 0x89B6, [2167] = 0x89B7, [2168] = 0x89B8,
  [2169] = 0x89B9, [2170] = 0x89BA, [2171] = 0x89BB, [2172] = 0x89BC,
  [2173] = 0x89BD, [2174] = 0x89BE, [2175] = 0x89BF, [2176] = 0x89C0,
  [2177] = 0x89C1, [2178] = 0x89C2, [2179] = 0x89C3, [2180] = 0x89C4,
  [2181] = 0x89C5, [2182] = 0x89C6, [2183] = 0x89C7, [2184] = 0x89C8,
  [2185] = 0x89C9, [2186] = 0x89CA, [2187] = 0x89CB, [2188] = 0x89CC,
  [2189] = 0x89CD, [2190] = 0x89CE, [2191] = 0x89CF, [2192] = 0x89D0,
  [2193] = 0x89D1, [2194] = 0x89D2, [2195] = 0x89D3, [2196] = 0x89D4,
  [2197] = 0x89D5, [2198] = 0x89D6, [2199] = 0x89D7, [2200] = 0x89D8,
  [2201] = 0x89D9, [2202] = 0x89DA, [2203] = 0x89DB, [2204] = 0x89DC,
  [2205] = 0x89DD, [2206] = 0x89DE, [2207] = 0x89DF, [2208] = 0x89E0,
  [2209] = 0x89E1, [2210] = 0x89E2, [2211] = 0x89E3, [2212] = 0x89E4,
  [2213] = 0x89E5, [2214] = 0x89E6, [2215] = 0x89E7, [2216] = 0x89E8,
  [2217] = 0x89E9, [2218] = 0x89EA, [2219] = 0x89EB, [2220] = 0x89EC,
  [2221] = 0x89ED, [2222] = 0x89EE, [2223] = 0x89EF, [2224] = 0x89F0,
  [2225] = 0x89F1, [2226] = 0x89F2, [2227] = 0x89F3, [2228] = 0x89F4,
  [2229] = 0x89F5, [2230] = 0x89F6, [2231] = 0x89F7, [2232] = 0x89F8,
  [2233] = 0x89F9, [2234] = 0x89FA, [2235] = 0x89FB, [2236] = 0x89FC,
  [2237] = 0x89FD, [2238] = 0x89FE, [2304] = 0x8A40, [2305] = 0x8A41,
  [2306] = 0x8A42, [2307] = 0x8A43, [2308] = 0x8A44, [2309] = 0x8A45,
  [2310] = 0x8A46, [2311] = 0x8A47, [2312] = 0x8A48, [2313] = 0x8A49,
  [2314] = 0x8A4A, [2315] = 0x8A4B, [2316] = 0x8A4C, [2317] = 0x8A4D,
  [2318] = 0x8A4E, [2319] = 0x8A4F, [2320] = 0x8A50, [2321] = 0x8A51,
  [2322] = 0x8A52, [2323] = 0x8A53, [2324] = 0x8A54, [2325] = 0x8A55,
  [2326] = 0x8A56, [2327] = 0x8A57, [2328] = 0x8A58, [2329] = 0x8A59,
  [2330] = 0x8A5A, [2331] = 0x8A5B, [2332] = 0x8A5C, [2333] = 0x8A5D,
  [2334] = 0x8A5E, [2335] = 0x8A5F, [2336] = 0x8A60, [2337] = 0x8A61,
  [2338] = 0x8A62, [2339] = 0x8A63, [2340] = 0x8A64, [2341] = 0x8A65,
  [2342] = 0x8A66, [2343] = 0x8A67, [2344] = 0x8A68, [2345] = 0x8A69,
  [2346] = 0x8A6A, [2347] = 0x8A6B, [2348] = 0x8A6C, [2349] = 0x8A6D,
  [2350] = 0x8A6E, [2351] = 0x8A6F, [2352] = 0x8A70, [2353] = 0x8A71,
  [2354] = 0x8A72, [2355] = 0x8A73, [2356] = 0x8A74, [2357] = 0x8A75,
  [2358] = 0x8A76, [2359] = 0x8A77, [2360] = 0x8A78, [2361] = 0x8A79,
  [2362] = 0x8A7A, [2363] = 0x8A7B, [2364] = 0x8A7C, [2365] = 0x8A7D,
  [2366] = 0x8A7E, [2368] = 0x8A80, [2369] = 0x8A81, [2370] = 0x8A82,
  [2371] = 0x8A83, [2372] = 0x8A84, [2373] = 0x8A85, [2374] = 0x8A86,
  [2375] = 0x8A87, [2376] = 0x8A88, [2377] = 0x8A89, [2378] = 0x8A8A,
  [2379] = 0x8A8B, [2380] = 0x8A8C, [2381] = 0x8A8D, [2382] = 0x8A8E,
  [2383] = 0x8A8F, [2384] = 0x8A90, [2385] = 0x8A91, [2386] = 0x8A92,
  [2387] = 0x8A93, [2388] = 0x8A94, [2389] = 0x8A95, [2390] = 0x8A96,
  [2391] = 0x8A97, [2392] = 0x8A98, [2393] = 0x8A99, [2394] = 0x8A9A,
  [2395] = 0x8A9B, [2396] = 0x8A9C, [2397] = 0x8A9D, [2398] = 0x8A9E,
  [2399] = 0x8A9F, [2400] = 0x8AA0, [2401] = 0x8AA1, [2402] = 0x8AA2,
  [2403] = 0x8AA3, [2404] = 0x8AA4, [2405] = 0x8AA5, [2406] = 0x8AA6,
  [2407] = 0x8AA7, [2408] = 0x8AA8, [2409] = 0x8AA9, [2410] = 0x8AAA,
  [2411] = 0x8AAB, [2412] = 0x8AAC, [2413] = 0x8AAD, [2414] = 0x8AAE,
  [2415] = 0x8AAF, [2416] = 0x8AB0, [2417] = 0x8AB1, [2418] = 0x8AB2,
  [2419] = 0x8AB3, [2420] = 0x8AB4, [2421] = 0x8AB5, [2422] = 0x8AB6,
  [2423] = 0x8AB7, [2424] = 0x8AB8, [2425] = 0x8AB9, [2426] = 0x8ABA,
  [2427] = 0x8ABB, [2428] = 0x8ABC, [2429] = 0x8ABD, [2430] = 0x8ABE,
  [2431] = 0x8ABF, [2432] = 0x8AC0, [2433] = 0x8AC1, [2434] = 0x8AC2,
  [2435] = 0x8AC3, [2436] = 0x8AC4, [2437] = 0x8AC5, [2438] = 0x8AC6,
  [2439] = 0x8AC7, [2440] = 0x8AC8, [2441] = 0x8AC9, [2442] = 0x8ACA,
  [2443] = 0x8ACB, [2444] = 0x8ACC, [2445] = 0x8ACD, [2446] = 0x8ACE,
  [2447] = 0x8ACF, [2448] = 0x8AD0, [2449] = 0x8AD1, [2450] = 0x8AD2,
  [2451] = 0x8AD3, [2452] = 0x8AD4, [2453] = 0x8AD5, [2454] = 0x8AD6,
  [2455] = 0x8AD7, [2456] = 0x8AD8, [2457] = 0x8AD9, [2458] = 0x8ADA,
  [2459] = 0x8ADB, [2460] = 0x8ADC, [2461] = 0x8ADD, [2462] = 0x8ADE,
  [2463] = 0x8ADF, [2464] = 0x8AE0, [2465] = 0x8AE1, [2466] = 0x8AE2,
  [2467] = 0x8AE3, [2468] = 0x8AE4, [2469] = 0x8AE5, [2470] = 0x8AE6,
  [2471] = 0x8AE7, [2472] = 0x8AE8, [2473] = 0x8AE9, [2474] = 0x8AEA,
  [2475] = 0x8AEB, [2476] = 0x8AEC, [2477] = 0x8AED, [2478] = 0x8AEE,
  [2479] = 0x8AEF, [2480] = 0x8AF0, [2481] = 0x8AF1, [2482] = 0x8AF2,
  [2483] = 0x8AF3, [2484] = 0x8AF4, [2485] = 0x8AF5, [2486] = 0x8AF6,
  [2487] = 0x8AF7, [2488] = 0x8AF8, [2489] = 0x8AF9, [2490] = 0x8AFA,
  [2491] = 0x8AFB, [2492] = 0x8AFC, [2493] = 0x8AFD, [2494] = 0x8AFE,
  [2560] = 0x8B40, [2561] = 0x8B41, [2562] = 0x8B42, [2563] = 0x8B43,
  [2564] = 0x8B44, [2565] = 0x8B45, [2566] = 0x8B46, [2567] = 0x8B47,
  [2568] = 0x8B48, [2569] = 0x8B49, [2570] = 0x8B4A, [2571] = 0x8B4B,
  [2572] = 0x8B4C, [2573] = 0x8B4D, [2574] = 0x8B4E, [2575] = 0x8B4F,
  [2576] = 0x8B50, [2577] = 0x8B51, [2578] = 0x8B52, [2579] = 0x8B53,
  [2580] = 0x8B54, [2581] = 0x8B55, [2582] = 0x8B56, [2583] = 0x8B57,
  [2584] = 0x8B58, [2585] = 0x8B59, [2586] = 0x8B5A, [2587] = 0x8B5B,
  [2588] = 0x8B5C, [2589] = 0x8B5D, [2590] = 0x8B5E, [2591] = 0x8B5F,
  [2592] = 0x8B60, [2593] = 0x8B61, [2594] = 0x8B62, [2595] = 0x8B63,
  [2596] = 0x8B64, [2597] = 0x8B65, [2598] = 0x8B66, [2599] = 0x8B67,
  [2600] = 0x8B68, [2601] = 0x8B69, [2602] = 0x8B6A, [2603] = 0x8B6B,
  [2604] = 0x8B6C, [2605] = 0x8B6D, [2606] = 0x8B6E, [2607] = 0x8B6F,
  [2608] = 0x8B70, [2609] = 0x8B71, [2610] = 0x8B72, [2611] = 0x8B73,
  [2612] = 0x8B74, [2613] = 0x8B75, [2614] = 0x8B76, [2615] = 0x8B77,
  [2616] = 0x8B78, [2617] = 0x8B79, [2618] = 0x8B7A, [2619] = 0x8B7B,
  [2620] = 0x8B7C, [2621] = 0x8B7D, [2622] = 0x8B7E, [2624] = 0x8B80,
  [2625] = 0x8B81, [2626] = 0x8B82, [2627] = 0x8B83, [2628] = 0x8B84,
  [2629] = 0x8B85, [2630] = 0x8B86, [2631] = 0x8B87, [2632] = 0x8B88,
  [2633] = 0x8B89, [2634] = 0x8B8A, [2635] = 0x8B8B, [2636] = 0x8B8C,
  [2637] = 0x8B8D, [2638] = 0x8B8E, [2639] = 0x8B8F, [2640] = 0x8B90,
  [2641] = 0x8B91, [2642] = 0x8B92, [2643] = 0x8B93, [2644] = 0x8B94,
  [2645] = 0x8B95, [2646] = 0x8B96, [2647] = 0x8B97, [2648] = 0x8B98,
  [2649] = 0x8B99, [2650] = 0x8B9A, [2651] = 0x8B9B, [2652] = 0x8B9C,
  [2653] = 0x8B9D, [2654] = 0x8B9E, [2655] = 0x8B9F, [2656] = 0x8BA0,
  [2657] = 0x8BA1, [2658] = 0x8BA2, [2659] = 0x8BA3, [2660] = 0x8BA4,
  [2661] = 0x8BA5, [2662] = 0x8BA6, [2663] = 0x8BA7, [2664] = 0x8BA8,
  [2665] = 0x8BA9, [2666] = 0x8BAA, [2667] = 0x8BAB, [2668] = 0x8BAC,
  [2669] = 0x8BAD, [2670] = 0x8BAE, [2671] = 0x8BAF, [2672] = 0x8BB0,
  [2673] = 0x8BB1, [2674] = 0x8BB2, [2675] = 0x8BB3, [2676] = 0x8BB4,
  [2677] = 0x8BB5, [2678] = 0x8BB6, [2679] = 0x8BB7, [2680] = 0x8BB8,
  [2681] = 0x8BB9, [2682] = 0x8BBA, [2683] = 0x8BBB, [2684] = 0x8BBC,
  [2685] = 0x8BBD, [2686] = 0x8BBE, [2687] = 0x8BBF, [2688] = 0x8BC0,
  [2689] = 0x8BC1, [2690] = 0x8BC2, [2691] = 0x8BC3, [2692] = 0x8BC4,
  [2693] = 0x8BC5, [2694] = 0x8BC6, [2695] = 0x8BC7, [2696] = 0x8BC8,
  [2697] = 0x8BC9, [2698] = 0x8BCA, [2699] = 0x8BCB, [2700] = 0x8BCC,
  [2701] = 0x8BCD, [2702] = 0x8BCE, [2703] = 0x8BCF, [2704] = 0x8BD0,
  [2705] = 0x8BD1, [2706] = 0x8BD2, [2707] = 0x8BD3, [2708] = 0x8BD4,
  [2709] = 0x8BD5, [2710] = 0x8BD6, [2711] = 0x8BD7, [2712] = 0x8BD8,
  [2713] = 0x8BD9, [2714] = 0x8BDA, [2715] = 0x8BDB, [2716] = 0x8BDC,
  [2717] = 0x8BDD, [2718] = 0x8BDE, [2719] = 0x8BDF, [2720] = 0x8BE0,
  [2721] = 0x8BE1, [2722] = 0x8BE2, [2723] = 0x8BE3, [2724] = 0x8BE4,
  [2725] = 0x8BE5, [2726] = 0x8BE6, [2727] = 0x8BE7, [2728] = 0x8BE8,
  [2729] = 0x8BE9, [2730] = 0x8BEA, [2731] = 0x8BEB, [2732] = 0x8BEC,
  [2733] = 0x8BED, [2734] = 0x8BEE, [2735] = 0x8BEF, [2736] = 0x8BF0,
  [2737] = 0x8BF1, [2738] = 0x8BF2, [2739] = 0x8BF3, [2740] = 0x8BF4,
  [2741] = 0x8BF5, [2742] = 0x8BF6, [2743] = 0x8BF7, [2744] = 0x8BF8,
  [2745] = 0x8BF9, [2746] = 0x8BFA, [2747] = 0x8BFB, [2748] = 0x8BFC,
  [2749] = 0x8BFD, [2750] = 0x8BFE, [2816] = 0x8C40, [2817] = 0x8C41,
  [2818] = 0x8C42, [2819] = 0x8C43, [2820] = 0x8C44, [2821] = 0x8C45,
  [2822] = 0x8C46, [2823] = 0x8C47, [2824] = 0x8C48, [2825] = 0x8C49,
  [2826] = 0x8C4A, [2827] = 0x8C4B, [2828] = 0x8C4C, [2829] = 0x8C4D,
  [2830] = 0x8C4E, [2831] = 0x8C4F, [2832] = 0x8C50, [2833] = 0x8C51,
  [2834] = 0x8C52, [2835] = 0x8C53, [2836] = 0x8C54, [2837] = 0x8C55,
  [2838] = 0x8C56, [2839] = 0x8C57, [2840] = 0x8C58, [2841] = 0x8C59,
  [2842] = 0x8C5A, [2843] = 0x8C5B, [2844] = 0x8C5C, [2845] = 0x8C5D,
  [2846] = 0x8C5E, [2847] = 0x8C5F, [2848] = 0x8C60, [2849] = 0x8C61,
  [2850] = 0x8C62, [2851] = 0x8C63, [2852] = 0x8C64, [2853] = 0x8C65,
  [2854] = 0x8C66, [2855] = 0x8C67, [2856] = 0x8C68, [2857] = 0x8C69,
  [2858] = 0x8C6A, [2859] = 0x8C6B, [2860] = 0x8C6C, [2861] = 0x8C6D,
  [2862] = 0x8C6E, [2863] = 0x8C6F, [2864] = 0x8C70, [2865] = 0x8C71,
  [2866] = 0x8C72, [2867] = 0x8C73, [2868] = 0x8C74, [2869] = 0x8C75,
  [2870] = 0x8C76, [2871] = 0x8C77, [2872] = 0x8C78, [2873] = 0x8C79,
  [2874] = 0x8C7A, [2875] = 0x8C7B, [2876] = 0x8C7C, [2877] = 0x8C7D,
  [2878] = 0x8C7E, [2880] = 0x8C80, [2881] = 0x8C81, [2882] = 0x8C82,
  [2883] = 0x8C83, [2884] = 0x8C84, [2885] = 0x8C85, [2886] = 0x8C86,
  [2887] = 0x8C87, [2888] = 0x8C88, [2889] = 0x8C89, [2890] = 0x8C8A,
  [2891] = 0x8C8B, [2892] = 0x8C8C, [2893] = 0x8C8D, [2894] = 0x8C8E,
  [2895] = 0x8C8F, [2896] = 0x8C90, [2897] = 0x8C91, [2898] = 0x8C92,
  [2899] = 0x8C93, [2900] = 0x8C94, [2901] = 0x8C95, [2902] = 0x8C96,
  [2903] = 0x8C97, [2904] = 0x8C98, [2905] = 0x8C99, [2906] = 0x8C9A,
  [2907] = 0x8C9B, [2908] = 0x8C9C, [2909] = 0x8C9D, [2910] = 0x8C9E,
  [2911] = 0x8C9F, [2912] = 0x8CA0, [2913] = 0x8CA1, [2914] = 0x8CA2,
  [2915] = 0x8CA3, [2916] = 0x8CA4, [2917] = 0x8CA5, [2918] = 0x8CA6,
  [2919] = 0x8CA7, [2920] = 0x8CA8, [2921] = 0x8CA9, [2922] = 0x8CAA,
  [2923] = 0x8CAB, [2924] = 0x8CAC, [2925] = 0x8CAD, [2926] = 0x8CAE,
  [2927] = 0x8CAF, [2928] = 0x8CB0, [2929] = 0x8CB1, [2930] = 0x8CB2,
  [2931] = 0x8CB3, [2932] = 0x8CB4, [2933] = 0x8CB5, [2934] = 0x8CB6,
  [2935] = 0x8CB7, [2936] = 0x8CB8, [2937] = 0x8CB9, [2938] = 0x8CBA,
  [2939] = 0x8CBB, [2940] = 0x8CBC, [2941] = 0x8CBD, [2942] = 0x8CBE,
  [2943] = 0x8CBF, [2944] = 0x8CC0, [2945] = 0x8CC1, [2946] = 0x8CC2,
  [2947] = 0x8CC3, [2948] = 0x8CC4, [2949] = 0x8CC5, [2950] = 0x8CC6,
  [2951] = 0x8CC7, [2952] = 0x8CC8, [2953] = 0x8CC9, [2954] = 0x8CCA,
  [2955] = 0x8CCB, [2956] = 0x8CCC, [2957] = 0x8CCD, [2958] = 0x8CCE,
  [2959] = 0x8CCF, [2960] = 0x8CD0, [2961] = 0x8CD1, [2962] = 0x8CD2,
  [2963] = 0x8CD3, [2964] = 0x8CD4, [2965] = 0x8CD5, [2966] = 0x8CD6,
  [2967] = 0x8CD7, [2968] = 0x8CD8, [2969] = 0x8CD9, [2970] = 0x8CDA,
  [2971] = 0x8CDB, [2972] = 0x8CDC, [2973] = 0x8CDD, [2974] = 0x8CDE,
  [2975] = 0x8CDF, [2976] = 0x8CE0, [2977] = 0x8CE1, [2978] = 0x8CE2,
  [2979] = 0x8CE3, [2980] = 0x8CE4, [2981] = 0x8CE5, [2982] = 0x8CE6,
  [2983] = 0x8CE7, [2984] = 0x8CE8, [2985] = 0x8CE9, [2986] = 0x8CEA,
  [2987] = 0x8CEB, [2988] = 0x8CEC, [2989] = 0x8CED, [2990] = 0x8CEE,
  [2991] = 0x8CEF, [2992] = 0x8CF0, [2993] = 0x8CF1, [2994] = 0x8CF2,
  [2995] = 0x8CF3, [2996] = 0x8CF4, [2997] = 0x8CF5, [2998] = 0x8CF6,
  [2999] = 0x8CF7, [3000] = 0x8CF8, [3001] = 0x8CF9, [3002] = 0x8CFA,
  [3003] = 0x8CFB, [3004] = 0x8CFC, [3005] = 0x8CFD, [3006] = 0x8CFE,
  [3072] = 0x8D40, [3073] = 0x8D41, [3074] = 0x8D42, [3075] = 0x8D43,
  [3076] = 0x8D44, [3077] = 0x8D45, [3078] = 0x8D46, [3079] = 0x8D47,
  [3080] = 0x8D48, [3081] = 0x8D49, [3082] = 0x8D4A, [3083] = 0x8D4B,
  [3084] = 0x8D4C, [3085] = 0x8D4D, [3086] = 0x8D4E, [3087] = 0x8D4F,
  [3088] = 0x8D50, [3089] = 0x8D51, [3090] = 0x8D52, [3091] = 0x8D53,
  [3092] = 0x8D54, [3093] = 0x8D55, [3094] = 0x8D56, [3095] = 0x8D57,
  [3096] = 0x8D58, [3097] = 0x8D59, [3098] = 0x8D5A, [3099] = 0x8D5B,
  [3100] = 0x8D5C, [3101] = 0x8D5D, [3102] = 0x8D5E, [3103] = 0x8D5F,
  [3104] = 0x8D60, [3105] = 0x8D61, [3106] = 0x8D62, [3107] = 0x8D63,
  [3108] = 0x8D64, [3109] = 0x8D65, [3110] = 0x8D66, [3111] = 0x8D67,
  [3112] = 0x8D68, [3113] = 0x8D69, [3114] = 0x8D6A, [3115] = 0x8D6B,
  [3116] = 0x8D6C, [3117] = 0x8D6D, [3118] = 0x8D6E, [3119] = 0x8D6F,
  [3120] = 0x8D70, [3121] = 0x8D71, [3122] = 0x8D72, [3123] = 0x8D73,
  [3124] = 0x8D74, [3125] = 0x8D75, [3126] = 0x8D76, [3127] = 0x8D77,
  [3128] = 0x8D78, [3129] = 0x8D79, [3130] = 0x8D7A, [3131] = 0x8D7B,
  [3132] = 0x8D7C, [3133] = 0x8D7D, [3134] = 0x8D7E, [3136] = 0x8D80,
  [3137] = 0x8D81, [3138] = 0x8D82, [3139] = 0x8D83, [3140] = 0x8D84,
  [3141] = 0x8D85, [3142] = 0x8D86, [3143] = 0x8D87, [3144] = 0x8D88,
  [3145] = 0x8D89, [3146] = 0x8D8A, [3147] = 0x8D8B, [3148] = 0x8D8C,
  [3149] = 0x8D8D, [3150] = 0x8D8E, [3151] = 0x8D8F, [3152] = 0x8D90,
  [3153] = 0x8D91, [3154] = 0x8D92, [3155] = 0x8D93, [3156] = 0x8D94,
  [3157] = 0x8D95, [3158] = 0x8D96, [3159] = 0x8D97, [3160] = 0x8D98,
  [3161] = 0x8D99, [3162] = 0x8D9A, [3163] = 0x8D9B, [3164] = 0x8D9C,
  [3165] = 0x8D9D, [3166] = 0x8D9E, [3167] = 0x8D9F, [3168] = 0x8DA0,
  [3169] = 0x8DA1, [3170] = 0x8DA2, [3171] = 0x8DA3, [3172] = 0x8DA4,
  [3173] = 0x8DA5, [3174] = 0x8DA6, [3175] = 0x8DA7, [3176] = 0x8DA8,
  [3177] = 0x8DA9, [3178] = 0x8DAA, [3179] = 0x8DAB, [3180] = 0x8DAC,
  [3181] = 0x8DAD, [3182] = 0x8DAE, [3183] = 0x8DAF, [3184] = 0x8DB0,
  [3185] = 0x8DB1, [3186] = 0x8DB2, [3187] = 0x8DB3, [3188] = 0x8DB4,
  [3189] = 0x8DB5, [3190] = 0x8DB6, [3191] = 0x8DB7, [3192] = 0x8DB8,
  [3193] = 0x8DB9, [3194] = 0x8DBA, [3195] = 0x8DBB, [3196] = 0x8DBC,
  [3197] = 0x8DBD, [3198] = 0x8DBE, [3199] = 0x8DBF, [3200] = 0x8DC0,
  [3201] = 0x8DC1, [3202] = 0x8DC2, [3203] = 0x8DC3, [3204] = 0x8DC4,
  [3205] = 0x8DC5, [3206] = 0x8DC6, [3207] = 0x8DC7, [3208] = 0x8DC8,
  [3209] = 0x8DC9, [3210] = 0x8DCA, [3211] = 0x8DCB, [3212] = 0x8DCC,
  [3213] = 0x8DCD, [3214] = 0x8DCE, [3215] = 0x8DCF, [3216] = 0x8DD0,
  [3217] = 0x8DD1, [3218] = 0x8DD2, [3219] = 0x8DD3, [3220] = 0x8DD4,
  [3221] = 0x8DD5, [3222] = 0x8DD6, [3223] = 0x8DD7, [3224] = 0x8DD8,
  [3225] = 0x8DD9, [3226] = 0x8DDA, [3227] = 0x8DDB, [3228] = 0x8DDC,
  [3229] = 0x8DDD, [3230] = 0x8DDE, [3231] = 0x8DDF, [3232] = 0x8DE0,
  [3233] = 0x8DE1, [3234] = 0x8DE2, [3235] = 0x8DE3, [3236] = 0x8DE4,
  [3237] = 0x8DE5, [3238] = 0x8DE6, [3239] = 0x8DE7, [3240] = 0x8DE8,
  [3241] = 0x8DE9, [3242] = 0x8DEA, [3243] = 0x8DEB, [3244] = 0x8DEC,
  [3245] = 0x8DED, [3246] = 0x8DEE, [3247] = 0x8DEF, [3248] = 0x8DF0,
  [3249] = 0x8DF1, [3250] = 0x8DF2, [3251] = 0x8DF3, [3252] = 0x8DF4,
  [3253] = 0x8DF5, [3254] = 0x8DF6, [3255] = 0x8DF7, [3256] = 0x8DF8,
  [3257] = 0x8DF9, [3258] = 0x8DFA, [3259] = 0x8DFB, [3260] = 0x8DFC,
  [3261] = 0x8DFD, [3262] = 0x8DFE, [3328] = 0x8E40, [3329] = 0x8E41,
  [3330] = 0x8E42, [3331] = 0x8E43, [3332] = 0x8E44, [3333] = 0x8E45,
  [3334] = 0x8E46, [3335] = 0x8E47, [3336] = 0x8E48, [3337] = 0x8E49,
  [3338] = 0x8E4A, [3339] = 0x8E4B, [3340] = 0x8E4C, [3341] = 0x8E4D,
  [3342] = 0x8E4E, [3343] = 0x8E4F, [3344] = 0x8E50, [3345] = 0x8E51,
  [3346] = 0x8E52, [3347] = 0x8E53, [3348] = 0x8E54, [3349] = 0x8E55,
  [3350] = 0x8E56, [3351] = 0x8E57, [3352] = 0x8E58, [3353] = 0x8E59,
  [3354] = 0x8E5A, [3355] = 0x8E5B, [3356] = 0x8E5C, [3357] = 0x8E5D,
  [3358] = 0x8E5E, [3359] = 0x8E5F, [3360] = 0x8E60, [3361] = 0x8E61,
  [3362] = 0x8E62, [3363] = 0x8E63, [3364] = 0x8E64, [3365] = 0x8E65,
  [3366] = 0x8E66, [3367] = 0x8E67, [3368] = 0x8E68, [3369] = 0x8E69,
  [3370] = 0x8E6A, [3371] = 0x8E6B, [3372] = 0x8E6C, [3373] = 0x8E6D,
  [3374] = 0x8E6E, [3375] = 0x8E6F, [3376] = 0x8E70, [3377] = 0x8E71,
  [3378] = 0x8E72, [3379] = 0x8E73, [3380] = 0x8E74, [3381] = 0x8E75,
  [3382] = 0x8E76, [3383] = 0x8E77, [3384] = 0x8E78, [3385] = 0x8E79,
  [3386] = 0x8E7A, [3387] = 0x8E7B, [3388] = 0x8E7C, [3389] = 0x8E7D,
  [3390] = 0x8E7E, [3392] = 0x8E80, [3393] = 0x8E81, [3394] = 0x8E82,
  [3395] = 0x8E83, [3396] = 0x8E84, [3397] = 0x8E85, [3398] = 0x8E86,
  [3399] = 0x8E87, [3400] = 0x8E88, [3401] = 0x8E89, [3402] = 0x8E8A,
  [3403] = 0x8E8B, [3404] = 0x8E8C, [3405] = 0x8E8D, [3406] = 0x8E8E,
  [3407] = 0x8E8F, [3408] = 0x8E90, [3409] = 0x8E91, [3410] = 0x8E92,
  [3411] = 0x8E93, [3412] = 0x8E94, [3413] = 0x8E95, [3414] = 0x8E96,
  [3415] = 0x8E97, [3416] = 0x8E98, [3417] = 0x8E99, [3418] = 0x8E9A,
  [3419] = 0x8E9B, [3420] = 0x8E9C, [3421] = 0x8E9D, [3422] = 0x8E9E,
  [3423] = 0x8E9F, [3424] = 0x8EA0, [3425] = 0x8EA1, [3426] = 0x8EA2,
  [3427] = 0x8EA3, [3428] = 0x8EA4, [3429] = 0x8EA5, [3430] = 0x8EA6,
  [3431] = 0x8EA7, [3432] = 0x8EA8, [3433] = 0x8EA9, [3434] = 0x8EAA,
  [3435] = 0x8EAB, [3436] = 0x8EAC, [3437] = 0x8EAD, [3438] = 0x8EAE,
  [3439] = 0x8EAF, [3440] = 0x8EB0, [3441] = 0x8EB1, [3442] = 0x8EB2,
  [3443] = 0x8EB3, [3444] = 0x8EB4, [3445] = 0x8EB5, [3446] = 0x8EB6,
  [3447] = 0x8EB7, [3448] = 0x8EB8, [3449] = 0x8EB9, [3450] = 0x8EBA,
  [3451] = 0x8EBB, [3452] = 0x8EBC, [3453] = 0x8EBD, [3454] = 0x8EBE,
  [3455] = 0x8EBF, [3456] = 0x8EC0, [3457] = 0x8EC1, [3458] = 0x8EC2,
  [3459] = 0x8EC3, [3460] = 0x8EC4, [3461] = 0x8EC5, [3462] = 0x8EC6,
  [3463] = 0x8EC7, [3464] = 0x8EC8, [3465] = 0x8EC9, [3466] = 0x8ECA,
  [3467] = 0x8ECB, [3468] = 0x8ECC, [3469] = 0x8ECD, [3470] = 0x8ECE,
  [3471] = 0x8ECF, [3472] = 0x8ED0, [3473] = 0x8ED1, [3474] = 0x8ED2,
  [3475] = 0x8ED3, [3476] = 0x8ED4, [3477] = 0x8ED5, [3478] = 0x8ED6,
  [3479] = 0x8ED7, [3480] = 0x8ED8, [3481] = 0x8ED9, [3482] = 0x8EDA,
  [3483] = 0x8EDB, [3484] = 0x8EDC, [3485] = 0x8EDD, [3486] = 0x8EDE,
  [3487] = 0x8EDF, [3488] = 0x8EE0, [3489] = 0x8EE1, [3490] = 0x8EE2,
  [3491] = 0x8EE3, [3492] = 0x8EE4, [3493] = 0x8EE5, [3494] = 0x8EE6,
  [3495] = 0x8EE7, [3496] = 0x8EE8, [3497] = 0x8EE9, [3498] = 0x8EEA,
  [3499] = 0x8EEB, [3500] = 0x8EEC, [3501] = 0x8EED, [3502] = 0x8EEE,
  [3503] = 0x8EEF, [3504] = 0x8EF0, [3505] = 0x8EF1, [3506] = 0x8EF2,
  [3507] = 0x8EF3, [3508] = 0x8EF4, [3509] = 0x8EF5, [3510] = 0x8EF6,
  [3511] = 0x8EF7, [3512] = 0x8EF8, [3513] = 0x8EF9, [3514] = 0x8EFA,
  [3515] = 0x8EFB, [3516] = 0x8EFC, [3517] = 0x8EFD, [3518] = 0x8EFE,
  [3584] = 0x8F40, [3585] = 0x8F41, [3586] = 0x8F42, [3587] = 0x8F43,
  [3588] = 0x8F44, [3589] = 0x8F45, [3590] = 0x8F46, [3591] = 0x8F47,
  [3592] = 0x8F48, [3593] = 0x8F49, [3594] = 0x8F4A, [3595] = 0x8F4B,
  [3596] = 0x8F4C, [3597] = 0x8F4D, [3598] = 0x8F4E, [3599] = 0x8F4F,
  [3600] = 0x8F50, [3601] = 0x8F51, [3602] = 0x8F52, [3603] = 0x8F53,
  [3604] = 0x8F54, [3605] = 0x8F55, [3606] = 0x8F56, [3607] = 0x8F57,
  [3608] = 0x8F58, [3609] = 0x8F59, [3610] = 0x8F5A, [3611] = 0x8F5B,
  [3612] = 0x8F5C, [3613] = 0x8F5D, [3614] = 0x8F5E, [3615] = 0x8F5F,
  [3616] = 0x8F60, [3617] = 0x8F61, [3618] = 0x8F62, [3619] = 0x8F63,
  [3620] = 0x8F64, [3621] = 0x8F65, [3622] = 0x8F66, [3623] = 0x8F67,
  [3624] = 0x8F68, [3625] = 0x8F69, [3626] = 0x8F6A, [3627] = 0x8F6B,
  [3628] = 0x8F6C, [3629] = 0x8F6D, [3630] = 0x8F6E, [3631] = 0x8F6F,
  [3632] = 0x8F70, [3633] = 0x8F71, [3634] = 0x8F72, [3635] = 0x8F73,
  [3636] = 0x8F74, [3637] = 0x8F75, [3638] = 0x8F76, [3639] = 0x8F77,
  [3640] = 0x8F78, [3641] = 0x8F79, [3642] = 0x8F7A, [3643] = 0x8F7B,
  [3644] = 0x8F7C, [3645] = 0x8F7D, [3646] = 0x8F7E, [3648] = 0x8F80,
  [3649] = 0x8F81, [3650] = 0x8F82, [3651] = 0x8F83, [3652] = 0x8F84,
  [3653] = 0x8F85, [3654] = 0x8F86, [3655] = 0x8F87, [3656] = 0x8F88,
  [3657] = 0x8F89, [3658] = 0x8F8A, [3659] = 0x8F8B, [3660] = 0x8F8C,
  [3661] = 0x8F8D, [3662] = 0x8F8E, [3663] = 0x8F8F, [3664] = 0x8F90,
  [3665] = 0x8F91, [3666] = 0x8F92, [3667] = 0x8F93, [3668] = 0x8F94,
  [3669] = 0x8F95, [3670] = 0x8F96, [3671] = 0x8F97, [3672] = 0x8F98,
  [3673] = 0x8F99, [3674] = 0x8F9A, [3675] = 0x8F9B, [3676] = 0x8F9C,
  [3677] = 0x8F9D, [3678] = 0x8F9E, [3679] = 0x8F9F, [3680] = 0x8FA0,
  [3681] = 0x8FA1, [3682] = 0x8FA2, [3683] = 0x8FA3, [3684] = 0x8FA4,
  [3685] = 0x8FA5, [3686] = 0x8FA6, [3687] = 0x8FA7, [3688] = 0x8FA8,
  [3689] = 0x8FA9, [3690] = 0x8FAA, [3691] = 0x8FAB, [3692] = 0x8FAC,
  [3693] = 0x8FAD, [3694] = 0x8FAE, [3695] = 0x8FAF, [3696] = 0x8FB0,
  [3697] = 0x8FB1, [3698] = 0x8FB2, [3699] = 0x8FB3, [3700] = 0x8FB4,
  [3701] = 0x8FB5, [3702] = 0x8FB6, [3703] = 0x8FB7, [3704] = 0x8FB8,
  [3705] = 0x8FB9, [3706] = 0x8FBA, [3707] = 0x8FBB, [3708] = 0x8FBC,
  [3709] = 0x8FBD, [3710] = 0x8FBE, [3711] = 0x8FBF, [3712] = 0x8FC0,
  [3713] = 0x8FC1, [3714] = 0x8FC2, [3715] = 0x8FC3, [3716] = 0x8FC4,
  [3717] = 0x8FC5, [3718] = 0x8FC6, [3719] = 0x8FC7, [3720] = 0x8FC8,
  [3721] = 0x8FC9, [3722] = 0x8FCA, [3723] = 0x8FCB, [3724] = 0x8FCC,
  [3725] = 0x8FCD, [3726] = 0x8FCE, [3727] = 0x8FCF, [3728] = 0x8FD0,
  [3729] = 0x8FD1, [3730] = 0x8FD2, [3731] = 0x8FD3, [3732] = 0x8FD4,
  [3733] = 0x8FD5, [3734] = 0x8FD6, [3735] = 0x8FD7, [3736] = 0x8FD8,
  [3737] = 0x8FD9, [3738] = 0x8FDA, [3739] = 0x8FDB, [3740] = 0x8FDC,
  [3741] = 0x8FDD, [3742] = 0x8FDE, [3743] = 0x8FDF, [3744] = 0x8FE0,
  [3745] = 0x8FE1, [3746] = 0x8FE2, [3747] = 0x8FE3, [3748] = 0x8FE4,
  [3749] = 0x8FE5, [3750] = 0x8FE6, [3751] = 0x8FE7, [3752] = 0x8FE8,
  [3753] = 0x8FE9, [3754] = 0x8FEA, [3755] = 0x8FEB, [3756] = 0x8FEC,
  [3757] = 0x8FED, [3758] = 0x8FEE, [3759] = 0x8FEF, [3760] = 0x8FF0,
  [3761] = 0x8FF1, [3762] = 0x8FF2, [3763] = 0x8FF3, [3764] = 0x8FF4,
  [3765] = 0x8FF5, [3766] = 0x8FF6, [3767] = 0x8FF7, [3768] = 0x8FF8,
  [3769] = 0x8FF9, [3770] = 0x8FFA, [3771] = 0x8FFB, [3772] = 0x8FFC,
  [3773] = 0x8FFD, [3774] = 0x8FFE, [3840] = 0x9040, [3841] = 0x9041,
  [3842] = 0x9042, [3843] = 0x9043, [3844] = 0x9044, [3845] = 0x9045,
  [3846] = 0x9046, [3847] = 0x9047, [3848] = 0x9048, [3849] = 0x9049,
  [3850] = 0x904A, [3851] = 0x904B, [3852] = 0x904C, [3853] = 0x904D,
  [3854] = 0x904E, [3855] = 0x904F, [3856] = 0x9050, [3857] = 0x9051,
  [3858] = 0x9052, [3859] = 0x9053, [3860] = 0x9054, [3861] = 0x9055,
  [3862] = 0x9056, [3863] = 0x9057, [3864] = 0x9058, [3865] = 0x9059,
  [3866] = 0x905A, [3867] = 0x905B, [3868] = 0x905C, [3869] = 0x905D,
  [3870] = 0x905E, [3871] = 0x905F, [3872] = 0x9060, [3873] = 0x9061,
  [3874] = 0x9062, [3875] = 0x9063, [3876] = 0x9064, [3877] = 0x9065,
  [3878] = 0x9066, [3879] = 0x9067, [3880] = 0x9068, [3881] = 0x9069,
  [3882] = 0x906A, [3883] = 0x906B, [3884] = 0x906C, [3885] = 0x906D,
  [3886] = 0x906E, [3887] = 0x906F, [3888] = 0x9070, [3889] = 0x9071,
  [3890] = 0x9072, [3891] = 0x9073, [3892] = 0x9074, [3893] = 0x9075,
  [3894] = 0x9076, [3895] = 0x9077, [3896] = 0x9078, [3897] = 0x9079,
  [3898] = 0x907A, [3899] = 0x907B, [3900] = 0x907C, [3901] = 0x907D,
  [3902] = 0x907E, [3904] = 0x9080, [3905] = 0x9081, [3906] = 0x9082,
  [3907] = 0x9083, [3908] = 0x9084, [3909] = 0x9085, [3910] = 0x9086,
  [3911] = 0x9087, [3912] = 0x9088, [3913] = 0x9089, [3914] = 0x908A,
  [3915] = 0x908B, [3916] = 0x908C, [3917] = 0x908D, [3918] = 0x908E,
  [3919] = 0x908F, [3920] = 0x9090, [3921] = 0x9091, [3922] = 0x9092,
  [3923] = 0x9093, [3924] = 0x9094, [3925] = 0x9095, [3926] = 0x9096,
  [3927] = 0x9097, [3928] = 0x9098, [3929] = 0x9099, [3930] = 0x909A,
  [3931] = 0x909B, [3932] = 0x909C, [3933] = 0x909D, [3934] = 0x909E,
  [3935] = 0x909F, [3936] = 0x90A0, [3937] = 0x90A1, [3938] = 0x90A2,
  [3939] = 0x90A3, [3940] = 0x90A4, [3941] = 0x90A5, [3942] = 0x90A6,
  [3943] = 0x90A7, [3944] = 0x90A8, [3945] = 0x90A9, [3946] = 0x90AA,
  [3947] = 0x90AB, [3948] = 0x90AC, [3949] = 0x90AD, [3950] = 0x90AE,
  [3951] = 0x90AF, [3952] = 0x90B0, [3953] = 0x90B1, [3954] = 0x90B2,
  [3955] = 0x90B3, [3956] = 0x90B4, [3957] = 0x90B5, [3958] = 0x90B6,
  [3959] = 0x90B7, [3960] = 0x90B8, [3961] = 0x90B9, [3962] = 0x90BA,
  [3963] = 0x90BB, [3964] = 0x90BC, [3965] = 0x90BD, [3966] = 0x90BE,
  [3967] = 0x90BF, [3968] = 0x90C0, [3969] = 0x90C1, [3970] = 0x90C2,
  [3971] = 0x90C3, [3972] = 0x90C4, [3973] = 0x90C5, [3974] = 0x90C6,
  [3975] = 0x90C7, [3976] = 0x90C8, [3977] = 0x90C9, [3978] = 0x90CA,
  [3979] = 0x90CB, [3980] = 0x90CC, [3981] = 0x90CD, [3982] = 0x90CE,
  [3983] = 0x90CF, [3984] = 0x90D0, [3985] = 0x90D1, [3986] = 0x90D2,
  [3987] = 0x90D3, [3988] = 0x90D4, [3989] = 0x90D5, [3990] = 0x90D6,
  [3991] = 0x90D7, [3992] = 0x90D8, [3993] = 0x90D9, [3994] = 0x90DA,
  [3995] = 0x90DB, [3996] = 0x90DC, [3997] = 0x90DD, [3998] = 0x90DE,
  [3999] = 0x90DF, [4000] = 0x90E0, [4001] = 0x90E1, [4002] = 0x90E2,
  [4003] = 0x90E3, [4004] = 0x90E4, [4005] = 0x90E5, [4006] = 0x90E6,
  [4007] = 0x90E7, [4008] = 0x90E8, [4009] = 0x90E9, [4010] = 0x90EA,
  [4011] = 0x90EB, [4012] = 0x90EC, [4013] = 0x90ED, [4014] = 0x90EE,
  [4015] = 0x90EF, [4016] = 0x90F0, [4017] = 0x90F1, [4018] = 0x90F2,
  [4019] = 0x90F3, [4020] = 0x90F4, [4021] = 0x90F5, [4022] = 0x90F6,
  [4023] = 0x90F7, [4024] = 0x90F8, [4025] = 0x90F9, [4026] = 0x90FA,
  [4027] = 0x90FB, [4028] = 0x90FC, [4029] = 0x90FD, [4030] = 0x90FE,
  [4096] = 0x9140, [4097] = 0x9141, [4098] = 0x9142, [4099] = 0x9143,
  [4100] = 0x9144, [4101] = 0x9145, [4102] = 0x9146, [4103] = 0x9147,
  [4104] = 0x9148, [4105] = 0x9149, [4106] = 0x914A, [4107] = 0x914B,
  [4108] = 0x914C, [4109] = 0x914D, [4110] = 0x914E, [4111] = 0x914F,
  [4112] = 0x9150, [4113] = 0x9151, [4114] = 0x9152, [4115] = 0x9153,
  [4116] = 0x9154, [4117] = 0x9155, [4118] = 0x9156, [4119] = 0x9157,
  [4120] = 0x9158, [4121] = 0x9159, [4122] = 0x915A, [4123] = 0x915B,
  [4124] = 0x915C, [4125] = 0x915D, [4126] = 0x915E, [4127] = 0x915F,
  [4128] = 0x9160, [4129] = 0x9161, [4130] = 0x9162, [4131] = 0x9163,
  [4132] = 0x9164, [4133] = 0x9165, [4134] = 0x9166, [4135] = 0x9167,
  [4136] = 0x9168, [4137] = 0x9169, [4138] = 0x916A, [4139] = 0x916B,
  [4140] = 0x916C, [4141] = 0x916D, [4142] = 0x916E, [4143] = 0x916F,
  [4144] = 0x9170, [4145] = 0x9171, [4146] = 0x9172, [4147] = 0x9173,
  [4148] = 0x9174, [4149] = 0x9175, [4150] = 0x9176, [4151] = 0x9177,
  [4152] = 0x9178, [4153] = 0x9179, [4154] = 0x917A, [4155] = 0x917B,
  [4156] = 0x917C, [4157] = 0x917D, [4158] = 0x917E, [4160] = 0x9180,
  [4161] = 0x9181, [4162] = 0x9182, [4163] = 0x9183, [4164] = 0x9184,
  [4165] = 0x9185, [4166] = 0x9186, [4167] = 0x9187, [4168] = 0x9188,
  [4169] = 0x9189, [4170] = 0x918A, [4171] = 0x918B, [4172] = 0x918C,
  [4173] = 0x918D, [4174] = 0x918E, [4175] = 0x918F, [4176] = 0x9190,
  [4177] = 0x9191, [4178] = 0x9192, [4179] = 0x9193, [4180] = 0x9194,
  [4181] = 0x9195, [4182] = 0x9196, [4183] = 0x9197, [4184] = 0x9198,
  [4185] = 0x9199, [4186] = 0x919A, [4187] = 0x919B, [4188] = 0x919C,
  [4189] = 0x919D, [4190] = 0x919E, [4191] = 0x919F, [4192] = 0x91A0,
  [4193] = 0x91A1, [4194] = 0x91A2, [4195] = 0x91A3, [4196] = 0x91A4,
  [4197] = 0x91A5, [4198] = 0x91A6, [4199] = 0x91A7, [4200] = 0x91A8,
  [4201] = 0x91A9, [4202] = 0x91AA, [4203] = 0x91AB, [4204] = 0x91AC,
  [4205] = 0x91AD, [4206] = 0x91AE, [4207] = 0x91AF, [4208] = 0x91B0,
  [4209] = 0x91B1, [4210] = 0x91B2, [4211] = 0x91B3, [4212] = 0x91B4,
  [4213] = 0x91B5, [4214] = 0x91B6, [4215] = 0x91B7, [4216] = 0x91B8,
  [4217] = 0x91B9, [4218] = 0x91BA, [4219] = 0x91BB, [4220] = 0x91BC,
  [4221] = 0x91BD, [4222] = 0x91BE, [4223] = 0x91BF, [4224] = 0x91C0,
  [4225] = 0x91C1, [4226] = 0x91C2, [4227] = 0x91C3, [4228] = 0x91C4,
  [4229] = 0x91C5, [4230] = 0x91C6, [4231] = 0x91C7, [4232] = 0x91C8,
  [4233] = 0x91C9, [4234] = 0x91CA, [4235] = 0x91CB, [4236] = 0x91CC,
  [4237] = 0x91CD, [4238] = 0x91CE, [4239] = 0x91CF, [4240] = 0x91D0,
  [4241] = 0x91D1, [4242] = 0x91D2, [4243] = 0x91D3, [4244] = 0x91D4,
  [4245] = 0x91D5, [4246] = 0x91D6, [4247] = 0x91D7, [4248] = 0x91D8,
  [4249] = 0x91D9, [4250] = 0x91DA, [4251] = 0x91DB, [4252] = 0x91DC,
  [4253] = 0x91DD, [4254] = 0x91DE, [4255] = 0x91DF, [4256] = 0x91E0,
  [4257] = 0x91E1, [4258] = 0x91E2, [4259] = 0x91E3, [4260] = 0x91E4,
  [4261] = 0x91E5, [4262] = 0x91E6, [4263] = 0x91E7, [4264] = 0x91E8,
  [4265] = 0x91E9, [4266] = 0x91EA, [4267] = 0x91EB, [4268] = 0x91EC,
  [4269] = 0x91ED, [4270] = 0x91EE, [4271] = 0x91EF, [4272] = 0x91F0,
  [4273] = 0x91F1, [4274] = 0x91F2, [4275] = 0x91F3, [4276] = 0x91F4,
  [4277] = 0x91F5, [4278] = 0x91F6, [4279] = 0x91F7, [4280] = 0x91F8,
  [4281] = 0x91F9, [4282] = 0x91FA, [4283] = 0x91FB, [4284] = 0x91FC,
  [4285] = 0x91FD, [4286] = 0x91FE, [4352] = 0x9240, [4353] = 0x9241,
  [4354] = 0x9242, [4355] = 0x9243, [4356] = 0x9244, [4357] = 0x9245,
  [4358] = 0x9246, [4359] = 0x9247, [4360] = 0x9248, [4361] = 0x9249,
  [4362] = 0x924A, [4363] = 0x924B, [4364] = 0x924C, [4365] = 0x924D,
  [4366] = 0x924E, [4367] = 0x924F, [4368] = 0x9250, [4369] = 0x9251,
  [4370] = 0x9252, [4371] = 0x9253, [4372] = 0x9254, [4373] = 0x9255,
  [4374] = 0x9256, [4375] = 0x9257, [4376] = 0x9258, [4377] = 0x9259,
  [4378] = 0x925A, [4379] = 0x925B, [4380] = 0x925C, [4381] = 0x925D,
  [4382] = 0x925E, [4383] = 0x925F, [4384] = 0x9260, [4385] = 0x9261,
  [4386] = 0x9262, [4387] = 0x9263, [4388] = 0x9264, [4389] = 0x9265,
  [4390] = 0x9266, [4391] = 0x9267, [4392] = 0x9268, [4393] = 0x9269,
  [4394] = 0x926A, [4395] = 0x926B, [4396] = 0x926C, [4397] = 0x926D,
  [4398] = 0x926E, [4399] = 0x926F, [4400] = 0x9270, [4401] = 0x9271,
  [4402] = 0x9272, [4403] = 0x9273, [4404] = 0x9274, [4405] = 0x9275,
  [4406] = 0x9276, [4407] = 0x9277, [4408] = 0x9278, [4409] = 0x9279,
  [4410] = 0x927A, [4411] = 0x927B, [4412] = 0x927C, [4413] = 0x927D,
  [4414] = 0x927E, [4416] = 0x9280, [4417] = 0x9281, [4418] = 0x9282,
  [4419] = 0x9283, [4420] = 0x9284, [4421] = 0x9285, [4422] = 0x9286,
  [4423] = 0x9287, [4424] = 0x9288, [4425] = 0x9289, [4426] = 0x928A,
  [4427] = 0x928B, [4428] = 0x928C, [4429] = 0x928D, [4430] = 0x928E,
  [4431] = 0x928F, [4432] = 0x9290, [4433] = 0x9291, [4434] = 0x9292,
  [4435] = 0x9293, [4436] = 0x9294, [4437] = 0x9295, [4438] = 0x9296,
  [4439] = 0x9297, [4440] = 0x9298, [4441] = 0x9299, [4442] = 0x929A,
  [4443] = 0x929B, [4444] = 0x929C, [4445] = 0x929D, [4446] = 0x929E,
  [4447] = 0x929F, [4448] = 0x92A0, [4449] = 0x92A1, [4450] = 0x92A2,
  [4451] = 0x92A3, [4452] = 0x92A4, [4453] = 0x92A5, [4454] = 0x92A6,
  [4455] = 0x92A7, [4456] = 0x92A8, [4457] = 0x92A9, [4458] = 0x92AA,
  [4459] = 0x92AB, [4460] = 0x92AC, [4461] = 0x92AD, [4462] = 0x92AE,
  [4463] = 0x92AF, [4464] = 0x92B0, [4465] = 0x92B1, [4466] = 0x92B2,
  [4467] = 0x92B3, [4468] = 0x92B4, [4469] = 0x92B5, [4470] = 0x92B6,
  [4471] = 0x92B7, [4472] = 0x92B8, [4473] = 0x92B9, [4474] = 0x92BA,
  [4475] = 0x92BB, [4476] = 0x92BC, [4477] = 0x92BD, [4478] = 0x92BE,
  [4479] = 0x92BF, [4480] = 0x92C0, [4481] = 0x92C1, [4482] = 0x92C2,
  [4483] = 0x92C3, [4484] = 0x92C4, [4485] = 0x92C5, [4486] = 0x92C6,
  [4487] = 0x92C7, [4488] = 0x92C8, [4489] = 0x92C9, [4490] = 0x92CA,
  [4491] = 0x92CB, [4492] = 0x92CC, [4493] = 0x92CD, [4494] = 0x92CE,
  [4495] = 0x92CF, [4496] = 0x92D0, [4497] = 0x92D1, [4498] = 0x92D2,
  [4499] = 0x92D3, [4500] = 0x92D4, [4501] = 0x92D5, [4502] = 0x92D6,
  [4503] = 0x92D7, [4504] = 0x92D8, [4505] = 0x92D9, [4506] = 0x92DA,
  [4507] = 0x92DB, [4508] = 0x92DC, [4509] = 0x92DD, [4510] = 0x92DE,
  [4511] = 0x92DF, [4512] = 0x92E0, [4513] = 0x92E1, [4514] = 0x92E2,
  [4515] = 0x92E3, [4516] = 0x92E4, [4517] = 0x92E5, [4518] = 0x92E6,
  [4519] = 0x92E7, [4520] = 0x92E8, [4521] = 0x92E9, [4522] = 0x92EA,
  [4523] = 0x92EB, [4524] = 0x92EC, [4525] = 0x92ED, [4526] = 0x92EE,
  [4527] = 0x92EF, [4528] = 0x92F0, [4529] = 0x92F1, [4530] = 0x92F2,
  [4531] = 0x92F3, [4532] = 0x92F4, [4533] = 0x92F5, [4534] = 0x92F6,
  [4535] = 0x92F7, [4536] = 0x92F8, [4537] = 0x92F9, [4538] = 0x92FA,
  [4539] = 0x92FB, [4540] = 0x92FC, [4541] = 0x92FD, [4542] = 0x92FE,
  [4608] = 0x9340, [4609] = 0x9341, [4610] = 0x9342, [4611] = 0x9343,
  [4612] = 0x9344, [4613] = 0x9345, [4614] = 0x9346, [4615] = 0x9347,
  [4616] = 0x9348, [4617] = 0x9349, [4618] = 0x934A, [4619] = 0x934B,
  [4620] = 0x934C, [4621] = 0x934D, [4622] = 0x934E, [4623] = 0x934F,
  [4624] = 0x9350, [4625] = 0x9351, [4626] = 0x9352, [4627] = 0x9353,
  [4628] = 0x9354, [4629] = 0x9355, [4630] = 0x9356, [4631] = 0x9357,
  [4632] = 0x9358, [4633] = 0x9359, [4634] = 0x935A, [4635] = 0x935B,
  [4636] = 0x935C, [4637] = 0x935D, [4638] = 0x935E, [4639] = 0x935F,
  [4640] = 0x9360, [4641] = 0x9361, [4642] = 0x9362, [4643] = 0x9363,
  [4644] = 0x9364, [4645] = 0x9365, [4646] = 0x9366, [4647] = 0x9367,
  [4648] = 0x9368, [4649] = 0x9369, [4650] = 0x936A, [4651] = 0x936B,
  [4652] = 0x936C, [4653] = 0x936D, [4654] = 0x936E, [4655] = 0x936F,
  [4656] = 0x9370, [4657] = 0x9371, [4658] = 0x9372, [4659] = 0x9373,
  [4660] = 0x9374, [4661] = 0x9375, [4662] = 0x9376, [4663] = 0x9377,
  [4664] = 0x9378, [4665] = 0x9379, [4666] = 0x937A, [4667] = 0x937B,
  [4668] = 0x937C, [4669] = 0x937D, [4670] = 0x937E, [4672] = 0x9380,
  [4673] = 0x9381, [4674] = 0x9382, [4675] = 0x9383, [4676] = 0x9384,
  [4677] = 0x9385, [4678] = 0x9386, [4679] = 0x9387, [4680] = 0x9388,
  [4681] = 0x9389, [4682] = 0x938A, [4683] = 0x938B, [4684] = 0x938C,
  [4685] = 0x938D, [4686] = 0x938E, [4687] = 0x938F, [4688] = 0x9390,
  [4689] = 0x9391, [4690] = 0x9392, [4691] = 0x9393, [4692] = 0x9394,
  [4693] = 0x9395, [4694] = 0x9396, [4695] = 0x9397, [4696] = 0x9398,
  [4697] = 0x9399, [4698] = 0x939A, [4699] = 0x939B, [4700] = 0x939C,
  [4701] = 0x939D, [4702] = 0x939E, [4703] = 0x939F, [4704] = 0x93A0,
  [4705] = 0x93A1, [4706] = 0x93A2, [4707] = 0x93A3, [4708] = 0x93A4,
  [4709] = 0x93A5, [4710] = 0x93A6, [4711] = 0x93A7, [4712] = 0x93A8,
  [4713] = 0x93A9, [4714] = 0x93AA, [4715] = 0x93AB, [4716] = 0x93AC,
  [4717] = 0x93AD, [4718] = 0x93AE, [4719] = 0x93AF, [4720] = 0x93B0,
  [4721] = 0x93B1, [4722] = 0x93B2, [4723] = 0x93B3, [4724] = 0x93B4,
  [4725] = 0x93B5, [4726] = 0x93B6, [4727] = 0x93B7, [4728] = 0x93B8,
  [4729] = 0x93B9, [4730] = 0x93BA, [4731] = 0x93BB, [4732] = 0x93BC,
  [4733] = 0x93BD, [4734] = 0x93BE, [4735] = 0x93BF, [4736] = 0x93C0,
  [4737] = 0x93C1, [4738] = 0x93C2, [4739] = 0x93C3, [4740] = 0x93C4,
  [4741] = 0x93C5, [4742] = 0x93C6, [4743] = 0x93C7, [4744] = 0x93C8,
  [4745] = 0x93C9, [4746] = 0x93CA, [4747] = 0x93CB, [4748] = 0x93CC,
  [4749] = 0x93CD, [4750] = 0x93CE, [4751] = 0x93CF, [4752] = 0x93D0,
  [4753] = 0x93D1, [4754] = 0x93D2, [4755] = 0x93D3, [4756] = 0x93D4,
  [4757] = 0x93D5, [4758] = 0x93D6, [4759] = 0x93D7, [4760] = 0x93D8,
  [4761] = 0x93D9, [4762] = 0x93DA, [4763] = 0x93DB, [4764] = 0x93DC,
  [4765] = 0x93DD, [4766] = 0x93DE, [4767] = 0x93DF, [4768] = 0x93E0,
  [4769] = 0x93E1, [4770] = 0x93E2, [4771] = 0x93E3, [4772] = 0x93E4,
  [4773] = 0x93E5, [4774] = 0x93E6, [4775] = 0x93E7, [4776] = 0x93E8,
  [4777] = 0x93E9, [4778] = 0x93EA, [4779] = 0x93EB, [4780] = 0x93EC,
  [4781] = 0x93ED, [4782] = 0x93EE, [4783] = 0x93EF, [4784] = 0x93F0,
  [4785] = 0x93F1, [4786] = 0x93F2, [4787] = 0x93F3, [4788] = 0x93F4,
  [4789] = 0x93F5, [4790] = 0x93F6, [4791] = 0x93F7, [4792] = 0x93F8,
  [4793] = 0x93F9, [4794] = 0x93FA, [4795] = 0x93FB, [4796] = 0x93FC,
  [4797] = 0x93FD, [4798] = 0x93FE, [4864] = 0x9440, [4865] = 0x9441,
  [4866] = 0x9442, [4867] = 0x9443, [4868] = 0x9444, [4869] = 0x9445,
  [4870] = 0x9446, [4871] = 0x9447, [4872] = 0x9448, [4873] = 0x9449,
  [4874] = 0x944A, [4875] = 0x944B, [4876] = 0x944C, [4877] = 0x944D,
  [4878] = 0x944E, [4879] = 0x944F, [4880] = 0x9450, [4881] = 0x9451,
  [4882] = 0x9452, [4883] = 0x9453, [4884] = 0x9454, [4885] = 0x9455,
  [4886] = 0x9456, [4887] = 0x9457, [4888] = 0x9458, [4889] = 0x9459,
  [4890] = 0x945A, [4891] = 0x945B, [4892] = 0x945C, [4893] = 0x945D,
  [4894] = 0x945E, [4895] = 0x945F, [4896] = 0x9460, [4897] = 0x9461,
  [4898] = 0x9462, [4899] = 0x9463, [4900] = 0x9464, [4901] = 0x9465,
  [4902] = 0x9466, [4903] = 0x9467, [4904] = 0x9468, [4905] = 0x9469,
  [4906] = 0x946A, [4907] = 0x946B, [4908] = 0x946C, [4909] = 0x946D,
  [4910] = 0x946E, [4911] = 0x946F, [4912] = 0x9470, [4913] = 0x9471,
  [4914] = 0x9472, [4915] = 0x9473, [4916] = 0x9474, [4917] = 0x9475,
  [4918] = 0x9476, [4919] = 0x9477, [4920] = 0x9478, [4921] = 0x9479,
  [4922] = 0x947A, [4923] = 0x947B, [4924] = 0x947C, [4925] = 0x947D,
  [4926] = 0x947E, [4928] = 0x9480, [4929] = 0x9481, [4930] = 0x9482,
  [4931] = 0x9483, [4932] = 0x9484, [4933] = 0x9485, [4934] = 0x9486,
  [4935] = 0x9487, [4936] = 0x9488, [4937] = 0x9489, [4938] = 0x948A,
  [4939] = 0x948B, [4940] = 0x948C, [4941] = 0x948D, [4942] = 0x948E,
  [4943] = 0x948F, [4944] = 0x9490, [4945] = 0x9491, [4946] = 0x9492,
  [4947] = 0x9493, [4948] = 0x9494, [4949] = 0x9495, [4950] = 0x9496,
  [4951] = 0x9497, [4952] = 0x9498, [4953] = 0x9499, [4954] = 0x949A,
  [4955] = 0x949B, [4956] = 0x949C, [4957] = 0x949D, [4958] = 0x949E,
  [4959] = 0x949F, [4960] = 0x94A0, [4961] = 0x94A1, [4962] = 0x94A2,
  [4963] = 0x94A3, [4964] = 0x94A4, [4965] = 0x94A5, [4966] = 0x94A6,
  [4967] = 0x94A7, [4968] = 0x94A8, [4969] = 0x94A9, [4970] = 0x94AA,
  [4971] = 0x94AB, [4972] = 0x94AC, [4973] = 0x94AD, [4974] = 0x94AE,
  [4975] = 0x94AF, [4976] = 0x94B0, [4977] = 0x94B1, [4978] = 0x94B2,
  [4979] = 0x94B3, [4980] = 0x94B4, [4981] = 0x94B5, [4982] = 0x94B6,
  [4983] = 0x94B7, [4984] = 0x94B8, [4985] = 0x94B9, [4986] = 0x94BA,
  [4987] = 0x94BB, [4988] = 0x94BC, [4989] = 0x94BD, [4990] = 0x94BE,
  [4991] = 0x94BF, [4992] = 0x94C0, [4993] = 0x94C1, [4994] = 0x94C2,
  [4995] = 0x94C3, [4996] = 0x94C4, [4997] = 0x94C5, [4998] = 0x94C6,
  [4999] = 0x94C7, [5000] = 0x94C8, [5001] = 0x94C9, [5002] = 0x94CA,
  [5003] = 0x94CB, [5004] = 0x94CC, [5005] = 0x94CD, [5006] = 0x94CE,
  [5007] = 0x94CF, [5008] = 0x94D0, [5009] = 0x94D1, [5010] = 0x94D2,
  [5011] = 0x94D3, [5012] = 0x94D4, [5013] = 0x94D5, [5014] = 0x94D6,
  [5015] = 0x94D7, [5016] = 0x94D8, [5017] = 0x94D9, [5018] = 0x94DA,
  [5019] = 0x94DB, [5020] = 0x94DC, [5021] = 0x94DD, [5022] = 0x94DE,
  [5023] = 0x94DF, [5024] = 0x94E0, [5025] = 0x94E1, [5026] = 0x94E2,
  [5027] = 0x94E3, [5028] = 0x94E4, [5029] = 0x94E5, [5030] = 0x94E6,
  [5031] = 0x94E7, [5032] = 0x94E8, [5033] = 0x94E9, [5034] = 0x94EA,
  [5035] = 0x94EB, [5036] = 0x94EC, [5037] = 0x94ED, [5038] = 0x94EE,
  [5039] = 0x94EF, [5040] = 0x94F0, [5041] = 0x94F1, [5042] = 0x94F2,
  [5043] = 0x94F3, [5044] = 0x94F4, [5045] = 0x94F5, [5046] = 0x94F6,
  [5047] = 0x94F7, [5048] = 0x94F8, [5049] = 0x94F9, [5050] = 0x94FA,
  [5051] = 0x94FB, [5052] = 0x94FC, [5053] = 0x94FD, [5054] = 0x94FE,
  [5120] = 0x9540, [5121] = 0x9541, [5122] = 0x9542, [5123] = 0x9543,
  [5124] = 0x9544, [5125] = 0x9545, [5126] = 0x9546, [5127] = 0x9547,
  [5128] = 0x9548, [5129] = 0x9549, [5130] = 0x954A, [5131] = 0x954B,
  [5132] = 0x954C, [5133] = 0x954D, [5134] = 0x954E, [5135] = 0x954F,
  [5136] = 0x9550, [5137] = 0x9551, [5138] = 0x9552, [5139] = 0x9553,
  [5140] = 0x9554, [5141] = 0x9555, [5142] = 0x9556, [5143] = 0x9557,
  [5144] = 0x9558, [5145] = 0x9559, [5146] = 0x955A, [5147] = 0x955B,
  [5148] = 0x955C, [5149] = 0x955D, [5150] = 0x955E, [5151] = 0x955F,
  [5152] = 0x9560, [5153] = 0x9561, [5154] = 0x9562, [5155] = 0x9563,
  [5156] = 0x9564, [5157] = 0x9565, [5158] = 0x9566, [5159] = 0x9567,
  [5160] = 0x9568, [5161] = 0x9569, [5162] = 0x956A, [5163] = 0x956B,
  [5164] = 0x956C, [5165] = 0x956D, [5166] = 0x956E, [5167] = 0x956F,
  [5168] = 0x9570, [5169] = 0x9571, [5170] = 0x9572, [5171] = 0x9573,
  [5172] = 0x9574, [5173] = 0x9575, [5174] = 0x9576, [5175] = 0x9577,
  [5176] = 0x9578, [5177] = 0x9579, [5178] = 0x957A, [5179] = 0x957B,
  [5180] = 0x957C, [5181] = 0x957D, [5182] = 0x957E, [5184] = 0x9580,
  [5185] = 0x9581, [5186] = 0x9582, [5187] = 0x9583, [5188] = 0x9584,
  [5189] = 0x9585, [5190] = 0x9586, [5191] = 0x9587, [5192] = 0x9588,
  [5193] = 0x9589, [5194] = 0x958A, [5195] = 0x958B, [5196] = 0x958C,
  [5197] = 0x958D, [5198] = 0x958E, [5199] = 0x958F, [5200] = 0x9590,
  [5201] = 0x9591, [5202] = 0x9592, [5203] = 0x9593, [5204] = 0x9594,
  [5205] = 0x9595, [5206] = 0x9596, [5207] = 0x9597, [5208] = 0x9598,
  [5209] = 0x9599, [5210] = 0x959A, [5211] = 0x959B, [5212] = 0x959C,
  [5213] = 0x959D, [5214] = 0x959E, [5215] = 0x959F, [5216] = 0x95A0,
  [5217] = 0x95A1, [5218] = 0x95A2, [5219] = 0x95A3, [5220] = 0x95A4,
  [5221] = 0x95A5, [5222] = 0x95A6, [5223] = 0x95A7, [5224] = 0x95A8,
  [5225] = 0x95A9, [5226] = 0x95AA, [5227] = 0x95AB, [5228] = 0x95AC,
  [5229] = 0x95AD, [5230] = 0x95AE, [5231] = 0x95AF, [5232] = 0x95B0,
  [5233] = 0x95B1, [5234] = 0x95B2, [5235] = 0x95B3, [5236] = 0x95B4,
  [5237] = 0x95B5, [5238] = 0x95B6, [5239] = 0x95B7, [5240] = 0x95B8,
  [5241] = 0x95B9, [5242] = 0x95BA, [5243] = 0x95BB, [5244] = 0x95BC,
  [5245] = 0x95BD, [5246] = 0x95BE, [5247] = 0x95BF, [5248] = 0x95C0,
  [5249] = 0x95C1, [5250] = 0x95C2, [5251] = 0x95C3, [5252] = 0x95C4,
  [5253] = 0x95C5, [5254] = 0x95C6, [5255] = 0x95C7, [5256] = 0x95C8,
  [5257] = 0x95C9, [5258] = 0x95CA, [5259] = 0x95CB, [5260] = 0x95CC,
  [5261] = 0x95CD, [5262] = 0x95CE, [5263] = 0x95CF, [5264] = 0x95D0,
  [5265] = 0x95D1, [5266] = 0x95D2, [5267] = 0x95D3, [5268] = 0x95D4,
  [5269] = 0x95D5, [5270] = 0x95D6, [5271] = 0x95D7, [5272] = 0x95D8,
  [5273] = 0x95D9, [5274] = 0x95DA, [5275] = 0x95DB, [5276] = 0x95DC,
  [5277] = 0x95DD, [5278] = 0x95DE, [5279] = 0x95DF, [5280] = 0x95E0,
  [5281] = 0x95E1, [5282] = 0x95E2, [5283] = 0x95E3, [5284] = 0x95E4,
  [5285] = 0x95E5, [5286] = 0x95E6, [5287] = 0x95E7, [5288] = 0x95E8,
  [5289] = 0x95E9, [5290] = 0x95EA, [5291] = 0x95EB, [5292] = 0x95EC,
  [5293] = 0x95ED, [5294] = 0x95EE, [5295] = 0x95EF, [5296] = 0x95F0,
  [5297] = 0x95F1, [5298] = 0x95F2, [5299] = 0x95F3, [5300] = 0x95F4,
  [5301] = 0x95F5, [5302] = 0x95F6, [5303] = 0x95F7, [5304] = 0x95F8,
  [5305] = 0x95F9, [5306] = 0x95FA, [5307] = 0x95FB, [5308] = 0x95FC,
  [5309] = 0x95FD, [5310] = 0x95FE, [5376] = 0x9640, [5377] = 0x9641,
  [5378] = 0x9642, [5379] = 0x9643, [5380] = 0x9644, [5381] = 0x9645,
  [5382] = 0x9646, [5383] = 0x9647, [5384] = 0x9648, [5385] = 0x9649,
  [5386] = 0x964A, [5387] = 0x964B, [5388] = 0x964C, [5389] = 0x964D,
  [5390] = 0x964E, [5391] = 0x964F, [5392] = 0x9650, [5393] = 0x9651,
  [5394] = 0x9652, [5395] = 0x9653, [5396] = 0x9654, [5397] = 0x9655,
  [5398] = 0x9656, [5399] = 0x9657, [5400] = 0x9658, [5401] = 0x9659,
  [5402] = 0x965A, [5403] = 0x965B, [5404] = 0x965C, [5405] = 0x965D,
  [5406] = 0x965E, [5407] = 0x965F, [5408] = 0x9660, [5409] = 0x9661,
  [5410] = 0x9662, [5411] = 0x9663, [5412] = 0x9664, [5413] = 0x9665,
  [5414] = 0x9666, [5415] = 0x9667, [5416] = 0x9668, [5417] = 0x9669,
  [5418] = 0x966A, [5419] = 0x966B, [5420] = 0x966C, [5421] = 0x966D,
  [5422] = 0x966E, [5423] = 0x966F, [5424] = 0x9670, [5425] = 0x9671,
  [5426] = 0x9672, [5427] = 0x9673, [5428] = 0x9674, [5429] = 0x9675,
  [5430] = 0x9676, [5431] = 0x9677, [5432] = 0x9678, [5433] = 0x9679,
  [5434] = 0x967A, [5435] = 0x967B, [5436] = 0x967C, [5437] = 0x967D,
  [5438] = 0x967E, [5440] = 0x9680, [5441] = 0x9681, [5442] = 0x9682,
  [5443] = 0x9683, [5444] = 0x9684, [5445] = 0x9685, [5446] = 0x9686,
  [5447] = 0x9687, [5448] = 0x9688, [5449] = 0x9689, [5450] = 0x968A,
  [5451] = 0x968B, [5452] = 0x968C, [5453] = 0x968D, [5454] = 0x968E,
  [5455] = 0x968F, [5456] = 0x9690, [5457] = 0x9691, [5458] = 0x9692,
  [5459] = 0x9693, [5460] = 0x9694, [5461] = 0x9695, [5462] = 0x9696,
  [5463] = 0x9697, [5464] = 0x9698, [5465] = 0x9699, [5466] = 0x969A,
  [5467] = 0x969B, [5468] = 0x969C, [5469] = 0x969D, [5470] = 0x969E,
  [5471] = 0x969F, [5472] = 0x96A0, [5473] = 0x96A1, [5474] = 0x96A2,
  [5475] = 0x96A3, [5476] = 0x96A4, [5477] = 0x96A5, [5478] = 0x96A6,
  [5479] = 0x96A7, [5480] = 0x96A8, [5481] = 0x96A9, [5482] = 0x96AA,
  [5483] = 0x96AB, [5484] = 0x96AC, [5485] = 0x96AD, [5486] = 0x96AE,
  [5487] = 0x96AF, [5488] = 0x96B0, [5489] = 0x96B1, [5490] = 0x96B2,
  [5491] = 0x96B3, [5492] = 0x96B4, [5493] = 0x96B5, [5494] = 0x96B6,
  [5495] = 0x96B7, [5496] = 0x96B8, [5497] = 0x96B9, [5498] = 0x96BA,
  [5499] = 0x96BB, [5500] = 0x96BC, [5501] = 0x96BD, [5502] = 0x96BE,
  [5503] = 0x96BF, [5504] = 0x96C0, [5505] = 0x96C1, [5506] = 0x96C2,
  [5507] = 0x96C3, [5508] = 0x96C4, [5509] = 0x96C5, [5510] = 0x96C6,
  [5511] = 0x96C7, [5512] = 0x96C8, [5513] = 0x96C9, [5514] = 0x96CA,
  [5515] = 0x96CB, [5516] = 0x96CC, [5517] = 0x96CD, [5518] = 0x96CE,
  [5519] = 0x96CF, [5520] = 0x96D0, [5521] = 0x96D1, [5522] = 0x96D2,
  [5523] = 0x96D3, [5524] = 0x96D4, [5525] = 0x96D5, [5526] = 0x96D6,
  [5527] = 0x96D7, [5528] = 0x96D8, [5529] = 0x96D9, [5530] = 0x96DA,
  [5531] = 0x96DB, [5532] = 0x96DC, [5533] = 0x96DD, [5534] = 0x96DE,
  [5535] = 0x96DF, [5536] = 0x96E0, [5537] = 0x96E1, [5538] = 0x96E2,
  [5539] = 0x96E3, [5540] = 0x96E4, [5541] = 0x96E5, [5542] = 0x96E6,
  [5543] = 0x96E7, [5544] = 0x96E8, [5545] = 0x96E9, [5546] = 0x96EA,
  [5547] = 0x96EB, [5548] = 0x96EC, [5549] = 0x96ED, [5550] = 0x96EE,
  [5551] = 0x96EF, [5552] = 0x96F0, [5553] = 0x96F1, [5554] = 0x96F2,
  [5555] = 0x96F3, [5556] = 0x96F4, [5557] = 0x96F5, [5558] = 0x96F6,
  [5559] = 0x96F7, [5560] = 0x96F8, [5561] = 0x96F9, [5562] = 0x96FA,
  [5563] = 0x96FB, [5564] = 0x96FC, [5565] = 0x96FD, [5566] = 0x96FE,
  [5632] = 0x9740, [5633] = 0x9741, [5634] = 0x9742, [5635] = 0x9743,
  [5636] = 0x9744, [5637] = 0x9745, [5638] = 0x9746, [5639] = 0x9747,
  [5640] = 0x9748, [5641] = 0x9749, [5642] = 0x974A, [5643] = 0x974B,
  [5644] = 0x974C, [5645] = 0x974D, [5646] = 0x974E, [5647] = 0x974F,
  [5648] = 0x9750, [5649] = 0x9751, [5650] = 0x9752, [5651] = 0x9753,
  [5652] = 0x9754, [5653] = 0x9755, [5654] = 0x9756, [5655] = 0x9757,
  [5656] = 0x9758, [5657] = 0x9759, [5658] = 0x975A, [5659] = 0x975B,
  [5660] = 0x975C, [5661] = 0x975D, [5662] = 0x975E, [5663] = 0x975F,
  [5664] = 0x9760, [5665] = 0x9761, [5666] = 0x9762, [5667] = 0x9763,
  [5668] = 0x9764, [5669] = 0x9765, [5670] = 0x9766, [5671] = 0x9767,
  [5672] = 0x9768, [5673] = 0x9769, [5674] = 0x976A, [5675] = 0x976B,
  [5676] = 0x976C, [5677] = 0x976D, [5678] = 0x976E, [5679] = 0x976F,
  [5680] = 0x9770, [5681] = 0x9771, [5682] = 0x9772, [5683] = 0x9773,
  [5684] = 0x9774, [5685] = 0x9775, [5686] = 0x9776, [5687] = 0x9777,
  [5688] = 0x9778, [5689] = 0x9779, [5690] = 0x977A, [5691] = 0x977B,
  [5692] = 0x977C, [5693] = 0x977D, [5694] = 0x977E, [5696] = 0x9780,
  [5697] = 0x9781, [5698] = 0x9782, [5699] = 0x9783, [5700] = 0x9784,
  [5701] = 0x9785, [5702] = 0x9786, [5703] = 0x9787, [5704] = 0x9788,
  [5705] = 0x9789, [5706] = 0x978A, [5707] = 0x978B, [5708] = 0x978C,
  [5709] = 0x978D, [5710] = 0x978E, [5711] = 0x978F, [5712] = 0x9790,
  [5713] = 0x9791, [5714] = 0x9792, [5715] = 0x9793, [5716] = 0x9794,
  [5717] = 0x9795, [5718] = 0x9796, [5719] = 0x9797, [5720] = 0x9798,
  [5721] = 0x9799, [5722] = 0x979A, [5723] = 0x979B, [5724] = 0x979C,
  [5725] = 0x979D, [5726] = 0x979E, [5727] = 0x979F, [5728] = 0x97A0,
  [5729] = 0x97A1, [5730] = 0x97A2, [5731] = 0x97A3, [5732] = 0x97A4,
  [5733] = 0x97A5, [5734] = 0x97A6, [5735] = 0x97A7, [5736] = 0x97A8,
  [5737] = 0x97A9, [5738] = 0x97AA, [5739] = 0x97AB, [5740] = 0x97AC,
  [5741] = 0x97AD, [5742] = 0x97AE, [5743] = 0x97AF, [5744] = 0x97B0,
  [5745] = 0x97B1, [5746] = 0x97B2, [5747] = 0x97B3, [5748] = 0x97B4,
  [5749] = 0x97B5, [5750] = 0x97B6, [5751] = 0x97B7, [5752] = 0x97B8,
  [5753] = 0x97B9, [5754] = 0x97BA, [5755] = 0x97BB, [5756] = 0x97BC,
  [5757] = 0x97BD, [5758] = 0x97BE, [5759] = 0x97BF, [5760] = 0x97C0,
  [5761] = 0x97C1, [5762] = 0x97C2, [5763] = 0x97C3, [5764] = 0x97C4,
  [5765] = 0x97C5, [5766] = 0x97C6, [5767] = 0x97C7, [5768] = 0x97C8,
  [5769] = 0x97C9, [5770] = 0x97CA, [5771] = 0x97CB, [5772] = 0x97CC,
  [5773] = 0x97CD, [5774] = 0x97CE, [5775] = 0x97CF, [5776] = 0x97D0,
  [5777] = 0x97D1, [5778] = 0x97D2, [5779] = 0x97D3, [5780] = 0x97D4,
  [5781] = 0x97D5, [5782] = 0x97D6, [5783] = 0x97D7, [5784] = 0x97D8,
  [5785] = 0x97D9, [5786] = 0x97DA, [5787] = 0x97DB, [5788] = 0x97DC,
  [5789] = 0x97DD, [5790] = 0x97DE, [5791] = 0x97DF, [5792] = 0x97E0,
  [5793] = 0x97E1, [5794] = 0x97E2, [5795] = 0x97E3, [5796] = 0x97E4,
  [5797] = 0x97E5, [5798] = 0x97E6, [5799] = 0x97E7, [5800] = 0x97E8,
  [5801] = 0x97E9, [5802] = 0x97EA, [5803] = 0x97EB, [5804] = 0x97EC,
  [5805] = 0x97ED, [5806] = 0x97EE, [5807] = 0x97EF, [5808] = 0x97F0,
  [5809] = 0x97F1, [5810] = 0x97F2, [5811] = 0x97F3, [5812] = 0x97F4,
  [5813] = 0x97F5, [5814] = 0x97F6, [5815] = 0x97F7, [5816] = 0x97F8,
  [5817] = 0x97F9, [5818] = 0x97FA, [5819] = 0x97FB, [5820] = 0x97FC,
  [5821] = 0x97FD, [5822] = 0x97FE, [5888] = 0x9840, [5889] = 0x9841,
  [5890] = 0x9842, [5891] = 0x9843, [5892] = 0x9844, [5893] = 0x9845,
  [5894] = 0x9846, [5895] = 0x9847, [5896] = 0x9848, [5897] = 0x9849,
  [5898] = 0x984A, [5899] = 0x984B, [5900] = 0x984C, [5901] = 0x984D,
  [5902] = 0x984E, [5903] = 0x984F, [5904] = 0x9850, [5905] = 0x9851,
  [5906] = 0x9852, [5907] = 0x9853, [5908] = 0x9854, [5909] = 0x9855,
  [5910] = 0x9856, [5911] = 0x9857, [5912] = 0x9858, [5913] = 0x9859,
  [5914] = 0x985A, [5915] = 0x985B, [5916] = 0x985C, [5917] = 0x985D,
  [5918] = 0x985E, [5919] = 0x985F, [5920] = 0x9860, [5921] = 0x9861,
  [5922] = 0x9862, [5923] = 0x9863, [5924] = 0x9864, [5925] = 0x9865,
  [5926] = 0x9866, [5927] = 0x9867, [5928] = 0x9868, [5929] = 0x9869,
  [5930] = 0x986A, [5931] = 0x986B, [5932] = 0x986C, [5933] = 0x986D,
  [5934] = 0x986E, [5935] = 0x986F, [5936] = 0x9870, [5937] = 0x9871,
  [5938] = 0x9872, [5939] = 0x9873, [5940] = 0x9874, [5941] = 0x9875,
  [5942] = 0x9876, [5943] = 0x9877, [5944] = 0x9878, [5945] = 0x9879,
  [5946] = 0x987A, [5947] = 0x987B, [5948] = 0x987C, [5949] = 0x987D,
  [5950] = 0x987E, [5952] = 0x9880, [5953] = 0x9881, [5954] = 0x9882,
  [5955] = 0x9883, [5956] = 0x9884, [5957] = 0x9885, [5958] = 0x9886,
  [5959] = 0x9887, [5960] = 0x9888, [5961] = 0x9889, [5962] = 0x988A,
  [5963] = 0x988B, [5964] = 0x988C, [5965] = 0x988D, [5966] = 0x988E,
  [5967] = 0x988F, [5968] = 0x9890, [5969] = 0x9891, [5970] = 0x9892,
  [5971] = 0x9893, [5972] = 0x9894, [5973] = 0x9895, [5974] = 0x9896,
  [5975] = 0x9897, [5976] = 0x9898, [5977] = 0x9899, [5978] = 0x989A,
  [5979] = 0x989B, [5980] = 0x989C, [5981] = 0x989D, [5982] = 0x989E,
  [5983] = 0x989F, [5984] = 0x98A0, [5985] = 0x98A1, [5986] = 0x98A2,
  [5987] = 0x98A3, [5988] = 0x98A4, [5989] = 0x98A5, [5990] = 0x98A6,
  [5991] = 0x98A7, [5992] = 0x98A8, [5993] = 0x98A9, [5994] = 0x98AA,
  [5995] = 0x98AB, [5996] = 0x98AC, [5997] = 0x98AD, [5998] = 0x98AE,
  [5999] = 0x98AF, [6000] = 0x98B0, [6001] = 0x98B1, [6002] = 0x98B2,
  [6003] = 0x98B3, [6004] = 0x98B4, [6005] = 0x98B5, [6006] = 0x98B6,
  [6007] = 0x98B7, [6008] = 0x98B8, [6009] = 0x98B9, [6010] = 0x98BA,
  [6011] = 0x98BB, [6012] = 0x98BC, [6013] = 0x98BD, [6014] = 0x98BE,
  [6015] = 0x98BF, [6016] = 0x98C0, [6017] = 0x98C1, [6018] = 0x98C2,
  [6019] = 0x98C3, [6020] = 0x98C4, [6021] = 0x98C5, [6022] = 0x98C6,
  [6023] = 0x98C7, [6024] = 0x98C8, [6025] = 0x98C9, [6026] = 0x98CA,
  [6027] = 0x98CB, [6028] = 0x98CC, [6029] = 0x98CD, [6030] = 0x98CE,
  [6031] = 0x98CF, [6032] = 0x98D0, [6033] = 0x98D1, [6034] = 0x98D2,
  [6035] = 0x98D3, [6036] = 0x98D4, [6037] = 0x98D5, [6038] = 0x98D6,
  [6039] = 0x98D7, [6040] = 0x98D8, [6041] = 0x98D9, [6042] = 0x98DA,
  [6043] = 0x98DB, [6044] = 0x98DC, [6045] = 0x98DD, [6046] = 0x98DE,
  [6047] = 0x98DF, [6048] = 0x98E0, [6049] = 0x98E1, [6050] = 0x98E2,
  [6051] = 0x98E3, [6052] = 0x98E4, [6053] = 0x98E5, [6054] = 0x98E6,
  [6055] = 0x98E7, [6056] = 0x98E8, [6057] = 0x98E9, [6058] = 0x98EA,
  [6059] = 0x98EB, [6060] = 0x98EC, [6061] = 0x98ED, [6062] = 0x98EE,
  [6063] = 0x98EF, [6064] = 0x98F0, [6065] = 0x98F1, [6066] = 0x98F2,
  [6067] = 0x98F3, [6068] = 0x98F4, [6069] = 0x98F5, [6070] = 0x98F6,
  [6071] = 0x98F7, [6072] = 0x98F8, [6073] = 0x98F9, [6074] = 0x98FA,
  [6075] = 0x98FB, [6076] = 0x98FC, [6077] = 0x98FD, [6078] = 0x98FE,
  [6144] = 0x9940, [6145] = 0x9941, [6146] = 0x9942, [6147] = 0x9943,
  [6148] = 0x9944, [6149] = 0x9945, [6150] = 0x9946, [6151] = 0x9947,
  [6152] = 0x9948, [6153] = 0x9949, [6154] = 0x994A, [6155] = 0x994B,
  [6156] = 0x994C, [6157] = 0x994D, [6158] = 0x994E, [6159] = 0x994F,
  [6160] = 0x9950, [6161] = 0x9951, [6162] = 0x9952, [6163] = 0x9953,
  [6164] = 0x9954, [6165] = 0x9955, [6166] = 0x9956, [6167] = 0x9957,
  [6168] = 0x9958, [6169] = 0x9959, [6170] = 0x995A, [6171] = 0x995B,
  [6172] = 0x995C, [6173] = 0x995D, [6174] = 0x995E, [6175] = 0x995F,
  [6176] = 0x9960, [6177] = 0x9961, [6178] = 0x9962, [6179] = 0x9963,
  [6180] = 0x9964, [6181] = 0x9965, [6182] = 0x9966, [6183] = 0x9967,
  [6184] = 0x9968, [6185] = 0x9969, [6186] = 0x996A, [6187] = 0x996B,
  [6188] = 0x996C, [6189] = 0x996D, [6190] = 0x996E, [6191] = 0x996F,
  [6192] = 0x9970, [6193] = 0x9971, [6194] = 0x9972, [6195] = 0x9973,
  [6196] = 0x9974, [6197] = 0x9975, [6198] = 0x9976, [6199] = 0x9977,
  [6200] = 0x9978, [6201] = 0x9979, [6202] = 0x997A, [6203] = 0x997B,
  [6204] = 0x997C, [6205] = 0x997D, [6206] = 0x997E, [6208] = 0x9980,
  [6209] = 0x9981, [6210] = 0x9982, [6211] = 0x9983, [6212] = 0x9984,
  [6213] = 0x9985, [6214] = 0x9986, [6215] = 0x9987, [6216] = 0x9988,
  [6217] = 0x9989, [6218] = 0x998A, [6219] = 0x998B, [6220] = 0x998C,
  [6221] = 0x998D, [6222] = 0x998E, [6223] = 0x998F, [6224] = 0x9990,
  [6225] = 0x9991, [6226] = 0x9992, [6227] = 0x9993, [6228] = 0x9994,
  [6229] = 0x9995, [6230] = 0x9996, [6231] = 0x9997, [6232] = 0x9998,
  [6233] = 0x9999, [6234] = 0x999A, [6235] = 0x999B, [6236] = 0x999C,
  [6237] = 0x999D, [6238] = 0x999E, [6239] = 0x999F, [6240] = 0x99A0,
  [6241] = 0x99A1, [6242] = 0x99A2, [6243] = 0x99A3, [6244] = 0x99A4,
  [6245] = 0x99A5, [6246] = 0x99A6, [6247] = 0x99A7, [6248] = 0x99A8,
  [6249] = 0x99A9, [6250] = 0x99AA, [6251] = 0x99AB, [6252] = 0x99AC,
  [6253] = 0x99AD, [6254] = 0x99AE, [6255] = 0x99AF, [6256] = 0x99B0,
  [6257] = 0x99B1, [6258] = 0x99B2, [6259] = 0x99B3, [6260] = 0x99B4,
  [6261] = 0x99B5, [6262] = 0x99B6, [6263] = 0x99B7, [6264] = 0x99B8,
  [6265] = 0x99B9, [6266] = 0x99BA, [6267] = 0x99BB, [6268] = 0x99BC,
  [6269] = 0x99BD, [6270] = 0x99BE, [6271] = 0x99BF, [6272] = 0x99C0,
  [6273] = 0x99C1, [6274] = 0x99C2, [6275] = 0x99C3, [6276] = 0x99C4,
  [6277] = 0x99C5, [6278] = 0x99C6, [6279] = 0x99C7, [6280] = 0x99C8,
  [6281] = 0x99C9, [6282] = 0x99CA, [6283] = 0x99CB, [6284] = 0x99CC,
  [6285] = 0x99CD, [6286] = 0x99CE, [6287] = 0x99CF, [6288] = 0x99D0,
  [6289] = 0x99D1, [6290] = 0x99D2, [6291] = 0x99D3, [6292] = 0x99D4,
  [6293] = 0x99D5, [6294] = 0x99D6, [6295] = 0x99D7, [6296] = 0x99D8,
  [6297] = 0x99D9, [6298] = 0x99DA, [6299] = 0x99DB, [6300] = 0x99DC,
  [6301] = 0x99DD, [6302] = 0x99DE, [6303] = 0x99DF, [6304] = 0x99E0,
  [6305] = 0x99E1, [6306] = 0x99E2, [6307] = 0x99E3, [6308] = 0x99E4,
  [6309] = 0x99E5, [6310] = 0x99E6, [6311] = 0x99E7, [6312] = 0x99E8,
  [6313] = 0x99E9, [6314] = 0x99EA, [6315] = 0x99EB, [6316] = 0x99EC,
  [6317] = 0x99ED, [6318] = 0x99EE, [6319] = 0x99EF, [6320] = 0x99F0,
  [6321] = 0x99F1, [6322] = 0x99F2, [6323] = 0x99F3, [6324] = 0x99F4,
  [6325] = 0x99F5, [6326] = 0x99F6, [6327] = 0x99F7, [6328] = 0x99F8,
  [6329] = 0x99F9, [6330] = 0x99FA, [6331] = 0x99FB, [6332] = 0x99FC,
  [6333] = 0x99FD, [6334] = 0x99FE, [6400] = 0x9A40, [6401] = 0x9A41,
  [6402] = 0x9A42, [6403] = 0x9A43, [6404] = 0x9A44, [6405] = 0x9A45,
  [6406] = 0x9A46, [6407] = 0x9A47, [6408] = 0x9A48, [6409] = 0x9A49,
  [6410] = 0x9A4A, [6411] = 0x9A4B, [6412] = 0x9A4C, [6413] = 0x9A4D,
  [6414] = 0x9A4E, [6415] = 0x9A4F, [6416] = 0x9A50, [6417] = 0x9A51,
  [6418] = 0x9A52, [6419] = 0x9A53, [6420] = 0x9A54, [6421] = 0x9A55,
  [6422] = 0x9A56, [6423] = 0x9A57, [6424] = 0x9A58, [6425] = 0x9A59,
  [6426] = 0x9A5A, [6427] = 0x9A5B, [6428] = 0x9A5C, [6429] = 0x9A5D,
  [6430] = 0x9A5E, [6431] = 0x9A5F, [6432] = 0x9A60, [6433] = 0x9A61,
  [6434] = 0x9A62, [6435] = 0x9A63, [6436] = 0x9A64, [6437] = 0x9A65,
  [6438] = 0x9A66, [6439] = 0x9A67, [6440] = 0x9A68, [6441] = 0x9A69,
  [6442] = 0x9A6A, [6443] = 0x9A6B, [6444] = 0x9A6C, [6445] = 0x9A6D,
  [6446] = 0x9A6E, [6447] = 0x9A6F, [6448] = 0x9A70, [6449] = 0x9A71,
  [6450] = 0x9A72, [6451] = 0x9A73, [6452] = 0x9A74, [6453] = 0x9A75,
  [6454] = 0x9A76, [6455] = 0x9A77, [6456] = 0x9A78, [6457] = 0x9A79,
  [6458] = 0x9A7A, [6459] = 0x9A7B, [6460] = 0x9A7C, [6461] = 0x9A7D,
  [6462] = 0x9A7E, [6464] = 0x9A80, [6465] = 0x9A81, [6466] = 0x9A82,
  [6467] = 0x9A83, [6468] = 0x9A84, [6469] = 0x9A85, [6470] = 0x9A86,
  [6471] = 0x9A87, [6472] = 0x9A88, [6473] = 0x9A89, [6474] = 0x9A8A,
  [6475] = 0x9A8B, [6476] = 0x9A8C, [6477] = 0x9A8D, [6478] = 0x9A8E,
  [6479] = 0x9A8F, [6480] = 0x9A90, [6481] = 0x9A91, [6482] = 0x9A92,
  [6483] = 0x9A93, [6484] = 0x9A94, [6485] = 0x9A95, [6486] = 0x9A96,
  [6487] = 0x9A97, [6488] = 0x9A98, [6489] = 0x9A99, [6490] = 0x9A9A,
  [6491] = 0x9A9B, [6492] = 0x9A9C, [6493] = 0x9A9D, [6494] = 0x9A9E,
  [6495] = 0x9A9F, [6496] = 0x9AA0, [6497] = 0x9AA1, [6498] = 0x9AA2,
  [6499] = 0x9AA3, [6500] = 0x9AA4, [6501] = 0x9AA5, [6502] = 0x9AA6,
  [6503] = 0x9AA7, [6504] = 0x9AA8, [6505] = 0x9AA9, [6506] = 0x9AAA,
  [6507] = 0x9AAB, [6508] = 0x9AAC, [6509] = 0x9AAD, [6510] = 0x9AAE,
  [6511] = 0x9AAF, [6512] = 0x9AB0, [6513] = 0x9AB1, [6514] = 0x9AB2,
  [6515] = 0x9AB3, [6516] = 0x9AB4, [6517] = 0x9AB5, [6518] = 0x9AB6,
  [6519] = 0x9AB7, [6520] = 0x9AB8, [6521] = 0x9AB9, [6522] = 0x9ABA,
  [6523] = 0x9ABB, [6524] = 0x9ABC, [6525] = 0x9ABD, [6526] = 0x9ABE,
  [6527] = 0x9ABF, [6528] = 0x9AC0, [6529] = 0x9AC1, [6530] = 0x9AC2,
  [6531] = 0x9AC3, [6532] = 0x9AC4, [6533] = 0x9AC5, [6534] = 0x9AC6,
  [6535] = 0x9AC7, [6536] = 0x9AC8, [6537] = 0x9AC9, [6538] = 0x9ACA,
  [6539] = 0x9ACB, [6540] = 0x9ACC, [6541] = 0x9ACD, [6542] = 0x9ACE,
  [6543] = 0x9ACF, [6544] = 0x9AD0, [6545] = 0x9AD1, [6546] = 0x9AD2,
  [6547] = 0x9AD3, [6548] = 0x9AD4, [6549] = 0x9AD5, [6550] = 0x9AD6,
  [6551] = 0x9AD7, [6552] = 0x9AD8, [6553] = 0x9AD9, [6554] = 0x9ADA,
  [6555] = 0x9ADB, [6556] = 0x9ADC, [6557] = 0x9ADD, [6558] = 0x9ADE,
  [6559] = 0x9ADF, [6560] = 0x9AE0, [6561] = 0x9AE1, [6562] = 0x9AE2,
  [6563] = 0x9AE3, [6564] = 0x9AE4, [6565] = 0x9AE5, [6566] = 0x9AE6,
  [6567] = 0x9AE7, [6568] = 0x9AE8, [6569] = 0x9AE9, [6570] = 0x9AEA,
  [6571] = 0x9AEB, [6572] = 0x9AEC, [6573] = 0x9AED, [6574] = 0x9AEE,
  [6575] = 0x9AEF, [6576] = 0x9AF0, [6577] = 0x9AF1, [6578] = 0x9AF2,
  [6579] = 0x9AF3, [6580] = 0x9AF4, [6581] = 0x9AF5, [6582] = 0x9AF6,
  [6583] = 0x9AF7, [6584] = 0x9AF8, [6585] = 0x9AF9, [6586] = 0x9AFA,
  [6587] = 0x9AFB, [6588] = 0x9AFC, [6589] = 0x9AFD, [6590] = 0x9AFE,
  [6656] = 0x9B40, [6657] = 0x9B41, [6658] = 0x9B42, [6659] = 0x9B43,
  [6660] = 0x9B44, [6661] = 0x9B45, [6662] = 0x9B46, [6663] = 0x9B47,
  [6664] = 0x9B48, [6665] = 0x9B49, [6666] = 0x9B4A, [6667] = 0x9B4B,
  [6668] = 0x9B4C, [6669] = 0x9B4D, [6670] = 0x9B4E, [6671] = 0x9B4F,
  [6672] = 0x9B50, [6673] = 0x9B51, [6674] = 0x9B52, [6675] = 0x9B53,
  [6676] = 0x9B54, [6677] = 0x9B55, [6678] = 0x9B56, [6679] = 0x9B57,
  [6680] = 0x9B58, [6681] = 0x9B59, [6682] = 0x9B5A, [6683] = 0x9B5B,
  [6684] = 0x9B5C, [6685] = 0x9B5D, [6686] = 0x9B5E, [6687] = 0x9B5F,
  [6688] = 0x9B60, [6689] = 0x9B61, [6690] = 0x9B62, [6691] = 0x9B63,
  [6692] = 0x9B64, [6693] = 0x9B65, [6694] = 0x9B66, [6695] = 0x9B67,
  [6696] = 0x9B68, [6697] = 0x9B69, [6698] = 0x9B6A, [6699] = 0x9B6B,
  [6700] = 0x9B6C, [6701] = 0x9B6D, [6702] = 0x9B6E, [6703] = 0x9B6F,
  [6704] = 0x9B70, [6705] = 0x9B71, [6706] = 0x9B72, [6707] = 0x9B73,
  [6708] = 0x9B74, [6709] = 0x9B75, [6710] = 0x9B76, [6711] = 0x9B77,
  [6712] = 0x9B78, [6713] = 0x9B79, [6714] = 0x9B7A, [6715] = 0x9B7B,
  [6716] = 0x9B7C, [6717] = 0x9B7D, [6718] = 0x9B7E, [6720] = 0x9B80,
  [6721] = 0x9B81, [6722] = 0x9B82, [6723] = 0x9B83, [6724] = 0x9B84,
  [6725] = 0x9B85, [6726] = 0x9B86, [6727] = 0x9B87, [6728] = 0x9B88,
  [6729] = 0x9B89, [6730] = 0x9B8A, [6731] = 0x9B8B, [6732] = 0x9B8C,
  [6733] = 0x9B8D, [6734] = 0x9B8E, [6735] = 0x9B8F, [6736] = 0x9B90,
  [6737] = 0x9B91, [6738] = 0x9B92, [6739] = 0x9B93, [6740] = 0x9B94,
  [6741] = 0x9B95, [6742] = 0x9B96, [6743] = 0x9B97, [6744] = 0x9B98,
  [6745] = 0x9B99, [6746] = 0x9B9A, [6747] = 0x9B9B, [6748] = 0x9B9C,
  [6749] = 0x9B9D, [6750] = 0x9B9E, [6751] = 0x9B9F, [6752] = 0x9BA0,
  [6753] = 0x9BA1, [6754] = 0x9BA2, [6755] = 0x9BA3, [6756] = 0x9BA4,
  [6757] = 0x9BA5, [6758] = 0x9BA6, [6759] = 0x9BA7, [6760] = 0x9BA8,
  [6761] = 0x9BA9, [6762] = 0x9BAA, [6763] = 0x9BAB, [6764] = 0x9BAC,
  [6765] = 0x9BAD, [6766] = 0x9BAE, [6767] = 0x9BAF, [6768] = 0x9BB0,
  [6769] = 0x9BB1, [6770] = 0x9BB2, [6771] = 0x9BB3, [6772] = 0x9BB4,
  [6773] = 0x9BB5, [6774] = 0x9BB6, [6775] = 0x9BB7, [6776] = 0x9BB8,
  [6777] = 0x9BB9, [6778] = 0x9BBA, [6779] = 0x9BBB, [6780] = 0x9BBC,
  [6781] = 0x9BBD, [6782] = 0x9BBE, [6783] = 0x9BBF, [6784] = 0x9BC0,
  [6785] = 0x9BC1, [6786] = 0x9BC2, [6787] = 0x9BC3, [6788] = 0x9BC4,
  [6789] = 0x9BC5, [6790] = 0x9BC6, [6791] = 0x9BC7, [6792] = 0x9BC8,
  [6793] = 0x9BC9, [6794] = 0x9BCA, [6795] = 0x9BCB, [6796] = 0x9BCC,
  [6797] = 0x9BCD, [6798] = 0x9BCE, [6799] = 0x9BCF, [6800] = 0x9BD0,
  [6801] = 0x9BD1, [6802] = 0x9BD2, [6803] = 0x9BD3, [6804] = 0x9BD4,
  [6805] = 0x9BD5, [6806] = 0x9BD6, [6807] = 0x9BD7, [6808] = 0x9BD8,
  [6809] = 0x9BD9, [6810] = 0x9BDA, [6811] = 0x9BDB, [6812] = 0x9BDC,
  [6813] = 0x9BDD, [6814] = 0x9BDE, [6815] = 0x9BDF, [6816] = 0x9BE0,
  [6817] = 0x9BE1, [6818] = 0x9BE2, [6819] = 0x9BE3, [6820] = 0x9BE4,
  [6821] = 0x9BE5, [6822] = 0x9BE6, [6823] = 0x9BE7, [6824] = 0x9BE8,
  [6825] = 0x9BE9, [6826] = 0x9BEA, [6827] = 0x9BEB, [6828] = 0x9BEC,
  [6829] = 0x9BED, [6830] = 0x9BEE, [6831] = 0x9BEF, [6832] = 0x9BF0,
  [6833] = 0x9BF1, [6834] = 0x9BF2, [6835] = 0x9BF3, [6836] = 0x9BF4,
  [6837] = 0x9BF5, [6838] = 0x9BF6, [6839] = 0x9BF7, [6840] = 0x9BF8,
  [6841] = 0x9BF9, [6842] = 0x9BFA, [6843] = 0x9BFB, [6844] = 0x9BFC,
  [6845] = 0x9BFD, [6846] = 0x9BFE, [6912] = 0x9C40, [6913] = 0x9C41,
  [6914] = 0x9C42, [6915] = 0x9C43, [6916] = 0x9C44, [6917] = 0x9C45,
  [6918] = 0x9C46, [6919] = 0x9C47, [6920] = 0x9C48, [6921] = 0x9C49,
  [6922] = 0x9C4A, [6923] = 0x9C4B, [6924] = 0x9C4C, [6925] = 0x9C4D,
  [6926] = 0x9C4E, [6927] = 0x9C4F, [6928] = 0x9C50, [6929] = 0x9C51,
  [6930] = 0x9C52, [6931] = 0x9C53, [6932] = 0x9C54, [6933] = 0x9C55,
  [6934] = 0x9C56, [6935] = 0x9C57, [6936] = 0x9C58, [6937] = 0x9C59,
  [6938] = 0x9C5A, [6939] = 0x9C5B, [6940] = 0x9C5C, [6941] = 0x9C5D,
  [6942] = 0x9C5E, [6943] = 0x9C5F, [6944] = 0x9C60, [6945] = 0x9C61,
  [6946] = 0x9C62, [6947] = 0x9C63, [6948] = 0x9C64, [6949] = 0x9C65,
  [6950] = 0x9C66, [6951] = 0x9C67, [6952] = 0x9C68, [6953] = 0x9C69,
  [6954] = 0x9C6A, [6955] = 0x9C6B, [6956] = 0x9C6C, [6957] = 0x9C6D,
  [6958] = 0x9C6E, [6959] = 0x9C6F, [6960] = 0x9C70, [6961] = 0x9C71,
  [6962] = 0x9C72, [6963] = 0x9C73, [6964] = 0x9C74, [6965] = 0x9C75,
  [6966] = 0x9C76, [6967] = 0x9C77, [6968] = 0x9C78, [6969] = 0x9C79,
  [6970] = 0x9C7A, [6971] = 0x9C7B, [6972] = 0x9C7C, [6973] = 0x9C7D,
  [6974] = 0x9C7E, [6976] = 0x9C80, [6977] = 0x9C81, [6978] = 0x9C82,
  [6979] = 0x9C83, [6980] = 0x9C84, [6981] = 0x9C85, [6982] = 0x9C86,
  [6983] = 0x9C87, [6984] = 0x9C88, [6985] = 0x9C89, [6986] = 0x9C8A,
  [6987] = 0x9C8B, [6988] = 0x9C8C, [6989] = 0x9C8D, [6990] = 0x9C8E,
  [6991] = 0x9C8F, [6992] = 0x9C90, [6993] = 0x9C91, [6994] = 0x9C92,
  [6995] = 0x9C93, [6996] = 0x9C94, [6997] = 0x9C95, [6998] = 0x9C96,
  [6999] = 0x9C97, [7000] = 0x9C98, [7001] = 0x9C99, [7002] = 0x9C9A,
  [7003] = 0x9C9B, [7004] = 0x9C9C, [7005] = 0x9C9D, [7006] = 0x9C9E,
  [7007] = 0x9C9F, [7008] = 0x9CA0, [7009] = 0x9CA1, [7010] = 0x9CA2,
  [7011] = 0x9CA3, [7012] = 0x9CA4, [7013] = 0x9CA5, [7014] = 0x9CA6,
  [7015] = 0x9CA7, [7016] = 0x9CA8, [7017] = 0x9CA9, [7018] = 0x9CAA,
  [7019] = 0x9CAB, [7020] = 0x9CAC, [7021] = 0x9CAD, [7022] = 0x9CAE,
  [7023] = 0x9CAF, [7024] = 0x9CB0, [7025] = 0x9CB1, [7026] = 0x9CB2,
  [7027] = 0x9CB3, [7028] = 0x9CB4, [7029] = 0x9CB5, [7030] = 0x9CB6,
  [7031] = 0x9CB7, [7032] = 0x9CB8, [7033] = 0x9CB9, [7034] = 0x9CBA,
  [7035] = 0x9CBB, [7036] = 0x9CBC, [7037] = 0x9CBD, [7038] = 0x9CBE,
  [7039] = 0x9CBF, [7040] = 0x9CC0, [7041] = 0x9CC1, [7042] = 0x9CC2,
  [7043] = 0x9CC3, [7044] = 0x9CC4, [7045] = 0x9CC5, [7046] = 0x9CC6,
  [7047] = 0x9CC7, [7048] = 0x9CC8, [7049] = 0x9CC9, [7050] = 0x9CCA,
  [7051] = 0x9CCB, [7052] = 0x9CCC, [7053] = 0x9CCD, [7054] = 0x9CCE,
  [7055] = 0x9CCF, [7056] = 0x9CD0, [7057] = 0x9CD1, [7058] = 0x9CD2,
  [7059] = 0x9CD3, [7060] = 0x9CD4, [7061] = 0x9CD5, [7062] = 0x9CD6,
  [7063] = 0x9CD7, [7064] = 0x9CD8, [7065] = 0x9CD9, [7066] = 0x9CDA,
  [7067] = 0x9CDB, [7068] = 0x9CDC, [7069] = 0x9CDD, [7070] = 0x9CDE,
  [7071] = 0x9CDF, [7072] = 0x9CE0, [7073] = 0x9CE1, [7074] = 0x9CE2,
  [7075] = 0x9CE3, [7076] = 0x9CE4, [7077] = 0x9CE5, [7078] = 0x9CE6,
  [7079] = 0x9CE7, [7080] = 0x9CE8, [7081] = 0x9CE9, [7082] = 0x9CEA,
  [7083] = 0x9CEB, [7084] = 0x9CEC, [7085] = 0x9CED, [7086] = 0x9CEE,
  [7087] = 0x9CEF, [7088] = 0x9CF0, [7089] = 0x9CF1, [7090] = 0x9CF2,
  [7091] = 0x9CF3, [7092] = 0x9CF4, [7093] = 0x9CF5, [7094] = 0x9CF6,
  [7095] = 0x9CF7, [7096] = 0x9CF8, [7097] = 0x9CF9, [7098] = 0x9CFA,
  [7099] = 0x9CFB, [7100] = 0x9CFC, [7101] = 0x9CFD, [7102] = 0x9CFE,
  [7168] = 0x9D40, [7169] = 0x9D41, [7170] = 0x9D42, [7171] = 0x9D43,
  [7172] = 0x9D44, [7173] = 0x9D45, [7174] = 0x9D46, [7175] = 0x9D47,
  [7176] = 0x9D48, [7177] = 0x9D49, [7178] = 0x9D4A, [7179] = 0x9D4B,
  [7180] = 0x9D4C, [7181] = 0x9D4D, [7182] = 0x9D4E, [7183] = 0x9D4F,
  [7184] = 0x9D50, [7185] = 0x9D51, [7186] = 0x9D52, [7187] = 0x9D53,
  [7188] = 0x9D54, [7189] = 0x9D55, [7190] = 0x9D56, [7191] = 0x9D57,
  [7192] = 0x9D58, [7193] = 0x9D59, [7194] = 0x9D5A, [7195] = 0x9D5B,
  [7196] = 0x9D5C, [7197] = 0x9D5D, [7198] = 0x9D5E, [7199] = 0x9D5F,
  [7200] = 0x9D60, [7201] = 0x9D61, [7202] = 0x9D62, [7203] = 0x9D63,
  [7204] = 0x9D64, [7205] = 0x9D65, [7206] = 0x9D66, [7207] = 0x9D67,
  [7208] = 0x9D68, [7209] = 0x9D69, [7210] = 0x9D6A, [7211] = 0x9D6B,
  [7212] = 0x9D6C, [7213] = 0x9D6D, [7214] = 0x9D6E, [7215] = 0x9D6F,
  [7216] = 0x9D70, [7217] = 0x9D71, [7218] = 0x9D72, [7219] = 0x9D73,
  [7220] = 0x9D74, [7221] = 0x9D75, [7222] = 0x9D76, [7223] = 0x9D77,
  [7224] = 0x9D78, [7225] = 0x9D79, [7226] = 0x9D7A, [7227] = 0x9D7B,
  [7228] = 0x9D7C, [7229] = 0x9D7D, [7230] = 0x9D7E, [7232] = 0x9D80,
  [7233] = 0x9D81, [7234] = 0x9D82, [7235] = 0x9D83, [7236] = 0x9D84,
  [7237] = 0x9D85, [7238] = 0x9D86, [7239] = 0x9D87, [7240] = 0x9D88,
  [7241] = 0x9D89, [7242] = 0x9D8A, [7243] = 0x9D8B, [7244] = 0x9D8C,
  [7245] = 0x9D8D, [7246] = 0x9D8E, [7247] = 0x9D8F, [7248] = 0x9D90,
  [7249] = 0x9D91, [7250] = 0x9D92, [7251] = 0x9D93, [7252] = 0x9D94,
  [7253] = 0x9D95, [7254] = 0x9D96, [7255] = 0x9D97, [7256] = 0x9D98,
  [7257] = 0x9D99, [7258] = 0x9D9A, [7259] = 0x9D9B, [7260] = 0x9D9C,
  [7261] = 0x9D9D, [7262] = 0x9D9E, [7263] = 0x9D9F, [7264] = 0x9DA0,
  [7265] = 0x9DA1, [7266] = 0x9DA2, [7267] = 0x9DA3, [7268] = 0x9DA4,
  [7269] = 0x9DA5, [7270] = 0x9DA6, [7271] = 0x9DA7, [7272] = 0x9DA8,
  [7273] = 0x9DA9, [7274] = 0x9DAA, [7275] = 0x9DAB, [7276] = 0x9DAC,
  [7277] = 0x9DAD, [7278] = 0x9DAE, [7279] = 0x9DAF, [7280] = 0x9DB0,
  [7281] = 0x9DB1, [7282] = 0x9DB2, [7283] = 0x9DB3, [7284] = 0x9DB4,
  [7285] = 0x9DB5, [7286] = 0x9DB6, [7287] = 0x9DB7, [7288] = 0x9DB8,
  [7289] = 0x9DB9, [7290] = 0x9DBA, [7291] = 0x9DBB, [7292] = 0x9DBC,
  [7293] = 0x9DBD, [7294] = 0x9DBE, [7295] = 0x9DBF, [7296] = 0x9DC0,
  [7297] = 0x9DC1, [7298] = 0x9DC2, [7299] = 0x9DC3, [7300] = 0x9DC4,
  [7301] = 0x9DC5, [7302] = 0x9DC6, [7303] = 0x9DC7, [7304] = 0x9DC8,
  [7305] = 0x9DC9, [7306] = 0x9DCA, [7307] = 0x9DCB, [7308] = 0x9DCC,
  [7309] = 0x9DCD, [7310] = 0x9DCE, [7311] = 0x9DCF, [7312] = 0x9DD0,
  [7313] = 0x9DD1, [7314] = 0x9DD2, [7315] = 0x9DD3, [7316] = 0x9DD4,
  [7317] = 0x9DD5, [7318] = 0x9DD6, [7319] = 0x9DD7, [7320] = 0x9DD8,
  [7321] = 0x9DD9, [7322] = 0x9DDA, [7323] = 0x9DDB, [7324] = 0x9DDC,
  [7325] = 0x9DDD, [7326] = 0x9DDE, [7327] = 0x9DDF, [7328] = 0x9DE0,
  [7329] = 0x9DE1, [7330] = 0x9DE2, [7331] = 0x9DE3, [7332] = 0x9DE4,
  [7333] = 0x9DE5, [7334] = 0x9DE6, [7335] = 0x9DE7, [7336] = 0x9DE8,
  [7337] = 0x9DE9, [7338] = 0x9DEA, [7339] = 0x9DEB, [7340] = 0x9DEC,
  [7341] = 0x9DED, [7342] = 0x9DEE, [7343] = 0x9DEF, [7344] = 0x9DF0,
  [7345] = 0x9DF1, [7346] = 0x9DF2, [7347] = 0x9DF3, [7348] = 0x9DF4,
  [7349] = 0x9DF5, [7350] = 0x9DF6, [7351] = 0x9DF7, [7352] = 0x9DF8,
  [7353] = 0x9DF9, [7354] = 0x9DFA, [7355] = 0x9DFB, [7356] = 0x9DFC,
  [7357] = 0x9DFD, [7358] = 0x9DFE, [7424] = 0x9E40, [7425] = 0x9E41,
  [7426] = 0x9E42, [7427] = 0x9E43, [7428] = 0x9E44, [7429] = 0x9E45,
  [7430] = 0x9E46, [7431] = 0x9E47, [7432] = 0x9E48, [7433] = 0x9E49,
  [7434] = 0x9E4A, [7435] = 0x9E4B, [7436] = 0x9E4C, [7437] = 0x9E4D,
  [7438] = 0x9E4E, [7439] = 0x9E4F, [7440] = 0x9E50, [7441] = 0x9E51,
  [7442] = 0x9E52, [7443] = 0x9E53, [7444] = 0x9E54, [7445] = 0x9E55,
  [7446] = 0x9E56, [7447] = 0x9E57, [7448] = 0x9E58, [7449] = 0x9E59,
  [7450] = 0x9E5A, [7451] = 0x9E5B, [7452] = 0x9E5C, [7453] = 0x9E5D,
  [7454] = 0x9E5E, [7455] = 0x9E5F, [7456] = 0x9E60, [7457] = 0x9E61,
  [7458] = 0x9E62, [7459] = 0x9E63, [7460] = 0x9E64, [7461] = 0x9E65,
  [7462] = 0x9E66, [7463] = 0x9E67, [7464] = 0x9E68, [7465] = 0x9E69,
  [7466] = 0x9E6A, [7467] = 0x9E6B, [7468] = 0x9E6C, [7469] = 0x9E6D,
  [7470] = 0x9E6E, [7471] = 0x9E6F, [7472] = 0x9E70, [7473] = 0x9E71,
  [7474] = 0x9E72, [7475] = 0x9E73, [7476] = 0x9E74, [7477] = 0x9E75,
  [7478] = 0x9E76, [7479] = 0x9E77, [7480] = 0x9E78, [7481] = 0x9E79,
  [7482] = 0x9E7A, [7483] = 0x9E7B, [7484] = 0x9E7C, [7485] = 0x9E7D,
  [7486] = 0x9E7E, [7488] = 0x9E80, [7489] = 0x9E81, [7490] = 0x9E82,
  [7491] = 0x9E83, [7492] = 0x9E84, [7493] = 0x9E85, [7494] = 0x9E86,
  [7495] = 0x9E87, [7496] = 0x9E88, [7497] = 0x9E89, [7498] = 0x9E8A,
  [7499] = 0x9E8B, [7500] = 0x9E8C, [7501] = 0x9E8D, [7502] = 0x9E8E,
  [7503] = 0x9E8F, [7504] = 0x9E90, [7505] = 0x9E91, [7506] = 0x9E92,
  [7507] = 0x9E93, [7508] = 0x9E94, [7509] = 0x9E95, [7510] = 0x9E96,
  [7511] = 0x9E97, [7512] = 0x9E98, [7513] = 0x9E99, [7514] = 0x9E9A,
  [7515] = 0x9E9B, [7516] = 0x9E9C, [7517] = 0x9E9D, [7518] = 0x9E9E,
  [7519] = 0x9E9F, [7520] = 0x9EA0, [7521] = 0x9EA1, [7522] = 0x9EA2,
  [7523] = 0x9EA3, [7524] = 0x9EA4, [7525] = 0x9EA5, [7526] = 0x9EA6,
  [7527] = 0x9EA7, [7528] = 0x9EA8, [7529] = 0x9EA9, [7530] = 0x9EAA,
  [7531] = 0x9EAB, [7532] = 0x9EAC, [7533] = 0x9EAD, [7534] = 0x9EAE,
  [7535] = 0x9EAF, [7536] = 0x9EB0, [7537] = 0x9EB1, [7538] = 0x9EB2,
  [7539] = 0x9EB3, [7540] = 0x9EB4, [7541] = 0x9EB5, [7542] = 0x9EB6,
  [7543] = 0x9EB7, [7544] = 0x9EB8, [7545] = 0x9EB9, [7546] = 0x9EBA,
  [7547] = 0x9EBB, [7548] = 0x9EBC, [7549] = 0x9EBD, [7550] = 0x9EBE,
  [7551] = 0x9EBF, [7552] = 0x9EC0, [7553] = 0x9EC1, [7554] = 0x9EC2,
  [7555] = 0x9EC3, [7556] = 0x9EC4, [7557] = 0x9EC5, [7558] = 0x9EC6,
  [7559] = 0x9EC7, [7560] = 0x9EC8, [7561] = 0x9EC9, [7562] = 0x9ECA,
  [7563] = 0x9ECB, [7564] = 0x9ECC, [7565] = 0x9ECD, [7566] = 0x9ECE,
  [7567] = 0x9ECF, [7568] = 0x9ED0, [7569] = 0x9ED1, [7570] = 0x9ED2,
  [7571] = 0x9ED3, [7572] = 0x9ED4, [7573] = 0x9ED5, [7574] = 0x9ED6,
  [7575] = 0x9ED7, [7576] = 0x9ED8, [7577] = 0x9ED9, [7578] = 0x9EDA,
  [7579] = 0x9EDB, [7580] = 0x9EDC, [7581] = 0x9EDD, [7582] = 0x9EDE,
  [7583] = 0x9EDF, [7584] = 0x9EE0, [7585] = 0x9EE1, [7586] = 0x9EE2,
  [7587] = 0x9EE3, [7588] = 0x9EE4, [7589] = 0x9EE5, [7590] = 0x9EE6,
  [7591] = 0x9EE7, [7592] = 0x9EE8, [7593] = 0x9EE9, [7594] = 0x9EEA,
  [7595] = 0x9EEB, [7596] = 0x9EEC, [7597] = 0x9EED, [7598] = 0x9EEE,
  [7599] = 0x9EEF, [7600] = 0x9EF0, [7601] = 0x9EF1, [7602] = 0x9EF2,
  [7603] = 0x9EF3, [7604] = 0x9EF4, [7605] = 0x9EF5, [7606] = 0x9EF6,
  [7607] = 0x9EF7, [7608] = 0x9EF8, [7609] = 0x9EF9, [7610] = 0x9EFA,
  [7611] = 0x9EFB, [7612] = 0x9EFC, [7613] = 0x9EFD, [7614] = 0x9EFE,
  [7680] = 0x9F40, [7681] = 0x9F41, [7682] = 0x9F42, [7683] = 0x9F43,
  [7684] = 0x9F44, [7685] = 0x9F45, [7686] = 0x9F46, [7687] = 0x9F47,
  [7688] = 0x9F48, [7689] = 0x9F49, [7690] = 0x9F4A, [7691] = 0x9F4B,
  [7692] = 0x9F4C, [7693] = 0x9F4D, [7694] = 0x9F4E, [7695] = 0x9F4F,
  [7696] = 0x9F50, [7697] = 0x9F51, [7698] = 0x9F52, [7699] = 0x9F53,
  [7700] = 0x9F54, [7701] = 0x9F55, [7702] = 0x9F56, [7703] = 0x9F57,
  [7704] = 0x9F58, [7705] = 0x9F59, [7706] = 0x9F5A, [7707] = 0x9F5B,
  [7708] = 0x9F5C, [7709] = 0x9F5D, [7710] = 0x9F5E, [7711] = 0x9F5F,
  [7712] = 0x9F60, [7713] = 0x9F61, [7714] = 0x9F62, [7715] = 0x9F63,
  [7716] = 0x9F64, [7717] = 0x9F65, [7718] = 0x9F66, [7719] = 0x9F67,
  [7720] = 0x9F68, [7721] = 0x9F69, [7722] = 0x9F6A, [7723] = 0x9F6B,
  [7724] = 0x9F6C, [7725] = 0x9F6D, [7726] = 0x9F6E, [7727] = 0x9F6F,
  [7728] = 0x9F70, [7729] = 0x9F71, [7730] = 0x9F72, [7731] = 0x9F73,
  [7732] = 0x9F74, [7733] = 0x9F75, [7734] = 0x9F76, [7735] = 0x9F77,
  [7736] = 0x9F78, [7737] = 0x9F79, [7738] = 0x9F7A, [7739] = 0x9F7B,
  [7740] = 0x9F7C, [7741] = 0x9F7D, [7742] = 0x9F7E, [7744] = 0x9F80,
  [7745] = 0x9F81, [7746] = 0x9F82, [7747] = 0x9F83, [7748] = 0x9F84,
  [7749] = 0x9F85, [7750] = 0x9F86, [7751] = 0x9F87, [7752] = 0x9F88,
  [7753] = 0x9F89, [7754] = 0x9F8A, [7755] = 0x9F8B, [7756] = 0x9F8C,
  [7757] = 0x9F8D, [7758] = 0x9F8E, [7759] = 0x9F8F, [7760] = 0x9F90,
  [7761] = 0x9F91, [7762] = 0x9F92, [7763] = 0x9F93, [7764] = 0x9F94,
  [7765] = 0x9F95, [7766] = 0x9F96, [7767] = 0x9F97, [7768] = 0x9F98,
  [7769] = 0x9F99, [7770] = 0x9F9A, [7771] = 0x9F9B, [7772] = 0x9F9C,
  [7773] = 0x9F9D, [7774] = 0x9F9E, [7775] = 0x9F9F, [7776] = 0x9FA0,
  [7777] = 0x9FA1, [7778] = 0x9FA2, [7779] = 0x9FA3, [7780] = 0x9FA4,
  [7781] = 0x9FA5, [7782] = 0x9FA6, [7783] = 0x9FA7, [7784] = 0x9FA8,
  [7785] = 0x9FA9, [7786] = 0x9FAA, [7787] = 0x9FAB, [7788] = 0x9FAC,
  [7789] = 0x9FAD, [7790] = 0x9FAE, [7791] = 0x9FAF, [7792] = 0x9FB0,
  [7793] = 0x9FB1, [7794] = 0x9FB2, [7795] = 0x9FB3, [7796] = 0x9FB4,
  [7797] = 0x9FB5, [7798] = 0x9FB6, [7799] = 0x9FB7, [7800] = 0x9FB8,
  [7801] = 0x9FB9, [7802] = 0x9FBA, [7803] = 0x9FBB, [7804] = 0x9FBC,
  [7805] = 0x9FBD, [7806] = 0x9FBE, [7807] = 0x9FBF, [7808] = 0x9FC0,
  [7809] = 0x9FC1, [7810] = 0x9FC2, [7811] = 0x9FC3, [7812] = 0x9FC4,
  [7813] = 0x9FC5, [7814] = 0x9FC6, [7815] = 0x9FC7, [7816] = 0x9FC8,
  [7817] = 0x9FC9, [7818] = 0x9FCA, [7819] = 0x9FCB, [7820] = 0x9FCC,
  [7821] = 0x9FCD, [7822] = 0x9FCE, [7823] = 0x9FCF, [7824] = 0x9FD0,
  [7825] = 0x9FD1, [7826] = 0x9FD2, [7827] = 0x9FD3, [7828] = 0x9FD4,
  [7829] = 0x9FD5, [7830] = 0x9FD6, [7831] = 0x9FD7, [7832] = 0x9FD8,
  [7833] = 0x9FD9, [7834] = 0x9FDA, [7835] = 0x9FDB, [7836] = 0x9FDC,
  [7837] = 0x9FDD, [7838] = 0x9FDE, [7839] = 0x9FDF, [7840] = 0x9FE0,
  [7841] = 0x9FE1, [7842] = 0x9FE2, [7843] = 0x9FE3, [7844] = 0x9FE4,
  [7845] = 0x9FE5, [7846] = 0x9FE6, [7847] = 0x9FE7, [7848] = 0x9FE8,
  [7849] = 0x9FE9, [7850] = 0x9FEA, [7851] = 0x9FEB, [7852] = 0x9FEC,
  [7853] = 0x9FED, [7854] = 0x9FEE, [7855] = 0x9FEF, [7856] = 0x9FF0,
  [7857] = 0x9FF1, [7858] = 0x9FF2, [7859] = 0x9FF3, [7860] = 0x9FF4,
  [7861] = 0x9FF5, [7862] = 0x9FF6, [7863] = 0x9FF7, [7864] = 0x9FF8,
  [7865] = 0x9FF9, [7866] = 0x9FFA, [7867] = 0x9FFB, [7868] = 0x9FFC,
  [7869] = 0x9FFD, [7870] = 0x9FFE, [7936] = 0xA040, [7937] = 0xA041,
  [7938] = 0xA042, [7939] = 0xA043, [7940] = 0xA044, [7941] = 0xA045,
  [7942] = 0xA046, [7943] = 0xA047, [7944] = 0xA048, [7945] = 0xA049,
  [7946] = 0xA04A, [7947] = 0xA04B, [7948] = 0xA04C, [7949] = 0xA04D,
  [7950] = 0xA04E, [7951] = 0xA04F, [7952] = 0xA050, [7953] = 0xA051,
  [7954] = 0xA052, [7955] = 0xA053, [7956] = 0xA054, [7957] = 0xA055,
  [7958] = 0xA056, [7959] = 0xA057, [7960] = 0xA058, [7961] = 0xA059,
  [7962] = 0xA05A, [7963] = 0xA05B, [7964] = 0xA05C, [7965] = 0xA05D,
  [7966] = 0xA05E, [7967] = 0xA05F, [7968] = 0xA060, [7969] = 0xA061,
  [7970] = 0xA062, [7971] = 0xA063, [7972] = 0xA064, [7973] = 0xA065,
  [7974] = 0xA066, [7975] = 0xA067, [7976] = 0xA068, [7977] = 0xA069,
  [7978] = 0xA06A, [7979] = 0xA06B, [7980] = 0xA06C, [7981] = 0xA06D,
  [7982] = 0xA06E, [7983] = 0xA06F, [7984] = 0xA070, [7985] = 0xA071,
  [7986] = 0xA072, [7987] = 0xA073, [7988] = 0xA074, [7989] = 0xA075,
  [7990] = 0xA076, [7991] = 0xA077, [7992] = 0xA078, [7993] = 0xA079,
  [7994] = 0xA07A, [7995] = 0xA07B, [7996] = 0xA07C, [7997] = 0xA07D,
  [7998] = 0xA07E, [8000] = 0xA080, [8001] = 0xA081, [8002] = 0xA082,
  [8003] = 0xA083, [8004] = 0xA084, [8005] = 0xA085, [8006] = 0xA086,
  [8007] = 0xA087, [8008] = 0xA088, [8009] = 0xA089, [8010] = 0xA08A,
  [8011] = 0xA08B, [8012] = 0xA08C, [8013] = 0xA08D, [8014] = 0xA08E,
  [8015] = 0xA08F, [8016] = 0xA090, [8017] = 0xA091, [8018] = 0xA092,
  [8019] = 0xA093, [8020] = 0xA094, [8021] = 0xA095, [8022] = 0xA096,
  [8023] = 0xA097, [8024] = 0xA098, [8025] = 0xA099, [8026] = 0xA09A,
  [8027] = 0xA09B, [8028] = 0xA09C, [8029] = 0xA09D, [8030] = 0xA09E,
  [8031] = 0xA09F, [8032] = 0xA0A0, [8033] = 0xA0A1, [8034] = 0xA0A2,
  [8035] = 0xA0A3, [8036] = 0xA0A4, [8037] = 0xA0A5, [8038] = 0xA0A6,
  [8039] = 0xA0A7, [8040] = 0xA0A8, [8041] = 0xA0A9, [8042] = 0xA0AA,
  [8043] = 0xA0AB, [8044] = 0xA0AC, [8045] = 0xA0AD, [8046] = 0xA0AE,
  [8047] = 0xA0AF, [8048] = 0xA0B0, [8049] = 0xA0B1, [8050] = 0xA0B2,
  [8051] = 0xA0B3, [8052] = 0xA0B4, [8053] = 0xA0B5, [8054] = 0xA0B6,
  [8055] = 0xA0B7, [8056] = 0xA0B8, [8057] = 0xA0B9, [8058] = 0xA0BA,
  [8059] = 0xA0BB, [8060] = 0xA0BC, [8061] = 0xA0BD, [8062] = 0xA0BE,
  [8063] = 0xA0BF, [8064] = 0xA0C0, [8065] = 0xA0C1, [8066] = 0xA0C2,
  [8067] = 0xA0C3, [8068] = 0xA0C4, [8069] = 0xA0C5, [8070] = 0xA0C6,
  [8071] = 0xA0C7, [8072] = 0xA0C8, [8073] = 0xA0C9, [8074] = 0xA0CA,
  [8075] = 0xA0CB, [8076] = 0xA0CC, [8077] = 0xA0CD, [8078] = 0xA0CE,
  [8079] = 0xA0CF, [8080] = 0xA0D0, [8081] = 0xA0D1, [8082] = 0xA0D2,
  [8083] = 0xA0D3, [8084] = 0xA0D4, [8085] = 0xA0D5, [8086] = 0xA0D6,
  [8087] = 0xA0D7, [8088] = 0xA0D8, [8089] = 0xA0D9, [8090] = 0xA0DA,
  [8091] = 0xA0DB, [8092] = 0xA0DC, [8093] = 0xA0DD, [8094] = 0xA0DE,
  [8095] = 0xA0DF, [8096] = 0xA0E0, [8097] = 0xA0E1, [8098] = 0xA0E2,
  [8099] = 0xA0E3, [8100] = 0xA0E4, [8101] = 0xA0E5, [8102] = 0xA0E6,
  [8103] = 0xA0E7, [8104] = 0xA0E8, [8105] = 0xA0E9, [8106] = 0xA0EA,
  [8107] = 0xA0EB, [8108] = 0xA0EC, [8109] = 0xA0ED, [8110] = 0xA0EE,
  [8111] = 0xA0EF, [8112] = 0xA0F0, [8113] = 0xA0F1, [8114] = 0xA0F2,
  [8115] = 0xA0F3, [8116] = 0xA0F4, [8117] = 0xA0F5, [8118] = 0xA0F6,
  [8119] = 0xA0F7, [8120] = 0xA0F8, [8121] = 0xA0F9, [8122] = 0xA0FA,
  [8123] = 0xA0FB, [8124] = 0xA0FC, [8125] = 0xA0FD, [8126] = 0xA0FE,
  [8192] = 0xA140, [8193] = 0xA141, [8194] = 0xA142, [8195] = 0xA143,
  [8196] = 0xA144, [8197] = 0xA145, [8198] = 0xA146, [8199] = 0xA147,
  [8200] = 0xA148, [8201] = 0xA149, [8202] = 0xA14A, [8203] = 0xA14B,
  [8204] = 0xA14C, [8205] = 0xA14D, [8206] = 0xA14E, [8207] = 0xA14F,
  [8208] = 0xA150, [8209] = 0xA151, [8210] = 0xA152, [8211] = 0xA153,
  [8212] = 0xA154, [8213] = 0xA155, [8214] = 0xA156, [8215] = 0xA157,
  [8216] = 0xA158, [8217] = 0xA159, [8218] = 0xA15A, [8219] = 0xA15B,
  [8220] = 0xA15C, [8221] = 0xA15D, [8222] = 0xA15E, [8223] = 0xA15F,
  [8224] = 0xA160, [8225] = 0xA161, [8226] = 0xA162, [8227] = 0xA163,
  [8228] = 0xA164, [8229] = 0xA165, [8230] = 0xA166, [8231] = 0xA167,
  [8232] = 0xA168, [8233] = 0xA169, [8234] = 0xA16A, [8235] = 0xA16B,
  [8236] = 0xA16C, [8237] = 0xA16D, [8238] = 0xA16E, [8239] = 0xA16F,
  [8240] = 0xA170, [8241] = 0xA171, [8242] = 0xA172, [8243] = 0xA173,
  [8244] = 0xA174, [8245] = 0xA175, [8246] = 0xA176, [8247] = 0xA177,
  [8248] = 0xA178, [8249] = 0xA179, [8250] = 0xA17A, [8251] = 0xA17B,
  [8252] = 0xA17C, [8253] = 0xA17D, [8254] = 0xA17E, [8256] = 0xA180,
  [8257] = 0xA181, [8258] = 0xA182, [8259] = 0xA183, [8260] = 0xA184,
  [8261] = 0xA185, [8262] = 0xA186, [8263] = 0xA187, [8264] = 0xA188,
  [8265] = 0xA189, [8266] = 0xA18A, [8267] = 0xA18B, [8268] = 0xA18C,
  [8269] = 0xA18D, [8270] = 0xA18E, [8271] = 0xA18F, [8272] = 0xA190,
  [8273] = 0xA191, [8274] = 0xA192, [8275] = 0xA193, [8276] = 0xA194,
  [8277] = 0xA195, [8278] = 0xA196, [8279] = 0xA197, [8280] = 0xA198,
  [8281] = 0xA199, [8282] = 0xA19A, [8283] = 0xA19B, [8284] = 0xA19C,
  [8285] = 0xA19D, [8286] = 0xA19E, [8287] = 0xA19F, [8288] = 0xA1A0,
  [8289] = 0xA1A1, [8290] = 0xA1A2, [8291] = 0xA1A3, [8292] = 0xA1A4,
  [8293] = 0xA1A5, [8294] = 0xA1A6, [8295] = 0xA1A7, [8296] = 0xA1A8,
  [8297] = 0xA1A9, [8298] = 0xA1AA, [8299] = 0xA1AB, [8300] = 0xA1AC,
  [8301] = 0xA1AD, [8302] = 0xA1AE, [8303] = 0xA1AF, [8304] = 0xA1B0,
  [8305] = 0xA1B1, [8306] = 0xA1B2, [8307] = 0xA1B3, [8308] = 0xA1B4,
  [8309] = 0xA1B5, [8310] = 0xA1B6, [8311] = 0xA1B7, [8312] = 0xA1B8,
  [8313] = 0xA1B9, [8314] = 0xA1BA, [8315] = 0xA1BB, [8316] = 0xA1BC,
  [8317] = 0xA1BD, [8318] = 0xA1BE, [8319] = 0xA1BF, [8320] = 0xA1C0,
  [8321] = 0xA1C1, [8322] = 0xA1C2, [8323] = 0xA1C3, [8324] = 0xA1C4,
  [8325] = 0xA1C5, [8326] = 0xA1C6, [8327] = 0xA1C7, [8328] = 0xA1C8,
  [8329] = 0xA1C9, [8330] = 0xA1CA, [8331] = 0xA1CB, [8332] = 0xA1CC,
  [8333] = 0xA1CD, [8334] = 0xA1CE, [8335] = 0xA1CF, [8336] = 0xA1D0,
  [8337] = 0xA1D1, [8338] = 0xA1D2, [8339] = 0xA1D3, [8340] = 0xA1D4,
  [8341] = 0xA1D5, [8342] = 0xA1D6, [8343] = 0xA1D7, [8344] = 0xA1D8,
  [8345] = 0xA1D9, [8346] = 0xA1DA, [8347] = 0xA1DB, [8348] = 0xA1DC,
  [8349] = 0xA1DD, [8350] = 0xA1DE, [8351] = 0xA1DF, [8352] = 0xA1E0,
  [8353] = 0xA1E1, [8354] = 0xA1E2, [8355] = 0xA1E3, [8356] = 0xA1E4,
  [8357] = 0xA1E5, [8358] = 0xA1E6, [8359] = 0xA1E7, [8360] = 0xA1E8,
  [8361] = 0xA1E9, [8362] = 0xA1EA, [8363] = 0xA1EB, [8364] = 0xA1EC,
  [8365] = 0xA1ED, [8366] = 0xA1EE, [8367] = 0xA1EF, [8368] = 0xA1F0,
  [8369] = 0xA1F1, [8370] = 0xA1F2, [8371] = 0xA1F3, [8372] = 0xA1F4,
  [8373] = 0xA1F5, [8374] = 0xA1F6, [8375] = 0xA1F7, [8376] = 0xA1F8,
  [8377] = 0xA1F9, [8378] = 0xA1FA, [8379] = 0xA1FB, [8380] = 0xA1FC,
  [8381] = 0xA1FD, [8382] = 0xA1FE, [8448] = 0xA240, [8449] = 0xA241,
  [8450] = 0xA242, [8451] = 0xA243, [8452] = 0xA244, [8453] = 0xA245,
  [8454] = 0xA246, [8455] = 0xA247, [8456] = 0xA248, [8457] = 0xA249,
  [8458] = 0xA24A, [8459] = 0xA24B, [8460] = 0xA24C, [8461] = 0xA24D,
  [8462] = 0xA24E, [8463] = 0xA24F, [8464] = 0xA250, [8465] = 0xA251,
  [8466] = 0xA252, [8467] = 0xA253, [8468] = 0xA254, [8469] = 0xA255,
  [8470] = 0xA256, [8471] = 0xA257, [8472] = 0xA258, [8473] = 0xA259,
  [8474] = 0xA25A, [8475] = 0xA25B, [8476] = 0xA25C, [8477] = 0xA25D,
  [8478] = 0xA25E, [8479] = 0xA25F, [8480] = 0xA260, [8481] = 0xA261,
  [8482] = 0xA262, [8483] = 0xA263, [8484] = 0xA264, [8485] = 0xA265,
  [8486] = 0xA266, [8487] = 0xA267, [8488] = 0xA268, [8489] = 0xA269,
  [8490] = 0xA26A, [8491] = 0xA26B, [8492] = 0xA26C, [8493] = 0xA26D,
  [8494] = 0xA26E, [8495] = 0xA26F, [8496] = 0xA270, [8497] = 0xA271,
  [8498] = 0xA272, [8499] = 0xA273, [8500] = 0xA274, [8501] = 0xA275,
  [8502] = 0xA276, [8503] = 0xA277, [8504] = 0xA278, [8505] = 0xA279,
  [8506] = 0xA27A, [8507] = 0xA27B, [8508] = 0xA27C, [8509] = 0xA27D,
  [8510] = 0xA27E, [8512] = 0xA280, [8513] = 0xA281, [8514] = 0xA282,
  [8515] = 0xA283, [8516] = 0xA284, [8517] = 0xA285, [8518] = 0xA286,
  [8519] = 0xA287, [8520] = 0xA288, [8521] = 0xA289, [8522] = 0xA28A,
  [8523] = 0xA28B, [8524] = 0xA28C, [8525] = 0xA28D, [8526] = 0xA28E,
  [8527] = 0xA28F, [8528] = 0xA290, [8529] = 0xA291, [8530] = 0xA292,
  [8531] = 0xA293, [8532] = 0xA294, [8533] = 0xA295, [8534] = 0xA296,
  [8535] = 0xA297, [8536] = 0xA298, [8537] = 0xA299, [8538] = 0xA29A,
  [8539] = 0xA29B, [8540] = 0xA29C, [8541] = 0xA29D, [8542] = 0xA29E,
  [8543] = 0xA29F, [8544] = 0xA2A0, [8545] = 0xA2A1, [8546] = 0xA2A2,
  [8547] = 0xA2A3, [8548] = 0xA2A4, [8549] = 0xA2A5, [8550] = 0xA2A6,
  [8551] = 0xA2A7, [8552] = 0xA2A8, [8553] = 0xA2A9, [8554] = 0xA2AA,
  [8555] = 0xA2AB, [8556] = 0xA2AC, [8557] = 0xA2AD, [8558] = 0xA2AE,
  [8559] = 0xA2AF, [8560] = 0xA2B0, [8561] = 0xA2B1, [8562] = 0xA2B2,
  [8563] = 0xA2B3, [8564] = 0xA2B4, [8565] = 0xA2B5, [8566] = 0xA2B6,
  [8567] = 0xA2B7, [8568] = 0xA2B8, [8569] = 0xA2B9, [8570] = 0xA2BA,
  [8571] = 0xA2BB, [8572] = 0xA2BC, [8573] = 0xA2BD, [8574] = 0xA2BE,
  [8575] = 0xA2BF, [8576] = 0xA2C0, [8577] = 0xA2C1, [8578] = 0xA2C2,
  [8579] = 0xA2C3, [8580] = 0xA2C4, [8581] = 0xA2C5, [8582] = 0xA2C6,
  [8583] = 0xA2C7, [8584] = 0xA2C8, [8585] = 0xA2C9, [8586] = 0xA2CA,
  [8587] = 0xA2CB, [8588] = 0xA2CC, [8589] = 0xA2CD, [8590] = 0xA2CE,
  [8591] = 0xA2CF, [8592] = 0xA2D0, [8593] = 0xA2D1, [8594] = 0xA2D2,
  [8595] = 0xA2D3, [8596] = 0xA2D4, [8597] = 0xA2D5, [8598] = 0xA2D6,
  [8599] = 0xA2D7, [8600] = 0xA2D8, [8601] = 0xA2D9, [8602] = 0xA2DA,
  [8603] = 0xA2DB, [8604] = 0xA2DC, [8605] = 0xA2DD, [8606] = 0xA2DE,
  [8607] = 0xA2DF, [8608] = 0xA2E0, [8609] = 0xA2E1, [8610] = 0xA2E2,
  [8611] = 0xA2E3, [8612] = 0xA2E4, [8613] = 0xA2E5, [8614] = 0xA2E6,
  [8615] = 0xA2E7, [8616] = 0xA2E8, [8617] = 0xA2E9, [8618] = 0xA2EA,
  [8619] = 0xA2EB, [8620] = 0xA2EC, [8621] = 0xA2ED, [8622] = 0xA2EE,
  [8623] = 0xA2EF, [8624] = 0xA2F0, [8625] = 0xA2F1, [8626] = 0xA2F2,
  [8627] = 0xA2F3, [8628] = 0xA2F4, [8629] = 0xA2F5, [8630] = 0xA2F6,
  [8631] = 0xA2F7, [8632] = 0xA2F8, [8633] = 0xA2F9, [8634] = 0xA2FA,
  [8635] = 0xA2FB, [8636] = 0xA2FC, [8637] = 0xA2FD, [8638] = 0xA2FE,
  [8704] = 0xA340, [8705] = 0xA341, [8706] = 0xA342, [8707] = 0xA343,
  [8708] = 0xA344, [8709] = 0xA345, [8710] = 0xA346, [8711] = 0xA347,
  [8712] = 0xA348, [8713] = 0xA349, [8714] = 0xA34A, [8715] = 0xA34B,
  [8716] = 0xA34C, [8717] = 0xA34D, [8718] = 0xA34E, [8719] = 0xA34F,
  [8720] = 0xA350, [8721] = 0xA351, [8722] = 0xA352, [8723] = 0xA353,
  [8724] = 0xA354, [8725] = 0xA355, [8726] = 0xA356, [8727] = 0xA357,
  [8728] = 0xA358, [8729] = 0xA359, [8730] = 0xA35A, [8731] = 0xA35B,
  [8732] = 0xA35C, [8733] = 0xA35D, [8734] = 0xA35E, [8735] = 0xA35F,
  [8736] = 0xA360, [8737] = 0xA361, [8738] = 0xA362, [8739] = 0xA363,
  [8740] = 0xA364, [8741] = 0xA365, [8742] = 0xA366, [8743] = 0xA367,
  [8744] = 0xA368, [8745] = 0xA369, [8746] = 0xA36A, [8747] = 0xA36B,
  [8748] = 0xA36C, [8749] = 0xA36D, [8750] = 0xA36E, [8751] = 0xA36F,
  [8752] = 0xA370, [8753] = 0xA371, [8754] = 0xA372, [8755] = 0xA373,
  [8756] = 0xA374, [8757] = 0xA375, [8758] = 0xA376, [8759] = 0xA377,
  [8760] = 0xA378, [8761] = 0xA379, [8762] = 0xA37A, [8763] = 0xA37B,
  [8764] = 0xA37C, [8765] = 0xA37D, [8766] = 0xA37E, [8768] = 0xA380,
  [8769] = 0xA381, [8770] = 0xA382, [8771] = 0xA383, [8772] = 0xA384,
  [8773] = 0xA385, [8774] = 0xA386, [8775] = 0xA387, [8776] = 0xA388,
  [8777] = 0xA389, [8778] = 0xA38A, [8779] = 0xA38B, [8780] = 0xA38C,
  [8781] = 0xA38D, [8782] = 0xA38E, [8783] = 0xA38F, [8784] = 0xA390,
  [8785] = 0xA391, [8786] = 0xA392, [8787] = 0xA393, [8788] = 0xA394,
  [8789] = 0xA395, [8790] = 0xA396, [8791] = 0xA397, [8792] = 0xA398,
  [8793] = 0xA399, [8794] = 0xA39A, [8795] = 0xA39B, [8796] = 0xA39C,
  [8797] = 0xA39D, [8798] = 0xA39E, [8799] = 0xA39F, [8800] = 0xA3A0,
  [8801] = 0xA3A1, [8802] = 0xA3A2, [8803] = 0xA3A3, [8804] = 0xA3A4,
  [8805] = 0xA3A5, [8806] = 0xA3A6, [8807] = 0xA3A7, [8808] = 0xA3A8,
  [8809] = 0xA3A9, [8810] = 0xA3AA, [8811] = 0xA3AB, [8812] = 0xA3AC,
  [8813] = 0xA3AD, [8814] = 0xA3AE, [8815] = 0xA3AF, [8816] = 0xA3B0,
  [8817] = 0xA3B1, [8818] = 0xA3B2, [8819] = 0xA3B3, [8820] = 0xA3B4,
  [8821] = 0xA3B5, [8822] = 0xA3B6, [8823] = 0xA3B7, [8824] = 0xA3B8,
  [8825] = 0xA3B9, [8826] = 0xA3BA, [8827] = 0xA3BB, [8828] = 0xA3BC,
  [8829] = 0xA3BD, [8830] = 0xA3BE, [8831] = 0xA3BF, [8832] = 0xA3C0,
  [8833] = 0xA3C1, [8834] = 0xA3C2, [8835] = 0xA3C3, [8836] = 0xA3C4,
  [8837] = 0xA3C5, [8838] = 0xA3C6, [8839] = 0xA3C7, [8840] = 0xA3C8,
  [8841] = 0xA3C9, [8842] = 0xA3CA, [8843] = 0xA3CB, [8844] = 0xA3CC,
  [8845] = 0xA3CD, [8846] = 0xA3CE, [8847] = 0xA3CF, [8848] = 0xA3D0,
  [8849] = 0xA3D1, [8850] = 0xA3D2, [8851] = 0xA3D3, [8852] = 0xA3D4,
  [8853] = 0xA3D5, [8854] = 0xA3D6, [8855] = 0xA3D7, [8856] = 0xA3D8,
  [8857] = 0xA3D9, [8858] = 0xA3DA, [8859] = 0xA3DB, [8860] = 0xA3DC,
  [8861] = 0xA3DD, [8862] = 0xA3DE, [8863] = 0xA3DF, [8864] = 0xA3E0,
  [8865] = 0xA3E1, [8866] = 0xA3E2, [8867] = 0xA3E3, [8868] = 0xA3E4,
  [8869] = 0xA3E5, [8870] = 0xA3E6, [8871] = 0xA3E7, [8872] = 0xA3E8,
  [8873] = 0xA3E9, [8874] = 0xA3EA, [8875] = 0xA3EB, [8876] = 0xA3EC,
  [8877] = 0xA3ED, [8878] = 0xA3EE, [8879] = 0xA3EF, [8880] = 0xA3F0,
  [8881] = 0xA3F1, [8882] = 0xA3F2, [8883] = 0xA3F3, [8884] = 0xA3F4,
  [8885] = 0xA3F5, [8886] = 0xA3F6, [8887] = 0xA3F7, [8888] = 0xA3F8,
  [8889] = 0xA3F9, [8890] = 0xA3FA, [8891] = 0xA3FB, [8892] = 0xA3FC,
  [8893] = 0xA3FD, [8894] = 0xA3FE, [8960] = 0xA440, [8961] = 0xA441,
  [8962] = 0xA442, [8963] = 0xA443, [8964] = 0xA444, [8965] = 0xA445,
  [8966] = 0xA446, [8967] = 0xA447, [8968] = 0xA448, [8969] = 0xA449,
  [8970] = 0xA44A, [8971] = 0xA44B, [8972] = 0xA44C, [8973] = 0xA44D,
  [8974] = 0xA44E, [8975] = 0xA44F, [8976] = 0xA450, [8977] = 0xA451,
  [8978] = 0xA452, [8979] = 0xA453, [8980] = 0xA454, [8981] = 0xA455,
  [8982] = 0xA456, [8983] = 0xA457, [8984] = 0xA458, [8985] = 0xA459,
  [8986] = 0xA45A, [8987] = 0xA45B, [8988] = 0xA45C, [8989] = 0xA45D,
  [8990] = 0xA45E, [8991] = 0xA45F, [8992] = 0xA460, [8993] = 0xA461,
  [8994] = 0xA462, [8995] = 0xA463, [8996] = 0xA464, [8997] = 0xA465,
  [8998] = 0xA466, [8999] = 0xA467, [9000] = 0xA468, [9001] = 0xA469,
  [9002] = 0xA46A, [9003] = 0xA46B, [9004] = 0xA46C, [9005] = 0xA46D,
  [9006] = 0xA46E, [9007] = 0xA46F, [9008] = 0xA470, [9009] = 0xA471,
  [9010] = 0xA472, [9011] = 0xA473, [9012] = 0xA474, [9013] = 0xA475,
  [9014] = 0xA476, [9015] = 0xA477, [9016] = 0xA478, [9017] = 0xA479,
  [9018] = 0xA47A, [9019] = 0xA47B, [9020] = 0xA47C, [9021] = 0xA47D,
  [9022] = 0xA47E, [9024] = 0xA480, [9025] = 0xA481, [9026] = 0xA482,
  [9027] = 0xA483, [9028] = 0xA484, [9029] = 0xA485, [9030] = 0xA486,
  [9031] = 0xA487, [9032] = 0xA488, [9033] = 0xA489, [9034] = 0xA48A,
  [9035] = 0xA48B, [9036] = 0xA48C, [9037] = 0xA48D, [9038] = 0xA48E,
  [9039] = 0xA48F, [9040] = 0xA490, [9041] = 0xA491, [9042] = 0xA492,
  [9043] = 0xA493, [9044] = 0xA494, [9045] = 0xA495, [9046] = 0xA496,
  [9047] = 0xA497, [9048] = 0xA498, [9049] = 0xA499, [9050] = 0xA49A,
  [9051] = 0xA49B, [9052] = 0xA49C, [9053] = 0xA49D, [9054] = 0xA49E,
  [9055] = 0xA49F, [9056] = 0xA4A0, [9057] = 0xA4A1, [9058] = 0xA4A2,
  [9059] = 0xA4A3, [9060] = 0xA4A4, [9061] = 0xA4A5, [9062] = 0xA4A6,
  [9063] = 0xA4A7, [9064] = 0xA4A8, [9065] = 0xA4A9, [9066] = 0xA4AA,
  [9067] = 0xA4AB, [9068] = 0xA4AC, [9069] = 0xA4AD, [9070] = 0xA4AE,
  [9071] = 0xA4AF, [9072] = 0xA4B0, [9073] = 0xA4B1, [9074] = 0xA4B2,
  [9075] = 0xA4B3, [9076] = 0xA4B4, [9077] = 0xA4B5, [9078] = 0xA4B6,
  [9079] = 0xA4B7, [9080] = 0xA4B8, [9081] = 0xA4B9, [9082] = 0xA4BA,
  [9083] = 0xA4BB, [9084] = 0xA4BC, [9085] = 0xA4BD, [9086] = 0xA4BE,
  [9087] = 0xA4BF, [9088] = 0xA4C0, [9089] = 0xA4C1, [9090] = 0xA4C2,
  [9091] = 0xA4C3, [9092] = 0xA4C4, [9093] = 0xA4C5, [9094] = 0xA4C6,
  [9095] = 0xA4C7, [9096] = 0xA4C8, [9097] = 0xA4C9, [9098] = 0xA4CA,
  [9099] = 0xA4CB, [9100] = 0xA4CC, [9101] = 0xA4CD, [9102] = 0xA4CE,
  [9103] = 0xA4CF, [9104] = 0xA4D0, [9105] = 0xA4D1, [9106] = 0xA4D2,
  [9107] = 0xA4D3, [9108] = 0xA4D4, [9109] = 0xA4D5, [9110] = 0xA4D6,
  [9111] = 0xA4D7, [9112] = 0xA4D8, [9113] = 0xA4D9, [9114] = 0xA4DA,
  [9115] = 0xA4DB, [9116] = 0xA4DC, [9117] = 0xA4DD, [9118] = 0xA4DE,
  [9119] = 0xA4DF, [9120] = 0xA4E0, [9121] = 0xA4E1, [9122] = 0xA4E2,
  [9123] = 0xA4E3, [9124] = 0xA4E4, [9125] = 0xA4E5, [9126] = 0xA4E6,
  [9127] = 0xA4E7, [9128] = 0xA4E8, [9129] = 0xA4E9, [9130] = 0xA4EA,
  [9131] = 0xA4EB, [9132] = 0xA4EC, [9133] = 0xA4ED, [9134] = 0xA4EE,
  [9135] = 0xA4EF, [9136] = 0xA4F0, [9137] = 0xA4F1, [9138] = 0xA4F2,
  [9139] = 0xA4F3, [9140] = 0xA4F4, [9141] = 0xA4F5, [9142] = 0xA4F6,
  [9143] = 0xA4F7, [9144] = 0xA4F8, [9145] = 0xA4F9, [9146] = 0xA4FA,
  [9147] = 0xA4FB, [9148] = 0xA4FC, [9149] = 0xA4FD, [9150] = 0xA4FE,
  [9216] = 0xA540, [9217] = 0xA541, [9218] = 0xA542, [9219] = 0xA543,
  [9220] = 0xA544, [9221] = 0xA545, [9222] = 0xA546, [9223] = 0xA547,
  [9224] = 0xA548, [9225] = 0xA549, [9226] = 0xA54A, [9227] = 0xA54B,
  [9228] = 0xA54C, [9229] = 0xA54D, [9230] = 0xA54E, [9231] = 0xA54F,
  [9232] = 0xA550, [9233] = 0xA551, [9234] = 0xA552, [9235] = 0xA553,
  [9236] = 0xA554, [9237] = 0xA555, [9238] = 0xA556, [9239] = 0xA557,
  [9240] = 0xA558, [9241] = 0xA559, [9242] = 0xA55A, [9243] = 0xA55B,
  [9244] = 0xA55C, [9245] = 0xA55D, [9246] = 0xA55E, [9247] = 0xA55F,
  [9248] = 0xA560, [9249] = 0xA561, [9250] = 0xA562, [9251] = 0xA563,
  [9252] = 0xA564, [9253] = 0xA565, [9254] = 0xA566, [9255] = 0xA567,
  [9256] = 0xA568, [9257] = 0xA569, [9258] = 0xA56A, [9259] = 0xA56B,
  [9260] = 0xA56C, [9261] = 0xA56D, [9262] = 0xA56E, [9263] = 0xA56F,
  [9264] = 0xA570, [9265] = 0xA571, [9266] = 0xA572, [9267] = 0xA573,
  [9268] = 0xA574, [9269] = 0xA575, [9270] = 0xA576, [9271] = 0xA577,
  [9272] = 0xA578, [9273] = 0xA579, [9274] = 0xA57A, [9275] = 0xA57B,
  [9276] = 0xA57C, [9277] = 0xA57D, [9278] = 0xA57E, [9280] = 0xA580,
  [9281] = 0xA581, [9282] = 0xA582, [9283] = 0xA583, [9284] = 0xA584,
  [9285] = 0xA585, [9286] = 0xA586, [9287] = 0xA587, [9288] = 0xA588,
  [9289] = 0xA589, [9290] = 0xA58A, [9291] = 0xA58B, [9292] = 0xA58C,
  [9293] = 0xA58D, [9294] = 0xA58E, [9295] = 0xA58F, [9296] = 0xA590,
  [9297] = 0xA591, [9298] = 0xA592, [9299] = 0xA593, [9300] = 0xA594,
  [9301] = 0xA595, [9302] = 0xA596, [9303] = 0xA597, [9304] = 0xA598,
  [9305] = 0xA599, [9306] = 0xA59A, [9307] = 0xA59B, [9308] = 0xA59C,
  [9309] = 0xA59D, [9310] = 0xA59E, [9311] = 0xA59F, [9312] = 0xA5A0,
  [9313] = 0xA5A1, [9314] = 0xA5A2, [9315] = 0xA5A3, [9316] = 0xA5A4,
  [9317] = 0xA5A5, [9318] = 0xA5A6, [9319] = 0xA5A7, [9320] = 0xA5A8,
  [9321] = 0xA5A9, [9322] = 0xA5AA, [9323] = 0xA5AB, [9324] = 0xA5AC,
  [9325] = 0xA5AD, [9326] = 0xA5AE, [9327] = 0xA5AF, [9328] = 0xA5B0,
  [9329] = 0xA5B1, [9330] = 0xA5B2, [9331] = 0xA5B3, [9332] = 0xA5B4,
  [9333] = 0xA5B5, [9334] = 0xA5B6, [9335] = 0xA5B7, [9336] = 0xA5B8,
  [9337] = 0xA5B9, [9338] = 0xA5BA, [9339] = 0xA5BB, [9340] = 0xA5BC,
  [9341] = 0xA5BD, [9342] = 0xA5BE, [9343] = 0xA5BF, [9344] = 0xA5C0,
  [9345] = 0xA5C1, [9346] = 0xA5C2, [9347] = 0xA5C3, [9348] = 0xA5C4,
  [9349] = 0xA5C5, [9350] = 0xA5C6, [9351] = 0xA5C7, [9352] = 0xA5C8,
  [9353] = 0xA5C9, [9354] = 0xA5CA, [9355] = 0xA5CB, [9356] = 0xA5CC,
  [9357] = 0xA5CD, [9358] = 0xA5CE, [9359] = 0xA5CF, [9360] = 0xA5D0,
  [9361] = 0xA5D1, [9362] = 0xA5D2, [9363] = 0xA5D3, [9364] = 0xA5D4,
  [9365] = 0xA5D5, [9366] = 0xA5D6, [9367] = 0xA5D7, [9368] = 0xA5D8,
  [9369] = 0xA5D9, [9370] = 0xA5DA, [9371] = 0xA5DB, [9372] = 0xA5DC,
  [9373] = 0xA5DD, [9374] = 0xA5DE, [9375] = 0xA5DF, [9376] = 0xA5E0,
  [9377] = 0xA5E1, [9378] = 0xA5E2, [9379] = 0xA5E3, [9380] = 0xA5E4,
  [9381] = 0xA5E5, [9382] = 0xA5E6, [9383] = 0xA5E7, [9384] = 0xA5E8,
  [9385] = 0xA5E9, [9386] = 0xA5EA, [9387] = 0xA5EB, [9388] = 0xA5EC,
  [9389] = 0xA5ED, [9390] = 0xA5EE, [9391] = 0xA5EF, [9392] = 0xA5F0,
  [9393] = 0xA5F1, [9394] = 0xA5F2, [9395] = 0xA5F3, [9396] = 0xA5F4,
  [9397] = 0xA5F5, [9398] = 0xA5F6, [9399] = 0xA5F7, [9400] = 0xA5F8,
  [9401] = 0xA5F9, [9402] = 0xA5FA, [9403] = 0xA5FB, [9404] = 0xA5FC,
  [9405] = 0xA5FD, [9406] = 0xA5FE, [9472] = 0xA640, [9473] = 0xA641,
  [9474] = 0xA642, [9475] = 0xA643, [9476] = 0xA644, [9477] = 0xA645,
  [9478] = 0xA646, [9479] = 0xA647, [9480] = 0xA648, [9481] = 0xA649,
  [9482] = 0xA64A, [9483] = 0xA64B, [9484] = 0xA64C, [9485] = 0xA64D,
  [9486] = 0xA64E, [9487] = 0xA64F, [9488] = 0xA650, [9489] = 0xA651,
  [9490] = 0xA652, [9491] = 0xA653, [9492] = 0xA654, [9493] = 0xA655,
  [9494] = 0xA656, [9495] = 0xA657, [9496] = 0xA658, [9497] = 0xA659,
  [9498] = 0xA65A, [9499] = 0xA65B, [9500] = 0xA65C, [9501] = 0xA65D,
  [9502] = 0xA65E, [9503] = 0xA65F, [9504] = 0xA660, [9505] = 0xA661,
  [9506] = 0xA662, [9507] = 0xA663, [9508] = 0xA664, [9509] = 0xA665,
  [9510] = 0xA666, [9511] = 0xA667, [9512] = 0xA668, [9513] = 0xA669,
  [9514] = 0xA66A, [9515] = 0xA66B, [9516] = 0xA66C, [9517] = 0xA66D,
  [9518] = 0xA66E, [9519] = 0xA66F, [9520] = 0xA670, [9521] = 0xA671,
  [9522] = 0xA672, [9523] = 0xA673, [9524] = 0xA674, [9525] = 0xA675,
  [9526] = 0xA676, [9527] = 0xA677, [9528] = 0xA678, [9529] = 0xA679,
  [9530] = 0xA67A, [9531] = 0xA67B, [9532] = 0xA67C, [9533] = 0xA67D,
  [9534] = 0xA67E, [9536] = 0xA680, [9537] = 0xA681, [9538] = 0xA682,
  [9539] = 0xA683, [9540] = 0xA684, [9541] = 0xA685, [9542] = 0xA686,
  [9543] = 0xA687, [9544] = 0xA688, [9545] = 0xA689, [9546] = 0xA68A,
  [9547] = 0xA68B, [9548] = 0xA68C, [9549] = 0xA68D, [9550] = 0xA68E,
  [9551] = 0xA68F, [9552] = 0xA690, [9553] = 0xA691, [9554] = 0xA692,
  [9555] = 0xA693, [9556] = 0xA694, [9557] = 0xA695, [9558] = 0xA696,
  [9559] = 0xA697, [9560] = 0xA698, [9561] = 0xA699, [9562] = 0xA69A,
  [9563] = 0xA69B, [9564] = 0xA69C, [9565] = 0xA69D, [9566] = 0xA69E,
  [9567] = 0xA69F, [9568] = 0xA6A0, [9569] = 0xA6A1, [9570] = 0xA6A2,
  [9571] = 0xA6A3, [9572] = 0xA6A4, [9573] = 0xA6A5, [9574] = 0xA6A6,
  [9575] = 0xA6A7, [9576] = 0xA6A8, [9577] = 0xA6A9, [9578] = 0xA6AA,
  [9579] = 0xA6AB, [9580] = 0xA6AC, [9581] = 0xA6AD, [9582] = 0xA6AE,
  [9583] = 0xA6AF, [9584] = 0xA6B0, [9585] = 0xA6B1, [9586] = 0xA6B2,
  [9587] = 0xA6B3, [9588] = 0xA6B4, [9589] = 0xA6B5, [9590] = 0xA6B6,
  [9591] = 0xA6B7, [9592] = 0xA6B8, [9593] = 0xA6B9, [9594] = 0xA6BA,
  [9595] = 0xA6BB, [9596] = 0xA6BC, [9597] = 0xA6BD, [9598] = 0xA6BE,
  [9599] = 0xA6BF, [9600] = 0xA6C0, [9601] = 0xA6C1, [9602] = 0xA6C2,
  [9603] = 0xA6C3, [9604] = 0xA6C4, [9605] = 0xA6C5, [9606] = 0xA6C6,
  [9607] = 0xA6C7, [9608] = 0xA6C8, [9609] = 0xA6C9, [9610] = 0xA6CA,
  [9611] = 0xA6CB, [9612] = 0xA6CC, [9613] = 0xA6CD, [9614] = 0xA6CE,
  [9615] = 0xA6CF, [9616] = 0xA6D0, [9617] = 0xA6D1, [9618] = 0xA6D2,
  [9619] = 0xA6D3, [9620] = 0xA6D4, [9621] = 0xA6D5, [9622] = 0xA6D6,
  [9623] = 0xA6D7, [9624] = 0xA6D8, [9625] = 0xA6D9, [9626] = 0xA6DA,
  [9627] = 0xA6DB, [9628] = 0xA6DC, [9629] = 0xA6DD, [9630] = 0xA6DE,
  [9631] = 0xA6DF, [9632] = 0xA6E0, [9633] = 0xA6E1, [9634] = 0xA6E2,
  [9635] = 0xA6E3, [9636] = 0xA6E4, [9637] = 0xA6E5, [9638] = 0xA6E6,
  [9639] = 0xA6E7, [9640] = 0xA6E8, [9641] = 0xA6E9, [9642] = 0xA6EA,
  [9643] = 0xA6EB, [9644] = 0xA6EC, [9645] = 0xA6ED, [9646] = 0xA6EE,
  [9647] = 0xA6EF, [9648] = 0xA6F0, [9649] = 0xA6F1, [9650] = 0xA6F2,
  [9651] = 0xA6F3, [9652] = 0xA6F4, [9653] = 0xA6F5, [9654] = 0xA6F6,
  [9655] = 0xA6F7, [9656] = 0xA6F8, [9657] = 0xA6F9, [9658] = 0xA6FA,
  [9659] = 0xA6FB, [9660] = 0xA6FC, [9661] = 0xA6FD, [9662] = 0xA6FE,
  [9728] = 0xA740, [9729] = 0xA741, [9730] = 0xA742, [9731] = 0xA743,
  [9732] = 0xA744, [9733] = 0xA745, [9734] = 0xA746, [9735] = 0xA747,
  [9736] = 0xA748, [9737] = 0xA749, [9738] = 0xA74A, [9739] = 0xA74B,
  [9740] = 0xA74C, [9741] = 0xA74D, [9742] = 0xA74E, [9743] = 0xA74F,
  [9744] = 0xA750, [9745] = 0xA751, [9746] = 0xA752, [9747] = 0xA753,
  [9748] = 0xA754, [9749] = 0xA755, [9750] = 0xA756, [9751] = 0xA757,
  [9752] = 0xA758, [9753] = 0xA759, [9754] = 0xA75A, [9755] = 0xA75B,
  [9756] = 0xA75C, [9757] = 0xA75D, [9758] = 0xA75E, [9759] = 0xA75F,
  [9760] = 0xA760, [9761] = 0xA761, [9762] = 0xA762, [9763] = 0xA763,
  [9764] = 0xA764, [9765] = 0xA765, [9766] = 0xA766, [9767] = 0xA767,
  [9768] = 0xA768, [9769] = 0xA769, [9770] = 0xA76A, [9771] = 0xA76B,
  [9772] = 0xA76C, [9773] = 0xA76D, [9774] = 0xA76E, [9775] = 0xA76F,
  [9776] = 0xA770, [9777] = 0xA771, [9778] = 0xA772, [9779] = 0xA773,
  [9780] = 0xA774, [9781] = 0xA775, [9782] = 0xA776, [9783] = 0xA777,
  [9784] = 0xA778, [9785] = 0xA779, [9786] = 0xA77A, [9787] = 0xA77B,
  [9788] = 0xA77C, [9789] = 0xA77D, [9790] = 0xA77E, [9792] = 0xA780,
  [9793] = 0xA781, [9794] = 0xA782, [9795] = 0xA783, [9796] = 0xA784,
  [9797] = 0xA785, [9798] = 0xA786, [9799] = 0xA787, [9800] = 0xA788,
  [9801] = 0xA789, [9802] = 0xA78A, [9803] = 0xA78B, [9804] = 0xA78C,
  [9805] = 0xA78D, [9806] = 0xA78E, [9807] = 0xA78F, [9808] = 0xA790,
  [9809] = 0xA791, [9810] = 0xA792, [9811] = 0xA793, [9812] = 0xA794,
  [9813] = 0xA795, [9814] = 0xA796, [9815] = 0xA797, [9816] = 0xA798,
  [9817] = 0xA799, [9818] = 0xA79A, [9819] = 0xA79B, [9820] = 0xA79C,
  [9821] = 0xA79D, [9822] = 0xA79E, [9823] = 0xA79F, [9824] = 0xA7A0,
  [9825] = 0xA7A1, [9826] = 0xA7A2, [9827] = 0xA7A3, [9828] = 0xA7A4,
  [9829] = 0xA7A5, [9830] = 0xA7A6, [9831] = 0xA7A7, [9832] = 0xA7A8,
  [9833] = 0xA7A9, [9834] = 0xA7AA, [9835] = 0xA7AB, [9836] = 0xA7AC,
  [9837] = 0xA7AD, [9838] = 0xA7AE, [9839] = 0xA7AF, [9840] = 0xA7B0,
  [9841] = 0xA7B1, [9842] = 0xA7B2, [9843] = 0xA7B3, [9844] = 0xA7B4,
  [9845] = 0xA7B5, [9846] = 0xA7B6, [9847] = 0xA7B7, [9848] = 0xA7B8,
  [9849] = 0xA7B9, [9850] = 0xA7BA, [9851] = 0xA7BB, [9852] = 0xA7BC,
  [9853] = 0xA7BD, [9854] = 0xA7BE, [9855] = 0xA7BF, [9856] = 0xA7C0,
  [9857] = 0xA7C1, [9858] = 0xA7C2, [9859] = 0xA7C3, [9860] = 0xA7C4,
  [9861] = 0xA7C5, [9862] = 0xA7C6, [9863] = 0xA7C7, [9864] = 0xA7C8,
  [9865] = 0xA7C9, [9866] = 0xA7CA, [9867] = 0xA7CB, [9868] = 0xA7CC,
  [9869] = 0xA7CD, [9870] = 0xA7CE, [9871] = 0xA7CF, [9872] = 0xA7D0,
  [9873] = 0xA7D1, [9874] = 0xA7D2, [9875] = 0xA7D3, [9876] = 0xA7D4,
  [9877] = 0xA7D5, [9878] = 0xA7D6, [9879] = 0xA7D7, [9880] = 0xA7D8,
  [9881] = 0xA7D9, [9882] = 0xA7DA, [9883] = 0xA7DB, [9884] = 0xA7DC,
  [9885] = 0xA7DD, [9886] = 0xA7DE, [9887] = 0xA7DF, [9888] = 0xA7E0,
  [9889] = 0xA7E1, [9890] = 0xA7E2, [9891] = 0xA7E3, [9892] = 0xA7E4,
  [9893] = 0xA7E5, [9894] = 0xA7E6, [9895] = 0xA7E7, [9896] = 0xA7E8,
  [9897] = 0xA7E9, [9898] = 0xA7EA, [9899] = 0xA7EB, [9900] = 0xA7EC,
  [9901] = 0xA7ED, [9902] = 0xA7EE, [9903] = 0xA7EF, [9904] = 0xA7F0,
  [9905] = 0xA7F1, [9906] = 0xA7F2, [9907] = 0xA7F3, [9908] = 0xA7F4,
  [9909] = 0xA7F5, [9910] = 0xA7F6, [9911] = 0xA7F7, [9912] = 0xA7F8,
  [9913] = 0xA7F9, [9914] = 0xA7FA, [9915] = 0xA7FB, [9916] = 0xA7FC,
  [9917] = 0xA7FD, [9918] = 0xA7FE, [9984] = 0xA840, [9985] = 0xA841,
  [9986] = 0xA842, [9987] = 0xA843, [9988] = 0xA844, [9989] = 0xA845,
  [9990] = 0xA846, [9991] = 0xA847, [9992] = 0xA848, [9993] = 0xA849,
  [9994] = 0xA84A, [9995] = 0xA84B, [9996] = 0xA84C, [9997] = 0xA84D,
  [9998] = 0xA84E, [9999] = 0xA84F, [10000] = 0xA850, [10001] = 0xA851,
  [10002] = 0xA852, [10003] = 0xA853, [10004] = 0xA854, [10005] = 0xA855,
  [10006] = 0xA856, [10007] = 0xA857, [10008] = 0xA858, [10009] = 0xA859,
  [10010] = 0xA85A, [10011] = 0xA85B, [10012] = 0xA85C, [10013] = 0xA85D,
  [10014] = 0xA85E, [10015] = 0xA85F, [10016] = 0xA860, [10017] = 0xA861,
  [10018] = 0xA862, [10019] = 0xA863, [10020] = 0xA864, [10021] = 0xA865,
  [10022] = 0xA866, [10023] = 0xA867, [10024] = 0xA868, [10025] = 0xA869,
  [10026] = 0xA86A, [10027] = 0xA86B, [10028] = 0xA86C, [10029] = 0xA86D,
  [10030] = 0xA86E, [10031] = 0xA86F, [10032] = 0xA870, [10033] = 0xA871,
  [10034] = 0xA872, [10035] = 0xA873, [10036] = 0xA874, [10037] = 0xA875,
  [10038] = 0xA876, [10039] = 0xA877, [10040] = 0xA878, [10041] = 0xA879,
  [10042] = 0xA87A, [10043] = 0xA87B, [10044] = 0xA87C, [10045] = 0xA87D,
  [10046] = 0xA87E, [10048] = 0xA880, [10049] = 0xA881, [10050] = 0xA882,
  [10051] = 0xA883, [10052] = 0xA884, [10053] = 0xA885, [10054] = 0xA886,
  [10055] = 0xA887, [10056] = 0xA888, [10057] = 0xA889, [10058] = 0xA88A,
  [10059] = 0xA88B, [10060] = 0xA88C, [10061] = 0xA88D, [10062] = 0xA88E,
  [10063] = 0xA88F, [10064] = 0xA890, [10065] = 0xA891, [10066] = 0xA892,
  [10067] = 0xA893, [10068] = 0xA894, [10069] = 0xA895, [10070] = 0xA896,
  [10071] = 0xA897, [10072] = 0xA898, [10073] = 0xA899, [10074] = 0xA89A,
  [10075] = 0xA89B, [10076] = 0xA89C, [10077] = 0xA89D, [10078] = 0xA89E,
  [10079] = 0xA89F, [10080] = 0xA8A0, [10081] = 0xA8A1, [10082] = 0xA8A2,
  [10083] = 0xA8A3, [10084] = 0xA8A4, [10085] = 0xA8A5, [10086] = 0xA8A6,
  [10087] = 0xA8A7, [10088] = 0xA8A8, [10089] = 0xA8A9, [10090] = 0xA8AA,
  [10091] = 0xA8AB, [10092] = 0xA8AC, [10093] = 0xA8AD, [10094] = 0xA8AE,
  [10095] = 0xA8AF, [10096] = 0xA8B0, [10097] = 0xA8B1, [10098] = 0xA8B2,
  [10099] = 0xA8B3, [10100] = 0xA8B4, [10101] = 0xA8B5, [10102] = 0xA8B6,
  [10103] = 0xA8B7, [10104] = 0xA8B8, [10105] = 0xA8B9, [10106] = 0xA8BA,
  [10107] = 0xA8BB, [10108] = 0xA8BC, [10109] = 0xA8BD, [10110] = 0xA8BE,
  [10111] = 0xA8BF, [10112] = 0xA8C0, [10113] = 0xA8C1, [10114] = 0xA8C2,
  [10115] = 0xA8C3, [10116] = 0xA8C4, [10117] = 0xA8C5, [10118] = 0xA8C6,
  [10119] = 0xA8C7, [10120] = 0xA8C8, [10121] = 0xA8C9, [10122] = 0xA8CA,
  [10123] = 0xA8CB, [10124] = 0xA8CC, [10125] = 0xA8CD, [10126] = 0xA8CE,
  [10127] = 0xA8CF, [10128] = 0xA8D0, [10129] = 0xA8D1, [10130] = 0xA8D2,
  [10131] = 0xA8D3, [10132] = 0xA8D4, [10133] = 0xA8D5, [10134] = 0xA8D6,
  [10135] = 0xA8D7, [10136] = 0xA8D8, [10137] = 0xA8D9, [10138] = 0xA8DA,
  [10139] = 0xA8DB, [10140] = 0xA8DC, [10141] = 0xA8DD, [10142] = 0xA8DE,
  [10143] = 0xA8DF, [10144] = 0xA8E0, [10145] = 0xA8E1, [10146] = 0xA8E2,
  [10147] = 0xA8E3, [10148] = 0xA8E4, [10149] = 0xA8E5, [10150] = 0xA8E6,
  [10151] = 0xA8E7, [10152] = 0xA8E8, [10153] = 0xA8E9, [10154] = 0xA8EA,
  [10155] = 0xA8EB, [10156] = 0xA8EC, [10157] = 0xA8ED, [10158] = 0xA8EE,
  [10159] = 0xA8EF, [10160] = 0xA8F0, [10161] = 0xA8F1, [10162] = 0xA8F2,
  [10163] = 0xA8F3, [10164] = 0xA8F4, [10165] = 0xA8F5, [10166] = 0xA8F6,
  [10167] = 0xA8F7, [10168] = 0xA8F8, [10169] = 0xA8F9, [10170] = 0xA8FA,
  [10171] = 0xA8FB, [10172] = 0xA8FC, [10173] = 0xA8FD, [10174] = 0xA8FE,
  [10240] = 0xA940, [10241] = 0xA941, [10242] = 0xA942, [10243] = 0xA943,
  [10244] = 0xA944, [10245] = 0xA945, [10246] = 0xA946, [10247] = 0xA947,
  [10248] = 0xA948, [10249] = 0xA949, [10250] = 0xA94A, [10251] = 0xA94B,
  [10252] = 0xA94C, [10253] = 0xA94D, [10254] = 0xA94E, [10255] = 0xA94F,
  [10256] = 0xA950, [10257] = 0xA951, [10258] = 0xA952, [10259] = 0xA953,
  [10260] = 0xA954, [10261] = 0xA955, [10262] = 0xA956, [10263] = 0xA957,
  [10264] = 0xA958, [10265] = 0xA959, [10266] = 0xA95A, [10267] = 0xA95B,
  [10268] = 0xA95C, [10269] = 0xA95D, [10270] = 0xA95E, [10271] = 0xA95F,
  [10272] = 0xA960, [10273] = 0xA961, [10274] = 0xA962, [10275] = 0xA963,
  [10276] = 0xA964, [10277] = 0xA965, [10278] = 0xA966, [10279] = 0xA967,
  [10280] = 0xA968, [10281] = 0xA969, [10282] = 0xA96A, [10283] = 0xA96B,
  [10284] = 0xA96C, [10285] = 0xA96D, [10286] = 0xA96E, [10287] = 0xA96F,
  [10288] = 0xA970, [10289] = 0xA971, [10290] = 0xA972, [10291] = 0xA973,
  [10292] = 0xA974, [10293] = 0xA975, [10294] = 0xA976, [10295] = 0xA977,
  [10296] = 0xA978, [10297] = 0xA979, [10298] = 0xA97A, [10299] = 0xA97B,
  [10300] = 0xA97C, [10301] = 0xA97D, [10302] = 0xA97E, [10304] = 0xA980,
  [10305] = 0xA981, [10306] = 0xA982, [10307] = 0xA983, [10308] = 0xA984,
  [10309] = 0xA985, [10310] = 0xA986, [10311] = 0xA987, [10312] = 0xA988,
  [10313] = 0xA989, [10314] = 0xA98A, [10315] = 0xA98B, [10316] = 0xA98C,
  [10317] = 0xA98D, [10318] = 0xA98E, [10319] = 0xA98F, [10320] = 0xA990,
  [10321] = 0xA991, [10322] = 0xA992, [10323] = 0xA993, [10324] = 0xA994,
  [10325] = 0xA995, [10326] = 0xA996, [10327] = 0xA997, [10328] = 0xA998,
  [10329] = 0xA999, [10330] = 0xA99A, [10331] = 0xA99B, [10332] = 0xA99C,
  [10333] = 0xA99D, [10334] = 0xA99E, [10335] = 0xA99F, [10336] = 0xA9A0,
  [10337] = 0xA9A1, [10338] = 0xA9A2, [10339] = 0xA9A3, [10340] = 0xA9A4,
  [10341] = 0xA9A5, [10342] = 0xA9A6, [10343] = 0xA9A7, [10344] = 0xA9A8,
  [10345] = 0xA9A9, [10346] = 0xA9AA, [10347] = 0xA9AB, [10348] = 0xA9AC,
  [10349] = 0xA9AD, [10350] = 0xA9AE, [10351] = 0xA9AF, [10352] = 0xA9B0,
  [10353] = 0xA9B1, [10354] = 0xA9B2, [10355] = 0xA9B3, [10356] = 0xA9B4,
  [10357] = 0xA9B5, [10358] = 0xA9B6, [10359] = 0xA9B7, [10360] = 0xA9B8,
  [10361] = 0xA9B9, [10362] = 0xA9BA, [10363] = 0xA9BB, [10364] = 0xA9BC,
  [10365] = 0xA9BD, [10366] = 0xA9BE, [10367] = 0xA9BF, [10368] = 0xA9C0,
  [10369] = 0xA9C1, [10370] = 0xA9C2, [10371] = 0xA9C3, [10372] = 0xA9C4,
  [10373] = 0xA9C5, [10374] = 0xA9C6, [10375] = 0xA9C7, [10376] = 0xA9C8,
  [10377] = 0xA9C9, [10378] = 0xA9CA, [10379] = 0xA9CB, [10380] = 0xA9CC,
  [10381] = 0xA9CD, [10382] = 0xA9CE, [10383] = 0xA9CF, [10384] = 0xA9D0,
  [10385] = 0xA9D1, [10386] = 0xA9D2, [10387] = 0xA9D3, [10388] = 0xA9D4,
  [10389] = 0xA9D5, [10390] = 0xA9D6, [10391] = 0xA9D7, [10392] = 0xA9D8,
  [10393] = 0xA9D9, [10394] = 0xA9DA, [10395] = 0xA9DB, [10396] = 0xA9DC,
  [10397] = 0xA9DD, [10398] = 0xA9DE, [10399] = 0xA9DF, [10400] = 0xA9E0,
  [10401] = 0xA9E1, [10402] = 0xA9E2, [10403] = 0xA9E3, [10404] = 0xA9E4,
  [10405] = 0xA9E5, [10406] = 0xA9E6, [10407] = 0xA9E7, [10408] = 0xA9E8,
  [10409] = 0xA9E9, [10410] = 0xA9EA, [10411] = 0xA9EB, [10412] = 0xA9EC,
  [10413] = 0xA9ED, [10414] = 0xA9EE, [10415] = 0xA9EF, [10416] = 0xA9F0,
  [10417] = 0xA9F1, [10418] = 0xA9F2, [10419] = 0xA9F3, [10420] = 0xA9F4,
  [10421] = 0xA9F5, [10422] = 0xA9F6, [10423] = 0xA9F7, [10424] = 0xA9F8,
  [10425] = 0xA9F9, [10426] = 0xA9FA, [10427] = 0xA9FB, [10428] = 0xA9FC,
  [10429] = 0xA9FD, [10430] = 0xA9FE, [10496] = 0xAA40, [10497] = 0xAA41,
  [10498] = 0xAA42, [10499] = 0xAA43, [10500] = 0xAA44, [10501] = 0xAA45,
  [10502] = 0xAA46, [10503] = 0xAA47, [10504] = 0xAA48, [10505] = 0xAA49,
  [10506] = 0xAA4A, [10507] = 0xAA4B, [10508] = 0xAA4C, [10509] = 0xAA4D,
  [10510] = 0xAA4E, [10511] = 0xAA4F, [10512] = 0xAA50, [10513] = 0xAA51,
  [10514] = 0xAA52, [10515] = 0xAA53, [10516] = 0xAA54, [10517] = 0xAA55,
  [10518] = 0xAA56, [10519] = 0xAA57, [10520] = 0xAA58, [10521] = 0xAA59,
  [10522] = 0xAA5A, [10523] = 0xAA5B, [10524] = 0xAA5C, [10525] = 0xAA5D,
  [10526] = 0xAA5E, [10527] = 0xAA5F, [10528] = 0xAA60, [10529] = 0xAA61,
  [10530] = 0xAA62, [10531] = 0xAA63, [10532] = 0xAA64, [10533] = 0xAA65,
  [10534] = 0xAA66, [10535] = 0xAA67, [10536] = 0xAA68, [10537] = 0xAA69,
  [10538] = 0xAA6A, [10539] = 0xAA6B, [10540] = 0xAA6C, [10541] = 0xAA6D,
  [10542] = 0xAA6E, [10543] = 0xAA6F, [10544] = 0xAA70, [10545] = 0xAA71,
  [10546] = 0xAA72, [10547] = 0xAA73, [10548] = 0xAA74, [10549] = 0xAA75,
  [10550] = 0xAA76, [10551] = 0xAA77, [10552] = 0xAA78, [10553] = 0xAA79,
  [10554] = 0xAA7A, [10555] = 0xAA7B, [10556] = 0xAA7C, [10557] = 0xAA7D,
  [10558] = 0xAA7E, [10560] = 0xAA80, [10561] = 0xAA81, [10562] = 0xAA82,
  [10563] = 0xAA83, [10564] = 0xAA84, [10565] = 0xAA85, [10566] = 0xAA86,
  [10567] = 0xAA87, [10568] = 0xAA88, [10569] = 0xAA89, [10570] = 0xAA8A,
  [10571] = 0xAA8B, [10572] = 0xAA8C, [10573] = 0xAA8D, [10574] = 0xAA8E,
  [10575] = 0xAA8F, [10576] = 0xAA90, [10577] = 0xAA91, [10578] = 0xAA92,
  [10579] = 0xAA93, [10580] = 0xAA94, [10581] = 0xAA95, [10582] = 0xAA96,
  [10583] = 0xAA97, [10584] = 0xAA98, [10585] = 0xAA99, [10586] = 0xAA9A,
  [10587] = 0xAA9B, [10588] = 0xAA9C, [10589] = 0xAA9D, [10590] = 0xAA9E,
  [10591] = 0xAA9F, [10592] = 0xAAA0, [10593] = 0xAAA1, [10594] = 0xAAA2,
  [10595] = 0xAAA3, [10596] = 0xAAA4, [10597] = 0xAAA5, [10598] = 0xAAA6,
  [10599] = 0xAAA7, [10600] = 0xAAA8, [10601] = 0xAAA9, [10602] = 0xAAAA,
  [10603] = 0xAAAB, [10604] = 0xAAAC, [10605] = 0xAAAD, [10606] = 0xAAAE,
  [10607] = 0xAAAF, [10608] = 0xAAB0, [10609] = 0xAAB1, [10610] = 0xAAB2,
  [10611] = 0xAAB3, [10612] = 0xAAB4, [10613] = 0xAAB5, [10614] = 0xAAB6,
  [10615] = 0xAAB7, [10616] = 0xAAB8, [10617] = 0xAAB9, [10618] = 0xAABA,
  [10619] = 0xAABB, [10620] = 0xAABC, [10621] = 0xAABD, [10622] = 0xAABE,
  [10623] = 0xAABF, [10624] = 0xAAC0, [10625] = 0xAAC1, [10626] = 0xAAC2,
  [10627] = 0xAAC3, [10628] = 0xAAC4, [10629] = 0xAAC5, [10630] = 0xAAC6,
  [10631] = 0xAAC7, [10632] = 0xAAC8, [10633] = 0xAAC9, [10634] = 0xAACA,
  [10635] = 0xAACB, [10636] = 0xAACC, [10637] = 0xAACD, [10638] = 0xAACE,
  [10639] = 0xAACF, [10640] = 0xAAD0, [10641] = 0xAAD1, [10642] = 0xAAD2,
  [10643] = 0xAAD3, [10644] = 0xAAD4, [10645] = 0xAAD5, [10646] = 0xAAD6,
  [10647] = 0xAAD7, [10648] = 0xAAD8, [10649] = 0xAAD9, [10650] = 0xAADA,
  [10651] = 0xAADB, [10652] = 0xAADC, [10653] = 0xAADD, [10654] = 0xAADE,
  [10655] = 0xAADF, [10656] = 0xAAE0, [10657] = 0xAAE1, [10658] = 0xAAE2,
  [10659] = 0xAAE3, [10660] = 0xAAE4, [10661] = 0xAAE5, [10662] = 0xAAE6,
  [10663] = 0xAAE7, [10664] = 0xAAE8, [10665] = 0xAAE9, [10666] = 0xAAEA,
  [10667] = 0xAAEB, [10668] = 0xAAEC, [10669] = 0xAAED, [10670] = 0xAAEE,
  [10671] = 0xAAEF, [10672] = 0xAAF0, [10673] = 0xAAF1, [10674] = 0xAAF2,
  [10675] = 0xAAF3, [10676] = 0xAAF4, [10677] = 0xAAF5, [10678] = 0xAAF6,
  [10679] = 0xAAF7, [10680] = 0xAAF8, [10681] = 0xAAF9, [10682] = 0xAAFA,
  [10683] = 0xAAFB, [10684] = 0xAAFC, [10685] = 0xAAFD, [10686] = 0xAAFE,
  [10752] = 0xAB40, [10753] = 0xAB41, [10754] = 0xAB42, [10755] = 0xAB43,
  [10756] = 0xAB44, [10757] = 0xAB45, [10758] = 0xAB46, [10759] = 0xAB47,
  [10760] = 0xAB48, [10761] = 0xAB49, [10762] = 0xAB4A, [10763] = 0xAB4B,
  [10764] = 0xAB4C, [10765] = 0xAB4D, [10766] = 0xAB4E, [10767] = 0xAB4F,
  [10768] = 0xAB50, [10769] = 0xAB51, [10770] = 0xAB52, [10771] = 0xAB53,
  [10772] = 0xAB54, [10773] = 0xAB55, [10774] = 0xAB56, [10775] = 0xAB57,
  [10776] = 0xAB58, [10777] = 0xAB59, [10778] = 0xAB5A, [10779] = 0xAB5B,
  [10780] = 0xAB5C, [10781] = 0xAB5D, [10782] = 0xAB5E, [10783] = 0xAB5F,
  [10784] = 0xAB60, [10785] = 0xAB61, [10786] = 0xAB62, [10787] = 0xAB63,
  [10788] = 0xAB64, [10789] = 0xAB65, [10790] = 0xAB66, [10791] = 0xAB67,
  [10792] = 0xAB68, [10793] = 0xAB69, [10794] = 0xAB6A, [10795] = 0xAB6B,
  [10796] = 0xAB6C, [10797] = 0xAB6D, [10798] = 0xAB6E, [10799] = 0xAB6F,
  [10800] = 0xAB70, [10801] = 0xAB71, [10802] = 0xAB72, [10803] = 0xAB73,
  [10804] = 0xAB74, [10805] = 0xAB75, [10806] = 0xAB76, [10807] = 0xAB77,
  [10808] = 0xAB78, [10809] = 0xAB79, [10810] = 0xAB7A, [10811] = 0xAB7B,
  [10812] = 0xAB7C, [10813] = 0xAB7D, [10814] = 0xAB7E, [10816] = 0xAB80,
  [10817] = 0xAB81, [10818] = 0xAB82, [10819] = 0xAB83, [10820] = 0xAB84,
  [10821] = 0xAB85, [10822] = 0xAB86, [10823] = 0xAB87, [10824] = 0xAB88,
  [10825] = 0xAB89, [10826] = 0xAB8A, [10827] = 0xAB8B, [10828] = 0xAB8C,
  [10829] = 0xAB8D, [10830] = 0xAB8E, [10831] = 0xAB8F, [10832] = 0xAB90,
  [10833] = 0xAB91, [10834] = 0xAB92, [10835] = 0xAB93, [10836] = 0xAB94,
  [10837] = 0xAB95, [10838] = 0xAB96, [10839] = 0xAB97, [10840] = 0xAB98,
  [10841] = 0xAB99, [10842] = 0xAB9A, [10843] = 0xAB9B, [10844] = 0xAB9C,
  [10845] = 0xAB9D, [10846] = 0xAB9E, [10847] = 0xAB9F, [10848] = 0xABA0,
  [10849] = 0xABA1, [10850] = 0xABA2, [10851] = 0xABA3, [10852] = 0xABA4,
  [10853] = 0xABA5, [10854] = 0xABA6, [10855] = 0xABA7, [10856] = 0xABA8,
  [10857] = 0xABA9, [10858] = 0xABAA, [10859] = 0xABAB, [10860] = 0xABAC,
  [10861] = 0xABAD, [10862] = 0xABAE, [10863] = 0xABAF, [10864] = 0xABB0,
  [10865] = 0xABB1, [10866] = 0xABB2, [10867] = 0xABB3, [10868] = 0xABB4,
  [10869] = 0xABB5, [10870] = 0xABB6, [10871] = 0xABB7, [10872] = 0xABB8,
  [10873] = 0xABB9, [10874] = 0xABBA, [10875] = 0xABBB, [10876] = 0xABBC,
  [10877] = 0xABBD, [10878] = 0xABBE, [10879] = 0xABBF, [10880] = 0xABC0,
  [10881] = 0xABC1, [10882] = 0xABC2, [10883] = 0xABC3, [10884] = 0xABC4,
  [10885] = 0xABC5, [10886] = 0xABC6, [10887] = 0xABC7, [10888] = 0xABC8,
  [10889] = 0xABC9, [10890] = 0xABCA, [10891] = 0xABCB, [10892] = 0xABCC,
  [10893] = 0xABCD, [10894] = 0xABCE, [10895] = 0xABCF, [10896] = 0xABD0,
  [10897] = 0xABD1, [10898] = 0xABD2, [10899] = 0xABD3, [10900] = 0xABD4,
  [10901] = 0xABD5, [10902] = 0xABD6, [10903] = 0xABD7, [10904] = 0xABD8,
  [10905] = 0xABD9, [10906] = 0xABDA, [10907] = 0xABDB, [10908] = 0xABDC,
  [10909] = 0xABDD, [10910] = 0xABDE, [10911] = 0xABDF, [10912] = 0xABE0,
  [10913] = 0xABE1, [10914] = 0xABE2, [10915] = 0xABE3, [10916] = 0xABE4,
  [10917] = 0xABE5, [10918] = 0xABE6, [10919] = 0xABE7, [10920] = 0xABE8,
  [10921] = 0xABE9, [10922] = 0xABEA, [10923] = 0xABEB, [10924] = 0xABEC,
  [10925] = 0xABED, [10926] = 0xABEE, [10927] = 0xABEF, [10928] = 0xABF0,
  [10929] = 0xABF1, [10930] = 0xABF2, [10931] = 0xABF3, [10932] = 0xABF4,
  [10933] = 0xABF5, [10934] = 0xABF6, [10935] = 0xABF7, [10936] = 0xABF8,
  [10937] = 0xABF9, [10938] = 0xABFA, [10939] = 0xABFB, [10940] = 0xABFC,
  [10941] = 0xABFD, [10942] = 0xABFE, [11008] = 0xAC40, [11009] = 0xAC41,
  [11010] = 0xAC42, [11011] = 0xAC43, [11012] = 0xAC44, [11013] = 0xAC45,
  [11014] = 0xAC46, [11015] = 0xAC47, [11016] = 0xAC48, [11017] = 0xAC49,
  [11018] = 0xAC4A, [11019] = 0xAC4B, [11020] = 0xAC4C, [11021] = 0xAC4D,
  [11022] = 0xAC4E, [11023] = 0xAC4F, [11024] = 0xAC50, [11025] = 0xAC51,
  [11026] = 0xAC52, [11027] = 0xAC53, [11028] = 0xAC54, [11029] = 0xAC55,
  [11030] = 0xAC56, [11031] = 0xAC57, [11032] = 0xAC58, [11033] = 0xAC59,
  [11034] = 0xAC5A, [11035] = 0xAC5B, [11036] = 0xAC5C, [11037] = 0xAC5D,
  [11038] = 0xAC5E, [11039] = 0xAC5F, [11040] = 0xAC60, [11041] = 0xAC61,
  [11042] = 0xAC62, [11043] = 0xAC63, [11044] = 0xAC64, [11045] = 0xAC65,
  [11046] = 0xAC66, [11047] = 0xAC67, [11048] = 0xAC68, [11049] = 0xAC69,
  [11050] = 0xAC6A, [11051] = 0xAC6B, [11052] = 0xAC6C, [11053] = 0xAC6D,
  [11054] = 0xAC6E, [11055] = 0xAC6F, [11056] = 0xAC70, [11057] = 0xAC71,
  [11058] = 0xAC72, [11059] = 0xAC73, [11060] = 0xAC74, [11061] = 0xAC75,
  [11062] = 0xAC76, [11063] = 0xAC77, [11064] = 0xAC78, [11065] = 0xAC79,
  [11066] = 0xAC7A, [11067] = 0xAC7B, [11068] = 0xAC7C, [11069] = 0xAC7D,
  [11070] = 0xAC7E, [11072] = 0xAC80, [11073] = 0xAC81, [11074] = 0xAC82,
  [11075] = 0xAC83, [11076] = 0xAC84, [11077] = 0xAC85, [11078] = 0xAC86,
  [11079] = 0xAC87, [11080] = 0xAC88, [11081] = 0xAC89, [11082] = 0xAC8A,
  [11083] = 0xAC8B, [11084] = 0xAC8C, [11085] = 0xAC8D, [11086] = 0xAC8E,
  [11087] = 0xAC8F, [11088] = 0xAC90, [11089] = 0xAC91, [11090] = 0xAC92,
  [11091] = 0xAC93, [11092] = 0xAC94, [11093] = 0xAC95, [11094] = 0xAC96,
  [11095] = 0xAC97, [11096] = 0xAC98, [11097] = 0xAC99, [11098] = 0xAC9A,
  [11099] = 0xAC9B, [11100] = 0xAC9C, [11101] = 0xAC9D, [11102] = 0xAC9E,
  [11103] = 0xAC9F, [11104] = 0xACA0, [11105] = 0xACA1, [11106] = 0xACA2,
  [11107] = 0xACA3, [11108] = 0xACA4, [11109] = 0xACA5, [11110] = 0xACA6,
  [11111] = 0xACA7, [11112] = 0xACA8, [11113] = 0xACA9, [11114] = 0xACAA,
  [11115] = 0xACAB, [11116] = 0xACAC, [11117] = 0xACAD, [11118] = 0xACAE,
  [11119] = 0xACAF, [11120] = 0xACB0, [11121] = 0xACB1, [11122] = 0xACB2,
  [11123] = 0xACB3, [11124] = 0xACB4, [11125] = 0xACB5, [11126] = 0xACB6,
  [11127] = 0xACB7, [11128] = 0xACB8, [11129] = 0xACB9, [11130] = 0xACBA,
  [11131] = 0xACBB, [11132] = 0xACBC, [11133] = 0xACBD, [11134] = 0xACBE,
  [11135] = 0xACBF, [11136] = 0xACC0, [11137] = 0xACC1, [11138] = 0xACC2,
  [11139] = 0xACC3, [11140] = 0xACC4, [11141] = 0xACC5, [11142] = 0xACC6,
  [11143] = 0xACC7, [11144] = 0xACC8, [11145] = 0xACC9, [11146] = 0xACCA,
  [11147] = 0xACCB, [11148] = 0xACCC, [11149] = 0xACCD, [11150] = 0xACCE,
  [11151] = 0xACCF, [11152] = 0xACD0, [11153] = 0xACD1, [11154] = 0xACD2,
  [11155] = 0xACD3, [11156] = 0xACD4, [11157] = 0xACD5, [11158] = 0xACD6,
  [11159] = 0xACD7, [11160] = 0xACD8, [11161] = 0xACD9, [11162] = 0xACDA,
  [11163] = 0xACDB, [11164] = 0xACDC, [11165] = 0xACDD, [11166] = 0xACDE,
  [11167] = 0xACDF, [11168] = 0xACE0, [11169] = 0xACE1, [11170] = 0xACE2,
  [11171] = 0xACE3, [11172] = 0xACE4, [11173] = 0xACE5, [11174] = 0xACE6,
  [11175] = 0xACE7, [11176] = 0xACE8, [11177] = 0xACE9, [11178] = 0xACEA,
  [11179] = 0xACEB, [11180] = 0xACEC, [11181] = 0xACED, [11182] = 0xACEE,
  [11183] = 0xACEF, [11184] = 0xACF0, [11185] = 0xACF1, [11186] = 0xACF2,
  [11187] = 0xACF3, [11188] = 0xACF4, [11189] = 0xACF5, [11190] = 0xACF6,
  [11191] = 0xACF7, [11192] = 0xACF8, [11193] = 0xACF9, [11194] = 0xACFA,
  [11195] = 0xACFB, [11196] = 0xACFC, [11197] = 0xACFD, [11198] = 0xACFE,
  [11264] = 0xAD40, [11265] = 0xAD41, [11266] = 0xAD42, [11267] = 0xAD43,
  [11268] = 0xAD44, [11269] = 0xAD45, [11270] = 0xAD46, [11271] = 0xAD47,
  [11272] = 0xAD48, [11273] = 0xAD49, [11274] = 0xAD4A, [11275] = 0xAD4B,
  [11276] = 0xAD4C, [11277] = 0xAD4D, [11278] = 0xAD4E, [11279] = 0xAD4F,
  [11280] = 0xAD50, [11281] = 0xAD51, [11282] = 0xAD52, [11283] = 0xAD53,
  [11284] = 0xAD54, [11285] = 0xAD55, [11286] = 0xAD56, [11287] = 0xAD57,
  [11288] = 0xAD58, [11289] = 0xAD59, [11290] = 0xAD5A, [11291] = 0xAD5B,
  [11292] = 0xAD5C, [11293] = 0xAD5D, [11294] = 0xAD5E, [11295] = 0xAD5F,
  [11296] = 0xAD60, [11297] = 0xAD61, [11298] = 0xAD62, [11299] = 0xAD63,
  [11300] = 0xAD64, [11301] = 0xAD65, [11302] = 0xAD66, [11303] = 0xAD67,
  [11304] = 0xAD68, [11305] = 0xAD69, [11306] = 0xAD6A, [11307] = 0xAD6B,
  [11308] = 0xAD6C, [11309] = 0xAD6D, [11310] = 0xAD6E, [11311] = 0xAD6F,
  [11312] = 0xAD70, [11313] = 0xAD71, [11314] = 0xAD72, [11315] = 0xAD73,
  [11316] = 0xAD74, [11317] = 0xAD75, [11318] = 0xAD76, [11319] = 0xAD77,
  [11320] = 0xAD78, [11321] = 0xAD79, [11322] = 0xAD7A, [11323] = 0xAD7B,
  [11324] = 0xAD7C, [11325] = 0xAD7D, [11326] = 0xAD7E, [11328] = 0xAD80,
  [11329] = 0xAD81, [11330] = 0xAD82, [11331] = 0xAD83, [11332] = 0xAD84,
  [11333] = 0xAD85, [11334] = 0xAD86, [11335] = 0xAD87, [11336] = 0xAD88,
  [11337] = 0xAD89, [11338] = 0xAD8A, [11339] = 0xAD8B, [11340] = 0xAD8C,
  [11341] = 0xAD8D, [11342] = 0xAD8E, [11343] = 0xAD8F, [11344] = 0xAD90,
  [11345] = 0xAD91, [11346] = 0xAD92, [11347] = 0xAD93, [11348] = 0xAD94,
  [11349] = 0xAD95, [11350] = 0xAD96, [11351] = 0xAD97, [11352] = 0xAD98,
  [11353] = 0xAD99, [11354] = 0xAD9A, [11355] = 0xAD9B, [11356] = 0xAD9C,
  [11357] = 0xAD9D, [11358] = 0xAD9E, [11359] = 0xAD9F, [11360] = 0xADA0,
  [11361] = 0xADA1, [11362] = 0xADA2, [11363] = 0xADA3, [11364] = 0xADA4,
  [11365] = 0xADA5, [11366] = 0xADA6, [11367] = 0xADA7, [11368] = 0xADA8,
  [11369] = 0xADA9, [11370] = 0xADAA, [11371] = 0xADAB, [11372] = 0xADAC,
  [11373] = 0xADAD, [11374] = 0xADAE, [11375] = 0xADAF, [11376] = 0xADB0,
  [11377] = 0xADB1, [11378] = 0xADB2, [11379] = 0xADB3, [11380] = 0xADB4,
  [11381] = 0xADB5, [11382] = 0xADB6, [11383] = 0xADB7, [11384] = 0xADB8,
  [11385] = 0xADB9, [11386] = 0xADBA, [11387] = 0xADBB, [11388] = 0xADBC,
  [11389] = 0xADBD, [11390] = 0xADBE, [11391] = 0xADBF, [11392] = 0xADC0,
  [11393] = 0xADC1, [11394] = 0xADC2, [11395] = 0xADC3, [11396] = 0xADC4,
  [11397] = 0xADC5, [11398] = 0xADC6, [11399] = 0xADC7, [11400] = 0xADC8,
  [11401] = 0xADC9, [11402] = 0xADCA, [11403] = 0xADCB, [11404] = 0xADCC,
  [11405] = 0xADCD, [11406] = 0xADCE, [11407] = 0xADCF, [11408] = 0xADD0,
  [11409] = 0xADD1, [11410] = 0xADD2, [11411] = 0xADD3, [11412] = 0xADD4,
  [11413] = 0xADD5, [11414] = 0xADD6, [11415] = 0xADD7, [11416] = 0xADD8,
  [11417] = 0xADD9, [11418] = 0xADDA, [11419] = 0xADDB, [11420] = 0xADDC,
  [11421] = 0xADDD, [11422] = 0xADDE, [11423] = 0xADDF, [11424] = 0xADE0,
  [11425] = 0xADE1, [11426] = 0xADE2, [11427] = 0xADE3, [11428] = 0xADE4,
  [11429] = 0xADE5, [11430] = 0xADE6, [11431] = 0xADE7, [11432] = 0xADE8,
  [11433] = 0xADE9, [11434] = 0xADEA, [11435] = 0xADEB, [11436] = 0xADEC,
  [11437] = 0xADED, [11438] = 0xADEE, [11439] = 0xADEF, [11440] = 0xADF0,
  [11441] = 0xADF1, [11442] = 0xADF2, [11443] = 0xADF3, [11444] = 0xADF4,
  [11445] = 0xADF5, [11446] = 0xADF6, [11447] = 0xADF7, [11448] = 0xADF8,
  [11449] = 0xADF9, [11450] = 0xADFA, [11451] = 0xADFB, [11452] = 0xADFC,
  [11453] = 0xADFD, [11454] = 0xADFE, [11520] = 0xAE40, [11521] = 0xAE41,
  [11522] = 0xAE42, [11523] = 0xAE43, [11524] = 0xAE44, [11525] = 0xAE45,
  [11526] = 0xAE46, [11527] = 0xAE47, [11528] = 0xAE48, [11529] = 0xAE49,
  [11530] = 0xAE4A, [11531] = 0xAE4B, [11532] = 0xAE4C, [11533] = 0xAE4D,
  [11534] = 0xAE4E, [11535] = 0xAE4F, [11536] = 0xAE50, [11537] = 0xAE51,
  [11538] = 0xAE52, [11539] = 0xAE53, [11540] = 0xAE54, [11541] = 0xAE55,
  [11542] = 0xAE56, [11543] = 0xAE57, [11544] = 0xAE58, [11545] = 0xAE59,
  [11546] = 0xAE5A, [11547] = 0xAE5B, [11548] = 0xAE5C, [11549] = 0xAE5D,
  [11550] = 0xAE5E, [11551] = 0xAE5F, [11552] = 0xAE60, [11553] = 0xAE61,
  [11554] = 0xAE62, [11555] = 0xAE63, [11556] = 0xAE64, [11557] = 0xAE65,
  [11558] = 0xAE66, [11559] = 0xAE67, [11560] = 0xAE68, [11561] = 0xAE69,
  [11562] = 0xAE6A, [11563] = 0xAE6B, [11564] = 0xAE6C, [11565] = 0xAE6D,
  [11566] = 0xAE6E, [11567] = 0xAE6F, [11568] = 0xAE70, [11569] = 0xAE71,
  [11570] = 0xAE72, [11571] = 0xAE73, [11572] = 0xAE74, [11573] = 0xAE75,
  [11574] = 0xAE76, [11575] = 0xAE77, [11576] = 0xAE78, [11577] = 0xAE79,
  [11578] = 0xAE7A, [11579] = 0xAE7B, [11580] = 0xAE7C, [11581] = 0xAE7D,
  [11582] = 0xAE7E, [11584] = 0xAE80, [11585] = 0xAE81, [11586] = 0xAE82,
  [11587] = 0xAE83, [11588] = 0xAE84, [11589] = 0xAE85, [11590] = 0xAE86,
  [11591] = 0xAE87, [11592] = 0xAE88, [11593] = 0xAE89, [11594] = 0xAE8A,
  [11595] = 0xAE8B, [11596] = 0xAE8C, [11597] = 0xAE8D, [11598] = 0xAE8E,
  [11599] = 0xAE8F, [11600] = 0xAE90, [11601] = 0xAE91, [11602] = 0xAE92,
  [11603] = 0xAE93, [11604] = 0xAE94, [11605] = 0xAE95, [11606] = 0xAE96,
  [11607] = 0xAE97, [11608] = 0xAE98, [11609] = 0xAE99, [11610] = 0xAE9A,
  [11611] = 0xAE9B, [11612] = 0xAE9C, [11613] = 0xAE9D, [11614] = 0xAE9E,
  [11615] = 0xAE9F, [11616] = 0xAEA0, [11617] = 0xAEA1, [11618] = 0xAEA2,
  [11619] = 0xAEA3, [11620] = 0xAEA4, [11621] = 0xAEA5, [11622] = 0xAEA6,
  [11623] = 0xAEA7, [11624] = 0xAEA8, [11625] = 0xAEA9, [11626] = 0xAEAA,
  [11627] = 0xAEAB, [11628] = 0xAEAC, [11629] = 0xAEAD, [11630] = 0xAEAE,
  [11631] = 0xAEAF, [11632] = 0xAEB0, [11633] = 0xAEB1, [11634] = 0xAEB2,
  [11635] = 0xAEB3, [11636] = 0xAEB4, [11637] = 0xAEB5, [11638] = 0xAEB6,
  [11639] = 0xAEB7, [11640] = 0xAEB8, [11641] = 0xAEB9, [11642] = 0xAEBA,
  [11643] = 0xAEBB, [11644] = 0xAEBC, [11645] = 0xAEBD, [11646] = 0xAEBE,
  [11647] = 0xAEBF, [11648] = 0xAEC0, [11649] = 0xAEC1, [11650] = 0xAEC2,
  [11651] = 0xAEC3, [11652] = 0xAEC4, [11653] = 0xAEC5, [11654] = 0xAEC6,
  [11655] = 0xAEC7, [11656] = 0xAEC8, [11657] = 0xAEC9, [11658] = 0xAECA,
  [11659] = 0xAECB, [11660] = 0xAECC, [11661] = 0xAECD, [11662] = 0xAECE,
  [11663] = 0xAECF, [11664] = 0xAED0, [11665] = 0xAED1, [11666] = 0xAED2,
  [11667] = 0xAED3, [11668] = 0xAED4, [11669] = 0xAED5, [11670] = 0xAED6,
  [11671] = 0xAED7, [11672] = 0xAED8, [11673] = 0xAED9, [11674] = 0xAEDA,
  [11675] = 0xAEDB, [11676] = 0xAEDC, [11677] = 0xAEDD, [11678] = 0xAEDE,
  [11679] = 0xAEDF, [11680] = 0xAEE0, [11681] = 0xAEE1, [11682] = 0xAEE2,
  [11683] = 0xAEE3, [11684] = 0xAEE4, [11685] = 0xAEE5, [11686] = 0xAEE6,
  [11687] = 0xAEE7, [11688] = 0xAEE8, [11689] = 0xAEE9, [11690] = 0xAEEA,
  [11691] = 0xAEEB, [11692] = 0xAEEC, [11693] = 0xAEED, [11694] = 0xAEEE,
  [11695] = 0xAEEF, [11696] = 0xAEF0, [11697] = 0xAEF1, [11698] = 0xAEF2,
  [11699] = 0xAEF3, [11700] = 0xAEF4, [11701] = 0xAEF5, [11702] = 0xAEF6,
  [11703] = 0xAEF7, [11704] = 0xAEF8, [11705] = 0xAEF9, [11706] = 0xAEFA,
  [11707] = 0xAEFB, [11708] = 0xAEFC, [11709] = 0xAEFD, [11710] = 0xAEFE,
  [11776] = 0xAF40, [11777] = 0xAF41, [11778] = 0xAF42, [11779] = 0xAF43,
  [11780] = 0xAF44, [11781] = 0xAF45, [11782] = 0xAF46, [11783] = 0xAF47,
  [11784] = 0xAF48, [11785] = 0xAF49, [11786] = 0xAF4A, [11787] = 0xAF4B,
  [11788] = 0xAF4C, [11789] = 0xAF4D, [11790] = 0xAF4E, [11791] = 0xAF4F,
  [11792] = 0xAF50, [11793] = 0xAF51, [11794] = 0xAF52, [11795] = 0xAF53,
  [11796] = 0xAF54, [11797] = 0xAF55, [11798] = 0xAF56, [11799] = 0xAF57,
  [11800] = 0xAF58, [11801] = 0xAF59, [11802] = 0xAF5A, [11803] = 0xAF5B,
  [11804] = 0xAF5C, [11805] = 0xAF5D, [11806] = 0xAF5E, [11807] = 0xAF5F,
  [11808] = 0xAF60, [11809] = 0xAF61, [11810] = 0xAF62, [11811] = 0xAF63,
  [11812] = 0xAF64, [11813] = 0xAF65, [11814] = 0xAF66, [11815] = 0xAF67,
  [11816] = 0xAF68, [11817] = 0xAF69, [11818] = 0xAF6A, [11819] = 0xAF6B,
  [11820] = 0xAF6C, [11821] = 0xAF6D, [11822] = 0xAF6E, [11823] = 0xAF6F,
  [11824] = 0xAF70, [11825] = 0xAF71, [11826] = 0xAF72, [11827] = 0xAF73,
  [11828] = 0xAF74, [11829] = 0xAF75, [11830] = 0xAF76, [11831] = 0xAF77,
  [11832] = 0xAF78, [11833] = 0xAF79, [11834] = 0xAF7A, [11835] = 0xAF7B,
  [11836] = 0xAF7C, [11837] = 0xAF7D, [11838] = 0xAF7E, [11840] = 0xAF80,
  [11841] = 0xAF81, [11842] = 0xAF82, [11843] = 0xAF83, [11844] = 0xAF84,
  [11845] = 0xAF85, [11846] = 0xAF86, [11847] = 0xAF87, [11848] = 0xAF88,
  [11849] = 0xAF89, [11850] = 0xAF8A, [11851] = 0xAF8B, [11852] = 0xAF8C,
  [11853] = 0xAF8D, [11854] = 0xAF8E, [11855] = 0xAF8F, [11856] = 0xAF90,
  [11857] = 0xAF91, [11858] = 0xAF92, [11859] = 0xAF93, [11860] = 0xAF94,
  [11861] = 0xAF95, [11862] = 0xAF96, [11863] = 0xAF97, [11864] = 0xAF98,
  [11865] = 0xAF99, [11866] = 0xAF9A, [11867] = 0xAF9B, [11868] = 0xAF9C,
  [11869] = 0xAF9D, [11870] = 0xAF9E, [11871] = 0xAF9F, [11872] = 0xAFA0,
  [11873] = 0xAFA1, [11874] = 0xAFA2, [11875] = 0xAFA3, [11876] = 0xAFA4,
  [11877] = 0xAFA5, [11878] = 0xAFA6, [11879] = 0xAFA7, [11880] = 0xAFA8,
  [11881] = 0xAFA9, [11882] = 0xAFAA, [11883] = 0xAFAB, [11884] = 0xAFAC,
  [11885] = 0xAFAD, [11886] = 0xAFAE, [11887] = 0xAFAF, [11888] = 0xAFB0,
  [11889] = 0xAFB1, [11890] = 0xAFB2, [11891] = 0xAFB3, [11892] = 0xAFB4,
  [11893] = 0xAFB5, [11894] = 0xAFB6, [11895] = 0xAFB7, [11896] = 0xAFB8,
  [11897] = 0xAFB9, [11898] = 0xAFBA, [11899] = 0xAFBB, [11900] = 0xAFBC,
  [11901] = 0xAFBD, [11902] = 0xAFBE, [11903] = 0xAFBF, [11904] = 0xAFC0,
  [11905] = 0xAFC1, [11906] = 0xAFC2, [11907] = 0xAFC3, [11908] = 0xAFC4,
  [11909] = 0xAFC5, [11910] = 0xAFC6, [11911] = 0xAFC7, [11912] = 0xAFC8,
  [11913] = 0xAFC9, [11914] = 0xAFCA, [11915] = 0xAFCB, [11916] = 0xAFCC,
  [11917] = 0xAFCD, [11918] = 0xAFCE, [11919] = 0xAFCF, [11920] = 0xAFD0,
  [11921] = 0xAFD1, [11922] = 0xAFD2, [11923] = 0xAFD3, [11924] = 0xAFD4,
  [11925] = 0xAFD5, [11926] = 0xAFD6, [11927] = 0xAFD7, [11928] = 0xAFD8,
  [11929] = 0xAFD9, [11930] = 0xAFDA, [11931] = 0xAFDB, [11932] = 0xAFDC,
  [11933] = 0xAFDD, [11934] = 0xAFDE, [11935] = 0xAFDF, [11936] = 0xAFE0,
  [11937] = 0xAFE1, [11938] = 0xAFE2, [11939] = 0xAFE3, [11940] = 0xAFE4,
  [11941] = 0xAFE5, [11942] = 0xAFE6, [11943] = 0xAFE7, [11944] = 0xAFE8,
  [11945] = 0xAFE9, [11946] = 0xAFEA, [11947] = 0xAFEB, [11948] = 0xAFEC,
  [11949] = 0xAFED, [11950] = 0xAFEE, [11951] = 0xAFEF, [11952] = 0xAFF0,
  [11953] = 0xAFF1, [11954] = 0xAFF2, [11955] = 0xAFF3, [11956] = 0xAFF4,
  [11957] = 0xAFF5, [11958] = 0xAFF6, [11959] = 0xAFF7, [11960] = 0xAFF8,
  [11961] = 0xAFF9, [11962] = 0xAFFA, [11963] = 0xAFFB, [11964] = 0xAFFC,
  [11965] = 0xAFFD, [11966] = 0xAFFE, [12032] = 0xB040, [12033] = 0xB041,
  [12034] = 0xB042, [12035] = 0xB043, [12036] = 0xB044, [12037] = 0xB045,
  [12038] = 0xB046, [12039] = 0xB047, [12040] = 0xB048, [12041] = 0xB049,
  [12042] = 0xB04A, [12043] = 0xB04B, [12044] = 0xB04C, [12045] = 0xB04D,
  [12046] = 0xB04E, [12047] = 0xB04F, [12048] = 0xB050, [12049] = 0xB051,
  [12050] = 0xB052, [12051] = 0xB053, [12052] = 0xB054, [12053] = 0xB055,
  [12054] = 0xB056, [12055] = 0xB057, [12056] = 0xB058, [12057] = 0xB059,
  [12058] = 0xB05A, [12059] = 0xB05B, [12060] = 0xB05C, [12061] = 0xB05D,
  [12062] = 0xB05E, [12063] = 0xB05F, [12064] = 0xB060, [12065] = 0xB061,
  [12066] = 0xB062, [12067] = 0xB063, [12068] = 0xB064, [12069] = 0xB065,
  [12070] = 0xB066, [12071] = 0xB067, [12072] = 0xB068, [12073] = 0xB069,
  [12074] = 0xB06A, [12075] = 0xB06B, [12076] = 0xB06C, [12077] = 0xB06D,
  [12078] = 0xB06E, [12079] = 0xB06F, [12080] = 0xB070, [12081] = 0xB071,
  [12082] = 0xB072, [12083] = 0xB073, [12084] = 0xB074, [12085] = 0xB075,
  [12086] = 0xB076, [12087] = 0xB077, [12088] = 0xB078, [12089] = 0xB079,
  [12090] = 0xB07A, [12091] = 0xB07B, [12092] = 0xB07C, [12093] = 0xB07D,
  [12094] = 0xB07E, [12096] = 0xB080, [12097] = 0xB081, [12098] = 0xB082,
  [12099] = 0xB083, [12100] = 0xB084, [12101] = 0xB085, [12102] = 0xB086,
  [12103] = 0xB087, [12104] = 0xB088, [12105] = 0xB089, [12106] = 0xB08A,
  [12107] = 0xB08B, [12108] = 0xB08C, [12109] = 0xB08D, [12110] = 0xB08E,
  [12111] = 0xB08F, [12112] = 0xB090, [12113] = 0xB091, [12114] = 0xB092,
  [12115] = 0xB093, [12116] = 0xB094, [12117] = 0xB095, [12118] = 0xB096,
  [12119] = 0xB097, [12120] = 0xB098, [12121] = 0xB099, [12122] = 0xB09A,
  [12123] = 0xB09B, [12124] = 0xB09C, [12125] = 0xB09D, [12126] = 0xB09E,
  [12127] = 0xB09F, [12128] = 0xB0A0, [12129] = 0xB0A1, [12130] = 0xB0A2,
  [12131] = 0xB0A3, [12132] = 0xB0A4, [12133] = 0xB0A5, [12134] = 0xB0A6,
  [12135] = 0xB0A7, [12136] = 0xB0A8, [12137] = 0xB0A9, [12138] = 0xB0AA,
  [12139] = 0xB0AB, [12140] = 0xB0AC, [12141] = 0xB0AD, [12142] = 0xB0AE,
  [12143] = 0xB0AF, [12144] = 0xB0B0, [12145] = 0xB0B1, [12146] = 0xB0B2,
  [12147] = 0xB0B3, [12148] = 0xB0B4, [12149] = 0xB0B5, [12150] = 0xB0B6,
  [12151] = 0xB0B7, [12152] = 0xB0B8, [12153] = 0xB0B9, [12154] = 0xB0BA,
  [12155] = 0xB0BB, [12156] = 0xB0BC, [12157] = 0xB0BD, [12158] = 0xB0BE,
  [12159] = 0xB0BF, [12160] = 0xB0C0, [12161] = 0xB0C1, [12162] = 0xB0C2,
  [12163] = 0xB0C3, [12164] = 0xB0C4, [12165] = 0xB0C5, [12166] = 0xB0C6,
  [12167] = 0xB0C7, [12168] = 0xB0C8, [12169] = 0xB0C9, [12170] = 0xB0CA,
  [12171] = 0xB0CB, [12172] = 0xB0CC, [12173] = 0xB0CD, [12174] = 0xB0CE,
  [12175] = 0xB0CF, [12176] = 0xB0D0, [12177] = 0xB0D1, [12178] = 0xB0D2,
  [12179] = 0xB0D3, [12180] = 0xB0D4, [12181] = 0xB0D5, [12182] = 0xB0D6,
  [12183] = 0xB0D7, [12184] = 0xB0D8, [12185] = 0xB0D9, [12186] = 0xB0DA,
  [12187] = 0xB0DB, [12188] = 0xB0DC, [12189] = 0xB0DD, [12190] = 0xB0DE,
  [12191] = 0xB0DF, [12192] = 0xB0E0, [12193] = 0xB0E1, [12194] = 0xB0E2,
  [12195] = 0xB0E3, [12196] = 0xB0E4, [12197] = 0xB0E5, [12198] = 0xB0E6,
  [12199] = 0xB0E7, [12200] = 0xB0E8, [12201] = 0xB0E9, [12202] = 0xB0EA,
  [12203] = 0xB0EB, [12204] = 0xB0EC, [12205] = 0xB0ED, [12206] = 0xB0EE,
  [12207] = 0xB0EF, [12208] = 0xB0F0, [12209] = 0xB0F1, [12210] = 0xB0F2,
  [12211] = 0xB0F3, [12212] = 0xB0F4, [12213] = 0xB0F5, [12214] = 0xB0F6,
  [12215] = 0xB0F7, [12216] = 0xB0F8, [12217] = 0xB0F9, [12218] = 0xB0FA,
  [12219] = 0xB0FB, [12220] = 0xB0FC, [12221] = 0xB0FD, [12222] = 0xB0FE,
  [12288] = 0xB140, [12289] = 0xB141, [12290] = 0xB142, [12291] = 0xB143,
  [12292] = 0xB144, [12293] = 0xB145, [12294] = 0xB146, [12295] = 0xB147,
  [12296] = 0xB148, [12297] = 0xB149, [12298] = 0xB14A, [12299] = 0xB14B,
  [12300] = 0xB14C, [12301] = 0xB14D, [12302] = 0xB14E, [12303] = 0xB14F,
  [12304] = 0xB150, [12305] = 0xB151, [12306] = 0xB152, [12307] = 0xB153,
  [12308] = 0xB154, [12309] = 0xB155, [12310] = 0xB156, [12311] = 0xB157,
  [12312] = 0xB158, [12313] = 0xB159, [12314] = 0xB15A, [12315] = 0xB15B,
  [12316] = 0xB15C, [12317] = 0xB15D, [12318] = 0xB15E, [12319] = 0xB15F,
  [12320] = 0xB160, [12321] = 0xB161, [12322] = 0xB162, [12323] = 0xB163,
  [12324] = 0xB164, [12325] = 0xB165, [12326] = 0xB166, [12327] = 0xB167,
  [12328] = 0xB168, [12329] = 0xB169, [12330] = 0xB16A, [12331] = 0xB16B,
  [12332] = 0xB16C, [12333] = 0xB16D, [12334] = 0xB16E, [12335] = 0xB16F,
  [12336] = 0xB170, [12337] = 0xB171, [12338] = 0xB172, [12339] = 0xB173,
  [12340] = 0xB174, [12341] = 0xB175, [12342] = 0xB176, [12343] = 0xB177,
  [12344] = 0xB178, [12345] = 0xB179, [12346] = 0xB17A, [12347] = 0xB17B,
  [12348] = 0xB17C, [12349] = 0xB17D, [12350] = 0xB17E, [12352] = 0xB180,
  [12353] = 0xB181, [12354] = 0xB182, [12355] = 0xB183, [12356] = 0xB184,
  [12357] = 0xB185, [12358] = 0xB186, [12359] = 0xB187, [12360] = 0xB188,
  [12361] = 0xB189, [12362] = 0xB18A, [12363] = 0xB18B, [12364] = 0xB18C,
  [12365] = 0xB18D, [12366] = 0xB18E, [12367] = 0xB18F, [12368] = 0xB190,
  [12369] = 0xB191, [12370] = 0xB192, [12371] = 0xB193, [12372] = 0xB194,
  [12373] = 0xB195, [12374] = 0xB196, [12375] = 0xB197, [12376] = 0xB198,
  [12377] = 0xB199, [12378] = 0xB19A, [12379] = 0xB19B, [12380] = 0xB19C,
  [12381] = 0xB19D, [12382] = 0xB19E, [12383] = 0xB19F, [12384] = 0xB1A0,
  [12385] = 0xB1A1, [12386] = 0xB1A2, [12387] = 0xB1A3, [12388] = 0xB1A4,
  [12389] = 0xB1A5, [12390] = 0xB1A6, [12391] = 0xB1A7, [12392] = 0xB1A8,
  [12393] = 0xB1A9, [12394] = 0xB1AA, [12395] = 0xB1AB, [12396] = 0xB1AC,
  [12397] = 0xB1AD, [12398] = 0xB1AE, [12399] = 0xB1AF, [12400] = 0xB1B0,
  [12401] = 0xB1B1, [12402] = 0xB1B2, [12403] = 0xB1B3, [12404] = 0xB1B4,
  [12405] = 0xB1B5, [12406] = 0xB1B6, [12407] = 0xB1B7, [12408] = 0xB1B8,
  [12409] = 0xB1B9, [12410] = 0xB1BA, [12411] = 0xB1BB, [12412] = 0xB1BC,
  [12413] = 0xB1BD, [12414] = 0xB1BE, [12415] = 0xB1BF, [12416] = 0xB1C0,
  [12417] = 0xB1C1, [12418] = 0xB1C2, [12419] = 0xB1C3, [12420] = 0xB1C4,
  [12421] = 0xB1C5, [12422] = 0xB1C6, [12423] = 0xB1C7, [12424] = 0xB1C8,
  [12425] = 0xB1C9, [12426] = 0xB1CA, [12427] = 0xB1CB, [12428] = 0xB1CC,
  [12429] = 0xB1CD, [12430] = 0xB1CE, [12431] = 0xB1CF, [12432] = 0xB1D0,
  [12433] = 0xB1D1, [12434] = 0xB1D2, [12435] = 0xB1D3, [12436] = 0xB1D4,
  [12437] = 0xB1D5, [12438] = 0xB1D6, [12439] = 0xB1D7, [12440] = 0xB1D8,
  [12441] = 0xB1D9, [12442] = 0xB1DA, [12443] = 0xB1DB, [12444] = 0xB1DC,
  [12445] = 0xB1DD, [12446] = 0xB1DE, [12447] = 0xB1DF, [12448] = 0xB1E0,
  [12449] = 0xB1E1, [12450] = 0xB1E2, [12451] = 0xB1E3, [12452] = 0xB1E4,
  [12453] = 0xB1E5, [12454] = 0xB1E6, [12455] = 0xB1E7, [12456] = 0xB1E8,
  [12457] = 0xB1E9, [12458] = 0xB1EA, [12459] = 0xB1EB, [12460] = 0xB1EC,
  [12461] = 0xB1ED, [12462] = 0xB1EE, [12463] = 0xB1EF, [12464] = 0xB1F0,
  [12465] = 0xB1F1, [12466] = 0xB1F2, [12467] = 0xB1F3, [12468] = 0xB1F4,
  [12469] = 0xB1F5, [12470] = 0xB1F6, [12471] = 0xB1F7, [12472] = 0xB1F8,
  [12473] = 0xB1F9, [12474] = 0xB1FA, [12475] = 0xB1FB, [12476] = 0xB1FC,
  [12477] = 0xB1FD, [12478] = 0xB1FE, [12544] = 0xB240, [12545] = 0xB241,
  [12546] = 0xB242, [12547] = 0xB243, [12548] = 0xB244, [12549] = 0xB245,
  [12550] = 0xB246, [12551] = 0xB247, [12552] = 0xB248, [12553] = 0xB249,
  [12554] = 0xB24A, [12555] = 0xB24B, [12556] = 0xB24C, [12557] = 0xB24D,
  [12558] = 0xB24E, [12559] = 0xB24F, [12560] = 0xB250, [12561] = 0xB251,
  [12562] = 0xB252, [12563] = 0xB253, [12564] = 0xB254, [12565] = 0xB255,
  [12566] = 0xB256, [12567] = 0xB257, [12568] = 0xB258, [12569] = 0xB259,
  [12570] = 0xB25A, [12571] = 0xB25B, [12572] = 0xB25C, [12573] = 0xB25D,
  [12574] = 0xB25E, [12575] = 0xB25F, [12576] = 0xB260, [12577] = 0xB261,
  [12578] = 0xB262, [12579] = 0xB263, [12580] = 0xB264, [12581] = 0xB265,
  [12582] = 0xB266, [12583] = 0xB267, [12584] = 0xB268, [12585] = 0xB269,
  [12586] = 0xB26A, [12587] = 0xB26B, [12588] = 0xB26C, [12589] = 0xB26D,
  [12590] = 0xB26E, [12591] = 0xB26F, [12592] = 0xB270, [12593] = 0xB271,
  [12594] = 0xB272, [12595] = 0xB273, [12596] = 0xB274, [12597] = 0xB275,
  [12598] = 0xB276, [12599] = 0xB277, [12600] = 0xB278, [12601] = 0xB279,
  [12602] = 0xB27A, [12603] = 0xB27B, [12604] = 0xB27C, [12605] = 0xB27D,
  [12606] = 0xB27E, [12608] = 0xB280, [12609] = 0xB281, [12610] = 0xB282,
  [12611] = 0xB283, [12612] = 0xB284, [12613] = 0xB285, [12614] = 0xB286,
  [12615] = 0xB287, [12616] = 0xB288, [12617] = 0xB289, [12618] = 0xB28A,
  [12619] = 0xB28B, [12620] = 0xB28C, [12621] = 0xB28D, [12622] = 0xB28E,
  [12623] = 0xB28F, [12624] = 0xB290, [12625] = 0xB291, [12626] = 0xB292,
  [12627] = 0xB293, [12628] = 0xB294, [12629] = 0xB295, [12630] = 0xB296,
  [12631] = 0xB297, [12632] = 0xB298, [12633] = 0xB299, [12634] = 0xB29A,
  [12635] = 0xB29B, [12636] = 0xB29C, [12637] = 0xB29D, [12638] = 0xB29E,
  [12639] = 0xB29F, [12640] = 0xB2A0, [12641] = 0xB2A1, [12642] = 0xB2A2,
  [12643] = 0xB2A3, [12644] = 0xB2A4, [12645] = 0xB2A5, [12646] = 0xB2A6,
  [12647] = 0xB2A7, [12648] = 0xB2A8, [12649] = 0xB2A9, [12650] = 0xB2AA,
  [12651] = 0xB2AB, [12652] = 0xB2AC, [12653] = 0xB2AD, [12654] = 0xB2AE,
  [12655] = 0xB2AF, [12656] = 0xB2B0, [12657] = 0xB2B1, [12658] = 0xB2B2,
  [12659] = 0xB2B3, [12660] = 0xB2B4, [12661] = 0xB2B5, [12662] = 0xB2B6,
  [12663] = 0xB2B7, [12664] = 0xB2B8, [12665] = 0xB2B9, [12666] = 0xB2BA,
  [12667] = 0xB2BB, [12668] = 0xB2BC, [12669] = 0xB2BD, [12670] = 0xB2BE,
  [12671] = 0xB2BF, [12672] = 0xB2C0, [12673] = 0xB2C1, [12674] = 0xB2C2,
  [12675] = 0xB2C3, [12676] = 0xB2C4, [12677] = 0xB2C5, [12678] = 0xB2C6,
  [12679] = 0xB2C7, [12680] = 0xB2C8, [12681] = 0xB2C9, [12682] = 0xB2CA,
  [12683] = 0xB2CB, [12684] = 0xB2CC, [12685] = 0xB2CD, [12686] = 0xB2CE,
  [12687] = 0xB2CF, [12688] = 0xB2D0, [12689] = 0xB2D1, [12690] = 0xB2D2,
  [12691] = 0xB2D3, [12692] = 0xB2D4, [12693] = 0xB2D5, [12694] = 0xB2D6,
  [12695] = 0xB2D7, [12696] = 0xB2D8, [12697] = 0xB2D9, [12698] = 0xB2DA,
  [12699] = 0xB2DB, [12700] = 0xB2DC, [12701] = 0xB2DD, [12702] = 0xB2DE,
  [12703] = 0xB2DF, [12704] = 0xB2E0, [12705] = 0xB2E1, [12706] = 0xB2E2,
  [12707] = 0xB2E3, [12708] = 0xB2E4, [12709] = 0xB2E5, [12710] = 0xB2E6,
  [12711] = 0xB2E7, [12712] = 0xB2E8, [12713] = 0xB2E9, [12714] = 0xB2EA,
  [12715] = 0xB2EB, [12716] = 0xB2EC, [12717] = 0xB2ED, [12718] = 0xB2EE,
  [12719] = 0xB2EF, [12720] = 0xB2F0, [12721] = 0xB2F1, [12722] = 0xB2F2,
  [12723] = 0xB2F3, [12724] = 0xB2F4, [12725] = 0xB2F5, [12726] = 0xB2F6,
  [12727] = 0xB2F7, [12728] = 0xB2F8, [12729] = 0xB2F9, [12730] = 0xB2FA,
  [12731] = 0xB2FB, [12732] = 0xB2FC, [12733] = 0xB2FD, [12734] = 0xB2FE,
  [12800] = 0xB340, [12801] = 0xB341, [12802] = 0xB342, [12803] = 0xB343,
  [12804] = 0xB344, [12805] = 0xB345, [12806] = 0xB346, [12807] = 0xB347,
  [12808] = 0xB348, [12809] = 0xB349, [12810] = 0xB34A, [12811] = 0xB34B,
  [12812] = 0xB34C, [12813] = 0xB34D, [12814] = 0xB34E, [12815] = 0xB34F,
  [12816] = 0xB350, [12817] = 0xB351, [12818] = 0xB352, [12819] = 0xB353,
  [12820] = 0xB354, [12821] = 0xB355, [12822] = 0xB356, [12823] = 0xB357,
  [12824] = 0xB358, [12825] = 0xB359, [12826] = 0xB35A, [12827] = 0xB35B,
  [12828] = 0xB35C, [12829] = 0xB35D, [12830] = 0xB35E, [12831] = 0xB35F,
  [12832] = 0xB360, [12833] = 0xB361, [12834] = 0xB362, [12835] = 0xB363,
  [12836] = 0xB364, [12837] = 0xB365, [12838] = 0xB366, [12839] = 0xB367,
  [12840] = 0xB368, [12841] = 0xB369, [12842] = 0xB36A, [12843] = 0xB36B,
  [12844] = 0xB36C, [12845] = 0xB36D, [12846] = 0xB36E, [12847] = 0xB36F,
  [12848] = 0xB370, [12849] = 0xB371, [12850] = 0xB372, [12851] = 0xB373,
  [12852] = 0xB374, [12853] = 0xB375, [12854] = 0xB376, [12855] = 0xB377,
  [12856] = 0xB378, [12857] = 0xB379, [12858] = 0xB37A, [12859] = 0xB37B,
  [12860] = 0xB37C, [12861] = 0xB37D, [12862] = 0xB37E, [12864] = 0xB380,
  [12865] = 0xB381, [12866] = 0xB382, [12867] = 0xB383, [12868] = 0xB384,
  [12869] = 0xB385, [12870] = 0xB386, [12871] = 0xB387, [12872] = 0xB388,
  [12873] = 0xB389, [12874] = 0xB38A, [12875] = 0xB38B, [12876] = 0xB38C,
  [12877] = 0xB38D, [12878] = 0xB38E, [12879] = 0xB38F, [12880] = 0xB390,
  [12881] = 0xB391, [12882] = 0xB392, [12883] = 0xB393, [12884] = 0xB394,
  [12885] = 0xB395, [12886] = 0xB396, [12887] = 0xB397, [12888] = 0xB398,
  [12889] = 0xB399, [12890] = 0xB39A, [12891] = 0xB39B, [12892] = 0xB39C,
  [12893] = 0xB39D, [12894] = 0xB39E, [12895] = 0xB39F, [12896] = 0xB3A0,
  [12897] = 0xB3A1, [12898] = 0xB3A2, [12899] = 0xB3A3, [12900] = 0xB3A4,
  [12901] = 0xB3A5, [12902] = 0xB3A6, [12903] = 0xB3A7, [12904] = 0xB3A8,
  [12905] = 0xB3A9, [12906] = 0xB3AA, [12907] = 0xB3AB, [12908] = 0xB3AC,
  [12909] = 0xB3AD, [12910] = 0xB3AE, [12911] = 0xB3AF, [12912] = 0xB3B0,
  [12913] = 0xB3B1, [12914] = 0xB3B2, [12915] = 0xB3B3, [12916] = 0xB3B4,
  [12917] = 0xB3B5, [12918] = 0xB3B6, [12919] = 0xB3B7, [12920] = 0xB3B8,
  [12921] = 0xB3B9, [12922] = 0xB3BA, [12923] = 0xB3BB, [12924] = 0xB3BC,
  [12925] = 0xB3BD, [12926] = 0xB3BE, [12927] = 0xB3BF, [12928] = 0xB3C0,
  [12929] = 0xB3C1, [12930] = 0xB3C2, [12931] = 0xB3C3, [12932] = 0xB3C4,
  [12933] = 0xB3C5, [12934] = 0xB3C6, [12935] = 0xB3C7, [12936] = 0xB3C8,
  [12937] = 0xB3C9, [12938] = 0xB3CA, [12939] = 0xB3CB, [12940] = 0xB3CC,
  [12941] = 0xB3CD, [12942] = 0xB3CE, [12943] = 0xB3CF, [12944] = 0xB3D0,
  [12945] = 0xB3D1, [12946] = 0xB3D2, [12947] = 0xB3D3, [12948] = 0xB3D4,
  [12949] = 0xB3D5, [12950] = 0xB3D6, [12951] = 0xB3D7, [12952] = 0xB3D8,
  [12953] = 0xB3D9, [12954] = 0xB3DA, [12955] = 0xB3DB, [12956] = 0xB3DC,
  [12957] = 0xB3DD, [12958] = 0xB3DE, [12959] = 0xB3DF, [12960] = 0xB3E0,
  [12961] = 0xB3E1, [12962] = 0xB3E2, [12963] = 0xB3E3, [12964] = 0xB3E4,
  [12965] = 0xB3E5, [12966] = 0xB3E6, [12967] = 0xB3E7, [12968] = 0xB3E8,
  [12969] = 0xB3E9, [12970] = 0xB3EA, [12971] = 0xB3EB, [12972] = 0xB3EC,
  [12973] = 0xB3ED, [12974] = 0xB3EE, [12975] = 0xB3EF, [12976] = 0xB3F0,
  [12977] = 0xB3F1, [12978] = 0xB3F2, [12979] = 0xB3F3, [12980] = 0xB3F4,
  [12981] = 0xB3F5, [12982] = 0xB3F6, [12983] = 0xB3F7, [12984] = 0xB3F8,
  [12985] = 0xB3F9, [12986] = 0xB3FA, [12987] = 0xB3FB, [12988] = 0xB3FC,
  [12989] = 0xB3FD, [12990] = 0xB3FE, [13056] = 0xB440, [13057] = 0xB441,
  [13058] = 0xB442, [13059] = 0xB443, [13060] = 0xB444, [13061] = 0xB445,
  [13062] = 0xB446, [13063] = 0xB447, [13064] = 0xB448, [13065] = 0xB449,
  [13066] = 0xB44A, [13067] = 0xB44B, [13068] = 0xB44C, [13069] = 0xB44D,
  [13070] = 0xB44E, [13071] = 0xB44F, [13072] = 0xB450, [13073] = 0xB451,
  [13074] = 0xB452, [13075] = 0xB453, [13076] = 0xB454, [13077] = 0xB455,
  [13078] = 0xB456, [13079] = 0xB457, [13080] = 0xB458, [13081] = 0xB459,
  [13082] = 0xB45A, [13083] = 0xB45B, [13084] = 0xB45C, [13085] = 0xB45D,
  [13086] = 0xB45E, [13087] = 0xB45F, [13088] = 0xB460, [13089] = 0xB461,
  [13090] = 0xB462, [13091] = 0xB463, [13092] = 0xB464, [13093] = 0xB465,
  [13094] = 0xB466, [13095] = 0xB467, [13096] = 0xB468, [13097] = 0xB469,
  [13098] = 0xB46A, [13099] = 0xB46B, [13100] = 0xB46C, [13101] = 0xB46D,
  [13102] = 0xB46E, [13103] = 0xB46F, [13104] = 0xB470, [13105] = 0xB471,
  [13106] = 0xB472, [13107] = 0xB473, [13108] = 0xB474, [13109] = 0xB475,
  [13110] = 0xB476, [13111] = 0xB477, [13112] = 0xB478, [13113] = 0xB479,
  [13114] = 0xB47A, [13115] = 0xB47B, [13116] = 0xB47C, [13117] = 0xB47D,
  [13118] = 0xB47E, [13120] = 0xB480, [13121] = 0xB481, [13122] = 0xB482,
  [13123] = 0xB483, [13124] = 0xB484, [13125] = 0xB485, [13126] = 0xB486,
  [13127] = 0xB487, [13128] = 0xB488, [13129] = 0xB489, [13130] = 0xB48A,
  [13131] = 0xB48B, [13132] = 0xB48C, [13133] = 0xB48D, [13134] = 0xB48E,
  [13135] = 0xB48F, [13136] = 0xB490, [13137] = 0xB491, [13138] = 0xB492,
  [13139] = 0xB493, [13140] = 0xB494, [13141] = 0xB495, [13142] = 0xB496,
  [13143] = 0xB497, [13144] = 0xB498, [13145] = 0xB499, [13146] = 0xB49A,
  [13147] = 0xB49B, [13148] = 0xB49C, [13149] = 0xB49D, [13150] = 0xB49E,
  [13151] = 0xB49F, [13152] = 0xB4A0, [13153] = 0xB4A1, [13154] = 0xB4A2,
  [13155] = 0xB4A3, [13156] = 0xB4A4, [13157] = 0xB4A5, [13158] = 0xB4A6,
  [13159] = 0xB4A7, [13160] = 0xB4A8, [13161] = 0xB4A9, [13162] = 0xB4AA,
  [13163] = 0xB4AB, [13164] = 0xB4AC, [13165] = 0xB4AD, [13166] = 0xB4AE,
  [13167] = 0xB4AF, [13168] = 0xB4B0, [13169] = 0xB4B1, [13170] = 0xB4B2,
  [13171] = 0xB4B3, [13172] = 0xB4B4, [13173] = 0xB4B5, [13174] = 0xB4B6,
  [13175] = 0xB4B7, [13176] = 0xB4B8, [13177] = 0xB4B9, [13178] = 0xB4BA,
  [13179] = 0xB4BB, [13180] = 0xB4BC, [13181] = 0xB4BD, [13182] = 0xB4BE,
  [13183] = 0xB4BF, [13184] = 0xB4C0, [13185] = 0xB4C1, [13186] = 0xB4C2,
  [13187] = 0xB4C3, [13188] = 0xB4C4, [13189] = 0xB4C5, [13190] = 0xB4C6,
  [13191] = 0xB4C7, [13192] = 0xB4C8, [13193] = 0xB4C9, [13194] = 0xB4CA,
  [13195] = 0xB4CB, [13196] = 0xB4CC, [13197] = 0xB4CD, [13198] = 0xB4CE,
  [13199] = 0xB4CF, [13200] = 0xB4D0, [13201] = 0xB4D1, [13202] = 0xB4D2,
  [13203] = 0xB4D3, [13204] = 0xB4D4, [13205] = 0xB4D5, [13206] = 0xB4D6,
  [13207] = 0xB4D7, [13208] = 0xB4D8, [13209] = 0xB4D9, [13210] = 0xB4DA,
  [13211] = 0xB4DB, [13212] = 0xB4DC, [13213] = 0xB4DD, [13214] = 0xB4DE,
  [13215] = 0xB4DF, [13216] = 0xB4E0, [13217] = 0xB4E1, [13218] = 0xB4E2,
  [13219] = 0xB4E3, [13220] = 0xB4E4, [13221] = 0xB4E5, [13222] = 0xB4E6,
  [13223] = 0xB4E7, [13224] = 0xB4E8, [13225] = 0xB4E9, [13226] = 0xB4EA,
  [13227] = 0xB4EB, [13228] = 0xB4EC, [13229] = 0xB4ED, [13230] = 0xB4EE,
  [13231] = 0xB4EF, [13232] = 0xB4F0, [13233] = 0xB4F1, [13234] = 0xB4F2,
  [13235] = 0xB4F3, [13236] = 0xB4F4, [13237] = 0xB4F5, [13238] = 0xB4F6,
  [13239] = 0xB4F7, [13240] = 0xB4F8, [13241] = 0xB4F9, [13242] = 0xB4FA,
  [13243] = 0xB4FB, [13244] = 0xB4FC, [13245] = 0xB4FD, [13246] = 0xB4FE,
  [13312] = 0xB540, [13313] = 0xB541, [13314] = 0xB542, [13315] = 0xB543,
  [13316] = 0xB544, [13317] = 0xB545, [13318] = 0xB546, [13319] = 0xB547,
  [13320] = 0xB548, [13321] = 0xB549, [13322] = 0xB54A, [13323] = 0xB54B,
  [13324] = 0xB54C, [13325] = 0xB54D, [13326] = 0xB54E, [13327] = 0xB54F,
  [13328] = 0xB550, [13329] = 0xB551, [13330] = 0xB552, [13331] = 0xB553,
  [13332] = 0xB554, [13333] = 0xB555, [13334] = 0xB556, [13335] = 0xB557,
  [13336] = 0xB558, [13337] = 0xB559, [13338] = 0xB55A, [13339] = 0xB55B,
  [13340] = 0xB55C, [13341] = 0xB55D, [13342] = 0xB55E, [13343] = 0xB55F,
  [13344] = 0xB560, [13345] = 0xB561, [13346] = 0xB562, [13347] = 0xB563,
  [13348] = 0xB564, [13349] = 0xB565, [13350] = 0xB566, [13351] = 0xB567,
  [13352] = 0xB568, [13353] = 0xB569, [13354] = 0xB56A, [13355] = 0xB56B,
  [13356] = 0xB56C, [13357] = 0xB56D, [13358] = 0xB56E, [13359] = 0xB56F,
  [13360] = 0xB570, [13361] = 0xB571, [13362] = 0xB572, [13363] = 0xB573,
  [13364] = 0xB574, [13365] = 0xB575, [13366] = 0xB576, [13367] = 0xB577,
  [13368] = 0xB578, [13369] = 0xB579, [13370] = 0xB57A, [13371] = 0xB57B,
  [13372] = 0xB57C, [13373] = 0xB57D, [13374] = 0xB57E, [13376] = 0xB580,
  [13377] = 0xB581, [13378] = 0xB582, [13379] = 0xB583, [13380] = 0xB584,
  [13381] = 0xB585, [13382] = 0xB586, [13383] = 0xB587, [13384] = 0xB588,
  [13385] = 0xB589, [13386] = 0xB58A, [13387] = 0xB58B, [13388] = 0xB58C,
  [13389] = 0xB58D, [13390] = 0xB58E, [13391] = 0xB58F, [13392] = 0xB590,
  [13393] = 0xB591, [13394] = 0xB592, [13395] = 0xB593, [13396] = 0xB594,
  [13397] = 0xB595, [13398] = 0xB596, [13399] = 0xB597, [13400] = 0xB598,
  [13401] = 0xB599, [13402] = 0xB59A, [13403] = 0xB59B, [13404] = 0xB59C,
  [13405] = 0xB59D, [13406] = 0xB59E, [13407] = 0xB59F, [13408] = 0xB5A0,
  [13409] = 0xB5A1, [13410] = 0xB5A2, [13411] = 0xB5A3, [13412] = 0xB5A4,
  [13413] = 0xB5A5, [13414] = 0xB5A6, [13415] = 0xB5A7, [13416] = 0xB5A8,
  [13417] = 0xB5A9, [13418] = 0xB5AA, [13419] = 0xB5AB, [13420] = 0xB5AC,
  [13421] = 0xB5AD, [13422] = 0xB5AE, [13423] = 0xB5AF, [13424] = 0xB5B0,
  [13425] = 0xB5B1, [13426] = 0xB5B2, [13427] = 0xB5B3, [13428] = 0xB5B4,
  [13429] = 0xB5B5, [13430] = 0xB5B6, [13431] = 0xB5B7, [13432] = 0xB5B8,
  [13433] = 0xB5B9, [13434] = 0xB5BA, [13435] = 0xB5BB, [13436] = 0xB5BC,
  [13437] = 0xB5BD, [13438] = 0xB5BE, [13439] = 0xB5BF, [13440] = 0xB5C0,
  [13441] = 0xB5C1, [13442] = 0xB5C2, [13443] = 0xB5C3, [13444] = 0xB5C4,
  [13445] = 0xB5C5, [13446] = 0xB5C6, [13447] = 0xB5C7, [13448] = 0xB5C8,
  [13449] = 0xB5C9, [13450] = 0xB5CA, [13451] = 0xB5CB, [13452] = 0xB5CC,
  [13453] = 0xB5CD, [13454] = 0xB5CE, [13455] = 0xB5CF, [13456] = 0xB5D0,
  [13457] = 0xB5D1, [13458] = 0xB5D2, [13459] = 0xB5D3, [13460] = 0xB5D4,
  [13461] = 0xB5D5, [13462] = 0xB5D6, [13463] = 0xB5D7, [13464] = 0xB5D8,
  [13465] = 0xB5D9, [13466] = 0xB5DA, [13467] = 0xB5DB, [13468] = 0xB5DC,
  [13469] = 0xB5DD, [13470] = 0xB5DE, [13471] = 0xB5DF, [13472] = 0xB5E0,
  [13473] = 0xB5E1, [13474] = 0xB5E2, [13475] = 0xB5E3, [13476] = 0xB5E4,
  [13477] = 0xB5E5, [13478] = 0xB5E6, [13479] = 0xB5E7, [13480] = 0xB5E8,
  [13481] = 0xB5E9, [13482] = 0xB5EA, [13483] = 0xB5EB, [13484] = 0xB5EC,
  [13485] = 0xB5ED, [13486] = 0xB5EE, [13487] = 0xB5EF, [13488] = 0xB5F0,
  [13489] = 0xB5F1, [13490] = 0xB5F2, [13491] = 0xB5F3, [13492] = 0xB5F4,
  [13493] = 0xB5F5, [13494] = 0xB5F6, [13495] = 0xB5F7, [13496] = 0xB5F8,
  [13497] = 0xB5F9, [13498] = 0xB5FA, [13499] = 0xB5FB, [13500] = 0xB5FC,
  [13501] = 0xB5FD, [13502] = 0xB5FE, [13568] = 0xB640, [13569] = 0xB641,
  [13570] = 0xB642, [13571] = 0xB643, [13572] = 0xB644, [13573] = 0xB645,
  [13574] = 0xB646, [13575] = 0xB647, [13576] = 0xB648, [13577] = 0xB649,
  [13578] = 0xB64A, [13579] = 0xB64B, [13580] = 0xB64C, [13581] = 0xB64D,
  [13582] = 0xB64E, [13583] = 0xB64F, [13584] = 0xB650, [13585] = 0xB651,
  [13586] = 0xB652, [13587] = 0xB653, [13588] = 0xB654, [13589] = 0xB655,
  [13590] = 0xB656, [13591] = 0xB657, [13592] = 0xB658, [13593] = 0xB659,
  [13594] = 0xB65A, [13595] = 0xB65B, [13596] = 0xB65C, [13597] = 0xB65D,
  [13598] = 0xB65E, [13599] = 0xB65F, [13600] = 0xB660, [13601] = 0xB661,
  [13602] = 0xB662, [13603] = 0xB663, [13604] = 0xB664, [13605] = 0xB665,
  [13606] = 0xB666, [13607] = 0xB667, [13608] = 0xB668, [13609] = 0xB669,
  [13610] = 0xB66A, [13611] = 0xB66B, [13612] = 0xB66C, [13613] = 0xB66D,
  [13614] = 0xB66E, [13615] = 0xB66F, [13616] = 0xB670, [13617] = 0xB671,
  [13618] = 0xB672, [13619] = 0xB673, [13620] = 0xB674, [13621] = 0xB675,
  [13622] = 0xB676, [13623] = 0xB677, [13624] = 0xB678, [13625] = 0xB679,
  [13626] = 0xB67A, [13627] = 0xB67B, [13628] = 0xB67C, [13629] = 0xB67D,
  [13630] = 0xB67E, [13632] = 0xB680, [13633] = 0xB681, [13634] = 0xB682,
  [13635] = 0xB683, [13636] = 0xB684, [13637] = 0xB685, [13638] = 0xB686,
  [13639] = 0xB687, [13640] = 0xB688, [13641] = 0xB689, [13642] = 0xB68A,
  [13643] = 0xB68B, [13644] = 0xB68C, [13645] = 0xB68D, [13646] = 0xB68E,
  [13647] = 0xB68F, [13648] = 0xB690, [13649] = 0xB691, [13650] = 0xB692,
  [13651] = 0xB693, [13652] = 0xB694, [13653] = 0xB695, [13654] = 0xB696,
  [13655] = 0xB697, [13656] = 0xB698, [13657] = 0xB699, [13658] = 0xB69A,
  [13659] = 0xB69B, [13660] = 0xB69C, [13661] = 0xB69D, [13662] = 0xB69E,
  [13663] = 0xB69F, [13664] = 0xB6A0, [13665] = 0xB6A1, [13666] = 0xB6A2,
  [13667] = 0xB6A3, [13668] = 0xB6A4, [13669] = 0xB6A5, [13670] = 0xB6A6,
  [13671] = 0xB6A7, [13672] = 0xB6A8, [13673] = 0xB6A9, [13674] = 0xB6AA,
  [13675] = 0xB6AB, [13676] = 0xB6AC, [13677] = 0xB6AD, [13678] = 0xB6AE,
  [13679] = 0xB6AF, [13680] = 0xB6B0, [13681] = 0xB6B1, [13682] = 0xB6B2,
  [13683] = 0xB6B3, [13684] = 0xB6B4, [13685] = 0xB6B5, [13686] = 0xB6B6,
  [13687] = 0xB6B7, [13688] = 0xB6B8, [13689] = 0xB6B9, [13690] = 0xB6BA,
  [13691] = 0xB6BB, [13692] = 0xB6BC, [13693] = 0xB6BD, [13694] = 0xB6BE,
  [13695] = 0xB6BF, [13696] = 0xB6C0, [13697] = 0xB6C1, [13698] = 0xB6C2,
  [13699] = 0xB6C3, [13700] = 0xB6C4, [13701] = 0xB6C5, [13702] = 0xB6C6,
  [13703] = 0xB6C7, [13704] = 0xB6C8, [13705] = 0xB6C9, [13706] = 0xB6CA,
  [13707] = 0xB6CB, [13708] = 0xB6CC, [13709] = 0xB6CD, [13710] = 0xB6CE,
  [13711] = 0xB6CF, [13712] = 0xB6D0, [13713] = 0xB6D1, [13714] = 0xB6D2,
  [13715] = 0xB6D3, [13716] = 0xB6D4, [13717] = 0xB6D5, [13718] = 0xB6D6,
  [13719] = 0xB6D7, [13720] = 0xB6D8, [13721] = 0xB6D9, [13722] = 0xB6DA,
  [13723] = 0xB6DB, [13724] = 0xB6DC, [13725] = 0xB6DD, [13726] = 0xB6DE,
  [13727] = 0xB6DF, [13728] = 0xB6E0, [13729] = 0xB6E1, [13730] = 0xB6E2,
  [13731] = 0xB6E3, [13732] = 0xB6E4, [13733] = 0xB6E5, [13734] = 0xB6E6,
  [13735] = 0xB6E7, [13736] = 0xB6E8, [13737] = 0xB6E9, [13738] = 0xB6EA,
  [13739] = 0xB6EB, [13740] = 0xB6EC, [13741] = 0xB6ED, [13742] = 0xB6EE,
  [13743] = 0xB6EF, [13744] = 0xB6F0, [13745] = 0xB6F1, [13746] = 0xB6F2,
  [13747] = 0xB6F3, [13748] = 0xB6F4, [13749] = 0xB6F5, [13750] = 0xB6F6,
  [13751] = 0xB6F7, [13752] = 0xB6F8, [13753] = 0xB6F9, [13754] = 0xB6FA,
  [13755] = 0xB6FB, [13756] = 0xB6FC, [13757] = 0xB6FD, [13758] = 0xB6FE,
  [13824] = 0xB740, [13825] = 0xB741, [13826] = 0xB742, [13827] = 0xB743,
  [13828] = 0xB744, [13829] = 0xB745, [13830] = 0xB746, [13831] = 0xB747,
  [13832] = 0xB748, [13833] = 0xB749, [13834] = 0xB74A, [13835] = 0xB74B,
  [13836] = 0xB74C, [13837] = 0xB74D, [13838] = 0xB74E, [13839] = 0xB74F,
  [13840] = 0xB750, [13841] = 0xB751, [13842] = 0xB752, [13843] = 0xB753,
  [13844] = 0xB754, [13845] = 0xB755, [13846] = 0xB756, [13847] = 0xB757,
  [13848] = 0xB758, [13849] = 0xB759, [13850] = 0xB75A, [13851] = 0xB75B,
  [13852] = 0xB75C, [13853] = 0xB75D, [13854] = 0xB75E, [13855] = 0xB75F,
  [13856] = 0xB760, [13857] = 0xB761, [13858] = 0xB762, [13859] = 0xB763,
  [13860] = 0xB764, [13861] = 0xB765, [13862] = 0xB766, [13863] = 0xB767,
  [13864] = 0xB768, [13865] = 0xB769, [13866] = 0xB76A, [13867] = 0xB76B,
  [13868] = 0xB76C, [13869] = 0xB76D, [13870] = 0xB76E, [13871] = 0xB76F,
  [13872] = 0xB770, [13873] = 0xB771, [13874] = 0xB772, [13875] = 0xB773,
  [13876] = 0xB774, [13877] = 0xB775, [13878] = 0xB776, [13879] = 0xB777,
  [13880] = 0xB778, [13881] = 0xB779, [13882] = 0xB77A, [13883] = 0xB77B,
  [13884] = 0xB77C, [13885] = 0xB77D, [13886] = 0xB77E, [13888] = 0xB780,
  [13889] = 0xB781, [13890] = 0xB782, [13891] = 0xB783, [13892] = 0xB784,
  [13893] = 0xB785, [13894] = 0xB786, [13895] = 0xB787, [13896] = 0xB788,
  [13897] = 0xB789, [13898] = 0xB78A, [13899] = 0xB78B, [13900] = 0xB78C,
  [13901] = 0xB78D, [13902] = 0xB78E, [13903] = 0xB78F, [13904] = 0xB790,
  [13905] = 0xB791, [13906] = 0xB792, [13907] = 0xB793, [13908] = 0xB794,
  [13909] = 0xB795, [13910] = 0xB796, [13911] = 0xB797, [13912] = 0xB798,
  [13913] = 0xB799, [13914] = 0xB79A, [13915] = 0xB79B, [13916] = 0xB79C,
  [13917] = 0xB79D, [13918] = 0xB79E, [13919] = 0xB79F, [13920] = 0xB7A0,
  [13921] = 0xB7A1, [13922] = 0xB7A2, [13923] = 0xB7A3, [13924] = 0xB7A4,
  [13925] = 0xB7A5, [13926] = 0xB7A6, [13927] = 0xB7A7, [13928] = 0xB7A8,
  [13929] = 0xB7A9, [13930] = 0xB7AA, [13931] = 0xB7AB, [13932] = 0xB7AC,
  [13933] = 0xB7AD, [13934] = 0xB7AE, [13935] = 0xB7AF, [13936] = 0xB7B0,
  [13937] = 0xB7B1, [13938] = 0xB7B2, [13939] = 0xB7B3, [13940] = 0xB7B4,
  [13941] = 0xB7B5, [13942] = 0xB7B6, [13943] = 0xB7B7, [13944] = 0xB7B8,
  [13945] = 0xB7B9, [13946] = 0xB7BA, [13947] = 0xB7BB, [13948] = 0xB7BC,
  [13949] = 0xB7BD, [13950] = 0xB7BE, [13951] = 0xB7BF, [13952] = 0xB7C0,
  [13953] = 0xB7C1, [13954] = 0xB7C2, [13955] = 0xB7C3, [13956] = 0xB7C4,
  [13957] = 0xB7C5, [13958] = 0xB7C6, [13959] = 0xB7C7, [13960] = 0xB7C8,
  [13961] = 0xB7C9, [13962] = 0xB7CA, [13963] = 0xB7CB, [13964] = 0xB7CC,
  [13965] = 0xB7CD, [13966] = 0xB7CE, [13967] = 0xB7CF, [13968] = 0xB7D0,
  [13969] = 0xB7D1, [13970] = 0xB7D2, [13971] = 0xB7D3, [13972] = 0xB7D4,
  [13973] = 0xB7D5, [13974] = 0xB7D6, [13975] = 0xB7D7, [13976] = 0xB7D8,
  [13977] = 0xB7D9, [13978] = 0xB7DA, [13979] = 0xB7DB, [13980] = 0xB7DC,
  [13981] = 0xB7DD, [13982] = 0xB7DE, [13983] = 0xB7DF, [13984] = 0xB7E0,
  [13985] = 0xB7E1, [13986] = 0xB7E2, [13987] = 0xB7E3, [13988] = 0xB7E4,
  [13989] = 0xB7E5, [13990] = 0xB7E6, [13991] = 0xB7E7, [13992] = 0xB7E8,
  [13993] = 0xB7E9, [13994] = 0xB7EA, [13995] = 0xB7EB, [13996] = 0xB7EC,
  [13997] = 0xB7ED, [13998] = 0xB7EE, [13999] = 0xB7EF, [14000] = 0xB7F0,
  [14001] = 0xB7F1, [14002] = 0xB7F2, [14003] = 0xB7F3, [14004] = 0xB7F4,
  [14005] = 0xB7F5, [14006] = 0xB7F6, [14007] = 0xB7F7, [14008] = 0xB7F8,
  [14009] = 0xB7F9, [14010] = 0xB7FA, [14011] = 0xB7FB, [14012] = 0xB7FC,
  [14013] = 0xB7FD, [14014] = 0xB7FE, [14080] = 0xB840, [14081] = 0xB841,
  [14082] = 0xB842, [14083] = 0xB843, [14084] = 0xB844, [14085] = 0xB845,
  [14086] = 0xB846, [14087] = 0xB847, [14088] = 0xB848, [14089] = 0xB849,
  [14090] = 0xB84A, [14091] = 0xB84B, [14092] = 0xB84C, [14093] = 0xB84D,
  [14094] = 0xB84E, [14095] = 0xB84F, [14096] = 0xB850, [14097] = 0xB851,
  [14098] = 0xB852, [14099] = 0xB853, [14100] = 0xB854, [14101] = 0xB855,
  [14102] = 0xB856, [14103] = 0xB857, [14104] = 0xB858, [14105] = 0xB859,
  [14106] = 0xB85A, [14107] = 0xB85B, [14108] = 0xB85C, [14109] = 0xB85D,
  [14110] = 0xB85E, [14111] = 0xB85F, [14112] = 0xB860, [14113] = 0xB861,
  [14114] = 0xB862, [14115] = 0xB863, [14116] = 0xB864, [14117] = 0xB865,
  [14118] = 0xB866, [14119] = 0xB867, [14120] = 0xB868, [14121] = 0xB869,
  [14122] = 0xB86A, [14123] = 0xB86B, [14124] = 0xB86C, [14125] = 0xB86D,
  [14126] = 0xB86E, [14127] = 0xB86F, [14128] = 0xB870, [14129] = 0xB871,
  [14130] = 0xB872, [14131] = 0xB873, [14132] = 0xB874, [14133] = 0xB875,
  [14134] = 0xB876, [14135] = 0xB877, [14136] = 0xB878, [14137] = 0xB879,
  [14138] = 0xB87A, [14139] = 0xB87B, [14140] = 0xB87C, [14141] = 0xB87D,
  [14142] = 0xB87E, [14144] = 0xB880, [14145] = 0xB881, [14146] = 0xB882,
  [14147] = 0xB883, [14148] = 0xB884, [14149] = 0xB885, [14150] = 0xB886,
  [14151] = 0xB887, [14152] = 0xB888, [14153] = 0xB889, [14154] = 0xB88A,
  [14155] = 0xB88B, [14156] = 0xB88C, [14157] = 0xB88D, [14158] = 0xB88E,
  [14159] = 0xB88F, [14160] = 0xB890, [14161] = 0xB891, [14162] = 0xB892,
  [14163] = 0xB893, [14164] = 0xB894, [14165] = 0xB895, [14166] = 0xB896,
  [14167] = 0xB897, [14168] = 0xB898, [14169] = 0xB899, [14170] = 0xB89A,
  [14171] = 0xB89B, [14172] = 0xB89C, [14173] = 0xB89D, [14174] = 0xB89E,
  [14175] = 0xB89F, [14176] = 0xB8A0, [14177] = 0xB8A1, [14178] = 0xB8A2,
  [14179] = 0xB8A3, [14180] = 0xB8A4, [14181] = 0xB8A5, [14182] = 0xB8A6,
  [14183] = 0xB8A7, [14184] = 0xB8A8, [14185] = 0xB8A9, [14186] = 0xB8AA,
  [14187] = 0xB8AB, [14188] = 0xB8AC, [14189] = 0xB8AD, [14190] = 0xB8AE,
  [14191] = 0xB8AF, [14192] = 0xB8B0, [14193] = 0xB8B1, [14194] = 0xB8B2,
  [14195] = 0xB8B3, [14196] = 0xB8B4, [14197] = 0xB8B5, [14198] = 0xB8B6,
  [14199] = 0xB8B7, [14200] = 0xB8B8, [14201] = 0xB8B9, [14202] = 0xB8BA,
  [14203] = 0xB8BB, [14204] = 0xB8BC, [14205] = 0xB8BD, [14206] = 0xB8BE,
  [14207] = 0xB8BF, [14208] = 0xB8C0, [14209] = 0xB8C1, [14210] = 0xB8C2,
  [14211] = 0xB8C3, [14212] = 0xB8C4, [14213] = 0xB8C5, [14214] = 0xB8C6,
  [14215] = 0xB8C7, [14216] = 0xB8C8, [14217] = 0xB8C9, [14218] = 0xB8CA,
  [14219] = 0xB8CB, [14220] = 0xB8CC, [14221] = 0xB8CD, [14222] = 0xB8CE,
  [14223] = 0xB8CF, [14224] = 0xB8D0, [14225] = 0xB8D1, [14226] = 0xB8D2,
  [14227] = 0xB8D3, [14228] = 0xB8D4, [14229] = 0xB8D5, [14230] = 0xB8D6,
  [14231] = 0xB8D7, [14232] = 0xB8D8, [14233] = 0xB8D9, [14234] = 0xB8DA,
  [14235] = 0xB8DB, [14236] = 0xB8DC, [14237] = 0xB8DD, [14238] = 0xB8DE,
  [14239] = 0xB8DF, [14240] = 0xB8E0, [14241] = 0xB8E1, [14242] = 0xB8E2,
  [14243] = 0xB8E3, [14244] = 0xB8E4, [14245] = 0xB8E5, [14246] = 0xB8E6,
  [14247] = 0xB8E7, [14248] = 0xB8E8, [14249] = 0xB8E9, [14250] = 0xB8EA,
  [14251] = 0xB8EB, [14252] = 0xB8EC, [14253] = 0xB8ED, [14254] = 0xB8EE,
  [14255] = 0xB8EF, [14256] = 0xB8F0, [14257] = 0xB8F1, [14258] = 0xB8F2,
  [14259] = 0xB8F3, [14260] = 0xB8F4, [14261] = 0xB8F5, [14262] = 0xB8F6,
  [14263] = 0xB8F7, [14264] = 0xB8F8, [14265] = 0xB8F9, [14266] = 0xB8FA,
  [14267] = 0xB8FB, [14268] = 0xB8FC, [14269] = 0xB8FD, [14270] = 0xB8FE,
  [14336] = 0xB940, [14337] = 0xB941, [14338] = 0xB942, [14339] = 0xB943,
  [14340] = 0xB944, [14341] = 0xB945, [14342] = 0xB946, [14343] = 0xB947,
  [14344] = 0xB948, [14345] = 0xB949, [14346] = 0xB94A, [14347] = 0xB94B,
  [14348] = 0xB94C, [14349] = 0xB94D, [14350] = 0xB94E, [14351] = 0xB94F,
  [14352] = 0xB950, [14353] = 0xB951, [14354] = 0xB952, [14355] = 0xB953,
  [14356] = 0xB954, [14357] = 0xB955, [14358] = 0xB956, [14359] = 0xB957,
  [14360] = 0xB958, [14361] = 0xB959, [14362] = 0xB95A, [14363] = 0xB95B,
  [14364] = 0xB95C, [14365] = 0xB95D, [14366] = 0xB95E, [14367] = 0xB95F,
  [14368] = 0xB960, [14369] = 0xB961, [14370] = 0xB962, [14371] = 0xB963,
  [14372] = 0xB964, [14373] = 0xB965, [14374] = 0xB966, [14375] = 0xB967,
  [14376] = 0xB968, [14377] = 0xB969, [14378] = 0xB96A, [14379] = 0xB96B,
  [14380] = 0xB96C, [14381] = 0xB96D, [14382] = 0xB96E, [14383] = 0xB96F,
  [14384] = 0xB970, [14385] = 0xB971, [14386] = 0xB972, [14387] = 0xB973,
  [14388] = 0xB974, [14389] = 0xB975, [14390] = 0xB976, [14391] = 0xB977,
  [14392] = 0xB978, [14393] = 0xB979, [14394] = 0xB97A, [14395] = 0xB97B,
  [14396] = 0xB97C, [14397] = 0xB97D, [14398] = 0xB97E, [14400] = 0xB980,
  [14401] = 0xB981, [14402] = 0xB982, [14403] = 0xB983, [14404] = 0xB984,
  [14405] = 0xB985, [14406] = 0xB986, [14407] = 0xB987, [14408] = 0xB988,
  [14409] = 0xB989, [14410] = 0xB98A, [14411] = 0xB98B, [14412] = 0xB98C,
  [14413] = 0xB98D, [14414] = 0xB98E, [14415] = 0xB98F, [14416] = 0xB990,
  [14417] = 0xB991, [14418] = 0xB992, [14419] = 0xB993, [14420] = 0xB994,
  [14421] = 0xB995, [14422] = 0xB996, [14423] = 0xB997, [14424] = 0xB998,
  [14425] = 0xB999, [14426] = 0xB99A, [14427] = 0xB99B, [14428] = 0xB99C,
  [14429] = 0xB99D, [14430] = 0xB99E, [14431] = 0xB99F, [14432] = 0xB9A0,
  [14433] = 0xB9A1, [14434] = 0xB9A2, [14435] = 0xB9A3, [14436] = 0xB9A4,
  [14437] = 0xB9A5, [14438] = 0xB9A6, [14439] = 0xB9A7, [14440] = 0xB9A8,
  [14441] = 0xB9A9, [14442] = 0xB9AA, [14443] = 0xB9AB, [14444] = 0xB9AC,
  [14445] = 0xB9AD, [14446] = 0xB9AE, [14447] = 0xB9AF, [14448] = 0xB9B0,
  [14449] = 0xB9B1, [14450] = 0xB9B2, [14451] = 0xB9B3, [14452] = 0xB9B4,
  [14453] = 0xB9B5, [14454] = 0xB9B6, [14455] = 0xB9B7, [14456] = 0xB9B8,
  [14457] = 0xB9B9, [14458] = 0xB9BA, [14459] = 0xB9BB, [14460] = 0xB9BC,
  [14461] = 0xB9BD, [14462] = 0xB9BE, [14463] = 0xB9BF, [14464] = 0xB9C0,
  [14465] = 0xB9C1, [14466] = 0xB9C2, [14467] = 0xB9C3, [14468] = 0xB9C4,
  [14469] = 0xB9C5, [14470] = 0xB9C6, [14471] = 0xB9C7, [14472] = 0xB9C8,
  [14473] = 0xB9C9, [14474] = 0xB9CA, [14475] = 0xB9CB, [14476] = 0xB9CC,
  [14477] = 0xB9CD, [14478] = 0xB9CE, [14479] = 0xB9CF, [14480] = 0xB9D0,
  [14481] = 0xB9D1, [14482] = 0xB9D2, [14483] = 0xB9D3, [14484] = 0xB9D4,
  [14485] = 0xB9D5, [14486] = 0xB9D6, [14487] = 0xB9D7, [14488] = 0xB9D8,
  [14489] = 0xB9D9, [14490] = 0xB9DA, [14491] = 0xB9DB, [14492] = 0xB9DC,
  [14493] = 0xB9DD, [14494] = 0xB9DE, [14495] = 0xB9DF, [14496] = 0xB9E0,
  [14497] = 0xB9E1, [14498] = 0xB9E2, [14499] = 0xB9E3, [14500] = 0xB9E4,
  [14501] = 0xB9E5, [14502] = 0xB9E6, [14503] = 0xB9E7, [14504] = 0xB9E8,
  [14505] = 0xB9E9, [14506] = 0xB9EA, [14507] = 0xB9EB, [14508] = 0xB9EC,
  [14509] = 0xB9ED, [14510] = 0xB9EE, [14511] = 0xB9EF, [14512] = 0xB9F0,
  [14513] = 0xB9F1, [14514] = 0xB9F2, [14515] = 0xB9F3, [14516] = 0xB9F4,
  [14517] = 0xB9F5, [14518] = 0xB9F6, [14519] = 0xB9F7, [14520] = 0xB9F8,
  [14521] = 0xB9F9, [14522] = 0xB9FA, [14523] = 0xB9FB, [14524] = 0xB9FC,
  [14525] = 0xB9FD, [14526] = 0xB9FE, [14592] = 0xBA40, [14593] = 0xBA41,
  [14594] = 0xBA42, [14595] = 0xBA43, [14596] = 0xBA44, [14597] = 0xBA45,
  [14598] = 0xBA46, [14599] = 0xBA47, [14600] = 0xBA48, [14601] = 0xBA49,
  [14602] = 0xBA4A, [14603] = 0xBA4B, [14604] = 0xBA4C, [14605] = 0xBA4D,
  [14606] = 0xBA4E, [14607] = 0xBA4F, [14608] = 0xBA50, [14609] = 0xBA51,
  [14610] = 0xBA52, [14611] = 0xBA53, [14612] = 0xBA54, [14613] = 0xBA55,
  [14614] = 0xBA56, [14615] = 0xBA57, [14616] = 0xBA58, [14617] = 0xBA59,
  [14618] = 0xBA5A, [14619] = 0xBA5B, [14620] = 0xBA5C, [14621] = 0xBA5D,
  [14622] = 0xBA5E, [14623] = 0xBA5F, [14624] = 0xBA60, [14625] = 0xBA61,
  [14626] = 0xBA62, [14627] = 0xBA63, [14628] = 0xBA64, [14629] = 0xBA65,
  [14630] = 0xBA66, [14631] = 0xBA67, [14632] = 0xBA68, [14633] = 0xBA69,
  [14634] = 0xBA6A, [14635] = 0xBA6B, [14636] = 0xBA6C, [14637] = 0xBA6D,
  [14638] = 0xBA6E, [14639] = 0xBA6F, [14640] = 0xBA70, [14641] = 0xBA71,
  [14642] = 0xBA72, [14643] = 0xBA73, [14644] = 0xBA74, [14645] = 0xBA75,
  [14646] = 0xBA76, [14647] = 0xBA77, [14648] = 0xBA78, [14649] = 0xBA79,
  [14650] = 0xBA7A, [14651] = 0xBA7B, [14652] = 0xBA7C, [14653] = 0xBA7D,
  [14654] = 0xBA7E, [14656] = 0xBA80, [14657] = 0xBA81, [14658] = 0xBA82,
  [14659] = 0xBA83, [14660] = 0xBA84, [14661] = 0xBA85, [14662] = 0xBA86,
  [14663] = 0xBA87, [14664] = 0xBA88, [14665] = 0xBA89, [14666] = 0xBA8A,
  [14667] = 0xBA8B, [14668] = 0xBA8C, [14669] = 0xBA8D, [14670] = 0xBA8E,
  [14671] = 0xBA8F, [14672] = 0xBA90, [14673] = 0xBA91, [14674] = 0xBA92,
  [14675] = 0xBA93, [14676] = 0xBA94, [14677] = 0xBA95, [14678] = 0xBA96,
  [14679] = 0xBA97, [14680] = 0xBA98, [14681] = 0xBA99, [14682] = 0xBA9A,
  [14683] = 0xBA9B, [14684] = 0xBA9C, [14685] = 0xBA9D, [14686] = 0xBA9E,
  [14687] = 0xBA9F, [14688] = 0xBAA0, [14689] = 0xBAA1, [14690] = 0xBAA2,
  [14691] = 0xBAA3, [14692] = 0xBAA4, [14693] = 0xBAA5, [14694] = 0xBAA6,
  [14695] = 0xBAA7, [14696] = 0xBAA8, [14697] = 0xBAA9, [14698] = 0xBAAA,
  [14699] = 0xBAAB, [14700] = 0xBAAC, [14701] = 0xBAAD, [14702] = 0xBAAE,
  [14703] = 0xBAAF, [14704] = 0xBAB0, [14705] = 0xBAB1, [14706] = 0xBAB2,
  [14707] = 0xBAB3, [14708] = 0xBAB4, [14709] = 0xBAB5, [14710] = 0xBAB6,
  [14711] = 0xBAB7, [14712] = 0xBAB8, [14713] = 0xBAB9, [14714] = 0xBABA,
  [14715] = 0xBABB, [14716] = 0xBABC, [14717] = 0xBABD, [14718] = 0xBABE,
  [14719] = 0xBABF, [14720] = 0xBAC0, [14721] = 0xBAC1, [14722] = 0xBAC2,
  [14723] = 0xBAC3, [14724] = 0xBAC4, [14725] = 0xBAC5, [14726] = 0xBAC6,
  [14727] = 0xBAC7, [14728] = 0xBAC8, [14729] = 0xBAC9, [14730] = 0xBACA,
  [14731] = 0xBACB, [14732] = 0xBACC, [14733] = 0xBACD, [14734] = 0xBACE,
  [14735] = 0xBACF, [14736] = 0xBAD0, [14737] = 0xBAD1, [14738] = 0xBAD2,
  [14739] = 0xBAD3, [14740] = 0xBAD4, [14741] = 0xBAD5, [14742] = 0xBAD6,
  [14743] = 0xBAD7, [14744] = 0xBAD8, [14745] = 0xBAD9, [14746] = 0xBADA,
  [14747] = 0xBADB, [14748] = 0xBADC, [14749] = 0xBADD, [14750] = 0xBADE,
  [14751] = 0xBADF, [14752] = 0xBAE0, [14753] = 0xBAE1, [14754] = 0xBAE2,
  [14755] = 0xBAE3, [14756] = 0xBAE4, [14757] = 0xBAE5, [14758] = 0xBAE6,
  [14759] = 0xBAE7, [14760] = 0xBAE8, [14761] = 0xBAE9, [14762] = 0xBAEA,
  [14763] = 0xBAEB, [14764] = 0xBAEC, [14765] = 0xBAED, [14766] = 0xBAEE,
  [14767] = 0xBAEF, [14768] = 0xBAF0, [14769] = 0xBAF1, [14770] = 0xBAF2,
  [14771] = 0xBAF3, [14772] = 0xBAF4, [14773] = 0xBAF5, [14774] = 0xBAF6,
  [14775] = 0xBAF7, [14776] = 0xBAF8, [14777] = 0xBAF9, [14778] = 0xBAFA,
  [14779] = 0xBAFB, [14780] = 0xBAFC, [14781] = 0xBAFD, [14782] = 0xBAFE,
  [14848] = 0xBB40, [14849] = 0xBB41, [14850] = 0xBB42, [14851] = 0xBB43,
  [14852] = 0xBB44, [14853] = 0xBB45, [14854] = 0xBB46, [14855] = 0xBB47,
  [14856] = 0xBB48, [14857] = 0xBB49, [14858] = 0xBB4A, [14859] = 0xBB4B,
  [14860] = 0xBB4C, [14861] = 0xBB4D, [14862] = 0xBB4E, [14863] = 0xBB4F,
  [14864] = 0xBB50, [14865] = 0xBB51, [14866] = 0xBB52, [14867] = 0xBB53,
  [14868] = 0xBB54, [14869] = 0xBB55, [14870] = 0xBB56, [14871] = 0xBB57,
  [14872] = 0xBB58, [14873] = 0xBB59, [14874] = 0xBB5A, [14875] = 0xBB5B,
  [14876] = 0xBB5C, [14877] = 0xBB5D, [14878] = 0xBB5E, [14879] = 0xBB5F,
  [14880] = 0xBB60, [14881] = 0xBB61, [14882] = 0xBB62, [14883] = 0xBB63,
  [14884] = 0xBB64, [14885] = 0xBB65, [14886] = 0xBB66, [14887] = 0xBB67,
  [14888] = 0xBB68, [14889] = 0xBB69, [14890] = 0xBB6A, [14891] = 0xBB6B,
  [14892] = 0xBB6C, [14893] = 0xBB6D, [14894] = 0xBB6E, [14895] = 0xBB6F,
  [14896] = 0xBB70, [14897] = 0xBB71, [14898] = 0xBB72, [14899] = 0xBB73,
  [14900] = 0xBB74, [14901] = 0xBB75, [14902] = 0xBB76, [14903] = 0xBB77,
  [14904] = 0xBB78, [14905] = 0xBB79, [14906] = 0xBB7A, [14907] = 0xBB7B,
  [14908] = 0xBB7C, [14909] = 0xBB7D, [14910] = 0xBB7E, [14912] = 0xBB80,
  [14913] = 0xBB81, [14914] = 0xBB82, [14915] = 0xBB83, [14916] = 0xBB84,
  [14917] = 0xBB85, [14918] = 0xBB86, [14919] = 0xBB87, [14920] = 0xBB88,
  [14921] = 0xBB89, [14922] = 0xBB8A, [14923] = 0xBB8B, [14924] = 0xBB8C,
  [14925] = 0xBB8D, [14926] = 0xBB8E, [14927] = 0xBB8F, [14928] = 0xBB90,
  [14929] = 0xBB91, [14930] = 0xBB92, [14931] = 0xBB93, [14932] = 0xBB94,
  [14933] = 0xBB95, [14934] = 0xBB96, [14935] = 0xBB97, [14936] = 0xBB98,
  [14937] = 0xBB99, [14938] = 0xBB9A, [14939] = 0xBB9B, [14940] = 0xBB9C,
  [14941] = 0xBB9D, [14942] = 0xBB9E, [14943] = 0xBB9F, [14944] = 0xBBA0,
  [14945] = 0xBBA1, [14946] = 0xBBA2, [14947] = 0xBBA3, [14948] = 0xBBA4,
  [14949] = 0xBBA5, [14950] = 0xBBA6, [14951] = 0xBBA7, [14952] = 0xBBA8,
  [14953] = 0xBBA9, [14954] = 0xBBAA, [14955] = 0xBBAB, [14956] = 0xBBAC,
  [14957] = 0xBBAD, [14958] = 0xBBAE, [14959] = 0xBBAF, [14960] = 0xBBB0,
  [14961] = 0xBBB1, [14962] = 0xBBB2, [14963] = 0xBBB3, [14964] = 0xBBB4,
  [14965] = 0xBBB5, [14966] = 0xBBB6, [14967] = 0xBBB7, [14968] = 0xBBB8,
  [14969] = 0xBBB9, [14970] = 0xBBBA, [14971] = 0xBBBB, [14972] = 0xBBBC,
  [14973] = 0xBBBD, [14974] = 0xBBBE, [14975] = 0xBBBF, [14976] = 0xBBC0,
  [14977] = 0xBBC1, [14978] = 0xBBC2, [14979] = 0xBBC3, [14980] = 0xBBC4,
  [14981] = 0xBBC5, [14982] = 0xBBC6, [14983] = 0xBBC7, [14984] = 0xBBC8,
  [14985] = 0xBBC9, [14986] = 0xBBCA, [14987] = 0xBBCB, [14988] = 0xBBCC,
  [14989] = 0xBBCD, [14990] = 0xBBCE, [14991] = 0xBBCF, [14992] = 0xBBD0,
  [14993] = 0xBBD1, [14994] = 0xBBD2, [14995] = 0xBBD3, [14996] = 0xBBD4,
  [14997] = 0xBBD5, [14998] = 0xBBD6, [14999] = 0xBBD7, [15000] = 0xBBD8,
  [15001] = 0xBBD9, [15002] = 0xBBDA, [15003] = 0xBBDB, [15004] = 0xBBDC,
  [15005] = 0xBBDD, [15006] = 0xBBDE, [15007] = 0xBBDF, [15008] = 0xBBE0,
  [15009] = 0xBBE1, [15010] = 0xBBE2, [15011] = 0xBBE3, [15012] = 0xBBE4,
  [15013] = 0xBBE5, [15014] = 0xBBE6, [15015] = 0xBBE7, [15016] = 0xBBE8,
  [15017] = 0xBBE9, [15018] = 0xBBEA, [15019] = 0xBBEB, [15020] = 0xBBEC,
  [15021] = 0xBBED, [15022] = 0xBBEE, [15023] = 0xBBEF, [15024] = 0xBBF0,
  [15025] = 0xBBF1, [15026] = 0xBBF2, [15027] = 0xBBF3, [15028] = 0xBBF4,
  [15029] = 0xBBF5, [15030] = 0xBBF6, [15031] = 0xBBF7, [15032] = 0xBBF8,
  [15033] = 0xBBF9, [15034] = 0xBBFA, [15035] = 0xBBFB, [15036] = 0xBBFC,
  [15037] = 0xBBFD, [15038] = 0xBBFE, [15104] = 0xBC40, [15105] = 0xBC41,
  [15106] = 0xBC42, [15107] = 0xBC43, [15108] = 0xBC44, [15109] = 0xBC45,
  [15110] = 0xBC46, [15111] = 0xBC47, [15112] = 0xBC48, [15113] = 0xBC49,
  [15114] = 0xBC4A, [15115] = 0xBC4B, [15116] = 0xBC4C, [15117] = 0xBC4D,
  [15118] = 0xBC4E, [15119] = 0xBC4F, [15120] = 0xBC50, [15121] = 0xBC51,
  [15122] = 0xBC52, [15123] = 0xBC53, [15124] = 0xBC54, [15125] = 0xBC55,
  [15126] = 0xBC56, [15127] = 0xBC57, [15128] = 0xBC58, [15129] = 0xBC59,
  [15130] = 0xBC5A, [15131] = 0xBC5B, [15132] = 0xBC5C, [15133] = 0xBC5D,
  [15134] = 0xBC5E, [15135] = 0xBC5F, [15136] = 0xBC60, [15137] = 0xBC61,
  [15138] = 0xBC62, [15139] = 0xBC63, [15140] = 0xBC64, [15141] = 0xBC65,
  [15142] = 0xBC66, [15143] = 0xBC67, [15144] = 0xBC68, [15145] = 0xBC69,
  [15146] = 0xBC6A, [15147] = 0xBC6B, [15148] = 0xBC6C, [15149] = 0xBC6D,
  [15150] = 0xBC6E, [15151] = 0xBC6F, [15152] = 0xBC70, [15153] = 0xBC71,
  [15154] = 0xBC72, [15155] = 0xBC73, [15156] = 0xBC74, [15157] = 0xBC75,
  [15158] = 0xBC76, [15159] = 0xBC77, [15160] = 0xBC78, [15161] = 0xBC79,
  [15162] = 0xBC7A, [15163] = 0xBC7B, [15164] = 0xBC7C, [15165] = 0xBC7D,
  [15166] = 0xBC7E, [15168] = 0xBC80, [15169] = 0xBC81, [15170] = 0xBC82,
  [15171] = 0xBC83, [15172] = 0xBC84, [15173] = 0xBC85, [15174] = 0xBC86,
  [15175] = 0xBC87, [15176] = 0xBC88, [15177] = 0xBC89, [15178] = 0xBC8A,
  [15179] = 0xBC8B, [15180] = 0xBC8C, [15181] = 0xBC8D, [15182] = 0xBC8E,
  [15183] = 0xBC8F, [15184] = 0xBC90, [15185] = 0xBC91, [15186] = 0xBC92,
  [15187] = 0xBC93, [15188] = 0xBC94, [15189] = 0xBC95, [15190] = 0xBC96,
  [15191] = 0xBC97, [15192] = 0xBC98, [15193] = 0xBC99, [15194] = 0xBC9A,
  [15195] = 0xBC9B, [15196] = 0xBC9C, [15197] = 0xBC9D, [15198] = 0xBC9E,
  [15199] = 0xBC9F, [15200] = 0xBCA0, [15201] = 0xBCA1, [15202] = 0xBCA2,
  [15203] = 0xBCA3, [15204] = 0xBCA4, [15205] = 0xBCA5, [15206] = 0xBCA6,
  [15207] = 0xBCA7, [15208] = 0xBCA8, [15209] = 0xBCA9, [15210] = 0xBCAA,
  [15211] = 0xBCAB, [15212] = 0xBCAC, [15213] = 0xBCAD, [15214] = 0xBCAE,
  [15215] = 0xBCAF, [15216] = 0xBCB0, [15217] = 0xBCB1, [15218] = 0xBCB2,
  [15219] = 0xBCB3, [15220] = 0xBCB4, [15221] = 0xBCB5, [15222] = 0xBCB6,
  [15223] = 0xBCB7, [15224] = 0xBCB8, [15225] = 0xBCB9, [15226] = 0xBCBA,
  [15227] = 0xBCBB, [15228] = 0xBCBC, [15229] = 0xBCBD, [15230] = 0xBCBE,
  [15231] = 0xBCBF, [15232] = 0xBCC0, [15233] = 0xBCC1, [15234] = 0xBCC2,
  [15235] = 0xBCC3, [15236] = 0xBCC4, [15237] = 0xBCC5, [15238] = 0xBCC6,
  [15239] = 0xBCC7, [15240] = 0xBCC8, [15241] = 0xBCC9, [15242] = 0xBCCA,
  [15243] = 0xBCCB, [15244] = 0xBCCC, [15245] = 0xBCCD, [15246] = 0xBCCE,
  [15247] = 0xBCCF, [15248] = 0xBCD0, [15249] = 0xBCD1, [15250] = 0xBCD2,
  [15251] = 0xBCD3, [15252] = 0xBCD4, [15253] = 0xBCD5, [15254] = 0xBCD6,
  [15255] = 0xBCD7, [15256] = 0xBCD8, [15257] = 0xBCD9, [15258] = 0xBCDA,
  [15259] = 0xBCDB, [15260] = 0xBCDC, [15261] = 0xBCDD, [15262] = 0xBCDE,
  [15263] = 0xBCDF, [15264] = 0xBCE0, [15265] = 0xBCE1, [15266] = 0xBCE2,
  [15267] = 0xBCE3, [15268] = 0xBCE4, [15269] = 0xBCE5, [15270] = 0xBCE6,
  [15271] = 0xBCE7, [15272] = 0xBCE8, [15273] = 0xBCE9, [15274] = 0xBCEA,
  [15275] = 0xBCEB, [15276] = 0xBCEC, [15277] = 0xBCED, [15278] = 0xBCEE,
  [15279] = 0xBCEF, [15280] = 0xBCF0, [15281] = 0xBCF1, [15282] = 0xBCF2,
  [15283] = 0xBCF3, [15284] = 0xBCF4, [15285] = 0xBCF5, [15286] = 0xBCF6,
  [15287] = 0xBCF7, [15288] = 0xBCF8, [15289] = 0xBCF9, [15290] = 0xBCFA,
  [15291] = 0xBCFB, [15292] = 0xBCFC, [15293] = 0xBCFD, [15294] = 0xBCFE,
  [15360] = 0xBD40, [15361] = 0xBD41, [15362] = 0xBD42, [15363] = 0xBD43,
  [15364] = 0xBD44, [15365] = 0xBD45, [15366] = 0xBD46, [15367] = 0xBD47,
  [15368] = 0xBD48, [15369] = 0xBD49, [15370] = 0xBD4A, [15371] = 0xBD4B,
  [15372] = 0xBD4C, [15373] = 0xBD4D, [15374] = 0xBD4E, [15375] = 0xBD4F,
  [15376] = 0xBD50, [15377] = 0xBD51, [15378] = 0xBD52, [15379] = 0xBD53,
  [15380] = 0xBD54, [15381] = 0xBD55, [15382] = 0xBD56, [15383] = 0xBD57,
  [15384] = 0xBD58, [15385] = 0xBD59, [15386] = 0xBD5A, [15387] = 0xBD5B,
  [15388] = 0xBD5C, [15389] = 0xBD5D, [15390] = 0xBD5E, [15391] = 0xBD5F,
  [15392] = 0xBD60, [15393] = 0xBD61, [15394] = 0xBD62, [15395] = 0xBD63,
  [15396] = 0xBD64, [15397] = 0xBD65, [15398] = 0xBD66, [15399] = 0xBD67,
  [15400] = 0xBD68, [15401] = 0xBD69, [15402] = 0xBD6A, [15403] = 0xBD6B,
  [15404] = 0xBD6C, [15405] = 0xBD6D, [15406] = 0xBD6E, [15407] = 0xBD6F,
  [15408] = 0xBD70, [15409] = 0xBD71, [15410] = 0xBD72, [15411] = 0xBD73,
  [15412] = 0xBD74, [15413] = 0xBD75, [15414] = 0xBD76, [15415] = 0xBD77,
  [15416] = 0xBD78, [15417] = 0xBD79, [15418] = 0xBD7A, [15419] = 0xBD7B,
  [15420] = 0xBD7C, [15421] = 0xBD7D, [15422] = 0xBD7E, [15424] = 0xBD80,
  [15425] = 0xBD81, [15426] = 0xBD82, [15427] = 0xBD83, [15428] = 0xBD84,
  [15429] = 0xBD85, [15430] = 0xBD86, [15431] = 0xBD87, [15432] = 0xBD88,
  [15433] = 0xBD89, [15434] = 0xBD8A, [15435] = 0xBD8B, [15436] = 0xBD8C,
  [15437] = 0xBD8D, [15438] = 0xBD8E, [15439] = 0xBD8F, [15440] = 0xBD90,
  [15441] = 0xBD91, [15442] = 0xBD92, [15443] = 0xBD93, [15444] = 0xBD94,
  [15445] = 0xBD95, [15446] = 0xBD96, [15447] = 0xBD97, [15448] = 0xBD98,
  [15449] = 0xBD99, [15450] = 0xBD9A, [15451] = 0xBD9B, [15452] = 0xBD9C,
  [15453] = 0xBD9D, [15454] = 0xBD9E, [15455] = 0xBD9F, [15456] = 0xBDA0,
  [15457] = 0xBDA1, [15458] = 0xBDA2, [15459] = 0xBDA3, [15460] = 0xBDA4,
  [15461] = 0xBDA5, [15462] = 0xBDA6, [15463] = 0xBDA7, [15464] = 0xBDA8,
  [15465] = 0xBDA9, [15466] = 0xBDAA, [15467] = 0xBDAB, [15468] = 0xBDAC,
  [15469] = 0xBDAD, [15470] = 0xBDAE, [15471] = 0xBDAF, [15472] = 0xBDB0,
  [15473] = 0xBDB1, [15474] = 0xBDB2, [15475] = 0xBDB3, [15476] = 0xBDB4,
  [15477] = 0xBDB5, [15478] = 0xBDB6, [15479] = 0xBDB7, [15480] = 0xBDB8,
  [15481] = 0xBDB9, [15482] = 0xBDBA, [15483] = 0xBDBB, [15484] = 0xBDBC,
  [15485] = 0xBDBD, [15486] = 0xBDBE, [15487] = 0xBDBF, [15488] = 0xBDC0,
  [15489] = 0xBDC1, [15490] = 0xBDC2, [15491] = 0xBDC3, [15492] = 0xBDC4,
  [15493] = 0xBDC5, [15494] = 0xBDC6, [15495] = 0xBDC7, [15496] = 0xBDC8,
  [15497] = 0xBDC9, [15498] = 0xBDCA, [15499] = 0xBDCB, [15500] = 0xBDCC,
  [15501] = 0xBDCD, [15502] = 0xBDCE, [15503] = 0xBDCF, [15504] = 0xBDD0,
  [15505] = 0xBDD1, [15506] = 0xBDD2, [15507] = 0xBDD3, [15508] = 0xBDD4,
  [15509] = 0xBDD5, [15510] = 0xBDD6, [15511] = 0xBDD7, [15512] = 0xBDD8,
  [15513] = 0xBDD9, [15514] = 0xBDDA, [15515] = 0xBDDB, [15516] = 0xBDDC,
  [15517] = 0xBDDD, [15518] = 0xBDDE, [15519] = 0xBDDF, [15520] = 0xBDE0,
  [15521] = 0xBDE1, [15522] = 0xBDE2, [15523] = 0xBDE3, [15524] = 0xBDE4,
  [15525] = 0xBDE5, [15526] = 0xBDE6, [15527] = 0xBDE7, [15528] = 0xBDE8,
  [15529] = 0xBDE9, [15530] = 0xBDEA, [15531] = 0xBDEB, [15532] = 0xBDEC,
  [15533] = 0xBDED, [15534] = 0xBDEE, [15535] = 0xBDEF, [15536] = 0xBDF0,
  [15537] = 0xBDF1, [15538] = 0xBDF2, [15539] = 0xBDF3, [15540] = 0xBDF4,
  [15541] = 0xBDF5, [15542] = 0xBDF6, [15543] = 0xBDF7, [15544] = 0xBDF8,
  [15545] = 0xBDF9, [15546] = 0xBDFA, [15547] = 0xBDFB, [15548] = 0xBDFC,
  [15549] = 0xBDFD, [15550] = 0xBDFE, [15616] = 0xBE40, [15617] = 0xBE41,
  [15618] = 0xBE42, [15619] = 0xBE43, [15620] = 0xBE44, [15621] = 0xBE45,
  [15622] = 0xBE46, [15623] = 0xBE47, [15624] = 0xBE48, [15625] = 0xBE49,
  [15626] = 0xBE4A, [15627] = 0xBE4B, [15628] = 0xBE4C, [15629] = 0xBE4D,
  [15630] = 0xBE4E, [15631] = 0xBE4F, [15632] = 0xBE50, [15633] = 0xBE51,
  [15634] = 0xBE52, [15635] = 0xBE53, [15636] = 0xBE54, [15637] = 0xBE55,
  [15638] = 0xBE56, [15639] = 0xBE57, [15640] = 0xBE58, [15641] = 0xBE59,
  [15642] = 0xBE5A, [15643] = 0xBE5B, [15644] = 0xBE5C, [15645] = 0xBE5D,
  [15646] = 0xBE5E, [15647] = 0xBE5F, [15648] = 0xBE60, [15649] = 0xBE61,
  [15650] = 0xBE62, [15651] = 0xBE63, [15652] = 0xBE64, [15653] = 0xBE65,
  [15654] = 0xBE66, [15655] = 0xBE67, [15656] = 0xBE68, [15657] = 0xBE69,
  [15658] = 0xBE6A, [15659] = 0xBE6B, [15660] = 0xBE6C, [15661] = 0xBE6D,
  [15662] = 0xBE6E, [15663] = 0xBE6F, [15664] = 0xBE70, [15665] = 0xBE71,
  [15666] = 0xBE72, [15667] = 0xBE73, [15668] = 0xBE74, [15669] = 0xBE75,
  [15670] = 0xBE76, [15671] = 0xBE77, [15672] = 0xBE78, [15673] = 0xBE79,
  [15674] = 0xBE7A, [15675] = 0xBE7B, [15676] = 0xBE7C, [15677] = 0xBE7D,
  [15678] = 0xBE7E, [15680] = 0xBE80, [15681] = 0xBE81, [15682] = 0xBE82,
  [15683] = 0xBE83, [15684] = 0xBE84, [15685] = 0xBE85, [15686] = 0xBE86,
  [15687] = 0xBE87, [15688] = 0xBE88, [15689] = 0xBE89, [15690] = 0xBE8A,
  [15691] = 0xBE8B, [15692] = 0xBE8C, [15693] = 0xBE8D, [15694] = 0xBE8E,
  [15695] = 0xBE8F, [15696] = 0xBE90, [15697] = 0xBE91, [15698] = 0xBE92,
  [15699] = 0xBE93, [15700] = 0xBE94, [15701] = 0xBE95, [15702] = 0xBE96,
  [15703] = 0xBE97, [15704] = 0xBE98, [15705] = 0xBE99, [15706] = 0xBE9A,
  [15707] = 0xBE9B, [15708] = 0xBE9C, [15709] = 0xBE9D, [15710] = 0xBE9E,
  [15711] = 0xBE9F, [15712] = 0xBEA0, [15713] = 0xBEA1, [15714] = 0xBEA2,
  [15715] = 0xBEA3, [15716] = 0xBEA4, [15717] = 0xBEA5, [15718] = 0xBEA6,
  [15719] = 0xBEA7, [15720] = 0xBEA8, [15721] = 0xBEA9, [15722] = 0xBEAA,
  [15723] = 0xBEAB, [15724] = 0xBEAC, [15725] = 0xBEAD, [15726] = 0xBEAE,
  [15727] = 0xBEAF, [15728] = 0xBEB0, [15729] = 0xBEB1, [15730] = 0xBEB2,
  [15731] = 0xBEB3, [15732] = 0xBEB4, [15733] = 0xBEB5, [15734] = 0xBEB6,
  [15735] = 0xBEB7, [15736] = 0xBEB8, [15737] = 0xBEB9, [15738] = 0xBEBA,
  [15739] = 0xBEBB, [15740] = 0xBEBC, [15741] = 0xBEBD, [15742] = 0xBEBE,
  [15743] = 0xBEBF, [15744] = 0xBEC0, [15745] = 0xBEC1, [15746] = 0xBEC2,
  [15747] = 0xBEC3, [15748] = 0xBEC4, [15749] = 0xBEC5, [15750] = 0xBEC6,
  [15751] = 0xBEC7, [15752] = 0xBEC8, [15753] = 0xBEC9, [15754] = 0xBECA,
  [15755] = 0xBECB, [15756] = 0xBECC, [15757] = 0xBECD, [15758] = 0xBECE,
  [15759] = 0xBECF, [15760] = 0xBED0, [15761] = 0xBED1, [15762] = 0xBED2,
  [15763] = 0xBED3, [15764] = 0xBED4, [15765] = 0xBED5, [15766] = 0xBED6,
  [15767] = 0xBED7, [15768] = 0xBED8, [15769] = 0xBED9, [15770] = 0xBEDA,
  [15771] = 0xBEDB, [15772] = 0xBEDC, [15773] = 0xBEDD, [15774] = 0xBEDE,
  [15775] = 0xBEDF, [15776] = 0xBEE0, [15777] = 0xBEE1, [15778] = 0xBEE2,
  [15779] = 0xBEE3, [15780] = 0xBEE4, [15781] = 0xBEE5, [15782] = 0xBEE6,
  [15783] = 0xBEE7, [15784] = 0xBEE8, [15785] = 0xBEE9, [15786] = 0xBEEA,
  [15787] = 0xBEEB, [15788] = 0xBEEC, [15789] = 0xBEED, [15790] = 0xBEEE,
  [15791] = 0xBEEF, [15792] = 0xBEF0, [15793] = 0xBEF1, [15794] = 0xBEF2,
  [15795] = 0xBEF3, [15796] = 0xBEF4, [15797] = 0xBEF5, [15798] = 0xBEF6,
  [15799] = 0xBEF7, [15800] = 0xBEF8, [15801] = 0xBEF9, [15802] = 0xBEFA,
  [15803] = 0xBEFB, [15804] = 0xBEFC, [15805] = 0xBEFD, [15806] = 0xBEFE,
  [15872] = 0xBF40, [15873] = 0xBF41, [15874] = 0xBF42, [15875] = 0xBF43,
  [15876] = 0xBF44, [15877] = 0xBF45, [15878] = 0xBF46, [15879] = 0xBF47,
  [15880] = 0xBF48, [15881] = 0xBF49, [15882] = 0xBF4A, [15883] = 0xBF4B,
  [15884] = 0xBF4C, [15885] = 0xBF4D, [15886] = 0xBF4E, [15887] = 0xBF4F,
  [15888] = 0xBF50, [15889] = 0xBF51, [15890] = 0xBF52, [15891] = 0xBF53,
  [15892] = 0xBF54, [15893] = 0xBF55, [15894] = 0xBF56, [15895] = 0xBF57,
  [15896] = 0xBF58, [15897] = 0xBF59, [15898] = 0xBF5A, [15899] = 0xBF5B,
  [15900] = 0xBF5C, [15901] = 0xBF5D, [15902] = 0xBF5E, [15903] = 0xBF5F,
  [15904] = 0xBF60, [15905] = 0xBF61, [15906] = 0xBF62, [15907] = 0xBF63,
  [15908] = 0xBF64, [15909] = 0xBF65, [15910] = 0xBF66, [15911] = 0xBF67,
  [15912] = 0xBF68, [15913] = 0xBF69, [15914] = 0xBF6A, [15915] = 0xBF6B,
  [15916] = 0xBF6C, [15917] = 0xBF6D, [15918] = 0xBF6E, [15919] = 0xBF6F,
  [15920] = 0xBF70, [15921] = 0xBF71, [15922] = 0xBF72, [15923] = 0xBF73,
  [15924] = 0xBF74, [15925] = 0xBF75, [15926] = 0xBF76, [15927] = 0xBF77,
  [15928] = 0xBF78, [15929] = 0xBF79, [15930] = 0xBF7A, [15931] = 0xBF7B,
  [15932] = 0xBF7C, [15933] = 0xBF7D, [15934] = 0xBF7E, [15936] = 0xBF80,
  [15937] = 0xBF81, [15938] = 0xBF82, [15939] = 0xBF83, [15940] = 0xBF84,
  [15941] = 0xBF85, [15942] = 0xBF86, [15943] = 0xBF87, [15944] = 0xBF88,
  [15945] = 0xBF89, [15946] = 0xBF8A, [15947] = 0xBF8B, [15948] = 0xBF8C,
  [15949] = 0xBF8D, [15950] = 0xBF8E, [15951] = 0xBF8F, [15952] = 0xBF90,
  [15953] = 0xBF91, [15954] = 0xBF92, [15955] = 0xBF93, [15956] = 0xBF94,
  [15957] = 0xBF95, [15958] = 0xBF96, [15959] = 0xBF97, [15960] = 0xBF98,
  [15961] = 0xBF99, [15962] = 0xBF9A, [15963] = 0xBF9B, [15964] = 0xBF9C,
  [15965] = 0xBF9D, [15966] = 0xBF9E, [15967] = 0xBF9F, [15968] = 0xBFA0,
  [15969] = 0xBFA1, [15970] = 0xBFA2, [15971] = 0xBFA3, [15972] = 0xBFA4,
  [15973] = 0xBFA5, [15974] = 0xBFA6, [15975] = 0xBFA7, [15976] = 0xBFA8,
  [15977] = 0xBFA9, [15978] = 0xBFAA, [15979] = 0xBFAB, [15980] = 0xBFAC,
  [15981] = 0xBFAD, [15982] = 0xBFAE, [15983] = 0xBFAF, [15984] = 0xBFB0,
  [15985] = 0xBFB1, [15986] = 0xBFB2, [15987] = 0xBFB3, [15988] = 0xBFB4,
  [15989] = 0xBFB5, [15990] = 0xBFB6, [15991] = 0xBFB7, [15992] = 0xBFB8,
  [15993] = 0xBFB9, [15994] = 0xBFBA, [15995] = 0xBFBB, [15996] = 0xBFBC,
  [15997] = 0xBFBD, [15998] = 0xBFBE, [15999] = 0xBFBF, [16000] = 0xBFC0,
  [16001] = 0xBFC1, [16002] = 0xBFC2, [16003] = 0xBFC3, [16004] = 0xBFC4,
  [16005] = 0xBFC5, [16006] = 0xBFC6, [16007] = 0xBFC7, [16008] = 0xBFC8,
  [16009] = 0xBFC9, [16010] = 0xBFCA, [16011] = 0xBFCB, [16012] = 0xBFCC,
  [16013] = 0xBFCD, [16014] = 0xBFCE, [16015] = 0xBFCF, [16016] = 0xBFD0,
  [16017] = 0xBFD1, [16018] = 0xBFD2, [16019] = 0xBFD3, [16020] = 0xBFD4,
  [16021] = 0xBFD5, [16022] = 0xBFD6, [16023] = 0xBFD7, [16024] = 0xBFD8,
  [16025] = 0xBFD9, [16026] = 0xBFDA, [16027] = 0xBFDB, [16028] = 0xBFDC,
  [16029] = 0xBFDD, [16030] = 0xBFDE, [16031] = 0xBFDF, [16032] = 0xBFE0,
  [16033] = 0xBFE1, [16034] = 0xBFE2, [16035] = 0xBFE3, [16036] = 0xBFE4,
  [16037] = 0xBFE5, [16038] = 0xBFE6, [16039] = 0xBFE7, [16040] = 0xBFE8,
  [16041] = 0xBFE9, [16042] = 0xBFEA, [16043] = 0xBFEB, [16044] = 0xBFEC,
  [16045] = 0xBFED, [16046] = 0xBFEE, [16047] = 0xBFEF, [16048] = 0xBFF0,
  [16049] = 0xBFF1, [16050] = 0xBFF2, [16051] = 0xBFF3, [16052] = 0xBFF4,
  [16053] = 0xBFF5, [16054] = 0xBFF6, [16055] = 0xBFF7, [16056] = 0xBFF8,
  [16057] = 0xBFF9, [16058] = 0xBFFA, [16059] = 0xBFFB, [16060] = 0xBFFC,
  [16061] = 0xBFFD, [16062] = 0xBFFE, [16128] = 0xC040, [16129] = 0xC041,
  [16130] = 0xC042, [16131] = 0xC043, [16132] = 0xC044, [16133] = 0xC045,
  [16134] = 0xC046, [16135] = 0xC047, [16136] = 0xC048, [16137] = 0xC049,
  [16138] = 0xC04A, [16139] = 0xC04B, [16140] = 0xC04C, [16141] = 0xC04D,
  [16142] = 0xC04E, [16143] = 0xC04F, [16144] = 0xC050, [16145] = 0xC051,
  [16146] = 0xC052, [16147] = 0xC053, [16148] = 0xC054, [16149] = 0xC055,
  [16150] = 0xC056, [16151] = 0xC057, [16152] = 0xC058, [16153] = 0xC059,
  [16154] = 0xC05A, [16155] = 0xC05B, [16156] = 0xC05C, [16157] = 0xC05D,
  [16158] = 0xC05E, [16159] = 0xC05F, [16160] = 0xC060, [16161] = 0xC061,
  [16162] = 0xC062, [16163] = 0xC063, [16164] = 0xC064, [16165] = 0xC065,
  [16166] = 0xC066, [16167] = 0xC067, [16168] = 0xC068, [16169] = 0xC069,
  [16170] = 0xC06A, [16171] = 0xC06B, [16172] = 0xC06C, [16173] = 0xC06D,
  [16174] = 0xC06E, [16175] = 0xC06F, [16176] = 0xC070, [16177] = 0xC071,
  [16178] = 0xC072, [16179] = 0xC073, [16180] = 0xC074, [16181] = 0xC075,
  [16182] = 0xC076, [16183] = 0xC077, [16184] = 0xC078, [16185] = 0xC079,
  [16186] = 0xC07A, [16187] = 0xC07B, [16188] = 0xC07C, [16189] = 0xC07D,
  [16190] = 0xC07E, [16192] = 0xC080, [16193] = 0xC081, [16194] = 0xC082,
  [16195] = 0xC083, [16196] = 0xC084, [16197] = 0xC085, [16198] = 0xC086,
  [16199] = 0xC087, [16200] = 0xC088, [16201] = 0xC089, [16202] = 0xC08A,
  [16203] = 0xC08B, [16204] = 0xC08C, [16205] = 0xC08D, [16206] = 0xC08E,
  [16207] = 0xC08F, [16208] = 0xC090, [16209] = 0xC091, [16210] = 0xC092,
  [16211] = 0xC093, [16212] = 0xC094, [16213] = 0xC095, [16214] = 0xC096,
  [16215] = 0xC097, [16216] = 0xC098, [16217] = 0xC099, [16218] = 0xC09A,
  [16219] = 0xC09B, [16220] = 0xC09C, [16221] = 0xC09D, [16222] = 0xC09E,
  [16223] = 0xC09F, [16224] = 0xC0A0, [16225] = 0xC0A1, [16226] = 0xC0A2,
  [16227] = 0xC0A3, [16228] = 0xC0A4, [16229] = 0xC0A5, [16230] = 0xC0A6,
  [16231] = 0xC0A7, [16232] = 0xC0A8, [16233] = 0xC0A9, [16234] = 0xC0AA,
  [16235] = 0xC0AB, [16236] = 0xC0AC, [16237] = 0xC0AD, [16238] = 0xC0AE,
  [16239] = 0xC0AF, [16240] = 0xC0B0, [16241] = 0xC0B1, [16242] = 0xC0B2,
  [16243] = 0xC0B3, [16244] = 0xC0B4, [16245] = 0xC0B5, [16246] = 0xC0B6,
  [16247] = 0xC0B7, [16248] = 0xC0B8, [16249] = 0xC0B9, [16250] = 0xC0BA,
  [16251] = 0xC0BB, [16252] = 0xC0BC, [16253] = 0xC0BD, [16254] = 0xC0BE,
  [16255] = 0xC0BF, [16256] = 0xC0C0, [16257] = 0xC0C1, [16258] = 0xC0C2,
  [16259] = 0xC0C3, [16260] = 0xC0C4, [16261] = 0xC0C5, [16262] = 0xC0C6,
  [16263] = 0xC0C7, [16264] = 0xC0C8, [16265] = 0xC0C9, [16266] = 0xC0CA,
  [16267] = 0xC0CB, [16268] = 0xC0CC, [16269] = 0xC0CD, [16270] = 0xC0CE,
  [16271] = 0xC0CF, [16272] = 0xC0D0, [16273] = 0xC0D1, [16274] = 0xC0D2,
  [16275] = 0xC0D3, [16276] = 0xC0D4, [16277] = 0xC0D5, [16278] = 0xC0D6,
  [16279] = 0xC0D7, [16280] = 0xC0D8, [16281] = 0xC0D9, [16282] = 0xC0DA,
  [16283] = 0xC0DB, [16284] = 0xC0DC, [16285] = 0xC0DD, [16286] = 0xC0DE,
  [16287] = 0xC0DF, [16288] = 0xC0E0, [16289] = 0xC0E1, [16290] = 0xC0E2,
  [16291] = 0xC0E3, [16292] = 0xC0E4, [16293] = 0xC0E5, [16294] = 0xC0E6,
  [16295] = 0xC0E7, [16296] = 0xC0E8, [16297] = 0xC0E9, [16298] = 0xC0EA,
  [16299] = 0xC0EB, [16300] = 0xC0EC, [16301] = 0xC0ED, [16302] = 0xC0EE,
  [16303] = 0xC0EF, [16304] = 0xC0F0, [16305] = 0xC0F1, [16306] = 0xC0F2,
  [16307] = 0xC0F3, [16308] = 0xC0F4, [16309] = 0xC0F5, [16310] = 0xC0F6,
  [16311] = 0xC0F7, [16312] = 0xC0F8, [16313] = 0xC0F9, [16314] = 0xC0FA,
  [16315] = 0xC0FB, [16316] = 0xC0FC, [16317] = 0xC0FD, [16318] = 0xC0FE,
  [16384] = 0xC140, [16385] = 0xC141, [16386] = 0xC142, [16387] = 0xC143,
  [16388] = 0xC144, [16389] = 0xC145, [16390] = 0xC146, [16391] = 0xC147,
  [16392] = 0xC148, [16393] = 0xC149, [16394] = 0xC14A, [16395] = 0xC14B,
  [16396] = 0xC14C, [16397] = 0xC14D, [16398] = 0xC14E, [16399] = 0xC14F,
  [16400] = 0xC150, [16401] = 0xC151, [16402] = 0xC152, [16403] = 0xC153,
  [16404] = 0xC154, [16405] = 0xC155, [16406] = 0xC156, [16407] = 0xC157,
  [16408] = 0xC158, [16409] = 0xC159, [16410] = 0xC15A, [16411] = 0xC15B,
  [16412] = 0xC15C, [16413] = 0xC15D, [16414] = 0xC15E, [16415] = 0xC15F,
  [16416] = 0xC160, [16417] = 0xC161, [16418] = 0xC162, [16419] = 0xC163,
  [16420] = 0xC164, [16421] = 0xC165, [16422] = 0xC166, [16423] = 0xC167,
  [16424] = 0xC168, [16425] = 0xC169, [16426] = 0xC16A, [16427] = 0xC16B,
  [16428] = 0xC16C, [16429] = 0xC16D, [16430] = 0xC16E, [16431] = 0xC16F,
  [16432] = 0xC170, [16433] = 0xC171, [16434] = 0xC172, [16435] = 0xC173,
  [16436] = 0xC174, [16437] = 0xC175, [16438] = 0xC176, [16439] = 0xC177,
  [16440] = 0xC178, [16441] = 0xC179, [16442] = 0xC17A, [16443] = 0xC17B,
  [16444] = 0xC17C, [16445] = 0xC17D, [16446] = 0xC17E, [16448] = 0xC180,
  [16449] = 0xC181, [16450] = 0xC182, [16451] = 0xC183, [16452] = 0xC184,
  [16453] = 0xC185, [16454] = 0xC186, [16455] = 0xC187, [16456] = 0xC188,
  [16457] = 0xC189, [16458] = 0xC18A, [16459] = 0xC18B, [16460] = 0xC18C,
  [16461] = 0xC18D, [16462] = 0xC18E, [16463] = 0xC18F, [16464] = 0xC190,
  [16465] = 0xC191, [16466] = 0xC192, [16467] = 0xC193, [16468] = 0xC194,
  [16469] = 0xC195, [16470] = 0xC196, [16471] = 0xC197, [16472] = 0xC198,
  [16473] = 0xC199, [16474] = 0xC19A, [16475] = 0xC19B, [16476] = 0xC19C,
  [16477] = 0xC19D, [16478] = 0xC19E, [16479] = 0xC19F, [16480] = 0xC1A0,
  [16481] = 0xC1A1, [16482] = 0xC1A2, [16483] = 0xC1A3, [16484] = 0xC1A4,
  [16485] = 0xC1A5, [16486] = 0xC1A6, [16487] = 0xC1A7, [16488] = 0xC1A8,
  [16489] = 0xC1A9, [16490] = 0xC1AA, [16491] = 0xC1AB, [16492] = 0xC1AC,
  [16493] = 0xC1AD, [16494] = 0xC1AE, [16495] = 0xC1AF, [16496] = 0xC1B0,
  [16497] = 0xC1B1, [16498] = 0xC1B2, [16499] = 0xC1B3, [16500] = 0xC1B4,
  [16501] = 0xC1B5, [16502] = 0xC1B6, [16503] = 0xC1B7, [16504] = 0xC1B8,
  [16505] = 0xC1B9, [16506] = 0xC1BA, [16507] = 0xC1BB, [16508] = 0xC1BC,
  [16509] = 0xC1BD, [16510] = 0xC1BE, [16511] = 0xC1BF, [16512] = 0xC1C0,
  [16513] = 0xC1C1, [16514] = 0xC1C2, [16515] = 0xC1C3, [16516] = 0xC1C4,
  [16517] = 0xC1C5, [16518] = 0xC1C6, [16519] = 0xC1C7, [16520] = 0xC1C8,
  [16521] = 0xC1C9, [16522] = 0xC1CA, [16523] = 0xC1CB, [16524] = 0xC1CC,
  [16525] = 0xC1CD, [16526] = 0xC1CE, [16527] = 0xC1CF, [16528] = 0xC1D0,
  [16529] = 0xC1D1, [16530] = 0xC1D2, [16531] = 0xC1D3, [16532] = 0xC1D4,
  [16533] = 0xC1D5, [16534] = 0xC1D6, [16535] = 0xC1D7, [16536] = 0xC1D8,
  [16537] = 0xC1D9, [16538] = 0xC1DA, [16539] = 0xC1DB, [16540] = 0xC1DC,
  [16541] = 0xC1DD, [16542] = 0xC1DE, [16543] = 0xC1DF, [16544] = 0xC1E0,
  [16545] = 0xC1E1, [16546] = 0xC1E2, [16547] = 0xC1E3, [16548] = 0xC1E4,
  [16549] = 0xC1E5, [16550] = 0xC1E6, [16551] = 0xC1E7, [16552] = 0xC1E8,
  [16553] = 0xC1E9, [16554] = 0xC1EA, [16555] = 0xC1EB, [16556] = 0xC1EC,
  [16557] = 0xC1ED, [16558] = 0xC1EE, [16559] = 0xC1EF, [16560] = 0xC1F0,
  [16561] = 0xC1F1, [16562] = 0xC1F2, [16563] = 0xC1F3, [16564] = 0xC1F4,
  [16565] = 0xC1F5, [16566] = 0xC1F6, [16567] = 0xC1F7, [16568] = 0xC1F8,
  [16569] = 0xC1F9, [16570] = 0xC1FA, [16571] = 0xC1FB, [16572] = 0xC1FC,
  [16573] = 0xC1FD, [16574] = 0xC1FE, [16640] = 0xC240, [16641] = 0xC241,
  [16642] = 0xC242, [16643] = 0xC243, [16644] = 0xC244, [16645] = 0xC245,
  [16646] = 0xC246, [16647] = 0xC247, [16648] = 0xC248, [16649] = 0xC249,
  [16650] = 0xC24A, [16651] = 0xC24B, [16652] = 0xC24C, [16653] = 0xC24D,
  [16654] = 0xC24E, [16655] = 0xC24F, [16656] = 0xC250, [16657] = 0xC251,
  [16658] = 0xC252, [16659] = 0xC253, [16660] = 0xC254, [16661] = 0xC255,
  [16662] = 0xC256, [16663] = 0xC257, [16664] = 0xC258, [16665] = 0xC259,
  [16666] = 0xC25A, [16667] = 0xC25B, [16668] = 0xC25C, [16669] = 0xC25D,
  [16670] = 0xC25E, [16671] = 0xC25F, [16672] = 0xC260, [16673] = 0xC261,
  [16674] = 0xC262, [16675] = 0xC263, [16676] = 0xC264, [16677] = 0xC265,
  [16678] = 0xC266, [16679] = 0xC267, [16680] = 0xC268, [16681] = 0xC269,
  [16682] = 0xC26A, [16683] = 0xC26B, [16684] = 0xC26C, [16685] = 0xC26D,
  [16686] = 0xC26E, [16687] = 0xC26F, [16688] = 0xC270, [16689] = 0xC271,
  [16690] = 0xC272, [16691] = 0xC273, [16692] = 0xC274, [16693] = 0xC275,
  [16694] = 0xC276, [16695] = 0xC277, [16696] = 0xC278, [16697] = 0xC279,
  [16698] = 0xC27A, [16699] = 0xC27B, [16700] = 0xC27C, [16701] = 0xC27D,
  [16702] = 0xC27E, [16704] = 0xC280, [16705] = 0xC281, [16706] = 0xC282,
  [16707] = 0xC283, [16708] = 0xC284, [16709] = 0xC285, [16710] = 0xC286,
  [16711] = 0xC287, [16712] = 0xC288, [16713] = 0xC289, [16714] = 0xC28A,
  [16715] = 0xC28B, [16716] = 0xC28C, [16717] = 0xC28D, [16718] = 0xC28E,
  [16719] = 0xC28F, [16720] = 0xC290, [16721] = 0xC291, [16722] = 0xC292,
  [16723] = 0xC293, [16724] = 0xC294, [16725] = 0xC295, [16726] = 0xC296,
  [16727] = 0xC297, [16728] = 0xC298, [16729] = 0xC299, [16730] = 0xC29A,
  [16731] = 0xC29B, [16732] = 0xC29C, [16733] = 0xC29D, [16734] = 0xC29E,
  [16735] = 0xC29F, [16736] = 0xC2A0, [16737] = 0xC2A1, [16738] = 0xC2A2,
  [16739] = 0xC2A3, [16740] = 0xC2A4, [16741] = 0xC2A5, [16742] = 0xC2A6,
  [16743] = 0xC2A7, [16744] = 0xC2A8, [16745] = 0xC2A9, [16746] = 0xC2AA,
  [16747] = 0xC2AB, [16748] = 0xC2AC, [16749] = 0xC2AD, [16750] = 0xC2AE,
  [16751] = 0xC2AF, [16752] = 0xC2B0, [16753] = 0xC2B1, [16754] = 0xC2B2,
  [16755] = 0xC2B3, [16756] = 0xC2B4, [16757] = 0xC2B5, [16758] = 0xC2B6,
  [16759] = 0xC2B7, [16760] = 0xC2B8, [16761] = 0xC2B9, [16762] = 0xC2BA,
  [16763] = 0xC2BB, [16764] = 0xC2BC, [16765] = 0xC2BD, [16766] = 0xC2BE,
  [16767] = 0xC2BF, [16768] = 0xC2C0, [16769] = 0xC2C1, [16770] = 0xC2C2,
  [16771] = 0xC2C3, [16772] = 0xC2C4, [16773] = 0xC2C5, [16774] = 0xC2C6,
  [16775] = 0xC2C7, [16776] = 0xC2C8, [16777] = 0xC2C9, [16778] = 0xC2CA,
  [16779] = 0xC2CB, [16780] = 0xC2CC, [16781] = 0xC2CD, [16782] = 0xC2CE,
  [16783] = 0xC2CF, [16784] = 0xC2D0, [16785] = 0xC2D1, [16786] = 0xC2D2,
  [16787] = 0xC2D3, [16788] = 0xC2D4, [16789] = 0xC2D5, [16790] = 0xC2D6,
  [16791] = 0xC2D7, [16792] = 0xC2D8, [16793] = 0xC2D9, [16794] = 0xC2DA,
  [16795] = 0xC2DB, [16796] = 0xC2DC, [16797] = 0xC2DD, [16798] = 0xC2DE,
  [16799] = 0xC2DF, [16800] = 0xC2E0, [16801] = 0xC2E1, [16802] = 0xC2E2,
  [16803] = 0xC2E3, [16804] = 0xC2E4, [16805] = 0xC2E5, [16806] = 0xC2E6,
  [16807] = 0xC2E7, [16808] = 0xC2E8, [16809] = 0xC2E9, [16810] = 0xC2EA,
  [16811] = 0xC2EB, [16812] = 0xC2EC, [16813] = 0xC2ED, [16814] = 0xC2EE,
  [16815] = 0xC2EF, [16816] = 0xC2F0, [16817] = 0xC2F1, [16818] = 0xC2F2,
  [16819] = 0xC2F3, [16820] = 0xC2F4, [16821] = 0xC2F5, [16822] = 0xC2F6,
  [16823] = 0xC2F7, [16824] = 0xC2F8, [16825] = 0xC2F9, [16826] = 0xC2FA,
  [16827] = 0xC2FB, [16828] = 0xC2FC, [16829] = 0xC2FD, [16830] = 0xC2FE,
  [16896] = 0xC340, [16897] = 0xC341, [16898] = 0xC342, [16899] = 0xC343,
  [16900] = 0xC344, [16901] = 0xC345, [16902] = 0xC346, [16903] = 0xC347,
  [16904] = 0xC348, [16905] = 0xC349, [16906] = 0xC34A, [16907] = 0xC34B,
  [16908] = 0xC34C, [16909] = 0xC34D, [16910] = 0xC34E, [16911] = 0xC34F,
  [16912] = 0xC350, [16913] = 0xC351, [16914] = 0xC352, [16915] = 0xC353,
  [16916] = 0xC354, [16917] = 0xC355, [16918] = 0xC356, [16919] = 0xC357,
  [16920] = 0xC358, [16921] = 0xC359, [16922] = 0xC35A, [16923] = 0xC35B,
  [16924] = 0xC35C, [16925] = 0xC35D, [16926] = 0xC35E, [16927] = 0xC35F,
  [16928] = 0xC360, [16929] = 0xC361, [16930] = 0xC362, [16931] = 0xC363,
  [16932] = 0xC364, [16933] = 0xC365, [16934] = 0xC366, [16935] = 0xC367,
  [16936] = 0xC368, [16937] = 0xC369, [16938] = 0xC36A, [16939] = 0xC36B,
  [16940] = 0xC36C, [16941] = 0xC36D, [16942] = 0xC36E, [16943] = 0xC36F,
  [16944] = 0xC370, [16945] = 0xC371, [16946] = 0xC372, [16947] = 0xC373,
  [16948] = 0xC374, [16949] = 0xC375, [16950] = 0xC376, [16951] = 0xC377,
  [16952] = 0xC378, [16953] = 0xC379, [16954] = 0xC37A, [16955] = 0xC37B,
  [16956] = 0xC37C, [16957] = 0xC37D, [16958] = 0xC37E, [16960] = 0xC380,
  [16961] = 0xC381, [16962] = 0xC382, [16963] = 0xC383, [16964] = 0xC384,
  [16965] = 0xC385, [16966] = 0xC386, [16967] = 0xC387, [16968] = 0xC388,
  [16969] = 0xC389, [16970] = 0xC38A, [16971] = 0xC38B, [16972] = 0xC38C,
  [16973] = 0xC38D, [16974] = 0xC38E, [16975] = 0xC38F, [16976] = 0xC390,
  [16977] = 0xC391, [16978] = 0xC392, [16979] = 0xC393, [16980] = 0xC394,
  [16981] = 0xC395, [16982] = 0xC396, [16983] = 0xC397, [16984] = 0xC398,
  [16985] = 0xC399, [16986] = 0xC39A, [16987] = 0xC39B, [16988] = 0xC39C,
  [16989] = 0xC39D, [16990] = 0xC39E, [16991] = 0xC39F, [16992] = 0xC3A0,
  [16993] = 0xC3A1, [16994] = 0xC3A2, [16995] = 0xC3A3, [16996] = 0xC3A4,
  [16997] = 0xC3A5, [16998] = 0xC3A6, [16999] = 0xC3A7, [17000] = 0xC3A8,
  [17001] = 0xC3A9, [17002] = 0xC3AA, [17003] = 0xC3AB, [17004] = 0xC3AC,
  [17005] = 0xC3AD, [17006] = 0xC3AE, [17007] = 0xC3AF, [17008] = 0xC3B0,
  [17009] = 0xC3B1, [17010] = 0xC3B2, [17011] = 0xC3B3, [17012] = 0xC3B4,
  [17013] = 0xC3B5, [17014] = 0xC3B6, [17015] = 0xC3B7, [17016] = 0xC3B8,
  [17017] = 0xC3B9, [17018] = 0xC3BA, [17019] = 0xC3BB, [17020] = 0xC3BC,
  [17021] = 0xC3BD, [17022] = 0xC3BE, [17023] = 0xC3BF, [17024] = 0xC3C0,
  [17025] = 0xC3C1, [17026] = 0xC3C2, [17027] = 0xC3C3, [17028] = 0xC3C4,
  [17029] = 0xC3C5, [17030] = 0xC3C6, [17031] = 0xC3C7, [17032] = 0xC3C8,
  [17033] = 0xC3C9, [17034] = 0xC3CA, [17035] = 0xC3CB, [17036] = 0xC3CC,
  [17037] = 0xC3CD, [17038] = 0xC3CE, [17039] = 0xC3CF, [17040] = 0xC3D0,
  [17041] = 0xC3D1, [17042] = 0xC3D2, [17043] = 0xC3D3, [17044] = 0xC3D4,
  [17045] = 0xC3D5, [17046] = 0xC3D6, [17047] = 0xC3D7, [17048] = 0xC3D8,
  [17049] = 0xC3D9, [17050] = 0xC3DA, [17051] = 0xC3DB, [17052] = 0xC3DC,
  [17053] = 0xC3DD, [17054] = 0xC3DE, [17055] = 0xC3DF, [17056] = 0xC3E0,
  [17057] = 0xC3E1, [17058] = 0xC3E2, [17059] = 0xC3E3, [17060] = 0xC3E4,
  [17061] = 0xC3E5, [17062] = 0xC3E6, [17063] = 0xC3E7, [17064] = 0xC3E8,
  [17065] = 0xC3E9, [17066] = 0xC3EA, [17067] = 0xC3EB, [17068] = 0xC3EC,
  [17069] = 0xC3ED, [17070] = 0xC3EE, [17071] = 0xC3EF, [17072] = 0xC3F0,
  [17073] = 0xC3F1, [17074] = 0xC3F2, [17075] = 0xC3F3, [17076] = 0xC3F4,
  [17077] = 0xC3F5, [17078] = 0xC3F6, [17079] = 0xC3F7, [17080] = 0xC3F8,
  [17081] = 0xC3F9, [17082] = 0xC3FA, [17083] = 0xC3FB, [17084] = 0xC3FC,
  [17085] = 0xC3FD, [17086] = 0xC3FE, [17152] = 0xC440, [17153] = 0xC441,
  [17154] = 0xC442, [17155] = 0xC443, [17156] = 0xC444, [17157] = 0xC445,
  [17158] = 0xC446, [17159] = 0xC447, [17160] = 0xC448, [17161] = 0xC449,
  [17162] = 0xC44A, [17163] = 0xC44B, [17164] = 0xC44C, [17165] = 0xC44D,
  [17166] = 0xC44E, [17167] = 0xC44F, [17168] = 0xC450, [17169] = 0xC451,
  [17170] = 0xC452, [17171] = 0xC453, [17172] = 0xC454, [17173] = 0xC455,
  [17174] = 0xC456, [17175] = 0xC457, [17176] = 0xC458, [17177] = 0xC459,
  [17178] = 0xC45A, [17179] = 0xC45B, [17180] = 0xC45C, [17181] = 0xC45D,
  [17182] = 0xC45E, [17183] = 0xC45F, [17184] = 0xC460, [17185] = 0xC461,
  [17186] = 0xC462, [17187] = 0xC463, [17188] = 0xC464, [17189] = 0xC465,
  [17190] = 0xC466, [17191] = 0xC467, [17192] = 0xC468, [17193] = 0xC469,
  [17194] = 0xC46A, [17195] = 0xC46B, [17196] = 0xC46C, [17197] = 0xC46D,
  [17198] = 0xC46E, [17199] = 0xC46F, [17200] = 0xC470, [17201] = 0xC471,
  [17202] = 0xC472, [17203] = 0xC473, [17204] = 0xC474, [17205] = 0xC475,
  [17206] = 0xC476, [17207] = 0xC477, [17208] = 0xC478, [17209] = 0xC479,
  [17210] = 0xC47A, [17211] = 0xC47B, [17212] = 0xC47C, [17213] = 0xC47D,
  [17214] = 0xC47E, [17216] = 0xC480, [17217] = 0xC481, [17218] = 0xC482,
  [17219] = 0xC483, [17220] = 0xC484, [17221] = 0xC485, [17222] = 0xC486,
  [17223] = 0xC487, [17224] = 0xC488, [17225] = 0xC489, [17226] = 0xC48A,
  [17227] = 0xC48B, [17228] = 0xC48C, [17229] = 0xC48D, [17230] = 0xC48E,
  [17231] = 0xC48F, [17232] = 0xC490, [17233] = 0xC491, [17234] = 0xC492,
  [17235] = 0xC493, [17236] = 0xC494, [17237] = 0xC495, [17238] = 0xC496,
  [17239] = 0xC497, [17240] = 0xC498, [17241] = 0xC499, [17242] = 0xC49A,
  [17243] = 0xC49B, [17244] = 0xC49C, [17245] = 0xC49D, [17246] = 0xC49E,
  [17247] = 0xC49F, [17248] = 0xC4A0, [17249] = 0xC4A1, [17250] = 0xC4A2,
  [17251] = 0xC4A3, [17252] = 0xC4A4, [17253] = 0xC4A5, [17254] = 0xC4A6,
  [17255] = 0xC4A7, [17256] = 0xC4A8, [17257] = 0xC4A9, [17258] = 0xC4AA,
  [17259] = 0xC4AB, [17260] = 0xC4AC, [17261] = 0xC4AD, [17262] = 0xC4AE,
  [17263] = 0xC4AF, [17264] = 0xC4B0, [17265] = 0xC4B1, [17266] = 0xC4B2,
  [17267] = 0xC4B3, [17268] = 0xC4B4, [17269] = 0xC4B5, [17270] = 0xC4B6,
  [17271] = 0xC4B7, [17272] = 0xC4B8, [17273] = 0xC4B9, [17274] = 0xC4BA,
  [17275] = 0xC4BB, [17276] = 0xC4BC, [17277] = 0xC4BD, [17278] = 0xC4BE,
  [17279] = 0xC4BF, [17280] = 0xC4C0, [17281] = 0xC4C1, [17282] = 0xC4C2,
  [17283] = 0xC4C3, [17284] = 0xC4C4, [17285] = 0xC4C5, [17286] = 0xC4C6,
  [17287] = 0xC4C7, [17288] = 0xC4C8, [17289] = 0xC4C9, [17290] = 0xC4CA,
  [17291] = 0xC4CB, [17292] = 0xC4CC, [17293] = 0xC4CD, [17294] = 0xC4CE,
  [17295] = 0xC4CF, [17296] = 0xC4D0, [17297] = 0xC4D1, [17298] = 0xC4D2,
  [17299] = 0xC4D3, [17300] = 0xC4D4, [17301] = 0xC4D5, [17302] = 0xC4D6,
  [17303] = 0xC4D7, [17304] = 0xC4D8, [17305] = 0xC4D9, [17306] = 0xC4DA,
  [17307] = 0xC4DB, [17308] = 0xC4DC, [17309] = 0xC4DD, [17310] = 0xC4DE,
  [17311] = 0xC4DF, [17312] = 0xC4E0, [17313] = 0xC4E1, [17314] = 0xC4E2,
  [17315] = 0xC4E3, [17316] = 0xC4E4, [17317] = 0xC4E5, [17318] = 0xC4E6,
  [17319] = 0xC4E7, [17320] = 0xC4E8, [17321] = 0xC4E9, [17322] = 0xC4EA,
  [17323] = 0xC4EB, [17324] = 0xC4EC, [17325] = 0xC4ED, [17326] = 0xC4EE,
  [17327] = 0xC4EF, [17328] = 0xC4F0, [17329] = 0xC4F1, [17330] = 0xC4F2,
  [17331] = 0xC4F3, [17332] = 0xC4F4, [17333] = 0xC4F5, [17334] = 0xC4F6,
  [17335] = 0xC4F7, [17336] = 0xC4F8, [17337] = 0xC4F9, [17338] = 0xC4FA,
  [17339] = 0xC4FB, [17340] = 0xC4FC, [17341] = 0xC4FD, [17342] = 0xC4FE,
  [17408] = 0xC540, [17409] = 0xC541, [17410] = 0xC542, [17411] = 0xC543,
  [17412] = 0xC544, [17413] = 0xC545, [17414] = 0xC546, [17415] = 0xC547,
  [17416] = 0xC548, [17417] = 0xC549, [17418] = 0xC54A, [17419] = 0xC54B,
  [17420] = 0xC54C, [17421] = 0xC54D, [17422] = 0xC54E, [17423] = 0xC54F,
  [17424] = 0xC550, [17425] = 0xC551, [17426] = 0xC552, [17427] = 0xC553,
  [17428] = 0xC554, [17429] = 0xC555, [17430] = 0xC556, [17431] = 0xC557,
  [17432] = 0xC558, [17433] = 0xC559, [17434] = 0xC55A, [17435] = 0xC55B,
  [17436] = 0xC55C, [17437] = 0xC55D, [17438] = 0xC55E, [17439] = 0xC55F,
  [17440] = 0xC560, [17441] = 0xC561, [17442] = 0xC562, [17443] = 0xC563,
  [17444] = 0xC564, [17445] = 0xC565, [17446] = 0xC566, [17447] = 0xC567,
  [17448] = 0xC568, [17449] = 0xC569, [17450] = 0xC56A, [17451] = 0xC56B,
  [17452] = 0xC56C, [17453] = 0xC56D, [17454] = 0xC56E, [17455] = 0xC56F,
  [17456] = 0xC570, [17457] = 0xC571, [17458] = 0xC572, [17459] = 0xC573,
  [17460] = 0xC574, [17461] = 0xC575, [17462] = 0xC576, [17463] = 0xC577,
  [17464] = 0xC578, [17465] = 0xC579, [17466] = 0xC57A, [17467] = 0xC57B,
  [17468] = 0xC57C, [17469] = 0xC57D, [17470] = 0xC57E, [17472] = 0xC580,
  [17473] = 0xC581, [17474] = 0xC582, [17475] = 0xC583, [17476] = 0xC584,
  [17477] = 0xC585, [17478] = 0xC586, [17479] = 0xC587, [17480] = 0xC588,
  [17481] = 0xC589, [17482] = 0xC58A, [17483] = 0xC58B, [17484] = 0xC58C,
  [17485] = 0xC58D, [17486] = 0xC58E, [17487] = 0xC58F, [17488] = 0xC590,
  [17489] = 0xC591, [17490] = 0xC592, [17491] = 0xC593, [17492] = 0xC594,
  [17493] = 0xC595, [17494] = 0xC596, [17495] = 0xC597, [17496] = 0xC598,
  [17497] = 0xC599, [17498] = 0xC59A, [17499] = 0xC59B, [17500] = 0xC59C,
  [17501] = 0xC59D, [17502] = 0xC59E, [17503] = 0xC59F, [17504] = 0xC5A0,
  [17505] = 0xC5A1, [17506] = 0xC5A2, [17507] = 0xC5A3, [17508] = 0xC5A4,
  [17509] = 0xC5A5, [17510] = 0xC5A6, [17511] = 0xC5A7, [17512] = 0xC5A8,
  [17513] = 0xC5A9, [17514] = 0xC5AA, [17515] = 0xC5AB, [17516] = 0xC5AC,
  [17517] = 0xC5AD, [17518] = 0xC5AE, [17519] = 0xC5AF, [17520] = 0xC5B0,
  [17521] = 0xC5B1, [17522] = 0xC5B2, [17523] = 0xC5B3, [17524] = 0xC5B4,
  [17525] = 0xC5B5, [17526] = 0xC5B6, [17527] = 0xC5B7, [17528] = 0xC5B8,
  [17529] = 0xC5B9, [17530] = 0xC5BA, [17531] = 0xC5BB, [17532] = 0xC5BC,
  [17533] = 0xC5BD, [17534] = 0xC5BE, [17535] = 0xC5BF, [17536] = 0xC5C0,
  [17537] = 0xC5C1, [17538] = 0xC5C2, [17539] = 0xC5C3, [17540] = 0xC5C4,
  [17541] = 0xC5C5, [17542] = 0xC5C6, [17543] = 0xC5C7, [17544] = 0xC5C8,
  [17545] = 0xC5C9, [17546] = 0xC5CA, [17547] = 0xC5CB, [17548] = 0xC5CC,
  [17549] = 0xC5CD, [17550] = 0xC5CE, [17551] = 0xC5CF, [17552] = 0xC5D0,
  [17553] = 0xC5D1, [17554] = 0xC5D2, [17555] = 0xC5D3, [17556] = 0xC5D4,
  [17557] = 0xC5D5, [17558] = 0xC5D6, [17559] = 0xC5D7, [17560] = 0xC5D8,
  [17561] = 0xC5D9, [17562] = 0xC5DA, [17563] = 0xC5DB, [17564] = 0xC5DC,
  [17565] = 0xC5DD, [17566] = 0xC5DE, [17567] = 0xC5DF, [17568] = 0xC5E0,
  [17569] = 0xC5E1, [17570] = 0xC5E2, [17571] = 0xC5E3, [17572] = 0xC5E4,
  [17573] = 0xC5E5, [17574] = 0xC5E6, [17575] = 0xC5E7, [17576] = 0xC5E8,
  [17577] = 0xC5E9, [17578] = 0xC5EA, [17579] = 0xC5EB, [17580] = 0xC5EC,
  [17581] = 0xC5ED, [17582] = 0xC5EE, [17583] = 0xC5EF, [17584] = 0xC5F0,
  [17585] = 0xC5F1, [17586] = 0xC5F2, [17587] = 0xC5F3, [17588] = 0xC5F4,
  [17589] = 0xC5F5, [17590] = 0xC5F6, [17591] = 0xC5F7, [17592] = 0xC5F8,
  [17593] = 0xC5F9, [17594] = 0xC5FA, [17595] = 0xC5FB, [17596] = 0xC5FC,
  [17597] = 0xC5FD, [17598] = 0xC5FE, [17664] = 0xC640, [17665] = 0xC641,
  [17666] = 0xC642, [17667] = 0xC643, [17668] = 0xC644, [17669] = 0xC645,
  [17670] = 0xC646, [17671] = 0xC647, [17672] = 0xC648, [17673] = 0xC649,
  [17674] = 0xC64A, [17675] = 0xC64B, [17676] = 0xC64C, [17677] = 0xC64D,
  [17678] = 0xC64E, [17679] = 0xC64F, [17680] = 0xC650, [17681] = 0xC651,
  [17682] = 0xC652, [17683] = 0xC653, [17684] = 0xC654, [17685] = 0xC655,
  [17686] = 0xC656, [17687] = 0xC657, [17688] = 0xC658, [17689] = 0xC659,
  [17690] = 0xC65A, [17691] = 0xC65B, [17692] = 0xC65C, [17693] = 0xC65D,
  [17694] = 0xC65E, [17695] = 0xC65F, [17696] = 0xC660, [17697] = 0xC661,
  [17698] = 0xC662, [17699] = 0xC663, [17700] = 0xC664, [17701] = 0xC665,
  [17702] = 0xC666, [17703] = 0xC667, [17704] = 0xC668, [17705] = 0xC669,
  [17706] = 0xC66A, [17707] = 0xC66B, [17708] = 0xC66C, [17709] = 0xC66D,
  [17710] = 0xC66E, [17711] = 0xC66F, [17712] = 0xC670, [17713] = 0xC671,
  [17714] = 0xC672, [17715] = 0xC673, [17716] = 0xC674, [17717] = 0xC675,
  [17718] = 0xC676, [17719] = 0xC677, [17720] = 0xC678, [17721] = 0xC679,
  [17722] = 0xC67A, [17723] = 0xC67B, [17724] = 0xC67C, [17725] = 0xC67D,
  [17726] = 0xC67E, [17728] = 0xC680, [17729] = 0xC681, [17730] = 0xC682,
  [17731] = 0xC683, [17732] = 0xC684, [17733] = 0xC685, [17734] = 0xC686,
  [17735] = 0xC687, [17736] = 0xC688, [17737] = 0xC689, [17738] = 0xC68A,
  [17739] = 0xC68B, [17740] = 0xC68C, [17741] = 0xC68D, [17742] = 0xC68E,
  [17743] = 0xC68F, [17744] = 0xC690, [17745] = 0xC691, [17746] = 0xC692,
  [17747] = 0xC693, [17748] = 0xC694, [17749] = 0xC695, [17750] = 0xC696,
  [17751] = 0xC697, [17752] = 0xC698, [17753] = 0xC699, [17754] = 0xC69A,
  [17755] = 0xC69B, [17756] = 0xC69C, [17757] = 0xC69D, [17758] = 0xC69E,
  [17759] = 0xC69F, [17760] = 0xC6A0, [17761] = 0xC6A1, [17762] = 0xC6A2,
  [17763] = 0xC6A3, [17764] = 0xC6A4, [17765] = 0xC6A5, [17766] = 0xC6A6,
  [17767] = 0xC6A7, [17768] = 0xC6A8, [17769] = 0xC6A9, [17770] = 0xC6AA,
  [17771] = 0xC6AB, [17772] = 0xC6AC, [17773] = 0xC6AD, [17774] = 0xC6AE,
  [17775] = 0xC6AF, [17776] = 0xC6B0, [17777] = 0xC6B1, [17778] = 0xC6B2,
  [17779] = 0xC6B3, [17780] = 0xC6B4, [17781] = 0xC6B5, [17782] = 0xC6B6,
  [17783] = 0xC6B7, [17784] = 0xC6B8, [17785] = 0xC6B9, [17786] = 0xC6BA,
  [17787] = 0xC6BB, [17788] = 0xC6BC, [17789] = 0xC6BD, [17790] = 0xC6BE,
  [17791] = 0xC6BF, [17792] = 0xC6C0, [17793] = 0xC6C1, [17794] = 0xC6C2,
  [17795] = 0xC6C3, [17796] = 0xC6C4, [17797] = 0xC6C5, [17798] = 0xC6C6,
  [17799] = 0xC6C7, [17800] = 0xC6C8, [17801] = 0xC6C9, [17802] = 0xC6CA,
  [17803] = 0xC6CB, [17804] = 0xC6CC, [17805] = 0xC6CD, [17806] = 0xC6CE,
  [17807] = 0xC6CF, [17808] = 0xC6D0, [17809] = 0xC6D1, [17810] = 0xC6D2,
  [17811] = 0xC6D3, [17812] = 0xC6D4, [17813] = 0xC6D5, [17814] = 0xC6D6,
  [17815] = 0xC6D7, [17816] = 0xC6D8, [17817] = 0xC6D9, [17818] = 0xC6DA,
  [17819] = 0xC6DB, [17820] = 0xC6DC, [17821] = 0xC6DD, [17822] = 0xC6DE,
  [17823] = 0xC6DF, [17824] = 0xC6E0, [17825] = 0xC6E1, [17826] = 0xC6E2,
  [17827] = 0xC6E3, [17828] = 0xC6E4, [17829] = 0xC6E5, [17830] = 0xC6E6,
  [17831] = 0xC6E7, [17832] = 0xC6E8, [17833] = 0xC6E9, [17834] = 0xC6EA,
  [17835] = 0xC6EB, [17836] = 0xC6EC, [17837] = 0xC6ED, [17838] = 0xC6EE,
  [17839] = 0xC6EF, [17840] = 0xC6F0, [17841] = 0xC6F1, [17842] = 0xC6F2,
  [17843] = 0xC6F3, [17844] = 0xC6F4, [17845] = 0xC6F5, [17846] = 0xC6F6,
  [17847] = 0xC6F7, [17848] = 0xC6F8, [17849] = 0xC6F9, [17850] = 0xC6FA,
  [17851] = 0xC6FB, [17852] = 0xC6FC, [17853] = 0xC6FD, [17854] = 0xC6FE,
  [17920] = 0xC740, [17921] = 0xC741, [17922] = 0xC742, [17923] = 0xC743,
  [17924] = 0xC744, [17925] = 0xC745, [17926] = 0xC746, [17927] = 0xC747,
  [17928] = 0xC748, [17929] = 0xC749, [17930] = 0xC74A, [17931] = 0xC74B,
  [17932] = 0xC74C, [17933] = 0xC74D, [17934] = 0xC74E, [17935] = 0xC74F,
  [17936] = 0xC750, [17937] = 0xC751, [17938] = 0xC752, [17939] = 0xC753,
  [17940] = 0xC754, [17941] = 0xC755, [17942] = 0xC756, [17943] = 0xC757,
  [17944] = 0xC758, [17945] = 0xC759, [17946] = 0xC75A, [17947] = 0xC75B,
  [17948] = 0xC75C, [17949] = 0xC75D, [17950] = 0xC75E, [17951] = 0xC75F,
  [17952] = 0xC760, [17953] = 0xC761, [17954] = 0xC762, [17955] = 0xC763,
  [17956] = 0xC764, [17957] = 0xC765, [17958] = 0xC766, [17959] = 0xC767,
  [17960] = 0xC768, [17961] = 0xC769, [17962] = 0xC76A, [17963] = 0xC76B,
  [17964] = 0xC76C, [17965] = 0xC76D, [17966] = 0xC76E, [17967] = 0xC76F,
  [17968] = 0xC770, [17969] = 0xC771, [17970] = 0xC772, [17971] = 0xC773,
  [17972] = 0xC774, [17973] = 0xC775, [17974] = 0xC776, [17975] = 0xC777,
  [17976] = 0xC778, [17977] = 0xC779, [17978] = 0xC77A, [17979] = 0xC77B,
  [17980] = 0xC77C, [17981] = 0xC77D, [17982] = 0xC77E, [17984] = 0xC780,
  [17985] = 0xC781, [17986] = 0xC782, [17987] = 0xC783, [17988] = 0xC784,
  [17989] = 0xC785, [17990] = 0xC786, [17991] = 0xC787, [17992] = 0xC788,
  [17993] = 0xC789, [17994] = 0xC78A, [17995] = 0xC78B, [17996] = 0xC78C,
  [17997] = 0xC78D, [17998] = 0xC78E, [17999] = 0xC78F, [18000] = 0xC790,
  [18001] = 0xC791, [18002] = 0xC792, [18003] = 0xC793, [18004] = 0xC794,
  [18005] = 0xC795, [18006] = 0xC796, [18007] = 0xC797, [18008] = 0xC798,
  [18009] = 0xC799, [18010] = 0xC79A, [18011] = 0xC79B, [18012] = 0xC79C,
  [18013] = 0xC79D, [18014] = 0xC79E, [18015] = 0xC79F, [18016] = 0xC7A0,
  [18017] = 0xC7A1, [18018] = 0xC7A2, [18019] = 0xC7A3, [18020] = 0xC7A4,
  [18021] = 0xC7A5, [18022] = 0xC7A6, [18023] = 0xC7A7, [18024] = 0xC7A8,
  [18025] = 0xC7A9, [18026] = 0xC7AA, [18027] = 0xC7AB, [18028] = 0xC7AC,
  [18029] = 0xC7AD, [18030] = 0xC7AE, [18031] = 0xC7AF, [18032] = 0xC7B0,
  [18033] = 0xC7B1, [18034] = 0xC7B2, [18035] = 0xC7B3, [18036] = 0xC7B4,
  [18037] = 0xC7B5, [18038] = 0xC7B6, [18039] = 0xC7B7, [18040] = 0xC7B8,
  [18041] = 0xC7B9, [18042] = 0xC7BA, [18043] = 0xC7BB, [18044] = 0xC7BC,
  [18045] = 0xC7BD, [18046] = 0xC7BE, [18047] = 0xC7BF, [18048] = 0xC7C0,
  [18049] = 0xC7C1, [18050] = 0xC7C2, [18051] = 0xC7C3, [18052] = 0xC7C4,
  [18053] = 0xC7C5, [18054] = 0xC7C6, [18055] = 0xC7C7, [18056] = 0xC7C8,
  [18057] = 0xC7C9, [18058] = 0xC7CA, [18059] = 0xC7CB, [18060] = 0xC7CC,
  [18061] = 0xC7CD, [18062] = 0xC7CE, [18063] = 0xC7CF, [18064] = 0xC7D0,
  [18065] = 0xC7D1, [18066] = 0xC7D2, [18067] = 0xC7D3, [18068] = 0xC7D4,
  [18069] = 0xC7D5, [18070] = 0xC7D6, [18071] = 0xC7D7, [18072] = 0xC7D8,
  [18073] = 0xC7D9, [18074] = 0xC7DA, [18075] = 0xC7DB, [18076] = 0xC7DC,
  [18077] = 0xC7DD, [18078] = 0xC7DE, [18079] = 0xC7DF, [18080] = 0xC7E0,
  [18081] = 0xC7E1, [18082] = 0xC7E2, [18083] = 0xC7E3, [18084] = 0xC7E4,
  [18085] = 0xC7E5, [18086] = 0xC7E6, [18087] = 0xC7E7, [18088] = 0xC7E8,
  [18089] = 0xC7E9, [18090] = 0xC7EA, [18091] = 0xC7EB, [18092] = 0xC7EC,
  [18093] = 0xC7ED, [18094] = 0xC7EE, [18095] = 0xC7EF, [18096] = 0xC7F0,
  [18097] = 0xC7F1, [18098] = 0xC7F2, [18099] = 0xC7F3, [18100] = 0xC7F4,
  [18101] = 0xC7F5, [18102] = 0xC7F6, [18103] = 0xC7F7, [18104] = 0xC7F8,
  [18105] = 0xC7F9, [18106] = 0xC7FA, [18107] = 0xC7FB, [18108] = 0xC7FC,
  [18109] = 0xC7FD, [18110] = 0xC7FE, [18176] = 0xC840, [18177] = 0xC841,
  [18178] = 0xC842, [18179] = 0xC843, [18180] = 0xC844, [18181] = 0xC845,
  [18182] = 0xC846, [18183] = 0xC847, [18184] = 0xC848, [18185] = 0xC849,
  [18186] = 0xC84A, [18187] = 0xC84B, [18188] = 0xC84C, [18189] = 0xC84D,
  [18190] = 0xC84E, [18191] = 0xC84F, [18192] = 0xC850, [18193] = 0xC851,
  [18194] = 0xC852, [18195] = 0xC853, [18196] = 0xC854, [18197] = 0xC855,
  [18198] = 0xC856, [18199] = 0xC857, [18200] = 0xC858, [18201] = 0xC859,
  [18202] = 0xC85A, [18203] = 0xC85B, [18204] = 0xC85C, [18205] = 0xC85D,
  [18206] = 0xC85E, [18207] = 0xC85F, [18208] = 0xC860, [18209] = 0xC861,
  [18210] = 0xC862, [18211] = 0xC863, [18212] = 0xC864, [18213] = 0xC865,
  [18214] = 0xC866, [18215] = 0xC867, [18216] = 0xC868, [18217] = 0xC869,
  [18218] = 0xC86A, [18219] = 0xC86B, [18220] = 0xC86C, [18221] = 0xC86D,
  [18222] = 0xC86E, [18223] = 0xC86F, [18224] = 0xC870, [18225] = 0xC871,
  [18226] = 0xC872, [18227] = 0xC873, [18228] = 0xC874, [18229] = 0xC875,
  [18230] = 0xC876, [18231] = 0xC877, [18232] = 0xC878, [18233] = 0xC879,
  [18234] = 0xC87A, [18235] = 0xC87B, [18236] = 0xC87C, [18237] = 0xC87D,
  [18238] = 0xC87E, [18240] = 0xC880, [18241] = 0xC881, [18242] = 0xC882,
  [18243] = 0xC883, [18244] = 0xC884, [18245] = 0xC885, [18246] = 0xC886,
  [18247] = 0xC887, [18248] = 0xC888, [18249] = 0xC889, [18250] = 0xC88A,
  [18251] = 0xC88B, [18252] = 0xC88C, [18253] = 0xC88D, [18254] = 0xC88E,
  [18255] = 0xC88F, [18256] = 0xC890, [18257] = 0xC891, [18258] = 0xC892,
  [18259] = 0xC893, [18260] = 0xC894, [18261] = 0xC895, [18262] = 0xC896,
  [18263] = 0xC897, [18264] = 0xC898, [18265] = 0xC899, [18266] = 0xC89A,
  [18267] = 0xC89B, [18268] = 0xC89C, [18269] = 0xC89D, [18270] = 0xC89E,
  [18271] = 0xC89F, [18272] = 0xC8A0, [18273] = 0xC8A1, [18274] = 0xC8A2,
  [18275] = 0xC8A3, [18276] = 0xC8A4, [18277] = 0xC8A5, [18278] = 0xC8A6,
  [18279] = 0xC8A7, [18280] = 0xC8A8, [18281] = 0xC8A9, [18282] = 0xC8AA,
  [18283] = 0xC8AB, [18284] = 0xC8AC, [18285] = 0xC8AD, [18286] = 0xC8AE,
  [18287] = 0xC8AF, [18288] = 0xC8B0, [18289] = 0xC8B1, [18290] = 0xC8B2,
  [18291] = 0xC8B3, [18292] = 0xC8B4, [18293] = 0xC8B5, [18294] = 0xC8B6,
  [18295] = 0xC8B7, [18296] = 0xC8B8, [18297] = 0xC8B9, [18298] = 0xC8BA,
  [18299] = 0xC8BB, [18300] = 0xC8BC, [18301] = 0xC8BD, [18302] = 0xC8BE,
  [18303] = 0xC8BF, [18304] = 0xC8C0, [18305] = 0xC8C1, [18306] = 0xC8C2,
  [18307] = 0xC8C3, [18308] = 0xC8C4, [18309] = 0xC8C5, [18310] = 0xC8C6,
  [18311] = 0xC8C7, [18312] = 0xC8C8, [18313] = 0xC8C9, [18314] = 0xC8CA,
  [18315] = 0xC8CB, [18316] = 0xC8CC, [18317] = 0xC8CD, [18318] = 0xC8CE,
  [18319] = 0xC8CF, [18320] = 0xC8D0, [18321] = 0xC8D1, [18322] = 0xC8D2,
  [18323] = 0xC8D3, [18324] = 0xC8D4, [18325] = 0xC8D5, [18326] = 0xC8D6,
  [18327] = 0xC8D7, [18328] = 0xC8D8, [18329] = 0xC8D9, [18330] = 0xC8DA,
  [18331] = 0xC8DB, [18332] = 0xC8DC, [18333] = 0xC8DD, [18334] = 0xC8DE,
  [18335] = 0xC8DF, [18336] = 0xC8E0, [18337] = 0xC8E1, [18338] = 0xC8E2,
  [18339] = 0xC8E3, [18340] = 0xC8E4, [18341] = 0xC8E5, [18342] = 0xC8E6,
  [18343] = 0xC8E7, [18344] = 0xC8E8, [18345] = 0xC8E9, [18346] = 0xC8EA,
  [18347] = 0xC8EB, [18348] = 0xC8EC, [18349] = 0xC8ED, [18350] = 0xC8EE,
  [18351] = 0xC8EF, [18352] = 0xC8F0, [18353] = 0xC8F1, [18354] = 0xC8F2,
  [18355] = 0xC8F3, [18356] = 0xC8F4, [18357] = 0xC8F5, [18358] = 0xC8F6,
  [18359] = 0xC8F7, [18360] = 0xC8F8, [18361] = 0xC8F9, [18362] = 0xC8FA,
  [18363] = 0xC8FB, [18364] = 0xC8FC, [18365] = 0xC8FD, [18366] = 0xC8FE,
  [18432] = 0xC940, [18433] = 0xC941, [18434] = 0xC942, [18435] = 0xC943,
  [18436] = 0xC944, [18437] = 0xC945, [18438] = 0xC946, [18439] = 0xC947,
  [18440] = 0xC948, [18441] = 0xC949, [18442] = 0xC94A, [18443] = 0xC94B,
  [18444] = 0xC94C, [18445] = 0xC94D, [18446] = 0xC94E, [18447] = 0xC94F,
  [18448] = 0xC950, [18449] = 0xC951, [18450] = 0xC952, [18451] = 0xC953,
  [18452] = 0xC954, [18453] = 0xC955, [18454] = 0xC956, [18455] = 0xC957,
  [18456] = 0xC958, [18457] = 0xC959, [18458] = 0xC95A, [18459] = 0xC95B,
  [18460] = 0xC95C, [18461] = 0xC95D, [18462] = 0xC95E, [18463] = 0xC95F,
  [18464] = 0xC960, [18465] = 0xC961, [18466] = 0xC962, [18467] = 0xC963,
  [18468] = 0xC964, [18469] = 0xC965, [18470] = 0xC966, [18471] = 0xC967,
  [18472] = 0xC968, [18473] = 0xC969, [18474] = 0xC96A, [18475] = 0xC96B,
  [18476] = 0xC96C, [18477] = 0xC96D, [18478] = 0xC96E, [18479] = 0xC96F,
  [18480] = 0xC970, [18481] = 0xC971, [18482] = 0xC972, [18483] = 0xC973,
  [18484] = 0xC974, [18485] = 0xC975, [18486] = 0xC976, [18487] = 0xC977,
  [18488] = 0xC978, [18489] = 0xC979, [18490] = 0xC97A, [18491] = 0xC97B,
  [18492] = 0xC97C, [18493] = 0xC97D, [18494] = 0xC97E, [18496] = 0xC980,
  [18497] = 0xC981, [18498] = 0xC982, [18499] = 0xC983, [18500] = 0xC984,
  [18501] = 0xC985, [18502] = 0xC986, [18503] = 0xC987, [18504] = 0xC988,
  [18505] = 0xC989, [18506] = 0xC98A, [18507] = 0xC98B, [18508] = 0xC98C,
  [18509] = 0xC98D, [18510] = 0xC98E, [18511] = 0xC98F, [18512] = 0xC990,
  [18513] = 0xC991, [18514] = 0xC992, [18515] = 0xC993, [18516] = 0xC994,
  [18517] = 0xC995, [18518] = 0xC996, [18519] = 0xC997, [18520] = 0xC998,
  [18521] = 0xC999, [18522] = 0xC99A, [18523] = 0xC99B, [18524] = 0xC99C,
  [18525] = 0xC99D, [18526] = 0xC99E, [18527] = 0xC99F, [18528] = 0xC9A0,
  [18529] = 0xC9A1, [18530] = 0xC9A2, [18531] = 0xC9A3, [18532] = 0xC9A4,
  [18533] = 0xC9A5, [18534] = 0xC9A6, [18535] = 0xC9A7, [18536] = 0xC9A8,
  [18537] = 0xC9A9, [18538] = 0xC9AA, [18539] = 0xC9AB, [18540] = 0xC9AC,
  [18541] = 0xC9AD, [18542] = 0xC9AE, [18543] = 0xC9AF, [18544] = 0xC9B0,
  [18545] = 0xC9B1, [18546] = 0xC9B2, [18547] = 0xC9B3, [18548] = 0xC9B4,
  [18549] = 0xC9B5, [18550] = 0xC9B6, [18551] = 0xC9B7, [18552] = 0xC9B8,
  [18553] = 0xC9B9, [18554] = 0xC9BA, [18555] = 0xC9BB, [18556] = 0xC9BC,
  [18557] = 0xC9BD, [18558] = 0xC9BE, [18559] = 0xC9BF, [18560] = 0xC9C0,
  [18561] = 0xC9C1, [18562] = 0xC9C2, [18563] = 0xC9C3, [18564] = 0xC9C4,
  [18565] = 0xC9C5, [18566] = 0xC9C6, [18567] = 0xC9C7, [18568] = 0xC9C8,
  [18569] = 0xC9C9, [18570] = 0xC9CA, [18571] = 0xC9CB, [18572] = 0xC9CC,
  [18573] = 0xC9CD, [18574] = 0xC9CE, [18575] = 0xC9CF, [18576] = 0xC9D0,
  [18577] = 0xC9D1, [18578] = 0xC9D2, [18579] = 0xC9D3, [18580] = 0xC9D4,
  [18581] = 0xC9D5, [18582] = 0xC9D6, [18583] = 0xC9D7, [18584] = 0xC9D8,
  [18585] = 0xC9D9, [18586] = 0xC9DA, [18587] = 0xC9DB, [18588] = 0xC9DC,
  [18589] = 0xC9DD, [18590] = 0xC9DE, [18591] = 0xC9DF, [18592] = 0xC9E0,
  [18593] = 0xC9E1, [18594] = 0xC9E2, [18595] = 0xC9E3, [18596] = 0xC9E4,
  [18597] = 0xC9E5, [18598] = 0xC9E6, [18599] = 0xC9E7, [18600] = 0xC9E8,
  [18601] = 0xC9E9, [18602] = 0xC9EA, [18603] = 0xC9EB, [18604] = 0xC9EC,
  [18605] = 0xC9ED, [18606] = 0xC9EE, [18607] = 0xC9EF, [18608] = 0xC9F0,
  [18609] = 0xC9F1, [18610] = 0xC9F2, [18611] = 0xC9F3, [18612] = 0xC9F4,
  [18613] = 0xC9F5, [18614] = 0xC9F6, [18615] = 0xC9F7, [18616] = 0xC9F8,
  [18617] = 0xC9F9, [18618] = 0xC9FA, [18619] = 0xC9FB, [18620] = 0xC9FC,
  [18621] = 0xC9FD, [18622] = 0xC9FE, [18688] = 0xCA40, [18689] = 0xCA41,
  [18690] = 0xCA42, [18691] = 0xCA43, [18692] = 0xCA44, [18693] = 0xCA45,
  [18694] = 0xCA46, [18695] = 0xCA47, [18696] = 0xCA48, [18697] = 0xCA49,
  [18698] = 0xCA4A, [18699] = 0xCA4B, [18700] = 0xCA4C, [18701] = 0xCA4D,
  [18702] = 0xCA4E, [18703] = 0xCA4F, [18704] = 0xCA50, [18705] = 0xCA51,
  [18706] = 0xCA52, [18707] = 0xCA53, [18708] = 0xCA54, [18709] = 0xCA55,
  [18710] = 0xCA56, [18711] = 0xCA57, [18712] = 0xCA58, [18713] = 0xCA59,
  [18714] = 0xCA5A, [18715] = 0xCA5B, [18716] = 0xCA5C, [18717] = 0xCA5D,
  [18718] = 0xCA5E, [18719] = 0xCA5F, [18720] = 0xCA60, [18721] = 0xCA61,
  [18722] = 0xCA62, [18723] = 0xCA63, [18724] = 0xCA64, [18725] = 0xCA65,
  [18726] = 0xCA66, [18727] = 0xCA67, [18728] = 0xCA68, [18729] = 0xCA69,
  [18730] = 0xCA6A, [18731] = 0xCA6B, [18732] = 0xCA6C, [18733] = 0xCA6D,
  [18734] = 0xCA6E, [18735] = 0xCA6F, [18736] = 0xCA70, [18737] = 0xCA71,
  [18738] = 0xCA72, [18739] = 0xCA73, [18740] = 0xCA74, [18741] = 0xCA75,
  [18742] = 0xCA76, [18743] = 0xCA77, [18744] = 0xCA78, [18745] = 0xCA79,
  [18746] = 0xCA7A, [18747] = 0xCA7B, [18748] = 0xCA7C, [18749] = 0xCA7D,
  [18750] = 0xCA7E, [18752] = 0xCA80, [18753] = 0xCA81, [18754] = 0xCA82,
  [18755] = 0xCA83, [18756] = 0xCA84, [18757] = 0xCA85, [18758] = 0xCA86,
  [18759] = 0xCA87, [18760] = 0xCA88, [18761] = 0xCA89, [18762] = 0xCA8A,
  [18763] = 0xCA8B, [18764] = 0xCA8C, [18765] = 0xCA8D, [18766] = 0xCA8E,
  [18767] = 0xCA8F, [18768] = 0xCA90, [18769] = 0xCA91, [18770] = 0xCA92,
  [18771] = 0xCA93, [18772] = 0xCA94, [18773] = 0xCA95, [18774] = 0xCA96,
  [18775] = 0xCA97, [18776] = 0xCA98, [18777] = 0xCA99, [18778] = 0xCA9A,
  [18779] = 0xCA9B, [18780] = 0xCA9C, [18781] = 0xCA9D, [18782] = 0xCA9E,
  [18783] = 0xCA9F, [18784] = 0xCAA0, [18785] = 0xCAA1, [18786] = 0xCAA2,
  [18787] = 0xCAA3, [18788] = 0xCAA4, [18789] = 0xCAA5, [18790] = 0xCAA6,
  [18791] = 0xCAA7, [18792] = 0xCAA8, [18793] = 0xCAA9, [18794] = 0xCAAA,
  [18795] = 0xCAAB, [18796] = 0xCAAC, [18797] = 0xCAAD, [18798] = 0xCAAE,
  [18799] = 0xCAAF, [18800] = 0xCAB0, [18801] = 0xCAB1, [18802] = 0xCAB2,
  [18803] = 0xCAB3, [18804] = 0xCAB4, [18805] = 0xCAB5, [18806] = 0xCAB6,
  [18807] = 0xCAB7, [18808] = 0xCAB8, [18809] = 0xCAB9, [18810] = 0xCABA,
  [18811] = 0xCABB, [18812] = 0xCABC, [18813] = 0xCABD, [18814] = 0xCABE,
  [18815] = 0xCABF, [18816] = 0xCAC0, [18817] = 0xCAC1, [18818] = 0xCAC2,
  [18819] = 0xCAC3, [18820] = 0xCAC4, [18821] = 0xCAC5, [18822] = 0xCAC6,
  [18823] = 0xCAC7, [18824] = 0xCAC8, [18825] = 0xCAC9, [18826] = 0xCACA,
  [18827] = 0xCACB, [18828] = 0xCACC, [18829] = 0xCACD, [18830] = 0xCACE,
  [18831] = 0xCACF, [18832] = 0xCAD0, [18833] = 0xCAD1, [18834] = 0xCAD2,
  [18835] = 0xCAD3, [18836] = 0xCAD4, [18837] = 0xCAD5, [18838] = 0xCAD6,
  [18839] = 0xCAD7, [18840] = 0xCAD8, [18841] = 0xCAD9, [18842] = 0xCADA,
  [18843] = 0xCADB, [18844] = 0xCADC, [18845] = 0xCADD, [18846] = 0xCADE,
  [18847] = 0xCADF, [18848] = 0xCAE0, [18849] = 0xCAE1, [18850] = 0xCAE2,
  [18851] = 0xCAE3, [18852] = 0xCAE4, [18853] = 0xCAE5, [18854] = 0xCAE6,
  [18855] = 0xCAE7, [18856] = 0xCAE8, [18857] = 0xCAE9, [18858] = 0xCAEA,
  [18859] = 0xCAEB, [18860] = 0xCAEC, [18861] = 0xCAED, [18862] = 0xCAEE,
  [18863] = 0xCAEF, [18864] = 0xCAF0, [18865] = 0xCAF1, [18866] = 0xCAF2,
  [18867] = 0xCAF3, [18868] = 0xCAF4, [18869] = 0xCAF5, [18870] = 0xCAF6,
  [18871] = 0xCAF7, [18872] = 0xCAF8, [18873] = 0xCAF9, [18874] = 0xCAFA,
  [18875] = 0xCAFB, [18876] = 0xCAFC, [18877] = 0xCAFD, [18878] = 0xCAFE,
  [18944] = 0xCB40, [18945] = 0xCB41, [18946] = 0xCB42, [18947] = 0xCB43,
  [18948] = 0xCB44, [18949] = 0xCB45, [18950] = 0xCB46, [18951] = 0xCB47,
  [18952] = 0xCB48, [18953] = 0xCB49, [18954] = 0xCB4A, [18955] = 0xCB4B,
  [18956] = 0xCB4C, [18957] = 0xCB4D, [18958] = 0xCB4E, [18959] = 0xCB4F,
  [18960] = 0xCB50, [18961] = 0xCB51, [18962] = 0xCB52, [18963] = 0xCB53,
  [18964] = 0xCB54, [18965] = 0xCB55, [18966] = 0xCB56, [18967] = 0xCB57,
  [18968] = 0xCB58, [18969] = 0xCB59, [18970] = 0xCB5A, [18971] = 0xCB5B,
  [18972] = 0xCB5C, [18973] = 0xCB5D, [18974] = 0xCB5E, [18975] = 0xCB5F,
  [18976] = 0xCB60, [18977] = 0xCB61, [18978] = 0xCB62, [18979] = 0xCB63,
  [18980] = 0xCB64, [18981] = 0xCB65, [18982] = 0xCB66, [18983] = 0xCB67,
  [18984] = 0xCB68, [18985] = 0xCB69, [18986] = 0xCB6A, [18987] = 0xCB6B,
  [18988] = 0xCB6C, [18989] = 0xCB6D, [18990] = 0xCB6E, [18991] = 0xCB6F,
  [18992] = 0xCB70, [18993] = 0xCB71, [18994] = 0xCB72, [18995] = 0xCB73,
  [18996] = 0xCB74, [18997] = 0xCB75, [18998] = 0xCB76, [18999] = 0xCB77,
  [19000] = 0xCB78, [19001] = 0xCB79, [19002] = 0xCB7A, [19003] = 0xCB7B,
  [19004] = 0xCB7C, [19005] = 0xCB7D, [19006] = 0xCB7E, [19008] = 0xCB80,
  [19009] = 0xCB81, [19010] = 0xCB82, [19011] = 0xCB83, [19012] = 0xCB84,
  [19013] = 0xCB85, [19014] = 0xCB86, [19015] = 0xCB87, [19016] = 0xCB88,
  [19017] = 0xCB89, [19018] = 0xCB8A, [19019] = 0xCB8B, [19020] = 0xCB8C,
  [19021] = 0xCB8D, [19022] = 0xCB8E, [19023] = 0xCB8F, [19024] = 0xCB90,
  [19025] = 0xCB91, [19026] = 0xCB92, [19027] = 0xCB93, [19028] = 0xCB94,
  [19029] = 0xCB95, [19030] = 0xCB96, [19031] = 0xCB97, [19032] = 0xCB98,
  [19033] = 0xCB99, [19034] = 0xCB9A, [19035] = 0xCB9B, [19036] = 0xCB9C,
  [19037] = 0xCB9D, [19038] = 0xCB9E, [19039] = 0xCB9F, [19040] = 0xCBA0,
  [19041] = 0xCBA1, [19042] = 0xCBA2, [19043] = 0xCBA3, [19044] = 0xCBA4,
  [19045] = 0xCBA5, [19046] = 0xCBA6, [19047] = 0xCBA7, [19048] = 0xCBA8,
  [19049] = 0xCBA9, [19050] = 0xCBAA, [19051] = 0xCBAB, [19052] = 0xCBAC,
  [19053] = 0xCBAD, [19054] = 0xCBAE, [19055] = 0xCBAF, [19056] = 0xCBB0,
  [19057] = 0xCBB1, [19058] = 0xCBB2, [19059] = 0xCBB3, [19060] = 0xCBB4,
  [19061] = 0xCBB5, [19062] = 0xCBB6, [19063] = 0xCBB7, [19064] = 0xCBB8,
  [19065] = 0xCBB9, [19066] = 0xCBBA, [19067] = 0xCBBB, [19068] = 0xCBBC,
  [19069] = 0xCBBD, [19070] = 0xCBBE, [19071] = 0xCBBF, [19072] = 0xCBC0,
  [19073] = 0xCBC1, [19074] = 0xCBC2, [19075] = 0xCBC3, [19076] = 0xCBC4,
  [19077] = 0xCBC5, [19078] = 0xCBC6, [19079] = 0xCBC7, [19080] = 0xCBC8,
  [19081] = 0xCBC9, [19082] = 0xCBCA, [19083] = 0xCBCB, [19084] = 0xCBCC,
  [19085] = 0xCBCD, [19086] = 0xCBCE, [19087] = 0xCBCF, [19088] = 0xCBD0,
  [19089] = 0xCBD1, [19090] = 0xCBD2, [19091] = 0xCBD3, [19092] = 0xCBD4,
  [19093] = 0xCBD5, [19094] = 0xCBD6, [19095] = 0xCBD7, [19096] = 0xCBD8,
  [19097] = 0xCBD9, [19098] = 0xCBDA, [19099] = 0xCBDB, [19100] = 0xCBDC,
  [19101] = 0xCBDD, [19102] = 0xCBDE, [19103] = 0xCBDF, [19104] = 0xCBE0,
  [19105] = 0xCBE1, [19106] = 0xCBE2, [19107] = 0xCBE3, [19108] = 0xCBE4,
  [19109] = 0xCBE5, [19110] = 0xCBE6, [19111] = 0xCBE7, [19112] = 0xCBE8,
  [19113] = 0xCBE9, [19114] = 0xCBEA, [19115] = 0xCBEB, [19116] = 0xCBEC,
  [19117] = 0xCBED, [19118] = 0xCBEE, [19119] = 0xCBEF, [19120] = 0xCBF0,
  [19121] = 0xCBF1, [19122] = 0xCBF2, [19123] = 0xCBF3, [19124] = 0xCBF4,
  [19125] = 0xCBF5, [19126] = 0xCBF6, [19127] = 0xCBF7, [19128] = 0xCBF8,
  [19129] = 0xCBF9, [19130] = 0xCBFA, [19131] = 0xCBFB, [19132] = 0xCBFC,
  [19133] = 0xCBFD, [19134] = 0xCBFE, [19200] = 0xCC40, [19201] = 0xCC41,
  [19202] = 0xCC42, [19203] = 0xCC43, [19204] = 0xCC44, [19205] = 0xCC45,
  [19206] = 0xCC46, [19207] = 0xCC47, [19208] = 0xCC48, [19209] = 0xCC49,
  [19210] = 0xCC4A, [19211] = 0xCC4B, [19212] = 0xCC4C, [19213] = 0xCC4D,
  [19214] = 0xCC4E, [19215] = 0xCC4F, [19216] = 0xCC50, [19217] = 0xCC51,
  [19218] = 0xCC52, [19219] = 0xCC53, [19220] = 0xCC54, [19221] = 0xCC55,
  [19222] = 0xCC56, [19223] = 0xCC57, [19224] = 0xCC58, [19225] = 0xCC59,
  [19226] = 0xCC5A, [19227] = 0xCC5B, [19228] = 0xCC5C, [19229] = 0xCC5D,
  [19230] = 0xCC5E, [19231] = 0xCC5F, [19232] = 0xCC60, [19233] = 0xCC61,
  [19234] = 0xCC62, [19235] = 0xCC63, [19236] = 0xCC64, [19237] = 0xCC65,
  [19238] = 0xCC66, [19239] = 0xCC67, [19240] = 0xCC68, [19241] = 0xCC69,
  [19242] = 0xCC6A, [19243] = 0xCC6B, [19244] = 0xCC6C, [19245] = 0xCC6D,
  [19246] = 0xCC6E, [19247] = 0xCC6F, [19248] = 0xCC70, [19249] = 0xCC71,
  [19250] = 0xCC72, [19251] = 0xCC73, [19252] = 0xCC74, [19253] = 0xCC75,
  [19254] = 0xCC76, [19255] = 0xCC77, [19256] = 0xCC78, [19257] = 0xCC79,
  [19258] = 0xCC7A, [19259] = 0xCC7B, [19260] = 0xCC7C, [19261] = 0xCC7D,
  [19262] = 0xCC7E, [19264] = 0xCC80, [19265] = 0xCC81, [19266] = 0xCC82,
  [19267] = 0xCC83, [19268] = 0xCC84, [19269] = 0xCC85, [19270] = 0xCC86,
  [19271] = 0xCC87, [19272] = 0xCC88, [19273] = 0xCC89, [19274] = 0xCC8A,
  [19275] = 0xCC8B, [19276] = 0xCC8C, [19277] = 0xCC8D, [19278] = 0xCC8E,
  [19279] = 0xCC8F, [19280] = 0xCC90, [19281] = 0xCC91, [19282] = 0xCC92,
  [19283] = 0xCC93, [19284] = 0xCC94, [19285] = 0xCC95, [19286] = 0xCC96,
  [19287] = 0xCC97, [19288] = 0xCC98, [19289] = 0xCC99, [19290] = 0xCC9A,
  [19291] = 0xCC9B, [19292] = 0xCC9C, [19293] = 0xCC9D, [19294] = 0xCC9E,
  [19295] = 0xCC9F, [19296] = 0xCCA0, [19297] = 0xCCA1, [19298] = 0xCCA2,
  [19299] = 0xCCA3, [19300] = 0xCCA4, [19301] = 0xCCA5, [19302] = 0xCCA6,
  [19303] = 0xCCA7, [19304] = 0xCCA8, [19305] = 0xCCA9, [19306] = 0xCCAA,
  [19307] = 0xCCAB, [19308] = 0xCCAC, [19309] = 0xCCAD, [19310] = 0xCCAE,
  [19311] = 0xCCAF, [19312] = 0xCCB0, [19313] = 0xCCB1, [19314] = 0xCCB2,
  [19315] = 0xCCB3, [19316] = 0xCCB4, [19317] = 0xCCB5, [19318] = 0xCCB6,
  [19319] = 0xCCB7, [19320] = 0xCCB8, [19321] = 0xCCB9, [19322] = 0xCCBA,
  [19323] = 0xCCBB, [19324] = 0xCCBC, [19325] = 0xCCBD, [19326] = 0xCCBE,
  [19327] = 0xCCBF, [19328] = 0xCCC0, [19329] = 0xCCC1, [19330] = 0xCCC2,
  [19331] = 0xCCC3, [19332] = 0xCCC4, [19333] = 0xCCC5, [19334] = 0xCCC6,
  [19335] = 0xCCC7, [19336] = 0xCCC8, [19337] = 0xCCC9, [19338] = 0xCCCA,
  [19339] = 0xCCCB, [19340] = 0xCCCC, [19341] = 0xCCCD, [19342] = 0xCCCE,
  [19343] = 0xCCCF, [19344] = 0xCCD0, [19345] = 0xCCD1, [19346] = 0xCCD2,
  [19347] = 0xCCD3, [19348] = 0xCCD4, [19349] = 0xCCD5, [19350] = 0xCCD6,
  [19351] = 0xCCD7, [19352] = 0xCCD8, [19353] = 0xCCD9, [19354] = 0xCCDA,
  [19355] = 0xCCDB, [19356] = 0xCCDC, [19357] = 0xCCDD, [19358] = 0xCCDE,
  [19359] = 0xCCDF, [19360] = 0xCCE0, [19361] = 0xCCE1, [19362] = 0xCCE2,
  [19363] = 0xCCE3, [19364] = 0xCCE4, [19365] = 0xCCE5, [19366] = 0xCCE6,
  [19367] = 0xCCE7, [19368] = 0xCCE8, [19369] = 0xCCE9, [19370] = 0xCCEA,
  [19371] = 0xCCEB, [19372] = 0xCCEC, [19373] = 0xCCED, [19374] = 0xCCEE,
  [19375] = 0xCCEF, [19376] = 0xCCF0, [19377] = 0xCCF1, [19378] = 0xCCF2,
  [19379] = 0xCCF3, [19380] = 0xCCF4, [19381] = 0xCCF5, [19382] = 0xCCF6,
  [19383] = 0xCCF7, [19384] = 0xCCF8, [19385] = 0xCCF9, [19386] = 0xCCFA,
  [19387] = 0xCCFB, [19388] = 0xCCFC, [19389] = 0xCCFD, [19390] = 0xCCFE,
  [19456] = 0xCD40, [19457] = 0xCD41, [19458] = 0xCD42, [19459] = 0xCD43,
  [19460] = 0xCD44, [19461] = 0xCD45, [19462] = 0xCD46, [19463] = 0xCD47,
  [19464] = 0xCD48, [19465] = 0xCD49, [19466] = 0xCD4A, [19467] = 0xCD4B,
  [19468] = 0xCD4C, [19469] = 0xCD4D, [19470] = 0xCD4E, [19471] = 0xCD4F,
  [19472] = 0xCD50, [19473] = 0xCD51, [19474] = 0xCD52, [19475] = 0xCD53,
  [19476] = 0xCD54, [19477] = 0xCD55, [19478] = 0xCD56, [19479] = 0xCD57,
  [19480] = 0xCD58, [19481] = 0xCD59, [19482] = 0xCD5A, [19483] = 0xCD5B,
  [19484] = 0xCD5C, [19485] = 0xCD5D, [19486] = 0xCD5E, [19487] = 0xCD5F,
  [19488] = 0xCD60, [19489] = 0xCD61, [19490] = 0xCD62, [19491] = 0xCD63,
  [19492] = 0xCD64, [19493] = 0xCD65, [19494] = 0xCD66, [19495] = 0xCD67,
  [19496] = 0xCD68, [19497] = 0xCD69, [19498] = 0xCD6A, [19499] = 0xCD6B,
  [19500] = 0xCD6C, [19501] = 0xCD6D, [19502] = 0xCD6E, [19503] = 0xCD6F,
  [19504] = 0xCD70, [19505] = 0xCD71, [19506] = 0xCD72, [19507] = 0xCD73,
  [19508] = 0xCD74, [19509] = 0xCD75, [19510] = 0xCD76, [19511] = 0xCD77,
  [19512] = 0xCD78, [19513] = 0xCD79, [19514] = 0xCD7A, [19515] = 0xCD7B,
  [19516] = 0xCD7C, [19517] = 0xCD7D, [19518] = 0xCD7E, [19520] = 0xCD80,
  [19521] = 0xCD81, [19522] = 0xCD82, [19523] = 0xCD83, [19524] = 0xCD84,
  [19525] = 0xCD85, [19526] = 0xCD86, [19527] = 0xCD87, [19528] = 0xCD88,
  [19529] = 0xCD89, [19530] = 0xCD8A, [19531] = 0xCD8B, [19532] = 0xCD8C,
  [19533] = 0xCD8D, [19534] = 0xCD8E, [19535] = 0xCD8F, [19536] = 0xCD90,
  [19537] = 0xCD91, [19538] = 0xCD92, [19539] = 0xCD93, [19540] = 0xCD94,
  [19541] = 0xCD95, [19542] = 0xCD96, [19543] = 0xCD97, [19544] = 0xCD98,
  [19545] = 0xCD99, [19546] = 0xCD9A, [19547] = 0xCD9B, [19548] = 0xCD9C,
  [19549] = 0xCD9D, [19550] = 0xCD9E, [19551] = 0xCD9F, [19552] = 0xCDA0,
  [19553] = 0xCDA1, [19554] = 0xCDA2, [19555] = 0xCDA3, [19556] = 0xCDA4,
  [19557] = 0xCDA5, [19558] = 0xCDA6, [19559] = 0xCDA7, [19560] = 0xCDA8,
  [19561] = 0xCDA9, [19562] = 0xCDAA, [19563] = 0xCDAB, [19564] = 0xCDAC,
  [19565] = 0xCDAD, [19566] = 0xCDAE, [19567] = 0xCDAF, [19568] = 0xCDB0,
  [19569] = 0xCDB1, [19570] = 0xCDB2, [19571] = 0xCDB3, [19572] = 0xCDB4,
  [19573] = 0xCDB5, [19574] = 0xCDB6, [19575] = 0xCDB7, [19576] = 0xCDB8,
  [19577] = 0xCDB9, [19578] = 0xCDBA, [19579] = 0xCDBB, [19580] = 0xCDBC,
  [19581] = 0xCDBD, [19582] = 0xCDBE, [19583] = 0xCDBF, [19584] = 0xCDC0,
  [19585] = 0xCDC1, [19586] = 0xCDC2, [19587] = 0xCDC3, [19588] = 0xCDC4,
  [19589] = 0xCDC5, [19590] = 0xCDC6, [19591] = 0xCDC7, [19592] = 0xCDC8,
  [19593] = 0xCDC9, [19594] = 0xCDCA, [19595] = 0xCDCB, [19596] = 0xCDCC,
  [19597] = 0xCDCD, [19598] = 0xCDCE, [19599] = 0xCDCF, [19600] = 0xCDD0,
  [19601] = 0xCDD1, [19602] = 0xCDD2, [19603] = 0xCDD3, [19604] = 0xCDD4,
  [19605] = 0xCDD5, [19606] = 0xCDD6, [19607] = 0xCDD7, [19608] = 0xCDD8,
  [19609] = 0xCDD9, [19610] = 0xCDDA, [19611] = 0xCDDB, [19612] = 0xCDDC,
  [19613] = 0xCDDD, [19614] = 0xCDDE, [19615] = 0xCDDF, [19616] = 0xCDE0,
  [19617] = 0xCDE1, [19618] = 0xCDE2, [19619] = 0xCDE3, [19620] = 0xCDE4,
  [19621] = 0xCDE5, [19622] = 0xCDE6, [19623] = 0xCDE7, [19624] = 0xCDE8,
  [19625] = 0xCDE9, [19626] = 0xCDEA, [19627] = 0xCDEB, [19628] = 0xCDEC,
  [19629] = 0xCDED, [19630] = 0xCDEE, [19631] = 0xCDEF, [19632] = 0xCDF0,
  [19633] = 0xCDF1, [19634] = 0xCDF2, [19635] = 0xCDF3, [19636] = 0xCDF4,
  [19637] = 0xCDF5, [19638] = 0xCDF6, [19639] = 0xCDF7, [19640] = 0xCDF8,
  [19641] = 0xCDF9, [19642] = 0xCDFA, [19643] = 0xCDFB, [19644] = 0xCDFC,
  [19645] = 0xCDFD, [19646] = 0xCDFE, [19712] = 0xCE40, [19713] = 0xCE41,
  [19714] = 0xCE42, [19715] = 0xCE43, [19716] = 0xCE44, [19717] = 0xCE45,
  [19718] = 0xCE46, [19719] = 0xCE47, [19720] = 0xCE48, [19721] = 0xCE49,
  [19722] = 0xCE4A, [19723] = 0xCE4B, [19724] = 0xCE4C, [19725] = 0xCE4D,
  [19726] = 0xCE4E, [19727] = 0xCE4F, [19728] = 0xCE50, [19729] = 0xCE51,
  [19730] = 0xCE52, [19731] = 0xCE53, [19732] = 0xCE54, [19733] = 0xCE55,
  [19734] = 0xCE56, [19735] = 0xCE57, [19736] = 0xCE58, [19737] = 0xCE59,
  [19738] = 0xCE5A, [19739] = 0xCE5B, [19740] = 0xCE5C, [19741] = 0xCE5D,
  [19742] = 0xCE5E, [19743] = 0xCE5F, [19744] = 0xCE60, [19745] = 0xCE61,
  [19746] = 0xCE62, [19747] = 0xCE63, [19748] = 0xCE64, [19749] = 0xCE65,
  [19750] = 0xCE66, [19751] = 0xCE67, [19752] = 0xCE68, [19753] = 0xCE69,
  [19754] = 0xCE6A, [19755] = 0xCE6B, [19756] = 0xCE6C, [19757] = 0xCE6D,
  [19758] = 0xCE6E, [19759] = 0xCE6F, [19760] = 0xCE70, [19761] = 0xCE71,
  [19762] = 0xCE72, [19763] = 0xCE73, [19764] = 0xCE74, [19765] = 0xCE75,
  [19766] = 0xCE76, [19767] = 0xCE77, [19768] = 0xCE78, [19769] = 0xCE79,
  [19770] = 0xCE7A, [19771] = 0xCE7B, [19772] = 0xCE7C, [19773] = 0xCE7D,
  [19774] = 0xCE7E, [19776] = 0xCE80, [19777] = 0xCE81, [19778] = 0xCE82,
  [19779] = 0xCE83, [19780] = 0xCE84, [19781] = 0xCE85, [19782] = 0xCE86,
  [19783] = 0xCE87, [19784] = 0xCE88, [19785] = 0xCE89, [19786] = 0xCE8A,
  [19787] = 0xCE8B, [19788] = 0xCE8C, [19789] = 0xCE8D, [19790] = 0xCE8E,
  [19791] = 0xCE8F, [19792] = 0xCE90, [19793] = 0xCE91, [19794] = 0xCE92,
  [19795] = 0xCE93, [19796] = 0xCE94, [19797] = 0xCE95, [19798] = 0xCE96,
  [19799] = 0xCE97, [19800] = 0xCE98, [19801] = 0xCE99, [19802] = 0xCE9A,
  [19803] = 0xCE9B, [19804] = 0xCE9C, [19805] = 0xCE9D, [19806] = 0xCE9E,
  [19807] = 0xCE9F, [19808] = 0xCEA0, [19809] = 0xCEA1, [19810] = 0xCEA2,
  [19811] = 0xCEA3, [19812] = 0xCEA4, [19813] = 0xCEA5, [19814] = 0xCEA6,
  [19815] = 0xCEA7, [19816] = 0xCEA8, [19817] = 0xCEA9, [19818] = 0xCEAA,
  [19819] = 0xCEAB, [19820] = 0xCEAC, [19821] = 0xCEAD, [19822] = 0xCEAE,
  [19823] = 0xCEAF, [19824] = 0xCEB0, [19825] = 0xCEB1, [19826] = 0xCEB2,
  [19827] = 0xCEB3, [19828] = 0xCEB4, [19829] = 0xCEB5, [19830] = 0xCEB6,
  [19831] = 0xCEB7, [19832] = 0xCEB8, [19833] = 0xCEB9, [19834] = 0xCEBA,
  [19835] = 0xCEBB, [19836] = 0xCEBC, [19837] = 0xCEBD, [19838] = 0xCEBE,
  [19839] = 0xCEBF, [19840] = 0xCEC0, [19841] = 0xCEC1, [19842] = 0xCEC2,
  [19843] = 0xCEC3, [19844] = 0xCEC4, [19845] = 0xCEC5, [19846] = 0xCEC6,
  [19847] = 0xCEC7, [19848] = 0xCEC8, [19849] = 0xCEC9, [19850] = 0xCECA,
  [19851] = 0xCECB, [19852] = 0xCECC, [19853] = 0xCECD, [19854] = 0xCECE,
  [19855] = 0xCECF, [19856] = 0xCED0, [19857] = 0xCED1, [19858] = 0xCED2,
  [19859] = 0xCED3, [19860] = 0xCED4, [19861] = 0xCED5, [19862] = 0xCED6,
  [19863] = 0xCED7, [19864] = 0xCED8, [19865] = 0xCED9, [19866] = 0xCEDA,
  [19867] = 0xCEDB, [19868] = 0xCEDC, [19869] = 0xCEDD, [19870] = 0xCEDE,
  [19871] = 0xCEDF, [19872] = 0xCEE0, [19873] = 0xCEE1, [19874] = 0xCEE2,
  [19875] = 0xCEE3, [19876] = 0xCEE4, [19877] = 0xCEE5, [19878] = 0xCEE6,
  [19879] = 0xCEE7, [19880] = 0xCEE8, [19881] = 0xCEE9, [19882] = 0xCEEA,
  [19883] = 0xCEEB, [19884] = 0xCEEC, [19885] = 0xCEED, [19886] = 0xCEEE,
  [19887] = 0xCEEF, [19888] = 0xCEF0, [19889] = 0xCEF1, [19890] = 0xCEF2,
  [19891] = 0xCEF3, [19892] = 0xCEF4, [19893] = 0xCEF5, [19894] = 0xCEF6,
  [19895] = 0xCEF7, [19896] = 0xCEF8, [19897] = 0xCEF9, [19898] = 0xCEFA,
  [19899] = 0xCEFB, [19900] = 0xCEFC, [19901] = 0xCEFD, [19902] = 0xCEFE,
  [19968] = 0xCF40, [19969] = 0xCF41, [19970] = 0xCF42, [19971] = 0xCF43,
  [19972] = 0xCF44, [19973] = 0xCF45, [19974] = 0xCF46, [19975] = 0xCF47,
  [19976] = 0xCF48, [19977] = 0xCF49, [19978] = 0xCF4A, [19979] = 0xCF4B,
  [19980] = 0xCF4C, [19981] = 0xCF4D, [19982] = 0xCF4E, [19983] = 0xCF4F,
  [19984] = 0xCF50, [19985] = 0xCF51, [19986] = 0xCF52, [19987] = 0xCF53,
  [19988] = 0xCF54, [19989] = 0xCF55, [19990] = 0xCF56, [19991] = 0xCF57,
  [19992] = 0xCF58, [19993] = 0xCF59, [19994] = 0xCF5A, [19995] = 0xCF5B,
  [19996] = 0xCF5C, [19997] = 0xCF5D, [19998] = 0xCF5E, [19999] = 0xCF5F,
  [20000] = 0xCF60, [20001] = 0xCF61, [20002] = 0xCF62, [20003] = 0xCF63,
  [20004] = 0xCF64, [20005] = 0xCF65, [20006] = 0xCF66, [20007] = 0xCF67,
  [20008] = 0xCF68, [20009] = 0xCF69, [20010] = 0xCF6A, [20011] = 0xCF6B,
  [20012] = 0xCF6C, [20013] = 0xCF6D, [20014] = 0xCF6E, [20015] = 0xCF6F,
  [20016] = 0xCF70, [20017] = 0xCF71, [20018] = 0xCF72, [20019] = 0xCF73,
  [20020] = 0xCF74, [20021] = 0xCF75, [20022] = 0xCF76, [20023] = 0xCF77,
  [20024] = 0xCF78, [20025] = 0xCF79, [20026] = 0xCF7A, [20027] = 0xCF7B,
  [20028] = 0xCF7C, [20029] = 0xCF7D, [20030] = 0xCF7E, [20032] = 0xCF80,
  [20033] = 0xCF81, [20034] = 0xCF82, [20035] = 0xCF83, [20036] = 0xCF84,
  [20037] = 0xCF85, [20038] = 0xCF86, [20039] = 0xCF87, [20040] = 0xCF88,
  [20041] = 0xCF89, [20042] = 0xCF8A, [20043] = 0xCF8B, [20044] = 0xCF8C,
  [20045] = 0xCF8D, [20046] = 0xCF8E, [20047] = 0xCF8F, [20048] = 0xCF90,
  [20049] = 0xCF91, [20050] = 0xCF92, [20051] = 0xCF93, [20052] = 0xCF94,
  [20053] = 0xCF95, [20054] = 0xCF96, [20055] = 0xCF97, [20056] = 0xCF98,
  [20057] = 0xCF99, [20058] = 0xCF9A, [20059] = 0xCF9B, [20060] = 0xCF9C,
  [20061] = 0xCF9D, [20062] = 0xCF9E, [20063] = 0xCF9F, [20064] = 0xCFA0,
  [20065] = 0xCFA1, [20066] = 0xCFA2, [20067] = 0xCFA3, [20068] = 0xCFA4,
  [20069] = 0xCFA5, [20070] = 0xCFA6, [20071] = 0xCFA7, [20072] = 0xCFA8,
  [20073] = 0xCFA9, [20074] = 0xCFAA, [20075] = 0xCFAB, [20076] = 0xCFAC,
  [20077] = 0xCFAD, [20078] = 0xCFAE, [20079] = 0xCFAF, [20080] = 0xCFB0,
  [20081] = 0xCFB1, [20082] = 0xCFB2, [20083] = 0xCFB3, [20084] = 0xCFB4,
  [20085] = 0xCFB5, [20086] = 0xCFB6, [20087] = 0xCFB7, [20088] = 0xCFB8,
  [20089] = 0xCFB9, [20090] = 0xCFBA, [20091] = 0xCFBB, [20092] = 0xCFBC,
  [20093] = 0xCFBD, [20094] = 0xCFBE, [20095] = 0xCFBF, [20096] = 0xCFC0,
  [20097] = 0xCFC1, [20098] = 0xCFC2, [20099] = 0xCFC3, [20100] = 0xCFC4,
  [20101] = 0xCFC5, [20102] = 0xCFC6, [20103] = 0xCFC7, [20104] = 0xCFC8,
  [20105] = 0xCFC9, [20106] = 0xCFCA, [20107] = 0xCFCB, [20108] = 0xCFCC,
  [20109] = 0xCFCD, [20110] = 0xCFCE, [20111] = 0xCFCF, [20112] = 0xCFD0,
  [20113] = 0xCFD1, [20114] = 0xCFD2, [20115] = 0xCFD3, [20116] = 0xCFD4,
  [20117] = 0xCFD5, [20118] = 0xCFD6, [20119] = 0xCFD7, [20120] = 0xCFD8,
  [20121] = 0xCFD9, [20122] = 0xCFDA, [20123] = 0xCFDB, [20124] = 0xCFDC,
  [20125] = 0xCFDD, [20126] = 0xCFDE, [20127] = 0xCFDF, [20128] = 0xCFE0,
  [20129] = 0xCFE1, [20130] = 0xCFE2, [20131] = 0xCFE3, [20132] = 0xCFE4,
  [20133] = 0xCFE5, [20134] = 0xCFE6, [20135] = 0xCFE7, [20136] = 0xCFE8,
  [20137] = 0xCFE9, [20138] = 0xCFEA, [20139] = 0xCFEB, [20140] = 0xCFEC,
  [20141] = 0xCFED, [20142] = 0xCFEE, [20143] = 0xCFEF, [20144] = 0xCFF0,
  [20145] = 0xCFF1, [20146] = 0xCFF2, [20147] = 0xCFF3, [20148] = 0xCFF4,
  [20149] = 0xCFF5, [20150] = 0xCFF6, [20151] = 0xCFF7, [20152] = 0xCFF8,
  [20153] = 0xCFF9, [20154] = 0xCFFA, [20155] = 0xCFFB, [20156] = 0xCFFC,
  [20157] = 0xCFFD, [20158] = 0xCFFE, [20224] = 0xD040, [20225] = 0xD041,
  [20226] = 0xD042, [20227] = 0xD043, [20228] = 0xD044, [20229] = 0xD045,
  [20230] = 0xD046, [20231] = 0xD047, [20232] = 0xD048, [20233] = 0xD049,
  [20234] = 0xD04A, [20235] = 0xD04B, [20236] = 0xD04C, [20237] = 0xD04D,
  [20238] = 0xD04E, [20239] = 0xD04F, [20240] = 0xD050, [20241] = 0xD051,
  [20242] = 0xD052, [20243] = 0xD053, [20244] = 0xD054, [20245] = 0xD055,
  [20246] = 0xD056, [20247] = 0xD057, [20248] = 0xD058, [20249] = 0xD059,
  [20250] = 0xD05A, [20251] = 0xD05B, [20252] = 0xD05C, [20253] = 0xD05D,
  [20254] = 0xD05E, [20255] = 0xD05F, [20256] = 0xD060, [20257] = 0xD061,
  [20258] = 0xD062, [20259] = 0xD063, [20260] = 0xD064, [20261] = 0xD065,
  [20262] = 0xD066, [20263] = 0xD067, [20264] = 0xD068, [20265] = 0xD069,
  [20266] = 0xD06A, [20267] = 0xD06B, [20268] = 0xD06C, [20269] = 0xD06D,
  [20270] = 0xD06E, [20271] = 0xD06F, [20272] = 0xD070, [20273] = 0xD071,
  [20274] = 0xD072, [20275] = 0xD073, [20276] = 0xD074, [20277] = 0xD075,
  [20278] = 0xD076, [20279] = 0xD077, [20280] = 0xD078, [20281] = 0xD079,
  [20282] = 0xD07A, [20283] = 0xD07B, [20284] = 0xD07C, [20285] = 0xD07D,
  [20286] = 0xD07E, [20288] = 0xD080, [20289] = 0xD081, [20290] = 0xD082,
  [20291] = 0xD083, [20292] = 0xD084, [20293] = 0xD085, [20294] = 0xD086,
  [20295] = 0xD087, [20296] = 0xD088, [20297] = 0xD089, [20298] = 0xD08A,
  [20299] = 0xD08B, [20300] = 0xD08C, [20301] = 0xD08D, [20302] = 0xD08E,
  [20303] = 0xD08F, [20304] = 0xD090, [20305] = 0xD091, [20306] = 0xD092,
  [20307] = 0xD093, [20308] = 0xD094, [20309] = 0xD095, [20310] = 0xD096,
  [20311] = 0xD097, [20312] = 0xD098, [20313] = 0xD099, [20314] = 0xD09A,
  [20315] = 0xD09B, [20316] = 0xD09C, [20317] = 0xD09D, [20318] = 0xD09E,
  [20319] = 0xD09F, [20320] = 0xD0A0, [20321] = 0xD0A1, [20322] = 0xD0A2,
  [20323] = 0xD0A3, [20324] = 0xD0A4, [20325] = 0xD0A5, [20326] = 0xD0A6,
  [20327] = 0xD0A7, [20328] = 0xD0A8, [20329] = 0xD0A9, [20330] = 0xD0AA,
  [20331] = 0xD0AB, [20332] = 0xD0AC, [20333] = 0xD0AD, [20334] = 0xD0AE,
  [20335] = 0xD0AF, [20336] = 0xD0B0, [20337] = 0xD0B1, [20338] = 0xD0B2,
  [20339] = 0xD0B3, [20340] = 0xD0B4, [20341] = 0xD0B5, [20342] = 0xD0B6,
  [20343] = 0xD0B7, [20344] = 0xD0B8, [20345] = 0xD0B9, [20346] = 0xD0BA,
  [20347] = 0xD0BB, [20348] = 0xD0BC, [20349] = 0xD0BD, [20350] = 0xD0BE,
  [20351] = 0xD0BF, [20352] = 0xD0C0, [20353] = 0xD0C1, [20354] = 0xD0C2,
  [20355] = 0xD0C3, [20356] = 0xD0C4, [20357] = 0xD0C5, [20358] = 0xD0C6,
  [20359] = 0xD0C7, [20360] = 0xD0C8, [20361] = 0xD0C9, [20362] = 0xD0CA,
  [20363] = 0xD0CB, [20364] = 0xD0CC, [20365] = 0xD0CD, [20366] = 0xD0CE,
  [20367] = 0xD0CF, [20368] = 0xD0D0, [20369] = 0xD0D1, [20370] = 0xD0D2,
  [20371] = 0xD0D3, [20372] = 0xD0D4, [20373] = 0xD0D5, [20374] = 0xD0D6,
  [20375] = 0xD0D7, [20376] = 0xD0D8, [20377] = 0xD0D9, [20378] = 0xD0DA,
  [20379] = 0xD0DB, [20380] = 0xD0DC, [20381] = 0xD0DD, [20382] = 0xD0DE,
  [20383] = 0xD0DF, [20384] = 0xD0E0, [20385] = 0xD0E1, [20386] = 0xD0E2,
  [20387] = 0xD0E3, [20388] = 0xD0E4, [20389] = 0xD0E5, [20390] = 0xD0E6,
  [20391] = 0xD0E7, [20392] = 0xD0E8, [20393] = 0xD0E9, [20394] = 0xD0EA,
  [20395] = 0xD0EB, [20396] = 0xD0EC, [20397] = 0xD0ED, [20398] = 0xD0EE,
  [20399] = 0xD0EF, [20400] = 0xD0F0, [20401] = 0xD0F1, [20402] = 0xD0F2,
  [20403] = 0xD0F3, [20404] = 0xD0F4, [20405] = 0xD0F5, [20406] = 0xD0F6,
  [20407] = 0xD0F7, [20408] = 0xD0F8, [20409] = 0xD0F9, [20410] = 0xD0FA,
  [20411] = 0xD0FB, [20412] = 0xD0FC, [20413] = 0xD0FD, [20414] = 0xD0FE,
  [20480] = 0xD140, [20481] = 0xD141, [20482] = 0xD142, [20483] = 0xD143,
  [20484] = 0xD144, [20485] = 0xD145, [20486] = 0xD146, [20487] = 0xD147,
  [20488] = 0xD148, [20489] = 0xD149, [20490] = 0xD14A, [20491] = 0xD14B,
  [20492] = 0xD14C, [20493] = 0xD14D, [20494] = 0xD14E, [20495] = 0xD14F,
  [20496] = 0xD150, [20497] = 0xD151, [20498] = 0xD152, [20499] = 0xD153,
  [20500] = 0xD154, [20501] = 0xD155, [20502] = 0xD156, [20503] = 0xD157,
  [20504] = 0xD158, [20505] = 0xD159, [20506] = 0xD15A, [20507] = 0xD15B,
  [20508] = 0xD15C, [20509] = 0xD15D, [20510] = 0xD15E, [20511] = 0xD15F,
  [20512] = 0xD160, [20513] = 0xD161, [20514] = 0xD162, [20515] = 0xD163,
  [20516] = 0xD164, [20517] = 0xD165, [20518] = 0xD166, [20519] = 0xD167,
  [20520] = 0xD168, [20521] = 0xD169, [20522] = 0xD16A, [20523] = 0xD16B,
  [20524] = 0xD16C, [20525] = 0xD16D, [20526] = 0xD16E, [20527] = 0xD16F,
  [20528] = 0xD170, [20529] = 0xD171, [20530] = 0xD172, [20531] = 0xD173,
  [20532] = 0xD174, [20533] = 0xD175, [20534] = 0xD176, [20535] = 0xD177,
  [20536] = 0xD178, [20537] = 0xD179, [20538] = 0xD17A, [20539] = 0xD17B,
  [20540] = 0xD17C, [20541] = 0xD17D, [20542] = 0xD17E, [20544] = 0xD180,
  [20545] = 0xD181, [20546] = 0xD182, [20547] = 0xD183, [20548] = 0xD184,
  [20549] = 0xD185, [20550] = 0xD186, [20551] = 0xD187, [20552] = 0xD188,
  [20553] = 0xD189, [20554] = 0xD18A, [20555] = 0xD18B, [20556] = 0xD18C,
  [20557] = 0xD18D, [20558] = 0xD18E, [20559] = 0xD18F, [20560] = 0xD190,
  [20561] = 0xD191, [20562] = 0xD192, [20563] = 0xD193, [20564] = 0xD194,
  [20565] = 0xD195, [20566] = 0xD196, [20567] = 0xD197, [20568] = 0xD198,
  [20569] = 0xD199, [20570] = 0xD19A, [20571] = 0xD19B, [20572] = 0xD19C,
  [20573] = 0xD19D, [20574] = 0xD19E, [20575] = 0xD19F, [20576] = 0xD1A0,
  [20577] = 0xD1A1, [20578] = 0xD1A2, [20579] = 0xD1A3, [20580] = 0xD1A4,
  [20581] = 0xD1A5, [20582] = 0xD1A6, [20583] = 0xD1A7, [20584] = 0xD1A8,
  [20585] = 0xD1A9, [20586] = 0xD1AA, [20587] = 0xD1AB, [20588] = 0xD1AC,
  [20589] = 0xD1AD, [20590] = 0xD1AE, [20591] = 0xD1AF, [20592] = 0xD1B0,
  [20593] = 0xD1B1, [20594] = 0xD1B2, [20595] = 0xD1B3, [20596] = 0xD1B4,
  [20597] = 0xD1B5, [20598] = 0xD1B6, [20599] = 0xD1B7, [20600] = 0xD1B8,
  [20601] = 0xD1B9, [20602] = 0xD1BA, [20603] = 0xD1BB, [20604] = 0xD1BC,
  [20605] = 0xD1BD, [20606] = 0xD1BE, [20607] = 0xD1BF, [20608] = 0xD1C0,
  [20609] = 0xD1C1, [20610] = 0xD1C2, [20611] = 0xD1C3, [20612] = 0xD1C4,
  [20613] = 0xD1C5, [20614] = 0xD1C6, [20615] = 0xD1C7, [20616] = 0xD1C8,
  [20617] = 0xD1C9, [20618] = 0xD1CA, [20619] = 0xD1CB, [20620] = 0xD1CC,
  [20621] = 0xD1CD, [20622] = 0xD1CE, [20623] = 0xD1CF, [20624] = 0xD1D0,
  [20625] = 0xD1D1, [20626] = 0xD1D2, [20627] = 0xD1D3, [20628] = 0xD1D4,
  [20629] = 0xD1D5, [20630] = 0xD1D6, [20631] = 0xD1D7, [20632] = 0xD1D8,
  [20633] = 0xD1D9, [20634] = 0xD1DA, [20635] = 0xD1DB, [20636] = 0xD1DC,
  [20637] = 0xD1DD, [20638] = 0xD1DE, [20639] = 0xD1DF, [20640] = 0xD1E0,
  [20641] = 0xD1E1, [20642] = 0xD1E2, [20643] = 0xD1E3, [20644] = 0xD1E4,
  [20645] = 0xD1E5, [20646] = 0xD1E6, [20647] = 0xD1E7, [20648] = 0xD1E8,
  [20649] = 0xD1E9, [20650] = 0xD1EA, [20651] = 0xD1EB, [20652] = 0xD1EC,
  [20653] = 0xD1ED, [20654] = 0xD1EE, [20655] = 0xD1EF, [20656] = 0xD1F0,
  [20657] = 0xD1F1, [20658] = 0xD1F2, [20659] = 0xD1F3, [20660] = 0xD1F4,
  [20661] = 0xD1F5, [20662] = 0xD1F6, [20663] = 0xD1F7, [20664] = 0xD1F8,
  [20665] = 0xD1F9, [20666] = 0xD1FA, [20667] = 0xD1FB, [20668] = 0xD1FC,
  [20669] = 0xD1FD, [20670] = 0xD1FE, [20736] = 0xD240, [20737] = 0xD241,
  [20738] = 0xD242, [20739] = 0xD243, [20740] = 0xD244, [20741] = 0xD245,
  [20742] = 0xD246, [20743] = 0xD247, [20744] = 0xD248, [20745] = 0xD249,
  [20746] = 0xD24A, [20747] = 0xD24B, [20748] = 0xD24C, [20749] = 0xD24D,
  [20750] = 0xD24E, [20751] = 0xD24F, [20752] = 0xD250, [20753] = 0xD251,
  [20754] = 0xD252, [20755] = 0xD253, [20756] = 0xD254, [20757] = 0xD255,
  [20758] = 0xD256, [20759] = 0xD257, [20760] = 0xD258, [20761] = 0xD259,
  [20762] = 0xD25A, [20763] = 0xD25B, [20764] = 0xD25C, [20765] = 0xD25D,
  [20766] = 0xD25E, [20767] = 0xD25F, [20768] = 0xD260, [20769] = 0xD261,
  [20770] = 0xD262, [20771] = 0xD263, [20772] = 0xD264, [20773] = 0xD265,
  [20774] = 0xD266, [20775] = 0xD267, [20776] = 0xD268, [20777] = 0xD269,
  [20778] = 0xD26A, [20779] = 0xD26B, [20780] = 0xD26C, [20781] = 0xD26D,
  [20782] = 0xD26E, [20783] = 0xD26F, [20784] = 0xD270, [20785] = 0xD271,
  [20786] = 0xD272, [20787] = 0xD273, [20788] = 0xD274, [20789] = 0xD275,
  [20790] = 0xD276, [20791] = 0xD277, [20792] = 0xD278, [20793] = 0xD279,
  [20794] = 0xD27A, [20795] = 0xD27B, [20796] = 0xD27C, [20797] = 0xD27D,
  [20798] = 0xD27E, [20800] = 0xD280, [20801] = 0xD281, [20802] = 0xD282,
  [20803] = 0xD283, [20804] = 0xD284, [20805] = 0xD285, [20806] = 0xD286,
  [20807] = 0xD287, [20808] = 0xD288, [20809] = 0xD289, [20810] = 0xD28A,
  [20811] = 0xD28B, [20812] = 0xD28C, [20813] = 0xD28D, [20814] = 0xD28E,
  [20815] = 0xD28F, [20816] = 0xD290, [20817] = 0xD291, [20818] = 0xD292,
  [20819] = 0xD293, [20820] = 0xD294, [20821] = 0xD295, [20822] = 0xD296,
  [20823] = 0xD297, [20824] = 0xD298, [20825] = 0xD299, [20826] = 0xD29A,
  [20827] = 0xD29B, [20828] = 0xD29C, [20829] = 0xD29D, [20830] = 0xD29E,
  [20831] = 0xD29F, [20832] = 0xD2A0, [20833] = 0xD2A1, [20834] = 0xD2A2,
  [20835] = 0xD2A3, [20836] = 0xD2A4, [20837] = 0xD2A5, [20838] = 0xD2A6,
  [20839] = 0xD2A7, [20840] = 0xD2A8, [20841] = 0xD2A9, [20842] = 0xD2AA,
  [20843] = 0xD2AB, [20844] = 0xD2AC, [20845] = 0xD2AD, [20846] = 0xD2AE,
  [20847] = 0xD2AF, [20848] = 0xD2B0, [20849] = 0xD2B1, [20850] = 0xD2B2,
  [20851] = 0xD2B3, [20852] = 0xD2B4, [20853] = 0xD2B5, [20854] = 0xD2B6,
  [20855] = 0xD2B7, [20856] = 0xD2B8, [20857] = 0xD2B9, [20858] = 0xD2BA,
  [20859] = 0xD2BB, [20860] = 0xD2BC, [20861] = 0xD2BD, [20862] = 0xD2BE,
  [20863] = 0xD2BF, [20864] = 0xD2C0, [20865] = 0xD2C1, [20866] = 0xD2C2,
  [20867] = 0xD2C3, [20868] = 0xD2C4, [20869] = 0xD2C5, [20870] = 0xD2C6,
  [20871] = 0xD2C7, [20872] = 0xD2C8, [20873] = 0xD2C9, [20874] = 0xD2CA,
  [20875] = 0xD2CB, [20876] = 0xD2CC, [20877] = 0xD2CD, [20878] = 0xD2CE,
  [20879] = 0xD2CF, [20880] = 0xD2D0, [20881] = 0xD2D1, [20882] = 0xD2D2,
  [20883] = 0xD2D3, [20884] = 0xD2D4, [20885] = 0xD2D5, [20886] = 0xD2D6,
  [20887] = 0xD2D7, [20888] = 0xD2D8, [20889] = 0xD2D9, [20890] = 0xD2DA,
  [20891] = 0xD2DB, [20892] = 0xD2DC, [20893] = 0xD2DD, [20894] = 0xD2DE,
  [20895] = 0xD2DF, [20896] = 0xD2E0, [20897] = 0xD2E1, [20898] = 0xD2E2,
  [20899] = 0xD2E3, [20900] = 0xD2E4, [20901] = 0xD2E5, [20902] = 0xD2E6,
  [20903] = 0xD2E7, [20904] = 0xD2E8, [20905] = 0xD2E9, [20906] = 0xD2EA,
  [20907] = 0xD2EB, [20908] = 0xD2EC, [20909] = 0xD2ED, [20910] = 0xD2EE,
  [20911] = 0xD2EF, [20912] = 0xD2F0, [20913] = 0xD2F1, [20914] = 0xD2F2,
  [20915] = 0xD2F3, [20916] = 0xD2F4, [20917] = 0xD2F5, [20918] = 0xD2F6,
  [20919] = 0xD2F7, [20920] = 0xD2F8, [20921] = 0xD2F9, [20922] = 0xD2FA,
  [20923] = 0xD2FB, [20924] = 0xD2FC, [20925] = 0xD2FD, [20926] = 0xD2FE,
  [20992] = 0xD340, [20993] = 0xD341, [20994] = 0xD342, [20995] = 0xD343,
  [20996] = 0xD344, [20997] = 0xD345, [20998] = 0xD346, [20999] = 0xD347,
  [21000] = 0xD348, [21001] = 0xD349, [21002] = 0xD34A, [21003] = 0xD34B,
  [21004] = 0xD34C, [21005] = 0xD34D, [21006] = 0xD34E, [21007] = 0xD34F,
  [21008] = 0xD350, [21009] = 0xD351, [21010] = 0xD352, [21011] = 0xD353,
  [21012] = 0xD354, [21013] = 0xD355, [21014] = 0xD356, [21015] = 0xD357,
  [21016] = 0xD358, [21017] = 0xD359, [21018] = 0xD35A, [21019] = 0xD35B,
  [21020] = 0xD35C, [21021] = 0xD35D, [21022] = 0xD35E, [21023] = 0xD35F,
  [21024] = 0xD360, [21025] = 0xD361, [21026] = 0xD362, [21027] = 0xD363,
  [21028] = 0xD364, [21029] = 0xD365, [21030] = 0xD366, [21031] = 0xD367,
  [21032] = 0xD368, [21033] = 0xD369, [21034] = 0xD36A, [21035] = 0xD36B,
  [21036] = 0xD36C, [21037] = 0xD36D, [21038] = 0xD36E, [21039] = 0xD36F,
  [21040] = 0xD370, [21041] = 0xD371, [21042] = 0xD372, [21043] = 0xD373,
  [21044] = 0xD374, [21045] = 0xD375, [21046] = 0xD376, [21047] = 0xD377,
  [21048] = 0xD378, [21049] = 0xD379, [21050] = 0xD37A, [21051] = 0xD37B,
  [21052] = 0xD37C, [21053] = 0xD37D, [21054] = 0xD37E, [21056] = 0xD380,
  [21057] = 0xD381, [21058] = 0xD382, [21059] = 0xD383, [21060] = 0xD384,
  [21061] = 0xD385, [21062] = 0xD386, [21063] = 0xD387, [21064] = 0xD388,
  [21065] = 0xD389, [21066] = 0xD38A, [21067] = 0xD38B, [21068] = 0xD38C,
  [21069] = 0xD38D, [21070] = 0xD38E, [21071] = 0xD38F, [21072] = 0xD390,
  [21073] = 0xD391, [21074] = 0xD392, [21075] = 0xD393, [21076] = 0xD394,
  [21077] = 0xD395, [21078] = 0xD396, [21079] = 0xD397, [21080] = 0xD398,
  [21081] = 0xD399, [21082] = 0xD39A, [21083] = 0xD39B, [21084] = 0xD39C,
  [21085] = 0xD39D, [21086] = 0xD39E, [21087] = 0xD39F, [21088] = 0xD3A0,
  [21089] = 0xD3A1, [21090] = 0xD3A2, [21091] = 0xD3A3, [21092] = 0xD3A4,
  [21093] = 0xD3A5, [21094] = 0xD3A6, [21095] = 0xD3A7, [21096] = 0xD3A8,
  [21097] = 0xD3A9, [21098] = 0xD3AA, [21099] = 0xD3AB, [21100] = 0xD3AC,
  [21101] = 0xD3AD, [21102] = 0xD3AE, [21103] = 0xD3AF, [21104] = 0xD3B0,
  [21105] = 0xD3B1, [21106] = 0xD3B2, [21107] = 0xD3B3, [21108] = 0xD3B4,
  [21109] = 0xD3B5, [21110] = 0xD3B6, [21111] = 0xD3B7, [21112] = 0xD3B8,
  [21113] = 0xD3B9, [21114] = 0xD3BA, [21115] = 0xD3BB, [21116] = 0xD3BC,
  [21117] = 0xD3BD, [21118] = 0xD3BE, [21119] = 0xD3BF, [21120] = 0xD3C0,
  [21121] = 0xD3C1, [21122] = 0xD3C2, [21123] = 0xD3C3, [21124] = 0xD3C4,
  [21125] = 0xD3C5, [21126] = 0xD3C6, [21127] = 0xD3C7, [21128] = 0xD3C8,
  [21129] = 0xD3C9, [21130] = 0xD3CA, [21131] = 0xD3CB, [21132] = 0xD3CC,
  [21133] = 0xD3CD, [21134] = 0xD3CE, [21135] = 0xD3CF, [21136] = 0xD3D0,
  [21137] = 0xD3D1, [21138] = 0xD3D2, [21139] = 0xD3D3, [21140] = 0xD3D4,
  [21141] = 0xD3D5, [21142] = 0xD3D6, [21143] = 0xD3D7, [21144] = 0xD3D8,
  [21145] = 0xD3D9, [21146] = 0xD3DA, [21147] = 0xD3DB, [21148] = 0xD3DC,
  [21149] = 0xD3DD, [21150] = 0xD3DE, [21151] = 0xD3DF, [21152] = 0xD3E0,
  [21153] = 0xD3E1, [21154] = 0xD3E2, [21155] = 0xD3E3, [21156] = 0xD3E4,
  [21157] = 0xD3E5, [21158] = 0xD3E6, [21159] = 0xD3E7, [21160] = 0xD3E8,
  [21161] = 0xD3E9, [21162] = 0xD3EA, [21163] = 0xD3EB, [21164] = 0xD3EC,
  [21165] = 0xD3ED, [21166] = 0xD3EE, [21167] = 0xD3EF, [21168] = 0xD3F0,
  [21169] = 0xD3F1, [21170] = 0xD3F2, [21171] = 0xD3F3, [21172] = 0xD3F4,
  [21173] = 0xD3F5, [21174] = 0xD3F6, [21175] = 0xD3F7, [21176] = 0xD3F8,
  [21177] = 0xD3F9, [21178] = 0xD3FA, [21179] = 0xD3FB, [21180] = 0xD3FC,
  [21181] = 0xD3FD, [21182] = 0xD3FE, [21248] = 0xD440, [21249] = 0xD441,
  [21250] = 0xD442, [21251] = 0xD443, [21252] = 0xD444, [21253] = 0xD445,
  [21254] = 0xD446, [21255] = 0xD447, [21256] = 0xD448, [21257] = 0xD449,
  [21258] = 0xD44A, [21259] = 0xD44B, [21260] = 0xD44C, [21261] = 0xD44D,
  [21262] = 0xD44E, [21263] = 0xD44F, [21264] = 0xD450, [21265] = 0xD451,
  [21266] = 0xD452, [21267] = 0xD453, [21268] = 0xD454, [21269] = 0xD455,
  [21270] = 0xD456, [21271] = 0xD457, [21272] = 0xD458, [21273] = 0xD459,
  [21274] = 0xD45A, [21275] = 0xD45B, [21276] = 0xD45C, [21277] = 0xD45D,
  [21278] = 0xD45E, [21279] = 0xD45F, [21280] = 0xD460, [21281] = 0xD461,
  [21282] = 0xD462, [21283] = 0xD463, [21284] = 0xD464, [21285] = 0xD465,
  [21286] = 0xD466, [21287] = 0xD467, [21288] = 0xD468, [21289] = 0xD469,
  [21290] = 0xD46A, [21291] = 0xD46B, [21292] = 0xD46C, [21293] = 0xD46D,
  [21294] = 0xD46E, [21295] = 0xD46F, [21296] = 0xD470, [21297] = 0xD471,
  [21298] = 0xD472, [21299] = 0xD473, [21300] = 0xD474, [21301] = 0xD475,
  [21302] = 0xD476, [21303] = 0xD477, [21304] = 0xD478, [21305] = 0xD479,
  [21306] = 0xD47A, [21307] = 0xD47B, [21308] = 0xD47C, [21309] = 0xD47D,
  [21310] = 0xD47E, [21312] = 0xD480, [21313] = 0xD481, [21314] = 0xD482,
  [21315] = 0xD483, [21316] = 0xD484, [21317] = 0xD485, [21318] = 0xD486,
  [21319] = 0xD487, [21320] = 0xD488, [21321] = 0xD489, [21322] = 0xD48A,
  [21323] = 0xD48B, [21324] = 0xD48C, [21325] = 0xD48D, [21326] = 0xD48E,
  [21327] = 0xD48F, [21328] = 0xD490, [21329] = 0xD491, [21330] = 0xD492,
  [21331] = 0xD493, [21332] = 0xD494, [21333] = 0xD495, [21334] = 0xD496,
  [21335] = 0xD497, [21336] = 0xD498, [21337] = 0xD499, [21338] = 0xD49A,
  [21339] = 0xD49B, [21340] = 0xD49C, [21341] = 0xD49D, [21342] = 0xD49E,
  [21343] = 0xD49F, [21344] = 0xD4A0, [21345] = 0xD4A1, [21346] = 0xD4A2,
  [21347] = 0xD4A3, [21348] = 0xD4A4, [21349] = 0xD4A5, [21350] = 0xD4A6,
  [21351] = 0xD4A7, [21352] = 0xD4A8, [21353] = 0xD4A9, [21354] = 0xD4AA,
  [21355] = 0xD4AB, [21356] = 0xD4AC, [21357] = 0xD4AD, [21358] = 0xD4AE,
  [21359] = 0xD4AF, [21360] = 0xD4B0, [21361] = 0xD4B1, [21362] = 0xD4B2,
  [21363] = 0xD4B3, [21364] = 0xD4B4, [21365] = 0xD4B5, [21366] = 0xD4B6,
  [21367] = 0xD4B7, [21368] = 0xD4B8, [21369] = 0xD4B9, [21370] = 0xD4BA,
  [21371] = 0xD4BB, [21372] = 0xD4BC, [21373] = 0xD4BD, [21374] = 0xD4BE,
  [21375] = 0xD4BF, [21376] = 0xD4C0, [21377] = 0xD4C1, [21378] = 0xD4C2,
  [21379] = 0xD4C3, [21380] = 0xD4C4, [21381] = 0xD4C5, [21382] = 0xD4C6,
  [21383] = 0xD4C7, [21384] = 0xD4C8, [21385] = 0xD4C9, [21386] = 0xD4CA,
  [21387] = 0xD4CB, [21388] = 0xD4CC, [21389] = 0xD4CD, [21390] = 0xD4CE,
  [21391] = 0xD4CF, [21392] = 0xD4D0, [21393] = 0xD4D1, [21394] = 0xD4D2,
  [21395] = 0xD4D3, [21396] = 0xD4D4, [21397] = 0xD4D5, [21398] = 0xD4D6,
  [21399] = 0xD4D7, [21400] = 0xD4D8, [21401] = 0xD4D9, [21402] = 0xD4DA,
  [21403] = 0xD4DB, [21404] = 0xD4DC, [21405] = 0xD4DD, [21406] = 0xD4DE,
  [21407] = 0xD4DF, [21408] = 0xD4E0, [21409] = 0xD4E1, [21410] = 0xD4E2,
  [21411] = 0xD4E3, [21412] = 0xD4E4, [21413] = 0xD4E5, [21414] = 0xD4E6,
  [21415] = 0xD4E7, [21416] = 0xD4E8, [21417] = 0xD4E9, [21418] = 0xD4EA,
  [21419] = 0xD4EB, [21420] = 0xD4EC, [21421] = 0xD4ED, [21422] = 0xD4EE,
  [21423] = 0xD4EF, [21424] = 0xD4F0, [21425] = 0xD4F1, [21426] = 0xD4F2,
  [21427] = 0xD4F3, [21428] = 0xD4F4, [21429] = 0xD4F5, [21430] = 0xD4F6,
  [21431] = 0xD4F7, [21432] = 0xD4F8, [21433] = 0xD4F9, [21434] = 0xD4FA,
  [21435] = 0xD4FB, [21436] = 0xD4FC, [21437] = 0xD4FD, [21438] = 0xD4FE,
  [21504] = 0xD540, [21505] = 0xD541, [21506] = 0xD542, [21507] = 0xD543,
  [21508] = 0xD544, [21509] = 0xD545, [21510] = 0xD546, [21511] = 0xD547,
  [21512] = 0xD548, [21513] = 0xD549, [21514] = 0xD54A, [21515] = 0xD54B,
  [21516] = 0xD54C, [21517] = 0xD54D, [21518] = 0xD54E, [21519] = 0xD54F,
  [21520] = 0xD550, [21521] = 0xD551, [21522] = 0xD552, [21523] = 0xD553,
  [21524] = 0xD554, [21525] = 0xD555, [21526] = 0xD556, [21527] = 0xD557,
  [21528] = 0xD558, [21529] = 0xD559, [21530] = 0xD55A, [21531] = 0xD55B,
  [21532] = 0xD55C, [21533] = 0xD55D, [21534] = 0xD55E, [21535] = 0xD55F,
  [21536] = 0xD560, [21537] = 0xD561, [21538] = 0xD562, [21539] = 0xD563,
  [21540] = 0xD564, [21541] = 0xD565, [21542] = 0xD566, [21543] = 0xD567,
  [21544] = 0xD568, [21545] = 0xD569, [21546] = 0xD56A, [21547] = 0xD56B,
  [21548] = 0xD56C, [21549] = 0xD56D, [21550] = 0xD56E, [21551] = 0xD56F,
  [21552] = 0xD570, [21553] = 0xD571, [21554] = 0xD572, [21555] = 0xD573,
  [21556] = 0xD574, [21557] = 0xD575, [21558] = 0xD576, [21559] = 0xD577,
  [21560] = 0xD578, [21561] = 0xD579, [21562] = 0xD57A, [21563] = 0xD57B,
  [21564] = 0xD57C, [21565] = 0xD57D, [21566] = 0xD57E, [21568] = 0xD580,
  [21569] = 0xD581, [21570] = 0xD582, [21571] = 0xD583, [21572] = 0xD584,
  [21573] = 0xD585, [21574] = 0xD586, [21575] = 0xD587, [21576] = 0xD588,
  [21577] = 0xD589, [21578] = 0xD58A, [21579] = 0xD58B, [21580] = 0xD58C,
  [21581] = 0xD58D, [21582] = 0xD58E, [21583] = 0xD58F, [21584] = 0xD590,
  [21585] = 0xD591, [21586] = 0xD592, [21587] = 0xD593, [21588] = 0xD594,
  [21589] = 0xD595, [21590] = 0xD596, [21591] = 0xD597, [21592] = 0xD598,
  [21593] = 0xD599, [21594] = 0xD59A, [21595] = 0xD59B, [21596] = 0xD59C,
  [21597] = 0xD59D, [21598] = 0xD59E, [21599] = 0xD59F, [21600] = 0xD5A0,
  [21601] = 0xD5A1, [21602] = 0xD5A2, [21603] = 0xD5A3, [21604] = 0xD5A4,
  [21605] = 0xD5A5, [21606] = 0xD5A6, [21607] = 0xD5A7, [21608] = 0xD5A8,
  [21609] = 0xD5A9, [21610] = 0xD5AA, [21611] = 0xD5AB, [21612] = 0xD5AC,
  [21613] = 0xD5AD, [21614] = 0xD5AE, [21615] = 0xD5AF, [21616] = 0xD5B0,
  [21617] = 0xD5B1, [21618] = 0xD5B2, [21619] = 0xD5B3, [21620] = 0xD5B4,
  [21621] = 0xD5B5, [21622] = 0xD5B6, [21623] = 0xD5B7, [21624] = 0xD5B8,
  [21625] = 0xD5B9, [21626] = 0xD5BA, [21627] = 0xD5BB, [21628] = 0xD5BC,
  [21629] = 0xD5BD, [21630] = 0xD5BE, [21631] = 0xD5BF, [21632] = 0xD5C0,
  [21633] = 0xD5C1, [21634] = 0xD5C2, [21635] = 0xD5C3, [21636] = 0xD5C4,
  [21637] = 0xD5C5, [21638] = 0xD5C6, [21639] = 0xD5C7, [21640] = 0xD5C8,
  [21641] = 0xD5C9, [21642] = 0xD5CA, [21643] = 0xD5CB, [21644] = 0xD5CC,
  [21645] = 0xD5CD, [21646] = 0xD5CE, [21647] = 0xD5CF, [21648] = 0xD5D0,
  [21649] = 0xD5D1, [21650] = 0xD5D2, [21651] = 0xD5D3, [21652] = 0xD5D4,
  [21653] = 0xD5D5, [21654] = 0xD5D6, [21655] = 0xD5D7, [21656] = 0xD5D8,
  [21657] = 0xD5D9, [21658] = 0xD5DA, [21659] = 0xD5DB, [21660] = 0xD5DC,
  [21661] = 0xD5DD, [21662] = 0xD5DE, [21663] = 0xD5DF, [21664] = 0xD5E0,
  [21665] = 0xD5E1, [21666] = 0xD5E2, [21667] = 0xD5E3, [21668] = 0xD5E4,
  [21669] = 0xD5E5, [21670] = 0xD5E6, [21671] = 0xD5E7, [21672] = 0xD5E8,
  [21673] = 0xD5E9, [21674] = 0xD5EA, [21675] = 0xD5EB, [21676] = 0xD5EC,
  [21677] = 0xD5ED, [21678] = 0xD5EE, [21679] = 0xD5EF, [21680] = 0xD5F0,
  [21681] = 0xD5F1, [21682] = 0xD5F2, [21683] = 0xD5F3, [21684] = 0xD5F4,
  [21685] = 0xD5F5, [21686] = 0xD5F6, [21687] = 0xD5F7, [21688] = 0xD5F8,
  [21689] = 0xD5F9, [21690] = 0xD5FA, [21691] = 0xD5FB, [21692] = 0xD5FC,
  [21693] = 0xD5FD, [21694] = 0xD5FE, [21760] = 0xD640, [21761] = 0xD641,
  [21762] = 0xD642, [21763] = 0xD643, [21764] = 0xD644, [21765] = 0xD645,
  [21766] = 0xD646, [21767] = 0xD647, [21768] = 0xD648, [21769] = 0xD649,
  [21770] = 0xD64A, [21771] = 0xD64B, [21772] = 0xD64C, [21773] = 0xD64D,
  [21774] = 0xD64E, [21775] = 0xD64F, [21776] = 0xD650, [21777] = 0xD651,
  [21778] = 0xD652, [21779] = 0xD653, [21780] = 0xD654, [21781] = 0xD655,
  [21782] = 0xD656, [21783] = 0xD657, [21784] = 0xD658, [21785] = 0xD659,
  [21786] = 0xD65A, [21787] = 0xD65B, [21788] = 0xD65C, [21789] = 0xD65D,
  [21790] = 0xD65E, [21791] = 0xD65F, [21792] = 0xD660, [21793] = 0xD661,
  [21794] = 0xD662, [21795] = 0xD663, [21796] = 0xD664, [21797] = 0xD665,
  [21798] = 0xD666, [21799] = 0xD667, [21800] = 0xD668, [21801] = 0xD669,
  [21802] = 0xD66A, [21803] = 0xD66B, [21804] = 0xD66C, [21805] = 0xD66D,
  [21806] = 0xD66E, [21807] = 0xD66F, [21808] = 0xD670, [21809] = 0xD671,
  [21810] = 0xD672, [21811] = 0xD673, [21812] = 0xD674, [21813] = 0xD675,
  [21814] = 0xD676, [21815] = 0xD677, [21816] = 0xD678, [21817] = 0xD679,
  [21818] = 0xD67A, [21819] = 0xD67B, [21820] = 0xD67C, [21821] = 0xD67D,
  [21822] = 0xD67E, [21824] = 0xD680, [21825] = 0xD681, [21826] = 0xD682,
  [21827] = 0xD683, [21828] = 0xD684, [21829] = 0xD685, [21830] = 0xD686,
  [21831] = 0xD687, [21832] = 0xD688, [21833] = 0xD689, [21834] = 0xD68A,
  [21835] = 0xD68B, [21836] = 0xD68C, [21837] = 0xD68D, [21838] = 0xD68E,
  [21839] = 0xD68F, [21840] = 0xD690, [21841] = 0xD691, [21842] = 0xD692,
  [21843] = 0xD693, [21844] = 0xD694, [21845] = 0xD695, [21846] = 0xD696,
  [21847] = 0xD697, [21848] = 0xD698, [21849] = 0xD699, [21850] = 0xD69A,
  [21851] = 0xD69B, [21852] = 0xD69C, [21853] = 0xD69D, [21854] = 0xD69E,
  [21855] = 0xD69F, [21856] = 0xD6A0, [21857] = 0xD6A1, [21858] = 0xD6A2,
  [21859] = 0xD6A3, [21860] = 0xD6A4, [21861] = 0xD6A5, [21862] = 0xD6A6,
  [21863] = 0xD6A7, [21864] = 0xD6A8, [21865] = 0xD6A9, [21866] = 0xD6AA,
  [21867] = 0xD6AB, [21868] = 0xD6AC, [21869] = 0xD6AD, [21870] = 0xD6AE,
  [21871] = 0xD6AF, [21872] = 0xD6B0, [21873] = 0xD6B1, [21874] = 0xD6B2,
  [21875] = 0xD6B3, [21876] = 0xD6B4, [21877] = 0xD6B5, [21878] = 0xD6B6,
  [21879] = 0xD6B7, [21880] = 0xD6B8, [21881] = 0xD6B9, [21882] = 0xD6BA,
  [21883] = 0xD6BB, [21884] = 0xD6BC, [21885] = 0xD6BD, [21886] = 0xD6BE,
  [21887] = 0xD6BF, [21888] = 0xD6C0, [21889] = 0xD6C1, [21890] = 0xD6C2,
  [21891] = 0xD6C3, [21892] = 0xD6C4, [21893] = 0xD6C5, [21894] = 0xD6C6,
  [21895] = 0xD6C7, [21896] = 0xD6C8, [21897] = 0xD6C9, [21898] = 0xD6CA,
  [21899] = 0xD6CB, [21900] = 0xD6CC, [21901] = 0xD6CD, [21902] = 0xD6CE,
  [21903] = 0xD6CF, [21904] = 0xD6D0, [21905] = 0xD6D1, [21906] = 0xD6D2,
  [21907] = 0xD6D3, [21908] = 0xD6D4, [21909] = 0xD6D5, [21910] = 0xD6D6,
  [21911] = 0xD6D7, [21912] = 0xD6D8, [21913] = 0xD6D9, [21914] = 0xD6DA,
  [21915] = 0xD6DB, [21916] = 0xD6DC, [21917] = 0xD6DD, [21918] = 0xD6DE,
  [21919] = 0xD6DF, [21920] = 0xD6E0, [21921] = 0xD6E1, [21922] = 0xD6E2,
  [21923] = 0xD6E3, [21924] = 0xD6E4, [21925] = 0xD6E5, [21926] = 0xD6E6,
  [21927] = 0xD6E7, [21928] = 0xD6E8, [21929] = 0xD6E9, [21930] = 0xD6EA,
  [21931] = 0xD6EB, [21932] = 0xD6EC, [21933] = 0xD6ED, [21934] = 0xD6EE,
  [21935] = 0xD6EF, [21936] = 0xD6F0, [21937] = 0xD6F1, [21938] = 0xD6F2,
  [21939] = 0xD6F3, [21940] = 0xD6F4, [21941] = 0xD6F5, [21942] = 0xD6F6,
  [21943] = 0xD6F7, [21944] = 0xD6F8, [21945] = 0xD6F9, [21946] = 0xD6FA,
  [21947] = 0xD6FB, [21948] = 0xD6FC, [21949] = 0xD6FD, [21950] = 0xD6FE,
  [22016] = 0xD740, [22017] = 0xD741, [22018] = 0xD742, [22019] = 0xD743,
  [22020] = 0xD744, [22021] = 0xD745, [22022] = 0xD746, [22023] = 0xD747,
  [22024] = 0xD748, [22025] = 0xD749, [22026] = 0xD74A, [22027] = 0xD74B,
  [22028] = 0xD74C, [22029] = 0xD74D, [22030] = 0xD74E, [22031] = 0xD74F,
  [22032] = 0xD750, [22033] = 0xD751, [22034] = 0xD752, [22035] = 0xD753,
  [22036] = 0xD754, [22037] = 0xD755, [22038] = 0xD756, [22039] = 0xD757,
  [22040] = 0xD758, [22041] = 0xD759, [22042] = 0xD75A, [22043] = 0xD75B,
  [22044] = 0xD75C, [22045] = 0xD75D, [22046] = 0xD75E, [22047] = 0xD75F,
  [22048] = 0xD760, [22049] = 0xD761, [22050] = 0xD762, [22051] = 0xD763,
  [22052] = 0xD764, [22053] = 0xD765, [22054] = 0xD766, [22055] = 0xD767,
  [22056] = 0xD768, [22057] = 0xD769, [22058] = 0xD76A, [22059] = 0xD76B,
  [22060] = 0xD76C, [22061] = 0xD76D, [22062] = 0xD76E, [22063] = 0xD76F,
  [22064] = 0xD770, [22065] = 0xD771, [22066] = 0xD772, [22067] = 0xD773,
  [22068] = 0xD774, [22069] = 0xD775, [22070] = 0xD776, [22071] = 0xD777,
  [22072] = 0xD778, [22073] = 0xD779, [22074] = 0xD77A, [22075] = 0xD77B,
  [22076] = 0xD77C, [22077] = 0xD77D, [22078] = 0xD77E, [22080] = 0xD780,
  [22081] = 0xD781, [22082] = 0xD782, [22083] = 0xD783, [22084] = 0xD784,
  [22085] = 0xD785, [22086] = 0xD786, [22087] = 0xD787, [22088] = 0xD788,
  [22089] = 0xD789, [22090] = 0xD78A, [22091] = 0xD78B, [22092] = 0xD78C,
  [22093] = 0xD78D, [22094] = 0xD78E, [22095] = 0xD78F, [22096] = 0xD790,
  [22097] = 0xD791, [22098] = 0xD792, [22099] = 0xD793, [22100] = 0xD794,
  [22101] = 0xD795, [22102] = 0xD796, [22103] = 0xD797, [22104] = 0xD798,
  [22105] = 0xD799, [22106] = 0xD79A, [22107] = 0xD79B, [22108] = 0xD79C,
  [22109] = 0xD79D, [22110] = 0xD79E, [22111] = 0xD79F, [22112] = 0xD7A0,
  [22113] = 0xD7A1, [22114] = 0xD7A2, [22115] = 0xD7A3, [22116] = 0xD7A4,
  [22117] = 0xD7A5, [22118] = 0xD7A6, [22119] = 0xD7A7, [22120] = 0xD7A8,
  [22121] = 0xD7A9, [22122] = 0xD7AA, [22123] = 0xD7AB, [22124] = 0xD7AC,
  [22125] = 0xD7AD, [22126] = 0xD7AE, [22127] = 0xD7AF, [22128] = 0xD7B0,
  [22129] = 0xD7B1, [22130] = 0xD7B2, [22131] = 0xD7B3, [22132] = 0xD7B4,
  [22133] = 0xD7B5, [22134] = 0xD7B6, [22135] = 0xD7B7, [22136] = 0xD7B8,
  [22137] = 0xD7B9, [22138] = 0xD7BA, [22139] = 0xD7BB, [22140] = 0xD7BC,
  [22141] = 0xD7BD, [22142] = 0xD7BE, [22143] = 0xD7BF, [22144] = 0xD7C0,
  [22145] = 0xD7C1, [22146] = 0xD7C2, [22147] = 0xD7C3, [22148] = 0xD7C4,
  [22149] = 0xD7C5, [22150] = 0xD7C6, [22151] = 0xD7C7, [22152] = 0xD7C8,
  [22153] = 0xD7C9, [22154] = 0xD7CA, [22155] = 0xD7CB, [22156] = 0xD7CC,
  [22157] = 0xD7CD, [22158] = 0xD7CE, [22159] = 0xD7CF, [22160] = 0xD7D0,
  [22161] = 0xD7D1, [22162] = 0xD7D2, [22163] = 0xD7D3, [22164] = 0xD7D4,
  [22165] = 0xD7D5, [22166] = 0xD7D6, [22167] = 0xD7D7, [22168] = 0xD7D8,
  [22169] = 0xD7D9, [22170] = 0xD7DA, [22171] = 0xD7DB, [22172] = 0xD7DC,
  [22173] = 0xD7DD, [22174] = 0xD7DE, [22175] = 0xD7DF, [22176] = 0xD7E0,
  [22177] = 0xD7E1, [22178] = 0xD7E2, [22179] = 0xD7E3, [22180] = 0xD7E4,
  [22181] = 0xD7E5, [22182] = 0xD7E6, [22183] = 0xD7E7, [22184] = 0xD7E8,
  [22185] = 0xD7E9, [22186] = 0xD7EA, [22187] = 0xD7EB, [22188] = 0xD7EC,
  [22189] = 0xD7ED, [22190] = 0xD7EE, [22191] = 0xD7EF, [22192] = 0xD7F0,
  [22193] = 0xD7F1, [22194] = 0xD7F2, [22195] = 0xD7F3, [22196] = 0xD7F4,
  [22197] = 0xD7F5, [22198] = 0xD7F6, [22199] = 0xD7F7, [22200] = 0xD7F8,
  [22201] = 0xD7F9, [22202] = 0xD7FA, [22203] = 0xD7FB, [22204] = 0xD7FC,
  [22205] = 0xD7FD, [22206] = 0xD7FE, [22272] = 0xD840, [22273] = 0xD841,
  [22274] = 0xD842, [22275] = 0xD843, [22276] = 0xD844, [22277] = 0xD845,
  [22278] = 0xD846, [22279] = 0xD847, [22280] = 0xD848, [22281] = 0xD849,
  [22282] = 0xD84A, [22283] = 0xD84B, [22284] = 0xD84C, [22285] = 0xD84D,
  [22286] = 0xD84E, [22287] = 0xD84F, [22288] = 0xD850, [22289] = 0xD851,
  [22290] = 0xD852, [22291] = 0xD853, [22292] = 0xD854, [22293] = 0xD855,
  [22294] = 0xD856, [22295] = 0xD857, [22296] = 0xD858, [22297] = 0xD859,
  [22298] = 0xD85A, [22299] = 0xD85B, [22300] = 0xD85C, [22301] = 0xD85D,
  [22302] = 0xD85E, [22303] = 0xD85F, [22304] = 0xD860, [22305] = 0xD861,
  [22306] = 0xD862, [22307] = 0xD863, [22308] = 0xD864, [22309] = 0xD865,
  [22310] = 0xD866, [22311] = 0xD867, [22312] = 0xD868, [22313] = 0xD869,
  [22314] = 0xD86A, [22315] = 0xD86B, [22316] = 0xD86C, [22317] = 0xD86D,
  [22318] = 0xD86E, [22319] = 0xD86F, [22320] = 0xD870, [22321] = 0xD871,
  [22322] = 0xD872, [22323] = 0xD873, [22324] = 0xD874, [22325] = 0xD875,
  [22326] = 0xD876, [22327] = 0xD877, [22328] = 0xD878, [22329] = 0xD879,
  [22330] = 0xD87A, [22331] = 0xD87B, [22332] = 0xD87C, [22333] = 0xD87D,
  [22334] = 0xD87E, [22336] = 0xD880, [22337] = 0xD881, [22338] = 0xD882,
  [22339] = 0xD883, [22340] = 0xD884, [22341] = 0xD885, [22342] = 0xD886,
  [22343] = 0xD887, [22344] = 0xD888, [22345] = 0xD889, [22346] = 0xD88A,
  [22347] = 0xD88B, [22348] = 0xD88C, [22349] = 0xD88D, [22350] = 0xD88E,
  [22351] = 0xD88F, [22352] = 0xD890, [22353] = 0xD891, [22354] = 0xD892,
  [22355] = 0xD893, [22356] = 0xD894, [22357] = 0xD895, [22358] = 0xD896,
  [22359] = 0xD897, [22360] = 0xD898, [22361] = 0xD899, [22362] = 0xD89A,
  [22363] = 0xD89B, [22364] = 0xD89C, [22365] = 0xD89D, [22366] = 0xD89E,
  [22367] = 0xD89F, [22368] = 0xD8A0, [22369] = 0xD8A1, [22370] = 0xD8A2,
  [22371] = 0xD8A3, [22372] = 0xD8A4, [22373] = 0xD8A5, [22374] = 0xD8A6,
  [22375] = 0xD8A7, [22376] = 0xD8A8, [22377] = 0xD8A9, [22378] = 0xD8AA,
  [22379] = 0xD8AB, [22380] = 0xD8AC, [22381] = 0xD8AD, [22382] = 0xD8AE,
  [22383] = 0xD8AF, [22384] = 0xD8B0, [22385] = 0xD8B1, [22386] = 0xD8B2,
  [22387] = 0xD8B3, [22388] = 0xD8B4, [22389] = 0xD8B5, [22390] = 0xD8B6,
  [22391] = 0xD8B7, [22392] = 0xD8B8, [22393] = 0xD8B9, [22394] = 0xD8BA,
  [22395] = 0xD8BB, [22396] = 0xD8BC, [22397] = 0xD8BD, [22398] = 0xD8BE,
  [22399] = 0xD8BF, [22400] = 0xD8C0, [22401] = 0xD8C1, [22402] = 0xD8C2,
  [22403] = 0xD8C3, [22404] = 0xD8C4, [22405] = 0xD8C5, [22406] = 0xD8C6,
  [22407] = 0xD8C7, [22408] = 0xD8C8, [22409] = 0xD8C9, [22410] = 0xD8CA,
  [22411] = 0xD8CB, [22412] = 0xD8CC, [22413] = 0xD8CD, [22414] = 0xD8CE,
  [22415] = 0xD8CF, [22416] = 0xD8D0, [22417] = 0xD8D1, [22418] = 0xD8D2,
  [22419] = 0xD8D3, [22420] = 0xD8D4, [22421] = 0xD8D5, [22422] = 0xD8D6,
  [22423] = 0xD8D7, [22424] = 0xD8D8, [22425] = 0xD8D9, [22426] = 0xD8DA,
  [22427] = 0xD8DB, [22428] = 0xD8DC, [22429] = 0xD8DD, [22430] = 0xD8DE,
  [22431] = 0xD8DF, [22432] = 0xD8E0, [22433] = 0xD8E1, [22434] = 0xD8E2,
  [22435] = 0xD8E3, [22436] = 0xD8E4, [22437] = 0xD8E5, [22438] = 0xD8E6,
  [22439] = 0xD8E7, [22440] = 0xD8E8, [22441] = 0xD8E9, [22442] = 0xD8EA,
  [22443] = 0xD8EB, [22444] = 0xD8EC, [22445] = 0xD8ED, [22446] = 0xD8EE,
  [22447] = 0xD8EF, [22448] = 0xD8F0, [22449] = 0xD8F1, [22450] = 0xD8F2,
  [22451] = 0xD8F3, [22452] = 0xD8F4, [22453] = 0xD8F5, [22454] = 0xD8F6,
  [22455] = 0xD8F7, [22456] = 0xD8F8, [22457] = 0xD8F9, [22458] = 0xD8FA,
  [22459] = 0xD8FB, [22460] = 0xD8FC, [22461] = 0xD8FD, [22462] = 0xD8FE,
  [22528] = 0xD940, [22529] = 0xD941, [22530] = 0xD942, [22531] = 0xD943,
  [22532] = 0xD944, [22533] = 0xD945, [22534] = 0xD946, [22535] = 0xD947,
  [22536] = 0xD948, [22537] = 0xD949, [22538] = 0xD94A, [22539] = 0xD94B,
  [22540] = 0xD94C, [22541] = 0xD94D, [22542] = 0xD94E, [22543] = 0xD94F,
  [22544] = 0xD950, [22545] = 0xD951, [22546] = 0xD952, [22547] = 0xD953,
  [22548] = 0xD954, [22549] = 0xD955, [22550] = 0xD956, [22551] = 0xD957,
  [22552] = 0xD958, [22553] = 0xD959, [22554] = 0xD95A, [22555] = 0xD95B,
  [22556] = 0xD95C, [22557] = 0xD95D, [22558] = 0xD95E, [22559] = 0xD95F,
  [22560] = 0xD960, [22561] = 0xD961, [22562] = 0xD962, [22563] = 0xD963,
  [22564] = 0xD964, [22565] = 0xD965, [22566] = 0xD966, [22567] = 0xD967,
  [22568] = 0xD968, [22569] = 0xD969, [22570] = 0xD96A, [22571] = 0xD96B,
  [22572] = 0xD96C, [22573] = 0xD96D, [22574] = 0xD96E, [22575] = 0xD96F,
  [22576] = 0xD970, [22577] = 0xD971, [22578] = 0xD972, [22579] = 0xD973,
  [22580] = 0xD974, [22581] = 0xD975, [22582] = 0xD976, [22583] = 0xD977,
  [22584] = 0xD978, [22585] = 0xD979, [22586] = 0xD97A, [22587] = 0xD97B,
  [22588] = 0xD97C, [22589] = 0xD97D, [22590] = 0xD97E, [22592] = 0xD980,
  [22593] = 0xD981, [22594] = 0xD982, [22595] = 0xD983, [22596] = 0xD984,
  [22597] = 0xD985, [22598] = 0xD986, [22599] = 0xD987, [22600] = 0xD988,
  [22601] = 0xD989, [22602] = 0xD98A, [22603] = 0xD98B, [22604] = 0xD98C,
  [22605] = 0xD98D, [22606] = 0xD98E, [22607] = 0xD98F, [22608] = 0xD990,
  [22609] = 0xD991, [22610] = 0xD992, [22611] = 0xD993, [22612] = 0xD994,
  [22613] = 0xD995, [22614] = 0xD996, [22615] = 0xD997, [22616] = 0xD998,
  [22617] = 0xD999, [22618] = 0xD99A, [22619] = 0xD99B, [22620] = 0xD99C,
  [22621] = 0xD99D, [22622] = 0xD99E, [22623] = 0xD99F, [22624] = 0xD9A0,
  [22625] = 0xD9A1, [22626] = 0xD9A2, [22627] = 0xD9A3, [22628] = 0xD9A4,
  [22629] = 0xD9A5, [22630] = 0xD9A6, [22631] = 0xD9A7, [22632] = 0xD9A8,
  [22633] = 0xD9A9, [22634] = 0xD9AA, [22635] = 0xD9AB, [22636] = 0xD9AC,
  [22637] = 0xD9AD, [22638] = 0xD9AE, [22639] = 0xD9AF, [22640] = 0xD9B0,
  [22641] = 0xD9B1, [22642] = 0xD9B2, [22643] = 0xD9B3, [22644] = 0xD9B4,
  [22645] = 0xD9B5, [22646] = 0xD9B6, [22647] = 0xD9B7, [22648] = 0xD9B8,
  [22649] = 0xD9B9, [22650] = 0xD9BA, [22651] = 0xD9BB, [22652] = 0xD9BC,
  [22653] = 0xD9BD, [22654] = 0xD9BE, [22655] = 0xD9BF, [22656] = 0xD9C0,
  [22657] = 0xD9C1, [22658] = 0xD9C2, [22659] = 0xD9C3, [22660] = 0xD9C4,
  [22661] = 0xD9C5, [22662] = 0xD9C6, [22663] = 0xD9C7, [22664] = 0xD9C8,
  [22665] = 0xD9C9, [22666] = 0xD9CA, [22667] = 0xD9CB, [22668] = 0xD9CC,
  [22669] = 0xD9CD, [22670] = 0xD9CE, [22671] = 0xD9CF, [22672] = 0xD9D0,
  [22673] = 0xD9D1, [22674] = 0xD9D2, [22675] = 0xD9D3, [22676] = 0xD9D4,
  [22677] = 0xD9D5, [22678] = 0xD9D6, [22679] = 0xD9D7, [22680] = 0xD9D8,
  [22681] = 0xD9D9, [22682] = 0xD9DA, [22683] = 0xD9DB, [22684] = 0xD9DC,
  [22685] = 0xD9DD, [22686] = 0xD9DE, [22687] = 0xD9DF, [22688] = 0xD9E0,
  [22689] = 0xD9E1, [22690] = 0xD9E2, [22691] = 0xD9E3, [22692] = 0xD9E4,
  [22693] = 0xD9E5, [22694] = 0xD9E6, [22695] = 0xD9E7, [22696] = 0xD9E8,
  [22697] = 0xD9E9, [22698] = 0xD9EA, [22699] = 0xD9EB, [22700] = 0xD9EC,
  [22701] = 0xD9ED, [22702] = 0xD9EE, [22703] = 0xD9EF, [22704] = 0xD9F0,
  [22705] = 0xD9F1, [22706] = 0xD9F2, [22707] = 0xD9F3, [22708] = 0xD9F4,
  [22709] = 0xD9F5, [22710] = 0xD9F6, [22711] = 0xD9F7, [22712] = 0xD9F8,
  [22713] = 0xD9F9, [22714] = 0xD9FA, [22715] = 0xD9FB, [22716] = 0xD9FC,
  [22717] = 0xD9FD, [22718] = 0xD9FE, [22784] = 0xDA40, [22785] = 0xDA41,
  [22786] = 0xDA42, [22787] = 0xDA43, [22788] = 0xDA44, [22789] = 0xDA45,
  [22790] = 0xDA46, [22791] = 0xDA47, [22792] = 0xDA48, [22793] = 0xDA49,
  [22794] = 0xDA4A, [22795] = 0xDA4B, [22796] = 0xDA4C, [22797] = 0xDA4D,
  [22798] = 0xDA4E, [22799] = 0xDA4F, [22800] = 0xDA50, [22801] = 0xDA51,
  [22802] = 0xDA52, [22803] = 0xDA53, [22804] = 0xDA54, [22805] = 0xDA55,
  [22806] = 0xDA56, [22807] = 0xDA57, [22808] = 0xDA58, [22809] = 0xDA59,
  [22810] = 0xDA5A, [22811] = 0xDA5B, [22812] = 0xDA5C, [22813] = 0xDA5D,
  [22814] = 0xDA5E, [22815] = 0xDA5F, [22816] = 0xDA60, [22817] = 0xDA61,
  [22818] = 0xDA62, [22819] = 0xDA63, [22820] = 0xDA64, [22821] = 0xDA65,
  [22822] = 0xDA66, [22823] = 0xDA67, [22824] = 0xDA68, [22825] = 0xDA69,
  [22826] = 0xDA6A, [22827] = 0xDA6B, [22828] = 0xDA6C, [22829] = 0xDA6D,
  [22830] = 0xDA6E, [22831] = 0xDA6F, [22832] = 0xDA70, [22833] = 0xDA71,
  [22834] = 0xDA72, [22835] = 0xDA73, [22836] = 0xDA74, [22837] = 0xDA75,
  [22838] = 0xDA76, [22839] = 0xDA77, [22840] = 0xDA78, [22841] = 0xDA79,
  [22842] = 0xDA7A, [22843] = 0xDA7B, [22844] = 0xDA7C, [22845] = 0xDA7D,
  [22846] = 0xDA7E, [22848] = 0xDA80, [22849] = 0xDA81, [22850] = 0xDA82,
  [22851] = 0xDA83, [22852] = 0xDA84, [22853] = 0xDA85, [22854] = 0xDA86,
  [22855] = 0xDA87, [22856] = 0xDA88, [22857] = 0xDA89, [22858] = 0xDA8A,
  [22859] = 0xDA8B, [22860] = 0xDA8C, [22861] = 0xDA8D, [22862] = 0xDA8E,
  [22863] = 0xDA8F, [22864] = 0xDA90, [22865] = 0xDA91, [22866] = 0xDA92,
  [22867] = 0xDA93, [22868] = 0xDA94, [22869] = 0xDA95, [22870] = 0xDA96,
  [22871] = 0xDA97, [22872] = 0xDA98, [22873] = 0xDA99, [22874] = 0xDA9A,
  [22875] = 0xDA9B, [22876] = 0xDA9C, [22877] = 0xDA9D, [22878] = 0xDA9E,
  [22879] = 0xDA9F, [22880] = 0xDAA0, [22881] = 0xDAA1, [22882] = 0xDAA2,
  [22883] = 0xDAA3, [22884] = 0xDAA4, [22885] = 0xDAA5, [22886] = 0xDAA6,
  [22887] = 0xDAA7, [22888] = 0xDAA8, [22889] = 0xDAA9, [22890] = 0xDAAA,
  [22891] = 0xDAAB, [22892] = 0xDAAC, [22893] = 0xDAAD, [22894] = 0xDAAE,
  [22895] = 0xDAAF, [22896] = 0xDAB0, [22897] = 0xDAB1, [22898] = 0xDAB2,
  [22899] = 0xDAB3, [22900] = 0xDAB4, [22901] = 0xDAB5, [22902] = 0xDAB6,
  [22903] = 0xDAB7, [22904] = 0xDAB8, [22905] = 0xDAB9, [22906] = 0xDABA,
  [22907] = 0xDABB, [22908] = 0xDABC, [22909] = 0xDABD, [22910] = 0xDABE,
  [22911] = 0xDABF, [22912] = 0xDAC0, [22913] = 0xDAC1, [22914] = 0xDAC2,
  [22915] = 0xDAC3, [22916] = 0xDAC4, [22917] = 0xDAC5, [22918] = 0xDAC6,
  [22919] = 0xDAC7, [22920] = 0xDAC8, [22921] = 0xDAC9, [22922] = 0xDACA,
  [22923] = 0xDACB, [22924] = 0xDACC, [22925] = 0xDACD, [22926] = 0xDACE,
  [22927] = 0xDACF, [22928] = 0xDAD0, [22929] = 0xDAD1, [22930] = 0xDAD2,
  [22931] = 0xDAD3, [22932] = 0xDAD4, [22933] = 0xDAD5, [22934] = 0xDAD6,
  [22935] = 0xDAD7, [22936] = 0xDAD8, [22937] = 0xDAD9, [22938] = 0xDADA,
  [22939] = 0xDADB, [22940] = 0xDADC, [22941] = 0xDADD, [22942] = 0xDADE,
  [22943] = 0xDADF, [22944] = 0xDAE0, [22945] = 0xDAE1, [22946] = 0xDAE2,
  [22947] = 0xDAE3, [22948] = 0xDAE4, [22949] = 0xDAE5, [22950] = 0xDAE6,
  [22951] = 0xDAE7, [22952] = 0xDAE8, [22953] = 0xDAE9, [22954] = 0xDAEA,
  [22955] = 0xDAEB, [22956] = 0xDAEC, [22957] = 0xDAED, [22958] = 0xDAEE,
  [22959] = 0xDAEF, [22960] = 0xDAF0, [22961] = 0xDAF1, [22962] = 0xDAF2,
  [22963] = 0xDAF3, [22964] = 0xDAF4, [22965] = 0xDAF5, [22966] = 0xDAF6,
  [22967] = 0xDAF7, [22968] = 0xDAF8, [22969] = 0xDAF9, [22970] = 0xDAFA,
  [22971] = 0xDAFB, [22972] = 0xDAFC, [22973] = 0xDAFD, [22974] = 0xDAFE,
  [23040] = 0xDB40, [23041] = 0xDB41, [23042] = 0xDB42, [23043] = 0xDB43,
  [23044] = 0xDB44, [23045] = 0xDB45, [23046] = 0xDB46, [23047] = 0xDB47,
  [23048] = 0xDB48, [23049] = 0xDB49, [23050] = 0xDB4A, [23051] = 0xDB4B,
  [23052] = 0xDB4C, [23053] = 0xDB4D, [23054] = 0xDB4E, [23055] = 0xDB4F,
  [23056] = 0xDB50, [23057] = 0xDB51, [23058] = 0xDB52, [23059] = 0xDB53,
  [23060] = 0xDB54, [23061] = 0xDB55, [23062] = 0xDB56, [23063] = 0xDB57,
  [23064] = 0xDB58, [23065] = 0xDB59, [23066] = 0xDB5A, [23067] = 0xDB5B,
  [23068] = 0xDB5C, [23069] = 0xDB5D, [23070] = 0xDB5E, [23071] = 0xDB5F,
  [23072] = 0xDB60, [23073] = 0xDB61, [23074] = 0xDB62, [23075] = 0xDB63,
  [23076] = 0xDB64, [23077] = 0xDB65, [23078] = 0xDB66, [23079] = 0xDB67,
  [23080] = 0xDB68, [23081] = 0xDB69, [23082] = 0xDB6A, [23083] = 0xDB6B,
  [23084] = 0xDB6C, [23085] = 0xDB6D, [23086] = 0xDB6E, [23087] = 0xDB6F,
  [23088] = 0xDB70, [23089] = 0xDB71, [23090] = 0xDB72, [23091] = 0xDB73,
  [23092] = 0xDB74, [23093] = 0xDB75, [23094] = 0xDB76, [23095] = 0xDB77,
  [23096] = 0xDB78, [23097] = 0xDB79, [23098] = 0xDB7A, [23099] = 0xDB7B,
  [23100] = 0xDB7C, [23101] = 0xDB7D, [23102] = 0xDB7E, [23104] = 0xDB80,
  [23105] = 0xDB81, [23106] = 0xDB82, [23107] = 0xDB83, [23108] = 0xDB84,
  [23109] = 0xDB85, [23110] = 0xDB86, [23111] = 0xDB87, [23112] = 0xDB88,
  [23113] = 0xDB89, [23114] = 0xDB8A, [23115] = 0xDB8B, [23116] = 0xDB8C,
  [23117] = 0xDB8D, [23118] = 0xDB8E, [23119] = 0xDB8F, [23120] = 0xDB90,
  [23121] = 0xDB91, [23122] = 0xDB92, [23123] = 0xDB93, [23124] = 0xDB94,
  [23125] = 0xDB95, [23126] = 0xDB96, [23127] = 0xDB97, [23128] = 0xDB98,
  [23129] = 0xDB99, [23130] = 0xDB9A, [23131] = 0xDB9B, [23132] = 0xDB9C,
  [23133] = 0xDB9D, [23134] = 0xDB9E, [23135] = 0xDB9F, [23136] = 0xDBA0,
  [23137] = 0xDBA1, [23138] = 0xDBA2, [23139] = 0xDBA3, [23140] = 0xDBA4,
  [23141] = 0xDBA5, [23142] = 0xDBA6, [23143] = 0xDBA7, [23144] = 0xDBA8,
  [23145] = 0xDBA9, [23146] = 0xDBAA, [23147] = 0xDBAB, [23148] = 0xDBAC,
  [23149] = 0xDBAD, [23150] = 0xDBAE, [23151] = 0xDBAF, [23152] = 0xDBB0,
  [23153] = 0xDBB1, [23154] = 0xDBB2, [23155] = 0xDBB3, [23156] = 0xDBB4,
  [23157] = 0xDBB5, [23158] = 0xDBB6, [23159] = 0xDBB7, [23160] = 0xDBB8,
  [23161] = 0xDBB9, [23162] = 0xDBBA, [23163] = 0xDBBB, [23164] = 0xDBBC,
  [23165] = 0xDBBD, [23166] = 0xDBBE, [23167] = 0xDBBF, [23168] = 0xDBC0,
  [23169] = 0xDBC1, [23170] = 0xDBC2, [23171] = 0xDBC3, [23172] = 0xDBC4,
  [23173] = 0xDBC5, [23174] = 0xDBC6, [23175] = 0xDBC7, [23176] = 0xDBC8,
  [23177] = 0xDBC9, [23178] = 0xDBCA, [23179] = 0xDBCB, [23180] = 0xDBCC,
  [23181] = 0xDBCD, [23182] = 0xDBCE, [23183] = 0xDBCF, [23184] = 0xDBD0,
  [23185] = 0xDBD1, [23186] = 0xDBD2, [23187] = 0xDBD3, [23188] = 0xDBD4,
  [23189] = 0xDBD5, [23190] = 0xDBD6, [23191] = 0xDBD7, [23192] = 0xDBD8,
  [23193] = 0xDBD9, [23194] = 0xDBDA, [23195] = 0xDBDB, [23196] = 0xDBDC,
  [23197] = 0xDBDD, [23198] = 0xDBDE, [23199] = 0xDBDF, [23200] = 0xDBE0,
  [23201] = 0xDBE1, [23202] = 0xDBE2, [23203] = 0xDBE3, [23204] = 0xDBE4,
  [23205] = 0xDBE5, [23206] = 0xDBE6, [23207] = 0xDBE7, [23208] = 0xDBE8,
  [23209] = 0xDBE9, [23210] = 0xDBEA, [23211] = 0xDBEB, [23212] = 0xDBEC,
  [23213] = 0xDBED, [23214] = 0xDBEE, [23215] = 0xDBEF, [23216] = 0xDBF0,
  [23217] = 0xDBF1, [23218] = 0xDBF2, [23219] = 0xDBF3, [23220] = 0xDBF4,
  [23221] = 0xDBF5, [23222] = 0xDBF6, [23223] = 0xDBF7, [23224] = 0xDBF8,
  [23225] = 0xDBF9, [23226] = 0xDBFA, [23227] = 0xDBFB, [23228] = 0xDBFC,
  [23229] = 0xDBFD, [23230] = 0xDBFE, [23296] = 0xDC40, [23297] = 0xDC41,
  [23298] = 0xDC42, [23299] = 0xDC43, [23300] = 0xDC44, [23301] = 0xDC45,
  [23302] = 0xDC46, [23303] = 0xDC47, [23304] = 0xDC48, [23305] = 0xDC49,
  [23306] = 0xDC4A, [23307] = 0xDC4B, [23308] = 0xDC4C, [23309] = 0xDC4D,
  [23310] = 0xDC4E, [23311] = 0xDC4F, [23312] = 0xDC50, [23313] = 0xDC51,
  [23314] = 0xDC52, [23315] = 0xDC53, [23316] = 0xDC54, [23317] = 0xDC55,
  [23318] = 0xDC56, [23319] = 0xDC57, [23320] = 0xDC58, [23321] = 0xDC59,
  [23322] = 0xDC5A, [23323] = 0xDC5B, [23324] = 0xDC5C, [23325] = 0xDC5D,
  [23326] = 0xDC5E, [23327] = 0xDC5F, [23328] = 0xDC60, [23329] = 0xDC61,
  [23330] = 0xDC62, [23331] = 0xDC63, [23332] = 0xDC64, [23333] = 0xDC65,
  [23334] = 0xDC66, [23335] = 0xDC67, [23336] = 0xDC68, [23337] = 0xDC69,
  [23338] = 0xDC6A, [23339] = 0xDC6B, [23340] = 0xDC6C, [23341] = 0xDC6D,
  [23342] = 0xDC6E, [23343] = 0xDC6F, [23344] = 0xDC70, [23345] = 0xDC71,
  [23346] = 0xDC72, [23347] = 0xDC73, [23348] = 0xDC74, [23349] = 0xDC75,
  [23350] = 0xDC76, [23351] = 0xDC77, [23352] = 0xDC78, [23353] = 0xDC79,
  [23354] = 0xDC7A, [23355] = 0xDC7B, [23356] = 0xDC7C, [23357] = 0xDC7D,
  [23358] = 0xDC7E, [23360] = 0xDC80, [23361] = 0xDC81, [23362] = 0xDC82,
  [23363] = 0xDC83, [23364] = 0xDC84, [23365] = 0xDC85, [23366] = 0xDC86,
  [23367] = 0xDC87, [23368] = 0xDC88, [23369] = 0xDC89, [23370] = 0xDC8A,
  [23371] = 0xDC8B, [23372] = 0xDC8C, [23373] = 0xDC8D, [23374] = 0xDC8E,
  [23375] = 0xDC8F, [23376] = 0xDC90, [23377] = 0xDC91, [23378] = 0xDC92,
  [23379] = 0xDC93, [23380] = 0xDC94, [23381] = 0xDC95, [23382] = 0xDC96,
  [23383] = 0xDC97, [23384] = 0xDC98, [23385] = 0xDC99, [23386] = 0xDC9A,
  [23387] = 0xDC9B, [23388] = 0xDC9C, [23389] = 0xDC9D, [23390] = 0xDC9E,
  [23391] = 0xDC9F, [23392] = 0xDCA0, [23393] = 0xDCA1, [23394] = 0xDCA2,
  [23395] = 0xDCA3, [23396] = 0xDCA4, [23397] = 0xDCA5, [23398] = 0xDCA6,
  [23399] = 0xDCA7, [23400] = 0xDCA8, [23401] = 0xDCA9, [23402] = 0xDCAA,
  [23403] = 0xDCAB, [23404] = 0xDCAC, [23405] = 0xDCAD, [23406] = 0xDCAE,
  [23407] = 0xDCAF, [23408] = 0xDCB0, [23409] = 0xDCB1, [23410] = 0xDCB2,
  [23411] = 0xDCB3, [23412] = 0xDCB4, [23413] = 0xDCB5, [23414] = 0xDCB6,
  [23415] = 0xDCB7, [23416] = 0xDCB8, [23417] = 0xDCB9, [23418] = 0xDCBA,
  [23419] = 0xDCBB, [23420] = 0xDCBC, [23421] = 0xDCBD, [23422] = 0xDCBE,
  [23423] = 0xDCBF, [23424] = 0xDCC0, [23425] = 0xDCC1, [23426] = 0xDCC2,
  [23427] = 0xDCC3, [23428] = 0xDCC4, [23429] = 0xDCC5, [23430] = 0xDCC6,
  [23431] = 0xDCC7, [23432] = 0xDCC8, [23433] = 0xDCC9, [23434] = 0xDCCA,
  [23435] = 0xDCCB, [23436] = 0xDCCC, [23437] = 0xDCCD, [23438] = 0xDCCE,
  [23439] = 0xDCCF, [23440] = 0xDCD0, [23441] = 0xDCD1, [23442] = 0xDCD2,
  [23443] = 0xDCD3, [23444] = 0xDCD4, [23445] = 0xDCD5, [23446] = 0xDCD6,
  [23447] = 0xDCD7, [23448] = 0xDCD8, [23449] = 0xDCD9, [23450] = 0xDCDA,
  [23451] = 0xDCDB, [23452] = 0xDCDC, [23453] = 0xDCDD, [23454] = 0xDCDE,
  [23455] = 0xDCDF, [23456] = 0xDCE0, [23457] = 0xDCE1, [23458] = 0xDCE2,
  [23459] = 0xDCE3, [23460] = 0xDCE4, [23461] = 0xDCE5, [23462] = 0xDCE6,
  [23463] = 0xDCE7, [23464] = 0xDCE8, [23465] = 0xDCE9, [23466] = 0xDCEA,
  [23467] = 0xDCEB, [23468] = 0xDCEC, [23469] = 0xDCED, [23470] = 0xDCEE,
  [23471] = 0xDCEF, [23472] = 0xDCF0, [23473] = 0xDCF1, [23474] = 0xDCF2,
  [23475] = 0xDCF3, [23476] = 0xDCF4, [23477] = 0xDCF5, [23478] = 0xDCF6,
  [23479] = 0xDCF7, [23480] = 0xDCF8, [23481] = 0xDCF9, [23482] = 0xDCFA,
  [23483] = 0xDCFB, [23484] = 0xDCFC, [23485] = 0xDCFD, [23486] = 0xDCFE,
  [23552] = 0xDD40, [23553] = 0xDD41, [23554] = 0xDD42, [23555] = 0xDD43,
  [23556] = 0xDD44, [23557] = 0xDD45, [23558] = 0xDD46, [23559] = 0xDD47,
  [23560] = 0xDD48, [23561] = 0xDD49, [23562] = 0xDD4A, [23563] = 0xDD4B,
  [23564] = 0xDD4C, [23565] = 0xDD4D, [23566] = 0xDD4E, [23567] = 0xDD4F,
  [23568] = 0xDD50, [23569] = 0xDD51, [23570] = 0xDD52, [23571] = 0xDD53,
  [23572] = 0xDD54, [23573] = 0xDD55, [23574] = 0xDD56, [23575] = 0xDD57,
  [23576] = 0xDD58, [23577] = 0xDD59, [23578] = 0xDD5A, [23579] = 0xDD5B,
  [23580] = 0xDD5C, [23581] = 0xDD5D, [23582] = 0xDD5E, [23583] = 0xDD5F,
  [23584] = 0xDD60, [23585] = 0xDD61, [23586] = 0xDD62, [23587] = 0xDD63,
  [23588] = 0xDD64, [23589] = 0xDD65, [23590] = 0xDD66, [23591] = 0xDD67,
  [23592] = 0xDD68, [23593] = 0xDD69, [23594] = 0xDD6A, [23595] = 0xDD6B,
  [23596] = 0xDD6C, [23597] = 0xDD6D, [23598] = 0xDD6E, [23599] = 0xDD6F,
  [23600] = 0xDD70, [23601] = 0xDD71, [23602] = 0xDD72, [23603] = 0xDD73,
  [23604] = 0xDD74, [23605] = 0xDD75, [23606] = 0xDD76, [23607] = 0xDD77,
  [23608] = 0xDD78, [23609] = 0xDD79, [23610] = 0xDD7A, [23611] = 0xDD7B,
  [23612] = 0xDD7C, [23613] = 0xDD7D, [23614] = 0xDD7E, [23616] = 0xDD80,
  [23617] = 0xDD81, [23618] = 0xDD82, [23619] = 0xDD83, [23620] = 0xDD84,
  [23621] = 0xDD85, [23622] = 0xDD86, [23623] = 0xDD87, [23624] = 0xDD88,
  [23625] = 0xDD89, [23626] = 0xDD8A, [23627] = 0xDD8B, [23628] = 0xDD8C,
  [23629] = 0xDD8D, [23630] = 0xDD8E, [23631] = 0xDD8F, [23632] = 0xDD90,
  [23633] = 0xDD91, [23634] = 0xDD92, [23635] = 0xDD93, [23636] = 0xDD94,
  [23637] = 0xDD95, [23638] = 0xDD96, [23639] = 0xDD97, [23640] = 0xDD98,
  [23641] = 0xDD99, [23642] = 0xDD9A, [23643] = 0xDD9B, [23644] = 0xDD9C,
  [23645] = 0xDD9D, [23646] = 0xDD9E, [23647] = 0xDD9F, [23648] = 0xDDA0,
  [23649] = 0xDDA1, [23650] = 0xDDA2, [23651] = 0xDDA3, [23652] = 0xDDA4,
  [23653] = 0xDDA5, [23654] = 0xDDA6, [23655] = 0xDDA7, [23656] = 0xDDA8,
  [23657] = 0xDDA9, [23658] = 0xDDAA, [23659] = 0xDDAB, [23660] = 0xDDAC,
  [23661] = 0xDDAD, [23662] = 0xDDAE, [23663] = 0xDDAF, [23664] = 0xDDB0,
  [23665] = 0xDDB1, [23666] = 0xDDB2, [23667] = 0xDDB3, [23668] = 0xDDB4,
  [23669] = 0xDDB5, [23670] = 0xDDB6, [23671] = 0xDDB7, [23672] = 0xDDB8,
  [23673] = 0xDDB9, [23674] = 0xDDBA, [23675] = 0xDDBB, [23676] = 0xDDBC,
  [23677] = 0xDDBD, [23678] = 0xDDBE, [23679] = 0xDDBF, [23680] = 0xDDC0,
  [23681] = 0xDDC1, [23682] = 0xDDC2, [23683] = 0xDDC3, [23684] = 0xDDC4,
  [23685] = 0xDDC5, [23686] = 0xDDC6, [23687] = 0xDDC7, [23688] = 0xDDC8,
  [23689] = 0xDDC9, [23690] = 0xDDCA, [23691] = 0xDDCB, [23692] = 0xDDCC,
  [23693] = 0xDDCD, [23694] = 0xDDCE, [23695] = 0xDDCF, [23696] = 0xDDD0,
  [23697] = 0xDDD1, [23698] = 0xDDD2, [23699] = 0xDDD3, [23700] = 0xDDD4,
  [23701] = 0xDDD5, [23702] = 0xDDD6, [23703] = 0xDDD7, [23704] = 0xDDD8,
  [23705] = 0xDDD9, [23706] = 0xDDDA, [23707] = 0xDDDB, [23708] = 0xDDDC,
  [23709] = 0xDDDD, [23710] = 0xDDDE, [23711] = 0xDDDF, [23712] = 0xDDE0,
  [23713] = 0xDDE1, [23714] = 0xDDE2, [23715] = 0xDDE3, [23716] = 0xDDE4,
  [23717] = 0xDDE5, [23718] = 0xDDE6, [23719] = 0xDDE7, [23720] = 0xDDE8,
  [23721] = 0xDDE9, [23722] = 0xDDEA, [23723] = 0xDDEB, [23724] = 0xDDEC,
  [23725] = 0xDDED, [23726] = 0xDDEE, [23727] = 0xDDEF, [23728] = 0xDDF0,
  [23729] = 0xDDF1, [23730] = 0xDDF2, [23731] = 0xDDF3, [23732] = 0xDDF4,
  [23733] = 0xDDF5, [23734] = 0xDDF6, [23735] = 0xDDF7, [23736] = 0xDDF8,
  [23737] = 0xDDF9, [23738] = 0xDDFA, [23739] = 0xDDFB, [23740] = 0xDDFC,
  [23741] = 0xDDFD, [23742] = 0xDDFE, [23808] = 0xDE40, [23809] = 0xDE41,
  [23810] = 0xDE42, [23811] = 0xDE43, [23812] = 0xDE44, [23813] = 0xDE45,
  [23814] = 0xDE46, [23815] = 0xDE47, [23816] = 0xDE48, [23817] = 0xDE49,
  [23818] = 0xDE4A, [23819] = 0xDE4B, [23820] = 0xDE4C, [23821] = 0xDE4D,
  [23822] = 0xDE4E, [23823] = 0xDE4F, [23824] = 0xDE50, [23825] = 0xDE51,
  [23826] = 0xDE52, [23827] = 0xDE53, [23828] = 0xDE54, [23829] = 0xDE55,
  [23830] = 0xDE56, [23831] = 0xDE57, [23832] = 0xDE58, [23833] = 0xDE59,
  [23834] = 0xDE5A, [23835] = 0xDE5B, [23836] = 0xDE5C, [23837] = 0xDE5D,
  [23838] = 0xDE5E, [23839] = 0xDE5F, [23840] = 0xDE60, [23841] = 0xDE61,
  [23842] = 0xDE62, [23843] = 0xDE63, [23844] = 0xDE64, [23845] = 0xDE65,
  [23846] = 0xDE66, [23847] = 0xDE67, [23848] = 0xDE68, [23849] = 0xDE69,
  [23850] = 0xDE6A, [23851] = 0xDE6B, [23852] = 0xDE6C, [23853] = 0xDE6D,
  [23854] = 0xDE6E, [23855] = 0xDE6F, [23856] = 0xDE70, [23857] = 0xDE71,
  [23858] = 0xDE72, [23859] = 0xDE73, [23860] = 0xDE74, [23861] = 0xDE75,
  [23862] = 0xDE76, [23863] = 0xDE77, [23864] = 0xDE78, [23865] = 0xDE79,
  [23866] = 0xDE7A, [23867] = 0xDE7B, [23868] = 0xDE7C, [23869] = 0xDE7D,
  [23870] = 0xDE7E, [23872] = 0xDE80, [23873] = 0xDE81, [23874] = 0xDE82,
  [23875] = 0xDE83, [23876] = 0xDE84, [23877] = 0xDE85, [23878] = 0xDE86,
  [23879] = 0xDE87, [23880] = 0xDE88, [23881] = 0xDE89, [23882] = 0xDE8A,
  [23883] = 0xDE8B, [23884] = 0xDE8C, [23885] = 0xDE8D, [23886] = 0xDE8E,
  [23887] = 0xDE8F, [23888] = 0xDE90, [23889] = 0xDE91, [23890] = 0xDE92,
  [23891] = 0xDE93, [23892] = 0xDE94, [23893] = 0xDE95, [23894] = 0xDE96,
  [23895] = 0xDE97, [23896] = 0xDE98, [23897] = 0xDE99, [23898] = 0xDE9A,
  [23899] = 0xDE9B, [23900] = 0xDE9C, [23901] = 0xDE9D, [23902] = 0xDE9E,
  [23903] = 0xDE9F, [23904] = 0xDEA0, [23905] = 0xDEA1, [23906] = 0xDEA2,
  [23907] = 0xDEA3, [23908] = 0xDEA4, [23909] = 0xDEA5, [23910] = 0xDEA6,
  [23911] = 0xDEA7, [23912] = 0xDEA8, [23913] = 0xDEA9, [23914] = 0xDEAA,
  [23915] = 0xDEAB, [23916] = 0xDEAC, [23917] = 0xDEAD, [23918] = 0xDEAE,
  [23919] = 0xDEAF, [23920] = 0xDEB0, [23921] = 0xDEB1, [23922] = 0xDEB2,
  [23923] = 0xDEB3, [23924] = 0xDEB4, [23925] = 0xDEB5, [23926] = 0xDEB6,
  [23927] = 0xDEB7, [23928] = 0xDEB8, [23929] = 0xDEB9, [23930] = 0xDEBA,
  [23931] = 0xDEBB, [23932] = 0xDEBC, [23933] = 0xDEBD, [23934] = 0xDEBE,
  [23935] = 0xDEBF, [23936] = 0xDEC0, [23937] = 0xDEC1, [23938] = 0xDEC2,
  [23939] = 0xDEC3, [23940] = 0xDEC4, [23941] = 0xDEC5, [23942] = 0xDEC6,
  [23943] = 0xDEC7, [23944] = 0xDEC8, [23945] = 0xDEC9, [23946] = 0xDECA,
  [23947] = 0xDECB, [23948] = 0xDECC, [23949] = 0xDECD, [23950] = 0xDECE,
  [23951] = 0xDECF, [23952] = 0xDED0, [23953] = 0xDED1, [23954] = 0xDED2,
  [23955] = 0xDED3, [23956] = 0xDED4, [23957] = 0xDED5, [23958] = 0xDED6,
  [23959] = 0xDED7, [23960] = 0xDED8, [23961] = 0xDED9, [23962] = 0xDEDA,
  [23963] = 0xDEDB, [23964] = 0xDEDC, [23965] = 0xDEDD, [23966] = 0xDEDE,
  [23967] = 0xDEDF, [23968] = 0xDEE0, [23969] = 0xDEE1, [23970] = 0xDEE2,
  [23971] = 0xDEE3, [23972] = 0xDEE4, [23973] = 0xDEE5, [23974] = 0xDEE6,
  [23975] = 0xDEE7, [23976] = 0xDEE8, [23977] = 0xDEE9, [23978] = 0xDEEA,
  [23979] = 0xDEEB, [23980] = 0xDEEC, [23981] = 0xDEED, [23982] = 0xDEEE,
  [23983] = 0xDEEF, [23984] = 0xDEF0, [23985] = 0xDEF1, [23986] = 0xDEF2,
  [23987] = 0xDEF3, [23988] = 0xDEF4, [23989] = 0xDEF5, [23990] = 0xDEF6,
  [23991] = 0xDEF7, [23992] = 0xDEF8, [23993] = 0xDEF9, [23994] = 0xDEFA,
  [23995] = 0xDEFB, [23996] = 0xDEFC, [23997] = 0xDEFD, [23998] = 0xDEFE,
  [24064] = 0xDF40, [24065] = 0xDF41, [24066] = 0xDF42, [24067] = 0xDF43,
  [24068] = 0xDF44, [24069] = 0xDF45, [24070] = 0xDF46, [24071] = 0xDF47,
  [24072] = 0xDF48, [24073] = 0xDF49, [24074] = 0xDF4A, [24075] = 0xDF4B,
  [24076] = 0xDF4C, [24077] = 0xDF4D, [24078] = 0xDF4E, [24079] = 0xDF4F,
  [24080] = 0xDF50, [24081] = 0xDF51, [24082] = 0xDF52, [24083] = 0xDF53,
  [24084] = 0xDF54, [24085] = 0xDF55, [24086] = 0xDF56, [24087] = 0xDF57,
  [24088] = 0xDF58, [24089] = 0xDF59, [24090] = 0xDF5A, [24091] = 0xDF5B,
  [24092] = 0xDF5C, [24093] = 0xDF5D, [24094] = 0xDF5E, [24095] = 0xDF5F,
  [24096] = 0xDF60, [24097] = 0xDF61, [24098] = 0xDF62, [24099] = 0xDF63,
  [24100] = 0xDF64, [24101] = 0xDF65, [24102] = 0xDF66, [24103] = 0xDF67,
  [24104] = 0xDF68, [24105] = 0xDF69, [24106] = 0xDF6A, [24107] = 0xDF6B,
  [24108] = 0xDF6C, [24109] = 0xDF6D, [24110] = 0xDF6E, [24111] = 0xDF6F,
  [24112] = 0xDF70, [24113] = 0xDF71, [24114] = 0xDF72, [24115] = 0xDF73,
  [24116] = 0xDF74, [24117] = 0xDF75, [24118] = 0xDF76, [24119] = 0xDF77,
  [24120] = 0xDF78, [24121] = 0xDF79, [24122] = 0xDF7A, [24123] = 0xDF7B,
  [24124] = 0xDF7C, [24125] = 0xDF7D, [24126] = 0xDF7E, [24128] = 0xDF80,
  [24129] = 0xDF81, [24130] = 0xDF82, [24131] = 0xDF83, [24132] = 0xDF84,
  [24133] = 0xDF85, [24134] = 0xDF86, [24135] = 0xDF87, [24136] = 0xDF88,
  [24137] = 0xDF89, [24138] = 0xDF8A, [24139] = 0xDF8B, [24140] = 0xDF8C,
  [24141] = 0xDF8D, [24142] = 0xDF8E, [24143] = 0xDF8F, [24144] = 0xDF90,
  [24145] = 0xDF91, [24146] = 0xDF92, [24147] = 0xDF93, [24148] = 0xDF94,
  [24149] = 0xDF95, [24150] = 0xDF96, [24151] = 0xDF97, [24152] = 0xDF98,
  [24153] = 0xDF99, [24154] = 0xDF9A, [24155] = 0xDF9B, [24156] = 0xDF9C,
  [24157] = 0xDF9D, [24158] = 0xDF9E, [24159] = 0xDF9F, [24160] = 0xDFA0,
  [24161] = 0xDFA1, [24162] = 0xDFA2, [24163] = 0xDFA3, [24164] = 0xDFA4,
  [24165] = 0xDFA5, [24166] = 0xDFA6, [24167] = 0xDFA7, [24168] = 0xDFA8,
  [24169] = 0xDFA9, [24170] = 0xDFAA, [24171] = 0xDFAB, [24172] = 0xDFAC,
  [24173] = 0xDFAD, [24174] = 0xDFAE, [24175] = 0xDFAF, [24176] = 0xDFB0,
  [24177] = 0xDFB1, [24178] = 0xDFB2, [24179] = 0xDFB3, [24180] = 0xDFB4,
  [24181] = 0xDFB5, [24182] = 0xDFB6, [24183] = 0xDFB7, [24184] = 0xDFB8,
  [24185] = 0xDFB9, [24186] = 0xDFBA, [24187] = 0xDFBB, [24188] = 0xDFBC,
  [24189] = 0xDFBD, [24190] = 0xDFBE, [24191] = 0xDFBF, [24192] = 0xDFC0,
  [24193] = 0xDFC1, [24194] = 0xDFC2, [24195] = 0xDFC3, [24196] = 0xDFC4,
  [24197] = 0xDFC5, [24198] = 0xDFC6, [24199] = 0xDFC7, [24200] = 0xDFC8,
  [24201] = 0xDFC9, [24202] = 0xDFCA, [24203] = 0xDFCB, [24204] = 0xDFCC,
  [24205] = 0xDFCD, [24206] = 0xDFCE, [24207] = 0xDFCF, [24208] = 0xDFD0,
  [24209] = 0xDFD1, [24210] = 0xDFD2, [24211] = 0xDFD3, [24212] = 0xDFD4,
  [24213] = 0xDFD5, [24214] = 0xDFD6, [24215] = 0xDFD7, [24216] = 0xDFD8,
  [24217] = 0xDFD9, [24218] = 0xDFDA, [24219] = 0xDFDB, [24220] = 0xDFDC,
  [24221] = 0xDFDD, [24222] = 0xDFDE, [24223] = 0xDFDF, [24224] = 0xDFE0,
  [24225] = 0xDFE1, [24226] = 0xDFE2, [24227] = 0xDFE3, [24228] = 0xDFE4,
  [24229] = 0xDFE5, [24230] = 0xDFE6, [24231] = 0xDFE7, [24232] = 0xDFE8,
  [24233] = 0xDFE9, [24234] = 0xDFEA, [24235] = 0xDFEB, [24236] = 0xDFEC,
  [24237] = 0xDFED, [24238] = 0xDFEE, [24239] = 0xDFEF, [24240] = 0xDFF0,
  [24241] = 0xDFF1, [24242] = 0xDFF2, [24243] = 0xDFF3, [24244] = 0xDFF4,
  [24245] = 0xDFF5, [24246] = 0xDFF6, [24247] = 0xDFF7, [24248] = 0xDFF8,
  [24249] = 0xDFF9, [24250] = 0xDFFA, [24251] = 0xDFFB, [24252] = 0xDFFC,
  [24253] = 0xDFFD, [24254] = 0xDFFE, [24320] = 0xE040, [24321] = 0xE041,
  [24322] = 0xE042, [24323] = 0xE043, [24324] = 0xE044, [24325] = 0xE045,
  [24326] = 0xE046, [24327] = 0xE047, [24328] = 0xE048, [24329] = 0xE049,
  [24330] = 0xE04A, [24331] = 0xE04B, [24332] = 0xE04C, [24333] = 0xE04D,
  [24334] = 0xE04E, [24335] = 0xE04F, [24336] = 0xE050, [24337] = 0xE051,
  [24338] = 0xE052, [24339] = 0xE053, [24340] = 0xE054, [24341] = 0xE055,
  [24342] = 0xE056, [24343] = 0xE057, [24344] = 0xE058, [24345] = 0xE059,
  [24346] = 0xE05A, [24347] = 0xE05B, [24348] = 0xE05C, [24349] = 0xE05D,
  [24350] = 0xE05E, [24351] = 0xE05F, [24352] = 0xE060, [24353] = 0xE061,
  [24354] = 0xE062, [24355] = 0xE063, [24356] = 0xE064, [24357] = 0xE065,
  [24358] = 0xE066, [24359] = 0xE067, [24360] = 0xE068, [24361] = 0xE069,
  [24362] = 0xE06A, [24363] = 0xE06B, [24364] = 0xE06C, [24365] = 0xE06D,
  [24366] = 0xE06E, [24367] = 0xE06F, [24368] = 0xE070, [24369] = 0xE071,
  [24370] = 0xE072, [24371] = 0xE073, [24372] = 0xE074, [24373] = 0xE075,
  [24374] = 0xE076, [24375] = 0xE077, [24376] = 0xE078, [24377] = 0xE079,
  [24378] = 0xE07A, [24379] = 0xE07B, [24380] = 0xE07C, [24381] = 0xE07D,
  [24382] = 0xE07E, [24384] = 0xE080, [24385] = 0xE081, [24386] = 0xE082,
  [24387] = 0xE083, [24388] = 0xE084, [24389] = 0xE085, [24390] = 0xE086,
  [24391] = 0xE087, [24392] = 0xE088, [24393] = 0xE089, [24394] = 0xE08A,
  [24395] = 0xE08B, [24396] = 0xE08C, [24397] = 0xE08D, [24398] = 0xE08E,
  [24399] = 0xE08F, [24400] = 0xE090, [24401] = 0xE091, [24402] = 0xE092,
  [24403] = 0xE093, [24404] = 0xE094, [24405] = 0xE095, [24406] = 0xE096,
  [24407] = 0xE097, [24408] = 0xE098, [24409] = 0xE099, [24410] = 0xE09A,
  [24411] = 0xE09B, [24412] = 0xE09C, [24413] = 0xE09D, [24414] = 0xE09E,
  [24415] = 0xE09F, [24416] = 0xE0A0, [24417] = 0xE0A1, [24418] = 0xE0A2,
  [24419] = 0xE0A3, [24420] = 0xE0A4, [24421] = 0xE0A5, [24422] = 0xE0A6,
  [24423] = 0xE0A7, [24424] = 0xE0A8, [24425] = 0xE0A9, [24426] = 0xE0AA,
  [24427] = 0xE0AB, [24428] = 0xE0AC, [24429] = 0xE0AD, [24430] = 0xE0AE,
  [24431] = 0xE0AF, [24432] = 0xE0B0, [24433] = 0xE0B1, [24434] = 0xE0B2,
  [24435] = 0xE0B3, [24436] = 0xE0B4, [24437] = 0xE0B5, [24438] = 0xE0B6,
  [24439] = 0xE0B7, [24440] = 0xE0B8, [24441] = 0xE0B9, [24442] = 0xE0BA,
  [24443] = 0xE0BB, [24444] = 0xE0BC, [24445] = 0xE0BD, [24446] = 0xE0BE,
  [24447] = 0xE0BF, [24448] = 0xE0C0, [24449] = 0xE0C1, [24450] = 0xE0C2,
  [24451] = 0xE0C3, [24452] = 0xE0C4, [24453] = 0xE0C5, [24454] = 0xE0C6,
  [24455] = 0xE0C7, [24456] = 0xE0C8, [24457] = 0xE0C9, [24458] = 0xE0CA,
  [24459] = 0xE0CB, [24460] = 0xE0CC, [24461] = 0xE0CD, [24462] = 0xE0CE,
  [24463] = 0xE0CF, [24464] = 0xE0D0, [24465] = 0xE0D1, [24466] = 0xE0D2,
  [24467] = 0xE0D3, [24468] = 0xE0D4, [24469] = 0xE0D5, [24470] = 0xE0D6,
  [24471] = 0xE0D7, [24472] = 0xE0D8, [24473] = 0xE0D9, [24474] = 0xE0DA,
  [24475] = 0xE0DB, [24476] = 0xE0DC, [24477] = 0xE0DD, [24478] = 0xE0DE,
  [24479] = 0xE0DF, [24480] = 0xE0E0, [24481] = 0xE0E1, [24482] = 0xE0E2,
  [24483] = 0xE0E3, [24484] = 0xE0E4, [24485] = 0xE0E5, [24486] = 0xE0E6,
  [24487] = 0xE0E7, [24488] = 0xE0E8, [24489] = 0xE0E9, [24490] = 0xE0EA,
  [24491] = 0xE0EB, [24492] = 0xE0EC, [24493] = 0xE0ED, [24494] = 0xE0EE,
  [24495] = 0xE0EF, [24496] = 0xE0F0, [24497] = 0xE0F1, [24498] = 0xE0F2,
  [24499] = 0xE0F3, [24500] = 0xE0F4, [24501] = 0xE0F5, [24502] = 0xE0F6,
  [24503] = 0xE0F7, [24504] = 0xE0F8, [24505] = 0xE0F9, [24506] = 0xE0FA,
  [24507] = 0xE0FB, [24508] = 0xE0FC, [24509] = 0xE0FD, [24510] = 0xE0FE,
  [24576] = 0xE140, [24577] = 0xE141, [24578] = 0xE142, [24579] = 0xE143,
  [24580] = 0xE144, [24581] = 0xE145, [24582] = 0xE146, [24583] = 0xE147,
  [24584] = 0xE148, [24585] = 0xE149, [24586] = 0xE14A, [24587] = 0xE14B,
  [24588] = 0xE14C, [24589] = 0xE14D, [24590] = 0xE14E, [24591] = 0xE14F,
  [24592] = 0xE150, [24593] = 0xE151, [24594] = 0xE152, [24595] = 0xE153,
  [24596] = 0xE154, [24597] = 0xE155, [24598] = 0xE156, [24599] = 0xE157,
  [24600] = 0xE158, [24601] = 0xE159, [24602] = 0xE15A, [24603] = 0xE15B,
  [24604] = 0xE15C, [24605] = 0xE15D, [24606] = 0xE15E, [24607] = 0xE15F,
  [24608] = 0xE160, [24609] = 0xE161, [24610] = 0xE162, [24611] = 0xE163,
  [24612] = 0xE164, [24613] = 0xE165, [24614] = 0xE166, [24615] = 0xE167,
  [24616] = 0xE168, [24617] = 0xE169, [24618] = 0xE16A, [24619] = 0xE16B,
  [24620] = 0xE16C, [24621] = 0xE16D, [24622] = 0xE16E, [24623] = 0xE16F,
  [24624] = 0xE170, [24625] = 0xE171, [24626] = 0xE172, [24627] = 0xE173,
  [24628] = 0xE174, [24629] = 0xE175, [24630] = 0xE176, [24631] = 0xE177,
  [24632] = 0xE178, [24633] = 0xE179, [24634] = 0xE17A, [24635] = 0xE17B,
  [24636] = 0xE17C, [24637] = 0xE17D, [24638] = 0xE17E, [24640] = 0xE180,
  [24641] = 0xE181, [24642] = 0xE182, [24643] = 0xE183, [24644] = 0xE184,
  [24645] = 0xE185, [24646] = 0xE186, [24647] = 0xE187, [24648] = 0xE188,
  [24649] = 0xE189, [24650] = 0xE18A, [24651] = 0xE18B, [24652] = 0xE18C,
  [24653] = 0xE18D, [24654] = 0xE18E, [24655] = 0xE18F, [24656] = 0xE190,
  [24657] = 0xE191, [24658] = 0xE192, [24659] = 0xE193, [24660] = 0xE194,
  [24661] = 0xE195, [24662] = 0xE196, [24663] = 0xE197, [24664] = 0xE198,
  [24665] = 0xE199, [24666] = 0xE19A, [24667] = 0xE19B, [24668] = 0xE19C,
  [24669] = 0xE19D, [24670] = 0xE19E, [24671] = 0xE19F, [24672] = 0xE1A0,
  [24673] = 0xE1A1, [24674] = 0xE1A2, [24675] = 0xE1A3, [24676] = 0xE1A4,
  [24677] = 0xE1A5, [24678] = 0xE1A6, [24679] = 0xE1A7, [24680] = 0xE1A8,
  [24681] = 0xE1A9, [24682] = 0xE1AA, [24683] = 0xE1AB, [24684] = 0xE1AC,
  [24685] = 0xE1AD, [24686] = 0xE1AE, [24687] = 0xE1AF, [24688] = 0xE1B0,
  [24689] = 0xE1B1, [24690] = 0xE1B2, [24691] = 0xE1B3, [24692] = 0xE1B4,
  [24693] = 0xE1B5, [24694] = 0xE1B6, [24695] = 0xE1B7, [24696] = 0xE1B8,
  [24697] = 0xE1B9, [24698] = 0xE1BA, [24699] = 0xE1BB, [24700] = 0xE1BC,
  [24701] = 0xE1BD, [24702] = 0xE1BE, [24703] = 0xE1BF, [24704] = 0xE1C0,
  [24705] = 0xE1C1, [24706] = 0xE1C2, [24707] = 0xE1C3, [24708] = 0xE1C4,
  [24709] = 0xE1C5, [24710] = 0xE1C6, [24711] = 0xE1C7, [24712] = 0xE1C8,
  [24713] = 0xE1C9, [24714] = 0xE1CA, [24715] = 0xE1CB, [24716] = 0xE1CC,
  [24717] = 0xE1CD, [24718] = 0xE1CE, [24719] = 0xE1CF, [24720] = 0xE1D0,
  [24721] = 0xE1D1, [24722] = 0xE1D2, [24723] = 0xE1D3, [24724] = 0xE1D4,
  [24725] = 0xE1D5, [24726] = 0xE1D6, [24727] = 0xE1D7, [24728] = 0xE1D8,
  [24729] = 0xE1D9, [24730] = 0xE1DA, [24731] = 0xE1DB, [24732] = 0xE1DC,
  [24733] = 0xE1DD, [24734] = 0xE1DE, [24735] = 0xE1DF, [24736] = 0xE1E0,
  [24737] = 0xE1E1, [24738] = 0xE1E2, [24739] = 0xE1E3, [24740] = 0xE1E4,
  [24741] = 0xE1E5, [24742] = 0xE1E6, [24743] = 0xE1E7, [24744] = 0xE1E8,
  [24745] = 0xE1E9, [24746] = 0xE1EA, [24747] = 0xE1EB, [24748] = 0xE1EC,
  [24749] = 0xE1ED, [24750] = 0xE1EE, [24751] = 0xE1EF, [24752] = 0xE1F0,
  [24753] = 0xE1F1, [24754] = 0xE1F2, [24755] = 0xE1F3, [24756] = 0xE1F4,
  [24757] = 0xE1F5, [24758] = 0xE1F6, [24759] = 0xE1F7, [24760] = 0xE1F8,
  [24761] = 0xE1F9, [24762] = 0xE1FA, [24763] = 0xE1FB, [24764] = 0xE1FC,
  [24765] = 0xE1FD, [24766] = 0xE1FE, [24832] = 0xE240, [24833] = 0xE241,
  [24834] = 0xE242, [24835] = 0xE243, [24836] = 0xE244, [24837] = 0xE245,
  [24838] = 0xE246, [24839] = 0xE247, [24840] = 0xE248, [24841] = 0xE249,
  [24842] = 0xE24A, [24843] = 0xE24B, [24844] = 0xE24C, [24845] = 0xE24D,
  [24846] = 0xE24E, [24847] = 0xE24F, [24848] = 0xE250, [24849] = 0xE251,
  [24850] = 0xE252, [24851] = 0xE253, [24852] = 0xE254, [24853] = 0xE255,
  [24854] = 0xE256, [24855] = 0xE257, [24856] = 0xE258, [24857] = 0xE259,
  [24858] = 0xE25A, [24859] = 0xE25B, [24860] = 0xE25C, [24861] = 0xE25D,
  [24862] = 0xE25E, [24863] = 0xE25F, [24864] = 0xE260, [24865] = 0xE261,
  [24866] = 0xE262, [24867] = 0xE263, [24868] = 0xE264, [24869] = 0xE265,
  [24870] = 0xE266, [24871] = 0xE267, [24872] = 0xE268, [24873] = 0xE269,
  [24874] = 0xE26A, [24875] = 0xE26B, [24876] = 0xE26C, [24877] = 0xE26D,
  [24878] = 0xE26E, [24879] = 0xE26F, [24880] = 0xE270, [24881] = 0xE271,
  [24882] = 0xE272, [24883] = 0xE273, [24884] = 0xE274, [24885] = 0xE275,
  [24886] = 0xE276, [24887] = 0xE277, [24888] = 0xE278, [24889] = 0xE279,
  [24890] = 0xE27A, [24891] = 0xE27B, [24892] = 0xE27C, [24893] = 0xE27D,
  [24894] = 0xE27E, [24896] = 0xE280, [24897] = 0xE281, [24898] = 0xE282,
  [24899] = 0xE283, [24900] = 0xE284, [24901] = 0xE285, [24902] = 0xE286,
  [24903] = 0xE287, [24904] = 0xE288, [24905] = 0xE289, [24906] = 0xE28A,
  [24907] = 0xE28B, [24908] = 0xE28C, [24909] = 0xE28D, [24910] = 0xE28E,
  [24911] = 0xE28F, [24912] = 0xE290, [24913] = 0xE291, [24914] = 0xE292,
  [24915] = 0xE293, [24916] = 0xE294, [24917] = 0xE295, [24918] = 0xE296,
  [24919] = 0xE297, [24920] = 0xE298, [24921] = 0xE299, [24922] = 0xE29A,
  [24923] = 0xE29B, [24924] = 0xE29C, [24925] = 0xE29D, [24926] = 0xE29E,
  [24927] = 0xE29F, [24928] = 0xE2A0, [24929] = 0xE2A1, [24930] = 0xE2A2,
  [24931] = 0xE2A3, [24932] = 0xE2A4, [24933] = 0xE2A5, [24934] = 0xE2A6,
  [24935] = 0xE2A7, [24936] = 0xE2A8, [24937] = 0xE2A9, [24938] = 0xE2AA,
  [24939] = 0xE2AB, [24940] = 0xE2AC, [24941] = 0xE2AD, [24942] = 0xE2AE,
  [24943] = 0xE2AF, [24944] = 0xE2B0, [24945] = 0xE2B1, [24946] = 0xE2B2,
  [24947] = 0xE2B3, [24948] = 0xE2B4, [24949] = 0xE2B5, [24950] = 0xE2B6,
  [24951] = 0xE2B7, [24952] = 0xE2B8, [24953] = 0xE2B9, [24954] = 0xE2BA,
  [24955] = 0xE2BB, [24956] = 0xE2BC, [24957] = 0xE2BD, [24958] = 0xE2BE,
  [24959] = 0xE2BF, [24960] = 0xE2C0, [24961] = 0xE2C1, [24962] = 0xE2C2,
  [24963] = 0xE2C3, [24964] = 0xE2C4, [24965] = 0xE2C5, [24966] = 0xE2C6,
  [24967] = 0xE2C7, [24968] = 0xE2C8, [24969] = 0xE2C9, [24970] = 0xE2CA,
  [24971] = 0xE2CB, [24972] = 0xE2CC, [24973] = 0xE2CD, [24974] = 0xE2CE,
  [24975] = 0xE2CF, [24976] = 0xE2D0, [24977] = 0xE2D1, [24978] = 0xE2D2,
  [24979] = 0xE2D3, [24980] = 0xE2D4, [24981] = 0xE2D5, [24982] = 0xE2D6,
  [24983] = 0xE2D7, [24984] = 0xE2D8, [24985] = 0xE2D9, [24986] = 0xE2DA,
  [24987] = 0xE2DB, [24988] = 0xE2DC, [24989] = 0xE2DD, [24990] = 0xE2DE,
  [24991] = 0xE2DF, [24992] = 0xE2E0, [24993] = 0xE2E1, [24994] = 0xE2E2,
  [24995] = 0xE2E3, [24996] = 0xE2E4, [24997] = 0xE2E5, [24998] = 0xE2E6,
  [24999] = 0xE2E7, [25000] = 0xE2E8, [25001] = 0xE2E9, [25002] = 0xE2EA,
  [25003] = 0xE2EB, [25004] = 0xE2EC, [25005] = 0xE2ED, [25006] = 0xE2EE,
  [25007] = 0xE2EF, [25008] = 0xE2F0, [25009] = 0xE2F1, [25010] = 0xE2F2,
  [25011] = 0xE2F3, [25012] = 0xE2F4, [25013] = 0xE2F5, [25014] = 0xE2F6,
  [25015] = 0xE2F7, [25016] = 0xE2F8, [25017] = 0xE2F9, [25018] = 0xE2FA,
  [25019] = 0xE2FB, [25020] = 0xE2FC, [25021] = 0xE2FD, [25022] = 0xE2FE,
  [25088] = 0xE340, [25089] = 0xE341, [25090] = 0xE342, [25091] = 0xE343,
  [25092] = 0xE344, [25093] = 0xE345, [25094] = 0xE346, [25095] = 0xE347,
  [25096] = 0xE348, [25097] = 0xE349, [25098] = 0xE34A, [25099] = 0xE34B,
  [25100] = 0xE34C, [25101] = 0xE34D, [25102] = 0xE34E, [25103] = 0xE34F,
  [25104] = 0xE350, [25105] = 0xE351, [25106] = 0xE352, [25107] = 0xE353,
  [25108] = 0xE354, [25109] = 0xE355, [25110] = 0xE356, [25111] = 0xE357,
  [25112] = 0xE358, [25113] = 0xE359, [25114] = 0xE35A, [25115] = 0xE35B,
  [25116] = 0xE35C, [25117] = 0xE35D, [25118] = 0xE35E, [25119] = 0xE35F,
  [25120] = 0xE360, [25121] = 0xE361, [25122] = 0xE362, [25123] = 0xE363,
  [25124] = 0xE364, [25125] = 0xE365, [25126] = 0xE366, [25127] = 0xE367,
  [25128] = 0xE368, [25129] = 0xE369, [25130] = 0xE36A, [25131] = 0xE36B,
  [25132] = 0xE36C, [25133] = 0xE36D, [25134] = 0xE36E, [25135] = 0xE36F,
  [25136] = 0xE370, [25137] = 0xE371, [25138] = 0xE372, [25139] = 0xE373,
  [25140] = 0xE374, [25141] = 0xE375, [25142] = 0xE376, [25143] = 0xE377,
  [25144] = 0xE378, [25145] = 0xE379, [25146] = 0xE37A, [25147] = 0xE37B,
  [25148] = 0xE37C, [25149] = 0xE37D, [25150] = 0xE37E, [25152] = 0xE380,
  [25153] = 0xE381, [25154] = 0xE382, [25155] = 0xE383, [25156] = 0xE384,
  [25157] = 0xE385, [25158] = 0xE386, [25159] = 0xE387, [25160] = 0xE388,
  [25161] = 0xE389, [25162] = 0xE38A, [25163] = 0xE38B, [25164] = 0xE38C,
  [25165] = 0xE38D, [25166] = 0xE38E, [25167] = 0xE38F, [25168] = 0xE390,
  [25169] = 0xE391, [25170] = 0xE392, [25171] = 0xE393, [25172] = 0xE394,
  [25173] = 0xE395, [25174] = 0xE396, [25175] = 0xE397, [25176] = 0xE398,
  [25177] = 0xE399, [25178] = 0xE39A, [25179] = 0xE39B, [25180] = 0xE39C,
  [25181] = 0xE39D, [25182] = 0xE39E, [25183] = 0xE39F, [25184] = 0xE3A0,
  [25185] = 0xE3A1, [25186] = 0xE3A2, [25187] = 0xE3A3, [25188] = 0xE3A4,
  [25189] = 0xE3A5, [25190] = 0xE3A6, [25191] = 0xE3A7, [25192] = 0xE3A8,
  [25193] = 0xE3A9, [25194] = 0xE3AA, [25195] = 0xE3AB, [25196] = 0xE3AC,
  [25197] = 0xE3AD, [25198] = 0xE3AE, [25199] = 0xE3AF, [25200] = 0xE3B0,
  [25201] = 0xE3B1, [25202] = 0xE3B2, [25203] = 0xE3B3, [25204] = 0xE3B4,
  [25205] = 0xE3B5, [25206] = 0xE3B6, [25207] = 0xE3B7, [25208] = 0xE3B8,
  [25209] = 0xE3B9, [25210] = 0xE3BA, [25211] = 0xE3BB, [25212] = 0xE3BC,
  [25213] = 0xE3BD, [25214] = 0xE3BE, [25215] = 0xE3BF, [25216] = 0xE3C0,
  [25217] = 0xE3C1, [25218] = 0xE3C2, [25219] = 0xE3C3, [25220] = 0xE3C4,
  [25221] = 0xE3C5, [25222] = 0xE3C6, [25223] = 0xE3C7, [25224] = 0xE3C8,
  [25225] = 0xE3C9, [25226] = 0xE3CA, [25227] = 0xE3CB, [25228] = 0xE3CC,
  [25229] = 0xE3CD, [25230] = 0xE3CE, [25231] = 0xE3CF, [25232] = 0xE3D0,
  [25233] = 0xE3D1, [25234] = 0xE3D2, [25235] = 0xE3D3, [25236] = 0xE3D4,
  [25237] = 0xE3D5, [25238] = 0xE3D6, [25239] = 0xE3D7, [25240] = 0xE3D8,
  [25241] = 0xE3D9, [25242] = 0xE3DA, [25243] = 0xE3DB, [25244] = 0xE3DC,
  [25245] = 0xE3DD, [25246] = 0xE3DE, [25247] = 0xE3DF, [25248] = 0xE3E0,
  [25249] = 0xE3E1, [25250] = 0xE3E2, [25251] = 0xE3E3, [25252] = 0xE3E4,
  [25253] = 0xE3E5, [25254] = 0xE3E6, [25255] = 0xE3E7, [25256] = 0xE3E8,
  [25257] = 0xE3E9, [25258] = 0xE3EA, [25259] = 0xE3EB, [25260] = 0xE3EC,
  [25261] = 0xE3ED, [25262] = 0xE3EE, [25263] = 0xE3EF, [25264] = 0xE3F0,
  [25265] = 0xE3F1, [25266] = 0xE3F2, [25267] = 0xE3F3, [25268] = 0xE3F4,
  [25269] = 0xE3F5, [25270] = 0xE3F6, [25271] = 0xE3F7, [25272] = 0xE3F8,
  [25273] = 0xE3F9, [25274] = 0xE3FA, [25275] = 0xE3FB, [25276] = 0xE3FC,
  [25277] = 0xE3FD, [25278] = 0xE3FE, [25344] = 0xE440, [25345] = 0xE441,
  [25346] = 0xE442, [25347] = 0xE443, [25348] = 0xE444, [25349] = 0xE445,
  [25350] = 0xE446, [25351] = 0xE447, [25352] = 0xE448, [25353] = 0xE449,
  [25354] = 0xE44A, [25355] = 0xE44B, [25356] = 0xE44C, [25357] = 0xE44D,
  [25358] = 0xE44E, [25359] = 0xE44F, [25360] = 0xE450, [25361] = 0xE451,
  [25362] = 0xE452, [25363] = 0xE453, [25364] = 0xE454, [25365] = 0xE455,
  [25366] = 0xE456, [25367] = 0xE457, [25368] = 0xE458, [25369] = 0xE459,
  [25370] = 0xE45A, [25371] = 0xE45B, [25372] = 0xE45C, [25373] = 0xE45D,
  [25374] = 0xE45E, [25375] = 0xE45F, [25376] = 0xE460, [25377] = 0xE461,
  [25378] = 0xE462, [25379] = 0xE463, [25380] = 0xE464, [25381] = 0xE465,
  [25382] = 0xE466, [25383] = 0xE467, [25384] = 0xE468, [25385] = 0xE469,
  [25386] = 0xE46A, [25387] = 0xE46B, [25388] = 0xE46C, [25389] = 0xE46D,
  [25390] = 0xE46E, [25391] = 0xE46F, [25392] = 0xE470, [25393] = 0xE471,
  [25394] = 0xE472, [25395] = 0xE473, [25396] = 0xE474, [25397] = 0xE475,
  [25398] = 0xE476, [25399] = 0xE477, [25400] = 0xE478, [25401] = 0xE479,
  [25402] = 0xE47A, [25403] = 0xE47B, [25404] = 0xE47C, [25405] = 0xE47D,
  [25406] = 0xE47E, [25408] = 0xE480, [25409] = 0xE481, [25410] = 0xE482,
  [25411] = 0xE483, [25412] = 0xE484, [25413] = 0xE485, [25414] = 0xE486,
  [25415] = 0xE487, [25416] = 0xE488, [25417] = 0xE489, [25418] = 0xE48A,
  [25419] = 0xE48B, [25420] = 0xE48C, [25421] = 0xE48D, [25422] = 0xE48E,
  [25423] = 0xE48F, [25424] = 0xE490, [25425] = 0xE491, [25426] = 0xE492,
  [25427] = 0xE493, [25428] = 0xE494, [25429] = 0xE495, [25430] = 0xE496,
  [25431] = 0xE497, [25432] = 0xE498, [25433] = 0xE499, [25434] = 0xE49A,
  [25435] = 0xE49B, [25436] = 0xE49C, [25437] = 0xE49D, [25438] = 0xE49E,
  [25439] = 0xE49F, [25440] = 0xE4A0, [25441] = 0xE4A1, [25442] = 0xE4A2,
  [25443] = 0xE4A3, [25444] = 0xE4A4, [25445] = 0xE4A5, [25446] = 0xE4A6,
  [25447] = 0xE4A7, [25448] = 0xE4A8, [25449] = 0xE4A9, [25450] = 0xE4AA,
  [25451] = 0xE4AB, [25452] = 0xE4AC, [25453] = 0xE4AD, [25454] = 0xE4AE,
  [25455] = 0xE4AF, [25456] = 0xE4B0, [25457] = 0xE4B1, [25458] = 0xE4B2,
  [25459] = 0xE4B3, [25460] = 0xE4B4, [25461] = 0xE4B5, [25462] = 0xE4B6,
  [25463] = 0xE4B7, [25464] = 0xE4B8, [25465] = 0xE4B9, [25466] = 0xE4BA,
  [25467] = 0xE4BB, [25468] = 0xE4BC, [25469] = 0xE4BD, [25470] = 0xE4BE,
  [25471] = 0xE4BF, [25472] = 0xE4C0, [25473] = 0xE4C1, [25474] = 0xE4C2,
  [25475] = 0xE4C3, [25476] = 0xE4C4, [25477] = 0xE4C5, [25478] = 0xE4C6,
  [25479] = 0xE4C7, [25480] = 0xE4C8, [25481] = 0xE4C9, [25482] = 0xE4CA,
  [25483] = 0xE4CB, [25484] = 0xE4CC, [25485] = 0xE4CD, [25486] = 0xE4CE,
  [25487] = 0xE4CF, [25488] = 0xE4D0, [25489] = 0xE4D1, [25490] = 0xE4D2,
  [25491] = 0xE4D3, [25492] = 0xE4D4, [25493] = 0xE4D5, [25494] = 0xE4D6,
  [25495] = 0xE4D7, [25496] = 0xE4D8, [25497] = 0xE4D9, [25498] = 0xE4DA,
  [25499] = 0xE4DB, [25500] = 0xE4DC, [25501] = 0xE4DD, [25502] = 0xE4DE,
  [25503] = 0xE4DF, [25504] = 0xE4E0, [25505] = 0xE4E1, [25506] = 0xE4E2,
  [25507] = 0xE4E3, [25508] = 0xE4E4, [25509] = 0xE4E5, [25510] = 0xE4E6,
  [25511] = 0xE4E7, [25512] = 0xE4E8, [25513] = 0xE4E9, [25514] = 0xE4EA,
  [25515] = 0xE4EB, [25516] = 0xE4EC, [25517] = 0xE4ED, [25518] = 0xE4EE,
  [25519] = 0xE4EF, [25520] = 0xE4F0, [25521] = 0xE4F1, [25522] = 0xE4F2,
  [25523] = 0xE4F3, [25524] = 0xE4F4, [25525] = 0xE4F5, [25526] = 0xE4F6,
  [25527] = 0xE4F7, [25528] = 0xE4F8, [25529] = 0xE4F9, [25530] = 0xE4FA,
  [25531] = 0xE4FB, [25532] = 0xE4FC, [25533] = 0xE4FD, [25534] = 0xE4FE,
  [25600] = 0xE540, [25601] = 0xE541, [25602] = 0xE542, [25603] = 0xE543,
  [25604] = 0xE544, [25605] = 0xE545, [25606] = 0xE546, [25607] = 0xE547,
  [25608] = 0xE548, [25609] = 0xE549, [25610] = 0xE54A, [25611] = 0xE54B,
  [25612] = 0xE54C, [25613] = 0xE54D, [25614] = 0xE54E, [25615] = 0xE54F,
  [25616] = 0xE550, [25617] = 0xE551, [25618] = 0xE552, [25619] = 0xE553,
  [25620] = 0xE554, [25621] = 0xE555, [25622] = 0xE556, [25623] = 0xE557,
  [25624] = 0xE558, [25625] = 0xE559, [25626] = 0xE55A, [25627] = 0xE55B,
  [25628] = 0xE55C, [25629] = 0xE55D, [25630] = 0xE55E, [25631] = 0xE55F,
  [25632] = 0xE560, [25633] = 0xE561, [25634] = 0xE562, [25635] = 0xE563,
  [25636] = 0xE564, [25637] = 0xE565, [25638] = 0xE566, [25639] = 0xE567,
  [25640] = 0xE568, [25641] = 0xE569, [25642] = 0xE56A, [25643] = 0xE56B,
  [25644] = 0xE56C, [25645] = 0xE56D, [25646] = 0xE56E, [25647] = 0xE56F,
  [25648] = 0xE570, [25649] = 0xE571, [25650] = 0xE572, [25651] = 0xE573,
  [25652] = 0xE574, [25653] = 0xE575, [25654] = 0xE576, [25655] = 0xE577,
  [25656] = 0xE578, [25657] = 0xE579, [25658] = 0xE57A, [25659] = 0xE57B,
  [25660] = 0xE57C, [25661] = 0xE57D, [25662] = 0xE57E, [25664] = 0xE580,
  [25665] = 0xE581, [25666] = 0xE582, [25667] = 0xE583, [25668] = 0xE584,
  [25669] = 0xE585, [25670] = 0xE586, [25671] = 0xE587, [25672] = 0xE588,
  [25673] = 0xE589, [25674] = 0xE58A, [25675] = 0xE58B, [25676] = 0xE58C,
  [25677] = 0xE58D, [25678] = 0xE58E, [25679] = 0xE58F, [25680] = 0xE590,
  [25681] = 0xE591, [25682] = 0xE592, [25683] = 0xE593, [25684] = 0xE594,
  [25685] = 0xE595, [25686] = 0xE596, [25687] = 0xE597, [25688] = 0xE598,
  [25689] = 0xE599, [25690] = 0xE59A, [25691] = 0xE59B, [25692] = 0xE59C,
  [25693] = 0xE59D, [25694] = 0xE59E, [25695] = 0xE59F, [25696] = 0xE5A0,
  [25697] = 0xE5A1, [25698] = 0xE5A2, [25699] = 0xE5A3, [25700] = 0xE5A4,
  [25701] = 0xE5A5, [25702] = 0xE5A6, [25703] = 0xE5A7, [25704] = 0xE5A8,
  [25705] = 0xE5A9, [25706] = 0xE5AA, [25707] = 0xE5AB, [25708] = 0xE5AC,
  [25709] = 0xE5AD, [25710] = 0xE5AE, [25711] = 0xE5AF, [25712] = 0xE5B0,
  [25713] = 0xE5B1, [25714] = 0xE5B2, [25715] = 0xE5B3, [25716] = 0xE5B4,
  [25717] = 0xE5B5, [25718] = 0xE5B6, [25719] = 0xE5B7, [25720] = 0xE5B8,
  [25721] = 0xE5B9, [25722] = 0xE5BA, [25723] = 0xE5BB, [25724] = 0xE5BC,
  [25725] = 0xE5BD, [25726] = 0xE5BE, [25727] = 0xE5BF, [25728] = 0xE5C0,
  [25729] = 0xE5C1, [25730] = 0xE5C2, [25731] = 0xE5C3, [25732] = 0xE5C4,
  [25733] = 0xE5C5, [25734] = 0xE5C6, [25735] = 0xE5C7, [25736] = 0xE5C8,
  [25737] = 0xE5C9, [25738] = 0xE5CA, [25739] = 0xE5CB, [25740] = 0xE5CC,
  [25741] = 0xE5CD, [25742] = 0xE5CE, [25743] = 0xE5CF, [25744] = 0xE5D0,
  [25745] = 0xE5D1, [25746] = 0xE5D2, [25747] = 0xE5D3, [25748] = 0xE5D4,
  [25749] = 0xE5D5, [25750] = 0xE5D6, [25751] = 0xE5D7, [25752] = 0xE5D8,
  [25753] = 0xE5D9, [25754] = 0xE5DA, [25755] = 0xE5DB, [25756] = 0xE5DC,
  [25757] = 0xE5DD, [25758] = 0xE5DE, [25759] = 0xE5DF, [25760] = 0xE5E0,
  [25761] = 0xE5E1, [25762] = 0xE5E2, [25763] = 0xE5E3, [25764] = 0xE5E4,
  [25765] = 0xE5E5, [25766] = 0xE5E6, [25767] = 0xE5E7, [25768] = 0xE5E8,
  [25769] = 0xE5E9, [25770] = 0xE5EA, [25771] = 0xE5EB, [25772] = 0xE5EC,
  [25773] = 0xE5ED, [25774] = 0xE5EE, [25775] = 0xE5EF, [25776] = 0xE5F0,
  [25777] = 0xE5F1, [25778] = 0xE5F2, [25779] = 0xE5F3, [25780] = 0xE5F4,
  [25781] = 0xE5F5, [25782] = 0xE5F6, [25783] = 0xE5F7, [25784] = 0xE5F8,
  [25785] = 0xE5F9, [25786] = 0xE5FA, [25787] = 0xE5FB, [25788] = 0xE5FC,
  [25789] = 0xE5FD, [25790] = 0xE5FE, [25856] = 0xE640, [25857] = 0xE641,
  [25858] = 0xE642, [25859] = 0xE643, [25860] = 0xE644, [25861] = 0xE645,
  [25862] = 0xE646, [25863] = 0xE647, [25864] = 0xE648, [25865] = 0xE649,
  [25866] = 0xE64A, [25867] = 0xE64B, [25868] = 0xE64C, [25869] = 0xE64D,
  [25870] = 0xE64E, [25871] = 0xE64F, [25872] = 0xE650, [25873] = 0xE651,
  [25874] = 0xE652, [25875] = 0xE653, [25876] = 0xE654, [25877] = 0xE655,
  [25878] = 0xE656, [25879] = 0xE657, [25880] = 0xE658, [25881] = 0xE659,
  [25882] = 0xE65A, [25883] = 0xE65B, [25884] = 0xE65C, [25885] = 0xE65D,
  [25886] = 0xE65E, [25887] = 0xE65F, [25888] = 0xE660, [25889] = 0xE661,
  [25890] = 0xE662, [25891] = 0xE663, [25892] = 0xE664, [25893] = 0xE665,
  [25894] = 0xE666, [25895] = 0xE667, [25896] = 0xE668, [25897] = 0xE669,
  [25898] = 0xE66A, [25899] = 0xE66B, [25900] = 0xE66C, [25901] = 0xE66D,
  [25902] = 0xE66E, [25903] = 0xE66F, [25904] = 0xE670, [25905] = 0xE671,
  [25906] = 0xE672, [25907] = 0xE673, [25908] = 0xE674, [25909] = 0xE675,
  [25910] = 0xE676, [25911] = 0xE677, [25912] = 0xE678, [25913] = 0xE679,
  [25914] = 0xE67A, [25915] = 0xE67B, [25916] = 0xE67C, [25917] = 0xE67D,
  [25918] = 0xE67E, [25920] = 0xE680, [25921] = 0xE681, [25922] = 0xE682,
  [25923] = 0xE683, [25924] = 0xE684, [25925] = 0xE685, [25926] = 0xE686,
  [25927] = 0xE687, [25928] = 0xE688, [25929] = 0xE689, [25930] = 0xE68A,
  [25931] = 0xE68B, [25932] = 0xE68C, [25933] = 0xE68D, [25934] = 0xE68E,
  [25935] = 0xE68F, [25936] = 0xE690, [25937] = 0xE691, [25938] = 0xE692,
  [25939] = 0xE693, [25940] = 0xE694, [25941] = 0xE695, [25942] = 0xE696,
  [25943] = 0xE697, [25944] = 0xE698, [25945] = 0xE699, [25946] = 0xE69A,
  [25947] = 0xE69B, [25948] = 0xE69C, [25949] = 0xE69D, [25950] = 0xE69E,
  [25951] = 0xE69F, [25952] = 0xE6A0, [25953] = 0xE6A1, [25954] = 0xE6A2,
  [25955] = 0xE6A3, [25956] = 0xE6A4, [25957] = 0xE6A5, [25958] = 0xE6A6,
  [25959] = 0xE6A7, [25960] = 0xE6A8, [25961] = 0xE6A9, [25962] = 0xE6AA,
  [25963] = 0xE6AB, [25964] = 0xE6AC, [25965] = 0xE6AD, [25966] = 0xE6AE,
  [25967] = 0xE6AF, [25968] = 0xE6B0, [25969] = 0xE6B1, [25970] = 0xE6B2,
  [25971] = 0xE6B3, [25972] = 0xE6B4, [25973] = 0xE6B5, [25974] = 0xE6B6,
  [25975] = 0xE6B7, [25976] = 0xE6B8, [25977] = 0xE6B9, [25978] = 0xE6BA,
  [25979] = 0xE6BB, [25980] = 0xE6BC, [25981] = 0xE6BD, [25982] = 0xE6BE,
  [25983] = 0xE6BF, [25984] = 0xE6C0, [25985] = 0xE6C1, [25986] = 0xE6C2,
  [25987] = 0xE6C3, [25988] = 0xE6C4, [25989] = 0xE6C5, [25990] = 0xE6C6,
  [25991] = 0xE6C7, [25992] = 0xE6C8, [25993] = 0xE6C9, [25994] = 0xE6CA,
  [25995] = 0xE6CB, [25996] = 0xE6CC, [25997] = 0xE6CD, [25998] = 0xE6CE,
  [25999] = 0xE6CF, [26000] = 0xE6D0, [26001] = 0xE6D1, [26002] = 0xE6D2,
  [26003] = 0xE6D3, [26004] = 0xE6D4, [26005] = 0xE6D5, [26006] = 0xE6D6,
  [26007] = 0xE6D7, [26008] = 0xE6D8, [26009] = 0xE6D9, [26010] = 0xE6DA,
  [26011] = 0xE6DB, [26012] = 0xE6DC, [26013] = 0xE6DD, [26014] = 0xE6DE,
  [26015] = 0xE6DF, [26016] = 0xE6E0, [26017] = 0xE6E1, [26018] = 0xE6E2,
  [26019] = 0xE6E3, [26020] = 0xE6E4, [26021] = 0xE6E5, [26022] = 0xE6E6,
  [26023] = 0xE6E7, [26024] = 0xE6E8, [26025] = 0xE6E9, [26026] = 0xE6EA,
  [26027] = 0xE6EB, [26028] = 0xE6EC, [26029] = 0xE6ED, [26030] = 0xE6EE,
  [26031] = 0xE6EF, [26032] = 0xE6F0, [26033] = 0xE6F1, [26034] = 0xE6F2,
  [26035] = 0xE6F3, [26036] = 0xE6F4, [26037] = 0xE6F5, [26038] = 0xE6F6,
  [26039] = 0xE6F7, [26040] = 0xE6F8, [26041] = 0xE6F9, [26042] = 0xE6FA,
  [26043] = 0xE6FB, [26044] = 0xE6FC, [26045] = 0xE6FD, [26046] = 0xE6FE,
  [26112] = 0xE740, [26113] = 0xE741, [26114] = 0xE742, [26115] = 0xE743,
  [26116] = 0xE744, [26117] = 0xE745, [26118] = 0xE746, [26119] = 0xE747,
  [26120] = 0xE748, [26121] = 0xE749, [26122] = 0xE74A, [26123] = 0xE74B,
  [26124] = 0xE74C, [26125] = 0xE74D, [26126] = 0xE74E, [26127] = 0xE74F,
  [26128] = 0xE750, [26129] = 0xE751, [26130] = 0xE752, [26131] = 0xE753,
  [26132] = 0xE754, [26133] = 0xE755, [26134] = 0xE756, [26135] = 0xE757,
  [26136] = 0xE758, [26137] = 0xE759, [26138] = 0xE75A, [26139] = 0xE75B,
  [26140] = 0xE75C, [26141] = 0xE75D, [26142] = 0xE75E, [26143] = 0xE75F,
  [26144] = 0xE760, [26145] = 0xE761, [26146] = 0xE762, [26147] = 0xE763,
  [26148] = 0xE764, [26149] = 0xE765, [26150] = 0xE766, [26151] = 0xE767,
  [26152] = 0xE768, [26153] = 0xE769, [26154] = 0xE76A, [26155] = 0xE76B,
  [26156] = 0xE76C, [26157] = 0xE76D, [26158] = 0xE76E, [26159] = 0xE76F,
  [26160] = 0xE770, [26161] = 0xE771, [26162] = 0xE772, [26163] = 0xE773,
  [26164] = 0xE774, [26165] = 0xE775, [26166] = 0xE776, [26167] = 0xE777,
  [26168] = 0xE778, [26169] = 0xE779, [26170] = 0xE77A, [26171] = 0xE77B,
  [26172] = 0xE77C, [26173] = 0xE77D, [26174] = 0xE77E, [26176] = 0xE780,
  [26177] = 0xE781, [26178] = 0xE782, [26179] = 0xE783, [26180] = 0xE784,
  [26181] = 0xE785, [26182] = 0xE786, [26183] = 0xE787, [26184] = 0xE788,
  [26185] = 0xE789, [26186] = 0xE78A, [26187] = 0xE78B, [26188] = 0xE78C,
  [26189] = 0xE78D, [26190] = 0xE78E, [26191] = 0xE78F, [26192] = 0xE790,
  [26193] = 0xE791, [26194] = 0xE792, [26195] = 0xE793, [26196] = 0xE794,
  [26197] = 0xE795, [26198] = 0xE796, [26199] = 0xE797, [26200] = 0xE798,
  [26201] = 0xE799, [26202] = 0xE79A, [26203] = 0xE79B, [26204] = 0xE79C,
  [26205] = 0xE79D, [26206] = 0xE79E, [26207] = 0xE79F, [26208] = 0xE7A0,
  [26209] = 0xE7A1, [26210] = 0xE7A2, [26211] = 0xE7A3, [26212] = 0xE7A4,
  [26213] = 0xE7A5, [26214] = 0xE7A6, [26215] = 0xE7A7, [26216] = 0xE7A8,
  [26217] = 0xE7A9, [26218] = 0xE7AA, [26219] = 0xE7AB, [26220] = 0xE7AC,
  [26221] = 0xE7AD, [26222] = 0xE7AE, [26223] = 0xE7AF, [26224] = 0xE7B0,
  [26225] = 0xE7B1, [26226] = 0xE7B2, [26227] = 0xE7B3, [26228] = 0xE7B4,
  [26229] = 0xE7B5, [26230] = 0xE7B6, [26231] = 0xE7B7, [26232] = 0xE7B8,
  [26233] = 0xE7B9, [26234] = 0xE7BA, [26235] = 0xE7BB, [26236] = 0xE7BC,
  [26237] = 0xE7BD, [26238] = 0xE7BE, [26239] = 0xE7BF, [26240] = 0xE7C0,
  [26241] = 0xE7C1, [26242] = 0xE7C2, [26243] = 0xE7C3, [26244] = 0xE7C4,
  [26245] = 0xE7C5, [26246] = 0xE7C6, [26247] = 0xE7C7, [26248] = 0xE7C8,
  [26249] = 0xE7C9, [26250] = 0xE7CA, [26251] = 0xE7CB, [26252] = 0xE7CC,
  [26253] = 0xE7CD, [26254] = 0xE7CE, [26255] = 0xE7CF, [26256] = 0xE7D0,
  [26257] = 0xE7D1, [26258] = 0xE7D2, [26259] = 0xE7D3, [26260] = 0xE7D4,
  [26261] = 0xE7D5, [26262] = 0xE7D6, [26263] = 0xE7D7, [26264] = 0xE7D8,
  [26265] = 0xE7D9, [26266] = 0xE7DA, [26267] = 0xE7DB, [26268] = 0xE7DC,
  [26269] = 0xE7DD, [26270] = 0xE7DE, [26271] = 0xE7DF, [26272] = 0xE7E0,
  [26273] = 0xE7E1, [26274] = 0xE7E2, [26275] = 0xE7E3, [26276] = 0xE7E4,
  [26277] = 0xE7E5, [26278] = 0xE7E6, [26279] = 0xE7E7, [26280] = 0xE7E8,
  [26281] = 0xE7E9, [26282] = 0xE7EA, [26283] = 0xE7EB, [26284] = 0xE7EC,
  [26285] = 0xE7ED, [26286] = 0xE7EE, [26287] = 0xE7EF, [26288] = 0xE7F0,
  [26289] = 0xE7F1, [26290] = 0xE7F2, [26291] = 0xE7F3, [26292] = 0xE7F4,
  [26293] = 0xE7F5, [26294] = 0xE7F6, [26295] = 0xE7F7, [26296] = 0xE7F8,
  [26297] = 0xE7F9, [26298] = 0xE7FA, [26299] = 0xE7FB, [26300] = 0xE7FC,
  [26301] = 0xE7FD, [26302] = 0xE7FE, [26368] = 0xE840, [26369] = 0xE841,
  [26370] = 0xE842, [26371] = 0xE843, [26372] = 0xE844, [26373] = 0xE845,
  [26374] = 0xE846, [26375] = 0xE847, [26376] = 0xE848, [26377] = 0xE849,
  [26378] = 0xE84A, [26379] = 0xE84B, [26380] = 0xE84C, [26381] = 0xE84D,
  [26382] = 0xE84E, [26383] = 0xE84F, [26384] = 0xE850, [26385] = 0xE851,
  [26386] = 0xE852, [26387] = 0xE853, [26388] = 0xE854, [26389] = 0xE855,
  [26390] = 0xE856, [26391] = 0xE857, [26392] = 0xE858, [26393] = 0xE859,
  [26394] = 0xE85A, [26395] = 0xE85B, [26396] = 0xE85C, [26397] = 0xE85D,
  [26398] = 0xE85E, [26399] = 0xE85F, [26400] = 0xE860, [26401] = 0xE861,
  [26402] = 0xE862, [26403] = 0xE863, [26404] = 0xE864, [26405] = 0xE865,
  [26406] = 0xE866, [26407] = 0xE867, [26408] = 0xE868, [26409] = 0xE869,
  [26410] = 0xE86A, [26411] = 0xE86B, [26412] = 0xE86C, [26413] = 0xE86D,
  [26414] = 0xE86E, [26415] = 0xE86F, [26416] = 0xE870, [26417] = 0xE871,
  [26418] = 0xE872, [26419] = 0xE873, [26420] = 0xE874, [26421] = 0xE875,
  [26422] = 0xE876, [26423] = 0xE877, [26424] = 0xE878, [26425] = 0xE879,
  [26426] = 0xE87A, [26427] = 0xE87B, [26428] = 0xE87C, [26429] = 0xE87D,
  [26430] = 0xE87E, [26432] = 0xE880, [26433] = 0xE881, [26434] = 0xE882,
  [26435] = 0xE883, [26436] = 0xE884, [26437] = 0xE885, [26438] = 0xE886,
  [26439] = 0xE887, [26440] = 0xE888, [26441] = 0xE889, [26442] = 0xE88A,
  [26443] = 0xE88B, [26444] = 0xE88C, [26445] = 0xE88D, [26446] = 0xE88E,
  [26447] = 0xE88F, [26448] = 0xE890, [26449] = 0xE891, [26450] = 0xE892,
  [26451] = 0xE893, [26452] = 0xE894, [26453] = 0xE895, [26454] = 0xE896,
  [26455] = 0xE897, [26456] = 0xE898, [26457] = 0xE899, [26458] = 0xE89A,
  [26459] = 0xE89B, [26460] = 0xE89C, [26461] = 0xE89D, [26462] = 0xE89E,
  [26463] = 0xE89F, [26464] = 0xE8A0, [26465] = 0xE8A1, [26466] = 0xE8A2,
  [26467] = 0xE8A3, [26468] = 0xE8A4, [26469] = 0xE8A5, [26470] = 0xE8A6,
  [26471] = 0xE8A7, [26472] = 0xE8A8, [26473] = 0xE8A9, [26474] = 0xE8AA,
  [26475] = 0xE8AB, [26476] = 0xE8AC, [26477] = 0xE8AD, [26478] = 0xE8AE,
  [26479] = 0xE8AF, [26480] = 0xE8B0, [26481] = 0xE8B1, [26482] = 0xE8B2,
  [26483] = 0xE8B3, [26484] = 0xE8B4, [26485] = 0xE8B5, [26486] = 0xE8B6,
  [26487] = 0xE8B7, [26488] = 0xE8B8, [26489] = 0xE8B9, [26490] = 0xE8BA,
  [26491] = 0xE8BB, [26492] = 0xE8BC, [26493] = 0xE8BD, [26494] = 0xE8BE,
  [26495] = 0xE8BF, [26496] = 0xE8C0, [26497] = 0xE8C1, [26498] = 0xE8C2,
  [26499] = 0xE8C3, [26500] = 0xE8C4, [26501] = 0xE8C5, [26502] = 0xE8C6,
  [26503] = 0xE8C7, [26504] = 0xE8C8, [26505] = 0xE8C9, [26506] = 0xE8CA,
  [26507] = 0xE8CB, [26508] = 0xE8CC, [26509] = 0xE8CD, [26510] = 0xE8CE,
  [26511] = 0xE8CF, [26512] = 0xE8D0, [26513] = 0xE8D1, [26514] = 0xE8D2,
  [26515] = 0xE8D3, [26516] = 0xE8D4, [26517] = 0xE8D5, [26518] = 0xE8D6,
  [26519] = 0xE8D7, [26520] = 0xE8D8, [26521] = 0xE8D9, [26522] = 0xE8DA,
  [26523] = 0xE8DB, [26524] = 0xE8DC, [26525] = 0xE8DD, [26526] = 0xE8DE,
  [26527] = 0xE8DF, [26528] = 0xE8E0, [26529] = 0xE8E1, [26530] = 0xE8E2,
  [26531] = 0xE8E3, [26532] = 0xE8E4, [26533] = 0xE8E5, [26534] = 0xE8E6,
  [26535] = 0xE8E7, [26536] = 0xE8E8, [26537] = 0xE8E9, [26538] = 0xE8EA,
  [26539] = 0xE8EB, [26540] = 0xE8EC, [26541] = 0xE8ED, [26542] = 0xE8EE,
  [26543] = 0xE8EF, [26544] = 0xE8F0, [26545] = 0xE8F1, [26546] = 0xE8F2,
  [26547] = 0xE8F3, [26548] = 0xE8F4, [26549] = 0xE8F5, [26550] = 0xE8F6,
  [26551] = 0xE8F7, [26552] = 0xE8F8, [26553] = 0xE8F9, [26554] = 0xE8FA,
  [26555] = 0xE8FB, [26556] = 0xE8FC, [26557] = 0xE8FD, [26558] = 0xE8FE,
  [26624] = 0xE940, [26625] = 0xE941, [26626] = 0xE942, [26627] = 0xE943,
  [26628] = 0xE944, [26629] = 0xE945, [26630] = 0xE946, [26631] = 0xE947,
  [26632] = 0xE948, [26633] = 0xE949, [26634] = 0xE94A, [26635] = 0xE94B,
  [26636] = 0xE94C, [26637] = 0xE94D, [26638] = 0xE94E, [26639] = 0xE94F,
  [26640] = 0xE950, [26641] = 0xE951, [26642] = 0xE952, [26643] = 0xE953,
  [26644] = 0xE954, [26645] = 0xE955, [26646] = 0xE956, [26647] = 0xE957,
  [26648] = 0xE958, [26649] = 0xE959, [26650] = 0xE95A, [26651] = 0xE95B,
  [26652] = 0xE95C, [26653] = 0xE95D, [26654] = 0xE95E, [26655] = 0xE95F,
  [26656] = 0xE960, [26657] = 0xE961, [26658] = 0xE962, [26659] = 0xE963,
  [26660] = 0xE964, [26661] = 0xE965, [26662] = 0xE966, [26663] = 0xE967,
  [26664] = 0xE968, [26665] = 0xE969, [26666] = 0xE96A, [26667] = 0xE96B,
  [26668] = 0xE96C, [26669] = 0xE96D, [26670] = 0xE96E, [26671] = 0xE96F,
  [26672] = 0xE970, [26673] = 0xE971, [26674] = 0xE972, [26675] = 0xE973,
  [26676] = 0xE974, [26677] = 0xE975, [26678] = 0xE976, [26679] = 0xE977,
  [26680] = 0xE978, [26681] = 0xE979, [26682] = 0xE97A, [26683] = 0xE97B,
  [26684] = 0xE97C, [26685] = 0xE97D, [26686] = 0xE97E, [26688] = 0xE980,
  [26689] = 0xE981, [26690] = 0xE982, [26691] = 0xE983, [26692] = 0xE984,
  [26693] = 0xE985, [26694] = 0xE986, [26695] = 0xE987, [26696] = 0xE988,
  [26697] = 0xE989, [26698] = 0xE98A, [26699] = 0xE98B, [26700] = 0xE98C,
  [26701] = 0xE98D, [26702] = 0xE98E, [26703] = 0xE98F, [26704] = 0xE990,
  [26705] = 0xE991, [26706] = 0xE992, [26707] = 0xE993, [26708] = 0xE994,
  [26709] = 0xE995, [26710] = 0xE996, [26711] = 0xE997, [26712] = 0xE998,
  [26713] = 0xE999, [26714] = 0xE99A, [26715] = 0xE99B, [26716] = 0xE99C,
  [26717] = 0xE99D, [26718] = 0xE99E, [26719] = 0xE99F, [26720] = 0xE9A0,
  [26721] = 0xE9A1, [26722] = 0xE9A2, [26723] = 0xE9A3, [26724] = 0xE9A4,
  [26725] = 0xE9A5, [26726] = 0xE9A6, [26727] = 0xE9A7, [26728] = 0xE9A8,
  [26729] = 0xE9A9, [26730] = 0xE9AA, [26731] = 0xE9AB, [26732] = 0xE9AC,
  [26733] = 0xE9AD, [26734] = 0xE9AE, [26735] = 0xE9AF, [26736] = 0xE9B0,
  [26737] = 0xE9B1, [26738] = 0xE9B2, [26739] = 0xE9B3, [26740] = 0xE9B4,
  [26741] = 0xE9B5, [26742] = 0xE9B6, [26743] = 0xE9B7, [26744] = 0xE9B8,
  [26745] = 0xE9B9, [26746] = 0xE9BA, [26747] = 0xE9BB, [26748] = 0xE9BC,
  [26749] = 0xE9BD, [26750] = 0xE9BE, [26751] = 0xE9BF, [26752] = 0xE9C0,
  [26753] = 0xE9C1, [26754] = 0xE9C2, [26755] = 0xE9C3, [26756] = 0xE9C4,
  [26757] = 0xE9C5, [26758] = 0xE9C6, [26759] = 0xE9C7, [26760] = 0xE9C8,
  [26761] = 0xE9C9, [26762] = 0xE9CA, [26763] = 0xE9CB, [26764] = 0xE9CC,
  [26765] = 0xE9CD, [26766] = 0xE9CE, [26767] = 0xE9CF, [26768] = 0xE9D0,
  [26769] = 0xE9D1, [26770] = 0xE9D2, [26771] = 0xE9D3, [26772] = 0xE9D4,
  [26773] = 0xE9D5, [26774] = 0xE9D6, [26775] = 0xE9D7, [26776] = 0xE9D8,
  [26777] = 0xE9D9, [26778] = 0xE9DA, [26779] = 0xE9DB, [26780] = 0xE9DC,
  [26781] = 0xE9DD, [26782] = 0xE9DE, [26783] = 0xE9DF, [26784] = 0xE9E0,
  [26785] = 0xE9E1, [26786] = 0xE9E2, [26787] = 0xE9E3, [26788] = 0xE9E4,
  [26789] = 0xE9E5, [26790] = 0xE9E6, [26791] = 0xE9E7, [26792] = 0xE9E8,
  [26793] = 0xE9E9, [26794] = 0xE9EA, [26795] = 0xE9EB, [26796] = 0xE9EC,
  [26797] = 0xE9ED, [26798] = 0xE9EE, [26799] = 0xE9EF, [26800] = 0xE9F0,
  [26801] = 0xE9F1, [26802] = 0xE9F2, [26803] = 0xE9F3, [26804] = 0xE9F4,
  [26805] = 0xE9F5, [26806] = 0xE9F6, [26807] = 0xE9F7, [26808] = 0xE9F8,
  [26809] = 0xE9F9, [26810] = 0xE9FA, [26811] = 0xE9FB, [26812] = 0xE9FC,
  [26813] = 0xE9FD, [26814] = 0xE9FE, [26880] = 0xEA40, [26881] = 0xEA41,
  [26882] = 0xEA42, [26883] = 0xEA43, [26884] = 0xEA44, [26885] = 0xEA45,
  [26886] = 0xEA46, [26887] = 0xEA47, [26888] = 0xEA48, [26889] = 0xEA49,
  [26890] = 0xEA4A, [26891] = 0xEA4B, [26892] = 0xEA4C, [26893] = 0xEA4D,
  [26894] = 0xEA4E, [26895] = 0xEA4F, [26896] = 0xEA50, [26897] = 0xEA51,
  [26898] = 0xEA52, [26899] = 0xEA53, [26900] = 0xEA54, [26901] = 0xEA55,
  [26902] = 0xEA56, [26903] = 0xEA57, [26904] = 0xEA58, [26905] = 0xEA59,
  [26906] = 0xEA5A, [26907] = 0xEA5B, [26908] = 0xEA5C, [26909] = 0xEA5D,
  [26910] = 0xEA5E, [26911] = 0xEA5F, [26912] = 0xEA60, [26913] = 0xEA61,
  [26914] = 0xEA62, [26915] = 0xEA63, [26916] = 0xEA64, [26917] = 0xEA65,
  [26918] = 0xEA66, [26919] = 0xEA67, [26920] = 0xEA68, [26921] = 0xEA69,
  [26922] = 0xEA6A, [26923] = 0xEA6B, [26924] = 0xEA6C, [26925] = 0xEA6D,
  [26926] = 0xEA6E, [26927] = 0xEA6F, [26928] = 0xEA70, [26929] = 0xEA71,
  [26930] = 0xEA72, [26931] = 0xEA73, [26932] = 0xEA74, [26933] = 0xEA75,
  [26934] = 0xEA76, [26935] = 0xEA77, [26936] = 0xEA78, [26937] = 0xEA79,
  [26938] = 0xEA7A, [26939] = 0xEA7B, [26940] = 0xEA7C, [26941] = 0xEA7D,
  [26942] = 0xEA7E, [26944] = 0xEA80, [26945] = 0xEA81, [26946] = 0xEA82,
  [26947] = 0xEA83, [26948] = 0xEA84, [26949] = 0xEA85, [26950] = 0xEA86,
  [26951] = 0xEA87, [26952] = 0xEA88, [26953] = 0xEA89, [26954] = 0xEA8A,
  [26955] = 0xEA8B, [26956] = 0xEA8C, [26957] = 0xEA8D, [26958] = 0xEA8E,
  [26959] = 0xEA8F, [26960] = 0xEA90, [26961] = 0xEA91, [26962] = 0xEA92,
  [26963] = 0xEA93, [26964] = 0xEA94, [26965] = 0xEA95, [26966] = 0xEA96,
  [26967] = 0xEA97, [26968] = 0xEA98, [26969] = 0xEA99, [26970] = 0xEA9A,
  [26971] = 0xEA9B, [26972] = 0xEA9C, [26973] = 0xEA9D, [26974] = 0xEA9E,
  [26975] = 0xEA9F, [26976] = 0xEAA0, [26977] = 0xEAA1, [26978] = 0xEAA2,
  [26979] = 0xEAA3, [26980] = 0xEAA4, [26981] = 0xEAA5, [26982] = 0xEAA6,
  [26983] = 0xEAA7, [26984] = 0xEAA8, [26985] = 0xEAA9, [26986] = 0xEAAA,
  [26987] = 0xEAAB, [26988] = 0xEAAC, [26989] = 0xEAAD, [26990] = 0xEAAE,
  [26991] = 0xEAAF, [26992] = 0xEAB0, [26993] = 0xEAB1, [26994] = 0xEAB2,
  [26995] = 0xEAB3, [26996] = 0xEAB4, [26997] = 0xEAB5, [26998] = 0xEAB6,
  [26999] = 0xEAB7, [27000] = 0xEAB8, [27001] = 0xEAB9, [27002] = 0xEABA,
  [27003] = 0xEABB, [27004] = 0xEABC, [27005] = 0xEABD, [27006] = 0xEABE,
  [27007] = 0xEABF, [27008] = 0xEAC0, [27009] = 0xEAC1, [27010] = 0xEAC2,
  [27011] = 0xEAC3, [27012] = 0xEAC4, [27013] = 0xEAC5, [27014] = 0xEAC6,
  [27015] = 0xEAC7, [27016] = 0xEAC8, [27017] = 0xEAC9, [27018] = 0xEACA,
  [27019] = 0xEACB, [27020] = 0xEACC, [27021] = 0xEACD, [27022] = 0xEACE,
  [27023] = 0xEACF, [27024] = 0xEAD0, [27025] = 0xEAD1, [27026] = 0xEAD2,
  [27027] = 0xEAD3, [27028] = 0xEAD4, [27029] = 0xEAD5, [27030] = 0xEAD6,
  [27031] = 0xEAD7, [27032] = 0xEAD8, [27033] = 0xEAD9, [27034] = 0xEADA,
  [27035] = 0xEADB, [27036] = 0xEADC, [27037] = 0xEADD, [27038] = 0xEADE,
  [27039] = 0xEADF, [27040] = 0xEAE0, [27041] = 0xEAE1, [27042] = 0xEAE2,
  [27043] = 0xEAE3, [27044] = 0xEAE4, [27045] = 0xEAE5, [27046] = 0xEAE6,
  [27047] = 0xEAE7, [27048] = 0xEAE8, [27049] = 0xEAE9, [27050] = 0xEAEA,
  [27051] = 0xEAEB, [27052] = 0xEAEC, [27053] = 0xEAED, [27054] = 0xEAEE,
  [27055] = 0xEAEF, [27056] = 0xEAF0, [27057] = 0xEAF1, [27058] = 0xEAF2,
  [27059] = 0xEAF3, [27060] = 0xEAF4, [27061] = 0xEAF5, [27062] = 0xEAF6,
  [27063] = 0xEAF7, [27064] = 0xEAF8, [27065] = 0xEAF9, [27066] = 0xEAFA,
  [27067] = 0xEAFB, [27068] = 0xEAFC, [27069] = 0xEAFD, [27070] = 0xEAFE,
  [27136] = 0xEB40, [27137] = 0xEB41, [27138] = 0xEB42, [27139] = 0xEB43,
  [27140] = 0xEB44, [27141] = 0xEB45, [27142] = 0xEB46, [27143] = 0xEB47,
  [27144] = 0xEB48, [27145] = 0xEB49, [27146] = 0xEB4A, [27147] = 0xEB4B,
  [27148] = 0xEB4C, [27149] = 0xEB4D, [27150] = 0xEB4E, [27151] = 0xEB4F,
  [27152] = 0xEB50, [27153] = 0xEB51, [27154] = 0xEB52, [27155] = 0xEB53,
  [27156] = 0xEB54, [27157] = 0xEB55, [27158] = 0xEB56, [27159] = 0xEB57,
  [27160] = 0xEB58, [27161] = 0xEB59, [27162] = 0xEB5A, [27163] = 0xEB5B,
  [27164] = 0xEB5C, [27165] = 0xEB5D, [27166] = 0xEB5E, [27167] = 0xEB5F,
  [27168] = 0xEB60, [27169] = 0xEB61, [27170] = 0xEB62, [27171] = 0xEB63,
  [27172] = 0xEB64, [27173] = 0xEB65, [27174] = 0xEB66, [27175] = 0xEB67,
  [27176] = 0xEB68, [27177] = 0xEB69, [27178] = 0xEB6A, [27179] = 0xEB6B,
  [27180] = 0xEB6C, [27181] = 0xEB6D, [27182] = 0xEB6E, [27183] = 0xEB6F,
  [27184] = 0xEB70, [27185] = 0xEB71, [27186] = 0xEB72, [27187] = 0xEB73,
  [27188] = 0xEB74, [27189] = 0xEB75, [27190] = 0xEB76, [27191] = 0xEB77,
  [27192] = 0xEB78, [27193] = 0xEB79, [27194] = 0xEB7A, [27195] = 0xEB7B,
  [27196] = 0xEB7C, [27197] = 0xEB7D, [27198] = 0xEB7E, [27200] = 0xEB80,
  [27201] = 0xEB81, [27202] = 0xEB82, [27203] = 0xEB83, [27204] = 0xEB84,
  [27205] = 0xEB85, [27206] = 0xEB86, [27207] = 0xEB87, [27208] = 0xEB88,
  [27209] = 0xEB89, [27210] = 0xEB8A, [27211] = 0xEB8B, [27212] = 0xEB8C,
  [27213] = 0xEB8D, [27214] = 0xEB8E, [27215] = 0xEB8F, [27216] = 0xEB90,
  [27217] = 0xEB91, [27218] = 0xEB92, [27219] = 0xEB93, [27220] = 0xEB94,
  [27221] = 0xEB95, [27222] = 0xEB96, [27223] = 0xEB97, [27224] = 0xEB98,
  [27225] = 0xEB99, [27226] = 0xEB9A, [27227] = 0xEB9B, [27228] = 0xEB9C,
  [27229] = 0xEB9D, [27230] = 0xEB9E, [27231] = 0xEB9F, [27232] = 0xEBA0,
  [27233] = 0xEBA1, [27234] = 0xEBA2, [27235] = 0xEBA3, [27236] = 0xEBA4,
  [27237] = 0xEBA5, [27238] = 0xEBA6, [27239] = 0xEBA7, [27240] = 0xEBA8,
  [27241] = 0xEBA9, [27242] = 0xEBAA, [27243] = 0xEBAB, [27244] = 0xEBAC,
  [27245] = 0xEBAD, [27246] = 0xEBAE, [27247] = 0xEBAF, [27248] = 0xEBB0,
  [27249] = 0xEBB1, [27250] = 0xEBB2, [27251] = 0xEBB3, [27252] = 0xEBB4,
  [27253] = 0xEBB5, [27254] = 0xEBB6, [27255] = 0xEBB7, [27256] = 0xEBB8,
  [27257] = 0xEBB9, [27258] = 0xEBBA, [27259] = 0xEBBB, [27260] = 0xEBBC,
  [27261] = 0xEBBD, [27262] = 0xEBBE, [27263] = 0xEBBF, [27264] = 0xEBC0,
  [27265] = 0xEBC1, [27266] = 0xEBC2, [27267] = 0xEBC3, [27268] = 0xEBC4,
  [27269] = 0xEBC5, [27270] = 0xEBC6, [27271] = 0xEBC7, [27272] = 0xEBC8,
  [27273] = 0xEBC9, [27274] = 0xEBCA, [27275] = 0xEBCB, [27276] = 0xEBCC,
  [27277] = 0xEBCD, [27278] = 0xEBCE, [27279] = 0xEBCF, [27280] = 0xEBD0,
  [27281] = 0xEBD1, [27282] = 0xEBD2, [27283] = 0xEBD3, [27284] = 0xEBD4,
  [27285] = 0xEBD5, [27286] = 0xEBD6, [27287] = 0xEBD7, [27288] = 0xEBD8,
  [27289] = 0xEBD9, [27290] = 0xEBDA, [27291] = 0xEBDB, [27292] = 0xEBDC,
  [27293] = 0xEBDD, [27294] = 0xEBDE, [27295] = 0xEBDF, [27296] = 0xEBE0,
  [27297] = 0xEBE1, [27298] = 0xEBE2, [27299] = 0xEBE3, [27300] = 0xEBE4,
  [27301] = 0xEBE5, [27302] = 0xEBE6, [27303] = 0xEBE7, [27304] = 0xEBE8,
  [27305] = 0xEBE9, [27306] = 0xEBEA, [27307] = 0xEBEB, [27308] = 0xEBEC,
  [27309] = 0xEBED, [27310] = 0xEBEE, [27311] = 0xEBEF, [27312] = 0xEBF0,
  [27313] = 0xEBF1, [27314] = 0xEBF2, [27315] = 0xEBF3, [27316] = 0xEBF4,
  [27317] = 0xEBF5, [27318] = 0xEBF6, [27319] = 0xEBF7, [27320] = 0xEBF8,
  [27321] = 0xEBF9, [27322] = 0xEBFA, [27323] = 0xEBFB, [27324] = 0xEBFC,
  [27325] = 0xEBFD, [27326] = 0xEBFE, [27392] = 0xEC40, [27393] = 0xEC41,
  [27394] = 0xEC42, [27395] = 0xEC43, [27396] = 0xEC44, [27397] = 0xEC45,
  [27398] = 0xEC46, [27399] = 0xEC47, [27400] = 0xEC48, [27401] = 0xEC49,
  [27402] = 0xEC4A, [27403] = 0xEC4B, [27404] = 0xEC4C, [27405] = 0xEC4D,
  [27406] = 0xEC4E, [27407] = 0xEC4F, [27408] = 0xEC50, [27409] = 0xEC51,
  [27410] = 0xEC52, [27411] = 0xEC53, [27412] = 0xEC54, [27413] = 0xEC55,
  [27414] = 0xEC56, [27415] = 0xEC57, [27416] = 0xEC58, [27417] = 0xEC59,
  [27418] = 0xEC5A, [27419] = 0xEC5B, [27420] = 0xEC5C, [27421] = 0xEC5D,
  [27422] = 0xEC5E, [27423] = 0xEC5F, [27424] = 0xEC60, [27425] = 0xEC61,
  [27426] = 0xEC62, [27427] = 0xEC63, [27428] = 0xEC64, [27429] = 0xEC65,
  [27430] = 0xEC66, [27431] = 0xEC67, [27432] = 0xEC68, [27433] = 0xEC69,
  [27434] = 0xEC6A, [27435] = 0xEC6B, [27436] = 0xEC6C, [27437] = 0xEC6D,
  [27438] = 0xEC6E, [27439] = 0xEC6F, [27440] = 0xEC70, [27441] = 0xEC71,
  [27442] = 0xEC72, [27443] = 0xEC73, [27444] = 0xEC74, [27445] = 0xEC75,
  [27446] = 0xEC76, [27447] = 0xEC77, [27448] = 0xEC78, [27449] = 0xEC79,
  [27450] = 0xEC7A, [27451] = 0xEC7B, [27452] = 0xEC7C, [27453] = 0xEC7D,
  [27454] = 0xEC7E, [27456] = 0xEC80, [27457] = 0xEC81, [27458] = 0xEC82,
  [27459] = 0xEC83, [27460] = 0xEC84, [27461] = 0xEC85, [27462] = 0xEC86,
  [27463] = 0xEC87, [27464] = 0xEC88, [27465] = 0xEC89, [27466] = 0xEC8A,
  [27467] = 0xEC8B, [27468] = 0xEC8C, [27469] = 0xEC8D, [27470] = 0xEC8E,
  [27471] = 0xEC8F, [27472] = 0xEC90, [27473] = 0xEC91, [27474] = 0xEC92,
  [27475] = 0xEC93, [27476] = 0xEC94, [27477] = 0xEC95, [27478] = 0xEC96,
  [27479] = 0xEC97, [27480] = 0xEC98, [27481] = 0xEC99, [27482] = 0xEC9A,
  [27483] = 0xEC9B, [27484] = 0xEC9C, [27485] = 0xEC9D, [27486] = 0xEC9E,
  [27487] = 0xEC9F, [27488] = 0xECA0, [27489] = 0xECA1, [27490] = 0xECA2,
  [27491] = 0xECA3, [27492] = 0xECA4, [27493] = 0xECA5, [27494] = 0xECA6,
  [27495] = 0xECA7, [27496] = 0xECA8, [27497] = 0xECA9, [27498] = 0xECAA,
  [27499] = 0xECAB, [27500] = 0xECAC, [27501] = 0xECAD, [27502] = 0xECAE,
  [27503] = 0xECAF, [27504] = 0xECB0, [27505] = 0xECB1, [27506] = 0xECB2,
  [27507] = 0xECB3, [27508] = 0xECB4, [27509] = 0xECB5, [27510] = 0xECB6,
  [27511] = 0xECB7, [27512] = 0xECB8, [27513] = 0xECB9, [27514] = 0xECBA,
  [27515] = 0xECBB, [27516] = 0xECBC, [27517] = 0xECBD, [27518] = 0xECBE,
  [27519] = 0xECBF, [27520] = 0xECC0, [27521] = 0xECC1, [27522] = 0xECC2,
  [27523] = 0xECC3, [27524] = 0xECC4, [27525] = 0xECC5, [27526] = 0xECC6,
  [27527] = 0xECC7, [27528] = 0xECC8, [27529] = 0xECC9, [27530] = 0xECCA,
  [27531] = 0xECCB, [27532] = 0xECCC, [27533] = 0xECCD, [27534] = 0xECCE,
  [27535] = 0xECCF, [27536] = 0xECD0, [27537] = 0xECD1, [27538] = 0xECD2,
  [27539] = 0xECD3, [27540] = 0xECD4, [27541] = 0xECD5, [27542] = 0xECD6,
  [27543] = 0xECD7, [27544] = 0xECD8, [27545] = 0xECD9, [27546] = 0xECDA,
  [27547] = 0xECDB, [27548] = 0xECDC, [27549] = 0xECDD, [27550] = 0xECDE,
  [27551] = 0xECDF, [27552] = 0xECE0, [27553] = 0xECE1, [27554] = 0xECE2,
  [27555] = 0xECE3, [27556] = 0xECE4, [27557] = 0xECE5, [27558] = 0xECE6,
  [27559] = 0xECE7, [27560] = 0xECE8, [27561] = 0xECE9, [27562] = 0xECEA,
  [27563] = 0xECEB, [27564] = 0xECEC, [27565] = 0xECED, [27566] = 0xECEE,
  [27567] = 0xECEF, [27568] = 0xECF0, [27569] = 0xECF1, [27570] = 0xECF2,
  [27571] = 0xECF3, [27572] = 0xECF4, [27573] = 0xECF5, [27574] = 0xECF6,
  [27575] = 0xECF7, [27576] = 0xECF8, [27577] = 0xECF9, [27578] = 0xECFA,
  [27579] = 0xECFB, [27580] = 0xECFC, [27581] = 0xECFD, [27582] = 0xECFE,
  [27648] = 0xED40, [27649] = 0xED41, [27650] = 0xED42, [27651] = 0xED43,
  [27652] = 0xED44, [27653] = 0xED45, [27654] = 0xED46, [27655] = 0xED47,
  [27656] = 0xED48, [27657] = 0xED49, [27658] = 0xED4A, [27659] = 0xED4B,
  [27660] = 0xED4C, [27661] = 0xED4D, [27662] = 0xED4E, [27663] = 0xED4F,
  [27664] = 0xED50, [27665] = 0xED51, [27666] = 0xED52, [27667] = 0xED53,
  [27668] = 0xED54, [27669] = 0xED55, [27670] = 0xED56, [27671] = 0xED57,
  [27672] = 0xED58, [27673] = 0xED59, [27674] = 0xED5A, [27675] = 0xED5B,
  [27676] = 0xED5C, [27677] = 0xED5D, [27678] = 0xED5E, [27679] = 0xED5F,
  [27680] = 0xED60, [27681] = 0xED61, [27682] = 0xED62, [27683] = 0xED63,
  [27684] = 0xED64, [27685] = 0xED65, [27686] = 0xED66, [27687] = 0xED67,
  [27688] = 0xED68, [27689] = 0xED69, [27690] = 0xED6A, [27691] = 0xED6B,
  [27692] = 0xED6C, [27693] = 0xED6D, [27694] = 0xED6E, [27695] = 0xED6F,
  [27696] = 0xED70, [27697] = 0xED71, [27698] = 0xED72, [27699] = 0xED73,
  [27700] = 0xED74, [27701] = 0xED75, [27702] = 0xED76, [27703] = 0xED77,
  [27704] = 0xED78, [27705] = 0xED79, [27706] = 0xED7A, [27707] = 0xED7B,
  [27708] = 0xED7C, [27709] = 0xED7D, [27710] = 0xED7E, [27712] = 0xED80,
  [27713] = 0xED81, [27714] = 0xED82, [27715] = 0xED83, [27716] = 0xED84,
  [27717] = 0xED85, [27718] = 0xED86, [27719] = 0xED87, [27720] = 0xED88,
  [27721] = 0xED89, [27722] = 0xED8A, [27723] = 0xED8B, [27724] = 0xED8C,
  [27725] = 0xED8D, [27726] = 0xED8E, [27727] = 0xED8F, [27728] = 0xED90,
  [27729] = 0xED91, [27730] = 0xED92, [27731] = 0xED93, [27732] = 0xED94,
  [27733] = 0xED95, [27734] = 0xED96, [27735] = 0xED97, [27736] = 0xED98,
  [27737] = 0xED99, [27738] = 0xED9A, [27739] = 0xED9B, [27740] = 0xED9C,
  [27741] = 0xED9D, [27742] = 0xED9E, [27743] = 0xED9F, [27744] = 0xEDA0,
  [27745] = 0xEDA1, [27746] = 0xEDA2, [27747] = 0xEDA3, [27748] = 0xEDA4,
  [27749] = 0xEDA5, [27750] = 0xEDA6, [27751] = 0xEDA7, [27752] = 0xEDA8,
  [27753] = 0xEDA9, [27754] = 0xEDAA, [27755] = 0xEDAB, [27756] = 0xEDAC,
  [27757] = 0xEDAD, [27758] = 0xEDAE, [27759] = 0xEDAF, [27760] = 0xEDB0,
  [27761] = 0xEDB1, [27762] = 0xEDB2, [27763] = 0xEDB3, [27764] = 0xEDB4,
  [27765] = 0xEDB5, [27766] = 0xEDB6, [27767] = 0xEDB7, [27768] = 0xEDB8,
  [27769] = 0xEDB9, [27770] = 0xEDBA, [27771] = 0xEDBB, [27772] = 0xEDBC,
  [27773] = 0xEDBD, [27774] = 0xEDBE, [27775] = 0xEDBF, [27776] = 0xEDC0,
  [27777] = 0xEDC1, [27778] = 0xEDC2, [27779] = 0xEDC3, [27780] = 0xEDC4,
  [27781] = 0xEDC5, [27782] = 0xEDC6, [27783] = 0xEDC7, [27784] = 0xEDC8,
  [27785] = 0xEDC9, [27786] = 0xEDCA, [27787] = 0xEDCB, [27788] = 0xEDCC,
  [27789] = 0xEDCD, [27790] = 0xEDCE, [27791] = 0xEDCF, [27792] = 0xEDD0,
  [27793] = 0xEDD1, [27794] = 0xEDD2, [27795] = 0xEDD3, [27796] = 0xEDD4,
  [27797] = 0xEDD5, [27798] = 0xEDD6, [27799] = 0xEDD7, [27800] = 0xEDD8,
  [27801] = 0xEDD9, [27802] = 0xEDDA, [27803] = 0xEDDB, [27804] = 0xEDDC,
  [27805] = 0xEDDD, [27806] = 0xEDDE, [27807] = 0xEDDF, [27808] = 0xEDE0,
  [27809] = 0xEDE1, [27810] = 0xEDE2, [27811] = 0xEDE3, [27812] = 0xEDE4,
  [27813] = 0xEDE5, [27814] = 0xEDE6, [27815] = 0xEDE7, [27816] = 0xEDE8,
  [27817] = 0xEDE9, [27818] = 0xEDEA, [27819] = 0xEDEB, [27820] = 0xEDEC,
  [27821] = 0xEDED, [27822] = 0xEDEE, [27823] = 0xEDEF, [27824] = 0xEDF0,
  [27825] = 0xEDF1, [27826] = 0xEDF2, [27827] = 0xEDF3, [27828] = 0xEDF4,
  [27829] = 0xEDF5, [27830] = 0xEDF6, [27831] = 0xEDF7, [27832] = 0xEDF8,
  [27833] = 0xEDF9, [27834] = 0xEDFA, [27835] = 0xEDFB, [27836] = 0xEDFC,
  [27837] = 0xEDFD, [27838] = 0xEDFE, [27904] = 0xEE40, [27905] = 0xEE41,
  [27906] = 0xEE42, [27907] = 0xEE43, [27908] = 0xEE44, [27909] = 0xEE45,
  [27910] = 0xEE46, [27911] = 0xEE47, [27912] = 0xEE48, [27913] = 0xEE49,
  [27914] = 0xEE4A, [27915] = 0xEE4B, [27916] = 0xEE4C, [27917] = 0xEE4D,
  [27918] = 0xEE4E, [27919] = 0xEE4F, [27920] = 0xEE50, [27921] = 0xEE51,
  [27922] = 0xEE52, [27923] = 0xEE53, [27924] = 0xEE54, [27925] = 0xEE55,
  [27926] = 0xEE56, [27927] = 0xEE57, [27928] = 0xEE58, [27929] = 0xEE59,
  [27930] = 0xEE5A, [27931] = 0xEE5B, [27932] = 0xEE5C, [27933] = 0xEE5D,
  [27934] = 0xEE5E, [27935] = 0xEE5F, [27936] = 0xEE60, [27937] = 0xEE61,
  [27938] = 0xEE62, [27939] = 0xEE63, [27940] = 0xEE64, [27941] = 0xEE65,
  [27942] = 0xEE66, [27943] = 0xEE67, [27944] = 0xEE68, [27945] = 0xEE69,
  [27946] = 0xEE6A, [27947] = 0xEE6B, [27948] = 0xEE6C, [27949] = 0xEE6D,
  [27950] = 0xEE6E, [27951] = 0xEE6F, [27952] = 0xEE70, [27953] = 0xEE71,
  [27954] = 0xEE72, [27955] = 0xEE73, [27956] = 0xEE74, [27957] = 0xEE75,
  [27958] = 0xEE76, [27959] = 0xEE77, [27960] = 0xEE78, [27961] = 0xEE79,
  [27962] = 0xEE7A, [27963] = 0xEE7B, [27964] = 0xEE7C, [27965] = 0xEE7D,
  [27966] = 0xEE7E, [27968] = 0xEE80, [27969] = 0xEE81, [27970] = 0xEE82,
  [27971] = 0xEE83, [27972] = 0xEE84, [27973] = 0xEE85, [27974] = 0xEE86,
  [27975] = 0xEE87, [27976] = 0xEE88, [27977] = 0xEE89, [27978] = 0xEE8A,
  [27979] = 0xEE8B, [27980] = 0xEE8C, [27981] = 0xEE8D, [27982] = 0xEE8E,
  [27983] = 0xEE8F, [27984] = 0xEE90, [27985] = 0xEE91, [27986] = 0xEE92,
  [27987] = 0xEE93, [27988] = 0xEE94, [27989] = 0xEE95, [27990] = 0xEE96,
  [27991] = 0xEE97, [27992] = 0xEE98, [27993] = 0xEE99, [27994] = 0xEE9A,
  [27995] = 0xEE9B, [27996] = 0xEE9C, [27997] = 0xEE9D, [27998] = 0xEE9E,
  [27999] = 0xEE9F, [28000] = 0xEEA0, [28001] = 0xEEA1, [28002] = 0xEEA2,
  [28003] = 0xEEA3, [28004] = 0xEEA4, [28005] = 0xEEA5, [28006] = 0xEEA6,
  [28007] = 0xEEA7, [28008] = 0xEEA8, [28009] = 0xEEA9, [28010] = 0xEEAA,
  [28011] = 0xEEAB, [28012] = 0xEEAC, [28013] = 0xEEAD, [28014] = 0xEEAE,
  [28015] = 0xEEAF, [28016] = 0xEEB0, [28017] = 0xEEB1, [28018] = 0xEEB2,
  [28019] = 0xEEB3, [28020] = 0xEEB4, [28021] = 0xEEB5, [28022] = 0xEEB6,
  [28023] = 0xEEB7, [28024] = 0xEEB8, [28025] = 0xEEB9, [28026] = 0xEEBA,
  [28027] = 0xEEBB, [28028] = 0xEEBC, [28029] = 0xEEBD, [28030] = 0xEEBE,
  [28031] = 0xEEBF, [28032] = 0xEEC0, [28033] = 0xEEC1, [28034] = 0xEEC2,
  [28035] = 0xEEC3, [28036] = 0xEEC4, [28037] = 0xEEC5, [28038] = 0xEEC6,
  [28039] = 0xEEC7, [28040] = 0xEEC8, [28041] = 0xEEC9, [28042] = 0xEECA,
  [28043] = 0xEECB, [28044] = 0xEECC, [28045] = 0xEECD, [28046] = 0xEECE,
  [28047] = 0xEECF, [28048] = 0xEED0, [28049] = 0xEED1, [28050] = 0xEED2,
  [28051] = 0xEED3, [28052] = 0xEED4, [28053] = 0xEED5, [28054] = 0xEED6,
  [28055] = 0xEED7, [28056] = 0xEED8, [28057] = 0xEED9, [28058] = 0xEEDA,
  [28059] = 0xEEDB, [28060] = 0xEEDC, [28061] = 0xEEDD, [28062] = 0xEEDE,
  [28063] = 0xEEDF, [28064] = 0xEEE0, [28065] = 0xEEE1, [28066] = 0xEEE2,
  [28067] = 0xEEE3, [28068] = 0xEEE4, [28069] = 0xEEE5, [28070] = 0xEEE6,
  [28071] = 0xEEE7, [28072] = 0xEEE8, [28073] = 0xEEE9, [28074] = 0xEEEA,
  [28075] = 0xEEEB, [28076] = 0xEEEC, [28077] = 0xEEED, [28078] = 0xEEEE,
  [28079] = 0xEEEF, [28080] = 0xEEF0, [28081] = 0xEEF1, [28082] = 0xEEF2,
  [28083] = 0xEEF3, [28084] = 0xEEF4, [28085] = 0xEEF5, [28086] = 0xEEF6,
  [28087] = 0xEEF7, [28088] = 0xEEF8, [28089] = 0xEEF9, [28090] = 0xEEFA,
  [28091] = 0xEEFB, [28092] = 0xEEFC, [28093] = 0xEEFD, [28094] = 0xEEFE,
  [28160] = 0xEF40, [28161] = 0xEF41, [28162] = 0xEF42, [28163] = 0xEF43,
  [28164] = 0xEF44, [28165] = 0xEF45, [28166] = 0xEF46, [28167] = 0xEF47,
  [28168] = 0xEF48, [28169] = 0xEF49, [28170] = 0xEF4A, [28171] = 0xEF4B,
  [28172] = 0xEF4C, [28173] = 0xEF4D, [28174] = 0xEF4E, [28175] = 0xEF4F,
  [28176] = 0xEF50, [28177] = 0xEF51, [28178] = 0xEF52, [28179] = 0xEF53,
  [28180] = 0xEF54, [28181] = 0xEF55, [28182] = 0xEF56, [28183] = 0xEF57,
  [28184] = 0xEF58, [28185] = 0xEF59, [28186] = 0xEF5A, [28187] = 0xEF5B,
  [28188] = 0xEF5C, [28189] = 0xEF5D, [28190] = 0xEF5E, [28191] = 0xEF5F,
  [28192] = 0xEF60, [28193] = 0xEF61, [28194] = 0xEF62, [28195] = 0xEF63,
  [28196] = 0xEF64, [28197] = 0xEF65, [28198] = 0xEF66, [28199] = 0xEF67,
  [28200] = 0xEF68, [28201] = 0xEF69, [28202] = 0xEF6A, [28203] = 0xEF6B,
  [28204] = 0xEF6C, [28205] = 0xEF6D, [28206] = 0xEF6E, [28207] = 0xEF6F,
  [28208] = 0xEF70, [28209] = 0xEF71, [28210] = 0xEF72, [28211] = 0xEF73,
  [28212] = 0xEF74, [28213] = 0xEF75, [28214] = 0xEF76, [28215] = 0xEF77,
  [28216] = 0xEF78, [28217] = 0xEF79, [28218] = 0xEF7A, [28219] = 0xEF7B,
  [28220] = 0xEF7C, [28221] = 0xEF7D, [28222] = 0xEF7E, [28224] = 0xEF80,
  [28225] = 0xEF81, [28226] = 0xEF82, [28227] = 0xEF83, [28228] = 0xEF84,
  [28229] = 0xEF85, [28230] = 0xEF86, [28231] = 0xEF87, [28232] = 0xEF88,
  [28233] = 0xEF89, [28234] = 0xEF8A, [28235] = 0xEF8B, [28236] = 0xEF8C,
  [28237] = 0xEF8D, [28238] = 0xEF8E, [28239] = 0xEF8F, [28240] = 0xEF90,
  [28241] = 0xEF91, [28242] = 0xEF92, [28243] = 0xEF93, [28244] = 0xEF94,
  [28245] = 0xEF95, [28246] = 0xEF96, [28247] = 0xEF97, [28248] = 0xEF98,
  [28249] = 0xEF99, [28250] = 0xEF9A, [28251] = 0xEF9B, [28252] = 0xEF9C,
  [28253] = 0xEF9D, [28254] = 0xEF9E, [28255] = 0xEF9F, [28256] = 0xEFA0,
  [28257] = 0xEFA1, [28258] = 0xEFA2, [28259] = 0xEFA3, [28260] = 0xEFA4,
  [28261] = 0xEFA5, [28262] = 0xEFA6, [28263] = 0xEFA7, [28264] = 0xEFA8,
  [28265] = 0xEFA9, [28266] = 0xEFAA, [28267] = 0xEFAB, [28268] = 0xEFAC,
  [28269] = 0xEFAD, [28270] = 0xEFAE, [28271] = 0xEFAF, [28272] = 0xEFB0,
  [28273] = 0xEFB1, [28274] = 0xEFB2, [28275] = 0xEFB3, [28276] = 0xEFB4,
  [28277] = 0xEFB5, [28278] = 0xEFB6, [28279] = 0xEFB7, [28280] = 0xEFB8,
  [28281] = 0xEFB9, [28282] = 0xEFBA, [28283] = 0xEFBB, [28284] = 0xEFBC,
  [28285] = 0xEFBD, [28286] = 0xEFBE, [28287] = 0xEFBF, [28288] = 0xEFC0,
  [28289] = 0xEFC1, [28290] = 0xEFC2, [28291] = 0xEFC3, [28292] = 0xEFC4,
  [28293] = 0xEFC5, [28294] = 0xEFC6, [28295] = 0xEFC7, [28296] = 0xEFC8,
  [28297] = 0xEFC9, [28298] = 0xEFCA, [28299] = 0xEFCB, [28300] = 0xEFCC,
  [28301] = 0xEFCD, [28302] = 0xEFCE, [28303] = 0xEFCF, [28304] = 0xEFD0,
  [28305] = 0xEFD1, [28306] = 0xEFD2, [28307] = 0xEFD3, [28308] = 0xEFD4,
  [28309] = 0xEFD5, [28310] = 0xEFD6, [28311] = 0xEFD7, [28312] = 0xEFD8,
  [28313] = 0xEFD9, [28314] = 0xEFDA, [28315] = 0xEFDB, [28316] = 0xEFDC,
  [28317] = 0xEFDD, [28318] = 0xEFDE, [28319] = 0xEFDF, [28320] = 0xEFE0,
  [28321] = 0xEFE1, [28322] = 0xEFE2, [28323] = 0xEFE3, [28324] = 0xEFE4,
  [28325] = 0xEFE5, [28326] = 0xEFE6, [28327] = 0xEFE7, [28328] = 0xEFE8,
  [28329] = 0xEFE9, [28330] = 0xEFEA, [28331] = 0xEFEB, [28332] = 0xEFEC,
  [28333] = 0xEFED, [28334] = 0xEFEE, [28335] = 0xEFEF, [28336] = 0xEFF0,
  [28337] = 0xEFF1, [28338] = 0xEFF2, [28339] = 0xEFF3, [28340] = 0xEFF4,
  [28341] = 0xEFF5, [28342] = 0xEFF6, [28343] = 0xEFF7, [28344] = 0xEFF8,
  [28345] = 0xEFF9, [28346] = 0xEFFA, [28347] = 0xEFFB, [28348] = 0xEFFC,
  [28349] = 0xEFFD, [28350] = 0xEFFE, [28416] = 0xF040, [28417] = 0xF041,
  [28418] = 0xF042, [28419] = 0xF043, [28420] = 0xF044, [28421] = 0xF045,
  [28422] = 0xF046, [28423] = 0xF047, [28424] = 0xF048, [28425] = 0xF049,
  [28426] = 0xF04A, [28427] = 0xF04B, [28428] = 0xF04C, [28429] = 0xF04D,
  [28430] = 0xF04E, [28431] = 0xF04F, [28432] = 0xF050, [28433] = 0xF051,
  [28434] = 0xF052, [28435] = 0xF053, [28436] = 0xF054, [28437] = 0xF055,
  [28438] = 0xF056, [28439] = 0xF057, [28440] = 0xF058, [28441] = 0xF059,
  [28442] = 0xF05A, [28443] = 0xF05B, [28444] = 0xF05C, [28445] = 0xF05D,
  [28446] = 0xF05E, [28447] = 0xF05F, [28448] = 0xF060, [28449] = 0xF061,
  [28450] = 0xF062, [28451] = 0xF063, [28452] = 0xF064, [28453] = 0xF065,
  [28454] = 0xF066, [28455] = 0xF067, [28456] = 0xF068, [28457] = 0xF069,
  [28458] = 0xF06A, [28459] = 0xF06B, [28460] = 0xF06C, [28461] = 0xF06D,
  [28462] = 0xF06E, [28463] = 0xF06F, [28464] = 0xF070, [28465] = 0xF071,
  [28466] = 0xF072, [28467] = 0xF073, [28468] = 0xF074, [28469] = 0xF075,
  [28470] = 0xF076, [28471] = 0xF077, [28472] = 0xF078, [28473] = 0xF079,
  [28474] = 0xF07A, [28475] = 0xF07B, [28476] = 0xF07C, [28477] = 0xF07D,
  [28478] = 0xF07E, [28480] = 0xF080, [28481] = 0xF081, [28482] = 0xF082,
  [28483] = 0xF083, [28484] = 0xF084, [28485] = 0xF085, [28486] = 0xF086,
  [28487] = 0xF087, [28488] = 0xF088, [28489] = 0xF089, [28490] = 0xF08A,
  [28491] = 0xF08B, [28492] = 0xF08C, [28493] = 0xF08D, [28494] = 0xF08E,
  [28495] = 0xF08F, [28496] = 0xF090, [28497] = 0xF091, [28498] = 0xF092,
  [28499] = 0xF093, [28500] = 0xF094, [28501] = 0xF095, [28502] = 0xF096,
  [28503] = 0xF097, [28504] = 0xF098, [28505] = 0xF099, [28506] = 0xF09A,
  [28507] = 0xF09B, [28508] = 0xF09C, [28509] = 0xF09D, [28510] = 0xF09E,
  [28511] = 0xF09F, [28512] = 0xF0A0, [28513] = 0xF0A1, [28514] = 0xF0A2,
  [28515] = 0xF0A3, [28516] = 0xF0A4, [28517] = 0xF0A5, [28518] = 0xF0A6,
  [28519] = 0xF0A7, [28520] = 0xF0A8, [28521] = 0xF0A9, [28522] = 0xF0AA,
  [28523] = 0xF0AB, [28524] = 0xF0AC, [28525] = 0xF0AD, [28526] = 0xF0AE,
  [28527] = 0xF0AF, [28528] = 0xF0B0, [28529] = 0xF0B1, [28530] = 0xF0B2,
  [28531] = 0xF0B3, [28532] = 0xF0B4, [28533] = 0xF0B5, [28534] = 0xF0B6,
  [28535] = 0xF0B7, [28536] = 0xF0B8, [28537] = 0xF0B9, [28538] = 0xF0BA,
  [28539] = 0xF0BB, [28540] = 0xF0BC, [28541] = 0xF0BD, [28542] = 0xF0BE,
  [28543] = 0xF0BF, [28544] = 0xF0C0, [28545] = 0xF0C1, [28546] = 0xF0C2,
  [28547] = 0xF0C3, [28548] = 0xF0C4, [28549] = 0xF0C5, [28550] = 0xF0C6,
  [28551] = 0xF0C7, [28552] = 0xF0C8, [28553] = 0xF0C9, [28554] = 0xF0CA,
  [28555] = 0xF0CB, [28556] = 0xF0CC, [28557] = 0xF0CD, [28558] = 0xF0CE,
  [28559] = 0xF0CF, [28560] = 0xF0D0, [28561] = 0xF0D1, [28562] = 0xF0D2,
  [28563] = 0xF0D3, [28564] = 0xF0D4, [28565] = 0xF0D5, [28566] = 0xF0D6,
  [28567] = 0xF0D7, [28568] = 0xF0D8, [28569] = 0xF0D9, [28570] = 0xF0DA,
  [28571] = 0xF0DB, [28572] = 0xF0DC, [28573] = 0xF0DD, [28574] = 0xF0DE,
  [28575] = 0xF0DF, [28576] = 0xF0E0, [28577] = 0xF0E1, [28578] = 0xF0E2,
  [28579] = 0xF0E3, [28580] = 0xF0E4, [28581] = 0xF0E5, [28582] = 0xF0E6,
  [28583] = 0xF0E7, [28584] = 0xF0E8, [28585] = 0xF0E9, [28586] = 0xF0EA,
  [28587] = 0xF0EB, [28588] = 0xF0EC, [28589] = 0xF0ED, [28590] = 0xF0EE,
  [28591] = 0xF0EF, [28592] = 0xF0F0, [28593] = 0xF0F1, [28594] = 0xF0F2,
  [28595] = 0xF0F3, [28596] = 0xF0F4, [28597] = 0xF0F5, [28598] = 0xF0F6,
  [28599] = 0xF0F7, [28600] = 0xF0F8, [28601] = 0xF0F9, [28602] = 0xF0FA,
  [28603] = 0xF0FB, [28604] = 0xF0FC, [28605] = 0xF0FD, [28606] = 0xF0FE,
  [28672] = 0xF140, [28673] = 0xF141, [28674] = 0xF142, [28675] = 0xF143,
  [28676] = 0xF144, [28677] = 0xF145, [28678] = 0xF146, [28679] = 0xF147,
  [28680] = 0xF148, [28681] = 0xF149, [28682] = 0xF14A, [28683] = 0xF14B,
  [28684] = 0xF14C, [28685] = 0xF14D, [28686] = 0xF14E, [28687] = 0xF14F,
  [28688] = 0xF150, [28689] = 0xF151, [28690] = 0xF152, [28691] = 0xF153,
  [28692] = 0xF154, [28693] = 0xF155, [28694] = 0xF156, [28695] = 0xF157,
  [28696] = 0xF158, [28697] = 0xF159, [28698] = 0xF15A, [28699] = 0xF15B,
  [28700] = 0xF15C, [28701] = 0xF15D, [28702] = 0xF15E, [28703] = 0xF15F,
  [28704] = 0xF160, [28705] = 0xF161, [28706] = 0xF162, [28707] = 0xF163,
  [28708] = 0xF164, [28709] = 0xF165, [28710] = 0xF166, [28711] = 0xF167,
  [28712] = 0xF168, [28713] = 0xF169, [28714] = 0xF16A, [28715] = 0xF16B,
  [28716] = 0xF16C, [28717] = 0xF16D, [28718] = 0xF16E, [28719] = 0xF16F,
  [28720] = 0xF170, [28721] = 0xF171, [28722] = 0xF172, [28723] = 0xF173,
  [28724] = 0xF174, [28725] = 0xF175, [28726] = 0xF176, [28727] = 0xF177,
  [28728] = 0xF178, [28729] = 0xF179, [28730] = 0xF17A, [28731] = 0xF17B,
  [28732] = 0xF17C, [28733] = 0xF17D, [28734] = 0xF17E, [28736] = 0xF180,
  [28737] = 0xF181, [28738] = 0xF182, [28739] = 0xF183, [28740] = 0xF184,
  [28741] = 0xF185, [28742] = 0xF186, [28743] = 0xF187, [28744] = 0xF188,
  [28745] = 0xF189, [28746] = 0xF18A, [28747] = 0xF18B, [28748] = 0xF18C,
  [28749] = 0xF18D, [28750] = 0xF18E, [28751] = 0xF18F, [28752] = 0xF190,
  [28753] = 0xF191, [28754] = 0xF192, [28755] = 0xF193, [28756] = 0xF194,
  [28757] = 0xF195, [28758] = 0xF196, [28759] = 0xF197, [28760] = 0xF198,
  [28761] = 0xF199, [28762] = 0xF19A, [28763] = 0xF19B, [28764] = 0xF19C,
  [28765] = 0xF19D, [28766] = 0xF19E, [28767] = 0xF19F, [28768] = 0xF1A0,
  [28769] = 0xF1A1, [28770] = 0xF1A2, [28771] = 0xF1A3, [28772] = 0xF1A4,
  [28773] = 0xF1A5, [28774] = 0xF1A6, [28775] = 0xF1A7, [28776] = 0xF1A8,
  [28777] = 0xF1A9, [28778] = 0xF1AA, [28779] = 0xF1AB, [28780] = 0xF1AC,
  [28781] = 0xF1AD, [28782] = 0xF1AE, [28783] = 0xF1AF, [28784] = 0xF1B0,
  [28785] = 0xF1B1, [28786] = 0xF1B2, [28787] = 0xF1B3, [28788] = 0xF1B4,
  [28789] = 0xF1B5, [28790] = 0xF1B6, [28791] = 0xF1B7, [28792] = 0xF1B8,
  [28793] = 0xF1B9, [28794] = 0xF1BA, [28795] = 0xF1BB, [28796] = 0xF1BC,
  [28797] = 0xF1BD, [28798] = 0xF1BE, [28799] = 0xF1BF, [28800] = 0xF1C0,
  [28801] = 0xF1C1, [28802] = 0xF1C2, [28803] = 0xF1C3, [28804] = 0xF1C4,
  [28805] = 0xF1C5, [28806] = 0xF1C6, [28807] = 0xF1C7, [28808] = 0xF1C8,
  [28809] = 0xF1C9, [28810] = 0xF1CA, [28811] = 0xF1CB, [28812] = 0xF1CC,
  [28813] = 0xF1CD, [28814] = 0xF1CE, [28815] = 0xF1CF, [28816] = 0xF1D0,
  [28817] = 0xF1D1, [28818] = 0xF1D2, [28819] = 0xF1D3, [28820] = 0xF1D4,
  [28821] = 0xF1D5, [28822] = 0xF1D6, [28823] = 0xF1D7, [28824] = 0xF1D8,
  [28825] = 0xF1D9, [28826] = 0xF1DA, [28827] = 0xF1DB, [28828] = 0xF1DC,
  [28829] = 0xF1DD, [28830] = 0xF1DE, [28831] = 0xF1DF, [28832] = 0xF1E0,
  [28833] = 0xF1E1, [28834] = 0xF1E2, [28835] = 0xF1E3, [28836] = 0xF1E4,
  [28837] = 0xF1E5, [28838] = 0xF1E6, [28839] = 0xF1E7, [28840] = 0xF1E8,
  [28841] = 0xF1E9, [28842] = 0xF1EA, [28843] = 0xF1EB, [28844] = 0xF1EC,
  [28845] = 0xF1ED, [28846] = 0xF1EE, [28847] = 0xF1EF, [28848] = 0xF1F0,
  [28849] = 0xF1F1, [28850] = 0xF1F2, [28851] = 0xF1F3, [28852] = 0xF1F4,
  [28853] = 0xF1F5, [28854] = 0xF1F6, [28855] = 0xF1F7, [28856] = 0xF1F8,
  [28857] = 0xF1F9, [28858] = 0xF1FA, [28859] = 0xF1FB, [28860] = 0xF1FC,
  [28861] = 0xF1FD, [28862] = 0xF1FE, [28928] = 0xF240, [28929] = 0xF241,
  [28930] = 0xF242, [28931] = 0xF243, [28932] = 0xF244, [28933] = 0xF245,
  [28934] = 0xF246, [28935] = 0xF247, [28936] = 0xF248, [28937] = 0xF249,
  [28938] = 0xF24A, [28939] = 0xF24B, [28940] = 0xF24C, [28941] = 0xF24D,
  [28942] = 0xF24E, [28943] = 0xF24F, [28944] = 0xF250, [28945] = 0xF251,
  [28946] = 0xF252, [28947] = 0xF253, [28948] = 0xF254, [28949] = 0xF255,
  [28950] = 0xF256, [28951] = 0xF257, [28952] = 0xF258, [28953] = 0xF259,
  [28954] = 0xF25A, [28955] = 0xF25B, [28956] = 0xF25C, [28957] = 0xF25D,
  [28958] = 0xF25E, [28959] = 0xF25F, [28960] = 0xF260, [28961] = 0xF261,
  [28962] = 0xF262, [28963] = 0xF263, [28964] = 0xF264, [28965] = 0xF265,
  [28966] = 0xF266, [28967] = 0xF267, [28968] = 0xF268, [28969] = 0xF269,
  [28970] = 0xF26A, [28971] = 0xF26B, [28972] = 0xF26C, [28973] = 0xF26D,
  [28974] = 0xF26E, [28975] = 0xF26F, [28976] = 0xF270, [28977] = 0xF271,
  [28978] = 0xF272, [28979] = 0xF273, [28980] = 0xF274, [28981] = 0xF275,
  [28982] = 0xF276, [28983] = 0xF277, [28984] = 0xF278, [28985] = 0xF279,
  [28986] = 0xF27A, [28987] = 0xF27B, [28988] = 0xF27C, [28989] = 0xF27D,
  [28990] = 0xF27E, [28992] = 0xF280, [28993] = 0xF281, [28994] = 0xF282,
  [28995] = 0xF283, [28996] = 0xF284, [28997] = 0xF285, [28998] = 0xF286,
  [28999] = 0xF287, [29000] = 0xF288, [29001] = 0xF289, [29002] = 0xF28A,
  [29003] = 0xF28B, [29004] = 0xF28C, [29005] = 0xF28D, [29006] = 0xF28E,
  [29007] = 0xF28F, [29008] = 0xF290, [29009] = 0xF291, [29010] = 0xF292,
  [29011] = 0xF293, [29012] = 0xF294, [29013] = 0xF295, [29014] = 0xF296,
  [29015] = 0xF297, [29016] = 0xF298, [29017] = 0xF299, [29018] = 0xF29A,
  [29019] = 0xF29B, [29020] = 0xF29C, [29021] = 0xF29D, [29022] = 0xF29E,
  [29023] = 0xF29F, [29024] = 0xF2A0, [29025] = 0xF2A1, [29026] = 0xF2A2,
  [29027] = 0xF2A3, [29028] = 0xF2A4, [29029] = 0xF2A5, [29030] = 0xF2A6,
  [29031] = 0xF2A7, [29032] = 0xF2A8, [29033] = 0xF2A9, [29034] = 0xF2AA,
  [29035] = 0xF2AB, [29036] = 0xF2AC, [29037] = 0xF2AD, [29038] = 0xF2AE,
  [29039] = 0xF2AF, [29040] = 0xF2B0, [29041] = 0xF2B1, [29042] = 0xF2B2,
  [29043] = 0xF2B3, [29044] = 0xF2B4, [29045] = 0xF2B5, [29046] = 0xF2B6,
  [29047] = 0xF2B7, [29048] = 0xF2B8, [29049] = 0xF2B9, [29050] = 0xF2BA,
  [29051] = 0xF2BB, [29052] = 0xF2BC, [29053] = 0xF2BD, [29054] = 0xF2BE,
  [29055] = 0xF2BF, [29056] = 0xF2C0, [29057] = 0xF2C1, [29058] = 0xF2C2,
  [29059] = 0xF2C3, [29060] = 0xF2C4, [29061] = 0xF2C5, [29062] = 0xF2C6,
  [29063] = 0xF2C7, [29064] = 0xF2C8, [29065] = 0xF2C9, [29066] = 0xF2CA,
  [29067] = 0xF2CB, [29068] = 0xF2CC, [29069] = 0xF2CD, [29070] = 0xF2CE,
  [29071] = 0xF2CF, [29072] = 0xF2D0, [29073] = 0xF2D1, [29074] = 0xF2D2,
  [29075] = 0xF2D3, [29076] = 0xF2D4, [29077] = 0xF2D5, [29078] = 0xF2D6,
  [29079] = 0xF2D7, [29080] = 0xF2D8, [29081] = 0xF2D9, [29082] = 0xF2DA,
  [29083] = 0xF2DB, [29084] = 0xF2DC, [29085] = 0xF2DD, [29086] = 0xF2DE,
  [29087] = 0xF2DF, [29088] = 0xF2E0, [29089] = 0xF2E1, [29090] = 0xF2E2,
  [29091] = 0xF2E3, [29092] = 0xF2E4, [29093] = 0xF2E5, [29094] = 0xF2E6,
  [29095] = 0xF2E7, [29096] = 0xF2E8, [29097] = 0xF2E9, [29098] = 0xF2EA,
  [29099] = 0xF2EB, [29100] = 0xF2EC, [29101] = 0xF2ED, [29102] = 0xF2EE,
  [29103] = 0xF2EF, [29104] = 0xF2F0, [29105] = 0xF2F1, [29106] = 0xF2F2,
  [29107] = 0xF2F3, [29108] = 0xF2F4, [29109] = 0xF2F5, [29110] = 0xF2F6,
  [29111] = 0xF2F7, [29112] = 0xF2F8, [29113] = 0xF2F9, [29114] = 0xF2FA,
  [29115] = 0xF2FB, [29116] = 0xF2FC, [29117] = 0xF2FD, [29118] = 0xF2FE,
  [29184] = 0xF340, [29185] = 0xF341, [29186] = 0xF342, [29187] = 0xF343,
  [29188] = 0xF344, [29189] = 0xF345, [29190] = 0xF346, [29191] = 0xF347,
  [29192] = 0xF348, [29193] = 0xF349, [29194] = 0xF34A, [29195] = 0xF34B,
  [29196] = 0xF34C, [29197] = 0xF34D, [29198] = 0xF34E, [29199] = 0xF34F,
  [29200] = 0xF350, [29201] = 0xF351, [29202] = 0xF352, [29203] = 0xF353,
  [29204] = 0xF354, [29205] = 0xF355, [29206] = 0xF356, [29207] = 0xF357,
  [29208] = 0xF358, [29209] = 0xF359, [29210] = 0xF35A, [29211] = 0xF35B,
  [29212] = 0xF35C, [29213] = 0xF35D, [29214] = 0xF35E, [29215] = 0xF35F,
  [29216] = 0xF360, [29217] = 0xF361, [29218] = 0xF362, [29219] = 0xF363,
  [29220] = 0xF364, [29221] = 0xF365, [29222] = 0xF366, [29223] = 0xF367,
  [29224] = 0xF368, [29225] = 0xF369, [29226] = 0xF36A, [29227] = 0xF36B,
  [29228] = 0xF36C, [29229] = 0xF36D, [29230] = 0xF36E, [29231] = 0xF36F,
  [29232] = 0xF370, [29233] = 0xF371, [29234] = 0xF372, [29235] = 0xF373,
  [29236] = 0xF374, [29237] = 0xF375, [29238] = 0xF376, [29239] = 0xF377,
  [29240] = 0xF378, [29241] = 0xF379, [29242] = 0xF37A, [29243] = 0xF37B,
  [29244] = 0xF37C, [29245] = 0xF37D, [29246] = 0xF37E, [29248] = 0xF380,
  [29249] = 0xF381, [29250] = 0xF382, [29251] = 0xF383, [29252] = 0xF384,
  [29253] = 0xF385, [29254] = 0xF386, [29255] = 0xF387, [29256] = 0xF388,
  [29257] = 0xF389, [29258] = 0xF38A, [29259] = 0xF38B, [29260] = 0xF38C,
  [29261] = 0xF38D, [29262] = 0xF38E, [29263] = 0xF38F, [29264] = 0xF390,
  [29265] = 0xF391, [29266] = 0xF392, [29267] = 0xF393, [29268] = 0xF394,
  [29269] = 0xF395, [29270] = 0xF396, [29271] = 0xF397, [29272] = 0xF398,
  [29273] = 0xF399, [29274] = 0xF39A, [29275] = 0xF39B, [29276] = 0xF39C,
  [29277] = 0xF39D, [29278] = 0xF39E, [29279] = 0xF39F, [29280] = 0xF3A0,
  [29281] = 0xF3A1, [29282] = 0xF3A2, [29283] = 0xF3A3, [29284] = 0xF3A4,
  [29285] = 0xF3A5, [29286] = 0xF3A6, [29287] = 0xF3A7, [29288] = 0xF3A8,
  [29289] = 0xF3A9, [29290] = 0xF3AA, [29291] = 0xF3AB, [29292] = 0xF3AC,
  [29293] = 0xF3AD, [29294] = 0xF3AE, [29295] = 0xF3AF, [29296] = 0xF3B0,
  [29297] = 0xF3B1, [29298] = 0xF3B2, [29299] = 0xF3B3, [29300] = 0xF3B4,
  [29301] = 0xF3B5, [29302] = 0xF3B6, [29303] = 0xF3B7, [29304] = 0xF3B8,
  [29305] = 0xF3B9, [29306] = 0xF3BA, [29307] = 0xF3BB, [29308] = 0xF3BC,
  [29309] = 0xF3BD, [29310] = 0xF3BE, [29311] = 0xF3BF, [29312] = 0xF3C0,
  [29313] = 0xF3C1, [29314] = 0xF3C2, [29315] = 0xF3C3, [29316] = 0xF3C4,
  [29317] = 0xF3C5, [29318] = 0xF3C6, [29319] = 0xF3C7, [29320] = 0xF3C8,
  [29321] = 0xF3C9, [29322] = 0xF3CA, [29323] = 0xF3CB, [29324] = 0xF3CC,
  [29325] = 0xF3CD, [29326] = 0xF3CE, [29327] = 0xF3CF, [29328] = 0xF3D0,
  [29329] = 0xF3D1, [29330] = 0xF3D2, [29331] = 0xF3D3, [29332] = 0xF3D4,
  [29333] = 0xF3D5, [29334] = 0xF3D6, [29335] = 0xF3D7, [29336] = 0xF3D8,
  [29337] = 0xF3D9, [29338] = 0xF3DA, [29339] = 0xF3DB, [29340] = 0xF3DC,
  [29341] = 0xF3DD, [29342] = 0xF3DE, [29343] = 0xF3DF, [29344] = 0xF3E0,
  [29345] = 0xF3E1, [29346] = 0xF3E2, [29347] = 0xF3E3, [29348] = 0xF3E4,
  [29349] = 0xF3E5, [29350] = 0xF3E6, [29351] = 0xF3E7, [29352] = 0xF3E8,
  [29353] = 0xF3E9, [29354] = 0xF3EA, [29355] = 0xF3EB, [29356] = 0xF3EC,
  [29357] = 0xF3ED, [29358] = 0xF3EE, [29359] = 0xF3EF, [29360] = 0xF3F0,
  [29361] = 0xF3F1, [29362] = 0xF3F2, [29363] = 0xF3F3, [29364] = 0xF3F4,
  [29365] = 0xF3F5, [29366] = 0xF3F6, [29367] = 0xF3F7, [29368] = 0xF3F8,
  [29369] = 0xF3F9, [29370] = 0xF3FA, [29371] = 0xF3FB, [29372] = 0xF3FC,
  [29373] = 0xF3FD, [29374] = 0xF3FE, [29440] = 0xF440, [29441] = 0xF441,
  [29442] = 0xF442, [29443] = 0xF443, [29444] = 0xF444, [29445] = 0xF445,
  [29446] = 0xF446, [29447] = 0xF447, [29448] = 0xF448, [29449] = 0xF449,
  [29450] = 0xF44A, [29451] = 0xF44B, [29452] = 0xF44C, [29453] = 0xF44D,
  [29454] = 0xF44E, [29455] = 0xF44F, [29456] = 0xF450, [29457] = 0xF451,
  [29458] = 0xF452, [29459] = 0xF453, [29460] = 0xF454, [29461] = 0xF455,
  [29462] = 0xF456, [29463] = 0xF457, [29464] = 0xF458, [29465] = 0xF459,
  [29466] = 0xF45A, [29467] = 0xF45B, [29468] = 0xF45C, [29469] = 0xF45D,
  [29470] = 0xF45E, [29471] = 0xF45F, [29472] = 0xF460, [29473] = 0xF461,
  [29474] = 0xF462, [29475] = 0xF463, [29476] = 0xF464, [29477] = 0xF465,
  [29478] = 0xF466, [29479] = 0xF467, [29480] = 0xF468, [29481] = 0xF469,
  [29482] = 0xF46A, [29483] = 0xF46B, [29484] = 0xF46C, [29485] = 0xF46D,
  [29486] = 0xF46E, [29487] = 0xF46F, [29488] = 0xF470, [29489] = 0xF471,
  [29490] = 0xF472, [29491] = 0xF473, [29492] = 0xF474, [29493] = 0xF475,
  [29494] = 0xF476, [29495] = 0xF477, [29496] = 0xF478, [29497] = 0xF479,
  [29498] = 0xF47A, [29499] = 0xF47B, [29500] = 0xF47C, [29501] = 0xF47D,
  [29502] = 0xF47E, [29504] = 0xF480, [29505] = 0xF481, [29506] = 0xF482,
  [29507] = 0xF483, [29508] = 0xF484, [29509] = 0xF485, [29510] = 0xF486,
  [29511] = 0xF487, [29512] = 0xF488, [29513] = 0xF489, [29514] = 0xF48A,
  [29515] = 0xF48B, [29516] = 0xF48C, [29517] = 0xF48D, [29518] = 0xF48E,
  [29519] = 0xF48F, [29520] = 0xF490, [29521] = 0xF491, [29522] = 0xF492,
  [29523] = 0xF493, [29524] = 0xF494, [29525] = 0xF495, [29526] = 0xF496,
  [29527] = 0xF497, [29528] = 0xF498, [29529] = 0xF499, [29530] = 0xF49A,
  [29531] = 0xF49B, [29532] = 0xF49C, [29533] = 0xF49D, [29534] = 0xF49E,
  [29535] = 0xF49F, [29536] = 0xF4A0, [29537] = 0xF4A1, [29538] = 0xF4A2,
  [29539] = 0xF4A3, [29540] = 0xF4A4, [29541] = 0xF4A5, [29542] = 0xF4A6,
  [29543] = 0xF4A7, [29544] = 0xF4A8, [29545] = 0xF4A9, [29546] = 0xF4AA,
  [29547] = 0xF4AB, [29548] = 0xF4AC, [29549] = 0xF4AD, [29550] = 0xF4AE,
  [29551] = 0xF4AF, [29552] = 0xF4B0, [29553] = 0xF4B1, [29554] = 0xF4B2,
  [29555] = 0xF4B3, [29556] = 0xF4B4, [29557] = 0xF4B5, [29558] = 0xF4B6,
  [29559] = 0xF4B7, [29560] = 0xF4B8, [29561] = 0xF4B9, [29562] = 0xF4BA,
  [29563] = 0xF4BB, [29564] = 0xF4BC, [29565] = 0xF4BD, [29566] = 0xF4BE,
  [29567] = 0xF4BF, [29568] = 0xF4C0, [29569] = 0xF4C1, [29570] = 0xF4C2,
  [29571] = 0xF4C3, [29572] = 0xF4C4, [29573] = 0xF4C5, [29574] = 0xF4C6,
  [29575] = 0xF4C7, [29576] = 0xF4C8, [29577] = 0xF4C9, [29578] = 0xF4CA,
  [29579] = 0xF4CB, [29580] = 0xF4CC, [29581] = 0xF4CD, [29582] = 0xF4CE,
  [29583] = 0xF4CF, [29584] = 0xF4D0, [29585] = 0xF4D1, [29586] = 0xF4D2,
  [29587] = 0xF4D3, [29588] = 0xF4D4, [29589] = 0xF4D5, [29590] = 0xF4D6,
  [29591] = 0xF4D7, [29592] = 0xF4D8, [29593] = 0xF4D9, [29594] = 0xF4DA,
  [29595] = 0xF4DB, [29596] = 0xF4DC, [29597] = 0xF4DD, [29598] = 0xF4DE,
  [29599] = 0xF4DF, [29600] = 0xF4E0, [29601] = 0xF4E1, [29602] = 0xF4E2,
  [29603] = 0xF4E3, [29604] = 0xF4E4, [29605] = 0xF4E5, [29606] = 0xF4E6,
  [29607] = 0xF4E7, [29608] = 0xF4E8, [29609] = 0xF4E9, [29610] = 0xF4EA,
  [29611] = 0xF4EB, [29612] = 0xF4EC, [29613] = 0xF4ED, [29614] = 0xF4EE,
  [29615] = 0xF4EF, [29616] = 0xF4F0, [29617] = 0xF4F1, [29618] = 0xF4F2,
  [29619] = 0xF4F3, [29620] = 0xF4F4, [29621] = 0xF4F5, [29622] = 0xF4F6,
  [29623] = 0xF4F7, [29624] = 0xF4F8, [29625] = 0xF4F9, [29626] = 0xF4FA,
  [29627] = 0xF4FB, [29628] = 0xF4FC, [29629] = 0xF4FD, [29630] = 0xF4FE,
  [29696] = 0xF540, [29697] = 0xF541, [29698] = 0xF542, [29699] = 0xF543,
  [29700] = 0xF544, [29701] = 0xF545, [29702] = 0xF546, [29703] = 0xF547,
  [29704] = 0xF548, [29705] = 0xF549, [29706] = 0xF54A, [29707] = 0xF54B,
  [29708] = 0xF54C, [29709] = 0xF54D, [29710] = 0xF54E, [29711] = 0xF54F,
  [29712] = 0xF550, [29713] = 0xF551, [29714] = 0xF552, [29715] = 0xF553,
  [29716] = 0xF554, [29717] = 0xF555, [29718] = 0xF556, [29719] = 0xF557,
  [29720] = 0xF558, [29721] = 0xF559, [29722] = 0xF55A, [29723] = 0xF55B,
  [29724] = 0xF55C, [29725] = 0xF55D, [29726] = 0xF55E, [29727] = 0xF55F,
  [29728] = 0xF560, [29729] = 0xF561, [29730] = 0xF562, [29731] = 0xF563,
  [29732] = 0xF564, [29733] = 0xF565, [29734] = 0xF566, [29735] = 0xF567,
  [29736] = 0xF568, [29737] = 0xF569, [29738] = 0xF56A, [29739] = 0xF56B,
  [29740] = 0xF56C, [29741] = 0xF56D, [29742] = 0xF56E, [29743] = 0xF56F,
  [29744] = 0xF570, [29745] = 0xF571, [29746] = 0xF572, [29747] = 0xF573,
  [29748] = 0xF574, [29749] = 0xF575, [29750] = 0xF576, [29751] = 0xF577,
  [29752] = 0xF578, [29753] = 0xF579, [29754] = 0xF57A, [29755] = 0xF57B,
  [29756] = 0xF57C, [29757] = 0xF57D, [29758] = 0xF57E, [29760] = 0xF580,
  [29761] = 0xF581, [29762] = 0xF582, [29763] = 0xF583, [29764] = 0xF584,
  [29765] = 0xF585, [29766] = 0xF586, [29767] = 0xF587, [29768] = 0xF588,
  [29769] = 0xF589, [29770] = 0xF58A, [29771] = 0xF58B, [29772] = 0xF58C,
  [29773] = 0xF58D, [29774] = 0xF58E, [29775] = 0xF58F, [29776] = 0xF590,
  [29777] = 0xF591, [29778] = 0xF592, [29779] = 0xF593, [29780] = 0xF594,
  [29781] = 0xF595, [29782] = 0xF596, [29783] = 0xF597, [29784] = 0xF598,
  [29785] = 0xF599, [29786] = 0xF59A, [29787] = 0xF59B, [29788] = 0xF59C,
  [29789] = 0xF59D, [29790] = 0xF59E, [29791] = 0xF59F, [29792] = 0xF5A0,
  [29793] = 0xF5A1, [29794] = 0xF5A2, [29795] = 0xF5A3, [29796] = 0xF5A4,
  [29797] = 0xF5A5, [29798] = 0xF5A6, [29799] = 0xF5A7, [29800] = 0xF5A8,
  [29801] = 0xF5A9, [29802] = 0xF5AA, [29803] = 0xF5AB, [29804] = 0xF5AC,
  [29805] = 0xF5AD, [29806] = 0xF5AE, [29807] = 0xF5AF, [29808] = 0xF5B0,
  [29809] = 0xF5B1, [29810] = 0xF5B2, [29811] = 0xF5B3, [29812] = 0xF5B4,
  [29813] = 0xF5B5, [29814] = 0xF5B6, [29815] = 0xF5B7, [29816] = 0xF5B8,
  [29817] = 0xF5B9, [29818] = 0xF5BA, [29819] = 0xF5BB, [29820] = 0xF5BC,
  [29821] = 0xF5BD, [29822] = 0xF5BE, [29823] = 0xF5BF, [29824] = 0xF5C0,
  [29825] = 0xF5C1, [29826] = 0xF5C2, [29827] = 0xF5C3, [29828] = 0xF5C4,
  [29829] = 0xF5C5, [29830] = 0xF5C6, [29831] = 0xF5C7, [29832] = 0xF5C8,
  [29833] = 0xF5C9, [29834] = 0xF5CA, [29835] = 0xF5CB, [29836] = 0xF5CC,
  [29837] = 0xF5CD, [29838] = 0xF5CE, [29839] = 0xF5CF, [29840] = 0xF5D0,
  [29841] = 0xF5D1, [29842] = 0xF5D2, [29843] = 0xF5D3, [29844] = 0xF5D4,
  [29845] = 0xF5D5, [29846] = 0xF5D6, [29847] = 0xF5D7, [29848] = 0xF5D8,
  [29849] = 0xF5D9, [29850] = 0xF5DA, [29851] = 0xF5DB, [29852] = 0xF5DC,
  [29853] = 0xF5DD, [29854] = 0xF5DE, [29855] = 0xF5DF, [29856] = 0xF5E0,
  [29857] = 0xF5E1, [29858] = 0xF5E2, [29859] = 0xF5E3, [29860] = 0xF5E4,
  [29861] = 0xF5E5, [29862] = 0xF5E6, [29863] = 0xF5E7, [29864] = 0xF5E8,
  [29865] = 0xF5E9, [29866] = 0xF5EA, [29867] = 0xF5EB, [29868] = 0xF5EC,
  [29869] = 0xF5ED, [29870] = 0xF5EE, [29871] = 0xF5EF, [29872] = 0xF5F0,
  [29873] = 0xF5F1, [29874] = 0xF5F2, [29875] = 0xF5F3, [29876] = 0xF5F4,
  [29877] = 0xF5F5, [29878] = 0xF5F6, [29879] = 0xF5F7, [29880] = 0xF5F8,
  [29881] = 0xF5F9, [29882] = 0xF5FA, [29883] = 0xF5FB, [29884] = 0xF5FC,
  [29885] = 0xF5FD, [29886] = 0xF5FE, [29952] = 0xF640, [29953] = 0xF641,
  [29954] = 0xF642, [29955] = 0xF643, [29956] = 0xF644, [29957] = 0xF645,
  [29958] = 0xF646, [29959] = 0xF647, [29960] = 0xF648, [29961] = 0xF649,
  [29962] = 0xF64A, [29963] = 0xF64B, [29964] = 0xF64C, [29965] = 0xF64D,
  [29966] = 0xF64E, [29967] = 0xF64F, [29968] = 0xF650, [29969] = 0xF651,
  [29970] = 0xF652, [29971] = 0xF653, [29972] = 0xF654, [29973] = 0xF655,
  [29974] = 0xF656, [29975] = 0xF657, [29976] = 0xF658, [29977] = 0xF659,
  [29978] = 0xF65A, [29979] = 0xF65B, [29980] = 0xF65C, [29981] = 0xF65D,
  [29982] = 0xF65E, [29983] = 0xF65F, [29984] = 0xF660, [29985] = 0xF661,
  [29986] = 0xF662, [29987] = 0xF663, [29988] = 0xF664, [29989] = 0xF665,
  [29990] = 0xF666, [29991] = 0xF667, [29992] = 0xF668, [29993] = 0xF669,
  [29994] = 0xF66A, [29995] = 0xF66B, [29996] = 0xF66C, [29997] = 0xF66D,
  [29998] = 0xF66E, [29999] = 0xF66F, [30000] = 0xF670, [30001] = 0xF671,
  [30002] = 0xF672, [30003] = 0xF673, [30004] = 0xF674, [30005] = 0xF675,
  [30006] = 0xF676, [30007] = 0xF677, [30008] = 0xF678, [30009] = 0xF679,
  [30010] = 0xF67A, [30011] = 0xF67B, [30012] = 0xF67C, [30013] = 0xF67D,
  [30014] = 0xF67E, [30016] = 0xF680, [30017] = 0xF681, [30018] = 0xF682,
  [30019] = 0xF683, [30020] = 0xF684, [30021] = 0xF685, [30022] = 0xF686,
  [30023] = 0xF687, [30024] = 0xF688, [30025] = 0xF689, [30026] = 0xF68A,
  [30027] = 0xF68B, [30028] = 0xF68C, [30029] = 0xF68D, [30030] = 0xF68E,
  [30031] = 0xF68F, [30032] = 0xF690, [30033] = 0xF691, [30034] = 0xF692,
  [30035] = 0xF693, [30036] = 0xF694, [30037] = 0xF695, [30038] = 0xF696,
  [30039] = 0xF697, [30040] = 0xF698, [30041] = 0xF699, [30042] = 0xF69A,
  [30043] = 0xF69B, [30044] = 0xF69C, [30045] = 0xF69D, [30046] = 0xF69E,
  [30047] = 0xF69F, [30048] = 0xF6A0, [30049] = 0xF6A1, [30050] = 0xF6A2,
  [30051] = 0xF6A3, [30052] = 0xF6A4, [30053] = 0xF6A5, [30054] = 0xF6A6,
  [30055] = 0xF6A7, [30056] = 0xF6A8, [30057] = 0xF6A9, [30058] = 0xF6AA,
  [30059] = 0xF6AB, [30060] = 0xF6AC, [30061] = 0xF6AD, [30062] = 0xF6AE,
  [30063] = 0xF6AF, [30064] = 0xF6B0, [30065] = 0xF6B1, [30066] = 0xF6B2,
  [30067] = 0xF6B3, [30068] = 0xF6B4, [30069] = 0xF6B5, [30070] = 0xF6B6,
  [30071] = 0xF6B7, [30072] = 0xF6B8, [30073] = 0xF6B9, [30074] = 0xF6BA,
  [30075] = 0xF6BB, [30076] = 0xF6BC, [30077] = 0xF6BD, [30078] = 0xF6BE,
  [30079] = 0xF6BF, [30080] = 0xF6C0, [30081] = 0xF6C1, [30082] = 0xF6C2,
  [30083] = 0xF6C3, [30084] = 0xF6C4, [30085] = 0xF6C5, [30086] = 0xF6C6,
  [30087] = 0xF6C7, [30088] = 0xF6C8, [30089] = 0xF6C9, [30090] = 0xF6CA,
  [30091] = 0xF6CB, [30092] = 0xF6CC, [30093] = 0xF6CD, [30094] = 0xF6CE,
  [30095] = 0xF6CF, [30096] = 0xF6D0, [30097] = 0xF6D1, [30098] = 0xF6D2,
  [30099] = 0xF6D3, [30100] = 0xF6D4, [30101] = 0xF6D5, [30102] = 0xF6D6,
  [30103] = 0xF6D7, [30104] = 0xF6D8, [30105] = 0xF6D9, [30106] = 0xF6DA,
  [30107] = 0xF6DB, [30108] = 0xF6DC, [30109] = 0xF6DD, [30110] = 0xF6DE,
  [30111] = 0xF6DF, [30112] = 0xF6E0, [30113] = 0xF6E1, [30114] = 0xF6E2,
  [30115] = 0xF6E3, [30116] = 0xF6E4, [30117] = 0xF6E5, [30118] = 0xF6E6,
  [30119] = 0xF6E7, [30120] = 0xF6E8, [30121] = 0xF6E9, [30122] = 0xF6EA,
  [30123] = 0xF6EB, [30124] = 0xF6EC, [30125] = 0xF6ED, [30126] = 0xF6EE,
  [30127] = 0xF6EF, [30128] = 0xF6F0, [30129] = 0xF6F1, [30130] = 0xF6F2,
  [30131] = 0xF6F3, [30132] = 0xF6F4, [30133] = 0xF6F5, [30134] = 0xF6F6,
  [30135] = 0xF6F7, [30136] = 0xF6F8, [30137] = 0xF6F9, [30138] = 0xF6FA,
  [30139] = 0xF6FB, [30140] = 0xF6FC, [30141] = 0xF6FD, [30142] = 0xF6FE,
  [30208] = 0xF740, [30209] = 0xF741, [30210] = 0xF742, [30211] = 0xF743,
  [30212] = 0xF744, [30213] = 0xF745, [30214] = 0xF746, [30215] = 0xF747,
  [30216] = 0xF748, [30217] = 0xF749, [30218] = 0xF74A, [30219] = 0xF74B,
  [30220] = 0xF74C, [30221] = 0xF74D, [30222] = 0xF74E, [30223] = 0xF74F,
  [30224] = 0xF750, [30225] = 0xF751, [30226] = 0xF752, [30227] = 0xF753,
  [30228] = 0xF754, [30229] = 0xF755, [30230] = 0xF756, [30231] = 0xF757,
  [30232] = 0xF758, [30233] = 0xF759, [30234] = 0xF75A, [30235] = 0xF75B,
  [30236] = 0xF75C, [30237] = 0xF75D, [30238] = 0xF75E, [30239] = 0xF75F,
  [30240] = 0xF760, [30241] = 0xF761, [30242] = 0xF762, [30243] = 0xF763,
  [30244] = 0xF764, [30245] = 0xF765, [30246] = 0xF766, [30247] = 0xF767,
  [30248] = 0xF768, [30249] = 0xF769, [30250] = 0xF76A, [30251] = 0xF76B,
  [30252] = 0xF76C, [30253] = 0xF76D, [30254] = 0xF76E, [30255] = 0xF76F,
  [30256] = 0xF770, [30257] = 0xF771, [30258] = 0xF772, [30259] = 0xF773,
  [30260] = 0xF774, [30261] = 0xF775, [30262] = 0xF776, [30263] = 0xF777,
  [30264] = 0xF778, [30265] = 0xF779, [30266] = 0xF77A, [30267] = 0xF77B,
  [30268] = 0xF77C, [30269] = 0xF77D, [30270] = 0xF77E, [30272] = 0xF780,
  [30273] = 0xF781, [30274] = 0xF782, [30275] = 0xF783, [30276] = 0xF784,
  [30277] = 0xF785, [30278] = 0xF786, [30279] = 0xF787, [30280] = 0xF788,
  [30281] = 0xF789, [30282] = 0xF78A, [30283] = 0xF78B, [30284] = 0xF78C,
  [30285] = 0xF78D, [30286] = 0xF78E, [30287] = 0xF78F, [30288] = 0xF790,
  [30289] = 0xF791, [30290] = 0xF792, [30291] = 0xF793, [30292] = 0xF794,
  [30293] = 0xF795, [30294] = 0xF796, [30295] = 0xF797, [30296] = 0xF798,
  [30297] = 0xF799, [30298] = 0xF79A, [30299] = 0xF79B, [30300] = 0xF79C,
  [30301] = 0xF79D, [30302] = 0xF79E, [30303] = 0xF79F, [30304] = 0xF7A0,
  [30305] = 0xF7A1, [30306] = 0xF7A2, [30307] = 0xF7A3, [30308] = 0xF7A4,
  [30309] = 0xF7A5, [30310] = 0xF7A6, [30311] = 0xF7A7, [30312] = 0xF7A8,
  [30313] = 0xF7A9, [30314] = 0xF7AA, [30315] = 0xF7AB, [30316] = 0xF7AC,
  [30317] = 0xF7AD, [30318] = 0xF7AE, [30319] = 0xF7AF, [30320] = 0xF7B0,
  [30321] = 0xF7B1, [30322] = 0xF7B2, [30323] = 0xF7B3, [30324] = 0xF7B4,
  [30325] = 0xF7B5, [30326] = 0xF7B6, [30327] = 0xF7B7, [30328] = 0xF7B8,
  [30329] = 0xF7B9, [30330] = 0xF7BA, [30331] = 0xF7BB, [30332] = 0xF7BC,
  [30333] = 0xF7BD, [30334] = 0xF7BE, [30335] = 0xF7BF, [30336] = 0xF7C0,
  [30337] = 0xF7C1, [30338] = 0xF7C2, [30339] = 0xF7C3, [30340] = 0xF7C4,
  [30341] = 0xF7C5, [30342] = 0xF7C6, [30343] = 0xF7C7, [30344] = 0xF7C8,
  [30345] = 0xF7C9, [30346] = 0xF7CA, [30347] = 0xF7CB, [30348] = 0xF7CC,
  [30349] = 0xF7CD, [30350] = 0xF7CE, [30351] = 0xF7CF, [30352] = 0xF7D0,
  [30353] = 0xF7D1, [30354] = 0xF7D2, [30355] = 0xF7D3, [30356] = 0xF7D4,
  [30357] = 0xF7D5, [30358] = 0xF7D6, [30359] = 0xF7D7, [30360] = 0xF7D8,
  [30361] = 0xF7D9, [30362] = 0xF7DA, [30363] = 0xF7DB, [30364] = 0xF7DC,
  [30365] = 0xF7DD, [30366] = 0xF7DE, [30367] = 0xF7DF, [30368] = 0xF7E0,
  [30369] = 0xF7E1, [30370] = 0xF7E2, [30371] = 0xF7E3, [30372] = 0xF7E4,
  [30373] = 0xF7E5, [30374] = 0xF7E6, [30375] = 0xF7E7, [30376] = 0xF7E8,
  [30377] = 0xF7E9, [30378] = 0xF7EA, [30379] = 0xF7EB, [30380] = 0xF7EC,
  [30381] = 0xF7ED, [30382] = 0xF7EE, [30383] = 0xF7EF, [30384] = 0xF7F0,
  [30385] = 0xF7F1, [30386] = 0xF7F2, [30387] = 0xF7F3, [30388] = 0xF7F4,
  [30389] = 0xF7F5, [30390] = 0xF7F6, [30391] = 0xF7F7, [30392] = 0xF7F8,
  [30393] = 0xF7F9, [30394] = 0xF7FA, [30395] = 0xF7FB, [30396] = 0xF7FC,
  [30397] = 0xF7FD, [30398] = 0xF7FE, [30464] = 0xF840, [30465] = 0xF841,
  [30466] = 0xF842, [30467] = 0xF843, [30468] = 0xF844, [30469] = 0xF845,
  [30470] = 0xF846, [30471] = 0xF847, [30472] = 0xF848, [30473] = 0xF849,
  [30474] = 0xF84A, [30475] = 0xF84B, [30476] = 0xF84C, [30477] = 0xF84D,
  [30478] = 0xF84E, [30479] = 0xF84F, [30480] = 0xF850, [30481] = 0xF851,
  [30482] = 0xF852, [30483] = 0xF853, [30484] = 0xF854, [30485] = 0xF855,
  [30486] = 0xF856, [30487] = 0xF857, [30488] = 0xF858, [30489] = 0xF859,
  [30490] = 0xF85A, [30491] = 0xF85B, [30492] = 0xF85C, [30493] = 0xF85D,
  [30494] = 0xF85E, [30495] = 0xF85F, [30496] = 0xF860, [30497] = 0xF861,
  [30498] = 0xF862, [30499] = 0xF863, [30500] = 0xF864, [30501] = 0xF865,
  [30502] = 0xF866, [30503] = 0xF867, [30504] = 0xF868, [30505] = 0xF869,
  [30506] = 0xF86A, [30507] = 0xF86B, [30508] = 0xF86C, [30509] = 0xF86D,
  [30510] = 0xF86E, [30511] = 0xF86F, [30512] = 0xF870, [30513] = 0xF871,
  [30514] = 0xF872, [30515] = 0xF873, [30516] = 0xF874, [30517] = 0xF875,
  [30518] = 0xF876, [30519] = 0xF877, [30520] = 0xF878, [30521] = 0xF879,
  [30522] = 0xF87A, [30523] = 0xF87B, [30524] = 0xF87C, [30525] = 0xF87D,
  [30526] = 0xF87E, [30528] = 0xF880, [30529] = 0xF881, [30530] = 0xF882,
  [30531] = 0xF883, [30532] = 0xF884, [30533] = 0xF885, [30534] = 0xF886,
  [30535] = 0xF887, [30536] = 0xF888, [30537] = 0xF889, [30538] = 0xF88A,
  [30539] = 0xF88B, [30540] = 0xF88C, [30541] = 0xF88D, [30542] = 0xF88E,
  [30543] = 0xF88F, [30544] = 0xF890, [30545] = 0xF891, [30546] = 0xF892,
  [30547] = 0xF893, [30548] = 0xF894, [30549] = 0xF895, [30550] = 0xF896,
  [30551] = 0xF897, [30552] = 0xF898, [30553] = 0xF899, [30554] = 0xF89A,
  [30555] = 0xF89B, [30556] = 0xF89C, [30557] = 0xF89D, [30558] = 0xF89E,
  [30559] = 0xF89F, [30560] = 0xF8A0, [30561] = 0xF8A1, [30562] = 0xF8A2,
  [30563] = 0xF8A3, [30564] = 0xF8A4, [30565] = 0xF8A5, [30566] = 0xF8A6,
  [30567] = 0xF8A7, [30568] = 0xF8A8, [30569] = 0xF8A9, [30570] = 0xF8AA,
  [30571] = 0xF8AB, [30572] = 0xF8AC, [30573] = 0xF8AD, [30574] = 0xF8AE,
  [30575] = 0xF8AF, [30576] = 0xF8B0, [30577] = 0xF8B1, [30578] = 0xF8B2,
  [30579] = 0xF8B3, [30580] = 0xF8B4, [30581] = 0xF8B5, [30582] = 0xF8B6,
  [30583] = 0xF8B7, [30584] = 0xF8B8, [30585] = 0xF8B9, [30586] = 0xF8BA,
  [30587] = 0xF8BB, [30588] = 0xF8BC, [30589] = 0xF8BD, [30590] = 0xF8BE,
  [30591] = 0xF8BF, [30592] = 0xF8C0, [30593] = 0xF8C1, [30594] = 0xF8C2,
  [30595] = 0xF8C3, [30596] = 0xF8C4, [30597] = 0xF8C5, [30598] = 0xF8C6,
  [30599] = 0xF8C7, [30600] = 0xF8C8, [30601] = 0xF8C9, [30602] = 0xF8CA,
  [30603] = 0xF8CB, [30604] = 0xF8CC, [30605] = 0xF8CD, [30606] = 0xF8CE,
  [30607] = 0xF8CF, [30608] = 0xF8D0, [30609] = 0xF8D1, [30610] = 0xF8D2,
  [30611] = 0xF8D3, [30612] = 0xF8D4, [30613] = 0xF8D5, [30614] = 0xF8D6,
  [30615] = 0xF8D7, [30616] = 0xF8D8, [30617] = 0xF8D9, [30618] = 0xF8DA,
  [30619] = 0xF8DB, [30620] = 0xF8DC, [30621] = 0xF8DD, [30622] = 0xF8DE,
  [30623] = 0xF8DF, [30624] = 0xF8E0, [30625] = 0xF8E1, [30626] = 0xF8E2,
  [30627] = 0xF8E3, [30628] = 0xF8E4, [30629] = 0xF8E5, [30630] = 0xF8E6,
  [30631] = 0xF8E7, [30632] = 0xF8E8, [30633] = 0xF8E9, [30634] = 0xF8EA,
  [30635] = 0xF8EB, [30636] = 0xF8EC, [30637] = 0xF8ED, [30638] = 0xF8EE,
  [30639] = 0xF8EF, [30640] = 0xF8F0, [30641] = 0xF8F1, [30642] = 0xF8F2,
  [30643] = 0xF8F3, [30644] = 0xF8F4, [30645] = 0xF8F5, [30646] = 0xF8F6,
  [30647] = 0xF8F7, [30648] = 0xF8F8, [30649] = 0xF8F9, [30650] = 0xF8FA,
  [30651] = 0xF8FB, [30652] = 0xF8FC, [30653] = 0xF8FD, [30654] = 0xF8FE,
  [30720] = 0xF940, [30721] = 0xF941, [30722] = 0xF942, [30723] = 0xF943,
  [30724] = 0xF944, [30725] = 0xF945, [30726] = 0xF946, [30727] = 0xF947,
  [30728] = 0xF948, [30729] = 0xF949, [30730] = 0xF94A, [30731] = 0xF94B,
  [30732] = 0xF94C, [30733] = 0xF94D, [30734] = 0xF94E, [30735] = 0xF94F,
  [30736] = 0xF950, [30737] = 0xF951, [30738] = 0xF952, [30739] = 0xF953,
  [30740] = 0xF954, [30741] = 0xF955, [30742] = 0xF956, [30743] = 0xF957,
  [30744] = 0xF958, [30745] = 0xF959, [30746] = 0xF95A, [30747] = 0xF95B,
  [30748] = 0xF95C, [30749] = 0xF95D, [30750] = 0xF95E, [30751] = 0xF95F,
  [30752] = 0xF960, [30753] = 0xF961, [30754] = 0xF962, [30755] = 0xF963,
  [30756] = 0xF964, [30757] = 0xF965, [30758] = 0xF966, [30759] = 0xF967,
  [30760] = 0xF968, [30761] = 0xF969, [30762] = 0xF96A, [30763] = 0xF96B,
  [30764] = 0xF96C, [30765] = 0xF96D, [30766] = 0xF96E, [30767] = 0xF96F,
  [30768] = 0xF970, [30769] = 0xF971, [30770] = 0xF972, [30771] = 0xF973,
  [30772] = 0xF974, [30773] = 0xF975, [30774] = 0xF976, [30775] = 0xF977,
  [30776] = 0xF978, [30777] = 0xF979, [30778] = 0xF97A, [30779] = 0xF97B,
  [30780] = 0xF97C, [30781] = 0xF97D, [30782] = 0xF97E, [30784] = 0xF980,
  [30785] = 0xF981, [30786] = 0xF982, [30787] = 0xF983, [30788] = 0xF984,
  [30789] = 0xF985, [30790] = 0xF986, [30791] = 0xF987, [30792] = 0xF988,
  [30793] = 0xF989, [30794] = 0xF98A, [30795] = 0xF98B, [30796] = 0xF98C,
  [30797] = 0xF98D, [30798] = 0xF98E, [30799] = 0xF98F, [30800] = 0xF990,
  [30801] = 0xF991, [30802] = 0xF992, [30803] = 0xF993, [30804] = 0xF994,
  [30805] = 0xF995, [30806] = 0xF996, [30807] = 0xF997, [30808] = 0xF998,
  [30809] = 0xF999, [30810] = 0xF99A, [30811] = 0xF99B, [30812] = 0xF99C,
  [30813] = 0xF99D, [30814] = 0xF99E, [30815] = 0xF99F, [30816] = 0xF9A0,
  [30817] = 0xF9A1, [30818] = 0xF9A2, [30819] = 0xF9A3, [30820] = 0xF9A4,
  [30821] = 0xF9A5, [30822] = 0xF9A6, [30823] = 0xF9A7, [30824] = 0xF9A8,
  [30825] = 0xF9A9, [30826] = 0xF9AA, [30827] = 0xF9AB, [30828] = 0xF9AC,
  [30829] = 0xF9AD, [30830] = 0xF9AE, [30831] = 0xF9AF, [30832] = 0xF9B0,
  [30833] = 0xF9B1, [30834] = 0xF9B2, [30835] = 0xF9B3, [30836] = 0xF9B4,
  [30837] = 0xF9B5, [30838] = 0xF9B6, [30839] = 0xF9B7, [30840] = 0xF9B8,
  [30841] = 0xF9B9, [30842] = 0xF9BA, [30843] = 0xF9BB, [30844] = 0xF9BC,
  [30845] = 0xF9BD, [30846] = 0xF9BE, [30847] = 0xF9BF, [30848] = 0xF9C0,
  [30849] = 0xF9C1, [30850] = 0xF9C2, [30851] = 0xF9C3, [30852] = 0xF9C4,
  [30853] = 0xF9C5, [30854] = 0xF9C6, [30855] = 0xF9C7, [30856] = 0xF9C8,
  [30857] = 0xF9C9, [30858] = 0xF9CA, [30859] = 0xF9CB, [30860] = 0xF9CC,
  [30861] = 0xF9CD, [30862] = 0xF9CE, [30863] = 0xF9CF, [30864] = 0xF9D0,
  [30865] = 0xF9D1, [30866] = 0xF9D2, [30867] = 0xF9D3, [30868] = 0xF9D4,
  [30869] = 0xF9D5, [30870] = 0xF9D6, [30871] = 0xF9D7, [30872] = 0xF9D8,
  [30873] = 0xF9D9, [30874] = 0xF9DA, [30875] = 0xF9DB, [30876] = 0xF9DC,
  [30877] = 0xF9DD, [30878] = 0xF9DE, [30879] = 0xF9DF, [30880] = 0xF9E0,
  [30881] = 0xF9E1, [30882] = 0xF9E2, [30883] = 0xF9E3, [30884] = 0xF9E4,
  [30885] = 0xF9E5, [30886] = 0xF9E6, [30887] = 0xF9E7, [30888] = 0xF9E8,
  [30889] = 0xF9E9, [30890] = 0xF9EA, [30891] = 0xF9EB, [30892] = 0xF9EC,
  [30893] = 0xF9ED, [30894] = 0xF9EE, [30895] = 0xF9EF, [30896] = 0xF9F0,
  [30897] = 0xF9F1, [30898] = 0xF9F2, [30899] = 0xF9F3, [30900] = 0xF9F4,
  [30901] = 0xF9F5, [30902] = 0xF9F6, [30903] = 0xF9F7, [30904] = 0xF9F8,
  [30905] = 0xF9F9, [30906] = 0xF9FA, [30907] = 0xF9FB, [30908] = 0xF9FC,
  [30909] = 0xF9FD, [30910] = 0xF9FE, [30976] = 0xFA40, [30977] = 0xFA41,
  [30978] = 0xFA42, [30979] = 0xFA43, [30980] = 0xFA44, [30981] = 0xFA45,
  [30982] = 0xFA46, [30983] = 0xFA47, [30984] = 0xFA48, [30985] = 0xFA49,
  [30986] = 0xFA4A, [30987] = 0xFA4B, [30988] = 0xFA4C, [30989] = 0xFA4D,
  [30990] = 0xFA4E, [30991] = 0xFA4F, [30992] = 0xFA50, [30993] = 0xFA51,
  [30994] = 0xFA52, [30995] = 0xFA53, [30996] = 0xFA54, [30997] = 0xFA55,
  [30998] = 0xFA56, [30999] = 0xFA57, [31000] = 0xFA58, [31001] = 0xFA59,
  [31002] = 0xFA5A, [31003] = 0xFA5B, [31004] = 0xFA5C, [31005] = 0xFA5D,
  [31006] = 0xFA5E, [31007] = 0xFA5F, [31008] = 0xFA60, [31009] = 0xFA61,
  [31010] = 0xFA62, [31011] = 0xFA63, [31012] = 0xFA64, [31013] = 0xFA65,
  [31014] = 0xFA66, [31015] = 0xFA67, [31016] = 0xFA68, [31017] = 0xFA69,
  [31018] = 0xFA6A, [31019] = 0xFA6B, [31020] = 0xFA6C, [31021] = 0xFA6D,
  [31022] = 0xFA6E, [31023] = 0xFA6F, [31024] = 0xFA70, [31025] = 0xFA71,
  [31026] = 0xFA72, [31027] = 0xFA73, [31028] = 0xFA74, [31029] = 0xFA75,
  [31030] = 0xFA76, [31031] = 0xFA77, [31032] = 0xFA78, [31033] = 0xFA79,
  [31034] = 0xFA7A, [31035] = 0xFA7B, [31036] = 0xFA7C, [31037] = 0xFA7D,
  [31038] = 0xFA7E, [31040] = 0xFA80, [31041] = 0xFA81, [31042] = 0xFA82,
  [31043] = 0xFA83, [31044] = 0xFA84, [31045] = 0xFA85, [31046] = 0xFA86,
  [31047] = 0xFA87, [31048] = 0xFA88, [31049] = 0xFA89, [31050] = 0xFA8A,
  [31051] = 0xFA8B, [31052] = 0xFA8C, [31053] = 0xFA8D, [31054] = 0xFA8E,
  [31055] = 0xFA8F, [31056] = 0xFA90, [31057] = 0xFA91, [31058] = 0xFA92,
  [31059] = 0xFA93, [31060] = 0xFA94, [31061] = 0xFA95, [31062] = 0xFA96,
  [31063] = 0xFA97, [31064] = 0xFA98, [31065] = 0xFA99, [31066] = 0xFA9A,
  [31067] = 0xFA9B, [31068] = 0xFA9C, [31069] = 0xFA9D, [31070] = 0xFA9E,
  [31071] = 0xFA9F, [31072] = 0xFAA0, [31073] = 0xFAA1, [31074] = 0xFAA2,
  [31075] = 0xFAA3, [31076] = 0xFAA4, [31077] = 0xFAA5, [31078] = 0xFAA6,
  [31079] = 0xFAA7, [31080] = 0xFAA8, [31081] = 0xFAA9, [31082] = 0xFAAA,
  [31083] = 0xFAAB, [31084] = 0xFAAC, [31085] = 0xFAAD, [31086] = 0xFAAE,
  [31087] = 0xFAAF, [31088] = 0xFAB0, [31089] = 0xFAB1, [31090] = 0xFAB2,
  [31091] = 0xFAB3, [31092] = 0xFAB4, [31093] = 0xFAB5, [31094] = 0xFAB6,
  [31095] = 0xFAB7, [31096] = 0xFAB8, [31097] = 0xFAB9, [31098] = 0xFABA,
  [31099] = 0xFABB, [31100] = 0xFABC, [31101] = 0xFABD, [31102] = 0xFABE,
  [31103] = 0xFABF, [31104] = 0xFAC0, [31105] = 0xFAC1, [31106] = 0xFAC2,
  [31107] = 0xFAC3, [31108] = 0xFAC4, [31109] = 0xFAC5, [31110] = 0xFAC6,
  [31111] = 0xFAC7, [31112] = 0xFAC8, [31113] = 0xFAC9, [31114] = 0xFACA,
  [31115] = 0xFACB, [31116] = 0xFACC, [31117] = 0xFACD, [31118] = 0xFACE,
  [31119] = 0xFACF, [31120] = 0xFAD0, [31121] = 0xFAD1, [31122] = 0xFAD2,
  [31123] = 0xFAD3, [31124] = 0xFAD4, [31125] = 0xFAD5, [31126] = 0xFAD6,
  [31127] = 0xFAD7, [31128] = 0xFAD8, [31129] = 0xFAD9, [31130] = 0xFADA,
  [31131] = 0xFADB, [31132] = 0xFADC, [31133] = 0xFADD, [31134] = 0xFADE,
  [31135] = 0xFADF, [31136] = 0xFAE0, [31137] = 0xFAE1, [31138] = 0xFAE2,
  [31139] = 0xFAE3, [31140] = 0xFAE4, [31141] = 0xFAE5, [31142] = 0xFAE6,
  [31143] = 0xFAE7, [31144] = 0xFAE8, [31145] = 0xFAE9, [31146] = 0xFAEA,
  [31147] = 0xFAEB, [31148] = 0xFAEC, [31149] = 0xFAED, [31150] = 0xFAEE,
  [31151] = 0xFAEF, [31152] = 0xFAF0, [31153] = 0xFAF1, [31154] = 0xFAF2,
  [31155] = 0xFAF3, [31156] = 0xFAF4, [31157] = 0xFAF5, [31158] = 0xFAF6,
  [31159] = 0xFAF7, [31160] = 0xFAF8, [31161] = 0xFAF9, [31162] = 0xFAFA,
  [31163] = 0xFAFB, [31164] = 0xFAFC, [31165] = 0xFAFD, [31166] = 0xFAFE,
  [31232] = 0xFB40, [31233] = 0xFB41, [31234] = 0xFB42, [31235] = 0xFB43,
  [31236] = 0xFB44, [31237] = 0xFB45, [31238] = 0xFB46, [31239] = 0xFB47,
  [31240] = 0xFB48, [31241] = 0xFB49, [31242] = 0xFB4A, [31243] = 0xFB4B,
  [31244] = 0xFB4C, [31245] = 0xFB4D, [31246] = 0xFB4E, [31247] = 0xFB4F,
  [31248] = 0xFB50, [31249] = 0xFB51, [31250] = 0xFB52, [31251] = 0xFB53,
  [31252] = 0xFB54, [31253] = 0xFB55, [31254] = 0xFB56, [31255] = 0xFB57,
  [31256] = 0xFB58, [31257] = 0xFB59, [31258] = 0xFB5A, [31259] = 0xFB5B,
  [31260] = 0xFB5C, [31261] = 0xFB5D, [31262] = 0xFB5E, [31263] = 0xFB5F,
  [31264] = 0xFB60, [31265] = 0xFB61, [31266] = 0xFB62, [31267] = 0xFB63,
  [31268] = 0xFB64, [31269] = 0xFB65, [31270] = 0xFB66, [31271] = 0xFB67,
  [31272] = 0xFB68, [31273] = 0xFB69, [31274] = 0xFB6A, [31275] = 0xFB6B,
  [31276] = 0xFB6C, [31277] = 0xFB6D, [31278] = 0xFB6E, [31279] = 0xFB6F,
  [31280] = 0xFB70, [31281] = 0xFB71, [31282] = 0xFB72, [31283] = 0xFB73,
  [31284] = 0xFB74, [31285] = 0xFB75, [31286] = 0xFB76, [31287] = 0xFB77,
  [31288] = 0xFB78, [31289] = 0xFB79, [31290] = 0xFB7A, [31291] = 0xFB7B,
  [31292] = 0xFB7C, [31293] = 0xFB7D, [31294] = 0xFB7E, [31296] = 0xFB80,
  [31297] = 0xFB81, [31298] = 0xFB82, [31299] = 0xFB83, [31300] = 0xFB84,
  [31301] = 0xFB85, [31302] = 0xFB86, [31303] = 0xFB87, [31304] = 0xFB88,
  [31305] = 0xFB89, [31306] = 0xFB8A, [31307] = 0xFB8B, [31308] = 0xFB8C,
  [31309] = 0xFB8D, [31310] = 0xFB8E, [31311] = 0xFB8F, [31312] = 0xFB90,
  [31313] = 0xFB91, [31314] = 0xFB92, [31315] = 0xFB93, [31316] = 0xFB94,
  [31317] = 0xFB95, [31318] = 0xFB96, [31319] = 0xFB97, [31320] = 0xFB98,
  [31321] = 0xFB99, [31322] = 0xFB9A, [31323] = 0xFB9B, [31324] = 0xFB9C,
  [31325] = 0xFB9D, [31326] = 0xFB9E, [31327] = 0xFB9F, [31328] = 0xFBA0,
  [31329] = 0xFBA1, [31330] = 0xFBA2, [31331] = 0xFBA3, [31332] = 0xFBA4,
  [31333] = 0xFBA5, [31334] = 0xFBA6, [31335] = 0xFBA7, [31336] = 0xFBA8,
  [31337] = 0xFBA9, [31338] = 0xFBAA, [31339] = 0xFBAB, [31340] = 0xFBAC,
  [31341] = 0xFBAD, [31342] = 0xFBAE, [31343] = 0xFBAF, [31344] = 0xFBB0,
  [31345] = 0xFBB1, [31346] = 0xFBB2, [31347] = 0xFBB3, [31348] = 0xFBB4,
  [31349] = 0xFBB5, [31350] = 0xFBB6, [31351] = 0xFBB7, [31352] = 0xFBB8,
  [31353] = 0xFBB9, [31354] = 0xFBBA, [31355] = 0xFBBB, [31356] = 0xFBBC,
  [31357] = 0xFBBD, [31358] = 0xFBBE, [31359] = 0xFBBF, [31360] = 0xFBC0,
  [31361] = 0xFBC1, [31362] = 0xFBC2, [31363] = 0xFBC3, [31364] = 0xFBC4,
  [31365] = 0xFBC5, [31366] = 0xFBC6, [31367] = 0xFBC7, [31368] = 0xFBC8,
  [31369] = 0xFBC9, [31370] = 0xFBCA, [31371] = 0xFBCB, [31372] = 0xFBCC,
  [31373] = 0xFBCD, [31374] = 0xFBCE, [31375] = 0xFBCF, [31376] = 0xFBD0,
  [31377] = 0xFBD1, [31378] = 0xFBD2, [31379] = 0xFBD3, [31380] = 0xFBD4,
  [31381] = 0xFBD5, [31382] = 0xFBD6, [31383] = 0xFBD7, [31384] = 0xFBD8,
  [31385] = 0xFBD9, [31386] = 0xFBDA, [31387] = 0xFBDB, [31388] = 0xFBDC,
  [31389] = 0xFBDD, [31390] = 0xFBDE, [31391] = 0xFBDF, [31392] = 0xFBE0,
  [31393] = 0xFBE1, [31394] = 0xFBE2, [31395] = 0xFBE3, [31396] = 0xFBE4,
  [31397] = 0xFBE5, [31398] = 0xFBE6, [31399] = 0xFBE7, [31400] = 0xFBE8,
  [31401] = 0xFBE9, [31402] = 0xFBEA, [31403] = 0xFBEB, [31404] = 0xFBEC,
  [31405] = 0xFBED, [31406] = 0xFBEE, [31407] = 0xFBEF, [31408] = 0xFBF0,
  [31409] = 0xFBF1, [31410] = 0xFBF2, [31411] = 0xFBF3, [31412] = 0xFBF4,
  [31413] = 0xFBF5, [31414] = 0xFBF6, [31415] = 0xFBF7, [31416] = 0xFBF8,
  [31417] = 0xFBF9, [31418] = 0xFBFA, [31419] = 0xFBFB, [31420] = 0xFBFC,
  [31421] = 0xFBFD, [31422] = 0xFBFE, [31488] = 0xFC40, [31489] = 0xFC41,
  [31490] = 0xFC42, [31491] = 0xFC43, [31492] = 0xFC44, [31493] = 0xFC45,
  [31494] = 0xFC46, [31495] = 0xFC47, [31496] = 0xFC48, [31497] = 0xFC49,
  [31498] = 0xFC4A, [31499] = 0xFC4B, [31500] = 0xFC4C, [31501] = 0xFC4D,
  [31502] = 0xFC4E, [31503] = 0xFC4F, [31504] = 0xFC50, [31505] = 0xFC51,
  [31506] = 0xFC52, [31507] = 0xFC53, [31508] = 0xFC54, [31509] = 0xFC55,
  [31510] = 0xFC56, [31511] = 0xFC57, [31512] = 0xFC58, [31513] = 0xFC59,
  [31514] = 0xFC5A, [31515] = 0xFC5B, [31516] = 0xFC5C, [31517] = 0xFC5D,
  [31518] = 0xFC5E, [31519] = 0xFC5F, [31520] = 0xFC60, [31521] = 0xFC61,
  [31522] = 0xFC62, [31523] = 0xFC63, [31524] = 0xFC64, [31525] = 0xFC65,
  [31526] = 0xFC66, [31527] = 0xFC67, [31528] = 0xFC68, [31529] = 0xFC69,
  [31530] = 0xFC6A, [31531] = 0xFC6B, [31532] = 0xFC6C, [31533] = 0xFC6D,
  [31534] = 0xFC6E, [31535] = 0xFC6F, [31536] = 0xFC70, [31537] = 0xFC71,
  [31538] = 0xFC72, [31539] = 0xFC73, [31540] = 0xFC74, [31541] = 0xFC75,
  [31542] = 0xFC76, [31543] = 0xFC77, [31544] = 0xFC78, [31545] = 0xFC79,
  [31546] = 0xFC7A, [31547] = 0xFC7B, [31548] = 0xFC7C, [31549] = 0xFC7D,
  [31550] = 0xFC7E, [31552] = 0xFC80, [31553] = 0xFC81, [31554] = 0xFC82,
  [31555] = 0xFC83, [31556] = 0xFC84, [31557] = 0xFC85, [31558] = 0xFC86,
  [31559] = 0xFC87, [31560] = 0xFC88, [31561] = 0xFC89, [31562] = 0xFC8A,
  [31563] = 0xFC8B, [31564] = 0xFC8C, [31565] = 0xFC8D, [31566] = 0xFC8E,
  [31567] = 0xFC8F, [31568] = 0xFC90, [31569] = 0xFC91, [31570] = 0xFC92,
  [31571] = 0xFC93, [31572] = 0xFC94, [31573] = 0xFC95, [31574] = 0xFC96,
  [31575] = 0xFC97, [31576] = 0xFC98, [31577] = 0xFC99, [31578] = 0xFC9A,
  [31579] = 0xFC9B, [31580] = 0xFC9C, [31581] = 0xFC9D, [31582] = 0xFC9E,
  [31583] = 0xFC9F, [31584] = 0xFCA0, [31585] = 0xFCA1, [31586] = 0xFCA2,
  [31587] = 0xFCA3, [31588] = 0xFCA4, [31589] = 0xFCA5, [31590] = 0xFCA6,
  [31591] = 0xFCA7, [31592] = 0xFCA8, [31593] = 0xFCA9, [31594] = 0xFCAA,
  [31595] = 0xFCAB, [31596] = 0xFCAC, [31597] = 0xFCAD, [31598] = 0xFCAE,
  [31599] = 0xFCAF, [31600] = 0xFCB0, [31601] = 0xFCB1, [31602] = 0xFCB2,
  [31603] = 0xFCB3, [31604] = 0xFCB4, [31605] = 0xFCB5, [31606] = 0xFCB6,
  [31607] = 0xFCB7, [31608] = 0xFCB8, [31609] = 0xFCB9, [31610] = 0xFCBA,
  [31611] = 0xFCBB, [31612] = 0xFCBC, [31613] = 0xFCBD, [31614] = 0xFCBE,
  [31615] = 0xFCBF, [31616] = 0xFCC0, [31617] = 0xFCC1, [31618] = 0xFCC2,
  [31619] = 0xFCC3, [31620] = 0xFCC4, [31621] = 0xFCC5, [31622] = 0xFCC6,
  [31623] = 0xFCC7, [31624] = 0xFCC8, [31625] = 0xFCC9, [31626] = 0xFCCA,
  [31627] = 0xFCCB, [31628] = 0xFCCC, [31629] = 0xFCCD, [31630] = 0xFCCE,
  [31631] = 0xFCCF, [31632] = 0xFCD0, [31633] = 0xFCD1, [31634] = 0xFCD2,
  [31635] = 0xFCD3, [31636] = 0xFCD4, [31637] = 0xFCD5, [31638] = 0xFCD6,
  [31639] = 0xFCD7, [31640] = 0xFCD8, [31641] = 0xFCD9, [31642] = 0xFCDA,
  [31643] = 0xFCDB, [31644] = 0xFCDC, [31645] = 0xFCDD, [31646] = 0xFCDE,
  [31647] = 0xFCDF, [31648] = 0xFCE0, [31649] = 0xFCE1, [31650] = 0xFCE2,
  [31651] = 0xFCE3, [31652] = 0xFCE4, [31653] = 0xFCE5, [31654] = 0xFCE6,
  [31655] = 0xFCE7, [31656] = 0xFCE8, [31657] = 0xFCE9, [31658] = 0xFCEA,
  [31659] = 0xFCEB, [31660] = 0xFCEC, [31661] = 0xFCED, [31662] = 0xFCEE,
  [31663] = 0xFCEF, [31664] = 0xFCF0, [31665] = 0xFCF1, [31666] = 0xFCF2,
  [31667] = 0xFCF3, [31668] = 0xFCF4, [31669] = 0xFCF5, [31670] = 0xFCF6,
  [31671] = 0xFCF7, [31672] = 0xFCF8, [31673] = 0xFCF9, [31674] = 0xFCFA,
  [31675] = 0xFCFB, [31676] = 0xFCFC, [31677] = 0xFCFD, [31678] = 0xFCFE,
  [31744] = 0xFD40, [31745] = 0xFD41, [31746] = 0xFD42, [31747] = 0xFD43,
  [31748] = 0xFD44, [31749] = 0xFD45, [31750] = 0xFD46, [31751] = 0xFD47,
  [31752] = 0xFD48, [31753] = 0xFD49, [31754] = 0xFD4A, [31755] = 0xFD4B,
  [31756] = 0xFD4C, [31757] = 0xFD4D, [31758] = 0xFD4E, [31759] = 0xFD4F,
  [31760] = 0xFD50, [31761] = 0xFD51, [31762] = 0xFD52, [31763] = 0xFD53,
  [31764] = 0xFD54, [31765] = 0xFD55, [31766] = 0xFD56, [31767] = 0xFD57,
  [31768] = 0xFD58, [31769] = 0xFD59, [31770] = 0xFD5A, [31771] = 0xFD5B,
  [31772] = 0xFD5C, [31773] = 0xFD5D, [31774] = 0xFD5E, [31775] = 0xFD5F,
  [31776] = 0xFD60, [31777] = 0xFD61, [31778] = 0xFD62, [31779] = 0xFD63,
  [31780] = 0xFD64, [31781] = 0xFD65, [31782] = 0xFD66, [31783] = 0xFD67,
  [31784] = 0xFD68, [31785] = 0xFD69, [31786] = 0xFD6A, [31787] = 0xFD6B,
  [31788] = 0xFD6C, [31789] = 0xFD6D, [31790] = 0xFD6E, [31791] = 0xFD6F,
  [31792] = 0xFD70, [31793] = 0xFD71, [31794] = 0xFD72, [31795] = 0xFD73,
  [31796] = 0xFD74, [31797] = 0xFD75, [31798] = 0xFD76, [31799] = 0xFD77,
  [31800] = 0xFD78, [31801] = 0xFD79, [31802] = 0xFD7A, [31803] = 0xFD7B,
  [31804] = 0xFD7C, [31805] = 0xFD7D, [31806] = 0xFD7E, [31808] = 0xFD80,
  [31809] = 0xFD81, [31810] = 0xFD82, [31811] = 0xFD83, [31812] = 0xFD84,
  [31813] = 0xFD85, [31814] = 0xFD86, [31815] = 0xFD87, [31816] = 0xFD88,
  [31817] = 0xFD89, [31818] = 0xFD8A, [31819] = 0xFD8B, [31820] = 0xFD8C,
  [31821] = 0xFD8D, [31822] = 0xFD8E, [31823] = 0xFD8F, [31824] = 0xFD90,
  [31825] = 0xFD91, [31826] = 0xFD92, [31827] = 0xFD93, [31828] = 0xFD94,
  [31829] = 0xFD95, [31830] = 0xFD96, [31831] = 0xFD97, [31832] = 0xFD98,
  [31833] = 0xFD99, [31834] = 0xFD9A, [31835] = 0xFD9B, [31836] = 0xFD9C,
  [31837] = 0xFD9D, [31838] = 0xFD9E, [31839] = 0xFD9F, [31840] = 0xFDA0,
  [31841] = 0xFDA1, [31842] = 0xFDA2, [31843] = 0xFDA3, [31844] = 0xFDA4,
  [31845] = 0xFDA5, [31846] = 0xFDA6, [31847] = 0xFDA7, [31848] = 0xFDA8,
  [31849] = 0xFDA9, [31850] = 0xFDAA, [31851] = 0xFDAB, [31852] = 0xFDAC,
  [31853] = 0xFDAD, [31854] = 0xFDAE, [31855] = 0xFDAF, [31856] = 0xFDB0,
  [31857] = 0xFDB1, [31858] = 0xFDB2, [31859] = 0xFDB3, [31860] = 0xFDB4,
  [31861] = 0xFDB5, [31862] = 0xFDB6, [31863] = 0xFDB7, [31864] = 0xFDB8,
  [31865] = 0xFDB9, [31866] = 0xFDBA, [31867] = 0xFDBB, [31868] = 0xFDBC,
  [31869] = 0xFDBD, [31870] = 0xFDBE, [31871] = 0xFDBF, [31872] = 0xFDC0,
  [31873] = 0xFDC1, [31874] = 0xFDC2, [31875] = 0xFDC3, [31876] = 0xFDC4,
  [31877] = 0xFDC5, [31878] = 0xFDC6, [31879] = 0xFDC7, [31880] = 0xFDC8,
  [31881] = 0xFDC9, [31882] = 0xFDCA, [31883] = 0xFDCB, [31884] = 0xFDCC,
  [31885] = 0xFDCD, [31886] = 0xFDCE, [31887] = 0xFDCF, [31888] = 0xFDD0,
  [31889] = 0xFDD1, [31890] = 0xFDD2, [31891] = 0xFDD3, [31892] = 0xFDD4,
  [31893] = 0xFDD5, [31894] = 0xFDD6, [31895] = 0xFDD7, [31896] = 0xFDD8,
  [31897] = 0xFDD9, [31898] = 0xFDDA, [31899] = 0xFDDB, [31900] = 0xFDDC,
  [31901] = 0xFDDD, [31902] = 0xFDDE, [31903] = 0xFDDF, [31904] = 0xFDE0,
  [31905] = 0xFDE1, [31906] = 0xFDE2, [31907] = 0xFDE3, [31908] = 0xFDE4,
  [31909] = 0xFDE5, [31910] = 0xFDE6, [31911] = 0xFDE7, [31912] = 0xFDE8,
  [31913] = 0xFDE9, [31914] = 0xFDEA, [31915] = 0xFDEB, [31916] = 0xFDEC,
  [31917] = 0xFDED, [31918] = 0xFDEE, [31919] = 0xFDEF, [31920] = 0xFDF0,
  [31921] = 0xFDF1, [31922] = 0xFDF2, [31923] = 0xFDF3, [31924] = 0xFDF4,
  [31925] = 0xFDF5, [31926] = 0xFDF6, [31927] = 0xFDF7, [31928] = 0xFDF8,
  [31929] = 0xFDF9, [31930] = 0xFDFA, [31931] = 0xFDFB, [31932] = 0xFDFC,
  [31933] = 0xFDFD, [31934] = 0xFDFE, [32000] = 0xFE40, [32001] = 0xFE41,
  [32002] = 0xFE42, [32003] = 0xFE43, [32004] = 0xFE44, [32005] = 0xFE45,
  [32006] = 0xFE46, [32007] = 0xFE47, [32008] = 0xFE48, [32009] = 0xFE49,
  [32010] = 0xFE4A, [32011] = 0xFE4B, [32012] = 0xFE4C, [32013] = 0xFE4D,
  [32014] = 0xFE4E, [32015] = 0xFE4F, [32016] = 0xFE50, [32017] = 0xFE51,
  [32018] = 0xFE52, [32019] = 0xFE53, [32020] = 0xFE54, [32021] = 0xFE55,
  [32022] = 0xFE56, [32023] = 0xFE57, [32024] = 0xFE58, [32025] = 0xFE59,
  [32026] = 0xFE5A, [32027] = 0xFE5B, [32028] = 0xFE5C, [32029] = 0xFE5D,
  [32030] = 0xFE5E, [32031] = 0xFE5F, [32032] = 0xFE60, [32033] = 0xFE61,
  [32034] = 0xFE62, [32035] = 0xFE63, [32036] = 0xFE64, [32037] = 0xFE65,
  [32038] = 0xFE66, [32039] = 0xFE67, [32040] = 0xFE68, [32041] = 0xFE69,
  [32042] = 0xFE6A, [32043] = 0xFE6B, [32044] = 0xFE6C, [32045] = 0xFE6D,
  [32046] = 0xFE6E, [32047] = 0xFE6F, [32048] = 0xFE70, [32049] = 0xFE71,
  [32050] = 0xFE72, [32051] = 0xFE73, [32052] = 0xFE74, [32053] = 0xFE75,
  [32054] = 0xFE76, [32055] = 0xFE77, [32056] = 0xFE78, [32057] = 0xFE79,
  [32058] = 0xFE7A, [32059] = 0xFE7B, [32060] = 0xFE7C, [32061] = 0xFE7D,
  [32062] = 0xFE7E, [32064] = 0xFE80, [32065] = 0xFE81, [32066] = 0xFE82,
  [32067] = 0xFE83, [32068] = 0xFE84, [32069] = 0xFE85, [32070] = 0xFE86,
  [32071] = 0xFE87, [32072] = 0xFE88, [32073] = 0xFE89, [32074] = 0xFE8A,
  [32075] = 0xFE8B, [32076] = 0xFE8C, [32077] = 0xFE8D, [32078] = 0xFE8E,
  [32079] = 0xFE8F, [32080] = 0xFE90, [32081] = 0xFE91, [32082] = 0xFE92,
  [32083] = 0xFE93, [32084] = 0xFE94, [32085] = 0xFE95, [32086] = 0xFE96,
  [32087] = 0xFE97, [32088] = 0xFE98, [32089] = 0xFE99, [32090] = 0xFE9A,
  [32091] = 0xFE9B, [32092] = 0xFE9C, [32093] = 0xFE9D, [32094] = 0xFE9E,
  [32095] = 0xFE9F, [32096] = 0xFEA0, [32097] = 0xFEA1, [32098] = 0xFEA2,
  [32099] = 0xFEA3, [32100] = 0xFEA4, [32101] = 0xFEA5, [32102] = 0xFEA6,
  [32103] = 0xFEA7, [32104] = 0xFEA8, [32105] = 0xFEA9, [32106] = 0xFEAA,
  [32107] = 0xFEAB, [32108] = 0xFEAC, [32109] = 0xFEAD, [32110] = 0xFEAE,
  [32111] = 0xFEAF, [32112] = 0xFEB0, [32113] = 0xFEB1, [32114] = 0xFEB2,
  [32115] = 0xFEB3, [32116] = 0xFEB4, [32117] = 0xFEB5, [32118] = 0xFEB6,
  [32119] = 0xFEB7, [32120] = 0xFEB8, [32121] = 0xFEB9, [32122] = 0xFEBA,
  [32123] = 0xFEBB, [32124] = 0xFEBC, [32125] = 0xFEBD, [32126] = 0xFEBE,
  [32127] = 0xFEBF, [32128] = 0xFEC0, [32129] = 0xFEC1, [32130] = 0xFEC2,
  [32131] = 0xFEC3, [32132] = 0xFEC4, [32133] = 0xFEC5, [32134] = 0xFEC6,
  [32135] = 0xFEC7, [32136] = 0xFEC8, [32137] = 0xFEC9, [32138] = 0xFECA,
  [32139] = 0xFECB, [32140] = 0xFECC, [32141] = 0xFECD, [32142] = 0xFECE,
  [32143] = 0xFECF, [32144] = 0xFED0, [32145] = 0xFED1, [32146] = 0xFED2,
  [32147] = 0xFED3, [32148] = 0xFED4, [32149] = 0xFED5, [32150] = 0xFED6,
  [32151] = 0xFED7, [32152] = 0xFED8, [32153] = 0xFED9, [32154] = 0xFEDA,
  [32155] = 0xFEDB, [32156] = 0xFEDC, [32157] = 0xFEDD, [32158] = 0xFEDE,
  [32159] = 0xFEDF, [32160] = 0xFEE0, [32161] = 0xFEE1, [32162] = 0xFEE2,
  [32163] = 0xFEE3, [32164] = 0xFEE4, [32165] = 0xFEE5, [32166] = 0xFEE6,
  [32167] = 0xFEE7, [32168] = 0xFEE8, [32169] = 0xFEE9, [32170] = 0xFEEA,
  [32171] = 0xFEEB, [32172] = 0xFEEC, [32173] = 0xFEED, [32174] = 0xFEEE,
  [32175] = 0xFEEF, [32176] = 0xFEF0, [32177] = 0xFEF1, [32178] = 0xFEF2,
  [32179] = 0xFEF3, [32180] = 0xFEF4, [32181] = 0xFEF5, [32182] = 0xFEF6,
  [32183] = 0xFEF7, [32184] = 0xFEF8, [32185] = 0xFEF9, [32186] = 0xFEFA,
  [32187] = 0xFEFB, [32188] = 0xFEFC, [32189] = 0xFEFD, [32190] = 0xFEFE
};


static const char from_ucs4_lat1[128][2] =
{
  [0x0000] = "\x00\x00", [0x0001] = "\x01\x00", [0x0002] = "\x02\x00",
  [0x0003] = "\x03\x00", [0x0004] = "\x04\x00", [0x0005] = "\x05\x00",
  [0x0006] = "\x06\x00", [0x0007] = "\x07\x00", [0x0008] = "\x08\x00",
  [0x0009] = "\x09\x00", [0x000a] = "\x0a\x00", [0x000b] = "\x0b\x00",
  [0x000c] = "\x0c\x00", [0x000d] = "\x0d\x00", [0x000e] = "\x0e\x00",
  [0x000f] = "\x0f\x00", [0x0010] = "\x10\x00", [0x0011] = "\x11\x00",
  [0x0012] = "\x12\x00", [0x0013] = "\x13\x00", [0x0014] = "\x14\x00",
  [0x0015] = "\x15\x00", [0x0016] = "\x16\x00", [0x0017] = "\x17\x00",
  [0x0018] = "\x18\x00", [0x0019] = "\x19\x00", [0x001a] = "\x1a\x00",
  [0x001b] = "\x1b\x00", [0x001c] = "\x1c\x00", [0x001d] = "\x1d\x00",
  [0x001e] = "\x1e\x00", [0x001f] = "\x1f\x00", [0x0020] = "\x20\x00",
  [0x0021] = "\x21\x00", [0x0022] = "\x22\x00", [0x0023] = "\x23\x00",
  [0x0024] = "\x24\x00", [0x0025] = "\x25\x00", [0x0026] = "\x26\x00",
  [0x0027] = "\x27\x00", [0x0028] = "\x28\x00", [0x0029] = "\x29\x00",
  [0x002a] = "\x2a\x00", [0x002b] = "\x2b\x00", [0x002c] = "\x2c\x00",
  [0x002d] = "\x2d\x00", [0x002e] = "\x2e\x00", [0x002f] = "\x2f\x00",
  [0x0030] = "\x30\x00", [0x0031] = "\x31\x00", [0x0032] = "\x32\x00",
  [0x0033] = "\x33\x00", [0x0034] = "\x34\x00", [0x0035] = "\x35\x00",
  [0x0036] = "\x36\x00", [0x0037] = "\x37\x00", [0x0038] = "\x38\x00",
  [0x0039] = "\x39\x00", [0x003a] = "\x3a\x00", [0x003b] = "\x3b\x00",
  [0x003c] = "\x3c\x00", [0x003d] = "\x3d\x00", [0x003e] = "\x3e\x00",
  [0x003f] = "\x3f\x00", [0x0040] = "\x40\x00", [0x0041] = "\x41\x00",
  [0x0042] = "\x42\x00", [0x0043] = "\x43\x00", [0x0044] = "\x44\x00",
  [0x0045] = "\x45\x00", [0x0046] = "\x46\x00", [0x0047] = "\x47\x00",
  [0x0048] = "\x48\x00", [0x0049] = "\x49\x00", [0x004a] = "\x4a\x00",
  [0x004b] = "\x4b\x00", [0x004c] = "\x4c\x00", [0x004d] = "\x4d\x00",
  [0x004e] = "\x4e\x00", [0x004f] = "\x4f\x00", [0x0050] = "\x50\x00",
  [0x0051] = "\x51\x00", [0x0052] = "\x52\x00", [0x0053] = "\x53\x00",
  [0x0054] = "\x54\x00", [0x0055] = "\x55\x00", [0x0056] = "\x56\x00",
  [0x0057] = "\x57\x00", [0x0058] = "\x58\x00", [0x0059] = "\x59\x00",
  [0x005a] = "\x5a\x00", [0x005b] = "\x5b\x00", [0x005c] = "\x5c\x00",
  [0x005d] = "\x5d\x00", [0x005e] = "\x5e\x00", [0x005f] = "\x5f\x00",
  [0x0060] = "\x60\x00", [0x0061] = "\x61\x00", [0x0062] = "\x62\x00",
  [0x0063] = "\x63\x00", [0x0064] = "\x64\x00", [0x0065] = "\x65\x00",
  [0x0066] = "\x66\x00", [0x0067] = "\x67\x00", [0x0068] = "\x68\x00",
  [0x0069] = "\x69\x00", [0x006a] = "\x6a\x00", [0x006b] = "\x6b\x00",
  [0x006c] = "\x6c\x00", [0x006d] = "\x6d\x00", [0x006e] = "\x6e\x00",
  [0x006f] = "\x6f\x00", [0x0070] = "\x70\x00", [0x0071] = "\x71\x00",
  [0x0072] = "\x72\x00", [0x0073] = "\x73\x00", [0x0074] = "\x74\x00",
  [0x0075] = "\x75\x00", [0x0076] = "\x76\x00", [0x0077] = "\x77\x00",
  [0x0078] = "\x78\x00", [0x0079] = "\x79\x00", [0x007a] = "\x7a\x00",
  [0x007b] = "\x7b\x00", [0x007c] = "\x7c\x00", [0x007d] = "\x7d\x00",
  [0x007e] = "\x7e\x00", [0x007f] = "\x7f\x00"
};

static const char from_ucs4_asianuni[0x7dbf][2] =
{
  [0x0000] = "\x81\x40", [0x0001] = "\x81\x41", [0x0002] = "\x81\x42",
  [0x0003] = "\x81\x43", [0x0004] = "\x81\x44", [0x0005] = "\x81\x45",
  [0x0006] = "\x81\x46", [0x0007] = "\x81\x47", [0x0008] = "\x81\x48",
  [0x0009] = "\x81\x49", [0x000a] = "\x81\x4a", [0x000b] = "\x81\x4b",
  [0x000c] = "\x81\x4c", [0x000d] = "\x81\x4d", [0x000e] = "\x81\x4e",
  [0x000f] = "\x81\x4f", [0x0010] = "\x81\x50", [0x0011] = "\x81\x51",
  [0x0012] = "\x81\x52", [0x0013] = "\x81\x53", [0x0014] = "\x81\x54",
  [0x0015] = "\x81\x55", [0x0016] = "\x81\x56", [0x0017] = "\x81\x57",
  [0x0018] = "\x81\x58", [0x0019] = "\x81\x59", [0x001a] = "\x81\x5a",
  [0x001b] = "\x81\x5b", [0x001c] = "\x81\x5c", [0x001d] = "\x81\x5d",
  [0x001e] = "\x81\x5e", [0x001f] = "\x81\x5f", [0x0020] = "\x81\x60",
  [0x0021] = "\x81\x61", [0x0022] = "\x81\x62", [0x0023] = "\x81\x63",
  [0x0024] = "\x81\x64", [0x0025] = "\x81\x65", [0x0026] = "\x81\x66",
  [0x0027] = "\x81\x67", [0x0028] = "\x81\x68", [0x0029] = "\x81\x69",
  [0x002a] = "\x81\x6a", [0x002b] = "\x81\x6b", [0x002c] = "\x81\x6c",
  [0x002d] = "\x81\x6d", [0x002e] = "\x81\x6e", [0x002f] = "\x81\x6f",
  [0x0030] = "\x81\x70", [0x0031] = "\x81\x71", [0x0032] = "\x81\x72",
  [0x0033] = "\x81\x73", [0x0034] = "\x81\x74", [0x0035] = "\x81\x75",
  [0x0036] = "\x81\x76", [0x0037] = "\x81\x77", [0x0038] = "\x81\x78",
  [0x0039] = "\x81\x79", [0x003a] = "\x81\x7a", [0x003b] = "\x81\x7b",
  [0x003c] = "\x81\x7c", [0x003d] = "\x81\x7d", [0x003e] = "\x81\x7e",
  [0x0040] = "\x81\x80", [0x0041] = "\x81\x81", [0x0042] = "\x81\x82",
  [0x0043] = "\x81\x83", [0x0044] = "\x81\x84", [0x0045] = "\x81\x85",
  [0x0046] = "\x81\x86", [0x0047] = "\x81\x87", [0x0048] = "\x81\x88",
  [0x0049] = "\x81\x89", [0x004a] = "\x81\x8a", [0x004b] = "\x81\x8b",
  [0x004c] = "\x81\x8c", [0x004d] = "\x81\x8d", [0x004e] = "\x81\x8e",
  [0x004f] = "\x81\x8f", [0x0050] = "\x81\x90", [0x0051] = "\x81\x91",
  [0x0052] = "\x81\x92", [0x0053] = "\x81\x93", [0x0054] = "\x81\x94",
  [0x0055] = "\x81\x95", [0x0056] = "\x81\x96", [0x0057] = "\x81\x97",
  [0x0058] = "\x81\x98", [0x0059] = "\x81\x99", [0x005a] = "\x81\x9a",
  [0x005b] = "\x81\x9b", [0x005c] = "\x81\x9c", [0x005d] = "\x81\x9d",
  [0x005e] = "\x81\x9e", [0x005f] = "\x81\x9f", [0x0060] = "\x81\xa0",
  [0x0061] = "\x81\xa1", [0x0062] = "\x81\xa2", [0x0063] = "\x81\xa3",
  [0x0064] = "\x81\xa4", [0x0065] = "\x81\xa5", [0x0066] = "\x81\xa6",
  [0x0067] = "\x81\xa7", [0x0068] = "\x81\xa8", [0x0069] = "\x81\xa9",
  [0x006a] = "\x81\xaa", [0x006b] = "\x81\xab", [0x006c] = "\x81\xac",
  [0x006d] = "\x81\xad", [0x006e] = "\x81\xae", [0x006f] = "\x81\xaf",
  [0x0070] = "\x81\xb0", [0x0071] = "\x81\xb1", [0x0072] = "\x81\xb2",
  [0x0073] = "\x81\xb3", [0x0074] = "\x81\xb4", [0x0075] = "\x81\xb5",
  [0x0076] = "\x81\xb6", [0x0077] = "\x81\xb7", [0x0078] = "\x81\xb8",
  [0x0079] = "\x81\xb9", [0x007a] = "\x81\xba", [0x007b] = "\x81\xbb",
  [0x007c] = "\x81\xbc", [0x007d] = "\x81\xbd", [0x007e] = "\x81\xbe",
  [0x007f] = "\x81\xbf", [0x0080] = "\x81\xc0", [0x0081] = "\x81\xc1",
  [0x0082] = "\x81\xc2", [0x0083] = "\x81\xc3", [0x0084] = "\x81\xc4",
  [0x0085] = "\x81\xc5", [0x0086] = "\x81\xc6", [0x0087] = "\x81\xc7",
  [0x0088] = "\x81\xc8", [0x0089] = "\x81\xc9", [0x008a] = "\x81\xca",
  [0x008b] = "\x81\xcb", [0x008c] = "\x81\xcc", [0x008d] = "\x81\xcd",
  [0x008e] = "\x81\xce", [0x008f] = "\x81\xcf", [0x0090] = "\x81\xd0",
  [0x0091] = "\x81\xd1", [0x0092] = "\x81\xd2", [0x0093] = "\x81\xd3",
  [0x0094] = "\x81\xd4", [0x0095] = "\x81\xd5", [0x0096] = "\x81\xd6",
  [0x0097] = "\x81\xd7", [0x0098] = "\x81\xd8", [0x0099] = "\x81\xd9",
  [0x009a] = "\x81\xda", [0x009b] = "\x81\xdb", [0x009c] = "\x81\xdc",
  [0x009d] = "\x81\xdd", [0x009e] = "\x81\xde", [0x009f] = "\x81\xdf",
  [0x00a0] = "\x81\xe0", [0x00a1] = "\x81\xe1", [0x00a2] = "\x81\xe2",
  [0x00a3] = "\x81\xe3", [0x00a4] = "\x81\xe4", [0x00a5] = "\x81\xe5",
  [0x00a6] = "\x81\xe6", [0x00a7] = "\x81\xe7", [0x00a8] = "\x81\xe8",
  [0x00a9] = "\x81\xe9", [0x00aa] = "\x81\xea", [0x00ab] = "\x81\xeb",
  [0x00ac] = "\x81\xec", [0x00ad] = "\x81\xed", [0x00ae] = "\x81\xee",
  [0x00af] = "\x81\xef", [0x00b0] = "\x81\xf0", [0x00b1] = "\x81\xf1",
  [0x00b2] = "\x81\xf2", [0x00b3] = "\x81\xf3", [0x00b4] = "\x81\xf4",
  [0x00b5] = "\x81\xf5", [0x00b6] = "\x81\xf6", [0x00b7] = "\x81\xf7",
  [0x00b8] = "\x81\xf8", [0x00b9] = "\x81\xf9", [0x00ba] = "\x81\xfa",
  [0x00bb] = "\x81\xfb", [0x00bc] = "\x81\xfc", [0x00bd] = "\x81\xfd",
  [0x00be] = "\x81\xfe", [0x0100] = "\x82\x40", [0x0101] = "\x82\x41",
  [0x0102] = "\x82\x42", [0x0103] = "\x82\x43", [0x0104] = "\x82\x44",
  [0x0105] = "\x82\x45", [0x0106] = "\x82\x46", [0x0107] = "\x82\x47",
  [0x0108] = "\x82\x48", [0x0109] = "\x82\x49", [0x010a] = "\x82\x4a",
  [0x010b] = "\x82\x4b", [0x010c] = "\x82\x4c", [0x010d] = "\x82\x4d",
  [0x010e] = "\x82\x4e", [0x010f] = "\x82\x4f", [0x0110] = "\x82\x50",
  [0x0111] = "\x82\x51", [0x0112] = "\x82\x52", [0x0113] = "\x82\x53",
  [0x0114] = "\x82\x54", [0x0115] = "\x82\x55", [0x0116] = "\x82\x56",
  [0x0117] = "\x82\x57", [0x0118] = "\x82\x58", [0x0119] = "\x82\x59",
  [0x011a] = "\x82\x5a", [0x011b] = "\x82\x5b", [0x011c] = "\x82\x5c",
  [0x011d] = "\x82\x5d", [0x011e] = "\x82\x5e", [0x011f] = "\x82\x5f",
  [0x0120] = "\x82\x60", [0x0121] = "\x82\x61", [0x0122] = "\x82\x62",
  [0x0123] = "\x82\x63", [0x0124] = "\x82\x64", [0x0125] = "\x82\x65",
  [0x0126] = "\x82\x66", [0x0127] = "\x82\x67", [0x0128] = "\x82\x68",
  [0x0129] = "\x82\x69", [0x012a] = "\x82\x6a", [0x012b] = "\x82\x6b",
  [0x012c] = "\x82\x6c", [0x012d] = "\x82\x6d", [0x012e] = "\x82\x6e",
  [0x012f] = "\x82\x6f", [0x0130] = "\x82\x70", [0x0131] = "\x82\x71",
  [0x0132] = "\x82\x72", [0x0133] = "\x82\x73", [0x0134] = "\x82\x74",
  [0x0135] = "\x82\x75", [0x0136] = "\x82\x76", [0x0137] = "\x82\x77",
  [0x0138] = "\x82\x78", [0x0139] = "\x82\x79", [0x013a] = "\x82\x7a",
  [0x013b] = "\x82\x7b", [0x013c] = "\x82\x7c", [0x013d] = "\x82\x7d",
  [0x013e] = "\x82\x7e", [0x0140] = "\x82\x80", [0x0141] = "\x82\x81",
  [0x0142] = "\x82\x82", [0x0143] = "\x82\x83", [0x0144] = "\x82\x84",
  [0x0145] = "\x82\x85", [0x0146] = "\x82\x86", [0x0147] = "\x82\x87",
  [0x0148] = "\x82\x88", [0x0149] = "\x82\x89", [0x014a] = "\x82\x8a",
  [0x014b] = "\x82\x8b", [0x014c] = "\x82\x8c", [0x014d] = "\x82\x8d",
  [0x014e] = "\x82\x8e", [0x014f] = "\x82\x8f", [0x0150] = "\x82\x90",
  [0x0151] = "\x82\x91", [0x0152] = "\x82\x92", [0x0153] = "\x82\x93",
  [0x0154] = "\x82\x94", [0x0155] = "\x82\x95", [0x0156] = "\x82\x96",
  [0x0157] = "\x82\x97", [0x0158] = "\x82\x98", [0x0159] = "\x82\x99",
  [0x015a] = "\x82\x9a", [0x015b] = "\x82\x9b", [0x015c] = "\x82\x9c",
  [0x015d] = "\x82\x9d", [0x015e] = "\x82\x9e", [0x015f] = "\x82\x9f",
  [0x0160] = "\x82\xa0", [0x0161] = "\x82\xa1", [0x0162] = "\x82\xa2",
  [0x0163] = "\x82\xa3", [0x0164] = "\x82\xa4", [0x0165] = "\x82\xa5",
  [0x0166] = "\x82\xa6", [0x0167] = "\x82\xa7", [0x0168] = "\x82\xa8",
  [0x0169] = "\x82\xa9", [0x016a] = "\x82\xaa", [0x016b] = "\x82\xab",
  [0x016c] = "\x82\xac", [0x016d] = "\x82\xad", [0x016e] = "\x82\xae",
  [0x016f] = "\x82\xaf", [0x0170] = "\x82\xb0", [0x0171] = "\x82\xb1",
  [0x0172] = "\x82\xb2", [0x0173] = "\x82\xb3", [0x0174] = "\x82\xb4",
  [0x0175] = "\x82\xb5", [0x0176] = "\x82\xb6", [0x0177] = "\x82\xb7",
  [0x0178] = "\x82\xb8", [0x0179] = "\x82\xb9", [0x017a] = "\x82\xba",
  [0x017b] = "\x82\xbb", [0x017c] = "\x82\xbc", [0x017d] = "\x82\xbd",
  [0x017e] = "\x82\xbe", [0x017f] = "\x82\xbf", [0x0180] = "\x82\xc0",
  [0x0181] = "\x82\xc1", [0x0182] = "\x82\xc2", [0x0183] = "\x82\xc3",
  [0x0184] = "\x82\xc4", [0x0185] = "\x82\xc5", [0x0186] = "\x82\xc6",
  [0x0187] = "\x82\xc7", [0x0188] = "\x82\xc8", [0x0189] = "\x82\xc9",
  [0x018a] = "\x82\xca", [0x018b] = "\x82\xcb", [0x018c] = "\x82\xcc",
  [0x018d] = "\x82\xcd", [0x018e] = "\x82\xce", [0x018f] = "\x82\xcf",
  [0x0190] = "\x82\xd0", [0x0191] = "\x82\xd1", [0x0192] = "\x82\xd2",
  [0x0193] = "\x82\xd3", [0x0194] = "\x82\xd4", [0x0195] = "\x82\xd5",
  [0x0196] = "\x82\xd6", [0x0197] = "\x82\xd7", [0x0198] = "\x82\xd8",
  [0x0199] = "\x82\xd9", [0x019a] = "\x82\xda", [0x019b] = "\x82\xdb",
  [0x019c] = "\x82\xdc", [0x019d] = "\x82\xdd", [0x019e] = "\x82\xde",
  [0x019f] = "\x82\xdf", [0x01a0] = "\x82\xe0", [0x01a1] = "\x82\xe1",
  [0x01a2] = "\x82\xe2", [0x01a3] = "\x82\xe3", [0x01a4] = "\x82\xe4",
  [0x01a5] = "\x82\xe5", [0x01a6] = "\x82\xe6", [0x01a7] = "\x82\xe7",
  [0x01a8] = "\x82\xe8", [0x01a9] = "\x82\xe9", [0x01aa] = "\x82\xea",
  [0x01ab] = "\x82\xeb", [0x01ac] = "\x82\xec", [0x01ad] = "\x82\xed",
  [0x01ae] = "\x82\xee", [0x01af] = "\x82\xef", [0x01b0] = "\x82\xf0",
  [0x01b1] = "\x82\xf1", [0x01b2] = "\x82\xf2", [0x01b3] = "\x82\xf3",
  [0x01b4] = "\x82\xf4", [0x01b5] = "\x82\xf5", [0x01b6] = "\x82\xf6",
  [0x01b7] = "\x82\xf7", [0x01b8] = "\x82\xf8", [0x01b9] = "\x82\xf9",
  [0x01ba] = "\x82\xfa", [0x01bb] = "\x82\xfb", [0x01bc] = "\x82\xfc",
  [0x01bd] = "\x82\xfd", [0x01be] = "\x82\xfe", [0x0200] = "\x83\x40",
  [0x0201] = "\x83\x41", [0x0202] = "\x83\x42", [0x0203] = "\x83\x43",
  [0x0204] = "\x83\x44", [0x0205] = "\x83\x45", [0x0206] = "\x83\x46",
  [0x0207] = "\x83\x47", [0x0208] = "\x83\x48", [0x0209] = "\x83\x49",
  [0x020a] = "\x83\x4a", [0x020b] = "\x83\x4b", [0x020c] = "\x83\x4c",
  [0x020d] = "\x83\x4d", [0x020e] = "\x83\x4e", [0x020f] = "\x83\x4f",
  [0x0210] = "\x83\x50", [0x0211] = "\x83\x51", [0x0212] = "\x83\x52",
  [0x0213] = "\x83\x53", [0x0214] = "\x83\x54", [0x0215] = "\x83\x55",
  [0x0216] = "\x83\x56", [0x0217] = "\x83\x57", [0x0218] = "\x83\x58",
  [0x0219] = "\x83\x59", [0x021a] = "\x83\x5a", [0x021b] = "\x83\x5b",
  [0x021c] = "\x83\x5c", [0x021d] = "\x83\x5d", [0x021e] = "\x83\x5e",
  [0x021f] = "\x83\x5f", [0x0220] = "\x83\x60", [0x0221] = "\x83\x61",
  [0x0222] = "\x83\x62", [0x0223] = "\x83\x63", [0x0224] = "\x83\x64",
  [0x0225] = "\x83\x65", [0x0226] = "\x83\x66", [0x0227] = "\x83\x67",
  [0x0228] = "\x83\x68", [0x0229] = "\x83\x69", [0x022a] = "\x83\x6a",
  [0x022b] = "\x83\x6b", [0x022c] = "\x83\x6c", [0x022d] = "\x83\x6d",
  [0x022e] = "\x83\x6e", [0x022f] = "\x83\x6f", [0x0230] = "\x83\x70",
  [0x0231] = "\x83\x71", [0x0232] = "\x83\x72", [0x0233] = "\x83\x73",
  [0x0234] = "\x83\x74", [0x0235] = "\x83\x75", [0x0236] = "\x83\x76",
  [0x0237] = "\x83\x77", [0x0238] = "\x83\x78", [0x0239] = "\x83\x79",
  [0x023a] = "\x83\x7a", [0x023b] = "\x83\x7b", [0x023c] = "\x83\x7c",
  [0x023d] = "\x83\x7d", [0x023e] = "\x83\x7e", [0x0240] = "\x83\x80",
  [0x0241] = "\x83\x81", [0x0242] = "\x83\x82", [0x0243] = "\x83\x83",
  [0x0244] = "\x83\x84", [0x0245] = "\x83\x85", [0x0246] = "\x83\x86",
  [0x0247] = "\x83\x87", [0x0248] = "\x83\x88", [0x0249] = "\x83\x89",
  [0x024a] = "\x83\x8a", [0x024b] = "\x83\x8b", [0x024c] = "\x83\x8c",
  [0x024d] = "\x83\x8d", [0x024e] = "\x83\x8e", [0x024f] = "\x83\x8f",
  [0x0250] = "\x83\x90", [0x0251] = "\x83\x91", [0x0252] = "\x83\x92",
  [0x0253] = "\x83\x93", [0x0254] = "\x83\x94", [0x0255] = "\x83\x95",
  [0x0256] = "\x83\x96", [0x0257] = "\x83\x97", [0x0258] = "\x83\x98",
  [0x0259] = "\x83\x99", [0x025a] = "\x83\x9a", [0x025b] = "\x83\x9b",
  [0x025c] = "\x83\x9c", [0x025d] = "\x83\x9d", [0x025e] = "\x83\x9e",
  [0x025f] = "\x83\x9f", [0x0260] = "\x83\xa0", [0x0261] = "\x83\xa1",
  [0x0262] = "\x83\xa2", [0x0263] = "\x83\xa3", [0x0264] = "\x83\xa4",
  [0x0265] = "\x83\xa5", [0x0266] = "\x83\xa6", [0x0267] = "\x83\xa7",
  [0x0268] = "\x83\xa8", [0x0269] = "\x83\xa9", [0x026a] = "\x83\xaa",
  [0x026b] = "\x83\xab", [0x026c] = "\x83\xac", [0x026d] = "\x83\xad",
  [0x026e] = "\x83\xae", [0x026f] = "\x83\xaf", [0x0270] = "\x83\xb0",
  [0x0271] = "\x83\xb1", [0x0272] = "\x83\xb2", [0x0273] = "\x83\xb3",
  [0x0274] = "\x83\xb4", [0x0275] = "\x83\xb5", [0x0276] = "\x83\xb6",
  [0x0277] = "\x83\xb7", [0x0278] = "\x83\xb8", [0x0279] = "\x83\xb9",
  [0x027a] = "\x83\xba", [0x027b] = "\x83\xbb", [0x027c] = "\x83\xbc",
  [0x027d] = "\x83\xbd", [0x027e] = "\x83\xbe", [0x027f] = "\x83\xbf",
  [0x0280] = "\x83\xc0", [0x0281] = "\x83\xc1", [0x0282] = "\x83\xc2",
  [0x0283] = "\x83\xc3", [0x0284] = "\x83\xc4", [0x0285] = "\x83\xc5",
  [0x0286] = "\x83\xc6", [0x0287] = "\x83\xc7", [0x0288] = "\x83\xc8",
  [0x0289] = "\x83\xc9", [0x028a] = "\x83\xca", [0x028b] = "\x83\xcb",
  [0x028c] = "\x83\xcc", [0x028d] = "\x83\xcd", [0x028e] = "\x83\xce",
  [0x028f] = "\x83\xcf", [0x0290] = "\x83\xd0", [0x0291] = "\x83\xd1",
  [0x0292] = "\x83\xd2", [0x0293] = "\x83\xd3", [0x0294] = "\x83\xd4",
  [0x0295] = "\x83\xd5", [0x0296] = "\x83\xd6", [0x0297] = "\x83\xd7",
  [0x0298] = "\x83\xd8", [0x0299] = "\x83\xd9", [0x029a] = "\x83\xda",
  [0x029b] = "\x83\xdb", [0x029c] = "\x83\xdc", [0x029d] = "\x83\xdd",
  [0x029e] = "\x83\xde", [0x029f] = "\x83\xdf", [0x02a0] = "\x83\xe0",
  [0x02a1] = "\x83\xe1", [0x02a2] = "\x83\xe2", [0x02a3] = "\x83\xe3",
  [0x02a4] = "\x83\xe4", [0x02a5] = "\x83\xe5", [0x02a6] = "\x83\xe6",
  [0x02a7] = "\x83\xe7", [0x02a8] = "\x83\xe8", [0x02a9] = "\x83\xe9",
  [0x02aa] = "\x83\xea", [0x02ab] = "\x83\xeb", [0x02ac] = "\x83\xec",
  [0x02ad] = "\x83\xed", [0x02ae] = "\x83\xee", [0x02af] = "\x83\xef",
  [0x02b0] = "\x83\xf0", [0x02b1] = "\x83\xf1", [0x02b2] = "\x83\xf2",
  [0x02b3] = "\x83\xf3", [0x02b4] = "\x83\xf4", [0x02b5] = "\x83\xf5",
  [0x02b6] = "\x83\xf6", [0x02b7] = "\x83\xf7", [0x02b8] = "\x83\xf8",
  [0x02b9] = "\x83\xf9", [0x02ba] = "\x83\xfa", [0x02bb] = "\x83\xfb",
  [0x02bc] = "\x83\xfc", [0x02bd] = "\x83\xfd", [0x02be] = "\x83\xfe",
  [0x0300] = "\x84\x40", [0x0301] = "\x84\x41", [0x0302] = "\x84\x42",
  [0x0303] = "\x84\x43", [0x0304] = "\x84\x44", [0x0305] = "\x84\x45",
  [0x0306] = "\x84\x46", [0x0307] = "\x84\x47", [0x0308] = "\x84\x48",
  [0x0309] = "\x84\x49", [0x030a] = "\x84\x4a", [0x030b] = "\x84\x4b",
  [0x030c] = "\x84\x4c", [0x030d] = "\x84\x4d", [0x030e] = "\x84\x4e",
  [0x030f] = "\x84\x4f", [0x0310] = "\x84\x50", [0x0311] = "\x84\x51",
  [0x0312] = "\x84\x52", [0x0313] = "\x84\x53", [0x0314] = "\x84\x54",
  [0x0315] = "\x84\x55", [0x0316] = "\x84\x56", [0x0317] = "\x84\x57",
  [0x0318] = "\x84\x58", [0x0319] = "\x84\x59", [0x031a] = "\x84\x5a",
  [0x031b] = "\x84\x5b", [0x031c] = "\x84\x5c", [0x031d] = "\x84\x5d",
  [0x031e] = "\x84\x5e", [0x031f] = "\x84\x5f", [0x0320] = "\x84\x60",
  [0x0321] = "\x84\x61", [0x0322] = "\x84\x62", [0x0323] = "\x84\x63",
  [0x0324] = "\x84\x64", [0x0325] = "\x84\x65", [0x0326] = "\x84\x66",
  [0x0327] = "\x84\x67", [0x0328] = "\x84\x68", [0x0329] = "\x84\x69",
  [0x032a] = "\x84\x6a", [0x032b] = "\x84\x6b", [0x032c] = "\x84\x6c",
  [0x032d] = "\x84\x6d", [0x032e] = "\x84\x6e", [0x032f] = "\x84\x6f",
  [0x0330] = "\x84\x70", [0x0331] = "\x84\x71", [0x0332] = "\x84\x72",
  [0x0333] = "\x84\x73", [0x0334] = "\x84\x74", [0x0335] = "\x84\x75",
  [0x0336] = "\x84\x76", [0x0337] = "\x84\x77", [0x0338] = "\x84\x78",
  [0x0339] = "\x84\x79", [0x033a] = "\x84\x7a", [0x033b] = "\x84\x7b",
  [0x033c] = "\x84\x7c", [0x033d] = "\x84\x7d", [0x033e] = "\x84\x7e",
  [0x0340] = "\x84\x80", [0x0341] = "\x84\x81", [0x0342] = "\x84\x82",
  [0x0343] = "\x84\x83", [0x0344] = "\x84\x84", [0x0345] = "\x84\x85",
  [0x0346] = "\x84\x86", [0x0347] = "\x84\x87", [0x0348] = "\x84\x88",
  [0x0349] = "\x84\x89", [0x034a] = "\x84\x8a", [0x034b] = "\x84\x8b",
  [0x034c] = "\x84\x8c", [0x034d] = "\x84\x8d", [0x034e] = "\x84\x8e",
  [0x034f] = "\x84\x8f", [0x0350] = "\x84\x90", [0x0351] = "\x84\x91",
  [0x0352] = "\x84\x92", [0x0353] = "\x84\x93", [0x0354] = "\x84\x94",
  [0x0355] = "\x84\x95", [0x0356] = "\x84\x96", [0x0357] = "\x84\x97",
  [0x0358] = "\x84\x98", [0x0359] = "\x84\x99", [0x035a] = "\x84\x9a",
  [0x035b] = "\x84\x9b", [0x035c] = "\x84\x9c", [0x035d] = "\x84\x9d",
  [0x035e] = "\x84\x9e", [0x035f] = "\x84\x9f", [0x0360] = "\x84\xa0",
  [0x0361] = "\x84\xa1", [0x0362] = "\x84\xa2", [0x0363] = "\x84\xa3",
  [0x0364] = "\x84\xa4", [0x0365] = "\x84\xa5", [0x0366] = "\x84\xa6",
  [0x0367] = "\x84\xa7", [0x0368] = "\x84\xa8", [0x0369] = "\x84\xa9",
  [0x036a] = "\x84\xaa", [0x036b] = "\x84\xab", [0x036c] = "\x84\xac",
  [0x036d] = "\x84\xad", [0x036e] = "\x84\xae", [0x036f] = "\x84\xaf",
  [0x0370] = "\x84\xb0", [0x0371] = "\x84\xb1", [0x0372] = "\x84\xb2",
  [0x0373] = "\x84\xb3", [0x0374] = "\x84\xb4", [0x0375] = "\x84\xb5",
  [0x0376] = "\x84\xb6", [0x0377] = "\x84\xb7", [0x0378] = "\x84\xb8",
  [0x0379] = "\x84\xb9", [0x037a] = "\x84\xba", [0x037b] = "\x84\xbb",
  [0x037c] = "\x84\xbc", [0x037d] = "\x84\xbd", [0x037e] = "\x84\xbe",
  [0x037f] = "\x84\xbf", [0x0380] = "\x84\xc0", [0x0381] = "\x84\xc1",
  [0x0382] = "\x84\xc2", [0x0383] = "\x84\xc3", [0x0384] = "\x84\xc4",
  [0x0385] = "\x84\xc5", [0x0386] = "\x84\xc6", [0x0387] = "\x84\xc7",
  [0x0388] = "\x84\xc8", [0x0389] = "\x84\xc9", [0x038a] = "\x84\xca",
  [0x038b] = "\x84\xcb", [0x038c] = "\x84\xcc", [0x038d] = "\x84\xcd",
  [0x038e] = "\x84\xce", [0x038f] = "\x84\xcf", [0x0390] = "\x84\xd0",
  [0x0391] = "\x84\xd1", [0x0392] = "\x84\xd2", [0x0393] = "\x84\xd3",
  [0x0394] = "\x84\xd4", [0x0395] = "\x84\xd5", [0x0396] = "\x84\xd6",
  [0x0397] = "\x84\xd7", [0x0398] = "\x84\xd8", [0x0399] = "\x84\xd9",
  [0x039a] = "\x84\xda", [0x039b] = "\x84\xdb", [0x039c] = "\x84\xdc",
  [0x039d] = "\x84\xdd", [0x039e] = "\x84\xde", [0x039f] = "\x84\xdf",
  [0x03a0] = "\x84\xe0", [0x03a1] = "\x84\xe1", [0x03a2] = "\x84\xe2",
  [0x03a3] = "\x84\xe3", [0x03a4] = "\x84\xe4", [0x03a5] = "\x84\xe5",
  [0x03a6] = "\x84\xe6", [0x03a7] = "\x84\xe7", [0x03a8] = "\x84\xe8",
  [0x03a9] = "\x84\xe9", [0x03aa] = "\x84\xea", [0x03ab] = "\x84\xeb",
  [0x03ac] = "\x84\xec", [0x03ad] = "\x84\xed", [0x03ae] = "\x84\xee",
  [0x03af] = "\x84\xef", [0x03b0] = "\x84\xf0", [0x03b1] = "\x84\xf1",
  [0x03b2] = "\x84\xf2", [0x03b3] = "\x84\xf3", [0x03b4] = "\x84\xf4",
  [0x03b5] = "\x84\xf5", [0x03b6] = "\x84\xf6", [0x03b7] = "\x84\xf7",
  [0x03b8] = "\x84\xf8", [0x03b9] = "\x84\xf9", [0x03ba] = "\x84\xfa",
  [0x03bb] = "\x84\xfb", [0x03bc] = "\x84\xfc", [0x03bd] = "\x84\xfd",
  [0x03be] = "\x84\xfe", [0x0400] = "\x85\x40", [0x0401] = "\x85\x41",
  [0x0402] = "\x85\x42", [0x0403] = "\x85\x43", [0x0404] = "\x85\x44",
  [0x0405] = "\x85\x45", [0x0406] = "\x85\x46", [0x0407] = "\x85\x47",
  [0x0408] = "\x85\x48", [0x0409] = "\x85\x49", [0x040a] = "\x85\x4a",
  [0x040b] = "\x85\x4b", [0x040c] = "\x85\x4c", [0x040d] = "\x85\x4d",
  [0x040e] = "\x85\x4e", [0x040f] = "\x85\x4f", [0x0410] = "\x85\x50",
  [0x0411] = "\x85\x51", [0x0412] = "\x85\x52", [0x0413] = "\x85\x53",
  [0x0414] = "\x85\x54", [0x0415] = "\x85\x55", [0x0416] = "\x85\x56",
  [0x0417] = "\x85\x57", [0x0418] = "\x85\x58", [0x0419] = "\x85\x59",
  [0x041a] = "\x85\x5a", [0x041b] = "\x85\x5b", [0x041c] = "\x85\x5c",
  [0x041d] = "\x85\x5d", [0x041e] = "\x85\x5e", [0x041f] = "\x85\x5f",
  [0x0420] = "\x85\x60", [0x0421] = "\x85\x61", [0x0422] = "\x85\x62",
  [0x0423] = "\x85\x63", [0x0424] = "\x85\x64", [0x0425] = "\x85\x65",
  [0x0426] = "\x85\x66", [0x0427] = "\x85\x67", [0x0428] = "\x85\x68",
  [0x0429] = "\x85\x69", [0x042a] = "\x85\x6a", [0x042b] = "\x85\x6b",
  [0x042c] = "\x85\x6c", [0x042d] = "\x85\x6d", [0x042e] = "\x85\x6e",
  [0x042f] = "\x85\x6f", [0x0430] = "\x85\x70", [0x0431] = "\x85\x71",
  [0x0432] = "\x85\x72", [0x0433] = "\x85\x73", [0x0434] = "\x85\x74",
  [0x0435] = "\x85\x75", [0x0436] = "\x85\x76", [0x0437] = "\x85\x77",
  [0x0438] = "\x85\x78", [0x0439] = "\x85\x79", [0x043a] = "\x85\x7a",
  [0x043b] = "\x85\x7b", [0x043c] = "\x85\x7c", [0x043d] = "\x85\x7d",
  [0x043e] = "\x85\x7e", [0x0440] = "\x85\x80", [0x0441] = "\x85\x81",
  [0x0442] = "\x85\x82", [0x0443] = "\x85\x83", [0x0444] = "\x85\x84",
  [0x0445] = "\x85\x85", [0x0446] = "\x85\x86", [0x0447] = "\x85\x87",
  [0x0448] = "\x85\x88", [0x0449] = "\x85\x89", [0x044a] = "\x85\x8a",
  [0x044b] = "\x85\x8b", [0x044c] = "\x85\x8c", [0x044d] = "\x85\x8d",
  [0x044e] = "\x85\x8e", [0x044f] = "\x85\x8f", [0x0450] = "\x85\x90",
  [0x0451] = "\x85\x91", [0x0452] = "\x85\x92", [0x0453] = "\x85\x93",
  [0x0454] = "\x85\x94", [0x0455] = "\x85\x95", [0x0456] = "\x85\x96",
  [0x0457] = "\x85\x97", [0x0458] = "\x85\x98", [0x0459] = "\x85\x99",
  [0x045a] = "\x85\x9a", [0x045b] = "\x85\x9b", [0x045c] = "\x85\x9c",
  [0x045d] = "\x85\x9d", [0x045e] = "\x85\x9e", [0x045f] = "\x85\x9f",
  [0x0460] = "\x85\xa0", [0x0461] = "\x85\xa1", [0x0462] = "\x85\xa2",
  [0x0463] = "\x85\xa3", [0x0464] = "\x85\xa4", [0x0465] = "\x85\xa5",
  [0x0466] = "\x85\xa6", [0x0467] = "\x85\xa7", [0x0468] = "\x85\xa8",
  [0x0469] = "\x85\xa9", [0x046a] = "\x85\xaa", [0x046b] = "\x85\xab",
  [0x046c] = "\x85\xac", [0x046d] = "\x85\xad", [0x046e] = "\x85\xae",
  [0x046f] = "\x85\xaf", [0x0470] = "\x85\xb0", [0x0471] = "\x85\xb1",
  [0x0472] = "\x85\xb2", [0x0473] = "\x85\xb3", [0x0474] = "\x85\xb4",
  [0x0475] = "\x85\xb5", [0x0476] = "\x85\xb6", [0x0477] = "\x85\xb7",
  [0x0478] = "\x85\xb8", [0x0479] = "\x85\xb9", [0x047a] = "\x85\xba",
  [0x047b] = "\x85\xbb", [0x047c] = "\x85\xbc", [0x047d] = "\x85\xbd",
  [0x047e] = "\x85\xbe", [0x047f] = "\x85\xbf", [0x0480] = "\x85\xc0",
  [0x0481] = "\x85\xc1", [0x0482] = "\x85\xc2", [0x0483] = "\x85\xc3",
  [0x0484] = "\x85\xc4", [0x0485] = "\x85\xc5", [0x0486] = "\x85\xc6",
  [0x0487] = "\x85\xc7", [0x0488] = "\x85\xc8", [0x0489] = "\x85\xc9",
  [0x048a] = "\x85\xca", [0x048b] = "\x85\xcb", [0x048c] = "\x85\xcc",
  [0x048d] = "\x85\xcd", [0x048e] = "\x85\xce", [0x048f] = "\x85\xcf",
  [0x0490] = "\x85\xd0", [0x0491] = "\x85\xd1", [0x0492] = "\x85\xd2",
  [0x0493] = "\x85\xd3", [0x0494] = "\x85\xd4", [0x0495] = "\x85\xd5",
  [0x0496] = "\x85\xd6", [0x0497] = "\x85\xd7", [0x0498] = "\x85\xd8",
  [0x0499] = "\x85\xd9", [0x049a] = "\x85\xda", [0x049b] = "\x85\xdb",
  [0x049c] = "\x85\xdc", [0x049d] = "\x85\xdd", [0x049e] = "\x85\xde",
  [0x049f] = "\x85\xdf", [0x04a0] = "\x85\xe0", [0x04a1] = "\x85\xe1",
  [0x04a2] = "\x85\xe2", [0x04a3] = "\x85\xe3", [0x04a4] = "\x85\xe4",
  [0x04a5] = "\x85\xe5", [0x04a6] = "\x85\xe6", [0x04a7] = "\x85\xe7",
  [0x04a8] = "\x85\xe8", [0x04a9] = "\x85\xe9", [0x04aa] = "\x85\xea",
  [0x04ab] = "\x85\xeb", [0x04ac] = "\x85\xec", [0x04ad] = "\x85\xed",
  [0x04ae] = "\x85\xee", [0x04af] = "\x85\xef", [0x04b0] = "\x85\xf0",
  [0x04b1] = "\x85\xf1", [0x04b2] = "\x85\xf2", [0x04b3] = "\x85\xf3",
  [0x04b4] = "\x85\xf4", [0x04b5] = "\x85\xf5", [0x04b6] = "\x85\xf6",
  [0x04b7] = "\x85\xf7", [0x04b8] = "\x85\xf8", [0x04b9] = "\x85\xf9",
  [0x04ba] = "\x85\xfa", [0x04bb] = "\x85\xfb", [0x04bc] = "\x85\xfc",
  [0x04bd] = "\x85\xfd", [0x04be] = "\x85\xfe", [0x0500] = "\x86\x40",
  [0x0501] = "\x86\x41", [0x0502] = "\x86\x42", [0x0503] = "\x86\x43",
  [0x0504] = "\x86\x44", [0x0505] = "\x86\x45", [0x0506] = "\x86\x46",
  [0x0507] = "\x86\x47", [0x0508] = "\x86\x48", [0x0509] = "\x86\x49",
  [0x050a] = "\x86\x4a", [0x050b] = "\x86\x4b", [0x050c] = "\x86\x4c",
  [0x050d] = "\x86\x4d", [0x050e] = "\x86\x4e", [0x050f] = "\x86\x4f",
  [0x0510] = "\x86\x50", [0x0511] = "\x86\x51", [0x0512] = "\x86\x52",
  [0x0513] = "\x86\x53", [0x0514] = "\x86\x54", [0x0515] = "\x86\x55",
  [0x0516] = "\x86\x56", [0x0517] = "\x86\x57", [0x0518] = "\x86\x58",
  [0x0519] = "\x86\x59", [0x051a] = "\x86\x5a", [0x051b] = "\x86\x5b",
  [0x051c] = "\x86\x5c", [0x051d] = "\x86\x5d", [0x051e] = "\x86\x5e",
  [0x051f] = "\x86\x5f", [0x0520] = "\x86\x60", [0x0521] = "\x86\x61",
  [0x0522] = "\x86\x62", [0x0523] = "\x86\x63", [0x0524] = "\x86\x64",
  [0x0525] = "\x86\x65", [0x0526] = "\x86\x66", [0x0527] = "\x86\x67",
  [0x0528] = "\x86\x68", [0x0529] = "\x86\x69", [0x052a] = "\x86\x6a",
  [0x052b] = "\x86\x6b", [0x052c] = "\x86\x6c", [0x052d] = "\x86\x6d",
  [0x052e] = "\x86\x6e", [0x052f] = "\x86\x6f", [0x0530] = "\x86\x70",
  [0x0531] = "\x86\x71", [0x0532] = "\x86\x72", [0x0533] = "\x86\x73",
  [0x0534] = "\x86\x74", [0x0535] = "\x86\x75", [0x0536] = "\x86\x76",
  [0x0537] = "\x86\x77", [0x0538] = "\x86\x78", [0x0539] = "\x86\x79",
  [0x053a] = "\x86\x7a", [0x053b] = "\x86\x7b", [0x053c] = "\x86\x7c",
  [0x053d] = "\x86\x7d", [0x053e] = "\x86\x7e", [0x0540] = "\x86\x80",
  [0x0541] = "\x86\x81", [0x0542] = "\x86\x82", [0x0543] = "\x86\x83",
  [0x0544] = "\x86\x84", [0x0545] = "\x86\x85", [0x0546] = "\x86\x86",
  [0x0547] = "\x86\x87", [0x0548] = "\x86\x88", [0x0549] = "\x86\x89",
  [0x054a] = "\x86\x8a", [0x054b] = "\x86\x8b", [0x054c] = "\x86\x8c",
  [0x054d] = "\x86\x8d", [0x054e] = "\x86\x8e", [0x054f] = "\x86\x8f",
  [0x0550] = "\x86\x90", [0x0551] = "\x86\x91", [0x0552] = "\x86\x92",
  [0x0553] = "\x86\x93", [0x0554] = "\x86\x94", [0x0555] = "\x86\x95",
  [0x0556] = "\x86\x96", [0x0557] = "\x86\x97", [0x0558] = "\x86\x98",
  [0x0559] = "\x86\x99", [0x055a] = "\x86\x9a", [0x055b] = "\x86\x9b",
  [0x055c] = "\x86\x9c", [0x055d] = "\x86\x9d", [0x055e] = "\x86\x9e",
  [0x055f] = "\x86\x9f", [0x0560] = "\x86\xa0", [0x0561] = "\x86\xa1",
  [0x0562] = "\x86\xa2", [0x0563] = "\x86\xa3", [0x0564] = "\x86\xa4",
  [0x0565] = "\x86\xa5", [0x0566] = "\x86\xa6", [0x0567] = "\x86\xa7",
  [0x0568] = "\x86\xa8", [0x0569] = "\x86\xa9", [0x056a] = "\x86\xaa",
  [0x056b] = "\x86\xab", [0x056c] = "\x86\xac", [0x056d] = "\x86\xad",
  [0x056e] = "\x86\xae", [0x056f] = "\x86\xaf", [0x0570] = "\x86\xb0",
  [0x0571] = "\x86\xb1", [0x0572] = "\x86\xb2", [0x0573] = "\x86\xb3",
  [0x0574] = "\x86\xb4", [0x0575] = "\x86\xb5", [0x0576] = "\x86\xb6",
  [0x0577] = "\x86\xb7", [0x0578] = "\x86\xb8", [0x0579] = "\x86\xb9",
  [0x057a] = "\x86\xba", [0x057b] = "\x86\xbb", [0x057c] = "\x86\xbc",
  [0x057d] = "\x86\xbd", [0x057e] = "\x86\xbe", [0x057f] = "\x86\xbf",
  [0x0580] = "\x86\xc0", [0x0581] = "\x86\xc1", [0x0582] = "\x86\xc2",
  [0x0583] = "\x86\xc3", [0x0584] = "\x86\xc4", [0x0585] = "\x86\xc5",
  [0x0586] = "\x86\xc6", [0x0587] = "\x86\xc7", [0x0588] = "\x86\xc8",
  [0x0589] = "\x86\xc9", [0x058a] = "\x86\xca", [0x058b] = "\x86\xcb",
  [0x058c] = "\x86\xcc", [0x058d] = "\x86\xcd", [0x058e] = "\x86\xce",
  [0x058f] = "\x86\xcf", [0x0590] = "\x86\xd0", [0x0591] = "\x86\xd1",
  [0x0592] = "\x86\xd2", [0x0593] = "\x86\xd3", [0x0594] = "\x86\xd4",
  [0x0595] = "\x86\xd5", [0x0596] = "\x86\xd6", [0x0597] = "\x86\xd7",
  [0x0598] = "\x86\xd8", [0x0599] = "\x86\xd9", [0x059a] = "\x86\xda",
  [0x059b] = "\x86\xdb", [0x059c] = "\x86\xdc", [0x059d] = "\x86\xdd",
  [0x059e] = "\x86\xde", [0x059f] = "\x86\xdf", [0x05a0] = "\x86\xe0",
  [0x05a1] = "\x86\xe1", [0x05a2] = "\x86\xe2", [0x05a3] = "\x86\xe3",
  [0x05a4] = "\x86\xe4", [0x05a5] = "\x86\xe5", [0x05a6] = "\x86\xe6",
  [0x05a7] = "\x86\xe7", [0x05a8] = "\x86\xe8", [0x05a9] = "\x86\xe9",
  [0x05aa] = "\x86\xea", [0x05ab] = "\x86\xeb", [0x05ac] = "\x86\xec",
  [0x05ad] = "\x86\xed", [0x05ae] = "\x86\xee", [0x05af] = "\x86\xef",
  [0x05b0] = "\x86\xf0", [0x05b1] = "\x86\xf1", [0x05b2] = "\x86\xf2",
  [0x05b3] = "\x86\xf3", [0x05b4] = "\x86\xf4", [0x05b5] = "\x86\xf5",
  [0x05b6] = "\x86\xf6", [0x05b7] = "\x86\xf7", [0x05b8] = "\x86\xf8",
  [0x05b9] = "\x86\xf9", [0x05ba] = "\x86\xfa", [0x05bb] = "\x86\xfb",
  [0x05bc] = "\x86\xfc", [0x05bd] = "\x86\xfd", [0x05be] = "\x86\xfe",
  [0x0600] = "\x87\x40", [0x0601] = "\x87\x41", [0x0602] = "\x87\x42",
  [0x0603] = "\x87\x43", [0x0604] = "\x87\x44", [0x0605] = "\x87\x45",
  [0x0606] = "\x87\x46", [0x0607] = "\x87\x47", [0x0608] = "\x87\x48",
  [0x0609] = "\x87\x49", [0x060a] = "\x87\x4a", [0x060b] = "\x87\x4b",
  [0x060c] = "\x87\x4c", [0x060d] = "\x87\x4d", [0x060e] = "\x87\x4e",
  [0x060f] = "\x87\x4f", [0x0610] = "\x87\x50", [0x0611] = "\x87\x51",
  [0x0612] = "\x87\x52", [0x0613] = "\x87\x53", [0x0614] = "\x87\x54",
  [0x0615] = "\x87\x55", [0x0616] = "\x87\x56", [0x0617] = "\x87\x57",
  [0x0618] = "\x87\x58", [0x0619] = "\x87\x59", [0x061a] = "\x87\x5a",
  [0x061b] = "\x87\x5b", [0x061c] = "\x87\x5c", [0x061d] = "\x87\x5d",
  [0x061e] = "\x87\x5e", [0x061f] = "\x87\x5f", [0x0620] = "\x87\x60",
  [0x0621] = "\x87\x61", [0x0622] = "\x87\x62", [0x0623] = "\x87\x63",
  [0x0624] = "\x87\x64", [0x0625] = "\x87\x65", [0x0626] = "\x87\x66",
  [0x0627] = "\x87\x67", [0x0628] = "\x87\x68", [0x0629] = "\x87\x69",
  [0x062a] = "\x87\x6a", [0x062b] = "\x87\x6b", [0x062c] = "\x87\x6c",
  [0x062d] = "\x87\x6d", [0x062e] = "\x87\x6e", [0x062f] = "\x87\x6f",
  [0x0630] = "\x87\x70", [0x0631] = "\x87\x71", [0x0632] = "\x87\x72",
  [0x0633] = "\x87\x73", [0x0634] = "\x87\x74", [0x0635] = "\x87\x75",
  [0x0636] = "\x87\x76", [0x0637] = "\x87\x77", [0x0638] = "\x87\x78",
  [0x0639] = "\x87\x79", [0x063a] = "\x87\x7a", [0x063b] = "\x87\x7b",
  [0x063c] = "\x87\x7c", [0x063d] = "\x87\x7d", [0x063e] = "\x87\x7e",
  [0x0640] = "\x87\x80", [0x0641] = "\x87\x81", [0x0642] = "\x87\x82",
  [0x0643] = "\x87\x83", [0x0644] = "\x87\x84", [0x0645] = "\x87\x85",
  [0x0646] = "\x87\x86", [0x0647] = "\x87\x87", [0x0648] = "\x87\x88",
  [0x0649] = "\x87\x89", [0x064a] = "\x87\x8a", [0x064b] = "\x87\x8b",
  [0x064c] = "\x87\x8c", [0x064d] = "\x87\x8d", [0x064e] = "\x87\x8e",
  [0x064f] = "\x87\x8f", [0x0650] = "\x87\x90", [0x0651] = "\x87\x91",
  [0x0652] = "\x87\x92", [0x0653] = "\x87\x93", [0x0654] = "\x87\x94",
  [0x0655] = "\x87\x95", [0x0656] = "\x87\x96", [0x0657] = "\x87\x97",
  [0x0658] = "\x87\x98", [0x0659] = "\x87\x99", [0x065a] = "\x87\x9a",
  [0x065b] = "\x87\x9b", [0x065c] = "\x87\x9c", [0x065d] = "\x87\x9d",
  [0x065e] = "\x87\x9e", [0x065f] = "\x87\x9f", [0x0660] = "\x87\xa0",
  [0x0661] = "\x87\xa1", [0x0662] = "\x87\xa2", [0x0663] = "\x87\xa3",
  [0x0664] = "\x87\xa4", [0x0665] = "\x87\xa5", [0x0666] = "\x87\xa6",
  [0x0667] = "\x87\xa7", [0x0668] = "\x87\xa8", [0x0669] = "\x87\xa9",
  [0x066a] = "\x87\xaa", [0x066b] = "\x87\xab", [0x066c] = "\x87\xac",
  [0x066d] = "\x87\xad", [0x066e] = "\x87\xae", [0x066f] = "\x87\xaf",
  [0x0670] = "\x87\xb0", [0x0671] = "\x87\xb1", [0x0672] = "\x87\xb2",
  [0x0673] = "\x87\xb3", [0x0674] = "\x87\xb4", [0x0675] = "\x87\xb5",
  [0x0676] = "\x87\xb6", [0x0677] = "\x87\xb7", [0x0678] = "\x87\xb8",
  [0x0679] = "\x87\xb9", [0x067a] = "\x87\xba", [0x067b] = "\x87\xbb",
  [0x067c] = "\x87\xbc", [0x067d] = "\x87\xbd", [0x067e] = "\x87\xbe",
  [0x067f] = "\x87\xbf", [0x0680] = "\x87\xc0", [0x0681] = "\x87\xc1",
  [0x0682] = "\x87\xc2", [0x0683] = "\x87\xc3", [0x0684] = "\x87\xc4",
  [0x0685] = "\x87\xc5", [0x0686] = "\x87\xc6", [0x0687] = "\x87\xc7",
  [0x0688] = "\x87\xc8", [0x0689] = "\x87\xc9", [0x068a] = "\x87\xca",
  [0x068b] = "\x87\xcb", [0x068c] = "\x87\xcc", [0x068d] = "\x87\xcd",
  [0x068e] = "\x87\xce", [0x068f] = "\x87\xcf", [0x0690] = "\x87\xd0",
  [0x0691] = "\x87\xd1", [0x0692] = "\x87\xd2", [0x0693] = "\x87\xd3",
  [0x0694] = "\x87\xd4", [0x0695] = "\x87\xd5", [0x0696] = "\x87\xd6",
  [0x0697] = "\x87\xd7", [0x0698] = "\x87\xd8", [0x0699] = "\x87\xd9",
  [0x069a] = "\x87\xda", [0x069b] = "\x87\xdb", [0x069c] = "\x87\xdc",
  [0x069d] = "\x87\xdd", [0x069e] = "\x87\xde", [0x069f] = "\x87\xdf",
  [0x06a0] = "\x87\xe0", [0x06a1] = "\x87\xe1", [0x06a2] = "\x87\xe2",
  [0x06a3] = "\x87\xe3", [0x06a4] = "\x87\xe4", [0x06a5] = "\x87\xe5",
  [0x06a6] = "\x87\xe6", [0x06a7] = "\x87\xe7", [0x06a8] = "\x87\xe8",
  [0x06a9] = "\x87\xe9", [0x06aa] = "\x87\xea", [0x06ab] = "\x87\xeb",
  [0x06ac] = "\x87\xec", [0x06ad] = "\x87\xed", [0x06ae] = "\x87\xee",
  [0x06af] = "\x87\xef", [0x06b0] = "\x87\xf0", [0x06b1] = "\x87\xf1",
  [0x06b2] = "\x87\xf2", [0x06b3] = "\x87\xf3", [0x06b4] = "\x87\xf4",
  [0x06b5] = "\x87\xf5", [0x06b6] = "\x87\xf6", [0x06b7] = "\x87\xf7",
  [0x06b8] = "\x87\xf8", [0x06b9] = "\x87\xf9", [0x06ba] = "\x87\xfa",
  [0x06bb] = "\x87\xfb", [0x06bc] = "\x87\xfc", [0x06bd] = "\x87\xfd",
  [0x06be] = "\x87\xfe", [0x0700] = "\x88\x40", [0x0701] = "\x88\x41",
  [0x0702] = "\x88\x42", [0x0703] = "\x88\x43", [0x0704] = "\x88\x44",
  [0x0705] = "\x88\x45", [0x0706] = "\x88\x46", [0x0707] = "\x88\x47",
  [0x0708] = "\x88\x48", [0x0709] = "\x88\x49", [0x070a] = "\x88\x4a",
  [0x070b] = "\x88\x4b", [0x070c] = "\x88\x4c", [0x070d] = "\x88\x4d",
  [0x070e] = "\x88\x4e", [0x070f] = "\x88\x4f", [0x0710] = "\x88\x50",
  [0x0711] = "\x88\x51", [0x0712] = "\x88\x52", [0x0713] = "\x88\x53",
  [0x0714] = "\x88\x54", [0x0715] = "\x88\x55", [0x0716] = "\x88\x56",
  [0x0717] = "\x88\x57", [0x0718] = "\x88\x58", [0x0719] = "\x88\x59",
  [0x071a] = "\x88\x5a", [0x071b] = "\x88\x5b", [0x071c] = "\x88\x5c",
  [0x071d] = "\x88\x5d", [0x071e] = "\x88\x5e", [0x071f] = "\x88\x5f",
  [0x0720] = "\x88\x60", [0x0721] = "\x88\x61", [0x0722] = "\x88\x62",
  [0x0723] = "\x88\x63", [0x0724] = "\x88\x64", [0x0725] = "\x88\x65",
  [0x0726] = "\x88\x66", [0x0727] = "\x88\x67", [0x0728] = "\x88\x68",
  [0x0729] = "\x88\x69", [0x072a] = "\x88\x6a", [0x072b] = "\x88\x6b",
  [0x072c] = "\x88\x6c", [0x072d] = "\x88\x6d", [0x072e] = "\x88\x6e",
  [0x072f] = "\x88\x6f", [0x0730] = "\x88\x70", [0x0731] = "\x88\x71",
  [0x0732] = "\x88\x72", [0x0733] = "\x88\x73", [0x0734] = "\x88\x74",
  [0x0735] = "\x88\x75", [0x0736] = "\x88\x76", [0x0737] = "\x88\x77",
  [0x0738] = "\x88\x78", [0x0739] = "\x88\x79", [0x073a] = "\x88\x7a",
  [0x073b] = "\x88\x7b", [0x073c] = "\x88\x7c", [0x073d] = "\x88\x7d",
  [0x073e] = "\x88\x7e", [0x0740] = "\x88\x80", [0x0741] = "\x88\x81",
  [0x0742] = "\x88\x82", [0x0743] = "\x88\x83", [0x0744] = "\x88\x84",
  [0x0745] = "\x88\x85", [0x0746] = "\x88\x86", [0x0747] = "\x88\x87",
  [0x0748] = "\x88\x88", [0x0749] = "\x88\x89", [0x074a] = "\x88\x8a",
  [0x074b] = "\x88\x8b", [0x074c] = "\x88\x8c", [0x074d] = "\x88\x8d",
  [0x074e] = "\x88\x8e", [0x074f] = "\x88\x8f", [0x0750] = "\x88\x90",
  [0x0751] = "\x88\x91", [0x0752] = "\x88\x92", [0x0753] = "\x88\x93",
  [0x0754] = "\x88\x94", [0x0755] = "\x88\x95", [0x0756] = "\x88\x96",
  [0x0757] = "\x88\x97", [0x0758] = "\x88\x98", [0x0759] = "\x88\x99",
  [0x075a] = "\x88\x9a", [0x075b] = "\x88\x9b", [0x075c] = "\x88\x9c",
  [0x075d] = "\x88\x9d", [0x075e] = "\x88\x9e", [0x075f] = "\x88\x9f",
  [0x0760] = "\x88\xa0", [0x0761] = "\x88\xa1", [0x0762] = "\x88\xa2",
  [0x0763] = "\x88\xa3", [0x0764] = "\x88\xa4", [0x0765] = "\x88\xa5",
  [0x0766] = "\x88\xa6", [0x0767] = "\x88\xa7", [0x0768] = "\x88\xa8",
  [0x0769] = "\x88\xa9", [0x076a] = "\x88\xaa", [0x076b] = "\x88\xab",
  [0x076c] = "\x88\xac", [0x076d] = "\x88\xad", [0x076e] = "\x88\xae",
  [0x076f] = "\x88\xaf", [0x0770] = "\x88\xb0", [0x0771] = "\x88\xb1",
  [0x0772] = "\x88\xb2", [0x0773] = "\x88\xb3", [0x0774] = "\x88\xb4",
  [0x0775] = "\x88\xb5", [0x0776] = "\x88\xb6", [0x0777] = "\x88\xb7",
  [0x0778] = "\x88\xb8", [0x0779] = "\x88\xb9", [0x077a] = "\x88\xba",
  [0x077b] = "\x88\xbb", [0x077c] = "\x88\xbc", [0x077d] = "\x88\xbd",
  [0x077e] = "\x88\xbe", [0x077f] = "\x88\xbf", [0x0780] = "\x88\xc0",
  [0x0781] = "\x88\xc1", [0x0782] = "\x88\xc2", [0x0783] = "\x88\xc3",
  [0x0784] = "\x88\xc4", [0x0785] = "\x88\xc5", [0x0786] = "\x88\xc6",
  [0x0787] = "\x88\xc7", [0x0788] = "\x88\xc8", [0x0789] = "\x88\xc9",
  [0x078a] = "\x88\xca", [0x078b] = "\x88\xcb", [0x078c] = "\x88\xcc",
  [0x078d] = "\x88\xcd", [0x078e] = "\x88\xce", [0x078f] = "\x88\xcf",
  [0x0790] = "\x88\xd0", [0x0791] = "\x88\xd1", [0x0792] = "\x88\xd2",
  [0x0793] = "\x88\xd3", [0x0794] = "\x88\xd4", [0x0795] = "\x88\xd5",
  [0x0796] = "\x88\xd6", [0x0797] = "\x88\xd7", [0x0798] = "\x88\xd8",
  [0x0799] = "\x88\xd9", [0x079a] = "\x88\xda", [0x079b] = "\x88\xdb",
  [0x079c] = "\x88\xdc", [0x079d] = "\x88\xdd", [0x079e] = "\x88\xde",
  [0x079f] = "\x88\xdf", [0x07a0] = "\x88\xe0", [0x07a1] = "\x88\xe1",
  [0x07a2] = "\x88\xe2", [0x07a3] = "\x88\xe3", [0x07a4] = "\x88\xe4",
  [0x07a5] = "\x88\xe5", [0x07a6] = "\x88\xe6", [0x07a7] = "\x88\xe7",
  [0x07a8] = "\x88\xe8", [0x07a9] = "\x88\xe9", [0x07aa] = "\x88\xea",
  [0x07ab] = "\x88\xeb", [0x07ac] = "\x88\xec", [0x07ad] = "\x88\xed",
  [0x07ae] = "\x88\xee", [0x07af] = "\x88\xef", [0x07b0] = "\x88\xf0",
  [0x07b1] = "\x88\xf1", [0x07b2] = "\x88\xf2", [0x07b3] = "\x88\xf3",
  [0x07b4] = "\x88\xf4", [0x07b5] = "\x88\xf5", [0x07b6] = "\x88\xf6",
  [0x07b7] = "\x88\xf7", [0x07b8] = "\x88\xf8", [0x07b9] = "\x88\xf9",
  [0x07ba] = "\x88\xfa", [0x07bb] = "\x88\xfb", [0x07bc] = "\x88\xfc",
  [0x07bd] = "\x88\xfd", [0x07be] = "\x88\xfe", [0x0800] = "\x89\x40",
  [0x0801] = "\x89\x41", [0x0802] = "\x89\x42", [0x0803] = "\x89\x43",
  [0x0804] = "\x89\x44", [0x0805] = "\x89\x45", [0x0806] = "\x89\x46",
  [0x0807] = "\x89\x47", [0x0808] = "\x89\x48", [0x0809] = "\x89\x49",
  [0x080a] = "\x89\x4a", [0x080b] = "\x89\x4b", [0x080c] = "\x89\x4c",
  [0x080d] = "\x89\x4d", [0x080e] = "\x89\x4e", [0x080f] = "\x89\x4f",
  [0x0810] = "\x89\x50", [0x0811] = "\x89\x51", [0x0812] = "\x89\x52",
  [0x0813] = "\x89\x53", [0x0814] = "\x89\x54", [0x0815] = "\x89\x55",
  [0x0816] = "\x89\x56", [0x0817] = "\x89\x57", [0x0818] = "\x89\x58",
  [0x0819] = "\x89\x59", [0x081a] = "\x89\x5a", [0x081b] = "\x89\x5b",
  [0x081c] = "\x89\x5c", [0x081d] = "\x89\x5d", [0x081e] = "\x89\x5e",
  [0x081f] = "\x89\x5f", [0x0820] = "\x89\x60", [0x0821] = "\x89\x61",
  [0x0822] = "\x89\x62", [0x0823] = "\x89\x63", [0x0824] = "\x89\x64",
  [0x0825] = "\x89\x65", [0x0826] = "\x89\x66", [0x0827] = "\x89\x67",
  [0x0828] = "\x89\x68", [0x0829] = "\x89\x69", [0x082a] = "\x89\x6a",
  [0x082b] = "\x89\x6b", [0x082c] = "\x89\x6c", [0x082d] = "\x89\x6d",
  [0x082e] = "\x89\x6e", [0x082f] = "\x89\x6f", [0x0830] = "\x89\x70",
  [0x0831] = "\x89\x71", [0x0832] = "\x89\x72", [0x0833] = "\x89\x73",
  [0x0834] = "\x89\x74", [0x0835] = "\x89\x75", [0x0836] = "\x89\x76",
  [0x0837] = "\x89\x77", [0x0838] = "\x89\x78", [0x0839] = "\x89\x79",
  [0x083a] = "\x89\x7a", [0x083b] = "\x89\x7b", [0x083c] = "\x89\x7c",
  [0x083d] = "\x89\x7d", [0x083e] = "\x89\x7e", [0x0840] = "\x89\x80",
  [0x0841] = "\x89\x81", [0x0842] = "\x89\x82", [0x0843] = "\x89\x83",
  [0x0844] = "\x89\x84", [0x0845] = "\x89\x85", [0x0846] = "\x89\x86",
  [0x0847] = "\x89\x87", [0x0848] = "\x89\x88", [0x0849] = "\x89\x89",
  [0x084a] = "\x89\x8a", [0x084b] = "\x89\x8b", [0x084c] = "\x89\x8c",
  [0x084d] = "\x89\x8d", [0x084e] = "\x89\x8e", [0x084f] = "\x89\x8f",
  [0x0850] = "\x89\x90", [0x0851] = "\x89\x91", [0x0852] = "\x89\x92",
  [0x0853] = "\x89\x93", [0x0854] = "\x89\x94", [0x0855] = "\x89\x95",
  [0x0856] = "\x89\x96", [0x0857] = "\x89\x97", [0x0858] = "\x89\x98",
  [0x0859] = "\x89\x99", [0x085a] = "\x89\x9a", [0x085b] = "\x89\x9b",
  [0x085c] = "\x89\x9c", [0x085d] = "\x89\x9d", [0x085e] = "\x89\x9e",
  [0x085f] = "\x89\x9f", [0x0860] = "\x89\xa0", [0x0861] = "\x89\xa1",
  [0x0862] = "\x89\xa2", [0x0863] = "\x89\xa3", [0x0864] = "\x89\xa4",
  [0x0865] = "\x89\xa5", [0x0866] = "\x89\xa6", [0x0867] = "\x89\xa7",
  [0x0868] = "\x89\xa8", [0x0869] = "\x89\xa9", [0x086a] = "\x89\xaa",
  [0x086b] = "\x89\xab", [0x086c] = "\x89\xac", [0x086d] = "\x89\xad",
  [0x086e] = "\x89\xae", [0x086f] = "\x89\xaf", [0x0870] = "\x89\xb0",
  [0x0871] = "\x89\xb1", [0x0872] = "\x89\xb2", [0x0873] = "\x89\xb3",
  [0x0874] = "\x89\xb4", [0x0875] = "\x89\xb5", [0x0876] = "\x89\xb6",
  [0x0877] = "\x89\xb7", [0x0878] = "\x89\xb8", [0x0879] = "\x89\xb9",
  [0x087a] = "\x89\xba", [0x087b] = "\x89\xbb", [0x087c] = "\x89\xbc",
  [0x087d] = "\x89\xbd", [0x087e] = "\x89\xbe", [0x087f] = "\x89\xbf",
  [0x0880] = "\x89\xc0", [0x0881] = "\x89\xc1", [0x0882] = "\x89\xc2",
  [0x0883] = "\x89\xc3", [0x0884] = "\x89\xc4", [0x0885] = "\x89\xc5",
  [0x0886] = "\x89\xc6", [0x0887] = "\x89\xc7", [0x0888] = "\x89\xc8",
  [0x0889] = "\x89\xc9", [0x088a] = "\x89\xca", [0x088b] = "\x89\xcb",
  [0x088c] = "\x89\xcc", [0x088d] = "\x89\xcd", [0x088e] = "\x89\xce",
  [0x088f] = "\x89\xcf", [0x0890] = "\x89\xd0", [0x0891] = "\x89\xd1",
  [0x0892] = "\x89\xd2", [0x0893] = "\x89\xd3", [0x0894] = "\x89\xd4",
  [0x0895] = "\x89\xd5", [0x0896] = "\x89\xd6", [0x0897] = "\x89\xd7",
  [0x0898] = "\x89\xd8", [0x0899] = "\x89\xd9", [0x089a] = "\x89\xda",
  [0x089b] = "\x89\xdb", [0x089c] = "\x89\xdc", [0x089d] = "\x89\xdd",
  [0x089e] = "\x89\xde", [0x089f] = "\x89\xdf", [0x08a0] = "\x89\xe0",
  [0x08a1] = "\x89\xe1", [0x08a2] = "\x89\xe2", [0x08a3] = "\x89\xe3",
  [0x08a4] = "\x89\xe4", [0x08a5] = "\x89\xe5", [0x08a6] = "\x89\xe6",
  [0x08a7] = "\x89\xe7", [0x08a8] = "\x89\xe8", [0x08a9] = "\x89\xe9",
  [0x08aa] = "\x89\xea", [0x08ab] = "\x89\xeb", [0x08ac] = "\x89\xec",
  [0x08ad] = "\x89\xed", [0x08ae] = "\x89\xee", [0x08af] = "\x89\xef",
  [0x08b0] = "\x89\xf0", [0x08b1] = "\x89\xf1", [0x08b2] = "\x89\xf2",
  [0x08b3] = "\x89\xf3", [0x08b4] = "\x89\xf4", [0x08b5] = "\x89\xf5",
  [0x08b6] = "\x89\xf6", [0x08b7] = "\x89\xf7", [0x08b8] = "\x89\xf8",
  [0x08b9] = "\x89\xf9", [0x08ba] = "\x89\xfa", [0x08bb] = "\x89\xfb",
  [0x08bc] = "\x89\xfc", [0x08bd] = "\x89\xfd", [0x08be] = "\x89\xfe",
  [0x0900] = "\x8a\x40", [0x0901] = "\x8a\x41", [0x0902] = "\x8a\x42",
  [0x0903] = "\x8a\x43", [0x0904] = "\x8a\x44", [0x0905] = "\x8a\x45",
  [0x0906] = "\x8a\x46", [0x0907] = "\x8a\x47", [0x0908] = "\x8a\x48",
  [0x0909] = "\x8a\x49", [0x090a] = "\x8a\x4a", [0x090b] = "\x8a\x4b",
  [0x090c] = "\x8a\x4c", [0x090d] = "\x8a\x4d", [0x090e] = "\x8a\x4e",
  [0x090f] = "\x8a\x4f", [0x0910] = "\x8a\x50", [0x0911] = "\x8a\x51",
  [0x0912] = "\x8a\x52", [0x0913] = "\x8a\x53", [0x0914] = "\x8a\x54",
  [0x0915] = "\x8a\x55", [0x0916] = "\x8a\x56", [0x0917] = "\x8a\x57",
  [0x0918] = "\x8a\x58", [0x0919] = "\x8a\x59", [0x091a] = "\x8a\x5a",
  [0x091b] = "\x8a\x5b", [0x091c] = "\x8a\x5c", [0x091d] = "\x8a\x5d",
  [0x091e] = "\x8a\x5e", [0x091f] = "\x8a\x5f", [0x0920] = "\x8a\x60",
  [0x0921] = "\x8a\x61", [0x0922] = "\x8a\x62", [0x0923] = "\x8a\x63",
  [0x0924] = "\x8a\x64", [0x0925] = "\x8a\x65", [0x0926] = "\x8a\x66",
  [0x0927] = "\x8a\x67", [0x0928] = "\x8a\x68", [0x0929] = "\x8a\x69",
  [0x092a] = "\x8a\x6a", [0x092b] = "\x8a\x6b", [0x092c] = "\x8a\x6c",
  [0x092d] = "\x8a\x6d", [0x092e] = "\x8a\x6e", [0x092f] = "\x8a\x6f",
  [0x0930] = "\x8a\x70", [0x0931] = "\x8a\x71", [0x0932] = "\x8a\x72",
  [0x0933] = "\x8a\x73", [0x0934] = "\x8a\x74", [0x0935] = "\x8a\x75",
  [0x0936] = "\x8a\x76", [0x0937] = "\x8a\x77", [0x0938] = "\x8a\x78",
  [0x0939] = "\x8a\x79", [0x093a] = "\x8a\x7a", [0x093b] = "\x8a\x7b",
  [0x093c] = "\x8a\x7c", [0x093d] = "\x8a\x7d", [0x093e] = "\x8a\x7e",
  [0x0940] = "\x8a\x80", [0x0941] = "\x8a\x81", [0x0942] = "\x8a\x82",
  [0x0943] = "\x8a\x83", [0x0944] = "\x8a\x84", [0x0945] = "\x8a\x85",
  [0x0946] = "\x8a\x86", [0x0947] = "\x8a\x87", [0x0948] = "\x8a\x88",
  [0x0949] = "\x8a\x89", [0x094a] = "\x8a\x8a", [0x094b] = "\x8a\x8b",
  [0x094c] = "\x8a\x8c", [0x094d] = "\x8a\x8d", [0x094e] = "\x8a\x8e",
  [0x094f] = "\x8a\x8f", [0x0950] = "\x8a\x90", [0x0951] = "\x8a\x91",
  [0x0952] = "\x8a\x92", [0x0953] = "\x8a\x93", [0x0954] = "\x8a\x94",
  [0x0955] = "\x8a\x95", [0x0956] = "\x8a\x96", [0x0957] = "\x8a\x97",
  [0x0958] = "\x8a\x98", [0x0959] = "\x8a\x99", [0x095a] = "\x8a\x9a",
  [0x095b] = "\x8a\x9b", [0x095c] = "\x8a\x9c", [0x095d] = "\x8a\x9d",
  [0x095e] = "\x8a\x9e", [0x095f] = "\x8a\x9f", [0x0960] = "\x8a\xa0",
  [0x0961] = "\x8a\xa1", [0x0962] = "\x8a\xa2", [0x0963] = "\x8a\xa3",
  [0x0964] = "\x8a\xa4", [0x0965] = "\x8a\xa5", [0x0966] = "\x8a\xa6",
  [0x0967] = "\x8a\xa7", [0x0968] = "\x8a\xa8", [0x0969] = "\x8a\xa9",
  [0x096a] = "\x8a\xaa", [0x096b] = "\x8a\xab", [0x096c] = "\x8a\xac",
  [0x096d] = "\x8a\xad", [0x096e] = "\x8a\xae", [0x096f] = "\x8a\xaf",
  [0x0970] = "\x8a\xb0", [0x0971] = "\x8a\xb1", [0x0972] = "\x8a\xb2",
  [0x0973] = "\x8a\xb3", [0x0974] = "\x8a\xb4", [0x0975] = "\x8a\xb5",
  [0x0976] = "\x8a\xb6", [0x0977] = "\x8a\xb7", [0x0978] = "\x8a\xb8",
  [0x0979] = "\x8a\xb9", [0x097a] = "\x8a\xba", [0x097b] = "\x8a\xbb",
  [0x097c] = "\x8a\xbc", [0x097d] = "\x8a\xbd", [0x097e] = "\x8a\xbe",
  [0x097f] = "\x8a\xbf", [0x0980] = "\x8a\xc0", [0x0981] = "\x8a\xc1",
  [0x0982] = "\x8a\xc2", [0x0983] = "\x8a\xc3", [0x0984] = "\x8a\xc4",
  [0x0985] = "\x8a\xc5", [0x0986] = "\x8a\xc6", [0x0987] = "\x8a\xc7",
  [0x0988] = "\x8a\xc8", [0x0989] = "\x8a\xc9", [0x098a] = "\x8a\xca",
  [0x098b] = "\x8a\xcb", [0x098c] = "\x8a\xcc", [0x098d] = "\x8a\xcd",
  [0x098e] = "\x8a\xce", [0x098f] = "\x8a\xcf", [0x0990] = "\x8a\xd0",
  [0x0991] = "\x8a\xd1", [0x0992] = "\x8a\xd2", [0x0993] = "\x8a\xd3",
  [0x0994] = "\x8a\xd4", [0x0995] = "\x8a\xd5", [0x0996] = "\x8a\xd6",
  [0x0997] = "\x8a\xd7", [0x0998] = "\x8a\xd8", [0x0999] = "\x8a\xd9",
  [0x099a] = "\x8a\xda", [0x099b] = "\x8a\xdb", [0x099c] = "\x8a\xdc",
  [0x099d] = "\x8a\xdd", [0x099e] = "\x8a\xde", [0x099f] = "\x8a\xdf",
  [0x09a0] = "\x8a\xe0", [0x09a1] = "\x8a\xe1", [0x09a2] = "\x8a\xe2",
  [0x09a3] = "\x8a\xe3", [0x09a4] = "\x8a\xe4", [0x09a5] = "\x8a\xe5",
  [0x09a6] = "\x8a\xe6", [0x09a7] = "\x8a\xe7", [0x09a8] = "\x8a\xe8",
  [0x09a9] = "\x8a\xe9", [0x09aa] = "\x8a\xea", [0x09ab] = "\x8a\xeb",
  [0x09ac] = "\x8a\xec", [0x09ad] = "\x8a\xed", [0x09ae] = "\x8a\xee",
  [0x09af] = "\x8a\xef", [0x09b0] = "\x8a\xf0", [0x09b1] = "\x8a\xf1",
  [0x09b2] = "\x8a\xf2", [0x09b3] = "\x8a\xf3", [0x09b4] = "\x8a\xf4",
  [0x09b5] = "\x8a\xf5", [0x09b6] = "\x8a\xf6", [0x09b7] = "\x8a\xf7",
  [0x09b8] = "\x8a\xf8", [0x09b9] = "\x8a\xf9", [0x09ba] = "\x8a\xfa",
  [0x09bb] = "\x8a\xfb", [0x09bc] = "\x8a\xfc", [0x09bd] = "\x8a\xfd",
  [0x09be] = "\x8a\xfe", [0x0a00] = "\x8b\x40", [0x0a01] = "\x8b\x41",
  [0x0a02] = "\x8b\x42", [0x0a03] = "\x8b\x43", [0x0a04] = "\x8b\x44",
  [0x0a05] = "\x8b\x45", [0x0a06] = "\x8b\x46", [0x0a07] = "\x8b\x47",
  [0x0a08] = "\x8b\x48", [0x0a09] = "\x8b\x49", [0x0a0a] = "\x8b\x4a",
  [0x0a0b] = "\x8b\x4b", [0x0a0c] = "\x8b\x4c", [0x0a0d] = "\x8b\x4d",
  [0x0a0e] = "\x8b\x4e", [0x0a0f] = "\x8b\x4f", [0x0a10] = "\x8b\x50",
  [0x0a11] = "\x8b\x51", [0x0a12] = "\x8b\x52", [0x0a13] = "\x8b\x53",
  [0x0a14] = "\x8b\x54", [0x0a15] = "\x8b\x55", [0x0a16] = "\x8b\x56",
  [0x0a17] = "\x8b\x57", [0x0a18] = "\x8b\x58", [0x0a19] = "\x8b\x59",
  [0x0a1a] = "\x8b\x5a", [0x0a1b] = "\x8b\x5b", [0x0a1c] = "\x8b\x5c",
  [0x0a1d] = "\x8b\x5d", [0x0a1e] = "\x8b\x5e", [0x0a1f] = "\x8b\x5f",
  [0x0a20] = "\x8b\x60", [0x0a21] = "\x8b\x61", [0x0a22] = "\x8b\x62",
  [0x0a23] = "\x8b\x63", [0x0a24] = "\x8b\x64", [0x0a25] = "\x8b\x65",
  [0x0a26] = "\x8b\x66", [0x0a27] = "\x8b\x67", [0x0a28] = "\x8b\x68",
  [0x0a29] = "\x8b\x69", [0x0a2a] = "\x8b\x6a", [0x0a2b] = "\x8b\x6b",
  [0x0a2c] = "\x8b\x6c", [0x0a2d] = "\x8b\x6d", [0x0a2e] = "\x8b\x6e",
  [0x0a2f] = "\x8b\x6f", [0x0a30] = "\x8b\x70", [0x0a31] = "\x8b\x71",
  [0x0a32] = "\x8b\x72", [0x0a33] = "\x8b\x73", [0x0a34] = "\x8b\x74",
  [0x0a35] = "\x8b\x75", [0x0a36] = "\x8b\x76", [0x0a37] = "\x8b\x77",
  [0x0a38] = "\x8b\x78", [0x0a39] = "\x8b\x79", [0x0a3a] = "\x8b\x7a",
  [0x0a3b] = "\x8b\x7b", [0x0a3c] = "\x8b\x7c", [0x0a3d] = "\x8b\x7d",
  [0x0a3e] = "\x8b\x7e", [0x0a40] = "\x8b\x80", [0x0a41] = "\x8b\x81",
  [0x0a42] = "\x8b\x82", [0x0a43] = "\x8b\x83", [0x0a44] = "\x8b\x84",
  [0x0a45] = "\x8b\x85", [0x0a46] = "\x8b\x86", [0x0a47] = "\x8b\x87",
  [0x0a48] = "\x8b\x88", [0x0a49] = "\x8b\x89", [0x0a4a] = "\x8b\x8a",
  [0x0a4b] = "\x8b\x8b", [0x0a4c] = "\x8b\x8c", [0x0a4d] = "\x8b\x8d",
  [0x0a4e] = "\x8b\x8e", [0x0a4f] = "\x8b\x8f", [0x0a50] = "\x8b\x90",
  [0x0a51] = "\x8b\x91", [0x0a52] = "\x8b\x92", [0x0a53] = "\x8b\x93",
  [0x0a54] = "\x8b\x94", [0x0a55] = "\x8b\x95", [0x0a56] = "\x8b\x96",
  [0x0a57] = "\x8b\x97", [0x0a58] = "\x8b\x98", [0x0a59] = "\x8b\x99",
  [0x0a5a] = "\x8b\x9a", [0x0a5b] = "\x8b\x9b", [0x0a5c] = "\x8b\x9c",
  [0x0a5d] = "\x8b\x9d", [0x0a5e] = "\x8b\x9e", [0x0a5f] = "\x8b\x9f",
  [0x0a60] = "\x8b\xa0", [0x0a61] = "\x8b\xa1", [0x0a62] = "\x8b\xa2",
  [0x0a63] = "\x8b\xa3", [0x0a64] = "\x8b\xa4", [0x0a65] = "\x8b\xa5",
  [0x0a66] = "\x8b\xa6", [0x0a67] = "\x8b\xa7", [0x0a68] = "\x8b\xa8",
  [0x0a69] = "\x8b\xa9", [0x0a6a] = "\x8b\xaa", [0x0a6b] = "\x8b\xab",
  [0x0a6c] = "\x8b\xac", [0x0a6d] = "\x8b\xad", [0x0a6e] = "\x8b\xae",
  [0x0a6f] = "\x8b\xaf", [0x0a70] = "\x8b\xb0", [0x0a71] = "\x8b\xb1",
  [0x0a72] = "\x8b\xb2", [0x0a73] = "\x8b\xb3", [0x0a74] = "\x8b\xb4",
  [0x0a75] = "\x8b\xb5", [0x0a76] = "\x8b\xb6", [0x0a77] = "\x8b\xb7",
  [0x0a78] = "\x8b\xb8", [0x0a79] = "\x8b\xb9", [0x0a7a] = "\x8b\xba",
  [0x0a7b] = "\x8b\xbb", [0x0a7c] = "\x8b\xbc", [0x0a7d] = "\x8b\xbd",
  [0x0a7e] = "\x8b\xbe", [0x0a7f] = "\x8b\xbf", [0x0a80] = "\x8b\xc0",
  [0x0a81] = "\x8b\xc1", [0x0a82] = "\x8b\xc2", [0x0a83] = "\x8b\xc3",
  [0x0a84] = "\x8b\xc4", [0x0a85] = "\x8b\xc5", [0x0a86] = "\x8b\xc6",
  [0x0a87] = "\x8b\xc7", [0x0a88] = "\x8b\xc8", [0x0a89] = "\x8b\xc9",
  [0x0a8a] = "\x8b\xca", [0x0a8b] = "\x8b\xcb", [0x0a8c] = "\x8b\xcc",
  [0x0a8d] = "\x8b\xcd", [0x0a8e] = "\x8b\xce", [0x0a8f] = "\x8b\xcf",
  [0x0a90] = "\x8b\xd0", [0x0a91] = "\x8b\xd1", [0x0a92] = "\x8b\xd2",
  [0x0a93] = "\x8b\xd3", [0x0a94] = "\x8b\xd4", [0x0a95] = "\x8b\xd5",
  [0x0a96] = "\x8b\xd6", [0x0a97] = "\x8b\xd7", [0x0a98] = "\x8b\xd8",
  [0x0a99] = "\x8b\xd9", [0x0a9a] = "\x8b\xda", [0x0a9b] = "\x8b\xdb",
  [0x0a9c] = "\x8b\xdc", [0x0a9d] = "\x8b\xdd", [0x0a9e] = "\x8b\xde",
  [0x0a9f] = "\x8b\xdf", [0x0aa0] = "\x8b\xe0", [0x0aa1] = "\x8b\xe1",
  [0x0aa2] = "\x8b\xe2", [0x0aa3] = "\x8b\xe3", [0x0aa4] = "\x8b\xe4",
  [0x0aa5] = "\x8b\xe5", [0x0aa6] = "\x8b\xe6", [0x0aa7] = "\x8b\xe7",
  [0x0aa8] = "\x8b\xe8", [0x0aa9] = "\x8b\xe9", [0x0aaa] = "\x8b\xea",
  [0x0aab] = "\x8b\xeb", [0x0aac] = "\x8b\xec", [0x0aad] = "\x8b\xed",
  [0x0aae] = "\x8b\xee", [0x0aaf] = "\x8b\xef", [0x0ab0] = "\x8b\xf0",
  [0x0ab1] = "\x8b\xf1", [0x0ab2] = "\x8b\xf2", [0x0ab3] = "\x8b\xf3",
  [0x0ab4] = "\x8b\xf4", [0x0ab5] = "\x8b\xf5", [0x0ab6] = "\x8b\xf6",
  [0x0ab7] = "\x8b\xf7", [0x0ab8] = "\x8b\xf8", [0x0ab9] = "\x8b\xf9",
  [0x0aba] = "\x8b\xfa", [0x0abb] = "\x8b\xfb", [0x0abc] = "\x8b\xfc",
  [0x0abd] = "\x8b\xfd", [0x0abe] = "\x8b\xfe", [0x0b00] = "\x8c\x40",
  [0x0b01] = "\x8c\x41", [0x0b02] = "\x8c\x42", [0x0b03] = "\x8c\x43",
  [0x0b04] = "\x8c\x44", [0x0b05] = "\x8c\x45", [0x0b06] = "\x8c\x46",
  [0x0b07] = "\x8c\x47", [0x0b08] = "\x8c\x48", [0x0b09] = "\x8c\x49",
  [0x0b0a] = "\x8c\x4a", [0x0b0b] = "\x8c\x4b", [0x0b0c] = "\x8c\x4c",
  [0x0b0d] = "\x8c\x4d", [0x0b0e] = "\x8c\x4e", [0x0b0f] = "\x8c\x4f",
  [0x0b10] = "\x8c\x50", [0x0b11] = "\x8c\x51", [0x0b12] = "\x8c\x52",
  [0x0b13] = "\x8c\x53", [0x0b14] = "\x8c\x54", [0x0b15] = "\x8c\x55",
  [0x0b16] = "\x8c\x56", [0x0b17] = "\x8c\x57", [0x0b18] = "\x8c\x58",
  [0x0b19] = "\x8c\x59", [0x0b1a] = "\x8c\x5a", [0x0b1b] = "\x8c\x5b",
  [0x0b1c] = "\x8c\x5c", [0x0b1d] = "\x8c\x5d", [0x0b1e] = "\x8c\x5e",
  [0x0b1f] = "\x8c\x5f", [0x0b20] = "\x8c\x60", [0x0b21] = "\x8c\x61",
  [0x0b22] = "\x8c\x62", [0x0b23] = "\x8c\x63", [0x0b24] = "\x8c\x64",
  [0x0b25] = "\x8c\x65", [0x0b26] = "\x8c\x66", [0x0b27] = "\x8c\x67",
  [0x0b28] = "\x8c\x68", [0x0b29] = "\x8c\x69", [0x0b2a] = "\x8c\x6a",
  [0x0b2b] = "\x8c\x6b", [0x0b2c] = "\x8c\x6c", [0x0b2d] = "\x8c\x6d",
  [0x0b2e] = "\x8c\x6e", [0x0b2f] = "\x8c\x6f", [0x0b30] = "\x8c\x70",
  [0x0b31] = "\x8c\x71", [0x0b32] = "\x8c\x72", [0x0b33] = "\x8c\x73",
  [0x0b34] = "\x8c\x74", [0x0b35] = "\x8c\x75", [0x0b36] = "\x8c\x76",
  [0x0b37] = "\x8c\x77", [0x0b38] = "\x8c\x78", [0x0b39] = "\x8c\x79",
  [0x0b3a] = "\x8c\x7a", [0x0b3b] = "\x8c\x7b", [0x0b3c] = "\x8c\x7c",
  [0x0b3d] = "\x8c\x7d", [0x0b3e] = "\x8c\x7e", [0x0b40] = "\x8c\x80",
  [0x0b41] = "\x8c\x81", [0x0b42] = "\x8c\x82", [0x0b43] = "\x8c\x83",
  [0x0b44] = "\x8c\x84", [0x0b45] = "\x8c\x85", [0x0b46] = "\x8c\x86",
  [0x0b47] = "\x8c\x87", [0x0b48] = "\x8c\x88", [0x0b49] = "\x8c\x89",
  [0x0b4a] = "\x8c\x8a", [0x0b4b] = "\x8c\x8b", [0x0b4c] = "\x8c\x8c",
  [0x0b4d] = "\x8c\x8d", [0x0b4e] = "\x8c\x8e", [0x0b4f] = "\x8c\x8f",
  [0x0b50] = "\x8c\x90", [0x0b51] = "\x8c\x91", [0x0b52] = "\x8c\x92",
  [0x0b53] = "\x8c\x93", [0x0b54] = "\x8c\x94", [0x0b55] = "\x8c\x95",
  [0x0b56] = "\x8c\x96", [0x0b57] = "\x8c\x97", [0x0b58] = "\x8c\x98",
  [0x0b59] = "\x8c\x99", [0x0b5a] = "\x8c\x9a", [0x0b5b] = "\x8c\x9b",
  [0x0b5c] = "\x8c\x9c", [0x0b5d] = "\x8c\x9d", [0x0b5e] = "\x8c\x9e",
  [0x0b5f] = "\x8c\x9f", [0x0b60] = "\x8c\xa0", [0x0b61] = "\x8c\xa1",
  [0x0b62] = "\x8c\xa2", [0x0b63] = "\x8c\xa3", [0x0b64] = "\x8c\xa4",
  [0x0b65] = "\x8c\xa5", [0x0b66] = "\x8c\xa6", [0x0b67] = "\x8c\xa7",
  [0x0b68] = "\x8c\xa8", [0x0b69] = "\x8c\xa9", [0x0b6a] = "\x8c\xaa",
  [0x0b6b] = "\x8c\xab", [0x0b6c] = "\x8c\xac", [0x0b6d] = "\x8c\xad",
  [0x0b6e] = "\x8c\xae", [0x0b6f] = "\x8c\xaf", [0x0b70] = "\x8c\xb0",
  [0x0b71] = "\x8c\xb1", [0x0b72] = "\x8c\xb2", [0x0b73] = "\x8c\xb3",
  [0x0b74] = "\x8c\xb4", [0x0b75] = "\x8c\xb5", [0x0b76] = "\x8c\xb6",
  [0x0b77] = "\x8c\xb7", [0x0b78] = "\x8c\xb8", [0x0b79] = "\x8c\xb9",
  [0x0b7a] = "\x8c\xba", [0x0b7b] = "\x8c\xbb", [0x0b7c] = "\x8c\xbc",
  [0x0b7d] = "\x8c\xbd", [0x0b7e] = "\x8c\xbe", [0x0b7f] = "\x8c\xbf",
  [0x0b80] = "\x8c\xc0", [0x0b81] = "\x8c\xc1", [0x0b82] = "\x8c\xc2",
  [0x0b83] = "\x8c\xc3", [0x0b84] = "\x8c\xc4", [0x0b85] = "\x8c\xc5",
  [0x0b86] = "\x8c\xc6", [0x0b87] = "\x8c\xc7", [0x0b88] = "\x8c\xc8",
  [0x0b89] = "\x8c\xc9", [0x0b8a] = "\x8c\xca", [0x0b8b] = "\x8c\xcb",
  [0x0b8c] = "\x8c\xcc", [0x0b8d] = "\x8c\xcd", [0x0b8e] = "\x8c\xce",
  [0x0b8f] = "\x8c\xcf", [0x0b90] = "\x8c\xd0", [0x0b91] = "\x8c\xd1",
  [0x0b92] = "\x8c\xd2", [0x0b93] = "\x8c\xd3", [0x0b94] = "\x8c\xd4",
  [0x0b95] = "\x8c\xd5", [0x0b96] = "\x8c\xd6", [0x0b97] = "\x8c\xd7",
  [0x0b98] = "\x8c\xd8", [0x0b99] = "\x8c\xd9", [0x0b9a] = "\x8c\xda",
  [0x0b9b] = "\x8c\xdb", [0x0b9c] = "\x8c\xdc", [0x0b9d] = "\x8c\xdd",
  [0x0b9e] = "\x8c\xde", [0x0b9f] = "\x8c\xdf", [0x0ba0] = "\x8c\xe0",
  [0x0ba1] = "\x8c\xe1", [0x0ba2] = "\x8c\xe2", [0x0ba3] = "\x8c\xe3",
  [0x0ba4] = "\x8c\xe4", [0x0ba5] = "\x8c\xe5", [0x0ba6] = "\x8c\xe6",
  [0x0ba7] = "\x8c\xe7", [0x0ba8] = "\x8c\xe8", [0x0ba9] = "\x8c\xe9",
  [0x0baa] = "\x8c\xea", [0x0bab] = "\x8c\xeb", [0x0bac] = "\x8c\xec",
  [0x0bad] = "\x8c\xed", [0x0bae] = "\x8c\xee", [0x0baf] = "\x8c\xef",
  [0x0bb0] = "\x8c\xf0", [0x0bb1] = "\x8c\xf1", [0x0bb2] = "\x8c\xf2",
  [0x0bb3] = "\x8c\xf3", [0x0bb4] = "\x8c\xf4", [0x0bb5] = "\x8c\xf5",
  [0x0bb6] = "\x8c\xf6", [0x0bb7] = "\x8c\xf7", [0x0bb8] = "\x8c\xf8",
  [0x0bb9] = "\x8c\xf9", [0x0bba] = "\x8c\xfa", [0x0bbb] = "\x8c\xfb",
  [0x0bbc] = "\x8c\xfc", [0x0bbd] = "\x8c\xfd", [0x0bbe] = "\x8c\xfe",
  [0x0c00] = "\x8d\x40", [0x0c01] = "\x8d\x41", [0x0c02] = "\x8d\x42",
  [0x0c03] = "\x8d\x43", [0x0c04] = "\x8d\x44", [0x0c05] = "\x8d\x45",
  [0x0c06] = "\x8d\x46", [0x0c07] = "\x8d\x47", [0x0c08] = "\x8d\x48",
  [0x0c09] = "\x8d\x49", [0x0c0a] = "\x8d\x4a", [0x0c0b] = "\x8d\x4b",
  [0x0c0c] = "\x8d\x4c", [0x0c0d] = "\x8d\x4d", [0x0c0e] = "\x8d\x4e",
  [0x0c0f] = "\x8d\x4f", [0x0c10] = "\x8d\x50", [0x0c11] = "\x8d\x51",
  [0x0c12] = "\x8d\x52", [0x0c13] = "\x8d\x53", [0x0c14] = "\x8d\x54",
  [0x0c15] = "\x8d\x55", [0x0c16] = "\x8d\x56", [0x0c17] = "\x8d\x57",
  [0x0c18] = "\x8d\x58", [0x0c19] = "\x8d\x59", [0x0c1a] = "\x8d\x5a",
  [0x0c1b] = "\x8d\x5b", [0x0c1c] = "\x8d\x5c", [0x0c1d] = "\x8d\x5d",
  [0x0c1e] = "\x8d\x5e", [0x0c1f] = "\x8d\x5f", [0x0c20] = "\x8d\x60",
  [0x0c21] = "\x8d\x61", [0x0c22] = "\x8d\x62", [0x0c23] = "\x8d\x63",
  [0x0c24] = "\x8d\x64", [0x0c25] = "\x8d\x65", [0x0c26] = "\x8d\x66",
  [0x0c27] = "\x8d\x67", [0x0c28] = "\x8d\x68", [0x0c29] = "\x8d\x69",
  [0x0c2a] = "\x8d\x6a", [0x0c2b] = "\x8d\x6b", [0x0c2c] = "\x8d\x6c",
  [0x0c2d] = "\x8d\x6d", [0x0c2e] = "\x8d\x6e", [0x0c2f] = "\x8d\x6f",
  [0x0c30] = "\x8d\x70", [0x0c31] = "\x8d\x71", [0x0c32] = "\x8d\x72",
  [0x0c33] = "\x8d\x73", [0x0c34] = "\x8d\x74", [0x0c35] = "\x8d\x75",
  [0x0c36] = "\x8d\x76", [0x0c37] = "\x8d\x77", [0x0c38] = "\x8d\x78",
  [0x0c39] = "\x8d\x79", [0x0c3a] = "\x8d\x7a", [0x0c3b] = "\x8d\x7b",
  [0x0c3c] = "\x8d\x7c", [0x0c3d] = "\x8d\x7d", [0x0c3e] = "\x8d\x7e",
  [0x0c40] = "\x8d\x80", [0x0c41] = "\x8d\x81", [0x0c42] = "\x8d\x82",
  [0x0c43] = "\x8d\x83", [0x0c44] = "\x8d\x84", [0x0c45] = "\x8d\x85",
  [0x0c46] = "\x8d\x86", [0x0c47] = "\x8d\x87", [0x0c48] = "\x8d\x88",
  [0x0c49] = "\x8d\x89", [0x0c4a] = "\x8d\x8a", [0x0c4b] = "\x8d\x8b",
  [0x0c4c] = "\x8d\x8c", [0x0c4d] = "\x8d\x8d", [0x0c4e] = "\x8d\x8e",
  [0x0c4f] = "\x8d\x8f", [0x0c50] = "\x8d\x90", [0x0c51] = "\x8d\x91",
  [0x0c52] = "\x8d\x92", [0x0c53] = "\x8d\x93", [0x0c54] = "\x8d\x94",
  [0x0c55] = "\x8d\x95", [0x0c56] = "\x8d\x96", [0x0c57] = "\x8d\x97",
  [0x0c58] = "\x8d\x98", [0x0c59] = "\x8d\x99", [0x0c5a] = "\x8d\x9a",
  [0x0c5b] = "\x8d\x9b", [0x0c5c] = "\x8d\x9c", [0x0c5d] = "\x8d\x9d",
  [0x0c5e] = "\x8d\x9e", [0x0c5f] = "\x8d\x9f", [0x0c60] = "\x8d\xa0",
  [0x0c61] = "\x8d\xa1", [0x0c62] = "\x8d\xa2", [0x0c63] = "\x8d\xa3",
  [0x0c64] = "\x8d\xa4", [0x0c65] = "\x8d\xa5", [0x0c66] = "\x8d\xa6",
  [0x0c67] = "\x8d\xa7", [0x0c68] = "\x8d\xa8", [0x0c69] = "\x8d\xa9",
  [0x0c6a] = "\x8d\xaa", [0x0c6b] = "\x8d\xab", [0x0c6c] = "\x8d\xac",
  [0x0c6d] = "\x8d\xad", [0x0c6e] = "\x8d\xae", [0x0c6f] = "\x8d\xaf",
  [0x0c70] = "\x8d\xb0", [0x0c71] = "\x8d\xb1", [0x0c72] = "\x8d\xb2",
  [0x0c73] = "\x8d\xb3", [0x0c74] = "\x8d\xb4", [0x0c75] = "\x8d\xb5",
  [0x0c76] = "\x8d\xb6", [0x0c77] = "\x8d\xb7", [0x0c78] = "\x8d\xb8",
  [0x0c79] = "\x8d\xb9", [0x0c7a] = "\x8d\xba", [0x0c7b] = "\x8d\xbb",
  [0x0c7c] = "\x8d\xbc", [0x0c7d] = "\x8d\xbd", [0x0c7e] = "\x8d\xbe",
  [0x0c7f] = "\x8d\xbf", [0x0c80] = "\x8d\xc0", [0x0c81] = "\x8d\xc1",
  [0x0c82] = "\x8d\xc2", [0x0c83] = "\x8d\xc3", [0x0c84] = "\x8d\xc4",
  [0x0c85] = "\x8d\xc5", [0x0c86] = "\x8d\xc6", [0x0c87] = "\x8d\xc7",
  [0x0c88] = "\x8d\xc8", [0x0c89] = "\x8d\xc9", [0x0c8a] = "\x8d\xca",
  [0x0c8b] = "\x8d\xcb", [0x0c8c] = "\x8d\xcc", [0x0c8d] = "\x8d\xcd",
  [0x0c8e] = "\x8d\xce", [0x0c8f] = "\x8d\xcf", [0x0c90] = "\x8d\xd0",
  [0x0c91] = "\x8d\xd1", [0x0c92] = "\x8d\xd2", [0x0c93] = "\x8d\xd3",
  [0x0c94] = "\x8d\xd4", [0x0c95] = "\x8d\xd5", [0x0c96] = "\x8d\xd6",
  [0x0c97] = "\x8d\xd7", [0x0c98] = "\x8d\xd8", [0x0c99] = "\x8d\xd9",
  [0x0c9a] = "\x8d\xda", [0x0c9b] = "\x8d\xdb", [0x0c9c] = "\x8d\xdc",
  [0x0c9d] = "\x8d\xdd", [0x0c9e] = "\x8d\xde", [0x0c9f] = "\x8d\xdf",
  [0x0ca0] = "\x8d\xe0", [0x0ca1] = "\x8d\xe1", [0x0ca2] = "\x8d\xe2",
  [0x0ca3] = "\x8d\xe3", [0x0ca4] = "\x8d\xe4", [0x0ca5] = "\x8d\xe5",
  [0x0ca6] = "\x8d\xe6", [0x0ca7] = "\x8d\xe7", [0x0ca8] = "\x8d\xe8",
  [0x0ca9] = "\x8d\xe9", [0x0caa] = "\x8d\xea", [0x0cab] = "\x8d\xeb",
  [0x0cac] = "\x8d\xec", [0x0cad] = "\x8d\xed", [0x0cae] = "\x8d\xee",
  [0x0caf] = "\x8d\xef", [0x0cb0] = "\x8d\xf0", [0x0cb1] = "\x8d\xf1",
  [0x0cb2] = "\x8d\xf2", [0x0cb3] = "\x8d\xf3", [0x0cb4] = "\x8d\xf4",
  [0x0cb5] = "\x8d\xf5", [0x0cb6] = "\x8d\xf6", [0x0cb7] = "\x8d\xf7",
  [0x0cb8] = "\x8d\xf8", [0x0cb9] = "\x8d\xf9", [0x0cba] = "\x8d\xfa",
  [0x0cbb] = "\x8d\xfb", [0x0cbc] = "\x8d\xfc", [0x0cbd] = "\x8d\xfd",
  [0x0cbe] = "\x8d\xfe", [0x0d00] = "\x8e\x40", [0x0d01] = "\x8e\x41",
  [0x0d02] = "\x8e\x42", [0x0d03] = "\x8e\x43", [0x0d04] = "\x8e\x44",
  [0x0d05] = "\x8e\x45", [0x0d06] = "\x8e\x46", [0x0d07] = "\x8e\x47",
  [0x0d08] = "\x8e\x48", [0x0d09] = "\x8e\x49", [0x0d0a] = "\x8e\x4a",
  [0x0d0b] = "\x8e\x4b", [0x0d0c] = "\x8e\x4c", [0x0d0d] = "\x8e\x4d",
  [0x0d0e] = "\x8e\x4e", [0x0d0f] = "\x8e\x4f", [0x0d10] = "\x8e\x50",
  [0x0d11] = "\x8e\x51", [0x0d12] = "\x8e\x52", [0x0d13] = "\x8e\x53",
  [0x0d14] = "\x8e\x54", [0x0d15] = "\x8e\x55", [0x0d16] = "\x8e\x56",
  [0x0d17] = "\x8e\x57", [0x0d18] = "\x8e\x58", [0x0d19] = "\x8e\x59",
  [0x0d1a] = "\x8e\x5a", [0x0d1b] = "\x8e\x5b", [0x0d1c] = "\x8e\x5c",
  [0x0d1d] = "\x8e\x5d", [0x0d1e] = "\x8e\x5e", [0x0d1f] = "\x8e\x5f",
  [0x0d20] = "\x8e\x60", [0x0d21] = "\x8e\x61", [0x0d22] = "\x8e\x62",
  [0x0d23] = "\x8e\x63", [0x0d24] = "\x8e\x64", [0x0d25] = "\x8e\x65",
  [0x0d26] = "\x8e\x66", [0x0d27] = "\x8e\x67", [0x0d28] = "\x8e\x68",
  [0x0d29] = "\x8e\x69", [0x0d2a] = "\x8e\x6a", [0x0d2b] = "\x8e\x6b",
  [0x0d2c] = "\x8e\x6c", [0x0d2d] = "\x8e\x6d", [0x0d2e] = "\x8e\x6e",
  [0x0d2f] = "\x8e\x6f", [0x0d30] = "\x8e\x70", [0x0d31] = "\x8e\x71",
  [0x0d32] = "\x8e\x72", [0x0d33] = "\x8e\x73", [0x0d34] = "\x8e\x74",
  [0x0d35] = "\x8e\x75", [0x0d36] = "\x8e\x76", [0x0d37] = "\x8e\x77",
  [0x0d38] = "\x8e\x78", [0x0d39] = "\x8e\x79", [0x0d3a] = "\x8e\x7a",
  [0x0d3b] = "\x8e\x7b", [0x0d3c] = "\x8e\x7c", [0x0d3d] = "\x8e\x7d",
  [0x0d3e] = "\x8e\x7e", [0x0d40] = "\x8e\x80", [0x0d41] = "\x8e\x81",
  [0x0d42] = "\x8e\x82", [0x0d43] = "\x8e\x83", [0x0d44] = "\x8e\x84",
  [0x0d45] = "\x8e\x85", [0x0d46] = "\x8e\x86", [0x0d47] = "\x8e\x87",
  [0x0d48] = "\x8e\x88", [0x0d49] = "\x8e\x89", [0x0d4a] = "\x8e\x8a",
  [0x0d4b] = "\x8e\x8b", [0x0d4c] = "\x8e\x8c", [0x0d4d] = "\x8e\x8d",
  [0x0d4e] = "\x8e\x8e", [0x0d4f] = "\x8e\x8f", [0x0d50] = "\x8e\x90",
  [0x0d51] = "\x8e\x91", [0x0d52] = "\x8e\x92", [0x0d53] = "\x8e\x93",
  [0x0d54] = "\x8e\x94", [0x0d55] = "\x8e\x95", [0x0d56] = "\x8e\x96",
  [0x0d57] = "\x8e\x97", [0x0d58] = "\x8e\x98", [0x0d59] = "\x8e\x99",
  [0x0d5a] = "\x8e\x9a", [0x0d5b] = "\x8e\x9b", [0x0d5c] = "\x8e\x9c",
  [0x0d5d] = "\x8e\x9d", [0x0d5e] = "\x8e\x9e", [0x0d5f] = "\x8e\x9f",
  [0x0d60] = "\x8e\xa0", [0x0d61] = "\x8e\xa1", [0x0d62] = "\x8e\xa2",
  [0x0d63] = "\x8e\xa3", [0x0d64] = "\x8e\xa4", [0x0d65] = "\x8e\xa5",
  [0x0d66] = "\x8e\xa6", [0x0d67] = "\x8e\xa7", [0x0d68] = "\x8e\xa8",
  [0x0d69] = "\x8e\xa9", [0x0d6a] = "\x8e\xaa", [0x0d6b] = "\x8e\xab",
  [0x0d6c] = "\x8e\xac", [0x0d6d] = "\x8e\xad", [0x0d6e] = "\x8e\xae",
  [0x0d6f] = "\x8e\xaf", [0x0d70] = "\x8e\xb0", [0x0d71] = "\x8e\xb1",
  [0x0d72] = "\x8e\xb2", [0x0d73] = "\x8e\xb3", [0x0d74] = "\x8e\xb4",
  [0x0d75] = "\x8e\xb5", [0x0d76] = "\x8e\xb6", [0x0d77] = "\x8e\xb7",
  [0x0d78] = "\x8e\xb8", [0x0d79] = "\x8e\xb9", [0x0d7a] = "\x8e\xba",
  [0x0d7b] = "\x8e\xbb", [0x0d7c] = "\x8e\xbc", [0x0d7d] = "\x8e\xbd",
  [0x0d7e] = "\x8e\xbe", [0x0d7f] = "\x8e\xbf", [0x0d80] = "\x8e\xc0",
  [0x0d81] = "\x8e\xc1", [0x0d82] = "\x8e\xc2", [0x0d83] = "\x8e\xc3",
  [0x0d84] = "\x8e\xc4", [0x0d85] = "\x8e\xc5", [0x0d86] = "\x8e\xc6",
  [0x0d87] = "\x8e\xc7", [0x0d88] = "\x8e\xc8", [0x0d89] = "\x8e\xc9",
  [0x0d8a] = "\x8e\xca", [0x0d8b] = "\x8e\xcb", [0x0d8c] = "\x8e\xcc",
  [0x0d8d] = "\x8e\xcd", [0x0d8e] = "\x8e\xce", [0x0d8f] = "\x8e\xcf",
  [0x0d90] = "\x8e\xd0", [0x0d91] = "\x8e\xd1", [0x0d92] = "\x8e\xd2",
  [0x0d93] = "\x8e\xd3", [0x0d94] = "\x8e\xd4", [0x0d95] = "\x8e\xd5",
  [0x0d96] = "\x8e\xd6", [0x0d97] = "\x8e\xd7", [0x0d98] = "\x8e\xd8",
  [0x0d99] = "\x8e\xd9", [0x0d9a] = "\x8e\xda", [0x0d9b] = "\x8e\xdb",
  [0x0d9c] = "\x8e\xdc", [0x0d9d] = "\x8e\xdd", [0x0d9e] = "\x8e\xde",
  [0x0d9f] = "\x8e\xdf", [0x0da0] = "\x8e\xe0", [0x0da1] = "\x8e\xe1",
  [0x0da2] = "\x8e\xe2", [0x0da3] = "\x8e\xe3", [0x0da4] = "\x8e\xe4",
  [0x0da5] = "\x8e\xe5", [0x0da6] = "\x8e\xe6", [0x0da7] = "\x8e\xe7",
  [0x0da8] = "\x8e\xe8", [0x0da9] = "\x8e\xe9", [0x0daa] = "\x8e\xea",
  [0x0dab] = "\x8e\xeb", [0x0dac] = "\x8e\xec", [0x0dad] = "\x8e\xed",
  [0x0dae] = "\x8e\xee", [0x0daf] = "\x8e\xef", [0x0db0] = "\x8e\xf0",
  [0x0db1] = "\x8e\xf1", [0x0db2] = "\x8e\xf2", [0x0db3] = "\x8e\xf3",
  [0x0db4] = "\x8e\xf4", [0x0db5] = "\x8e\xf5", [0x0db6] = "\x8e\xf6",
  [0x0db7] = "\x8e\xf7", [0x0db8] = "\x8e\xf8", [0x0db9] = "\x8e\xf9",
  [0x0dba] = "\x8e\xfa", [0x0dbb] = "\x8e\xfb", [0x0dbc] = "\x8e\xfc",
  [0x0dbd] = "\x8e\xfd", [0x0dbe] = "\x8e\xfe", [0x0e00] = "\x8f\x40",
  [0x0e01] = "\x8f\x41", [0x0e02] = "\x8f\x42", [0x0e03] = "\x8f\x43",
  [0x0e04] = "\x8f\x44", [0x0e05] = "\x8f\x45", [0x0e06] = "\x8f\x46",
  [0x0e07] = "\x8f\x47", [0x0e08] = "\x8f\x48", [0x0e09] = "\x8f\x49",
  [0x0e0a] = "\x8f\x4a", [0x0e0b] = "\x8f\x4b", [0x0e0c] = "\x8f\x4c",
  [0x0e0d] = "\x8f\x4d", [0x0e0e] = "\x8f\x4e", [0x0e0f] = "\x8f\x4f",
  [0x0e10] = "\x8f\x50", [0x0e11] = "\x8f\x51", [0x0e12] = "\x8f\x52",
  [0x0e13] = "\x8f\x53", [0x0e14] = "\x8f\x54", [0x0e15] = "\x8f\x55",
  [0x0e16] = "\x8f\x56", [0x0e17] = "\x8f\x57", [0x0e18] = "\x8f\x58",
  [0x0e19] = "\x8f\x59", [0x0e1a] = "\x8f\x5a", [0x0e1b] = "\x8f\x5b",
  [0x0e1c] = "\x8f\x5c", [0x0e1d] = "\x8f\x5d", [0x0e1e] = "\x8f\x5e",
  [0x0e1f] = "\x8f\x5f", [0x0e20] = "\x8f\x60", [0x0e21] = "\x8f\x61",
  [0x0e22] = "\x8f\x62", [0x0e23] = "\x8f\x63", [0x0e24] = "\x8f\x64",
  [0x0e25] = "\x8f\x65", [0x0e26] = "\x8f\x66", [0x0e27] = "\x8f\x67",
  [0x0e28] = "\x8f\x68", [0x0e29] = "\x8f\x69", [0x0e2a] = "\x8f\x6a",
  [0x0e2b] = "\x8f\x6b", [0x0e2c] = "\x8f\x6c", [0x0e2d] = "\x8f\x6d",
  [0x0e2e] = "\x8f\x6e", [0x0e2f] = "\x8f\x6f", [0x0e30] = "\x8f\x70",
  [0x0e31] = "\x8f\x71", [0x0e32] = "\x8f\x72", [0x0e33] = "\x8f\x73",
  [0x0e34] = "\x8f\x74", [0x0e35] = "\x8f\x75", [0x0e36] = "\x8f\x76",
  [0x0e37] = "\x8f\x77", [0x0e38] = "\x8f\x78", [0x0e39] = "\x8f\x79",
  [0x0e3a] = "\x8f\x7a", [0x0e3b] = "\x8f\x7b", [0x0e3c] = "\x8f\x7c",
  [0x0e3d] = "\x8f\x7d", [0x0e3e] = "\x8f\x7e", [0x0e40] = "\x8f\x80",
  [0x0e41] = "\x8f\x81", [0x0e42] = "\x8f\x82", [0x0e43] = "\x8f\x83",
  [0x0e44] = "\x8f\x84", [0x0e45] = "\x8f\x85", [0x0e46] = "\x8f\x86",
  [0x0e47] = "\x8f\x87", [0x0e48] = "\x8f\x88", [0x0e49] = "\x8f\x89",
  [0x0e4a] = "\x8f\x8a", [0x0e4b] = "\x8f\x8b", [0x0e4c] = "\x8f\x8c",
  [0x0e4d] = "\x8f\x8d", [0x0e4e] = "\x8f\x8e", [0x0e4f] = "\x8f\x8f",
  [0x0e50] = "\x8f\x90", [0x0e51] = "\x8f\x91", [0x0e52] = "\x8f\x92",
  [0x0e53] = "\x8f\x93", [0x0e54] = "\x8f\x94", [0x0e55] = "\x8f\x95",
  [0x0e56] = "\x8f\x96", [0x0e57] = "\x8f\x97", [0x0e58] = "\x8f\x98",
  [0x0e59] = "\x8f\x99", [0x0e5a] = "\x8f\x9a", [0x0e5b] = "\x8f\x9b",
  [0x0e5c] = "\x8f\x9c", [0x0e5d] = "\x8f\x9d", [0x0e5e] = "\x8f\x9e",
  [0x0e5f] = "\x8f\x9f", [0x0e60] = "\x8f\xa0", [0x0e61] = "\x8f\xa1",
  [0x0e62] = "\x8f\xa2", [0x0e63] = "\x8f\xa3", [0x0e64] = "\x8f\xa4",
  [0x0e65] = "\x8f\xa5", [0x0e66] = "\x8f\xa6", [0x0e67] = "\x8f\xa7",
  [0x0e68] = "\x8f\xa8", [0x0e69] = "\x8f\xa9", [0x0e6a] = "\x8f\xaa",
  [0x0e6b] = "\x8f\xab", [0x0e6c] = "\x8f\xac", [0x0e6d] = "\x8f\xad",
  [0x0e6e] = "\x8f\xae", [0x0e6f] = "\x8f\xaf", [0x0e70] = "\x8f\xb0",
  [0x0e71] = "\x8f\xb1", [0x0e72] = "\x8f\xb2", [0x0e73] = "\x8f\xb3",
  [0x0e74] = "\x8f\xb4", [0x0e75] = "\x8f\xb5", [0x0e76] = "\x8f\xb6",
  [0x0e77] = "\x8f\xb7", [0x0e78] = "\x8f\xb8", [0x0e79] = "\x8f\xb9",
  [0x0e7a] = "\x8f\xba", [0x0e7b] = "\x8f\xbb", [0x0e7c] = "\x8f\xbc",
  [0x0e7d] = "\x8f\xbd", [0x0e7e] = "\x8f\xbe", [0x0e7f] = "\x8f\xbf",
  [0x0e80] = "\x8f\xc0", [0x0e81] = "\x8f\xc1", [0x0e82] = "\x8f\xc2",
  [0x0e83] = "\x8f\xc3", [0x0e84] = "\x8f\xc4", [0x0e85] = "\x8f\xc5",
  [0x0e86] = "\x8f\xc6", [0x0e87] = "\x8f\xc7", [0x0e88] = "\x8f\xc8",
  [0x0e89] = "\x8f\xc9", [0x0e8a] = "\x8f\xca", [0x0e8b] = "\x8f\xcb",
  [0x0e8c] = "\x8f\xcc", [0x0e8d] = "\x8f\xcd", [0x0e8e] = "\x8f\xce",
  [0x0e8f] = "\x8f\xcf", [0x0e90] = "\x8f\xd0", [0x0e91] = "\x8f\xd1",
  [0x0e92] = "\x8f\xd2", [0x0e93] = "\x8f\xd3", [0x0e94] = "\x8f\xd4",
  [0x0e95] = "\x8f\xd5", [0x0e96] = "\x8f\xd6", [0x0e97] = "\x8f\xd7",
  [0x0e98] = "\x8f\xd8", [0x0e99] = "\x8f\xd9", [0x0e9a] = "\x8f\xda",
  [0x0e9b] = "\x8f\xdb", [0x0e9c] = "\x8f\xdc", [0x0e9d] = "\x8f\xdd",
  [0x0e9e] = "\x8f\xde", [0x0e9f] = "\x8f\xdf", [0x0ea0] = "\x8f\xe0",
  [0x0ea1] = "\x8f\xe1", [0x0ea2] = "\x8f\xe2", [0x0ea3] = "\x8f\xe3",
  [0x0ea4] = "\x8f\xe4", [0x0ea5] = "\x8f\xe5", [0x0ea6] = "\x8f\xe6",
  [0x0ea7] = "\x8f\xe7", [0x0ea8] = "\x8f\xe8", [0x0ea9] = "\x8f\xe9",
  [0x0eaa] = "\x8f\xea", [0x0eab] = "\x8f\xeb", [0x0eac] = "\x8f\xec",
  [0x0ead] = "\x8f\xed", [0x0eae] = "\x8f\xee", [0x0eaf] = "\x8f\xef",
  [0x0eb0] = "\x8f\xf0", [0x0eb1] = "\x8f\xf1", [0x0eb2] = "\x8f\xf2",
  [0x0eb3] = "\x8f\xf3", [0x0eb4] = "\x8f\xf4", [0x0eb5] = "\x8f\xf5",
  [0x0eb6] = "\x8f\xf6", [0x0eb7] = "\x8f\xf7", [0x0eb8] = "\x8f\xf8",
  [0x0eb9] = "\x8f\xf9", [0x0eba] = "\x8f\xfa", [0x0ebb] = "\x8f\xfb",
  [0x0ebc] = "\x8f\xfc", [0x0ebd] = "\x8f\xfd", [0x0ebe] = "\x8f\xfe",
  [0x0f00] = "\x90\x40", [0x0f01] = "\x90\x41", [0x0f02] = "\x90\x42",
  [0x0f03] = "\x90\x43", [0x0f04] = "\x90\x44", [0x0f05] = "\x90\x45",
  [0x0f06] = "\x90\x46", [0x0f07] = "\x90\x47", [0x0f08] = "\x90\x48",
  [0x0f09] = "\x90\x49", [0x0f0a] = "\x90\x4a", [0x0f0b] = "\x90\x4b",
  [0x0f0c] = "\x90\x4c", [0x0f0d] = "\x90\x4d", [0x0f0e] = "\x90\x4e",
  [0x0f0f] = "\x90\x4f", [0x0f10] = "\x90\x50", [0x0f11] = "\x90\x51",
  [0x0f12] = "\x90\x52", [0x0f13] = "\x90\x53", [0x0f14] = "\x90\x54",
  [0x0f15] = "\x90\x55", [0x0f16] = "\x90\x56", [0x0f17] = "\x90\x57",
  [0x0f18] = "\x90\x58", [0x0f19] = "\x90\x59", [0x0f1a] = "\x90\x5a",
  [0x0f1b] = "\x90\x5b", [0x0f1c] = "\x90\x5c", [0x0f1d] = "\x90\x5d",
  [0x0f1e] = "\x90\x5e", [0x0f1f] = "\x90\x5f", [0x0f20] = "\x90\x60",
  [0x0f21] = "\x90\x61", [0x0f22] = "\x90\x62", [0x0f23] = "\x90\x63",
  [0x0f24] = "\x90\x64", [0x0f25] = "\x90\x65", [0x0f26] = "\x90\x66",
  [0x0f27] = "\x90\x67", [0x0f28] = "\x90\x68", [0x0f29] = "\x90\x69",
  [0x0f2a] = "\x90\x6a", [0x0f2b] = "\x90\x6b", [0x0f2c] = "\x90\x6c",
  [0x0f2d] = "\x90\x6d", [0x0f2e] = "\x90\x6e", [0x0f2f] = "\x90\x6f",
  [0x0f30] = "\x90\x70", [0x0f31] = "\x90\x71", [0x0f32] = "\x90\x72",
  [0x0f33] = "\x90\x73", [0x0f34] = "\x90\x74", [0x0f35] = "\x90\x75",
  [0x0f36] = "\x90\x76", [0x0f37] = "\x90\x77", [0x0f38] = "\x90\x78",
  [0x0f39] = "\x90\x79", [0x0f3a] = "\x90\x7a", [0x0f3b] = "\x90\x7b",
  [0x0f3c] = "\x90\x7c", [0x0f3d] = "\x90\x7d", [0x0f3e] = "\x90\x7e",
  [0x0f40] = "\x90\x80", [0x0f41] = "\x90\x81", [0x0f42] = "\x90\x82",
  [0x0f43] = "\x90\x83", [0x0f44] = "\x90\x84", [0x0f45] = "\x90\x85",
  [0x0f46] = "\x90\x86", [0x0f47] = "\x90\x87", [0x0f48] = "\x90\x88",
  [0x0f49] = "\x90\x89", [0x0f4a] = "\x90\x8a", [0x0f4b] = "\x90\x8b",
  [0x0f4c] = "\x90\x8c", [0x0f4d] = "\x90\x8d", [0x0f4e] = "\x90\x8e",
  [0x0f4f] = "\x90\x8f", [0x0f50] = "\x90\x90", [0x0f51] = "\x90\x91",
  [0x0f52] = "\x90\x92", [0x0f53] = "\x90\x93", [0x0f54] = "\x90\x94",
  [0x0f55] = "\x90\x95", [0x0f56] = "\x90\x96", [0x0f57] = "\x90\x97",
  [0x0f58] = "\x90\x98", [0x0f59] = "\x90\x99", [0x0f5a] = "\x90\x9a",
  [0x0f5b] = "\x90\x9b", [0x0f5c] = "\x90\x9c", [0x0f5d] = "\x90\x9d",
  [0x0f5e] = "\x90\x9e", [0x0f5f] = "\x90\x9f", [0x0f60] = "\x90\xa0",
  [0x0f61] = "\x90\xa1", [0x0f62] = "\x90\xa2", [0x0f63] = "\x90\xa3",
  [0x0f64] = "\x90\xa4", [0x0f65] = "\x90\xa5", [0x0f66] = "\x90\xa6",
  [0x0f67] = "\x90\xa7", [0x0f68] = "\x90\xa8", [0x0f69] = "\x90\xa9",
  [0x0f6a] = "\x90\xaa", [0x0f6b] = "\x90\xab", [0x0f6c] = "\x90\xac",
  [0x0f6d] = "\x90\xad", [0x0f6e] = "\x90\xae", [0x0f6f] = "\x90\xaf",
  [0x0f70] = "\x90\xb0", [0x0f71] = "\x90\xb1", [0x0f72] = "\x90\xb2",
  [0x0f73] = "\x90\xb3", [0x0f74] = "\x90\xb4", [0x0f75] = "\x90\xb5",
  [0x0f76] = "\x90\xb6", [0x0f77] = "\x90\xb7", [0x0f78] = "\x90\xb8",
  [0x0f79] = "\x90\xb9", [0x0f7a] = "\x90\xba", [0x0f7b] = "\x90\xbb",
  [0x0f7c] = "\x90\xbc", [0x0f7d] = "\x90\xbd", [0x0f7e] = "\x90\xbe",
  [0x0f7f] = "\x90\xbf", [0x0f80] = "\x90\xc0", [0x0f81] = "\x90\xc1",
  [0x0f82] = "\x90\xc2", [0x0f83] = "\x90\xc3", [0x0f84] = "\x90\xc4",
  [0x0f85] = "\x90\xc5", [0x0f86] = "\x90\xc6", [0x0f87] = "\x90\xc7",
  [0x0f88] = "\x90\xc8", [0x0f89] = "\x90\xc9", [0x0f8a] = "\x90\xca",
  [0x0f8b] = "\x90\xcb", [0x0f8c] = "\x90\xcc", [0x0f8d] = "\x90\xcd",
  [0x0f8e] = "\x90\xce", [0x0f8f] = "\x90\xcf", [0x0f90] = "\x90\xd0",
  [0x0f91] = "\x90\xd1", [0x0f92] = "\x90\xd2", [0x0f93] = "\x90\xd3",
  [0x0f94] = "\x90\xd4", [0x0f95] = "\x90\xd5", [0x0f96] = "\x90\xd6",
  [0x0f97] = "\x90\xd7", [0x0f98] = "\x90\xd8", [0x0f99] = "\x90\xd9",
  [0x0f9a] = "\x90\xda", [0x0f9b] = "\x90\xdb", [0x0f9c] = "\x90\xdc",
  [0x0f9d] = "\x90\xdd", [0x0f9e] = "\x90\xde", [0x0f9f] = "\x90\xdf",
  [0x0fa0] = "\x90\xe0", [0x0fa1] = "\x90\xe1", [0x0fa2] = "\x90\xe2",
  [0x0fa3] = "\x90\xe3", [0x0fa4] = "\x90\xe4", [0x0fa5] = "\x90\xe5",
  [0x0fa6] = "\x90\xe6", [0x0fa7] = "\x90\xe7", [0x0fa8] = "\x90\xe8",
  [0x0fa9] = "\x90\xe9", [0x0faa] = "\x90\xea", [0x0fab] = "\x90\xeb",
  [0x0fac] = "\x90\xec", [0x0fad] = "\x90\xed", [0x0fae] = "\x90\xee",
  [0x0faf] = "\x90\xef", [0x0fb0] = "\x90\xf0", [0x0fb1] = "\x90\xf1",
  [0x0fb2] = "\x90\xf2", [0x0fb3] = "\x90\xf3", [0x0fb4] = "\x90\xf4",
  [0x0fb5] = "\x90\xf5", [0x0fb6] = "\x90\xf6", [0x0fb7] = "\x90\xf7",
  [0x0fb8] = "\x90\xf8", [0x0fb9] = "\x90\xf9", [0x0fba] = "\x90\xfa",
  [0x0fbb] = "\x90\xfb", [0x0fbc] = "\x90\xfc", [0x0fbd] = "\x90\xfd",
  [0x0fbe] = "\x90\xfe", [0x1000] = "\x91\x40", [0x1001] = "\x91\x41",
  [0x1002] = "\x91\x42", [0x1003] = "\x91\x43", [0x1004] = "\x91\x44",
  [0x1005] = "\x91\x45", [0x1006] = "\x91\x46", [0x1007] = "\x91\x47",
  [0x1008] = "\x91\x48", [0x1009] = "\x91\x49", [0x100a] = "\x91\x4a",
  [0x100b] = "\x91\x4b", [0x100c] = "\x91\x4c", [0x100d] = "\x91\x4d",
  [0x100e] = "\x91\x4e", [0x100f] = "\x91\x4f", [0x1010] = "\x91\x50",
  [0x1011] = "\x91\x51", [0x1012] = "\x91\x52", [0x1013] = "\x91\x53",
  [0x1014] = "\x91\x54", [0x1015] = "\x91\x55", [0x1016] = "\x91\x56",
  [0x1017] = "\x91\x57", [0x1018] = "\x91\x58", [0x1019] = "\x91\x59",
  [0x101a] = "\x91\x5a", [0x101b] = "\x91\x5b", [0x101c] = "\x91\x5c",
  [0x101d] = "\x91\x5d", [0x101e] = "\x91\x5e", [0x101f] = "\x91\x5f",
  [0x1020] = "\x91\x60", [0x1021] = "\x91\x61", [0x1022] = "\x91\x62",
  [0x1023] = "\x91\x63", [0x1024] = "\x91\x64", [0x1025] = "\x91\x65",
  [0x1026] = "\x91\x66", [0x1027] = "\x91\x67", [0x1028] = "\x91\x68",
  [0x1029] = "\x91\x69", [0x102a] = "\x91\x6a", [0x102b] = "\x91\x6b",
  [0x102c] = "\x91\x6c", [0x102d] = "\x91\x6d", [0x102e] = "\x91\x6e",
  [0x102f] = "\x91\x6f", [0x1030] = "\x91\x70", [0x1031] = "\x91\x71",
  [0x1032] = "\x91\x72", [0x1033] = "\x91\x73", [0x1034] = "\x91\x74",
  [0x1035] = "\x91\x75", [0x1036] = "\x91\x76", [0x1037] = "\x91\x77",
  [0x1038] = "\x91\x78", [0x1039] = "\x91\x79", [0x103a] = "\x91\x7a",
  [0x103b] = "\x91\x7b", [0x103c] = "\x91\x7c", [0x103d] = "\x91\x7d",
  [0x103e] = "\x91\x7e", [0x1040] = "\x91\x80", [0x1041] = "\x91\x81",
  [0x1042] = "\x91\x82", [0x1043] = "\x91\x83", [0x1044] = "\x91\x84",
  [0x1045] = "\x91\x85", [0x1046] = "\x91\x86", [0x1047] = "\x91\x87",
  [0x1048] = "\x91\x88", [0x1049] = "\x91\x89", [0x104a] = "\x91\x8a",
  [0x104b] = "\x91\x8b", [0x104c] = "\x91\x8c", [0x104d] = "\x91\x8d",
  [0x104e] = "\x91\x8e", [0x104f] = "\x91\x8f", [0x1050] = "\x91\x90",
  [0x1051] = "\x91\x91", [0x1052] = "\x91\x92", [0x1053] = "\x91\x93",
  [0x1054] = "\x91\x94", [0x1055] = "\x91\x95", [0x1056] = "\x91\x96",
  [0x1057] = "\x91\x97", [0x1058] = "\x91\x98", [0x1059] = "\x91\x99",
  [0x105a] = "\x91\x9a", [0x105b] = "\x91\x9b", [0x105c] = "\x91\x9c",
  [0x105d] = "\x91\x9d", [0x105e] = "\x91\x9e", [0x105f] = "\x91\x9f",
  [0x1060] = "\x91\xa0", [0x1061] = "\x91\xa1", [0x1062] = "\x91\xa2",
  [0x1063] = "\x91\xa3", [0x1064] = "\x91\xa4", [0x1065] = "\x91\xa5",
  [0x1066] = "\x91\xa6", [0x1067] = "\x91\xa7", [0x1068] = "\x91\xa8",
  [0x1069] = "\x91\xa9", [0x106a] = "\x91\xaa", [0x106b] = "\x91\xab",
  [0x106c] = "\x91\xac", [0x106d] = "\x91\xad", [0x106e] = "\x91\xae",
  [0x106f] = "\x91\xaf", [0x1070] = "\x91\xb0", [0x1071] = "\x91\xb1",
  [0x1072] = "\x91\xb2", [0x1073] = "\x91\xb3", [0x1074] = "\x91\xb4",
  [0x1075] = "\x91\xb5", [0x1076] = "\x91\xb6", [0x1077] = "\x91\xb7",
  [0x1078] = "\x91\xb8", [0x1079] = "\x91\xb9", [0x107a] = "\x91\xba",
  [0x107b] = "\x91\xbb", [0x107c] = "\x91\xbc", [0x107d] = "\x91\xbd",
  [0x107e] = "\x91\xbe", [0x107f] = "\x91\xbf", [0x1080] = "\x91\xc0",
  [0x1081] = "\x91\xc1", [0x1082] = "\x91\xc2", [0x1083] = "\x91\xc3",
  [0x1084] = "\x91\xc4", [0x1085] = "\x91\xc5", [0x1086] = "\x91\xc6",
  [0x1087] = "\x91\xc7", [0x1088] = "\x91\xc8", [0x1089] = "\x91\xc9",
  [0x108a] = "\x91\xca", [0x108b] = "\x91\xcb", [0x108c] = "\x91\xcc",
  [0x108d] = "\x91\xcd", [0x108e] = "\x91\xce", [0x108f] = "\x91\xcf",
  [0x1090] = "\x91\xd0", [0x1091] = "\x91\xd1", [0x1092] = "\x91\xd2",
  [0x1093] = "\x91\xd3", [0x1094] = "\x91\xd4", [0x1095] = "\x91\xd5",
  [0x1096] = "\x91\xd6", [0x1097] = "\x91\xd7", [0x1098] = "\x91\xd8",
  [0x1099] = "\x91\xd9", [0x109a] = "\x91\xda", [0x109b] = "\x91\xdb",
  [0x109c] = "\x91\xdc", [0x109d] = "\x91\xdd", [0x109e] = "\x91\xde",
  [0x109f] = "\x91\xdf", [0x10a0] = "\x91\xe0", [0x10a1] = "\x91\xe1",
  [0x10a2] = "\x91\xe2", [0x10a3] = "\x91\xe3", [0x10a4] = "\x91\xe4",
  [0x10a5] = "\x91\xe5", [0x10a6] = "\x91\xe6", [0x10a7] = "\x91\xe7",
  [0x10a8] = "\x91\xe8", [0x10a9] = "\x91\xe9", [0x10aa] = "\x91\xea",
  [0x10ab] = "\x91\xeb", [0x10ac] = "\x91\xec", [0x10ad] = "\x91\xed",
  [0x10ae] = "\x91\xee", [0x10af] = "\x91\xef", [0x10b0] = "\x91\xf0",
  [0x10b1] = "\x91\xf1", [0x10b2] = "\x91\xf2", [0x10b3] = "\x91\xf3",
  [0x10b4] = "\x91\xf4", [0x10b5] = "\x91\xf5", [0x10b6] = "\x91\xf6",
  [0x10b7] = "\x91\xf7", [0x10b8] = "\x91\xf8", [0x10b9] = "\x91\xf9",
  [0x10ba] = "\x91\xfa", [0x10bb] = "\x91\xfb", [0x10bc] = "\x91\xfc",
  [0x10bd] = "\x91\xfd", [0x10be] = "\x91\xfe", [0x1100] = "\x92\x40",
  [0x1101] = "\x92\x41", [0x1102] = "\x92\x42", [0x1103] = "\x92\x43",
  [0x1104] = "\x92\x44", [0x1105] = "\x92\x45", [0x1106] = "\x92\x46",
  [0x1107] = "\x92\x47", [0x1108] = "\x92\x48", [0x1109] = "\x92\x49",
  [0x110a] = "\x92\x4a", [0x110b] = "\x92\x4b", [0x110c] = "\x92\x4c",
  [0x110d] = "\x92\x4d", [0x110e] = "\x92\x4e", [0x110f] = "\x92\x4f",
  [0x1110] = "\x92\x50", [0x1111] = "\x92\x51", [0x1112] = "\x92\x52",
  [0x1113] = "\x92\x53", [0x1114] = "\x92\x54", [0x1115] = "\x92\x55",
  [0x1116] = "\x92\x56", [0x1117] = "\x92\x57", [0x1118] = "\x92\x58",
  [0x1119] = "\x92\x59", [0x111a] = "\x92\x5a", [0x111b] = "\x92\x5b",
  [0x111c] = "\x92\x5c", [0x111d] = "\x92\x5d", [0x111e] = "\x92\x5e",
  [0x111f] = "\x92\x5f", [0x1120] = "\x92\x60", [0x1121] = "\x92\x61",
  [0x1122] = "\x92\x62", [0x1123] = "\x92\x63", [0x1124] = "\x92\x64",
  [0x1125] = "\x92\x65", [0x1126] = "\x92\x66", [0x1127] = "\x92\x67",
  [0x1128] = "\x92\x68", [0x1129] = "\x92\x69", [0x112a] = "\x92\x6a",
  [0x112b] = "\x92\x6b", [0x112c] = "\x92\x6c", [0x112d] = "\x92\x6d",
  [0x112e] = "\x92\x6e", [0x112f] = "\x92\x6f", [0x1130] = "\x92\x70",
  [0x1131] = "\x92\x71", [0x1132] = "\x92\x72", [0x1133] = "\x92\x73",
  [0x1134] = "\x92\x74", [0x1135] = "\x92\x75", [0x1136] = "\x92\x76",
  [0x1137] = "\x92\x77", [0x1138] = "\x92\x78", [0x1139] = "\x92\x79",
  [0x113a] = "\x92\x7a", [0x113b] = "\x92\x7b", [0x113c] = "\x92\x7c",
  [0x113d] = "\x92\x7d", [0x113e] = "\x92\x7e", [0x1140] = "\x92\x80",
  [0x1141] = "\x92\x81", [0x1142] = "\x92\x82", [0x1143] = "\x92\x83",
  [0x1144] = "\x92\x84", [0x1145] = "\x92\x85", [0x1146] = "\x92\x86",
  [0x1147] = "\x92\x87", [0x1148] = "\x92\x88", [0x1149] = "\x92\x89",
  [0x114a] = "\x92\x8a", [0x114b] = "\x92\x8b", [0x114c] = "\x92\x8c",
  [0x114d] = "\x92\x8d", [0x114e] = "\x92\x8e", [0x114f] = "\x92\x8f",
  [0x1150] = "\x92\x90", [0x1151] = "\x92\x91", [0x1152] = "\x92\x92",
  [0x1153] = "\x92\x93", [0x1154] = "\x92\x94", [0x1155] = "\x92\x95",
  [0x1156] = "\x92\x96", [0x1157] = "\x92\x97", [0x1158] = "\x92\x98",
  [0x1159] = "\x92\x99", [0x115a] = "\x92\x9a", [0x115b] = "\x92\x9b",
  [0x115c] = "\x92\x9c", [0x115d] = "\x92\x9d", [0x115e] = "\x92\x9e",
  [0x115f] = "\x92\x9f", [0x1160] = "\x92\xa0", [0x1161] = "\x92\xa1",
  [0x1162] = "\x92\xa2", [0x1163] = "\x92\xa3", [0x1164] = "\x92\xa4",
  [0x1165] = "\x92\xa5", [0x1166] = "\x92\xa6", [0x1167] = "\x92\xa7",
  [0x1168] = "\x92\xa8", [0x1169] = "\x92\xa9", [0x116a] = "\x92\xaa",
  [0x116b] = "\x92\xab", [0x116c] = "\x92\xac", [0x116d] = "\x92\xad",
  [0x116e] = "\x92\xae", [0x116f] = "\x92\xaf", [0x1170] = "\x92\xb0",
  [0x1171] = "\x92\xb1", [0x1172] = "\x92\xb2", [0x1173] = "\x92\xb3",
  [0x1174] = "\x92\xb4", [0x1175] = "\x92\xb5", [0x1176] = "\x92\xb6",
  [0x1177] = "\x92\xb7", [0x1178] = "\x92\xb8", [0x1179] = "\x92\xb9",
  [0x117a] = "\x92\xba", [0x117b] = "\x92\xbb", [0x117c] = "\x92\xbc",
  [0x117d] = "\x92\xbd", [0x117e] = "\x92\xbe", [0x117f] = "\x92\xbf",
  [0x1180] = "\x92\xc0", [0x1181] = "\x92\xc1", [0x1182] = "\x92\xc2",
  [0x1183] = "\x92\xc3", [0x1184] = "\x92\xc4", [0x1185] = "\x92\xc5",
  [0x1186] = "\x92\xc6", [0x1187] = "\x92\xc7", [0x1188] = "\x92\xc8",
  [0x1189] = "\x92\xc9", [0x118a] = "\x92\xca", [0x118b] = "\x92\xcb",
  [0x118c] = "\x92\xcc", [0x118d] = "\x92\xcd", [0x118e] = "\x92\xce",
  [0x118f] = "\x92\xcf", [0x1190] = "\x92\xd0", [0x1191] = "\x92\xd1",
  [0x1192] = "\x92\xd2", [0x1193] = "\x92\xd3", [0x1194] = "\x92\xd4",
  [0x1195] = "\x92\xd5", [0x1196] = "\x92\xd6", [0x1197] = "\x92\xd7",
  [0x1198] = "\x92\xd8", [0x1199] = "\x92\xd9", [0x119a] = "\x92\xda",
  [0x119b] = "\x92\xdb", [0x119c] = "\x92\xdc", [0x119d] = "\x92\xdd",
  [0x119e] = "\x92\xde", [0x119f] = "\x92\xdf", [0x11a0] = "\x92\xe0",
  [0x11a1] = "\x92\xe1", [0x11a2] = "\x92\xe2", [0x11a3] = "\x92\xe3",
  [0x11a4] = "\x92\xe4", [0x11a5] = "\x92\xe5", [0x11a6] = "\x92\xe6",
  [0x11a7] = "\x92\xe7", [0x11a8] = "\x92\xe8", [0x11a9] = "\x92\xe9",
  [0x11aa] = "\x92\xea", [0x11ab] = "\x92\xeb", [0x11ac] = "\x92\xec",
  [0x11ad] = "\x92\xed", [0x11ae] = "\x92\xee", [0x11af] = "\x92\xef",
  [0x11b0] = "\x92\xf0", [0x11b1] = "\x92\xf1", [0x11b2] = "\x92\xf2",
  [0x11b3] = "\x92\xf3", [0x11b4] = "\x92\xf4", [0x11b5] = "\x92\xf5",
  [0x11b6] = "\x92\xf6", [0x11b7] = "\x92\xf7", [0x11b8] = "\x92\xf8",
  [0x11b9] = "\x92\xf9", [0x11ba] = "\x92\xfa", [0x11bb] = "\x92\xfb",
  [0x11bc] = "\x92\xfc", [0x11bd] = "\x92\xfd", [0x11be] = "\x92\xfe",
  [0x1200] = "\x93\x40", [0x1201] = "\x93\x41", [0x1202] = "\x93\x42",
  [0x1203] = "\x93\x43", [0x1204] = "\x93\x44", [0x1205] = "\x93\x45",
  [0x1206] = "\x93\x46", [0x1207] = "\x93\x47", [0x1208] = "\x93\x48",
  [0x1209] = "\x93\x49", [0x120a] = "\x93\x4a", [0x120b] = "\x93\x4b",
  [0x120c] = "\x93\x4c", [0x120d] = "\x93\x4d", [0x120e] = "\x93\x4e",
  [0x120f] = "\x93\x4f", [0x1210] = "\x93\x50", [0x1211] = "\x93\x51",
  [0x1212] = "\x93\x52", [0x1213] = "\x93\x53", [0x1214] = "\x93\x54",
  [0x1215] = "\x93\x55", [0x1216] = "\x93\x56", [0x1217] = "\x93\x57",
  [0x1218] = "\x93\x58", [0x1219] = "\x93\x59", [0x121a] = "\x93\x5a",
  [0x121b] = "\x93\x5b", [0x121c] = "\x93\x5c", [0x121d] = "\x93\x5d",
  [0x121e] = "\x93\x5e", [0x121f] = "\x93\x5f", [0x1220] = "\x93\x60",
  [0x1221] = "\x93\x61", [0x1222] = "\x93\x62", [0x1223] = "\x93\x63",
  [0x1224] = "\x93\x64", [0x1225] = "\x93\x65", [0x1226] = "\x93\x66",
  [0x1227] = "\x93\x67", [0x1228] = "\x93\x68", [0x1229] = "\x93\x69",
  [0x122a] = "\x93\x6a", [0x122b] = "\x93\x6b", [0x122c] = "\x93\x6c",
  [0x122d] = "\x93\x6d", [0x122e] = "\x93\x6e", [0x122f] = "\x93\x6f",
  [0x1230] = "\x93\x70", [0x1231] = "\x93\x71", [0x1232] = "\x93\x72",
  [0x1233] = "\x93\x73", [0x1234] = "\x93\x74", [0x1235] = "\x93\x75",
  [0x1236] = "\x93\x76", [0x1237] = "\x93\x77", [0x1238] = "\x93\x78",
  [0x1239] = "\x93\x79", [0x123a] = "\x93\x7a", [0x123b] = "\x93\x7b",
  [0x123c] = "\x93\x7c", [0x123d] = "\x93\x7d", [0x123e] = "\x93\x7e",
  [0x1240] = "\x93\x80", [0x1241] = "\x93\x81", [0x1242] = "\x93\x82",
  [0x1243] = "\x93\x83", [0x1244] = "\x93\x84", [0x1245] = "\x93\x85",
  [0x1246] = "\x93\x86", [0x1247] = "\x93\x87", [0x1248] = "\x93\x88",
  [0x1249] = "\x93\x89", [0x124a] = "\x93\x8a", [0x124b] = "\x93\x8b",
  [0x124c] = "\x93\x8c", [0x124d] = "\x93\x8d", [0x124e] = "\x93\x8e",
  [0x124f] = "\x93\x8f", [0x1250] = "\x93\x90", [0x1251] = "\x93\x91",
  [0x1252] = "\x93\x92", [0x1253] = "\x93\x93", [0x1254] = "\x93\x94",
  [0x1255] = "\x93\x95", [0x1256] = "\x93\x96", [0x1257] = "\x93\x97",
  [0x1258] = "\x93\x98", [0x1259] = "\x93\x99", [0x125a] = "\x93\x9a",
  [0x125b] = "\x93\x9b", [0x125c] = "\x93\x9c", [0x125d] = "\x93\x9d",
  [0x125e] = "\x93\x9e", [0x125f] = "\x93\x9f", [0x1260] = "\x93\xa0",
  [0x1261] = "\x93\xa1", [0x1262] = "\x93\xa2", [0x1263] = "\x93\xa3",
  [0x1264] = "\x93\xa4", [0x1265] = "\x93\xa5", [0x1266] = "\x93\xa6",
  [0x1267] = "\x93\xa7", [0x1268] = "\x93\xa8", [0x1269] = "\x93\xa9",
  [0x126a] = "\x93\xaa", [0x126b] = "\x93\xab", [0x126c] = "\x93\xac",
  [0x126d] = "\x93\xad", [0x126e] = "\x93\xae", [0x126f] = "\x93\xaf",
  [0x1270] = "\x93\xb0", [0x1271] = "\x93\xb1", [0x1272] = "\x93\xb2",
  [0x1273] = "\x93\xb3", [0x1274] = "\x93\xb4", [0x1275] = "\x93\xb5",
  [0x1276] = "\x93\xb6", [0x1277] = "\x93\xb7", [0x1278] = "\x93\xb8",
  [0x1279] = "\x93\xb9", [0x127a] = "\x93\xba", [0x127b] = "\x93\xbb",
  [0x127c] = "\x93\xbc", [0x127d] = "\x93\xbd", [0x127e] = "\x93\xbe",
  [0x127f] = "\x93\xbf", [0x1280] = "\x93\xc0", [0x1281] = "\x93\xc1",
  [0x1282] = "\x93\xc2", [0x1283] = "\x93\xc3", [0x1284] = "\x93\xc4",
  [0x1285] = "\x93\xc5", [0x1286] = "\x93\xc6", [0x1287] = "\x93\xc7",
  [0x1288] = "\x93\xc8", [0x1289] = "\x93\xc9", [0x128a] = "\x93\xca",
  [0x128b] = "\x93\xcb", [0x128c] = "\x93\xcc", [0x128d] = "\x93\xcd",
  [0x128e] = "\x93\xce", [0x128f] = "\x93\xcf", [0x1290] = "\x93\xd0",
  [0x1291] = "\x93\xd1", [0x1292] = "\x93\xd2", [0x1293] = "\x93\xd3",
  [0x1294] = "\x93\xd4", [0x1295] = "\x93\xd5", [0x1296] = "\x93\xd6",
  [0x1297] = "\x93\xd7", [0x1298] = "\x93\xd8", [0x1299] = "\x93\xd9",
  [0x129a] = "\x93\xda", [0x129b] = "\x93\xdb", [0x129c] = "\x93\xdc",
  [0x129d] = "\x93\xdd", [0x129e] = "\x93\xde", [0x129f] = "\x93\xdf",
  [0x12a0] = "\x93\xe0", [0x12a1] = "\x93\xe1", [0x12a2] = "\x93\xe2",
  [0x12a3] = "\x93\xe3", [0x12a4] = "\x93\xe4", [0x12a5] = "\x93\xe5",
  [0x12a6] = "\x93\xe6", [0x12a7] = "\x93\xe7", [0x12a8] = "\x93\xe8",
  [0x12a9] = "\x93\xe9", [0x12aa] = "\x93\xea", [0x12ab] = "\x93\xeb",
  [0x12ac] = "\x93\xec", [0x12ad] = "\x93\xed", [0x12ae] = "\x93\xee",
  [0x12af] = "\x93\xef", [0x12b0] = "\x93\xf0", [0x12b1] = "\x93\xf1",
  [0x12b2] = "\x93\xf2", [0x12b3] = "\x93\xf3", [0x12b4] = "\x93\xf4",
  [0x12b5] = "\x93\xf5", [0x12b6] = "\x93\xf6", [0x12b7] = "\x93\xf7",
  [0x12b8] = "\x93\xf8", [0x12b9] = "\x93\xf9", [0x12ba] = "\x93\xfa",
  [0x12bb] = "\x93\xfb", [0x12bc] = "\x93\xfc", [0x12bd] = "\x93\xfd",
  [0x12be] = "\x93\xfe", [0x1300] = "\x94\x40", [0x1301] = "\x94\x41",
  [0x1302] = "\x94\x42", [0x1303] = "\x94\x43", [0x1304] = "\x94\x44",
  [0x1305] = "\x94\x45", [0x1306] = "\x94\x46", [0x1307] = "\x94\x47",
  [0x1308] = "\x94\x48", [0x1309] = "\x94\x49", [0x130a] = "\x94\x4a",
  [0x130b] = "\x94\x4b", [0x130c] = "\x94\x4c", [0x130d] = "\x94\x4d",
  [0x130e] = "\x94\x4e", [0x130f] = "\x94\x4f", [0x1310] = "\x94\x50",
  [0x1311] = "\x94\x51", [0x1312] = "\x94\x52", [0x1313] = "\x94\x53",
  [0x1314] = "\x94\x54", [0x1315] = "\x94\x55", [0x1316] = "\x94\x56",
  [0x1317] = "\x94\x57", [0x1318] = "\x94\x58", [0x1319] = "\x94\x59",
  [0x131a] = "\x94\x5a", [0x131b] = "\x94\x5b", [0x131c] = "\x94\x5c",
  [0x131d] = "\x94\x5d", [0x131e] = "\x94\x5e", [0x131f] = "\x94\x5f",
  [0x1320] = "\x94\x60", [0x1321] = "\x94\x61", [0x1322] = "\x94\x62",
  [0x1323] = "\x94\x63", [0x1324] = "\x94\x64", [0x1325] = "\x94\x65",
  [0x1326] = "\x94\x66", [0x1327] = "\x94\x67", [0x1328] = "\x94\x68",
  [0x1329] = "\x94\x69", [0x132a] = "\x94\x6a", [0x132b] = "\x94\x6b",
  [0x132c] = "\x94\x6c", [0x132d] = "\x94\x6d", [0x132e] = "\x94\x6e",
  [0x132f] = "\x94\x6f", [0x1330] = "\x94\x70", [0x1331] = "\x94\x71",
  [0x1332] = "\x94\x72", [0x1333] = "\x94\x73", [0x1334] = "\x94\x74",
  [0x1335] = "\x94\x75", [0x1336] = "\x94\x76", [0x1337] = "\x94\x77",
  [0x1338] = "\x94\x78", [0x1339] = "\x94\x79", [0x133a] = "\x94\x7a",
  [0x133b] = "\x94\x7b", [0x133c] = "\x94\x7c", [0x133d] = "\x94\x7d",
  [0x133e] = "\x94\x7e", [0x1340] = "\x94\x80", [0x1341] = "\x94\x81",
  [0x1342] = "\x94\x82", [0x1343] = "\x94\x83", [0x1344] = "\x94\x84",
  [0x1345] = "\x94\x85", [0x1346] = "\x94\x86", [0x1347] = "\x94\x87",
  [0x1348] = "\x94\x88", [0x1349] = "\x94\x89", [0x134a] = "\x94\x8a",
  [0x134b] = "\x94\x8b", [0x134c] = "\x94\x8c", [0x134d] = "\x94\x8d",
  [0x134e] = "\x94\x8e", [0x134f] = "\x94\x8f", [0x1350] = "\x94\x90",
  [0x1351] = "\x94\x91", [0x1352] = "\x94\x92", [0x1353] = "\x94\x93",
  [0x1354] = "\x94\x94", [0x1355] = "\x94\x95", [0x1356] = "\x94\x96",
  [0x1357] = "\x94\x97", [0x1358] = "\x94\x98", [0x1359] = "\x94\x99",
  [0x135a] = "\x94\x9a", [0x135b] = "\x94\x9b", [0x135c] = "\x94\x9c",
  [0x135d] = "\x94\x9d", [0x135e] = "\x94\x9e", [0x135f] = "\x94\x9f",
  [0x1360] = "\x94\xa0", [0x1361] = "\x94\xa1", [0x1362] = "\x94\xa2",
  [0x1363] = "\x94\xa3", [0x1364] = "\x94\xa4", [0x1365] = "\x94\xa5",
  [0x1366] = "\x94\xa6", [0x1367] = "\x94\xa7", [0x1368] = "\x94\xa8",
  [0x1369] = "\x94\xa9", [0x136a] = "\x94\xaa", [0x136b] = "\x94\xab",
  [0x136c] = "\x94\xac", [0x136d] = "\x94\xad", [0x136e] = "\x94\xae",
  [0x136f] = "\x94\xaf", [0x1370] = "\x94\xb0", [0x1371] = "\x94\xb1",
  [0x1372] = "\x94\xb2", [0x1373] = "\x94\xb3", [0x1374] = "\x94\xb4",
  [0x1375] = "\x94\xb5", [0x1376] = "\x94\xb6", [0x1377] = "\x94\xb7",
  [0x1378] = "\x94\xb8", [0x1379] = "\x94\xb9", [0x137a] = "\x94\xba",
  [0x137b] = "\x94\xbb", [0x137c] = "\x94\xbc", [0x137d] = "\x94\xbd",
  [0x137e] = "\x94\xbe", [0x137f] = "\x94\xbf", [0x1380] = "\x94\xc0",
  [0x1381] = "\x94\xc1", [0x1382] = "\x94\xc2", [0x1383] = "\x94\xc3",
  [0x1384] = "\x94\xc4", [0x1385] = "\x94\xc5", [0x1386] = "\x94\xc6",
  [0x1387] = "\x94\xc7", [0x1388] = "\x94\xc8", [0x1389] = "\x94\xc9",
  [0x138a] = "\x94\xca", [0x138b] = "\x94\xcb", [0x138c] = "\x94\xcc",
  [0x138d] = "\x94\xcd", [0x138e] = "\x94\xce", [0x138f] = "\x94\xcf",
  [0x1390] = "\x94\xd0", [0x1391] = "\x94\xd1", [0x1392] = "\x94\xd2",
  [0x1393] = "\x94\xd3", [0x1394] = "\x94\xd4", [0x1395] = "\x94\xd5",
  [0x1396] = "\x94\xd6", [0x1397] = "\x94\xd7", [0x1398] = "\x94\xd8",
  [0x1399] = "\x94\xd9", [0x139a] = "\x94\xda", [0x139b] = "\x94\xdb",
  [0x139c] = "\x94\xdc", [0x139d] = "\x94\xdd", [0x139e] = "\x94\xde",
  [0x139f] = "\x94\xdf", [0x13a0] = "\x94\xe0", [0x13a1] = "\x94\xe1",
  [0x13a2] = "\x94\xe2", [0x13a3] = "\x94\xe3", [0x13a4] = "\x94\xe4",
  [0x13a5] = "\x94\xe5", [0x13a6] = "\x94\xe6", [0x13a7] = "\x94\xe7",
  [0x13a8] = "\x94\xe8", [0x13a9] = "\x94\xe9", [0x13aa] = "\x94\xea",
  [0x13ab] = "\x94\xeb", [0x13ac] = "\x94\xec", [0x13ad] = "\x94\xed",
  [0x13ae] = "\x94\xee", [0x13af] = "\x94\xef", [0x13b0] = "\x94\xf0",
  [0x13b1] = "\x94\xf1", [0x13b2] = "\x94\xf2", [0x13b3] = "\x94\xf3",
  [0x13b4] = "\x94\xf4", [0x13b5] = "\x94\xf5", [0x13b6] = "\x94\xf6",
  [0x13b7] = "\x94\xf7", [0x13b8] = "\x94\xf8", [0x13b9] = "\x94\xf9",
  [0x13ba] = "\x94\xfa", [0x13bb] = "\x94\xfb", [0x13bc] = "\x94\xfc",
  [0x13bd] = "\x94\xfd", [0x13be] = "\x94\xfe", [0x1400] = "\x95\x40",
  [0x1401] = "\x95\x41", [0x1402] = "\x95\x42", [0x1403] = "\x95\x43",
  [0x1404] = "\x95\x44", [0x1405] = "\x95\x45", [0x1406] = "\x95\x46",
  [0x1407] = "\x95\x47", [0x1408] = "\x95\x48", [0x1409] = "\x95\x49",
  [0x140a] = "\x95\x4a", [0x140b] = "\x95\x4b", [0x140c] = "\x95\x4c",
  [0x140d] = "\x95\x4d", [0x140e] = "\x95\x4e", [0x140f] = "\x95\x4f",
  [0x1410] = "\x95\x50", [0x1411] = "\x95\x51", [0x1412] = "\x95\x52",
  [0x1413] = "\x95\x53", [0x1414] = "\x95\x54", [0x1415] = "\x95\x55",
  [0x1416] = "\x95\x56", [0x1417] = "\x95\x57", [0x1418] = "\x95\x58",
  [0x1419] = "\x95\x59", [0x141a] = "\x95\x5a", [0x141b] = "\x95\x5b",
  [0x141c] = "\x95\x5c", [0x141d] = "\x95\x5d", [0x141e] = "\x95\x5e",
  [0x141f] = "\x95\x5f", [0x1420] = "\x95\x60", [0x1421] = "\x95\x61",
  [0x1422] = "\x95\x62", [0x1423] = "\x95\x63", [0x1424] = "\x95\x64",
  [0x1425] = "\x95\x65", [0x1426] = "\x95\x66", [0x1427] = "\x95\x67",
  [0x1428] = "\x95\x68", [0x1429] = "\x95\x69", [0x142a] = "\x95\x6a",
  [0x142b] = "\x95\x6b", [0x142c] = "\x95\x6c", [0x142d] = "\x95\x6d",
  [0x142e] = "\x95\x6e", [0x142f] = "\x95\x6f", [0x1430] = "\x95\x70",
  [0x1431] = "\x95\x71", [0x1432] = "\x95\x72", [0x1433] = "\x95\x73",
  [0x1434] = "\x95\x74", [0x1435] = "\x95\x75", [0x1436] = "\x95\x76",
  [0x1437] = "\x95\x77", [0x1438] = "\x95\x78", [0x1439] = "\x95\x79",
  [0x143a] = "\x95\x7a", [0x143b] = "\x95\x7b", [0x143c] = "\x95\x7c",
  [0x143d] = "\x95\x7d", [0x143e] = "\x95\x7e", [0x1440] = "\x95\x80",
  [0x1441] = "\x95\x81", [0x1442] = "\x95\x82", [0x1443] = "\x95\x83",
  [0x1444] = "\x95\x84", [0x1445] = "\x95\x85", [0x1446] = "\x95\x86",
  [0x1447] = "\x95\x87", [0x1448] = "\x95\x88", [0x1449] = "\x95\x89",
  [0x144a] = "\x95\x8a", [0x144b] = "\x95\x8b", [0x144c] = "\x95\x8c",
  [0x144d] = "\x95\x8d", [0x144e] = "\x95\x8e", [0x144f] = "\x95\x8f",
  [0x1450] = "\x95\x90", [0x1451] = "\x95\x91", [0x1452] = "\x95\x92",
  [0x1453] = "\x95\x93", [0x1454] = "\x95\x94", [0x1455] = "\x95\x95",
  [0x1456] = "\x95\x96", [0x1457] = "\x95\x97", [0x1458] = "\x95\x98",
  [0x1459] = "\x95\x99", [0x145a] = "\x95\x9a", [0x145b] = "\x95\x9b",
  [0x145c] = "\x95\x9c", [0x145d] = "\x95\x9d", [0x145e] = "\x95\x9e",
  [0x145f] = "\x95\x9f", [0x1460] = "\x95\xa0", [0x1461] = "\x95\xa1",
  [0x1462] = "\x95\xa2", [0x1463] = "\x95\xa3", [0x1464] = "\x95\xa4",
  [0x1465] = "\x95\xa5", [0x1466] = "\x95\xa6", [0x1467] = "\x95\xa7",
  [0x1468] = "\x95\xa8", [0x1469] = "\x95\xa9", [0x146a] = "\x95\xaa",
  [0x146b] = "\x95\xab", [0x146c] = "\x95\xac", [0x146d] = "\x95\xad",
  [0x146e] = "\x95\xae", [0x146f] = "\x95\xaf", [0x1470] = "\x95\xb0",
  [0x1471] = "\x95\xb1", [0x1472] = "\x95\xb2", [0x1473] = "\x95\xb3",
  [0x1474] = "\x95\xb4", [0x1475] = "\x95\xb5", [0x1476] = "\x95\xb6",
  [0x1477] = "\x95\xb7", [0x1478] = "\x95\xb8", [0x1479] = "\x95\xb9",
  [0x147a] = "\x95\xba", [0x147b] = "\x95\xbb", [0x147c] = "\x95\xbc",
  [0x147d] = "\x95\xbd", [0x147e] = "\x95\xbe", [0x147f] = "\x95\xbf",
  [0x1480] = "\x95\xc0", [0x1481] = "\x95\xc1", [0x1482] = "\x95\xc2",
  [0x1483] = "\x95\xc3", [0x1484] = "\x95\xc4", [0x1485] = "\x95\xc5",
  [0x1486] = "\x95\xc6", [0x1487] = "\x95\xc7", [0x1488] = "\x95\xc8",
  [0x1489] = "\x95\xc9", [0x148a] = "\x95\xca", [0x148b] = "\x95\xcb",
  [0x148c] = "\x95\xcc", [0x148d] = "\x95\xcd", [0x148e] = "\x95\xce",
  [0x148f] = "\x95\xcf", [0x1490] = "\x95\xd0", [0x1491] = "\x95\xd1",
  [0x1492] = "\x95\xd2", [0x1493] = "\x95\xd3", [0x1494] = "\x95\xd4",
  [0x1495] = "\x95\xd5", [0x1496] = "\x95\xd6", [0x1497] = "\x95\xd7",
  [0x1498] = "\x95\xd8", [0x1499] = "\x95\xd9", [0x149a] = "\x95\xda",
  [0x149b] = "\x95\xdb", [0x149c] = "\x95\xdc", [0x149d] = "\x95\xdd",
  [0x149e] = "\x95\xde", [0x149f] = "\x95\xdf", [0x14a0] = "\x95\xe0",
  [0x14a1] = "\x95\xe1", [0x14a2] = "\x95\xe2", [0x14a3] = "\x95\xe3",
  [0x14a4] = "\x95\xe4", [0x14a5] = "\x95\xe5", [0x14a6] = "\x95\xe6",
  [0x14a7] = "\x95\xe7", [0x14a8] = "\x95\xe8", [0x14a9] = "\x95\xe9",
  [0x14aa] = "\x95\xea", [0x14ab] = "\x95\xeb", [0x14ac] = "\x95\xec",
  [0x14ad] = "\x95\xed", [0x14ae] = "\x95\xee", [0x14af] = "\x95\xef",
  [0x14b0] = "\x95\xf0", [0x14b1] = "\x95\xf1", [0x14b2] = "\x95\xf2",
  [0x14b3] = "\x95\xf3", [0x14b4] = "\x95\xf4", [0x14b5] = "\x95\xf5",
  [0x14b6] = "\x95\xf6", [0x14b7] = "\x95\xf7", [0x14b8] = "\x95\xf8",
  [0x14b9] = "\x95\xf9", [0x14ba] = "\x95\xfa", [0x14bb] = "\x95\xfb",
  [0x14bc] = "\x95\xfc", [0x14bd] = "\x95\xfd", [0x14be] = "\x95\xfe",
  [0x1500] = "\x96\x40", [0x1501] = "\x96\x41", [0x1502] = "\x96\x42",
  [0x1503] = "\x96\x43", [0x1504] = "\x96\x44", [0x1505] = "\x96\x45",
  [0x1506] = "\x96\x46", [0x1507] = "\x96\x47", [0x1508] = "\x96\x48",
  [0x1509] = "\x96\x49", [0x150a] = "\x96\x4a", [0x150b] = "\x96\x4b",
  [0x150c] = "\x96\x4c", [0x150d] = "\x96\x4d", [0x150e] = "\x96\x4e",
  [0x150f] = "\x96\x4f", [0x1510] = "\x96\x50", [0x1511] = "\x96\x51",
  [0x1512] = "\x96\x52", [0x1513] = "\x96\x53", [0x1514] = "\x96\x54",
  [0x1515] = "\x96\x55", [0x1516] = "\x96\x56", [0x1517] = "\x96\x57",
  [0x1518] = "\x96\x58", [0x1519] = "\x96\x59", [0x151a] = "\x96\x5a",
  [0x151b] = "\x96\x5b", [0x151c] = "\x96\x5c", [0x151d] = "\x96\x5d",
  [0x151e] = "\x96\x5e", [0x151f] = "\x96\x5f", [0x1520] = "\x96\x60",
  [0x1521] = "\x96\x61", [0x1522] = "\x96\x62", [0x1523] = "\x96\x63",
  [0x1524] = "\x96\x64", [0x1525] = "\x96\x65", [0x1526] = "\x96\x66",
  [0x1527] = "\x96\x67", [0x1528] = "\x96\x68", [0x1529] = "\x96\x69",
  [0x152a] = "\x96\x6a", [0x152b] = "\x96\x6b", [0x152c] = "\x96\x6c",
  [0x152d] = "\x96\x6d", [0x152e] = "\x96\x6e", [0x152f] = "\x96\x6f",
  [0x1530] = "\x96\x70", [0x1531] = "\x96\x71", [0x1532] = "\x96\x72",
  [0x1533] = "\x96\x73", [0x1534] = "\x96\x74", [0x1535] = "\x96\x75",
  [0x1536] = "\x96\x76", [0x1537] = "\x96\x77", [0x1538] = "\x96\x78",
  [0x1539] = "\x96\x79", [0x153a] = "\x96\x7a", [0x153b] = "\x96\x7b",
  [0x153c] = "\x96\x7c", [0x153d] = "\x96\x7d", [0x153e] = "\x96\x7e",
  [0x1540] = "\x96\x80", [0x1541] = "\x96\x81", [0x1542] = "\x96\x82",
  [0x1543] = "\x96\x83", [0x1544] = "\x96\x84", [0x1545] = "\x96\x85",
  [0x1546] = "\x96\x86", [0x1547] = "\x96\x87", [0x1548] = "\x96\x88",
  [0x1549] = "\x96\x89", [0x154a] = "\x96\x8a", [0x154b] = "\x96\x8b",
  [0x154c] = "\x96\x8c", [0x154d] = "\x96\x8d", [0x154e] = "\x96\x8e",
  [0x154f] = "\x96\x8f", [0x1550] = "\x96\x90", [0x1551] = "\x96\x91",
  [0x1552] = "\x96\x92", [0x1553] = "\x96\x93", [0x1554] = "\x96\x94",
  [0x1555] = "\x96\x95", [0x1556] = "\x96\x96", [0x1557] = "\x96\x97",
  [0x1558] = "\x96\x98", [0x1559] = "\x96\x99", [0x155a] = "\x96\x9a",
  [0x155b] = "\x96\x9b", [0x155c] = "\x96\x9c", [0x155d] = "\x96\x9d",
  [0x155e] = "\x96\x9e", [0x155f] = "\x96\x9f", [0x1560] = "\x96\xa0",
  [0x1561] = "\x96\xa1", [0x1562] = "\x96\xa2", [0x1563] = "\x96\xa3",
  [0x1564] = "\x96\xa4", [0x1565] = "\x96\xa5", [0x1566] = "\x96\xa6",
  [0x1567] = "\x96\xa7", [0x1568] = "\x96\xa8", [0x1569] = "\x96\xa9",
  [0x156a] = "\x96\xaa", [0x156b] = "\x96\xab", [0x156c] = "\x96\xac",
  [0x156d] = "\x96\xad", [0x156e] = "\x96\xae", [0x156f] = "\x96\xaf",
  [0x1570] = "\x96\xb0", [0x1571] = "\x96\xb1", [0x1572] = "\x96\xb2",
  [0x1573] = "\x96\xb3", [0x1574] = "\x96\xb4", [0x1575] = "\x96\xb5",
  [0x1576] = "\x96\xb6", [0x1577] = "\x96\xb7", [0x1578] = "\x96\xb8",
  [0x1579] = "\x96\xb9", [0x157a] = "\x96\xba", [0x157b] = "\x96\xbb",
  [0x157c] = "\x96\xbc", [0x157d] = "\x96\xbd", [0x157e] = "\x96\xbe",
  [0x157f] = "\x96\xbf", [0x1580] = "\x96\xc0", [0x1581] = "\x96\xc1",
  [0x1582] = "\x96\xc2", [0x1583] = "\x96\xc3", [0x1584] = "\x96\xc4",
  [0x1585] = "\x96\xc5", [0x1586] = "\x96\xc6", [0x1587] = "\x96\xc7",
  [0x1588] = "\x96\xc8", [0x1589] = "\x96\xc9", [0x158a] = "\x96\xca",
  [0x158b] = "\x96\xcb", [0x158c] = "\x96\xcc", [0x158d] = "\x96\xcd",
  [0x158e] = "\x96\xce", [0x158f] = "\x96\xcf", [0x1590] = "\x96\xd0",
  [0x1591] = "\x96\xd1", [0x1592] = "\x96\xd2", [0x1593] = "\x96\xd3",
  [0x1594] = "\x96\xd4", [0x1595] = "\x96\xd5", [0x1596] = "\x96\xd6",
  [0x1597] = "\x96\xd7", [0x1598] = "\x96\xd8", [0x1599] = "\x96\xd9",
  [0x159a] = "\x96\xda", [0x159b] = "\x96\xdb", [0x159c] = "\x96\xdc",
  [0x159d] = "\x96\xdd", [0x159e] = "\x96\xde", [0x159f] = "\x96\xdf",
  [0x15a0] = "\x96\xe0", [0x15a1] = "\x96\xe1", [0x15a2] = "\x96\xe2",
  [0x15a3] = "\x96\xe3", [0x15a4] = "\x96\xe4", [0x15a5] = "\x96\xe5",
  [0x15a6] = "\x96\xe6", [0x15a7] = "\x96\xe7", [0x15a8] = "\x96\xe8",
  [0x15a9] = "\x96\xe9", [0x15aa] = "\x96\xea", [0x15ab] = "\x96\xeb",
  [0x15ac] = "\x96\xec", [0x15ad] = "\x96\xed", [0x15ae] = "\x96\xee",
  [0x15af] = "\x96\xef", [0x15b0] = "\x96\xf0", [0x15b1] = "\x96\xf1",
  [0x15b2] = "\x96\xf2", [0x15b3] = "\x96\xf3", [0x15b4] = "\x96\xf4",
  [0x15b5] = "\x96\xf5", [0x15b6] = "\x96\xf6", [0x15b7] = "\x96\xf7",
  [0x15b8] = "\x96\xf8", [0x15b9] = "\x96\xf9", [0x15ba] = "\x96\xfa",
  [0x15bb] = "\x96\xfb", [0x15bc] = "\x96\xfc", [0x15bd] = "\x96\xfd",
  [0x15be] = "\x96\xfe", [0x1600] = "\x97\x40", [0x1601] = "\x97\x41",
  [0x1602] = "\x97\x42", [0x1603] = "\x97\x43", [0x1604] = "\x97\x44",
  [0x1605] = "\x97\x45", [0x1606] = "\x97\x46", [0x1607] = "\x97\x47",
  [0x1608] = "\x97\x48", [0x1609] = "\x97\x49", [0x160a] = "\x97\x4a",
  [0x160b] = "\x97\x4b", [0x160c] = "\x97\x4c", [0x160d] = "\x97\x4d",
  [0x160e] = "\x97\x4e", [0x160f] = "\x97\x4f", [0x1610] = "\x97\x50",
  [0x1611] = "\x97\x51", [0x1612] = "\x97\x52", [0x1613] = "\x97\x53",
  [0x1614] = "\x97\x54", [0x1615] = "\x97\x55", [0x1616] = "\x97\x56",
  [0x1617] = "\x97\x57", [0x1618] = "\x97\x58", [0x1619] = "\x97\x59",
  [0x161a] = "\x97\x5a", [0x161b] = "\x97\x5b", [0x161c] = "\x97\x5c",
  [0x161d] = "\x97\x5d", [0x161e] = "\x97\x5e", [0x161f] = "\x97\x5f",
  [0x1620] = "\x97\x60", [0x1621] = "\x97\x61", [0x1622] = "\x97\x62",
  [0x1623] = "\x97\x63", [0x1624] = "\x97\x64", [0x1625] = "\x97\x65",
  [0x1626] = "\x97\x66", [0x1627] = "\x97\x67", [0x1628] = "\x97\x68",
  [0x1629] = "\x97\x69", [0x162a] = "\x97\x6a", [0x162b] = "\x97\x6b",
  [0x162c] = "\x97\x6c", [0x162d] = "\x97\x6d", [0x162e] = "\x97\x6e",
  [0x162f] = "\x97\x6f", [0x1630] = "\x97\x70", [0x1631] = "\x97\x71",
  [0x1632] = "\x97\x72", [0x1633] = "\x97\x73", [0x1634] = "\x97\x74",
  [0x1635] = "\x97\x75", [0x1636] = "\x97\x76", [0x1637] = "\x97\x77",
  [0x1638] = "\x97\x78", [0x1639] = "\x97\x79", [0x163a] = "\x97\x7a",
  [0x163b] = "\x97\x7b", [0x163c] = "\x97\x7c", [0x163d] = "\x97\x7d",
  [0x163e] = "\x97\x7e", [0x1640] = "\x97\x80", [0x1641] = "\x97\x81",
  [0x1642] = "\x97\x82", [0x1643] = "\x97\x83", [0x1644] = "\x97\x84",
  [0x1645] = "\x97\x85", [0x1646] = "\x97\x86", [0x1647] = "\x97\x87",
  [0x1648] = "\x97\x88", [0x1649] = "\x97\x89", [0x164a] = "\x97\x8a",
  [0x164b] = "\x97\x8b", [0x164c] = "\x97\x8c", [0x164d] = "\x97\x8d",
  [0x164e] = "\x97\x8e", [0x164f] = "\x97\x8f", [0x1650] = "\x97\x90",
  [0x1651] = "\x97\x91", [0x1652] = "\x97\x92", [0x1653] = "\x97\x93",
  [0x1654] = "\x97\x94", [0x1655] = "\x97\x95", [0x1656] = "\x97\x96",
  [0x1657] = "\x97\x97", [0x1658] = "\x97\x98", [0x1659] = "\x97\x99",
  [0x165a] = "\x97\x9a", [0x165b] = "\x97\x9b", [0x165c] = "\x97\x9c",
  [0x165d] = "\x97\x9d", [0x165e] = "\x97\x9e", [0x165f] = "\x97\x9f",
  [0x1660] = "\x97\xa0", [0x1661] = "\x97\xa1", [0x1662] = "\x97\xa2",
  [0x1663] = "\x97\xa3", [0x1664] = "\x97\xa4", [0x1665] = "\x97\xa5",
  [0x1666] = "\x97\xa6", [0x1667] = "\x97\xa7", [0x1668] = "\x97\xa8",
  [0x1669] = "\x97\xa9", [0x166a] = "\x97\xaa", [0x166b] = "\x97\xab",
  [0x166c] = "\x97\xac", [0x166d] = "\x97\xad", [0x166e] = "\x97\xae",
  [0x166f] = "\x97\xaf", [0x1670] = "\x97\xb0", [0x1671] = "\x97\xb1",
  [0x1672] = "\x97\xb2", [0x1673] = "\x97\xb3", [0x1674] = "\x97\xb4",
  [0x1675] = "\x97\xb5", [0x1676] = "\x97\xb6", [0x1677] = "\x97\xb7",
  [0x1678] = "\x97\xb8", [0x1679] = "\x97\xb9", [0x167a] = "\x97\xba",
  [0x167b] = "\x97\xbb", [0x167c] = "\x97\xbc", [0x167d] = "\x97\xbd",
  [0x167e] = "\x97\xbe", [0x167f] = "\x97\xbf", [0x1680] = "\x97\xc0",
  [0x1681] = "\x97\xc1", [0x1682] = "\x97\xc2", [0x1683] = "\x97\xc3",
  [0x1684] = "\x97\xc4", [0x1685] = "\x97\xc5", [0x1686] = "\x97\xc6",
  [0x1687] = "\x97\xc7", [0x1688] = "\x97\xc8", [0x1689] = "\x97\xc9",
  [0x168a] = "\x97\xca", [0x168b] = "\x97\xcb", [0x168c] = "\x97\xcc",
  [0x168d] = "\x97\xcd", [0x168e] = "\x97\xce", [0x168f] = "\x97\xcf",
  [0x1690] = "\x97\xd0", [0x1691] = "\x97\xd1", [0x1692] = "\x97\xd2",
  [0x1693] = "\x97\xd3", [0x1694] = "\x97\xd4", [0x1695] = "\x97\xd5",
  [0x1696] = "\x97\xd6", [0x1697] = "\x97\xd7", [0x1698] = "\x97\xd8",
  [0x1699] = "\x97\xd9", [0x169a] = "\x97\xda", [0x169b] = "\x97\xdb",
  [0x169c] = "\x97\xdc", [0x169d] = "\x97\xdd", [0x169e] = "\x97\xde",
  [0x169f] = "\x97\xdf", [0x16a0] = "\x97\xe0", [0x16a1] = "\x97\xe1",
  [0x16a2] = "\x97\xe2", [0x16a3] = "\x97\xe3", [0x16a4] = "\x97\xe4",
  [0x16a5] = "\x97\xe5", [0x16a6] = "\x97\xe6", [0x16a7] = "\x97\xe7",
  [0x16a8] = "\x97\xe8", [0x16a9] = "\x97\xe9", [0x16aa] = "\x97\xea",
  [0x16ab] = "\x97\xeb", [0x16ac] = "\x97\xec", [0x16ad] = "\x97\xed",
  [0x16ae] = "\x97\xee", [0x16af] = "\x97\xef", [0x16b0] = "\x97\xf0",
  [0x16b1] = "\x97\xf1", [0x16b2] = "\x97\xf2", [0x16b3] = "\x97\xf3",
  [0x16b4] = "\x97\xf4", [0x16b5] = "\x97\xf5", [0x16b6] = "\x97\xf6",
  [0x16b7] = "\x97\xf7", [0x16b8] = "\x97\xf8", [0x16b9] = "\x97\xf9",
  [0x16ba] = "\x97\xfa", [0x16bb] = "\x97\xfb", [0x16bc] = "\x97\xfc",
  [0x16bd] = "\x97\xfd", [0x16be] = "\x97\xfe", [0x1700] = "\x98\x40",
  [0x1701] = "\x98\x41", [0x1702] = "\x98\x42", [0x1703] = "\x98\x43",
  [0x1704] = "\x98\x44", [0x1705] = "\x98\x45", [0x1706] = "\x98\x46",
  [0x1707] = "\x98\x47", [0x1708] = "\x98\x48", [0x1709] = "\x98\x49",
  [0x170a] = "\x98\x4a", [0x170b] = "\x98\x4b", [0x170c] = "\x98\x4c",
  [0x170d] = "\x98\x4d", [0x170e] = "\x98\x4e", [0x170f] = "\x98\x4f",
  [0x1710] = "\x98\x50", [0x1711] = "\x98\x51", [0x1712] = "\x98\x52",
  [0x1713] = "\x98\x53", [0x1714] = "\x98\x54", [0x1715] = "\x98\x55",
  [0x1716] = "\x98\x56", [0x1717] = "\x98\x57", [0x1718] = "\x98\x58",
  [0x1719] = "\x98\x59", [0x171a] = "\x98\x5a", [0x171b] = "\x98\x5b",
  [0x171c] = "\x98\x5c", [0x171d] = "\x98\x5d", [0x171e] = "\x98\x5e",
  [0x171f] = "\x98\x5f", [0x1720] = "\x98\x60", [0x1721] = "\x98\x61",
  [0x1722] = "\x98\x62", [0x1723] = "\x98\x63", [0x1724] = "\x98\x64",
  [0x1725] = "\x98\x65", [0x1726] = "\x98\x66", [0x1727] = "\x98\x67",
  [0x1728] = "\x98\x68", [0x1729] = "\x98\x69", [0x172a] = "\x98\x6a",
  [0x172b] = "\x98\x6b", [0x172c] = "\x98\x6c", [0x172d] = "\x98\x6d",
  [0x172e] = "\x98\x6e", [0x172f] = "\x98\x6f", [0x1730] = "\x98\x70",
  [0x1731] = "\x98\x71", [0x1732] = "\x98\x72", [0x1733] = "\x98\x73",
  [0x1734] = "\x98\x74", [0x1735] = "\x98\x75", [0x1736] = "\x98\x76",
  [0x1737] = "\x98\x77", [0x1738] = "\x98\x78", [0x1739] = "\x98\x79",
  [0x173a] = "\x98\x7a", [0x173b] = "\x98\x7b", [0x173c] = "\x98\x7c",
  [0x173d] = "\x98\x7d", [0x173e] = "\x98\x7e", [0x1740] = "\x98\x80",
  [0x1741] = "\x98\x81", [0x1742] = "\x98\x82", [0x1743] = "\x98\x83",
  [0x1744] = "\x98\x84", [0x1745] = "\x98\x85", [0x1746] = "\x98\x86",
  [0x1747] = "\x98\x87", [0x1748] = "\x98\x88", [0x1749] = "\x98\x89",
  [0x174a] = "\x98\x8a", [0x174b] = "\x98\x8b", [0x174c] = "\x98\x8c",
  [0x174d] = "\x98\x8d", [0x174e] = "\x98\x8e", [0x174f] = "\x98\x8f",
  [0x1750] = "\x98\x90", [0x1751] = "\x98\x91", [0x1752] = "\x98\x92",
  [0x1753] = "\x98\x93", [0x1754] = "\x98\x94", [0x1755] = "\x98\x95",
  [0x1756] = "\x98\x96", [0x1757] = "\x98\x97", [0x1758] = "\x98\x98",
  [0x1759] = "\x98\x99", [0x175a] = "\x98\x9a", [0x175b] = "\x98\x9b",
  [0x175c] = "\x98\x9c", [0x175d] = "\x98\x9d", [0x175e] = "\x98\x9e",
  [0x175f] = "\x98\x9f", [0x1760] = "\x98\xa0", [0x1761] = "\x98\xa1",
  [0x1762] = "\x98\xa2", [0x1763] = "\x98\xa3", [0x1764] = "\x98\xa4",
  [0x1765] = "\x98\xa5", [0x1766] = "\x98\xa6", [0x1767] = "\x98\xa7",
  [0x1768] = "\x98\xa8", [0x1769] = "\x98\xa9", [0x176a] = "\x98\xaa",
  [0x176b] = "\x98\xab", [0x176c] = "\x98\xac", [0x176d] = "\x98\xad",
  [0x176e] = "\x98\xae", [0x176f] = "\x98\xaf", [0x1770] = "\x98\xb0",
  [0x1771] = "\x98\xb1", [0x1772] = "\x98\xb2", [0x1773] = "\x98\xb3",
  [0x1774] = "\x98\xb4", [0x1775] = "\x98\xb5", [0x1776] = "\x98\xb6",
  [0x1777] = "\x98\xb7", [0x1778] = "\x98\xb8", [0x1779] = "\x98\xb9",
  [0x177a] = "\x98\xba", [0x177b] = "\x98\xbb", [0x177c] = "\x98\xbc",
  [0x177d] = "\x98\xbd", [0x177e] = "\x98\xbe", [0x177f] = "\x98\xbf",
  [0x1780] = "\x98\xc0", [0x1781] = "\x98\xc1", [0x1782] = "\x98\xc2",
  [0x1783] = "\x98\xc3", [0x1784] = "\x98\xc4", [0x1785] = "\x98\xc5",
  [0x1786] = "\x98\xc6", [0x1787] = "\x98\xc7", [0x1788] = "\x98\xc8",
  [0x1789] = "\x98\xc9", [0x178a] = "\x98\xca", [0x178b] = "\x98\xcb",
  [0x178c] = "\x98\xcc", [0x178d] = "\x98\xcd", [0x178e] = "\x98\xce",
  [0x178f] = "\x98\xcf", [0x1790] = "\x98\xd0", [0x1791] = "\x98\xd1",
  [0x1792] = "\x98\xd2", [0x1793] = "\x98\xd3", [0x1794] = "\x98\xd4",
  [0x1795] = "\x98\xd5", [0x1796] = "\x98\xd6", [0x1797] = "\x98\xd7",
  [0x1798] = "\x98\xd8", [0x1799] = "\x98\xd9", [0x179a] = "\x98\xda",
  [0x179b] = "\x98\xdb", [0x179c] = "\x98\xdc", [0x179d] = "\x98\xdd",
  [0x179e] = "\x98\xde", [0x179f] = "\x98\xdf", [0x17a0] = "\x98\xe0",
  [0x17a1] = "\x98\xe1", [0x17a2] = "\x98\xe2", [0x17a3] = "\x98\xe3",
  [0x17a4] = "\x98\xe4", [0x17a5] = "\x98\xe5", [0x17a6] = "\x98\xe6",
  [0x17a7] = "\x98\xe7", [0x17a8] = "\x98\xe8", [0x17a9] = "\x98\xe9",
  [0x17aa] = "\x98\xea", [0x17ab] = "\x98\xeb", [0x17ac] = "\x98\xec",
  [0x17ad] = "\x98\xed", [0x17ae] = "\x98\xee", [0x17af] = "\x98\xef",
  [0x17b0] = "\x98\xf0", [0x17b1] = "\x98\xf1", [0x17b2] = "\x98\xf2",
  [0x17b3] = "\x98\xf3", [0x17b4] = "\x98\xf4", [0x17b5] = "\x98\xf5",
  [0x17b6] = "\x98\xf6", [0x17b7] = "\x98\xf7", [0x17b8] = "\x98\xf8",
  [0x17b9] = "\x98\xf9", [0x17ba] = "\x98\xfa", [0x17bb] = "\x98\xfb",
  [0x17bc] = "\x98\xfc", [0x17bd] = "\x98\xfd", [0x17be] = "\x98\xfe",
  [0x1800] = "\x99\x40", [0x1801] = "\x99\x41", [0x1802] = "\x99\x42",
  [0x1803] = "\x99\x43", [0x1804] = "\x99\x44", [0x1805] = "\x99\x45",
  [0x1806] = "\x99\x46", [0x1807] = "\x99\x47", [0x1808] = "\x99\x48",
  [0x1809] = "\x99\x49", [0x180a] = "\x99\x4a", [0x180b] = "\x99\x4b",
  [0x180c] = "\x99\x4c", [0x180d] = "\x99\x4d", [0x180e] = "\x99\x4e",
  [0x180f] = "\x99\x4f", [0x1810] = "\x99\x50", [0x1811] = "\x99\x51",
  [0x1812] = "\x99\x52", [0x1813] = "\x99\x53", [0x1814] = "\x99\x54",
  [0x1815] = "\x99\x55", [0x1816] = "\x99\x56", [0x1817] = "\x99\x57",
  [0x1818] = "\x99\x58", [0x1819] = "\x99\x59", [0x181a] = "\x99\x5a",
  [0x181b] = "\x99\x5b", [0x181c] = "\x99\x5c", [0x181d] = "\x99\x5d",
  [0x181e] = "\x99\x5e", [0x181f] = "\x99\x5f", [0x1820] = "\x99\x60",
  [0x1821] = "\x99\x61", [0x1822] = "\x99\x62", [0x1823] = "\x99\x63",
  [0x1824] = "\x99\x64", [0x1825] = "\x99\x65", [0x1826] = "\x99\x66",
  [0x1827] = "\x99\x67", [0x1828] = "\x99\x68", [0x1829] = "\x99\x69",
  [0x182a] = "\x99\x6a", [0x182b] = "\x99\x6b", [0x182c] = "\x99\x6c",
  [0x182d] = "\x99\x6d", [0x182e] = "\x99\x6e", [0x182f] = "\x99\x6f",
  [0x1830] = "\x99\x70", [0x1831] = "\x99\x71", [0x1832] = "\x99\x72",
  [0x1833] = "\x99\x73", [0x1834] = "\x99\x74", [0x1835] = "\x99\x75",
  [0x1836] = "\x99\x76", [0x1837] = "\x99\x77", [0x1838] = "\x99\x78",
  [0x1839] = "\x99\x79", [0x183a] = "\x99\x7a", [0x183b] = "\x99\x7b",
  [0x183c] = "\x99\x7c", [0x183d] = "\x99\x7d", [0x183e] = "\x99\x7e",
  [0x1840] = "\x99\x80", [0x1841] = "\x99\x81", [0x1842] = "\x99\x82",
  [0x1843] = "\x99\x83", [0x1844] = "\x99\x84", [0x1845] = "\x99\x85",
  [0x1846] = "\x99\x86", [0x1847] = "\x99\x87", [0x1848] = "\x99\x88",
  [0x1849] = "\x99\x89", [0x184a] = "\x99\x8a", [0x184b] = "\x99\x8b",
  [0x184c] = "\x99\x8c", [0x184d] = "\x99\x8d", [0x184e] = "\x99\x8e",
  [0x184f] = "\x99\x8f", [0x1850] = "\x99\x90", [0x1851] = "\x99\x91",
  [0x1852] = "\x99\x92", [0x1853] = "\x99\x93", [0x1854] = "\x99\x94",
  [0x1855] = "\x99\x95", [0x1856] = "\x99\x96", [0x1857] = "\x99\x97",
  [0x1858] = "\x99\x98", [0x1859] = "\x99\x99", [0x185a] = "\x99\x9a",
  [0x185b] = "\x99\x9b", [0x185c] = "\x99\x9c", [0x185d] = "\x99\x9d",
  [0x185e] = "\x99\x9e", [0x185f] = "\x99\x9f", [0x1860] = "\x99\xa0",
  [0x1861] = "\x99\xa1", [0x1862] = "\x99\xa2", [0x1863] = "\x99\xa3",
  [0x1864] = "\x99\xa4", [0x1865] = "\x99\xa5", [0x1866] = "\x99\xa6",
  [0x1867] = "\x99\xa7", [0x1868] = "\x99\xa8", [0x1869] = "\x99\xa9",
  [0x186a] = "\x99\xaa", [0x186b] = "\x99\xab", [0x186c] = "\x99\xac",
  [0x186d] = "\x99\xad", [0x186e] = "\x99\xae", [0x186f] = "\x99\xaf",
  [0x1870] = "\x99\xb0", [0x1871] = "\x99\xb1", [0x1872] = "\x99\xb2",
  [0x1873] = "\x99\xb3", [0x1874] = "\x99\xb4", [0x1875] = "\x99\xb5",
  [0x1876] = "\x99\xb6", [0x1877] = "\x99\xb7", [0x1878] = "\x99\xb8",
  [0x1879] = "\x99\xb9", [0x187a] = "\x99\xba", [0x187b] = "\x99\xbb",
  [0x187c] = "\x99\xbc", [0x187d] = "\x99\xbd", [0x187e] = "\x99\xbe",
  [0x187f] = "\x99\xbf", [0x1880] = "\x99\xc0", [0x1881] = "\x99\xc1",
  [0x1882] = "\x99\xc2", [0x1883] = "\x99\xc3", [0x1884] = "\x99\xc4",
  [0x1885] = "\x99\xc5", [0x1886] = "\x99\xc6", [0x1887] = "\x99\xc7",
  [0x1888] = "\x99\xc8", [0x1889] = "\x99\xc9", [0x188a] = "\x99\xca",
  [0x188b] = "\x99\xcb", [0x188c] = "\x99\xcc", [0x188d] = "\x99\xcd",
  [0x188e] = "\x99\xce", [0x188f] = "\x99\xcf", [0x1890] = "\x99\xd0",
  [0x1891] = "\x99\xd1", [0x1892] = "\x99\xd2", [0x1893] = "\x99\xd3",
  [0x1894] = "\x99\xd4", [0x1895] = "\x99\xd5", [0x1896] = "\x99\xd6",
  [0x1897] = "\x99\xd7", [0x1898] = "\x99\xd8", [0x1899] = "\x99\xd9",
  [0x189a] = "\x99\xda", [0x189b] = "\x99\xdb", [0x189c] = "\x99\xdc",
  [0x189d] = "\x99\xdd", [0x189e] = "\x99\xde", [0x189f] = "\x99\xdf",
  [0x18a0] = "\x99\xe0", [0x18a1] = "\x99\xe1", [0x18a2] = "\x99\xe2",
  [0x18a3] = "\x99\xe3", [0x18a4] = "\x99\xe4", [0x18a5] = "\x99\xe5",
  [0x18a6] = "\x99\xe6", [0x18a7] = "\x99\xe7", [0x18a8] = "\x99\xe8",
  [0x18a9] = "\x99\xe9", [0x18aa] = "\x99\xea", [0x18ab] = "\x99\xeb",
  [0x18ac] = "\x99\xec", [0x18ad] = "\x99\xed", [0x18ae] = "\x99\xee",
  [0x18af] = "\x99\xef", [0x18b0] = "\x99\xf0", [0x18b1] = "\x99\xf1",
  [0x18b2] = "\x99\xf2", [0x18b3] = "\x99\xf3", [0x18b4] = "\x99\xf4",
  [0x18b5] = "\x99\xf5", [0x18b6] = "\x99\xf6", [0x18b7] = "\x99\xf7",
  [0x18b8] = "\x99\xf8", [0x18b9] = "\x99\xf9", [0x18ba] = "\x99\xfa",
  [0x18bb] = "\x99\xfb", [0x18bc] = "\x99\xfc", [0x18bd] = "\x99\xfd",
  [0x18be] = "\x99\xfe", [0x1900] = "\x9a\x40", [0x1901] = "\x9a\x41",
  [0x1902] = "\x9a\x42", [0x1903] = "\x9a\x43", [0x1904] = "\x9a\x44",
  [0x1905] = "\x9a\x45", [0x1906] = "\x9a\x46", [0x1907] = "\x9a\x47",
  [0x1908] = "\x9a\x48", [0x1909] = "\x9a\x49", [0x190a] = "\x9a\x4a",
  [0x190b] = "\x9a\x4b", [0x190c] = "\x9a\x4c", [0x190d] = "\x9a\x4d",
  [0x190e] = "\x9a\x4e", [0x190f] = "\x9a\x4f", [0x1910] = "\x9a\x50",
  [0x1911] = "\x9a\x51", [0x1912] = "\x9a\x52", [0x1913] = "\x9a\x53",
  [0x1914] = "\x9a\x54", [0x1915] = "\x9a\x55", [0x1916] = "\x9a\x56",
  [0x1917] = "\x9a\x57", [0x1918] = "\x9a\x58", [0x1919] = "\x9a\x59",
  [0x191a] = "\x9a\x5a", [0x191b] = "\x9a\x5b", [0x191c] = "\x9a\x5c",
  [0x191d] = "\x9a\x5d", [0x191e] = "\x9a\x5e", [0x191f] = "\x9a\x5f",
  [0x1920] = "\x9a\x60", [0x1921] = "\x9a\x61", [0x1922] = "\x9a\x62",
  [0x1923] = "\x9a\x63", [0x1924] = "\x9a\x64", [0x1925] = "\x9a\x65",
  [0x1926] = "\x9a\x66", [0x1927] = "\x9a\x67", [0x1928] = "\x9a\x68",
  [0x1929] = "\x9a\x69", [0x192a] = "\x9a\x6a", [0x192b] = "\x9a\x6b",
  [0x192c] = "\x9a\x6c", [0x192d] = "\x9a\x6d", [0x192e] = "\x9a\x6e",
  [0x192f] = "\x9a\x6f", [0x1930] = "\x9a\x70", [0x1931] = "\x9a\x71",
  [0x1932] = "\x9a\x72", [0x1933] = "\x9a\x73", [0x1934] = "\x9a\x74",
  [0x1935] = "\x9a\x75", [0x1936] = "\x9a\x76", [0x1937] = "\x9a\x77",
  [0x1938] = "\x9a\x78", [0x1939] = "\x9a\x79", [0x193a] = "\x9a\x7a",
  [0x193b] = "\x9a\x7b", [0x193c] = "\x9a\x7c", [0x193d] = "\x9a\x7d",
  [0x193e] = "\x9a\x7e", [0x1940] = "\x9a\x80", [0x1941] = "\x9a\x81",
  [0x1942] = "\x9a\x82", [0x1943] = "\x9a\x83", [0x1944] = "\x9a\x84",
  [0x1945] = "\x9a\x85", [0x1946] = "\x9a\x86", [0x1947] = "\x9a\x87",
  [0x1948] = "\x9a\x88", [0x1949] = "\x9a\x89", [0x194a] = "\x9a\x8a",
  [0x194b] = "\x9a\x8b", [0x194c] = "\x9a\x8c", [0x194d] = "\x9a\x8d",
  [0x194e] = "\x9a\x8e", [0x194f] = "\x9a\x8f", [0x1950] = "\x9a\x90",
  [0x1951] = "\x9a\x91", [0x1952] = "\x9a\x92", [0x1953] = "\x9a\x93",
  [0x1954] = "\x9a\x94", [0x1955] = "\x9a\x95", [0x1956] = "\x9a\x96",
  [0x1957] = "\x9a\x97", [0x1958] = "\x9a\x98", [0x1959] = "\x9a\x99",
  [0x195a] = "\x9a\x9a", [0x195b] = "\x9a\x9b", [0x195c] = "\x9a\x9c",
  [0x195d] = "\x9a\x9d", [0x195e] = "\x9a\x9e", [0x195f] = "\x9a\x9f",
  [0x1960] = "\x9a\xa0", [0x1961] = "\x9a\xa1", [0x1962] = "\x9a\xa2",
  [0x1963] = "\x9a\xa3", [0x1964] = "\x9a\xa4", [0x1965] = "\x9a\xa5",
  [0x1966] = "\x9a\xa6", [0x1967] = "\x9a\xa7", [0x1968] = "\x9a\xa8",
  [0x1969] = "\x9a\xa9", [0x196a] = "\x9a\xaa", [0x196b] = "\x9a\xab",
  [0x196c] = "\x9a\xac", [0x196d] = "\x9a\xad", [0x196e] = "\x9a\xae",
  [0x196f] = "\x9a\xaf", [0x1970] = "\x9a\xb0", [0x1971] = "\x9a\xb1",
  [0x1972] = "\x9a\xb2", [0x1973] = "\x9a\xb3", [0x1974] = "\x9a\xb4",
  [0x1975] = "\x9a\xb5", [0x1976] = "\x9a\xb6", [0x1977] = "\x9a\xb7",
  [0x1978] = "\x9a\xb8", [0x1979] = "\x9a\xb9", [0x197a] = "\x9a\xba",
  [0x197b] = "\x9a\xbb", [0x197c] = "\x9a\xbc", [0x197d] = "\x9a\xbd",
  [0x197e] = "\x9a\xbe", [0x197f] = "\x9a\xbf", [0x1980] = "\x9a\xc0",
  [0x1981] = "\x9a\xc1", [0x1982] = "\x9a\xc2", [0x1983] = "\x9a\xc3",
  [0x1984] = "\x9a\xc4", [0x1985] = "\x9a\xc5", [0x1986] = "\x9a\xc6",
  [0x1987] = "\x9a\xc7", [0x1988] = "\x9a\xc8", [0x1989] = "\x9a\xc9",
  [0x198a] = "\x9a\xca", [0x198b] = "\x9a\xcb", [0x198c] = "\x9a\xcc",
  [0x198d] = "\x9a\xcd", [0x198e] = "\x9a\xce", [0x198f] = "\x9a\xcf",
  [0x1990] = "\x9a\xd0", [0x1991] = "\x9a\xd1", [0x1992] = "\x9a\xd2",
  [0x1993] = "\x9a\xd3", [0x1994] = "\x9a\xd4", [0x1995] = "\x9a\xd5",
  [0x1996] = "\x9a\xd6", [0x1997] = "\x9a\xd7", [0x1998] = "\x9a\xd8",
  [0x1999] = "\x9a\xd9", [0x199a] = "\x9a\xda", [0x199b] = "\x9a\xdb",
  [0x199c] = "\x9a\xdc", [0x199d] = "\x9a\xdd", [0x199e] = "\x9a\xde",
  [0x199f] = "\x9a\xdf", [0x19a0] = "\x9a\xe0", [0x19a1] = "\x9a\xe1",
  [0x19a2] = "\x9a\xe2", [0x19a3] = "\x9a\xe3", [0x19a4] = "\x9a\xe4",
  [0x19a5] = "\x9a\xe5", [0x19a6] = "\x9a\xe6", [0x19a7] = "\x9a\xe7",
  [0x19a8] = "\x9a\xe8", [0x19a9] = "\x9a\xe9", [0x19aa] = "\x9a\xea",
  [0x19ab] = "\x9a\xeb", [0x19ac] = "\x9a\xec", [0x19ad] = "\x9a\xed",
  [0x19ae] = "\x9a\xee", [0x19af] = "\x9a\xef", [0x19b0] = "\x9a\xf0",
  [0x19b1] = "\x9a\xf1", [0x19b2] = "\x9a\xf2", [0x19b3] = "\x9a\xf3",
  [0x19b4] = "\x9a\xf4", [0x19b5] = "\x9a\xf5", [0x19b6] = "\x9a\xf6",
  [0x19b7] = "\x9a\xf7", [0x19b8] = "\x9a\xf8", [0x19b9] = "\x9a\xf9",
  [0x19ba] = "\x9a\xfa", [0x19bb] = "\x9a\xfb", [0x19bc] = "\x9a\xfc",
  [0x19bd] = "\x9a\xfd", [0x19be] = "\x9a\xfe", [0x1a00] = "\x9b\x40",
  [0x1a01] = "\x9b\x41", [0x1a02] = "\x9b\x42", [0x1a03] = "\x9b\x43",
  [0x1a04] = "\x9b\x44", [0x1a05] = "\x9b\x45", [0x1a06] = "\x9b\x46",
  [0x1a07] = "\x9b\x47", [0x1a08] = "\x9b\x48", [0x1a09] = "\x9b\x49",
  [0x1a0a] = "\x9b\x4a", [0x1a0b] = "\x9b\x4b", [0x1a0c] = "\x9b\x4c",
  [0x1a0d] = "\x9b\x4d", [0x1a0e] = "\x9b\x4e", [0x1a0f] = "\x9b\x4f",
  [0x1a10] = "\x9b\x50", [0x1a11] = "\x9b\x51", [0x1a12] = "\x9b\x52",
  [0x1a13] = "\x9b\x53", [0x1a14] = "\x9b\x54", [0x1a15] = "\x9b\x55",
  [0x1a16] = "\x9b\x56", [0x1a17] = "\x9b\x57", [0x1a18] = "\x9b\x58",
  [0x1a19] = "\x9b\x59", [0x1a1a] = "\x9b\x5a", [0x1a1b] = "\x9b\x5b",
  [0x1a1c] = "\x9b\x5c", [0x1a1d] = "\x9b\x5d", [0x1a1e] = "\x9b\x5e",
  [0x1a1f] = "\x9b\x5f", [0x1a20] = "\x9b\x60", [0x1a21] = "\x9b\x61",
  [0x1a22] = "\x9b\x62", [0x1a23] = "\x9b\x63", [0x1a24] = "\x9b\x64",
  [0x1a25] = "\x9b\x65", [0x1a26] = "\x9b\x66", [0x1a27] = "\x9b\x67",
  [0x1a28] = "\x9b\x68", [0x1a29] = "\x9b\x69", [0x1a2a] = "\x9b\x6a",
  [0x1a2b] = "\x9b\x6b", [0x1a2c] = "\x9b\x6c", [0x1a2d] = "\x9b\x6d",
  [0x1a2e] = "\x9b\x6e", [0x1a2f] = "\x9b\x6f", [0x1a30] = "\x9b\x70",
  [0x1a31] = "\x9b\x71", [0x1a32] = "\x9b\x72", [0x1a33] = "\x9b\x73",
  [0x1a34] = "\x9b\x74", [0x1a35] = "\x9b\x75", [0x1a36] = "\x9b\x76",
  [0x1a37] = "\x9b\x77", [0x1a38] = "\x9b\x78", [0x1a39] = "\x9b\x79",
  [0x1a3a] = "\x9b\x7a", [0x1a3b] = "\x9b\x7b", [0x1a3c] = "\x9b\x7c",
  [0x1a3d] = "\x9b\x7d", [0x1a3e] = "\x9b\x7e", [0x1a40] = "\x9b\x80",
  [0x1a41] = "\x9b\x81", [0x1a42] = "\x9b\x82", [0x1a43] = "\x9b\x83",
  [0x1a44] = "\x9b\x84", [0x1a45] = "\x9b\x85", [0x1a46] = "\x9b\x86",
  [0x1a47] = "\x9b\x87", [0x1a48] = "\x9b\x88", [0x1a49] = "\x9b\x89",
  [0x1a4a] = "\x9b\x8a", [0x1a4b] = "\x9b\x8b", [0x1a4c] = "\x9b\x8c",
  [0x1a4d] = "\x9b\x8d", [0x1a4e] = "\x9b\x8e", [0x1a4f] = "\x9b\x8f",
  [0x1a50] = "\x9b\x90", [0x1a51] = "\x9b\x91", [0x1a52] = "\x9b\x92",
  [0x1a53] = "\x9b\x93", [0x1a54] = "\x9b\x94", [0x1a55] = "\x9b\x95",
  [0x1a56] = "\x9b\x96", [0x1a57] = "\x9b\x97", [0x1a58] = "\x9b\x98",
  [0x1a59] = "\x9b\x99", [0x1a5a] = "\x9b\x9a", [0x1a5b] = "\x9b\x9b",
  [0x1a5c] = "\x9b\x9c", [0x1a5d] = "\x9b\x9d", [0x1a5e] = "\x9b\x9e",
  [0x1a5f] = "\x9b\x9f", [0x1a60] = "\x9b\xa0", [0x1a61] = "\x9b\xa1",
  [0x1a62] = "\x9b\xa2", [0x1a63] = "\x9b\xa3", [0x1a64] = "\x9b\xa4",
  [0x1a65] = "\x9b\xa5", [0x1a66] = "\x9b\xa6", [0x1a67] = "\x9b\xa7",
  [0x1a68] = "\x9b\xa8", [0x1a69] = "\x9b\xa9", [0x1a6a] = "\x9b\xaa",
  [0x1a6b] = "\x9b\xab", [0x1a6c] = "\x9b\xac", [0x1a6d] = "\x9b\xad",
  [0x1a6e] = "\x9b\xae", [0x1a6f] = "\x9b\xaf", [0x1a70] = "\x9b\xb0",
  [0x1a71] = "\x9b\xb1", [0x1a72] = "\x9b\xb2", [0x1a73] = "\x9b\xb3",
  [0x1a74] = "\x9b\xb4", [0x1a75] = "\x9b\xb5", [0x1a76] = "\x9b\xb6",
  [0x1a77] = "\x9b\xb7", [0x1a78] = "\x9b\xb8", [0x1a79] = "\x9b\xb9",
  [0x1a7a] = "\x9b\xba", [0x1a7b] = "\x9b\xbb", [0x1a7c] = "\x9b\xbc",
  [0x1a7d] = "\x9b\xbd", [0x1a7e] = "\x9b\xbe", [0x1a7f] = "\x9b\xbf",
  [0x1a80] = "\x9b\xc0", [0x1a81] = "\x9b\xc1", [0x1a82] = "\x9b\xc2",
  [0x1a83] = "\x9b\xc3", [0x1a84] = "\x9b\xc4", [0x1a85] = "\x9b\xc5",
  [0x1a86] = "\x9b\xc6", [0x1a87] = "\x9b\xc7", [0x1a88] = "\x9b\xc8",
  [0x1a89] = "\x9b\xc9", [0x1a8a] = "\x9b\xca", [0x1a8b] = "\x9b\xcb",
  [0x1a8c] = "\x9b\xcc", [0x1a8d] = "\x9b\xcd", [0x1a8e] = "\x9b\xce",
  [0x1a8f] = "\x9b\xcf", [0x1a90] = "\x9b\xd0", [0x1a91] = "\x9b\xd1",
  [0x1a92] = "\x9b\xd2", [0x1a93] = "\x9b\xd3", [0x1a94] = "\x9b\xd4",
  [0x1a95] = "\x9b\xd5", [0x1a96] = "\x9b\xd6", [0x1a97] = "\x9b\xd7",
  [0x1a98] = "\x9b\xd8", [0x1a99] = "\x9b\xd9", [0x1a9a] = "\x9b\xda",
  [0x1a9b] = "\x9b\xdb", [0x1a9c] = "\x9b\xdc", [0x1a9d] = "\x9b\xdd",
  [0x1a9e] = "\x9b\xde", [0x1a9f] = "\x9b\xdf", [0x1aa0] = "\x9b\xe0",
  [0x1aa1] = "\x9b\xe1", [0x1aa2] = "\x9b\xe2", [0x1aa3] = "\x9b\xe3",
  [0x1aa4] = "\x9b\xe4", [0x1aa5] = "\x9b\xe5", [0x1aa6] = "\x9b\xe6",
  [0x1aa7] = "\x9b\xe7", [0x1aa8] = "\x9b\xe8", [0x1aa9] = "\x9b\xe9",
  [0x1aaa] = "\x9b\xea", [0x1aab] = "\x9b\xeb", [0x1aac] = "\x9b\xec",
  [0x1aad] = "\x9b\xed", [0x1aae] = "\x9b\xee", [0x1aaf] = "\x9b\xef",
  [0x1ab0] = "\x9b\xf0", [0x1ab1] = "\x9b\xf1", [0x1ab2] = "\x9b\xf2",
  [0x1ab3] = "\x9b\xf3", [0x1ab4] = "\x9b\xf4", [0x1ab5] = "\x9b\xf5",
  [0x1ab6] = "\x9b\xf6", [0x1ab7] = "\x9b\xf7", [0x1ab8] = "\x9b\xf8",
  [0x1ab9] = "\x9b\xf9", [0x1aba] = "\x9b\xfa", [0x1abb] = "\x9b\xfb",
  [0x1abc] = "\x9b\xfc", [0x1abd] = "\x9b\xfd", [0x1abe] = "\x9b\xfe",
  [0x1b00] = "\x9c\x40", [0x1b01] = "\x9c\x41", [0x1b02] = "\x9c\x42",
  [0x1b03] = "\x9c\x43", [0x1b04] = "\x9c\x44", [0x1b05] = "\x9c\x45",
  [0x1b06] = "\x9c\x46", [0x1b07] = "\x9c\x47", [0x1b08] = "\x9c\x48",
  [0x1b09] = "\x9c\x49", [0x1b0a] = "\x9c\x4a", [0x1b0b] = "\x9c\x4b",
  [0x1b0c] = "\x9c\x4c", [0x1b0d] = "\x9c\x4d", [0x1b0e] = "\x9c\x4e",
  [0x1b0f] = "\x9c\x4f", [0x1b10] = "\x9c\x50", [0x1b11] = "\x9c\x51",
  [0x1b12] = "\x9c\x52", [0x1b13] = "\x9c\x53", [0x1b14] = "\x9c\x54",
  [0x1b15] = "\x9c\x55", [0x1b16] = "\x9c\x56", [0x1b17] = "\x9c\x57",
  [0x1b18] = "\x9c\x58", [0x1b19] = "\x9c\x59", [0x1b1a] = "\x9c\x5a",
  [0x1b1b] = "\x9c\x5b", [0x1b1c] = "\x9c\x5c", [0x1b1d] = "\x9c\x5d",
  [0x1b1e] = "\x9c\x5e", [0x1b1f] = "\x9c\x5f", [0x1b20] = "\x9c\x60",
  [0x1b21] = "\x9c\x61", [0x1b22] = "\x9c\x62", [0x1b23] = "\x9c\x63",
  [0x1b24] = "\x9c\x64", [0x1b25] = "\x9c\x65", [0x1b26] = "\x9c\x66",
  [0x1b27] = "\x9c\x67", [0x1b28] = "\x9c\x68", [0x1b29] = "\x9c\x69",
  [0x1b2a] = "\x9c\x6a", [0x1b2b] = "\x9c\x6b", [0x1b2c] = "\x9c\x6c",
  [0x1b2d] = "\x9c\x6d", [0x1b2e] = "\x9c\x6e", [0x1b2f] = "\x9c\x6f",
  [0x1b30] = "\x9c\x70", [0x1b31] = "\x9c\x71", [0x1b32] = "\x9c\x72",
  [0x1b33] = "\x9c\x73", [0x1b34] = "\x9c\x74", [0x1b35] = "\x9c\x75",
  [0x1b36] = "\x9c\x76", [0x1b37] = "\x9c\x77", [0x1b38] = "\x9c\x78",
  [0x1b39] = "\x9c\x79", [0x1b3a] = "\x9c\x7a", [0x1b3b] = "\x9c\x7b",
  [0x1b3c] = "\x9c\x7c", [0x1b3d] = "\x9c\x7d", [0x1b3e] = "\x9c\x7e",
  [0x1b40] = "\x9c\x80", [0x1b41] = "\x9c\x81", [0x1b42] = "\x9c\x82",
  [0x1b43] = "\x9c\x83", [0x1b44] = "\x9c\x84", [0x1b45] = "\x9c\x85",
  [0x1b46] = "\x9c\x86", [0x1b47] = "\x9c\x87", [0x1b48] = "\x9c\x88",
  [0x1b49] = "\x9c\x89", [0x1b4a] = "\x9c\x8a", [0x1b4b] = "\x9c\x8b",
  [0x1b4c] = "\x9c\x8c", [0x1b4d] = "\x9c\x8d", [0x1b4e] = "\x9c\x8e",
  [0x1b4f] = "\x9c\x8f", [0x1b50] = "\x9c\x90", [0x1b51] = "\x9c\x91",
  [0x1b52] = "\x9c\x92", [0x1b53] = "\x9c\x93", [0x1b54] = "\x9c\x94",
  [0x1b55] = "\x9c\x95", [0x1b56] = "\x9c\x96", [0x1b57] = "\x9c\x97",
  [0x1b58] = "\x9c\x98", [0x1b59] = "\x9c\x99", [0x1b5a] = "\x9c\x9a",
  [0x1b5b] = "\x9c\x9b", [0x1b5c] = "\x9c\x9c", [0x1b5d] = "\x9c\x9d",
  [0x1b5e] = "\x9c\x9e", [0x1b5f] = "\x9c\x9f", [0x1b60] = "\x9c\xa0",
  [0x1b61] = "\x9c\xa1", [0x1b62] = "\x9c\xa2", [0x1b63] = "\x9c\xa3",
  [0x1b64] = "\x9c\xa4", [0x1b65] = "\x9c\xa5", [0x1b66] = "\x9c\xa6",
  [0x1b67] = "\x9c\xa7", [0x1b68] = "\x9c\xa8", [0x1b69] = "\x9c\xa9",
  [0x1b6a] = "\x9c\xaa", [0x1b6b] = "\x9c\xab", [0x1b6c] = "\x9c\xac",
  [0x1b6d] = "\x9c\xad", [0x1b6e] = "\x9c\xae", [0x1b6f] = "\x9c\xaf",
  [0x1b70] = "\x9c\xb0", [0x1b71] = "\x9c\xb1", [0x1b72] = "\x9c\xb2",
  [0x1b73] = "\x9c\xb3", [0x1b74] = "\x9c\xb4", [0x1b75] = "\x9c\xb5",
  [0x1b76] = "\x9c\xb6", [0x1b77] = "\x9c\xb7", [0x1b78] = "\x9c\xb8",
  [0x1b79] = "\x9c\xb9", [0x1b7a] = "\x9c\xba", [0x1b7b] = "\x9c\xbb",
  [0x1b7c] = "\x9c\xbc", [0x1b7d] = "\x9c\xbd", [0x1b7e] = "\x9c\xbe",
  [0x1b7f] = "\x9c\xbf", [0x1b80] = "\x9c\xc0", [0x1b81] = "\x9c\xc1",
  [0x1b82] = "\x9c\xc2", [0x1b83] = "\x9c\xc3", [0x1b84] = "\x9c\xc4",
  [0x1b85] = "\x9c\xc5", [0x1b86] = "\x9c\xc6", [0x1b87] = "\x9c\xc7",
  [0x1b88] = "\x9c\xc8", [0x1b89] = "\x9c\xc9", [0x1b8a] = "\x9c\xca",
  [0x1b8b] = "\x9c\xcb", [0x1b8c] = "\x9c\xcc", [0x1b8d] = "\x9c\xcd",
  [0x1b8e] = "\x9c\xce", [0x1b8f] = "\x9c\xcf", [0x1b90] = "\x9c\xd0",
  [0x1b91] = "\x9c\xd1", [0x1b92] = "\x9c\xd2", [0x1b93] = "\x9c\xd3",
  [0x1b94] = "\x9c\xd4", [0x1b95] = "\x9c\xd5", [0x1b96] = "\x9c\xd6",
  [0x1b97] = "\x9c\xd7", [0x1b98] = "\x9c\xd8", [0x1b99] = "\x9c\xd9",
  [0x1b9a] = "\x9c\xda", [0x1b9b] = "\x9c\xdb", [0x1b9c] = "\x9c\xdc",
  [0x1b9d] = "\x9c\xdd", [0x1b9e] = "\x9c\xde", [0x1b9f] = "\x9c\xdf",
  [0x1ba0] = "\x9c\xe0", [0x1ba1] = "\x9c\xe1", [0x1ba2] = "\x9c\xe2",
  [0x1ba3] = "\x9c\xe3", [0x1ba4] = "\x9c\xe4", [0x1ba5] = "\x9c\xe5",
  [0x1ba6] = "\x9c\xe6", [0x1ba7] = "\x9c\xe7", [0x1ba8] = "\x9c\xe8",
  [0x1ba9] = "\x9c\xe9", [0x1baa] = "\x9c\xea", [0x1bab] = "\x9c\xeb",
  [0x1bac] = "\x9c\xec", [0x1bad] = "\x9c\xed", [0x1bae] = "\x9c\xee",
  [0x1baf] = "\x9c\xef", [0x1bb0] = "\x9c\xf0", [0x1bb1] = "\x9c\xf1",
  [0x1bb2] = "\x9c\xf2", [0x1bb3] = "\x9c\xf3", [0x1bb4] = "\x9c\xf4",
  [0x1bb5] = "\x9c\xf5", [0x1bb6] = "\x9c\xf6", [0x1bb7] = "\x9c\xf7",
  [0x1bb8] = "\x9c\xf8", [0x1bb9] = "\x9c\xf9", [0x1bba] = "\x9c\xfa",
  [0x1bbb] = "\x9c\xfb", [0x1bbc] = "\x9c\xfc", [0x1bbd] = "\x9c\xfd",
  [0x1bbe] = "\x9c\xfe", [0x1c00] = "\x9d\x40", [0x1c01] = "\x9d\x41",
  [0x1c02] = "\x9d\x42", [0x1c03] = "\x9d\x43", [0x1c04] = "\x9d\x44",
  [0x1c05] = "\x9d\x45", [0x1c06] = "\x9d\x46", [0x1c07] = "\x9d\x47",
  [0x1c08] = "\x9d\x48", [0x1c09] = "\x9d\x49", [0x1c0a] = "\x9d\x4a",
  [0x1c0b] = "\x9d\x4b", [0x1c0c] = "\x9d\x4c", [0x1c0d] = "\x9d\x4d",
  [0x1c0e] = "\x9d\x4e", [0x1c0f] = "\x9d\x4f", [0x1c10] = "\x9d\x50",
  [0x1c11] = "\x9d\x51", [0x1c12] = "\x9d\x52", [0x1c13] = "\x9d\x53",
  [0x1c14] = "\x9d\x54", [0x1c15] = "\x9d\x55", [0x1c16] = "\x9d\x56",
  [0x1c17] = "\x9d\x57", [0x1c18] = "\x9d\x58", [0x1c19] = "\x9d\x59",
  [0x1c1a] = "\x9d\x5a", [0x1c1b] = "\x9d\x5b", [0x1c1c] = "\x9d\x5c",
  [0x1c1d] = "\x9d\x5d", [0x1c1e] = "\x9d\x5e", [0x1c1f] = "\x9d\x5f",
  [0x1c20] = "\x9d\x60", [0x1c21] = "\x9d\x61", [0x1c22] = "\x9d\x62",
  [0x1c23] = "\x9d\x63", [0x1c24] = "\x9d\x64", [0x1c25] = "\x9d\x65",
  [0x1c26] = "\x9d\x66", [0x1c27] = "\x9d\x67", [0x1c28] = "\x9d\x68",
  [0x1c29] = "\x9d\x69", [0x1c2a] = "\x9d\x6a", [0x1c2b] = "\x9d\x6b",
  [0x1c2c] = "\x9d\x6c", [0x1c2d] = "\x9d\x6d", [0x1c2e] = "\x9d\x6e",
  [0x1c2f] = "\x9d\x6f", [0x1c30] = "\x9d\x70", [0x1c31] = "\x9d\x71",
  [0x1c32] = "\x9d\x72", [0x1c33] = "\x9d\x73", [0x1c34] = "\x9d\x74",
  [0x1c35] = "\x9d\x75", [0x1c36] = "\x9d\x76", [0x1c37] = "\x9d\x77",
  [0x1c38] = "\x9d\x78", [0x1c39] = "\x9d\x79", [0x1c3a] = "\x9d\x7a",
  [0x1c3b] = "\x9d\x7b", [0x1c3c] = "\x9d\x7c", [0x1c3d] = "\x9d\x7d",
  [0x1c3e] = "\x9d\x7e", [0x1c40] = "\x9d\x80", [0x1c41] = "\x9d\x81",
  [0x1c42] = "\x9d\x82", [0x1c43] = "\x9d\x83", [0x1c44] = "\x9d\x84",
  [0x1c45] = "\x9d\x85", [0x1c46] = "\x9d\x86", [0x1c47] = "\x9d\x87",
  [0x1c48] = "\x9d\x88", [0x1c49] = "\x9d\x89", [0x1c4a] = "\x9d\x8a",
  [0x1c4b] = "\x9d\x8b", [0x1c4c] = "\x9d\x8c", [0x1c4d] = "\x9d\x8d",
  [0x1c4e] = "\x9d\x8e", [0x1c4f] = "\x9d\x8f", [0x1c50] = "\x9d\x90",
  [0x1c51] = "\x9d\x91", [0x1c52] = "\x9d\x92", [0x1c53] = "\x9d\x93",
  [0x1c54] = "\x9d\x94", [0x1c55] = "\x9d\x95", [0x1c56] = "\x9d\x96",
  [0x1c57] = "\x9d\x97", [0x1c58] = "\x9d\x98", [0x1c59] = "\x9d\x99",
  [0x1c5a] = "\x9d\x9a", [0x1c5b] = "\x9d\x9b", [0x1c5c] = "\x9d\x9c",
  [0x1c5d] = "\x9d\x9d", [0x1c5e] = "\x9d\x9e", [0x1c5f] = "\x9d\x9f",
  [0x1c60] = "\x9d\xa0", [0x1c61] = "\x9d\xa1", [0x1c62] = "\x9d\xa2",
  [0x1c63] = "\x9d\xa3", [0x1c64] = "\x9d\xa4", [0x1c65] = "\x9d\xa5",
  [0x1c66] = "\x9d\xa6", [0x1c67] = "\x9d\xa7", [0x1c68] = "\x9d\xa8",
  [0x1c69] = "\x9d\xa9", [0x1c6a] = "\x9d\xaa", [0x1c6b] = "\x9d\xab",
  [0x1c6c] = "\x9d\xac", [0x1c6d] = "\x9d\xad", [0x1c6e] = "\x9d\xae",
  [0x1c6f] = "\x9d\xaf", [0x1c70] = "\x9d\xb0", [0x1c71] = "\x9d\xb1",
  [0x1c72] = "\x9d\xb2", [0x1c73] = "\x9d\xb3", [0x1c74] = "\x9d\xb4",
  [0x1c75] = "\x9d\xb5", [0x1c76] = "\x9d\xb6", [0x1c77] = "\x9d\xb7",
  [0x1c78] = "\x9d\xb8", [0x1c79] = "\x9d\xb9", [0x1c7a] = "\x9d\xba",
  [0x1c7b] = "\x9d\xbb", [0x1c7c] = "\x9d\xbc", [0x1c7d] = "\x9d\xbd",
  [0x1c7e] = "\x9d\xbe", [0x1c7f] = "\x9d\xbf", [0x1c80] = "\x9d\xc0",
  [0x1c81] = "\x9d\xc1", [0x1c82] = "\x9d\xc2", [0x1c83] = "\x9d\xc3",
  [0x1c84] = "\x9d\xc4", [0x1c85] = "\x9d\xc5", [0x1c86] = "\x9d\xc6",
  [0x1c87] = "\x9d\xc7", [0x1c88] = "\x9d\xc8", [0x1c89] = "\x9d\xc9",
  [0x1c8a] = "\x9d\xca", [0x1c8b] = "\x9d\xcb", [0x1c8c] = "\x9d\xcc",
  [0x1c8d] = "\x9d\xcd", [0x1c8e] = "\x9d\xce", [0x1c8f] = "\x9d\xcf",
  [0x1c90] = "\x9d\xd0", [0x1c91] = "\x9d\xd1", [0x1c92] = "\x9d\xd2",
  [0x1c93] = "\x9d\xd3", [0x1c94] = "\x9d\xd4", [0x1c95] = "\x9d\xd5",
  [0x1c96] = "\x9d\xd6", [0x1c97] = "\x9d\xd7", [0x1c98] = "\x9d\xd8",
  [0x1c99] = "\x9d\xd9", [0x1c9a] = "\x9d\xda", [0x1c9b] = "\x9d\xdb",
  [0x1c9c] = "\x9d\xdc", [0x1c9d] = "\x9d\xdd", [0x1c9e] = "\x9d\xde",
  [0x1c9f] = "\x9d\xdf", [0x1ca0] = "\x9d\xe0", [0x1ca1] = "\x9d\xe1",
  [0x1ca2] = "\x9d\xe2", [0x1ca3] = "\x9d\xe3", [0x1ca4] = "\x9d\xe4",
  [0x1ca5] = "\x9d\xe5", [0x1ca6] = "\x9d\xe6", [0x1ca7] = "\x9d\xe7",
  [0x1ca8] = "\x9d\xe8", [0x1ca9] = "\x9d\xe9", [0x1caa] = "\x9d\xea",
  [0x1cab] = "\x9d\xeb", [0x1cac] = "\x9d\xec", [0x1cad] = "\x9d\xed",
  [0x1cae] = "\x9d\xee", [0x1caf] = "\x9d\xef", [0x1cb0] = "\x9d\xf0",
  [0x1cb1] = "\x9d\xf1", [0x1cb2] = "\x9d\xf2", [0x1cb3] = "\x9d\xf3",
  [0x1cb4] = "\x9d\xf4", [0x1cb5] = "\x9d\xf5", [0x1cb6] = "\x9d\xf6",
  [0x1cb7] = "\x9d\xf7", [0x1cb8] = "\x9d\xf8", [0x1cb9] = "\x9d\xf9",
  [0x1cba] = "\x9d\xfa", [0x1cbb] = "\x9d\xfb", [0x1cbc] = "\x9d\xfc",
  [0x1cbd] = "\x9d\xfd", [0x1cbe] = "\x9d\xfe", [0x1d00] = "\x9e\x40",
  [0x1d01] = "\x9e\x41", [0x1d02] = "\x9e\x42", [0x1d03] = "\x9e\x43",
  [0x1d04] = "\x9e\x44", [0x1d05] = "\x9e\x45", [0x1d06] = "\x9e\x46",
  [0x1d07] = "\x9e\x47", [0x1d08] = "\x9e\x48", [0x1d09] = "\x9e\x49",
  [0x1d0a] = "\x9e\x4a", [0x1d0b] = "\x9e\x4b", [0x1d0c] = "\x9e\x4c",
  [0x1d0d] = "\x9e\x4d", [0x1d0e] = "\x9e\x4e", [0x1d0f] = "\x9e\x4f",
  [0x1d10] = "\x9e\x50", [0x1d11] = "\x9e\x51", [0x1d12] = "\x9e\x52",
  [0x1d13] = "\x9e\x53", [0x1d14] = "\x9e\x54", [0x1d15] = "\x9e\x55",
  [0x1d16] = "\x9e\x56", [0x1d17] = "\x9e\x57", [0x1d18] = "\x9e\x58",
  [0x1d19] = "\x9e\x59", [0x1d1a] = "\x9e\x5a", [0x1d1b] = "\x9e\x5b",
  [0x1d1c] = "\x9e\x5c", [0x1d1d] = "\x9e\x5d", [0x1d1e] = "\x9e\x5e",
  [0x1d1f] = "\x9e\x5f", [0x1d20] = "\x9e\x60", [0x1d21] = "\x9e\x61",
  [0x1d22] = "\x9e\x62", [0x1d23] = "\x9e\x63", [0x1d24] = "\x9e\x64",
  [0x1d25] = "\x9e\x65", [0x1d26] = "\x9e\x66", [0x1d27] = "\x9e\x67",
  [0x1d28] = "\x9e\x68", [0x1d29] = "\x9e\x69", [0x1d2a] = "\x9e\x6a",
  [0x1d2b] = "\x9e\x6b", [0x1d2c] = "\x9e\x6c", [0x1d2d] = "\x9e\x6d",
  [0x1d2e] = "\x9e\x6e", [0x1d2f] = "\x9e\x6f", [0x1d30] = "\x9e\x70",
  [0x1d31] = "\x9e\x71", [0x1d32] = "\x9e\x72", [0x1d33] = "\x9e\x73",
  [0x1d34] = "\x9e\x74", [0x1d35] = "\x9e\x75", [0x1d36] = "\x9e\x76",
  [0x1d37] = "\x9e\x77", [0x1d38] = "\x9e\x78", [0x1d39] = "\x9e\x79",
  [0x1d3a] = "\x9e\x7a", [0x1d3b] = "\x9e\x7b", [0x1d3c] = "\x9e\x7c",
  [0x1d3d] = "\x9e\x7d", [0x1d3e] = "\x9e\x7e", [0x1d40] = "\x9e\x80",
  [0x1d41] = "\x9e\x81", [0x1d42] = "\x9e\x82", [0x1d43] = "\x9e\x83",
  [0x1d44] = "\x9e\x84", [0x1d45] = "\x9e\x85", [0x1d46] = "\x9e\x86",
  [0x1d47] = "\x9e\x87", [0x1d48] = "\x9e\x88", [0x1d49] = "\x9e\x89",
  [0x1d4a] = "\x9e\x8a", [0x1d4b] = "\x9e\x8b", [0x1d4c] = "\x9e\x8c",
  [0x1d4d] = "\x9e\x8d", [0x1d4e] = "\x9e\x8e", [0x1d4f] = "\x9e\x8f",
  [0x1d50] = "\x9e\x90", [0x1d51] = "\x9e\x91", [0x1d52] = "\x9e\x92",
  [0x1d53] = "\x9e\x93", [0x1d54] = "\x9e\x94", [0x1d55] = "\x9e\x95",
  [0x1d56] = "\x9e\x96", [0x1d57] = "\x9e\x97", [0x1d58] = "\x9e\x98",
  [0x1d59] = "\x9e\x99", [0x1d5a] = "\x9e\x9a", [0x1d5b] = "\x9e\x9b",
  [0x1d5c] = "\x9e\x9c", [0x1d5d] = "\x9e\x9d", [0x1d5e] = "\x9e\x9e",
  [0x1d5f] = "\x9e\x9f", [0x1d60] = "\x9e\xa0", [0x1d61] = "\x9e\xa1",
  [0x1d62] = "\x9e\xa2", [0x1d63] = "\x9e\xa3", [0x1d64] = "\x9e\xa4",
  [0x1d65] = "\x9e\xa5", [0x1d66] = "\x9e\xa6", [0x1d67] = "\x9e\xa7",
  [0x1d68] = "\x9e\xa8", [0x1d69] = "\x9e\xa9", [0x1d6a] = "\x9e\xaa",
  [0x1d6b] = "\x9e\xab", [0x1d6c] = "\x9e\xac", [0x1d6d] = "\x9e\xad",
  [0x1d6e] = "\x9e\xae", [0x1d6f] = "\x9e\xaf", [0x1d70] = "\x9e\xb0",
  [0x1d71] = "\x9e\xb1", [0x1d72] = "\x9e\xb2", [0x1d73] = "\x9e\xb3",
  [0x1d74] = "\x9e\xb4", [0x1d75] = "\x9e\xb5", [0x1d76] = "\x9e\xb6",
  [0x1d77] = "\x9e\xb7", [0x1d78] = "\x9e\xb8", [0x1d79] = "\x9e\xb9",
  [0x1d7a] = "\x9e\xba", [0x1d7b] = "\x9e\xbb", [0x1d7c] = "\x9e\xbc",
  [0x1d7d] = "\x9e\xbd", [0x1d7e] = "\x9e\xbe", [0x1d7f] = "\x9e\xbf",
  [0x1d80] = "\x9e\xc0", [0x1d81] = "\x9e\xc1", [0x1d82] = "\x9e\xc2",
  [0x1d83] = "\x9e\xc3", [0x1d84] = "\x9e\xc4", [0x1d85] = "\x9e\xc5",
  [0x1d86] = "\x9e\xc6", [0x1d87] = "\x9e\xc7", [0x1d88] = "\x9e\xc8",
  [0x1d89] = "\x9e\xc9", [0x1d8a] = "\x9e\xca", [0x1d8b] = "\x9e\xcb",
  [0x1d8c] = "\x9e\xcc", [0x1d8d] = "\x9e\xcd", [0x1d8e] = "\x9e\xce",
  [0x1d8f] = "\x9e\xcf", [0x1d90] = "\x9e\xd0", [0x1d91] = "\x9e\xd1",
  [0x1d92] = "\x9e\xd2", [0x1d93] = "\x9e\xd3", [0x1d94] = "\x9e\xd4",
  [0x1d95] = "\x9e\xd5", [0x1d96] = "\x9e\xd6", [0x1d97] = "\x9e\xd7",
  [0x1d98] = "\x9e\xd8", [0x1d99] = "\x9e\xd9", [0x1d9a] = "\x9e\xda",
  [0x1d9b] = "\x9e\xdb", [0x1d9c] = "\x9e\xdc", [0x1d9d] = "\x9e\xdd",
  [0x1d9e] = "\x9e\xde", [0x1d9f] = "\x9e\xdf", [0x1da0] = "\x9e\xe0",
  [0x1da1] = "\x9e\xe1", [0x1da2] = "\x9e\xe2", [0x1da3] = "\x9e\xe3",
  [0x1da4] = "\x9e\xe4", [0x1da5] = "\x9e\xe5", [0x1da6] = "\x9e\xe6",
  [0x1da7] = "\x9e\xe7", [0x1da8] = "\x9e\xe8", [0x1da9] = "\x9e\xe9",
  [0x1daa] = "\x9e\xea", [0x1dab] = "\x9e\xeb", [0x1dac] = "\x9e\xec",
  [0x1dad] = "\x9e\xed", [0x1dae] = "\x9e\xee", [0x1daf] = "\x9e\xef",
  [0x1db0] = "\x9e\xf0", [0x1db1] = "\x9e\xf1", [0x1db2] = "\x9e\xf2",
  [0x1db3] = "\x9e\xf3", [0x1db4] = "\x9e\xf4", [0x1db5] = "\x9e\xf5",
  [0x1db6] = "\x9e\xf6", [0x1db7] = "\x9e\xf7", [0x1db8] = "\x9e\xf8",
  [0x1db9] = "\x9e\xf9", [0x1dba] = "\x9e\xfa", [0x1dbb] = "\x9e\xfb",
  [0x1dbc] = "\x9e\xfc", [0x1dbd] = "\x9e\xfd", [0x1dbe] = "\x9e\xfe",
  [0x1e00] = "\x9f\x40", [0x1e01] = "\x9f\x41", [0x1e02] = "\x9f\x42",
  [0x1e03] = "\x9f\x43", [0x1e04] = "\x9f\x44", [0x1e05] = "\x9f\x45",
  [0x1e06] = "\x9f\x46", [0x1e07] = "\x9f\x47", [0x1e08] = "\x9f\x48",
  [0x1e09] = "\x9f\x49", [0x1e0a] = "\x9f\x4a", [0x1e0b] = "\x9f\x4b",
  [0x1e0c] = "\x9f\x4c", [0x1e0d] = "\x9f\x4d", [0x1e0e] = "\x9f\x4e",
  [0x1e0f] = "\x9f\x4f", [0x1e10] = "\x9f\x50", [0x1e11] = "\x9f\x51",
  [0x1e12] = "\x9f\x52", [0x1e13] = "\x9f\x53", [0x1e14] = "\x9f\x54",
  [0x1e15] = "\x9f\x55", [0x1e16] = "\x9f\x56", [0x1e17] = "\x9f\x57",
  [0x1e18] = "\x9f\x58", [0x1e19] = "\x9f\x59", [0x1e1a] = "\x9f\x5a",
  [0x1e1b] = "\x9f\x5b", [0x1e1c] = "\x9f\x5c", [0x1e1d] = "\x9f\x5d",
  [0x1e1e] = "\x9f\x5e", [0x1e1f] = "\x9f\x5f", [0x1e20] = "\x9f\x60",
  [0x1e21] = "\x9f\x61", [0x1e22] = "\x9f\x62", [0x1e23] = "\x9f\x63",
  [0x1e24] = "\x9f\x64", [0x1e25] = "\x9f\x65", [0x1e26] = "\x9f\x66",
  [0x1e27] = "\x9f\x67", [0x1e28] = "\x9f\x68", [0x1e29] = "\x9f\x69",
  [0x1e2a] = "\x9f\x6a", [0x1e2b] = "\x9f\x6b", [0x1e2c] = "\x9f\x6c",
  [0x1e2d] = "\x9f\x6d", [0x1e2e] = "\x9f\x6e", [0x1e2f] = "\x9f\x6f",
  [0x1e30] = "\x9f\x70", [0x1e31] = "\x9f\x71", [0x1e32] = "\x9f\x72",
  [0x1e33] = "\x9f\x73", [0x1e34] = "\x9f\x74", [0x1e35] = "\x9f\x75",
  [0x1e36] = "\x9f\x76", [0x1e37] = "\x9f\x77", [0x1e38] = "\x9f\x78",
  [0x1e39] = "\x9f\x79", [0x1e3a] = "\x9f\x7a", [0x1e3b] = "\x9f\x7b",
  [0x1e3c] = "\x9f\x7c", [0x1e3d] = "\x9f\x7d", [0x1e3e] = "\x9f\x7e",
  [0x1e40] = "\x9f\x80", [0x1e41] = "\x9f\x81", [0x1e42] = "\x9f\x82",
  [0x1e43] = "\x9f\x83", [0x1e44] = "\x9f\x84", [0x1e45] = "\x9f\x85",
  [0x1e46] = "\x9f\x86", [0x1e47] = "\x9f\x87", [0x1e48] = "\x9f\x88",
  [0x1e49] = "\x9f\x89", [0x1e4a] = "\x9f\x8a", [0x1e4b] = "\x9f\x8b",
  [0x1e4c] = "\x9f\x8c", [0x1e4d] = "\x9f\x8d", [0x1e4e] = "\x9f\x8e",
  [0x1e4f] = "\x9f\x8f", [0x1e50] = "\x9f\x90", [0x1e51] = "\x9f\x91",
  [0x1e52] = "\x9f\x92", [0x1e53] = "\x9f\x93", [0x1e54] = "\x9f\x94",
  [0x1e55] = "\x9f\x95", [0x1e56] = "\x9f\x96", [0x1e57] = "\x9f\x97",
  [0x1e58] = "\x9f\x98", [0x1e59] = "\x9f\x99", [0x1e5a] = "\x9f\x9a",
  [0x1e5b] = "\x9f\x9b", [0x1e5c] = "\x9f\x9c", [0x1e5d] = "\x9f\x9d",
  [0x1e5e] = "\x9f\x9e", [0x1e5f] = "\x9f\x9f", [0x1e60] = "\x9f\xa0",
  [0x1e61] = "\x9f\xa1", [0x1e62] = "\x9f\xa2", [0x1e63] = "\x9f\xa3",
  [0x1e64] = "\x9f\xa4", [0x1e65] = "\x9f\xa5", [0x1e66] = "\x9f\xa6",
  [0x1e67] = "\x9f\xa7", [0x1e68] = "\x9f\xa8", [0x1e69] = "\x9f\xa9",
  [0x1e6a] = "\x9f\xaa", [0x1e6b] = "\x9f\xab", [0x1e6c] = "\x9f\xac",
  [0x1e6d] = "\x9f\xad", [0x1e6e] = "\x9f\xae", [0x1e6f] = "\x9f\xaf",
  [0x1e70] = "\x9f\xb0", [0x1e71] = "\x9f\xb1", [0x1e72] = "\x9f\xb2",
  [0x1e73] = "\x9f\xb3", [0x1e74] = "\x9f\xb4", [0x1e75] = "\x9f\xb5",
  [0x1e76] = "\x9f\xb6", [0x1e77] = "\x9f\xb7", [0x1e78] = "\x9f\xb8",
  [0x1e79] = "\x9f\xb9", [0x1e7a] = "\x9f\xba", [0x1e7b] = "\x9f\xbb",
  [0x1e7c] = "\x9f\xbc", [0x1e7d] = "\x9f\xbd", [0x1e7e] = "\x9f\xbe",
  [0x1e7f] = "\x9f\xbf", [0x1e80] = "\x9f\xc0", [0x1e81] = "\x9f\xc1",
  [0x1e82] = "\x9f\xc2", [0x1e83] = "\x9f\xc3", [0x1e84] = "\x9f\xc4",
  [0x1e85] = "\x9f\xc5", [0x1e86] = "\x9f\xc6", [0x1e87] = "\x9f\xc7",
  [0x1e88] = "\x9f\xc8", [0x1e89] = "\x9f\xc9", [0x1e8a] = "\x9f\xca",
  [0x1e8b] = "\x9f\xcb", [0x1e8c] = "\x9f\xcc", [0x1e8d] = "\x9f\xcd",
  [0x1e8e] = "\x9f\xce", [0x1e8f] = "\x9f\xcf", [0x1e90] = "\x9f\xd0",
  [0x1e91] = "\x9f\xd1", [0x1e92] = "\x9f\xd2", [0x1e93] = "\x9f\xd3",
  [0x1e94] = "\x9f\xd4", [0x1e95] = "\x9f\xd5", [0x1e96] = "\x9f\xd6",
  [0x1e97] = "\x9f\xd7", [0x1e98] = "\x9f\xd8", [0x1e99] = "\x9f\xd9",
  [0x1e9a] = "\x9f\xda", [0x1e9b] = "\x9f\xdb", [0x1e9c] = "\x9f\xdc",
  [0x1e9d] = "\x9f\xdd", [0x1e9e] = "\x9f\xde", [0x1e9f] = "\x9f\xdf",
  [0x1ea0] = "\x9f\xe0", [0x1ea1] = "\x9f\xe1", [0x1ea2] = "\x9f\xe2",
  [0x1ea3] = "\x9f\xe3", [0x1ea4] = "\x9f\xe4", [0x1ea5] = "\x9f\xe5",
  [0x1ea6] = "\x9f\xe6", [0x1ea7] = "\x9f\xe7", [0x1ea8] = "\x9f\xe8",
  [0x1ea9] = "\x9f\xe9", [0x1eaa] = "\x9f\xea", [0x1eab] = "\x9f\xeb",
  [0x1eac] = "\x9f\xec", [0x1ead] = "\x9f\xed", [0x1eae] = "\x9f\xee",
  [0x1eaf] = "\x9f\xef", [0x1eb0] = "\x9f\xf0", [0x1eb1] = "\x9f\xf1",
  [0x1eb2] = "\x9f\xf2", [0x1eb3] = "\x9f\xf3", [0x1eb4] = "\x9f\xf4",
  [0x1eb5] = "\x9f\xf5", [0x1eb6] = "\x9f\xf6", [0x1eb7] = "\x9f\xf7",
  [0x1eb8] = "\x9f\xf8", [0x1eb9] = "\x9f\xf9", [0x1eba] = "\x9f\xfa",
  [0x1ebb] = "\x9f\xfb", [0x1ebc] = "\x9f\xfc", [0x1ebd] = "\x9f\xfd",
  [0x1ebe] = "\x9f\xfe", [0x1f00] = "\xa0\x40", [0x1f01] = "\xa0\x41",
  [0x1f02] = "\xa0\x42", [0x1f03] = "\xa0\x43", [0x1f04] = "\xa0\x44",
  [0x1f05] = "\xa0\x45", [0x1f06] = "\xa0\x46", [0x1f07] = "\xa0\x47",
  [0x1f08] = "\xa0\x48", [0x1f09] = "\xa0\x49", [0x1f0a] = "\xa0\x4a",
  [0x1f0b] = "\xa0\x4b", [0x1f0c] = "\xa0\x4c", [0x1f0d] = "\xa0\x4d",
  [0x1f0e] = "\xa0\x4e", [0x1f0f] = "\xa0\x4f", [0x1f10] = "\xa0\x50",
  [0x1f11] = "\xa0\x51", [0x1f12] = "\xa0\x52", [0x1f13] = "\xa0\x53",
  [0x1f14] = "\xa0\x54", [0x1f15] = "\xa0\x55", [0x1f16] = "\xa0\x56",
  [0x1f17] = "\xa0\x57", [0x1f18] = "\xa0\x58", [0x1f19] = "\xa0\x59",
  [0x1f1a] = "\xa0\x5a", [0x1f1b] = "\xa0\x5b", [0x1f1c] = "\xa0\x5c",
  [0x1f1d] = "\xa0\x5d", [0x1f1e] = "\xa0\x5e", [0x1f1f] = "\xa0\x5f",
  [0x1f20] = "\xa0\x60", [0x1f21] = "\xa0\x61", [0x1f22] = "\xa0\x62",
  [0x1f23] = "\xa0\x63", [0x1f24] = "\xa0\x64", [0x1f25] = "\xa0\x65",
  [0x1f26] = "\xa0\x66", [0x1f27] = "\xa0\x67", [0x1f28] = "\xa0\x68",
  [0x1f29] = "\xa0\x69", [0x1f2a] = "\xa0\x6a", [0x1f2b] = "\xa0\x6b",
  [0x1f2c] = "\xa0\x6c", [0x1f2d] = "\xa0\x6d", [0x1f2e] = "\xa0\x6e",
  [0x1f2f] = "\xa0\x6f", [0x1f30] = "\xa0\x70", [0x1f31] = "\xa0\x71",
  [0x1f32] = "\xa0\x72", [0x1f33] = "\xa0\x73", [0x1f34] = "\xa0\x74",
  [0x1f35] = "\xa0\x75", [0x1f36] = "\xa0\x76", [0x1f37] = "\xa0\x77",
  [0x1f38] = "\xa0\x78", [0x1f39] = "\xa0\x79", [0x1f3a] = "\xa0\x7a",
  [0x1f3b] = "\xa0\x7b", [0x1f3c] = "\xa0\x7c", [0x1f3d] = "\xa0\x7d",
  [0x1f3e] = "\xa0\x7e", [0x1f40] = "\xa0\x80", [0x1f41] = "\xa0\x81",
  [0x1f42] = "\xa0\x82", [0x1f43] = "\xa0\x83", [0x1f44] = "\xa0\x84",
  [0x1f45] = "\xa0\x85", [0x1f46] = "\xa0\x86", [0x1f47] = "\xa0\x87",
  [0x1f48] = "\xa0\x88", [0x1f49] = "\xa0\x89", [0x1f4a] = "\xa0\x8a",
  [0x1f4b] = "\xa0\x8b", [0x1f4c] = "\xa0\x8c", [0x1f4d] = "\xa0\x8d",
  [0x1f4e] = "\xa0\x8e", [0x1f4f] = "\xa0\x8f", [0x1f50] = "\xa0\x90",
  [0x1f51] = "\xa0\x91", [0x1f52] = "\xa0\x92", [0x1f53] = "\xa0\x93",
  [0x1f54] = "\xa0\x94", [0x1f55] = "\xa0\x95", [0x1f56] = "\xa0\x96",
  [0x1f57] = "\xa0\x97", [0x1f58] = "\xa0\x98", [0x1f59] = "\xa0\x99",
  [0x1f5a] = "\xa0\x9a", [0x1f5b] = "\xa0\x9b", [0x1f5c] = "\xa0\x9c",
  [0x1f5d] = "\xa0\x9d", [0x1f5e] = "\xa0\x9e", [0x1f5f] = "\xa0\x9f",
  [0x1f60] = "\xa0\xa0", [0x1f61] = "\xa0\xa1", [0x1f62] = "\xa0\xa2",
  [0x1f63] = "\xa0\xa3", [0x1f64] = "\xa0\xa4", [0x1f65] = "\xa0\xa5",
  [0x1f66] = "\xa0\xa6", [0x1f67] = "\xa0\xa7", [0x1f68] = "\xa0\xa8",
  [0x1f69] = "\xa0\xa9", [0x1f6a] = "\xa0\xaa", [0x1f6b] = "\xa0\xab",
  [0x1f6c] = "\xa0\xac", [0x1f6d] = "\xa0\xad", [0x1f6e] = "\xa0\xae",
  [0x1f6f] = "\xa0\xaf", [0x1f70] = "\xa0\xb0", [0x1f71] = "\xa0\xb1",
  [0x1f72] = "\xa0\xb2", [0x1f73] = "\xa0\xb3", [0x1f74] = "\xa0\xb4",
  [0x1f75] = "\xa0\xb5", [0x1f76] = "\xa0\xb6", [0x1f77] = "\xa0\xb7",
  [0x1f78] = "\xa0\xb8", [0x1f79] = "\xa0\xb9", [0x1f7a] = "\xa0\xba",
  [0x1f7b] = "\xa0\xbb", [0x1f7c] = "\xa0\xbc", [0x1f7d] = "\xa0\xbd",
  [0x1f7e] = "\xa0\xbe", [0x1f7f] = "\xa0\xbf", [0x1f80] = "\xa0\xc0",
  [0x1f81] = "\xa0\xc1", [0x1f82] = "\xa0\xc2", [0x1f83] = "\xa0\xc3",
  [0x1f84] = "\xa0\xc4", [0x1f85] = "\xa0\xc5", [0x1f86] = "\xa0\xc6",
  [0x1f87] = "\xa0\xc7", [0x1f88] = "\xa0\xc8", [0x1f89] = "\xa0\xc9",
  [0x1f8a] = "\xa0\xca", [0x1f8b] = "\xa0\xcb", [0x1f8c] = "\xa0\xcc",
  [0x1f8d] = "\xa0\xcd", [0x1f8e] = "\xa0\xce", [0x1f8f] = "\xa0\xcf",
  [0x1f90] = "\xa0\xd0", [0x1f91] = "\xa0\xd1", [0x1f92] = "\xa0\xd2",
  [0x1f93] = "\xa0\xd3", [0x1f94] = "\xa0\xd4", [0x1f95] = "\xa0\xd5",
  [0x1f96] = "\xa0\xd6", [0x1f97] = "\xa0\xd7", [0x1f98] = "\xa0\xd8",
  [0x1f99] = "\xa0\xd9", [0x1f9a] = "\xa0\xda", [0x1f9b] = "\xa0\xdb",
  [0x1f9c] = "\xa0\xdc", [0x1f9d] = "\xa0\xdd", [0x1f9e] = "\xa0\xde",
  [0x1f9f] = "\xa0\xdf", [0x1fa0] = "\xa0\xe0", [0x1fa1] = "\xa0\xe1",
  [0x1fa2] = "\xa0\xe2", [0x1fa3] = "\xa0\xe3", [0x1fa4] = "\xa0\xe4",
  [0x1fa5] = "\xa0\xe5", [0x1fa6] = "\xa0\xe6", [0x1fa7] = "\xa0\xe7",
  [0x1fa8] = "\xa0\xe8", [0x1fa9] = "\xa0\xe9", [0x1faa] = "\xa0\xea",
  [0x1fab] = "\xa0\xeb", [0x1fac] = "\xa0\xec", [0x1fad] = "\xa0\xed",
  [0x1fae] = "\xa0\xee", [0x1faf] = "\xa0\xef", [0x1fb0] = "\xa0\xf0",
  [0x1fb1] = "\xa0\xf1", [0x1fb2] = "\xa0\xf2", [0x1fb3] = "\xa0\xf3",
  [0x1fb4] = "\xa0\xf4", [0x1fb5] = "\xa0\xf5", [0x1fb6] = "\xa0\xf6",
  [0x1fb7] = "\xa0\xf7", [0x1fb8] = "\xa0\xf8", [0x1fb9] = "\xa0\xf9",
  [0x1fba] = "\xa0\xfa", [0x1fbb] = "\xa0\xfb", [0x1fbc] = "\xa0\xfc",
  [0x1fbd] = "\xa0\xfd", [0x1fbe] = "\xa0\xfe", [0x2000] = "\xa1\x40",
  [0x2001] = "\xa1\x41", [0x2002] = "\xa1\x42", [0x2003] = "\xa1\x43",
  [0x2004] = "\xa1\x44", [0x2005] = "\xa1\x45", [0x2006] = "\xa1\x46",
  [0x2007] = "\xa1\x47", [0x2008] = "\xa1\x48", [0x2009] = "\xa1\x49",
  [0x200a] = "\xa1\x4a", [0x200b] = "\xa1\x4b", [0x200c] = "\xa1\x4c",
  [0x200d] = "\xa1\x4d", [0x200e] = "\xa1\x4e", [0x200f] = "\xa1\x4f",
  [0x2010] = "\xa1\x50", [0x2011] = "\xa1\x51", [0x2012] = "\xa1\x52",
  [0x2013] = "\xa1\x53", [0x2014] = "\xa1\x54", [0x2015] = "\xa1\x55",
  [0x2016] = "\xa1\x56", [0x2017] = "\xa1\x57", [0x2018] = "\xa1\x58",
  [0x2019] = "\xa1\x59", [0x201a] = "\xa1\x5a", [0x201b] = "\xa1\x5b",
  [0x201c] = "\xa1\x5c", [0x201d] = "\xa1\x5d", [0x201e] = "\xa1\x5e",
  [0x201f] = "\xa1\x5f", [0x2020] = "\xa1\x60", [0x2021] = "\xa1\x61",
  [0x2022] = "\xa1\x62", [0x2023] = "\xa1\x63", [0x2024] = "\xa1\x64",
  [0x2025] = "\xa1\x65", [0x2026] = "\xa1\x66", [0x2027] = "\xa1\x67",
  [0x2028] = "\xa1\x68", [0x2029] = "\xa1\x69", [0x202a] = "\xa1\x6a",
  [0x202b] = "\xa1\x6b", [0x202c] = "\xa1\x6c", [0x202d] = "\xa1\x6d",
  [0x202e] = "\xa1\x6e", [0x202f] = "\xa1\x6f", [0x2030] = "\xa1\x70",
  [0x2031] = "\xa1\x71", [0x2032] = "\xa1\x72", [0x2033] = "\xa1\x73",
  [0x2034] = "\xa1\x74", [0x2035] = "\xa1\x75", [0x2036] = "\xa1\x76",
  [0x2037] = "\xa1\x77", [0x2038] = "\xa1\x78", [0x2039] = "\xa1\x79",
  [0x203a] = "\xa1\x7a", [0x203b] = "\xa1\x7b", [0x203c] = "\xa1\x7c",
  [0x203d] = "\xa1\x7d", [0x203e] = "\xa1\x7e", [0x2040] = "\xa1\x80",
  [0x2041] = "\xa1\x81", [0x2042] = "\xa1\x82", [0x2043] = "\xa1\x83",
  [0x2044] = "\xa1\x84", [0x2045] = "\xa1\x85", [0x2046] = "\xa1\x86",
  [0x2047] = "\xa1\x87", [0x2048] = "\xa1\x88", [0x2049] = "\xa1\x89",
  [0x204a] = "\xa1\x8a", [0x204b] = "\xa1\x8b", [0x204c] = "\xa1\x8c",
  [0x204d] = "\xa1\x8d", [0x204e] = "\xa1\x8e", [0x204f] = "\xa1\x8f",
  [0x2050] = "\xa1\x90", [0x2051] = "\xa1\x91", [0x2052] = "\xa1\x92",
  [0x2053] = "\xa1\x93", [0x2054] = "\xa1\x94", [0x2055] = "\xa1\x95",
  [0x2056] = "\xa1\x96", [0x2057] = "\xa1\x97", [0x2058] = "\xa1\x98",
  [0x2059] = "\xa1\x99", [0x205a] = "\xa1\x9a", [0x205b] = "\xa1\x9b",
  [0x205c] = "\xa1\x9c", [0x205d] = "\xa1\x9d", [0x205e] = "\xa1\x9e",
  [0x205f] = "\xa1\x9f", [0x2060] = "\xa1\xa0", [0x2061] = "\xa1\xa1",
  [0x2062] = "\xa1\xa2", [0x2063] = "\xa1\xa3", [0x2064] = "\xa1\xa4",
  [0x2065] = "\xa1\xa5", [0x2066] = "\xa1\xa6", [0x2067] = "\xa1\xa7",
  [0x2068] = "\xa1\xa8", [0x2069] = "\xa1\xa9", [0x206a] = "\xa1\xaa",
  [0x206b] = "\xa1\xab", [0x206c] = "\xa1\xac", [0x206d] = "\xa1\xad",
  [0x206e] = "\xa1\xae", [0x206f] = "\xa1\xaf", [0x2070] = "\xa1\xb0",
  [0x2071] = "\xa1\xb1", [0x2072] = "\xa1\xb2", [0x2073] = "\xa1\xb3",
  [0x2074] = "\xa1\xb4", [0x2075] = "\xa1\xb5", [0x2076] = "\xa1\xb6",
  [0x2077] = "\xa1\xb7", [0x2078] = "\xa1\xb8", [0x2079] = "\xa1\xb9",
  [0x207a] = "\xa1\xba", [0x207b] = "\xa1\xbb", [0x207c] = "\xa1\xbc",
  [0x207d] = "\xa1\xbd", [0x207e] = "\xa1\xbe", [0x207f] = "\xa1\xbf",
  [0x2080] = "\xa1\xc0", [0x2081] = "\xa1\xc1", [0x2082] = "\xa1\xc2",
  [0x2083] = "\xa1\xc3", [0x2084] = "\xa1\xc4", [0x2085] = "\xa1\xc5",
  [0x2086] = "\xa1\xc6", [0x2087] = "\xa1\xc7", [0x2088] = "\xa1\xc8",
  [0x2089] = "\xa1\xc9", [0x208a] = "\xa1\xca", [0x208b] = "\xa1\xcb",
  [0x208c] = "\xa1\xcc", [0x208d] = "\xa1\xcd", [0x208e] = "\xa1\xce",
  [0x208f] = "\xa1\xcf", [0x2090] = "\xa1\xd0", [0x2091] = "\xa1\xd1",
  [0x2092] = "\xa1\xd2", [0x2093] = "\xa1\xd3", [0x2094] = "\xa1\xd4",
  [0x2095] = "\xa1\xd5", [0x2096] = "\xa1\xd6", [0x2097] = "\xa1\xd7",
  [0x2098] = "\xa1\xd8", [0x2099] = "\xa1\xd9", [0x209a] = "\xa1\xda",
  [0x209b] = "\xa1\xdb", [0x209c] = "\xa1\xdc", [0x209d] = "\xa1\xdd",
  [0x209e] = "\xa1\xde", [0x209f] = "\xa1\xdf", [0x20a0] = "\xa1\xe0",
  [0x20a1] = "\xa1\xe1", [0x20a2] = "\xa1\xe2", [0x20a3] = "\xa1\xe3",
  [0x20a4] = "\xa1\xe4", [0x20a5] = "\xa1\xe5", [0x20a6] = "\xa1\xe6",
  [0x20a7] = "\xa1\xe7", [0x20a8] = "\xa1\xe8", [0x20a9] = "\xa1\xe9",
  [0x20aa] = "\xa1\xea", [0x20ab] = "\xa1\xeb", [0x20ac] = "\xa1\xec",
  [0x20ad] = "\xa1\xed", [0x20ae] = "\xa1\xee", [0x20af] = "\xa1\xef",
  [0x20b0] = "\xa1\xf0", [0x20b1] = "\xa1\xf1", [0x20b2] = "\xa1\xf2",
  [0x20b3] = "\xa1\xf3", [0x20b4] = "\xa1\xf4", [0x20b5] = "\xa1\xf5",
  [0x20b6] = "\xa1\xf6", [0x20b7] = "\xa1\xf7", [0x20b8] = "\xa1\xf8",
  [0x20b9] = "\xa1\xf9", [0x20ba] = "\xa1\xfa", [0x20bb] = "\xa1\xfb",
  [0x20bc] = "\xa1\xfc", [0x20bd] = "\xa1\xfd", [0x20be] = "\xa1\xfe",
  [0x2100] = "\xa2\x40", [0x2101] = "\xa2\x41", [0x2102] = "\xa2\x42",
  [0x2103] = "\xa2\x43", [0x2104] = "\xa2\x44", [0x2105] = "\xa2\x45",
  [0x2106] = "\xa2\x46", [0x2107] = "\xa2\x47", [0x2108] = "\xa2\x48",
  [0x2109] = "\xa2\x49", [0x210a] = "\xa2\x4a", [0x210b] = "\xa2\x4b",
  [0x210c] = "\xa2\x4c", [0x210d] = "\xa2\x4d", [0x210e] = "\xa2\x4e",
  [0x210f] = "\xa2\x4f", [0x2110] = "\xa2\x50", [0x2111] = "\xa2\x51",
  [0x2112] = "\xa2\x52", [0x2113] = "\xa2\x53", [0x2114] = "\xa2\x54",
  [0x2115] = "\xa2\x55", [0x2116] = "\xa2\x56", [0x2117] = "\xa2\x57",
  [0x2118] = "\xa2\x58", [0x2119] = "\xa2\x59", [0x211a] = "\xa2\x5a",
  [0x211b] = "\xa2\x5b", [0x211c] = "\xa2\x5c", [0x211d] = "\xa2\x5d",
  [0x211e] = "\xa2\x5e", [0x211f] = "\xa2\x5f", [0x2120] = "\xa2\x60",
  [0x2121] = "\xa2\x61", [0x2122] = "\xa2\x62", [0x2123] = "\xa2\x63",
  [0x2124] = "\xa2\x64", [0x2125] = "\xa2\x65", [0x2126] = "\xa2\x66",
  [0x2127] = "\xa2\x67", [0x2128] = "\xa2\x68", [0x2129] = "\xa2\x69",
  [0x212a] = "\xa2\x6a", [0x212b] = "\xa2\x6b", [0x212c] = "\xa2\x6c",
  [0x212d] = "\xa2\x6d", [0x212e] = "\xa2\x6e", [0x212f] = "\xa2\x6f",
  [0x2130] = "\xa2\x70", [0x2131] = "\xa2\x71", [0x2132] = "\xa2\x72",
  [0x2133] = "\xa2\x73", [0x2134] = "\xa2\x74", [0x2135] = "\xa2\x75",
  [0x2136] = "\xa2\x76", [0x2137] = "\xa2\x77", [0x2138] = "\xa2\x78",
  [0x2139] = "\xa2\x79", [0x213a] = "\xa2\x7a", [0x213b] = "\xa2\x7b",
  [0x213c] = "\xa2\x7c", [0x213d] = "\xa2\x7d", [0x213e] = "\xa2\x7e",
  [0x2140] = "\xa2\x80", [0x2141] = "\xa2\x81", [0x2142] = "\xa2\x82",
  [0x2143] = "\xa2\x83", [0x2144] = "\xa2\x84", [0x2145] = "\xa2\x85",
  [0x2146] = "\xa2\x86", [0x2147] = "\xa2\x87", [0x2148] = "\xa2\x88",
  [0x2149] = "\xa2\x89", [0x214a] = "\xa2\x8a", [0x214b] = "\xa2\x8b",
  [0x214c] = "\xa2\x8c", [0x214d] = "\xa2\x8d", [0x214e] = "\xa2\x8e",
  [0x214f] = "\xa2\x8f", [0x2150] = "\xa2\x90", [0x2151] = "\xa2\x91",
  [0x2152] = "\xa2\x92", [0x2153] = "\xa2\x93", [0x2154] = "\xa2\x94",
  [0x2155] = "\xa2\x95", [0x2156] = "\xa2\x96", [0x2157] = "\xa2\x97",
  [0x2158] = "\xa2\x98", [0x2159] = "\xa2\x99", [0x215a] = "\xa2\x9a",
  [0x215b] = "\xa2\x9b", [0x215c] = "\xa2\x9c", [0x215d] = "\xa2\x9d",
  [0x215e] = "\xa2\x9e", [0x215f] = "\xa2\x9f", [0x2160] = "\xa2\xa0",
  [0x2161] = "\xa2\xa1", [0x2162] = "\xa2\xa2", [0x2163] = "\xa2\xa3",
  [0x2164] = "\xa2\xa4", [0x2165] = "\xa2\xa5", [0x2166] = "\xa2\xa6",
  [0x2167] = "\xa2\xa7", [0x2168] = "\xa2\xa8", [0x2169] = "\xa2\xa9",
  [0x216a] = "\xa2\xaa", [0x216b] = "\xa2\xab", [0x216c] = "\xa2\xac",
  [0x216d] = "\xa2\xad", [0x216e] = "\xa2\xae", [0x216f] = "\xa2\xaf",
  [0x2170] = "\xa2\xb0", [0x2171] = "\xa2\xb1", [0x2172] = "\xa2\xb2",
  [0x2173] = "\xa2\xb3", [0x2174] = "\xa2\xb4", [0x2175] = "\xa2\xb5",
  [0x2176] = "\xa2\xb6", [0x2177] = "\xa2\xb7", [0x2178] = "\xa2\xb8",
  [0x2179] = "\xa2\xb9", [0x217a] = "\xa2\xba", [0x217b] = "\xa2\xbb",
  [0x217c] = "\xa2\xbc", [0x217d] = "\xa2\xbd", [0x217e] = "\xa2\xbe",
  [0x217f] = "\xa2\xbf", [0x2180] = "\xa2\xc0", [0x2181] = "\xa2\xc1",
  [0x2182] = "\xa2\xc2", [0x2183] = "\xa2\xc3", [0x2184] = "\xa2\xc4",
  [0x2185] = "\xa2\xc5", [0x2186] = "\xa2\xc6", [0x2187] = "\xa2\xc7",
  [0x2188] = "\xa2\xc8", [0x2189] = "\xa2\xc9", [0x218a] = "\xa2\xca",
  [0x218b] = "\xa2\xcb", [0x218c] = "\xa2\xcc", [0x218d] = "\xa2\xcd",
  [0x218e] = "\xa2\xce", [0x218f] = "\xa2\xcf", [0x2190] = "\xa2\xd0",
  [0x2191] = "\xa2\xd1", [0x2192] = "\xa2\xd2", [0x2193] = "\xa2\xd3",
  [0x2194] = "\xa2\xd4", [0x2195] = "\xa2\xd5", [0x2196] = "\xa2\xd6",
  [0x2197] = "\xa2\xd7", [0x2198] = "\xa2\xd8", [0x2199] = "\xa2\xd9",
  [0x219a] = "\xa2\xda", [0x219b] = "\xa2\xdb", [0x219c] = "\xa2\xdc",
  [0x219d] = "\xa2\xdd", [0x219e] = "\xa2\xde", [0x219f] = "\xa2\xdf",
  [0x21a0] = "\xa2\xe0", [0x21a1] = "\xa2\xe1", [0x21a2] = "\xa2\xe2",
  [0x21a3] = "\xa2\xe3", [0x21a4] = "\xa2\xe4", [0x21a5] = "\xa2\xe5",
  [0x21a6] = "\xa2\xe6", [0x21a7] = "\xa2\xe7", [0x21a8] = "\xa2\xe8",
  [0x21a9] = "\xa2\xe9", [0x21aa] = "\xa2\xea", [0x21ab] = "\xa2\xeb",
  [0x21ac] = "\xa2\xec", [0x21ad] = "\xa2\xed", [0x21ae] = "\xa2\xee",
  [0x21af] = "\xa2\xef", [0x21b0] = "\xa2\xf0", [0x21b1] = "\xa2\xf1",
  [0x21b2] = "\xa2\xf2", [0x21b3] = "\xa2\xf3", [0x21b4] = "\xa2\xf4",
  [0x21b5] = "\xa2\xf5", [0x21b6] = "\xa2\xf6", [0x21b7] = "\xa2\xf7",
  [0x21b8] = "\xa2\xf8", [0x21b9] = "\xa2\xf9", [0x21ba] = "\xa2\xfa",
  [0x21bb] = "\xa2\xfb", [0x21bc] = "\xa2\xfc", [0x21bd] = "\xa2\xfd",
  [0x21be] = "\xa2\xfe", [0x2200] = "\xa3\x40", [0x2201] = "\xa3\x41",
  [0x2202] = "\xa3\x42", [0x2203] = "\xa3\x43", [0x2204] = "\xa3\x44",
  [0x2205] = "\xa3\x45", [0x2206] = "\xa3\x46", [0x2207] = "\xa3\x47",
  [0x2208] = "\xa3\x48", [0x2209] = "\xa3\x49", [0x220a] = "\xa3\x4a",
  [0x220b] = "\xa3\x4b", [0x220c] = "\xa3\x4c", [0x220d] = "\xa3\x4d",
  [0x220e] = "\xa3\x4e", [0x220f] = "\xa3\x4f", [0x2210] = "\xa3\x50",
  [0x2211] = "\xa3\x51", [0x2212] = "\xa3\x52", [0x2213] = "\xa3\x53",
  [0x2214] = "\xa3\x54", [0x2215] = "\xa3\x55", [0x2216] = "\xa3\x56",
  [0x2217] = "\xa3\x57", [0x2218] = "\xa3\x58", [0x2219] = "\xa3\x59",
  [0x221a] = "\xa3\x5a", [0x221b] = "\xa3\x5b", [0x221c] = "\xa3\x5c",
  [0x221d] = "\xa3\x5d", [0x221e] = "\xa3\x5e", [0x221f] = "\xa3\x5f",
  [0x2220] = "\xa3\x60", [0x2221] = "\xa3\x61", [0x2222] = "\xa3\x62",
  [0x2223] = "\xa3\x63", [0x2224] = "\xa3\x64", [0x2225] = "\xa3\x65",
  [0x2226] = "\xa3\x66", [0x2227] = "\xa3\x67", [0x2228] = "\xa3\x68",
  [0x2229] = "\xa3\x69", [0x222a] = "\xa3\x6a", [0x222b] = "\xa3\x6b",
  [0x222c] = "\xa3\x6c", [0x222d] = "\xa3\x6d", [0x222e] = "\xa3\x6e",
  [0x222f] = "\xa3\x6f", [0x2230] = "\xa3\x70", [0x2231] = "\xa3\x71",
  [0x2232] = "\xa3\x72", [0x2233] = "\xa3\x73", [0x2234] = "\xa3\x74",
  [0x2235] = "\xa3\x75", [0x2236] = "\xa3\x76", [0x2237] = "\xa3\x77",
  [0x2238] = "\xa3\x78", [0x2239] = "\xa3\x79", [0x223a] = "\xa3\x7a",
  [0x223b] = "\xa3\x7b", [0x223c] = "\xa3\x7c", [0x223d] = "\xa3\x7d",
  [0x223e] = "\xa3\x7e", [0x2240] = "\xa3\x80", [0x2241] = "\xa3\x81",
  [0x2242] = "\xa3\x82", [0x2243] = "\xa3\x83", [0x2244] = "\xa3\x84",
  [0x2245] = "\xa3\x85", [0x2246] = "\xa3\x86", [0x2247] = "\xa3\x87",
  [0x2248] = "\xa3\x88", [0x2249] = "\xa3\x89", [0x224a] = "\xa3\x8a",
  [0x224b] = "\xa3\x8b", [0x224c] = "\xa3\x8c", [0x224d] = "\xa3\x8d",
  [0x224e] = "\xa3\x8e", [0x224f] = "\xa3\x8f", [0x2250] = "\xa3\x90",
  [0x2251] = "\xa3\x91", [0x2252] = "\xa3\x92", [0x2253] = "\xa3\x93",
  [0x2254] = "\xa3\x94", [0x2255] = "\xa3\x95", [0x2256] = "\xa3\x96",
  [0x2257] = "\xa3\x97", [0x2258] = "\xa3\x98", [0x2259] = "\xa3\x99",
  [0x225a] = "\xa3\x9a", [0x225b] = "\xa3\x9b", [0x225c] = "\xa3\x9c",
  [0x225d] = "\xa3\x9d", [0x225e] = "\xa3\x9e", [0x225f] = "\xa3\x9f",
  [0x2260] = "\xa3\xa0", [0x2261] = "\xa3\xa1", [0x2262] = "\xa3\xa2",
  [0x2263] = "\xa3\xa3", [0x2264] = "\xa3\xa4", [0x2265] = "\xa3\xa5",
  [0x2266] = "\xa3\xa6", [0x2267] = "\xa3\xa7", [0x2268] = "\xa3\xa8",
  [0x2269] = "\xa3\xa9", [0x226a] = "\xa3\xaa", [0x226b] = "\xa3\xab",
  [0x226c] = "\xa3\xac", [0x226d] = "\xa3\xad", [0x226e] = "\xa3\xae",
  [0x226f] = "\xa3\xaf", [0x2270] = "\xa3\xb0", [0x2271] = "\xa3\xb1",
  [0x2272] = "\xa3\xb2", [0x2273] = "\xa3\xb3", [0x2274] = "\xa3\xb4",
  [0x2275] = "\xa3\xb5", [0x2276] = "\xa3\xb6", [0x2277] = "\xa3\xb7",
  [0x2278] = "\xa3\xb8", [0x2279] = "\xa3\xb9", [0x227a] = "\xa3\xba",
  [0x227b] = "\xa3\xbb", [0x227c] = "\xa3\xbc", [0x227d] = "\xa3\xbd",
  [0x227e] = "\xa3\xbe", [0x227f] = "\xa3\xbf", [0x2280] = "\xa3\xc0",
  [0x2281] = "\xa3\xc1", [0x2282] = "\xa3\xc2", [0x2283] = "\xa3\xc3",
  [0x2284] = "\xa3\xc4", [0x2285] = "\xa3\xc5", [0x2286] = "\xa3\xc6",
  [0x2287] = "\xa3\xc7", [0x2288] = "\xa3\xc8", [0x2289] = "\xa3\xc9",
  [0x228a] = "\xa3\xca", [0x228b] = "\xa3\xcb", [0x228c] = "\xa3\xcc",
  [0x228d] = "\xa3\xcd", [0x228e] = "\xa3\xce", [0x228f] = "\xa3\xcf",
  [0x2290] = "\xa3\xd0", [0x2291] = "\xa3\xd1", [0x2292] = "\xa3\xd2",
  [0x2293] = "\xa3\xd3", [0x2294] = "\xa3\xd4", [0x2295] = "\xa3\xd5",
  [0x2296] = "\xa3\xd6", [0x2297] = "\xa3\xd7", [0x2298] = "\xa3\xd8",
  [0x2299] = "\xa3\xd9", [0x229a] = "\xa3\xda", [0x229b] = "\xa3\xdb",
  [0x229c] = "\xa3\xdc", [0x229d] = "\xa3\xdd", [0x229e] = "\xa3\xde",
  [0x229f] = "\xa3\xdf", [0x22a0] = "\xa3\xe0", [0x22a1] = "\xa3\xe1",
  [0x22a2] = "\xa3\xe2", [0x22a3] = "\xa3\xe3", [0x22a4] = "\xa3\xe4",
  [0x22a5] = "\xa3\xe5", [0x22a6] = "\xa3\xe6", [0x22a7] = "\xa3\xe7",
  [0x22a8] = "\xa3\xe8", [0x22a9] = "\xa3\xe9", [0x22aa] = "\xa3\xea",
  [0x22ab] = "\xa3\xeb", [0x22ac] = "\xa3\xec", [0x22ad] = "\xa3\xed",
  [0x22ae] = "\xa3\xee", [0x22af] = "\xa3\xef", [0x22b0] = "\xa3\xf0",
  [0x22b1] = "\xa3\xf1", [0x22b2] = "\xa3\xf2", [0x22b3] = "\xa3\xf3",
  [0x22b4] = "\xa3\xf4", [0x22b5] = "\xa3\xf5", [0x22b6] = "\xa3\xf6",
  [0x22b7] = "\xa3\xf7", [0x22b8] = "\xa3\xf8", [0x22b9] = "\xa3\xf9",
  [0x22ba] = "\xa3\xfa", [0x22bb] = "\xa3\xfb", [0x22bc] = "\xa3\xfc",
  [0x22bd] = "\xa3\xfd", [0x22be] = "\xa3\xfe", [0x2300] = "\xa4\x40",
  [0x2301] = "\xa4\x41", [0x2302] = "\xa4\x42", [0x2303] = "\xa4\x43",
  [0x2304] = "\xa4\x44", [0x2305] = "\xa4\x45", [0x2306] = "\xa4\x46",
  [0x2307] = "\xa4\x47", [0x2308] = "\xa4\x48", [0x2309] = "\xa4\x49",
  [0x230a] = "\xa4\x4a", [0x230b] = "\xa4\x4b", [0x230c] = "\xa4\x4c",
  [0x230d] = "\xa4\x4d", [0x230e] = "\xa4\x4e", [0x230f] = "\xa4\x4f",
  [0x2310] = "\xa4\x50", [0x2311] = "\xa4\x51", [0x2312] = "\xa4\x52",
  [0x2313] = "\xa4\x53", [0x2314] = "\xa4\x54", [0x2315] = "\xa4\x55",
  [0x2316] = "\xa4\x56", [0x2317] = "\xa4\x57", [0x2318] = "\xa4\x58",
  [0x2319] = "\xa4\x59", [0x231a] = "\xa4\x5a", [0x231b] = "\xa4\x5b",
  [0x231c] = "\xa4\x5c", [0x231d] = "\xa4\x5d", [0x231e] = "\xa4\x5e",
  [0x231f] = "\xa4\x5f", [0x2320] = "\xa4\x60", [0x2321] = "\xa4\x61",
  [0x2322] = "\xa4\x62", [0x2323] = "\xa4\x63", [0x2324] = "\xa4\x64",
  [0x2325] = "\xa4\x65", [0x2326] = "\xa4\x66", [0x2327] = "\xa4\x67",
  [0x2328] = "\xa4\x68", [0x2329] = "\xa4\x69", [0x232a] = "\xa4\x6a",
  [0x232b] = "\xa4\x6b", [0x232c] = "\xa4\x6c", [0x232d] = "\xa4\x6d",
  [0x232e] = "\xa4\x6e", [0x232f] = "\xa4\x6f", [0x2330] = "\xa4\x70",
  [0x2331] = "\xa4\x71", [0x2332] = "\xa4\x72", [0x2333] = "\xa4\x73",
  [0x2334] = "\xa4\x74", [0x2335] = "\xa4\x75", [0x2336] = "\xa4\x76",
  [0x2337] = "\xa4\x77", [0x2338] = "\xa4\x78", [0x2339] = "\xa4\x79",
  [0x233a] = "\xa4\x7a", [0x233b] = "\xa4\x7b", [0x233c] = "\xa4\x7c",
  [0x233d] = "\xa4\x7d", [0x233e] = "\xa4\x7e", [0x2340] = "\xa4\x80",
  [0x2341] = "\xa4\x81", [0x2342] = "\xa4\x82", [0x2343] = "\xa4\x83",
  [0x2344] = "\xa4\x84", [0x2345] = "\xa4\x85", [0x2346] = "\xa4\x86",
  [0x2347] = "\xa4\x87", [0x2348] = "\xa4\x88", [0x2349] = "\xa4\x89",
  [0x234a] = "\xa4\x8a", [0x234b] = "\xa4\x8b", [0x234c] = "\xa4\x8c",
  [0x234d] = "\xa4\x8d", [0x234e] = "\xa4\x8e", [0x234f] = "\xa4\x8f",
  [0x2350] = "\xa4\x90", [0x2351] = "\xa4\x91", [0x2352] = "\xa4\x92",
  [0x2353] = "\xa4\x93", [0x2354] = "\xa4\x94", [0x2355] = "\xa4\x95",
  [0x2356] = "\xa4\x96", [0x2357] = "\xa4\x97", [0x2358] = "\xa4\x98",
  [0x2359] = "\xa4\x99", [0x235a] = "\xa4\x9a", [0x235b] = "\xa4\x9b",
  [0x235c] = "\xa4\x9c", [0x235d] = "\xa4\x9d", [0x235e] = "\xa4\x9e",
  [0x235f] = "\xa4\x9f", [0x2360] = "\xa4\xa0", [0x2361] = "\xa4\xa1",
  [0x2362] = "\xa4\xa2", [0x2363] = "\xa4\xa3", [0x2364] = "\xa4\xa4",
  [0x2365] = "\xa4\xa5", [0x2366] = "\xa4\xa6", [0x2367] = "\xa4\xa7",
  [0x2368] = "\xa4\xa8", [0x2369] = "\xa4\xa9", [0x236a] = "\xa4\xaa",
  [0x236b] = "\xa4\xab", [0x236c] = "\xa4\xac", [0x236d] = "\xa4\xad",
  [0x236e] = "\xa4\xae", [0x236f] = "\xa4\xaf", [0x2370] = "\xa4\xb0",
  [0x2371] = "\xa4\xb1", [0x2372] = "\xa4\xb2", [0x2373] = "\xa4\xb3",
  [0x2374] = "\xa4\xb4", [0x2375] = "\xa4\xb5", [0x2376] = "\xa4\xb6",
  [0x2377] = "\xa4\xb7", [0x2378] = "\xa4\xb8", [0x2379] = "\xa4\xb9",
  [0x237a] = "\xa4\xba", [0x237b] = "\xa4\xbb", [0x237c] = "\xa4\xbc",
  [0x237d] = "\xa4\xbd", [0x237e] = "\xa4\xbe", [0x237f] = "\xa4\xbf",
  [0x2380] = "\xa4\xc0", [0x2381] = "\xa4\xc1", [0x2382] = "\xa4\xc2",
  [0x2383] = "\xa4\xc3", [0x2384] = "\xa4\xc4", [0x2385] = "\xa4\xc5",
  [0x2386] = "\xa4\xc6", [0x2387] = "\xa4\xc7", [0x2388] = "\xa4\xc8",
  [0x2389] = "\xa4\xc9", [0x238a] = "\xa4\xca", [0x238b] = "\xa4\xcb",
  [0x238c] = "\xa4\xcc", [0x238d] = "\xa4\xcd", [0x238e] = "\xa4\xce",
  [0x238f] = "\xa4\xcf", [0x2390] = "\xa4\xd0", [0x2391] = "\xa4\xd1",
  [0x2392] = "\xa4\xd2", [0x2393] = "\xa4\xd3", [0x2394] = "\xa4\xd4",
  [0x2395] = "\xa4\xd5", [0x2396] = "\xa4\xd6", [0x2397] = "\xa4\xd7",
  [0x2398] = "\xa4\xd8", [0x2399] = "\xa4\xd9", [0x239a] = "\xa4\xda",
  [0x239b] = "\xa4\xdb", [0x239c] = "\xa4\xdc", [0x239d] = "\xa4\xdd",
  [0x239e] = "\xa4\xde", [0x239f] = "\xa4\xdf", [0x23a0] = "\xa4\xe0",
  [0x23a1] = "\xa4\xe1", [0x23a2] = "\xa4\xe2", [0x23a3] = "\xa4\xe3",
  [0x23a4] = "\xa4\xe4", [0x23a5] = "\xa4\xe5", [0x23a6] = "\xa4\xe6",
  [0x23a7] = "\xa4\xe7", [0x23a8] = "\xa4\xe8", [0x23a9] = "\xa4\xe9",
  [0x23aa] = "\xa4\xea", [0x23ab] = "\xa4\xeb", [0x23ac] = "\xa4\xec",
  [0x23ad] = "\xa4\xed", [0x23ae] = "\xa4\xee", [0x23af] = "\xa4\xef",
  [0x23b0] = "\xa4\xf0", [0x23b1] = "\xa4\xf1", [0x23b2] = "\xa4\xf2",
  [0x23b3] = "\xa4\xf3", [0x23b4] = "\xa4\xf4", [0x23b5] = "\xa4\xf5",
  [0x23b6] = "\xa4\xf6", [0x23b7] = "\xa4\xf7", [0x23b8] = "\xa4\xf8",
  [0x23b9] = "\xa4\xf9", [0x23ba] = "\xa4\xfa", [0x23bb] = "\xa4\xfb",
  [0x23bc] = "\xa4\xfc", [0x23bd] = "\xa4\xfd", [0x23be] = "\xa4\xfe",
  [0x2400] = "\xa5\x40", [0x2401] = "\xa5\x41", [0x2402] = "\xa5\x42",
  [0x2403] = "\xa5\x43", [0x2404] = "\xa5\x44", [0x2405] = "\xa5\x45",
  [0x2406] = "\xa5\x46", [0x2407] = "\xa5\x47", [0x2408] = "\xa5\x48",
  [0x2409] = "\xa5\x49", [0x240a] = "\xa5\x4a", [0x240b] = "\xa5\x4b",
  [0x240c] = "\xa5\x4c", [0x240d] = "\xa5\x4d", [0x240e] = "\xa5\x4e",
  [0x240f] = "\xa5\x4f", [0x2410] = "\xa5\x50", [0x2411] = "\xa5\x51",
  [0x2412] = "\xa5\x52", [0x2413] = "\xa5\x53", [0x2414] = "\xa5\x54",
  [0x2415] = "\xa5\x55", [0x2416] = "\xa5\x56", [0x2417] = "\xa5\x57",
  [0x2418] = "\xa5\x58", [0x2419] = "\xa5\x59", [0x241a] = "\xa5\x5a",
  [0x241b] = "\xa5\x5b", [0x241c] = "\xa5\x5c", [0x241d] = "\xa5\x5d",
  [0x241e] = "\xa5\x5e", [0x241f] = "\xa5\x5f", [0x2420] = "\xa5\x60",
  [0x2421] = "\xa5\x61", [0x2422] = "\xa5\x62", [0x2423] = "\xa5\x63",
  [0x2424] = "\xa5\x64", [0x2425] = "\xa5\x65", [0x2426] = "\xa5\x66",
  [0x2427] = "\xa5\x67", [0x2428] = "\xa5\x68", [0x2429] = "\xa5\x69",
  [0x242a] = "\xa5\x6a", [0x242b] = "\xa5\x6b", [0x242c] = "\xa5\x6c",
  [0x242d] = "\xa5\x6d", [0x242e] = "\xa5\x6e", [0x242f] = "\xa5\x6f",
  [0x2430] = "\xa5\x70", [0x2431] = "\xa5\x71", [0x2432] = "\xa5\x72",
  [0x2433] = "\xa5\x73", [0x2434] = "\xa5\x74", [0x2435] = "\xa5\x75",
  [0x2436] = "\xa5\x76", [0x2437] = "\xa5\x77", [0x2438] = "\xa5\x78",
  [0x2439] = "\xa5\x79", [0x243a] = "\xa5\x7a", [0x243b] = "\xa5\x7b",
  [0x243c] = "\xa5\x7c", [0x243d] = "\xa5\x7d", [0x243e] = "\xa5\x7e",
  [0x2440] = "\xa5\x80", [0x2441] = "\xa5\x81", [0x2442] = "\xa5\x82",
  [0x2443] = "\xa5\x83", [0x2444] = "\xa5\x84", [0x2445] = "\xa5\x85",
  [0x2446] = "\xa5\x86", [0x2447] = "\xa5\x87", [0x2448] = "\xa5\x88",
  [0x2449] = "\xa5\x89", [0x244a] = "\xa5\x8a", [0x244b] = "\xa5\x8b",
  [0x244c] = "\xa5\x8c", [0x244d] = "\xa5\x8d", [0x244e] = "\xa5\x8e",
  [0x244f] = "\xa5\x8f", [0x2450] = "\xa5\x90", [0x2451] = "\xa5\x91",
  [0x2452] = "\xa5\x92", [0x2453] = "\xa5\x93", [0x2454] = "\xa5\x94",
  [0x2455] = "\xa5\x95", [0x2456] = "\xa5\x96", [0x2457] = "\xa5\x97",
  [0x2458] = "\xa5\x98", [0x2459] = "\xa5\x99", [0x245a] = "\xa5\x9a",
  [0x245b] = "\xa5\x9b", [0x245c] = "\xa5\x9c", [0x245d] = "\xa5\x9d",
  [0x245e] = "\xa5\x9e", [0x245f] = "\xa5\x9f", [0x2460] = "\xa5\xa0",
  [0x2461] = "\xa5\xa1", [0x2462] = "\xa5\xa2", [0x2463] = "\xa5\xa3",
  [0x2464] = "\xa5\xa4", [0x2465] = "\xa5\xa5", [0x2466] = "\xa5\xa6",
  [0x2467] = "\xa5\xa7", [0x2468] = "\xa5\xa8", [0x2469] = "\xa5\xa9",
  [0x246a] = "\xa5\xaa", [0x246b] = "\xa5\xab", [0x246c] = "\xa5\xac",
  [0x246d] = "\xa5\xad", [0x246e] = "\xa5\xae", [0x246f] = "\xa5\xaf",
  [0x2470] = "\xa5\xb0", [0x2471] = "\xa5\xb1", [0x2472] = "\xa5\xb2",
  [0x2473] = "\xa5\xb3", [0x2474] = "\xa5\xb4", [0x2475] = "\xa5\xb5",
  [0x2476] = "\xa5\xb6", [0x2477] = "\xa5\xb7", [0x2478] = "\xa5\xb8",
  [0x2479] = "\xa5\xb9", [0x247a] = "\xa5\xba", [0x247b] = "\xa5\xbb",
  [0x247c] = "\xa5\xbc", [0x247d] = "\xa5\xbd", [0x247e] = "\xa5\xbe",
  [0x247f] = "\xa5\xbf", [0x2480] = "\xa5\xc0", [0x2481] = "\xa5\xc1",
  [0x2482] = "\xa5\xc2", [0x2483] = "\xa5\xc3", [0x2484] = "\xa5\xc4",
  [0x2485] = "\xa5\xc5", [0x2486] = "\xa5\xc6", [0x2487] = "\xa5\xc7",
  [0x2488] = "\xa5\xc8", [0x2489] = "\xa5\xc9", [0x248a] = "\xa5\xca",
  [0x248b] = "\xa5\xcb", [0x248c] = "\xa5\xcc", [0x248d] = "\xa5\xcd",
  [0x248e] = "\xa5\xce", [0x248f] = "\xa5\xcf", [0x2490] = "\xa5\xd0",
  [0x2491] = "\xa5\xd1", [0x2492] = "\xa5\xd2", [0x2493] = "\xa5\xd3",
  [0x2494] = "\xa5\xd4", [0x2495] = "\xa5\xd5", [0x2496] = "\xa5\xd6",
  [0x2497] = "\xa5\xd7", [0x2498] = "\xa5\xd8", [0x2499] = "\xa5\xd9",
  [0x249a] = "\xa5\xda", [0x249b] = "\xa5\xdb", [0x249c] = "\xa5\xdc",
  [0x249d] = "\xa5\xdd", [0x249e] = "\xa5\xde", [0x249f] = "\xa5\xdf",
  [0x24a0] = "\xa5\xe0", [0x24a1] = "\xa5\xe1", [0x24a2] = "\xa5\xe2",
  [0x24a3] = "\xa5\xe3", [0x24a4] = "\xa5\xe4", [0x24a5] = "\xa5\xe5",
  [0x24a6] = "\xa5\xe6", [0x24a7] = "\xa5\xe7", [0x24a8] = "\xa5\xe8",
  [0x24a9] = "\xa5\xe9", [0x24aa] = "\xa5\xea", [0x24ab] = "\xa5\xeb",
  [0x24ac] = "\xa5\xec", [0x24ad] = "\xa5\xed", [0x24ae] = "\xa5\xee",
  [0x24af] = "\xa5\xef", [0x24b0] = "\xa5\xf0", [0x24b1] = "\xa5\xf1",
  [0x24b2] = "\xa5\xf2", [0x24b3] = "\xa5\xf3", [0x24b4] = "\xa5\xf4",
  [0x24b5] = "\xa5\xf5", [0x24b6] = "\xa5\xf6", [0x24b7] = "\xa5\xf7",
  [0x24b8] = "\xa5\xf8", [0x24b9] = "\xa5\xf9", [0x24ba] = "\xa5\xfa",
  [0x24bb] = "\xa5\xfb", [0x24bc] = "\xa5\xfc", [0x24bd] = "\xa5\xfd",
  [0x24be] = "\xa5\xfe", [0x2500] = "\xa6\x40", [0x2501] = "\xa6\x41",
  [0x2502] = "\xa6\x42", [0x2503] = "\xa6\x43", [0x2504] = "\xa6\x44",
  [0x2505] = "\xa6\x45", [0x2506] = "\xa6\x46", [0x2507] = "\xa6\x47",
  [0x2508] = "\xa6\x48", [0x2509] = "\xa6\x49", [0x250a] = "\xa6\x4a",
  [0x250b] = "\xa6\x4b", [0x250c] = "\xa6\x4c", [0x250d] = "\xa6\x4d",
  [0x250e] = "\xa6\x4e", [0x250f] = "\xa6\x4f", [0x2510] = "\xa6\x50",
  [0x2511] = "\xa6\x51", [0x2512] = "\xa6\x52", [0x2513] = "\xa6\x53",
  [0x2514] = "\xa6\x54", [0x2515] = "\xa6\x55", [0x2516] = "\xa6\x56",
  [0x2517] = "\xa6\x57", [0x2518] = "\xa6\x58", [0x2519] = "\xa6\x59",
  [0x251a] = "\xa6\x5a", [0x251b] = "\xa6\x5b", [0x251c] = "\xa6\x5c",
  [0x251d] = "\xa6\x5d", [0x251e] = "\xa6\x5e", [0x251f] = "\xa6\x5f",
  [0x2520] = "\xa6\x60", [0x2521] = "\xa6\x61", [0x2522] = "\xa6\x62",
  [0x2523] = "\xa6\x63", [0x2524] = "\xa6\x64", [0x2525] = "\xa6\x65",
  [0x2526] = "\xa6\x66", [0x2527] = "\xa6\x67", [0x2528] = "\xa6\x68",
  [0x2529] = "\xa6\x69", [0x252a] = "\xa6\x6a", [0x252b] = "\xa6\x6b",
  [0x252c] = "\xa6\x6c", [0x252d] = "\xa6\x6d", [0x252e] = "\xa6\x6e",
  [0x252f] = "\xa6\x6f", [0x2530] = "\xa6\x70", [0x2531] = "\xa6\x71",
  [0x2532] = "\xa6\x72", [0x2533] = "\xa6\x73", [0x2534] = "\xa6\x74",
  [0x2535] = "\xa6\x75", [0x2536] = "\xa6\x76", [0x2537] = "\xa6\x77",
  [0x2538] = "\xa6\x78", [0x2539] = "\xa6\x79", [0x253a] = "\xa6\x7a",
  [0x253b] = "\xa6\x7b", [0x253c] = "\xa6\x7c", [0x253d] = "\xa6\x7d",
  [0x253e] = "\xa6\x7e", [0x2540] = "\xa6\x80", [0x2541] = "\xa6\x81",
  [0x2542] = "\xa6\x82", [0x2543] = "\xa6\x83", [0x2544] = "\xa6\x84",
  [0x2545] = "\xa6\x85", [0x2546] = "\xa6\x86", [0x2547] = "\xa6\x87",
  [0x2548] = "\xa6\x88", [0x2549] = "\xa6\x89", [0x254a] = "\xa6\x8a",
  [0x254b] = "\xa6\x8b", [0x254c] = "\xa6\x8c", [0x254d] = "\xa6\x8d",
  [0x254e] = "\xa6\x8e", [0x254f] = "\xa6\x8f", [0x2550] = "\xa6\x90",
  [0x2551] = "\xa6\x91", [0x2552] = "\xa6\x92", [0x2553] = "\xa6\x93",
  [0x2554] = "\xa6\x94", [0x2555] = "\xa6\x95", [0x2556] = "\xa6\x96",
  [0x2557] = "\xa6\x97", [0x2558] = "\xa6\x98", [0x2559] = "\xa6\x99",
  [0x255a] = "\xa6\x9a", [0x255b] = "\xa6\x9b", [0x255c] = "\xa6\x9c",
  [0x255d] = "\xa6\x9d", [0x255e] = "\xa6\x9e", [0x255f] = "\xa6\x9f",
  [0x2560] = "\xa6\xa0", [0x2561] = "\xa6\xa1", [0x2562] = "\xa6\xa2",
  [0x2563] = "\xa6\xa3", [0x2564] = "\xa6\xa4", [0x2565] = "\xa6\xa5",
  [0x2566] = "\xa6\xa6", [0x2567] = "\xa6\xa7", [0x2568] = "\xa6\xa8",
  [0x2569] = "\xa6\xa9", [0x256a] = "\xa6\xaa", [0x256b] = "\xa6\xab",
  [0x256c] = "\xa6\xac", [0x256d] = "\xa6\xad", [0x256e] = "\xa6\xae",
  [0x256f] = "\xa6\xaf", [0x2570] = "\xa6\xb0", [0x2571] = "\xa6\xb1",
  [0x2572] = "\xa6\xb2", [0x2573] = "\xa6\xb3", [0x2574] = "\xa6\xb4",
  [0x2575] = "\xa6\xb5", [0x2576] = "\xa6\xb6", [0x2577] = "\xa6\xb7",
  [0x2578] = "\xa6\xb8", [0x2579] = "\xa6\xb9", [0x257a] = "\xa6\xba",
  [0x257b] = "\xa6\xbb", [0x257c] = "\xa6\xbc", [0x257d] = "\xa6\xbd",
  [0x257e] = "\xa6\xbe", [0x257f] = "\xa6\xbf", [0x2580] = "\xa6\xc0",
  [0x2581] = "\xa6\xc1", [0x2582] = "\xa6\xc2", [0x2583] = "\xa6\xc3",
  [0x2584] = "\xa6\xc4", [0x2585] = "\xa6\xc5", [0x2586] = "\xa6\xc6",
  [0x2587] = "\xa6\xc7", [0x2588] = "\xa6\xc8", [0x2589] = "\xa6\xc9",
  [0x258a] = "\xa6\xca", [0x258b] = "\xa6\xcb", [0x258c] = "\xa6\xcc",
  [0x258d] = "\xa6\xcd", [0x258e] = "\xa6\xce", [0x258f] = "\xa6\xcf",
  [0x2590] = "\xa6\xd0", [0x2591] = "\xa6\xd1", [0x2592] = "\xa6\xd2",
  [0x2593] = "\xa6\xd3", [0x2594] = "\xa6\xd4", [0x2595] = "\xa6\xd5",
  [0x2596] = "\xa6\xd6", [0x2597] = "\xa6\xd7", [0x2598] = "\xa6\xd8",
  [0x2599] = "\xa6\xd9", [0x259a] = "\xa6\xda", [0x259b] = "\xa6\xdb",
  [0x259c] = "\xa6\xdc", [0x259d] = "\xa6\xdd", [0x259e] = "\xa6\xde",
  [0x259f] = "\xa6\xdf", [0x25a0] = "\xa6\xe0", [0x25a1] = "\xa6\xe1",
  [0x25a2] = "\xa6\xe2", [0x25a3] = "\xa6\xe3", [0x25a4] = "\xa6\xe4",
  [0x25a5] = "\xa6\xe5", [0x25a6] = "\xa6\xe6", [0x25a7] = "\xa6\xe7",
  [0x25a8] = "\xa6\xe8", [0x25a9] = "\xa6\xe9", [0x25aa] = "\xa6\xea",
  [0x25ab] = "\xa6\xeb", [0x25ac] = "\xa6\xec", [0x25ad] = "\xa6\xed",
  [0x25ae] = "\xa6\xee", [0x25af] = "\xa6\xef", [0x25b0] = "\xa6\xf0",
  [0x25b1] = "\xa6\xf1", [0x25b2] = "\xa6\xf2", [0x25b3] = "\xa6\xf3",
  [0x25b4] = "\xa6\xf4", [0x25b5] = "\xa6\xf5", [0x25b6] = "\xa6\xf6",
  [0x25b7] = "\xa6\xf7", [0x25b8] = "\xa6\xf8", [0x25b9] = "\xa6\xf9",
  [0x25ba] = "\xa6\xfa", [0x25bb] = "\xa6\xfb", [0x25bc] = "\xa6\xfc",
  [0x25bd] = "\xa6\xfd", [0x25be] = "\xa6\xfe", [0x2600] = "\xa7\x40",
  [0x2601] = "\xa7\x41", [0x2602] = "\xa7\x42", [0x2603] = "\xa7\x43",
  [0x2604] = "\xa7\x44", [0x2605] = "\xa7\x45", [0x2606] = "\xa7\x46",
  [0x2607] = "\xa7\x47", [0x2608] = "\xa7\x48", [0x2609] = "\xa7\x49",
  [0x260a] = "\xa7\x4a", [0x260b] = "\xa7\x4b", [0x260c] = "\xa7\x4c",
  [0x260d] = "\xa7\x4d", [0x260e] = "\xa7\x4e", [0x260f] = "\xa7\x4f",
  [0x2610] = "\xa7\x50", [0x2611] = "\xa7\x51", [0x2612] = "\xa7\x52",
  [0x2613] = "\xa7\x53", [0x2614] = "\xa7\x54", [0x2615] = "\xa7\x55",
  [0x2616] = "\xa7\x56", [0x2617] = "\xa7\x57", [0x2618] = "\xa7\x58",
  [0x2619] = "\xa7\x59", [0x261a] = "\xa7\x5a", [0x261b] = "\xa7\x5b",
  [0x261c] = "\xa7\x5c", [0x261d] = "\xa7\x5d", [0x261e] = "\xa7\x5e",
  [0x261f] = "\xa7\x5f", [0x2620] = "\xa7\x60", [0x2621] = "\xa7\x61",
  [0x2622] = "\xa7\x62", [0x2623] = "\xa7\x63", [0x2624] = "\xa7\x64",
  [0x2625] = "\xa7\x65", [0x2626] = "\xa7\x66", [0x2627] = "\xa7\x67",
  [0x2628] = "\xa7\x68", [0x2629] = "\xa7\x69", [0x262a] = "\xa7\x6a",
  [0x262b] = "\xa7\x6b", [0x262c] = "\xa7\x6c", [0x262d] = "\xa7\x6d",
  [0x262e] = "\xa7\x6e", [0x262f] = "\xa7\x6f", [0x2630] = "\xa7\x70",
  [0x2631] = "\xa7\x71", [0x2632] = "\xa7\x72", [0x2633] = "\xa7\x73",
  [0x2634] = "\xa7\x74", [0x2635] = "\xa7\x75", [0x2636] = "\xa7\x76",
  [0x2637] = "\xa7\x77", [0x2638] = "\xa7\x78", [0x2639] = "\xa7\x79",
  [0x263a] = "\xa7\x7a", [0x263b] = "\xa7\x7b", [0x263c] = "\xa7\x7c",
  [0x263d] = "\xa7\x7d", [0x263e] = "\xa7\x7e", [0x2640] = "\xa7\x80",
  [0x2641] = "\xa7\x81", [0x2642] = "\xa7\x82", [0x2643] = "\xa7\x83",
  [0x2644] = "\xa7\x84", [0x2645] = "\xa7\x85", [0x2646] = "\xa7\x86",
  [0x2647] = "\xa7\x87", [0x2648] = "\xa7\x88", [0x2649] = "\xa7\x89",
  [0x264a] = "\xa7\x8a", [0x264b] = "\xa7\x8b", [0x264c] = "\xa7\x8c",
  [0x264d] = "\xa7\x8d", [0x264e] = "\xa7\x8e", [0x264f] = "\xa7\x8f",
  [0x2650] = "\xa7\x90", [0x2651] = "\xa7\x91", [0x2652] = "\xa7\x92",
  [0x2653] = "\xa7\x93", [0x2654] = "\xa7\x94", [0x2655] = "\xa7\x95",
  [0x2656] = "\xa7\x96", [0x2657] = "\xa7\x97", [0x2658] = "\xa7\x98",
  [0x2659] = "\xa7\x99", [0x265a] = "\xa7\x9a", [0x265b] = "\xa7\x9b",
  [0x265c] = "\xa7\x9c", [0x265d] = "\xa7\x9d", [0x265e] = "\xa7\x9e",
  [0x265f] = "\xa7\x9f", [0x2660] = "\xa7\xa0", [0x2661] = "\xa7\xa1",
  [0x2662] = "\xa7\xa2", [0x2663] = "\xa7\xa3", [0x2664] = "\xa7\xa4",
  [0x2665] = "\xa7\xa5", [0x2666] = "\xa7\xa6", [0x2667] = "\xa7\xa7",
  [0x2668] = "\xa7\xa8", [0x2669] = "\xa7\xa9", [0x266a] = "\xa7\xaa",
  [0x266b] = "\xa7\xab", [0x266c] = "\xa7\xac", [0x266d] = "\xa7\xad",
  [0x266e] = "\xa7\xae", [0x266f] = "\xa7\xaf", [0x2670] = "\xa7\xb0",
  [0x2671] = "\xa7\xb1", [0x2672] = "\xa7\xb2", [0x2673] = "\xa7\xb3",
  [0x2674] = "\xa7\xb4", [0x2675] = "\xa7\xb5", [0x2676] = "\xa7\xb6",
  [0x2677] = "\xa7\xb7", [0x2678] = "\xa7\xb8", [0x2679] = "\xa7\xb9",
  [0x267a] = "\xa7\xba", [0x267b] = "\xa7\xbb", [0x267c] = "\xa7\xbc",
  [0x267d] = "\xa7\xbd", [0x267e] = "\xa7\xbe", [0x267f] = "\xa7\xbf",
  [0x2680] = "\xa7\xc0", [0x2681] = "\xa7\xc1", [0x2682] = "\xa7\xc2",
  [0x2683] = "\xa7\xc3", [0x2684] = "\xa7\xc4", [0x2685] = "\xa7\xc5",
  [0x2686] = "\xa7\xc6", [0x2687] = "\xa7\xc7", [0x2688] = "\xa7\xc8",
  [0x2689] = "\xa7\xc9", [0x268a] = "\xa7\xca", [0x268b] = "\xa7\xcb",
  [0x268c] = "\xa7\xcc", [0x268d] = "\xa7\xcd", [0x268e] = "\xa7\xce",
  [0x268f] = "\xa7\xcf", [0x2690] = "\xa7\xd0", [0x2691] = "\xa7\xd1",
  [0x2692] = "\xa7\xd2", [0x2693] = "\xa7\xd3", [0x2694] = "\xa7\xd4",
  [0x2695] = "\xa7\xd5", [0x2696] = "\xa7\xd6", [0x2697] = "\xa7\xd7",
  [0x2698] = "\xa7\xd8", [0x2699] = "\xa7\xd9", [0x269a] = "\xa7\xda",
  [0x269b] = "\xa7\xdb", [0x269c] = "\xa7\xdc", [0x269d] = "\xa7\xdd",
  [0x269e] = "\xa7\xde", [0x269f] = "\xa7\xdf", [0x26a0] = "\xa7\xe0",
  [0x26a1] = "\xa7\xe1", [0x26a2] = "\xa7\xe2", [0x26a3] = "\xa7\xe3",
  [0x26a4] = "\xa7\xe4", [0x26a5] = "\xa7\xe5", [0x26a6] = "\xa7\xe6",
  [0x26a7] = "\xa7\xe7", [0x26a8] = "\xa7\xe8", [0x26a9] = "\xa7\xe9",
  [0x26aa] = "\xa7\xea", [0x26ab] = "\xa7\xeb", [0x26ac] = "\xa7\xec",
  [0x26ad] = "\xa7\xed", [0x26ae] = "\xa7\xee", [0x26af] = "\xa7\xef",
  [0x26b0] = "\xa7\xf0", [0x26b1] = "\xa7\xf1", [0x26b2] = "\xa7\xf2",
  [0x26b3] = "\xa7\xf3", [0x26b4] = "\xa7\xf4", [0x26b5] = "\xa7\xf5",
  [0x26b6] = "\xa7\xf6", [0x26b7] = "\xa7\xf7", [0x26b8] = "\xa7\xf8",
  [0x26b9] = "\xa7\xf9", [0x26ba] = "\xa7\xfa", [0x26bb] = "\xa7\xfb",
  [0x26bc] = "\xa7\xfc", [0x26bd] = "\xa7\xfd", [0x26be] = "\xa7\xfe",
  [0x2700] = "\xa8\x40", [0x2701] = "\xa8\x41", [0x2702] = "\xa8\x42",
  [0x2703] = "\xa8\x43", [0x2704] = "\xa8\x44", [0x2705] = "\xa8\x45",
  [0x2706] = "\xa8\x46", [0x2707] = "\xa8\x47", [0x2708] = "\xa8\x48",
  [0x2709] = "\xa8\x49", [0x270a] = "\xa8\x4a", [0x270b] = "\xa8\x4b",
  [0x270c] = "\xa8\x4c", [0x270d] = "\xa8\x4d", [0x270e] = "\xa8\x4e",
  [0x270f] = "\xa8\x4f", [0x2710] = "\xa8\x50", [0x2711] = "\xa8\x51",
  [0x2712] = "\xa8\x52", [0x2713] = "\xa8\x53", [0x2714] = "\xa8\x54",
  [0x2715] = "\xa8\x55", [0x2716] = "\xa8\x56", [0x2717] = "\xa8\x57",
  [0x2718] = "\xa8\x58", [0x2719] = "\xa8\x59", [0x271a] = "\xa8\x5a",
  [0x271b] = "\xa8\x5b", [0x271c] = "\xa8\x5c", [0x271d] = "\xa8\x5d",
  [0x271e] = "\xa8\x5e", [0x271f] = "\xa8\x5f", [0x2720] = "\xa8\x60",
  [0x2721] = "\xa8\x61", [0x2722] = "\xa8\x62", [0x2723] = "\xa8\x63",
  [0x2724] = "\xa8\x64", [0x2725] = "\xa8\x65", [0x2726] = "\xa8\x66",
  [0x2727] = "\xa8\x67", [0x2728] = "\xa8\x68", [0x2729] = "\xa8\x69",
  [0x272a] = "\xa8\x6a", [0x272b] = "\xa8\x6b", [0x272c] = "\xa8\x6c",
  [0x272d] = "\xa8\x6d", [0x272e] = "\xa8\x6e", [0x272f] = "\xa8\x6f",
  [0x2730] = "\xa8\x70", [0x2731] = "\xa8\x71", [0x2732] = "\xa8\x72",
  [0x2733] = "\xa8\x73", [0x2734] = "\xa8\x74", [0x2735] = "\xa8\x75",
  [0x2736] = "\xa8\x76", [0x2737] = "\xa8\x77", [0x2738] = "\xa8\x78",
  [0x2739] = "\xa8\x79", [0x273a] = "\xa8\x7a", [0x273b] = "\xa8\x7b",
  [0x273c] = "\xa8\x7c", [0x273d] = "\xa8\x7d", [0x273e] = "\xa8\x7e",
  [0x2740] = "\xa8\x80", [0x2741] = "\xa8\x81", [0x2742] = "\xa8\x82",
  [0x2743] = "\xa8\x83", [0x2744] = "\xa8\x84", [0x2745] = "\xa8\x85",
  [0x2746] = "\xa8\x86", [0x2747] = "\xa8\x87", [0x2748] = "\xa8\x88",
  [0x2749] = "\xa8\x89", [0x274a] = "\xa8\x8a", [0x274b] = "\xa8\x8b",
  [0x274c] = "\xa8\x8c", [0x274d] = "\xa8\x8d", [0x274e] = "\xa8\x8e",
  [0x274f] = "\xa8\x8f", [0x2750] = "\xa8\x90", [0x2751] = "\xa8\x91",
  [0x2752] = "\xa8\x92", [0x2753] = "\xa8\x93", [0x2754] = "\xa8\x94",
  [0x2755] = "\xa8\x95", [0x2756] = "\xa8\x96", [0x2757] = "\xa8\x97",
  [0x2758] = "\xa8\x98", [0x2759] = "\xa8\x99", [0x275a] = "\xa8\x9a",
  [0x275b] = "\xa8\x9b", [0x275c] = "\xa8\x9c", [0x275d] = "\xa8\x9d",
  [0x275e] = "\xa8\x9e", [0x275f] = "\xa8\x9f", [0x2760] = "\xa8\xa0",
  [0x2761] = "\xa8\xa1", [0x2762] = "\xa8\xa2", [0x2763] = "\xa8\xa3",
  [0x2764] = "\xa8\xa4", [0x2765] = "\xa8\xa5", [0x2766] = "\xa8\xa6",
  [0x2767] = "\xa8\xa7", [0x2768] = "\xa8\xa8", [0x2769] = "\xa8\xa9",
  [0x276a] = "\xa8\xaa", [0x276b] = "\xa8\xab", [0x276c] = "\xa8\xac",
  [0x276d] = "\xa8\xad", [0x276e] = "\xa8\xae", [0x276f] = "\xa8\xaf",
  [0x2770] = "\xa8\xb0", [0x2771] = "\xa8\xb1", [0x2772] = "\xa8\xb2",
  [0x2773] = "\xa8\xb3", [0x2774] = "\xa8\xb4", [0x2775] = "\xa8\xb5",
  [0x2776] = "\xa8\xb6", [0x2777] = "\xa8\xb7", [0x2778] = "\xa8\xb8",
  [0x2779] = "\xa8\xb9", [0x277a] = "\xa8\xba", [0x277b] = "\xa8\xbb",
  [0x277c] = "\xa8\xbc", [0x277d] = "\xa8\xbd", [0x277e] = "\xa8\xbe",
  [0x277f] = "\xa8\xbf", [0x2780] = "\xa8\xc0", [0x2781] = "\xa8\xc1",
  [0x2782] = "\xa8\xc2", [0x2783] = "\xa8\xc3", [0x2784] = "\xa8\xc4",
  [0x2785] = "\xa8\xc5", [0x2786] = "\xa8\xc6", [0x2787] = "\xa8\xc7",
  [0x2788] = "\xa8\xc8", [0x2789] = "\xa8\xc9", [0x278a] = "\xa8\xca",
  [0x278b] = "\xa8\xcb", [0x278c] = "\xa8\xcc", [0x278d] = "\xa8\xcd",
  [0x278e] = "\xa8\xce", [0x278f] = "\xa8\xcf", [0x2790] = "\xa8\xd0",
  [0x2791] = "\xa8\xd1", [0x2792] = "\xa8\xd2", [0x2793] = "\xa8\xd3",
  [0x2794] = "\xa8\xd4", [0x2795] = "\xa8\xd5", [0x2796] = "\xa8\xd6",
  [0x2797] = "\xa8\xd7", [0x2798] = "\xa8\xd8", [0x2799] = "\xa8\xd9",
  [0x279a] = "\xa8\xda", [0x279b] = "\xa8\xdb", [0x279c] = "\xa8\xdc",
  [0x279d] = "\xa8\xdd", [0x279e] = "\xa8\xde", [0x279f] = "\xa8\xdf",
  [0x27a0] = "\xa8\xe0", [0x27a1] = "\xa8\xe1", [0x27a2] = "\xa8\xe2",
  [0x27a3] = "\xa8\xe3", [0x27a4] = "\xa8\xe4", [0x27a5] = "\xa8\xe5",
  [0x27a6] = "\xa8\xe6", [0x27a7] = "\xa8\xe7", [0x27a8] = "\xa8\xe8",
  [0x27a9] = "\xa8\xe9", [0x27aa] = "\xa8\xea", [0x27ab] = "\xa8\xeb",
  [0x27ac] = "\xa8\xec", [0x27ad] = "\xa8\xed", [0x27ae] = "\xa8\xee",
  [0x27af] = "\xa8\xef", [0x27b0] = "\xa8\xf0", [0x27b1] = "\xa8\xf1",
  [0x27b2] = "\xa8\xf2", [0x27b3] = "\xa8\xf3", [0x27b4] = "\xa8\xf4",
  [0x27b5] = "\xa8\xf5", [0x27b6] = "\xa8\xf6", [0x27b7] = "\xa8\xf7",
  [0x27b8] = "\xa8\xf8", [0x27b9] = "\xa8\xf9", [0x27ba] = "\xa8\xfa",
  [0x27bb] = "\xa8\xfb", [0x27bc] = "\xa8\xfc", [0x27bd] = "\xa8\xfd",
  [0x27be] = "\xa8\xfe", [0x2800] = "\xa9\x40", [0x2801] = "\xa9\x41",
  [0x2802] = "\xa9\x42", [0x2803] = "\xa9\x43", [0x2804] = "\xa9\x44",
  [0x2805] = "\xa9\x45", [0x2806] = "\xa9\x46", [0x2807] = "\xa9\x47",
  [0x2808] = "\xa9\x48", [0x2809] = "\xa9\x49", [0x280a] = "\xa9\x4a",
  [0x280b] = "\xa9\x4b", [0x280c] = "\xa9\x4c", [0x280d] = "\xa9\x4d",
  [0x280e] = "\xa9\x4e", [0x280f] = "\xa9\x4f", [0x2810] = "\xa9\x50",
  [0x2811] = "\xa9\x51", [0x2812] = "\xa9\x52", [0x2813] = "\xa9\x53",
  [0x2814] = "\xa9\x54", [0x2815] = "\xa9\x55", [0x2816] = "\xa9\x56",
  [0x2817] = "\xa9\x57", [0x2818] = "\xa9\x58", [0x2819] = "\xa9\x59",
  [0x281a] = "\xa9\x5a", [0x281b] = "\xa9\x5b", [0x281c] = "\xa9\x5c",
  [0x281d] = "\xa9\x5d", [0x281e] = "\xa9\x5e", [0x281f] = "\xa9\x5f",
  [0x2820] = "\xa9\x60", [0x2821] = "\xa9\x61", [0x2822] = "\xa9\x62",
  [0x2823] = "\xa9\x63", [0x2824] = "\xa9\x64", [0x2825] = "\xa9\x65",
  [0x2826] = "\xa9\x66", [0x2827] = "\xa9\x67", [0x2828] = "\xa9\x68",
  [0x2829] = "\xa9\x69", [0x282a] = "\xa9\x6a", [0x282b] = "\xa9\x6b",
  [0x282c] = "\xa9\x6c", [0x282d] = "\xa9\x6d", [0x282e] = "\xa9\x6e",
  [0x282f] = "\xa9\x6f", [0x2830] = "\xa9\x70", [0x2831] = "\xa9\x71",
  [0x2832] = "\xa9\x72", [0x2833] = "\xa9\x73", [0x2834] = "\xa9\x74",
  [0x2835] = "\xa9\x75", [0x2836] = "\xa9\x76", [0x2837] = "\xa9\x77",
  [0x2838] = "\xa9\x78", [0x2839] = "\xa9\x79", [0x283a] = "\xa9\x7a",
  [0x283b] = "\xa9\x7b", [0x283c] = "\xa9\x7c", [0x283d] = "\xa9\x7d",
  [0x283e] = "\xa9\x7e", [0x2840] = "\xa9\x80", [0x2841] = "\xa9\x81",
  [0x2842] = "\xa9\x82", [0x2843] = "\xa9\x83", [0x2844] = "\xa9\x84",
  [0x2845] = "\xa9\x85", [0x2846] = "\xa9\x86", [0x2847] = "\xa9\x87",
  [0x2848] = "\xa9\x88", [0x2849] = "\xa9\x89", [0x284a] = "\xa9\x8a",
  [0x284b] = "\xa9\x8b", [0x284c] = "\xa9\x8c", [0x284d] = "\xa9\x8d",
  [0x284e] = "\xa9\x8e", [0x284f] = "\xa9\x8f", [0x2850] = "\xa9\x90",
  [0x2851] = "\xa9\x91", [0x2852] = "\xa9\x92", [0x2853] = "\xa9\x93",
  [0x2854] = "\xa9\x94", [0x2855] = "\xa9\x95", [0x2856] = "\xa9\x96",
  [0x2857] = "\xa9\x97", [0x2858] = "\xa9\x98", [0x2859] = "\xa9\x99",
  [0x285a] = "\xa9\x9a", [0x285b] = "\xa9\x9b", [0x285c] = "\xa9\x9c",
  [0x285d] = "\xa9\x9d", [0x285e] = "\xa9\x9e", [0x285f] = "\xa9\x9f",
  [0x2860] = "\xa9\xa0", [0x2861] = "\xa9\xa1", [0x2862] = "\xa9\xa2",
  [0x2863] = "\xa9\xa3", [0x2864] = "\xa9\xa4", [0x2865] = "\xa9\xa5",
  [0x2866] = "\xa9\xa6", [0x2867] = "\xa9\xa7", [0x2868] = "\xa9\xa8",
  [0x2869] = "\xa9\xa9", [0x286a] = "\xa9\xaa", [0x286b] = "\xa9\xab",
  [0x286c] = "\xa9\xac", [0x286d] = "\xa9\xad", [0x286e] = "\xa9\xae",
  [0x286f] = "\xa9\xaf", [0x2870] = "\xa9\xb0", [0x2871] = "\xa9\xb1",
  [0x2872] = "\xa9\xb2", [0x2873] = "\xa9\xb3", [0x2874] = "\xa9\xb4",
  [0x2875] = "\xa9\xb5", [0x2876] = "\xa9\xb6", [0x2877] = "\xa9\xb7",
  [0x2878] = "\xa9\xb8", [0x2879] = "\xa9\xb9", [0x287a] = "\xa9\xba",
  [0x287b] = "\xa9\xbb", [0x287c] = "\xa9\xbc", [0x287d] = "\xa9\xbd",
  [0x287e] = "\xa9\xbe", [0x287f] = "\xa9\xbf", [0x2880] = "\xa9\xc0",
  [0x2881] = "\xa9\xc1", [0x2882] = "\xa9\xc2", [0x2883] = "\xa9\xc3",
  [0x2884] = "\xa9\xc4", [0x2885] = "\xa9\xc5", [0x2886] = "\xa9\xc6",
  [0x2887] = "\xa9\xc7", [0x2888] = "\xa9\xc8", [0x2889] = "\xa9\xc9",
  [0x288a] = "\xa9\xca", [0x288b] = "\xa9\xcb", [0x288c] = "\xa9\xcc",
  [0x288d] = "\xa9\xcd", [0x288e] = "\xa9\xce", [0x288f] = "\xa9\xcf",
  [0x2890] = "\xa9\xd0", [0x2891] = "\xa9\xd1", [0x2892] = "\xa9\xd2",
  [0x2893] = "\xa9\xd3", [0x2894] = "\xa9\xd4", [0x2895] = "\xa9\xd5",
  [0x2896] = "\xa9\xd6", [0x2897] = "\xa9\xd7", [0x2898] = "\xa9\xd8",
  [0x2899] = "\xa9\xd9", [0x289a] = "\xa9\xda", [0x289b] = "\xa9\xdb",
  [0x289c] = "\xa9\xdc", [0x289d] = "\xa9\xdd", [0x289e] = "\xa9\xde",
  [0x289f] = "\xa9\xdf", [0x28a0] = "\xa9\xe0", [0x28a1] = "\xa9\xe1",
  [0x28a2] = "\xa9\xe2", [0x28a3] = "\xa9\xe3", [0x28a4] = "\xa9\xe4",
  [0x28a5] = "\xa9\xe5", [0x28a6] = "\xa9\xe6", [0x28a7] = "\xa9\xe7",
  [0x28a8] = "\xa9\xe8", [0x28a9] = "\xa9\xe9", [0x28aa] = "\xa9\xea",
  [0x28ab] = "\xa9\xeb", [0x28ac] = "\xa9\xec", [0x28ad] = "\xa9\xed",
  [0x28ae] = "\xa9\xee", [0x28af] = "\xa9\xef", [0x28b0] = "\xa9\xf0",
  [0x28b1] = "\xa9\xf1", [0x28b2] = "\xa9\xf2", [0x28b3] = "\xa9\xf3",
  [0x28b4] = "\xa9\xf4", [0x28b5] = "\xa9\xf5", [0x28b6] = "\xa9\xf6",
  [0x28b7] = "\xa9\xf7", [0x28b8] = "\xa9\xf8", [0x28b9] = "\xa9\xf9",
  [0x28ba] = "\xa9\xfa", [0x28bb] = "\xa9\xfb", [0x28bc] = "\xa9\xfc",
  [0x28bd] = "\xa9\xfd", [0x28be] = "\xa9\xfe", [0x2900] = "\xaa\x40",
  [0x2901] = "\xaa\x41", [0x2902] = "\xaa\x42", [0x2903] = "\xaa\x43",
  [0x2904] = "\xaa\x44", [0x2905] = "\xaa\x45", [0x2906] = "\xaa\x46",
  [0x2907] = "\xaa\x47", [0x2908] = "\xaa\x48", [0x2909] = "\xaa\x49",
  [0x290a] = "\xaa\x4a", [0x290b] = "\xaa\x4b", [0x290c] = "\xaa\x4c",
  [0x290d] = "\xaa\x4d", [0x290e] = "\xaa\x4e", [0x290f] = "\xaa\x4f",
  [0x2910] = "\xaa\x50", [0x2911] = "\xaa\x51", [0x2912] = "\xaa\x52",
  [0x2913] = "\xaa\x53", [0x2914] = "\xaa\x54", [0x2915] = "\xaa\x55",
  [0x2916] = "\xaa\x56", [0x2917] = "\xaa\x57", [0x2918] = "\xaa\x58",
  [0x2919] = "\xaa\x59", [0x291a] = "\xaa\x5a", [0x291b] = "\xaa\x5b",
  [0x291c] = "\xaa\x5c", [0x291d] = "\xaa\x5d", [0x291e] = "\xaa\x5e",
  [0x291f] = "\xaa\x5f", [0x2920] = "\xaa\x60", [0x2921] = "\xaa\x61",
  [0x2922] = "\xaa\x62", [0x2923] = "\xaa\x63", [0x2924] = "\xaa\x64",
  [0x2925] = "\xaa\x65", [0x2926] = "\xaa\x66", [0x2927] = "\xaa\x67",
  [0x2928] = "\xaa\x68", [0x2929] = "\xaa\x69", [0x292a] = "\xaa\x6a",
  [0x292b] = "\xaa\x6b", [0x292c] = "\xaa\x6c", [0x292d] = "\xaa\x6d",
  [0x292e] = "\xaa\x6e", [0x292f] = "\xaa\x6f", [0x2930] = "\xaa\x70",
  [0x2931] = "\xaa\x71", [0x2932] = "\xaa\x72", [0x2933] = "\xaa\x73",
  [0x2934] = "\xaa\x74", [0x2935] = "\xaa\x75", [0x2936] = "\xaa\x76",
  [0x2937] = "\xaa\x77", [0x2938] = "\xaa\x78", [0x2939] = "\xaa\x79",
  [0x293a] = "\xaa\x7a", [0x293b] = "\xaa\x7b", [0x293c] = "\xaa\x7c",
  [0x293d] = "\xaa\x7d", [0x293e] = "\xaa\x7e", [0x2940] = "\xaa\x80",
  [0x2941] = "\xaa\x81", [0x2942] = "\xaa\x82", [0x2943] = "\xaa\x83",
  [0x2944] = "\xaa\x84", [0x2945] = "\xaa\x85", [0x2946] = "\xaa\x86",
  [0x2947] = "\xaa\x87", [0x2948] = "\xaa\x88", [0x2949] = "\xaa\x89",
  [0x294a] = "\xaa\x8a", [0x294b] = "\xaa\x8b", [0x294c] = "\xaa\x8c",
  [0x294d] = "\xaa\x8d", [0x294e] = "\xaa\x8e", [0x294f] = "\xaa\x8f",
  [0x2950] = "\xaa\x90", [0x2951] = "\xaa\x91", [0x2952] = "\xaa\x92",
  [0x2953] = "\xaa\x93", [0x2954] = "\xaa\x94", [0x2955] = "\xaa\x95",
  [0x2956] = "\xaa\x96", [0x2957] = "\xaa\x97", [0x2958] = "\xaa\x98",
  [0x2959] = "\xaa\x99", [0x295a] = "\xaa\x9a", [0x295b] = "\xaa\x9b",
  [0x295c] = "\xaa\x9c", [0x295d] = "\xaa\x9d", [0x295e] = "\xaa\x9e",
  [0x295f] = "\xaa\x9f", [0x2960] = "\xaa\xa0", [0x2961] = "\xaa\xa1",
  [0x2962] = "\xaa\xa2", [0x2963] = "\xaa\xa3", [0x2964] = "\xaa\xa4",
  [0x2965] = "\xaa\xa5", [0x2966] = "\xaa\xa6", [0x2967] = "\xaa\xa7",
  [0x2968] = "\xaa\xa8", [0x2969] = "\xaa\xa9", [0x296a] = "\xaa\xaa",
  [0x296b] = "\xaa\xab", [0x296c] = "\xaa\xac", [0x296d] = "\xaa\xad",
  [0x296e] = "\xaa\xae", [0x296f] = "\xaa\xaf", [0x2970] = "\xaa\xb0",
  [0x2971] = "\xaa\xb1", [0x2972] = "\xaa\xb2", [0x2973] = "\xaa\xb3",
  [0x2974] = "\xaa\xb4", [0x2975] = "\xaa\xb5", [0x2976] = "\xaa\xb6",
  [0x2977] = "\xaa\xb7", [0x2978] = "\xaa\xb8", [0x2979] = "\xaa\xb9",
  [0x297a] = "\xaa\xba", [0x297b] = "\xaa\xbb", [0x297c] = "\xaa\xbc",
  [0x297d] = "\xaa\xbd", [0x297e] = "\xaa\xbe", [0x297f] = "\xaa\xbf",
  [0x2980] = "\xaa\xc0", [0x2981] = "\xaa\xc1", [0x2982] = "\xaa\xc2",
  [0x2983] = "\xaa\xc3", [0x2984] = "\xaa\xc4", [0x2985] = "\xaa\xc5",
  [0x2986] = "\xaa\xc6", [0x2987] = "\xaa\xc7", [0x2988] = "\xaa\xc8",
  [0x2989] = "\xaa\xc9", [0x298a] = "\xaa\xca", [0x298b] = "\xaa\xcb",
  [0x298c] = "\xaa\xcc", [0x298d] = "\xaa\xcd", [0x298e] = "\xaa\xce",
  [0x298f] = "\xaa\xcf", [0x2990] = "\xaa\xd0", [0x2991] = "\xaa\xd1",
  [0x2992] = "\xaa\xd2", [0x2993] = "\xaa\xd3", [0x2994] = "\xaa\xd4",
  [0x2995] = "\xaa\xd5", [0x2996] = "\xaa\xd6", [0x2997] = "\xaa\xd7",
  [0x2998] = "\xaa\xd8", [0x2999] = "\xaa\xd9", [0x299a] = "\xaa\xda",
  [0x299b] = "\xaa\xdb", [0x299c] = "\xaa\xdc", [0x299d] = "\xaa\xdd",
  [0x299e] = "\xaa\xde", [0x299f] = "\xaa\xdf", [0x29a0] = "\xaa\xe0",
  [0x29a1] = "\xaa\xe1", [0x29a2] = "\xaa\xe2", [0x29a3] = "\xaa\xe3",
  [0x29a4] = "\xaa\xe4", [0x29a5] = "\xaa\xe5", [0x29a6] = "\xaa\xe6",
  [0x29a7] = "\xaa\xe7", [0x29a8] = "\xaa\xe8", [0x29a9] = "\xaa\xe9",
  [0x29aa] = "\xaa\xea", [0x29ab] = "\xaa\xeb", [0x29ac] = "\xaa\xec",
  [0x29ad] = "\xaa\xed", [0x29ae] = "\xaa\xee", [0x29af] = "\xaa\xef",
  [0x29b0] = "\xaa\xf0", [0x29b1] = "\xaa\xf1", [0x29b2] = "\xaa\xf2",
  [0x29b3] = "\xaa\xf3", [0x29b4] = "\xaa\xf4", [0x29b5] = "\xaa\xf5",
  [0x29b6] = "\xaa\xf6", [0x29b7] = "\xaa\xf7", [0x29b8] = "\xaa\xf8",
  [0x29b9] = "\xaa\xf9", [0x29ba] = "\xaa\xfa", [0x29bb] = "\xaa\xfb",
  [0x29bc] = "\xaa\xfc", [0x29bd] = "\xaa\xfd", [0x29be] = "\xaa\xfe",
  [0x2a00] = "\xab\x40", [0x2a01] = "\xab\x41", [0x2a02] = "\xab\x42",
  [0x2a03] = "\xab\x43", [0x2a04] = "\xab\x44", [0x2a05] = "\xab\x45",
  [0x2a06] = "\xab\x46", [0x2a07] = "\xab\x47", [0x2a08] = "\xab\x48",
  [0x2a09] = "\xab\x49", [0x2a0a] = "\xab\x4a", [0x2a0b] = "\xab\x4b",
  [0x2a0c] = "\xab\x4c", [0x2a0d] = "\xab\x4d", [0x2a0e] = "\xab\x4e",
  [0x2a0f] = "\xab\x4f", [0x2a10] = "\xab\x50", [0x2a11] = "\xab\x51",
  [0x2a12] = "\xab\x52", [0x2a13] = "\xab\x53", [0x2a14] = "\xab\x54",
  [0x2a15] = "\xab\x55", [0x2a16] = "\xab\x56", [0x2a17] = "\xab\x57",
  [0x2a18] = "\xab\x58", [0x2a19] = "\xab\x59", [0x2a1a] = "\xab\x5a",
  [0x2a1b] = "\xab\x5b", [0x2a1c] = "\xab\x5c", [0x2a1d] = "\xab\x5d",
  [0x2a1e] = "\xab\x5e", [0x2a1f] = "\xab\x5f", [0x2a20] = "\xab\x60",
  [0x2a21] = "\xab\x61", [0x2a22] = "\xab\x62", [0x2a23] = "\xab\x63",
  [0x2a24] = "\xab\x64", [0x2a25] = "\xab\x65", [0x2a26] = "\xab\x66",
  [0x2a27] = "\xab\x67", [0x2a28] = "\xab\x68", [0x2a29] = "\xab\x69",
  [0x2a2a] = "\xab\x6a", [0x2a2b] = "\xab\x6b", [0x2a2c] = "\xab\x6c",
  [0x2a2d] = "\xab\x6d", [0x2a2e] = "\xab\x6e", [0x2a2f] = "\xab\x6f",
  [0x2a30] = "\xab\x70", [0x2a31] = "\xab\x71", [0x2a32] = "\xab\x72",
  [0x2a33] = "\xab\x73", [0x2a34] = "\xab\x74", [0x2a35] = "\xab\x75",
  [0x2a36] = "\xab\x76", [0x2a37] = "\xab\x77", [0x2a38] = "\xab\x78",
  [0x2a39] = "\xab\x79", [0x2a3a] = "\xab\x7a", [0x2a3b] = "\xab\x7b",
  [0x2a3c] = "\xab\x7c", [0x2a3d] = "\xab\x7d", [0x2a3e] = "\xab\x7e",
  [0x2a40] = "\xab\x80", [0x2a41] = "\xab\x81", [0x2a42] = "\xab\x82",
  [0x2a43] = "\xab\x83", [0x2a44] = "\xab\x84", [0x2a45] = "\xab\x85",
  [0x2a46] = "\xab\x86", [0x2a47] = "\xab\x87", [0x2a48] = "\xab\x88",
  [0x2a49] = "\xab\x89", [0x2a4a] = "\xab\x8a", [0x2a4b] = "\xab\x8b",
  [0x2a4c] = "\xab\x8c", [0x2a4d] = "\xab\x8d", [0x2a4e] = "\xab\x8e",
  [0x2a4f] = "\xab\x8f", [0x2a50] = "\xab\x90", [0x2a51] = "\xab\x91",
  [0x2a52] = "\xab\x92", [0x2a53] = "\xab\x93", [0x2a54] = "\xab\x94",
  [0x2a55] = "\xab\x95", [0x2a56] = "\xab\x96", [0x2a57] = "\xab\x97",
  [0x2a58] = "\xab\x98", [0x2a59] = "\xab\x99", [0x2a5a] = "\xab\x9a",
  [0x2a5b] = "\xab\x9b", [0x2a5c] = "\xab\x9c", [0x2a5d] = "\xab\x9d",
  [0x2a5e] = "\xab\x9e", [0x2a5f] = "\xab\x9f", [0x2a60] = "\xab\xa0",
  [0x2a61] = "\xab\xa1", [0x2a62] = "\xab\xa2", [0x2a63] = "\xab\xa3",
  [0x2a64] = "\xab\xa4", [0x2a65] = "\xab\xa5", [0x2a66] = "\xab\xa6",
  [0x2a67] = "\xab\xa7", [0x2a68] = "\xab\xa8", [0x2a69] = "\xab\xa9",
  [0x2a6a] = "\xab\xaa", [0x2a6b] = "\xab\xab", [0x2a6c] = "\xab\xac",
  [0x2a6d] = "\xab\xad", [0x2a6e] = "\xab\xae", [0x2a6f] = "\xab\xaf",
  [0x2a70] = "\xab\xb0", [0x2a71] = "\xab\xb1", [0x2a72] = "\xab\xb2",
  [0x2a73] = "\xab\xb3", [0x2a74] = "\xab\xb4", [0x2a75] = "\xab\xb5",
  [0x2a76] = "\xab\xb6", [0x2a77] = "\xab\xb7", [0x2a78] = "\xab\xb8",
  [0x2a79] = "\xab\xb9", [0x2a7a] = "\xab\xba", [0x2a7b] = "\xab\xbb",
  [0x2a7c] = "\xab\xbc", [0x2a7d] = "\xab\xbd", [0x2a7e] = "\xab\xbe",
  [0x2a7f] = "\xab\xbf", [0x2a80] = "\xab\xc0", [0x2a81] = "\xab\xc1",
  [0x2a82] = "\xab\xc2", [0x2a83] = "\xab\xc3", [0x2a84] = "\xab\xc4",
  [0x2a85] = "\xab\xc5", [0x2a86] = "\xab\xc6", [0x2a87] = "\xab\xc7",
  [0x2a88] = "\xab\xc8", [0x2a89] = "\xab\xc9", [0x2a8a] = "\xab\xca",
  [0x2a8b] = "\xab\xcb", [0x2a8c] = "\xab\xcc", [0x2a8d] = "\xab\xcd",
  [0x2a8e] = "\xab\xce", [0x2a8f] = "\xab\xcf", [0x2a90] = "\xab\xd0",
  [0x2a91] = "\xab\xd1", [0x2a92] = "\xab\xd2", [0x2a93] = "\xab\xd3",
  [0x2a94] = "\xab\xd4", [0x2a95] = "\xab\xd5", [0x2a96] = "\xab\xd6",
  [0x2a97] = "\xab\xd7", [0x2a98] = "\xab\xd8", [0x2a99] = "\xab\xd9",
  [0x2a9a] = "\xab\xda", [0x2a9b] = "\xab\xdb", [0x2a9c] = "\xab\xdc",
  [0x2a9d] = "\xab\xdd", [0x2a9e] = "\xab\xde", [0x2a9f] = "\xab\xdf",
  [0x2aa0] = "\xab\xe0", [0x2aa1] = "\xab\xe1", [0x2aa2] = "\xab\xe2",
  [0x2aa3] = "\xab\xe3", [0x2aa4] = "\xab\xe4", [0x2aa5] = "\xab\xe5",
  [0x2aa6] = "\xab\xe6", [0x2aa7] = "\xab\xe7", [0x2aa8] = "\xab\xe8",
  [0x2aa9] = "\xab\xe9", [0x2aaa] = "\xab\xea", [0x2aab] = "\xab\xeb",
  [0x2aac] = "\xab\xec", [0x2aad] = "\xab\xed", [0x2aae] = "\xab\xee",
  [0x2aaf] = "\xab\xef", [0x2ab0] = "\xab\xf0", [0x2ab1] = "\xab\xf1",
  [0x2ab2] = "\xab\xf2", [0x2ab3] = "\xab\xf3", [0x2ab4] = "\xab\xf4",
  [0x2ab5] = "\xab\xf5", [0x2ab6] = "\xab\xf6", [0x2ab7] = "\xab\xf7",
  [0x2ab8] = "\xab\xf8", [0x2ab9] = "\xab\xf9", [0x2aba] = "\xab\xfa",
  [0x2abb] = "\xab\xfb", [0x2abc] = "\xab\xfc", [0x2abd] = "\xab\xfd",
  [0x2abe] = "\xab\xfe", [0x2b00] = "\xac\x40", [0x2b01] = "\xac\x41",
  [0x2b02] = "\xac\x42", [0x2b03] = "\xac\x43", [0x2b04] = "\xac\x44",
  [0x2b05] = "\xac\x45", [0x2b06] = "\xac\x46", [0x2b07] = "\xac\x47",
  [0x2b08] = "\xac\x48", [0x2b09] = "\xac\x49", [0x2b0a] = "\xac\x4a",
  [0x2b0b] = "\xac\x4b", [0x2b0c] = "\xac\x4c", [0x2b0d] = "\xac\x4d",
  [0x2b0e] = "\xac\x4e", [0x2b0f] = "\xac\x4f", [0x2b10] = "\xac\x50",
  [0x2b11] = "\xac\x51", [0x2b12] = "\xac\x52", [0x2b13] = "\xac\x53",
  [0x2b14] = "\xac\x54", [0x2b15] = "\xac\x55", [0x2b16] = "\xac\x56",
  [0x2b17] = "\xac\x57", [0x2b18] = "\xac\x58", [0x2b19] = "\xac\x59",
  [0x2b1a] = "\xac\x5a", [0x2b1b] = "\xac\x5b", [0x2b1c] = "\xac\x5c",
  [0x2b1d] = "\xac\x5d", [0x2b1e] = "\xac\x5e", [0x2b1f] = "\xac\x5f",
  [0x2b20] = "\xac\x60", [0x2b21] = "\xac\x61", [0x2b22] = "\xac\x62",
  [0x2b23] = "\xac\x63", [0x2b24] = "\xac\x64", [0x2b25] = "\xac\x65",
  [0x2b26] = "\xac\x66", [0x2b27] = "\xac\x67", [0x2b28] = "\xac\x68",
  [0x2b29] = "\xac\x69", [0x2b2a] = "\xac\x6a", [0x2b2b] = "\xac\x6b",
  [0x2b2c] = "\xac\x6c", [0x2b2d] = "\xac\x6d", [0x2b2e] = "\xac\x6e",
  [0x2b2f] = "\xac\x6f", [0x2b30] = "\xac\x70", [0x2b31] = "\xac\x71",
  [0x2b32] = "\xac\x72", [0x2b33] = "\xac\x73", [0x2b34] = "\xac\x74",
  [0x2b35] = "\xac\x75", [0x2b36] = "\xac\x76", [0x2b37] = "\xac\x77",
  [0x2b38] = "\xac\x78", [0x2b39] = "\xac\x79", [0x2b3a] = "\xac\x7a",
  [0x2b3b] = "\xac\x7b", [0x2b3c] = "\xac\x7c", [0x2b3d] = "\xac\x7d",
  [0x2b3e] = "\xac\x7e", [0x2b40] = "\xac\x80", [0x2b41] = "\xac\x81",
  [0x2b42] = "\xac\x82", [0x2b43] = "\xac\x83", [0x2b44] = "\xac\x84",
  [0x2b45] = "\xac\x85", [0x2b46] = "\xac\x86", [0x2b47] = "\xac\x87",
  [0x2b48] = "\xac\x88", [0x2b49] = "\xac\x89", [0x2b4a] = "\xac\x8a",
  [0x2b4b] = "\xac\x8b", [0x2b4c] = "\xac\x8c", [0x2b4d] = "\xac\x8d",
  [0x2b4e] = "\xac\x8e", [0x2b4f] = "\xac\x8f", [0x2b50] = "\xac\x90",
  [0x2b51] = "\xac\x91", [0x2b52] = "\xac\x92", [0x2b53] = "\xac\x93",
  [0x2b54] = "\xac\x94", [0x2b55] = "\xac\x95", [0x2b56] = "\xac\x96",
  [0x2b57] = "\xac\x97", [0x2b58] = "\xac\x98", [0x2b59] = "\xac\x99",
  [0x2b5a] = "\xac\x9a", [0x2b5b] = "\xac\x9b", [0x2b5c] = "\xac\x9c",
  [0x2b5d] = "\xac\x9d", [0x2b5e] = "\xac\x9e", [0x2b5f] = "\xac\x9f",
  [0x2b60] = "\xac\xa0", [0x2b61] = "\xac\xa1", [0x2b62] = "\xac\xa2",
  [0x2b63] = "\xac\xa3", [0x2b64] = "\xac\xa4", [0x2b65] = "\xac\xa5",
  [0x2b66] = "\xac\xa6", [0x2b67] = "\xac\xa7", [0x2b68] = "\xac\xa8",
  [0x2b69] = "\xac\xa9", [0x2b6a] = "\xac\xaa", [0x2b6b] = "\xac\xab",
  [0x2b6c] = "\xac\xac", [0x2b6d] = "\xac\xad", [0x2b6e] = "\xac\xae",
  [0x2b6f] = "\xac\xaf", [0x2b70] = "\xac\xb0", [0x2b71] = "\xac\xb1",
  [0x2b72] = "\xac\xb2", [0x2b73] = "\xac\xb3", [0x2b74] = "\xac\xb4",
  [0x2b75] = "\xac\xb5", [0x2b76] = "\xac\xb6", [0x2b77] = "\xac\xb7",
  [0x2b78] = "\xac\xb8", [0x2b79] = "\xac\xb9", [0x2b7a] = "\xac\xba",
  [0x2b7b] = "\xac\xbb", [0x2b7c] = "\xac\xbc", [0x2b7d] = "\xac\xbd",
  [0x2b7e] = "\xac\xbe", [0x2b7f] = "\xac\xbf", [0x2b80] = "\xac\xc0",
  [0x2b81] = "\xac\xc1", [0x2b82] = "\xac\xc2", [0x2b83] = "\xac\xc3",
  [0x2b84] = "\xac\xc4", [0x2b85] = "\xac\xc5", [0x2b86] = "\xac\xc6",
  [0x2b87] = "\xac\xc7", [0x2b88] = "\xac\xc8", [0x2b89] = "\xac\xc9",
  [0x2b8a] = "\xac\xca", [0x2b8b] = "\xac\xcb", [0x2b8c] = "\xac\xcc",
  [0x2b8d] = "\xac\xcd", [0x2b8e] = "\xac\xce", [0x2b8f] = "\xac\xcf",
  [0x2b90] = "\xac\xd0", [0x2b91] = "\xac\xd1", [0x2b92] = "\xac\xd2",
  [0x2b93] = "\xac\xd3", [0x2b94] = "\xac\xd4", [0x2b95] = "\xac\xd5",
  [0x2b96] = "\xac\xd6", [0x2b97] = "\xac\xd7", [0x2b98] = "\xac\xd8",
  [0x2b99] = "\xac\xd9", [0x2b9a] = "\xac\xda", [0x2b9b] = "\xac\xdb",
  [0x2b9c] = "\xac\xdc", [0x2b9d] = "\xac\xdd", [0x2b9e] = "\xac\xde",
  [0x2b9f] = "\xac\xdf", [0x2ba0] = "\xac\xe0", [0x2ba1] = "\xac\xe1",
  [0x2ba2] = "\xac\xe2", [0x2ba3] = "\xac\xe3", [0x2ba4] = "\xac\xe4",
  [0x2ba5] = "\xac\xe5", [0x2ba6] = "\xac\xe6", [0x2ba7] = "\xac\xe7",
  [0x2ba8] = "\xac\xe8", [0x2ba9] = "\xac\xe9", [0x2baa] = "\xac\xea",
  [0x2bab] = "\xac\xeb", [0x2bac] = "\xac\xec", [0x2bad] = "\xac\xed",
  [0x2bae] = "\xac\xee", [0x2baf] = "\xac\xef", [0x2bb0] = "\xac\xf0",
  [0x2bb1] = "\xac\xf1", [0x2bb2] = "\xac\xf2", [0x2bb3] = "\xac\xf3",
  [0x2bb4] = "\xac\xf4", [0x2bb5] = "\xac\xf5", [0x2bb6] = "\xac\xf6",
  [0x2bb7] = "\xac\xf7", [0x2bb8] = "\xac\xf8", [0x2bb9] = "\xac\xf9",
  [0x2bba] = "\xac\xfa", [0x2bbb] = "\xac\xfb", [0x2bbc] = "\xac\xfc",
  [0x2bbd] = "\xac\xfd", [0x2bbe] = "\xac\xfe", [0x2c00] = "\xad\x40",
  [0x2c01] = "\xad\x41", [0x2c02] = "\xad\x42", [0x2c03] = "\xad\x43",
  [0x2c04] = "\xad\x44", [0x2c05] = "\xad\x45", [0x2c06] = "\xad\x46",
  [0x2c07] = "\xad\x47", [0x2c08] = "\xad\x48", [0x2c09] = "\xad\x49",
  [0x2c0a] = "\xad\x4a", [0x2c0b] = "\xad\x4b", [0x2c0c] = "\xad\x4c",
  [0x2c0d] = "\xad\x4d", [0x2c0e] = "\xad\x4e", [0x2c0f] = "\xad\x4f",
  [0x2c10] = "\xad\x50", [0x2c11] = "\xad\x51", [0x2c12] = "\xad\x52",
  [0x2c13] = "\xad\x53", [0x2c14] = "\xad\x54", [0x2c15] = "\xad\x55",
  [0x2c16] = "\xad\x56", [0x2c17] = "\xad\x57", [0x2c18] = "\xad\x58",
  [0x2c19] = "\xad\x59", [0x2c1a] = "\xad\x5a", [0x2c1b] = "\xad\x5b",
  [0x2c1c] = "\xad\x5c", [0x2c1d] = "\xad\x5d", [0x2c1e] = "\xad\x5e",
  [0x2c1f] = "\xad\x5f", [0x2c20] = "\xad\x60", [0x2c21] = "\xad\x61",
  [0x2c22] = "\xad\x62", [0x2c23] = "\xad\x63", [0x2c24] = "\xad\x64",
  [0x2c25] = "\xad\x65", [0x2c26] = "\xad\x66", [0x2c27] = "\xad\x67",
  [0x2c28] = "\xad\x68", [0x2c29] = "\xad\x69", [0x2c2a] = "\xad\x6a",
  [0x2c2b] = "\xad\x6b", [0x2c2c] = "\xad\x6c", [0x2c2d] = "\xad\x6d",
  [0x2c2e] = "\xad\x6e", [0x2c2f] = "\xad\x6f", [0x2c30] = "\xad\x70",
  [0x2c31] = "\xad\x71", [0x2c32] = "\xad\x72", [0x2c33] = "\xad\x73",
  [0x2c34] = "\xad\x74", [0x2c35] = "\xad\x75", [0x2c36] = "\xad\x76",
  [0x2c37] = "\xad\x77", [0x2c38] = "\xad\x78", [0x2c39] = "\xad\x79",
  [0x2c3a] = "\xad\x7a", [0x2c3b] = "\xad\x7b", [0x2c3c] = "\xad\x7c",
  [0x2c3d] = "\xad\x7d", [0x2c3e] = "\xad\x7e", [0x2c40] = "\xad\x80",
  [0x2c41] = "\xad\x81", [0x2c42] = "\xad\x82", [0x2c43] = "\xad\x83",
  [0x2c44] = "\xad\x84", [0x2c45] = "\xad\x85", [0x2c46] = "\xad\x86",
  [0x2c47] = "\xad\x87", [0x2c48] = "\xad\x88", [0x2c49] = "\xad\x89",
  [0x2c4a] = "\xad\x8a", [0x2c4b] = "\xad\x8b", [0x2c4c] = "\xad\x8c",
  [0x2c4d] = "\xad\x8d", [0x2c4e] = "\xad\x8e", [0x2c4f] = "\xad\x8f",
  [0x2c50] = "\xad\x90", [0x2c51] = "\xad\x91", [0x2c52] = "\xad\x92",
  [0x2c53] = "\xad\x93", [0x2c54] = "\xad\x94", [0x2c55] = "\xad\x95",
  [0x2c56] = "\xad\x96", [0x2c57] = "\xad\x97", [0x2c58] = "\xad\x98",
  [0x2c59] = "\xad\x99", [0x2c5a] = "\xad\x9a", [0x2c5b] = "\xad\x9b",
  [0x2c5c] = "\xad\x9c", [0x2c5d] = "\xad\x9d", [0x2c5e] = "\xad\x9e",
  [0x2c5f] = "\xad\x9f", [0x2c60] = "\xad\xa0", [0x2c61] = "\xad\xa1",
  [0x2c62] = "\xad\xa2", [0x2c63] = "\xad\xa3", [0x2c64] = "\xad\xa4",
  [0x2c65] = "\xad\xa5", [0x2c66] = "\xad\xa6", [0x2c67] = "\xad\xa7",
  [0x2c68] = "\xad\xa8", [0x2c69] = "\xad\xa9", [0x2c6a] = "\xad\xaa",
  [0x2c6b] = "\xad\xab", [0x2c6c] = "\xad\xac", [0x2c6d] = "\xad\xad",
  [0x2c6e] = "\xad\xae", [0x2c6f] = "\xad\xaf", [0x2c70] = "\xad\xb0",
  [0x2c71] = "\xad\xb1", [0x2c72] = "\xad\xb2", [0x2c73] = "\xad\xb3",
  [0x2c74] = "\xad\xb4", [0x2c75] = "\xad\xb5", [0x2c76] = "\xad\xb6",
  [0x2c77] = "\xad\xb7", [0x2c78] = "\xad\xb8", [0x2c79] = "\xad\xb9",
  [0x2c7a] = "\xad\xba", [0x2c7b] = "\xad\xbb", [0x2c7c] = "\xad\xbc",
  [0x2c7d] = "\xad\xbd", [0x2c7e] = "\xad\xbe", [0x2c7f] = "\xad\xbf",
  [0x2c80] = "\xad\xc0", [0x2c81] = "\xad\xc1", [0x2c82] = "\xad\xc2",
  [0x2c83] = "\xad\xc3", [0x2c84] = "\xad\xc4", [0x2c85] = "\xad\xc5",
  [0x2c86] = "\xad\xc6", [0x2c87] = "\xad\xc7", [0x2c88] = "\xad\xc8",
  [0x2c89] = "\xad\xc9", [0x2c8a] = "\xad\xca", [0x2c8b] = "\xad\xcb",
  [0x2c8c] = "\xad\xcc", [0x2c8d] = "\xad\xcd", [0x2c8e] = "\xad\xce",
  [0x2c8f] = "\xad\xcf", [0x2c90] = "\xad\xd0", [0x2c91] = "\xad\xd1",
  [0x2c92] = "\xad\xd2", [0x2c93] = "\xad\xd3", [0x2c94] = "\xad\xd4",
  [0x2c95] = "\xad\xd5", [0x2c96] = "\xad\xd6", [0x2c97] = "\xad\xd7",
  [0x2c98] = "\xad\xd8", [0x2c99] = "\xad\xd9", [0x2c9a] = "\xad\xda",
  [0x2c9b] = "\xad\xdb", [0x2c9c] = "\xad\xdc", [0x2c9d] = "\xad\xdd",
  [0x2c9e] = "\xad\xde", [0x2c9f] = "\xad\xdf", [0x2ca0] = "\xad\xe0",
  [0x2ca1] = "\xad\xe1", [0x2ca2] = "\xad\xe2", [0x2ca3] = "\xad\xe3",
  [0x2ca4] = "\xad\xe4", [0x2ca5] = "\xad\xe5", [0x2ca6] = "\xad\xe6",
  [0x2ca7] = "\xad\xe7", [0x2ca8] = "\xad\xe8", [0x2ca9] = "\xad\xe9",
  [0x2caa] = "\xad\xea", [0x2cab] = "\xad\xeb", [0x2cac] = "\xad\xec",
  [0x2cad] = "\xad\xed", [0x2cae] = "\xad\xee", [0x2caf] = "\xad\xef",
  [0x2cb0] = "\xad\xf0", [0x2cb1] = "\xad\xf1", [0x2cb2] = "\xad\xf2",
  [0x2cb3] = "\xad\xf3", [0x2cb4] = "\xad\xf4", [0x2cb5] = "\xad\xf5",
  [0x2cb6] = "\xad\xf6", [0x2cb7] = "\xad\xf7", [0x2cb8] = "\xad\xf8",
  [0x2cb9] = "\xad\xf9", [0x2cba] = "\xad\xfa", [0x2cbb] = "\xad\xfb",
  [0x2cbc] = "\xad\xfc", [0x2cbd] = "\xad\xfd", [0x2cbe] = "\xad\xfe",
  [0x2d00] = "\xae\x40", [0x2d01] = "\xae\x41", [0x2d02] = "\xae\x42",
  [0x2d03] = "\xae\x43", [0x2d04] = "\xae\x44", [0x2d05] = "\xae\x45",
  [0x2d06] = "\xae\x46", [0x2d07] = "\xae\x47", [0x2d08] = "\xae\x48",
  [0x2d09] = "\xae\x49", [0x2d0a] = "\xae\x4a", [0x2d0b] = "\xae\x4b",
  [0x2d0c] = "\xae\x4c", [0x2d0d] = "\xae\x4d", [0x2d0e] = "\xae\x4e",
  [0x2d0f] = "\xae\x4f", [0x2d10] = "\xae\x50", [0x2d11] = "\xae\x51",
  [0x2d12] = "\xae\x52", [0x2d13] = "\xae\x53", [0x2d14] = "\xae\x54",
  [0x2d15] = "\xae\x55", [0x2d16] = "\xae\x56", [0x2d17] = "\xae\x57",
  [0x2d18] = "\xae\x58", [0x2d19] = "\xae\x59", [0x2d1a] = "\xae\x5a",
  [0x2d1b] = "\xae\x5b", [0x2d1c] = "\xae\x5c", [0x2d1d] = "\xae\x5d",
  [0x2d1e] = "\xae\x5e", [0x2d1f] = "\xae\x5f", [0x2d20] = "\xae\x60",
  [0x2d21] = "\xae\x61", [0x2d22] = "\xae\x62", [0x2d23] = "\xae\x63",
  [0x2d24] = "\xae\x64", [0x2d25] = "\xae\x65", [0x2d26] = "\xae\x66",
  [0x2d27] = "\xae\x67", [0x2d28] = "\xae\x68", [0x2d29] = "\xae\x69",
  [0x2d2a] = "\xae\x6a", [0x2d2b] = "\xae\x6b", [0x2d2c] = "\xae\x6c",
  [0x2d2d] = "\xae\x6d", [0x2d2e] = "\xae\x6e", [0x2d2f] = "\xae\x6f",
  [0x2d30] = "\xae\x70", [0x2d31] = "\xae\x71", [0x2d32] = "\xae\x72",
  [0x2d33] = "\xae\x73", [0x2d34] = "\xae\x74", [0x2d35] = "\xae\x75",
  [0x2d36] = "\xae\x76", [0x2d37] = "\xae\x77", [0x2d38] = "\xae\x78",
  [0x2d39] = "\xae\x79", [0x2d3a] = "\xae\x7a", [0x2d3b] = "\xae\x7b",
  [0x2d3c] = "\xae\x7c", [0x2d3d] = "\xae\x7d", [0x2d3e] = "\xae\x7e",
  [0x2d40] = "\xae\x80", [0x2d41] = "\xae\x81", [0x2d42] = "\xae\x82",
  [0x2d43] = "\xae\x83", [0x2d44] = "\xae\x84", [0x2d45] = "\xae\x85",
  [0x2d46] = "\xae\x86", [0x2d47] = "\xae\x87", [0x2d48] = "\xae\x88",
  [0x2d49] = "\xae\x89", [0x2d4a] = "\xae\x8a", [0x2d4b] = "\xae\x8b",
  [0x2d4c] = "\xae\x8c", [0x2d4d] = "\xae\x8d", [0x2d4e] = "\xae\x8e",
  [0x2d4f] = "\xae\x8f", [0x2d50] = "\xae\x90", [0x2d51] = "\xae\x91",
  [0x2d52] = "\xae\x92", [0x2d53] = "\xae\x93", [0x2d54] = "\xae\x94",
  [0x2d55] = "\xae\x95", [0x2d56] = "\xae\x96", [0x2d57] = "\xae\x97",
  [0x2d58] = "\xae\x98", [0x2d59] = "\xae\x99", [0x2d5a] = "\xae\x9a",
  [0x2d5b] = "\xae\x9b", [0x2d5c] = "\xae\x9c", [0x2d5d] = "\xae\x9d",
  [0x2d5e] = "\xae\x9e", [0x2d5f] = "\xae\x9f", [0x2d60] = "\xae\xa0",
  [0x2d61] = "\xae\xa1", [0x2d62] = "\xae\xa2", [0x2d63] = "\xae\xa3",
  [0x2d64] = "\xae\xa4", [0x2d65] = "\xae\xa5", [0x2d66] = "\xae\xa6",
  [0x2d67] = "\xae\xa7", [0x2d68] = "\xae\xa8", [0x2d69] = "\xae\xa9",
  [0x2d6a] = "\xae\xaa", [0x2d6b] = "\xae\xab", [0x2d6c] = "\xae\xac",
  [0x2d6d] = "\xae\xad", [0x2d6e] = "\xae\xae", [0x2d6f] = "\xae\xaf",
  [0x2d70] = "\xae\xb0", [0x2d71] = "\xae\xb1", [0x2d72] = "\xae\xb2",
  [0x2d73] = "\xae\xb3", [0x2d74] = "\xae\xb4", [0x2d75] = "\xae\xb5",
  [0x2d76] = "\xae\xb6", [0x2d77] = "\xae\xb7", [0x2d78] = "\xae\xb8",
  [0x2d79] = "\xae\xb9", [0x2d7a] = "\xae\xba", [0x2d7b] = "\xae\xbb",
  [0x2d7c] = "\xae\xbc", [0x2d7d] = "\xae\xbd", [0x2d7e] = "\xae\xbe",
  [0x2d7f] = "\xae\xbf", [0x2d80] = "\xae\xc0", [0x2d81] = "\xae\xc1",
  [0x2d82] = "\xae\xc2", [0x2d83] = "\xae\xc3", [0x2d84] = "\xae\xc4",
  [0x2d85] = "\xae\xc5", [0x2d86] = "\xae\xc6", [0x2d87] = "\xae\xc7",
  [0x2d88] = "\xae\xc8", [0x2d89] = "\xae\xc9", [0x2d8a] = "\xae\xca",
  [0x2d8b] = "\xae\xcb", [0x2d8c] = "\xae\xcc", [0x2d8d] = "\xae\xcd",
  [0x2d8e] = "\xae\xce", [0x2d8f] = "\xae\xcf", [0x2d90] = "\xae\xd0",
  [0x2d91] = "\xae\xd1", [0x2d92] = "\xae\xd2", [0x2d93] = "\xae\xd3",
  [0x2d94] = "\xae\xd4", [0x2d95] = "\xae\xd5", [0x2d96] = "\xae\xd6",
  [0x2d97] = "\xae\xd7", [0x2d98] = "\xae\xd8", [0x2d99] = "\xae\xd9",
  [0x2d9a] = "\xae\xda", [0x2d9b] = "\xae\xdb", [0x2d9c] = "\xae\xdc",
  [0x2d9d] = "\xae\xdd", [0x2d9e] = "\xae\xde", [0x2d9f] = "\xae\xdf",
  [0x2da0] = "\xae\xe0", [0x2da1] = "\xae\xe1", [0x2da2] = "\xae\xe2",
  [0x2da3] = "\xae\xe3", [0x2da4] = "\xae\xe4", [0x2da5] = "\xae\xe5",
  [0x2da6] = "\xae\xe6", [0x2da7] = "\xae\xe7", [0x2da8] = "\xae\xe8",
  [0x2da9] = "\xae\xe9", [0x2daa] = "\xae\xea", [0x2dab] = "\xae\xeb",
  [0x2dac] = "\xae\xec", [0x2dad] = "\xae\xed", [0x2dae] = "\xae\xee",
  [0x2daf] = "\xae\xef", [0x2db0] = "\xae\xf0", [0x2db1] = "\xae\xf1",
  [0x2db2] = "\xae\xf2", [0x2db3] = "\xae\xf3", [0x2db4] = "\xae\xf4",
  [0x2db5] = "\xae\xf5", [0x2db6] = "\xae\xf6", [0x2db7] = "\xae\xf7",
  [0x2db8] = "\xae\xf8", [0x2db9] = "\xae\xf9", [0x2dba] = "\xae\xfa",
  [0x2dbb] = "\xae\xfb", [0x2dbc] = "\xae\xfc", [0x2dbd] = "\xae\xfd",
  [0x2dbe] = "\xae\xfe", [0x2e00] = "\xaf\x40", [0x2e01] = "\xaf\x41",
  [0x2e02] = "\xaf\x42", [0x2e03] = "\xaf\x43", [0x2e04] = "\xaf\x44",
  [0x2e05] = "\xaf\x45", [0x2e06] = "\xaf\x46", [0x2e07] = "\xaf\x47",
  [0x2e08] = "\xaf\x48", [0x2e09] = "\xaf\x49", [0x2e0a] = "\xaf\x4a",
  [0x2e0b] = "\xaf\x4b", [0x2e0c] = "\xaf\x4c", [0x2e0d] = "\xaf\x4d",
  [0x2e0e] = "\xaf\x4e", [0x2e0f] = "\xaf\x4f", [0x2e10] = "\xaf\x50",
  [0x2e11] = "\xaf\x51", [0x2e12] = "\xaf\x52", [0x2e13] = "\xaf\x53",
  [0x2e14] = "\xaf\x54", [0x2e15] = "\xaf\x55", [0x2e16] = "\xaf\x56",
  [0x2e17] = "\xaf\x57", [0x2e18] = "\xaf\x58", [0x2e19] = "\xaf\x59",
  [0x2e1a] = "\xaf\x5a", [0x2e1b] = "\xaf\x5b", [0x2e1c] = "\xaf\x5c",
  [0x2e1d] = "\xaf\x5d", [0x2e1e] = "\xaf\x5e", [0x2e1f] = "\xaf\x5f",
  [0x2e20] = "\xaf\x60", [0x2e21] = "\xaf\x61", [0x2e22] = "\xaf\x62",
  [0x2e23] = "\xaf\x63", [0x2e24] = "\xaf\x64", [0x2e25] = "\xaf\x65",
  [0x2e26] = "\xaf\x66", [0x2e27] = "\xaf\x67", [0x2e28] = "\xaf\x68",
  [0x2e29] = "\xaf\x69", [0x2e2a] = "\xaf\x6a", [0x2e2b] = "\xaf\x6b",
  [0x2e2c] = "\xaf\x6c", [0x2e2d] = "\xaf\x6d", [0x2e2e] = "\xaf\x6e",
  [0x2e2f] = "\xaf\x6f", [0x2e30] = "\xaf\x70", [0x2e31] = "\xaf\x71",
  [0x2e32] = "\xaf\x72", [0x2e33] = "\xaf\x73", [0x2e34] = "\xaf\x74",
  [0x2e35] = "\xaf\x75", [0x2e36] = "\xaf\x76", [0x2e37] = "\xaf\x77",
  [0x2e38] = "\xaf\x78", [0x2e39] = "\xaf\x79", [0x2e3a] = "\xaf\x7a",
  [0x2e3b] = "\xaf\x7b", [0x2e3c] = "\xaf\x7c", [0x2e3d] = "\xaf\x7d",
  [0x2e3e] = "\xaf\x7e", [0x2e40] = "\xaf\x80", [0x2e41] = "\xaf\x81",
  [0x2e42] = "\xaf\x82", [0x2e43] = "\xaf\x83", [0x2e44] = "\xaf\x84",
  [0x2e45] = "\xaf\x85", [0x2e46] = "\xaf\x86", [0x2e47] = "\xaf\x87",
  [0x2e48] = "\xaf\x88", [0x2e49] = "\xaf\x89", [0x2e4a] = "\xaf\x8a",
  [0x2e4b] = "\xaf\x8b", [0x2e4c] = "\xaf\x8c", [0x2e4d] = "\xaf\x8d",
  [0x2e4e] = "\xaf\x8e", [0x2e4f] = "\xaf\x8f", [0x2e50] = "\xaf\x90",
  [0x2e51] = "\xaf\x91", [0x2e52] = "\xaf\x92", [0x2e53] = "\xaf\x93",
  [0x2e54] = "\xaf\x94", [0x2e55] = "\xaf\x95", [0x2e56] = "\xaf\x96",
  [0x2e57] = "\xaf\x97", [0x2e58] = "\xaf\x98", [0x2e59] = "\xaf\x99",
  [0x2e5a] = "\xaf\x9a", [0x2e5b] = "\xaf\x9b", [0x2e5c] = "\xaf\x9c",
  [0x2e5d] = "\xaf\x9d", [0x2e5e] = "\xaf\x9e", [0x2e5f] = "\xaf\x9f",
  [0x2e60] = "\xaf\xa0", [0x2e61] = "\xaf\xa1", [0x2e62] = "\xaf\xa2",
  [0x2e63] = "\xaf\xa3", [0x2e64] = "\xaf\xa4", [0x2e65] = "\xaf\xa5",
  [0x2e66] = "\xaf\xa6", [0x2e67] = "\xaf\xa7", [0x2e68] = "\xaf\xa8",
  [0x2e69] = "\xaf\xa9", [0x2e6a] = "\xaf\xaa", [0x2e6b] = "\xaf\xab",
  [0x2e6c] = "\xaf\xac", [0x2e6d] = "\xaf\xad", [0x2e6e] = "\xaf\xae",
  [0x2e6f] = "\xaf\xaf", [0x2e70] = "\xaf\xb0", [0x2e71] = "\xaf\xb1",
  [0x2e72] = "\xaf\xb2", [0x2e73] = "\xaf\xb3", [0x2e74] = "\xaf\xb4",
  [0x2e75] = "\xaf\xb5", [0x2e76] = "\xaf\xb6", [0x2e77] = "\xaf\xb7",
  [0x2e78] = "\xaf\xb8", [0x2e79] = "\xaf\xb9", [0x2e7a] = "\xaf\xba",
  [0x2e7b] = "\xaf\xbb", [0x2e7c] = "\xaf\xbc", [0x2e7d] = "\xaf\xbd",
  [0x2e7e] = "\xaf\xbe", [0x2e7f] = "\xaf\xbf", [0x2e80] = "\xaf\xc0",
  [0x2e81] = "\xaf\xc1", [0x2e82] = "\xaf\xc2", [0x2e83] = "\xaf\xc3",
  [0x2e84] = "\xaf\xc4", [0x2e85] = "\xaf\xc5", [0x2e86] = "\xaf\xc6",
  [0x2e87] = "\xaf\xc7", [0x2e88] = "\xaf\xc8", [0x2e89] = "\xaf\xc9",
  [0x2e8a] = "\xaf\xca", [0x2e8b] = "\xaf\xcb", [0x2e8c] = "\xaf\xcc",
  [0x2e8d] = "\xaf\xcd", [0x2e8e] = "\xaf\xce", [0x2e8f] = "\xaf\xcf",
  [0x2e90] = "\xaf\xd0", [0x2e91] = "\xaf\xd1", [0x2e92] = "\xaf\xd2",
  [0x2e93] = "\xaf\xd3", [0x2e94] = "\xaf\xd4", [0x2e95] = "\xaf\xd5",
  [0x2e96] = "\xaf\xd6", [0x2e97] = "\xaf\xd7", [0x2e98] = "\xaf\xd8",
  [0x2e99] = "\xaf\xd9", [0x2e9a] = "\xaf\xda", [0x2e9b] = "\xaf\xdb",
  [0x2e9c] = "\xaf\xdc", [0x2e9d] = "\xaf\xdd", [0x2e9e] = "\xaf\xde",
  [0x2e9f] = "\xaf\xdf", [0x2ea0] = "\xaf\xe0", [0x2ea1] = "\xaf\xe1",
  [0x2ea2] = "\xaf\xe2", [0x2ea3] = "\xaf\xe3", [0x2ea4] = "\xaf\xe4",
  [0x2ea5] = "\xaf\xe5", [0x2ea6] = "\xaf\xe6", [0x2ea7] = "\xaf\xe7",
  [0x2ea8] = "\xaf\xe8", [0x2ea9] = "\xaf\xe9", [0x2eaa] = "\xaf\xea",
  [0x2eab] = "\xaf\xeb", [0x2eac] = "\xaf\xec", [0x2ead] = "\xaf\xed",
  [0x2eae] = "\xaf\xee", [0x2eaf] = "\xaf\xef", [0x2eb0] = "\xaf\xf0",
  [0x2eb1] = "\xaf\xf1", [0x2eb2] = "\xaf\xf2", [0x2eb3] = "\xaf\xf3",
  [0x2eb4] = "\xaf\xf4", [0x2eb5] = "\xaf\xf5", [0x2eb6] = "\xaf\xf6",
  [0x2eb7] = "\xaf\xf7", [0x2eb8] = "\xaf\xf8", [0x2eb9] = "\xaf\xf9",
  [0x2eba] = "\xaf\xfa", [0x2ebb] = "\xaf\xfb", [0x2ebc] = "\xaf\xfc",
  [0x2ebd] = "\xaf\xfd", [0x2ebe] = "\xaf\xfe", [0x2f00] = "\xb0\x40",
  [0x2f01] = "\xb0\x41", [0x2f02] = "\xb0\x42", [0x2f03] = "\xb0\x43",
  [0x2f04] = "\xb0\x44", [0x2f05] = "\xb0\x45", [0x2f06] = "\xb0\x46",
  [0x2f07] = "\xb0\x47", [0x2f08] = "\xb0\x48", [0x2f09] = "\xb0\x49",
  [0x2f0a] = "\xb0\x4a", [0x2f0b] = "\xb0\x4b", [0x2f0c] = "\xb0\x4c",
  [0x2f0d] = "\xb0\x4d", [0x2f0e] = "\xb0\x4e", [0x2f0f] = "\xb0\x4f",
  [0x2f10] = "\xb0\x50", [0x2f11] = "\xb0\x51", [0x2f12] = "\xb0\x52",
  [0x2f13] = "\xb0\x53", [0x2f14] = "\xb0\x54", [0x2f15] = "\xb0\x55",
  [0x2f16] = "\xb0\x56", [0x2f17] = "\xb0\x57", [0x2f18] = "\xb0\x58",
  [0x2f19] = "\xb0\x59", [0x2f1a] = "\xb0\x5a", [0x2f1b] = "\xb0\x5b",
  [0x2f1c] = "\xb0\x5c", [0x2f1d] = "\xb0\x5d", [0x2f1e] = "\xb0\x5e",
  [0x2f1f] = "\xb0\x5f", [0x2f20] = "\xb0\x60", [0x2f21] = "\xb0\x61",
  [0x2f22] = "\xb0\x62", [0x2f23] = "\xb0\x63", [0x2f24] = "\xb0\x64",
  [0x2f25] = "\xb0\x65", [0x2f26] = "\xb0\x66", [0x2f27] = "\xb0\x67",
  [0x2f28] = "\xb0\x68", [0x2f29] = "\xb0\x69", [0x2f2a] = "\xb0\x6a",
  [0x2f2b] = "\xb0\x6b", [0x2f2c] = "\xb0\x6c", [0x2f2d] = "\xb0\x6d",
  [0x2f2e] = "\xb0\x6e", [0x2f2f] = "\xb0\x6f", [0x2f30] = "\xb0\x70",
  [0x2f31] = "\xb0\x71", [0x2f32] = "\xb0\x72", [0x2f33] = "\xb0\x73",
  [0x2f34] = "\xb0\x74", [0x2f35] = "\xb0\x75", [0x2f36] = "\xb0\x76",
  [0x2f37] = "\xb0\x77", [0x2f38] = "\xb0\x78", [0x2f39] = "\xb0\x79",
  [0x2f3a] = "\xb0\x7a", [0x2f3b] = "\xb0\x7b", [0x2f3c] = "\xb0\x7c",
  [0x2f3d] = "\xb0\x7d", [0x2f3e] = "\xb0\x7e", [0x2f40] = "\xb0\x80",
  [0x2f41] = "\xb0\x81", [0x2f42] = "\xb0\x82", [0x2f43] = "\xb0\x83",
  [0x2f44] = "\xb0\x84", [0x2f45] = "\xb0\x85", [0x2f46] = "\xb0\x86",
  [0x2f47] = "\xb0\x87", [0x2f48] = "\xb0\x88", [0x2f49] = "\xb0\x89",
  [0x2f4a] = "\xb0\x8a", [0x2f4b] = "\xb0\x8b", [0x2f4c] = "\xb0\x8c",
  [0x2f4d] = "\xb0\x8d", [0x2f4e] = "\xb0\x8e", [0x2f4f] = "\xb0\x8f",
  [0x2f50] = "\xb0\x90", [0x2f51] = "\xb0\x91", [0x2f52] = "\xb0\x92",
  [0x2f53] = "\xb0\x93", [0x2f54] = "\xb0\x94", [0x2f55] = "\xb0\x95",
  [0x2f56] = "\xb0\x96", [0x2f57] = "\xb0\x97", [0x2f58] = "\xb0\x98",
  [0x2f59] = "\xb0\x99", [0x2f5a] = "\xb0\x9a", [0x2f5b] = "\xb0\x9b",
  [0x2f5c] = "\xb0\x9c", [0x2f5d] = "\xb0\x9d", [0x2f5e] = "\xb0\x9e",
  [0x2f5f] = "\xb0\x9f", [0x2f60] = "\xb0\xa0", [0x2f61] = "\xb0\xa1",
  [0x2f62] = "\xb0\xa2", [0x2f63] = "\xb0\xa3", [0x2f64] = "\xb0\xa4",
  [0x2f65] = "\xb0\xa5", [0x2f66] = "\xb0\xa6", [0x2f67] = "\xb0\xa7",
  [0x2f68] = "\xb0\xa8", [0x2f69] = "\xb0\xa9", [0x2f6a] = "\xb0\xaa",
  [0x2f6b] = "\xb0\xab", [0x2f6c] = "\xb0\xac", [0x2f6d] = "\xb0\xad",
  [0x2f6e] = "\xb0\xae", [0x2f6f] = "\xb0\xaf", [0x2f70] = "\xb0\xb0",
  [0x2f71] = "\xb0\xb1", [0x2f72] = "\xb0\xb2", [0x2f73] = "\xb0\xb3",
  [0x2f74] = "\xb0\xb4", [0x2f75] = "\xb0\xb5", [0x2f76] = "\xb0\xb6",
  [0x2f77] = "\xb0\xb7", [0x2f78] = "\xb0\xb8", [0x2f79] = "\xb0\xb9",
  [0x2f7a] = "\xb0\xba", [0x2f7b] = "\xb0\xbb", [0x2f7c] = "\xb0\xbc",
  [0x2f7d] = "\xb0\xbd", [0x2f7e] = "\xb0\xbe", [0x2f7f] = "\xb0\xbf",
  [0x2f80] = "\xb0\xc0", [0x2f81] = "\xb0\xc1", [0x2f82] = "\xb0\xc2",
  [0x2f83] = "\xb0\xc3", [0x2f84] = "\xb0\xc4", [0x2f85] = "\xb0\xc5",
  [0x2f86] = "\xb0\xc6", [0x2f87] = "\xb0\xc7", [0x2f88] = "\xb0\xc8",
  [0x2f89] = "\xb0\xc9", [0x2f8a] = "\xb0\xca", [0x2f8b] = "\xb0\xcb",
  [0x2f8c] = "\xb0\xcc", [0x2f8d] = "\xb0\xcd", [0x2f8e] = "\xb0\xce",
  [0x2f8f] = "\xb0\xcf", [0x2f90] = "\xb0\xd0", [0x2f91] = "\xb0\xd1",
  [0x2f92] = "\xb0\xd2", [0x2f93] = "\xb0\xd3", [0x2f94] = "\xb0\xd4",
  [0x2f95] = "\xb0\xd5", [0x2f96] = "\xb0\xd6", [0x2f97] = "\xb0\xd7",
  [0x2f98] = "\xb0\xd8", [0x2f99] = "\xb0\xd9", [0x2f9a] = "\xb0\xda",
  [0x2f9b] = "\xb0\xdb", [0x2f9c] = "\xb0\xdc", [0x2f9d] = "\xb0\xdd",
  [0x2f9e] = "\xb0\xde", [0x2f9f] = "\xb0\xdf", [0x2fa0] = "\xb0\xe0",
  [0x2fa1] = "\xb0\xe1", [0x2fa2] = "\xb0\xe2", [0x2fa3] = "\xb0\xe3",
  [0x2fa4] = "\xb0\xe4", [0x2fa5] = "\xb0\xe5", [0x2fa6] = "\xb0\xe6",
  [0x2fa7] = "\xb0\xe7", [0x2fa8] = "\xb0\xe8", [0x2fa9] = "\xb0\xe9",
  [0x2faa] = "\xb0\xea", [0x2fab] = "\xb0\xeb", [0x2fac] = "\xb0\xec",
  [0x2fad] = "\xb0\xed", [0x2fae] = "\xb0\xee", [0x2faf] = "\xb0\xef",
  [0x2fb0] = "\xb0\xf0", [0x2fb1] = "\xb0\xf1", [0x2fb2] = "\xb0\xf2",
  [0x2fb3] = "\xb0\xf3", [0x2fb4] = "\xb0\xf4", [0x2fb5] = "\xb0\xf5",
  [0x2fb6] = "\xb0\xf6", [0x2fb7] = "\xb0\xf7", [0x2fb8] = "\xb0\xf8",
  [0x2fb9] = "\xb0\xf9", [0x2fba] = "\xb0\xfa", [0x2fbb] = "\xb0\xfb",
  [0x2fbc] = "\xb0\xfc", [0x2fbd] = "\xb0\xfd", [0x2fbe] = "\xb0\xfe",
  [0x3000] = "\xb1\x40", [0x3001] = "\xb1\x41", [0x3002] = "\xb1\x42",
  [0x3003] = "\xb1\x43", [0x3004] = "\xb1\x44", [0x3005] = "\xb1\x45",
  [0x3006] = "\xb1\x46", [0x3007] = "\xb1\x47", [0x3008] = "\xb1\x48",
  [0x3009] = "\xb1\x49", [0x300a] = "\xb1\x4a", [0x300b] = "\xb1\x4b",
  [0x300c] = "\xb1\x4c", [0x300d] = "\xb1\x4d", [0x300e] = "\xb1\x4e",
  [0x300f] = "\xb1\x4f", [0x3010] = "\xb1\x50", [0x3011] = "\xb1\x51",
  [0x3012] = "\xb1\x52", [0x3013] = "\xb1\x53", [0x3014] = "\xb1\x54",
  [0x3015] = "\xb1\x55", [0x3016] = "\xb1\x56", [0x3017] = "\xb1\x57",
  [0x3018] = "\xb1\x58", [0x3019] = "\xb1\x59", [0x301a] = "\xb1\x5a",
  [0x301b] = "\xb1\x5b", [0x301c] = "\xb1\x5c", [0x301d] = "\xb1\x5d",
  [0x301e] = "\xb1\x5e", [0x301f] = "\xb1\x5f", [0x3020] = "\xb1\x60",
  [0x3021] = "\xb1\x61", [0x3022] = "\xb1\x62", [0x3023] = "\xb1\x63",
  [0x3024] = "\xb1\x64", [0x3025] = "\xb1\x65", [0x3026] = "\xb1\x66",
  [0x3027] = "\xb1\x67", [0x3028] = "\xb1\x68", [0x3029] = "\xb1\x69",
  [0x302a] = "\xb1\x6a", [0x302b] = "\xb1\x6b", [0x302c] = "\xb1\x6c",
  [0x302d] = "\xb1\x6d", [0x302e] = "\xb1\x6e", [0x302f] = "\xb1\x6f",
  [0x3030] = "\xb1\x70", [0x3031] = "\xb1\x71", [0x3032] = "\xb1\x72",
  [0x3033] = "\xb1\x73", [0x3034] = "\xb1\x74", [0x3035] = "\xb1\x75",
  [0x3036] = "\xb1\x76", [0x3037] = "\xb1\x77", [0x3038] = "\xb1\x78",
  [0x3039] = "\xb1\x79", [0x303a] = "\xb1\x7a", [0x303b] = "\xb1\x7b",
  [0x303c] = "\xb1\x7c", [0x303d] = "\xb1\x7d", [0x303e] = "\xb1\x7e",
  [0x3040] = "\xb1\x80", [0x3041] = "\xb1\x81", [0x3042] = "\xb1\x82",
  [0x3043] = "\xb1\x83", [0x3044] = "\xb1\x84", [0x3045] = "\xb1\x85",
  [0x3046] = "\xb1\x86", [0x3047] = "\xb1\x87", [0x3048] = "\xb1\x88",
  [0x3049] = "\xb1\x89", [0x304a] = "\xb1\x8a", [0x304b] = "\xb1\x8b",
  [0x304c] = "\xb1\x8c", [0x304d] = "\xb1\x8d", [0x304e] = "\xb1\x8e",
  [0x304f] = "\xb1\x8f", [0x3050] = "\xb1\x90", [0x3051] = "\xb1\x91",
  [0x3052] = "\xb1\x92", [0x3053] = "\xb1\x93", [0x3054] = "\xb1\x94",
  [0x3055] = "\xb1\x95", [0x3056] = "\xb1\x96", [0x3057] = "\xb1\x97",
  [0x3058] = "\xb1\x98", [0x3059] = "\xb1\x99", [0x305a] = "\xb1\x9a",
  [0x305b] = "\xb1\x9b", [0x305c] = "\xb1\x9c", [0x305d] = "\xb1\x9d",
  [0x305e] = "\xb1\x9e", [0x305f] = "\xb1\x9f", [0x3060] = "\xb1\xa0",
  [0x3061] = "\xb1\xa1", [0x3062] = "\xb1\xa2", [0x3063] = "\xb1\xa3",
  [0x3064] = "\xb1\xa4", [0x3065] = "\xb1\xa5", [0x3066] = "\xb1\xa6",
  [0x3067] = "\xb1\xa7", [0x3068] = "\xb1\xa8", [0x3069] = "\xb1\xa9",
  [0x306a] = "\xb1\xaa", [0x306b] = "\xb1\xab", [0x306c] = "\xb1\xac",
  [0x306d] = "\xb1\xad", [0x306e] = "\xb1\xae", [0x306f] = "\xb1\xaf",
  [0x3070] = "\xb1\xb0", [0x3071] = "\xb1\xb1", [0x3072] = "\xb1\xb2",
  [0x3073] = "\xb1\xb3", [0x3074] = "\xb1\xb4", [0x3075] = "\xb1\xb5",
  [0x3076] = "\xb1\xb6", [0x3077] = "\xb1\xb7", [0x3078] = "\xb1\xb8",
  [0x3079] = "\xb1\xb9", [0x307a] = "\xb1\xba", [0x307b] = "\xb1\xbb",
  [0x307c] = "\xb1\xbc", [0x307d] = "\xb1\xbd", [0x307e] = "\xb1\xbe",
  [0x307f] = "\xb1\xbf", [0x3080] = "\xb1\xc0", [0x3081] = "\xb1\xc1",
  [0x3082] = "\xb1\xc2", [0x3083] = "\xb1\xc3", [0x3084] = "\xb1\xc4",
  [0x3085] = "\xb1\xc5", [0x3086] = "\xb1\xc6", [0x3087] = "\xb1\xc7",
  [0x3088] = "\xb1\xc8", [0x3089] = "\xb1\xc9", [0x308a] = "\xb1\xca",
  [0x308b] = "\xb1\xcb", [0x308c] = "\xb1\xcc", [0x308d] = "\xb1\xcd",
  [0x308e] = "\xb1\xce", [0x308f] = "\xb1\xcf", [0x3090] = "\xb1\xd0",
  [0x3091] = "\xb1\xd1", [0x3092] = "\xb1\xd2", [0x3093] = "\xb1\xd3",
  [0x3094] = "\xb1\xd4", [0x3095] = "\xb1\xd5", [0x3096] = "\xb1\xd6",
  [0x3097] = "\xb1\xd7", [0x3098] = "\xb1\xd8", [0x3099] = "\xb1\xd9",
  [0x309a] = "\xb1\xda", [0x309b] = "\xb1\xdb", [0x309c] = "\xb1\xdc",
  [0x309d] = "\xb1\xdd", [0x309e] = "\xb1\xde", [0x309f] = "\xb1\xdf",
  [0x30a0] = "\xb1\xe0", [0x30a1] = "\xb1\xe1", [0x30a2] = "\xb1\xe2",
  [0x30a3] = "\xb1\xe3", [0x30a4] = "\xb1\xe4", [0x30a5] = "\xb1\xe5",
  [0x30a6] = "\xb1\xe6", [0x30a7] = "\xb1\xe7", [0x30a8] = "\xb1\xe8",
  [0x30a9] = "\xb1\xe9", [0x30aa] = "\xb1\xea", [0x30ab] = "\xb1\xeb",
  [0x30ac] = "\xb1\xec", [0x30ad] = "\xb1\xed", [0x30ae] = "\xb1\xee",
  [0x30af] = "\xb1\xef", [0x30b0] = "\xb1\xf0", [0x30b1] = "\xb1\xf1",
  [0x30b2] = "\xb1\xf2", [0x30b3] = "\xb1\xf3", [0x30b4] = "\xb1\xf4",
  [0x30b5] = "\xb1\xf5", [0x30b6] = "\xb1\xf6", [0x30b7] = "\xb1\xf7",
  [0x30b8] = "\xb1\xf8", [0x30b9] = "\xb1\xf9", [0x30ba] = "\xb1\xfa",
  [0x30bb] = "\xb1\xfb", [0x30bc] = "\xb1\xfc", [0x30bd] = "\xb1\xfd",
  [0x30be] = "\xb1\xfe", [0x3100] = "\xb2\x40", [0x3101] = "\xb2\x41",
  [0x3102] = "\xb2\x42", [0x3103] = "\xb2\x43", [0x3104] = "\xb2\x44",
  [0x3105] = "\xb2\x45", [0x3106] = "\xb2\x46", [0x3107] = "\xb2\x47",
  [0x3108] = "\xb2\x48", [0x3109] = "\xb2\x49", [0x310a] = "\xb2\x4a",
  [0x310b] = "\xb2\x4b", [0x310c] = "\xb2\x4c", [0x310d] = "\xb2\x4d",
  [0x310e] = "\xb2\x4e", [0x310f] = "\xb2\x4f", [0x3110] = "\xb2\x50",
  [0x3111] = "\xb2\x51", [0x3112] = "\xb2\x52", [0x3113] = "\xb2\x53",
  [0x3114] = "\xb2\x54", [0x3115] = "\xb2\x55", [0x3116] = "\xb2\x56",
  [0x3117] = "\xb2\x57", [0x3118] = "\xb2\x58", [0x3119] = "\xb2\x59",
  [0x311a] = "\xb2\x5a", [0x311b] = "\xb2\x5b", [0x311c] = "\xb2\x5c",
  [0x311d] = "\xb2\x5d", [0x311e] = "\xb2\x5e", [0x311f] = "\xb2\x5f",
  [0x3120] = "\xb2\x60", [0x3121] = "\xb2\x61", [0x3122] = "\xb2\x62",
  [0x3123] = "\xb2\x63", [0x3124] = "\xb2\x64", [0x3125] = "\xb2\x65",
  [0x3126] = "\xb2\x66", [0x3127] = "\xb2\x67", [0x3128] = "\xb2\x68",
  [0x3129] = "\xb2\x69", [0x312a] = "\xb2\x6a", [0x312b] = "\xb2\x6b",
  [0x312c] = "\xb2\x6c", [0x312d] = "\xb2\x6d", [0x312e] = "\xb2\x6e",
  [0x312f] = "\xb2\x6f", [0x3130] = "\xb2\x70", [0x3131] = "\xb2\x71",
  [0x3132] = "\xb2\x72", [0x3133] = "\xb2\x73", [0x3134] = "\xb2\x74",
  [0x3135] = "\xb2\x75", [0x3136] = "\xb2\x76", [0x3137] = "\xb2\x77",
  [0x3138] = "\xb2\x78", [0x3139] = "\xb2\x79", [0x313a] = "\xb2\x7a",
  [0x313b] = "\xb2\x7b", [0x313c] = "\xb2\x7c", [0x313d] = "\xb2\x7d",
  [0x313e] = "\xb2\x7e", [0x3140] = "\xb2\x80", [0x3141] = "\xb2\x81",
  [0x3142] = "\xb2\x82", [0x3143] = "\xb2\x83", [0x3144] = "\xb2\x84",
  [0x3145] = "\xb2\x85", [0x3146] = "\xb2\x86", [0x3147] = "\xb2\x87",
  [0x3148] = "\xb2\x88", [0x3149] = "\xb2\x89", [0x314a] = "\xb2\x8a",
  [0x314b] = "\xb2\x8b", [0x314c] = "\xb2\x8c", [0x314d] = "\xb2\x8d",
  [0x314e] = "\xb2\x8e", [0x314f] = "\xb2\x8f", [0x3150] = "\xb2\x90",
  [0x3151] = "\xb2\x91", [0x3152] = "\xb2\x92", [0x3153] = "\xb2\x93",
  [0x3154] = "\xb2\x94", [0x3155] = "\xb2\x95", [0x3156] = "\xb2\x96",
  [0x3157] = "\xb2\x97", [0x3158] = "\xb2\x98", [0x3159] = "\xb2\x99",
  [0x315a] = "\xb2\x9a", [0x315b] = "\xb2\x9b", [0x315c] = "\xb2\x9c",
  [0x315d] = "\xb2\x9d", [0x315e] = "\xb2\x9e", [0x315f] = "\xb2\x9f",
  [0x3160] = "\xb2\xa0", [0x3161] = "\xb2\xa1", [0x3162] = "\xb2\xa2",
  [0x3163] = "\xb2\xa3", [0x3164] = "\xb2\xa4", [0x3165] = "\xb2\xa5",
  [0x3166] = "\xb2\xa6", [0x3167] = "\xb2\xa7", [0x3168] = "\xb2\xa8",
  [0x3169] = "\xb2\xa9", [0x316a] = "\xb2\xaa", [0x316b] = "\xb2\xab",
  [0x316c] = "\xb2\xac", [0x316d] = "\xb2\xad", [0x316e] = "\xb2\xae",
  [0x316f] = "\xb2\xaf", [0x3170] = "\xb2\xb0", [0x3171] = "\xb2\xb1",
  [0x3172] = "\xb2\xb2", [0x3173] = "\xb2\xb3", [0x3174] = "\xb2\xb4",
  [0x3175] = "\xb2\xb5", [0x3176] = "\xb2\xb6", [0x3177] = "\xb2\xb7",
  [0x3178] = "\xb2\xb8", [0x3179] = "\xb2\xb9", [0x317a] = "\xb2\xba",
  [0x317b] = "\xb2\xbb", [0x317c] = "\xb2\xbc", [0x317d] = "\xb2\xbd",
  [0x317e] = "\xb2\xbe", [0x317f] = "\xb2\xbf", [0x3180] = "\xb2\xc0",
  [0x3181] = "\xb2\xc1", [0x3182] = "\xb2\xc2", [0x3183] = "\xb2\xc3",
  [0x3184] = "\xb2\xc4", [0x3185] = "\xb2\xc5", [0x3186] = "\xb2\xc6",
  [0x3187] = "\xb2\xc7", [0x3188] = "\xb2\xc8", [0x3189] = "\xb2\xc9",
  [0x318a] = "\xb2\xca", [0x318b] = "\xb2\xcb", [0x318c] = "\xb2\xcc",
  [0x318d] = "\xb2\xcd", [0x318e] = "\xb2\xce", [0x318f] = "\xb2\xcf",
  [0x3190] = "\xb2\xd0", [0x3191] = "\xb2\xd1", [0x3192] = "\xb2\xd2",
  [0x3193] = "\xb2\xd3", [0x3194] = "\xb2\xd4", [0x3195] = "\xb2\xd5",
  [0x3196] = "\xb2\xd6", [0x3197] = "\xb2\xd7", [0x3198] = "\xb2\xd8",
  [0x3199] = "\xb2\xd9", [0x319a] = "\xb2\xda", [0x319b] = "\xb2\xdb",
  [0x319c] = "\xb2\xdc", [0x319d] = "\xb2\xdd", [0x319e] = "\xb2\xde",
  [0x319f] = "\xb2\xdf", [0x31a0] = "\xb2\xe0", [0x31a1] = "\xb2\xe1",
  [0x31a2] = "\xb2\xe2", [0x31a3] = "\xb2\xe3", [0x31a4] = "\xb2\xe4",
  [0x31a5] = "\xb2\xe5", [0x31a6] = "\xb2\xe6", [0x31a7] = "\xb2\xe7",
  [0x31a8] = "\xb2\xe8", [0x31a9] = "\xb2\xe9", [0x31aa] = "\xb2\xea",
  [0x31ab] = "\xb2\xeb", [0x31ac] = "\xb2\xec", [0x31ad] = "\xb2\xed",
  [0x31ae] = "\xb2\xee", [0x31af] = "\xb2\xef", [0x31b0] = "\xb2\xf0",
  [0x31b1] = "\xb2\xf1", [0x31b2] = "\xb2\xf2", [0x31b3] = "\xb2\xf3",
  [0x31b4] = "\xb2\xf4", [0x31b5] = "\xb2\xf5", [0x31b6] = "\xb2\xf6",
  [0x31b7] = "\xb2\xf7", [0x31b8] = "\xb2\xf8", [0x31b9] = "\xb2\xf9",
  [0x31ba] = "\xb2\xfa", [0x31bb] = "\xb2\xfb", [0x31bc] = "\xb2\xfc",
  [0x31bd] = "\xb2\xfd", [0x31be] = "\xb2\xfe", [0x3200] = "\xb3\x40",
  [0x3201] = "\xb3\x41", [0x3202] = "\xb3\x42", [0x3203] = "\xb3\x43",
  [0x3204] = "\xb3\x44", [0x3205] = "\xb3\x45", [0x3206] = "\xb3\x46",
  [0x3207] = "\xb3\x47", [0x3208] = "\xb3\x48", [0x3209] = "\xb3\x49",
  [0x320a] = "\xb3\x4a", [0x320b] = "\xb3\x4b", [0x320c] = "\xb3\x4c",
  [0x320d] = "\xb3\x4d", [0x320e] = "\xb3\x4e", [0x320f] = "\xb3\x4f",
  [0x3210] = "\xb3\x50", [0x3211] = "\xb3\x51", [0x3212] = "\xb3\x52",
  [0x3213] = "\xb3\x53", [0x3214] = "\xb3\x54", [0x3215] = "\xb3\x55",
  [0x3216] = "\xb3\x56", [0x3217] = "\xb3\x57", [0x3218] = "\xb3\x58",
  [0x3219] = "\xb3\x59", [0x321a] = "\xb3\x5a", [0x321b] = "\xb3\x5b",
  [0x321c] = "\xb3\x5c", [0x321d] = "\xb3\x5d", [0x321e] = "\xb3\x5e",
  [0x321f] = "\xb3\x5f", [0x3220] = "\xb3\x60", [0x3221] = "\xb3\x61",
  [0x3222] = "\xb3\x62", [0x3223] = "\xb3\x63", [0x3224] = "\xb3\x64",
  [0x3225] = "\xb3\x65", [0x3226] = "\xb3\x66", [0x3227] = "\xb3\x67",
  [0x3228] = "\xb3\x68", [0x3229] = "\xb3\x69", [0x322a] = "\xb3\x6a",
  [0x322b] = "\xb3\x6b", [0x322c] = "\xb3\x6c", [0x322d] = "\xb3\x6d",
  [0x322e] = "\xb3\x6e", [0x322f] = "\xb3\x6f", [0x3230] = "\xb3\x70",
  [0x3231] = "\xb3\x71", [0x3232] = "\xb3\x72", [0x3233] = "\xb3\x73",
  [0x3234] = "\xb3\x74", [0x3235] = "\xb3\x75", [0x3236] = "\xb3\x76",
  [0x3237] = "\xb3\x77", [0x3238] = "\xb3\x78", [0x3239] = "\xb3\x79",
  [0x323a] = "\xb3\x7a", [0x323b] = "\xb3\x7b", [0x323c] = "\xb3\x7c",
  [0x323d] = "\xb3\x7d", [0x323e] = "\xb3\x7e", [0x3240] = "\xb3\x80",
  [0x3241] = "\xb3\x81", [0x3242] = "\xb3\x82", [0x3243] = "\xb3\x83",
  [0x3244] = "\xb3\x84", [0x3245] = "\xb3\x85", [0x3246] = "\xb3\x86",
  [0x3247] = "\xb3\x87", [0x3248] = "\xb3\x88", [0x3249] = "\xb3\x89",
  [0x324a] = "\xb3\x8a", [0x324b] = "\xb3\x8b", [0x324c] = "\xb3\x8c",
  [0x324d] = "\xb3\x8d", [0x324e] = "\xb3\x8e", [0x324f] = "\xb3\x8f",
  [0x3250] = "\xb3\x90", [0x3251] = "\xb3\x91", [0x3252] = "\xb3\x92",
  [0x3253] = "\xb3\x93", [0x3254] = "\xb3\x94", [0x3255] = "\xb3\x95",
  [0x3256] = "\xb3\x96", [0x3257] = "\xb3\x97", [0x3258] = "\xb3\x98",
  [0x3259] = "\xb3\x99", [0x325a] = "\xb3\x9a", [0x325b] = "\xb3\x9b",
  [0x325c] = "\xb3\x9c", [0x325d] = "\xb3\x9d", [0x325e] = "\xb3\x9e",
  [0x325f] = "\xb3\x9f", [0x3260] = "\xb3\xa0", [0x3261] = "\xb3\xa1",
  [0x3262] = "\xb3\xa2", [0x3263] = "\xb3\xa3", [0x3264] = "\xb3\xa4",
  [0x3265] = "\xb3\xa5", [0x3266] = "\xb3\xa6", [0x3267] = "\xb3\xa7",
  [0x3268] = "\xb3\xa8", [0x3269] = "\xb3\xa9", [0x326a] = "\xb3\xaa",
  [0x326b] = "\xb3\xab", [0x326c] = "\xb3\xac", [0x326d] = "\xb3\xad",
  [0x326e] = "\xb3\xae", [0x326f] = "\xb3\xaf", [0x3270] = "\xb3\xb0",
  [0x3271] = "\xb3\xb1", [0x3272] = "\xb3\xb2", [0x3273] = "\xb3\xb3",
  [0x3274] = "\xb3\xb4", [0x3275] = "\xb3\xb5", [0x3276] = "\xb3\xb6",
  [0x3277] = "\xb3\xb7", [0x3278] = "\xb3\xb8", [0x3279] = "\xb3\xb9",
  [0x327a] = "\xb3\xba", [0x327b] = "\xb3\xbb", [0x327c] = "\xb3\xbc",
  [0x327d] = "\xb3\xbd", [0x327e] = "\xb3\xbe", [0x327f] = "\xb3\xbf",
  [0x3280] = "\xb3\xc0", [0x3281] = "\xb3\xc1", [0x3282] = "\xb3\xc2",
  [0x3283] = "\xb3\xc3", [0x3284] = "\xb3\xc4", [0x3285] = "\xb3\xc5",
  [0x3286] = "\xb3\xc6", [0x3287] = "\xb3\xc7", [0x3288] = "\xb3\xc8",
  [0x3289] = "\xb3\xc9", [0x328a] = "\xb3\xca", [0x328b] = "\xb3\xcb",
  [0x328c] = "\xb3\xcc", [0x328d] = "\xb3\xcd", [0x328e] = "\xb3\xce",
  [0x328f] = "\xb3\xcf", [0x3290] = "\xb3\xd0", [0x3291] = "\xb3\xd1",
  [0x3292] = "\xb3\xd2", [0x3293] = "\xb3\xd3", [0x3294] = "\xb3\xd4",
  [0x3295] = "\xb3\xd5", [0x3296] = "\xb3\xd6", [0x3297] = "\xb3\xd7",
  [0x3298] = "\xb3\xd8", [0x3299] = "\xb3\xd9", [0x329a] = "\xb3\xda",
  [0x329b] = "\xb3\xdb", [0x329c] = "\xb3\xdc", [0x329d] = "\xb3\xdd",
  [0x329e] = "\xb3\xde", [0x329f] = "\xb3\xdf", [0x32a0] = "\xb3\xe0",
  [0x32a1] = "\xb3\xe1", [0x32a2] = "\xb3\xe2", [0x32a3] = "\xb3\xe3",
  [0x32a4] = "\xb3\xe4", [0x32a5] = "\xb3\xe5", [0x32a6] = "\xb3\xe6",
  [0x32a7] = "\xb3\xe7", [0x32a8] = "\xb3\xe8", [0x32a9] = "\xb3\xe9",
  [0x32aa] = "\xb3\xea", [0x32ab] = "\xb3\xeb", [0x32ac] = "\xb3\xec",
  [0x32ad] = "\xb3\xed", [0x32ae] = "\xb3\xee", [0x32af] = "\xb3\xef",
  [0x32b0] = "\xb3\xf0", [0x32b1] = "\xb3\xf1", [0x32b2] = "\xb3\xf2",
  [0x32b3] = "\xb3\xf3", [0x32b4] = "\xb3\xf4", [0x32b5] = "\xb3\xf5",
  [0x32b6] = "\xb3\xf6", [0x32b7] = "\xb3\xf7", [0x32b8] = "\xb3\xf8",
  [0x32b9] = "\xb3\xf9", [0x32ba] = "\xb3\xfa", [0x32bb] = "\xb3\xfb",
  [0x32bc] = "\xb3\xfc", [0x32bd] = "\xb3\xfd", [0x32be] = "\xb3\xfe",
  [0x3300] = "\xb4\x40", [0x3301] = "\xb4\x41", [0x3302] = "\xb4\x42",
  [0x3303] = "\xb4\x43", [0x3304] = "\xb4\x44", [0x3305] = "\xb4\x45",
  [0x3306] = "\xb4\x46", [0x3307] = "\xb4\x47", [0x3308] = "\xb4\x48",
  [0x3309] = "\xb4\x49", [0x330a] = "\xb4\x4a", [0x330b] = "\xb4\x4b",
  [0x330c] = "\xb4\x4c", [0x330d] = "\xb4\x4d", [0x330e] = "\xb4\x4e",
  [0x330f] = "\xb4\x4f", [0x3310] = "\xb4\x50", [0x3311] = "\xb4\x51",
  [0x3312] = "\xb4\x52", [0x3313] = "\xb4\x53", [0x3314] = "\xb4\x54",
  [0x3315] = "\xb4\x55", [0x3316] = "\xb4\x56", [0x3317] = "\xb4\x57",
  [0x3318] = "\xb4\x58", [0x3319] = "\xb4\x59", [0x331a] = "\xb4\x5a",
  [0x331b] = "\xb4\x5b", [0x331c] = "\xb4\x5c", [0x331d] = "\xb4\x5d",
  [0x331e] = "\xb4\x5e", [0x331f] = "\xb4\x5f", [0x3320] = "\xb4\x60",
  [0x3321] = "\xb4\x61", [0x3322] = "\xb4\x62", [0x3323] = "\xb4\x63",
  [0x3324] = "\xb4\x64", [0x3325] = "\xb4\x65", [0x3326] = "\xb4\x66",
  [0x3327] = "\xb4\x67", [0x3328] = "\xb4\x68", [0x3329] = "\xb4\x69",
  [0x332a] = "\xb4\x6a", [0x332b] = "\xb4\x6b", [0x332c] = "\xb4\x6c",
  [0x332d] = "\xb4\x6d", [0x332e] = "\xb4\x6e", [0x332f] = "\xb4\x6f",
  [0x3330] = "\xb4\x70", [0x3331] = "\xb4\x71", [0x3332] = "\xb4\x72",
  [0x3333] = "\xb4\x73", [0x3334] = "\xb4\x74", [0x3335] = "\xb4\x75",
  [0x3336] = "\xb4\x76", [0x3337] = "\xb4\x77", [0x3338] = "\xb4\x78",
  [0x3339] = "\xb4\x79", [0x333a] = "\xb4\x7a", [0x333b] = "\xb4\x7b",
  [0x333c] = "\xb4\x7c", [0x333d] = "\xb4\x7d", [0x333e] = "\xb4\x7e",
  [0x3340] = "\xb4\x80", [0x3341] = "\xb4\x81", [0x3342] = "\xb4\x82",
  [0x3343] = "\xb4\x83", [0x3344] = "\xb4\x84", [0x3345] = "\xb4\x85",
  [0x3346] = "\xb4\x86", [0x3347] = "\xb4\x87", [0x3348] = "\xb4\x88",
  [0x3349] = "\xb4\x89", [0x334a] = "\xb4\x8a", [0x334b] = "\xb4\x8b",
  [0x334c] = "\xb4\x8c", [0x334d] = "\xb4\x8d", [0x334e] = "\xb4\x8e",
  [0x334f] = "\xb4\x8f", [0x3350] = "\xb4\x90", [0x3351] = "\xb4\x91",
  [0x3352] = "\xb4\x92", [0x3353] = "\xb4\x93", [0x3354] = "\xb4\x94",
  [0x3355] = "\xb4\x95", [0x3356] = "\xb4\x96", [0x3357] = "\xb4\x97",
  [0x3358] = "\xb4\x98", [0x3359] = "\xb4\x99", [0x335a] = "\xb4\x9a",
  [0x335b] = "\xb4\x9b", [0x335c] = "\xb4\x9c", [0x335d] = "\xb4\x9d",
  [0x335e] = "\xb4\x9e", [0x335f] = "\xb4\x9f", [0x3360] = "\xb4\xa0",
  [0x3361] = "\xb4\xa1", [0x3362] = "\xb4\xa2", [0x3363] = "\xb4\xa3",
  [0x3364] = "\xb4\xa4", [0x3365] = "\xb4\xa5", [0x3366] = "\xb4\xa6",
  [0x3367] = "\xb4\xa7", [0x3368] = "\xb4\xa8", [0x3369] = "\xb4\xa9",
  [0x336a] = "\xb4\xaa", [0x336b] = "\xb4\xab", [0x336c] = "\xb4\xac",
  [0x336d] = "\xb4\xad", [0x336e] = "\xb4\xae", [0x336f] = "\xb4\xaf",
  [0x3370] = "\xb4\xb0", [0x3371] = "\xb4\xb1", [0x3372] = "\xb4\xb2",
  [0x3373] = "\xb4\xb3", [0x3374] = "\xb4\xb4", [0x3375] = "\xb4\xb5",
  [0x3376] = "\xb4\xb6", [0x3377] = "\xb4\xb7", [0x3378] = "\xb4\xb8",
  [0x3379] = "\xb4\xb9", [0x337a] = "\xb4\xba", [0x337b] = "\xb4\xbb",
  [0x337c] = "\xb4\xbc", [0x337d] = "\xb4\xbd", [0x337e] = "\xb4\xbe",
  [0x337f] = "\xb4\xbf", [0x3380] = "\xb4\xc0", [0x3381] = "\xb4\xc1",
  [0x3382] = "\xb4\xc2", [0x3383] = "\xb4\xc3", [0x3384] = "\xb4\xc4",
  [0x3385] = "\xb4\xc5", [0x3386] = "\xb4\xc6", [0x3387] = "\xb4\xc7",
  [0x3388] = "\xb4\xc8", [0x3389] = "\xb4\xc9", [0x338a] = "\xb4\xca",
  [0x338b] = "\xb4\xcb", [0x338c] = "\xb4\xcc", [0x338d] = "\xb4\xcd",
  [0x338e] = "\xb4\xce", [0x338f] = "\xb4\xcf", [0x3390] = "\xb4\xd0",
  [0x3391] = "\xb4\xd1", [0x3392] = "\xb4\xd2", [0x3393] = "\xb4\xd3",
  [0x3394] = "\xb4\xd4", [0x3395] = "\xb4\xd5", [0x3396] = "\xb4\xd6",
  [0x3397] = "\xb4\xd7", [0x3398] = "\xb4\xd8", [0x3399] = "\xb4\xd9",
  [0x339a] = "\xb4\xda", [0x339b] = "\xb4\xdb", [0x339c] = "\xb4\xdc",
  [0x339d] = "\xb4\xdd", [0x339e] = "\xb4\xde", [0x339f] = "\xb4\xdf",
  [0x33a0] = "\xb4\xe0", [0x33a1] = "\xb4\xe1", [0x33a2] = "\xb4\xe2",
  [0x33a3] = "\xb4\xe3", [0x33a4] = "\xb4\xe4", [0x33a5] = "\xb4\xe5",
  [0x33a6] = "\xb4\xe6", [0x33a7] = "\xb4\xe7", [0x33a8] = "\xb4\xe8",
  [0x33a9] = "\xb4\xe9", [0x33aa] = "\xb4\xea", [0x33ab] = "\xb4\xeb",
  [0x33ac] = "\xb4\xec", [0x33ad] = "\xb4\xed", [0x33ae] = "\xb4\xee",
  [0x33af] = "\xb4\xef", [0x33b0] = "\xb4\xf0", [0x33b1] = "\xb4\xf1",
  [0x33b2] = "\xb4\xf2", [0x33b3] = "\xb4\xf3", [0x33b4] = "\xb4\xf4",
  [0x33b5] = "\xb4\xf5", [0x33b6] = "\xb4\xf6", [0x33b7] = "\xb4\xf7",
  [0x33b8] = "\xb4\xf8", [0x33b9] = "\xb4\xf9", [0x33ba] = "\xb4\xfa",
  [0x33bb] = "\xb4\xfb", [0x33bc] = "\xb4\xfc", [0x33bd] = "\xb4\xfd",
  [0x33be] = "\xb4\xfe", [0x3400] = "\xb5\x40", [0x3401] = "\xb5\x41",
  [0x3402] = "\xb5\x42", [0x3403] = "\xb5\x43", [0x3404] = "\xb5\x44",
  [0x3405] = "\xb5\x45", [0x3406] = "\xb5\x46", [0x3407] = "\xb5\x47",
  [0x3408] = "\xb5\x48", [0x3409] = "\xb5\x49", [0x340a] = "\xb5\x4a",
  [0x340b] = "\xb5\x4b", [0x340c] = "\xb5\x4c", [0x340d] = "\xb5\x4d",
  [0x340e] = "\xb5\x4e", [0x340f] = "\xb5\x4f", [0x3410] = "\xb5\x50",
  [0x3411] = "\xb5\x51", [0x3412] = "\xb5\x52", [0x3413] = "\xb5\x53",
  [0x3414] = "\xb5\x54", [0x3415] = "\xb5\x55", [0x3416] = "\xb5\x56",
  [0x3417] = "\xb5\x57", [0x3418] = "\xb5\x58", [0x3419] = "\xb5\x59",
  [0x341a] = "\xb5\x5a", [0x341b] = "\xb5\x5b", [0x341c] = "\xb5\x5c",
  [0x341d] = "\xb5\x5d", [0x341e] = "\xb5\x5e", [0x341f] = "\xb5\x5f",
  [0x3420] = "\xb5\x60", [0x3421] = "\xb5\x61", [0x3422] = "\xb5\x62",
  [0x3423] = "\xb5\x63", [0x3424] = "\xb5\x64", [0x3425] = "\xb5\x65",
  [0x3426] = "\xb5\x66", [0x3427] = "\xb5\x67", [0x3428] = "\xb5\x68",
  [0x3429] = "\xb5\x69", [0x342a] = "\xb5\x6a", [0x342b] = "\xb5\x6b",
  [0x342c] = "\xb5\x6c", [0x342d] = "\xb5\x6d", [0x342e] = "\xb5\x6e",
  [0x342f] = "\xb5\x6f", [0x3430] = "\xb5\x70", [0x3431] = "\xb5\x71",
  [0x3432] = "\xb5\x72", [0x3433] = "\xb5\x73", [0x3434] = "\xb5\x74",
  [0x3435] = "\xb5\x75", [0x3436] = "\xb5\x76", [0x3437] = "\xb5\x77",
  [0x3438] = "\xb5\x78", [0x3439] = "\xb5\x79", [0x343a] = "\xb5\x7a",
  [0x343b] = "\xb5\x7b", [0x343c] = "\xb5\x7c", [0x343d] = "\xb5\x7d",
  [0x343e] = "\xb5\x7e", [0x3440] = "\xb5\x80", [0x3441] = "\xb5\x81",
  [0x3442] = "\xb5\x82", [0x3443] = "\xb5\x83", [0x3444] = "\xb5\x84",
  [0x3445] = "\xb5\x85", [0x3446] = "\xb5\x86", [0x3447] = "\xb5\x87",
  [0x3448] = "\xb5\x88", [0x3449] = "\xb5\x89", [0x344a] = "\xb5\x8a",
  [0x344b] = "\xb5\x8b", [0x344c] = "\xb5\x8c", [0x344d] = "\xb5\x8d",
  [0x344e] = "\xb5\x8e", [0x344f] = "\xb5\x8f", [0x3450] = "\xb5\x90",
  [0x3451] = "\xb5\x91", [0x3452] = "\xb5\x92", [0x3453] = "\xb5\x93",
  [0x3454] = "\xb5\x94", [0x3455] = "\xb5\x95", [0x3456] = "\xb5\x96",
  [0x3457] = "\xb5\x97", [0x3458] = "\xb5\x98", [0x3459] = "\xb5\x99",
  [0x345a] = "\xb5\x9a", [0x345b] = "\xb5\x9b", [0x345c] = "\xb5\x9c",
  [0x345d] = "\xb5\x9d", [0x345e] = "\xb5\x9e", [0x345f] = "\xb5\x9f",
  [0x3460] = "\xb5\xa0", [0x3461] = "\xb5\xa1", [0x3462] = "\xb5\xa2",
  [0x3463] = "\xb5\xa3", [0x3464] = "\xb5\xa4", [0x3465] = "\xb5\xa5",
  [0x3466] = "\xb5\xa6", [0x3467] = "\xb5\xa7", [0x3468] = "\xb5\xa8",
  [0x3469] = "\xb5\xa9", [0x346a] = "\xb5\xaa", [0x346b] = "\xb5\xab",
  [0x346c] = "\xb5\xac", [0x346d] = "\xb5\xad", [0x346e] = "\xb5\xae",
  [0x346f] = "\xb5\xaf", [0x3470] = "\xb5\xb0", [0x3471] = "\xb5\xb1",
  [0x3472] = "\xb5\xb2", [0x3473] = "\xb5\xb3", [0x3474] = "\xb5\xb4",
  [0x3475] = "\xb5\xb5", [0x3476] = "\xb5\xb6", [0x3477] = "\xb5\xb7",
  [0x3478] = "\xb5\xb8", [0x3479] = "\xb5\xb9", [0x347a] = "\xb5\xba",
  [0x347b] = "\xb5\xbb", [0x347c] = "\xb5\xbc", [0x347d] = "\xb5\xbd",
  [0x347e] = "\xb5\xbe", [0x347f] = "\xb5\xbf", [0x3480] = "\xb5\xc0",
  [0x3481] = "\xb5\xc1", [0x3482] = "\xb5\xc2", [0x3483] = "\xb5\xc3",
  [0x3484] = "\xb5\xc4", [0x3485] = "\xb5\xc5", [0x3486] = "\xb5\xc6",
  [0x3487] = "\xb5\xc7", [0x3488] = "\xb5\xc8", [0x3489] = "\xb5\xc9",
  [0x348a] = "\xb5\xca", [0x348b] = "\xb5\xcb", [0x348c] = "\xb5\xcc",
  [0x348d] = "\xb5\xcd", [0x348e] = "\xb5\xce", [0x348f] = "\xb5\xcf",
  [0x3490] = "\xb5\xd0", [0x3491] = "\xb5\xd1", [0x3492] = "\xb5\xd2",
  [0x3493] = "\xb5\xd3", [0x3494] = "\xb5\xd4", [0x3495] = "\xb5\xd5",
  [0x3496] = "\xb5\xd6", [0x3497] = "\xb5\xd7", [0x3498] = "\xb5\xd8",
  [0x3499] = "\xb5\xd9", [0x349a] = "\xb5\xda", [0x349b] = "\xb5\xdb",
  [0x349c] = "\xb5\xdc", [0x349d] = "\xb5\xdd", [0x349e] = "\xb5\xde",
  [0x349f] = "\xb5\xdf", [0x34a0] = "\xb5\xe0", [0x34a1] = "\xb5\xe1",
  [0x34a2] = "\xb5\xe2", [0x34a3] = "\xb5\xe3", [0x34a4] = "\xb5\xe4",
  [0x34a5] = "\xb5\xe5", [0x34a6] = "\xb5\xe6", [0x34a7] = "\xb5\xe7",
  [0x34a8] = "\xb5\xe8", [0x34a9] = "\xb5\xe9", [0x34aa] = "\xb5\xea",
  [0x34ab] = "\xb5\xeb", [0x34ac] = "\xb5\xec", [0x34ad] = "\xb5\xed",
  [0x34ae] = "\xb5\xee", [0x34af] = "\xb5\xef", [0x34b0] = "\xb5\xf0",
  [0x34b1] = "\xb5\xf1", [0x34b2] = "\xb5\xf2", [0x34b3] = "\xb5\xf3",
  [0x34b4] = "\xb5\xf4", [0x34b5] = "\xb5\xf5", [0x34b6] = "\xb5\xf6",
  [0x34b7] = "\xb5\xf7", [0x34b8] = "\xb5\xf8", [0x34b9] = "\xb5\xf9",
  [0x34ba] = "\xb5\xfa", [0x34bb] = "\xb5\xfb", [0x34bc] = "\xb5\xfc",
  [0x34bd] = "\xb5\xfd", [0x34be] = "\xb5\xfe", [0x3500] = "\xb6\x40",
  [0x3501] = "\xb6\x41", [0x3502] = "\xb6\x42", [0x3503] = "\xb6\x43",
  [0x3504] = "\xb6\x44", [0x3505] = "\xb6\x45", [0x3506] = "\xb6\x46",
  [0x3507] = "\xb6\x47", [0x3508] = "\xb6\x48", [0x3509] = "\xb6\x49",
  [0x350a] = "\xb6\x4a", [0x350b] = "\xb6\x4b", [0x350c] = "\xb6\x4c",
  [0x350d] = "\xb6\x4d", [0x350e] = "\xb6\x4e", [0x350f] = "\xb6\x4f",
  [0x3510] = "\xb6\x50", [0x3511] = "\xb6\x51", [0x3512] = "\xb6\x52",
  [0x3513] = "\xb6\x53", [0x3514] = "\xb6\x54", [0x3515] = "\xb6\x55",
  [0x3516] = "\xb6\x56", [0x3517] = "\xb6\x57", [0x3518] = "\xb6\x58",
  [0x3519] = "\xb6\x59", [0x351a] = "\xb6\x5a", [0x351b] = "\xb6\x5b",
  [0x351c] = "\xb6\x5c", [0x351d] = "\xb6\x5d", [0x351e] = "\xb6\x5e",
  [0x351f] = "\xb6\x5f", [0x3520] = "\xb6\x60", [0x3521] = "\xb6\x61",
  [0x3522] = "\xb6\x62", [0x3523] = "\xb6\x63", [0x3524] = "\xb6\x64",
  [0x3525] = "\xb6\x65", [0x3526] = "\xb6\x66", [0x3527] = "\xb6\x67",
  [0x3528] = "\xb6\x68", [0x3529] = "\xb6\x69", [0x352a] = "\xb6\x6a",
  [0x352b] = "\xb6\x6b", [0x352c] = "\xb6\x6c", [0x352d] = "\xb6\x6d",
  [0x352e] = "\xb6\x6e", [0x352f] = "\xb6\x6f", [0x3530] = "\xb6\x70",
  [0x3531] = "\xb6\x71", [0x3532] = "\xb6\x72", [0x3533] = "\xb6\x73",
  [0x3534] = "\xb6\x74", [0x3535] = "\xb6\x75", [0x3536] = "\xb6\x76",
  [0x3537] = "\xb6\x77", [0x3538] = "\xb6\x78", [0x3539] = "\xb6\x79",
  [0x353a] = "\xb6\x7a", [0x353b] = "\xb6\x7b", [0x353c] = "\xb6\x7c",
  [0x353d] = "\xb6\x7d", [0x353e] = "\xb6\x7e", [0x3540] = "\xb6\x80",
  [0x3541] = "\xb6\x81", [0x3542] = "\xb6\x82", [0x3543] = "\xb6\x83",
  [0x3544] = "\xb6\x84", [0x3545] = "\xb6\x85", [0x3546] = "\xb6\x86",
  [0x3547] = "\xb6\x87", [0x3548] = "\xb6\x88", [0x3549] = "\xb6\x89",
  [0x354a] = "\xb6\x8a", [0x354b] = "\xb6\x8b", [0x354c] = "\xb6\x8c",
  [0x354d] = "\xb6\x8d", [0x354e] = "\xb6\x8e", [0x354f] = "\xb6\x8f",
  [0x3550] = "\xb6\x90", [0x3551] = "\xb6\x91", [0x3552] = "\xb6\x92",
  [0x3553] = "\xb6\x93", [0x3554] = "\xb6\x94", [0x3555] = "\xb6\x95",
  [0x3556] = "\xb6\x96", [0x3557] = "\xb6\x97", [0x3558] = "\xb6\x98",
  [0x3559] = "\xb6\x99", [0x355a] = "\xb6\x9a", [0x355b] = "\xb6\x9b",
  [0x355c] = "\xb6\x9c", [0x355d] = "\xb6\x9d", [0x355e] = "\xb6\x9e",
  [0x355f] = "\xb6\x9f", [0x3560] = "\xb6\xa0", [0x3561] = "\xb6\xa1",
  [0x3562] = "\xb6\xa2", [0x3563] = "\xb6\xa3", [0x3564] = "\xb6\xa4",
  [0x3565] = "\xb6\xa5", [0x3566] = "\xb6\xa6", [0x3567] = "\xb6\xa7",
  [0x3568] = "\xb6\xa8", [0x3569] = "\xb6\xa9", [0x356a] = "\xb6\xaa",
  [0x356b] = "\xb6\xab", [0x356c] = "\xb6\xac", [0x356d] = "\xb6\xad",
  [0x356e] = "\xb6\xae", [0x356f] = "\xb6\xaf", [0x3570] = "\xb6\xb0",
  [0x3571] = "\xb6\xb1", [0x3572] = "\xb6\xb2", [0x3573] = "\xb6\xb3",
  [0x3574] = "\xb6\xb4", [0x3575] = "\xb6\xb5", [0x3576] = "\xb6\xb6",
  [0x3577] = "\xb6\xb7", [0x3578] = "\xb6\xb8", [0x3579] = "\xb6\xb9",
  [0x357a] = "\xb6\xba", [0x357b] = "\xb6\xbb", [0x357c] = "\xb6\xbc",
  [0x357d] = "\xb6\xbd", [0x357e] = "\xb6\xbe", [0x357f] = "\xb6\xbf",
  [0x3580] = "\xb6\xc0", [0x3581] = "\xb6\xc1", [0x3582] = "\xb6\xc2",
  [0x3583] = "\xb6\xc3", [0x3584] = "\xb6\xc4", [0x3585] = "\xb6\xc5",
  [0x3586] = "\xb6\xc6", [0x3587] = "\xb6\xc7", [0x3588] = "\xb6\xc8",
  [0x3589] = "\xb6\xc9", [0x358a] = "\xb6\xca", [0x358b] = "\xb6\xcb",
  [0x358c] = "\xb6\xcc", [0x358d] = "\xb6\xcd", [0x358e] = "\xb6\xce",
  [0x358f] = "\xb6\xcf", [0x3590] = "\xb6\xd0", [0x3591] = "\xb6\xd1",
  [0x3592] = "\xb6\xd2", [0x3593] = "\xb6\xd3", [0x3594] = "\xb6\xd4",
  [0x3595] = "\xb6\xd5", [0x3596] = "\xb6\xd6", [0x3597] = "\xb6\xd7",
  [0x3598] = "\xb6\xd8", [0x3599] = "\xb6\xd9", [0x359a] = "\xb6\xda",
  [0x359b] = "\xb6\xdb", [0x359c] = "\xb6\xdc", [0x359d] = "\xb6\xdd",
  [0x359e] = "\xb6\xde", [0x359f] = "\xb6\xdf", [0x35a0] = "\xb6\xe0",
  [0x35a1] = "\xb6\xe1", [0x35a2] = "\xb6\xe2", [0x35a3] = "\xb6\xe3",
  [0x35a4] = "\xb6\xe4", [0x35a5] = "\xb6\xe5", [0x35a6] = "\xb6\xe6",
  [0x35a7] = "\xb6\xe7", [0x35a8] = "\xb6\xe8", [0x35a9] = "\xb6\xe9",
  [0x35aa] = "\xb6\xea", [0x35ab] = "\xb6\xeb", [0x35ac] = "\xb6\xec",
  [0x35ad] = "\xb6\xed", [0x35ae] = "\xb6\xee", [0x35af] = "\xb6\xef",
  [0x35b0] = "\xb6\xf0", [0x35b1] = "\xb6\xf1", [0x35b2] = "\xb6\xf2",
  [0x35b3] = "\xb6\xf3", [0x35b4] = "\xb6\xf4", [0x35b5] = "\xb6\xf5",
  [0x35b6] = "\xb6\xf6", [0x35b7] = "\xb6\xf7", [0x35b8] = "\xb6\xf8",
  [0x35b9] = "\xb6\xf9", [0x35ba] = "\xb6\xfa", [0x35bb] = "\xb6\xfb",
  [0x35bc] = "\xb6\xfc", [0x35bd] = "\xb6\xfd", [0x35be] = "\xb6\xfe",
  [0x3600] = "\xb7\x40", [0x3601] = "\xb7\x41", [0x3602] = "\xb7\x42",
  [0x3603] = "\xb7\x43", [0x3604] = "\xb7\x44", [0x3605] = "\xb7\x45",
  [0x3606] = "\xb7\x46", [0x3607] = "\xb7\x47", [0x3608] = "\xb7\x48",
  [0x3609] = "\xb7\x49", [0x360a] = "\xb7\x4a", [0x360b] = "\xb7\x4b",
  [0x360c] = "\xb7\x4c", [0x360d] = "\xb7\x4d", [0x360e] = "\xb7\x4e",
  [0x360f] = "\xb7\x4f", [0x3610] = "\xb7\x50", [0x3611] = "\xb7\x51",
  [0x3612] = "\xb7\x52", [0x3613] = "\xb7\x53", [0x3614] = "\xb7\x54",
  [0x3615] = "\xb7\x55", [0x3616] = "\xb7\x56", [0x3617] = "\xb7\x57",
  [0x3618] = "\xb7\x58", [0x3619] = "\xb7\x59", [0x361a] = "\xb7\x5a",
  [0x361b] = "\xb7\x5b", [0x361c] = "\xb7\x5c", [0x361d] = "\xb7\x5d",
  [0x361e] = "\xb7\x5e", [0x361f] = "\xb7\x5f", [0x3620] = "\xb7\x60",
  [0x3621] = "\xb7\x61", [0x3622] = "\xb7\x62", [0x3623] = "\xb7\x63",
  [0x3624] = "\xb7\x64", [0x3625] = "\xb7\x65", [0x3626] = "\xb7\x66",
  [0x3627] = "\xb7\x67", [0x3628] = "\xb7\x68", [0x3629] = "\xb7\x69",
  [0x362a] = "\xb7\x6a", [0x362b] = "\xb7\x6b", [0x362c] = "\xb7\x6c",
  [0x362d] = "\xb7\x6d", [0x362e] = "\xb7\x6e", [0x362f] = "\xb7\x6f",
  [0x3630] = "\xb7\x70", [0x3631] = "\xb7\x71", [0x3632] = "\xb7\x72",
  [0x3633] = "\xb7\x73", [0x3634] = "\xb7\x74", [0x3635] = "\xb7\x75",
  [0x3636] = "\xb7\x76", [0x3637] = "\xb7\x77", [0x3638] = "\xb7\x78",
  [0x3639] = "\xb7\x79", [0x363a] = "\xb7\x7a", [0x363b] = "\xb7\x7b",
  [0x363c] = "\xb7\x7c", [0x363d] = "\xb7\x7d", [0x363e] = "\xb7\x7e",
  [0x3640] = "\xb7\x80", [0x3641] = "\xb7\x81", [0x3642] = "\xb7\x82",
  [0x3643] = "\xb7\x83", [0x3644] = "\xb7\x84", [0x3645] = "\xb7\x85",
  [0x3646] = "\xb7\x86", [0x3647] = "\xb7\x87", [0x3648] = "\xb7\x88",
  [0x3649] = "\xb7\x89", [0x364a] = "\xb7\x8a", [0x364b] = "\xb7\x8b",
  [0x364c] = "\xb7\x8c", [0x364d] = "\xb7\x8d", [0x364e] = "\xb7\x8e",
  [0x364f] = "\xb7\x8f", [0x3650] = "\xb7\x90", [0x3651] = "\xb7\x91",
  [0x3652] = "\xb7\x92", [0x3653] = "\xb7\x93", [0x3654] = "\xb7\x94",
  [0x3655] = "\xb7\x95", [0x3656] = "\xb7\x96", [0x3657] = "\xb7\x97",
  [0x3658] = "\xb7\x98", [0x3659] = "\xb7\x99", [0x365a] = "\xb7\x9a",
  [0x365b] = "\xb7\x9b", [0x365c] = "\xb7\x9c", [0x365d] = "\xb7\x9d",
  [0x365e] = "\xb7\x9e", [0x365f] = "\xb7\x9f", [0x3660] = "\xb7\xa0",
  [0x3661] = "\xb7\xa1", [0x3662] = "\xb7\xa2", [0x3663] = "\xb7\xa3",
  [0x3664] = "\xb7\xa4", [0x3665] = "\xb7\xa5", [0x3666] = "\xb7\xa6",
  [0x3667] = "\xb7\xa7", [0x3668] = "\xb7\xa8", [0x3669] = "\xb7\xa9",
  [0x366a] = "\xb7\xaa", [0x366b] = "\xb7\xab", [0x366c] = "\xb7\xac",
  [0x366d] = "\xb7\xad", [0x366e] = "\xb7\xae", [0x366f] = "\xb7\xaf",
  [0x3670] = "\xb7\xb0", [0x3671] = "\xb7\xb1", [0x3672] = "\xb7\xb2",
  [0x3673] = "\xb7\xb3", [0x3674] = "\xb7\xb4", [0x3675] = "\xb7\xb5",
  [0x3676] = "\xb7\xb6", [0x3677] = "\xb7\xb7", [0x3678] = "\xb7\xb8",
  [0x3679] = "\xb7\xb9", [0x367a] = "\xb7\xba", [0x367b] = "\xb7\xbb",
  [0x367c] = "\xb7\xbc", [0x367d] = "\xb7\xbd", [0x367e] = "\xb7\xbe",
  [0x367f] = "\xb7\xbf", [0x3680] = "\xb7\xc0", [0x3681] = "\xb7\xc1",
  [0x3682] = "\xb7\xc2", [0x3683] = "\xb7\xc3", [0x3684] = "\xb7\xc4",
  [0x3685] = "\xb7\xc5", [0x3686] = "\xb7\xc6", [0x3687] = "\xb7\xc7",
  [0x3688] = "\xb7\xc8", [0x3689] = "\xb7\xc9", [0x368a] = "\xb7\xca",
  [0x368b] = "\xb7\xcb", [0x368c] = "\xb7\xcc", [0x368d] = "\xb7\xcd",
  [0x368e] = "\xb7\xce", [0x368f] = "\xb7\xcf", [0x3690] = "\xb7\xd0",
  [0x3691] = "\xb7\xd1", [0x3692] = "\xb7\xd2", [0x3693] = "\xb7\xd3",
  [0x3694] = "\xb7\xd4", [0x3695] = "\xb7\xd5", [0x3696] = "\xb7\xd6",
  [0x3697] = "\xb7\xd7", [0x3698] = "\xb7\xd8", [0x3699] = "\xb7\xd9",
  [0x369a] = "\xb7\xda", [0x369b] = "\xb7\xdb", [0x369c] = "\xb7\xdc",
  [0x369d] = "\xb7\xdd", [0x369e] = "\xb7\xde", [0x369f] = "\xb7\xdf",
  [0x36a0] = "\xb7\xe0", [0x36a1] = "\xb7\xe1", [0x36a2] = "\xb7\xe2",
  [0x36a3] = "\xb7\xe3", [0x36a4] = "\xb7\xe4", [0x36a5] = "\xb7\xe5",
  [0x36a6] = "\xb7\xe6", [0x36a7] = "\xb7\xe7", [0x36a8] = "\xb7\xe8",
  [0x36a9] = "\xb7\xe9", [0x36aa] = "\xb7\xea", [0x36ab] = "\xb7\xeb",
  [0x36ac] = "\xb7\xec", [0x36ad] = "\xb7\xed", [0x36ae] = "\xb7\xee",
  [0x36af] = "\xb7\xef", [0x36b0] = "\xb7\xf0", [0x36b1] = "\xb7\xf1",
  [0x36b2] = "\xb7\xf2", [0x36b3] = "\xb7\xf3", [0x36b4] = "\xb7\xf4",
  [0x36b5] = "\xb7\xf5", [0x36b6] = "\xb7\xf6", [0x36b7] = "\xb7\xf7",
  [0x36b8] = "\xb7\xf8", [0x36b9] = "\xb7\xf9", [0x36ba] = "\xb7\xfa",
  [0x36bb] = "\xb7\xfb", [0x36bc] = "\xb7\xfc", [0x36bd] = "\xb7\xfd",
  [0x36be] = "\xb7\xfe", [0x3700] = "\xb8\x40", [0x3701] = "\xb8\x41",
  [0x3702] = "\xb8\x42", [0x3703] = "\xb8\x43", [0x3704] = "\xb8\x44",
  [0x3705] = "\xb8\x45", [0x3706] = "\xb8\x46", [0x3707] = "\xb8\x47",
  [0x3708] = "\xb8\x48", [0x3709] = "\xb8\x49", [0x370a] = "\xb8\x4a",
  [0x370b] = "\xb8\x4b", [0x370c] = "\xb8\x4c", [0x370d] = "\xb8\x4d",
  [0x370e] = "\xb8\x4e", [0x370f] = "\xb8\x4f", [0x3710] = "\xb8\x50",
  [0x3711] = "\xb8\x51", [0x3712] = "\xb8\x52", [0x3713] = "\xb8\x53",
  [0x3714] = "\xb8\x54", [0x3715] = "\xb8\x55", [0x3716] = "\xb8\x56",
  [0x3717] = "\xb8\x57", [0x3718] = "\xb8\x58", [0x3719] = "\xb8\x59",
  [0x371a] = "\xb8\x5a", [0x371b] = "\xb8\x5b", [0x371c] = "\xb8\x5c",
  [0x371d] = "\xb8\x5d", [0x371e] = "\xb8\x5e", [0x371f] = "\xb8\x5f",
  [0x3720] = "\xb8\x60", [0x3721] = "\xb8\x61", [0x3722] = "\xb8\x62",
  [0x3723] = "\xb8\x63", [0x3724] = "\xb8\x64", [0x3725] = "\xb8\x65",
  [0x3726] = "\xb8\x66", [0x3727] = "\xb8\x67", [0x3728] = "\xb8\x68",
  [0x3729] = "\xb8\x69", [0x372a] = "\xb8\x6a", [0x372b] = "\xb8\x6b",
  [0x372c] = "\xb8\x6c", [0x372d] = "\xb8\x6d", [0x372e] = "\xb8\x6e",
  [0x372f] = "\xb8\x6f", [0x3730] = "\xb8\x70", [0x3731] = "\xb8\x71",
  [0x3732] = "\xb8\x72", [0x3733] = "\xb8\x73", [0x3734] = "\xb8\x74",
  [0x3735] = "\xb8\x75", [0x3736] = "\xb8\x76", [0x3737] = "\xb8\x77",
  [0x3738] = "\xb8\x78", [0x3739] = "\xb8\x79", [0x373a] = "\xb8\x7a",
  [0x373b] = "\xb8\x7b", [0x373c] = "\xb8\x7c", [0x373d] = "\xb8\x7d",
  [0x373e] = "\xb8\x7e", [0x3740] = "\xb8\x80", [0x3741] = "\xb8\x81",
  [0x3742] = "\xb8\x82", [0x3743] = "\xb8\x83", [0x3744] = "\xb8\x84",
  [0x3745] = "\xb8\x85", [0x3746] = "\xb8\x86", [0x3747] = "\xb8\x87",
  [0x3748] = "\xb8\x88", [0x3749] = "\xb8\x89", [0x374a] = "\xb8\x8a",
  [0x374b] = "\xb8\x8b", [0x374c] = "\xb8\x8c", [0x374d] = "\xb8\x8d",
  [0x374e] = "\xb8\x8e", [0x374f] = "\xb8\x8f", [0x3750] = "\xb8\x90",
  [0x3751] = "\xb8\x91", [0x3752] = "\xb8\x92", [0x3753] = "\xb8\x93",
  [0x3754] = "\xb8\x94", [0x3755] = "\xb8\x95", [0x3756] = "\xb8\x96",
  [0x3757] = "\xb8\x97", [0x3758] = "\xb8\x98", [0x3759] = "\xb8\x99",
  [0x375a] = "\xb8\x9a", [0x375b] = "\xb8\x9b", [0x375c] = "\xb8\x9c",
  [0x375d] = "\xb8\x9d", [0x375e] = "\xb8\x9e", [0x375f] = "\xb8\x9f",
  [0x3760] = "\xb8\xa0", [0x3761] = "\xb8\xa1", [0x3762] = "\xb8\xa2",
  [0x3763] = "\xb8\xa3", [0x3764] = "\xb8\xa4", [0x3765] = "\xb8\xa5",
  [0x3766] = "\xb8\xa6", [0x3767] = "\xb8\xa7", [0x3768] = "\xb8\xa8",
  [0x3769] = "\xb8\xa9", [0x376a] = "\xb8\xaa", [0x376b] = "\xb8\xab",
  [0x376c] = "\xb8\xac", [0x376d] = "\xb8\xad", [0x376e] = "\xb8\xae",
  [0x376f] = "\xb8\xaf", [0x3770] = "\xb8\xb0", [0x3771] = "\xb8\xb1",
  [0x3772] = "\xb8\xb2", [0x3773] = "\xb8\xb3", [0x3774] = "\xb8\xb4",
  [0x3775] = "\xb8\xb5", [0x3776] = "\xb8\xb6", [0x3777] = "\xb8\xb7",
  [0x3778] = "\xb8\xb8", [0x3779] = "\xb8\xb9", [0x377a] = "\xb8\xba",
  [0x377b] = "\xb8\xbb", [0x377c] = "\xb8\xbc", [0x377d] = "\xb8\xbd",
  [0x377e] = "\xb8\xbe", [0x377f] = "\xb8\xbf", [0x3780] = "\xb8\xc0",
  [0x3781] = "\xb8\xc1", [0x3782] = "\xb8\xc2", [0x3783] = "\xb8\xc3",
  [0x3784] = "\xb8\xc4", [0x3785] = "\xb8\xc5", [0x3786] = "\xb8\xc6",
  [0x3787] = "\xb8\xc7", [0x3788] = "\xb8\xc8", [0x3789] = "\xb8\xc9",
  [0x378a] = "\xb8\xca", [0x378b] = "\xb8\xcb", [0x378c] = "\xb8\xcc",
  [0x378d] = "\xb8\xcd", [0x378e] = "\xb8\xce", [0x378f] = "\xb8\xcf",
  [0x3790] = "\xb8\xd0", [0x3791] = "\xb8\xd1", [0x3792] = "\xb8\xd2",
  [0x3793] = "\xb8\xd3", [0x3794] = "\xb8\xd4", [0x3795] = "\xb8\xd5",
  [0x3796] = "\xb8\xd6", [0x3797] = "\xb8\xd7", [0x3798] = "\xb8\xd8",
  [0x3799] = "\xb8\xd9", [0x379a] = "\xb8\xda", [0x379b] = "\xb8\xdb",
  [0x379c] = "\xb8\xdc", [0x379d] = "\xb8\xdd", [0x379e] = "\xb8\xde",
  [0x379f] = "\xb8\xdf", [0x37a0] = "\xb8\xe0", [0x37a1] = "\xb8\xe1",
  [0x37a2] = "\xb8\xe2", [0x37a3] = "\xb8\xe3", [0x37a4] = "\xb8\xe4",
  [0x37a5] = "\xb8\xe5", [0x37a6] = "\xb8\xe6", [0x37a7] = "\xb8\xe7",
  [0x37a8] = "\xb8\xe8", [0x37a9] = "\xb8\xe9", [0x37aa] = "\xb8\xea",
  [0x37ab] = "\xb8\xeb", [0x37ac] = "\xb8\xec", [0x37ad] = "\xb8\xed",
  [0x37ae] = "\xb8\xee", [0x37af] = "\xb8\xef", [0x37b0] = "\xb8\xf0",
  [0x37b1] = "\xb8\xf1", [0x37b2] = "\xb8\xf2", [0x37b3] = "\xb8\xf3",
  [0x37b4] = "\xb8\xf4", [0x37b5] = "\xb8\xf5", [0x37b6] = "\xb8\xf6",
  [0x37b7] = "\xb8\xf7", [0x37b8] = "\xb8\xf8", [0x37b9] = "\xb8\xf9",
  [0x37ba] = "\xb8\xfa", [0x37bb] = "\xb8\xfb", [0x37bc] = "\xb8\xfc",
  [0x37bd] = "\xb8\xfd", [0x37be] = "\xb8\xfe", [0x3800] = "\xb9\x40",
  [0x3801] = "\xb9\x41", [0x3802] = "\xb9\x42", [0x3803] = "\xb9\x43",
  [0x3804] = "\xb9\x44", [0x3805] = "\xb9\x45", [0x3806] = "\xb9\x46",
  [0x3807] = "\xb9\x47", [0x3808] = "\xb9\x48", [0x3809] = "\xb9\x49",
  [0x380a] = "\xb9\x4a", [0x380b] = "\xb9\x4b", [0x380c] = "\xb9\x4c",
  [0x380d] = "\xb9\x4d", [0x380e] = "\xb9\x4e", [0x380f] = "\xb9\x4f",
  [0x3810] = "\xb9\x50", [0x3811] = "\xb9\x51", [0x3812] = "\xb9\x52",
  [0x3813] = "\xb9\x53", [0x3814] = "\xb9\x54", [0x3815] = "\xb9\x55",
  [0x3816] = "\xb9\x56", [0x3817] = "\xb9\x57", [0x3818] = "\xb9\x58",
  [0x3819] = "\xb9\x59", [0x381a] = "\xb9\x5a", [0x381b] = "\xb9\x5b",
  [0x381c] = "\xb9\x5c", [0x381d] = "\xb9\x5d", [0x381e] = "\xb9\x5e",
  [0x381f] = "\xb9\x5f", [0x3820] = "\xb9\x60", [0x3821] = "\xb9\x61",
  [0x3822] = "\xb9\x62", [0x3823] = "\xb9\x63", [0x3824] = "\xb9\x64",
  [0x3825] = "\xb9\x65", [0x3826] = "\xb9\x66", [0x3827] = "\xb9\x67",
  [0x3828] = "\xb9\x68", [0x3829] = "\xb9\x69", [0x382a] = "\xb9\x6a",
  [0x382b] = "\xb9\x6b", [0x382c] = "\xb9\x6c", [0x382d] = "\xb9\x6d",
  [0x382e] = "\xb9\x6e", [0x382f] = "\xb9\x6f", [0x3830] = "\xb9\x70",
  [0x3831] = "\xb9\x71", [0x3832] = "\xb9\x72", [0x3833] = "\xb9\x73",
  [0x3834] = "\xb9\x74", [0x3835] = "\xb9\x75", [0x3836] = "\xb9\x76",
  [0x3837] = "\xb9\x77", [0x3838] = "\xb9\x78", [0x3839] = "\xb9\x79",
  [0x383a] = "\xb9\x7a", [0x383b] = "\xb9\x7b", [0x383c] = "\xb9\x7c",
  [0x383d] = "\xb9\x7d", [0x383e] = "\xb9\x7e", [0x3840] = "\xb9\x80",
  [0x3841] = "\xb9\x81", [0x3842] = "\xb9\x82", [0x3843] = "\xb9\x83",
  [0x3844] = "\xb9\x84", [0x3845] = "\xb9\x85", [0x3846] = "\xb9\x86",
  [0x3847] = "\xb9\x87", [0x3848] = "\xb9\x88", [0x3849] = "\xb9\x89",
  [0x384a] = "\xb9\x8a", [0x384b] = "\xb9\x8b", [0x384c] = "\xb9\x8c",
  [0x384d] = "\xb9\x8d", [0x384e] = "\xb9\x8e", [0x384f] = "\xb9\x8f",
  [0x3850] = "\xb9\x90", [0x3851] = "\xb9\x91", [0x3852] = "\xb9\x92",
  [0x3853] = "\xb9\x93", [0x3854] = "\xb9\x94", [0x3855] = "\xb9\x95",
  [0x3856] = "\xb9\x96", [0x3857] = "\xb9\x97", [0x3858] = "\xb9\x98",
  [0x3859] = "\xb9\x99", [0x385a] = "\xb9\x9a", [0x385b] = "\xb9\x9b",
  [0x385c] = "\xb9\x9c", [0x385d] = "\xb9\x9d", [0x385e] = "\xb9\x9e",
  [0x385f] = "\xb9\x9f", [0x3860] = "\xb9\xa0", [0x3861] = "\xb9\xa1",
  [0x3862] = "\xb9\xa2", [0x3863] = "\xb9\xa3", [0x3864] = "\xb9\xa4",
  [0x3865] = "\xb9\xa5", [0x3866] = "\xb9\xa6", [0x3867] = "\xb9\xa7",
  [0x3868] = "\xb9\xa8", [0x3869] = "\xb9\xa9", [0x386a] = "\xb9\xaa",
  [0x386b] = "\xb9\xab", [0x386c] = "\xb9\xac", [0x386d] = "\xb9\xad",
  [0x386e] = "\xb9\xae", [0x386f] = "\xb9\xaf", [0x3870] = "\xb9\xb0",
  [0x3871] = "\xb9\xb1", [0x3872] = "\xb9\xb2", [0x3873] = "\xb9\xb3",
  [0x3874] = "\xb9\xb4", [0x3875] = "\xb9\xb5", [0x3876] = "\xb9\xb6",
  [0x3877] = "\xb9\xb7", [0x3878] = "\xb9\xb8", [0x3879] = "\xb9\xb9",
  [0x387a] = "\xb9\xba", [0x387b] = "\xb9\xbb", [0x387c] = "\xb9\xbc",
  [0x387d] = "\xb9\xbd", [0x387e] = "\xb9\xbe", [0x387f] = "\xb9\xbf",
  [0x3880] = "\xb9\xc0", [0x3881] = "\xb9\xc1", [0x3882] = "\xb9\xc2",
  [0x3883] = "\xb9\xc3", [0x3884] = "\xb9\xc4", [0x3885] = "\xb9\xc5",
  [0x3886] = "\xb9\xc6", [0x3887] = "\xb9\xc7", [0x3888] = "\xb9\xc8",
  [0x3889] = "\xb9\xc9", [0x388a] = "\xb9\xca", [0x388b] = "\xb9\xcb",
  [0x388c] = "\xb9\xcc", [0x388d] = "\xb9\xcd", [0x388e] = "\xb9\xce",
  [0x388f] = "\xb9\xcf", [0x3890] = "\xb9\xd0", [0x3891] = "\xb9\xd1",
  [0x3892] = "\xb9\xd2", [0x3893] = "\xb9\xd3", [0x3894] = "\xb9\xd4",
  [0x3895] = "\xb9\xd5", [0x3896] = "\xb9\xd6", [0x3897] = "\xb9\xd7",
  [0x3898] = "\xb9\xd8", [0x3899] = "\xb9\xd9", [0x389a] = "\xb9\xda",
  [0x389b] = "\xb9\xdb", [0x389c] = "\xb9\xdc", [0x389d] = "\xb9\xdd",
  [0x389e] = "\xb9\xde", [0x389f] = "\xb9\xdf", [0x38a0] = "\xb9\xe0",
  [0x38a1] = "\xb9\xe1", [0x38a2] = "\xb9\xe2", [0x38a3] = "\xb9\xe3",
  [0x38a4] = "\xb9\xe4", [0x38a5] = "\xb9\xe5", [0x38a6] = "\xb9\xe6",
  [0x38a7] = "\xb9\xe7", [0x38a8] = "\xb9\xe8", [0x38a9] = "\xb9\xe9",
  [0x38aa] = "\xb9\xea", [0x38ab] = "\xb9\xeb", [0x38ac] = "\xb9\xec",
  [0x38ad] = "\xb9\xed", [0x38ae] = "\xb9\xee", [0x38af] = "\xb9\xef",
  [0x38b0] = "\xb9\xf0", [0x38b1] = "\xb9\xf1", [0x38b2] = "\xb9\xf2",
  [0x38b3] = "\xb9\xf3", [0x38b4] = "\xb9\xf4", [0x38b5] = "\xb9\xf5",
  [0x38b6] = "\xb9\xf6", [0x38b7] = "\xb9\xf7", [0x38b8] = "\xb9\xf8",
  [0x38b9] = "\xb9\xf9", [0x38ba] = "\xb9\xfa", [0x38bb] = "\xb9\xfb",
  [0x38bc] = "\xb9\xfc", [0x38bd] = "\xb9\xfd", [0x38be] = "\xb9\xfe",
  [0x3900] = "\xba\x40", [0x3901] = "\xba\x41", [0x3902] = "\xba\x42",
  [0x3903] = "\xba\x43", [0x3904] = "\xba\x44", [0x3905] = "\xba\x45",
  [0x3906] = "\xba\x46", [0x3907] = "\xba\x47", [0x3908] = "\xba\x48",
  [0x3909] = "\xba\x49", [0x390a] = "\xba\x4a", [0x390b] = "\xba\x4b",
  [0x390c] = "\xba\x4c", [0x390d] = "\xba\x4d", [0x390e] = "\xba\x4e",
  [0x390f] = "\xba\x4f", [0x3910] = "\xba\x50", [0x3911] = "\xba\x51",
  [0x3912] = "\xba\x52", [0x3913] = "\xba\x53", [0x3914] = "\xba\x54",
  [0x3915] = "\xba\x55", [0x3916] = "\xba\x56", [0x3917] = "\xba\x57",
  [0x3918] = "\xba\x58", [0x3919] = "\xba\x59", [0x391a] = "\xba\x5a",
  [0x391b] = "\xba\x5b", [0x391c] = "\xba\x5c", [0x391d] = "\xba\x5d",
  [0x391e] = "\xba\x5e", [0x391f] = "\xba\x5f", [0x3920] = "\xba\x60",
  [0x3921] = "\xba\x61", [0x3922] = "\xba\x62", [0x3923] = "\xba\x63",
  [0x3924] = "\xba\x64", [0x3925] = "\xba\x65", [0x3926] = "\xba\x66",
  [0x3927] = "\xba\x67", [0x3928] = "\xba\x68", [0x3929] = "\xba\x69",
  [0x392a] = "\xba\x6a", [0x392b] = "\xba\x6b", [0x392c] = "\xba\x6c",
  [0x392d] = "\xba\x6d", [0x392e] = "\xba\x6e", [0x392f] = "\xba\x6f",
  [0x3930] = "\xba\x70", [0x3931] = "\xba\x71", [0x3932] = "\xba\x72",
  [0x3933] = "\xba\x73", [0x3934] = "\xba\x74", [0x3935] = "\xba\x75",
  [0x3936] = "\xba\x76", [0x3937] = "\xba\x77", [0x3938] = "\xba\x78",
  [0x3939] = "\xba\x79", [0x393a] = "\xba\x7a", [0x393b] = "\xba\x7b",
  [0x393c] = "\xba\x7c", [0x393d] = "\xba\x7d", [0x393e] = "\xba\x7e",
  [0x3940] = "\xba\x80", [0x3941] = "\xba\x81", [0x3942] = "\xba\x82",
  [0x3943] = "\xba\x83", [0x3944] = "\xba\x84", [0x3945] = "\xba\x85",
  [0x3946] = "\xba\x86", [0x3947] = "\xba\x87", [0x3948] = "\xba\x88",
  [0x3949] = "\xba\x89", [0x394a] = "\xba\x8a", [0x394b] = "\xba\x8b",
  [0x394c] = "\xba\x8c", [0x394d] = "\xba\x8d", [0x394e] = "\xba\x8e",
  [0x394f] = "\xba\x8f", [0x3950] = "\xba\x90", [0x3951] = "\xba\x91",
  [0x3952] = "\xba\x92", [0x3953] = "\xba\x93", [0x3954] = "\xba\x94",
  [0x3955] = "\xba\x95", [0x3956] = "\xba\x96", [0x3957] = "\xba\x97",
  [0x3958] = "\xba\x98", [0x3959] = "\xba\x99", [0x395a] = "\xba\x9a",
  [0x395b] = "\xba\x9b", [0x395c] = "\xba\x9c", [0x395d] = "\xba\x9d",
  [0x395e] = "\xba\x9e", [0x395f] = "\xba\x9f", [0x3960] = "\xba\xa0",
  [0x3961] = "\xba\xa1", [0x3962] = "\xba\xa2", [0x3963] = "\xba\xa3",
  [0x3964] = "\xba\xa4", [0x3965] = "\xba\xa5", [0x3966] = "\xba\xa6",
  [0x3967] = "\xba\xa7", [0x3968] = "\xba\xa8", [0x3969] = "\xba\xa9",
  [0x396a] = "\xba\xaa", [0x396b] = "\xba\xab", [0x396c] = "\xba\xac",
  [0x396d] = "\xba\xad", [0x396e] = "\xba\xae", [0x396f] = "\xba\xaf",
  [0x3970] = "\xba\xb0", [0x3971] = "\xba\xb1", [0x3972] = "\xba\xb2",
  [0x3973] = "\xba\xb3", [0x3974] = "\xba\xb4", [0x3975] = "\xba\xb5",
  [0x3976] = "\xba\xb6", [0x3977] = "\xba\xb7", [0x3978] = "\xba\xb8",
  [0x3979] = "\xba\xb9", [0x397a] = "\xba\xba", [0x397b] = "\xba\xbb",
  [0x397c] = "\xba\xbc", [0x397d] = "\xba\xbd", [0x397e] = "\xba\xbe",
  [0x397f] = "\xba\xbf", [0x3980] = "\xba\xc0", [0x3981] = "\xba\xc1",
  [0x3982] = "\xba\xc2", [0x3983] = "\xba\xc3", [0x3984] = "\xba\xc4",
  [0x3985] = "\xba\xc5", [0x3986] = "\xba\xc6", [0x3987] = "\xba\xc7",
  [0x3988] = "\xba\xc8", [0x3989] = "\xba\xc9", [0x398a] = "\xba\xca",
  [0x398b] = "\xba\xcb", [0x398c] = "\xba\xcc", [0x398d] = "\xba\xcd",
  [0x398e] = "\xba\xce", [0x398f] = "\xba\xcf", [0x3990] = "\xba\xd0",
  [0x3991] = "\xba\xd1", [0x3992] = "\xba\xd2", [0x3993] = "\xba\xd3",
  [0x3994] = "\xba\xd4", [0x3995] = "\xba\xd5", [0x3996] = "\xba\xd6",
  [0x3997] = "\xba\xd7", [0x3998] = "\xba\xd8", [0x3999] = "\xba\xd9",
  [0x399a] = "\xba\xda", [0x399b] = "\xba\xdb", [0x399c] = "\xba\xdc",
  [0x399d] = "\xba\xdd", [0x399e] = "\xba\xde", [0x399f] = "\xba\xdf",
  [0x39a0] = "\xba\xe0", [0x39a1] = "\xba\xe1", [0x39a2] = "\xba\xe2",
  [0x39a3] = "\xba\xe3", [0x39a4] = "\xba\xe4", [0x39a5] = "\xba\xe5",
  [0x39a6] = "\xba\xe6", [0x39a7] = "\xba\xe7", [0x39a8] = "\xba\xe8",
  [0x39a9] = "\xba\xe9", [0x39aa] = "\xba\xea", [0x39ab] = "\xba\xeb",
  [0x39ac] = "\xba\xec", [0x39ad] = "\xba\xed", [0x39ae] = "\xba\xee",
  [0x39af] = "\xba\xef", [0x39b0] = "\xba\xf0", [0x39b1] = "\xba\xf1",
  [0x39b2] = "\xba\xf2", [0x39b3] = "\xba\xf3", [0x39b4] = "\xba\xf4",
  [0x39b5] = "\xba\xf5", [0x39b6] = "\xba\xf6", [0x39b7] = "\xba\xf7",
  [0x39b8] = "\xba\xf8", [0x39b9] = "\xba\xf9", [0x39ba] = "\xba\xfa",
  [0x39bb] = "\xba\xfb", [0x39bc] = "\xba\xfc", [0x39bd] = "\xba\xfd",
  [0x39be] = "\xba\xfe", [0x3a00] = "\xbb\x40", [0x3a01] = "\xbb\x41",
  [0x3a02] = "\xbb\x42", [0x3a03] = "\xbb\x43", [0x3a04] = "\xbb\x44",
  [0x3a05] = "\xbb\x45", [0x3a06] = "\xbb\x46", [0x3a07] = "\xbb\x47",
  [0x3a08] = "\xbb\x48", [0x3a09] = "\xbb\x49", [0x3a0a] = "\xbb\x4a",
  [0x3a0b] = "\xbb\x4b", [0x3a0c] = "\xbb\x4c", [0x3a0d] = "\xbb\x4d",
  [0x3a0e] = "\xbb\x4e", [0x3a0f] = "\xbb\x4f", [0x3a10] = "\xbb\x50",
  [0x3a11] = "\xbb\x51", [0x3a12] = "\xbb\x52", [0x3a13] = "\xbb\x53",
  [0x3a14] = "\xbb\x54", [0x3a15] = "\xbb\x55", [0x3a16] = "\xbb\x56",
  [0x3a17] = "\xbb\x57", [0x3a18] = "\xbb\x58", [0x3a19] = "\xbb\x59",
  [0x3a1a] = "\xbb\x5a", [0x3a1b] = "\xbb\x5b", [0x3a1c] = "\xbb\x5c",
  [0x3a1d] = "\xbb\x5d", [0x3a1e] = "\xbb\x5e", [0x3a1f] = "\xbb\x5f",
  [0x3a20] = "\xbb\x60", [0x3a21] = "\xbb\x61", [0x3a22] = "\xbb\x62",
  [0x3a23] = "\xbb\x63", [0x3a24] = "\xbb\x64", [0x3a25] = "\xbb\x65",
  [0x3a26] = "\xbb\x66", [0x3a27] = "\xbb\x67", [0x3a28] = "\xbb\x68",
  [0x3a29] = "\xbb\x69", [0x3a2a] = "\xbb\x6a", [0x3a2b] = "\xbb\x6b",
  [0x3a2c] = "\xbb\x6c", [0x3a2d] = "\xbb\x6d", [0x3a2e] = "\xbb\x6e",
  [0x3a2f] = "\xbb\x6f", [0x3a30] = "\xbb\x70", [0x3a31] = "\xbb\x71",
  [0x3a32] = "\xbb\x72", [0x3a33] = "\xbb\x73", [0x3a34] = "\xbb\x74",
  [0x3a35] = "\xbb\x75", [0x3a36] = "\xbb\x76", [0x3a37] = "\xbb\x77",
  [0x3a38] = "\xbb\x78", [0x3a39] = "\xbb\x79", [0x3a3a] = "\xbb\x7a",
  [0x3a3b] = "\xbb\x7b", [0x3a3c] = "\xbb\x7c", [0x3a3d] = "\xbb\x7d",
  [0x3a3e] = "\xbb\x7e", [0x3a40] = "\xbb\x80", [0x3a41] = "\xbb\x81",
  [0x3a42] = "\xbb\x82", [0x3a43] = "\xbb\x83", [0x3a44] = "\xbb\x84",
  [0x3a45] = "\xbb\x85", [0x3a46] = "\xbb\x86", [0x3a47] = "\xbb\x87",
  [0x3a48] = "\xbb\x88", [0x3a49] = "\xbb\x89", [0x3a4a] = "\xbb\x8a",
  [0x3a4b] = "\xbb\x8b", [0x3a4c] = "\xbb\x8c", [0x3a4d] = "\xbb\x8d",
  [0x3a4e] = "\xbb\x8e", [0x3a4f] = "\xbb\x8f", [0x3a50] = "\xbb\x90",
  [0x3a51] = "\xbb\x91", [0x3a52] = "\xbb\x92", [0x3a53] = "\xbb\x93",
  [0x3a54] = "\xbb\x94", [0x3a55] = "\xbb\x95", [0x3a56] = "\xbb\x96",
  [0x3a57] = "\xbb\x97", [0x3a58] = "\xbb\x98", [0x3a59] = "\xbb\x99",
  [0x3a5a] = "\xbb\x9a", [0x3a5b] = "\xbb\x9b", [0x3a5c] = "\xbb\x9c",
  [0x3a5d] = "\xbb\x9d", [0x3a5e] = "\xbb\x9e", [0x3a5f] = "\xbb\x9f",
  [0x3a60] = "\xbb\xa0", [0x3a61] = "\xbb\xa1", [0x3a62] = "\xbb\xa2",
  [0x3a63] = "\xbb\xa3", [0x3a64] = "\xbb\xa4", [0x3a65] = "\xbb\xa5",
  [0x3a66] = "\xbb\xa6", [0x3a67] = "\xbb\xa7", [0x3a68] = "\xbb\xa8",
  [0x3a69] = "\xbb\xa9", [0x3a6a] = "\xbb\xaa", [0x3a6b] = "\xbb\xab",
  [0x3a6c] = "\xbb\xac", [0x3a6d] = "\xbb\xad", [0x3a6e] = "\xbb\xae",
  [0x3a6f] = "\xbb\xaf", [0x3a70] = "\xbb\xb0", [0x3a71] = "\xbb\xb1",
  [0x3a72] = "\xbb\xb2", [0x3a73] = "\xbb\xb3", [0x3a74] = "\xbb\xb4",
  [0x3a75] = "\xbb\xb5", [0x3a76] = "\xbb\xb6", [0x3a77] = "\xbb\xb7",
  [0x3a78] = "\xbb\xb8", [0x3a79] = "\xbb\xb9", [0x3a7a] = "\xbb\xba",
  [0x3a7b] = "\xbb\xbb", [0x3a7c] = "\xbb\xbc", [0x3a7d] = "\xbb\xbd",
  [0x3a7e] = "\xbb\xbe", [0x3a7f] = "\xbb\xbf", [0x3a80] = "\xbb\xc0",
  [0x3a81] = "\xbb\xc1", [0x3a82] = "\xbb\xc2", [0x3a83] = "\xbb\xc3",
  [0x3a84] = "\xbb\xc4", [0x3a85] = "\xbb\xc5", [0x3a86] = "\xbb\xc6",
  [0x3a87] = "\xbb\xc7", [0x3a88] = "\xbb\xc8", [0x3a89] = "\xbb\xc9",
  [0x3a8a] = "\xbb\xca", [0x3a8b] = "\xbb\xcb", [0x3a8c] = "\xbb\xcc",
  [0x3a8d] = "\xbb\xcd", [0x3a8e] = "\xbb\xce", [0x3a8f] = "\xbb\xcf",
  [0x3a90] = "\xbb\xd0", [0x3a91] = "\xbb\xd1", [0x3a92] = "\xbb\xd2",
  [0x3a93] = "\xbb\xd3", [0x3a94] = "\xbb\xd4", [0x3a95] = "\xbb\xd5",
  [0x3a96] = "\xbb\xd6", [0x3a97] = "\xbb\xd7", [0x3a98] = "\xbb\xd8",
  [0x3a99] = "\xbb\xd9", [0x3a9a] = "\xbb\xda", [0x3a9b] = "\xbb\xdb",
  [0x3a9c] = "\xbb\xdc", [0x3a9d] = "\xbb\xdd", [0x3a9e] = "\xbb\xde",
  [0x3a9f] = "\xbb\xdf", [0x3aa0] = "\xbb\xe0", [0x3aa1] = "\xbb\xe1",
  [0x3aa2] = "\xbb\xe2", [0x3aa3] = "\xbb\xe3", [0x3aa4] = "\xbb\xe4",
  [0x3aa5] = "\xbb\xe5", [0x3aa6] = "\xbb\xe6", [0x3aa7] = "\xbb\xe7",
  [0x3aa8] = "\xbb\xe8", [0x3aa9] = "\xbb\xe9", [0x3aaa] = "\xbb\xea",
  [0x3aab] = "\xbb\xeb", [0x3aac] = "\xbb\xec", [0x3aad] = "\xbb\xed",
  [0x3aae] = "\xbb\xee", [0x3aaf] = "\xbb\xef", [0x3ab0] = "\xbb\xf0",
  [0x3ab1] = "\xbb\xf1", [0x3ab2] = "\xbb\xf2", [0x3ab3] = "\xbb\xf3",
  [0x3ab4] = "\xbb\xf4", [0x3ab5] = "\xbb\xf5", [0x3ab6] = "\xbb\xf6",
  [0x3ab7] = "\xbb\xf7", [0x3ab8] = "\xbb\xf8", [0x3ab9] = "\xbb\xf9",
  [0x3aba] = "\xbb\xfa", [0x3abb] = "\xbb\xfb", [0x3abc] = "\xbb\xfc",
  [0x3abd] = "\xbb\xfd", [0x3abe] = "\xbb\xfe", [0x3b00] = "\xbc\x40",
  [0x3b01] = "\xbc\x41", [0x3b02] = "\xbc\x42", [0x3b03] = "\xbc\x43",
  [0x3b04] = "\xbc\x44", [0x3b05] = "\xbc\x45", [0x3b06] = "\xbc\x46",
  [0x3b07] = "\xbc\x47", [0x3b08] = "\xbc\x48", [0x3b09] = "\xbc\x49",
  [0x3b0a] = "\xbc\x4a", [0x3b0b] = "\xbc\x4b", [0x3b0c] = "\xbc\x4c",
  [0x3b0d] = "\xbc\x4d", [0x3b0e] = "\xbc\x4e", [0x3b0f] = "\xbc\x4f",
  [0x3b10] = "\xbc\x50", [0x3b11] = "\xbc\x51", [0x3b12] = "\xbc\x52",
  [0x3b13] = "\xbc\x53", [0x3b14] = "\xbc\x54", [0x3b15] = "\xbc\x55",
  [0x3b16] = "\xbc\x56", [0x3b17] = "\xbc\x57", [0x3b18] = "\xbc\x58",
  [0x3b19] = "\xbc\x59", [0x3b1a] = "\xbc\x5a", [0x3b1b] = "\xbc\x5b",
  [0x3b1c] = "\xbc\x5c", [0x3b1d] = "\xbc\x5d", [0x3b1e] = "\xbc\x5e",
  [0x3b1f] = "\xbc\x5f", [0x3b20] = "\xbc\x60", [0x3b21] = "\xbc\x61",
  [0x3b22] = "\xbc\x62", [0x3b23] = "\xbc\x63", [0x3b24] = "\xbc\x64",
  [0x3b25] = "\xbc\x65", [0x3b26] = "\xbc\x66", [0x3b27] = "\xbc\x67",
  [0x3b28] = "\xbc\x68", [0x3b29] = "\xbc\x69", [0x3b2a] = "\xbc\x6a",
  [0x3b2b] = "\xbc\x6b", [0x3b2c] = "\xbc\x6c", [0x3b2d] = "\xbc\x6d",
  [0x3b2e] = "\xbc\x6e", [0x3b2f] = "\xbc\x6f", [0x3b30] = "\xbc\x70",
  [0x3b31] = "\xbc\x71", [0x3b32] = "\xbc\x72", [0x3b33] = "\xbc\x73",
  [0x3b34] = "\xbc\x74", [0x3b35] = "\xbc\x75", [0x3b36] = "\xbc\x76",
  [0x3b37] = "\xbc\x77", [0x3b38] = "\xbc\x78", [0x3b39] = "\xbc\x79",
  [0x3b3a] = "\xbc\x7a", [0x3b3b] = "\xbc\x7b", [0x3b3c] = "\xbc\x7c",
  [0x3b3d] = "\xbc\x7d", [0x3b3e] = "\xbc\x7e", [0x3b40] = "\xbc\x80",
  [0x3b41] = "\xbc\x81", [0x3b42] = "\xbc\x82", [0x3b43] = "\xbc\x83",
  [0x3b44] = "\xbc\x84", [0x3b45] = "\xbc\x85", [0x3b46] = "\xbc\x86",
  [0x3b47] = "\xbc\x87", [0x3b48] = "\xbc\x88", [0x3b49] = "\xbc\x89",
  [0x3b4a] = "\xbc\x8a", [0x3b4b] = "\xbc\x8b", [0x3b4c] = "\xbc\x8c",
  [0x3b4d] = "\xbc\x8d", [0x3b4e] = "\xbc\x8e", [0x3b4f] = "\xbc\x8f",
  [0x3b50] = "\xbc\x90", [0x3b51] = "\xbc\x91", [0x3b52] = "\xbc\x92",
  [0x3b53] = "\xbc\x93", [0x3b54] = "\xbc\x94", [0x3b55] = "\xbc\x95",
  [0x3b56] = "\xbc\x96", [0x3b57] = "\xbc\x97", [0x3b58] = "\xbc\x98",
  [0x3b59] = "\xbc\x99", [0x3b5a] = "\xbc\x9a", [0x3b5b] = "\xbc\x9b",
  [0x3b5c] = "\xbc\x9c", [0x3b5d] = "\xbc\x9d", [0x3b5e] = "\xbc\x9e",
  [0x3b5f] = "\xbc\x9f", [0x3b60] = "\xbc\xa0", [0x3b61] = "\xbc\xa1",
  [0x3b62] = "\xbc\xa2", [0x3b63] = "\xbc\xa3", [0x3b64] = "\xbc\xa4",
  [0x3b65] = "\xbc\xa5", [0x3b66] = "\xbc\xa6", [0x3b67] = "\xbc\xa7",
  [0x3b68] = "\xbc\xa8", [0x3b69] = "\xbc\xa9", [0x3b6a] = "\xbc\xaa",
  [0x3b6b] = "\xbc\xab", [0x3b6c] = "\xbc\xac", [0x3b6d] = "\xbc\xad",
  [0x3b6e] = "\xbc\xae", [0x3b6f] = "\xbc\xaf", [0x3b70] = "\xbc\xb0",
  [0x3b71] = "\xbc\xb1", [0x3b72] = "\xbc\xb2", [0x3b73] = "\xbc\xb3",
  [0x3b74] = "\xbc\xb4", [0x3b75] = "\xbc\xb5", [0x3b76] = "\xbc\xb6",
  [0x3b77] = "\xbc\xb7", [0x3b78] = "\xbc\xb8", [0x3b79] = "\xbc\xb9",
  [0x3b7a] = "\xbc\xba", [0x3b7b] = "\xbc\xbb", [0x3b7c] = "\xbc\xbc",
  [0x3b7d] = "\xbc\xbd", [0x3b7e] = "\xbc\xbe", [0x3b7f] = "\xbc\xbf",
  [0x3b80] = "\xbc\xc0", [0x3b81] = "\xbc\xc1", [0x3b82] = "\xbc\xc2",
  [0x3b83] = "\xbc\xc3", [0x3b84] = "\xbc\xc4", [0x3b85] = "\xbc\xc5",
  [0x3b86] = "\xbc\xc6", [0x3b87] = "\xbc\xc7", [0x3b88] = "\xbc\xc8",
  [0x3b89] = "\xbc\xc9", [0x3b8a] = "\xbc\xca", [0x3b8b] = "\xbc\xcb",
  [0x3b8c] = "\xbc\xcc", [0x3b8d] = "\xbc\xcd", [0x3b8e] = "\xbc\xce",
  [0x3b8f] = "\xbc\xcf", [0x3b90] = "\xbc\xd0", [0x3b91] = "\xbc\xd1",
  [0x3b92] = "\xbc\xd2", [0x3b93] = "\xbc\xd3", [0x3b94] = "\xbc\xd4",
  [0x3b95] = "\xbc\xd5", [0x3b96] = "\xbc\xd6", [0x3b97] = "\xbc\xd7",
  [0x3b98] = "\xbc\xd8", [0x3b99] = "\xbc\xd9", [0x3b9a] = "\xbc\xda",
  [0x3b9b] = "\xbc\xdb", [0x3b9c] = "\xbc\xdc", [0x3b9d] = "\xbc\xdd",
  [0x3b9e] = "\xbc\xde", [0x3b9f] = "\xbc\xdf", [0x3ba0] = "\xbc\xe0",
  [0x3ba1] = "\xbc\xe1", [0x3ba2] = "\xbc\xe2", [0x3ba3] = "\xbc\xe3",
  [0x3ba4] = "\xbc\xe4", [0x3ba5] = "\xbc\xe5", [0x3ba6] = "\xbc\xe6",
  [0x3ba7] = "\xbc\xe7", [0x3ba8] = "\xbc\xe8", [0x3ba9] = "\xbc\xe9",
  [0x3baa] = "\xbc\xea", [0x3bab] = "\xbc\xeb", [0x3bac] = "\xbc\xec",
  [0x3bad] = "\xbc\xed", [0x3bae] = "\xbc\xee", [0x3baf] = "\xbc\xef",
  [0x3bb0] = "\xbc\xf0", [0x3bb1] = "\xbc\xf1", [0x3bb2] = "\xbc\xf2",
  [0x3bb3] = "\xbc\xf3", [0x3bb4] = "\xbc\xf4", [0x3bb5] = "\xbc\xf5",
  [0x3bb6] = "\xbc\xf6", [0x3bb7] = "\xbc\xf7", [0x3bb8] = "\xbc\xf8",
  [0x3bb9] = "\xbc\xf9", [0x3bba] = "\xbc\xfa", [0x3bbb] = "\xbc\xfb",
  [0x3bbc] = "\xbc\xfc", [0x3bbd] = "\xbc\xfd", [0x3bbe] = "\xbc\xfe",
  [0x3c00] = "\xbd\x40", [0x3c01] = "\xbd\x41", [0x3c02] = "\xbd\x42",
  [0x3c03] = "\xbd\x43", [0x3c04] = "\xbd\x44", [0x3c05] = "\xbd\x45",
  [0x3c06] = "\xbd\x46", [0x3c07] = "\xbd\x47", [0x3c08] = "\xbd\x48",
  [0x3c09] = "\xbd\x49", [0x3c0a] = "\xbd\x4a", [0x3c0b] = "\xbd\x4b",
  [0x3c0c] = "\xbd\x4c", [0x3c0d] = "\xbd\x4d", [0x3c0e] = "\xbd\x4e",
  [0x3c0f] = "\xbd\x4f", [0x3c10] = "\xbd\x50", [0x3c11] = "\xbd\x51",
  [0x3c12] = "\xbd\x52", [0x3c13] = "\xbd\x53", [0x3c14] = "\xbd\x54",
  [0x3c15] = "\xbd\x55", [0x3c16] = "\xbd\x56", [0x3c17] = "\xbd\x57",
  [0x3c18] = "\xbd\x58", [0x3c19] = "\xbd\x59", [0x3c1a] = "\xbd\x5a",
  [0x3c1b] = "\xbd\x5b", [0x3c1c] = "\xbd\x5c", [0x3c1d] = "\xbd\x5d",
  [0x3c1e] = "\xbd\x5e", [0x3c1f] = "\xbd\x5f", [0x3c20] = "\xbd\x60",
  [0x3c21] = "\xbd\x61", [0x3c22] = "\xbd\x62", [0x3c23] = "\xbd\x63",
  [0x3c24] = "\xbd\x64", [0x3c25] = "\xbd\x65", [0x3c26] = "\xbd\x66",
  [0x3c27] = "\xbd\x67", [0x3c28] = "\xbd\x68", [0x3c29] = "\xbd\x69",
  [0x3c2a] = "\xbd\x6a", [0x3c2b] = "\xbd\x6b", [0x3c2c] = "\xbd\x6c",
  [0x3c2d] = "\xbd\x6d", [0x3c2e] = "\xbd\x6e", [0x3c2f] = "\xbd\x6f",
  [0x3c30] = "\xbd\x70", [0x3c31] = "\xbd\x71", [0x3c32] = "\xbd\x72",
  [0x3c33] = "\xbd\x73", [0x3c34] = "\xbd\x74", [0x3c35] = "\xbd\x75",
  [0x3c36] = "\xbd\x76", [0x3c37] = "\xbd\x77", [0x3c38] = "\xbd\x78",
  [0x3c39] = "\xbd\x79", [0x3c3a] = "\xbd\x7a", [0x3c3b] = "\xbd\x7b",
  [0x3c3c] = "\xbd\x7c", [0x3c3d] = "\xbd\x7d", [0x3c3e] = "\xbd\x7e",
  [0x3c40] = "\xbd\x80", [0x3c41] = "\xbd\x81", [0x3c42] = "\xbd\x82",
  [0x3c43] = "\xbd\x83", [0x3c44] = "\xbd\x84", [0x3c45] = "\xbd\x85",
  [0x3c46] = "\xbd\x86", [0x3c47] = "\xbd\x87", [0x3c48] = "\xbd\x88",
  [0x3c49] = "\xbd\x89", [0x3c4a] = "\xbd\x8a", [0x3c4b] = "\xbd\x8b",
  [0x3c4c] = "\xbd\x8c", [0x3c4d] = "\xbd\x8d", [0x3c4e] = "\xbd\x8e",
  [0x3c4f] = "\xbd\x8f", [0x3c50] = "\xbd\x90", [0x3c51] = "\xbd\x91",
  [0x3c52] = "\xbd\x92", [0x3c53] = "\xbd\x93", [0x3c54] = "\xbd\x94",
  [0x3c55] = "\xbd\x95", [0x3c56] = "\xbd\x96", [0x3c57] = "\xbd\x97",
  [0x3c58] = "\xbd\x98", [0x3c59] = "\xbd\x99", [0x3c5a] = "\xbd\x9a",
  [0x3c5b] = "\xbd\x9b", [0x3c5c] = "\xbd\x9c", [0x3c5d] = "\xbd\x9d",
  [0x3c5e] = "\xbd\x9e", [0x3c5f] = "\xbd\x9f", [0x3c60] = "\xbd\xa0",
  [0x3c61] = "\xbd\xa1", [0x3c62] = "\xbd\xa2", [0x3c63] = "\xbd\xa3",
  [0x3c64] = "\xbd\xa4", [0x3c65] = "\xbd\xa5", [0x3c66] = "\xbd\xa6",
  [0x3c67] = "\xbd\xa7", [0x3c68] = "\xbd\xa8", [0x3c69] = "\xbd\xa9",
  [0x3c6a] = "\xbd\xaa", [0x3c6b] = "\xbd\xab", [0x3c6c] = "\xbd\xac",
  [0x3c6d] = "\xbd\xad", [0x3c6e] = "\xbd\xae", [0x3c6f] = "\xbd\xaf",
  [0x3c70] = "\xbd\xb0", [0x3c71] = "\xbd\xb1", [0x3c72] = "\xbd\xb2",
  [0x3c73] = "\xbd\xb3", [0x3c74] = "\xbd\xb4", [0x3c75] = "\xbd\xb5",
  [0x3c76] = "\xbd\xb6", [0x3c77] = "\xbd\xb7", [0x3c78] = "\xbd\xb8",
  [0x3c79] = "\xbd\xb9", [0x3c7a] = "\xbd\xba", [0x3c7b] = "\xbd\xbb",
  [0x3c7c] = "\xbd\xbc", [0x3c7d] = "\xbd\xbd", [0x3c7e] = "\xbd\xbe",
  [0x3c7f] = "\xbd\xbf", [0x3c80] = "\xbd\xc0", [0x3c81] = "\xbd\xc1",
  [0x3c82] = "\xbd\xc2", [0x3c83] = "\xbd\xc3", [0x3c84] = "\xbd\xc4",
  [0x3c85] = "\xbd\xc5", [0x3c86] = "\xbd\xc6", [0x3c87] = "\xbd\xc7",
  [0x3c88] = "\xbd\xc8", [0x3c89] = "\xbd\xc9", [0x3c8a] = "\xbd\xca",
  [0x3c8b] = "\xbd\xcb", [0x3c8c] = "\xbd\xcc", [0x3c8d] = "\xbd\xcd",
  [0x3c8e] = "\xbd\xce", [0x3c8f] = "\xbd\xcf", [0x3c90] = "\xbd\xd0",
  [0x3c91] = "\xbd\xd1", [0x3c92] = "\xbd\xd2", [0x3c93] = "\xbd\xd3",
  [0x3c94] = "\xbd\xd4", [0x3c95] = "\xbd\xd5", [0x3c96] = "\xbd\xd6",
  [0x3c97] = "\xbd\xd7", [0x3c98] = "\xbd\xd8", [0x3c99] = "\xbd\xd9",
  [0x3c9a] = "\xbd\xda", [0x3c9b] = "\xbd\xdb", [0x3c9c] = "\xbd\xdc",
  [0x3c9d] = "\xbd\xdd", [0x3c9e] = "\xbd\xde", [0x3c9f] = "\xbd\xdf",
  [0x3ca0] = "\xbd\xe0", [0x3ca1] = "\xbd\xe1", [0x3ca2] = "\xbd\xe2",
  [0x3ca3] = "\xbd\xe3", [0x3ca4] = "\xbd\xe4", [0x3ca5] = "\xbd\xe5",
  [0x3ca6] = "\xbd\xe6", [0x3ca7] = "\xbd\xe7", [0x3ca8] = "\xbd\xe8",
  [0x3ca9] = "\xbd\xe9", [0x3caa] = "\xbd\xea", [0x3cab] = "\xbd\xeb",
  [0x3cac] = "\xbd\xec", [0x3cad] = "\xbd\xed", [0x3cae] = "\xbd\xee",
  [0x3caf] = "\xbd\xef", [0x3cb0] = "\xbd\xf0", [0x3cb1] = "\xbd\xf1",
  [0x3cb2] = "\xbd\xf2", [0x3cb3] = "\xbd\xf3", [0x3cb4] = "\xbd\xf4",
  [0x3cb5] = "\xbd\xf5", [0x3cb6] = "\xbd\xf6", [0x3cb7] = "\xbd\xf7",
  [0x3cb8] = "\xbd\xf8", [0x3cb9] = "\xbd\xf9", [0x3cba] = "\xbd\xfa",
  [0x3cbb] = "\xbd\xfb", [0x3cbc] = "\xbd\xfc", [0x3cbd] = "\xbd\xfd",
  [0x3cbe] = "\xbd\xfe", [0x3d00] = "\xbe\x40", [0x3d01] = "\xbe\x41",
  [0x3d02] = "\xbe\x42", [0x3d03] = "\xbe\x43", [0x3d04] = "\xbe\x44",
  [0x3d05] = "\xbe\x45", [0x3d06] = "\xbe\x46", [0x3d07] = "\xbe\x47",
  [0x3d08] = "\xbe\x48", [0x3d09] = "\xbe\x49", [0x3d0a] = "\xbe\x4a",
  [0x3d0b] = "\xbe\x4b", [0x3d0c] = "\xbe\x4c", [0x3d0d] = "\xbe\x4d",
  [0x3d0e] = "\xbe\x4e", [0x3d0f] = "\xbe\x4f", [0x3d10] = "\xbe\x50",
  [0x3d11] = "\xbe\x51", [0x3d12] = "\xbe\x52", [0x3d13] = "\xbe\x53",
  [0x3d14] = "\xbe\x54", [0x3d15] = "\xbe\x55", [0x3d16] = "\xbe\x56",
  [0x3d17] = "\xbe\x57", [0x3d18] = "\xbe\x58", [0x3d19] = "\xbe\x59",
  [0x3d1a] = "\xbe\x5a", [0x3d1b] = "\xbe\x5b", [0x3d1c] = "\xbe\x5c",
  [0x3d1d] = "\xbe\x5d", [0x3d1e] = "\xbe\x5e", [0x3d1f] = "\xbe\x5f",
  [0x3d20] = "\xbe\x60", [0x3d21] = "\xbe\x61", [0x3d22] = "\xbe\x62",
  [0x3d23] = "\xbe\x63", [0x3d24] = "\xbe\x64", [0x3d25] = "\xbe\x65",
  [0x3d26] = "\xbe\x66", [0x3d27] = "\xbe\x67", [0x3d28] = "\xbe\x68",
  [0x3d29] = "\xbe\x69", [0x3d2a] = "\xbe\x6a", [0x3d2b] = "\xbe\x6b",
  [0x3d2c] = "\xbe\x6c", [0x3d2d] = "\xbe\x6d", [0x3d2e] = "\xbe\x6e",
  [0x3d2f] = "\xbe\x6f", [0x3d30] = "\xbe\x70", [0x3d31] = "\xbe\x71",
  [0x3d32] = "\xbe\x72", [0x3d33] = "\xbe\x73", [0x3d34] = "\xbe\x74",
  [0x3d35] = "\xbe\x75", [0x3d36] = "\xbe\x76", [0x3d37] = "\xbe\x77",
  [0x3d38] = "\xbe\x78", [0x3d39] = "\xbe\x79", [0x3d3a] = "\xbe\x7a",
  [0x3d3b] = "\xbe\x7b", [0x3d3c] = "\xbe\x7c", [0x3d3d] = "\xbe\x7d",
  [0x3d3e] = "\xbe\x7e", [0x3d40] = "\xbe\x80", [0x3d41] = "\xbe\x81",
  [0x3d42] = "\xbe\x82", [0x3d43] = "\xbe\x83", [0x3d44] = "\xbe\x84",
  [0x3d45] = "\xbe\x85", [0x3d46] = "\xbe\x86", [0x3d47] = "\xbe\x87",
  [0x3d48] = "\xbe\x88", [0x3d49] = "\xbe\x89", [0x3d4a] = "\xbe\x8a",
  [0x3d4b] = "\xbe\x8b", [0x3d4c] = "\xbe\x8c", [0x3d4d] = "\xbe\x8d",
  [0x3d4e] = "\xbe\x8e", [0x3d4f] = "\xbe\x8f", [0x3d50] = "\xbe\x90",
  [0x3d51] = "\xbe\x91", [0x3d52] = "\xbe\x92", [0x3d53] = "\xbe\x93",
  [0x3d54] = "\xbe\x94", [0x3d55] = "\xbe\x95", [0x3d56] = "\xbe\x96",
  [0x3d57] = "\xbe\x97", [0x3d58] = "\xbe\x98", [0x3d59] = "\xbe\x99",
  [0x3d5a] = "\xbe\x9a", [0x3d5b] = "\xbe\x9b", [0x3d5c] = "\xbe\x9c",
  [0x3d5d] = "\xbe\x9d", [0x3d5e] = "\xbe\x9e", [0x3d5f] = "\xbe\x9f",
  [0x3d60] = "\xbe\xa0", [0x3d61] = "\xbe\xa1", [0x3d62] = "\xbe\xa2",
  [0x3d63] = "\xbe\xa3", [0x3d64] = "\xbe\xa4", [0x3d65] = "\xbe\xa5",
  [0x3d66] = "\xbe\xa6", [0x3d67] = "\xbe\xa7", [0x3d68] = "\xbe\xa8",
  [0x3d69] = "\xbe\xa9", [0x3d6a] = "\xbe\xaa", [0x3d6b] = "\xbe\xab",
  [0x3d6c] = "\xbe\xac", [0x3d6d] = "\xbe\xad", [0x3d6e] = "\xbe\xae",
  [0x3d6f] = "\xbe\xaf", [0x3d70] = "\xbe\xb0", [0x3d71] = "\xbe\xb1",
  [0x3d72] = "\xbe\xb2", [0x3d73] = "\xbe\xb3", [0x3d74] = "\xbe\xb4",
  [0x3d75] = "\xbe\xb5", [0x3d76] = "\xbe\xb6", [0x3d77] = "\xbe\xb7",
  [0x3d78] = "\xbe\xb8", [0x3d79] = "\xbe\xb9", [0x3d7a] = "\xbe\xba",
  [0x3d7b] = "\xbe\xbb", [0x3d7c] = "\xbe\xbc", [0x3d7d] = "\xbe\xbd",
  [0x3d7e] = "\xbe\xbe", [0x3d7f] = "\xbe\xbf", [0x3d80] = "\xbe\xc0",
  [0x3d81] = "\xbe\xc1", [0x3d82] = "\xbe\xc2", [0x3d83] = "\xbe\xc3",
  [0x3d84] = "\xbe\xc4", [0x3d85] = "\xbe\xc5", [0x3d86] = "\xbe\xc6",
  [0x3d87] = "\xbe\xc7", [0x3d88] = "\xbe\xc8", [0x3d89] = "\xbe\xc9",
  [0x3d8a] = "\xbe\xca", [0x3d8b] = "\xbe\xcb", [0x3d8c] = "\xbe\xcc",
  [0x3d8d] = "\xbe\xcd", [0x3d8e] = "\xbe\xce", [0x3d8f] = "\xbe\xcf",
  [0x3d90] = "\xbe\xd0", [0x3d91] = "\xbe\xd1", [0x3d92] = "\xbe\xd2",
  [0x3d93] = "\xbe\xd3", [0x3d94] = "\xbe\xd4", [0x3d95] = "\xbe\xd5",
  [0x3d96] = "\xbe\xd6", [0x3d97] = "\xbe\xd7", [0x3d98] = "\xbe\xd8",
  [0x3d99] = "\xbe\xd9", [0x3d9a] = "\xbe\xda", [0x3d9b] = "\xbe\xdb",
  [0x3d9c] = "\xbe\xdc", [0x3d9d] = "\xbe\xdd", [0x3d9e] = "\xbe\xde",
  [0x3d9f] = "\xbe\xdf", [0x3da0] = "\xbe\xe0", [0x3da1] = "\xbe\xe1",
  [0x3da2] = "\xbe\xe2", [0x3da3] = "\xbe\xe3", [0x3da4] = "\xbe\xe4",
  [0x3da5] = "\xbe\xe5", [0x3da6] = "\xbe\xe6", [0x3da7] = "\xbe\xe7",
  [0x3da8] = "\xbe\xe8", [0x3da9] = "\xbe\xe9", [0x3daa] = "\xbe\xea",
  [0x3dab] = "\xbe\xeb", [0x3dac] = "\xbe\xec", [0x3dad] = "\xbe\xed",
  [0x3dae] = "\xbe\xee", [0x3daf] = "\xbe\xef", [0x3db0] = "\xbe\xf0",
  [0x3db1] = "\xbe\xf1", [0x3db2] = "\xbe\xf2", [0x3db3] = "\xbe\xf3",
  [0x3db4] = "\xbe\xf4", [0x3db5] = "\xbe\xf5", [0x3db6] = "\xbe\xf6",
  [0x3db7] = "\xbe\xf7", [0x3db8] = "\xbe\xf8", [0x3db9] = "\xbe\xf9",
  [0x3dba] = "\xbe\xfa", [0x3dbb] = "\xbe\xfb", [0x3dbc] = "\xbe\xfc",
  [0x3dbd] = "\xbe\xfd", [0x3dbe] = "\xbe\xfe", [0x3e00] = "\xbf\x40",
  [0x3e01] = "\xbf\x41", [0x3e02] = "\xbf\x42", [0x3e03] = "\xbf\x43",
  [0x3e04] = "\xbf\x44", [0x3e05] = "\xbf\x45", [0x3e06] = "\xbf\x46",
  [0x3e07] = "\xbf\x47", [0x3e08] = "\xbf\x48", [0x3e09] = "\xbf\x49",
  [0x3e0a] = "\xbf\x4a", [0x3e0b] = "\xbf\x4b", [0x3e0c] = "\xbf\x4c",
  [0x3e0d] = "\xbf\x4d", [0x3e0e] = "\xbf\x4e", [0x3e0f] = "\xbf\x4f",
  [0x3e10] = "\xbf\x50", [0x3e11] = "\xbf\x51", [0x3e12] = "\xbf\x52",
  [0x3e13] = "\xbf\x53", [0x3e14] = "\xbf\x54", [0x3e15] = "\xbf\x55",
  [0x3e16] = "\xbf\x56", [0x3e17] = "\xbf\x57", [0x3e18] = "\xbf\x58",
  [0x3e19] = "\xbf\x59", [0x3e1a] = "\xbf\x5a", [0x3e1b] = "\xbf\x5b",
  [0x3e1c] = "\xbf\x5c", [0x3e1d] = "\xbf\x5d", [0x3e1e] = "\xbf\x5e",
  [0x3e1f] = "\xbf\x5f", [0x3e20] = "\xbf\x60", [0x3e21] = "\xbf\x61",
  [0x3e22] = "\xbf\x62", [0x3e23] = "\xbf\x63", [0x3e24] = "\xbf\x64",
  [0x3e25] = "\xbf\x65", [0x3e26] = "\xbf\x66", [0x3e27] = "\xbf\x67",
  [0x3e28] = "\xbf\x68", [0x3e29] = "\xbf\x69", [0x3e2a] = "\xbf\x6a",
  [0x3e2b] = "\xbf\x6b", [0x3e2c] = "\xbf\x6c", [0x3e2d] = "\xbf\x6d",
  [0x3e2e] = "\xbf\x6e", [0x3e2f] = "\xbf\x6f", [0x3e30] = "\xbf\x70",
  [0x3e31] = "\xbf\x71", [0x3e32] = "\xbf\x72", [0x3e33] = "\xbf\x73",
  [0x3e34] = "\xbf\x74", [0x3e35] = "\xbf\x75", [0x3e36] = "\xbf\x76",
  [0x3e37] = "\xbf\x77", [0x3e38] = "\xbf\x78", [0x3e39] = "\xbf\x79",
  [0x3e3a] = "\xbf\x7a", [0x3e3b] = "\xbf\x7b", [0x3e3c] = "\xbf\x7c",
  [0x3e3d] = "\xbf\x7d", [0x3e3e] = "\xbf\x7e", [0x3e40] = "\xbf\x80",
  [0x3e41] = "\xbf\x81", [0x3e42] = "\xbf\x82", [0x3e43] = "\xbf\x83",
  [0x3e44] = "\xbf\x84", [0x3e45] = "\xbf\x85", [0x3e46] = "\xbf\x86",
  [0x3e47] = "\xbf\x87", [0x3e48] = "\xbf\x88", [0x3e49] = "\xbf\x89",
  [0x3e4a] = "\xbf\x8a", [0x3e4b] = "\xbf\x8b", [0x3e4c] = "\xbf\x8c",
  [0x3e4d] = "\xbf\x8d", [0x3e4e] = "\xbf\x8e", [0x3e4f] = "\xbf\x8f",
  [0x3e50] = "\xbf\x90", [0x3e51] = "\xbf\x91", [0x3e52] = "\xbf\x92",
  [0x3e53] = "\xbf\x93", [0x3e54] = "\xbf\x94", [0x3e55] = "\xbf\x95",
  [0x3e56] = "\xbf\x96", [0x3e57] = "\xbf\x97", [0x3e58] = "\xbf\x98",
  [0x3e59] = "\xbf\x99", [0x3e5a] = "\xbf\x9a", [0x3e5b] = "\xbf\x9b",
  [0x3e5c] = "\xbf\x9c", [0x3e5d] = "\xbf\x9d", [0x3e5e] = "\xbf\x9e",
  [0x3e5f] = "\xbf\x9f", [0x3e60] = "\xbf\xa0", [0x3e61] = "\xbf\xa1",
  [0x3e62] = "\xbf\xa2", [0x3e63] = "\xbf\xa3", [0x3e64] = "\xbf\xa4",
  [0x3e65] = "\xbf\xa5", [0x3e66] = "\xbf\xa6", [0x3e67] = "\xbf\xa7",
  [0x3e68] = "\xbf\xa8", [0x3e69] = "\xbf\xa9", [0x3e6a] = "\xbf\xaa",
  [0x3e6b] = "\xbf\xab", [0x3e6c] = "\xbf\xac", [0x3e6d] = "\xbf\xad",
  [0x3e6e] = "\xbf\xae", [0x3e6f] = "\xbf\xaf", [0x3e70] = "\xbf\xb0",
  [0x3e71] = "\xbf\xb1", [0x3e72] = "\xbf\xb2", [0x3e73] = "\xbf\xb3",
  [0x3e74] = "\xbf\xb4", [0x3e75] = "\xbf\xb5", [0x3e76] = "\xbf\xb6",
  [0x3e77] = "\xbf\xb7", [0x3e78] = "\xbf\xb8", [0x3e79] = "\xbf\xb9",
  [0x3e7a] = "\xbf\xba", [0x3e7b] = "\xbf\xbb", [0x3e7c] = "\xbf\xbc",
  [0x3e7d] = "\xbf\xbd", [0x3e7e] = "\xbf\xbe", [0x3e7f] = "\xbf\xbf",
  [0x3e80] = "\xbf\xc0", [0x3e81] = "\xbf\xc1", [0x3e82] = "\xbf\xc2",
  [0x3e83] = "\xbf\xc3", [0x3e84] = "\xbf\xc4", [0x3e85] = "\xbf\xc5",
  [0x3e86] = "\xbf\xc6", [0x3e87] = "\xbf\xc7", [0x3e88] = "\xbf\xc8",
  [0x3e89] = "\xbf\xc9", [0x3e8a] = "\xbf\xca", [0x3e8b] = "\xbf\xcb",
  [0x3e8c] = "\xbf\xcc", [0x3e8d] = "\xbf\xcd", [0x3e8e] = "\xbf\xce",
  [0x3e8f] = "\xbf\xcf", [0x3e90] = "\xbf\xd0", [0x3e91] = "\xbf\xd1",
  [0x3e92] = "\xbf\xd2", [0x3e93] = "\xbf\xd3", [0x3e94] = "\xbf\xd4",
  [0x3e95] = "\xbf\xd5", [0x3e96] = "\xbf\xd6", [0x3e97] = "\xbf\xd7",
  [0x3e98] = "\xbf\xd8", [0x3e99] = "\xbf\xd9", [0x3e9a] = "\xbf\xda",
  [0x3e9b] = "\xbf\xdb", [0x3e9c] = "\xbf\xdc", [0x3e9d] = "\xbf\xdd",
  [0x3e9e] = "\xbf\xde", [0x3e9f] = "\xbf\xdf", [0x3ea0] = "\xbf\xe0",
  [0x3ea1] = "\xbf\xe1", [0x3ea2] = "\xbf\xe2", [0x3ea3] = "\xbf\xe3",
  [0x3ea4] = "\xbf\xe4", [0x3ea5] = "\xbf\xe5", [0x3ea6] = "\xbf\xe6",
  [0x3ea7] = "\xbf\xe7", [0x3ea8] = "\xbf\xe8", [0x3ea9] = "\xbf\xe9",
  [0x3eaa] = "\xbf\xea", [0x3eab] = "\xbf\xeb", [0x3eac] = "\xbf\xec",
  [0x3ead] = "\xbf\xed", [0x3eae] = "\xbf\xee", [0x3eaf] = "\xbf\xef",
  [0x3eb0] = "\xbf\xf0", [0x3eb1] = "\xbf\xf1", [0x3eb2] = "\xbf\xf2",
  [0x3eb3] = "\xbf\xf3", [0x3eb4] = "\xbf\xf4", [0x3eb5] = "\xbf\xf5",
  [0x3eb6] = "\xbf\xf6", [0x3eb7] = "\xbf\xf7", [0x3eb8] = "\xbf\xf8",
  [0x3eb9] = "\xbf\xf9", [0x3eba] = "\xbf\xfa", [0x3ebb] = "\xbf\xfb",
  [0x3ebc] = "\xbf\xfc", [0x3ebd] = "\xbf\xfd", [0x3ebe] = "\xbf\xfe",
  [0x3f00] = "\xc0\x40", [0x3f01] = "\xc0\x41", [0x3f02] = "\xc0\x42",
  [0x3f03] = "\xc0\x43", [0x3f04] = "\xc0\x44", [0x3f05] = "\xc0\x45",
  [0x3f06] = "\xc0\x46", [0x3f07] = "\xc0\x47", [0x3f08] = "\xc0\x48",
  [0x3f09] = "\xc0\x49", [0x3f0a] = "\xc0\x4a", [0x3f0b] = "\xc0\x4b",
  [0x3f0c] = "\xc0\x4c", [0x3f0d] = "\xc0\x4d", [0x3f0e] = "\xc0\x4e",
  [0x3f0f] = "\xc0\x4f", [0x3f10] = "\xc0\x50", [0x3f11] = "\xc0\x51",
  [0x3f12] = "\xc0\x52", [0x3f13] = "\xc0\x53", [0x3f14] = "\xc0\x54",
  [0x3f15] = "\xc0\x55", [0x3f16] = "\xc0\x56", [0x3f17] = "\xc0\x57",
  [0x3f18] = "\xc0\x58", [0x3f19] = "\xc0\x59", [0x3f1a] = "\xc0\x5a",
  [0x3f1b] = "\xc0\x5b", [0x3f1c] = "\xc0\x5c", [0x3f1d] = "\xc0\x5d",
  [0x3f1e] = "\xc0\x5e", [0x3f1f] = "\xc0\x5f", [0x3f20] = "\xc0\x60",
  [0x3f21] = "\xc0\x61", [0x3f22] = "\xc0\x62", [0x3f23] = "\xc0\x63",
  [0x3f24] = "\xc0\x64", [0x3f25] = "\xc0\x65", [0x3f26] = "\xc0\x66",
  [0x3f27] = "\xc0\x67", [0x3f28] = "\xc0\x68", [0x3f29] = "\xc0\x69",
  [0x3f2a] = "\xc0\x6a", [0x3f2b] = "\xc0\x6b", [0x3f2c] = "\xc0\x6c",
  [0x3f2d] = "\xc0\x6d", [0x3f2e] = "\xc0\x6e", [0x3f2f] = "\xc0\x6f",
  [0x3f30] = "\xc0\x70", [0x3f31] = "\xc0\x71", [0x3f32] = "\xc0\x72",
  [0x3f33] = "\xc0\x73", [0x3f34] = "\xc0\x74", [0x3f35] = "\xc0\x75",
  [0x3f36] = "\xc0\x76", [0x3f37] = "\xc0\x77", [0x3f38] = "\xc0\x78",
  [0x3f39] = "\xc0\x79", [0x3f3a] = "\xc0\x7a", [0x3f3b] = "\xc0\x7b",
  [0x3f3c] = "\xc0\x7c", [0x3f3d] = "\xc0\x7d", [0x3f3e] = "\xc0\x7e",
  [0x3f40] = "\xc0\x80", [0x3f41] = "\xc0\x81", [0x3f42] = "\xc0\x82",
  [0x3f43] = "\xc0\x83", [0x3f44] = "\xc0\x84", [0x3f45] = "\xc0\x85",
  [0x3f46] = "\xc0\x86", [0x3f47] = "\xc0\x87", [0x3f48] = "\xc0\x88",
  [0x3f49] = "\xc0\x89", [0x3f4a] = "\xc0\x8a", [0x3f4b] = "\xc0\x8b",
  [0x3f4c] = "\xc0\x8c", [0x3f4d] = "\xc0\x8d", [0x3f4e] = "\xc0\x8e",
  [0x3f4f] = "\xc0\x8f", [0x3f50] = "\xc0\x90", [0x3f51] = "\xc0\x91",
  [0x3f52] = "\xc0\x92", [0x3f53] = "\xc0\x93", [0x3f54] = "\xc0\x94",
  [0x3f55] = "\xc0\x95", [0x3f56] = "\xc0\x96", [0x3f57] = "\xc0\x97",
  [0x3f58] = "\xc0\x98", [0x3f59] = "\xc0\x99", [0x3f5a] = "\xc0\x9a",
  [0x3f5b] = "\xc0\x9b", [0x3f5c] = "\xc0\x9c", [0x3f5d] = "\xc0\x9d",
  [0x3f5e] = "\xc0\x9e", [0x3f5f] = "\xc0\x9f", [0x3f60] = "\xc0\xa0",
  [0x3f61] = "\xc0\xa1", [0x3f62] = "\xc0\xa2", [0x3f63] = "\xc0\xa3",
  [0x3f64] = "\xc0\xa4", [0x3f65] = "\xc0\xa5", [0x3f66] = "\xc0\xa6",
  [0x3f67] = "\xc0\xa7", [0x3f68] = "\xc0\xa8", [0x3f69] = "\xc0\xa9",
  [0x3f6a] = "\xc0\xaa", [0x3f6b] = "\xc0\xab", [0x3f6c] = "\xc0\xac",
  [0x3f6d] = "\xc0\xad", [0x3f6e] = "\xc0\xae", [0x3f6f] = "\xc0\xaf",
  [0x3f70] = "\xc0\xb0", [0x3f71] = "\xc0\xb1", [0x3f72] = "\xc0\xb2",
  [0x3f73] = "\xc0\xb3", [0x3f74] = "\xc0\xb4", [0x3f75] = "\xc0\xb5",
  [0x3f76] = "\xc0\xb6", [0x3f77] = "\xc0\xb7", [0x3f78] = "\xc0\xb8",
  [0x3f79] = "\xc0\xb9", [0x3f7a] = "\xc0\xba", [0x3f7b] = "\xc0\xbb",
  [0x3f7c] = "\xc0\xbc", [0x3f7d] = "\xc0\xbd", [0x3f7e] = "\xc0\xbe",
  [0x3f7f] = "\xc0\xbf", [0x3f80] = "\xc0\xc0", [0x3f81] = "\xc0\xc1",
  [0x3f82] = "\xc0\xc2", [0x3f83] = "\xc0\xc3", [0x3f84] = "\xc0\xc4",
  [0x3f85] = "\xc0\xc5", [0x3f86] = "\xc0\xc6", [0x3f87] = "\xc0\xc7",
  [0x3f88] = "\xc0\xc8", [0x3f89] = "\xc0\xc9", [0x3f8a] = "\xc0\xca",
  [0x3f8b] = "\xc0\xcb", [0x3f8c] = "\xc0\xcc", [0x3f8d] = "\xc0\xcd",
  [0x3f8e] = "\xc0\xce", [0x3f8f] = "\xc0\xcf", [0x3f90] = "\xc0\xd0",
  [0x3f91] = "\xc0\xd1", [0x3f92] = "\xc0\xd2", [0x3f93] = "\xc0\xd3",
  [0x3f94] = "\xc0\xd4", [0x3f95] = "\xc0\xd5", [0x3f96] = "\xc0\xd6",
  [0x3f97] = "\xc0\xd7", [0x3f98] = "\xc0\xd8", [0x3f99] = "\xc0\xd9",
  [0x3f9a] = "\xc0\xda", [0x3f9b] = "\xc0\xdb", [0x3f9c] = "\xc0\xdc",
  [0x3f9d] = "\xc0\xdd", [0x3f9e] = "\xc0\xde", [0x3f9f] = "\xc0\xdf",
  [0x3fa0] = "\xc0\xe0", [0x3fa1] = "\xc0\xe1", [0x3fa2] = "\xc0\xe2",
  [0x3fa3] = "\xc0\xe3", [0x3fa4] = "\xc0\xe4", [0x3fa5] = "\xc0\xe5",
  [0x3fa6] = "\xc0\xe6", [0x3fa7] = "\xc0\xe7", [0x3fa8] = "\xc0\xe8",
  [0x3fa9] = "\xc0\xe9", [0x3faa] = "\xc0\xea", [0x3fab] = "\xc0\xeb",
  [0x3fac] = "\xc0\xec", [0x3fad] = "\xc0\xed", [0x3fae] = "\xc0\xee",
  [0x3faf] = "\xc0\xef", [0x3fb0] = "\xc0\xf0", [0x3fb1] = "\xc0\xf1",
  [0x3fb2] = "\xc0\xf2", [0x3fb3] = "\xc0\xf3", [0x3fb4] = "\xc0\xf4",
  [0x3fb5] = "\xc0\xf5", [0x3fb6] = "\xc0\xf6", [0x3fb7] = "\xc0\xf7",
  [0x3fb8] = "\xc0\xf8", [0x3fb9] = "\xc0\xf9", [0x3fba] = "\xc0\xfa",
  [0x3fbb] = "\xc0\xfb", [0x3fbc] = "\xc0\xfc", [0x3fbd] = "\xc0\xfd",
  [0x3fbe] = "\xc0\xfe", [0x4000] = "\xc1\x40", [0x4001] = "\xc1\x41",
  [0x4002] = "\xc1\x42", [0x4003] = "\xc1\x43", [0x4004] = "\xc1\x44",
  [0x4005] = "\xc1\x45", [0x4006] = "\xc1\x46", [0x4007] = "\xc1\x47",
  [0x4008] = "\xc1\x48", [0x4009] = "\xc1\x49", [0x400a] = "\xc1\x4a",
  [0x400b] = "\xc1\x4b", [0x400c] = "\xc1\x4c", [0x400d] = "\xc1\x4d",
  [0x400e] = "\xc1\x4e", [0x400f] = "\xc1\x4f", [0x4010] = "\xc1\x50",
  [0x4011] = "\xc1\x51", [0x4012] = "\xc1\x52", [0x4013] = "\xc1\x53",
  [0x4014] = "\xc1\x54", [0x4015] = "\xc1\x55", [0x4016] = "\xc1\x56",
  [0x4017] = "\xc1\x57", [0x4018] = "\xc1\x58", [0x4019] = "\xc1\x59",
  [0x401a] = "\xc1\x5a", [0x401b] = "\xc1\x5b", [0x401c] = "\xc1\x5c",
  [0x401d] = "\xc1\x5d", [0x401e] = "\xc1\x5e", [0x401f] = "\xc1\x5f",
  [0x4020] = "\xc1\x60", [0x4021] = "\xc1\x61", [0x4022] = "\xc1\x62",
  [0x4023] = "\xc1\x63", [0x4024] = "\xc1\x64", [0x4025] = "\xc1\x65",
  [0x4026] = "\xc1\x66", [0x4027] = "\xc1\x67", [0x4028] = "\xc1\x68",
  [0x4029] = "\xc1\x69", [0x402a] = "\xc1\x6a", [0x402b] = "\xc1\x6b",
  [0x402c] = "\xc1\x6c", [0x402d] = "\xc1\x6d", [0x402e] = "\xc1\x6e",
  [0x402f] = "\xc1\x6f", [0x4030] = "\xc1\x70", [0x4031] = "\xc1\x71",
  [0x4032] = "\xc1\x72", [0x4033] = "\xc1\x73", [0x4034] = "\xc1\x74",
  [0x4035] = "\xc1\x75", [0x4036] = "\xc1\x76", [0x4037] = "\xc1\x77",
  [0x4038] = "\xc1\x78", [0x4039] = "\xc1\x79", [0x403a] = "\xc1\x7a",
  [0x403b] = "\xc1\x7b", [0x403c] = "\xc1\x7c", [0x403d] = "\xc1\x7d",
  [0x403e] = "\xc1\x7e", [0x4040] = "\xc1\x80", [0x4041] = "\xc1\x81",
  [0x4042] = "\xc1\x82", [0x4043] = "\xc1\x83", [0x4044] = "\xc1\x84",
  [0x4045] = "\xc1\x85", [0x4046] = "\xc1\x86", [0x4047] = "\xc1\x87",
  [0x4048] = "\xc1\x88", [0x4049] = "\xc1\x89", [0x404a] = "\xc1\x8a",
  [0x404b] = "\xc1\x8b", [0x404c] = "\xc1\x8c", [0x404d] = "\xc1\x8d",
  [0x404e] = "\xc1\x8e", [0x404f] = "\xc1\x8f", [0x4050] = "\xc1\x90",
  [0x4051] = "\xc1\x91", [0x4052] = "\xc1\x92", [0x4053] = "\xc1\x93",
  [0x4054] = "\xc1\x94", [0x4055] = "\xc1\x95", [0x4056] = "\xc1\x96",
  [0x4057] = "\xc1\x97", [0x4058] = "\xc1\x98", [0x4059] = "\xc1\x99",
  [0x405a] = "\xc1\x9a", [0x405b] = "\xc1\x9b", [0x405c] = "\xc1\x9c",
  [0x405d] = "\xc1\x9d", [0x405e] = "\xc1\x9e", [0x405f] = "\xc1\x9f",
  [0x4060] = "\xc1\xa0", [0x4061] = "\xc1\xa1", [0x4062] = "\xc1\xa2",
  [0x4063] = "\xc1\xa3", [0x4064] = "\xc1\xa4", [0x4065] = "\xc1\xa5",
  [0x4066] = "\xc1\xa6", [0x4067] = "\xc1\xa7", [0x4068] = "\xc1\xa8",
  [0x4069] = "\xc1\xa9", [0x406a] = "\xc1\xaa", [0x406b] = "\xc1\xab",
  [0x406c] = "\xc1\xac", [0x406d] = "\xc1\xad", [0x406e] = "\xc1\xae",
  [0x406f] = "\xc1\xaf", [0x4070] = "\xc1\xb0", [0x4071] = "\xc1\xb1",
  [0x4072] = "\xc1\xb2", [0x4073] = "\xc1\xb3", [0x4074] = "\xc1\xb4",
  [0x4075] = "\xc1\xb5", [0x4076] = "\xc1\xb6", [0x4077] = "\xc1\xb7",
  [0x4078] = "\xc1\xb8", [0x4079] = "\xc1\xb9", [0x407a] = "\xc1\xba",
  [0x407b] = "\xc1\xbb", [0x407c] = "\xc1\xbc", [0x407d] = "\xc1\xbd",
  [0x407e] = "\xc1\xbe", [0x407f] = "\xc1\xbf", [0x4080] = "\xc1\xc0",
  [0x4081] = "\xc1\xc1", [0x4082] = "\xc1\xc2", [0x4083] = "\xc1\xc3",
  [0x4084] = "\xc1\xc4", [0x4085] = "\xc1\xc5", [0x4086] = "\xc1\xc6",
  [0x4087] = "\xc1\xc7", [0x4088] = "\xc1\xc8", [0x4089] = "\xc1\xc9",
  [0x408a] = "\xc1\xca", [0x408b] = "\xc1\xcb", [0x408c] = "\xc1\xcc",
  [0x408d] = "\xc1\xcd", [0x408e] = "\xc1\xce", [0x408f] = "\xc1\xcf",
  [0x4090] = "\xc1\xd0", [0x4091] = "\xc1\xd1", [0x4092] = "\xc1\xd2",
  [0x4093] = "\xc1\xd3", [0x4094] = "\xc1\xd4", [0x4095] = "\xc1\xd5",
  [0x4096] = "\xc1\xd6", [0x4097] = "\xc1\xd7", [0x4098] = "\xc1\xd8",
  [0x4099] = "\xc1\xd9", [0x409a] = "\xc1\xda", [0x409b] = "\xc1\xdb",
  [0x409c] = "\xc1\xdc", [0x409d] = "\xc1\xdd", [0x409e] = "\xc1\xde",
  [0x409f] = "\xc1\xdf", [0x40a0] = "\xc1\xe0", [0x40a1] = "\xc1\xe1",
  [0x40a2] = "\xc1\xe2", [0x40a3] = "\xc1\xe3", [0x40a4] = "\xc1\xe4",
  [0x40a5] = "\xc1\xe5", [0x40a6] = "\xc1\xe6", [0x40a7] = "\xc1\xe7",
  [0x40a8] = "\xc1\xe8", [0x40a9] = "\xc1\xe9", [0x40aa] = "\xc1\xea",
  [0x40ab] = "\xc1\xeb", [0x40ac] = "\xc1\xec", [0x40ad] = "\xc1\xed",
  [0x40ae] = "\xc1\xee", [0x40af] = "\xc1\xef", [0x40b0] = "\xc1\xf0",
  [0x40b1] = "\xc1\xf1", [0x40b2] = "\xc1\xf2", [0x40b3] = "\xc1\xf3",
  [0x40b4] = "\xc1\xf4", [0x40b5] = "\xc1\xf5", [0x40b6] = "\xc1\xf6",
  [0x40b7] = "\xc1\xf7", [0x40b8] = "\xc1\xf8", [0x40b9] = "\xc1\xf9",
  [0x40ba] = "\xc1\xfa", [0x40bb] = "\xc1\xfb", [0x40bc] = "\xc1\xfc",
  [0x40bd] = "\xc1\xfd", [0x40be] = "\xc1\xfe", [0x4100] = "\xc2\x40",
  [0x4101] = "\xc2\x41", [0x4102] = "\xc2\x42", [0x4103] = "\xc2\x43",
  [0x4104] = "\xc2\x44", [0x4105] = "\xc2\x45", [0x4106] = "\xc2\x46",
  [0x4107] = "\xc2\x47", [0x4108] = "\xc2\x48", [0x4109] = "\xc2\x49",
  [0x410a] = "\xc2\x4a", [0x410b] = "\xc2\x4b", [0x410c] = "\xc2\x4c",
  [0x410d] = "\xc2\x4d", [0x410e] = "\xc2\x4e", [0x410f] = "\xc2\x4f",
  [0x4110] = "\xc2\x50", [0x4111] = "\xc2\x51", [0x4112] = "\xc2\x52",
  [0x4113] = "\xc2\x53", [0x4114] = "\xc2\x54", [0x4115] = "\xc2\x55",
  [0x4116] = "\xc2\x56", [0x4117] = "\xc2\x57", [0x4118] = "\xc2\x58",
  [0x4119] = "\xc2\x59", [0x411a] = "\xc2\x5a", [0x411b] = "\xc2\x5b",
  [0x411c] = "\xc2\x5c", [0x411d] = "\xc2\x5d", [0x411e] = "\xc2\x5e",
  [0x411f] = "\xc2\x5f", [0x4120] = "\xc2\x60", [0x4121] = "\xc2\x61",
  [0x4122] = "\xc2\x62", [0x4123] = "\xc2\x63", [0x4124] = "\xc2\x64",
  [0x4125] = "\xc2\x65", [0x4126] = "\xc2\x66", [0x4127] = "\xc2\x67",
  [0x4128] = "\xc2\x68", [0x4129] = "\xc2\x69", [0x412a] = "\xc2\x6a",
  [0x412b] = "\xc2\x6b", [0x412c] = "\xc2\x6c", [0x412d] = "\xc2\x6d",
  [0x412e] = "\xc2\x6e", [0x412f] = "\xc2\x6f", [0x4130] = "\xc2\x70",
  [0x4131] = "\xc2\x71", [0x4132] = "\xc2\x72", [0x4133] = "\xc2\x73",
  [0x4134] = "\xc2\x74", [0x4135] = "\xc2\x75", [0x4136] = "\xc2\x76",
  [0x4137] = "\xc2\x77", [0x4138] = "\xc2\x78", [0x4139] = "\xc2\x79",
  [0x413a] = "\xc2\x7a", [0x413b] = "\xc2\x7b", [0x413c] = "\xc2\x7c",
  [0x413d] = "\xc2\x7d", [0x413e] = "\xc2\x7e", [0x4140] = "\xc2\x80",
  [0x4141] = "\xc2\x81", [0x4142] = "\xc2\x82", [0x4143] = "\xc2\x83",
  [0x4144] = "\xc2\x84", [0x4145] = "\xc2\x85", [0x4146] = "\xc2\x86",
  [0x4147] = "\xc2\x87", [0x4148] = "\xc2\x88", [0x4149] = "\xc2\x89",
  [0x414a] = "\xc2\x8a", [0x414b] = "\xc2\x8b", [0x414c] = "\xc2\x8c",
  [0x414d] = "\xc2\x8d", [0x414e] = "\xc2\x8e", [0x414f] = "\xc2\x8f",
  [0x4150] = "\xc2\x90", [0x4151] = "\xc2\x91", [0x4152] = "\xc2\x92",
  [0x4153] = "\xc2\x93", [0x4154] = "\xc2\x94", [0x4155] = "\xc2\x95",
  [0x4156] = "\xc2\x96", [0x4157] = "\xc2\x97", [0x4158] = "\xc2\x98",
  [0x4159] = "\xc2\x99", [0x415a] = "\xc2\x9a", [0x415b] = "\xc2\x9b",
  [0x415c] = "\xc2\x9c", [0x415d] = "\xc2\x9d", [0x415e] = "\xc2\x9e",
  [0x415f] = "\xc2\x9f", [0x4160] = "\xc2\xa0", [0x4161] = "\xc2\xa1",
  [0x4162] = "\xc2\xa2", [0x4163] = "\xc2\xa3", [0x4164] = "\xc2\xa4",
  [0x4165] = "\xc2\xa5", [0x4166] = "\xc2\xa6", [0x4167] = "\xc2\xa7",
  [0x4168] = "\xc2\xa8", [0x4169] = "\xc2\xa9", [0x416a] = "\xc2\xaa",
  [0x416b] = "\xc2\xab", [0x416c] = "\xc2\xac", [0x416d] = "\xc2\xad",
  [0x416e] = "\xc2\xae", [0x416f] = "\xc2\xaf", [0x4170] = "\xc2\xb0",
  [0x4171] = "\xc2\xb1", [0x4172] = "\xc2\xb2", [0x4173] = "\xc2\xb3",
  [0x4174] = "\xc2\xb4", [0x4175] = "\xc2\xb5", [0x4176] = "\xc2\xb6",
  [0x4177] = "\xc2\xb7", [0x4178] = "\xc2\xb8", [0x4179] = "\xc2\xb9",
  [0x417a] = "\xc2\xba", [0x417b] = "\xc2\xbb", [0x417c] = "\xc2\xbc",
  [0x417d] = "\xc2\xbd", [0x417e] = "\xc2\xbe", [0x417f] = "\xc2\xbf",
  [0x4180] = "\xc2\xc0", [0x4181] = "\xc2\xc1", [0x4182] = "\xc2\xc2",
  [0x4183] = "\xc2\xc3", [0x4184] = "\xc2\xc4", [0x4185] = "\xc2\xc5",
  [0x4186] = "\xc2\xc6", [0x4187] = "\xc2\xc7", [0x4188] = "\xc2\xc8",
  [0x4189] = "\xc2\xc9", [0x418a] = "\xc2\xca", [0x418b] = "\xc2\xcb",
  [0x418c] = "\xc2\xcc", [0x418d] = "\xc2\xcd", [0x418e] = "\xc2\xce",
  [0x418f] = "\xc2\xcf", [0x4190] = "\xc2\xd0", [0x4191] = "\xc2\xd1",
  [0x4192] = "\xc2\xd2", [0x4193] = "\xc2\xd3", [0x4194] = "\xc2\xd4",
  [0x4195] = "\xc2\xd5", [0x4196] = "\xc2\xd6", [0x4197] = "\xc2\xd7",
  [0x4198] = "\xc2\xd8", [0x4199] = "\xc2\xd9", [0x419a] = "\xc2\xda",
  [0x419b] = "\xc2\xdb", [0x419c] = "\xc2\xdc", [0x419d] = "\xc2\xdd",
  [0x419e] = "\xc2\xde", [0x419f] = "\xc2\xdf", [0x41a0] = "\xc2\xe0",
  [0x41a1] = "\xc2\xe1", [0x41a2] = "\xc2\xe2", [0x41a3] = "\xc2\xe3",
  [0x41a4] = "\xc2\xe4", [0x41a5] = "\xc2\xe5", [0x41a6] = "\xc2\xe6",
  [0x41a7] = "\xc2\xe7", [0x41a8] = "\xc2\xe8", [0x41a9] = "\xc2\xe9",
  [0x41aa] = "\xc2\xea", [0x41ab] = "\xc2\xeb", [0x41ac] = "\xc2\xec",
  [0x41ad] = "\xc2\xed", [0x41ae] = "\xc2\xee", [0x41af] = "\xc2\xef",
  [0x41b0] = "\xc2\xf0", [0x41b1] = "\xc2\xf1", [0x41b2] = "\xc2\xf2",
  [0x41b3] = "\xc2\xf3", [0x41b4] = "\xc2\xf4", [0x41b5] = "\xc2\xf5",
  [0x41b6] = "\xc2\xf6", [0x41b7] = "\xc2\xf7", [0x41b8] = "\xc2\xf8",
  [0x41b9] = "\xc2\xf9", [0x41ba] = "\xc2\xfa", [0x41bb] = "\xc2\xfb",
  [0x41bc] = "\xc2\xfc", [0x41bd] = "\xc2\xfd", [0x41be] = "\xc2\xfe",
  [0x4200] = "\xc3\x40", [0x4201] = "\xc3\x41", [0x4202] = "\xc3\x42",
  [0x4203] = "\xc3\x43", [0x4204] = "\xc3\x44", [0x4205] = "\xc3\x45",
  [0x4206] = "\xc3\x46", [0x4207] = "\xc3\x47", [0x4208] = "\xc3\x48",
  [0x4209] = "\xc3\x49", [0x420a] = "\xc3\x4a", [0x420b] = "\xc3\x4b",
  [0x420c] = "\xc3\x4c", [0x420d] = "\xc3\x4d", [0x420e] = "\xc3\x4e",
  [0x420f] = "\xc3\x4f", [0x4210] = "\xc3\x50", [0x4211] = "\xc3\x51",
  [0x4212] = "\xc3\x52", [0x4213] = "\xc3\x53", [0x4214] = "\xc3\x54",
  [0x4215] = "\xc3\x55", [0x4216] = "\xc3\x56", [0x4217] = "\xc3\x57",
  [0x4218] = "\xc3\x58", [0x4219] = "\xc3\x59", [0x421a] = "\xc3\x5a",
  [0x421b] = "\xc3\x5b", [0x421c] = "\xc3\x5c", [0x421d] = "\xc3\x5d",
  [0x421e] = "\xc3\x5e", [0x421f] = "\xc3\x5f", [0x4220] = "\xc3\x60",
  [0x4221] = "\xc3\x61", [0x4222] = "\xc3\x62", [0x4223] = "\xc3\x63",
  [0x4224] = "\xc3\x64", [0x4225] = "\xc3\x65", [0x4226] = "\xc3\x66",
  [0x4227] = "\xc3\x67", [0x4228] = "\xc3\x68", [0x4229] = "\xc3\x69",
  [0x422a] = "\xc3\x6a", [0x422b] = "\xc3\x6b", [0x422c] = "\xc3\x6c",
  [0x422d] = "\xc3\x6d", [0x422e] = "\xc3\x6e", [0x422f] = "\xc3\x6f",
  [0x4230] = "\xc3\x70", [0x4231] = "\xc3\x71", [0x4232] = "\xc3\x72",
  [0x4233] = "\xc3\x73", [0x4234] = "\xc3\x74", [0x4235] = "\xc3\x75",
  [0x4236] = "\xc3\x76", [0x4237] = "\xc3\x77", [0x4238] = "\xc3\x78",
  [0x4239] = "\xc3\x79", [0x423a] = "\xc3\x7a", [0x423b] = "\xc3\x7b",
  [0x423c] = "\xc3\x7c", [0x423d] = "\xc3\x7d", [0x423e] = "\xc3\x7e",
  [0x4240] = "\xc3\x80", [0x4241] = "\xc3\x81", [0x4242] = "\xc3\x82",
  [0x4243] = "\xc3\x83", [0x4244] = "\xc3\x84", [0x4245] = "\xc3\x85",
  [0x4246] = "\xc3\x86", [0x4247] = "\xc3\x87", [0x4248] = "\xc3\x88",
  [0x4249] = "\xc3\x89", [0x424a] = "\xc3\x8a", [0x424b] = "\xc3\x8b",
  [0x424c] = "\xc3\x8c", [0x424d] = "\xc3\x8d", [0x424e] = "\xc3\x8e",
  [0x424f] = "\xc3\x8f", [0x4250] = "\xc3\x90", [0x4251] = "\xc3\x91",
  [0x4252] = "\xc3\x92", [0x4253] = "\xc3\x93", [0x4254] = "\xc3\x94",
  [0x4255] = "\xc3\x95", [0x4256] = "\xc3\x96", [0x4257] = "\xc3\x97",
  [0x4258] = "\xc3\x98", [0x4259] = "\xc3\x99", [0x425a] = "\xc3\x9a",
  [0x425b] = "\xc3\x9b", [0x425c] = "\xc3\x9c", [0x425d] = "\xc3\x9d",
  [0x425e] = "\xc3\x9e", [0x425f] = "\xc3\x9f", [0x4260] = "\xc3\xa0",
  [0x4261] = "\xc3\xa1", [0x4262] = "\xc3\xa2", [0x4263] = "\xc3\xa3",
  [0x4264] = "\xc3\xa4", [0x4265] = "\xc3\xa5", [0x4266] = "\xc3\xa6",
  [0x4267] = "\xc3\xa7", [0x4268] = "\xc3\xa8", [0x4269] = "\xc3\xa9",
  [0x426a] = "\xc3\xaa", [0x426b] = "\xc3\xab", [0x426c] = "\xc3\xac",
  [0x426d] = "\xc3\xad", [0x426e] = "\xc3\xae", [0x426f] = "\xc3\xaf",
  [0x4270] = "\xc3\xb0", [0x4271] = "\xc3\xb1", [0x4272] = "\xc3\xb2",
  [0x4273] = "\xc3\xb3", [0x4274] = "\xc3\xb4", [0x4275] = "\xc3\xb5",
  [0x4276] = "\xc3\xb6", [0x4277] = "\xc3\xb7", [0x4278] = "\xc3\xb8",
  [0x4279] = "\xc3\xb9", [0x427a] = "\xc3\xba", [0x427b] = "\xc3\xbb",
  [0x427c] = "\xc3\xbc", [0x427d] = "\xc3\xbd", [0x427e] = "\xc3\xbe",
  [0x427f] = "\xc3\xbf", [0x4280] = "\xc3\xc0", [0x4281] = "\xc3\xc1",
  [0x4282] = "\xc3\xc2", [0x4283] = "\xc3\xc3", [0x4284] = "\xc3\xc4",
  [0x4285] = "\xc3\xc5", [0x4286] = "\xc3\xc6", [0x4287] = "\xc3\xc7",
  [0x4288] = "\xc3\xc8", [0x4289] = "\xc3\xc9", [0x428a] = "\xc3\xca",
  [0x428b] = "\xc3\xcb", [0x428c] = "\xc3\xcc", [0x428d] = "\xc3\xcd",
  [0x428e] = "\xc3\xce", [0x428f] = "\xc3\xcf", [0x4290] = "\xc3\xd0",
  [0x4291] = "\xc3\xd1", [0x4292] = "\xc3\xd2", [0x4293] = "\xc3\xd3",
  [0x4294] = "\xc3\xd4", [0x4295] = "\xc3\xd5", [0x4296] = "\xc3\xd6",
  [0x4297] = "\xc3\xd7", [0x4298] = "\xc3\xd8", [0x4299] = "\xc3\xd9",
  [0x429a] = "\xc3\xda", [0x429b] = "\xc3\xdb", [0x429c] = "\xc3\xdc",
  [0x429d] = "\xc3\xdd", [0x429e] = "\xc3\xde", [0x429f] = "\xc3\xdf",
  [0x42a0] = "\xc3\xe0", [0x42a1] = "\xc3\xe1", [0x42a2] = "\xc3\xe2",
  [0x42a3] = "\xc3\xe3", [0x42a4] = "\xc3\xe4", [0x42a5] = "\xc3\xe5",
  [0x42a6] = "\xc3\xe6", [0x42a7] = "\xc3\xe7", [0x42a8] = "\xc3\xe8",
  [0x42a9] = "\xc3\xe9", [0x42aa] = "\xc3\xea", [0x42ab] = "\xc3\xeb",
  [0x42ac] = "\xc3\xec", [0x42ad] = "\xc3\xed", [0x42ae] = "\xc3\xee",
  [0x42af] = "\xc3\xef", [0x42b0] = "\xc3\xf0", [0x42b1] = "\xc3\xf1",
  [0x42b2] = "\xc3\xf2", [0x42b3] = "\xc3\xf3", [0x42b4] = "\xc3\xf4",
  [0x42b5] = "\xc3\xf5", [0x42b6] = "\xc3\xf6", [0x42b7] = "\xc3\xf7",
  [0x42b8] = "\xc3\xf8", [0x42b9] = "\xc3\xf9", [0x42ba] = "\xc3\xfa",
  [0x42bb] = "\xc3\xfb", [0x42bc] = "\xc3\xfc", [0x42bd] = "\xc3\xfd",
  [0x42be] = "\xc3\xfe", [0x4300] = "\xc4\x40", [0x4301] = "\xc4\x41",
  [0x4302] = "\xc4\x42", [0x4303] = "\xc4\x43", [0x4304] = "\xc4\x44",
  [0x4305] = "\xc4\x45", [0x4306] = "\xc4\x46", [0x4307] = "\xc4\x47",
  [0x4308] = "\xc4\x48", [0x4309] = "\xc4\x49", [0x430a] = "\xc4\x4a",
  [0x430b] = "\xc4\x4b", [0x430c] = "\xc4\x4c", [0x430d] = "\xc4\x4d",
  [0x430e] = "\xc4\x4e", [0x430f] = "\xc4\x4f", [0x4310] = "\xc4\x50",
  [0x4311] = "\xc4\x51", [0x4312] = "\xc4\x52", [0x4313] = "\xc4\x53",
  [0x4314] = "\xc4\x54", [0x4315] = "\xc4\x55", [0x4316] = "\xc4\x56",
  [0x4317] = "\xc4\x57", [0x4318] = "\xc4\x58", [0x4319] = "\xc4\x59",
  [0x431a] = "\xc4\x5a", [0x431b] = "\xc4\x5b", [0x431c] = "\xc4\x5c",
  [0x431d] = "\xc4\x5d", [0x431e] = "\xc4\x5e", [0x431f] = "\xc4\x5f",
  [0x4320] = "\xc4\x60", [0x4321] = "\xc4\x61", [0x4322] = "\xc4\x62",
  [0x4323] = "\xc4\x63", [0x4324] = "\xc4\x64", [0x4325] = "\xc4\x65",
  [0x4326] = "\xc4\x66", [0x4327] = "\xc4\x67", [0x4328] = "\xc4\x68",
  [0x4329] = "\xc4\x69", [0x432a] = "\xc4\x6a", [0x432b] = "\xc4\x6b",
  [0x432c] = "\xc4\x6c", [0x432d] = "\xc4\x6d", [0x432e] = "\xc4\x6e",
  [0x432f] = "\xc4\x6f", [0x4330] = "\xc4\x70", [0x4331] = "\xc4\x71",
  [0x4332] = "\xc4\x72", [0x4333] = "\xc4\x73", [0x4334] = "\xc4\x74",
  [0x4335] = "\xc4\x75", [0x4336] = "\xc4\x76", [0x4337] = "\xc4\x77",
  [0x4338] = "\xc4\x78", [0x4339] = "\xc4\x79", [0x433a] = "\xc4\x7a",
  [0x433b] = "\xc4\x7b", [0x433c] = "\xc4\x7c", [0x433d] = "\xc4\x7d",
  [0x433e] = "\xc4\x7e", [0x4340] = "\xc4\x80", [0x4341] = "\xc4\x81",
  [0x4342] = "\xc4\x82", [0x4343] = "\xc4\x83", [0x4344] = "\xc4\x84",
  [0x4345] = "\xc4\x85", [0x4346] = "\xc4\x86", [0x4347] = "\xc4\x87",
  [0x4348] = "\xc4\x88", [0x4349] = "\xc4\x89", [0x434a] = "\xc4\x8a",
  [0x434b] = "\xc4\x8b", [0x434c] = "\xc4\x8c", [0x434d] = "\xc4\x8d",
  [0x434e] = "\xc4\x8e", [0x434f] = "\xc4\x8f", [0x4350] = "\xc4\x90",
  [0x4351] = "\xc4\x91", [0x4352] = "\xc4\x92", [0x4353] = "\xc4\x93",
  [0x4354] = "\xc4\x94", [0x4355] = "\xc4\x95", [0x4356] = "\xc4\x96",
  [0x4357] = "\xc4\x97", [0x4358] = "\xc4\x98", [0x4359] = "\xc4\x99",
  [0x435a] = "\xc4\x9a", [0x435b] = "\xc4\x9b", [0x435c] = "\xc4\x9c",
  [0x435d] = "\xc4\x9d", [0x435e] = "\xc4\x9e", [0x435f] = "\xc4\x9f",
  [0x4360] = "\xc4\xa0", [0x4361] = "\xc4\xa1", [0x4362] = "\xc4\xa2",
  [0x4363] = "\xc4\xa3", [0x4364] = "\xc4\xa4", [0x4365] = "\xc4\xa5",
  [0x4366] = "\xc4\xa6", [0x4367] = "\xc4\xa7", [0x4368] = "\xc4\xa8",
  [0x4369] = "\xc4\xa9", [0x436a] = "\xc4\xaa", [0x436b] = "\xc4\xab",
  [0x436c] = "\xc4\xac", [0x436d] = "\xc4\xad", [0x436e] = "\xc4\xae",
  [0x436f] = "\xc4\xaf", [0x4370] = "\xc4\xb0", [0x4371] = "\xc4\xb1",
  [0x4372] = "\xc4\xb2", [0x4373] = "\xc4\xb3", [0x4374] = "\xc4\xb4",
  [0x4375] = "\xc4\xb5", [0x4376] = "\xc4\xb6", [0x4377] = "\xc4\xb7",
  [0x4378] = "\xc4\xb8", [0x4379] = "\xc4\xb9", [0x437a] = "\xc4\xba",
  [0x437b] = "\xc4\xbb", [0x437c] = "\xc4\xbc", [0x437d] = "\xc4\xbd",
  [0x437e] = "\xc4\xbe", [0x437f] = "\xc4\xbf", [0x4380] = "\xc4\xc0",
  [0x4381] = "\xc4\xc1", [0x4382] = "\xc4\xc2", [0x4383] = "\xc4\xc3",
  [0x4384] = "\xc4\xc4", [0x4385] = "\xc4\xc5", [0x4386] = "\xc4\xc6",
  [0x4387] = "\xc4\xc7", [0x4388] = "\xc4\xc8", [0x4389] = "\xc4\xc9",
  [0x438a] = "\xc4\xca", [0x438b] = "\xc4\xcb", [0x438c] = "\xc4\xcc",
  [0x438d] = "\xc4\xcd", [0x438e] = "\xc4\xce", [0x438f] = "\xc4\xcf",
  [0x4390] = "\xc4\xd0", [0x4391] = "\xc4\xd1", [0x4392] = "\xc4\xd2",
  [0x4393] = "\xc4\xd3", [0x4394] = "\xc4\xd4", [0x4395] = "\xc4\xd5",
  [0x4396] = "\xc4\xd6", [0x4397] = "\xc4\xd7", [0x4398] = "\xc4\xd8",
  [0x4399] = "\xc4\xd9", [0x439a] = "\xc4\xda", [0x439b] = "\xc4\xdb",
  [0x439c] = "\xc4\xdc", [0x439d] = "\xc4\xdd", [0x439e] = "\xc4\xde",
  [0x439f] = "\xc4\xdf", [0x43a0] = "\xc4\xe0", [0x43a1] = "\xc4\xe1",
  [0x43a2] = "\xc4\xe2", [0x43a3] = "\xc4\xe3", [0x43a4] = "\xc4\xe4",
  [0x43a5] = "\xc4\xe5", [0x43a6] = "\xc4\xe6", [0x43a7] = "\xc4\xe7",
  [0x43a8] = "\xc4\xe8", [0x43a9] = "\xc4\xe9", [0x43aa] = "\xc4\xea",
  [0x43ab] = "\xc4\xeb", [0x43ac] = "\xc4\xec", [0x43ad] = "\xc4\xed",
  [0x43ae] = "\xc4\xee", [0x43af] = "\xc4\xef", [0x43b0] = "\xc4\xf0",
  [0x43b1] = "\xc4\xf1", [0x43b2] = "\xc4\xf2", [0x43b3] = "\xc4\xf3",
  [0x43b4] = "\xc4\xf4", [0x43b5] = "\xc4\xf5", [0x43b6] = "\xc4\xf6",
  [0x43b7] = "\xc4\xf7", [0x43b8] = "\xc4\xf8", [0x43b9] = "\xc4\xf9",
  [0x43ba] = "\xc4\xfa", [0x43bb] = "\xc4\xfb", [0x43bc] = "\xc4\xfc",
  [0x43bd] = "\xc4\xfd", [0x43be] = "\xc4\xfe", [0x4400] = "\xc5\x40",
  [0x4401] = "\xc5\x41", [0x4402] = "\xc5\x42", [0x4403] = "\xc5\x43",
  [0x4404] = "\xc5\x44", [0x4405] = "\xc5\x45", [0x4406] = "\xc5\x46",
  [0x4407] = "\xc5\x47", [0x4408] = "\xc5\x48", [0x4409] = "\xc5\x49",
  [0x440a] = "\xc5\x4a", [0x440b] = "\xc5\x4b", [0x440c] = "\xc5\x4c",
  [0x440d] = "\xc5\x4d", [0x440e] = "\xc5\x4e", [0x440f] = "\xc5\x4f",
  [0x4410] = "\xc5\x50", [0x4411] = "\xc5\x51", [0x4412] = "\xc5\x52",
  [0x4413] = "\xc5\x53", [0x4414] = "\xc5\x54", [0x4415] = "\xc5\x55",
  [0x4416] = "\xc5\x56", [0x4417] = "\xc5\x57", [0x4418] = "\xc5\x58",
  [0x4419] = "\xc5\x59", [0x441a] = "\xc5\x5a", [0x441b] = "\xc5\x5b",
  [0x441c] = "\xc5\x5c", [0x441d] = "\xc5\x5d", [0x441e] = "\xc5\x5e",
  [0x441f] = "\xc5\x5f", [0x4420] = "\xc5\x60", [0x4421] = "\xc5\x61",
  [0x4422] = "\xc5\x62", [0x4423] = "\xc5\x63", [0x4424] = "\xc5\x64",
  [0x4425] = "\xc5\x65", [0x4426] = "\xc5\x66", [0x4427] = "\xc5\x67",
  [0x4428] = "\xc5\x68", [0x4429] = "\xc5\x69", [0x442a] = "\xc5\x6a",
  [0x442b] = "\xc5\x6b", [0x442c] = "\xc5\x6c", [0x442d] = "\xc5\x6d",
  [0x442e] = "\xc5\x6e", [0x442f] = "\xc5\x6f", [0x4430] = "\xc5\x70",
  [0x4431] = "\xc5\x71", [0x4432] = "\xc5\x72", [0x4433] = "\xc5\x73",
  [0x4434] = "\xc5\x74", [0x4435] = "\xc5\x75", [0x4436] = "\xc5\x76",
  [0x4437] = "\xc5\x77", [0x4438] = "\xc5\x78", [0x4439] = "\xc5\x79",
  [0x443a] = "\xc5\x7a", [0x443b] = "\xc5\x7b", [0x443c] = "\xc5\x7c",
  [0x443d] = "\xc5\x7d", [0x443e] = "\xc5\x7e", [0x4440] = "\xc5\x80",
  [0x4441] = "\xc5\x81", [0x4442] = "\xc5\x82", [0x4443] = "\xc5\x83",
  [0x4444] = "\xc5\x84", [0x4445] = "\xc5\x85", [0x4446] = "\xc5\x86",
  [0x4447] = "\xc5\x87", [0x4448] = "\xc5\x88", [0x4449] = "\xc5\x89",
  [0x444a] = "\xc5\x8a", [0x444b] = "\xc5\x8b", [0x444c] = "\xc5\x8c",
  [0x444d] = "\xc5\x8d", [0x444e] = "\xc5\x8e", [0x444f] = "\xc5\x8f",
  [0x4450] = "\xc5\x90", [0x4451] = "\xc5\x91", [0x4452] = "\xc5\x92",
  [0x4453] = "\xc5\x93", [0x4454] = "\xc5\x94", [0x4455] = "\xc5\x95",
  [0x4456] = "\xc5\x96", [0x4457] = "\xc5\x97", [0x4458] = "\xc5\x98",
  [0x4459] = "\xc5\x99", [0x445a] = "\xc5\x9a", [0x445b] = "\xc5\x9b",
  [0x445c] = "\xc5\x9c", [0x445d] = "\xc5\x9d", [0x445e] = "\xc5\x9e",
  [0x445f] = "\xc5\x9f", [0x4460] = "\xc5\xa0", [0x4461] = "\xc5\xa1",
  [0x4462] = "\xc5\xa2", [0x4463] = "\xc5\xa3", [0x4464] = "\xc5\xa4",
  [0x4465] = "\xc5\xa5", [0x4466] = "\xc5\xa6", [0x4467] = "\xc5\xa7",
  [0x4468] = "\xc5\xa8", [0x4469] = "\xc5\xa9", [0x446a] = "\xc5\xaa",
  [0x446b] = "\xc5\xab", [0x446c] = "\xc5\xac", [0x446d] = "\xc5\xad",
  [0x446e] = "\xc5\xae", [0x446f] = "\xc5\xaf", [0x4470] = "\xc5\xb0",
  [0x4471] = "\xc5\xb1", [0x4472] = "\xc5\xb2", [0x4473] = "\xc5\xb3",
  [0x4474] = "\xc5\xb4", [0x4475] = "\xc5\xb5", [0x4476] = "\xc5\xb6",
  [0x4477] = "\xc5\xb7", [0x4478] = "\xc5\xb8", [0x4479] = "\xc5\xb9",
  [0x447a] = "\xc5\xba", [0x447b] = "\xc5\xbb", [0x447c] = "\xc5\xbc",
  [0x447d] = "\xc5\xbd", [0x447e] = "\xc5\xbe", [0x447f] = "\xc5\xbf",
  [0x4480] = "\xc5\xc0", [0x4481] = "\xc5\xc1", [0x4482] = "\xc5\xc2",
  [0x4483] = "\xc5\xc3", [0x4484] = "\xc5\xc4", [0x4485] = "\xc5\xc5",
  [0x4486] = "\xc5\xc6", [0x4487] = "\xc5\xc7", [0x4488] = "\xc5\xc8",
  [0x4489] = "\xc5\xc9", [0x448a] = "\xc5\xca", [0x448b] = "\xc5\xcb",
  [0x448c] = "\xc5\xcc", [0x448d] = "\xc5\xcd", [0x448e] = "\xc5\xce",
  [0x448f] = "\xc5\xcf", [0x4490] = "\xc5\xd0", [0x4491] = "\xc5\xd1",
  [0x4492] = "\xc5\xd2", [0x4493] = "\xc5\xd3", [0x4494] = "\xc5\xd4",
  [0x4495] = "\xc5\xd5", [0x4496] = "\xc5\xd6", [0x4497] = "\xc5\xd7",
  [0x4498] = "\xc5\xd8", [0x4499] = "\xc5\xd9", [0x449a] = "\xc5\xda",
  [0x449b] = "\xc5\xdb", [0x449c] = "\xc5\xdc", [0x449d] = "\xc5\xdd",
  [0x449e] = "\xc5\xde", [0x449f] = "\xc5\xdf", [0x44a0] = "\xc5\xe0",
  [0x44a1] = "\xc5\xe1", [0x44a2] = "\xc5\xe2", [0x44a3] = "\xc5\xe3",
  [0x44a4] = "\xc5\xe4", [0x44a5] = "\xc5\xe5", [0x44a6] = "\xc5\xe6",
  [0x44a7] = "\xc5\xe7", [0x44a8] = "\xc5\xe8", [0x44a9] = "\xc5\xe9",
  [0x44aa] = "\xc5\xea", [0x44ab] = "\xc5\xeb", [0x44ac] = "\xc5\xec",
  [0x44ad] = "\xc5\xed", [0x44ae] = "\xc5\xee", [0x44af] = "\xc5\xef",
  [0x44b0] = "\xc5\xf0", [0x44b1] = "\xc5\xf1", [0x44b2] = "\xc5\xf2",
  [0x44b3] = "\xc5\xf3", [0x44b4] = "\xc5\xf4", [0x44b5] = "\xc5\xf5",
  [0x44b6] = "\xc5\xf6", [0x44b7] = "\xc5\xf7", [0x44b8] = "\xc5\xf8",
  [0x44b9] = "\xc5\xf9", [0x44ba] = "\xc5\xfa", [0x44bb] = "\xc5\xfb",
  [0x44bc] = "\xc5\xfc", [0x44bd] = "\xc5\xfd", [0x44be] = "\xc5\xfe",
  [0x4500] = "\xc6\x40", [0x4501] = "\xc6\x41", [0x4502] = "\xc6\x42",
  [0x4503] = "\xc6\x43", [0x4504] = "\xc6\x44", [0x4505] = "\xc6\x45",
  [0x4506] = "\xc6\x46", [0x4507] = "\xc6\x47", [0x4508] = "\xc6\x48",
  [0x4509] = "\xc6\x49", [0x450a] = "\xc6\x4a", [0x450b] = "\xc6\x4b",
  [0x450c] = "\xc6\x4c", [0x450d] = "\xc6\x4d", [0x450e] = "\xc6\x4e",
  [0x450f] = "\xc6\x4f", [0x4510] = "\xc6\x50", [0x4511] = "\xc6\x51",
  [0x4512] = "\xc6\x52", [0x4513] = "\xc6\x53", [0x4514] = "\xc6\x54",
  [0x4515] = "\xc6\x55", [0x4516] = "\xc6\x56", [0x4517] = "\xc6\x57",
  [0x4518] = "\xc6\x58", [0x4519] = "\xc6\x59", [0x451a] = "\xc6\x5a",
  [0x451b] = "\xc6\x5b", [0x451c] = "\xc6\x5c", [0x451d] = "\xc6\x5d",
  [0x451e] = "\xc6\x5e", [0x451f] = "\xc6\x5f", [0x4520] = "\xc6\x60",
  [0x4521] = "\xc6\x61", [0x4522] = "\xc6\x62", [0x4523] = "\xc6\x63",
  [0x4524] = "\xc6\x64", [0x4525] = "\xc6\x65", [0x4526] = "\xc6\x66",
  [0x4527] = "\xc6\x67", [0x4528] = "\xc6\x68", [0x4529] = "\xc6\x69",
  [0x452a] = "\xc6\x6a", [0x452b] = "\xc6\x6b", [0x452c] = "\xc6\x6c",
  [0x452d] = "\xc6\x6d", [0x452e] = "\xc6\x6e", [0x452f] = "\xc6\x6f",
  [0x4530] = "\xc6\x70", [0x4531] = "\xc6\x71", [0x4532] = "\xc6\x72",
  [0x4533] = "\xc6\x73", [0x4534] = "\xc6\x74", [0x4535] = "\xc6\x75",
  [0x4536] = "\xc6\x76", [0x4537] = "\xc6\x77", [0x4538] = "\xc6\x78",
  [0x4539] = "\xc6\x79", [0x453a] = "\xc6\x7a", [0x453b] = "\xc6\x7b",
  [0x453c] = "\xc6\x7c", [0x453d] = "\xc6\x7d", [0x453e] = "\xc6\x7e",
  [0x4540] = "\xc6\x80", [0x4541] = "\xc6\x81", [0x4542] = "\xc6\x82",
  [0x4543] = "\xc6\x83", [0x4544] = "\xc6\x84", [0x4545] = "\xc6\x85",
  [0x4546] = "\xc6\x86", [0x4547] = "\xc6\x87", [0x4548] = "\xc6\x88",
  [0x4549] = "\xc6\x89", [0x454a] = "\xc6\x8a", [0x454b] = "\xc6\x8b",
  [0x454c] = "\xc6\x8c", [0x454d] = "\xc6\x8d", [0x454e] = "\xc6\x8e",
  [0x454f] = "\xc6\x8f", [0x4550] = "\xc6\x90", [0x4551] = "\xc6\x91",
  [0x4552] = "\xc6\x92", [0x4553] = "\xc6\x93", [0x4554] = "\xc6\x94",
  [0x4555] = "\xc6\x95", [0x4556] = "\xc6\x96", [0x4557] = "\xc6\x97",
  [0x4558] = "\xc6\x98", [0x4559] = "\xc6\x99", [0x455a] = "\xc6\x9a",
  [0x455b] = "\xc6\x9b", [0x455c] = "\xc6\x9c", [0x455d] = "\xc6\x9d",
  [0x455e] = "\xc6\x9e", [0x455f] = "\xc6\x9f", [0x4560] = "\xc6\xa0",
  [0x4561] = "\xc6\xa1", [0x4562] = "\xc6\xa2", [0x4563] = "\xc6\xa3",
  [0x4564] = "\xc6\xa4", [0x4565] = "\xc6\xa5", [0x4566] = "\xc6\xa6",
  [0x4567] = "\xc6\xa7", [0x4568] = "\xc6\xa8", [0x4569] = "\xc6\xa9",
  [0x456a] = "\xc6\xaa", [0x456b] = "\xc6\xab", [0x456c] = "\xc6\xac",
  [0x456d] = "\xc6\xad", [0x456e] = "\xc6\xae", [0x456f] = "\xc6\xaf",
  [0x4570] = "\xc6\xb0", [0x4571] = "\xc6\xb1", [0x4572] = "\xc6\xb2",
  [0x4573] = "\xc6\xb3", [0x4574] = "\xc6\xb4", [0x4575] = "\xc6\xb5",
  [0x4576] = "\xc6\xb6", [0x4577] = "\xc6\xb7", [0x4578] = "\xc6\xb8",
  [0x4579] = "\xc6\xb9", [0x457a] = "\xc6\xba", [0x457b] = "\xc6\xbb",
  [0x457c] = "\xc6\xbc", [0x457d] = "\xc6\xbd", [0x457e] = "\xc6\xbe",
  [0x457f] = "\xc6\xbf", [0x4580] = "\xc6\xc0", [0x4581] = "\xc6\xc1",
  [0x4582] = "\xc6\xc2", [0x4583] = "\xc6\xc3", [0x4584] = "\xc6\xc4",
  [0x4585] = "\xc6\xc5", [0x4586] = "\xc6\xc6", [0x4587] = "\xc6\xc7",
  [0x4588] = "\xc6\xc8", [0x4589] = "\xc6\xc9", [0x458a] = "\xc6\xca",
  [0x458b] = "\xc6\xcb", [0x458c] = "\xc6\xcc", [0x458d] = "\xc6\xcd",
  [0x458e] = "\xc6\xce", [0x458f] = "\xc6\xcf", [0x4590] = "\xc6\xd0",
  [0x4591] = "\xc6\xd1", [0x4592] = "\xc6\xd2", [0x4593] = "\xc6\xd3",
  [0x4594] = "\xc6\xd4", [0x4595] = "\xc6\xd5", [0x4596] = "\xc6\xd6",
  [0x4597] = "\xc6\xd7", [0x4598] = "\xc6\xd8", [0x4599] = "\xc6\xd9",
  [0x459a] = "\xc6\xda", [0x459b] = "\xc6\xdb", [0x459c] = "\xc6\xdc",
  [0x459d] = "\xc6\xdd", [0x459e] = "\xc6\xde", [0x459f] = "\xc6\xdf",
  [0x45a0] = "\xc6\xe0", [0x45a1] = "\xc6\xe1", [0x45a2] = "\xc6\xe2",
  [0x45a3] = "\xc6\xe3", [0x45a4] = "\xc6\xe4", [0x45a5] = "\xc6\xe5",
  [0x45a6] = "\xc6\xe6", [0x45a7] = "\xc6\xe7", [0x45a8] = "\xc6\xe8",
  [0x45a9] = "\xc6\xe9", [0x45aa] = "\xc6\xea", [0x45ab] = "\xc6\xeb",
  [0x45ac] = "\xc6\xec", [0x45ad] = "\xc6\xed", [0x45ae] = "\xc6\xee",
  [0x45af] = "\xc6\xef", [0x45b0] = "\xc6\xf0", [0x45b1] = "\xc6\xf1",
  [0x45b2] = "\xc6\xf2", [0x45b3] = "\xc6\xf3", [0x45b4] = "\xc6\xf4",
  [0x45b5] = "\xc6\xf5", [0x45b6] = "\xc6\xf6", [0x45b7] = "\xc6\xf7",
  [0x45b8] = "\xc6\xf8", [0x45b9] = "\xc6\xf9", [0x45ba] = "\xc6\xfa",
  [0x45bb] = "\xc6\xfb", [0x45bc] = "\xc6\xfc", [0x45bd] = "\xc6\xfd",
  [0x45be] = "\xc6\xfe", [0x4600] = "\xc7\x40", [0x4601] = "\xc7\x41",
  [0x4602] = "\xc7\x42", [0x4603] = "\xc7\x43", [0x4604] = "\xc7\x44",
  [0x4605] = "\xc7\x45", [0x4606] = "\xc7\x46", [0x4607] = "\xc7\x47",
  [0x4608] = "\xc7\x48", [0x4609] = "\xc7\x49", [0x460a] = "\xc7\x4a",
  [0x460b] = "\xc7\x4b", [0x460c] = "\xc7\x4c", [0x460d] = "\xc7\x4d",
  [0x460e] = "\xc7\x4e", [0x460f] = "\xc7\x4f", [0x4610] = "\xc7\x50",
  [0x4611] = "\xc7\x51", [0x4612] = "\xc7\x52", [0x4613] = "\xc7\x53",
  [0x4614] = "\xc7\x54", [0x4615] = "\xc7\x55", [0x4616] = "\xc7\x56",
  [0x4617] = "\xc7\x57", [0x4618] = "\xc7\x58", [0x4619] = "\xc7\x59",
  [0x461a] = "\xc7\x5a", [0x461b] = "\xc7\x5b", [0x461c] = "\xc7\x5c",
  [0x461d] = "\xc7\x5d", [0x461e] = "\xc7\x5e", [0x461f] = "\xc7\x5f",
  [0x4620] = "\xc7\x60", [0x4621] = "\xc7\x61", [0x4622] = "\xc7\x62",
  [0x4623] = "\xc7\x63", [0x4624] = "\xc7\x64", [0x4625] = "\xc7\x65",
  [0x4626] = "\xc7\x66", [0x4627] = "\xc7\x67", [0x4628] = "\xc7\x68",
  [0x4629] = "\xc7\x69", [0x462a] = "\xc7\x6a", [0x462b] = "\xc7\x6b",
  [0x462c] = "\xc7\x6c", [0x462d] = "\xc7\x6d", [0x462e] = "\xc7\x6e",
  [0x462f] = "\xc7\x6f", [0x4630] = "\xc7\x70", [0x4631] = "\xc7\x71",
  [0x4632] = "\xc7\x72", [0x4633] = "\xc7\x73", [0x4634] = "\xc7\x74",
  [0x4635] = "\xc7\x75", [0x4636] = "\xc7\x76", [0x4637] = "\xc7\x77",
  [0x4638] = "\xc7\x78", [0x4639] = "\xc7\x79", [0x463a] = "\xc7\x7a",
  [0x463b] = "\xc7\x7b", [0x463c] = "\xc7\x7c", [0x463d] = "\xc7\x7d",
  [0x463e] = "\xc7\x7e", [0x4640] = "\xc7\x80", [0x4641] = "\xc7\x81",
  [0x4642] = "\xc7\x82", [0x4643] = "\xc7\x83", [0x4644] = "\xc7\x84",
  [0x4645] = "\xc7\x85", [0x4646] = "\xc7\x86", [0x4647] = "\xc7\x87",
  [0x4648] = "\xc7\x88", [0x4649] = "\xc7\x89", [0x464a] = "\xc7\x8a",
  [0x464b] = "\xc7\x8b", [0x464c] = "\xc7\x8c", [0x464d] = "\xc7\x8d",
  [0x464e] = "\xc7\x8e", [0x464f] = "\xc7\x8f", [0x4650] = "\xc7\x90",
  [0x4651] = "\xc7\x91", [0x4652] = "\xc7\x92", [0x4653] = "\xc7\x93",
  [0x4654] = "\xc7\x94", [0x4655] = "\xc7\x95", [0x4656] = "\xc7\x96",
  [0x4657] = "\xc7\x97", [0x4658] = "\xc7\x98", [0x4659] = "\xc7\x99",
  [0x465a] = "\xc7\x9a", [0x465b] = "\xc7\x9b", [0x465c] = "\xc7\x9c",
  [0x465d] = "\xc7\x9d", [0x465e] = "\xc7\x9e", [0x465f] = "\xc7\x9f",
  [0x4660] = "\xc7\xa0", [0x4661] = "\xc7\xa1", [0x4662] = "\xc7\xa2",
  [0x4663] = "\xc7\xa3", [0x4664] = "\xc7\xa4", [0x4665] = "\xc7\xa5",
  [0x4666] = "\xc7\xa6", [0x4667] = "\xc7\xa7", [0x4668] = "\xc7\xa8",
  [0x4669] = "\xc7\xa9", [0x466a] = "\xc7\xaa", [0x466b] = "\xc7\xab",
  [0x466c] = "\xc7\xac", [0x466d] = "\xc7\xad", [0x466e] = "\xc7\xae",
  [0x466f] = "\xc7\xaf", [0x4670] = "\xc7\xb0", [0x4671] = "\xc7\xb1",
  [0x4672] = "\xc7\xb2", [0x4673] = "\xc7\xb3", [0x4674] = "\xc7\xb4",
  [0x4675] = "\xc7\xb5", [0x4676] = "\xc7\xb6", [0x4677] = "\xc7\xb7",
  [0x4678] = "\xc7\xb8", [0x4679] = "\xc7\xb9", [0x467a] = "\xc7\xba",
  [0x467b] = "\xc7\xbb", [0x467c] = "\xc7\xbc", [0x467d] = "\xc7\xbd",
  [0x467e] = "\xc7\xbe", [0x467f] = "\xc7\xbf", [0x4680] = "\xc7\xc0",
  [0x4681] = "\xc7\xc1", [0x4682] = "\xc7\xc2", [0x4683] = "\xc7\xc3",
  [0x4684] = "\xc7\xc4", [0x4685] = "\xc7\xc5", [0x4686] = "\xc7\xc6",
  [0x4687] = "\xc7\xc7", [0x4688] = "\xc7\xc8", [0x4689] = "\xc7\xc9",
  [0x468a] = "\xc7\xca", [0x468b] = "\xc7\xcb", [0x468c] = "\xc7\xcc",
  [0x468d] = "\xc7\xcd", [0x468e] = "\xc7\xce", [0x468f] = "\xc7\xcf",
  [0x4690] = "\xc7\xd0", [0x4691] = "\xc7\xd1", [0x4692] = "\xc7\xd2",
  [0x4693] = "\xc7\xd3", [0x4694] = "\xc7\xd4", [0x4695] = "\xc7\xd5",
  [0x4696] = "\xc7\xd6", [0x4697] = "\xc7\xd7", [0x4698] = "\xc7\xd8",
  [0x4699] = "\xc7\xd9", [0x469a] = "\xc7\xda", [0x469b] = "\xc7\xdb",
  [0x469c] = "\xc7\xdc", [0x469d] = "\xc7\xdd", [0x469e] = "\xc7\xde",
  [0x469f] = "\xc7\xdf", [0x46a0] = "\xc7\xe0", [0x46a1] = "\xc7\xe1",
  [0x46a2] = "\xc7\xe2", [0x46a3] = "\xc7\xe3", [0x46a4] = "\xc7\xe4",
  [0x46a5] = "\xc7\xe5", [0x46a6] = "\xc7\xe6", [0x46a7] = "\xc7\xe7",
  [0x46a8] = "\xc7\xe8", [0x46a9] = "\xc7\xe9", [0x46aa] = "\xc7\xea",
  [0x46ab] = "\xc7\xeb", [0x46ac] = "\xc7\xec", [0x46ad] = "\xc7\xed",
  [0x46ae] = "\xc7\xee", [0x46af] = "\xc7\xef", [0x46b0] = "\xc7\xf0",
  [0x46b1] = "\xc7\xf1", [0x46b2] = "\xc7\xf2", [0x46b3] = "\xc7\xf3",
  [0x46b4] = "\xc7\xf4", [0x46b5] = "\xc7\xf5", [0x46b6] = "\xc7\xf6",
  [0x46b7] = "\xc7\xf7", [0x46b8] = "\xc7\xf8", [0x46b9] = "\xc7\xf9",
  [0x46ba] = "\xc7\xfa", [0x46bb] = "\xc7\xfb", [0x46bc] = "\xc7\xfc",
  [0x46bd] = "\xc7\xfd", [0x46be] = "\xc7\xfe", [0x4700] = "\xc8\x40",
  [0x4701] = "\xc8\x41", [0x4702] = "\xc8\x42", [0x4703] = "\xc8\x43",
  [0x4704] = "\xc8\x44", [0x4705] = "\xc8\x45", [0x4706] = "\xc8\x46",
  [0x4707] = "\xc8\x47", [0x4708] = "\xc8\x48", [0x4709] = "\xc8\x49",
  [0x470a] = "\xc8\x4a", [0x470b] = "\xc8\x4b", [0x470c] = "\xc8\x4c",
  [0x470d] = "\xc8\x4d", [0x470e] = "\xc8\x4e", [0x470f] = "\xc8\x4f",
  [0x4710] = "\xc8\x50", [0x4711] = "\xc8\x51", [0x4712] = "\xc8\x52",
  [0x4713] = "\xc8\x53", [0x4714] = "\xc8\x54", [0x4715] = "\xc8\x55",
  [0x4716] = "\xc8\x56", [0x4717] = "\xc8\x57", [0x4718] = "\xc8\x58",
  [0x4719] = "\xc8\x59", [0x471a] = "\xc8\x5a", [0x471b] = "\xc8\x5b",
  [0x471c] = "\xc8\x5c", [0x471d] = "\xc8\x5d", [0x471e] = "\xc8\x5e",
  [0x471f] = "\xc8\x5f", [0x4720] = "\xc8\x60", [0x4721] = "\xc8\x61",
  [0x4722] = "\xc8\x62", [0x4723] = "\xc8\x63", [0x4724] = "\xc8\x64",
  [0x4725] = "\xc8\x65", [0x4726] = "\xc8\x66", [0x4727] = "\xc8\x67",
  [0x4728] = "\xc8\x68", [0x4729] = "\xc8\x69", [0x472a] = "\xc8\x6a",
  [0x472b] = "\xc8\x6b", [0x472c] = "\xc8\x6c", [0x472d] = "\xc8\x6d",
  [0x472e] = "\xc8\x6e", [0x472f] = "\xc8\x6f", [0x4730] = "\xc8\x70",
  [0x4731] = "\xc8\x71", [0x4732] = "\xc8\x72", [0x4733] = "\xc8\x73",
  [0x4734] = "\xc8\x74", [0x4735] = "\xc8\x75", [0x4736] = "\xc8\x76",
  [0x4737] = "\xc8\x77", [0x4738] = "\xc8\x78", [0x4739] = "\xc8\x79",
  [0x473a] = "\xc8\x7a", [0x473b] = "\xc8\x7b", [0x473c] = "\xc8\x7c",
  [0x473d] = "\xc8\x7d", [0x473e] = "\xc8\x7e", [0x4740] = "\xc8\x80",
  [0x4741] = "\xc8\x81", [0x4742] = "\xc8\x82", [0x4743] = "\xc8\x83",
  [0x4744] = "\xc8\x84", [0x4745] = "\xc8\x85", [0x4746] = "\xc8\x86",
  [0x4747] = "\xc8\x87", [0x4748] = "\xc8\x88", [0x4749] = "\xc8\x89",
  [0x474a] = "\xc8\x8a", [0x474b] = "\xc8\x8b", [0x474c] = "\xc8\x8c",
  [0x474d] = "\xc8\x8d", [0x474e] = "\xc8\x8e", [0x474f] = "\xc8\x8f",
  [0x4750] = "\xc8\x90", [0x4751] = "\xc8\x91", [0x4752] = "\xc8\x92",
  [0x4753] = "\xc8\x93", [0x4754] = "\xc8\x94", [0x4755] = "\xc8\x95",
  [0x4756] = "\xc8\x96", [0x4757] = "\xc8\x97", [0x4758] = "\xc8\x98",
  [0x4759] = "\xc8\x99", [0x475a] = "\xc8\x9a", [0x475b] = "\xc8\x9b",
  [0x475c] = "\xc8\x9c", [0x475d] = "\xc8\x9d", [0x475e] = "\xc8\x9e",
  [0x475f] = "\xc8\x9f", [0x4760] = "\xc8\xa0", [0x4761] = "\xc8\xa1",
  [0x4762] = "\xc8\xa2", [0x4763] = "\xc8\xa3", [0x4764] = "\xc8\xa4",
  [0x4765] = "\xc8\xa5", [0x4766] = "\xc8\xa6", [0x4767] = "\xc8\xa7",
  [0x4768] = "\xc8\xa8", [0x4769] = "\xc8\xa9", [0x476a] = "\xc8\xaa",
  [0x476b] = "\xc8\xab", [0x476c] = "\xc8\xac", [0x476d] = "\xc8\xad",
  [0x476e] = "\xc8\xae", [0x476f] = "\xc8\xaf", [0x4770] = "\xc8\xb0",
  [0x4771] = "\xc8\xb1", [0x4772] = "\xc8\xb2", [0x4773] = "\xc8\xb3",
  [0x4774] = "\xc8\xb4", [0x4775] = "\xc8\xb5", [0x4776] = "\xc8\xb6",
  [0x4777] = "\xc8\xb7", [0x4778] = "\xc8\xb8", [0x4779] = "\xc8\xb9",
  [0x477a] = "\xc8\xba", [0x477b] = "\xc8\xbb", [0x477c] = "\xc8\xbc",
  [0x477d] = "\xc8\xbd", [0x477e] = "\xc8\xbe", [0x477f] = "\xc8\xbf",
  [0x4780] = "\xc8\xc0", [0x4781] = "\xc8\xc1", [0x4782] = "\xc8\xc2",
  [0x4783] = "\xc8\xc3", [0x4784] = "\xc8\xc4", [0x4785] = "\xc8\xc5",
  [0x4786] = "\xc8\xc6", [0x4787] = "\xc8\xc7", [0x4788] = "\xc8\xc8",
  [0x4789] = "\xc8\xc9", [0x478a] = "\xc8\xca", [0x478b] = "\xc8\xcb",
  [0x478c] = "\xc8\xcc", [0x478d] = "\xc8\xcd", [0x478e] = "\xc8\xce",
  [0x478f] = "\xc8\xcf", [0x4790] = "\xc8\xd0", [0x4791] = "\xc8\xd1",
  [0x4792] = "\xc8\xd2", [0x4793] = "\xc8\xd3", [0x4794] = "\xc8\xd4",
  [0x4795] = "\xc8\xd5", [0x4796] = "\xc8\xd6", [0x4797] = "\xc8\xd7",
  [0x4798] = "\xc8\xd8", [0x4799] = "\xc8\xd9", [0x479a] = "\xc8\xda",
  [0x479b] = "\xc8\xdb", [0x479c] = "\xc8\xdc", [0x479d] = "\xc8\xdd",
  [0x479e] = "\xc8\xde", [0x479f] = "\xc8\xdf", [0x47a0] = "\xc8\xe0",
  [0x47a1] = "\xc8\xe1", [0x47a2] = "\xc8\xe2", [0x47a3] = "\xc8\xe3",
  [0x47a4] = "\xc8\xe4", [0x47a5] = "\xc8\xe5", [0x47a6] = "\xc8\xe6",
  [0x47a7] = "\xc8\xe7", [0x47a8] = "\xc8\xe8", [0x47a9] = "\xc8\xe9",
  [0x47aa] = "\xc8\xea", [0x47ab] = "\xc8\xeb", [0x47ac] = "\xc8\xec",
  [0x47ad] = "\xc8\xed", [0x47ae] = "\xc8\xee", [0x47af] = "\xc8\xef",
  [0x47b0] = "\xc8\xf0", [0x47b1] = "\xc8\xf1", [0x47b2] = "\xc8\xf2",
  [0x47b3] = "\xc8\xf3", [0x47b4] = "\xc8\xf4", [0x47b5] = "\xc8\xf5",
  [0x47b6] = "\xc8\xf6", [0x47b7] = "\xc8\xf7", [0x47b8] = "\xc8\xf8",
  [0x47b9] = "\xc8\xf9", [0x47ba] = "\xc8\xfa", [0x47bb] = "\xc8\xfb",
  [0x47bc] = "\xc8\xfc", [0x47bd] = "\xc8\xfd", [0x47be] = "\xc8\xfe",
  [0x4800] = "\xc9\x40", [0x4801] = "\xc9\x41", [0x4802] = "\xc9\x42",
  [0x4803] = "\xc9\x43", [0x4804] = "\xc9\x44", [0x4805] = "\xc9\x45",
  [0x4806] = "\xc9\x46", [0x4807] = "\xc9\x47", [0x4808] = "\xc9\x48",
  [0x4809] = "\xc9\x49", [0x480a] = "\xc9\x4a", [0x480b] = "\xc9\x4b",
  [0x480c] = "\xc9\x4c", [0x480d] = "\xc9\x4d", [0x480e] = "\xc9\x4e",
  [0x480f] = "\xc9\x4f", [0x4810] = "\xc9\x50", [0x4811] = "\xc9\x51",
  [0x4812] = "\xc9\x52", [0x4813] = "\xc9\x53", [0x4814] = "\xc9\x54",
  [0x4815] = "\xc9\x55", [0x4816] = "\xc9\x56", [0x4817] = "\xc9\x57",
  [0x4818] = "\xc9\x58", [0x4819] = "\xc9\x59", [0x481a] = "\xc9\x5a",
  [0x481b] = "\xc9\x5b", [0x481c] = "\xc9\x5c", [0x481d] = "\xc9\x5d",
  [0x481e] = "\xc9\x5e", [0x481f] = "\xc9\x5f", [0x4820] = "\xc9\x60",
  [0x4821] = "\xc9\x61", [0x4822] = "\xc9\x62", [0x4823] = "\xc9\x63",
  [0x4824] = "\xc9\x64", [0x4825] = "\xc9\x65", [0x4826] = "\xc9\x66",
  [0x4827] = "\xc9\x67", [0x4828] = "\xc9\x68", [0x4829] = "\xc9\x69",
  [0x482a] = "\xc9\x6a", [0x482b] = "\xc9\x6b", [0x482c] = "\xc9\x6c",
  [0x482d] = "\xc9\x6d", [0x482e] = "\xc9\x6e", [0x482f] = "\xc9\x6f",
  [0x4830] = "\xc9\x70", [0x4831] = "\xc9\x71", [0x4832] = "\xc9\x72",
  [0x4833] = "\xc9\x73", [0x4834] = "\xc9\x74", [0x4835] = "\xc9\x75",
  [0x4836] = "\xc9\x76", [0x4837] = "\xc9\x77", [0x4838] = "\xc9\x78",
  [0x4839] = "\xc9\x79", [0x483a] = "\xc9\x7a", [0x483b] = "\xc9\x7b",
  [0x483c] = "\xc9\x7c", [0x483d] = "\xc9\x7d", [0x483e] = "\xc9\x7e",
  [0x4840] = "\xc9\x80", [0x4841] = "\xc9\x81", [0x4842] = "\xc9\x82",
  [0x4843] = "\xc9\x83", [0x4844] = "\xc9\x84", [0x4845] = "\xc9\x85",
  [0x4846] = "\xc9\x86", [0x4847] = "\xc9\x87", [0x4848] = "\xc9\x88",
  [0x4849] = "\xc9\x89", [0x484a] = "\xc9\x8a", [0x484b] = "\xc9\x8b",
  [0x484c] = "\xc9\x8c", [0x484d] = "\xc9\x8d", [0x484e] = "\xc9\x8e",
  [0x484f] = "\xc9\x8f", [0x4850] = "\xc9\x90", [0x4851] = "\xc9\x91",
  [0x4852] = "\xc9\x92", [0x4853] = "\xc9\x93", [0x4854] = "\xc9\x94",
  [0x4855] = "\xc9\x95", [0x4856] = "\xc9\x96", [0x4857] = "\xc9\x97",
  [0x4858] = "\xc9\x98", [0x4859] = "\xc9\x99", [0x485a] = "\xc9\x9a",
  [0x485b] = "\xc9\x9b", [0x485c] = "\xc9\x9c", [0x485d] = "\xc9\x9d",
  [0x485e] = "\xc9\x9e", [0x485f] = "\xc9\x9f", [0x4860] = "\xc9\xa0",
  [0x4861] = "\xc9\xa1", [0x4862] = "\xc9\xa2", [0x4863] = "\xc9\xa3",
  [0x4864] = "\xc9\xa4", [0x4865] = "\xc9\xa5", [0x4866] = "\xc9\xa6",
  [0x4867] = "\xc9\xa7", [0x4868] = "\xc9\xa8", [0x4869] = "\xc9\xa9",
  [0x486a] = "\xc9\xaa", [0x486b] = "\xc9\xab", [0x486c] = "\xc9\xac",
  [0x486d] = "\xc9\xad", [0x486e] = "\xc9\xae", [0x486f] = "\xc9\xaf",
  [0x4870] = "\xc9\xb0", [0x4871] = "\xc9\xb1", [0x4872] = "\xc9\xb2",
  [0x4873] = "\xc9\xb3", [0x4874] = "\xc9\xb4", [0x4875] = "\xc9\xb5",
  [0x4876] = "\xc9\xb6", [0x4877] = "\xc9\xb7", [0x4878] = "\xc9\xb8",
  [0x4879] = "\xc9\xb9", [0x487a] = "\xc9\xba", [0x487b] = "\xc9\xbb",
  [0x487c] = "\xc9\xbc", [0x487d] = "\xc9\xbd", [0x487e] = "\xc9\xbe",
  [0x487f] = "\xc9\xbf", [0x4880] = "\xc9\xc0", [0x4881] = "\xc9\xc1",
  [0x4882] = "\xc9\xc2", [0x4883] = "\xc9\xc3", [0x4884] = "\xc9\xc4",
  [0x4885] = "\xc9\xc5", [0x4886] = "\xc9\xc6", [0x4887] = "\xc9\xc7",
  [0x4888] = "\xc9\xc8", [0x4889] = "\xc9\xc9", [0x488a] = "\xc9\xca",
  [0x488b] = "\xc9\xcb", [0x488c] = "\xc9\xcc", [0x488d] = "\xc9\xcd",
  [0x488e] = "\xc9\xce", [0x488f] = "\xc9\xcf", [0x4890] = "\xc9\xd0",
  [0x4891] = "\xc9\xd1", [0x4892] = "\xc9\xd2", [0x4893] = "\xc9\xd3",
  [0x4894] = "\xc9\xd4", [0x4895] = "\xc9\xd5", [0x4896] = "\xc9\xd6",
  [0x4897] = "\xc9\xd7", [0x4898] = "\xc9\xd8", [0x4899] = "\xc9\xd9",
  [0x489a] = "\xc9\xda", [0x489b] = "\xc9\xdb", [0x489c] = "\xc9\xdc",
  [0x489d] = "\xc9\xdd", [0x489e] = "\xc9\xde", [0x489f] = "\xc9\xdf",
  [0x48a0] = "\xc9\xe0", [0x48a1] = "\xc9\xe1", [0x48a2] = "\xc9\xe2",
  [0x48a3] = "\xc9\xe3", [0x48a4] = "\xc9\xe4", [0x48a5] = "\xc9\xe5",
  [0x48a6] = "\xc9\xe6", [0x48a7] = "\xc9\xe7", [0x48a8] = "\xc9\xe8",
  [0x48a9] = "\xc9\xe9", [0x48aa] = "\xc9\xea", [0x48ab] = "\xc9\xeb",
  [0x48ac] = "\xc9\xec", [0x48ad] = "\xc9\xed", [0x48ae] = "\xc9\xee",
  [0x48af] = "\xc9\xef", [0x48b0] = "\xc9\xf0", [0x48b1] = "\xc9\xf1",
  [0x48b2] = "\xc9\xf2", [0x48b3] = "\xc9\xf3", [0x48b4] = "\xc9\xf4",
  [0x48b5] = "\xc9\xf5", [0x48b6] = "\xc9\xf6", [0x48b7] = "\xc9\xf7",
  [0x48b8] = "\xc9\xf8", [0x48b9] = "\xc9\xf9", [0x48ba] = "\xc9\xfa",
  [0x48bb] = "\xc9\xfb", [0x48bc] = "\xc9\xfc", [0x48bd] = "\xc9\xfd",
  [0x48be] = "\xc9\xfe", [0x4900] = "\xca\x40", [0x4901] = "\xca\x41",
  [0x4902] = "\xca\x42", [0x4903] = "\xca\x43", [0x4904] = "\xca\x44",
  [0x4905] = "\xca\x45", [0x4906] = "\xca\x46", [0x4907] = "\xca\x47",
  [0x4908] = "\xca\x48", [0x4909] = "\xca\x49", [0x490a] = "\xca\x4a",
  [0x490b] = "\xca\x4b", [0x490c] = "\xca\x4c", [0x490d] = "\xca\x4d",
  [0x490e] = "\xca\x4e", [0x490f] = "\xca\x4f", [0x4910] = "\xca\x50",
  [0x4911] = "\xca\x51", [0x4912] = "\xca\x52", [0x4913] = "\xca\x53",
  [0x4914] = "\xca\x54", [0x4915] = "\xca\x55", [0x4916] = "\xca\x56",
  [0x4917] = "\xca\x57", [0x4918] = "\xca\x58", [0x4919] = "\xca\x59",
  [0x491a] = "\xca\x5a", [0x491b] = "\xca\x5b", [0x491c] = "\xca\x5c",
  [0x491d] = "\xca\x5d", [0x491e] = "\xca\x5e", [0x491f] = "\xca\x5f",
  [0x4920] = "\xca\x60", [0x4921] = "\xca\x61", [0x4922] = "\xca\x62",
  [0x4923] = "\xca\x63", [0x4924] = "\xca\x64", [0x4925] = "\xca\x65",
  [0x4926] = "\xca\x66", [0x4927] = "\xca\x67", [0x4928] = "\xca\x68",
  [0x4929] = "\xca\x69", [0x492a] = "\xca\x6a", [0x492b] = "\xca\x6b",
  [0x492c] = "\xca\x6c", [0x492d] = "\xca\x6d", [0x492e] = "\xca\x6e",
  [0x492f] = "\xca\x6f", [0x4930] = "\xca\x70", [0x4931] = "\xca\x71",
  [0x4932] = "\xca\x72", [0x4933] = "\xca\x73", [0x4934] = "\xca\x74",
  [0x4935] = "\xca\x75", [0x4936] = "\xca\x76", [0x4937] = "\xca\x77",
  [0x4938] = "\xca\x78", [0x4939] = "\xca\x79", [0x493a] = "\xca\x7a",
  [0x493b] = "\xca\x7b", [0x493c] = "\xca\x7c", [0x493d] = "\xca\x7d",
  [0x493e] = "\xca\x7e", [0x4940] = "\xca\x80", [0x4941] = "\xca\x81",
  [0x4942] = "\xca\x82", [0x4943] = "\xca\x83", [0x4944] = "\xca\x84",
  [0x4945] = "\xca\x85", [0x4946] = "\xca\x86", [0x4947] = "\xca\x87",
  [0x4948] = "\xca\x88", [0x4949] = "\xca\x89", [0x494a] = "\xca\x8a",
  [0x494b] = "\xca\x8b", [0x494c] = "\xca\x8c", [0x494d] = "\xca\x8d",
  [0x494e] = "\xca\x8e", [0x494f] = "\xca\x8f", [0x4950] = "\xca\x90",
  [0x4951] = "\xca\x91", [0x4952] = "\xca\x92", [0x4953] = "\xca\x93",
  [0x4954] = "\xca\x94", [0x4955] = "\xca\x95", [0x4956] = "\xca\x96",
  [0x4957] = "\xca\x97", [0x4958] = "\xca\x98", [0x4959] = "\xca\x99",
  [0x495a] = "\xca\x9a", [0x495b] = "\xca\x9b", [0x495c] = "\xca\x9c",
  [0x495d] = "\xca\x9d", [0x495e] = "\xca\x9e", [0x495f] = "\xca\x9f",
  [0x4960] = "\xca\xa0", [0x4961] = "\xca\xa1", [0x4962] = "\xca\xa2",
  [0x4963] = "\xca\xa3", [0x4964] = "\xca\xa4", [0x4965] = "\xca\xa5",
  [0x4966] = "\xca\xa6", [0x4967] = "\xca\xa7", [0x4968] = "\xca\xa8",
  [0x4969] = "\xca\xa9", [0x496a] = "\xca\xaa", [0x496b] = "\xca\xab",
  [0x496c] = "\xca\xac", [0x496d] = "\xca\xad", [0x496e] = "\xca\xae",
  [0x496f] = "\xca\xaf", [0x4970] = "\xca\xb0", [0x4971] = "\xca\xb1",
  [0x4972] = "\xca\xb2", [0x4973] = "\xca\xb3", [0x4974] = "\xca\xb4",
  [0x4975] = "\xca\xb5", [0x4976] = "\xca\xb6", [0x4977] = "\xca\xb7",
  [0x4978] = "\xca\xb8", [0x4979] = "\xca\xb9", [0x497a] = "\xca\xba",
  [0x497b] = "\xca\xbb", [0x497c] = "\xca\xbc", [0x497d] = "\xca\xbd",
  [0x497e] = "\xca\xbe", [0x497f] = "\xca\xbf", [0x4980] = "\xca\xc0",
  [0x4981] = "\xca\xc1", [0x4982] = "\xca\xc2", [0x4983] = "\xca\xc3",
  [0x4984] = "\xca\xc4", [0x4985] = "\xca\xc5", [0x4986] = "\xca\xc6",
  [0x4987] = "\xca\xc7", [0x4988] = "\xca\xc8", [0x4989] = "\xca\xc9",
  [0x498a] = "\xca\xca", [0x498b] = "\xca\xcb", [0x498c] = "\xca\xcc",
  [0x498d] = "\xca\xcd", [0x498e] = "\xca\xce", [0x498f] = "\xca\xcf",
  [0x4990] = "\xca\xd0", [0x4991] = "\xca\xd1", [0x4992] = "\xca\xd2",
  [0x4993] = "\xca\xd3", [0x4994] = "\xca\xd4", [0x4995] = "\xca\xd5",
  [0x4996] = "\xca\xd6", [0x4997] = "\xca\xd7", [0x4998] = "\xca\xd8",
  [0x4999] = "\xca\xd9", [0x499a] = "\xca\xda", [0x499b] = "\xca\xdb",
  [0x499c] = "\xca\xdc", [0x499d] = "\xca\xdd", [0x499e] = "\xca\xde",
  [0x499f] = "\xca\xdf", [0x49a0] = "\xca\xe0", [0x49a1] = "\xca\xe1",
  [0x49a2] = "\xca\xe2", [0x49a3] = "\xca\xe3", [0x49a4] = "\xca\xe4",
  [0x49a5] = "\xca\xe5", [0x49a6] = "\xca\xe6", [0x49a7] = "\xca\xe7",
  [0x49a8] = "\xca\xe8", [0x49a9] = "\xca\xe9", [0x49aa] = "\xca\xea",
  [0x49ab] = "\xca\xeb", [0x49ac] = "\xca\xec", [0x49ad] = "\xca\xed",
  [0x49ae] = "\xca\xee", [0x49af] = "\xca\xef", [0x49b0] = "\xca\xf0",
  [0x49b1] = "\xca\xf1", [0x49b2] = "\xca\xf2", [0x49b3] = "\xca\xf3",
  [0x49b4] = "\xca\xf4", [0x49b5] = "\xca\xf5", [0x49b6] = "\xca\xf6",
  [0x49b7] = "\xca\xf7", [0x49b8] = "\xca\xf8", [0x49b9] = "\xca\xf9",
  [0x49ba] = "\xca\xfa", [0x49bb] = "\xca\xfb", [0x49bc] = "\xca\xfc",
  [0x49bd] = "\xca\xfd", [0x49be] = "\xca\xfe", [0x4a00] = "\xcb\x40",
  [0x4a01] = "\xcb\x41", [0x4a02] = "\xcb\x42", [0x4a03] = "\xcb\x43",
  [0x4a04] = "\xcb\x44", [0x4a05] = "\xcb\x45", [0x4a06] = "\xcb\x46",
  [0x4a07] = "\xcb\x47", [0x4a08] = "\xcb\x48", [0x4a09] = "\xcb\x49",
  [0x4a0a] = "\xcb\x4a", [0x4a0b] = "\xcb\x4b", [0x4a0c] = "\xcb\x4c",
  [0x4a0d] = "\xcb\x4d", [0x4a0e] = "\xcb\x4e", [0x4a0f] = "\xcb\x4f",
  [0x4a10] = "\xcb\x50", [0x4a11] = "\xcb\x51", [0x4a12] = "\xcb\x52",
  [0x4a13] = "\xcb\x53", [0x4a14] = "\xcb\x54", [0x4a15] = "\xcb\x55",
  [0x4a16] = "\xcb\x56", [0x4a17] = "\xcb\x57", [0x4a18] = "\xcb\x58",
  [0x4a19] = "\xcb\x59", [0x4a1a] = "\xcb\x5a", [0x4a1b] = "\xcb\x5b",
  [0x4a1c] = "\xcb\x5c", [0x4a1d] = "\xcb\x5d", [0x4a1e] = "\xcb\x5e",
  [0x4a1f] = "\xcb\x5f", [0x4a20] = "\xcb\x60", [0x4a21] = "\xcb\x61",
  [0x4a22] = "\xcb\x62", [0x4a23] = "\xcb\x63", [0x4a24] = "\xcb\x64",
  [0x4a25] = "\xcb\x65", [0x4a26] = "\xcb\x66", [0x4a27] = "\xcb\x67",
  [0x4a28] = "\xcb\x68", [0x4a29] = "\xcb\x69", [0x4a2a] = "\xcb\x6a",
  [0x4a2b] = "\xcb\x6b", [0x4a2c] = "\xcb\x6c", [0x4a2d] = "\xcb\x6d",
  [0x4a2e] = "\xcb\x6e", [0x4a2f] = "\xcb\x6f", [0x4a30] = "\xcb\x70",
  [0x4a31] = "\xcb\x71", [0x4a32] = "\xcb\x72", [0x4a33] = "\xcb\x73",
  [0x4a34] = "\xcb\x74", [0x4a35] = "\xcb\x75", [0x4a36] = "\xcb\x76",
  [0x4a37] = "\xcb\x77", [0x4a38] = "\xcb\x78", [0x4a39] = "\xcb\x79",
  [0x4a3a] = "\xcb\x7a", [0x4a3b] = "\xcb\x7b", [0x4a3c] = "\xcb\x7c",
  [0x4a3d] = "\xcb\x7d", [0x4a3e] = "\xcb\x7e", [0x4a40] = "\xcb\x80",
  [0x4a41] = "\xcb\x81", [0x4a42] = "\xcb\x82", [0x4a43] = "\xcb\x83",
  [0x4a44] = "\xcb\x84", [0x4a45] = "\xcb\x85", [0x4a46] = "\xcb\x86",
  [0x4a47] = "\xcb\x87", [0x4a48] = "\xcb\x88", [0x4a49] = "\xcb\x89",
  [0x4a4a] = "\xcb\x8a", [0x4a4b] = "\xcb\x8b", [0x4a4c] = "\xcb\x8c",
  [0x4a4d] = "\xcb\x8d", [0x4a4e] = "\xcb\x8e", [0x4a4f] = "\xcb\x8f",
  [0x4a50] = "\xcb\x90", [0x4a51] = "\xcb\x91", [0x4a52] = "\xcb\x92",
  [0x4a53] = "\xcb\x93", [0x4a54] = "\xcb\x94", [0x4a55] = "\xcb\x95",
  [0x4a56] = "\xcb\x96", [0x4a57] = "\xcb\x97", [0x4a58] = "\xcb\x98",
  [0x4a59] = "\xcb\x99", [0x4a5a] = "\xcb\x9a", [0x4a5b] = "\xcb\x9b",
  [0x4a5c] = "\xcb\x9c", [0x4a5d] = "\xcb\x9d", [0x4a5e] = "\xcb\x9e",
  [0x4a5f] = "\xcb\x9f", [0x4a60] = "\xcb\xa0", [0x4a61] = "\xcb\xa1",
  [0x4a62] = "\xcb\xa2", [0x4a63] = "\xcb\xa3", [0x4a64] = "\xcb\xa4",
  [0x4a65] = "\xcb\xa5", [0x4a66] = "\xcb\xa6", [0x4a67] = "\xcb\xa7",
  [0x4a68] = "\xcb\xa8", [0x4a69] = "\xcb\xa9", [0x4a6a] = "\xcb\xaa",
  [0x4a6b] = "\xcb\xab", [0x4a6c] = "\xcb\xac", [0x4a6d] = "\xcb\xad",
  [0x4a6e] = "\xcb\xae", [0x4a6f] = "\xcb\xaf", [0x4a70] = "\xcb\xb0",
  [0x4a71] = "\xcb\xb1", [0x4a72] = "\xcb\xb2", [0x4a73] = "\xcb\xb3",
  [0x4a74] = "\xcb\xb4", [0x4a75] = "\xcb\xb5", [0x4a76] = "\xcb\xb6",
  [0x4a77] = "\xcb\xb7", [0x4a78] = "\xcb\xb8", [0x4a79] = "\xcb\xb9",
  [0x4a7a] = "\xcb\xba", [0x4a7b] = "\xcb\xbb", [0x4a7c] = "\xcb\xbc",
  [0x4a7d] = "\xcb\xbd", [0x4a7e] = "\xcb\xbe", [0x4a7f] = "\xcb\xbf",
  [0x4a80] = "\xcb\xc0", [0x4a81] = "\xcb\xc1", [0x4a82] = "\xcb\xc2",
  [0x4a83] = "\xcb\xc3", [0x4a84] = "\xcb\xc4", [0x4a85] = "\xcb\xc5",
  [0x4a86] = "\xcb\xc6", [0x4a87] = "\xcb\xc7", [0x4a88] = "\xcb\xc8",
  [0x4a89] = "\xcb\xc9", [0x4a8a] = "\xcb\xca", [0x4a8b] = "\xcb\xcb",
  [0x4a8c] = "\xcb\xcc", [0x4a8d] = "\xcb\xcd", [0x4a8e] = "\xcb\xce",
  [0x4a8f] = "\xcb\xcf", [0x4a90] = "\xcb\xd0", [0x4a91] = "\xcb\xd1",
  [0x4a92] = "\xcb\xd2", [0x4a93] = "\xcb\xd3", [0x4a94] = "\xcb\xd4",
  [0x4a95] = "\xcb\xd5", [0x4a96] = "\xcb\xd6", [0x4a97] = "\xcb\xd7",
  [0x4a98] = "\xcb\xd8", [0x4a99] = "\xcb\xd9", [0x4a9a] = "\xcb\xda",
  [0x4a9b] = "\xcb\xdb", [0x4a9c] = "\xcb\xdc", [0x4a9d] = "\xcb\xdd",
  [0x4a9e] = "\xcb\xde", [0x4a9f] = "\xcb\xdf", [0x4aa0] = "\xcb\xe0",
  [0x4aa1] = "\xcb\xe1", [0x4aa2] = "\xcb\xe2", [0x4aa3] = "\xcb\xe3",
  [0x4aa4] = "\xcb\xe4", [0x4aa5] = "\xcb\xe5", [0x4aa6] = "\xcb\xe6",
  [0x4aa7] = "\xcb\xe7", [0x4aa8] = "\xcb\xe8", [0x4aa9] = "\xcb\xe9",
  [0x4aaa] = "\xcb\xea", [0x4aab] = "\xcb\xeb", [0x4aac] = "\xcb\xec",
  [0x4aad] = "\xcb\xed", [0x4aae] = "\xcb\xee", [0x4aaf] = "\xcb\xef",
  [0x4ab0] = "\xcb\xf0", [0x4ab1] = "\xcb\xf1", [0x4ab2] = "\xcb\xf2",
  [0x4ab3] = "\xcb\xf3", [0x4ab4] = "\xcb\xf4", [0x4ab5] = "\xcb\xf5",
  [0x4ab6] = "\xcb\xf6", [0x4ab7] = "\xcb\xf7", [0x4ab8] = "\xcb\xf8",
  [0x4ab9] = "\xcb\xf9", [0x4aba] = "\xcb\xfa", [0x4abb] = "\xcb\xfb",
  [0x4abc] = "\xcb\xfc", [0x4abd] = "\xcb\xfd", [0x4abe] = "\xcb\xfe",
  [0x4b00] = "\xcc\x40", [0x4b01] = "\xcc\x41", [0x4b02] = "\xcc\x42",
  [0x4b03] = "\xcc\x43", [0x4b04] = "\xcc\x44", [0x4b05] = "\xcc\x45",
  [0x4b06] = "\xcc\x46", [0x4b07] = "\xcc\x47", [0x4b08] = "\xcc\x48",
  [0x4b09] = "\xcc\x49", [0x4b0a] = "\xcc\x4a", [0x4b0b] = "\xcc\x4b",
  [0x4b0c] = "\xcc\x4c", [0x4b0d] = "\xcc\x4d", [0x4b0e] = "\xcc\x4e",
  [0x4b0f] = "\xcc\x4f", [0x4b10] = "\xcc\x50", [0x4b11] = "\xcc\x51",
  [0x4b12] = "\xcc\x52", [0x4b13] = "\xcc\x53", [0x4b14] = "\xcc\x54",
  [0x4b15] = "\xcc\x55", [0x4b16] = "\xcc\x56", [0x4b17] = "\xcc\x57",
  [0x4b18] = "\xcc\x58", [0x4b19] = "\xcc\x59", [0x4b1a] = "\xcc\x5a",
  [0x4b1b] = "\xcc\x5b", [0x4b1c] = "\xcc\x5c", [0x4b1d] = "\xcc\x5d",
  [0x4b1e] = "\xcc\x5e", [0x4b1f] = "\xcc\x5f", [0x4b20] = "\xcc\x60",
  [0x4b21] = "\xcc\x61", [0x4b22] = "\xcc\x62", [0x4b23] = "\xcc\x63",
  [0x4b24] = "\xcc\x64", [0x4b25] = "\xcc\x65", [0x4b26] = "\xcc\x66",
  [0x4b27] = "\xcc\x67", [0x4b28] = "\xcc\x68", [0x4b29] = "\xcc\x69",
  [0x4b2a] = "\xcc\x6a", [0x4b2b] = "\xcc\x6b", [0x4b2c] = "\xcc\x6c",
  [0x4b2d] = "\xcc\x6d", [0x4b2e] = "\xcc\x6e", [0x4b2f] = "\xcc\x6f",
  [0x4b30] = "\xcc\x70", [0x4b31] = "\xcc\x71", [0x4b32] = "\xcc\x72",
  [0x4b33] = "\xcc\x73", [0x4b34] = "\xcc\x74", [0x4b35] = "\xcc\x75",
  [0x4b36] = "\xcc\x76", [0x4b37] = "\xcc\x77", [0x4b38] = "\xcc\x78",
  [0x4b39] = "\xcc\x79", [0x4b3a] = "\xcc\x7a", [0x4b3b] = "\xcc\x7b",
  [0x4b3c] = "\xcc\x7c", [0x4b3d] = "\xcc\x7d", [0x4b3e] = "\xcc\x7e",
  [0x4b40] = "\xcc\x80", [0x4b41] = "\xcc\x81", [0x4b42] = "\xcc\x82",
  [0x4b43] = "\xcc\x83", [0x4b44] = "\xcc\x84", [0x4b45] = "\xcc\x85",
  [0x4b46] = "\xcc\x86", [0x4b47] = "\xcc\x87", [0x4b48] = "\xcc\x88",
  [0x4b49] = "\xcc\x89", [0x4b4a] = "\xcc\x8a", [0x4b4b] = "\xcc\x8b",
  [0x4b4c] = "\xcc\x8c", [0x4b4d] = "\xcc\x8d", [0x4b4e] = "\xcc\x8e",
  [0x4b4f] = "\xcc\x8f", [0x4b50] = "\xcc\x90", [0x4b51] = "\xcc\x91",
  [0x4b52] = "\xcc\x92", [0x4b53] = "\xcc\x93", [0x4b54] = "\xcc\x94",
  [0x4b55] = "\xcc\x95", [0x4b56] = "\xcc\x96", [0x4b57] = "\xcc\x97",
  [0x4b58] = "\xcc\x98", [0x4b59] = "\xcc\x99", [0x4b5a] = "\xcc\x9a",
  [0x4b5b] = "\xcc\x9b", [0x4b5c] = "\xcc\x9c", [0x4b5d] = "\xcc\x9d",
  [0x4b5e] = "\xcc\x9e", [0x4b5f] = "\xcc\x9f", [0x4b60] = "\xcc\xa0",
  [0x4b61] = "\xcc\xa1", [0x4b62] = "\xcc\xa2", [0x4b63] = "\xcc\xa3",
  [0x4b64] = "\xcc\xa4", [0x4b65] = "\xcc\xa5", [0x4b66] = "\xcc\xa6",
  [0x4b67] = "\xcc\xa7", [0x4b68] = "\xcc\xa8", [0x4b69] = "\xcc\xa9",
  [0x4b6a] = "\xcc\xaa", [0x4b6b] = "\xcc\xab", [0x4b6c] = "\xcc\xac",
  [0x4b6d] = "\xcc\xad", [0x4b6e] = "\xcc\xae", [0x4b6f] = "\xcc\xaf",
  [0x4b70] = "\xcc\xb0", [0x4b71] = "\xcc\xb1", [0x4b72] = "\xcc\xb2",
  [0x4b73] = "\xcc\xb3", [0x4b74] = "\xcc\xb4", [0x4b75] = "\xcc\xb5",
  [0x4b76] = "\xcc\xb6", [0x4b77] = "\xcc\xb7", [0x4b78] = "\xcc\xb8",
  [0x4b79] = "\xcc\xb9", [0x4b7a] = "\xcc\xba", [0x4b7b] = "\xcc\xbb",
  [0x4b7c] = "\xcc\xbc", [0x4b7d] = "\xcc\xbd", [0x4b7e] = "\xcc\xbe",
  [0x4b7f] = "\xcc\xbf", [0x4b80] = "\xcc\xc0", [0x4b81] = "\xcc\xc1",
  [0x4b82] = "\xcc\xc2", [0x4b83] = "\xcc\xc3", [0x4b84] = "\xcc\xc4",
  [0x4b85] = "\xcc\xc5", [0x4b86] = "\xcc\xc6", [0x4b87] = "\xcc\xc7",
  [0x4b88] = "\xcc\xc8", [0x4b89] = "\xcc\xc9", [0x4b8a] = "\xcc\xca",
  [0x4b8b] = "\xcc\xcb", [0x4b8c] = "\xcc\xcc", [0x4b8d] = "\xcc\xcd",
  [0x4b8e] = "\xcc\xce", [0x4b8f] = "\xcc\xcf", [0x4b90] = "\xcc\xd0",
  [0x4b91] = "\xcc\xd1", [0x4b92] = "\xcc\xd2", [0x4b93] = "\xcc\xd3",
  [0x4b94] = "\xcc\xd4", [0x4b95] = "\xcc\xd5", [0x4b96] = "\xcc\xd6",
  [0x4b97] = "\xcc\xd7", [0x4b98] = "\xcc\xd8", [0x4b99] = "\xcc\xd9",
  [0x4b9a] = "\xcc\xda", [0x4b9b] = "\xcc\xdb", [0x4b9c] = "\xcc\xdc",
  [0x4b9d] = "\xcc\xdd", [0x4b9e] = "\xcc\xde", [0x4b9f] = "\xcc\xdf",
  [0x4ba0] = "\xcc\xe0", [0x4ba1] = "\xcc\xe1", [0x4ba2] = "\xcc\xe2",
  [0x4ba3] = "\xcc\xe3", [0x4ba4] = "\xcc\xe4", [0x4ba5] = "\xcc\xe5",
  [0x4ba6] = "\xcc\xe6", [0x4ba7] = "\xcc\xe7", [0x4ba8] = "\xcc\xe8",
  [0x4ba9] = "\xcc\xe9", [0x4baa] = "\xcc\xea", [0x4bab] = "\xcc\xeb",
  [0x4bac] = "\xcc\xec", [0x4bad] = "\xcc\xed", [0x4bae] = "\xcc\xee",
  [0x4baf] = "\xcc\xef", [0x4bb0] = "\xcc\xf0", [0x4bb1] = "\xcc\xf1",
  [0x4bb2] = "\xcc\xf2", [0x4bb3] = "\xcc\xf3", [0x4bb4] = "\xcc\xf4",
  [0x4bb5] = "\xcc\xf5", [0x4bb6] = "\xcc\xf6", [0x4bb7] = "\xcc\xf7",
  [0x4bb8] = "\xcc\xf8", [0x4bb9] = "\xcc\xf9", [0x4bba] = "\xcc\xfa",
  [0x4bbb] = "\xcc\xfb", [0x4bbc] = "\xcc\xfc", [0x4bbd] = "\xcc\xfd",
  [0x4bbe] = "\xcc\xfe", [0x4c00] = "\xcd\x40", [0x4c01] = "\xcd\x41",
  [0x4c02] = "\xcd\x42", [0x4c03] = "\xcd\x43", [0x4c04] = "\xcd\x44",
  [0x4c05] = "\xcd\x45", [0x4c06] = "\xcd\x46", [0x4c07] = "\xcd\x47",
  [0x4c08] = "\xcd\x48", [0x4c09] = "\xcd\x49", [0x4c0a] = "\xcd\x4a",
  [0x4c0b] = "\xcd\x4b", [0x4c0c] = "\xcd\x4c", [0x4c0d] = "\xcd\x4d",
  [0x4c0e] = "\xcd\x4e", [0x4c0f] = "\xcd\x4f", [0x4c10] = "\xcd\x50",
  [0x4c11] = "\xcd\x51", [0x4c12] = "\xcd\x52", [0x4c13] = "\xcd\x53",
  [0x4c14] = "\xcd\x54", [0x4c15] = "\xcd\x55", [0x4c16] = "\xcd\x56",
  [0x4c17] = "\xcd\x57", [0x4c18] = "\xcd\x58", [0x4c19] = "\xcd\x59",
  [0x4c1a] = "\xcd\x5a", [0x4c1b] = "\xcd\x5b", [0x4c1c] = "\xcd\x5c",
  [0x4c1d] = "\xcd\x5d", [0x4c1e] = "\xcd\x5e", [0x4c1f] = "\xcd\x5f",
  [0x4c20] = "\xcd\x60", [0x4c21] = "\xcd\x61", [0x4c22] = "\xcd\x62",
  [0x4c23] = "\xcd\x63", [0x4c24] = "\xcd\x64", [0x4c25] = "\xcd\x65",
  [0x4c26] = "\xcd\x66", [0x4c27] = "\xcd\x67", [0x4c28] = "\xcd\x68",
  [0x4c29] = "\xcd\x69", [0x4c2a] = "\xcd\x6a", [0x4c2b] = "\xcd\x6b",
  [0x4c2c] = "\xcd\x6c", [0x4c2d] = "\xcd\x6d", [0x4c2e] = "\xcd\x6e",
  [0x4c2f] = "\xcd\x6f", [0x4c30] = "\xcd\x70", [0x4c31] = "\xcd\x71",
  [0x4c32] = "\xcd\x72", [0x4c33] = "\xcd\x73", [0x4c34] = "\xcd\x74",
  [0x4c35] = "\xcd\x75", [0x4c36] = "\xcd\x76", [0x4c37] = "\xcd\x77",
  [0x4c38] = "\xcd\x78", [0x4c39] = "\xcd\x79", [0x4c3a] = "\xcd\x7a",
  [0x4c3b] = "\xcd\x7b", [0x4c3c] = "\xcd\x7c", [0x4c3d] = "\xcd\x7d",
  [0x4c3e] = "\xcd\x7e", [0x4c40] = "\xcd\x80", [0x4c41] = "\xcd\x81",
  [0x4c42] = "\xcd\x82", [0x4c43] = "\xcd\x83", [0x4c44] = "\xcd\x84",
  [0x4c45] = "\xcd\x85", [0x4c46] = "\xcd\x86", [0x4c47] = "\xcd\x87",
  [0x4c48] = "\xcd\x88", [0x4c49] = "\xcd\x89", [0x4c4a] = "\xcd\x8a",
  [0x4c4b] = "\xcd\x8b", [0x4c4c] = "\xcd\x8c", [0x4c4d] = "\xcd\x8d",
  [0x4c4e] = "\xcd\x8e", [0x4c4f] = "\xcd\x8f", [0x4c50] = "\xcd\x90",
  [0x4c51] = "\xcd\x91", [0x4c52] = "\xcd\x92", [0x4c53] = "\xcd\x93",
  [0x4c54] = "\xcd\x94", [0x4c55] = "\xcd\x95", [0x4c56] = "\xcd\x96",
  [0x4c57] = "\xcd\x97", [0x4c58] = "\xcd\x98", [0x4c59] = "\xcd\x99",
  [0x4c5a] = "\xcd\x9a", [0x4c5b] = "\xcd\x9b", [0x4c5c] = "\xcd\x9c",
  [0x4c5d] = "\xcd\x9d", [0x4c5e] = "\xcd\x9e", [0x4c5f] = "\xcd\x9f",
  [0x4c60] = "\xcd\xa0", [0x4c61] = "\xcd\xa1", [0x4c62] = "\xcd\xa2",
  [0x4c63] = "\xcd\xa3", [0x4c64] = "\xcd\xa4", [0x4c65] = "\xcd\xa5",
  [0x4c66] = "\xcd\xa6", [0x4c67] = "\xcd\xa7", [0x4c68] = "\xcd\xa8",
  [0x4c69] = "\xcd\xa9", [0x4c6a] = "\xcd\xaa", [0x4c6b] = "\xcd\xab",
  [0x4c6c] = "\xcd\xac", [0x4c6d] = "\xcd\xad", [0x4c6e] = "\xcd\xae",
  [0x4c6f] = "\xcd\xaf", [0x4c70] = "\xcd\xb0", [0x4c71] = "\xcd\xb1",
  [0x4c72] = "\xcd\xb2", [0x4c73] = "\xcd\xb3", [0x4c74] = "\xcd\xb4",
  [0x4c75] = "\xcd\xb5", [0x4c76] = "\xcd\xb6", [0x4c77] = "\xcd\xb7",
  [0x4c78] = "\xcd\xb8", [0x4c79] = "\xcd\xb9", [0x4c7a] = "\xcd\xba",
  [0x4c7b] = "\xcd\xbb", [0x4c7c] = "\xcd\xbc", [0x4c7d] = "\xcd\xbd",
  [0x4c7e] = "\xcd\xbe", [0x4c7f] = "\xcd\xbf", [0x4c80] = "\xcd\xc0",
  [0x4c81] = "\xcd\xc1", [0x4c82] = "\xcd\xc2", [0x4c83] = "\xcd\xc3",
  [0x4c84] = "\xcd\xc4", [0x4c85] = "\xcd\xc5", [0x4c86] = "\xcd\xc6",
  [0x4c87] = "\xcd\xc7", [0x4c88] = "\xcd\xc8", [0x4c89] = "\xcd\xc9",
  [0x4c8a] = "\xcd\xca", [0x4c8b] = "\xcd\xcb", [0x4c8c] = "\xcd\xcc",
  [0x4c8d] = "\xcd\xcd", [0x4c8e] = "\xcd\xce", [0x4c8f] = "\xcd\xcf",
  [0x4c90] = "\xcd\xd0", [0x4c91] = "\xcd\xd1", [0x4c92] = "\xcd\xd2",
  [0x4c93] = "\xcd\xd3", [0x4c94] = "\xcd\xd4", [0x4c95] = "\xcd\xd5",
  [0x4c96] = "\xcd\xd6", [0x4c97] = "\xcd\xd7", [0x4c98] = "\xcd\xd8",
  [0x4c99] = "\xcd\xd9", [0x4c9a] = "\xcd\xda", [0x4c9b] = "\xcd\xdb",
  [0x4c9c] = "\xcd\xdc", [0x4c9d] = "\xcd\xdd", [0x4c9e] = "\xcd\xde",
  [0x4c9f] = "\xcd\xdf", [0x4ca0] = "\xcd\xe0", [0x4ca1] = "\xcd\xe1",
  [0x4ca2] = "\xcd\xe2", [0x4ca3] = "\xcd\xe3", [0x4ca4] = "\xcd\xe4",
  [0x4ca5] = "\xcd\xe5", [0x4ca6] = "\xcd\xe6", [0x4ca7] = "\xcd\xe7",
  [0x4ca8] = "\xcd\xe8", [0x4ca9] = "\xcd\xe9", [0x4caa] = "\xcd\xea",
  [0x4cab] = "\xcd\xeb", [0x4cac] = "\xcd\xec", [0x4cad] = "\xcd\xed",
  [0x4cae] = "\xcd\xee", [0x4caf] = "\xcd\xef", [0x4cb0] = "\xcd\xf0",
  [0x4cb1] = "\xcd\xf1", [0x4cb2] = "\xcd\xf2", [0x4cb3] = "\xcd\xf3",
  [0x4cb4] = "\xcd\xf4", [0x4cb5] = "\xcd\xf5", [0x4cb6] = "\xcd\xf6",
  [0x4cb7] = "\xcd\xf7", [0x4cb8] = "\xcd\xf8", [0x4cb9] = "\xcd\xf9",
  [0x4cba] = "\xcd\xfa", [0x4cbb] = "\xcd\xfb", [0x4cbc] = "\xcd\xfc",
  [0x4cbd] = "\xcd\xfd", [0x4cbe] = "\xcd\xfe", [0x4d00] = "\xce\x40",
  [0x4d01] = "\xce\x41", [0x4d02] = "\xce\x42", [0x4d03] = "\xce\x43",
  [0x4d04] = "\xce\x44", [0x4d05] = "\xce\x45", [0x4d06] = "\xce\x46",
  [0x4d07] = "\xce\x47", [0x4d08] = "\xce\x48", [0x4d09] = "\xce\x49",
  [0x4d0a] = "\xce\x4a", [0x4d0b] = "\xce\x4b", [0x4d0c] = "\xce\x4c",
  [0x4d0d] = "\xce\x4d", [0x4d0e] = "\xce\x4e", [0x4d0f] = "\xce\x4f",
  [0x4d10] = "\xce\x50", [0x4d11] = "\xce\x51", [0x4d12] = "\xce\x52",
  [0x4d13] = "\xce\x53", [0x4d14] = "\xce\x54", [0x4d15] = "\xce\x55",
  [0x4d16] = "\xce\x56", [0x4d17] = "\xce\x57", [0x4d18] = "\xce\x58",
  [0x4d19] = "\xce\x59", [0x4d1a] = "\xce\x5a", [0x4d1b] = "\xce\x5b",
  [0x4d1c] = "\xce\x5c", [0x4d1d] = "\xce\x5d", [0x4d1e] = "\xce\x5e",
  [0x4d1f] = "\xce\x5f", [0x4d20] = "\xce\x60", [0x4d21] = "\xce\x61",
  [0x4d22] = "\xce\x62", [0x4d23] = "\xce\x63", [0x4d24] = "\xce\x64",
  [0x4d25] = "\xce\x65", [0x4d26] = "\xce\x66", [0x4d27] = "\xce\x67",
  [0x4d28] = "\xce\x68", [0x4d29] = "\xce\x69", [0x4d2a] = "\xce\x6a",
  [0x4d2b] = "\xce\x6b", [0x4d2c] = "\xce\x6c", [0x4d2d] = "\xce\x6d",
  [0x4d2e] = "\xce\x6e", [0x4d2f] = "\xce\x6f", [0x4d30] = "\xce\x70",
  [0x4d31] = "\xce\x71", [0x4d32] = "\xce\x72", [0x4d33] = "\xce\x73",
  [0x4d34] = "\xce\x74", [0x4d35] = "\xce\x75", [0x4d36] = "\xce\x76",
  [0x4d37] = "\xce\x77", [0x4d38] = "\xce\x78", [0x4d39] = "\xce\x79",
  [0x4d3a] = "\xce\x7a", [0x4d3b] = "\xce\x7b", [0x4d3c] = "\xce\x7c",
  [0x4d3d] = "\xce\x7d", [0x4d3e] = "\xce\x7e", [0x4d40] = "\xce\x80",
  [0x4d41] = "\xce\x81", [0x4d42] = "\xce\x82", [0x4d43] = "\xce\x83",
  [0x4d44] = "\xce\x84", [0x4d45] = "\xce\x85", [0x4d46] = "\xce\x86",
  [0x4d47] = "\xce\x87", [0x4d48] = "\xce\x88", [0x4d49] = "\xce\x89",
  [0x4d4a] = "\xce\x8a", [0x4d4b] = "\xce\x8b", [0x4d4c] = "\xce\x8c",
  [0x4d4d] = "\xce\x8d", [0x4d4e] = "\xce\x8e", [0x4d4f] = "\xce\x8f",
  [0x4d50] = "\xce\x90", [0x4d51] = "\xce\x91", [0x4d52] = "\xce\x92",
  [0x4d53] = "\xce\x93", [0x4d54] = "\xce\x94", [0x4d55] = "\xce\x95",
  [0x4d56] = "\xce\x96", [0x4d57] = "\xce\x97", [0x4d58] = "\xce\x98",
  [0x4d59] = "\xce\x99", [0x4d5a] = "\xce\x9a", [0x4d5b] = "\xce\x9b",
  [0x4d5c] = "\xce\x9c", [0x4d5d] = "\xce\x9d", [0x4d5e] = "\xce\x9e",
  [0x4d5f] = "\xce\x9f", [0x4d60] = "\xce\xa0", [0x4d61] = "\xce\xa1",
  [0x4d62] = "\xce\xa2", [0x4d63] = "\xce\xa3", [0x4d64] = "\xce\xa4",
  [0x4d65] = "\xce\xa5", [0x4d66] = "\xce\xa6", [0x4d67] = "\xce\xa7",
  [0x4d68] = "\xce\xa8", [0x4d69] = "\xce\xa9", [0x4d6a] = "\xce\xaa",
  [0x4d6b] = "\xce\xab", [0x4d6c] = "\xce\xac", [0x4d6d] = "\xce\xad",
  [0x4d6e] = "\xce\xae", [0x4d6f] = "\xce\xaf", [0x4d70] = "\xce\xb0",
  [0x4d71] = "\xce\xb1", [0x4d72] = "\xce\xb2", [0x4d73] = "\xce\xb3",
  [0x4d74] = "\xce\xb4", [0x4d75] = "\xce\xb5", [0x4d76] = "\xce\xb6",
  [0x4d77] = "\xce\xb7", [0x4d78] = "\xce\xb8", [0x4d79] = "\xce\xb9",
  [0x4d7a] = "\xce\xba", [0x4d7b] = "\xce\xbb", [0x4d7c] = "\xce\xbc",
  [0x4d7d] = "\xce\xbd", [0x4d7e] = "\xce\xbe", [0x4d7f] = "\xce\xbf",
  [0x4d80] = "\xce\xc0", [0x4d81] = "\xce\xc1", [0x4d82] = "\xce\xc2",
  [0x4d83] = "\xce\xc3", [0x4d84] = "\xce\xc4", [0x4d85] = "\xce\xc5",
  [0x4d86] = "\xce\xc6", [0x4d87] = "\xce\xc7", [0x4d88] = "\xce\xc8",
  [0x4d89] = "\xce\xc9", [0x4d8a] = "\xce\xca", [0x4d8b] = "\xce\xcb",
  [0x4d8c] = "\xce\xcc", [0x4d8d] = "\xce\xcd", [0x4d8e] = "\xce\xce",
  [0x4d8f] = "\xce\xcf", [0x4d90] = "\xce\xd0", [0x4d91] = "\xce\xd1",
  [0x4d92] = "\xce\xd2", [0x4d93] = "\xce\xd3", [0x4d94] = "\xce\xd4",
  [0x4d95] = "\xce\xd5", [0x4d96] = "\xce\xd6", [0x4d97] = "\xce\xd7",
  [0x4d98] = "\xce\xd8", [0x4d99] = "\xce\xd9", [0x4d9a] = "\xce\xda",
  [0x4d9b] = "\xce\xdb", [0x4d9c] = "\xce\xdc", [0x4d9d] = "\xce\xdd",
  [0x4d9e] = "\xce\xde", [0x4d9f] = "\xce\xdf", [0x4da0] = "\xce\xe0",
  [0x4da1] = "\xce\xe1", [0x4da2] = "\xce\xe2", [0x4da3] = "\xce\xe3",
  [0x4da4] = "\xce\xe4", [0x4da5] = "\xce\xe5", [0x4da6] = "\xce\xe6",
  [0x4da7] = "\xce\xe7", [0x4da8] = "\xce\xe8", [0x4da9] = "\xce\xe9",
  [0x4daa] = "\xce\xea", [0x4dab] = "\xce\xeb", [0x4dac] = "\xce\xec",
  [0x4dad] = "\xce\xed", [0x4dae] = "\xce\xee", [0x4daf] = "\xce\xef",
  [0x4db0] = "\xce\xf0", [0x4db1] = "\xce\xf1", [0x4db2] = "\xce\xf2",
  [0x4db3] = "\xce\xf3", [0x4db4] = "\xce\xf4", [0x4db5] = "\xce\xf5",
  [0x4db6] = "\xce\xf6", [0x4db7] = "\xce\xf7", [0x4db8] = "\xce\xf8",
  [0x4db9] = "\xce\xf9", [0x4dba] = "\xce\xfa", [0x4dbb] = "\xce\xfb",
  [0x4dbc] = "\xce\xfc", [0x4dbd] = "\xce\xfd", [0x4dbe] = "\xce\xfe",
  [0x4e00] = "\xcf\x40", [0x4e01] = "\xcf\x41", [0x4e02] = "\xcf\x42",
  [0x4e03] = "\xcf\x43", [0x4e04] = "\xcf\x44", [0x4e05] = "\xcf\x45",
  [0x4e06] = "\xcf\x46", [0x4e07] = "\xcf\x47", [0x4e08] = "\xcf\x48",
  [0x4e09] = "\xcf\x49", [0x4e0a] = "\xcf\x4a", [0x4e0b] = "\xcf\x4b",
  [0x4e0c] = "\xcf\x4c", [0x4e0d] = "\xcf\x4d", [0x4e0e] = "\xcf\x4e",
  [0x4e0f] = "\xcf\x4f", [0x4e10] = "\xcf\x50", [0x4e11] = "\xcf\x51",
  [0x4e12] = "\xcf\x52", [0x4e13] = "\xcf\x53", [0x4e14] = "\xcf\x54",
  [0x4e15] = "\xcf\x55", [0x4e16] = "\xcf\x56", [0x4e17] = "\xcf\x57",
  [0x4e18] = "\xcf\x58", [0x4e19] = "\xcf\x59", [0x4e1a] = "\xcf\x5a",
  [0x4e1b] = "\xcf\x5b", [0x4e1c] = "\xcf\x5c", [0x4e1d] = "\xcf\x5d",
  [0x4e1e] = "\xcf\x5e", [0x4e1f] = "\xcf\x5f", [0x4e20] = "\xcf\x60",
  [0x4e21] = "\xcf\x61", [0x4e22] = "\xcf\x62", [0x4e23] = "\xcf\x63",
  [0x4e24] = "\xcf\x64", [0x4e25] = "\xcf\x65", [0x4e26] = "\xcf\x66",
  [0x4e27] = "\xcf\x67", [0x4e28] = "\xcf\x68", [0x4e29] = "\xcf\x69",
  [0x4e2a] = "\xcf\x6a", [0x4e2b] = "\xcf\x6b", [0x4e2c] = "\xcf\x6c",
  [0x4e2d] = "\xcf\x6d", [0x4e2e] = "\xcf\x6e", [0x4e2f] = "\xcf\x6f",
  [0x4e30] = "\xcf\x70", [0x4e31] = "\xcf\x71", [0x4e32] = "\xcf\x72",
  [0x4e33] = "\xcf\x73", [0x4e34] = "\xcf\x74", [0x4e35] = "\xcf\x75",
  [0x4e36] = "\xcf\x76", [0x4e37] = "\xcf\x77", [0x4e38] = "\xcf\x78",
  [0x4e39] = "\xcf\x79", [0x4e3a] = "\xcf\x7a", [0x4e3b] = "\xcf\x7b",
  [0x4e3c] = "\xcf\x7c", [0x4e3d] = "\xcf\x7d", [0x4e3e] = "\xcf\x7e",
  [0x4e40] = "\xcf\x80", [0x4e41] = "\xcf\x81", [0x4e42] = "\xcf\x82",
  [0x4e43] = "\xcf\x83", [0x4e44] = "\xcf\x84", [0x4e45] = "\xcf\x85",
  [0x4e46] = "\xcf\x86", [0x4e47] = "\xcf\x87", [0x4e48] = "\xcf\x88",
  [0x4e49] = "\xcf\x89", [0x4e4a] = "\xcf\x8a", [0x4e4b] = "\xcf\x8b",
  [0x4e4c] = "\xcf\x8c", [0x4e4d] = "\xcf\x8d", [0x4e4e] = "\xcf\x8e",
  [0x4e4f] = "\xcf\x8f", [0x4e50] = "\xcf\x90", [0x4e51] = "\xcf\x91",
  [0x4e52] = "\xcf\x92", [0x4e53] = "\xcf\x93", [0x4e54] = "\xcf\x94",
  [0x4e55] = "\xcf\x95", [0x4e56] = "\xcf\x96", [0x4e57] = "\xcf\x97",
  [0x4e58] = "\xcf\x98", [0x4e59] = "\xcf\x99", [0x4e5a] = "\xcf\x9a",
  [0x4e5b] = "\xcf\x9b", [0x4e5c] = "\xcf\x9c", [0x4e5d] = "\xcf\x9d",
  [0x4e5e] = "\xcf\x9e", [0x4e5f] = "\xcf\x9f", [0x4e60] = "\xcf\xa0",
  [0x4e61] = "\xcf\xa1", [0x4e62] = "\xcf\xa2", [0x4e63] = "\xcf\xa3",
  [0x4e64] = "\xcf\xa4", [0x4e65] = "\xcf\xa5", [0x4e66] = "\xcf\xa6",
  [0x4e67] = "\xcf\xa7", [0x4e68] = "\xcf\xa8", [0x4e69] = "\xcf\xa9",
  [0x4e6a] = "\xcf\xaa", [0x4e6b] = "\xcf\xab", [0x4e6c] = "\xcf\xac",
  [0x4e6d] = "\xcf\xad", [0x4e6e] = "\xcf\xae", [0x4e6f] = "\xcf\xaf",
  [0x4e70] = "\xcf\xb0", [0x4e71] = "\xcf\xb1", [0x4e72] = "\xcf\xb2",
  [0x4e73] = "\xcf\xb3", [0x4e74] = "\xcf\xb4", [0x4e75] = "\xcf\xb5",
  [0x4e76] = "\xcf\xb6", [0x4e77] = "\xcf\xb7", [0x4e78] = "\xcf\xb8",
  [0x4e79] = "\xcf\xb9", [0x4e7a] = "\xcf\xba", [0x4e7b] = "\xcf\xbb",
  [0x4e7c] = "\xcf\xbc", [0x4e7d] = "\xcf\xbd", [0x4e7e] = "\xcf\xbe",
  [0x4e7f] = "\xcf\xbf", [0x4e80] = "\xcf\xc0", [0x4e81] = "\xcf\xc1",
  [0x4e82] = "\xcf\xc2", [0x4e83] = "\xcf\xc3", [0x4e84] = "\xcf\xc4",
  [0x4e85] = "\xcf\xc5", [0x4e86] = "\xcf\xc6", [0x4e87] = "\xcf\xc7",
  [0x4e88] = "\xcf\xc8", [0x4e89] = "\xcf\xc9", [0x4e8a] = "\xcf\xca",
  [0x4e8b] = "\xcf\xcb", [0x4e8c] = "\xcf\xcc", [0x4e8d] = "\xcf\xcd",
  [0x4e8e] = "\xcf\xce", [0x4e8f] = "\xcf\xcf", [0x4e90] = "\xcf\xd0",
  [0x4e91] = "\xcf\xd1", [0x4e92] = "\xcf\xd2", [0x4e93] = "\xcf\xd3",
  [0x4e94] = "\xcf\xd4", [0x4e95] = "\xcf\xd5", [0x4e96] = "\xcf\xd6",
  [0x4e97] = "\xcf\xd7", [0x4e98] = "\xcf\xd8", [0x4e99] = "\xcf\xd9",
  [0x4e9a] = "\xcf\xda", [0x4e9b] = "\xcf\xdb", [0x4e9c] = "\xcf\xdc",
  [0x4e9d] = "\xcf\xdd", [0x4e9e] = "\xcf\xde", [0x4e9f] = "\xcf\xdf",
  [0x4ea0] = "\xcf\xe0", [0x4ea1] = "\xcf\xe1", [0x4ea2] = "\xcf\xe2",
  [0x4ea3] = "\xcf\xe3", [0x4ea4] = "\xcf\xe4", [0x4ea5] = "\xcf\xe5",
  [0x4ea6] = "\xcf\xe6", [0x4ea7] = "\xcf\xe7", [0x4ea8] = "\xcf\xe8",
  [0x4ea9] = "\xcf\xe9", [0x4eaa] = "\xcf\xea", [0x4eab] = "\xcf\xeb",
  [0x4eac] = "\xcf\xec", [0x4ead] = "\xcf\xed", [0x4eae] = "\xcf\xee",
  [0x4eaf] = "\xcf\xef", [0x4eb0] = "\xcf\xf0", [0x4eb1] = "\xcf\xf1",
  [0x4eb2] = "\xcf\xf2", [0x4eb3] = "\xcf\xf3", [0x4eb4] = "\xcf\xf4",
  [0x4eb5] = "\xcf\xf5", [0x4eb6] = "\xcf\xf6", [0x4eb7] = "\xcf\xf7",
  [0x4eb8] = "\xcf\xf8", [0x4eb9] = "\xcf\xf9", [0x4eba] = "\xcf\xfa",
  [0x4ebb] = "\xcf\xfb", [0x4ebc] = "\xcf\xfc", [0x4ebd] = "\xcf\xfd",
  [0x4ebe] = "\xcf\xfe", [0x4f00] = "\xd0\x40", [0x4f01] = "\xd0\x41",
  [0x4f02] = "\xd0\x42", [0x4f03] = "\xd0\x43", [0x4f04] = "\xd0\x44",
  [0x4f05] = "\xd0\x45", [0x4f06] = "\xd0\x46", [0x4f07] = "\xd0\x47",
  [0x4f08] = "\xd0\x48", [0x4f09] = "\xd0\x49", [0x4f0a] = "\xd0\x4a",
  [0x4f0b] = "\xd0\x4b", [0x4f0c] = "\xd0\x4c", [0x4f0d] = "\xd0\x4d",
  [0x4f0e] = "\xd0\x4e", [0x4f0f] = "\xd0\x4f", [0x4f10] = "\xd0\x50",
  [0x4f11] = "\xd0\x51", [0x4f12] = "\xd0\x52", [0x4f13] = "\xd0\x53",
  [0x4f14] = "\xd0\x54", [0x4f15] = "\xd0\x55", [0x4f16] = "\xd0\x56",
  [0x4f17] = "\xd0\x57", [0x4f18] = "\xd0\x58", [0x4f19] = "\xd0\x59",
  [0x4f1a] = "\xd0\x5a", [0x4f1b] = "\xd0\x5b", [0x4f1c] = "\xd0\x5c",
  [0x4f1d] = "\xd0\x5d", [0x4f1e] = "\xd0\x5e", [0x4f1f] = "\xd0\x5f",
  [0x4f20] = "\xd0\x60", [0x4f21] = "\xd0\x61", [0x4f22] = "\xd0\x62",
  [0x4f23] = "\xd0\x63", [0x4f24] = "\xd0\x64", [0x4f25] = "\xd0\x65",
  [0x4f26] = "\xd0\x66", [0x4f27] = "\xd0\x67", [0x4f28] = "\xd0\x68",
  [0x4f29] = "\xd0\x69", [0x4f2a] = "\xd0\x6a", [0x4f2b] = "\xd0\x6b",
  [0x4f2c] = "\xd0\x6c", [0x4f2d] = "\xd0\x6d", [0x4f2e] = "\xd0\x6e",
  [0x4f2f] = "\xd0\x6f", [0x4f30] = "\xd0\x70", [0x4f31] = "\xd0\x71",
  [0x4f32] = "\xd0\x72", [0x4f33] = "\xd0\x73", [0x4f34] = "\xd0\x74",
  [0x4f35] = "\xd0\x75", [0x4f36] = "\xd0\x76", [0x4f37] = "\xd0\x77",
  [0x4f38] = "\xd0\x78", [0x4f39] = "\xd0\x79", [0x4f3a] = "\xd0\x7a",
  [0x4f3b] = "\xd0\x7b", [0x4f3c] = "\xd0\x7c", [0x4f3d] = "\xd0\x7d",
  [0x4f3e] = "\xd0\x7e", [0x4f40] = "\xd0\x80", [0x4f41] = "\xd0\x81",
  [0x4f42] = "\xd0\x82", [0x4f43] = "\xd0\x83", [0x4f44] = "\xd0\x84",
  [0x4f45] = "\xd0\x85", [0x4f46] = "\xd0\x86", [0x4f47] = "\xd0\x87",
  [0x4f48] = "\xd0\x88", [0x4f49] = "\xd0\x89", [0x4f4a] = "\xd0\x8a",
  [0x4f4b] = "\xd0\x8b", [0x4f4c] = "\xd0\x8c", [0x4f4d] = "\xd0\x8d",
  [0x4f4e] = "\xd0\x8e", [0x4f4f] = "\xd0\x8f", [0x4f50] = "\xd0\x90",
  [0x4f51] = "\xd0\x91", [0x4f52] = "\xd0\x92", [0x4f53] = "\xd0\x93",
  [0x4f54] = "\xd0\x94", [0x4f55] = "\xd0\x95", [0x4f56] = "\xd0\x96",
  [0x4f57] = "\xd0\x97", [0x4f58] = "\xd0\x98", [0x4f59] = "\xd0\x99",
  [0x4f5a] = "\xd0\x9a", [0x4f5b] = "\xd0\x9b", [0x4f5c] = "\xd0\x9c",
  [0x4f5d] = "\xd0\x9d", [0x4f5e] = "\xd0\x9e", [0x4f5f] = "\xd0\x9f",
  [0x4f60] = "\xd0\xa0", [0x4f61] = "\xd0\xa1", [0x4f62] = "\xd0\xa2",
  [0x4f63] = "\xd0\xa3", [0x4f64] = "\xd0\xa4", [0x4f65] = "\xd0\xa5",
  [0x4f66] = "\xd0\xa6", [0x4f67] = "\xd0\xa7", [0x4f68] = "\xd0\xa8",
  [0x4f69] = "\xd0\xa9", [0x4f6a] = "\xd0\xaa", [0x4f6b] = "\xd0\xab",
  [0x4f6c] = "\xd0\xac", [0x4f6d] = "\xd0\xad", [0x4f6e] = "\xd0\xae",
  [0x4f6f] = "\xd0\xaf", [0x4f70] = "\xd0\xb0", [0x4f71] = "\xd0\xb1",
  [0x4f72] = "\xd0\xb2", [0x4f73] = "\xd0\xb3", [0x4f74] = "\xd0\xb4",
  [0x4f75] = "\xd0\xb5", [0x4f76] = "\xd0\xb6", [0x4f77] = "\xd0\xb7",
  [0x4f78] = "\xd0\xb8", [0x4f79] = "\xd0\xb9", [0x4f7a] = "\xd0\xba",
  [0x4f7b] = "\xd0\xbb", [0x4f7c] = "\xd0\xbc", [0x4f7d] = "\xd0\xbd",
  [0x4f7e] = "\xd0\xbe", [0x4f7f] = "\xd0\xbf", [0x4f80] = "\xd0\xc0",
  [0x4f81] = "\xd0\xc1", [0x4f82] = "\xd0\xc2", [0x4f83] = "\xd0\xc3",
  [0x4f84] = "\xd0\xc4", [0x4f85] = "\xd0\xc5", [0x4f86] = "\xd0\xc6",
  [0x4f87] = "\xd0\xc7", [0x4f88] = "\xd0\xc8", [0x4f89] = "\xd0\xc9",
  [0x4f8a] = "\xd0\xca", [0x4f8b] = "\xd0\xcb", [0x4f8c] = "\xd0\xcc",
  [0x4f8d] = "\xd0\xcd", [0x4f8e] = "\xd0\xce", [0x4f8f] = "\xd0\xcf",
  [0x4f90] = "\xd0\xd0", [0x4f91] = "\xd0\xd1", [0x4f92] = "\xd0\xd2",
  [0x4f93] = "\xd0\xd3", [0x4f94] = "\xd0\xd4", [0x4f95] = "\xd0\xd5",
  [0x4f96] = "\xd0\xd6", [0x4f97] = "\xd0\xd7", [0x4f98] = "\xd0\xd8",
  [0x4f99] = "\xd0\xd9", [0x4f9a] = "\xd0\xda", [0x4f9b] = "\xd0\xdb",
  [0x4f9c] = "\xd0\xdc", [0x4f9d] = "\xd0\xdd", [0x4f9e] = "\xd0\xde",
  [0x4f9f] = "\xd0\xdf", [0x4fa0] = "\xd0\xe0", [0x4fa1] = "\xd0\xe1",
  [0x4fa2] = "\xd0\xe2", [0x4fa3] = "\xd0\xe3", [0x4fa4] = "\xd0\xe4",
  [0x4fa5] = "\xd0\xe5", [0x4fa6] = "\xd0\xe6", [0x4fa7] = "\xd0\xe7",
  [0x4fa8] = "\xd0\xe8", [0x4fa9] = "\xd0\xe9", [0x4faa] = "\xd0\xea",
  [0x4fab] = "\xd0\xeb", [0x4fac] = "\xd0\xec", [0x4fad] = "\xd0\xed",
  [0x4fae] = "\xd0\xee", [0x4faf] = "\xd0\xef", [0x4fb0] = "\xd0\xf0",
  [0x4fb1] = "\xd0\xf1", [0x4fb2] = "\xd0\xf2", [0x4fb3] = "\xd0\xf3",
  [0x4fb4] = "\xd0\xf4", [0x4fb5] = "\xd0\xf5", [0x4fb6] = "\xd0\xf6",
  [0x4fb7] = "\xd0\xf7", [0x4fb8] = "\xd0\xf8", [0x4fb9] = "\xd0\xf9",
  [0x4fba] = "\xd0\xfa", [0x4fbb] = "\xd0\xfb", [0x4fbc] = "\xd0\xfc",
  [0x4fbd] = "\xd0\xfd", [0x4fbe] = "\xd0\xfe", [0x5000] = "\xd1\x40",
  [0x5001] = "\xd1\x41", [0x5002] = "\xd1\x42", [0x5003] = "\xd1\x43",
  [0x5004] = "\xd1\x44", [0x5005] = "\xd1\x45", [0x5006] = "\xd1\x46",
  [0x5007] = "\xd1\x47", [0x5008] = "\xd1\x48", [0x5009] = "\xd1\x49",
  [0x500a] = "\xd1\x4a", [0x500b] = "\xd1\x4b", [0x500c] = "\xd1\x4c",
  [0x500d] = "\xd1\x4d", [0x500e] = "\xd1\x4e", [0x500f] = "\xd1\x4f",
  [0x5010] = "\xd1\x50", [0x5011] = "\xd1\x51", [0x5012] = "\xd1\x52",
  [0x5013] = "\xd1\x53", [0x5014] = "\xd1\x54", [0x5015] = "\xd1\x55",
  [0x5016] = "\xd1\x56", [0x5017] = "\xd1\x57", [0x5018] = "\xd1\x58",
  [0x5019] = "\xd1\x59", [0x501a] = "\xd1\x5a", [0x501b] = "\xd1\x5b",
  [0x501c] = "\xd1\x5c", [0x501d] = "\xd1\x5d", [0x501e] = "\xd1\x5e",
  [0x501f] = "\xd1\x5f", [0x5020] = "\xd1\x60", [0x5021] = "\xd1\x61",
  [0x5022] = "\xd1\x62", [0x5023] = "\xd1\x63", [0x5024] = "\xd1\x64",
  [0x5025] = "\xd1\x65", [0x5026] = "\xd1\x66", [0x5027] = "\xd1\x67",
  [0x5028] = "\xd1\x68", [0x5029] = "\xd1\x69", [0x502a] = "\xd1\x6a",
  [0x502b] = "\xd1\x6b", [0x502c] = "\xd1\x6c", [0x502d] = "\xd1\x6d",
  [0x502e] = "\xd1\x6e", [0x502f] = "\xd1\x6f", [0x5030] = "\xd1\x70",
  [0x5031] = "\xd1\x71", [0x5032] = "\xd1\x72", [0x5033] = "\xd1\x73",
  [0x5034] = "\xd1\x74", [0x5035] = "\xd1\x75", [0x5036] = "\xd1\x76",
  [0x5037] = "\xd1\x77", [0x5038] = "\xd1\x78", [0x5039] = "\xd1\x79",
  [0x503a] = "\xd1\x7a", [0x503b] = "\xd1\x7b", [0x503c] = "\xd1\x7c",
  [0x503d] = "\xd1\x7d", [0x503e] = "\xd1\x7e", [0x5040] = "\xd1\x80",
  [0x5041] = "\xd1\x81", [0x5042] = "\xd1\x82", [0x5043] = "\xd1\x83",
  [0x5044] = "\xd1\x84", [0x5045] = "\xd1\x85", [0x5046] = "\xd1\x86",
  [0x5047] = "\xd1\x87", [0x5048] = "\xd1\x88", [0x5049] = "\xd1\x89",
  [0x504a] = "\xd1\x8a", [0x504b] = "\xd1\x8b", [0x504c] = "\xd1\x8c",
  [0x504d] = "\xd1\x8d", [0x504e] = "\xd1\x8e", [0x504f] = "\xd1\x8f",
  [0x5050] = "\xd1\x90", [0x5051] = "\xd1\x91", [0x5052] = "\xd1\x92",
  [0x5053] = "\xd1\x93", [0x5054] = "\xd1\x94", [0x5055] = "\xd1\x95",
  [0x5056] = "\xd1\x96", [0x5057] = "\xd1\x97", [0x5058] = "\xd1\x98",
  [0x5059] = "\xd1\x99", [0x505a] = "\xd1\x9a", [0x505b] = "\xd1\x9b",
  [0x505c] = "\xd1\x9c", [0x505d] = "\xd1\x9d", [0x505e] = "\xd1\x9e",
  [0x505f] = "\xd1\x9f", [0x5060] = "\xd1\xa0", [0x5061] = "\xd1\xa1",
  [0x5062] = "\xd1\xa2", [0x5063] = "\xd1\xa3", [0x5064] = "\xd1\xa4",
  [0x5065] = "\xd1\xa5", [0x5066] = "\xd1\xa6", [0x5067] = "\xd1\xa7",
  [0x5068] = "\xd1\xa8", [0x5069] = "\xd1\xa9", [0x506a] = "\xd1\xaa",
  [0x506b] = "\xd1\xab", [0x506c] = "\xd1\xac", [0x506d] = "\xd1\xad",
  [0x506e] = "\xd1\xae", [0x506f] = "\xd1\xaf", [0x5070] = "\xd1\xb0",
  [0x5071] = "\xd1\xb1", [0x5072] = "\xd1\xb2", [0x5073] = "\xd1\xb3",
  [0x5074] = "\xd1\xb4", [0x5075] = "\xd1\xb5", [0x5076] = "\xd1\xb6",
  [0x5077] = "\xd1\xb7", [0x5078] = "\xd1\xb8", [0x5079] = "\xd1\xb9",
  [0x507a] = "\xd1\xba", [0x507b] = "\xd1\xbb", [0x507c] = "\xd1\xbc",
  [0x507d] = "\xd1\xbd", [0x507e] = "\xd1\xbe", [0x507f] = "\xd1\xbf",
  [0x5080] = "\xd1\xc0", [0x5081] = "\xd1\xc1", [0x5082] = "\xd1\xc2",
  [0x5083] = "\xd1\xc3", [0x5084] = "\xd1\xc4", [0x5085] = "\xd1\xc5",
  [0x5086] = "\xd1\xc6", [0x5087] = "\xd1\xc7", [0x5088] = "\xd1\xc8",
  [0x5089] = "\xd1\xc9", [0x508a] = "\xd1\xca", [0x508b] = "\xd1\xcb",
  [0x508c] = "\xd1\xcc", [0x508d] = "\xd1\xcd", [0x508e] = "\xd1\xce",
  [0x508f] = "\xd1\xcf", [0x5090] = "\xd1\xd0", [0x5091] = "\xd1\xd1",
  [0x5092] = "\xd1\xd2", [0x5093] = "\xd1\xd3", [0x5094] = "\xd1\xd4",
  [0x5095] = "\xd1\xd5", [0x5096] = "\xd1\xd6", [0x5097] = "\xd1\xd7",
  [0x5098] = "\xd1\xd8", [0x5099] = "\xd1\xd9", [0x509a] = "\xd1\xda",
  [0x509b] = "\xd1\xdb", [0x509c] = "\xd1\xdc", [0x509d] = "\xd1\xdd",
  [0x509e] = "\xd1\xde", [0x509f] = "\xd1\xdf", [0x50a0] = "\xd1\xe0",
  [0x50a1] = "\xd1\xe1", [0x50a2] = "\xd1\xe2", [0x50a3] = "\xd1\xe3",
  [0x50a4] = "\xd1\xe4", [0x50a5] = "\xd1\xe5", [0x50a6] = "\xd1\xe6",
  [0x50a7] = "\xd1\xe7", [0x50a8] = "\xd1\xe8", [0x50a9] = "\xd1\xe9",
  [0x50aa] = "\xd1\xea", [0x50ab] = "\xd1\xeb", [0x50ac] = "\xd1\xec",
  [0x50ad] = "\xd1\xed", [0x50ae] = "\xd1\xee", [0x50af] = "\xd1\xef",
  [0x50b0] = "\xd1\xf0", [0x50b1] = "\xd1\xf1", [0x50b2] = "\xd1\xf2",
  [0x50b3] = "\xd1\xf3", [0x50b4] = "\xd1\xf4", [0x50b5] = "\xd1\xf5",
  [0x50b6] = "\xd1\xf6", [0x50b7] = "\xd1\xf7", [0x50b8] = "\xd1\xf8",
  [0x50b9] = "\xd1\xf9", [0x50ba] = "\xd1\xfa", [0x50bb] = "\xd1\xfb",
  [0x50bc] = "\xd1\xfc", [0x50bd] = "\xd1\xfd", [0x50be] = "\xd1\xfe",
  [0x5100] = "\xd2\x40", [0x5101] = "\xd2\x41", [0x5102] = "\xd2\x42",
  [0x5103] = "\xd2\x43", [0x5104] = "\xd2\x44", [0x5105] = "\xd2\x45",
  [0x5106] = "\xd2\x46", [0x5107] = "\xd2\x47", [0x5108] = "\xd2\x48",
  [0x5109] = "\xd2\x49", [0x510a] = "\xd2\x4a", [0x510b] = "\xd2\x4b",
  [0x510c] = "\xd2\x4c", [0x510d] = "\xd2\x4d", [0x510e] = "\xd2\x4e",
  [0x510f] = "\xd2\x4f", [0x5110] = "\xd2\x50", [0x5111] = "\xd2\x51",
  [0x5112] = "\xd2\x52", [0x5113] = "\xd2\x53", [0x5114] = "\xd2\x54",
  [0x5115] = "\xd2\x55", [0x5116] = "\xd2\x56", [0x5117] = "\xd2\x57",
  [0x5118] = "\xd2\x58", [0x5119] = "\xd2\x59", [0x511a] = "\xd2\x5a",
  [0x511b] = "\xd2\x5b", [0x511c] = "\xd2\x5c", [0x511d] = "\xd2\x5d",
  [0x511e] = "\xd2\x5e", [0x511f] = "\xd2\x5f", [0x5120] = "\xd2\x60",
  [0x5121] = "\xd2\x61", [0x5122] = "\xd2\x62", [0x5123] = "\xd2\x63",
  [0x5124] = "\xd2\x64", [0x5125] = "\xd2\x65", [0x5126] = "\xd2\x66",
  [0x5127] = "\xd2\x67", [0x5128] = "\xd2\x68", [0x5129] = "\xd2\x69",
  [0x512a] = "\xd2\x6a", [0x512b] = "\xd2\x6b", [0x512c] = "\xd2\x6c",
  [0x512d] = "\xd2\x6d", [0x512e] = "\xd2\x6e", [0x512f] = "\xd2\x6f",
  [0x5130] = "\xd2\x70", [0x5131] = "\xd2\x71", [0x5132] = "\xd2\x72",
  [0x5133] = "\xd2\x73", [0x5134] = "\xd2\x74", [0x5135] = "\xd2\x75",
  [0x5136] = "\xd2\x76", [0x5137] = "\xd2\x77", [0x5138] = "\xd2\x78",
  [0x5139] = "\xd2\x79", [0x513a] = "\xd2\x7a", [0x513b] = "\xd2\x7b",
  [0x513c] = "\xd2\x7c", [0x513d] = "\xd2\x7d", [0x513e] = "\xd2\x7e",
  [0x5140] = "\xd2\x80", [0x5141] = "\xd2\x81", [0x5142] = "\xd2\x82",
  [0x5143] = "\xd2\x83", [0x5144] = "\xd2\x84", [0x5145] = "\xd2\x85",
  [0x5146] = "\xd2\x86", [0x5147] = "\xd2\x87", [0x5148] = "\xd2\x88",
  [0x5149] = "\xd2\x89", [0x514a] = "\xd2\x8a", [0x514b] = "\xd2\x8b",
  [0x514c] = "\xd2\x8c", [0x514d] = "\xd2\x8d", [0x514e] = "\xd2\x8e",
  [0x514f] = "\xd2\x8f", [0x5150] = "\xd2\x90", [0x5151] = "\xd2\x91",
  [0x5152] = "\xd2\x92", [0x5153] = "\xd2\x93", [0x5154] = "\xd2\x94",
  [0x5155] = "\xd2\x95", [0x5156] = "\xd2\x96", [0x5157] = "\xd2\x97",
  [0x5158] = "\xd2\x98", [0x5159] = "\xd2\x99", [0x515a] = "\xd2\x9a",
  [0x515b] = "\xd2\x9b", [0x515c] = "\xd2\x9c", [0x515d] = "\xd2\x9d",
  [0x515e] = "\xd2\x9e", [0x515f] = "\xd2\x9f", [0x5160] = "\xd2\xa0",
  [0x5161] = "\xd2\xa1", [0x5162] = "\xd2\xa2", [0x5163] = "\xd2\xa3",
  [0x5164] = "\xd2\xa4", [0x5165] = "\xd2\xa5", [0x5166] = "\xd2\xa6",
  [0x5167] = "\xd2\xa7", [0x5168] = "\xd2\xa8", [0x5169] = "\xd2\xa9",
  [0x516a] = "\xd2\xaa", [0x516b] = "\xd2\xab", [0x516c] = "\xd2\xac",
  [0x516d] = "\xd2\xad", [0x516e] = "\xd2\xae", [0x516f] = "\xd2\xaf",
  [0x5170] = "\xd2\xb0", [0x5171] = "\xd2\xb1", [0x5172] = "\xd2\xb2",
  [0x5173] = "\xd2\xb3", [0x5174] = "\xd2\xb4", [0x5175] = "\xd2\xb5",
  [0x5176] = "\xd2\xb6", [0x5177] = "\xd2\xb7", [0x5178] = "\xd2\xb8",
  [0x5179] = "\xd2\xb9", [0x517a] = "\xd2\xba", [0x517b] = "\xd2\xbb",
  [0x517c] = "\xd2\xbc", [0x517d] = "\xd2\xbd", [0x517e] = "\xd2\xbe",
  [0x517f] = "\xd2\xbf", [0x5180] = "\xd2\xc0", [0x5181] = "\xd2\xc1",
  [0x5182] = "\xd2\xc2", [0x5183] = "\xd2\xc3", [0x5184] = "\xd2\xc4",
  [0x5185] = "\xd2\xc5", [0x5186] = "\xd2\xc6", [0x5187] = "\xd2\xc7",
  [0x5188] = "\xd2\xc8", [0x5189] = "\xd2\xc9", [0x518a] = "\xd2\xca",
  [0x518b] = "\xd2\xcb", [0x518c] = "\xd2\xcc", [0x518d] = "\xd2\xcd",
  [0x518e] = "\xd2\xce", [0x518f] = "\xd2\xcf", [0x5190] = "\xd2\xd0",
  [0x5191] = "\xd2\xd1", [0x5192] = "\xd2\xd2", [0x5193] = "\xd2\xd3",
  [0x5194] = "\xd2\xd4", [0x5195] = "\xd2\xd5", [0x5196] = "\xd2\xd6",
  [0x5197] = "\xd2\xd7", [0x5198] = "\xd2\xd8", [0x5199] = "\xd2\xd9",
  [0x519a] = "\xd2\xda", [0x519b] = "\xd2\xdb", [0x519c] = "\xd2\xdc",
  [0x519d] = "\xd2\xdd", [0x519e] = "\xd2\xde", [0x519f] = "\xd2\xdf",
  [0x51a0] = "\xd2\xe0", [0x51a1] = "\xd2\xe1", [0x51a2] = "\xd2\xe2",
  [0x51a3] = "\xd2\xe3", [0x51a4] = "\xd2\xe4", [0x51a5] = "\xd2\xe5",
  [0x51a6] = "\xd2\xe6", [0x51a7] = "\xd2\xe7", [0x51a8] = "\xd2\xe8",
  [0x51a9] = "\xd2\xe9", [0x51aa] = "\xd2\xea", [0x51ab] = "\xd2\xeb",
  [0x51ac] = "\xd2\xec", [0x51ad] = "\xd2\xed", [0x51ae] = "\xd2\xee",
  [0x51af] = "\xd2\xef", [0x51b0] = "\xd2\xf0", [0x51b1] = "\xd2\xf1",
  [0x51b2] = "\xd2\xf2", [0x51b3] = "\xd2\xf3", [0x51b4] = "\xd2\xf4",
  [0x51b5] = "\xd2\xf5", [0x51b6] = "\xd2\xf6", [0x51b7] = "\xd2\xf7",
  [0x51b8] = "\xd2\xf8", [0x51b9] = "\xd2\xf9", [0x51ba] = "\xd2\xfa",
  [0x51bb] = "\xd2\xfb", [0x51bc] = "\xd2\xfc", [0x51bd] = "\xd2\xfd",
  [0x51be] = "\xd2\xfe", [0x5200] = "\xd3\x40", [0x5201] = "\xd3\x41",
  [0x5202] = "\xd3\x42", [0x5203] = "\xd3\x43", [0x5204] = "\xd3\x44",
  [0x5205] = "\xd3\x45", [0x5206] = "\xd3\x46", [0x5207] = "\xd3\x47",
  [0x5208] = "\xd3\x48", [0x5209] = "\xd3\x49", [0x520a] = "\xd3\x4a",
  [0x520b] = "\xd3\x4b", [0x520c] = "\xd3\x4c", [0x520d] = "\xd3\x4d",
  [0x520e] = "\xd3\x4e", [0x520f] = "\xd3\x4f", [0x5210] = "\xd3\x50",
  [0x5211] = "\xd3\x51", [0x5212] = "\xd3\x52", [0x5213] = "\xd3\x53",
  [0x5214] = "\xd3\x54", [0x5215] = "\xd3\x55", [0x5216] = "\xd3\x56",
  [0x5217] = "\xd3\x57", [0x5218] = "\xd3\x58", [0x5219] = "\xd3\x59",
  [0x521a] = "\xd3\x5a", [0x521b] = "\xd3\x5b", [0x521c] = "\xd3\x5c",
  [0x521d] = "\xd3\x5d", [0x521e] = "\xd3\x5e", [0x521f] = "\xd3\x5f",
  [0x5220] = "\xd3\x60", [0x5221] = "\xd3\x61", [0x5222] = "\xd3\x62",
  [0x5223] = "\xd3\x63", [0x5224] = "\xd3\x64", [0x5225] = "\xd3\x65",
  [0x5226] = "\xd3\x66", [0x5227] = "\xd3\x67", [0x5228] = "\xd3\x68",
  [0x5229] = "\xd3\x69", [0x522a] = "\xd3\x6a", [0x522b] = "\xd3\x6b",
  [0x522c] = "\xd3\x6c", [0x522d] = "\xd3\x6d", [0x522e] = "\xd3\x6e",
  [0x522f] = "\xd3\x6f", [0x5230] = "\xd3\x70", [0x5231] = "\xd3\x71",
  [0x5232] = "\xd3\x72", [0x5233] = "\xd3\x73", [0x5234] = "\xd3\x74",
  [0x5235] = "\xd3\x75", [0x5236] = "\xd3\x76", [0x5237] = "\xd3\x77",
  [0x5238] = "\xd3\x78", [0x5239] = "\xd3\x79", [0x523a] = "\xd3\x7a",
  [0x523b] = "\xd3\x7b", [0x523c] = "\xd3\x7c", [0x523d] = "\xd3\x7d",
  [0x523e] = "\xd3\x7e", [0x5240] = "\xd3\x80", [0x5241] = "\xd3\x81",
  [0x5242] = "\xd3\x82", [0x5243] = "\xd3\x83", [0x5244] = "\xd3\x84",
  [0x5245] = "\xd3\x85", [0x5246] = "\xd3\x86", [0x5247] = "\xd3\x87",
  [0x5248] = "\xd3\x88", [0x5249] = "\xd3\x89", [0x524a] = "\xd3\x8a",
  [0x524b] = "\xd3\x8b", [0x524c] = "\xd3\x8c", [0x524d] = "\xd3\x8d",
  [0x524e] = "\xd3\x8e", [0x524f] = "\xd3\x8f", [0x5250] = "\xd3\x90",
  [0x5251] = "\xd3\x91", [0x5252] = "\xd3\x92", [0x5253] = "\xd3\x93",
  [0x5254] = "\xd3\x94", [0x5255] = "\xd3\x95", [0x5256] = "\xd3\x96",
  [0x5257] = "\xd3\x97", [0x5258] = "\xd3\x98", [0x5259] = "\xd3\x99",
  [0x525a] = "\xd3\x9a", [0x525b] = "\xd3\x9b", [0x525c] = "\xd3\x9c",
  [0x525d] = "\xd3\x9d", [0x525e] = "\xd3\x9e", [0x525f] = "\xd3\x9f",
  [0x5260] = "\xd3\xa0", [0x5261] = "\xd3\xa1", [0x5262] = "\xd3\xa2",
  [0x5263] = "\xd3\xa3", [0x5264] = "\xd3\xa4", [0x5265] = "\xd3\xa5",
  [0x5266] = "\xd3\xa6", [0x5267] = "\xd3\xa7", [0x5268] = "\xd3\xa8",
  [0x5269] = "\xd3\xa9", [0x526a] = "\xd3\xaa", [0x526b] = "\xd3\xab",
  [0x526c] = "\xd3\xac", [0x526d] = "\xd3\xad", [0x526e] = "\xd3\xae",
  [0x526f] = "\xd3\xaf", [0x5270] = "\xd3\xb0", [0x5271] = "\xd3\xb1",
  [0x5272] = "\xd3\xb2", [0x5273] = "\xd3\xb3", [0x5274] = "\xd3\xb4",
  [0x5275] = "\xd3\xb5", [0x5276] = "\xd3\xb6", [0x5277] = "\xd3\xb7",
  [0x5278] = "\xd3\xb8", [0x5279] = "\xd3\xb9", [0x527a] = "\xd3\xba",
  [0x527b] = "\xd3\xbb", [0x527c] = "\xd3\xbc", [0x527d] = "\xd3\xbd",
  [0x527e] = "\xd3\xbe", [0x527f] = "\xd3\xbf", [0x5280] = "\xd3\xc0",
  [0x5281] = "\xd3\xc1", [0x5282] = "\xd3\xc2", [0x5283] = "\xd3\xc3",
  [0x5284] = "\xd3\xc4", [0x5285] = "\xd3\xc5", [0x5286] = "\xd3\xc6",
  [0x5287] = "\xd3\xc7", [0x5288] = "\xd3\xc8", [0x5289] = "\xd3\xc9",
  [0x528a] = "\xd3\xca", [0x528b] = "\xd3\xcb", [0x528c] = "\xd3\xcc",
  [0x528d] = "\xd3\xcd", [0x528e] = "\xd3\xce", [0x528f] = "\xd3\xcf",
  [0x5290] = "\xd3\xd0", [0x5291] = "\xd3\xd1", [0x5292] = "\xd3\xd2",
  [0x5293] = "\xd3\xd3", [0x5294] = "\xd3\xd4", [0x5295] = "\xd3\xd5",
  [0x5296] = "\xd3\xd6", [0x5297] = "\xd3\xd7", [0x5298] = "\xd3\xd8",
  [0x5299] = "\xd3\xd9", [0x529a] = "\xd3\xda", [0x529b] = "\xd3\xdb",
  [0x529c] = "\xd3\xdc", [0x529d] = "\xd3\xdd", [0x529e] = "\xd3\xde",
  [0x529f] = "\xd3\xdf", [0x52a0] = "\xd3\xe0", [0x52a1] = "\xd3\xe1",
  [0x52a2] = "\xd3\xe2", [0x52a3] = "\xd3\xe3", [0x52a4] = "\xd3\xe4",
  [0x52a5] = "\xd3\xe5", [0x52a6] = "\xd3\xe6", [0x52a7] = "\xd3\xe7",
  [0x52a8] = "\xd3\xe8", [0x52a9] = "\xd3\xe9", [0x52aa] = "\xd3\xea",
  [0x52ab] = "\xd3\xeb", [0x52ac] = "\xd3\xec", [0x52ad] = "\xd3\xed",
  [0x52ae] = "\xd3\xee", [0x52af] = "\xd3\xef", [0x52b0] = "\xd3\xf0",
  [0x52b1] = "\xd3\xf1", [0x52b2] = "\xd3\xf2", [0x52b3] = "\xd3\xf3",
  [0x52b4] = "\xd3\xf4", [0x52b5] = "\xd3\xf5", [0x52b6] = "\xd3\xf6",
  [0x52b7] = "\xd3\xf7", [0x52b8] = "\xd3\xf8", [0x52b9] = "\xd3\xf9",
  [0x52ba] = "\xd3\xfa", [0x52bb] = "\xd3\xfb", [0x52bc] = "\xd3\xfc",
  [0x52bd] = "\xd3\xfd", [0x52be] = "\xd3\xfe", [0x5300] = "\xd4\x40",
  [0x5301] = "\xd4\x41", [0x5302] = "\xd4\x42", [0x5303] = "\xd4\x43",
  [0x5304] = "\xd4\x44", [0x5305] = "\xd4\x45", [0x5306] = "\xd4\x46",
  [0x5307] = "\xd4\x47", [0x5308] = "\xd4\x48", [0x5309] = "\xd4\x49",
  [0x530a] = "\xd4\x4a", [0x530b] = "\xd4\x4b", [0x530c] = "\xd4\x4c",
  [0x530d] = "\xd4\x4d", [0x530e] = "\xd4\x4e", [0x530f] = "\xd4\x4f",
  [0x5310] = "\xd4\x50", [0x5311] = "\xd4\x51", [0x5312] = "\xd4\x52",
  [0x5313] = "\xd4\x53", [0x5314] = "\xd4\x54", [0x5315] = "\xd4\x55",
  [0x5316] = "\xd4\x56", [0x5317] = "\xd4\x57", [0x5318] = "\xd4\x58",
  [0x5319] = "\xd4\x59", [0x531a] = "\xd4\x5a", [0x531b] = "\xd4\x5b",
  [0x531c] = "\xd4\x5c", [0x531d] = "\xd4\x5d", [0x531e] = "\xd4\x5e",
  [0x531f] = "\xd4\x5f", [0x5320] = "\xd4\x60", [0x5321] = "\xd4\x61",
  [0x5322] = "\xd4\x62", [0x5323] = "\xd4\x63", [0x5324] = "\xd4\x64",
  [0x5325] = "\xd4\x65", [0x5326] = "\xd4\x66", [0x5327] = "\xd4\x67",
  [0x5328] = "\xd4\x68", [0x5329] = "\xd4\x69", [0x532a] = "\xd4\x6a",
  [0x532b] = "\xd4\x6b", [0x532c] = "\xd4\x6c", [0x532d] = "\xd4\x6d",
  [0x532e] = "\xd4\x6e", [0x532f] = "\xd4\x6f", [0x5330] = "\xd4\x70",
  [0x5331] = "\xd4\x71", [0x5332] = "\xd4\x72", [0x5333] = "\xd4\x73",
  [0x5334] = "\xd4\x74", [0x5335] = "\xd4\x75", [0x5336] = "\xd4\x76",
  [0x5337] = "\xd4\x77", [0x5338] = "\xd4\x78", [0x5339] = "\xd4\x79",
  [0x533a] = "\xd4\x7a", [0x533b] = "\xd4\x7b", [0x533c] = "\xd4\x7c",
  [0x533d] = "\xd4\x7d", [0x533e] = "\xd4\x7e", [0x5340] = "\xd4\x80",
  [0x5341] = "\xd4\x81", [0x5342] = "\xd4\x82", [0x5343] = "\xd4\x83",
  [0x5344] = "\xd4\x84", [0x5345] = "\xd4\x85", [0x5346] = "\xd4\x86",
  [0x5347] = "\xd4\x87", [0x5348] = "\xd4\x88", [0x5349] = "\xd4\x89",
  [0x534a] = "\xd4\x8a", [0x534b] = "\xd4\x8b", [0x534c] = "\xd4\x8c",
  [0x534d] = "\xd4\x8d", [0x534e] = "\xd4\x8e", [0x534f] = "\xd4\x8f",
  [0x5350] = "\xd4\x90", [0x5351] = "\xd4\x91", [0x5352] = "\xd4\x92",
  [0x5353] = "\xd4\x93", [0x5354] = "\xd4\x94", [0x5355] = "\xd4\x95",
  [0x5356] = "\xd4\x96", [0x5357] = "\xd4\x97", [0x5358] = "\xd4\x98",
  [0x5359] = "\xd4\x99", [0x535a] = "\xd4\x9a", [0x535b] = "\xd4\x9b",
  [0x535c] = "\xd4\x9c", [0x535d] = "\xd4\x9d", [0x535e] = "\xd4\x9e",
  [0x535f] = "\xd4\x9f", [0x5360] = "\xd4\xa0", [0x5361] = "\xd4\xa1",
  [0x5362] = "\xd4\xa2", [0x5363] = "\xd4\xa3", [0x5364] = "\xd4\xa4",
  [0x5365] = "\xd4\xa5", [0x5366] = "\xd4\xa6", [0x5367] = "\xd4\xa7",
  [0x5368] = "\xd4\xa8", [0x5369] = "\xd4\xa9", [0x536a] = "\xd4\xaa",
  [0x536b] = "\xd4\xab", [0x536c] = "\xd4\xac", [0x536d] = "\xd4\xad",
  [0x536e] = "\xd4\xae", [0x536f] = "\xd4\xaf", [0x5370] = "\xd4\xb0",
  [0x5371] = "\xd4\xb1", [0x5372] = "\xd4\xb2", [0x5373] = "\xd4\xb3",
  [0x5374] = "\xd4\xb4", [0x5375] = "\xd4\xb5", [0x5376] = "\xd4\xb6",
  [0x5377] = "\xd4\xb7", [0x5378] = "\xd4\xb8", [0x5379] = "\xd4\xb9",
  [0x537a] = "\xd4\xba", [0x537b] = "\xd4\xbb", [0x537c] = "\xd4\xbc",
  [0x537d] = "\xd4\xbd", [0x537e] = "\xd4\xbe", [0x537f] = "\xd4\xbf",
  [0x5380] = "\xd4\xc0", [0x5381] = "\xd4\xc1", [0x5382] = "\xd4\xc2",
  [0x5383] = "\xd4\xc3", [0x5384] = "\xd4\xc4", [0x5385] = "\xd4\xc5",
  [0x5386] = "\xd4\xc6", [0x5387] = "\xd4\xc7", [0x5388] = "\xd4\xc8",
  [0x5389] = "\xd4\xc9", [0x538a] = "\xd4\xca", [0x538b] = "\xd4\xcb",
  [0x538c] = "\xd4\xcc", [0x538d] = "\xd4\xcd", [0x538e] = "\xd4\xce",
  [0x538f] = "\xd4\xcf", [0x5390] = "\xd4\xd0", [0x5391] = "\xd4\xd1",
  [0x5392] = "\xd4\xd2", [0x5393] = "\xd4\xd3", [0x5394] = "\xd4\xd4",
  [0x5395] = "\xd4\xd5", [0x5396] = "\xd4\xd6", [0x5397] = "\xd4\xd7",
  [0x5398] = "\xd4\xd8", [0x5399] = "\xd4\xd9", [0x539a] = "\xd4\xda",
  [0x539b] = "\xd4\xdb", [0x539c] = "\xd4\xdc", [0x539d] = "\xd4\xdd",
  [0x539e] = "\xd4\xde", [0x539f] = "\xd4\xdf", [0x53a0] = "\xd4\xe0",
  [0x53a1] = "\xd4\xe1", [0x53a2] = "\xd4\xe2", [0x53a3] = "\xd4\xe3",
  [0x53a4] = "\xd4\xe4", [0x53a5] = "\xd4\xe5", [0x53a6] = "\xd4\xe6",
  [0x53a7] = "\xd4\xe7", [0x53a8] = "\xd4\xe8", [0x53a9] = "\xd4\xe9",
  [0x53aa] = "\xd4\xea", [0x53ab] = "\xd4\xeb", [0x53ac] = "\xd4\xec",
  [0x53ad] = "\xd4\xed", [0x53ae] = "\xd4\xee", [0x53af] = "\xd4\xef",
  [0x53b0] = "\xd4\xf0", [0x53b1] = "\xd4\xf1", [0x53b2] = "\xd4\xf2",
  [0x53b3] = "\xd4\xf3", [0x53b4] = "\xd4\xf4", [0x53b5] = "\xd4\xf5",
  [0x53b6] = "\xd4\xf6", [0x53b7] = "\xd4\xf7", [0x53b8] = "\xd4\xf8",
  [0x53b9] = "\xd4\xf9", [0x53ba] = "\xd4\xfa", [0x53bb] = "\xd4\xfb",
  [0x53bc] = "\xd4\xfc", [0x53bd] = "\xd4\xfd", [0x53be] = "\xd4\xfe",
  [0x5400] = "\xd5\x40", [0x5401] = "\xd5\x41", [0x5402] = "\xd5\x42",
  [0x5403] = "\xd5\x43", [0x5404] = "\xd5\x44", [0x5405] = "\xd5\x45",
  [0x5406] = "\xd5\x46", [0x5407] = "\xd5\x47", [0x5408] = "\xd5\x48",
  [0x5409] = "\xd5\x49", [0x540a] = "\xd5\x4a", [0x540b] = "\xd5\x4b",
  [0x540c] = "\xd5\x4c", [0x540d] = "\xd5\x4d", [0x540e] = "\xd5\x4e",
  [0x540f] = "\xd5\x4f", [0x5410] = "\xd5\x50", [0x5411] = "\xd5\x51",
  [0x5412] = "\xd5\x52", [0x5413] = "\xd5\x53", [0x5414] = "\xd5\x54",
  [0x5415] = "\xd5\x55", [0x5416] = "\xd5\x56", [0x5417] = "\xd5\x57",
  [0x5418] = "\xd5\x58", [0x5419] = "\xd5\x59", [0x541a] = "\xd5\x5a",
  [0x541b] = "\xd5\x5b", [0x541c] = "\xd5\x5c", [0x541d] = "\xd5\x5d",
  [0x541e] = "\xd5\x5e", [0x541f] = "\xd5\x5f", [0x5420] = "\xd5\x60",
  [0x5421] = "\xd5\x61", [0x5422] = "\xd5\x62", [0x5423] = "\xd5\x63",
  [0x5424] = "\xd5\x64", [0x5425] = "\xd5\x65", [0x5426] = "\xd5\x66",
  [0x5427] = "\xd5\x67", [0x5428] = "\xd5\x68", [0x5429] = "\xd5\x69",
  [0x542a] = "\xd5\x6a", [0x542b] = "\xd5\x6b", [0x542c] = "\xd5\x6c",
  [0x542d] = "\xd5\x6d", [0x542e] = "\xd5\x6e", [0x542f] = "\xd5\x6f",
  [0x5430] = "\xd5\x70", [0x5431] = "\xd5\x71", [0x5432] = "\xd5\x72",
  [0x5433] = "\xd5\x73", [0x5434] = "\xd5\x74", [0x5435] = "\xd5\x75",
  [0x5436] = "\xd5\x76", [0x5437] = "\xd5\x77", [0x5438] = "\xd5\x78",
  [0x5439] = "\xd5\x79", [0x543a] = "\xd5\x7a", [0x543b] = "\xd5\x7b",
  [0x543c] = "\xd5\x7c", [0x543d] = "\xd5\x7d", [0x543e] = "\xd5\x7e",
  [0x5440] = "\xd5\x80", [0x5441] = "\xd5\x81", [0x5442] = "\xd5\x82",
  [0x5443] = "\xd5\x83", [0x5444] = "\xd5\x84", [0x5445] = "\xd5\x85",
  [0x5446] = "\xd5\x86", [0x5447] = "\xd5\x87", [0x5448] = "\xd5\x88",
  [0x5449] = "\xd5\x89", [0x544a] = "\xd5\x8a", [0x544b] = "\xd5\x8b",
  [0x544c] = "\xd5\x8c", [0x544d] = "\xd5\x8d", [0x544e] = "\xd5\x8e",
  [0x544f] = "\xd5\x8f", [0x5450] = "\xd5\x90", [0x5451] = "\xd5\x91",
  [0x5452] = "\xd5\x92", [0x5453] = "\xd5\x93", [0x5454] = "\xd5\x94",
  [0x5455] = "\xd5\x95", [0x5456] = "\xd5\x96", [0x5457] = "\xd5\x97",
  [0x5458] = "\xd5\x98", [0x5459] = "\xd5\x99", [0x545a] = "\xd5\x9a",
  [0x545b] = "\xd5\x9b", [0x545c] = "\xd5\x9c", [0x545d] = "\xd5\x9d",
  [0x545e] = "\xd5\x9e", [0x545f] = "\xd5\x9f", [0x5460] = "\xd5\xa0",
  [0x5461] = "\xd5\xa1", [0x5462] = "\xd5\xa2", [0x5463] = "\xd5\xa3",
  [0x5464] = "\xd5\xa4", [0x5465] = "\xd5\xa5", [0x5466] = "\xd5\xa6",
  [0x5467] = "\xd5\xa7", [0x5468] = "\xd5\xa8", [0x5469] = "\xd5\xa9",
  [0x546a] = "\xd5\xaa", [0x546b] = "\xd5\xab", [0x546c] = "\xd5\xac",
  [0x546d] = "\xd5\xad", [0x546e] = "\xd5\xae", [0x546f] = "\xd5\xaf",
  [0x5470] = "\xd5\xb0", [0x5471] = "\xd5\xb1", [0x5472] = "\xd5\xb2",
  [0x5473] = "\xd5\xb3", [0x5474] = "\xd5\xb4", [0x5475] = "\xd5\xb5",
  [0x5476] = "\xd5\xb6", [0x5477] = "\xd5\xb7", [0x5478] = "\xd5\xb8",
  [0x5479] = "\xd5\xb9", [0x547a] = "\xd5\xba", [0x547b] = "\xd5\xbb",
  [0x547c] = "\xd5\xbc", [0x547d] = "\xd5\xbd", [0x547e] = "\xd5\xbe",
  [0x547f] = "\xd5\xbf", [0x5480] = "\xd5\xc0", [0x5481] = "\xd5\xc1",
  [0x5482] = "\xd5\xc2", [0x5483] = "\xd5\xc3", [0x5484] = "\xd5\xc4",
  [0x5485] = "\xd5\xc5", [0x5486] = "\xd5\xc6", [0x5487] = "\xd5\xc7",
  [0x5488] = "\xd5\xc8", [0x5489] = "\xd5\xc9", [0x548a] = "\xd5\xca",
  [0x548b] = "\xd5\xcb", [0x548c] = "\xd5\xcc", [0x548d] = "\xd5\xcd",
  [0x548e] = "\xd5\xce", [0x548f] = "\xd5\xcf", [0x5490] = "\xd5\xd0",
  [0x5491] = "\xd5\xd1", [0x5492] = "\xd5\xd2", [0x5493] = "\xd5\xd3",
  [0x5494] = "\xd5\xd4", [0x5495] = "\xd5\xd5", [0x5496] = "\xd5\xd6",
  [0x5497] = "\xd5\xd7", [0x5498] = "\xd5\xd8", [0x5499] = "\xd5\xd9",
  [0x549a] = "\xd5\xda", [0x549b] = "\xd5\xdb", [0x549c] = "\xd5\xdc",
  [0x549d] = "\xd5\xdd", [0x549e] = "\xd5\xde", [0x549f] = "\xd5\xdf",
  [0x54a0] = "\xd5\xe0", [0x54a1] = "\xd5\xe1", [0x54a2] = "\xd5\xe2",
  [0x54a3] = "\xd5\xe3", [0x54a4] = "\xd5\xe4", [0x54a5] = "\xd5\xe5",
  [0x54a6] = "\xd5\xe6", [0x54a7] = "\xd5\xe7", [0x54a8] = "\xd5\xe8",
  [0x54a9] = "\xd5\xe9", [0x54aa] = "\xd5\xea", [0x54ab] = "\xd5\xeb",
  [0x54ac] = "\xd5\xec", [0x54ad] = "\xd5\xed", [0x54ae] = "\xd5\xee",
  [0x54af] = "\xd5\xef", [0x54b0] = "\xd5\xf0", [0x54b1] = "\xd5\xf1",
  [0x54b2] = "\xd5\xf2", [0x54b3] = "\xd5\xf3", [0x54b4] = "\xd5\xf4",
  [0x54b5] = "\xd5\xf5", [0x54b6] = "\xd5\xf6", [0x54b7] = "\xd5\xf7",
  [0x54b8] = "\xd5\xf8", [0x54b9] = "\xd5\xf9", [0x54ba] = "\xd5\xfa",
  [0x54bb] = "\xd5\xfb", [0x54bc] = "\xd5\xfc", [0x54bd] = "\xd5\xfd",
  [0x54be] = "\xd5\xfe", [0x5500] = "\xd6\x40", [0x5501] = "\xd6\x41",
  [0x5502] = "\xd6\x42", [0x5503] = "\xd6\x43", [0x5504] = "\xd6\x44",
  [0x5505] = "\xd6\x45", [0x5506] = "\xd6\x46", [0x5507] = "\xd6\x47",
  [0x5508] = "\xd6\x48", [0x5509] = "\xd6\x49", [0x550a] = "\xd6\x4a",
  [0x550b] = "\xd6\x4b", [0x550c] = "\xd6\x4c", [0x550d] = "\xd6\x4d",
  [0x550e] = "\xd6\x4e", [0x550f] = "\xd6\x4f", [0x5510] = "\xd6\x50",
  [0x5511] = "\xd6\x51", [0x5512] = "\xd6\x52", [0x5513] = "\xd6\x53",
  [0x5514] = "\xd6\x54", [0x5515] = "\xd6\x55", [0x5516] = "\xd6\x56",
  [0x5517] = "\xd6\x57", [0x5518] = "\xd6\x58", [0x5519] = "\xd6\x59",
  [0x551a] = "\xd6\x5a", [0x551b] = "\xd6\x5b", [0x551c] = "\xd6\x5c",
  [0x551d] = "\xd6\x5d", [0x551e] = "\xd6\x5e", [0x551f] = "\xd6\x5f",
  [0x5520] = "\xd6\x60", [0x5521] = "\xd6\x61", [0x5522] = "\xd6\x62",
  [0x5523] = "\xd6\x63", [0x5524] = "\xd6\x64", [0x5525] = "\xd6\x65",
  [0x5526] = "\xd6\x66", [0x5527] = "\xd6\x67", [0x5528] = "\xd6\x68",
  [0x5529] = "\xd6\x69", [0x552a] = "\xd6\x6a", [0x552b] = "\xd6\x6b",
  [0x552c] = "\xd6\x6c", [0x552d] = "\xd6\x6d", [0x552e] = "\xd6\x6e",
  [0x552f] = "\xd6\x6f", [0x5530] = "\xd6\x70", [0x5531] = "\xd6\x71",
  [0x5532] = "\xd6\x72", [0x5533] = "\xd6\x73", [0x5534] = "\xd6\x74",
  [0x5535] = "\xd6\x75", [0x5536] = "\xd6\x76", [0x5537] = "\xd6\x77",
  [0x5538] = "\xd6\x78", [0x5539] = "\xd6\x79", [0x553a] = "\xd6\x7a",
  [0x553b] = "\xd6\x7b", [0x553c] = "\xd6\x7c", [0x553d] = "\xd6\x7d",
  [0x553e] = "\xd6\x7e", [0x5540] = "\xd6\x80", [0x5541] = "\xd6\x81",
  [0x5542] = "\xd6\x82", [0x5543] = "\xd6\x83", [0x5544] = "\xd6\x84",
  [0x5545] = "\xd6\x85", [0x5546] = "\xd6\x86", [0x5547] = "\xd6\x87",
  [0x5548] = "\xd6\x88", [0x5549] = "\xd6\x89", [0x554a] = "\xd6\x8a",
  [0x554b] = "\xd6\x8b", [0x554c] = "\xd6\x8c", [0x554d] = "\xd6\x8d",
  [0x554e] = "\xd6\x8e", [0x554f] = "\xd6\x8f", [0x5550] = "\xd6\x90",
  [0x5551] = "\xd6\x91", [0x5552] = "\xd6\x92", [0x5553] = "\xd6\x93",
  [0x5554] = "\xd6\x94", [0x5555] = "\xd6\x95", [0x5556] = "\xd6\x96",
  [0x5557] = "\xd6\x97", [0x5558] = "\xd6\x98", [0x5559] = "\xd6\x99",
  [0x555a] = "\xd6\x9a", [0x555b] = "\xd6\x9b", [0x555c] = "\xd6\x9c",
  [0x555d] = "\xd6\x9d", [0x555e] = "\xd6\x9e", [0x555f] = "\xd6\x9f",
  [0x5560] = "\xd6\xa0", [0x5561] = "\xd6\xa1", [0x5562] = "\xd6\xa2",
  [0x5563] = "\xd6\xa3", [0x5564] = "\xd6\xa4", [0x5565] = "\xd6\xa5",
  [0x5566] = "\xd6\xa6", [0x5567] = "\xd6\xa7", [0x5568] = "\xd6\xa8",
  [0x5569] = "\xd6\xa9", [0x556a] = "\xd6\xaa", [0x556b] = "\xd6\xab",
  [0x556c] = "\xd6\xac", [0x556d] = "\xd6\xad", [0x556e] = "\xd6\xae",
  [0x556f] = "\xd6\xaf", [0x5570] = "\xd6\xb0", [0x5571] = "\xd6\xb1",
  [0x5572] = "\xd6\xb2", [0x5573] = "\xd6\xb3", [0x5574] = "\xd6\xb4",
  [0x5575] = "\xd6\xb5", [0x5576] = "\xd6\xb6", [0x5577] = "\xd6\xb7",
  [0x5578] = "\xd6\xb8", [0x5579] = "\xd6\xb9", [0x557a] = "\xd6\xba",
  [0x557b] = "\xd6\xbb", [0x557c] = "\xd6\xbc", [0x557d] = "\xd6\xbd",
  [0x557e] = "\xd6\xbe", [0x557f] = "\xd6\xbf", [0x5580] = "\xd6\xc0",
  [0x5581] = "\xd6\xc1", [0x5582] = "\xd6\xc2", [0x5583] = "\xd6\xc3",
  [0x5584] = "\xd6\xc4", [0x5585] = "\xd6\xc5", [0x5586] = "\xd6\xc6",
  [0x5587] = "\xd6\xc7", [0x5588] = "\xd6\xc8", [0x5589] = "\xd6\xc9",
  [0x558a] = "\xd6\xca", [0x558b] = "\xd6\xcb", [0x558c] = "\xd6\xcc",
  [0x558d] = "\xd6\xcd", [0x558e] = "\xd6\xce", [0x558f] = "\xd6\xcf",
  [0x5590] = "\xd6\xd0", [0x5591] = "\xd6\xd1", [0x5592] = "\xd6\xd2",
  [0x5593] = "\xd6\xd3", [0x5594] = "\xd6\xd4", [0x5595] = "\xd6\xd5",
  [0x5596] = "\xd6\xd6", [0x5597] = "\xd6\xd7", [0x5598] = "\xd6\xd8",
  [0x5599] = "\xd6\xd9", [0x559a] = "\xd6\xda", [0x559b] = "\xd6\xdb",
  [0x559c] = "\xd6\xdc", [0x559d] = "\xd6\xdd", [0x559e] = "\xd6\xde",
  [0x559f] = "\xd6\xdf", [0x55a0] = "\xd6\xe0", [0x55a1] = "\xd6\xe1",
  [0x55a2] = "\xd6\xe2", [0x55a3] = "\xd6\xe3", [0x55a4] = "\xd6\xe4",
  [0x55a5] = "\xd6\xe5", [0x55a6] = "\xd6\xe6", [0x55a7] = "\xd6\xe7",
  [0x55a8] = "\xd6\xe8", [0x55a9] = "\xd6\xe9", [0x55aa] = "\xd6\xea",
  [0x55ab] = "\xd6\xeb", [0x55ac] = "\xd6\xec", [0x55ad] = "\xd6\xed",
  [0x55ae] = "\xd6\xee", [0x55af] = "\xd6\xef", [0x55b0] = "\xd6\xf0",
  [0x55b1] = "\xd6\xf1", [0x55b2] = "\xd6\xf2", [0x55b3] = "\xd6\xf3",
  [0x55b4] = "\xd6\xf4", [0x55b5] = "\xd6\xf5", [0x55b6] = "\xd6\xf6",
  [0x55b7] = "\xd6\xf7", [0x55b8] = "\xd6\xf8", [0x55b9] = "\xd6\xf9",
  [0x55ba] = "\xd6\xfa", [0x55bb] = "\xd6\xfb", [0x55bc] = "\xd6\xfc",
  [0x55bd] = "\xd6\xfd", [0x55be] = "\xd6\xfe", [0x5600] = "\xd7\x40",
  [0x5601] = "\xd7\x41", [0x5602] = "\xd7\x42", [0x5603] = "\xd7\x43",
  [0x5604] = "\xd7\x44", [0x5605] = "\xd7\x45", [0x5606] = "\xd7\x46",
  [0x5607] = "\xd7\x47", [0x5608] = "\xd7\x48", [0x5609] = "\xd7\x49",
  [0x560a] = "\xd7\x4a", [0x560b] = "\xd7\x4b", [0x560c] = "\xd7\x4c",
  [0x560d] = "\xd7\x4d", [0x560e] = "\xd7\x4e", [0x560f] = "\xd7\x4f",
  [0x5610] = "\xd7\x50", [0x5611] = "\xd7\x51", [0x5612] = "\xd7\x52",
  [0x5613] = "\xd7\x53", [0x5614] = "\xd7\x54", [0x5615] = "\xd7\x55",
  [0x5616] = "\xd7\x56", [0x5617] = "\xd7\x57", [0x5618] = "\xd7\x58",
  [0x5619] = "\xd7\x59", [0x561a] = "\xd7\x5a", [0x561b] = "\xd7\x5b",
  [0x561c] = "\xd7\x5c", [0x561d] = "\xd7\x5d", [0x561e] = "\xd7\x5e",
  [0x561f] = "\xd7\x5f", [0x5620] = "\xd7\x60", [0x5621] = "\xd7\x61",
  [0x5622] = "\xd7\x62", [0x5623] = "\xd7\x63", [0x5624] = "\xd7\x64",
  [0x5625] = "\xd7\x65", [0x5626] = "\xd7\x66", [0x5627] = "\xd7\x67",
  [0x5628] = "\xd7\x68", [0x5629] = "\xd7\x69", [0x562a] = "\xd7\x6a",
  [0x562b] = "\xd7\x6b", [0x562c] = "\xd7\x6c", [0x562d] = "\xd7\x6d",
  [0x562e] = "\xd7\x6e", [0x562f] = "\xd7\x6f", [0x5630] = "\xd7\x70",
  [0x5631] = "\xd7\x71", [0x5632] = "\xd7\x72", [0x5633] = "\xd7\x73",
  [0x5634] = "\xd7\x74", [0x5635] = "\xd7\x75", [0x5636] = "\xd7\x76",
  [0x5637] = "\xd7\x77", [0x5638] = "\xd7\x78", [0x5639] = "\xd7\x79",
  [0x563a] = "\xd7\x7a", [0x563b] = "\xd7\x7b", [0x563c] = "\xd7\x7c",
  [0x563d] = "\xd7\x7d", [0x563e] = "\xd7\x7e", [0x5640] = "\xd7\x80",
  [0x5641] = "\xd7\x81", [0x5642] = "\xd7\x82", [0x5643] = "\xd7\x83",
  [0x5644] = "\xd7\x84", [0x5645] = "\xd7\x85", [0x5646] = "\xd7\x86",
  [0x5647] = "\xd7\x87", [0x5648] = "\xd7\x88", [0x5649] = "\xd7\x89",
  [0x564a] = "\xd7\x8a", [0x564b] = "\xd7\x8b", [0x564c] = "\xd7\x8c",
  [0x564d] = "\xd7\x8d", [0x564e] = "\xd7\x8e", [0x564f] = "\xd7\x8f",
  [0x5650] = "\xd7\x90", [0x5651] = "\xd7\x91", [0x5652] = "\xd7\x92",
  [0x5653] = "\xd7\x93", [0x5654] = "\xd7\x94", [0x5655] = "\xd7\x95",
  [0x5656] = "\xd7\x96", [0x5657] = "\xd7\x97", [0x5658] = "\xd7\x98",
  [0x5659] = "\xd7\x99", [0x565a] = "\xd7\x9a", [0x565b] = "\xd7\x9b",
  [0x565c] = "\xd7\x9c", [0x565d] = "\xd7\x9d", [0x565e] = "\xd7\x9e",
  [0x565f] = "\xd7\x9f", [0x5660] = "\xd7\xa0", [0x5661] = "\xd7\xa1",
  [0x5662] = "\xd7\xa2", [0x5663] = "\xd7\xa3", [0x5664] = "\xd7\xa4",
  [0x5665] = "\xd7\xa5", [0x5666] = "\xd7\xa6", [0x5667] = "\xd7\xa7",
  [0x5668] = "\xd7\xa8", [0x5669] = "\xd7\xa9", [0x566a] = "\xd7\xaa",
  [0x566b] = "\xd7\xab", [0x566c] = "\xd7\xac", [0x566d] = "\xd7\xad",
  [0x566e] = "\xd7\xae", [0x566f] = "\xd7\xaf", [0x5670] = "\xd7\xb0",
  [0x5671] = "\xd7\xb1", [0x5672] = "\xd7\xb2", [0x5673] = "\xd7\xb3",
  [0x5674] = "\xd7\xb4", [0x5675] = "\xd7\xb5", [0x5676] = "\xd7\xb6",
  [0x5677] = "\xd7\xb7", [0x5678] = "\xd7\xb8", [0x5679] = "\xd7\xb9",
  [0x567a] = "\xd7\xba", [0x567b] = "\xd7\xbb", [0x567c] = "\xd7\xbc",
  [0x567d] = "\xd7\xbd", [0x567e] = "\xd7\xbe", [0x567f] = "\xd7\xbf",
  [0x5680] = "\xd7\xc0", [0x5681] = "\xd7\xc1", [0x5682] = "\xd7\xc2",
  [0x5683] = "\xd7\xc3", [0x5684] = "\xd7\xc4", [0x5685] = "\xd7\xc5",
  [0x5686] = "\xd7\xc6", [0x5687] = "\xd7\xc7", [0x5688] = "\xd7\xc8",
  [0x5689] = "\xd7\xc9", [0x568a] = "\xd7\xca", [0x568b] = "\xd7\xcb",
  [0x568c] = "\xd7\xcc", [0x568d] = "\xd7\xcd", [0x568e] = "\xd7\xce",
  [0x568f] = "\xd7\xcf", [0x5690] = "\xd7\xd0", [0x5691] = "\xd7\xd1",
  [0x5692] = "\xd7\xd2", [0x5693] = "\xd7\xd3", [0x5694] = "\xd7\xd4",
  [0x5695] = "\xd7\xd5", [0x5696] = "\xd7\xd6", [0x5697] = "\xd7\xd7",
  [0x5698] = "\xd7\xd8", [0x5699] = "\xd7\xd9", [0x569a] = "\xd7\xda",
  [0x569b] = "\xd7\xdb", [0x569c] = "\xd7\xdc", [0x569d] = "\xd7\xdd",
  [0x569e] = "\xd7\xde", [0x569f] = "\xd7\xdf", [0x56a0] = "\xd7\xe0",
  [0x56a1] = "\xd7\xe1", [0x56a2] = "\xd7\xe2", [0x56a3] = "\xd7\xe3",
  [0x56a4] = "\xd7\xe4", [0x56a5] = "\xd7\xe5", [0x56a6] = "\xd7\xe6",
  [0x56a7] = "\xd7\xe7", [0x56a8] = "\xd7\xe8", [0x56a9] = "\xd7\xe9",
  [0x56aa] = "\xd7\xea", [0x56ab] = "\xd7\xeb", [0x56ac] = "\xd7\xec",
  [0x56ad] = "\xd7\xed", [0x56ae] = "\xd7\xee", [0x56af] = "\xd7\xef",
  [0x56b0] = "\xd7\xf0", [0x56b1] = "\xd7\xf1", [0x56b2] = "\xd7\xf2",
  [0x56b3] = "\xd7\xf3", [0x56b4] = "\xd7\xf4", [0x56b5] = "\xd7\xf5",
  [0x56b6] = "\xd7\xf6", [0x56b7] = "\xd7\xf7", [0x56b8] = "\xd7\xf8",
  [0x56b9] = "\xd7\xf9", [0x56ba] = "\xd7\xfa", [0x56bb] = "\xd7\xfb",
  [0x56bc] = "\xd7\xfc", [0x56bd] = "\xd7\xfd", [0x56be] = "\xd7\xfe",
  [0x5700] = "\xd8\x40", [0x5701] = "\xd8\x41", [0x5702] = "\xd8\x42",
  [0x5703] = "\xd8\x43", [0x5704] = "\xd8\x44", [0x5705] = "\xd8\x45",
  [0x5706] = "\xd8\x46", [0x5707] = "\xd8\x47", [0x5708] = "\xd8\x48",
  [0x5709] = "\xd8\x49", [0x570a] = "\xd8\x4a", [0x570b] = "\xd8\x4b",
  [0x570c] = "\xd8\x4c", [0x570d] = "\xd8\x4d", [0x570e] = "\xd8\x4e",
  [0x570f] = "\xd8\x4f", [0x5710] = "\xd8\x50", [0x5711] = "\xd8\x51",
  [0x5712] = "\xd8\x52", [0x5713] = "\xd8\x53", [0x5714] = "\xd8\x54",
  [0x5715] = "\xd8\x55", [0x5716] = "\xd8\x56", [0x5717] = "\xd8\x57",
  [0x5718] = "\xd8\x58", [0x5719] = "\xd8\x59", [0x571a] = "\xd8\x5a",
  [0x571b] = "\xd8\x5b", [0x571c] = "\xd8\x5c", [0x571d] = "\xd8\x5d",
  [0x571e] = "\xd8\x5e", [0x571f] = "\xd8\x5f", [0x5720] = "\xd8\x60",
  [0x5721] = "\xd8\x61", [0x5722] = "\xd8\x62", [0x5723] = "\xd8\x63",
  [0x5724] = "\xd8\x64", [0x5725] = "\xd8\x65", [0x5726] = "\xd8\x66",
  [0x5727] = "\xd8\x67", [0x5728] = "\xd8\x68", [0x5729] = "\xd8\x69",
  [0x572a] = "\xd8\x6a", [0x572b] = "\xd8\x6b", [0x572c] = "\xd8\x6c",
  [0x572d] = "\xd8\x6d", [0x572e] = "\xd8\x6e", [0x572f] = "\xd8\x6f",
  [0x5730] = "\xd8\x70", [0x5731] = "\xd8\x71", [0x5732] = "\xd8\x72",
  [0x5733] = "\xd8\x73", [0x5734] = "\xd8\x74", [0x5735] = "\xd8\x75",
  [0x5736] = "\xd8\x76", [0x5737] = "\xd8\x77", [0x5738] = "\xd8\x78",
  [0x5739] = "\xd8\x79", [0x573a] = "\xd8\x7a", [0x573b] = "\xd8\x7b",
  [0x573c] = "\xd8\x7c", [0x573d] = "\xd8\x7d", [0x573e] = "\xd8\x7e",
  [0x5740] = "\xd8\x80", [0x5741] = "\xd8\x81", [0x5742] = "\xd8\x82",
  [0x5743] = "\xd8\x83", [0x5744] = "\xd8\x84", [0x5745] = "\xd8\x85",
  [0x5746] = "\xd8\x86", [0x5747] = "\xd8\x87", [0x5748] = "\xd8\x88",
  [0x5749] = "\xd8\x89", [0x574a] = "\xd8\x8a", [0x574b] = "\xd8\x8b",
  [0x574c] = "\xd8\x8c", [0x574d] = "\xd8\x8d", [0x574e] = "\xd8\x8e",
  [0x574f] = "\xd8\x8f", [0x5750] = "\xd8\x90", [0x5751] = "\xd8\x91",
  [0x5752] = "\xd8\x92", [0x5753] = "\xd8\x93", [0x5754] = "\xd8\x94",
  [0x5755] = "\xd8\x95", [0x5756] = "\xd8\x96", [0x5757] = "\xd8\x97",
  [0x5758] = "\xd8\x98", [0x5759] = "\xd8\x99", [0x575a] = "\xd8\x9a",
  [0x575b] = "\xd8\x9b", [0x575c] = "\xd8\x9c", [0x575d] = "\xd8\x9d",
  [0x575e] = "\xd8\x9e", [0x575f] = "\xd8\x9f", [0x5760] = "\xd8\xa0",
  [0x5761] = "\xd8\xa1", [0x5762] = "\xd8\xa2", [0x5763] = "\xd8\xa3",
  [0x5764] = "\xd8\xa4", [0x5765] = "\xd8\xa5", [0x5766] = "\xd8\xa6",
  [0x5767] = "\xd8\xa7", [0x5768] = "\xd8\xa8", [0x5769] = "\xd8\xa9",
  [0x576a] = "\xd8\xaa", [0x576b] = "\xd8\xab", [0x576c] = "\xd8\xac",
  [0x576d] = "\xd8\xad", [0x576e] = "\xd8\xae", [0x576f] = "\xd8\xaf",
  [0x5770] = "\xd8\xb0", [0x5771] = "\xd8\xb1", [0x5772] = "\xd8\xb2",
  [0x5773] = "\xd8\xb3", [0x5774] = "\xd8\xb4", [0x5775] = "\xd8\xb5",
  [0x5776] = "\xd8\xb6", [0x5777] = "\xd8\xb7", [0x5778] = "\xd8\xb8",
  [0x5779] = "\xd8\xb9", [0x577a] = "\xd8\xba", [0x577b] = "\xd8\xbb",
  [0x577c] = "\xd8\xbc", [0x577d] = "\xd8\xbd", [0x577e] = "\xd8\xbe",
  [0x577f] = "\xd8\xbf", [0x5780] = "\xd8\xc0", [0x5781] = "\xd8\xc1",
  [0x5782] = "\xd8\xc2", [0x5783] = "\xd8\xc3", [0x5784] = "\xd8\xc4",
  [0x5785] = "\xd8\xc5", [0x5786] = "\xd8\xc6", [0x5787] = "\xd8\xc7",
  [0x5788] = "\xd8\xc8", [0x5789] = "\xd8\xc9", [0x578a] = "\xd8\xca",
  [0x578b] = "\xd8\xcb", [0x578c] = "\xd8\xcc", [0x578d] = "\xd8\xcd",
  [0x578e] = "\xd8\xce", [0x578f] = "\xd8\xcf", [0x5790] = "\xd8\xd0",
  [0x5791] = "\xd8\xd1", [0x5792] = "\xd8\xd2", [0x5793] = "\xd8\xd3",
  [0x5794] = "\xd8\xd4", [0x5795] = "\xd8\xd5", [0x5796] = "\xd8\xd6",
  [0x5797] = "\xd8\xd7", [0x5798] = "\xd8\xd8", [0x5799] = "\xd8\xd9",
  [0x579a] = "\xd8\xda", [0x579b] = "\xd8\xdb", [0x579c] = "\xd8\xdc",
  [0x579d] = "\xd8\xdd", [0x579e] = "\xd8\xde", [0x579f] = "\xd8\xdf",
  [0x57a0] = "\xd8\xe0", [0x57a1] = "\xd8\xe1", [0x57a2] = "\xd8\xe2",
  [0x57a3] = "\xd8\xe3", [0x57a4] = "\xd8\xe4", [0x57a5] = "\xd8\xe5",
  [0x57a6] = "\xd8\xe6", [0x57a7] = "\xd8\xe7", [0x57a8] = "\xd8\xe8",
  [0x57a9] = "\xd8\xe9", [0x57aa] = "\xd8\xea", [0x57ab] = "\xd8\xeb",
  [0x57ac] = "\xd8\xec", [0x57ad] = "\xd8\xed", [0x57ae] = "\xd8\xee",
  [0x57af] = "\xd8\xef", [0x57b0] = "\xd8\xf0", [0x57b1] = "\xd8\xf1",
  [0x57b2] = "\xd8\xf2", [0x57b3] = "\xd8\xf3", [0x57b4] = "\xd8\xf4",
  [0x57b5] = "\xd8\xf5", [0x57b6] = "\xd8\xf6", [0x57b7] = "\xd8\xf7",
  [0x57b8] = "\xd8\xf8", [0x57b9] = "\xd8\xf9", [0x57ba] = "\xd8\xfa",
  [0x57bb] = "\xd8\xfb", [0x57bc] = "\xd8\xfc", [0x57bd] = "\xd8\xfd",
  [0x57be] = "\xd8\xfe", [0x5800] = "\xd9\x40", [0x5801] = "\xd9\x41",
  [0x5802] = "\xd9\x42", [0x5803] = "\xd9\x43", [0x5804] = "\xd9\x44",
  [0x5805] = "\xd9\x45", [0x5806] = "\xd9\x46", [0x5807] = "\xd9\x47",
  [0x5808] = "\xd9\x48", [0x5809] = "\xd9\x49", [0x580a] = "\xd9\x4a",
  [0x580b] = "\xd9\x4b", [0x580c] = "\xd9\x4c", [0x580d] = "\xd9\x4d",
  [0x580e] = "\xd9\x4e", [0x580f] = "\xd9\x4f", [0x5810] = "\xd9\x50",
  [0x5811] = "\xd9\x51", [0x5812] = "\xd9\x52", [0x5813] = "\xd9\x53",
  [0x5814] = "\xd9\x54", [0x5815] = "\xd9\x55", [0x5816] = "\xd9\x56",
  [0x5817] = "\xd9\x57", [0x5818] = "\xd9\x58", [0x5819] = "\xd9\x59",
  [0x581a] = "\xd9\x5a", [0x581b] = "\xd9\x5b", [0x581c] = "\xd9\x5c",
  [0x581d] = "\xd9\x5d", [0x581e] = "\xd9\x5e", [0x581f] = "\xd9\x5f",
  [0x5820] = "\xd9\x60", [0x5821] = "\xd9\x61", [0x5822] = "\xd9\x62",
  [0x5823] = "\xd9\x63", [0x5824] = "\xd9\x64", [0x5825] = "\xd9\x65",
  [0x5826] = "\xd9\x66", [0x5827] = "\xd9\x67", [0x5828] = "\xd9\x68",
  [0x5829] = "\xd9\x69", [0x582a] = "\xd9\x6a", [0x582b] = "\xd9\x6b",
  [0x582c] = "\xd9\x6c", [0x582d] = "\xd9\x6d", [0x582e] = "\xd9\x6e",
  [0x582f] = "\xd9\x6f", [0x5830] = "\xd9\x70", [0x5831] = "\xd9\x71",
  [0x5832] = "\xd9\x72", [0x5833] = "\xd9\x73", [0x5834] = "\xd9\x74",
  [0x5835] = "\xd9\x75", [0x5836] = "\xd9\x76", [0x5837] = "\xd9\x77",
  [0x5838] = "\xd9\x78", [0x5839] = "\xd9\x79", [0x583a] = "\xd9\x7a",
  [0x583b] = "\xd9\x7b", [0x583c] = "\xd9\x7c", [0x583d] = "\xd9\x7d",
  [0x583e] = "\xd9\x7e", [0x5840] = "\xd9\x80", [0x5841] = "\xd9\x81",
  [0x5842] = "\xd9\x82", [0x5843] = "\xd9\x83", [0x5844] = "\xd9\x84",
  [0x5845] = "\xd9\x85", [0x5846] = "\xd9\x86", [0x5847] = "\xd9\x87",
  [0x5848] = "\xd9\x88", [0x5849] = "\xd9\x89", [0x584a] = "\xd9\x8a",
  [0x584b] = "\xd9\x8b", [0x584c] = "\xd9\x8c", [0x584d] = "\xd9\x8d",
  [0x584e] = "\xd9\x8e", [0x584f] = "\xd9\x8f", [0x5850] = "\xd9\x90",
  [0x5851] = "\xd9\x91", [0x5852] = "\xd9\x92", [0x5853] = "\xd9\x93",
  [0x5854] = "\xd9\x94", [0x5855] = "\xd9\x95", [0x5856] = "\xd9\x96",
  [0x5857] = "\xd9\x97", [0x5858] = "\xd9\x98", [0x5859] = "\xd9\x99",
  [0x585a] = "\xd9\x9a", [0x585b] = "\xd9\x9b", [0x585c] = "\xd9\x9c",
  [0x585d] = "\xd9\x9d", [0x585e] = "\xd9\x9e", [0x585f] = "\xd9\x9f",
  [0x5860] = "\xd9\xa0", [0x5861] = "\xd9\xa1", [0x5862] = "\xd9\xa2",
  [0x5863] = "\xd9\xa3", [0x5864] = "\xd9\xa4", [0x5865] = "\xd9\xa5",
  [0x5866] = "\xd9\xa6", [0x5867] = "\xd9\xa7", [0x5868] = "\xd9\xa8",
  [0x5869] = "\xd9\xa9", [0x586a] = "\xd9\xaa", [0x586b] = "\xd9\xab",
  [0x586c] = "\xd9\xac", [0x586d] = "\xd9\xad", [0x586e] = "\xd9\xae",
  [0x586f] = "\xd9\xaf", [0x5870] = "\xd9\xb0", [0x5871] = "\xd9\xb1",
  [0x5872] = "\xd9\xb2", [0x5873] = "\xd9\xb3", [0x5874] = "\xd9\xb4",
  [0x5875] = "\xd9\xb5", [0x5876] = "\xd9\xb6", [0x5877] = "\xd9\xb7",
  [0x5878] = "\xd9\xb8", [0x5879] = "\xd9\xb9", [0x587a] = "\xd9\xba",
  [0x587b] = "\xd9\xbb", [0x587c] = "\xd9\xbc", [0x587d] = "\xd9\xbd",
  [0x587e] = "\xd9\xbe", [0x587f] = "\xd9\xbf", [0x5880] = "\xd9\xc0",
  [0x5881] = "\xd9\xc1", [0x5882] = "\xd9\xc2", [0x5883] = "\xd9\xc3",
  [0x5884] = "\xd9\xc4", [0x5885] = "\xd9\xc5", [0x5886] = "\xd9\xc6",
  [0x5887] = "\xd9\xc7", [0x5888] = "\xd9\xc8", [0x5889] = "\xd9\xc9",
  [0x588a] = "\xd9\xca", [0x588b] = "\xd9\xcb", [0x588c] = "\xd9\xcc",
  [0x588d] = "\xd9\xcd", [0x588e] = "\xd9\xce", [0x588f] = "\xd9\xcf",
  [0x5890] = "\xd9\xd0", [0x5891] = "\xd9\xd1", [0x5892] = "\xd9\xd2",
  [0x5893] = "\xd9\xd3", [0x5894] = "\xd9\xd4", [0x5895] = "\xd9\xd5",
  [0x5896] = "\xd9\xd6", [0x5897] = "\xd9\xd7", [0x5898] = "\xd9\xd8",
  [0x5899] = "\xd9\xd9", [0x589a] = "\xd9\xda", [0x589b] = "\xd9\xdb",
  [0x589c] = "\xd9\xdc", [0x589d] = "\xd9\xdd", [0x589e] = "\xd9\xde",
  [0x589f] = "\xd9\xdf", [0x58a0] = "\xd9\xe0", [0x58a1] = "\xd9\xe1",
  [0x58a2] = "\xd9\xe2", [0x58a3] = "\xd9\xe3", [0x58a4] = "\xd9\xe4",
  [0x58a5] = "\xd9\xe5", [0x58a6] = "\xd9\xe6", [0x58a7] = "\xd9\xe7",
  [0x58a8] = "\xd9\xe8", [0x58a9] = "\xd9\xe9", [0x58aa] = "\xd9\xea",
  [0x58ab] = "\xd9\xeb", [0x58ac] = "\xd9\xec", [0x58ad] = "\xd9\xed",
  [0x58ae] = "\xd9\xee", [0x58af] = "\xd9\xef", [0x58b0] = "\xd9\xf0",
  [0x58b1] = "\xd9\xf1", [0x58b2] = "\xd9\xf2", [0x58b3] = "\xd9\xf3",
  [0x58b4] = "\xd9\xf4", [0x58b5] = "\xd9\xf5", [0x58b6] = "\xd9\xf6",
  [0x58b7] = "\xd9\xf7", [0x58b8] = "\xd9\xf8", [0x58b9] = "\xd9\xf9",
  [0x58ba] = "\xd9\xfa", [0x58bb] = "\xd9\xfb", [0x58bc] = "\xd9\xfc",
  [0x58bd] = "\xd9\xfd", [0x58be] = "\xd9\xfe", [0x5900] = "\xda\x40",
  [0x5901] = "\xda\x41", [0x5902] = "\xda\x42", [0x5903] = "\xda\x43",
  [0x5904] = "\xda\x44", [0x5905] = "\xda\x45", [0x5906] = "\xda\x46",
  [0x5907] = "\xda\x47", [0x5908] = "\xda\x48", [0x5909] = "\xda\x49",
  [0x590a] = "\xda\x4a", [0x590b] = "\xda\x4b", [0x590c] = "\xda\x4c",
  [0x590d] = "\xda\x4d", [0x590e] = "\xda\x4e", [0x590f] = "\xda\x4f",
  [0x5910] = "\xda\x50", [0x5911] = "\xda\x51", [0x5912] = "\xda\x52",
  [0x5913] = "\xda\x53", [0x5914] = "\xda\x54", [0x5915] = "\xda\x55",
  [0x5916] = "\xda\x56", [0x5917] = "\xda\x57", [0x5918] = "\xda\x58",
  [0x5919] = "\xda\x59", [0x591a] = "\xda\x5a", [0x591b] = "\xda\x5b",
  [0x591c] = "\xda\x5c", [0x591d] = "\xda\x5d", [0x591e] = "\xda\x5e",
  [0x591f] = "\xda\x5f", [0x5920] = "\xda\x60", [0x5921] = "\xda\x61",
  [0x5922] = "\xda\x62", [0x5923] = "\xda\x63", [0x5924] = "\xda\x64",
  [0x5925] = "\xda\x65", [0x5926] = "\xda\x66", [0x5927] = "\xda\x67",
  [0x5928] = "\xda\x68", [0x5929] = "\xda\x69", [0x592a] = "\xda\x6a",
  [0x592b] = "\xda\x6b", [0x592c] = "\xda\x6c", [0x592d] = "\xda\x6d",
  [0x592e] = "\xda\x6e", [0x592f] = "\xda\x6f", [0x5930] = "\xda\x70",
  [0x5931] = "\xda\x71", [0x5932] = "\xda\x72", [0x5933] = "\xda\x73",
  [0x5934] = "\xda\x74", [0x5935] = "\xda\x75", [0x5936] = "\xda\x76",
  [0x5937] = "\xda\x77", [0x5938] = "\xda\x78", [0x5939] = "\xda\x79",
  [0x593a] = "\xda\x7a", [0x593b] = "\xda\x7b", [0x593c] = "\xda\x7c",
  [0x593d] = "\xda\x7d", [0x593e] = "\xda\x7e", [0x5940] = "\xda\x80",
  [0x5941] = "\xda\x81", [0x5942] = "\xda\x82", [0x5943] = "\xda\x83",
  [0x5944] = "\xda\x84", [0x5945] = "\xda\x85", [0x5946] = "\xda\x86",
  [0x5947] = "\xda\x87", [0x5948] = "\xda\x88", [0x5949] = "\xda\x89",
  [0x594a] = "\xda\x8a", [0x594b] = "\xda\x8b", [0x594c] = "\xda\x8c",
  [0x594d] = "\xda\x8d", [0x594e] = "\xda\x8e", [0x594f] = "\xda\x8f",
  [0x5950] = "\xda\x90", [0x5951] = "\xda\x91", [0x5952] = "\xda\x92",
  [0x5953] = "\xda\x93", [0x5954] = "\xda\x94", [0x5955] = "\xda\x95",
  [0x5956] = "\xda\x96", [0x5957] = "\xda\x97", [0x5958] = "\xda\x98",
  [0x5959] = "\xda\x99", [0x595a] = "\xda\x9a", [0x595b] = "\xda\x9b",
  [0x595c] = "\xda\x9c", [0x595d] = "\xda\x9d", [0x595e] = "\xda\x9e",
  [0x595f] = "\xda\x9f", [0x5960] = "\xda\xa0", [0x5961] = "\xda\xa1",
  [0x5962] = "\xda\xa2", [0x5963] = "\xda\xa3", [0x5964] = "\xda\xa4",
  [0x5965] = "\xda\xa5", [0x5966] = "\xda\xa6", [0x5967] = "\xda\xa7",
  [0x5968] = "\xda\xa8", [0x5969] = "\xda\xa9", [0x596a] = "\xda\xaa",
  [0x596b] = "\xda\xab", [0x596c] = "\xda\xac", [0x596d] = "\xda\xad",
  [0x596e] = "\xda\xae", [0x596f] = "\xda\xaf", [0x5970] = "\xda\xb0",
  [0x5971] = "\xda\xb1", [0x5972] = "\xda\xb2", [0x5973] = "\xda\xb3",
  [0x5974] = "\xda\xb4", [0x5975] = "\xda\xb5", [0x5976] = "\xda\xb6",
  [0x5977] = "\xda\xb7", [0x5978] = "\xda\xb8", [0x5979] = "\xda\xb9",
  [0x597a] = "\xda\xba", [0x597b] = "\xda\xbb", [0x597c] = "\xda\xbc",
  [0x597d] = "\xda\xbd", [0x597e] = "\xda\xbe", [0x597f] = "\xda\xbf",
  [0x5980] = "\xda\xc0", [0x5981] = "\xda\xc1", [0x5982] = "\xda\xc2",
  [0x5983] = "\xda\xc3", [0x5984] = "\xda\xc4", [0x5985] = "\xda\xc5",
  [0x5986] = "\xda\xc6", [0x5987] = "\xda\xc7", [0x5988] = "\xda\xc8",
  [0x5989] = "\xda\xc9", [0x598a] = "\xda\xca", [0x598b] = "\xda\xcb",
  [0x598c] = "\xda\xcc", [0x598d] = "\xda\xcd", [0x598e] = "\xda\xce",
  [0x598f] = "\xda\xcf", [0x5990] = "\xda\xd0", [0x5991] = "\xda\xd1",
  [0x5992] = "\xda\xd2", [0x5993] = "\xda\xd3", [0x5994] = "\xda\xd4",
  [0x5995] = "\xda\xd5", [0x5996] = "\xda\xd6", [0x5997] = "\xda\xd7",
  [0x5998] = "\xda\xd8", [0x5999] = "\xda\xd9", [0x599a] = "\xda\xda",
  [0x599b] = "\xda\xdb", [0x599c] = "\xda\xdc", [0x599d] = "\xda\xdd",
  [0x599e] = "\xda\xde", [0x599f] = "\xda\xdf", [0x59a0] = "\xda\xe0",
  [0x59a1] = "\xda\xe1", [0x59a2] = "\xda\xe2", [0x59a3] = "\xda\xe3",
  [0x59a4] = "\xda\xe4", [0x59a5] = "\xda\xe5", [0x59a6] = "\xda\xe6",
  [0x59a7] = "\xda\xe7", [0x59a8] = "\xda\xe8", [0x59a9] = "\xda\xe9",
  [0x59aa] = "\xda\xea", [0x59ab] = "\xda\xeb", [0x59ac] = "\xda\xec",
  [0x59ad] = "\xda\xed", [0x59ae] = "\xda\xee", [0x59af] = "\xda\xef",
  [0x59b0] = "\xda\xf0", [0x59b1] = "\xda\xf1", [0x59b2] = "\xda\xf2",
  [0x59b3] = "\xda\xf3", [0x59b4] = "\xda\xf4", [0x59b5] = "\xda\xf5",
  [0x59b6] = "\xda\xf6", [0x59b7] = "\xda\xf7", [0x59b8] = "\xda\xf8",
  [0x59b9] = "\xda\xf9", [0x59ba] = "\xda\xfa", [0x59bb] = "\xda\xfb",
  [0x59bc] = "\xda\xfc", [0x59bd] = "\xda\xfd", [0x59be] = "\xda\xfe",
  [0x5a00] = "\xdb\x40", [0x5a01] = "\xdb\x41", [0x5a02] = "\xdb\x42",
  [0x5a03] = "\xdb\x43", [0x5a04] = "\xdb\x44", [0x5a05] = "\xdb\x45",
  [0x5a06] = "\xdb\x46", [0x5a07] = "\xdb\x47", [0x5a08] = "\xdb\x48",
  [0x5a09] = "\xdb\x49", [0x5a0a] = "\xdb\x4a", [0x5a0b] = "\xdb\x4b",
  [0x5a0c] = "\xdb\x4c", [0x5a0d] = "\xdb\x4d", [0x5a0e] = "\xdb\x4e",
  [0x5a0f] = "\xdb\x4f", [0x5a10] = "\xdb\x50", [0x5a11] = "\xdb\x51",
  [0x5a12] = "\xdb\x52", [0x5a13] = "\xdb\x53", [0x5a14] = "\xdb\x54",
  [0x5a15] = "\xdb\x55", [0x5a16] = "\xdb\x56", [0x5a17] = "\xdb\x57",
  [0x5a18] = "\xdb\x58", [0x5a19] = "\xdb\x59", [0x5a1a] = "\xdb\x5a",
  [0x5a1b] = "\xdb\x5b", [0x5a1c] = "\xdb\x5c", [0x5a1d] = "\xdb\x5d",
  [0x5a1e] = "\xdb\x5e", [0x5a1f] = "\xdb\x5f", [0x5a20] = "\xdb\x60",
  [0x5a21] = "\xdb\x61", [0x5a22] = "\xdb\x62", [0x5a23] = "\xdb\x63",
  [0x5a24] = "\xdb\x64", [0x5a25] = "\xdb\x65", [0x5a26] = "\xdb\x66",
  [0x5a27] = "\xdb\x67", [0x5a28] = "\xdb\x68", [0x5a29] = "\xdb\x69",
  [0x5a2a] = "\xdb\x6a", [0x5a2b] = "\xdb\x6b", [0x5a2c] = "\xdb\x6c",
  [0x5a2d] = "\xdb\x6d", [0x5a2e] = "\xdb\x6e", [0x5a2f] = "\xdb\x6f",
  [0x5a30] = "\xdb\x70", [0x5a31] = "\xdb\x71", [0x5a32] = "\xdb\x72",
  [0x5a33] = "\xdb\x73", [0x5a34] = "\xdb\x74", [0x5a35] = "\xdb\x75",
  [0x5a36] = "\xdb\x76", [0x5a37] = "\xdb\x77", [0x5a38] = "\xdb\x78",
  [0x5a39] = "\xdb\x79", [0x5a3a] = "\xdb\x7a", [0x5a3b] = "\xdb\x7b",
  [0x5a3c] = "\xdb\x7c", [0x5a3d] = "\xdb\x7d", [0x5a3e] = "\xdb\x7e",
  [0x5a40] = "\xdb\x80", [0x5a41] = "\xdb\x81", [0x5a42] = "\xdb\x82",
  [0x5a43] = "\xdb\x83", [0x5a44] = "\xdb\x84", [0x5a45] = "\xdb\x85",
  [0x5a46] = "\xdb\x86", [0x5a47] = "\xdb\x87", [0x5a48] = "\xdb\x88",
  [0x5a49] = "\xdb\x89", [0x5a4a] = "\xdb\x8a", [0x5a4b] = "\xdb\x8b",
  [0x5a4c] = "\xdb\x8c", [0x5a4d] = "\xdb\x8d", [0x5a4e] = "\xdb\x8e",
  [0x5a4f] = "\xdb\x8f", [0x5a50] = "\xdb\x90", [0x5a51] = "\xdb\x91",
  [0x5a52] = "\xdb\x92", [0x5a53] = "\xdb\x93", [0x5a54] = "\xdb\x94",
  [0x5a55] = "\xdb\x95", [0x5a56] = "\xdb\x96", [0x5a57] = "\xdb\x97",
  [0x5a58] = "\xdb\x98", [0x5a59] = "\xdb\x99", [0x5a5a] = "\xdb\x9a",
  [0x5a5b] = "\xdb\x9b", [0x5a5c] = "\xdb\x9c", [0x5a5d] = "\xdb\x9d",
  [0x5a5e] = "\xdb\x9e", [0x5a5f] = "\xdb\x9f", [0x5a60] = "\xdb\xa0",
  [0x5a61] = "\xdb\xa1", [0x5a62] = "\xdb\xa2", [0x5a63] = "\xdb\xa3",
  [0x5a64] = "\xdb\xa4", [0x5a65] = "\xdb\xa5", [0x5a66] = "\xdb\xa6",
  [0x5a67] = "\xdb\xa7", [0x5a68] = "\xdb\xa8", [0x5a69] = "\xdb\xa9",
  [0x5a6a] = "\xdb\xaa", [0x5a6b] = "\xdb\xab", [0x5a6c] = "\xdb\xac",
  [0x5a6d] = "\xdb\xad", [0x5a6e] = "\xdb\xae", [0x5a6f] = "\xdb\xaf",
  [0x5a70] = "\xdb\xb0", [0x5a71] = "\xdb\xb1", [0x5a72] = "\xdb\xb2",
  [0x5a73] = "\xdb\xb3", [0x5a74] = "\xdb\xb4", [0x5a75] = "\xdb\xb5",
  [0x5a76] = "\xdb\xb6", [0x5a77] = "\xdb\xb7", [0x5a78] = "\xdb\xb8",
  [0x5a79] = "\xdb\xb9", [0x5a7a] = "\xdb\xba", [0x5a7b] = "\xdb\xbb",
  [0x5a7c] = "\xdb\xbc", [0x5a7d] = "\xdb\xbd", [0x5a7e] = "\xdb\xbe",
  [0x5a7f] = "\xdb\xbf", [0x5a80] = "\xdb\xc0", [0x5a81] = "\xdb\xc1",
  [0x5a82] = "\xdb\xc2", [0x5a83] = "\xdb\xc3", [0x5a84] = "\xdb\xc4",
  [0x5a85] = "\xdb\xc5", [0x5a86] = "\xdb\xc6", [0x5a87] = "\xdb\xc7",
  [0x5a88] = "\xdb\xc8", [0x5a89] = "\xdb\xc9", [0x5a8a] = "\xdb\xca",
  [0x5a8b] = "\xdb\xcb", [0x5a8c] = "\xdb\xcc", [0x5a8d] = "\xdb\xcd",
  [0x5a8e] = "\xdb\xce", [0x5a8f] = "\xdb\xcf", [0x5a90] = "\xdb\xd0",
  [0x5a91] = "\xdb\xd1", [0x5a92] = "\xdb\xd2", [0x5a93] = "\xdb\xd3",
  [0x5a94] = "\xdb\xd4", [0x5a95] = "\xdb\xd5", [0x5a96] = "\xdb\xd6",
  [0x5a97] = "\xdb\xd7", [0x5a98] = "\xdb\xd8", [0x5a99] = "\xdb\xd9",
  [0x5a9a] = "\xdb\xda", [0x5a9b] = "\xdb\xdb", [0x5a9c] = "\xdb\xdc",
  [0x5a9d] = "\xdb\xdd", [0x5a9e] = "\xdb\xde", [0x5a9f] = "\xdb\xdf",
  [0x5aa0] = "\xdb\xe0", [0x5aa1] = "\xdb\xe1", [0x5aa2] = "\xdb\xe2",
  [0x5aa3] = "\xdb\xe3", [0x5aa4] = "\xdb\xe4", [0x5aa5] = "\xdb\xe5",
  [0x5aa6] = "\xdb\xe6", [0x5aa7] = "\xdb\xe7", [0x5aa8] = "\xdb\xe8",
  [0x5aa9] = "\xdb\xe9", [0x5aaa] = "\xdb\xea", [0x5aab] = "\xdb\xeb",
  [0x5aac] = "\xdb\xec", [0x5aad] = "\xdb\xed", [0x5aae] = "\xdb\xee",
  [0x5aaf] = "\xdb\xef", [0x5ab0] = "\xdb\xf0", [0x5ab1] = "\xdb\xf1",
  [0x5ab2] = "\xdb\xf2", [0x5ab3] = "\xdb\xf3", [0x5ab4] = "\xdb\xf4",
  [0x5ab5] = "\xdb\xf5", [0x5ab6] = "\xdb\xf6", [0x5ab7] = "\xdb\xf7",
  [0x5ab8] = "\xdb\xf8", [0x5ab9] = "\xdb\xf9", [0x5aba] = "\xdb\xfa",
  [0x5abb] = "\xdb\xfb", [0x5abc] = "\xdb\xfc", [0x5abd] = "\xdb\xfd",
  [0x5abe] = "\xdb\xfe", [0x5b00] = "\xdc\x40", [0x5b01] = "\xdc\x41",
  [0x5b02] = "\xdc\x42", [0x5b03] = "\xdc\x43", [0x5b04] = "\xdc\x44",
  [0x5b05] = "\xdc\x45", [0x5b06] = "\xdc\x46", [0x5b07] = "\xdc\x47",
  [0x5b08] = "\xdc\x48", [0x5b09] = "\xdc\x49", [0x5b0a] = "\xdc\x4a",
  [0x5b0b] = "\xdc\x4b", [0x5b0c] = "\xdc\x4c", [0x5b0d] = "\xdc\x4d",
  [0x5b0e] = "\xdc\x4e", [0x5b0f] = "\xdc\x4f", [0x5b10] = "\xdc\x50",
  [0x5b11] = "\xdc\x51", [0x5b12] = "\xdc\x52", [0x5b13] = "\xdc\x53",
  [0x5b14] = "\xdc\x54", [0x5b15] = "\xdc\x55", [0x5b16] = "\xdc\x56",
  [0x5b17] = "\xdc\x57", [0x5b18] = "\xdc\x58", [0x5b19] = "\xdc\x59",
  [0x5b1a] = "\xdc\x5a", [0x5b1b] = "\xdc\x5b", [0x5b1c] = "\xdc\x5c",
  [0x5b1d] = "\xdc\x5d", [0x5b1e] = "\xdc\x5e", [0x5b1f] = "\xdc\x5f",
  [0x5b20] = "\xdc\x60", [0x5b21] = "\xdc\x61", [0x5b22] = "\xdc\x62",
  [0x5b23] = "\xdc\x63", [0x5b24] = "\xdc\x64", [0x5b25] = "\xdc\x65",
  [0x5b26] = "\xdc\x66", [0x5b27] = "\xdc\x67", [0x5b28] = "\xdc\x68",
  [0x5b29] = "\xdc\x69", [0x5b2a] = "\xdc\x6a", [0x5b2b] = "\xdc\x6b",
  [0x5b2c] = "\xdc\x6c", [0x5b2d] = "\xdc\x6d", [0x5b2e] = "\xdc\x6e",
  [0x5b2f] = "\xdc\x6f", [0x5b30] = "\xdc\x70", [0x5b31] = "\xdc\x71",
  [0x5b32] = "\xdc\x72", [0x5b33] = "\xdc\x73", [0x5b34] = "\xdc\x74",
  [0x5b35] = "\xdc\x75", [0x5b36] = "\xdc\x76", [0x5b37] = "\xdc\x77",
  [0x5b38] = "\xdc\x78", [0x5b39] = "\xdc\x79", [0x5b3a] = "\xdc\x7a",
  [0x5b3b] = "\xdc\x7b", [0x5b3c] = "\xdc\x7c", [0x5b3d] = "\xdc\x7d",
  [0x5b3e] = "\xdc\x7e", [0x5b40] = "\xdc\x80", [0x5b41] = "\xdc\x81",
  [0x5b42] = "\xdc\x82", [0x5b43] = "\xdc\x83", [0x5b44] = "\xdc\x84",
  [0x5b45] = "\xdc\x85", [0x5b46] = "\xdc\x86", [0x5b47] = "\xdc\x87",
  [0x5b48] = "\xdc\x88", [0x5b49] = "\xdc\x89", [0x5b4a] = "\xdc\x8a",
  [0x5b4b] = "\xdc\x8b", [0x5b4c] = "\xdc\x8c", [0x5b4d] = "\xdc\x8d",
  [0x5b4e] = "\xdc\x8e", [0x5b4f] = "\xdc\x8f", [0x5b50] = "\xdc\x90",
  [0x5b51] = "\xdc\x91", [0x5b52] = "\xdc\x92", [0x5b53] = "\xdc\x93",
  [0x5b54] = "\xdc\x94", [0x5b55] = "\xdc\x95", [0x5b56] = "\xdc\x96",
  [0x5b57] = "\xdc\x97", [0x5b58] = "\xdc\x98", [0x5b59] = "\xdc\x99",
  [0x5b5a] = "\xdc\x9a", [0x5b5b] = "\xdc\x9b", [0x5b5c] = "\xdc\x9c",
  [0x5b5d] = "\xdc\x9d", [0x5b5e] = "\xdc\x9e", [0x5b5f] = "\xdc\x9f",
  [0x5b60] = "\xdc\xa0", [0x5b61] = "\xdc\xa1", [0x5b62] = "\xdc\xa2",
  [0x5b63] = "\xdc\xa3", [0x5b64] = "\xdc\xa4", [0x5b65] = "\xdc\xa5",
  [0x5b66] = "\xdc\xa6", [0x5b67] = "\xdc\xa7", [0x5b68] = "\xdc\xa8",
  [0x5b69] = "\xdc\xa9", [0x5b6a] = "\xdc\xaa", [0x5b6b] = "\xdc\xab",
  [0x5b6c] = "\xdc\xac", [0x5b6d] = "\xdc\xad", [0x5b6e] = "\xdc\xae",
  [0x5b6f] = "\xdc\xaf", [0x5b70] = "\xdc\xb0", [0x5b71] = "\xdc\xb1",
  [0x5b72] = "\xdc\xb2", [0x5b73] = "\xdc\xb3", [0x5b74] = "\xdc\xb4",
  [0x5b75] = "\xdc\xb5", [0x5b76] = "\xdc\xb6", [0x5b77] = "\xdc\xb7",
  [0x5b78] = "\xdc\xb8", [0x5b79] = "\xdc\xb9", [0x5b7a] = "\xdc\xba",
  [0x5b7b] = "\xdc\xbb", [0x5b7c] = "\xdc\xbc", [0x5b7d] = "\xdc\xbd",
  [0x5b7e] = "\xdc\xbe", [0x5b7f] = "\xdc\xbf", [0x5b80] = "\xdc\xc0",
  [0x5b81] = "\xdc\xc1", [0x5b82] = "\xdc\xc2", [0x5b83] = "\xdc\xc3",
  [0x5b84] = "\xdc\xc4", [0x5b85] = "\xdc\xc5", [0x5b86] = "\xdc\xc6",
  [0x5b87] = "\xdc\xc7", [0x5b88] = "\xdc\xc8", [0x5b89] = "\xdc\xc9",
  [0x5b8a] = "\xdc\xca", [0x5b8b] = "\xdc\xcb", [0x5b8c] = "\xdc\xcc",
  [0x5b8d] = "\xdc\xcd", [0x5b8e] = "\xdc\xce", [0x5b8f] = "\xdc\xcf",
  [0x5b90] = "\xdc\xd0", [0x5b91] = "\xdc\xd1", [0x5b92] = "\xdc\xd2",
  [0x5b93] = "\xdc\xd3", [0x5b94] = "\xdc\xd4", [0x5b95] = "\xdc\xd5",
  [0x5b96] = "\xdc\xd6", [0x5b97] = "\xdc\xd7", [0x5b98] = "\xdc\xd8",
  [0x5b99] = "\xdc\xd9", [0x5b9a] = "\xdc\xda", [0x5b9b] = "\xdc\xdb",
  [0x5b9c] = "\xdc\xdc", [0x5b9d] = "\xdc\xdd", [0x5b9e] = "\xdc\xde",
  [0x5b9f] = "\xdc\xdf", [0x5ba0] = "\xdc\xe0", [0x5ba1] = "\xdc\xe1",
  [0x5ba2] = "\xdc\xe2", [0x5ba3] = "\xdc\xe3", [0x5ba4] = "\xdc\xe4",
  [0x5ba5] = "\xdc\xe5", [0x5ba6] = "\xdc\xe6", [0x5ba7] = "\xdc\xe7",
  [0x5ba8] = "\xdc\xe8", [0x5ba9] = "\xdc\xe9", [0x5baa] = "\xdc\xea",
  [0x5bab] = "\xdc\xeb", [0x5bac] = "\xdc\xec", [0x5bad] = "\xdc\xed",
  [0x5bae] = "\xdc\xee", [0x5baf] = "\xdc\xef", [0x5bb0] = "\xdc\xf0",
  [0x5bb1] = "\xdc\xf1", [0x5bb2] = "\xdc\xf2", [0x5bb3] = "\xdc\xf3",
  [0x5bb4] = "\xdc\xf4", [0x5bb5] = "\xdc\xf5", [0x5bb6] = "\xdc\xf6",
  [0x5bb7] = "\xdc\xf7", [0x5bb8] = "\xdc\xf8", [0x5bb9] = "\xdc\xf9",
  [0x5bba] = "\xdc\xfa", [0x5bbb] = "\xdc\xfb", [0x5bbc] = "\xdc\xfc",
  [0x5bbd] = "\xdc\xfd", [0x5bbe] = "\xdc\xfe", [0x5c00] = "\xdd\x40",
  [0x5c01] = "\xdd\x41", [0x5c02] = "\xdd\x42", [0x5c03] = "\xdd\x43",
  [0x5c04] = "\xdd\x44", [0x5c05] = "\xdd\x45", [0x5c06] = "\xdd\x46",
  [0x5c07] = "\xdd\x47", [0x5c08] = "\xdd\x48", [0x5c09] = "\xdd\x49",
  [0x5c0a] = "\xdd\x4a", [0x5c0b] = "\xdd\x4b", [0x5c0c] = "\xdd\x4c",
  [0x5c0d] = "\xdd\x4d", [0x5c0e] = "\xdd\x4e", [0x5c0f] = "\xdd\x4f",
  [0x5c10] = "\xdd\x50", [0x5c11] = "\xdd\x51", [0x5c12] = "\xdd\x52",
  [0x5c13] = "\xdd\x53", [0x5c14] = "\xdd\x54", [0x5c15] = "\xdd\x55",
  [0x5c16] = "\xdd\x56", [0x5c17] = "\xdd\x57", [0x5c18] = "\xdd\x58",
  [0x5c19] = "\xdd\x59", [0x5c1a] = "\xdd\x5a", [0x5c1b] = "\xdd\x5b",
  [0x5c1c] = "\xdd\x5c", [0x5c1d] = "\xdd\x5d", [0x5c1e] = "\xdd\x5e",
  [0x5c1f] = "\xdd\x5f", [0x5c20] = "\xdd\x60", [0x5c21] = "\xdd\x61",
  [0x5c22] = "\xdd\x62", [0x5c23] = "\xdd\x63", [0x5c24] = "\xdd\x64",
  [0x5c25] = "\xdd\x65", [0x5c26] = "\xdd\x66", [0x5c27] = "\xdd\x67",
  [0x5c28] = "\xdd\x68", [0x5c29] = "\xdd\x69", [0x5c2a] = "\xdd\x6a",
  [0x5c2b] = "\xdd\x6b", [0x5c2c] = "\xdd\x6c", [0x5c2d] = "\xdd\x6d",
  [0x5c2e] = "\xdd\x6e", [0x5c2f] = "\xdd\x6f", [0x5c30] = "\xdd\x70",
  [0x5c31] = "\xdd\x71", [0x5c32] = "\xdd\x72", [0x5c33] = "\xdd\x73",
  [0x5c34] = "\xdd\x74", [0x5c35] = "\xdd\x75", [0x5c36] = "\xdd\x76",
  [0x5c37] = "\xdd\x77", [0x5c38] = "\xdd\x78", [0x5c39] = "\xdd\x79",
  [0x5c3a] = "\xdd\x7a", [0x5c3b] = "\xdd\x7b", [0x5c3c] = "\xdd\x7c",
  [0x5c3d] = "\xdd\x7d", [0x5c3e] = "\xdd\x7e", [0x5c40] = "\xdd\x80",
  [0x5c41] = "\xdd\x81", [0x5c42] = "\xdd\x82", [0x5c43] = "\xdd\x83",
  [0x5c44] = "\xdd\x84", [0x5c45] = "\xdd\x85", [0x5c46] = "\xdd\x86",
  [0x5c47] = "\xdd\x87", [0x5c48] = "\xdd\x88", [0x5c49] = "\xdd\x89",
  [0x5c4a] = "\xdd\x8a", [0x5c4b] = "\xdd\x8b", [0x5c4c] = "\xdd\x8c",
  [0x5c4d] = "\xdd\x8d", [0x5c4e] = "\xdd\x8e", [0x5c4f] = "\xdd\x8f",
  [0x5c50] = "\xdd\x90", [0x5c51] = "\xdd\x91", [0x5c52] = "\xdd\x92",
  [0x5c53] = "\xdd\x93", [0x5c54] = "\xdd\x94", [0x5c55] = "\xdd\x95",
  [0x5c56] = "\xdd\x96", [0x5c57] = "\xdd\x97", [0x5c58] = "\xdd\x98",
  [0x5c59] = "\xdd\x99", [0x5c5a] = "\xdd\x9a", [0x5c5b] = "\xdd\x9b",
  [0x5c5c] = "\xdd\x9c", [0x5c5d] = "\xdd\x9d", [0x5c5e] = "\xdd\x9e",
  [0x5c5f] = "\xdd\x9f", [0x5c60] = "\xdd\xa0", [0x5c61] = "\xdd\xa1",
  [0x5c62] = "\xdd\xa2", [0x5c63] = "\xdd\xa3", [0x5c64] = "\xdd\xa4",
  [0x5c65] = "\xdd\xa5", [0x5c66] = "\xdd\xa6", [0x5c67] = "\xdd\xa7",
  [0x5c68] = "\xdd\xa8", [0x5c69] = "\xdd\xa9", [0x5c6a] = "\xdd\xaa",
  [0x5c6b] = "\xdd\xab", [0x5c6c] = "\xdd\xac", [0x5c6d] = "\xdd\xad",
  [0x5c6e] = "\xdd\xae", [0x5c6f] = "\xdd\xaf", [0x5c70] = "\xdd\xb0",
  [0x5c71] = "\xdd\xb1", [0x5c72] = "\xdd\xb2", [0x5c73] = "\xdd\xb3",
  [0x5c74] = "\xdd\xb4", [0x5c75] = "\xdd\xb5", [0x5c76] = "\xdd\xb6",
  [0x5c77] = "\xdd\xb7", [0x5c78] = "\xdd\xb8", [0x5c79] = "\xdd\xb9",
  [0x5c7a] = "\xdd\xba", [0x5c7b] = "\xdd\xbb", [0x5c7c] = "\xdd\xbc",
  [0x5c7d] = "\xdd\xbd", [0x5c7e] = "\xdd\xbe", [0x5c7f] = "\xdd\xbf",
  [0x5c80] = "\xdd\xc0", [0x5c81] = "\xdd\xc1", [0x5c82] = "\xdd\xc2",
  [0x5c83] = "\xdd\xc3", [0x5c84] = "\xdd\xc4", [0x5c85] = "\xdd\xc5",
  [0x5c86] = "\xdd\xc6", [0x5c87] = "\xdd\xc7", [0x5c88] = "\xdd\xc8",
  [0x5c89] = "\xdd\xc9", [0x5c8a] = "\xdd\xca", [0x5c8b] = "\xdd\xcb",
  [0x5c8c] = "\xdd\xcc", [0x5c8d] = "\xdd\xcd", [0x5c8e] = "\xdd\xce",
  [0x5c8f] = "\xdd\xcf", [0x5c90] = "\xdd\xd0", [0x5c91] = "\xdd\xd1",
  [0x5c92] = "\xdd\xd2", [0x5c93] = "\xdd\xd3", [0x5c94] = "\xdd\xd4",
  [0x5c95] = "\xdd\xd5", [0x5c96] = "\xdd\xd6", [0x5c97] = "\xdd\xd7",
  [0x5c98] = "\xdd\xd8", [0x5c99] = "\xdd\xd9", [0x5c9a] = "\xdd\xda",
  [0x5c9b] = "\xdd\xdb", [0x5c9c] = "\xdd\xdc", [0x5c9d] = "\xdd\xdd",
  [0x5c9e] = "\xdd\xde", [0x5c9f] = "\xdd\xdf", [0x5ca0] = "\xdd\xe0",
  [0x5ca1] = "\xdd\xe1", [0x5ca2] = "\xdd\xe2", [0x5ca3] = "\xdd\xe3",
  [0x5ca4] = "\xdd\xe4", [0x5ca5] = "\xdd\xe5", [0x5ca6] = "\xdd\xe6",
  [0x5ca7] = "\xdd\xe7", [0x5ca8] = "\xdd\xe8", [0x5ca9] = "\xdd\xe9",
  [0x5caa] = "\xdd\xea", [0x5cab] = "\xdd\xeb", [0x5cac] = "\xdd\xec",
  [0x5cad] = "\xdd\xed", [0x5cae] = "\xdd\xee", [0x5caf] = "\xdd\xef",
  [0x5cb0] = "\xdd\xf0", [0x5cb1] = "\xdd\xf1", [0x5cb2] = "\xdd\xf2",
  [0x5cb3] = "\xdd\xf3", [0x5cb4] = "\xdd\xf4", [0x5cb5] = "\xdd\xf5",
  [0x5cb6] = "\xdd\xf6", [0x5cb7] = "\xdd\xf7", [0x5cb8] = "\xdd\xf8",
  [0x5cb9] = "\xdd\xf9", [0x5cba] = "\xdd\xfa", [0x5cbb] = "\xdd\xfb",
  [0x5cbc] = "\xdd\xfc", [0x5cbd] = "\xdd\xfd", [0x5cbe] = "\xdd\xfe",
  [0x5d00] = "\xde\x40", [0x5d01] = "\xde\x41", [0x5d02] = "\xde\x42",
  [0x5d03] = "\xde\x43", [0x5d04] = "\xde\x44", [0x5d05] = "\xde\x45",
  [0x5d06] = "\xde\x46", [0x5d07] = "\xde\x47", [0x5d08] = "\xde\x48",
  [0x5d09] = "\xde\x49", [0x5d0a] = "\xde\x4a", [0x5d0b] = "\xde\x4b",
  [0x5d0c] = "\xde\x4c", [0x5d0d] = "\xde\x4d", [0x5d0e] = "\xde\x4e",
  [0x5d0f] = "\xde\x4f", [0x5d10] = "\xde\x50", [0x5d11] = "\xde\x51",
  [0x5d12] = "\xde\x52", [0x5d13] = "\xde\x53", [0x5d14] = "\xde\x54",
  [0x5d15] = "\xde\x55", [0x5d16] = "\xde\x56", [0x5d17] = "\xde\x57",
  [0x5d18] = "\xde\x58", [0x5d19] = "\xde\x59", [0x5d1a] = "\xde\x5a",
  [0x5d1b] = "\xde\x5b", [0x5d1c] = "\xde\x5c", [0x5d1d] = "\xde\x5d",
  [0x5d1e] = "\xde\x5e", [0x5d1f] = "\xde\x5f", [0x5d20] = "\xde\x60",
  [0x5d21] = "\xde\x61", [0x5d22] = "\xde\x62", [0x5d23] = "\xde\x63",
  [0x5d24] = "\xde\x64", [0x5d25] = "\xde\x65", [0x5d26] = "\xde\x66",
  [0x5d27] = "\xde\x67", [0x5d28] = "\xde\x68", [0x5d29] = "\xde\x69",
  [0x5d2a] = "\xde\x6a", [0x5d2b] = "\xde\x6b", [0x5d2c] = "\xde\x6c",
  [0x5d2d] = "\xde\x6d", [0x5d2e] = "\xde\x6e", [0x5d2f] = "\xde\x6f",
  [0x5d30] = "\xde\x70", [0x5d31] = "\xde\x71", [0x5d32] = "\xde\x72",
  [0x5d33] = "\xde\x73", [0x5d34] = "\xde\x74", [0x5d35] = "\xde\x75",
  [0x5d36] = "\xde\x76", [0x5d37] = "\xde\x77", [0x5d38] = "\xde\x78",
  [0x5d39] = "\xde\x79", [0x5d3a] = "\xde\x7a", [0x5d3b] = "\xde\x7b",
  [0x5d3c] = "\xde\x7c", [0x5d3d] = "\xde\x7d", [0x5d3e] = "\xde\x7e",
  [0x5d40] = "\xde\x80", [0x5d41] = "\xde\x81", [0x5d42] = "\xde\x82",
  [0x5d43] = "\xde\x83", [0x5d44] = "\xde\x84", [0x5d45] = "\xde\x85",
  [0x5d46] = "\xde\x86", [0x5d47] = "\xde\x87", [0x5d48] = "\xde\x88",
  [0x5d49] = "\xde\x89", [0x5d4a] = "\xde\x8a", [0x5d4b] = "\xde\x8b",
  [0x5d4c] = "\xde\x8c", [0x5d4d] = "\xde\x8d", [0x5d4e] = "\xde\x8e",
  [0x5d4f] = "\xde\x8f", [0x5d50] = "\xde\x90", [0x5d51] = "\xde\x91",
  [0x5d52] = "\xde\x92", [0x5d53] = "\xde\x93", [0x5d54] = "\xde\x94",
  [0x5d55] = "\xde\x95", [0x5d56] = "\xde\x96", [0x5d57] = "\xde\x97",
  [0x5d58] = "\xde\x98", [0x5d59] = "\xde\x99", [0x5d5a] = "\xde\x9a",
  [0x5d5b] = "\xde\x9b", [0x5d5c] = "\xde\x9c", [0x5d5d] = "\xde\x9d",
  [0x5d5e] = "\xde\x9e", [0x5d5f] = "\xde\x9f", [0x5d60] = "\xde\xa0",
  [0x5d61] = "\xde\xa1", [0x5d62] = "\xde\xa2", [0x5d63] = "\xde\xa3",
  [0x5d64] = "\xde\xa4", [0x5d65] = "\xde\xa5", [0x5d66] = "\xde\xa6",
  [0x5d67] = "\xde\xa7", [0x5d68] = "\xde\xa8", [0x5d69] = "\xde\xa9",
  [0x5d6a] = "\xde\xaa", [0x5d6b] = "\xde\xab", [0x5d6c] = "\xde\xac",
  [0x5d6d] = "\xde\xad", [0x5d6e] = "\xde\xae", [0x5d6f] = "\xde\xaf",
  [0x5d70] = "\xde\xb0", [0x5d71] = "\xde\xb1", [0x5d72] = "\xde\xb2",
  [0x5d73] = "\xde\xb3", [0x5d74] = "\xde\xb4", [0x5d75] = "\xde\xb5",
  [0x5d76] = "\xde\xb6", [0x5d77] = "\xde\xb7", [0x5d78] = "\xde\xb8",
  [0x5d79] = "\xde\xb9", [0x5d7a] = "\xde\xba", [0x5d7b] = "\xde\xbb",
  [0x5d7c] = "\xde\xbc", [0x5d7d] = "\xde\xbd", [0x5d7e] = "\xde\xbe",
  [0x5d7f] = "\xde\xbf", [0x5d80] = "\xde\xc0", [0x5d81] = "\xde\xc1",
  [0x5d82] = "\xde\xc2", [0x5d83] = "\xde\xc3", [0x5d84] = "\xde\xc4",
  [0x5d85] = "\xde\xc5", [0x5d86] = "\xde\xc6", [0x5d87] = "\xde\xc7",
  [0x5d88] = "\xde\xc8", [0x5d89] = "\xde\xc9", [0x5d8a] = "\xde\xca",
  [0x5d8b] = "\xde\xcb", [0x5d8c] = "\xde\xcc", [0x5d8d] = "\xde\xcd",
  [0x5d8e] = "\xde\xce", [0x5d8f] = "\xde\xcf", [0x5d90] = "\xde\xd0",
  [0x5d91] = "\xde\xd1", [0x5d92] = "\xde\xd2", [0x5d93] = "\xde\xd3",
  [0x5d94] = "\xde\xd4", [0x5d95] = "\xde\xd5", [0x5d96] = "\xde\xd6",
  [0x5d97] = "\xde\xd7", [0x5d98] = "\xde\xd8", [0x5d99] = "\xde\xd9",
  [0x5d9a] = "\xde\xda", [0x5d9b] = "\xde\xdb", [0x5d9c] = "\xde\xdc",
  [0x5d9d] = "\xde\xdd", [0x5d9e] = "\xde\xde", [0x5d9f] = "\xde\xdf",
  [0x5da0] = "\xde\xe0", [0x5da1] = "\xde\xe1", [0x5da2] = "\xde\xe2",
  [0x5da3] = "\xde\xe3", [0x5da4] = "\xde\xe4", [0x5da5] = "\xde\xe5",
  [0x5da6] = "\xde\xe6", [0x5da7] = "\xde\xe7", [0x5da8] = "\xde\xe8",
  [0x5da9] = "\xde\xe9", [0x5daa] = "\xde\xea", [0x5dab] = "\xde\xeb",
  [0x5dac] = "\xde\xec", [0x5dad] = "\xde\xed", [0x5dae] = "\xde\xee",
  [0x5daf] = "\xde\xef", [0x5db0] = "\xde\xf0", [0x5db1] = "\xde\xf1",
  [0x5db2] = "\xde\xf2", [0x5db3] = "\xde\xf3", [0x5db4] = "\xde\xf4",
  [0x5db5] = "\xde\xf5", [0x5db6] = "\xde\xf6", [0x5db7] = "\xde\xf7",
  [0x5db8] = "\xde\xf8", [0x5db9] = "\xde\xf9", [0x5dba] = "\xde\xfa",
  [0x5dbb] = "\xde\xfb", [0x5dbc] = "\xde\xfc", [0x5dbd] = "\xde\xfd",
  [0x5dbe] = "\xde\xfe", [0x5e00] = "\xdf\x40", [0x5e01] = "\xdf\x41",
  [0x5e02] = "\xdf\x42", [0x5e03] = "\xdf\x43", [0x5e04] = "\xdf\x44",
  [0x5e05] = "\xdf\x45", [0x5e06] = "\xdf\x46", [0x5e07] = "\xdf\x47",
  [0x5e08] = "\xdf\x48", [0x5e09] = "\xdf\x49", [0x5e0a] = "\xdf\x4a",
  [0x5e0b] = "\xdf\x4b", [0x5e0c] = "\xdf\x4c", [0x5e0d] = "\xdf\x4d",
  [0x5e0e] = "\xdf\x4e", [0x5e0f] = "\xdf\x4f", [0x5e10] = "\xdf\x50",
  [0x5e11] = "\xdf\x51", [0x5e12] = "\xdf\x52", [0x5e13] = "\xdf\x53",
  [0x5e14] = "\xdf\x54", [0x5e15] = "\xdf\x55", [0x5e16] = "\xdf\x56",
  [0x5e17] = "\xdf\x57", [0x5e18] = "\xdf\x58", [0x5e19] = "\xdf\x59",
  [0x5e1a] = "\xdf\x5a", [0x5e1b] = "\xdf\x5b", [0x5e1c] = "\xdf\x5c",
  [0x5e1d] = "\xdf\x5d", [0x5e1e] = "\xdf\x5e", [0x5e1f] = "\xdf\x5f",
  [0x5e20] = "\xdf\x60", [0x5e21] = "\xdf\x61", [0x5e22] = "\xdf\x62",
  [0x5e23] = "\xdf\x63", [0x5e24] = "\xdf\x64", [0x5e25] = "\xdf\x65",
  [0x5e26] = "\xdf\x66", [0x5e27] = "\xdf\x67", [0x5e28] = "\xdf\x68",
  [0x5e29] = "\xdf\x69", [0x5e2a] = "\xdf\x6a", [0x5e2b] = "\xdf\x6b",
  [0x5e2c] = "\xdf\x6c", [0x5e2d] = "\xdf\x6d", [0x5e2e] = "\xdf\x6e",
  [0x5e2f] = "\xdf\x6f", [0x5e30] = "\xdf\x70", [0x5e31] = "\xdf\x71",
  [0x5e32] = "\xdf\x72", [0x5e33] = "\xdf\x73", [0x5e34] = "\xdf\x74",
  [0x5e35] = "\xdf\x75", [0x5e36] = "\xdf\x76", [0x5e37] = "\xdf\x77",
  [0x5e38] = "\xdf\x78", [0x5e39] = "\xdf\x79", [0x5e3a] = "\xdf\x7a",
  [0x5e3b] = "\xdf\x7b", [0x5e3c] = "\xdf\x7c", [0x5e3d] = "\xdf\x7d",
  [0x5e3e] = "\xdf\x7e", [0x5e40] = "\xdf\x80", [0x5e41] = "\xdf\x81",
  [0x5e42] = "\xdf\x82", [0x5e43] = "\xdf\x83", [0x5e44] = "\xdf\x84",
  [0x5e45] = "\xdf\x85", [0x5e46] = "\xdf\x86", [0x5e47] = "\xdf\x87",
  [0x5e48] = "\xdf\x88", [0x5e49] = "\xdf\x89", [0x5e4a] = "\xdf\x8a",
  [0x5e4b] = "\xdf\x8b", [0x5e4c] = "\xdf\x8c", [0x5e4d] = "\xdf\x8d",
  [0x5e4e] = "\xdf\x8e", [0x5e4f] = "\xdf\x8f", [0x5e50] = "\xdf\x90",
  [0x5e51] = "\xdf\x91", [0x5e52] = "\xdf\x92", [0x5e53] = "\xdf\x93",
  [0x5e54] = "\xdf\x94", [0x5e55] = "\xdf\x95", [0x5e56] = "\xdf\x96",
  [0x5e57] = "\xdf\x97", [0x5e58] = "\xdf\x98", [0x5e59] = "\xdf\x99",
  [0x5e5a] = "\xdf\x9a", [0x5e5b] = "\xdf\x9b", [0x5e5c] = "\xdf\x9c",
  [0x5e5d] = "\xdf\x9d", [0x5e5e] = "\xdf\x9e", [0x5e5f] = "\xdf\x9f",
  [0x5e60] = "\xdf\xa0", [0x5e61] = "\xdf\xa1", [0x5e62] = "\xdf\xa2",
  [0x5e63] = "\xdf\xa3", [0x5e64] = "\xdf\xa4", [0x5e65] = "\xdf\xa5",
  [0x5e66] = "\xdf\xa6", [0x5e67] = "\xdf\xa7", [0x5e68] = "\xdf\xa8",
  [0x5e69] = "\xdf\xa9", [0x5e6a] = "\xdf\xaa", [0x5e6b] = "\xdf\xab",
  [0x5e6c] = "\xdf\xac", [0x5e6d] = "\xdf\xad", [0x5e6e] = "\xdf\xae",
  [0x5e6f] = "\xdf\xaf", [0x5e70] = "\xdf\xb0", [0x5e71] = "\xdf\xb1",
  [0x5e72] = "\xdf\xb2", [0x5e73] = "\xdf\xb3", [0x5e74] = "\xdf\xb4",
  [0x5e75] = "\xdf\xb5", [0x5e76] = "\xdf\xb6", [0x5e77] = "\xdf\xb7",
  [0x5e78] = "\xdf\xb8", [0x5e79] = "\xdf\xb9", [0x5e7a] = "\xdf\xba",
  [0x5e7b] = "\xdf\xbb", [0x5e7c] = "\xdf\xbc", [0x5e7d] = "\xdf\xbd",
  [0x5e7e] = "\xdf\xbe", [0x5e7f] = "\xdf\xbf", [0x5e80] = "\xdf\xc0",
  [0x5e81] = "\xdf\xc1", [0x5e82] = "\xdf\xc2", [0x5e83] = "\xdf\xc3",
  [0x5e84] = "\xdf\xc4", [0x5e85] = "\xdf\xc5", [0x5e86] = "\xdf\xc6",
  [0x5e87] = "\xdf\xc7", [0x5e88] = "\xdf\xc8", [0x5e89] = "\xdf\xc9",
  [0x5e8a] = "\xdf\xca", [0x5e8b] = "\xdf\xcb", [0x5e8c] = "\xdf\xcc",
  [0x5e8d] = "\xdf\xcd", [0x5e8e] = "\xdf\xce", [0x5e8f] = "\xdf\xcf",
  [0x5e90] = "\xdf\xd0", [0x5e91] = "\xdf\xd1", [0x5e92] = "\xdf\xd2",
  [0x5e93] = "\xdf\xd3", [0x5e94] = "\xdf\xd4", [0x5e95] = "\xdf\xd5",
  [0x5e96] = "\xdf\xd6", [0x5e97] = "\xdf\xd7", [0x5e98] = "\xdf\xd8",
  [0x5e99] = "\xdf\xd9", [0x5e9a] = "\xdf\xda", [0x5e9b] = "\xdf\xdb",
  [0x5e9c] = "\xdf\xdc", [0x5e9d] = "\xdf\xdd", [0x5e9e] = "\xdf\xde",
  [0x5e9f] = "\xdf\xdf", [0x5ea0] = "\xdf\xe0", [0x5ea1] = "\xdf\xe1",
  [0x5ea2] = "\xdf\xe2", [0x5ea3] = "\xdf\xe3", [0x5ea4] = "\xdf\xe4",
  [0x5ea5] = "\xdf\xe5", [0x5ea6] = "\xdf\xe6", [0x5ea7] = "\xdf\xe7",
  [0x5ea8] = "\xdf\xe8", [0x5ea9] = "\xdf\xe9", [0x5eaa] = "\xdf\xea",
  [0x5eab] = "\xdf\xeb", [0x5eac] = "\xdf\xec", [0x5ead] = "\xdf\xed",
  [0x5eae] = "\xdf\xee", [0x5eaf] = "\xdf\xef", [0x5eb0] = "\xdf\xf0",
  [0x5eb1] = "\xdf\xf1", [0x5eb2] = "\xdf\xf2", [0x5eb3] = "\xdf\xf3",
  [0x5eb4] = "\xdf\xf4", [0x5eb5] = "\xdf\xf5", [0x5eb6] = "\xdf\xf6",
  [0x5eb7] = "\xdf\xf7", [0x5eb8] = "\xdf\xf8", [0x5eb9] = "\xdf\xf9",
  [0x5eba] = "\xdf\xfa", [0x5ebb] = "\xdf\xfb", [0x5ebc] = "\xdf\xfc",
  [0x5ebd] = "\xdf\xfd", [0x5ebe] = "\xdf\xfe", [0x5f00] = "\xe0\x40",
  [0x5f01] = "\xe0\x41", [0x5f02] = "\xe0\x42", [0x5f03] = "\xe0\x43",
  [0x5f04] = "\xe0\x44", [0x5f05] = "\xe0\x45", [0x5f06] = "\xe0\x46",
  [0x5f07] = "\xe0\x47", [0x5f08] = "\xe0\x48", [0x5f09] = "\xe0\x49",
  [0x5f0a] = "\xe0\x4a", [0x5f0b] = "\xe0\x4b", [0x5f0c] = "\xe0\x4c",
  [0x5f0d] = "\xe0\x4d", [0x5f0e] = "\xe0\x4e", [0x5f0f] = "\xe0\x4f",
  [0x5f10] = "\xe0\x50", [0x5f11] = "\xe0\x51", [0x5f12] = "\xe0\x52",
  [0x5f13] = "\xe0\x53", [0x5f14] = "\xe0\x54", [0x5f15] = "\xe0\x55",
  [0x5f16] = "\xe0\x56", [0x5f17] = "\xe0\x57", [0x5f18] = "\xe0\x58",
  [0x5f19] = "\xe0\x59", [0x5f1a] = "\xe0\x5a", [0x5f1b] = "\xe0\x5b",
  [0x5f1c] = "\xe0\x5c", [0x5f1d] = "\xe0\x5d", [0x5f1e] = "\xe0\x5e",
  [0x5f1f] = "\xe0\x5f", [0x5f20] = "\xe0\x60", [0x5f21] = "\xe0\x61",
  [0x5f22] = "\xe0\x62", [0x5f23] = "\xe0\x63", [0x5f24] = "\xe0\x64",
  [0x5f25] = "\xe0\x65", [0x5f26] = "\xe0\x66", [0x5f27] = "\xe0\x67",
  [0x5f28] = "\xe0\x68", [0x5f29] = "\xe0\x69", [0x5f2a] = "\xe0\x6a",
  [0x5f2b] = "\xe0\x6b", [0x5f2c] = "\xe0\x6c", [0x5f2d] = "\xe0\x6d",
  [0x5f2e] = "\xe0\x6e", [0x5f2f] = "\xe0\x6f", [0x5f30] = "\xe0\x70",
  [0x5f31] = "\xe0\x71", [0x5f32] = "\xe0\x72", [0x5f33] = "\xe0\x73",
  [0x5f34] = "\xe0\x74", [0x5f35] = "\xe0\x75", [0x5f36] = "\xe0\x76",
  [0x5f37] = "\xe0\x77", [0x5f38] = "\xe0\x78", [0x5f39] = "\xe0\x79",
  [0x5f3a] = "\xe0\x7a", [0x5f3b] = "\xe0\x7b", [0x5f3c] = "\xe0\x7c",
  [0x5f3d] = "\xe0\x7d", [0x5f3e] = "\xe0\x7e", [0x5f40] = "\xe0\x80",
  [0x5f41] = "\xe0\x81", [0x5f42] = "\xe0\x82", [0x5f43] = "\xe0\x83",
  [0x5f44] = "\xe0\x84", [0x5f45] = "\xe0\x85", [0x5f46] = "\xe0\x86",
  [0x5f47] = "\xe0\x87", [0x5f48] = "\xe0\x88", [0x5f49] = "\xe0\x89",
  [0x5f4a] = "\xe0\x8a", [0x5f4b] = "\xe0\x8b", [0x5f4c] = "\xe0\x8c",
  [0x5f4d] = "\xe0\x8d", [0x5f4e] = "\xe0\x8e", [0x5f4f] = "\xe0\x8f",
  [0x5f50] = "\xe0\x90", [0x5f51] = "\xe0\x91", [0x5f52] = "\xe0\x92",
  [0x5f53] = "\xe0\x93", [0x5f54] = "\xe0\x94", [0x5f55] = "\xe0\x95",
  [0x5f56] = "\xe0\x96", [0x5f57] = "\xe0\x97", [0x5f58] = "\xe0\x98",
  [0x5f59] = "\xe0\x99", [0x5f5a] = "\xe0\x9a", [0x5f5b] = "\xe0\x9b",
  [0x5f5c] = "\xe0\x9c", [0x5f5d] = "\xe0\x9d", [0x5f5e] = "\xe0\x9e",
  [0x5f5f] = "\xe0\x9f", [0x5f60] = "\xe0\xa0", [0x5f61] = "\xe0\xa1",
  [0x5f62] = "\xe0\xa2", [0x5f63] = "\xe0\xa3", [0x5f64] = "\xe0\xa4",
  [0x5f65] = "\xe0\xa5", [0x5f66] = "\xe0\xa6", [0x5f67] = "\xe0\xa7",
  [0x5f68] = "\xe0\xa8", [0x5f69] = "\xe0\xa9", [0x5f6a] = "\xe0\xaa",
  [0x5f6b] = "\xe0\xab", [0x5f6c] = "\xe0\xac", [0x5f6d] = "\xe0\xad",
  [0x5f6e] = "\xe0\xae", [0x5f6f] = "\xe0\xaf", [0x5f70] = "\xe0\xb0",
  [0x5f71] = "\xe0\xb1", [0x5f72] = "\xe0\xb2", [0x5f73] = "\xe0\xb3",
  [0x5f74] = "\xe0\xb4", [0x5f75] = "\xe0\xb5", [0x5f76] = "\xe0\xb6",
  [0x5f77] = "\xe0\xb7", [0x5f78] = "\xe0\xb8", [0x5f79] = "\xe0\xb9",
  [0x5f7a] = "\xe0\xba", [0x5f7b] = "\xe0\xbb", [0x5f7c] = "\xe0\xbc",
  [0x5f7d] = "\xe0\xbd", [0x5f7e] = "\xe0\xbe", [0x5f7f] = "\xe0\xbf",
  [0x5f80] = "\xe0\xc0", [0x5f81] = "\xe0\xc1", [0x5f82] = "\xe0\xc2",
  [0x5f83] = "\xe0\xc3", [0x5f84] = "\xe0\xc4", [0x5f85] = "\xe0\xc5",
  [0x5f86] = "\xe0\xc6", [0x5f87] = "\xe0\xc7", [0x5f88] = "\xe0\xc8",
  [0x5f89] = "\xe0\xc9", [0x5f8a] = "\xe0\xca", [0x5f8b] = "\xe0\xcb",
  [0x5f8c] = "\xe0\xcc", [0x5f8d] = "\xe0\xcd", [0x5f8e] = "\xe0\xce",
  [0x5f8f] = "\xe0\xcf", [0x5f90] = "\xe0\xd0", [0x5f91] = "\xe0\xd1",
  [0x5f92] = "\xe0\xd2", [0x5f93] = "\xe0\xd3", [0x5f94] = "\xe0\xd4",
  [0x5f95] = "\xe0\xd5", [0x5f96] = "\xe0\xd6", [0x5f97] = "\xe0\xd7",
  [0x5f98] = "\xe0\xd8", [0x5f99] = "\xe0\xd9", [0x5f9a] = "\xe0\xda",
  [0x5f9b] = "\xe0\xdb", [0x5f9c] = "\xe0\xdc", [0x5f9d] = "\xe0\xdd",
  [0x5f9e] = "\xe0\xde", [0x5f9f] = "\xe0\xdf", [0x5fa0] = "\xe0\xe0",
  [0x5fa1] = "\xe0\xe1", [0x5fa2] = "\xe0\xe2", [0x5fa3] = "\xe0\xe3",
  [0x5fa4] = "\xe0\xe4", [0x5fa5] = "\xe0\xe5", [0x5fa6] = "\xe0\xe6",
  [0x5fa7] = "\xe0\xe7", [0x5fa8] = "\xe0\xe8", [0x5fa9] = "\xe0\xe9",
  [0x5faa] = "\xe0\xea", [0x5fab] = "\xe0\xeb", [0x5fac] = "\xe0\xec",
  [0x5fad] = "\xe0\xed", [0x5fae] = "\xe0\xee", [0x5faf] = "\xe0\xef",
  [0x5fb0] = "\xe0\xf0", [0x5fb1] = "\xe0\xf1", [0x5fb2] = "\xe0\xf2",
  [0x5fb3] = "\xe0\xf3", [0x5fb4] = "\xe0\xf4", [0x5fb5] = "\xe0\xf5",
  [0x5fb6] = "\xe0\xf6", [0x5fb7] = "\xe0\xf7", [0x5fb8] = "\xe0\xf8",
  [0x5fb9] = "\xe0\xf9", [0x5fba] = "\xe0\xfa", [0x5fbb] = "\xe0\xfb",
  [0x5fbc] = "\xe0\xfc", [0x5fbd] = "\xe0\xfd", [0x5fbe] = "\xe0\xfe",
  [0x6000] = "\xe1\x40", [0x6001] = "\xe1\x41", [0x6002] = "\xe1\x42",
  [0x6003] = "\xe1\x43", [0x6004] = "\xe1\x44", [0x6005] = "\xe1\x45",
  [0x6006] = "\xe1\x46", [0x6007] = "\xe1\x47", [0x6008] = "\xe1\x48",
  [0x6009] = "\xe1\x49", [0x600a] = "\xe1\x4a", [0x600b] = "\xe1\x4b",
  [0x600c] = "\xe1\x4c", [0x600d] = "\xe1\x4d", [0x600e] = "\xe1\x4e",
  [0x600f] = "\xe1\x4f", [0x6010] = "\xe1\x50", [0x6011] = "\xe1\x51",
  [0x6012] = "\xe1\x52", [0x6013] = "\xe1\x53", [0x6014] = "\xe1\x54",
  [0x6015] = "\xe1\x55", [0x6016] = "\xe1\x56", [0x6017] = "\xe1\x57",
  [0x6018] = "\xe1\x58", [0x6019] = "\xe1\x59", [0x601a] = "\xe1\x5a",
  [0x601b] = "\xe1\x5b", [0x601c] = "\xe1\x5c", [0x601d] = "\xe1\x5d",
  [0x601e] = "\xe1\x5e", [0x601f] = "\xe1\x5f", [0x6020] = "\xe1\x60",
  [0x6021] = "\xe1\x61", [0x6022] = "\xe1\x62", [0x6023] = "\xe1\x63",
  [0x6024] = "\xe1\x64", [0x6025] = "\xe1\x65", [0x6026] = "\xe1\x66",
  [0x6027] = "\xe1\x67", [0x6028] = "\xe1\x68", [0x6029] = "\xe1\x69",
  [0x602a] = "\xe1\x6a", [0x602b] = "\xe1\x6b", [0x602c] = "\xe1\x6c",
  [0x602d] = "\xe1\x6d", [0x602e] = "\xe1\x6e", [0x602f] = "\xe1\x6f",
  [0x6030] = "\xe1\x70", [0x6031] = "\xe1\x71", [0x6032] = "\xe1\x72",
  [0x6033] = "\xe1\x73", [0x6034] = "\xe1\x74", [0x6035] = "\xe1\x75",
  [0x6036] = "\xe1\x76", [0x6037] = "\xe1\x77", [0x6038] = "\xe1\x78",
  [0x6039] = "\xe1\x79", [0x603a] = "\xe1\x7a", [0x603b] = "\xe1\x7b",
  [0x603c] = "\xe1\x7c", [0x603d] = "\xe1\x7d", [0x603e] = "\xe1\x7e",
  [0x6040] = "\xe1\x80", [0x6041] = "\xe1\x81", [0x6042] = "\xe1\x82",
  [0x6043] = "\xe1\x83", [0x6044] = "\xe1\x84", [0x6045] = "\xe1\x85",
  [0x6046] = "\xe1\x86", [0x6047] = "\xe1\x87", [0x6048] = "\xe1\x88",
  [0x6049] = "\xe1\x89", [0x604a] = "\xe1\x8a", [0x604b] = "\xe1\x8b",
  [0x604c] = "\xe1\x8c", [0x604d] = "\xe1\x8d", [0x604e] = "\xe1\x8e",
  [0x604f] = "\xe1\x8f", [0x6050] = "\xe1\x90", [0x6051] = "\xe1\x91",
  [0x6052] = "\xe1\x92", [0x6053] = "\xe1\x93", [0x6054] = "\xe1\x94",
  [0x6055] = "\xe1\x95", [0x6056] = "\xe1\x96", [0x6057] = "\xe1\x97",
  [0x6058] = "\xe1\x98", [0x6059] = "\xe1\x99", [0x605a] = "\xe1\x9a",
  [0x605b] = "\xe1\x9b", [0x605c] = "\xe1\x9c", [0x605d] = "\xe1\x9d",
  [0x605e] = "\xe1\x9e", [0x605f] = "\xe1\x9f", [0x6060] = "\xe1\xa0",
  [0x6061] = "\xe1\xa1", [0x6062] = "\xe1\xa2", [0x6063] = "\xe1\xa3",
  [0x6064] = "\xe1\xa4", [0x6065] = "\xe1\xa5", [0x6066] = "\xe1\xa6",
  [0x6067] = "\xe1\xa7", [0x6068] = "\xe1\xa8", [0x6069] = "\xe1\xa9",
  [0x606a] = "\xe1\xaa", [0x606b] = "\xe1\xab", [0x606c] = "\xe1\xac",
  [0x606d] = "\xe1\xad", [0x606e] = "\xe1\xae", [0x606f] = "\xe1\xaf",
  [0x6070] = "\xe1\xb0", [0x6071] = "\xe1\xb1", [0x6072] = "\xe1\xb2",
  [0x6073] = "\xe1\xb3", [0x6074] = "\xe1\xb4", [0x6075] = "\xe1\xb5",
  [0x6076] = "\xe1\xb6", [0x6077] = "\xe1\xb7", [0x6078] = "\xe1\xb8",
  [0x6079] = "\xe1\xb9", [0x607a] = "\xe1\xba", [0x607b] = "\xe1\xbb",
  [0x607c] = "\xe1\xbc", [0x607d] = "\xe1\xbd", [0x607e] = "\xe1\xbe",
  [0x607f] = "\xe1\xbf", [0x6080] = "\xe1\xc0", [0x6081] = "\xe1\xc1",
  [0x6082] = "\xe1\xc2", [0x6083] = "\xe1\xc3", [0x6084] = "\xe1\xc4",
  [0x6085] = "\xe1\xc5", [0x6086] = "\xe1\xc6", [0x6087] = "\xe1\xc7",
  [0x6088] = "\xe1\xc8", [0x6089] = "\xe1\xc9", [0x608a] = "\xe1\xca",
  [0x608b] = "\xe1\xcb", [0x608c] = "\xe1\xcc", [0x608d] = "\xe1\xcd",
  [0x608e] = "\xe1\xce", [0x608f] = "\xe1\xcf", [0x6090] = "\xe1\xd0",
  [0x6091] = "\xe1\xd1", [0x6092] = "\xe1\xd2", [0x6093] = "\xe1\xd3",
  [0x6094] = "\xe1\xd4", [0x6095] = "\xe1\xd5", [0x6096] = "\xe1\xd6",
  [0x6097] = "\xe1\xd7", [0x6098] = "\xe1\xd8", [0x6099] = "\xe1\xd9",
  [0x609a] = "\xe1\xda", [0x609b] = "\xe1\xdb", [0x609c] = "\xe1\xdc",
  [0x609d] = "\xe1\xdd", [0x609e] = "\xe1\xde", [0x609f] = "\xe1\xdf",
  [0x60a0] = "\xe1\xe0", [0x60a1] = "\xe1\xe1", [0x60a2] = "\xe1\xe2",
  [0x60a3] = "\xe1\xe3", [0x60a4] = "\xe1\xe4", [0x60a5] = "\xe1\xe5",
  [0x60a6] = "\xe1\xe6", [0x60a7] = "\xe1\xe7", [0x60a8] = "\xe1\xe8",
  [0x60a9] = "\xe1\xe9", [0x60aa] = "\xe1\xea", [0x60ab] = "\xe1\xeb",
  [0x60ac] = "\xe1\xec", [0x60ad] = "\xe1\xed", [0x60ae] = "\xe1\xee",
  [0x60af] = "\xe1\xef", [0x60b0] = "\xe1\xf0", [0x60b1] = "\xe1\xf1",
  [0x60b2] = "\xe1\xf2", [0x60b3] = "\xe1\xf3", [0x60b4] = "\xe1\xf4",
  [0x60b5] = "\xe1\xf5", [0x60b6] = "\xe1\xf6", [0x60b7] = "\xe1\xf7",
  [0x60b8] = "\xe1\xf8", [0x60b9] = "\xe1\xf9", [0x60ba] = "\xe1\xfa",
  [0x60bb] = "\xe1\xfb", [0x60bc] = "\xe1\xfc", [0x60bd] = "\xe1\xfd",
  [0x60be] = "\xe1\xfe", [0x6100] = "\xe2\x40", [0x6101] = "\xe2\x41",
  [0x6102] = "\xe2\x42", [0x6103] = "\xe2\x43", [0x6104] = "\xe2\x44",
  [0x6105] = "\xe2\x45", [0x6106] = "\xe2\x46", [0x6107] = "\xe2\x47",
  [0x6108] = "\xe2\x48", [0x6109] = "\xe2\x49", [0x610a] = "\xe2\x4a",
  [0x610b] = "\xe2\x4b", [0x610c] = "\xe2\x4c", [0x610d] = "\xe2\x4d",
  [0x610e] = "\xe2\x4e", [0x610f] = "\xe2\x4f", [0x6110] = "\xe2\x50",
  [0x6111] = "\xe2\x51", [0x6112] = "\xe2\x52", [0x6113] = "\xe2\x53",
  [0x6114] = "\xe2\x54", [0x6115] = "\xe2\x55", [0x6116] = "\xe2\x56",
  [0x6117] = "\xe2\x57", [0x6118] = "\xe2\x58", [0x6119] = "\xe2\x59",
  [0x611a] = "\xe2\x5a", [0x611b] = "\xe2\x5b", [0x611c] = "\xe2\x5c",
  [0x611d] = "\xe2\x5d", [0x611e] = "\xe2\x5e", [0x611f] = "\xe2\x5f",
  [0x6120] = "\xe2\x60", [0x6121] = "\xe2\x61", [0x6122] = "\xe2\x62",
  [0x6123] = "\xe2\x63", [0x6124] = "\xe2\x64", [0x6125] = "\xe2\x65",
  [0x6126] = "\xe2\x66", [0x6127] = "\xe2\x67", [0x6128] = "\xe2\x68",
  [0x6129] = "\xe2\x69", [0x612a] = "\xe2\x6a", [0x612b] = "\xe2\x6b",
  [0x612c] = "\xe2\x6c", [0x612d] = "\xe2\x6d", [0x612e] = "\xe2\x6e",
  [0x612f] = "\xe2\x6f", [0x6130] = "\xe2\x70", [0x6131] = "\xe2\x71",
  [0x6132] = "\xe2\x72", [0x6133] = "\xe2\x73", [0x6134] = "\xe2\x74",
  [0x6135] = "\xe2\x75", [0x6136] = "\xe2\x76", [0x6137] = "\xe2\x77",
  [0x6138] = "\xe2\x78", [0x6139] = "\xe2\x79", [0x613a] = "\xe2\x7a",
  [0x613b] = "\xe2\x7b", [0x613c] = "\xe2\x7c", [0x613d] = "\xe2\x7d",
  [0x613e] = "\xe2\x7e", [0x6140] = "\xe2\x80", [0x6141] = "\xe2\x81",
  [0x6142] = "\xe2\x82", [0x6143] = "\xe2\x83", [0x6144] = "\xe2\x84",
  [0x6145] = "\xe2\x85", [0x6146] = "\xe2\x86", [0x6147] = "\xe2\x87",
  [0x6148] = "\xe2\x88", [0x6149] = "\xe2\x89", [0x614a] = "\xe2\x8a",
  [0x614b] = "\xe2\x8b", [0x614c] = "\xe2\x8c", [0x614d] = "\xe2\x8d",
  [0x614e] = "\xe2\x8e", [0x614f] = "\xe2\x8f", [0x6150] = "\xe2\x90",
  [0x6151] = "\xe2\x91", [0x6152] = "\xe2\x92", [0x6153] = "\xe2\x93",
  [0x6154] = "\xe2\x94", [0x6155] = "\xe2\x95", [0x6156] = "\xe2\x96",
  [0x6157] = "\xe2\x97", [0x6158] = "\xe2\x98", [0x6159] = "\xe2\x99",
  [0x615a] = "\xe2\x9a", [0x615b] = "\xe2\x9b", [0x615c] = "\xe2\x9c",
  [0x615d] = "\xe2\x9d", [0x615e] = "\xe2\x9e", [0x615f] = "\xe2\x9f",
  [0x6160] = "\xe2\xa0", [0x6161] = "\xe2\xa1", [0x6162] = "\xe2\xa2",
  [0x6163] = "\xe2\xa3", [0x6164] = "\xe2\xa4", [0x6165] = "\xe2\xa5",
  [0x6166] = "\xe2\xa6", [0x6167] = "\xe2\xa7", [0x6168] = "\xe2\xa8",
  [0x6169] = "\xe2\xa9", [0x616a] = "\xe2\xaa", [0x616b] = "\xe2\xab",
  [0x616c] = "\xe2\xac", [0x616d] = "\xe2\xad", [0x616e] = "\xe2\xae",
  [0x616f] = "\xe2\xaf", [0x6170] = "\xe2\xb0", [0x6171] = "\xe2\xb1",
  [0x6172] = "\xe2\xb2", [0x6173] = "\xe2\xb3", [0x6174] = "\xe2\xb4",
  [0x6175] = "\xe2\xb5", [0x6176] = "\xe2\xb6", [0x6177] = "\xe2\xb7",
  [0x6178] = "\xe2\xb8", [0x6179] = "\xe2\xb9", [0x617a] = "\xe2\xba",
  [0x617b] = "\xe2\xbb", [0x617c] = "\xe2\xbc", [0x617d] = "\xe2\xbd",
  [0x617e] = "\xe2\xbe", [0x617f] = "\xe2\xbf", [0x6180] = "\xe2\xc0",
  [0x6181] = "\xe2\xc1", [0x6182] = "\xe2\xc2", [0x6183] = "\xe2\xc3",
  [0x6184] = "\xe2\xc4", [0x6185] = "\xe2\xc5", [0x6186] = "\xe2\xc6",
  [0x6187] = "\xe2\xc7", [0x6188] = "\xe2\xc8", [0x6189] = "\xe2\xc9",
  [0x618a] = "\xe2\xca", [0x618b] = "\xe2\xcb", [0x618c] = "\xe2\xcc",
  [0x618d] = "\xe2\xcd", [0x618e] = "\xe2\xce", [0x618f] = "\xe2\xcf",
  [0x6190] = "\xe2\xd0", [0x6191] = "\xe2\xd1", [0x6192] = "\xe2\xd2",
  [0x6193] = "\xe2\xd3", [0x6194] = "\xe2\xd4", [0x6195] = "\xe2\xd5",
  [0x6196] = "\xe2\xd6", [0x6197] = "\xe2\xd7", [0x6198] = "\xe2\xd8",
  [0x6199] = "\xe2\xd9", [0x619a] = "\xe2\xda", [0x619b] = "\xe2\xdb",
  [0x619c] = "\xe2\xdc", [0x619d] = "\xe2\xdd", [0x619e] = "\xe2\xde",
  [0x619f] = "\xe2\xdf", [0x61a0] = "\xe2\xe0", [0x61a1] = "\xe2\xe1",
  [0x61a2] = "\xe2\xe2", [0x61a3] = "\xe2\xe3", [0x61a4] = "\xe2\xe4",
  [0x61a5] = "\xe2\xe5", [0x61a6] = "\xe2\xe6", [0x61a7] = "\xe2\xe7",
  [0x61a8] = "\xe2\xe8", [0x61a9] = "\xe2\xe9", [0x61aa] = "\xe2\xea",
  [0x61ab] = "\xe2\xeb", [0x61ac] = "\xe2\xec", [0x61ad] = "\xe2\xed",
  [0x61ae] = "\xe2\xee", [0x61af] = "\xe2\xef", [0x61b0] = "\xe2\xf0",
  [0x61b1] = "\xe2\xf1", [0x61b2] = "\xe2\xf2", [0x61b3] = "\xe2\xf3",
  [0x61b4] = "\xe2\xf4", [0x61b5] = "\xe2\xf5", [0x61b6] = "\xe2\xf6",
  [0x61b7] = "\xe2\xf7", [0x61b8] = "\xe2\xf8", [0x61b9] = "\xe2\xf9",
  [0x61ba] = "\xe2\xfa", [0x61bb] = "\xe2\xfb", [0x61bc] = "\xe2\xfc",
  [0x61bd] = "\xe2\xfd", [0x61be] = "\xe2\xfe", [0x6200] = "\xe3\x40",
  [0x6201] = "\xe3\x41", [0x6202] = "\xe3\x42", [0x6203] = "\xe3\x43",
  [0x6204] = "\xe3\x44", [0x6205] = "\xe3\x45", [0x6206] = "\xe3\x46",
  [0x6207] = "\xe3\x47", [0x6208] = "\xe3\x48", [0x6209] = "\xe3\x49",
  [0x620a] = "\xe3\x4a", [0x620b] = "\xe3\x4b", [0x620c] = "\xe3\x4c",
  [0x620d] = "\xe3\x4d", [0x620e] = "\xe3\x4e", [0x620f] = "\xe3\x4f",
  [0x6210] = "\xe3\x50", [0x6211] = "\xe3\x51", [0x6212] = "\xe3\x52",
  [0x6213] = "\xe3\x53", [0x6214] = "\xe3\x54", [0x6215] = "\xe3\x55",
  [0x6216] = "\xe3\x56", [0x6217] = "\xe3\x57", [0x6218] = "\xe3\x58",
  [0x6219] = "\xe3\x59", [0x621a] = "\xe3\x5a", [0x621b] = "\xe3\x5b",
  [0x621c] = "\xe3\x5c", [0x621d] = "\xe3\x5d", [0x621e] = "\xe3\x5e",
  [0x621f] = "\xe3\x5f", [0x6220] = "\xe3\x60", [0x6221] = "\xe3\x61",
  [0x6222] = "\xe3\x62", [0x6223] = "\xe3\x63", [0x6224] = "\xe3\x64",
  [0x6225] = "\xe3\x65", [0x6226] = "\xe3\x66", [0x6227] = "\xe3\x67",
  [0x6228] = "\xe3\x68", [0x6229] = "\xe3\x69", [0x622a] = "\xe3\x6a",
  [0x622b] = "\xe3\x6b", [0x622c] = "\xe3\x6c", [0x622d] = "\xe3\x6d",
  [0x622e] = "\xe3\x6e", [0x622f] = "\xe3\x6f", [0x6230] = "\xe3\x70",
  [0x6231] = "\xe3\x71", [0x6232] = "\xe3\x72", [0x6233] = "\xe3\x73",
  [0x6234] = "\xe3\x74", [0x6235] = "\xe3\x75", [0x6236] = "\xe3\x76",
  [0x6237] = "\xe3\x77", [0x6238] = "\xe3\x78", [0x6239] = "\xe3\x79",
  [0x623a] = "\xe3\x7a", [0x623b] = "\xe3\x7b", [0x623c] = "\xe3\x7c",
  [0x623d] = "\xe3\x7d", [0x623e] = "\xe3\x7e", [0x6240] = "\xe3\x80",
  [0x6241] = "\xe3\x81", [0x6242] = "\xe3\x82", [0x6243] = "\xe3\x83",
  [0x6244] = "\xe3\x84", [0x6245] = "\xe3\x85", [0x6246] = "\xe3\x86",
  [0x6247] = "\xe3\x87", [0x6248] = "\xe3\x88", [0x6249] = "\xe3\x89",
  [0x624a] = "\xe3\x8a", [0x624b] = "\xe3\x8b", [0x624c] = "\xe3\x8c",
  [0x624d] = "\xe3\x8d", [0x624e] = "\xe3\x8e", [0x624f] = "\xe3\x8f",
  [0x6250] = "\xe3\x90", [0x6251] = "\xe3\x91", [0x6252] = "\xe3\x92",
  [0x6253] = "\xe3\x93", [0x6254] = "\xe3\x94", [0x6255] = "\xe3\x95",
  [0x6256] = "\xe3\x96", [0x6257] = "\xe3\x97", [0x6258] = "\xe3\x98",
  [0x6259] = "\xe3\x99", [0x625a] = "\xe3\x9a", [0x625b] = "\xe3\x9b",
  [0x625c] = "\xe3\x9c", [0x625d] = "\xe3\x9d", [0x625e] = "\xe3\x9e",
  [0x625f] = "\xe3\x9f", [0x6260] = "\xe3\xa0", [0x6261] = "\xe3\xa1",
  [0x6262] = "\xe3\xa2", [0x6263] = "\xe3\xa3", [0x6264] = "\xe3\xa4",
  [0x6265] = "\xe3\xa5", [0x6266] = "\xe3\xa6", [0x6267] = "\xe3\xa7",
  [0x6268] = "\xe3\xa8", [0x6269] = "\xe3\xa9", [0x626a] = "\xe3\xaa",
  [0x626b] = "\xe3\xab", [0x626c] = "\xe3\xac", [0x626d] = "\xe3\xad",
  [0x626e] = "\xe3\xae", [0x626f] = "\xe3\xaf", [0x6270] = "\xe3\xb0",
  [0x6271] = "\xe3\xb1", [0x6272] = "\xe3\xb2", [0x6273] = "\xe3\xb3",
  [0x6274] = "\xe3\xb4", [0x6275] = "\xe3\xb5", [0x6276] = "\xe3\xb6",
  [0x6277] = "\xe3\xb7", [0x6278] = "\xe3\xb8", [0x6279] = "\xe3\xb9",
  [0x627a] = "\xe3\xba", [0x627b] = "\xe3\xbb", [0x627c] = "\xe3\xbc",
  [0x627d] = "\xe3\xbd", [0x627e] = "\xe3\xbe", [0x627f] = "\xe3\xbf",
  [0x6280] = "\xe3\xc0", [0x6281] = "\xe3\xc1", [0x6282] = "\xe3\xc2",
  [0x6283] = "\xe3\xc3", [0x6284] = "\xe3\xc4", [0x6285] = "\xe3\xc5",
  [0x6286] = "\xe3\xc6", [0x6287] = "\xe3\xc7", [0x6288] = "\xe3\xc8",
  [0x6289] = "\xe3\xc9", [0x628a] = "\xe3\xca", [0x628b] = "\xe3\xcb",
  [0x628c] = "\xe3\xcc", [0x628d] = "\xe3\xcd", [0x628e] = "\xe3\xce",
  [0x628f] = "\xe3\xcf", [0x6290] = "\xe3\xd0", [0x6291] = "\xe3\xd1",
  [0x6292] = "\xe3\xd2", [0x6293] = "\xe3\xd3", [0x6294] = "\xe3\xd4",
  [0x6295] = "\xe3\xd5", [0x6296] = "\xe3\xd6", [0x6297] = "\xe3\xd7",
  [0x6298] = "\xe3\xd8", [0x6299] = "\xe3\xd9", [0x629a] = "\xe3\xda",
  [0x629b] = "\xe3\xdb", [0x629c] = "\xe3\xdc", [0x629d] = "\xe3\xdd",
  [0x629e] = "\xe3\xde", [0x629f] = "\xe3\xdf", [0x62a0] = "\xe3\xe0",
  [0x62a1] = "\xe3\xe1", [0x62a2] = "\xe3\xe2", [0x62a3] = "\xe3\xe3",
  [0x62a4] = "\xe3\xe4", [0x62a5] = "\xe3\xe5", [0x62a6] = "\xe3\xe6",
  [0x62a7] = "\xe3\xe7", [0x62a8] = "\xe3\xe8", [0x62a9] = "\xe3\xe9",
  [0x62aa] = "\xe3\xea", [0x62ab] = "\xe3\xeb", [0x62ac] = "\xe3\xec",
  [0x62ad] = "\xe3\xed", [0x62ae] = "\xe3\xee", [0x62af] = "\xe3\xef",
  [0x62b0] = "\xe3\xf0", [0x62b1] = "\xe3\xf1", [0x62b2] = "\xe3\xf2",
  [0x62b3] = "\xe3\xf3", [0x62b4] = "\xe3\xf4", [0x62b5] = "\xe3\xf5",
  [0x62b6] = "\xe3\xf6", [0x62b7] = "\xe3\xf7", [0x62b8] = "\xe3\xf8",
  [0x62b9] = "\xe3\xf9", [0x62ba] = "\xe3\xfa", [0x62bb] = "\xe3\xfb",
  [0x62bc] = "\xe3\xfc", [0x62bd] = "\xe3\xfd", [0x62be] = "\xe3\xfe",
  [0x6300] = "\xe4\x40", [0x6301] = "\xe4\x41", [0x6302] = "\xe4\x42",
  [0x6303] = "\xe4\x43", [0x6304] = "\xe4\x44", [0x6305] = "\xe4\x45",
  [0x6306] = "\xe4\x46", [0x6307] = "\xe4\x47", [0x6308] = "\xe4\x48",
  [0x6309] = "\xe4\x49", [0x630a] = "\xe4\x4a", [0x630b] = "\xe4\x4b",
  [0x630c] = "\xe4\x4c", [0x630d] = "\xe4\x4d", [0x630e] = "\xe4\x4e",
  [0x630f] = "\xe4\x4f", [0x6310] = "\xe4\x50", [0x6311] = "\xe4\x51",
  [0x6312] = "\xe4\x52", [0x6313] = "\xe4\x53", [0x6314] = "\xe4\x54",
  [0x6315] = "\xe4\x55", [0x6316] = "\xe4\x56", [0x6317] = "\xe4\x57",
  [0x6318] = "\xe4\x58", [0x6319] = "\xe4\x59", [0x631a] = "\xe4\x5a",
  [0x631b] = "\xe4\x5b", [0x631c] = "\xe4\x5c", [0x631d] = "\xe4\x5d",
  [0x631e] = "\xe4\x5e", [0x631f] = "\xe4\x5f", [0x6320] = "\xe4\x60",
  [0x6321] = "\xe4\x61", [0x6322] = "\xe4\x62", [0x6323] = "\xe4\x63",
  [0x6324] = "\xe4\x64", [0x6325] = "\xe4\x65", [0x6326] = "\xe4\x66",
  [0x6327] = "\xe4\x67", [0x6328] = "\xe4\x68", [0x6329] = "\xe4\x69",
  [0x632a] = "\xe4\x6a", [0x632b] = "\xe4\x6b", [0x632c] = "\xe4\x6c",
  [0x632d] = "\xe4\x6d", [0x632e] = "\xe4\x6e", [0x632f] = "\xe4\x6f",
  [0x6330] = "\xe4\x70", [0x6331] = "\xe4\x71", [0x6332] = "\xe4\x72",
  [0x6333] = "\xe4\x73", [0x6334] = "\xe4\x74", [0x6335] = "\xe4\x75",
  [0x6336] = "\xe4\x76", [0x6337] = "\xe4\x77", [0x6338] = "\xe4\x78",
  [0x6339] = "\xe4\x79", [0x633a] = "\xe4\x7a", [0x633b] = "\xe4\x7b",
  [0x633c] = "\xe4\x7c", [0x633d] = "\xe4\x7d", [0x633e] = "\xe4\x7e",
  [0x6340] = "\xe4\x80", [0x6341] = "\xe4\x81", [0x6342] = "\xe4\x82",
  [0x6343] = "\xe4\x83", [0x6344] = "\xe4\x84", [0x6345] = "\xe4\x85",
  [0x6346] = "\xe4\x86", [0x6347] = "\xe4\x87", [0x6348] = "\xe4\x88",
  [0x6349] = "\xe4\x89", [0x634a] = "\xe4\x8a", [0x634b] = "\xe4\x8b",
  [0x634c] = "\xe4\x8c", [0x634d] = "\xe4\x8d", [0x634e] = "\xe4\x8e",
  [0x634f] = "\xe4\x8f", [0x6350] = "\xe4\x90", [0x6351] = "\xe4\x91",
  [0x6352] = "\xe4\x92", [0x6353] = "\xe4\x93", [0x6354] = "\xe4\x94",
  [0x6355] = "\xe4\x95", [0x6356] = "\xe4\x96", [0x6357] = "\xe4\x97",
  [0x6358] = "\xe4\x98", [0x6359] = "\xe4\x99", [0x635a] = "\xe4\x9a",
  [0x635b] = "\xe4\x9b", [0x635c] = "\xe4\x9c", [0x635d] = "\xe4\x9d",
  [0x635e] = "\xe4\x9e", [0x635f] = "\xe4\x9f", [0x6360] = "\xe4\xa0",
  [0x6361] = "\xe4\xa1", [0x6362] = "\xe4\xa2", [0x6363] = "\xe4\xa3",
  [0x6364] = "\xe4\xa4", [0x6365] = "\xe4\xa5", [0x6366] = "\xe4\xa6",
  [0x6367] = "\xe4\xa7", [0x6368] = "\xe4\xa8", [0x6369] = "\xe4\xa9",
  [0x636a] = "\xe4\xaa", [0x636b] = "\xe4\xab", [0x636c] = "\xe4\xac",
  [0x636d] = "\xe4\xad", [0x636e] = "\xe4\xae", [0x636f] = "\xe4\xaf",
  [0x6370] = "\xe4\xb0", [0x6371] = "\xe4\xb1", [0x6372] = "\xe4\xb2",
  [0x6373] = "\xe4\xb3", [0x6374] = "\xe4\xb4", [0x6375] = "\xe4\xb5",
  [0x6376] = "\xe4\xb6", [0x6377] = "\xe4\xb7", [0x6378] = "\xe4\xb8",
  [0x6379] = "\xe4\xb9", [0x637a] = "\xe4\xba", [0x637b] = "\xe4\xbb",
  [0x637c] = "\xe4\xbc", [0x637d] = "\xe4\xbd", [0x637e] = "\xe4\xbe",
  [0x637f] = "\xe4\xbf", [0x6380] = "\xe4\xc0", [0x6381] = "\xe4\xc1",
  [0x6382] = "\xe4\xc2", [0x6383] = "\xe4\xc3", [0x6384] = "\xe4\xc4",
  [0x6385] = "\xe4\xc5", [0x6386] = "\xe4\xc6", [0x6387] = "\xe4\xc7",
  [0x6388] = "\xe4\xc8", [0x6389] = "\xe4\xc9", [0x638a] = "\xe4\xca",
  [0x638b] = "\xe4\xcb", [0x638c] = "\xe4\xcc", [0x638d] = "\xe4\xcd",
  [0x638e] = "\xe4\xce", [0x638f] = "\xe4\xcf", [0x6390] = "\xe4\xd0",
  [0x6391] = "\xe4\xd1", [0x6392] = "\xe4\xd2", [0x6393] = "\xe4\xd3",
  [0x6394] = "\xe4\xd4", [0x6395] = "\xe4\xd5", [0x6396] = "\xe4\xd6",
  [0x6397] = "\xe4\xd7", [0x6398] = "\xe4\xd8", [0x6399] = "\xe4\xd9",
  [0x639a] = "\xe4\xda", [0x639b] = "\xe4\xdb", [0x639c] = "\xe4\xdc",
  [0x639d] = "\xe4\xdd", [0x639e] = "\xe4\xde", [0x639f] = "\xe4\xdf",
  [0x63a0] = "\xe4\xe0", [0x63a1] = "\xe4\xe1", [0x63a2] = "\xe4\xe2",
  [0x63a3] = "\xe4\xe3", [0x63a4] = "\xe4\xe4", [0x63a5] = "\xe4\xe5",
  [0x63a6] = "\xe4\xe6", [0x63a7] = "\xe4\xe7", [0x63a8] = "\xe4\xe8",
  [0x63a9] = "\xe4\xe9", [0x63aa] = "\xe4\xea", [0x63ab] = "\xe4\xeb",
  [0x63ac] = "\xe4\xec", [0x63ad] = "\xe4\xed", [0x63ae] = "\xe4\xee",
  [0x63af] = "\xe4\xef", [0x63b0] = "\xe4\xf0", [0x63b1] = "\xe4\xf1",
  [0x63b2] = "\xe4\xf2", [0x63b3] = "\xe4\xf3", [0x63b4] = "\xe4\xf4",
  [0x63b5] = "\xe4\xf5", [0x63b6] = "\xe4\xf6", [0x63b7] = "\xe4\xf7",
  [0x63b8] = "\xe4\xf8", [0x63b9] = "\xe4\xf9", [0x63ba] = "\xe4\xfa",
  [0x63bb] = "\xe4\xfb", [0x63bc] = "\xe4\xfc", [0x63bd] = "\xe4\xfd",
  [0x63be] = "\xe4\xfe", [0x6400] = "\xe5\x40", [0x6401] = "\xe5\x41",
  [0x6402] = "\xe5\x42", [0x6403] = "\xe5\x43", [0x6404] = "\xe5\x44",
  [0x6405] = "\xe5\x45", [0x6406] = "\xe5\x46", [0x6407] = "\xe5\x47",
  [0x6408] = "\xe5\x48", [0x6409] = "\xe5\x49", [0x640a] = "\xe5\x4a",
  [0x640b] = "\xe5\x4b", [0x640c] = "\xe5\x4c", [0x640d] = "\xe5\x4d",
  [0x640e] = "\xe5\x4e", [0x640f] = "\xe5\x4f", [0x6410] = "\xe5\x50",
  [0x6411] = "\xe5\x51", [0x6412] = "\xe5\x52", [0x6413] = "\xe5\x53",
  [0x6414] = "\xe5\x54", [0x6415] = "\xe5\x55", [0x6416] = "\xe5\x56",
  [0x6417] = "\xe5\x57", [0x6418] = "\xe5\x58", [0x6419] = "\xe5\x59",
  [0x641a] = "\xe5\x5a", [0x641b] = "\xe5\x5b", [0x641c] = "\xe5\x5c",
  [0x641d] = "\xe5\x5d", [0x641e] = "\xe5\x5e", [0x641f] = "\xe5\x5f",
  [0x6420] = "\xe5\x60", [0x6421] = "\xe5\x61", [0x6422] = "\xe5\x62",
  [0x6423] = "\xe5\x63", [0x6424] = "\xe5\x64", [0x6425] = "\xe5\x65",
  [0x6426] = "\xe5\x66", [0x6427] = "\xe5\x67", [0x6428] = "\xe5\x68",
  [0x6429] = "\xe5\x69", [0x642a] = "\xe5\x6a", [0x642b] = "\xe5\x6b",
  [0x642c] = "\xe5\x6c", [0x642d] = "\xe5\x6d", [0x642e] = "\xe5\x6e",
  [0x642f] = "\xe5\x6f", [0x6430] = "\xe5\x70", [0x6431] = "\xe5\x71",
  [0x6432] = "\xe5\x72", [0x6433] = "\xe5\x73", [0x6434] = "\xe5\x74",
  [0x6435] = "\xe5\x75", [0x6436] = "\xe5\x76", [0x6437] = "\xe5\x77",
  [0x6438] = "\xe5\x78", [0x6439] = "\xe5\x79", [0x643a] = "\xe5\x7a",
  [0x643b] = "\xe5\x7b", [0x643c] = "\xe5\x7c", [0x643d] = "\xe5\x7d",
  [0x643e] = "\xe5\x7e", [0x6440] = "\xe5\x80", [0x6441] = "\xe5\x81",
  [0x6442] = "\xe5\x82", [0x6443] = "\xe5\x83", [0x6444] = "\xe5\x84",
  [0x6445] = "\xe5\x85", [0x6446] = "\xe5\x86", [0x6447] = "\xe5\x87",
  [0x6448] = "\xe5\x88", [0x6449] = "\xe5\x89", [0x644a] = "\xe5\x8a",
  [0x644b] = "\xe5\x8b", [0x644c] = "\xe5\x8c", [0x644d] = "\xe5\x8d",
  [0x644e] = "\xe5\x8e", [0x644f] = "\xe5\x8f", [0x6450] = "\xe5\x90",
  [0x6451] = "\xe5\x91", [0x6452] = "\xe5\x92", [0x6453] = "\xe5\x93",
  [0x6454] = "\xe5\x94", [0x6455] = "\xe5\x95", [0x6456] = "\xe5\x96",
  [0x6457] = "\xe5\x97", [0x6458] = "\xe5\x98", [0x6459] = "\xe5\x99",
  [0x645a] = "\xe5\x9a", [0x645b] = "\xe5\x9b", [0x645c] = "\xe5\x9c",
  [0x645d] = "\xe5\x9d", [0x645e] = "\xe5\x9e", [0x645f] = "\xe5\x9f",
  [0x6460] = "\xe5\xa0", [0x6461] = "\xe5\xa1", [0x6462] = "\xe5\xa2",
  [0x6463] = "\xe5\xa3", [0x6464] = "\xe5\xa4", [0x6465] = "\xe5\xa5",
  [0x6466] = "\xe5\xa6", [0x6467] = "\xe5\xa7", [0x6468] = "\xe5\xa8",
  [0x6469] = "\xe5\xa9", [0x646a] = "\xe5\xaa", [0x646b] = "\xe5\xab",
  [0x646c] = "\xe5\xac", [0x646d] = "\xe5\xad", [0x646e] = "\xe5\xae",
  [0x646f] = "\xe5\xaf", [0x6470] = "\xe5\xb0", [0x6471] = "\xe5\xb1",
  [0x6472] = "\xe5\xb2", [0x6473] = "\xe5\xb3", [0x6474] = "\xe5\xb4",
  [0x6475] = "\xe5\xb5", [0x6476] = "\xe5\xb6", [0x6477] = "\xe5\xb7",
  [0x6478] = "\xe5\xb8", [0x6479] = "\xe5\xb9", [0x647a] = "\xe5\xba",
  [0x647b] = "\xe5\xbb", [0x647c] = "\xe5\xbc", [0x647d] = "\xe5\xbd",
  [0x647e] = "\xe5\xbe", [0x647f] = "\xe5\xbf", [0x6480] = "\xe5\xc0",
  [0x6481] = "\xe5\xc1", [0x6482] = "\xe5\xc2", [0x6483] = "\xe5\xc3",
  [0x6484] = "\xe5\xc4", [0x6485] = "\xe5\xc5", [0x6486] = "\xe5\xc6",
  [0x6487] = "\xe5\xc7", [0x6488] = "\xe5\xc8", [0x6489] = "\xe5\xc9",
  [0x648a] = "\xe5\xca", [0x648b] = "\xe5\xcb", [0x648c] = "\xe5\xcc",
  [0x648d] = "\xe5\xcd", [0x648e] = "\xe5\xce", [0x648f] = "\xe5\xcf",
  [0x6490] = "\xe5\xd0", [0x6491] = "\xe5\xd1", [0x6492] = "\xe5\xd2",
  [0x6493] = "\xe5\xd3", [0x6494] = "\xe5\xd4", [0x6495] = "\xe5\xd5",
  [0x6496] = "\xe5\xd6", [0x6497] = "\xe5\xd7", [0x6498] = "\xe5\xd8",
  [0x6499] = "\xe5\xd9", [0x649a] = "\xe5\xda", [0x649b] = "\xe5\xdb",
  [0x649c] = "\xe5\xdc", [0x649d] = "\xe5\xdd", [0x649e] = "\xe5\xde",
  [0x649f] = "\xe5\xdf", [0x64a0] = "\xe5\xe0", [0x64a1] = "\xe5\xe1",
  [0x64a2] = "\xe5\xe2", [0x64a3] = "\xe5\xe3", [0x64a4] = "\xe5\xe4",
  [0x64a5] = "\xe5\xe5", [0x64a6] = "\xe5\xe6", [0x64a7] = "\xe5\xe7",
  [0x64a8] = "\xe5\xe8", [0x64a9] = "\xe5\xe9", [0x64aa] = "\xe5\xea",
  [0x64ab] = "\xe5\xeb", [0x64ac] = "\xe5\xec", [0x64ad] = "\xe5\xed",
  [0x64ae] = "\xe5\xee", [0x64af] = "\xe5\xef", [0x64b0] = "\xe5\xf0",
  [0x64b1] = "\xe5\xf1", [0x64b2] = "\xe5\xf2", [0x64b3] = "\xe5\xf3",
  [0x64b4] = "\xe5\xf4", [0x64b5] = "\xe5\xf5", [0x64b6] = "\xe5\xf6",
  [0x64b7] = "\xe5\xf7", [0x64b8] = "\xe5\xf8", [0x64b9] = "\xe5\xf9",
  [0x64ba] = "\xe5\xfa", [0x64bb] = "\xe5\xfb", [0x64bc] = "\xe5\xfc",
  [0x64bd] = "\xe5\xfd", [0x64be] = "\xe5\xfe", [0x6500] = "\xe6\x40",
  [0x6501] = "\xe6\x41", [0x6502] = "\xe6\x42", [0x6503] = "\xe6\x43",
  [0x6504] = "\xe6\x44", [0x6505] = "\xe6\x45", [0x6506] = "\xe6\x46",
  [0x6507] = "\xe6\x47", [0x6508] = "\xe6\x48", [0x6509] = "\xe6\x49",
  [0x650a] = "\xe6\x4a", [0x650b] = "\xe6\x4b", [0x650c] = "\xe6\x4c",
  [0x650d] = "\xe6\x4d", [0x650e] = "\xe6\x4e", [0x650f] = "\xe6\x4f",
  [0x6510] = "\xe6\x50", [0x6511] = "\xe6\x51", [0x6512] = "\xe6\x52",
  [0x6513] = "\xe6\x53", [0x6514] = "\xe6\x54", [0x6515] = "\xe6\x55",
  [0x6516] = "\xe6\x56", [0x6517] = "\xe6\x57", [0x6518] = "\xe6\x58",
  [0x6519] = "\xe6\x59", [0x651a] = "\xe6\x5a", [0x651b] = "\xe6\x5b",
  [0x651c] = "\xe6\x5c", [0x651d] = "\xe6\x5d", [0x651e] = "\xe6\x5e",
  [0x651f] = "\xe6\x5f", [0x6520] = "\xe6\x60", [0x6521] = "\xe6\x61",
  [0x6522] = "\xe6\x62", [0x6523] = "\xe6\x63", [0x6524] = "\xe6\x64",
  [0x6525] = "\xe6\x65", [0x6526] = "\xe6\x66", [0x6527] = "\xe6\x67",
  [0x6528] = "\xe6\x68", [0x6529] = "\xe6\x69", [0x652a] = "\xe6\x6a",
  [0x652b] = "\xe6\x6b", [0x652c] = "\xe6\x6c", [0x652d] = "\xe6\x6d",
  [0x652e] = "\xe6\x6e", [0x652f] = "\xe6\x6f", [0x6530] = "\xe6\x70",
  [0x6531] = "\xe6\x71", [0x6532] = "\xe6\x72", [0x6533] = "\xe6\x73",
  [0x6534] = "\xe6\x74", [0x6535] = "\xe6\x75", [0x6536] = "\xe6\x76",
  [0x6537] = "\xe6\x77", [0x6538] = "\xe6\x78", [0x6539] = "\xe6\x79",
  [0x653a] = "\xe6\x7a", [0x653b] = "\xe6\x7b", [0x653c] = "\xe6\x7c",
  [0x653d] = "\xe6\x7d", [0x653e] = "\xe6\x7e", [0x6540] = "\xe6\x80",
  [0x6541] = "\xe6\x81", [0x6542] = "\xe6\x82", [0x6543] = "\xe6\x83",
  [0x6544] = "\xe6\x84", [0x6545] = "\xe6\x85", [0x6546] = "\xe6\x86",
  [0x6547] = "\xe6\x87", [0x6548] = "\xe6\x88", [0x6549] = "\xe6\x89",
  [0x654a] = "\xe6\x8a", [0x654b] = "\xe6\x8b", [0x654c] = "\xe6\x8c",
  [0x654d] = "\xe6\x8d", [0x654e] = "\xe6\x8e", [0x654f] = "\xe6\x8f",
  [0x6550] = "\xe6\x90", [0x6551] = "\xe6\x91", [0x6552] = "\xe6\x92",
  [0x6553] = "\xe6\x93", [0x6554] = "\xe6\x94", [0x6555] = "\xe6\x95",
  [0x6556] = "\xe6\x96", [0x6557] = "\xe6\x97", [0x6558] = "\xe6\x98",
  [0x6559] = "\xe6\x99", [0x655a] = "\xe6\x9a", [0x655b] = "\xe6\x9b",
  [0x655c] = "\xe6\x9c", [0x655d] = "\xe6\x9d", [0x655e] = "\xe6\x9e",
  [0x655f] = "\xe6\x9f", [0x6560] = "\xe6\xa0", [0x6561] = "\xe6\xa1",
  [0x6562] = "\xe6\xa2", [0x6563] = "\xe6\xa3", [0x6564] = "\xe6\xa4",
  [0x6565] = "\xe6\xa5", [0x6566] = "\xe6\xa6", [0x6567] = "\xe6\xa7",
  [0x6568] = "\xe6\xa8", [0x6569] = "\xe6\xa9", [0x656a] = "\xe6\xaa",
  [0x656b] = "\xe6\xab", [0x656c] = "\xe6\xac", [0x656d] = "\xe6\xad",
  [0x656e] = "\xe6\xae", [0x656f] = "\xe6\xaf", [0x6570] = "\xe6\xb0",
  [0x6571] = "\xe6\xb1", [0x6572] = "\xe6\xb2", [0x6573] = "\xe6\xb3",
  [0x6574] = "\xe6\xb4", [0x6575] = "\xe6\xb5", [0x6576] = "\xe6\xb6",
  [0x6577] = "\xe6\xb7", [0x6578] = "\xe6\xb8", [0x6579] = "\xe6\xb9",
  [0x657a] = "\xe6\xba", [0x657b] = "\xe6\xbb", [0x657c] = "\xe6\xbc",
  [0x657d] = "\xe6\xbd", [0x657e] = "\xe6\xbe", [0x657f] = "\xe6\xbf",
  [0x6580] = "\xe6\xc0", [0x6581] = "\xe6\xc1", [0x6582] = "\xe6\xc2",
  [0x6583] = "\xe6\xc3", [0x6584] = "\xe6\xc4", [0x6585] = "\xe6\xc5",
  [0x6586] = "\xe6\xc6", [0x6587] = "\xe6\xc7", [0x6588] = "\xe6\xc8",
  [0x6589] = "\xe6\xc9", [0x658a] = "\xe6\xca", [0x658b] = "\xe6\xcb",
  [0x658c] = "\xe6\xcc", [0x658d] = "\xe6\xcd", [0x658e] = "\xe6\xce",
  [0x658f] = "\xe6\xcf", [0x6590] = "\xe6\xd0", [0x6591] = "\xe6\xd1",
  [0x6592] = "\xe6\xd2", [0x6593] = "\xe6\xd3", [0x6594] = "\xe6\xd4",
  [0x6595] = "\xe6\xd5", [0x6596] = "\xe6\xd6", [0x6597] = "\xe6\xd7",
  [0x6598] = "\xe6\xd8", [0x6599] = "\xe6\xd9", [0x659a] = "\xe6\xda",
  [0x659b] = "\xe6\xdb", [0x659c] = "\xe6\xdc", [0x659d] = "\xe6\xdd",
  [0x659e] = "\xe6\xde", [0x659f] = "\xe6\xdf", [0x65a0] = "\xe6\xe0",
  [0x65a1] = "\xe6\xe1", [0x65a2] = "\xe6\xe2", [0x65a3] = "\xe6\xe3",
  [0x65a4] = "\xe6\xe4", [0x65a5] = "\xe6\xe5", [0x65a6] = "\xe6\xe6",
  [0x65a7] = "\xe6\xe7", [0x65a8] = "\xe6\xe8", [0x65a9] = "\xe6\xe9",
  [0x65aa] = "\xe6\xea", [0x65ab] = "\xe6\xeb", [0x65ac] = "\xe6\xec",
  [0x65ad] = "\xe6\xed", [0x65ae] = "\xe6\xee", [0x65af] = "\xe6\xef",
  [0x65b0] = "\xe6\xf0", [0x65b1] = "\xe6\xf1", [0x65b2] = "\xe6\xf2",
  [0x65b3] = "\xe6\xf3", [0x65b4] = "\xe6\xf4", [0x65b5] = "\xe6\xf5",
  [0x65b6] = "\xe6\xf6", [0x65b7] = "\xe6\xf7", [0x65b8] = "\xe6\xf8",
  [0x65b9] = "\xe6\xf9", [0x65ba] = "\xe6\xfa", [0x65bb] = "\xe6\xfb",
  [0x65bc] = "\xe6\xfc", [0x65bd] = "\xe6\xfd", [0x65be] = "\xe6\xfe",
  [0x6600] = "\xe7\x40", [0x6601] = "\xe7\x41", [0x6602] = "\xe7\x42",
  [0x6603] = "\xe7\x43", [0x6604] = "\xe7\x44", [0x6605] = "\xe7\x45",
  [0x6606] = "\xe7\x46", [0x6607] = "\xe7\x47", [0x6608] = "\xe7\x48",
  [0x6609] = "\xe7\x49", [0x660a] = "\xe7\x4a", [0x660b] = "\xe7\x4b",
  [0x660c] = "\xe7\x4c", [0x660d] = "\xe7\x4d", [0x660e] = "\xe7\x4e",
  [0x660f] = "\xe7\x4f", [0x6610] = "\xe7\x50", [0x6611] = "\xe7\x51",
  [0x6612] = "\xe7\x52", [0x6613] = "\xe7\x53", [0x6614] = "\xe7\x54",
  [0x6615] = "\xe7\x55", [0x6616] = "\xe7\x56", [0x6617] = "\xe7\x57",
  [0x6618] = "\xe7\x58", [0x6619] = "\xe7\x59", [0x661a] = "\xe7\x5a",
  [0x661b] = "\xe7\x5b", [0x661c] = "\xe7\x5c", [0x661d] = "\xe7\x5d",
  [0x661e] = "\xe7\x5e", [0x661f] = "\xe7\x5f", [0x6620] = "\xe7\x60",
  [0x6621] = "\xe7\x61", [0x6622] = "\xe7\x62", [0x6623] = "\xe7\x63",
  [0x6624] = "\xe7\x64", [0x6625] = "\xe7\x65", [0x6626] = "\xe7\x66",
  [0x6627] = "\xe7\x67", [0x6628] = "\xe7\x68", [0x6629] = "\xe7\x69",
  [0x662a] = "\xe7\x6a", [0x662b] = "\xe7\x6b", [0x662c] = "\xe7\x6c",
  [0x662d] = "\xe7\x6d", [0x662e] = "\xe7\x6e", [0x662f] = "\xe7\x6f",
  [0x6630] = "\xe7\x70", [0x6631] = "\xe7\x71", [0x6632] = "\xe7\x72",
  [0x6633] = "\xe7\x73", [0x6634] = "\xe7\x74", [0x6635] = "\xe7\x75",
  [0x6636] = "\xe7\x76", [0x6637] = "\xe7\x77", [0x6638] = "\xe7\x78",
  [0x6639] = "\xe7\x79", [0x663a] = "\xe7\x7a", [0x663b] = "\xe7\x7b",
  [0x663c] = "\xe7\x7c", [0x663d] = "\xe7\x7d", [0x663e] = "\xe7\x7e",
  [0x6640] = "\xe7\x80", [0x6641] = "\xe7\x81", [0x6642] = "\xe7\x82",
  [0x6643] = "\xe7\x83", [0x6644] = "\xe7\x84", [0x6645] = "\xe7\x85",
  [0x6646] = "\xe7\x86", [0x6647] = "\xe7\x87", [0x6648] = "\xe7\x88",
  [0x6649] = "\xe7\x89", [0x664a] = "\xe7\x8a", [0x664b] = "\xe7\x8b",
  [0x664c] = "\xe7\x8c", [0x664d] = "\xe7\x8d", [0x664e] = "\xe7\x8e",
  [0x664f] = "\xe7\x8f", [0x6650] = "\xe7\x90", [0x6651] = "\xe7\x91",
  [0x6652] = "\xe7\x92", [0x6653] = "\xe7\x93", [0x6654] = "\xe7\x94",
  [0x6655] = "\xe7\x95", [0x6656] = "\xe7\x96", [0x6657] = "\xe7\x97",
  [0x6658] = "\xe7\x98", [0x6659] = "\xe7\x99", [0x665a] = "\xe7\x9a",
  [0x665b] = "\xe7\x9b", [0x665c] = "\xe7\x9c", [0x665d] = "\xe7\x9d",
  [0x665e] = "\xe7\x9e", [0x665f] = "\xe7\x9f", [0x6660] = "\xe7\xa0",
  [0x6661] = "\xe7\xa1", [0x6662] = "\xe7\xa2", [0x6663] = "\xe7\xa3",
  [0x6664] = "\xe7\xa4", [0x6665] = "\xe7\xa5", [0x6666] = "\xe7\xa6",
  [0x6667] = "\xe7\xa7", [0x6668] = "\xe7\xa8", [0x6669] = "\xe7\xa9",
  [0x666a] = "\xe7\xaa", [0x666b] = "\xe7\xab", [0x666c] = "\xe7\xac",
  [0x666d] = "\xe7\xad", [0x666e] = "\xe7\xae", [0x666f] = "\xe7\xaf",
  [0x6670] = "\xe7\xb0", [0x6671] = "\xe7\xb1", [0x6672] = "\xe7\xb2",
  [0x6673] = "\xe7\xb3", [0x6674] = "\xe7\xb4", [0x6675] = "\xe7\xb5",
  [0x6676] = "\xe7\xb6", [0x6677] = "\xe7\xb7", [0x6678] = "\xe7\xb8",
  [0x6679] = "\xe7\xb9", [0x667a] = "\xe7\xba", [0x667b] = "\xe7\xbb",
  [0x667c] = "\xe7\xbc", [0x667d] = "\xe7\xbd", [0x667e] = "\xe7\xbe",
  [0x667f] = "\xe7\xbf", [0x6680] = "\xe7\xc0", [0x6681] = "\xe7\xc1",
  [0x6682] = "\xe7\xc2", [0x6683] = "\xe7\xc3", [0x6684] = "\xe7\xc4",
  [0x6685] = "\xe7\xc5", [0x6686] = "\xe7\xc6", [0x6687] = "\xe7\xc7",
  [0x6688] = "\xe7\xc8", [0x6689] = "\xe7\xc9", [0x668a] = "\xe7\xca",
  [0x668b] = "\xe7\xcb", [0x668c] = "\xe7\xcc", [0x668d] = "\xe7\xcd",
  [0x668e] = "\xe7\xce", [0x668f] = "\xe7\xcf", [0x6690] = "\xe7\xd0",
  [0x6691] = "\xe7\xd1", [0x6692] = "\xe7\xd2", [0x6693] = "\xe7\xd3",
  [0x6694] = "\xe7\xd4", [0x6695] = "\xe7\xd5", [0x6696] = "\xe7\xd6",
  [0x6697] = "\xe7\xd7", [0x6698] = "\xe7\xd8", [0x6699] = "\xe7\xd9",
  [0x669a] = "\xe7\xda", [0x669b] = "\xe7\xdb", [0x669c] = "\xe7\xdc",
  [0x669d] = "\xe7\xdd", [0x669e] = "\xe7\xde", [0x669f] = "\xe7\xdf",
  [0x66a0] = "\xe7\xe0", [0x66a1] = "\xe7\xe1", [0x66a2] = "\xe7\xe2",
  [0x66a3] = "\xe7\xe3", [0x66a4] = "\xe7\xe4", [0x66a5] = "\xe7\xe5",
  [0x66a6] = "\xe7\xe6", [0x66a7] = "\xe7\xe7", [0x66a8] = "\xe7\xe8",
  [0x66a9] = "\xe7\xe9", [0x66aa] = "\xe7\xea", [0x66ab] = "\xe7\xeb",
  [0x66ac] = "\xe7\xec", [0x66ad] = "\xe7\xed", [0x66ae] = "\xe7\xee",
  [0x66af] = "\xe7\xef", [0x66b0] = "\xe7\xf0", [0x66b1] = "\xe7\xf1",
  [0x66b2] = "\xe7\xf2", [0x66b3] = "\xe7\xf3", [0x66b4] = "\xe7\xf4",
  [0x66b5] = "\xe7\xf5", [0x66b6] = "\xe7\xf6", [0x66b7] = "\xe7\xf7",
  [0x66b8] = "\xe7\xf8", [0x66b9] = "\xe7\xf9", [0x66ba] = "\xe7\xfa",
  [0x66bb] = "\xe7\xfb", [0x66bc] = "\xe7\xfc", [0x66bd] = "\xe7\xfd",
  [0x66be] = "\xe7\xfe", [0x6700] = "\xe8\x40", [0x6701] = "\xe8\x41",
  [0x6702] = "\xe8\x42", [0x6703] = "\xe8\x43", [0x6704] = "\xe8\x44",
  [0x6705] = "\xe8\x45", [0x6706] = "\xe8\x46", [0x6707] = "\xe8\x47",
  [0x6708] = "\xe8\x48", [0x6709] = "\xe8\x49", [0x670a] = "\xe8\x4a",
  [0x670b] = "\xe8\x4b", [0x670c] = "\xe8\x4c", [0x670d] = "\xe8\x4d",
  [0x670e] = "\xe8\x4e", [0x670f] = "\xe8\x4f", [0x6710] = "\xe8\x50",
  [0x6711] = "\xe8\x51", [0x6712] = "\xe8\x52", [0x6713] = "\xe8\x53",
  [0x6714] = "\xe8\x54", [0x6715] = "\xe8\x55", [0x6716] = "\xe8\x56",
  [0x6717] = "\xe8\x57", [0x6718] = "\xe8\x58", [0x6719] = "\xe8\x59",
  [0x671a] = "\xe8\x5a", [0x671b] = "\xe8\x5b", [0x671c] = "\xe8\x5c",
  [0x671d] = "\xe8\x5d", [0x671e] = "\xe8\x5e", [0x671f] = "\xe8\x5f",
  [0x6720] = "\xe8\x60", [0x6721] = "\xe8\x61", [0x6722] = "\xe8\x62",
  [0x6723] = "\xe8\x63", [0x6724] = "\xe8\x64", [0x6725] = "\xe8\x65",
  [0x6726] = "\xe8\x66", [0x6727] = "\xe8\x67", [0x6728] = "\xe8\x68",
  [0x6729] = "\xe8\x69", [0x672a] = "\xe8\x6a", [0x672b] = "\xe8\x6b",
  [0x672c] = "\xe8\x6c", [0x672d] = "\xe8\x6d", [0x672e] = "\xe8\x6e",
  [0x672f] = "\xe8\x6f", [0x6730] = "\xe8\x70", [0x6731] = "\xe8\x71",
  [0x6732] = "\xe8\x72", [0x6733] = "\xe8\x73", [0x6734] = "\xe8\x74",
  [0x6735] = "\xe8\x75", [0x6736] = "\xe8\x76", [0x6737] = "\xe8\x77",
  [0x6738] = "\xe8\x78", [0x6739] = "\xe8\x79", [0x673a] = "\xe8\x7a",
  [0x673b] = "\xe8\x7b", [0x673c] = "\xe8\x7c", [0x673d] = "\xe8\x7d",
  [0x673e] = "\xe8\x7e", [0x6740] = "\xe8\x80", [0x6741] = "\xe8\x81",
  [0x6742] = "\xe8\x82", [0x6743] = "\xe8\x83", [0x6744] = "\xe8\x84",
  [0x6745] = "\xe8\x85", [0x6746] = "\xe8\x86", [0x6747] = "\xe8\x87",
  [0x6748] = "\xe8\x88", [0x6749] = "\xe8\x89", [0x674a] = "\xe8\x8a",
  [0x674b] = "\xe8\x8b", [0x674c] = "\xe8\x8c", [0x674d] = "\xe8\x8d",
  [0x674e] = "\xe8\x8e", [0x674f] = "\xe8\x8f", [0x6750] = "\xe8\x90",
  [0x6751] = "\xe8\x91", [0x6752] = "\xe8\x92", [0x6753] = "\xe8\x93",
  [0x6754] = "\xe8\x94", [0x6755] = "\xe8\x95", [0x6756] = "\xe8\x96",
  [0x6757] = "\xe8\x97", [0x6758] = "\xe8\x98", [0x6759] = "\xe8\x99",
  [0x675a] = "\xe8\x9a", [0x675b] = "\xe8\x9b", [0x675c] = "\xe8\x9c",
  [0x675d] = "\xe8\x9d", [0x675e] = "\xe8\x9e", [0x675f] = "\xe8\x9f",
  [0x6760] = "\xe8\xa0", [0x6761] = "\xe8\xa1", [0x6762] = "\xe8\xa2",
  [0x6763] = "\xe8\xa3", [0x6764] = "\xe8\xa4", [0x6765] = "\xe8\xa5",
  [0x6766] = "\xe8\xa6", [0x6767] = "\xe8\xa7", [0x6768] = "\xe8\xa8",
  [0x6769] = "\xe8\xa9", [0x676a] = "\xe8\xaa", [0x676b] = "\xe8\xab",
  [0x676c] = "\xe8\xac", [0x676d] = "\xe8\xad", [0x676e] = "\xe8\xae",
  [0x676f] = "\xe8\xaf", [0x6770] = "\xe8\xb0", [0x6771] = "\xe8\xb1",
  [0x6772] = "\xe8\xb2", [0x6773] = "\xe8\xb3", [0x6774] = "\xe8\xb4",
  [0x6775] = "\xe8\xb5", [0x6776] = "\xe8\xb6", [0x6777] = "\xe8\xb7",
  [0x6778] = "\xe8\xb8", [0x6779] = "\xe8\xb9", [0x677a] = "\xe8\xba",
  [0x677b] = "\xe8\xbb", [0x677c] = "\xe8\xbc", [0x677d] = "\xe8\xbd",
  [0x677e] = "\xe8\xbe", [0x677f] = "\xe8\xbf", [0x6780] = "\xe8\xc0",
  [0x6781] = "\xe8\xc1", [0x6782] = "\xe8\xc2", [0x6783] = "\xe8\xc3",
  [0x6784] = "\xe8\xc4", [0x6785] = "\xe8\xc5", [0x6786] = "\xe8\xc6",
  [0x6787] = "\xe8\xc7", [0x6788] = "\xe8\xc8", [0x6789] = "\xe8\xc9",
  [0x678a] = "\xe8\xca", [0x678b] = "\xe8\xcb", [0x678c] = "\xe8\xcc",
  [0x678d] = "\xe8\xcd", [0x678e] = "\xe8\xce", [0x678f] = "\xe8\xcf",
  [0x6790] = "\xe8\xd0", [0x6791] = "\xe8\xd1", [0x6792] = "\xe8\xd2",
  [0x6793] = "\xe8\xd3", [0x6794] = "\xe8\xd4", [0x6795] = "\xe8\xd5",
  [0x6796] = "\xe8\xd6", [0x6797] = "\xe8\xd7", [0x6798] = "\xe8\xd8",
  [0x6799] = "\xe8\xd9", [0x679a] = "\xe8\xda", [0x679b] = "\xe8\xdb",
  [0x679c] = "\xe8\xdc", [0x679d] = "\xe8\xdd", [0x679e] = "\xe8\xde",
  [0x679f] = "\xe8\xdf", [0x67a0] = "\xe8\xe0", [0x67a1] = "\xe8\xe1",
  [0x67a2] = "\xe8\xe2", [0x67a3] = "\xe8\xe3", [0x67a4] = "\xe8\xe4",
  [0x67a5] = "\xe8\xe5", [0x67a6] = "\xe8\xe6", [0x67a7] = "\xe8\xe7",
  [0x67a8] = "\xe8\xe8", [0x67a9] = "\xe8\xe9", [0x67aa] = "\xe8\xea",
  [0x67ab] = "\xe8\xeb", [0x67ac] = "\xe8\xec", [0x67ad] = "\xe8\xed",
  [0x67ae] = "\xe8\xee", [0x67af] = "\xe8\xef", [0x67b0] = "\xe8\xf0",
  [0x67b1] = "\xe8\xf1", [0x67b2] = "\xe8\xf2", [0x67b3] = "\xe8\xf3",
  [0x67b4] = "\xe8\xf4", [0x67b5] = "\xe8\xf5", [0x67b6] = "\xe8\xf6",
  [0x67b7] = "\xe8\xf7", [0x67b8] = "\xe8\xf8", [0x67b9] = "\xe8\xf9",
  [0x67ba] = "\xe8\xfa", [0x67bb] = "\xe8\xfb", [0x67bc] = "\xe8\xfc",
  [0x67bd] = "\xe8\xfd", [0x67be] = "\xe8\xfe", [0x6800] = "\xe9\x40",
  [0x6801] = "\xe9\x41", [0x6802] = "\xe9\x42", [0x6803] = "\xe9\x43",
  [0x6804] = "\xe9\x44", [0x6805] = "\xe9\x45", [0x6806] = "\xe9\x46",
  [0x6807] = "\xe9\x47", [0x6808] = "\xe9\x48", [0x6809] = "\xe9\x49",
  [0x680a] = "\xe9\x4a", [0x680b] = "\xe9\x4b", [0x680c] = "\xe9\x4c",
  [0x680d] = "\xe9\x4d", [0x680e] = "\xe9\x4e", [0x680f] = "\xe9\x4f",
  [0x6810] = "\xe9\x50", [0x6811] = "\xe9\x51", [0x6812] = "\xe9\x52",
  [0x6813] = "\xe9\x53", [0x6814] = "\xe9\x54", [0x6815] = "\xe9\x55",
  [0x6816] = "\xe9\x56", [0x6817] = "\xe9\x57", [0x6818] = "\xe9\x58",
  [0x6819] = "\xe9\x59", [0x681a] = "\xe9\x5a", [0x681b] = "\xe9\x5b",
  [0x681c] = "\xe9\x5c", [0x681d] = "\xe9\x5d", [0x681e] = "\xe9\x5e",
  [0x681f] = "\xe9\x5f", [0x6820] = "\xe9\x60", [0x6821] = "\xe9\x61",
  [0x6822] = "\xe9\x62", [0x6823] = "\xe9\x63", [0x6824] = "\xe9\x64",
  [0x6825] = "\xe9\x65", [0x6826] = "\xe9\x66", [0x6827] = "\xe9\x67",
  [0x6828] = "\xe9\x68", [0x6829] = "\xe9\x69", [0x682a] = "\xe9\x6a",
  [0x682b] = "\xe9\x6b", [0x682c] = "\xe9\x6c", [0x682d] = "\xe9\x6d",
  [0x682e] = "\xe9\x6e", [0x682f] = "\xe9\x6f", [0x6830] = "\xe9\x70",
  [0x6831] = "\xe9\x71", [0x6832] = "\xe9\x72", [0x6833] = "\xe9\x73",
  [0x6834] = "\xe9\x74", [0x6835] = "\xe9\x75", [0x6836] = "\xe9\x76",
  [0x6837] = "\xe9\x77", [0x6838] = "\xe9\x78", [0x6839] = "\xe9\x79",
  [0x683a] = "\xe9\x7a", [0x683b] = "\xe9\x7b", [0x683c] = "\xe9\x7c",
  [0x683d] = "\xe9\x7d", [0x683e] = "\xe9\x7e", [0x6840] = "\xe9\x80",
  [0x6841] = "\xe9\x81", [0x6842] = "\xe9\x82", [0x6843] = "\xe9\x83",
  [0x6844] = "\xe9\x84", [0x6845] = "\xe9\x85", [0x6846] = "\xe9\x86",
  [0x6847] = "\xe9\x87", [0x6848] = "\xe9\x88", [0x6849] = "\xe9\x89",
  [0x684a] = "\xe9\x8a", [0x684b] = "\xe9\x8b", [0x684c] = "\xe9\x8c",
  [0x684d] = "\xe9\x8d", [0x684e] = "\xe9\x8e", [0x684f] = "\xe9\x8f",
  [0x6850] = "\xe9\x90", [0x6851] = "\xe9\x91", [0x6852] = "\xe9\x92",
  [0x6853] = "\xe9\x93", [0x6854] = "\xe9\x94", [0x6855] = "\xe9\x95",
  [0x6856] = "\xe9\x96", [0x6857] = "\xe9\x97", [0x6858] = "\xe9\x98",
  [0x6859] = "\xe9\x99", [0x685a] = "\xe9\x9a", [0x685b] = "\xe9\x9b",
  [0x685c] = "\xe9\x9c", [0x685d] = "\xe9\x9d", [0x685e] = "\xe9\x9e",
  [0x685f] = "\xe9\x9f", [0x6860] = "\xe9\xa0", [0x6861] = "\xe9\xa1",
  [0x6862] = "\xe9\xa2", [0x6863] = "\xe9\xa3", [0x6864] = "\xe9\xa4",
  [0x6865] = "\xe9\xa5", [0x6866] = "\xe9\xa6", [0x6867] = "\xe9\xa7",
  [0x6868] = "\xe9\xa8", [0x6869] = "\xe9\xa9", [0x686a] = "\xe9\xaa",
  [0x686b] = "\xe9\xab", [0x686c] = "\xe9\xac", [0x686d] = "\xe9\xad",
  [0x686e] = "\xe9\xae", [0x686f] = "\xe9\xaf", [0x6870] = "\xe9\xb0",
  [0x6871] = "\xe9\xb1", [0x6872] = "\xe9\xb2", [0x6873] = "\xe9\xb3",
  [0x6874] = "\xe9\xb4", [0x6875] = "\xe9\xb5", [0x6876] = "\xe9\xb6",
  [0x6877] = "\xe9\xb7", [0x6878] = "\xe9\xb8", [0x6879] = "\xe9\xb9",
  [0x687a] = "\xe9\xba", [0x687b] = "\xe9\xbb", [0x687c] = "\xe9\xbc",
  [0x687d] = "\xe9\xbd", [0x687e] = "\xe9\xbe", [0x687f] = "\xe9\xbf",
  [0x6880] = "\xe9\xc0", [0x6881] = "\xe9\xc1", [0x6882] = "\xe9\xc2",
  [0x6883] = "\xe9\xc3", [0x6884] = "\xe9\xc4", [0x6885] = "\xe9\xc5",
  [0x6886] = "\xe9\xc6", [0x6887] = "\xe9\xc7", [0x6888] = "\xe9\xc8",
  [0x6889] = "\xe9\xc9", [0x688a] = "\xe9\xca", [0x688b] = "\xe9\xcb",
  [0x688c] = "\xe9\xcc", [0x688d] = "\xe9\xcd", [0x688e] = "\xe9\xce",
  [0x688f] = "\xe9\xcf", [0x6890] = "\xe9\xd0", [0x6891] = "\xe9\xd1",
  [0x6892] = "\xe9\xd2", [0x6893] = "\xe9\xd3", [0x6894] = "\xe9\xd4",
  [0x6895] = "\xe9\xd5", [0x6896] = "\xe9\xd6", [0x6897] = "\xe9\xd7",
  [0x6898] = "\xe9\xd8", [0x6899] = "\xe9\xd9", [0x689a] = "\xe9\xda",
  [0x689b] = "\xe9\xdb", [0x689c] = "\xe9\xdc", [0x689d] = "\xe9\xdd",
  [0x689e] = "\xe9\xde", [0x689f] = "\xe9\xdf", [0x68a0] = "\xe9\xe0",
  [0x68a1] = "\xe9\xe1", [0x68a2] = "\xe9\xe2", [0x68a3] = "\xe9\xe3",
  [0x68a4] = "\xe9\xe4", [0x68a5] = "\xe9\xe5", [0x68a6] = "\xe9\xe6",
  [0x68a7] = "\xe9\xe7", [0x68a8] = "\xe9\xe8", [0x68a9] = "\xe9\xe9",
  [0x68aa] = "\xe9\xea", [0x68ab] = "\xe9\xeb", [0x68ac] = "\xe9\xec",
  [0x68ad] = "\xe9\xed", [0x68ae] = "\xe9\xee", [0x68af] = "\xe9\xef",
  [0x68b0] = "\xe9\xf0", [0x68b1] = "\xe9\xf1", [0x68b2] = "\xe9\xf2",
  [0x68b3] = "\xe9\xf3", [0x68b4] = "\xe9\xf4", [0x68b5] = "\xe9\xf5",
  [0x68b6] = "\xe9\xf6", [0x68b7] = "\xe9\xf7", [0x68b8] = "\xe9\xf8",
  [0x68b9] = "\xe9\xf9", [0x68ba] = "\xe9\xfa", [0x68bb] = "\xe9\xfb",
  [0x68bc] = "\xe9\xfc", [0x68bd] = "\xe9\xfd", [0x68be] = "\xe9\xfe",
  [0x6900] = "\xea\x40", [0x6901] = "\xea\x41", [0x6902] = "\xea\x42",
  [0x6903] = "\xea\x43", [0x6904] = "\xea\x44", [0x6905] = "\xea\x45",
  [0x6906] = "\xea\x46", [0x6907] = "\xea\x47", [0x6908] = "\xea\x48",
  [0x6909] = "\xea\x49", [0x690a] = "\xea\x4a", [0x690b] = "\xea\x4b",
  [0x690c] = "\xea\x4c", [0x690d] = "\xea\x4d", [0x690e] = "\xea\x4e",
  [0x690f] = "\xea\x4f", [0x6910] = "\xea\x50", [0x6911] = "\xea\x51",
  [0x6912] = "\xea\x52", [0x6913] = "\xea\x53", [0x6914] = "\xea\x54",
  [0x6915] = "\xea\x55", [0x6916] = "\xea\x56", [0x6917] = "\xea\x57",
  [0x6918] = "\xea\x58", [0x6919] = "\xea\x59", [0x691a] = "\xea\x5a",
  [0x691b] = "\xea\x5b", [0x691c] = "\xea\x5c", [0x691d] = "\xea\x5d",
  [0x691e] = "\xea\x5e", [0x691f] = "\xea\x5f", [0x6920] = "\xea\x60",
  [0x6921] = "\xea\x61", [0x6922] = "\xea\x62", [0x6923] = "\xea\x63",
  [0x6924] = "\xea\x64", [0x6925] = "\xea\x65", [0x6926] = "\xea\x66",
  [0x6927] = "\xea\x67", [0x6928] = "\xea\x68", [0x6929] = "\xea\x69",
  [0x692a] = "\xea\x6a", [0x692b] = "\xea\x6b", [0x692c] = "\xea\x6c",
  [0x692d] = "\xea\x6d", [0x692e] = "\xea\x6e", [0x692f] = "\xea\x6f",
  [0x6930] = "\xea\x70", [0x6931] = "\xea\x71", [0x6932] = "\xea\x72",
  [0x6933] = "\xea\x73", [0x6934] = "\xea\x74", [0x6935] = "\xea\x75",
  [0x6936] = "\xea\x76", [0x6937] = "\xea\x77", [0x6938] = "\xea\x78",
  [0x6939] = "\xea\x79", [0x693a] = "\xea\x7a", [0x693b] = "\xea\x7b",
  [0x693c] = "\xea\x7c", [0x693d] = "\xea\x7d", [0x693e] = "\xea\x7e",
  [0x6940] = "\xea\x80", [0x6941] = "\xea\x81", [0x6942] = "\xea\x82",
  [0x6943] = "\xea\x83", [0x6944] = "\xea\x84", [0x6945] = "\xea\x85",
  [0x6946] = "\xea\x86", [0x6947] = "\xea\x87", [0x6948] = "\xea\x88",
  [0x6949] = "\xea\x89", [0x694a] = "\xea\x8a", [0x694b] = "\xea\x8b",
  [0x694c] = "\xea\x8c", [0x694d] = "\xea\x8d", [0x694e] = "\xea\x8e",
  [0x694f] = "\xea\x8f", [0x6950] = "\xea\x90", [0x6951] = "\xea\x91",
  [0x6952] = "\xea\x92", [0x6953] = "\xea\x93", [0x6954] = "\xea\x94",
  [0x6955] = "\xea\x95", [0x6956] = "\xea\x96", [0x6957] = "\xea\x97",
  [0x6958] = "\xea\x98", [0x6959] = "\xea\x99", [0x695a] = "\xea\x9a",
  [0x695b] = "\xea\x9b", [0x695c] = "\xea\x9c", [0x695d] = "\xea\x9d",
  [0x695e] = "\xea\x9e", [0x695f] = "\xea\x9f", [0x6960] = "\xea\xa0",
  [0x6961] = "\xea\xa1", [0x6962] = "\xea\xa2", [0x6963] = "\xea\xa3",
  [0x6964] = "\xea\xa4", [0x6965] = "\xea\xa5", [0x6966] = "\xea\xa6",
  [0x6967] = "\xea\xa7", [0x6968] = "\xea\xa8", [0x6969] = "\xea\xa9",
  [0x696a] = "\xea\xaa", [0x696b] = "\xea\xab", [0x696c] = "\xea\xac",
  [0x696d] = "\xea\xad", [0x696e] = "\xea\xae", [0x696f] = "\xea\xaf",
  [0x6970] = "\xea\xb0", [0x6971] = "\xea\xb1", [0x6972] = "\xea\xb2",
  [0x6973] = "\xea\xb3", [0x6974] = "\xea\xb4", [0x6975] = "\xea\xb5",
  [0x6976] = "\xea\xb6", [0x6977] = "\xea\xb7", [0x6978] = "\xea\xb8",
  [0x6979] = "\xea\xb9", [0x697a] = "\xea\xba", [0x697b] = "\xea\xbb",
  [0x697c] = "\xea\xbc", [0x697d] = "\xea\xbd", [0x697e] = "\xea\xbe",
  [0x697f] = "\xea\xbf", [0x6980] = "\xea\xc0", [0x6981] = "\xea\xc1",
  [0x6982] = "\xea\xc2", [0x6983] = "\xea\xc3", [0x6984] = "\xea\xc4",
  [0x6985] = "\xea\xc5", [0x6986] = "\xea\xc6", [0x6987] = "\xea\xc7",
  [0x6988] = "\xea\xc8", [0x6989] = "\xea\xc9", [0x698a] = "\xea\xca",
  [0x698b] = "\xea\xcb", [0x698c] = "\xea\xcc", [0x698d] = "\xea\xcd",
  [0x698e] = "\xea\xce", [0x698f] = "\xea\xcf", [0x6990] = "\xea\xd0",
  [0x6991] = "\xea\xd1", [0x6992] = "\xea\xd2", [0x6993] = "\xea\xd3",
  [0x6994] = "\xea\xd4", [0x6995] = "\xea\xd5", [0x6996] = "\xea\xd6",
  [0x6997] = "\xea\xd7", [0x6998] = "\xea\xd8", [0x6999] = "\xea\xd9",
  [0x699a] = "\xea\xda", [0x699b] = "\xea\xdb", [0x699c] = "\xea\xdc",
  [0x699d] = "\xea\xdd", [0x699e] = "\xea\xde", [0x699f] = "\xea\xdf",
  [0x69a0] = "\xea\xe0", [0x69a1] = "\xea\xe1", [0x69a2] = "\xea\xe2",
  [0x69a3] = "\xea\xe3", [0x69a4] = "\xea\xe4", [0x69a5] = "\xea\xe5",
  [0x69a6] = "\xea\xe6", [0x69a7] = "\xea\xe7", [0x69a8] = "\xea\xe8",
  [0x69a9] = "\xea\xe9", [0x69aa] = "\xea\xea", [0x69ab] = "\xea\xeb",
  [0x69ac] = "\xea\xec", [0x69ad] = "\xea\xed", [0x69ae] = "\xea\xee",
  [0x69af] = "\xea\xef", [0x69b0] = "\xea\xf0", [0x69b1] = "\xea\xf1",
  [0x69b2] = "\xea\xf2", [0x69b3] = "\xea\xf3", [0x69b4] = "\xea\xf4",
  [0x69b5] = "\xea\xf5", [0x69b6] = "\xea\xf6", [0x69b7] = "\xea\xf7",
  [0x69b8] = "\xea\xf8", [0x69b9] = "\xea\xf9", [0x69ba] = "\xea\xfa",
  [0x69bb] = "\xea\xfb", [0x69bc] = "\xea\xfc", [0x69bd] = "\xea\xfd",
  [0x69be] = "\xea\xfe", [0x6a00] = "\xeb\x40", [0x6a01] = "\xeb\x41",
  [0x6a02] = "\xeb\x42", [0x6a03] = "\xeb\x43", [0x6a04] = "\xeb\x44",
  [0x6a05] = "\xeb\x45", [0x6a06] = "\xeb\x46", [0x6a07] = "\xeb\x47",
  [0x6a08] = "\xeb\x48", [0x6a09] = "\xeb\x49", [0x6a0a] = "\xeb\x4a",
  [0x6a0b] = "\xeb\x4b", [0x6a0c] = "\xeb\x4c", [0x6a0d] = "\xeb\x4d",
  [0x6a0e] = "\xeb\x4e", [0x6a0f] = "\xeb\x4f", [0x6a10] = "\xeb\x50",
  [0x6a11] = "\xeb\x51", [0x6a12] = "\xeb\x52", [0x6a13] = "\xeb\x53",
  [0x6a14] = "\xeb\x54", [0x6a15] = "\xeb\x55", [0x6a16] = "\xeb\x56",
  [0x6a17] = "\xeb\x57", [0x6a18] = "\xeb\x58", [0x6a19] = "\xeb\x59",
  [0x6a1a] = "\xeb\x5a", [0x6a1b] = "\xeb\x5b", [0x6a1c] = "\xeb\x5c",
  [0x6a1d] = "\xeb\x5d", [0x6a1e] = "\xeb\x5e", [0x6a1f] = "\xeb\x5f",
  [0x6a20] = "\xeb\x60", [0x6a21] = "\xeb\x61", [0x6a22] = "\xeb\x62",
  [0x6a23] = "\xeb\x63", [0x6a24] = "\xeb\x64", [0x6a25] = "\xeb\x65",
  [0x6a26] = "\xeb\x66", [0x6a27] = "\xeb\x67", [0x6a28] = "\xeb\x68",
  [0x6a29] = "\xeb\x69", [0x6a2a] = "\xeb\x6a", [0x6a2b] = "\xeb\x6b",
  [0x6a2c] = "\xeb\x6c", [0x6a2d] = "\xeb\x6d", [0x6a2e] = "\xeb\x6e",
  [0x6a2f] = "\xeb\x6f", [0x6a30] = "\xeb\x70", [0x6a31] = "\xeb\x71",
  [0x6a32] = "\xeb\x72", [0x6a33] = "\xeb\x73", [0x6a34] = "\xeb\x74",
  [0x6a35] = "\xeb\x75", [0x6a36] = "\xeb\x76", [0x6a37] = "\xeb\x77",
  [0x6a38] = "\xeb\x78", [0x6a39] = "\xeb\x79", [0x6a3a] = "\xeb\x7a",
  [0x6a3b] = "\xeb\x7b", [0x6a3c] = "\xeb\x7c", [0x6a3d] = "\xeb\x7d",
  [0x6a3e] = "\xeb\x7e", [0x6a40] = "\xeb\x80", [0x6a41] = "\xeb\x81",
  [0x6a42] = "\xeb\x82", [0x6a43] = "\xeb\x83", [0x6a44] = "\xeb\x84",
  [0x6a45] = "\xeb\x85", [0x6a46] = "\xeb\x86", [0x6a47] = "\xeb\x87",
  [0x6a48] = "\xeb\x88", [0x6a49] = "\xeb\x89", [0x6a4a] = "\xeb\x8a",
  [0x6a4b] = "\xeb\x8b", [0x6a4c] = "\xeb\x8c", [0x6a4d] = "\xeb\x8d",
  [0x6a4e] = "\xeb\x8e", [0x6a4f] = "\xeb\x8f", [0x6a50] = "\xeb\x90",
  [0x6a51] = "\xeb\x91", [0x6a52] = "\xeb\x92", [0x6a53] = "\xeb\x93",
  [0x6a54] = "\xeb\x94", [0x6a55] = "\xeb\x95", [0x6a56] = "\xeb\x96",
  [0x6a57] = "\xeb\x97", [0x6a58] = "\xeb\x98", [0x6a59] = "\xeb\x99",
  [0x6a5a] = "\xeb\x9a", [0x6a5b] = "\xeb\x9b", [0x6a5c] = "\xeb\x9c",
  [0x6a5d] = "\xeb\x9d", [0x6a5e] = "\xeb\x9e", [0x6a5f] = "\xeb\x9f",
  [0x6a60] = "\xeb\xa0", [0x6a61] = "\xeb\xa1", [0x6a62] = "\xeb\xa2",
  [0x6a63] = "\xeb\xa3", [0x6a64] = "\xeb\xa4", [0x6a65] = "\xeb\xa5",
  [0x6a66] = "\xeb\xa6", [0x6a67] = "\xeb\xa7", [0x6a68] = "\xeb\xa8",
  [0x6a69] = "\xeb\xa9", [0x6a6a] = "\xeb\xaa", [0x6a6b] = "\xeb\xab",
  [0x6a6c] = "\xeb\xac", [0x6a6d] = "\xeb\xad", [0x6a6e] = "\xeb\xae",
  [0x6a6f] = "\xeb\xaf", [0x6a70] = "\xeb\xb0", [0x6a71] = "\xeb\xb1",
  [0x6a72] = "\xeb\xb2", [0x6a73] = "\xeb\xb3", [0x6a74] = "\xeb\xb4",
  [0x6a75] = "\xeb\xb5", [0x6a76] = "\xeb\xb6", [0x6a77] = "\xeb\xb7",
  [0x6a78] = "\xeb\xb8", [0x6a79] = "\xeb\xb9", [0x6a7a] = "\xeb\xba",
  [0x6a7b] = "\xeb\xbb", [0x6a7c] = "\xeb\xbc", [0x6a7d] = "\xeb\xbd",
  [0x6a7e] = "\xeb\xbe", [0x6a7f] = "\xeb\xbf", [0x6a80] = "\xeb\xc0",
  [0x6a81] = "\xeb\xc1", [0x6a82] = "\xeb\xc2", [0x6a83] = "\xeb\xc3",
  [0x6a84] = "\xeb\xc4", [0x6a85] = "\xeb\xc5", [0x6a86] = "\xeb\xc6",
  [0x6a87] = "\xeb\xc7", [0x6a88] = "\xeb\xc8", [0x6a89] = "\xeb\xc9",
  [0x6a8a] = "\xeb\xca", [0x6a8b] = "\xeb\xcb", [0x6a8c] = "\xeb\xcc",
  [0x6a8d] = "\xeb\xcd", [0x6a8e] = "\xeb\xce", [0x6a8f] = "\xeb\xcf",
  [0x6a90] = "\xeb\xd0", [0x6a91] = "\xeb\xd1", [0x6a92] = "\xeb\xd2",
  [0x6a93] = "\xeb\xd3", [0x6a94] = "\xeb\xd4", [0x6a95] = "\xeb\xd5",
  [0x6a96] = "\xeb\xd6", [0x6a97] = "\xeb\xd7", [0x6a98] = "\xeb\xd8",
  [0x6a99] = "\xeb\xd9", [0x6a9a] = "\xeb\xda", [0x6a9b] = "\xeb\xdb",
  [0x6a9c] = "\xeb\xdc", [0x6a9d] = "\xeb\xdd", [0x6a9e] = "\xeb\xde",
  [0x6a9f] = "\xeb\xdf", [0x6aa0] = "\xeb\xe0", [0x6aa1] = "\xeb\xe1",
  [0x6aa2] = "\xeb\xe2", [0x6aa3] = "\xeb\xe3", [0x6aa4] = "\xeb\xe4",
  [0x6aa5] = "\xeb\xe5", [0x6aa6] = "\xeb\xe6", [0x6aa7] = "\xeb\xe7",
  [0x6aa8] = "\xeb\xe8", [0x6aa9] = "\xeb\xe9", [0x6aaa] = "\xeb\xea",
  [0x6aab] = "\xeb\xeb", [0x6aac] = "\xeb\xec", [0x6aad] = "\xeb\xed",
  [0x6aae] = "\xeb\xee", [0x6aaf] = "\xeb\xef", [0x6ab0] = "\xeb\xf0",
  [0x6ab1] = "\xeb\xf1", [0x6ab2] = "\xeb\xf2", [0x6ab3] = "\xeb\xf3",
  [0x6ab4] = "\xeb\xf4", [0x6ab5] = "\xeb\xf5", [0x6ab6] = "\xeb\xf6",
  [0x6ab7] = "\xeb\xf7", [0x6ab8] = "\xeb\xf8", [0x6ab9] = "\xeb\xf9",
  [0x6aba] = "\xeb\xfa", [0x6abb] = "\xeb\xfb", [0x6abc] = "\xeb\xfc",
  [0x6abd] = "\xeb\xfd", [0x6abe] = "\xeb\xfe", [0x6b00] = "\xec\x40",
  [0x6b01] = "\xec\x41", [0x6b02] = "\xec\x42", [0x6b03] = "\xec\x43",
  [0x6b04] = "\xec\x44", [0x6b05] = "\xec\x45", [0x6b06] = "\xec\x46",
  [0x6b07] = "\xec\x47", [0x6b08] = "\xec\x48", [0x6b09] = "\xec\x49",
  [0x6b0a] = "\xec\x4a", [0x6b0b] = "\xec\x4b", [0x6b0c] = "\xec\x4c",
  [0x6b0d] = "\xec\x4d", [0x6b0e] = "\xec\x4e", [0x6b0f] = "\xec\x4f",
  [0x6b10] = "\xec\x50", [0x6b11] = "\xec\x51", [0x6b12] = "\xec\x52",
  [0x6b13] = "\xec\x53", [0x6b14] = "\xec\x54", [0x6b15] = "\xec\x55",
  [0x6b16] = "\xec\x56", [0x6b17] = "\xec\x57", [0x6b18] = "\xec\x58",
  [0x6b19] = "\xec\x59", [0x6b1a] = "\xec\x5a", [0x6b1b] = "\xec\x5b",
  [0x6b1c] = "\xec\x5c", [0x6b1d] = "\xec\x5d", [0x6b1e] = "\xec\x5e",
  [0x6b1f] = "\xec\x5f", [0x6b20] = "\xec\x60", [0x6b21] = "\xec\x61",
  [0x6b22] = "\xec\x62", [0x6b23] = "\xec\x63", [0x6b24] = "\xec\x64",
  [0x6b25] = "\xec\x65", [0x6b26] = "\xec\x66", [0x6b27] = "\xec\x67",
  [0x6b28] = "\xec\x68", [0x6b29] = "\xec\x69", [0x6b2a] = "\xec\x6a",
  [0x6b2b] = "\xec\x6b", [0x6b2c] = "\xec\x6c", [0x6b2d] = "\xec\x6d",
  [0x6b2e] = "\xec\x6e", [0x6b2f] = "\xec\x6f", [0x6b30] = "\xec\x70",
  [0x6b31] = "\xec\x71", [0x6b32] = "\xec\x72", [0x6b33] = "\xec\x73",
  [0x6b34] = "\xec\x74", [0x6b35] = "\xec\x75", [0x6b36] = "\xec\x76",
  [0x6b37] = "\xec\x77", [0x6b38] = "\xec\x78", [0x6b39] = "\xec\x79",
  [0x6b3a] = "\xec\x7a", [0x6b3b] = "\xec\x7b", [0x6b3c] = "\xec\x7c",
  [0x6b3d] = "\xec\x7d", [0x6b3e] = "\xec\x7e", [0x6b40] = "\xec\x80",
  [0x6b41] = "\xec\x81", [0x6b42] = "\xec\x82", [0x6b43] = "\xec\x83",
  [0x6b44] = "\xec\x84", [0x6b45] = "\xec\x85", [0x6b46] = "\xec\x86",
  [0x6b47] = "\xec\x87", [0x6b48] = "\xec\x88", [0x6b49] = "\xec\x89",
  [0x6b4a] = "\xec\x8a", [0x6b4b] = "\xec\x8b", [0x6b4c] = "\xec\x8c",
  [0x6b4d] = "\xec\x8d", [0x6b4e] = "\xec\x8e", [0x6b4f] = "\xec\x8f",
  [0x6b50] = "\xec\x90", [0x6b51] = "\xec\x91", [0x6b52] = "\xec\x92",
  [0x6b53] = "\xec\x93", [0x6b54] = "\xec\x94", [0x6b55] = "\xec\x95",
  [0x6b56] = "\xec\x96", [0x6b57] = "\xec\x97", [0x6b58] = "\xec\x98",
  [0x6b59] = "\xec\x99", [0x6b5a] = "\xec\x9a", [0x6b5b] = "\xec\x9b",
  [0x6b5c] = "\xec\x9c", [0x6b5d] = "\xec\x9d", [0x6b5e] = "\xec\x9e",
  [0x6b5f] = "\xec\x9f", [0x6b60] = "\xec\xa0", [0x6b61] = "\xec\xa1",
  [0x6b62] = "\xec\xa2", [0x6b63] = "\xec\xa3", [0x6b64] = "\xec\xa4",
  [0x6b65] = "\xec\xa5", [0x6b66] = "\xec\xa6", [0x6b67] = "\xec\xa7",
  [0x6b68] = "\xec\xa8", [0x6b69] = "\xec\xa9", [0x6b6a] = "\xec\xaa",
  [0x6b6b] = "\xec\xab", [0x6b6c] = "\xec\xac", [0x6b6d] = "\xec\xad",
  [0x6b6e] = "\xec\xae", [0x6b6f] = "\xec\xaf", [0x6b70] = "\xec\xb0",
  [0x6b71] = "\xec\xb1", [0x6b72] = "\xec\xb2", [0x6b73] = "\xec\xb3",
  [0x6b74] = "\xec\xb4", [0x6b75] = "\xec\xb5", [0x6b76] = "\xec\xb6",
  [0x6b77] = "\xec\xb7", [0x6b78] = "\xec\xb8", [0x6b79] = "\xec\xb9",
  [0x6b7a] = "\xec\xba", [0x6b7b] = "\xec\xbb", [0x6b7c] = "\xec\xbc",
  [0x6b7d] = "\xec\xbd", [0x6b7e] = "\xec\xbe", [0x6b7f] = "\xec\xbf",
  [0x6b80] = "\xec\xc0", [0x6b81] = "\xec\xc1", [0x6b82] = "\xec\xc2",
  [0x6b83] = "\xec\xc3", [0x6b84] = "\xec\xc4", [0x6b85] = "\xec\xc5",
  [0x6b86] = "\xec\xc6", [0x6b87] = "\xec\xc7", [0x6b88] = "\xec\xc8",
  [0x6b89] = "\xec\xc9", [0x6b8a] = "\xec\xca", [0x6b8b] = "\xec\xcb",
  [0x6b8c] = "\xec\xcc", [0x6b8d] = "\xec\xcd", [0x6b8e] = "\xec\xce",
  [0x6b8f] = "\xec\xcf", [0x6b90] = "\xec\xd0", [0x6b91] = "\xec\xd1",
  [0x6b92] = "\xec\xd2", [0x6b93] = "\xec\xd3", [0x6b94] = "\xec\xd4",
  [0x6b95] = "\xec\xd5", [0x6b96] = "\xec\xd6", [0x6b97] = "\xec\xd7",
  [0x6b98] = "\xec\xd8", [0x6b99] = "\xec\xd9", [0x6b9a] = "\xec\xda",
  [0x6b9b] = "\xec\xdb", [0x6b9c] = "\xec\xdc", [0x6b9d] = "\xec\xdd",
  [0x6b9e] = "\xec\xde", [0x6b9f] = "\xec\xdf", [0x6ba0] = "\xec\xe0",
  [0x6ba1] = "\xec\xe1", [0x6ba2] = "\xec\xe2", [0x6ba3] = "\xec\xe3",
  [0x6ba4] = "\xec\xe4", [0x6ba5] = "\xec\xe5", [0x6ba6] = "\xec\xe6",
  [0x6ba7] = "\xec\xe7", [0x6ba8] = "\xec\xe8", [0x6ba9] = "\xec\xe9",
  [0x6baa] = "\xec\xea", [0x6bab] = "\xec\xeb", [0x6bac] = "\xec\xec",
  [0x6bad] = "\xec\xed", [0x6bae] = "\xec\xee", [0x6baf] = "\xec\xef",
  [0x6bb0] = "\xec\xf0", [0x6bb1] = "\xec\xf1", [0x6bb2] = "\xec\xf2",
  [0x6bb3] = "\xec\xf3", [0x6bb4] = "\xec\xf4", [0x6bb5] = "\xec\xf5",
  [0x6bb6] = "\xec\xf6", [0x6bb7] = "\xec\xf7", [0x6bb8] = "\xec\xf8",
  [0x6bb9] = "\xec\xf9", [0x6bba] = "\xec\xfa", [0x6bbb] = "\xec\xfb",
  [0x6bbc] = "\xec\xfc", [0x6bbd] = "\xec\xfd", [0x6bbe] = "\xec\xfe",
  [0x6c00] = "\xed\x40", [0x6c01] = "\xed\x41", [0x6c02] = "\xed\x42",
  [0x6c03] = "\xed\x43", [0x6c04] = "\xed\x44", [0x6c05] = "\xed\x45",
  [0x6c06] = "\xed\x46", [0x6c07] = "\xed\x47", [0x6c08] = "\xed\x48",
  [0x6c09] = "\xed\x49", [0x6c0a] = "\xed\x4a", [0x6c0b] = "\xed\x4b",
  [0x6c0c] = "\xed\x4c", [0x6c0d] = "\xed\x4d", [0x6c0e] = "\xed\x4e",
  [0x6c0f] = "\xed\x4f", [0x6c10] = "\xed\x50", [0x6c11] = "\xed\x51",
  [0x6c12] = "\xed\x52", [0x6c13] = "\xed\x53", [0x6c14] = "\xed\x54",
  [0x6c15] = "\xed\x55", [0x6c16] = "\xed\x56", [0x6c17] = "\xed\x57",
  [0x6c18] = "\xed\x58", [0x6c19] = "\xed\x59", [0x6c1a] = "\xed\x5a",
  [0x6c1b] = "\xed\x5b", [0x6c1c] = "\xed\x5c", [0x6c1d] = "\xed\x5d",
  [0x6c1e] = "\xed\x5e", [0x6c1f] = "\xed\x5f", [0x6c20] = "\xed\x60",
  [0x6c21] = "\xed\x61", [0x6c22] = "\xed\x62", [0x6c23] = "\xed\x63",
  [0x6c24] = "\xed\x64", [0x6c25] = "\xed\x65", [0x6c26] = "\xed\x66",
  [0x6c27] = "\xed\x67", [0x6c28] = "\xed\x68", [0x6c29] = "\xed\x69",
  [0x6c2a] = "\xed\x6a", [0x6c2b] = "\xed\x6b", [0x6c2c] = "\xed\x6c",
  [0x6c2d] = "\xed\x6d", [0x6c2e] = "\xed\x6e", [0x6c2f] = "\xed\x6f",
  [0x6c30] = "\xed\x70", [0x6c31] = "\xed\x71", [0x6c32] = "\xed\x72",
  [0x6c33] = "\xed\x73", [0x6c34] = "\xed\x74", [0x6c35] = "\xed\x75",
  [0x6c36] = "\xed\x76", [0x6c37] = "\xed\x77", [0x6c38] = "\xed\x78",
  [0x6c39] = "\xed\x79", [0x6c3a] = "\xed\x7a", [0x6c3b] = "\xed\x7b",
  [0x6c3c] = "\xed\x7c", [0x6c3d] = "\xed\x7d", [0x6c3e] = "\xed\x7e",
  [0x6c40] = "\xed\x80", [0x6c41] = "\xed\x81", [0x6c42] = "\xed\x82",
  [0x6c43] = "\xed\x83", [0x6c44] = "\xed\x84", [0x6c45] = "\xed\x85",
  [0x6c46] = "\xed\x86", [0x6c47] = "\xed\x87", [0x6c48] = "\xed\x88",
  [0x6c49] = "\xed\x89", [0x6c4a] = "\xed\x8a", [0x6c4b] = "\xed\x8b",
  [0x6c4c] = "\xed\x8c", [0x6c4d] = "\xed\x8d", [0x6c4e] = "\xed\x8e",
  [0x6c4f] = "\xed\x8f", [0x6c50] = "\xed\x90", [0x6c51] = "\xed\x91",
  [0x6c52] = "\xed\x92", [0x6c53] = "\xed\x93", [0x6c54] = "\xed\x94",
  [0x6c55] = "\xed\x95", [0x6c56] = "\xed\x96", [0x6c57] = "\xed\x97",
  [0x6c58] = "\xed\x98", [0x6c59] = "\xed\x99", [0x6c5a] = "\xed\x9a",
  [0x6c5b] = "\xed\x9b", [0x6c5c] = "\xed\x9c", [0x6c5d] = "\xed\x9d",
  [0x6c5e] = "\xed\x9e", [0x6c5f] = "\xed\x9f", [0x6c60] = "\xed\xa0",
  [0x6c61] = "\xed\xa1", [0x6c62] = "\xed\xa2", [0x6c63] = "\xed\xa3",
  [0x6c64] = "\xed\xa4", [0x6c65] = "\xed\xa5", [0x6c66] = "\xed\xa6",
  [0x6c67] = "\xed\xa7", [0x6c68] = "\xed\xa8", [0x6c69] = "\xed\xa9",
  [0x6c6a] = "\xed\xaa", [0x6c6b] = "\xed\xab", [0x6c6c] = "\xed\xac",
  [0x6c6d] = "\xed\xad", [0x6c6e] = "\xed\xae", [0x6c6f] = "\xed\xaf",
  [0x6c70] = "\xed\xb0", [0x6c71] = "\xed\xb1", [0x6c72] = "\xed\xb2",
  [0x6c73] = "\xed\xb3", [0x6c74] = "\xed\xb4", [0x6c75] = "\xed\xb5",
  [0x6c76] = "\xed\xb6", [0x6c77] = "\xed\xb7", [0x6c78] = "\xed\xb8",
  [0x6c79] = "\xed\xb9", [0x6c7a] = "\xed\xba", [0x6c7b] = "\xed\xbb",
  [0x6c7c] = "\xed\xbc", [0x6c7d] = "\xed\xbd", [0x6c7e] = "\xed\xbe",
  [0x6c7f] = "\xed\xbf", [0x6c80] = "\xed\xc0", [0x6c81] = "\xed\xc1",
  [0x6c82] = "\xed\xc2", [0x6c83] = "\xed\xc3", [0x6c84] = "\xed\xc4",
  [0x6c85] = "\xed\xc5", [0x6c86] = "\xed\xc6", [0x6c87] = "\xed\xc7",
  [0x6c88] = "\xed\xc8", [0x6c89] = "\xed\xc9", [0x6c8a] = "\xed\xca",
  [0x6c8b] = "\xed\xcb", [0x6c8c] = "\xed\xcc", [0x6c8d] = "\xed\xcd",
  [0x6c8e] = "\xed\xce", [0x6c8f] = "\xed\xcf", [0x6c90] = "\xed\xd0",
  [0x6c91] = "\xed\xd1", [0x6c92] = "\xed\xd2", [0x6c93] = "\xed\xd3",
  [0x6c94] = "\xed\xd4", [0x6c95] = "\xed\xd5", [0x6c96] = "\xed\xd6",
  [0x6c97] = "\xed\xd7", [0x6c98] = "\xed\xd8", [0x6c99] = "\xed\xd9",
  [0x6c9a] = "\xed\xda", [0x6c9b] = "\xed\xdb", [0x6c9c] = "\xed\xdc",
  [0x6c9d] = "\xed\xdd", [0x6c9e] = "\xed\xde", [0x6c9f] = "\xed\xdf",
  [0x6ca0] = "\xed\xe0", [0x6ca1] = "\xed\xe1", [0x6ca2] = "\xed\xe2",
  [0x6ca3] = "\xed\xe3", [0x6ca4] = "\xed\xe4", [0x6ca5] = "\xed\xe5",
  [0x6ca6] = "\xed\xe6", [0x6ca7] = "\xed\xe7", [0x6ca8] = "\xed\xe8",
  [0x6ca9] = "\xed\xe9", [0x6caa] = "\xed\xea", [0x6cab] = "\xed\xeb",
  [0x6cac] = "\xed\xec", [0x6cad] = "\xed\xed", [0x6cae] = "\xed\xee",
  [0x6caf] = "\xed\xef", [0x6cb0] = "\xed\xf0", [0x6cb1] = "\xed\xf1",
  [0x6cb2] = "\xed\xf2", [0x6cb3] = "\xed\xf3", [0x6cb4] = "\xed\xf4",
  [0x6cb5] = "\xed\xf5", [0x6cb6] = "\xed\xf6", [0x6cb7] = "\xed\xf7",
  [0x6cb8] = "\xed\xf8", [0x6cb9] = "\xed\xf9", [0x6cba] = "\xed\xfa",
  [0x6cbb] = "\xed\xfb", [0x6cbc] = "\xed\xfc", [0x6cbd] = "\xed\xfd",
  [0x6cbe] = "\xed\xfe", [0x6d00] = "\xee\x40", [0x6d01] = "\xee\x41",
  [0x6d02] = "\xee\x42", [0x6d03] = "\xee\x43", [0x6d04] = "\xee\x44",
  [0x6d05] = "\xee\x45", [0x6d06] = "\xee\x46", [0x6d07] = "\xee\x47",
  [0x6d08] = "\xee\x48", [0x6d09] = "\xee\x49", [0x6d0a] = "\xee\x4a",
  [0x6d0b] = "\xee\x4b", [0x6d0c] = "\xee\x4c", [0x6d0d] = "\xee\x4d",
  [0x6d0e] = "\xee\x4e", [0x6d0f] = "\xee\x4f", [0x6d10] = "\xee\x50",
  [0x6d11] = "\xee\x51", [0x6d12] = "\xee\x52", [0x6d13] = "\xee\x53",
  [0x6d14] = "\xee\x54", [0x6d15] = "\xee\x55", [0x6d16] = "\xee\x56",
  [0x6d17] = "\xee\x57", [0x6d18] = "\xee\x58", [0x6d19] = "\xee\x59",
  [0x6d1a] = "\xee\x5a", [0x6d1b] = "\xee\x5b", [0x6d1c] = "\xee\x5c",
  [0x6d1d] = "\xee\x5d", [0x6d1e] = "\xee\x5e", [0x6d1f] = "\xee\x5f",
  [0x6d20] = "\xee\x60", [0x6d21] = "\xee\x61", [0x6d22] = "\xee\x62",
  [0x6d23] = "\xee\x63", [0x6d24] = "\xee\x64", [0x6d25] = "\xee\x65",
  [0x6d26] = "\xee\x66", [0x6d27] = "\xee\x67", [0x6d28] = "\xee\x68",
  [0x6d29] = "\xee\x69", [0x6d2a] = "\xee\x6a", [0x6d2b] = "\xee\x6b",
  [0x6d2c] = "\xee\x6c", [0x6d2d] = "\xee\x6d", [0x6d2e] = "\xee\x6e",
  [0x6d2f] = "\xee\x6f", [0x6d30] = "\xee\x70", [0x6d31] = "\xee\x71",
  [0x6d32] = "\xee\x72", [0x6d33] = "\xee\x73", [0x6d34] = "\xee\x74",
  [0x6d35] = "\xee\x75", [0x6d36] = "\xee\x76", [0x6d37] = "\xee\x77",
  [0x6d38] = "\xee\x78", [0x6d39] = "\xee\x79", [0x6d3a] = "\xee\x7a",
  [0x6d3b] = "\xee\x7b", [0x6d3c] = "\xee\x7c", [0x6d3d] = "\xee\x7d",
  [0x6d3e] = "\xee\x7e", [0x6d40] = "\xee\x80", [0x6d41] = "\xee\x81",
  [0x6d42] = "\xee\x82", [0x6d43] = "\xee\x83", [0x6d44] = "\xee\x84",
  [0x6d45] = "\xee\x85", [0x6d46] = "\xee\x86", [0x6d47] = "\xee\x87",
  [0x6d48] = "\xee\x88", [0x6d49] = "\xee\x89", [0x6d4a] = "\xee\x8a",
  [0x6d4b] = "\xee\x8b", [0x6d4c] = "\xee\x8c", [0x6d4d] = "\xee\x8d",
  [0x6d4e] = "\xee\x8e", [0x6d4f] = "\xee\x8f", [0x6d50] = "\xee\x90",
  [0x6d51] = "\xee\x91", [0x6d52] = "\xee\x92", [0x6d53] = "\xee\x93",
  [0x6d54] = "\xee\x94", [0x6d55] = "\xee\x95", [0x6d56] = "\xee\x96",
  [0x6d57] = "\xee\x97", [0x6d58] = "\xee\x98", [0x6d59] = "\xee\x99",
  [0x6d5a] = "\xee\x9a", [0x6d5b] = "\xee\x9b", [0x6d5c] = "\xee\x9c",
  [0x6d5d] = "\xee\x9d", [0x6d5e] = "\xee\x9e", [0x6d5f] = "\xee\x9f",
  [0x6d60] = "\xee\xa0", [0x6d61] = "\xee\xa1", [0x6d62] = "\xee\xa2",
  [0x6d63] = "\xee\xa3", [0x6d64] = "\xee\xa4", [0x6d65] = "\xee\xa5",
  [0x6d66] = "\xee\xa6", [0x6d67] = "\xee\xa7", [0x6d68] = "\xee\xa8",
  [0x6d69] = "\xee\xa9", [0x6d6a] = "\xee\xaa", [0x6d6b] = "\xee\xab",
  [0x6d6c] = "\xee\xac", [0x6d6d] = "\xee\xad", [0x6d6e] = "\xee\xae",
  [0x6d6f] = "\xee\xaf", [0x6d70] = "\xee\xb0", [0x6d71] = "\xee\xb1",
  [0x6d72] = "\xee\xb2", [0x6d73] = "\xee\xb3", [0x6d74] = "\xee\xb4",
  [0x6d75] = "\xee\xb5", [0x6d76] = "\xee\xb6", [0x6d77] = "\xee\xb7",
  [0x6d78] = "\xee\xb8", [0x6d79] = "\xee\xb9", [0x6d7a] = "\xee\xba",
  [0x6d7b] = "\xee\xbb", [0x6d7c] = "\xee\xbc", [0x6d7d] = "\xee\xbd",
  [0x6d7e] = "\xee\xbe", [0x6d7f] = "\xee\xbf", [0x6d80] = "\xee\xc0",
  [0x6d81] = "\xee\xc1", [0x6d82] = "\xee\xc2", [0x6d83] = "\xee\xc3",
  [0x6d84] = "\xee\xc4", [0x6d85] = "\xee\xc5", [0x6d86] = "\xee\xc6",
  [0x6d87] = "\xee\xc7", [0x6d88] = "\xee\xc8", [0x6d89] = "\xee\xc9",
  [0x6d8a] = "\xee\xca", [0x6d8b] = "\xee\xcb", [0x6d8c] = "\xee\xcc",
  [0x6d8d] = "\xee\xcd", [0x6d8e] = "\xee\xce", [0x6d8f] = "\xee\xcf",
  [0x6d90] = "\xee\xd0", [0x6d91] = "\xee\xd1", [0x6d92] = "\xee\xd2",
  [0x6d93] = "\xee\xd3", [0x6d94] = "\xee\xd4", [0x6d95] = "\xee\xd5",
  [0x6d96] = "\xee\xd6", [0x6d97] = "\xee\xd7", [0x6d98] = "\xee\xd8",
  [0x6d99] = "\xee\xd9", [0x6d9a] = "\xee\xda", [0x6d9b] = "\xee\xdb",
  [0x6d9c] = "\xee\xdc", [0x6d9d] = "\xee\xdd", [0x6d9e] = "\xee\xde",
  [0x6d9f] = "\xee\xdf", [0x6da0] = "\xee\xe0", [0x6da1] = "\xee\xe1",
  [0x6da2] = "\xee\xe2", [0x6da3] = "\xee\xe3", [0x6da4] = "\xee\xe4",
  [0x6da5] = "\xee\xe5", [0x6da6] = "\xee\xe6", [0x6da7] = "\xee\xe7",
  [0x6da8] = "\xee\xe8", [0x6da9] = "\xee\xe9", [0x6daa] = "\xee\xea",
  [0x6dab] = "\xee\xeb", [0x6dac] = "\xee\xec", [0x6dad] = "\xee\xed",
  [0x6dae] = "\xee\xee", [0x6daf] = "\xee\xef", [0x6db0] = "\xee\xf0",
  [0x6db1] = "\xee\xf1", [0x6db2] = "\xee\xf2", [0x6db3] = "\xee\xf3",
  [0x6db4] = "\xee\xf4", [0x6db5] = "\xee\xf5", [0x6db6] = "\xee\xf6",
  [0x6db7] = "\xee\xf7", [0x6db8] = "\xee\xf8", [0x6db9] = "\xee\xf9",
  [0x6dba] = "\xee\xfa", [0x6dbb] = "\xee\xfb", [0x6dbc] = "\xee\xfc",
  [0x6dbd] = "\xee\xfd", [0x6dbe] = "\xee\xfe", [0x6e00] = "\xef\x40",
  [0x6e01] = "\xef\x41", [0x6e02] = "\xef\x42", [0x6e03] = "\xef\x43",
  [0x6e04] = "\xef\x44", [0x6e05] = "\xef\x45", [0x6e06] = "\xef\x46",
  [0x6e07] = "\xef\x47", [0x6e08] = "\xef\x48", [0x6e09] = "\xef\x49",
  [0x6e0a] = "\xef\x4a", [0x6e0b] = "\xef\x4b", [0x6e0c] = "\xef\x4c",
  [0x6e0d] = "\xef\x4d", [0x6e0e] = "\xef\x4e", [0x6e0f] = "\xef\x4f",
  [0x6e10] = "\xef\x50", [0x6e11] = "\xef\x51", [0x6e12] = "\xef\x52",
  [0x6e13] = "\xef\x53", [0x6e14] = "\xef\x54", [0x6e15] = "\xef\x55",
  [0x6e16] = "\xef\x56", [0x6e17] = "\xef\x57", [0x6e18] = "\xef\x58",
  [0x6e19] = "\xef\x59", [0x6e1a] = "\xef\x5a", [0x6e1b] = "\xef\x5b",
  [0x6e1c] = "\xef\x5c", [0x6e1d] = "\xef\x5d", [0x6e1e] = "\xef\x5e",
  [0x6e1f] = "\xef\x5f", [0x6e20] = "\xef\x60", [0x6e21] = "\xef\x61",
  [0x6e22] = "\xef\x62", [0x6e23] = "\xef\x63", [0x6e24] = "\xef\x64",
  [0x6e25] = "\xef\x65", [0x6e26] = "\xef\x66", [0x6e27] = "\xef\x67",
  [0x6e28] = "\xef\x68", [0x6e29] = "\xef\x69", [0x6e2a] = "\xef\x6a",
  [0x6e2b] = "\xef\x6b", [0x6e2c] = "\xef\x6c", [0x6e2d] = "\xef\x6d",
  [0x6e2e] = "\xef\x6e", [0x6e2f] = "\xef\x6f", [0x6e30] = "\xef\x70",
  [0x6e31] = "\xef\x71", [0x6e32] = "\xef\x72", [0x6e33] = "\xef\x73",
  [0x6e34] = "\xef\x74", [0x6e35] = "\xef\x75", [0x6e36] = "\xef\x76",
  [0x6e37] = "\xef\x77", [0x6e38] = "\xef\x78", [0x6e39] = "\xef\x79",
  [0x6e3a] = "\xef\x7a", [0x6e3b] = "\xef\x7b", [0x6e3c] = "\xef\x7c",
  [0x6e3d] = "\xef\x7d", [0x6e3e] = "\xef\x7e", [0x6e40] = "\xef\x80",
  [0x6e41] = "\xef\x81", [0x6e42] = "\xef\x82", [0x6e43] = "\xef\x83",
  [0x6e44] = "\xef\x84", [0x6e45] = "\xef\x85", [0x6e46] = "\xef\x86",
  [0x6e47] = "\xef\x87", [0x6e48] = "\xef\x88", [0x6e49] = "\xef\x89",
  [0x6e4a] = "\xef\x8a", [0x6e4b] = "\xef\x8b", [0x6e4c] = "\xef\x8c",
  [0x6e4d] = "\xef\x8d", [0x6e4e] = "\xef\x8e", [0x6e4f] = "\xef\x8f",
  [0x6e50] = "\xef\x90", [0x6e51] = "\xef\x91", [0x6e52] = "\xef\x92",
  [0x6e53] = "\xef\x93", [0x6e54] = "\xef\x94", [0x6e55] = "\xef\x95",
  [0x6e56] = "\xef\x96", [0x6e57] = "\xef\x97", [0x6e58] = "\xef\x98",
  [0x6e59] = "\xef\x99", [0x6e5a] = "\xef\x9a", [0x6e5b] = "\xef\x9b",
  [0x6e5c] = "\xef\x9c", [0x6e5d] = "\xef\x9d", [0x6e5e] = "\xef\x9e",
  [0x6e5f] = "\xef\x9f", [0x6e60] = "\xef\xa0", [0x6e61] = "\xef\xa1",
  [0x6e62] = "\xef\xa2", [0x6e63] = "\xef\xa3", [0x6e64] = "\xef\xa4",
  [0x6e65] = "\xef\xa5", [0x6e66] = "\xef\xa6", [0x6e67] = "\xef\xa7",
  [0x6e68] = "\xef\xa8", [0x6e69] = "\xef\xa9", [0x6e6a] = "\xef\xaa",
  [0x6e6b] = "\xef\xab", [0x6e6c] = "\xef\xac", [0x6e6d] = "\xef\xad",
  [0x6e6e] = "\xef\xae", [0x6e6f] = "\xef\xaf", [0x6e70] = "\xef\xb0",
  [0x6e71] = "\xef\xb1", [0x6e72] = "\xef\xb2", [0x6e73] = "\xef\xb3",
  [0x6e74] = "\xef\xb4", [0x6e75] = "\xef\xb5", [0x6e76] = "\xef\xb6",
  [0x6e77] = "\xef\xb7", [0x6e78] = "\xef\xb8", [0x6e79] = "\xef\xb9",
  [0x6e7a] = "\xef\xba", [0x6e7b] = "\xef\xbb", [0x6e7c] = "\xef\xbc",
  [0x6e7d] = "\xef\xbd", [0x6e7e] = "\xef\xbe", [0x6e7f] = "\xef\xbf",
  [0x6e80] = "\xef\xc0", [0x6e81] = "\xef\xc1", [0x6e82] = "\xef\xc2",
  [0x6e83] = "\xef\xc3", [0x6e84] = "\xef\xc4", [0x6e85] = "\xef\xc5",
  [0x6e86] = "\xef\xc6", [0x6e87] = "\xef\xc7", [0x6e88] = "\xef\xc8",
  [0x6e89] = "\xef\xc9", [0x6e8a] = "\xef\xca", [0x6e8b] = "\xef\xcb",
  [0x6e8c] = "\xef\xcc", [0x6e8d] = "\xef\xcd", [0x6e8e] = "\xef\xce",
  [0x6e8f] = "\xef\xcf", [0x6e90] = "\xef\xd0", [0x6e91] = "\xef\xd1",
  [0x6e92] = "\xef\xd2", [0x6e93] = "\xef\xd3", [0x6e94] = "\xef\xd4",
  [0x6e95] = "\xef\xd5", [0x6e96] = "\xef\xd6", [0x6e97] = "\xef\xd7",
  [0x6e98] = "\xef\xd8", [0x6e99] = "\xef\xd9", [0x6e9a] = "\xef\xda",
  [0x6e9b] = "\xef\xdb", [0x6e9c] = "\xef\xdc", [0x6e9d] = "\xef\xdd",
  [0x6e9e] = "\xef\xde", [0x6e9f] = "\xef\xdf", [0x6ea0] = "\xef\xe0",
  [0x6ea1] = "\xef\xe1", [0x6ea2] = "\xef\xe2", [0x6ea3] = "\xef\xe3",
  [0x6ea4] = "\xef\xe4", [0x6ea5] = "\xef\xe5", [0x6ea6] = "\xef\xe6",
  [0x6ea7] = "\xef\xe7", [0x6ea8] = "\xef\xe8", [0x6ea9] = "\xef\xe9",
  [0x6eaa] = "\xef\xea", [0x6eab] = "\xef\xeb", [0x6eac] = "\xef\xec",
  [0x6ead] = "\xef\xed", [0x6eae] = "\xef\xee", [0x6eaf] = "\xef\xef",
  [0x6eb0] = "\xef\xf0", [0x6eb1] = "\xef\xf1", [0x6eb2] = "\xef\xf2",
  [0x6eb3] = "\xef\xf3", [0x6eb4] = "\xef\xf4", [0x6eb5] = "\xef\xf5",
  [0x6eb6] = "\xef\xf6", [0x6eb7] = "\xef\xf7", [0x6eb8] = "\xef\xf8",
  [0x6eb9] = "\xef\xf9", [0x6eba] = "\xef\xfa", [0x6ebb] = "\xef\xfb",
  [0x6ebc] = "\xef\xfc", [0x6ebd] = "\xef\xfd", [0x6ebe] = "\xef\xfe",
  [0x6f00] = "\xf0\x40", [0x6f01] = "\xf0\x41", [0x6f02] = "\xf0\x42",
  [0x6f03] = "\xf0\x43", [0x6f04] = "\xf0\x44", [0x6f05] = "\xf0\x45",
  [0x6f06] = "\xf0\x46", [0x6f07] = "\xf0\x47", [0x6f08] = "\xf0\x48",
  [0x6f09] = "\xf0\x49", [0x6f0a] = "\xf0\x4a", [0x6f0b] = "\xf0\x4b",
  [0x6f0c] = "\xf0\x4c", [0x6f0d] = "\xf0\x4d", [0x6f0e] = "\xf0\x4e",
  [0x6f0f] = "\xf0\x4f", [0x6f10] = "\xf0\x50", [0x6f11] = "\xf0\x51",
  [0x6f12] = "\xf0\x52", [0x6f13] = "\xf0\x53", [0x6f14] = "\xf0\x54",
  [0x6f15] = "\xf0\x55", [0x6f16] = "\xf0\x56", [0x6f17] = "\xf0\x57",
  [0x6f18] = "\xf0\x58", [0x6f19] = "\xf0\x59", [0x6f1a] = "\xf0\x5a",
  [0x6f1b] = "\xf0\x5b", [0x6f1c] = "\xf0\x5c", [0x6f1d] = "\xf0\x5d",
  [0x6f1e] = "\xf0\x5e", [0x6f1f] = "\xf0\x5f", [0x6f20] = "\xf0\x60",
  [0x6f21] = "\xf0\x61", [0x6f22] = "\xf0\x62", [0x6f23] = "\xf0\x63",
  [0x6f24] = "\xf0\x64", [0x6f25] = "\xf0\x65", [0x6f26] = "\xf0\x66",
  [0x6f27] = "\xf0\x67", [0x6f28] = "\xf0\x68", [0x6f29] = "\xf0\x69",
  [0x6f2a] = "\xf0\x6a", [0x6f2b] = "\xf0\x6b", [0x6f2c] = "\xf0\x6c",
  [0x6f2d] = "\xf0\x6d", [0x6f2e] = "\xf0\x6e", [0x6f2f] = "\xf0\x6f",
  [0x6f30] = "\xf0\x70", [0x6f31] = "\xf0\x71", [0x6f32] = "\xf0\x72",
  [0x6f33] = "\xf0\x73", [0x6f34] = "\xf0\x74", [0x6f35] = "\xf0\x75",
  [0x6f36] = "\xf0\x76", [0x6f37] = "\xf0\x77", [0x6f38] = "\xf0\x78",
  [0x6f39] = "\xf0\x79", [0x6f3a] = "\xf0\x7a", [0x6f3b] = "\xf0\x7b",
  [0x6f3c] = "\xf0\x7c", [0x6f3d] = "\xf0\x7d", [0x6f3e] = "\xf0\x7e",
  [0x6f40] = "\xf0\x80", [0x6f41] = "\xf0\x81", [0x6f42] = "\xf0\x82",
  [0x6f43] = "\xf0\x83", [0x6f44] = "\xf0\x84", [0x6f45] = "\xf0\x85",
  [0x6f46] = "\xf0\x86", [0x6f47] = "\xf0\x87", [0x6f48] = "\xf0\x88",
  [0x6f49] = "\xf0\x89", [0x6f4a] = "\xf0\x8a", [0x6f4b] = "\xf0\x8b",
  [0x6f4c] = "\xf0\x8c", [0x6f4d] = "\xf0\x8d", [0x6f4e] = "\xf0\x8e",
  [0x6f4f] = "\xf0\x8f", [0x6f50] = "\xf0\x90", [0x6f51] = "\xf0\x91",
  [0x6f52] = "\xf0\x92", [0x6f53] = "\xf0\x93", [0x6f54] = "\xf0\x94",
  [0x6f55] = "\xf0\x95", [0x6f56] = "\xf0\x96", [0x6f57] = "\xf0\x97",
  [0x6f58] = "\xf0\x98", [0x6f59] = "\xf0\x99", [0x6f5a] = "\xf0\x9a",
  [0x6f5b] = "\xf0\x9b", [0x6f5c] = "\xf0\x9c", [0x6f5d] = "\xf0\x9d",
  [0x6f5e] = "\xf0\x9e", [0x6f5f] = "\xf0\x9f", [0x6f60] = "\xf0\xa0",
  [0x6f61] = "\xf0\xa1", [0x6f62] = "\xf0\xa2", [0x6f63] = "\xf0\xa3",
  [0x6f64] = "\xf0\xa4", [0x6f65] = "\xf0\xa5", [0x6f66] = "\xf0\xa6",
  [0x6f67] = "\xf0\xa7", [0x6f68] = "\xf0\xa8", [0x6f69] = "\xf0\xa9",
  [0x6f6a] = "\xf0\xaa", [0x6f6b] = "\xf0\xab", [0x6f6c] = "\xf0\xac",
  [0x6f6d] = "\xf0\xad", [0x6f6e] = "\xf0\xae", [0x6f6f] = "\xf0\xaf",
  [0x6f70] = "\xf0\xb0", [0x6f71] = "\xf0\xb1", [0x6f72] = "\xf0\xb2",
  [0x6f73] = "\xf0\xb3", [0x6f74] = "\xf0\xb4", [0x6f75] = "\xf0\xb5",
  [0x6f76] = "\xf0\xb6", [0x6f77] = "\xf0\xb7", [0x6f78] = "\xf0\xb8",
  [0x6f79] = "\xf0\xb9", [0x6f7a] = "\xf0\xba", [0x6f7b] = "\xf0\xbb",
  [0x6f7c] = "\xf0\xbc", [0x6f7d] = "\xf0\xbd", [0x6f7e] = "\xf0\xbe",
  [0x6f7f] = "\xf0\xbf", [0x6f80] = "\xf0\xc0", [0x6f81] = "\xf0\xc1",
  [0x6f82] = "\xf0\xc2", [0x6f83] = "\xf0\xc3", [0x6f84] = "\xf0\xc4",
  [0x6f85] = "\xf0\xc5", [0x6f86] = "\xf0\xc6", [0x6f87] = "\xf0\xc7",
  [0x6f88] = "\xf0\xc8", [0x6f89] = "\xf0\xc9", [0x6f8a] = "\xf0\xca",
  [0x6f8b] = "\xf0\xcb", [0x6f8c] = "\xf0\xcc", [0x6f8d] = "\xf0\xcd",
  [0x6f8e] = "\xf0\xce", [0x6f8f] = "\xf0\xcf", [0x6f90] = "\xf0\xd0",
  [0x6f91] = "\xf0\xd1", [0x6f92] = "\xf0\xd2", [0x6f93] = "\xf0\xd3",
  [0x6f94] = "\xf0\xd4", [0x6f95] = "\xf0\xd5", [0x6f96] = "\xf0\xd6",
  [0x6f97] = "\xf0\xd7", [0x6f98] = "\xf0\xd8", [0x6f99] = "\xf0\xd9",
  [0x6f9a] = "\xf0\xda", [0x6f9b] = "\xf0\xdb", [0x6f9c] = "\xf0\xdc",
  [0x6f9d] = "\xf0\xdd", [0x6f9e] = "\xf0\xde", [0x6f9f] = "\xf0\xdf",
  [0x6fa0] = "\xf0\xe0", [0x6fa1] = "\xf0\xe1", [0x6fa2] = "\xf0\xe2",
  [0x6fa3] = "\xf0\xe3", [0x6fa4] = "\xf0\xe4", [0x6fa5] = "\xf0\xe5",
  [0x6fa6] = "\xf0\xe6", [0x6fa7] = "\xf0\xe7", [0x6fa8] = "\xf0\xe8",
  [0x6fa9] = "\xf0\xe9", [0x6faa] = "\xf0\xea", [0x6fab] = "\xf0\xeb",
  [0x6fac] = "\xf0\xec", [0x6fad] = "\xf0\xed", [0x6fae] = "\xf0\xee",
  [0x6faf] = "\xf0\xef", [0x6fb0] = "\xf0\xf0", [0x6fb1] = "\xf0\xf1",
  [0x6fb2] = "\xf0\xf2", [0x6fb3] = "\xf0\xf3", [0x6fb4] = "\xf0\xf4",
  [0x6fb5] = "\xf0\xf5", [0x6fb6] = "\xf0\xf6", [0x6fb7] = "\xf0\xf7",
  [0x6fb8] = "\xf0\xf8", [0x6fb9] = "\xf0\xf9", [0x6fba] = "\xf0\xfa",
  [0x6fbb] = "\xf0\xfb", [0x6fbc] = "\xf0\xfc", [0x6fbd] = "\xf0\xfd",
  [0x6fbe] = "\xf0\xfe", [0x7000] = "\xf1\x40", [0x7001] = "\xf1\x41",
  [0x7002] = "\xf1\x42", [0x7003] = "\xf1\x43", [0x7004] = "\xf1\x44",
  [0x7005] = "\xf1\x45", [0x7006] = "\xf1\x46", [0x7007] = "\xf1\x47",
  [0x7008] = "\xf1\x48", [0x7009] = "\xf1\x49", [0x700a] = "\xf1\x4a",
  [0x700b] = "\xf1\x4b", [0x700c] = "\xf1\x4c", [0x700d] = "\xf1\x4d",
  [0x700e] = "\xf1\x4e", [0x700f] = "\xf1\x4f", [0x7010] = "\xf1\x50",
  [0x7011] = "\xf1\x51", [0x7012] = "\xf1\x52", [0x7013] = "\xf1\x53",
  [0x7014] = "\xf1\x54", [0x7015] = "\xf1\x55", [0x7016] = "\xf1\x56",
  [0x7017] = "\xf1\x57", [0x7018] = "\xf1\x58", [0x7019] = "\xf1\x59",
  [0x701a] = "\xf1\x5a", [0x701b] = "\xf1\x5b", [0x701c] = "\xf1\x5c",
  [0x701d] = "\xf1\x5d", [0x701e] = "\xf1\x5e", [0x701f] = "\xf1\x5f",
  [0x7020] = "\xf1\x60", [0x7021] = "\xf1\x61", [0x7022] = "\xf1\x62",
  [0x7023] = "\xf1\x63", [0x7024] = "\xf1\x64", [0x7025] = "\xf1\x65",
  [0x7026] = "\xf1\x66", [0x7027] = "\xf1\x67", [0x7028] = "\xf1\x68",
  [0x7029] = "\xf1\x69", [0x702a] = "\xf1\x6a", [0x702b] = "\xf1\x6b",
  [0x702c] = "\xf1\x6c", [0x702d] = "\xf1\x6d", [0x702e] = "\xf1\x6e",
  [0x702f] = "\xf1\x6f", [0x7030] = "\xf1\x70", [0x7031] = "\xf1\x71",
  [0x7032] = "\xf1\x72", [0x7033] = "\xf1\x73", [0x7034] = "\xf1\x74",
  [0x7035] = "\xf1\x75", [0x7036] = "\xf1\x76", [0x7037] = "\xf1\x77",
  [0x7038] = "\xf1\x78", [0x7039] = "\xf1\x79", [0x703a] = "\xf1\x7a",
  [0x703b] = "\xf1\x7b", [0x703c] = "\xf1\x7c", [0x703d] = "\xf1\x7d",
  [0x703e] = "\xf1\x7e", [0x7040] = "\xf1\x80", [0x7041] = "\xf1\x81",
  [0x7042] = "\xf1\x82", [0x7043] = "\xf1\x83", [0x7044] = "\xf1\x84",
  [0x7045] = "\xf1\x85", [0x7046] = "\xf1\x86", [0x7047] = "\xf1\x87",
  [0x7048] = "\xf1\x88", [0x7049] = "\xf1\x89", [0x704a] = "\xf1\x8a",
  [0x704b] = "\xf1\x8b", [0x704c] = "\xf1\x8c", [0x704d] = "\xf1\x8d",
  [0x704e] = "\xf1\x8e", [0x704f] = "\xf1\x8f", [0x7050] = "\xf1\x90",
  [0x7051] = "\xf1\x91", [0x7052] = "\xf1\x92", [0x7053] = "\xf1\x93",
  [0x7054] = "\xf1\x94", [0x7055] = "\xf1\x95", [0x7056] = "\xf1\x96",
  [0x7057] = "\xf1\x97", [0x7058] = "\xf1\x98", [0x7059] = "\xf1\x99",
  [0x705a] = "\xf1\x9a", [0x705b] = "\xf1\x9b", [0x705c] = "\xf1\x9c",
  [0x705d] = "\xf1\x9d", [0x705e] = "\xf1\x9e", [0x705f] = "\xf1\x9f",
  [0x7060] = "\xf1\xa0", [0x7061] = "\xf1\xa1", [0x7062] = "\xf1\xa2",
  [0x7063] = "\xf1\xa3", [0x7064] = "\xf1\xa4", [0x7065] = "\xf1\xa5",
  [0x7066] = "\xf1\xa6", [0x7067] = "\xf1\xa7", [0x7068] = "\xf1\xa8",
  [0x7069] = "\xf1\xa9", [0x706a] = "\xf1\xaa", [0x706b] = "\xf1\xab",
  [0x706c] = "\xf1\xac", [0x706d] = "\xf1\xad", [0x706e] = "\xf1\xae",
  [0x706f] = "\xf1\xaf", [0x7070] = "\xf1\xb0", [0x7071] = "\xf1\xb1",
  [0x7072] = "\xf1\xb2", [0x7073] = "\xf1\xb3", [0x7074] = "\xf1\xb4",
  [0x7075] = "\xf1\xb5", [0x7076] = "\xf1\xb6", [0x7077] = "\xf1\xb7",
  [0x7078] = "\xf1\xb8", [0x7079] = "\xf1\xb9", [0x707a] = "\xf1\xba",
  [0x707b] = "\xf1\xbb", [0x707c] = "\xf1\xbc", [0x707d] = "\xf1\xbd",
  [0x707e] = "\xf1\xbe", [0x707f] = "\xf1\xbf", [0x7080] = "\xf1\xc0",
  [0x7081] = "\xf1\xc1", [0x7082] = "\xf1\xc2", [0x7083] = "\xf1\xc3",
  [0x7084] = "\xf1\xc4", [0x7085] = "\xf1\xc5", [0x7086] = "\xf1\xc6",
  [0x7087] = "\xf1\xc7", [0x7088] = "\xf1\xc8", [0x7089] = "\xf1\xc9",
  [0x708a] = "\xf1\xca", [0x708b] = "\xf1\xcb", [0x708c] = "\xf1\xcc",
  [0x708d] = "\xf1\xcd", [0x708e] = "\xf1\xce", [0x708f] = "\xf1\xcf",
  [0x7090] = "\xf1\xd0", [0x7091] = "\xf1\xd1", [0x7092] = "\xf1\xd2",
  [0x7093] = "\xf1\xd3", [0x7094] = "\xf1\xd4", [0x7095] = "\xf1\xd5",
  [0x7096] = "\xf1\xd6", [0x7097] = "\xf1\xd7", [0x7098] = "\xf1\xd8",
  [0x7099] = "\xf1\xd9", [0x709a] = "\xf1\xda", [0x709b] = "\xf1\xdb",
  [0x709c] = "\xf1\xdc", [0x709d] = "\xf1\xdd", [0x709e] = "\xf1\xde",
  [0x709f] = "\xf1\xdf", [0x70a0] = "\xf1\xe0", [0x70a1] = "\xf1\xe1",
  [0x70a2] = "\xf1\xe2", [0x70a3] = "\xf1\xe3", [0x70a4] = "\xf1\xe4",
  [0x70a5] = "\xf1\xe5", [0x70a6] = "\xf1\xe6", [0x70a7] = "\xf1\xe7",
  [0x70a8] = "\xf1\xe8", [0x70a9] = "\xf1\xe9", [0x70aa] = "\xf1\xea",
  [0x70ab] = "\xf1\xeb", [0x70ac] = "\xf1\xec", [0x70ad] = "\xf1\xed",
  [0x70ae] = "\xf1\xee", [0x70af] = "\xf1\xef", [0x70b0] = "\xf1\xf0",
  [0x70b1] = "\xf1\xf1", [0x70b2] = "\xf1\xf2", [0x70b3] = "\xf1\xf3",
  [0x70b4] = "\xf1\xf4", [0x70b5] = "\xf1\xf5", [0x70b6] = "\xf1\xf6",
  [0x70b7] = "\xf1\xf7", [0x70b8] = "\xf1\xf8", [0x70b9] = "\xf1\xf9",
  [0x70ba] = "\xf1\xfa", [0x70bb] = "\xf1\xfb", [0x70bc] = "\xf1\xfc",
  [0x70bd] = "\xf1\xfd", [0x70be] = "\xf1\xfe", [0x7100] = "\xf2\x40",
  [0x7101] = "\xf2\x41", [0x7102] = "\xf2\x42", [0x7103] = "\xf2\x43",
  [0x7104] = "\xf2\x44", [0x7105] = "\xf2\x45", [0x7106] = "\xf2\x46",
  [0x7107] = "\xf2\x47", [0x7108] = "\xf2\x48", [0x7109] = "\xf2\x49",
  [0x710a] = "\xf2\x4a", [0x710b] = "\xf2\x4b", [0x710c] = "\xf2\x4c",
  [0x710d] = "\xf2\x4d", [0x710e] = "\xf2\x4e", [0x710f] = "\xf2\x4f",
  [0x7110] = "\xf2\x50", [0x7111] = "\xf2\x51", [0x7112] = "\xf2\x52",
  [0x7113] = "\xf2\x53", [0x7114] = "\xf2\x54", [0x7115] = "\xf2\x55",
  [0x7116] = "\xf2\x56", [0x7117] = "\xf2\x57", [0x7118] = "\xf2\x58",
  [0x7119] = "\xf2\x59", [0x711a] = "\xf2\x5a", [0x711b] = "\xf2\x5b",
  [0x711c] = "\xf2\x5c", [0x711d] = "\xf2\x5d", [0x711e] = "\xf2\x5e",
  [0x711f] = "\xf2\x5f", [0x7120] = "\xf2\x60", [0x7121] = "\xf2\x61",
  [0x7122] = "\xf2\x62", [0x7123] = "\xf2\x63", [0x7124] = "\xf2\x64",
  [0x7125] = "\xf2\x65", [0x7126] = "\xf2\x66", [0x7127] = "\xf2\x67",
  [0x7128] = "\xf2\x68", [0x7129] = "\xf2\x69", [0x712a] = "\xf2\x6a",
  [0x712b] = "\xf2\x6b", [0x712c] = "\xf2\x6c", [0x712d] = "\xf2\x6d",
  [0x712e] = "\xf2\x6e", [0x712f] = "\xf2\x6f", [0x7130] = "\xf2\x70",
  [0x7131] = "\xf2\x71", [0x7132] = "\xf2\x72", [0x7133] = "\xf2\x73",
  [0x7134] = "\xf2\x74", [0x7135] = "\xf2\x75", [0x7136] = "\xf2\x76",
  [0x7137] = "\xf2\x77", [0x7138] = "\xf2\x78", [0x7139] = "\xf2\x79",
  [0x713a] = "\xf2\x7a", [0x713b] = "\xf2\x7b", [0x713c] = "\xf2\x7c",
  [0x713d] = "\xf2\x7d", [0x713e] = "\xf2\x7e", [0x7140] = "\xf2\x80",
  [0x7141] = "\xf2\x81", [0x7142] = "\xf2\x82", [0x7143] = "\xf2\x83",
  [0x7144] = "\xf2\x84", [0x7145] = "\xf2\x85", [0x7146] = "\xf2\x86",
  [0x7147] = "\xf2\x87", [0x7148] = "\xf2\x88", [0x7149] = "\xf2\x89",
  [0x714a] = "\xf2\x8a", [0x714b] = "\xf2\x8b", [0x714c] = "\xf2\x8c",
  [0x714d] = "\xf2\x8d", [0x714e] = "\xf2\x8e", [0x714f] = "\xf2\x8f",
  [0x7150] = "\xf2\x90", [0x7151] = "\xf2\x91", [0x7152] = "\xf2\x92",
  [0x7153] = "\xf2\x93", [0x7154] = "\xf2\x94", [0x7155] = "\xf2\x95",
  [0x7156] = "\xf2\x96", [0x7157] = "\xf2\x97", [0x7158] = "\xf2\x98",
  [0x7159] = "\xf2\x99", [0x715a] = "\xf2\x9a", [0x715b] = "\xf2\x9b",
  [0x715c] = "\xf2\x9c", [0x715d] = "\xf2\x9d", [0x715e] = "\xf2\x9e",
  [0x715f] = "\xf2\x9f", [0x7160] = "\xf2\xa0", [0x7161] = "\xf2\xa1",
  [0x7162] = "\xf2\xa2", [0x7163] = "\xf2\xa3", [0x7164] = "\xf2\xa4",
  [0x7165] = "\xf2\xa5", [0x7166] = "\xf2\xa6", [0x7167] = "\xf2\xa7",
  [0x7168] = "\xf2\xa8", [0x7169] = "\xf2\xa9", [0x716a] = "\xf2\xaa",
  [0x716b] = "\xf2\xab", [0x716c] = "\xf2\xac", [0x716d] = "\xf2\xad",
  [0x716e] = "\xf2\xae", [0x716f] = "\xf2\xaf", [0x7170] = "\xf2\xb0",
  [0x7171] = "\xf2\xb1", [0x7172] = "\xf2\xb2", [0x7173] = "\xf2\xb3",
  [0x7174] = "\xf2\xb4", [0x7175] = "\xf2\xb5", [0x7176] = "\xf2\xb6",
  [0x7177] = "\xf2\xb7", [0x7178] = "\xf2\xb8", [0x7179] = "\xf2\xb9",
  [0x717a] = "\xf2\xba", [0x717b] = "\xf2\xbb", [0x717c] = "\xf2\xbc",
  [0x717d] = "\xf2\xbd", [0x717e] = "\xf2\xbe", [0x717f] = "\xf2\xbf",
  [0x7180] = "\xf2\xc0", [0x7181] = "\xf2\xc1", [0x7182] = "\xf2\xc2",
  [0x7183] = "\xf2\xc3", [0x7184] = "\xf2\xc4", [0x7185] = "\xf2\xc5",
  [0x7186] = "\xf2\xc6", [0x7187] = "\xf2\xc7", [0x7188] = "\xf2\xc8",
  [0x7189] = "\xf2\xc9", [0x718a] = "\xf2\xca", [0x718b] = "\xf2\xcb",
  [0x718c] = "\xf2\xcc", [0x718d] = "\xf2\xcd", [0x718e] = "\xf2\xce",
  [0x718f] = "\xf2\xcf", [0x7190] = "\xf2\xd0", [0x7191] = "\xf2\xd1",
  [0x7192] = "\xf2\xd2", [0x7193] = "\xf2\xd3", [0x7194] = "\xf2\xd4",
  [0x7195] = "\xf2\xd5", [0x7196] = "\xf2\xd6", [0x7197] = "\xf2\xd7",
  [0x7198] = "\xf2\xd8", [0x7199] = "\xf2\xd9", [0x719a] = "\xf2\xda",
  [0x719b] = "\xf2\xdb", [0x719c] = "\xf2\xdc", [0x719d] = "\xf2\xdd",
  [0x719e] = "\xf2\xde", [0x719f] = "\xf2\xdf", [0x71a0] = "\xf2\xe0",
  [0x71a1] = "\xf2\xe1", [0x71a2] = "\xf2\xe2", [0x71a3] = "\xf2\xe3",
  [0x71a4] = "\xf2\xe4", [0x71a5] = "\xf2\xe5", [0x71a6] = "\xf2\xe6",
  [0x71a7] = "\xf2\xe7", [0x71a8] = "\xf2\xe8", [0x71a9] = "\xf2\xe9",
  [0x71aa] = "\xf2\xea", [0x71ab] = "\xf2\xeb", [0x71ac] = "\xf2\xec",
  [0x71ad] = "\xf2\xed", [0x71ae] = "\xf2\xee", [0x71af] = "\xf2\xef",
  [0x71b0] = "\xf2\xf0", [0x71b1] = "\xf2\xf1", [0x71b2] = "\xf2\xf2",
  [0x71b3] = "\xf2\xf3", [0x71b4] = "\xf2\xf4", [0x71b5] = "\xf2\xf5",
  [0x71b6] = "\xf2\xf6", [0x71b7] = "\xf2\xf7", [0x71b8] = "\xf2\xf8",
  [0x71b9] = "\xf2\xf9", [0x71ba] = "\xf2\xfa", [0x71bb] = "\xf2\xfb",
  [0x71bc] = "\xf2\xfc", [0x71bd] = "\xf2\xfd", [0x71be] = "\xf2\xfe",
  [0x7200] = "\xf3\x40", [0x7201] = "\xf3\x41", [0x7202] = "\xf3\x42",
  [0x7203] = "\xf3\x43", [0x7204] = "\xf3\x44", [0x7205] = "\xf3\x45",
  [0x7206] = "\xf3\x46", [0x7207] = "\xf3\x47", [0x7208] = "\xf3\x48",
  [0x7209] = "\xf3\x49", [0x720a] = "\xf3\x4a", [0x720b] = "\xf3\x4b",
  [0x720c] = "\xf3\x4c", [0x720d] = "\xf3\x4d", [0x720e] = "\xf3\x4e",
  [0x720f] = "\xf3\x4f", [0x7210] = "\xf3\x50", [0x7211] = "\xf3\x51",
  [0x7212] = "\xf3\x52", [0x7213] = "\xf3\x53", [0x7214] = "\xf3\x54",
  [0x7215] = "\xf3\x55", [0x7216] = "\xf3\x56", [0x7217] = "\xf3\x57",
  [0x7218] = "\xf3\x58", [0x7219] = "\xf3\x59", [0x721a] = "\xf3\x5a",
  [0x721b] = "\xf3\x5b", [0x721c] = "\xf3\x5c", [0x721d] = "\xf3\x5d",
  [0x721e] = "\xf3\x5e", [0x721f] = "\xf3\x5f", [0x7220] = "\xf3\x60",
  [0x7221] = "\xf3\x61", [0x7222] = "\xf3\x62", [0x7223] = "\xf3\x63",
  [0x7224] = "\xf3\x64", [0x7225] = "\xf3\x65", [0x7226] = "\xf3\x66",
  [0x7227] = "\xf3\x67", [0x7228] = "\xf3\x68", [0x7229] = "\xf3\x69",
  [0x722a] = "\xf3\x6a", [0x722b] = "\xf3\x6b", [0x722c] = "\xf3\x6c",
  [0x722d] = "\xf3\x6d", [0x722e] = "\xf3\x6e", [0x722f] = "\xf3\x6f",
  [0x7230] = "\xf3\x70", [0x7231] = "\xf3\x71", [0x7232] = "\xf3\x72",
  [0x7233] = "\xf3\x73", [0x7234] = "\xf3\x74", [0x7235] = "\xf3\x75",
  [0x7236] = "\xf3\x76", [0x7237] = "\xf3\x77", [0x7238] = "\xf3\x78",
  [0x7239] = "\xf3\x79", [0x723a] = "\xf3\x7a", [0x723b] = "\xf3\x7b",
  [0x723c] = "\xf3\x7c", [0x723d] = "\xf3\x7d", [0x723e] = "\xf3\x7e",
  [0x7240] = "\xf3\x80", [0x7241] = "\xf3\x81", [0x7242] = "\xf3\x82",
  [0x7243] = "\xf3\x83", [0x7244] = "\xf3\x84", [0x7245] = "\xf3\x85",
  [0x7246] = "\xf3\x86", [0x7247] = "\xf3\x87", [0x7248] = "\xf3\x88",
  [0x7249] = "\xf3\x89", [0x724a] = "\xf3\x8a", [0x724b] = "\xf3\x8b",
  [0x724c] = "\xf3\x8c", [0x724d] = "\xf3\x8d", [0x724e] = "\xf3\x8e",
  [0x724f] = "\xf3\x8f", [0x7250] = "\xf3\x90", [0x7251] = "\xf3\x91",
  [0x7252] = "\xf3\x92", [0x7253] = "\xf3\x93", [0x7254] = "\xf3\x94",
  [0x7255] = "\xf3\x95", [0x7256] = "\xf3\x96", [0x7257] = "\xf3\x97",
  [0x7258] = "\xf3\x98", [0x7259] = "\xf3\x99", [0x725a] = "\xf3\x9a",
  [0x725b] = "\xf3\x9b", [0x725c] = "\xf3\x9c", [0x725d] = "\xf3\x9d",
  [0x725e] = "\xf3\x9e", [0x725f] = "\xf3\x9f", [0x7260] = "\xf3\xa0",
  [0x7261] = "\xf3\xa1", [0x7262] = "\xf3\xa2", [0x7263] = "\xf3\xa3",
  [0x7264] = "\xf3\xa4", [0x7265] = "\xf3\xa5", [0x7266] = "\xf3\xa6",
  [0x7267] = "\xf3\xa7", [0x7268] = "\xf3\xa8", [0x7269] = "\xf3\xa9",
  [0x726a] = "\xf3\xaa", [0x726b] = "\xf3\xab", [0x726c] = "\xf3\xac",
  [0x726d] = "\xf3\xad", [0x726e] = "\xf3\xae", [0x726f] = "\xf3\xaf",
  [0x7270] = "\xf3\xb0", [0x7271] = "\xf3\xb1", [0x7272] = "\xf3\xb2",
  [0x7273] = "\xf3\xb3", [0x7274] = "\xf3\xb4", [0x7275] = "\xf3\xb5",
  [0x7276] = "\xf3\xb6", [0x7277] = "\xf3\xb7", [0x7278] = "\xf3\xb8",
  [0x7279] = "\xf3\xb9", [0x727a] = "\xf3\xba", [0x727b] = "\xf3\xbb",
  [0x727c] = "\xf3\xbc", [0x727d] = "\xf3\xbd", [0x727e] = "\xf3\xbe",
  [0x727f] = "\xf3\xbf", [0x7280] = "\xf3\xc0", [0x7281] = "\xf3\xc1",
  [0x7282] = "\xf3\xc2", [0x7283] = "\xf3\xc3", [0x7284] = "\xf3\xc4",
  [0x7285] = "\xf3\xc5", [0x7286] = "\xf3\xc6", [0x7287] = "\xf3\xc7",
  [0x7288] = "\xf3\xc8", [0x7289] = "\xf3\xc9", [0x728a] = "\xf3\xca",
  [0x728b] = "\xf3\xcb", [0x728c] = "\xf3\xcc", [0x728d] = "\xf3\xcd",
  [0x728e] = "\xf3\xce", [0x728f] = "\xf3\xcf", [0x7290] = "\xf3\xd0",
  [0x7291] = "\xf3\xd1", [0x7292] = "\xf3\xd2", [0x7293] = "\xf3\xd3",
  [0x7294] = "\xf3\xd4", [0x7295] = "\xf3\xd5", [0x7296] = "\xf3\xd6",
  [0x7297] = "\xf3\xd7", [0x7298] = "\xf3\xd8", [0x7299] = "\xf3\xd9",
  [0x729a] = "\xf3\xda", [0x729b] = "\xf3\xdb", [0x729c] = "\xf3\xdc",
  [0x729d] = "\xf3\xdd", [0x729e] = "\xf3\xde", [0x729f] = "\xf3\xdf",
  [0x72a0] = "\xf3\xe0", [0x72a1] = "\xf3\xe1", [0x72a2] = "\xf3\xe2",
  [0x72a3] = "\xf3\xe3", [0x72a4] = "\xf3\xe4", [0x72a5] = "\xf3\xe5",
  [0x72a6] = "\xf3\xe6", [0x72a7] = "\xf3\xe7", [0x72a8] = "\xf3\xe8",
  [0x72a9] = "\xf3\xe9", [0x72aa] = "\xf3\xea", [0x72ab] = "\xf3\xeb",
  [0x72ac] = "\xf3\xec", [0x72ad] = "\xf3\xed", [0x72ae] = "\xf3\xee",
  [0x72af] = "\xf3\xef", [0x72b0] = "\xf3\xf0", [0x72b1] = "\xf3\xf1",
  [0x72b2] = "\xf3\xf2", [0x72b3] = "\xf3\xf3", [0x72b4] = "\xf3\xf4",
  [0x72b5] = "\xf3\xf5", [0x72b6] = "\xf3\xf6", [0x72b7] = "\xf3\xf7",
  [0x72b8] = "\xf3\xf8", [0x72b9] = "\xf3\xf9", [0x72ba] = "\xf3\xfa",
  [0x72bb] = "\xf3\xfb", [0x72bc] = "\xf3\xfc", [0x72bd] = "\xf3\xfd",
  [0x72be] = "\xf3\xfe", [0x7300] = "\xf4\x40", [0x7301] = "\xf4\x41",
  [0x7302] = "\xf4\x42", [0x7303] = "\xf4\x43", [0x7304] = "\xf4\x44",
  [0x7305] = "\xf4\x45", [0x7306] = "\xf4\x46", [0x7307] = "\xf4\x47",
  [0x7308] = "\xf4\x48", [0x7309] = "\xf4\x49", [0x730a] = "\xf4\x4a",
  [0x730b] = "\xf4\x4b", [0x730c] = "\xf4\x4c", [0x730d] = "\xf4\x4d",
  [0x730e] = "\xf4\x4e", [0x730f] = "\xf4\x4f", [0x7310] = "\xf4\x50",
  [0x7311] = "\xf4\x51", [0x7312] = "\xf4\x52", [0x7313] = "\xf4\x53",
  [0x7314] = "\xf4\x54", [0x7315] = "\xf4\x55", [0x7316] = "\xf4\x56",
  [0x7317] = "\xf4\x57", [0x7318] = "\xf4\x58", [0x7319] = "\xf4\x59",
  [0x731a] = "\xf4\x5a", [0x731b] = "\xf4\x5b", [0x731c] = "\xf4\x5c",
  [0x731d] = "\xf4\x5d", [0x731e] = "\xf4\x5e", [0x731f] = "\xf4\x5f",
  [0x7320] = "\xf4\x60", [0x7321] = "\xf4\x61", [0x7322] = "\xf4\x62",
  [0x7323] = "\xf4\x63", [0x7324] = "\xf4\x64", [0x7325] = "\xf4\x65",
  [0x7326] = "\xf4\x66", [0x7327] = "\xf4\x67", [0x7328] = "\xf4\x68",
  [0x7329] = "\xf4\x69", [0x732a] = "\xf4\x6a", [0x732b] = "\xf4\x6b",
  [0x732c] = "\xf4\x6c", [0x732d] = "\xf4\x6d", [0x732e] = "\xf4\x6e",
  [0x732f] = "\xf4\x6f", [0x7330] = "\xf4\x70", [0x7331] = "\xf4\x71",
  [0x7332] = "\xf4\x72", [0x7333] = "\xf4\x73", [0x7334] = "\xf4\x74",
  [0x7335] = "\xf4\x75", [0x7336] = "\xf4\x76", [0x7337] = "\xf4\x77",
  [0x7338] = "\xf4\x78", [0x7339] = "\xf4\x79", [0x733a] = "\xf4\x7a",
  [0x733b] = "\xf4\x7b", [0x733c] = "\xf4\x7c", [0x733d] = "\xf4\x7d",
  [0x733e] = "\xf4\x7e", [0x7340] = "\xf4\x80", [0x7341] = "\xf4\x81",
  [0x7342] = "\xf4\x82", [0x7343] = "\xf4\x83", [0x7344] = "\xf4\x84",
  [0x7345] = "\xf4\x85", [0x7346] = "\xf4\x86", [0x7347] = "\xf4\x87",
  [0x7348] = "\xf4\x88", [0x7349] = "\xf4\x89", [0x734a] = "\xf4\x8a",
  [0x734b] = "\xf4\x8b", [0x734c] = "\xf4\x8c", [0x734d] = "\xf4\x8d",
  [0x734e] = "\xf4\x8e", [0x734f] = "\xf4\x8f", [0x7350] = "\xf4\x90",
  [0x7351] = "\xf4\x91", [0x7352] = "\xf4\x92", [0x7353] = "\xf4\x93",
  [0x7354] = "\xf4\x94", [0x7355] = "\xf4\x95", [0x7356] = "\xf4\x96",
  [0x7357] = "\xf4\x97", [0x7358] = "\xf4\x98", [0x7359] = "\xf4\x99",
  [0x735a] = "\xf4\x9a", [0x735b] = "\xf4\x9b", [0x735c] = "\xf4\x9c",
  [0x735d] = "\xf4\x9d", [0x735e] = "\xf4\x9e", [0x735f] = "\xf4\x9f",
  [0x7360] = "\xf4\xa0", [0x7361] = "\xf4\xa1", [0x7362] = "\xf4\xa2",
  [0x7363] = "\xf4\xa3", [0x7364] = "\xf4\xa4", [0x7365] = "\xf4\xa5",
  [0x7366] = "\xf4\xa6", [0x7367] = "\xf4\xa7", [0x7368] = "\xf4\xa8",
  [0x7369] = "\xf4\xa9", [0x736a] = "\xf4\xaa", [0x736b] = "\xf4\xab",
  [0x736c] = "\xf4\xac", [0x736d] = "\xf4\xad", [0x736e] = "\xf4\xae",
  [0x736f] = "\xf4\xaf", [0x7370] = "\xf4\xb0", [0x7371] = "\xf4\xb1",
  [0x7372] = "\xf4\xb2", [0x7373] = "\xf4\xb3", [0x7374] = "\xf4\xb4",
  [0x7375] = "\xf4\xb5", [0x7376] = "\xf4\xb6", [0x7377] = "\xf4\xb7",
  [0x7378] = "\xf4\xb8", [0x7379] = "\xf4\xb9", [0x737a] = "\xf4\xba",
  [0x737b] = "\xf4\xbb", [0x737c] = "\xf4\xbc", [0x737d] = "\xf4\xbd",
  [0x737e] = "\xf4\xbe", [0x737f] = "\xf4\xbf", [0x7380] = "\xf4\xc0",
  [0x7381] = "\xf4\xc1", [0x7382] = "\xf4\xc2", [0x7383] = "\xf4\xc3",
  [0x7384] = "\xf4\xc4", [0x7385] = "\xf4\xc5", [0x7386] = "\xf4\xc6",
  [0x7387] = "\xf4\xc7", [0x7388] = "\xf4\xc8", [0x7389] = "\xf4\xc9",
  [0x738a] = "\xf4\xca", [0x738b] = "\xf4\xcb", [0x738c] = "\xf4\xcc",
  [0x738d] = "\xf4\xcd", [0x738e] = "\xf4\xce", [0x738f] = "\xf4\xcf",
  [0x7390] = "\xf4\xd0", [0x7391] = "\xf4\xd1", [0x7392] = "\xf4\xd2",
  [0x7393] = "\xf4\xd3", [0x7394] = "\xf4\xd4", [0x7395] = "\xf4\xd5",
  [0x7396] = "\xf4\xd6", [0x7397] = "\xf4\xd7", [0x7398] = "\xf4\xd8",
  [0x7399] = "\xf4\xd9", [0x739a] = "\xf4\xda", [0x739b] = "\xf4\xdb",
  [0x739c] = "\xf4\xdc", [0x739d] = "\xf4\xdd", [0x739e] = "\xf4\xde",
  [0x739f] = "\xf4\xdf", [0x73a0] = "\xf4\xe0", [0x73a1] = "\xf4\xe1",
  [0x73a2] = "\xf4\xe2", [0x73a3] = "\xf4\xe3", [0x73a4] = "\xf4\xe4",
  [0x73a5] = "\xf4\xe5", [0x73a6] = "\xf4\xe6", [0x73a7] = "\xf4\xe7",
  [0x73a8] = "\xf4\xe8", [0x73a9] = "\xf4\xe9", [0x73aa] = "\xf4\xea",
  [0x73ab] = "\xf4\xeb", [0x73ac] = "\xf4\xec", [0x73ad] = "\xf4\xed",
  [0x73ae] = "\xf4\xee", [0x73af] = "\xf4\xef", [0x73b0] = "\xf4\xf0",
  [0x73b1] = "\xf4\xf1", [0x73b2] = "\xf4\xf2", [0x73b3] = "\xf4\xf3",
  [0x73b4] = "\xf4\xf4", [0x73b5] = "\xf4\xf5", [0x73b6] = "\xf4\xf6",
  [0x73b7] = "\xf4\xf7", [0x73b8] = "\xf4\xf8", [0x73b9] = "\xf4\xf9",
  [0x73ba] = "\xf4\xfa", [0x73bb] = "\xf4\xfb", [0x73bc] = "\xf4\xfc",
  [0x73bd] = "\xf4\xfd", [0x73be] = "\xf4\xfe", [0x7400] = "\xf5\x40",
  [0x7401] = "\xf5\x41", [0x7402] = "\xf5\x42", [0x7403] = "\xf5\x43",
  [0x7404] = "\xf5\x44", [0x7405] = "\xf5\x45", [0x7406] = "\xf5\x46",
  [0x7407] = "\xf5\x47", [0x7408] = "\xf5\x48", [0x7409] = "\xf5\x49",
  [0x740a] = "\xf5\x4a", [0x740b] = "\xf5\x4b", [0x740c] = "\xf5\x4c",
  [0x740d] = "\xf5\x4d", [0x740e] = "\xf5\x4e", [0x740f] = "\xf5\x4f",
  [0x7410] = "\xf5\x50", [0x7411] = "\xf5\x51", [0x7412] = "\xf5\x52",
  [0x7413] = "\xf5\x53", [0x7414] = "\xf5\x54", [0x7415] = "\xf5\x55",
  [0x7416] = "\xf5\x56", [0x7417] = "\xf5\x57", [0x7418] = "\xf5\x58",
  [0x7419] = "\xf5\x59", [0x741a] = "\xf5\x5a", [0x741b] = "\xf5\x5b",
  [0x741c] = "\xf5\x5c", [0x741d] = "\xf5\x5d", [0x741e] = "\xf5\x5e",
  [0x741f] = "\xf5\x5f", [0x7420] = "\xf5\x60", [0x7421] = "\xf5\x61",
  [0x7422] = "\xf5\x62", [0x7423] = "\xf5\x63", [0x7424] = "\xf5\x64",
  [0x7425] = "\xf5\x65", [0x7426] = "\xf5\x66", [0x7427] = "\xf5\x67",
  [0x7428] = "\xf5\x68", [0x7429] = "\xf5\x69", [0x742a] = "\xf5\x6a",
  [0x742b] = "\xf5\x6b", [0x742c] = "\xf5\x6c", [0x742d] = "\xf5\x6d",
  [0x742e] = "\xf5\x6e", [0x742f] = "\xf5\x6f", [0x7430] = "\xf5\x70",
  [0x7431] = "\xf5\x71", [0x7432] = "\xf5\x72", [0x7433] = "\xf5\x73",
  [0x7434] = "\xf5\x74", [0x7435] = "\xf5\x75", [0x7436] = "\xf5\x76",
  [0x7437] = "\xf5\x77", [0x7438] = "\xf5\x78", [0x7439] = "\xf5\x79",
  [0x743a] = "\xf5\x7a", [0x743b] = "\xf5\x7b", [0x743c] = "\xf5\x7c",
  [0x743d] = "\xf5\x7d", [0x743e] = "\xf5\x7e", [0x7440] = "\xf5\x80",
  [0x7441] = "\xf5\x81", [0x7442] = "\xf5\x82", [0x7443] = "\xf5\x83",
  [0x7444] = "\xf5\x84", [0x7445] = "\xf5\x85", [0x7446] = "\xf5\x86",
  [0x7447] = "\xf5\x87", [0x7448] = "\xf5\x88", [0x7449] = "\xf5\x89",
  [0x744a] = "\xf5\x8a", [0x744b] = "\xf5\x8b", [0x744c] = "\xf5\x8c",
  [0x744d] = "\xf5\x8d", [0x744e] = "\xf5\x8e", [0x744f] = "\xf5\x8f",
  [0x7450] = "\xf5\x90", [0x7451] = "\xf5\x91", [0x7452] = "\xf5\x92",
  [0x7453] = "\xf5\x93", [0x7454] = "\xf5\x94", [0x7455] = "\xf5\x95",
  [0x7456] = "\xf5\x96", [0x7457] = "\xf5\x97", [0x7458] = "\xf5\x98",
  [0x7459] = "\xf5\x99", [0x745a] = "\xf5\x9a", [0x745b] = "\xf5\x9b",
  [0x745c] = "\xf5\x9c", [0x745d] = "\xf5\x9d", [0x745e] = "\xf5\x9e",
  [0x745f] = "\xf5\x9f", [0x7460] = "\xf5\xa0", [0x7461] = "\xf5\xa1",
  [0x7462] = "\xf5\xa2", [0x7463] = "\xf5\xa3", [0x7464] = "\xf5\xa4",
  [0x7465] = "\xf5\xa5", [0x7466] = "\xf5\xa6", [0x7467] = "\xf5\xa7",
  [0x7468] = "\xf5\xa8", [0x7469] = "\xf5\xa9", [0x746a] = "\xf5\xaa",
  [0x746b] = "\xf5\xab", [0x746c] = "\xf5\xac", [0x746d] = "\xf5\xad",
  [0x746e] = "\xf5\xae", [0x746f] = "\xf5\xaf", [0x7470] = "\xf5\xb0",
  [0x7471] = "\xf5\xb1", [0x7472] = "\xf5\xb2", [0x7473] = "\xf5\xb3",
  [0x7474] = "\xf5\xb4", [0x7475] = "\xf5\xb5", [0x7476] = "\xf5\xb6",
  [0x7477] = "\xf5\xb7", [0x7478] = "\xf5\xb8", [0x7479] = "\xf5\xb9",
  [0x747a] = "\xf5\xba", [0x747b] = "\xf5\xbb", [0x747c] = "\xf5\xbc",
  [0x747d] = "\xf5\xbd", [0x747e] = "\xf5\xbe", [0x747f] = "\xf5\xbf",
  [0x7480] = "\xf5\xc0", [0x7481] = "\xf5\xc1", [0x7482] = "\xf5\xc2",
  [0x7483] = "\xf5\xc3", [0x7484] = "\xf5\xc4", [0x7485] = "\xf5\xc5",
  [0x7486] = "\xf5\xc6", [0x7487] = "\xf5\xc7", [0x7488] = "\xf5\xc8",
  [0x7489] = "\xf5\xc9", [0x748a] = "\xf5\xca", [0x748b] = "\xf5\xcb",
  [0x748c] = "\xf5\xcc", [0x748d] = "\xf5\xcd", [0x748e] = "\xf5\xce",
  [0x748f] = "\xf5\xcf", [0x7490] = "\xf5\xd0", [0x7491] = "\xf5\xd1",
  [0x7492] = "\xf5\xd2", [0x7493] = "\xf5\xd3", [0x7494] = "\xf5\xd4",
  [0x7495] = "\xf5\xd5", [0x7496] = "\xf5\xd6", [0x7497] = "\xf5\xd7",
  [0x7498] = "\xf5\xd8", [0x7499] = "\xf5\xd9", [0x749a] = "\xf5\xda",
  [0x749b] = "\xf5\xdb", [0x749c] = "\xf5\xdc", [0x749d] = "\xf5\xdd",
  [0x749e] = "\xf5\xde", [0x749f] = "\xf5\xdf", [0x74a0] = "\xf5\xe0",
  [0x74a1] = "\xf5\xe1", [0x74a2] = "\xf5\xe2", [0x74a3] = "\xf5\xe3",
  [0x74a4] = "\xf5\xe4", [0x74a5] = "\xf5\xe5", [0x74a6] = "\xf5\xe6",
  [0x74a7] = "\xf5\xe7", [0x74a8] = "\xf5\xe8", [0x74a9] = "\xf5\xe9",
  [0x74aa] = "\xf5\xea", [0x74ab] = "\xf5\xeb", [0x74ac] = "\xf5\xec",
  [0x74ad] = "\xf5\xed", [0x74ae] = "\xf5\xee", [0x74af] = "\xf5\xef",
  [0x74b0] = "\xf5\xf0", [0x74b1] = "\xf5\xf1", [0x74b2] = "\xf5\xf2",
  [0x74b3] = "\xf5\xf3", [0x74b4] = "\xf5\xf4", [0x74b5] = "\xf5\xf5",
  [0x74b6] = "\xf5\xf6", [0x74b7] = "\xf5\xf7", [0x74b8] = "\xf5\xf8",
  [0x74b9] = "\xf5\xf9", [0x74ba] = "\xf5\xfa", [0x74bb] = "\xf5\xfb",
  [0x74bc] = "\xf5\xfc", [0x74bd] = "\xf5\xfd", [0x74be] = "\xf5\xfe",
  [0x7500] = "\xf6\x40", [0x7501] = "\xf6\x41", [0x7502] = "\xf6\x42",
  [0x7503] = "\xf6\x43", [0x7504] = "\xf6\x44", [0x7505] = "\xf6\x45",
  [0x7506] = "\xf6\x46", [0x7507] = "\xf6\x47", [0x7508] = "\xf6\x48",
  [0x7509] = "\xf6\x49", [0x750a] = "\xf6\x4a", [0x750b] = "\xf6\x4b",
  [0x750c] = "\xf6\x4c", [0x750d] = "\xf6\x4d", [0x750e] = "\xf6\x4e",
  [0x750f] = "\xf6\x4f", [0x7510] = "\xf6\x50", [0x7511] = "\xf6\x51",
  [0x7512] = "\xf6\x52", [0x7513] = "\xf6\x53", [0x7514] = "\xf6\x54",
  [0x7515] = "\xf6\x55", [0x7516] = "\xf6\x56", [0x7517] = "\xf6\x57",
  [0x7518] = "\xf6\x58", [0x7519] = "\xf6\x59", [0x751a] = "\xf6\x5a",
  [0x751b] = "\xf6\x5b", [0x751c] = "\xf6\x5c", [0x751d] = "\xf6\x5d",
  [0x751e] = "\xf6\x5e", [0x751f] = "\xf6\x5f", [0x7520] = "\xf6\x60",
  [0x7521] = "\xf6\x61", [0x7522] = "\xf6\x62", [0x7523] = "\xf6\x63",
  [0x7524] = "\xf6\x64", [0x7525] = "\xf6\x65", [0x7526] = "\xf6\x66",
  [0x7527] = "\xf6\x67", [0x7528] = "\xf6\x68", [0x7529] = "\xf6\x69",
  [0x752a] = "\xf6\x6a", [0x752b] = "\xf6\x6b", [0x752c] = "\xf6\x6c",
  [0x752d] = "\xf6\x6d", [0x752e] = "\xf6\x6e", [0x752f] = "\xf6\x6f",
  [0x7530] = "\xf6\x70", [0x7531] = "\xf6\x71", [0x7532] = "\xf6\x72",
  [0x7533] = "\xf6\x73", [0x7534] = "\xf6\x74", [0x7535] = "\xf6\x75",
  [0x7536] = "\xf6\x76", [0x7537] = "\xf6\x77", [0x7538] = "\xf6\x78",
  [0x7539] = "\xf6\x79", [0x753a] = "\xf6\x7a", [0x753b] = "\xf6\x7b",
  [0x753c] = "\xf6\x7c", [0x753d] = "\xf6\x7d", [0x753e] = "\xf6\x7e",
  [0x7540] = "\xf6\x80", [0x7541] = "\xf6\x81", [0x7542] = "\xf6\x82",
  [0x7543] = "\xf6\x83", [0x7544] = "\xf6\x84", [0x7545] = "\xf6\x85",
  [0x7546] = "\xf6\x86", [0x7547] = "\xf6\x87", [0x7548] = "\xf6\x88",
  [0x7549] = "\xf6\x89", [0x754a] = "\xf6\x8a", [0x754b] = "\xf6\x8b",
  [0x754c] = "\xf6\x8c", [0x754d] = "\xf6\x8d", [0x754e] = "\xf6\x8e",
  [0x754f] = "\xf6\x8f", [0x7550] = "\xf6\x90", [0x7551] = "\xf6\x91",
  [0x7552] = "\xf6\x92", [0x7553] = "\xf6\x93", [0x7554] = "\xf6\x94",
  [0x7555] = "\xf6\x95", [0x7556] = "\xf6\x96", [0x7557] = "\xf6\x97",
  [0x7558] = "\xf6\x98", [0x7559] = "\xf6\x99", [0x755a] = "\xf6\x9a",
  [0x755b] = "\xf6\x9b", [0x755c] = "\xf6\x9c", [0x755d] = "\xf6\x9d",
  [0x755e] = "\xf6\x9e", [0x755f] = "\xf6\x9f", [0x7560] = "\xf6\xa0",
  [0x7561] = "\xf6\xa1", [0x7562] = "\xf6\xa2", [0x7563] = "\xf6\xa3",
  [0x7564] = "\xf6\xa4", [0x7565] = "\xf6\xa5", [0x7566] = "\xf6\xa6",
  [0x7567] = "\xf6\xa7", [0x7568] = "\xf6\xa8", [0x7569] = "\xf6\xa9",
  [0x756a] = "\xf6\xaa", [0x756b] = "\xf6\xab", [0x756c] = "\xf6\xac",
  [0x756d] = "\xf6\xad", [0x756e] = "\xf6\xae", [0x756f] = "\xf6\xaf",
  [0x7570] = "\xf6\xb0", [0x7571] = "\xf6\xb1", [0x7572] = "\xf6\xb2",
  [0x7573] = "\xf6\xb3", [0x7574] = "\xf6\xb4", [0x7575] = "\xf6\xb5",
  [0x7576] = "\xf6\xb6", [0x7577] = "\xf6\xb7", [0x7578] = "\xf6\xb8",
  [0x7579] = "\xf6\xb9", [0x757a] = "\xf6\xba", [0x757b] = "\xf6\xbb",
  [0x757c] = "\xf6\xbc", [0x757d] = "\xf6\xbd", [0x757e] = "\xf6\xbe",
  [0x757f] = "\xf6\xbf", [0x7580] = "\xf6\xc0", [0x7581] = "\xf6\xc1",
  [0x7582] = "\xf6\xc2", [0x7583] = "\xf6\xc3", [0x7584] = "\xf6\xc4",
  [0x7585] = "\xf6\xc5", [0x7586] = "\xf6\xc6", [0x7587] = "\xf6\xc7",
  [0x7588] = "\xf6\xc8", [0x7589] = "\xf6\xc9", [0x758a] = "\xf6\xca",
  [0x758b] = "\xf6\xcb", [0x758c] = "\xf6\xcc", [0x758d] = "\xf6\xcd",
  [0x758e] = "\xf6\xce", [0x758f] = "\xf6\xcf", [0x7590] = "\xf6\xd0",
  [0x7591] = "\xf6\xd1", [0x7592] = "\xf6\xd2", [0x7593] = "\xf6\xd3",
  [0x7594] = "\xf6\xd4", [0x7595] = "\xf6\xd5", [0x7596] = "\xf6\xd6",
  [0x7597] = "\xf6\xd7", [0x7598] = "\xf6\xd8", [0x7599] = "\xf6\xd9",
  [0x759a] = "\xf6\xda", [0x759b] = "\xf6\xdb", [0x759c] = "\xf6\xdc",
  [0x759d] = "\xf6\xdd", [0x759e] = "\xf6\xde", [0x759f] = "\xf6\xdf",
  [0x75a0] = "\xf6\xe0", [0x75a1] = "\xf6\xe1", [0x75a2] = "\xf6\xe2",
  [0x75a3] = "\xf6\xe3", [0x75a4] = "\xf6\xe4", [0x75a5] = "\xf6\xe5",
  [0x75a6] = "\xf6\xe6", [0x75a7] = "\xf6\xe7", [0x75a8] = "\xf6\xe8",
  [0x75a9] = "\xf6\xe9", [0x75aa] = "\xf6\xea", [0x75ab] = "\xf6\xeb",
  [0x75ac] = "\xf6\xec", [0x75ad] = "\xf6\xed", [0x75ae] = "\xf6\xee",
  [0x75af] = "\xf6\xef", [0x75b0] = "\xf6\xf0", [0x75b1] = "\xf6\xf1",
  [0x75b2] = "\xf6\xf2", [0x75b3] = "\xf6\xf3", [0x75b4] = "\xf6\xf4",
  [0x75b5] = "\xf6\xf5", [0x75b6] = "\xf6\xf6", [0x75b7] = "\xf6\xf7",
  [0x75b8] = "\xf6\xf8", [0x75b9] = "\xf6\xf9", [0x75ba] = "\xf6\xfa",
  [0x75bb] = "\xf6\xfb", [0x75bc] = "\xf6\xfc", [0x75bd] = "\xf6\xfd",
  [0x75be] = "\xf6\xfe", [0x7600] = "\xf7\x40", [0x7601] = "\xf7\x41",
  [0x7602] = "\xf7\x42", [0x7603] = "\xf7\x43", [0x7604] = "\xf7\x44",
  [0x7605] = "\xf7\x45", [0x7606] = "\xf7\x46", [0x7607] = "\xf7\x47",
  [0x7608] = "\xf7\x48", [0x7609] = "\xf7\x49", [0x760a] = "\xf7\x4a",
  [0x760b] = "\xf7\x4b", [0x760c] = "\xf7\x4c", [0x760d] = "\xf7\x4d",
  [0x760e] = "\xf7\x4e", [0x760f] = "\xf7\x4f", [0x7610] = "\xf7\x50",
  [0x7611] = "\xf7\x51", [0x7612] = "\xf7\x52", [0x7613] = "\xf7\x53",
  [0x7614] = "\xf7\x54", [0x7615] = "\xf7\x55", [0x7616] = "\xf7\x56",
  [0x7617] = "\xf7\x57", [0x7618] = "\xf7\x58", [0x7619] = "\xf7\x59",
  [0x761a] = "\xf7\x5a", [0x761b] = "\xf7\x5b", [0x761c] = "\xf7\x5c",
  [0x761d] = "\xf7\x5d", [0x761e] = "\xf7\x5e", [0x761f] = "\xf7\x5f",
  [0x7620] = "\xf7\x60", [0x7621] = "\xf7\x61", [0x7622] = "\xf7\x62",
  [0x7623] = "\xf7\x63", [0x7624] = "\xf7\x64", [0x7625] = "\xf7\x65",
  [0x7626] = "\xf7\x66", [0x7627] = "\xf7\x67", [0x7628] = "\xf7\x68",
  [0x7629] = "\xf7\x69", [0x762a] = "\xf7\x6a", [0x762b] = "\xf7\x6b",
  [0x762c] = "\xf7\x6c", [0x762d] = "\xf7\x6d", [0x762e] = "\xf7\x6e",
  [0x762f] = "\xf7\x6f", [0x7630] = "\xf7\x70", [0x7631] = "\xf7\x71",
  [0x7632] = "\xf7\x72", [0x7633] = "\xf7\x73", [0x7634] = "\xf7\x74",
  [0x7635] = "\xf7\x75", [0x7636] = "\xf7\x76", [0x7637] = "\xf7\x77",
  [0x7638] = "\xf7\x78", [0x7639] = "\xf7\x79", [0x763a] = "\xf7\x7a",
  [0x763b] = "\xf7\x7b", [0x763c] = "\xf7\x7c", [0x763d] = "\xf7\x7d",
  [0x763e] = "\xf7\x7e", [0x7640] = "\xf7\x80", [0x7641] = "\xf7\x81",
  [0x7642] = "\xf7\x82", [0x7643] = "\xf7\x83", [0x7644] = "\xf7\x84",
  [0x7645] = "\xf7\x85", [0x7646] = "\xf7\x86", [0x7647] = "\xf7\x87",
  [0x7648] = "\xf7\x88", [0x7649] = "\xf7\x89", [0x764a] = "\xf7\x8a",
  [0x764b] = "\xf7\x8b", [0x764c] = "\xf7\x8c", [0x764d] = "\xf7\x8d",
  [0x764e] = "\xf7\x8e", [0x764f] = "\xf7\x8f", [0x7650] = "\xf7\x90",
  [0x7651] = "\xf7\x91", [0x7652] = "\xf7\x92", [0x7653] = "\xf7\x93",
  [0x7654] = "\xf7\x94", [0x7655] = "\xf7\x95", [0x7656] = "\xf7\x96",
  [0x7657] = "\xf7\x97", [0x7658] = "\xf7\x98", [0x7659] = "\xf7\x99",
  [0x765a] = "\xf7\x9a", [0x765b] = "\xf7\x9b", [0x765c] = "\xf7\x9c",
  [0x765d] = "\xf7\x9d", [0x765e] = "\xf7\x9e", [0x765f] = "\xf7\x9f",
  [0x7660] = "\xf7\xa0", [0x7661] = "\xf7\xa1", [0x7662] = "\xf7\xa2",
  [0x7663] = "\xf7\xa3", [0x7664] = "\xf7\xa4", [0x7665] = "\xf7\xa5",
  [0x7666] = "\xf7\xa6", [0x7667] = "\xf7\xa7", [0x7668] = "\xf7\xa8",
  [0x7669] = "\xf7\xa9", [0x766a] = "\xf7\xaa", [0x766b] = "\xf7\xab",
  [0x766c] = "\xf7\xac", [0x766d] = "\xf7\xad", [0x766e] = "\xf7\xae",
  [0x766f] = "\xf7\xaf", [0x7670] = "\xf7\xb0", [0x7671] = "\xf7\xb1",
  [0x7672] = "\xf7\xb2", [0x7673] = "\xf7\xb3", [0x7674] = "\xf7\xb4",
  [0x7675] = "\xf7\xb5", [0x7676] = "\xf7\xb6", [0x7677] = "\xf7\xb7",
  [0x7678] = "\xf7\xb8", [0x7679] = "\xf7\xb9", [0x767a] = "\xf7\xba",
  [0x767b] = "\xf7\xbb", [0x767c] = "\xf7\xbc", [0x767d] = "\xf7\xbd",
  [0x767e] = "\xf7\xbe", [0x767f] = "\xf7\xbf", [0x7680] = "\xf7\xc0",
  [0x7681] = "\xf7\xc1", [0x7682] = "\xf7\xc2", [0x7683] = "\xf7\xc3",
  [0x7684] = "\xf7\xc4", [0x7685] = "\xf7\xc5", [0x7686] = "\xf7\xc6",
  [0x7687] = "\xf7\xc7", [0x7688] = "\xf7\xc8", [0x7689] = "\xf7\xc9",
  [0x768a] = "\xf7\xca", [0x768b] = "\xf7\xcb", [0x768c] = "\xf7\xcc",
  [0x768d] = "\xf7\xcd", [0x768e] = "\xf7\xce", [0x768f] = "\xf7\xcf",
  [0x7690] = "\xf7\xd0", [0x7691] = "\xf7\xd1", [0x7692] = "\xf7\xd2",
  [0x7693] = "\xf7\xd3", [0x7694] = "\xf7\xd4", [0x7695] = "\xf7\xd5",
  [0x7696] = "\xf7\xd6", [0x7697] = "\xf7\xd7", [0x7698] = "\xf7\xd8",
  [0x7699] = "\xf7\xd9", [0x769a] = "\xf7\xda", [0x769b] = "\xf7\xdb",
  [0x769c] = "\xf7\xdc", [0x769d] = "\xf7\xdd", [0x769e] = "\xf7\xde",
  [0x769f] = "\xf7\xdf", [0x76a0] = "\xf7\xe0", [0x76a1] = "\xf7\xe1",
  [0x76a2] = "\xf7\xe2", [0x76a3] = "\xf7\xe3", [0x76a4] = "\xf7\xe4",
  [0x76a5] = "\xf7\xe5", [0x76a6] = "\xf7\xe6", [0x76a7] = "\xf7\xe7",
  [0x76a8] = "\xf7\xe8", [0x76a9] = "\xf7\xe9", [0x76aa] = "\xf7\xea",
  [0x76ab] = "\xf7\xeb", [0x76ac] = "\xf7\xec", [0x76ad] = "\xf7\xed",
  [0x76ae] = "\xf7\xee", [0x76af] = "\xf7\xef", [0x76b0] = "\xf7\xf0",
  [0x76b1] = "\xf7\xf1", [0x76b2] = "\xf7\xf2", [0x76b3] = "\xf7\xf3",
  [0x76b4] = "\xf7\xf4", [0x76b5] = "\xf7\xf5", [0x76b6] = "\xf7\xf6",
  [0x76b7] = "\xf7\xf7", [0x76b8] = "\xf7\xf8", [0x76b9] = "\xf7\xf9",
  [0x76ba] = "\xf7\xfa", [0x76bb] = "\xf7\xfb", [0x76bc] = "\xf7\xfc",
  [0x76bd] = "\xf7\xfd", [0x76be] = "\xf7\xfe", [0x7700] = "\xf8\x40",
  [0x7701] = "\xf8\x41", [0x7702] = "\xf8\x42", [0x7703] = "\xf8\x43",
  [0x7704] = "\xf8\x44", [0x7705] = "\xf8\x45", [0x7706] = "\xf8\x46",
  [0x7707] = "\xf8\x47", [0x7708] = "\xf8\x48", [0x7709] = "\xf8\x49",
  [0x770a] = "\xf8\x4a", [0x770b] = "\xf8\x4b", [0x770c] = "\xf8\x4c",
  [0x770d] = "\xf8\x4d", [0x770e] = "\xf8\x4e", [0x770f] = "\xf8\x4f",
  [0x7710] = "\xf8\x50", [0x7711] = "\xf8\x51", [0x7712] = "\xf8\x52",
  [0x7713] = "\xf8\x53", [0x7714] = "\xf8\x54", [0x7715] = "\xf8\x55",
  [0x7716] = "\xf8\x56", [0x7717] = "\xf8\x57", [0x7718] = "\xf8\x58",
  [0x7719] = "\xf8\x59", [0x771a] = "\xf8\x5a", [0x771b] = "\xf8\x5b",
  [0x771c] = "\xf8\x5c", [0x771d] = "\xf8\x5d", [0x771e] = "\xf8\x5e",
  [0x771f] = "\xf8\x5f", [0x7720] = "\xf8\x60", [0x7721] = "\xf8\x61",
  [0x7722] = "\xf8\x62", [0x7723] = "\xf8\x63", [0x7724] = "\xf8\x64",
  [0x7725] = "\xf8\x65", [0x7726] = "\xf8\x66", [0x7727] = "\xf8\x67",
  [0x7728] = "\xf8\x68", [0x7729] = "\xf8\x69", [0x772a] = "\xf8\x6a",
  [0x772b] = "\xf8\x6b", [0x772c] = "\xf8\x6c", [0x772d] = "\xf8\x6d",
  [0x772e] = "\xf8\x6e", [0x772f] = "\xf8\x6f", [0x7730] = "\xf8\x70",
  [0x7731] = "\xf8\x71", [0x7732] = "\xf8\x72", [0x7733] = "\xf8\x73",
  [0x7734] = "\xf8\x74", [0x7735] = "\xf8\x75", [0x7736] = "\xf8\x76",
  [0x7737] = "\xf8\x77", [0x7738] = "\xf8\x78", [0x7739] = "\xf8\x79",
  [0x773a] = "\xf8\x7a", [0x773b] = "\xf8\x7b", [0x773c] = "\xf8\x7c",
  [0x773d] = "\xf8\x7d", [0x773e] = "\xf8\x7e", [0x7740] = "\xf8\x80",
  [0x7741] = "\xf8\x81", [0x7742] = "\xf8\x82", [0x7743] = "\xf8\x83",
  [0x7744] = "\xf8\x84", [0x7745] = "\xf8\x85", [0x7746] = "\xf8\x86",
  [0x7747] = "\xf8\x87", [0x7748] = "\xf8\x88", [0x7749] = "\xf8\x89",
  [0x774a] = "\xf8\x8a", [0x774b] = "\xf8\x8b", [0x774c] = "\xf8\x8c",
  [0x774d] = "\xf8\x8d", [0x774e] = "\xf8\x8e", [0x774f] = "\xf8\x8f",
  [0x7750] = "\xf8\x90", [0x7751] = "\xf8\x91", [0x7752] = "\xf8\x92",
  [0x7753] = "\xf8\x93", [0x7754] = "\xf8\x94", [0x7755] = "\xf8\x95",
  [0x7756] = "\xf8\x96", [0x7757] = "\xf8\x97", [0x7758] = "\xf8\x98",
  [0x7759] = "\xf8\x99", [0x775a] = "\xf8\x9a", [0x775b] = "\xf8\x9b",
  [0x775c] = "\xf8\x9c", [0x775d] = "\xf8\x9d", [0x775e] = "\xf8\x9e",
  [0x775f] = "\xf8\x9f", [0x7760] = "\xf8\xa0", [0x7761] = "\xf8\xa1",
  [0x7762] = "\xf8\xa2", [0x7763] = "\xf8\xa3", [0x7764] = "\xf8\xa4",
  [0x7765] = "\xf8\xa5", [0x7766] = "\xf8\xa6", [0x7767] = "\xf8\xa7",
  [0x7768] = "\xf8\xa8", [0x7769] = "\xf8\xa9", [0x776a] = "\xf8\xaa",
  [0x776b] = "\xf8\xab", [0x776c] = "\xf8\xac", [0x776d] = "\xf8\xad",
  [0x776e] = "\xf8\xae", [0x776f] = "\xf8\xaf", [0x7770] = "\xf8\xb0",
  [0x7771] = "\xf8\xb1", [0x7772] = "\xf8\xb2", [0x7773] = "\xf8\xb3",
  [0x7774] = "\xf8\xb4", [0x7775] = "\xf8\xb5", [0x7776] = "\xf8\xb6",
  [0x7777] = "\xf8\xb7", [0x7778] = "\xf8\xb8", [0x7779] = "\xf8\xb9",
  [0x777a] = "\xf8\xba", [0x777b] = "\xf8\xbb", [0x777c] = "\xf8\xbc",
  [0x777d] = "\xf8\xbd", [0x777e] = "\xf8\xbe", [0x777f] = "\xf8\xbf",
  [0x7780] = "\xf8\xc0", [0x7781] = "\xf8\xc1", [0x7782] = "\xf8\xc2",
  [0x7783] = "\xf8\xc3", [0x7784] = "\xf8\xc4", [0x7785] = "\xf8\xc5",
  [0x7786] = "\xf8\xc6", [0x7787] = "\xf8\xc7", [0x7788] = "\xf8\xc8",
  [0x7789] = "\xf8\xc9", [0x778a] = "\xf8\xca", [0x778b] = "\xf8\xcb",
  [0x778c] = "\xf8\xcc", [0x778d] = "\xf8\xcd", [0x778e] = "\xf8\xce",
  [0x778f] = "\xf8\xcf", [0x7790] = "\xf8\xd0", [0x7791] = "\xf8\xd1",
  [0x7792] = "\xf8\xd2", [0x7793] = "\xf8\xd3", [0x7794] = "\xf8\xd4",
  [0x7795] = "\xf8\xd5", [0x7796] = "\xf8\xd6", [0x7797] = "\xf8\xd7",
  [0x7798] = "\xf8\xd8", [0x7799] = "\xf8\xd9", [0x779a] = "\xf8\xda",
  [0x779b] = "\xf8\xdb", [0x779c] = "\xf8\xdc", [0x779d] = "\xf8\xdd",
  [0x779e] = "\xf8\xde", [0x779f] = "\xf8\xdf", [0x77a0] = "\xf8\xe0",
  [0x77a1] = "\xf8\xe1", [0x77a2] = "\xf8\xe2", [0x77a3] = "\xf8\xe3",
  [0x77a4] = "\xf8\xe4", [0x77a5] = "\xf8\xe5", [0x77a6] = "\xf8\xe6",
  [0x77a7] = "\xf8\xe7", [0x77a8] = "\xf8\xe8", [0x77a9] = "\xf8\xe9",
  [0x77aa] = "\xf8\xea", [0x77ab] = "\xf8\xeb", [0x77ac] = "\xf8\xec",
  [0x77ad] = "\xf8\xed", [0x77ae] = "\xf8\xee", [0x77af] = "\xf8\xef",
  [0x77b0] = "\xf8\xf0", [0x77b1] = "\xf8\xf1", [0x77b2] = "\xf8\xf2",
  [0x77b3] = "\xf8\xf3", [0x77b4] = "\xf8\xf4", [0x77b5] = "\xf8\xf5",
  [0x77b6] = "\xf8\xf6", [0x77b7] = "\xf8\xf7", [0x77b8] = "\xf8\xf8",
  [0x77b9] = "\xf8\xf9", [0x77ba] = "\xf8\xfa", [0x77bb] = "\xf8\xfb",
  [0x77bc] = "\xf8\xfc", [0x77bd] = "\xf8\xfd", [0x77be] = "\xf8\xfe",
  [0x7800] = "\xf9\x40", [0x7801] = "\xf9\x41", [0x7802] = "\xf9\x42",
  [0x7803] = "\xf9\x43", [0x7804] = "\xf9\x44", [0x7805] = "\xf9\x45",
  [0x7806] = "\xf9\x46", [0x7807] = "\xf9\x47", [0x7808] = "\xf9\x48",
  [0x7809] = "\xf9\x49", [0x780a] = "\xf9\x4a", [0x780b] = "\xf9\x4b",
  [0x780c] = "\xf9\x4c", [0x780d] = "\xf9\x4d", [0x780e] = "\xf9\x4e",
  [0x780f] = "\xf9\x4f", [0x7810] = "\xf9\x50", [0x7811] = "\xf9\x51",
  [0x7812] = "\xf9\x52", [0x7813] = "\xf9\x53", [0x7814] = "\xf9\x54",
  [0x7815] = "\xf9\x55", [0x7816] = "\xf9\x56", [0x7817] = "\xf9\x57",
  [0x7818] = "\xf9\x58", [0x7819] = "\xf9\x59", [0x781a] = "\xf9\x5a",
  [0x781b] = "\xf9\x5b", [0x781c] = "\xf9\x5c", [0x781d] = "\xf9\x5d",
  [0x781e] = "\xf9\x5e", [0x781f] = "\xf9\x5f", [0x7820] = "\xf9\x60",
  [0x7821] = "\xf9\x61", [0x7822] = "\xf9\x62", [0x7823] = "\xf9\x63",
  [0x7824] = "\xf9\x64", [0x7825] = "\xf9\x65", [0x7826] = "\xf9\x66",
  [0x7827] = "\xf9\x67", [0x7828] = "\xf9\x68", [0x7829] = "\xf9\x69",
  [0x782a] = "\xf9\x6a", [0x782b] = "\xf9\x6b", [0x782c] = "\xf9\x6c",
  [0x782d] = "\xf9\x6d", [0x782e] = "\xf9\x6e", [0x782f] = "\xf9\x6f",
  [0x7830] = "\xf9\x70", [0x7831] = "\xf9\x71", [0x7832] = "\xf9\x72",
  [0x7833] = "\xf9\x73", [0x7834] = "\xf9\x74", [0x7835] = "\xf9\x75",
  [0x7836] = "\xf9\x76", [0x7837] = "\xf9\x77", [0x7838] = "\xf9\x78",
  [0x7839] = "\xf9\x79", [0x783a] = "\xf9\x7a", [0x783b] = "\xf9\x7b",
  [0x783c] = "\xf9\x7c", [0x783d] = "\xf9\x7d", [0x783e] = "\xf9\x7e",
  [0x7840] = "\xf9\x80", [0x7841] = "\xf9\x81", [0x7842] = "\xf9\x82",
  [0x7843] = "\xf9\x83", [0x7844] = "\xf9\x84", [0x7845] = "\xf9\x85",
  [0x7846] = "\xf9\x86", [0x7847] = "\xf9\x87", [0x7848] = "\xf9\x88",
  [0x7849] = "\xf9\x89", [0x784a] = "\xf9\x8a", [0x784b] = "\xf9\x8b",
  [0x784c] = "\xf9\x8c", [0x784d] = "\xf9\x8d", [0x784e] = "\xf9\x8e",
  [0x784f] = "\xf9\x8f", [0x7850] = "\xf9\x90", [0x7851] = "\xf9\x91",
  [0x7852] = "\xf9\x92", [0x7853] = "\xf9\x93", [0x7854] = "\xf9\x94",
  [0x7855] = "\xf9\x95", [0x7856] = "\xf9\x96", [0x7857] = "\xf9\x97",
  [0x7858] = "\xf9\x98", [0x7859] = "\xf9\x99", [0x785a] = "\xf9\x9a",
  [0x785b] = "\xf9\x9b", [0x785c] = "\xf9\x9c", [0x785d] = "\xf9\x9d",
  [0x785e] = "\xf9\x9e", [0x785f] = "\xf9\x9f", [0x7860] = "\xf9\xa0",
  [0x7861] = "\xf9\xa1", [0x7862] = "\xf9\xa2", [0x7863] = "\xf9\xa3",
  [0x7864] = "\xf9\xa4", [0x7865] = "\xf9\xa5", [0x7866] = "\xf9\xa6",
  [0x7867] = "\xf9\xa7", [0x7868] = "\xf9\xa8", [0x7869] = "\xf9\xa9",
  [0x786a] = "\xf9\xaa", [0x786b] = "\xf9\xab", [0x786c] = "\xf9\xac",
  [0x786d] = "\xf9\xad", [0x786e] = "\xf9\xae", [0x786f] = "\xf9\xaf",
  [0x7870] = "\xf9\xb0", [0x7871] = "\xf9\xb1", [0x7872] = "\xf9\xb2",
  [0x7873] = "\xf9\xb3", [0x7874] = "\xf9\xb4", [0x7875] = "\xf9\xb5",
  [0x7876] = "\xf9\xb6", [0x7877] = "\xf9\xb7", [0x7878] = "\xf9\xb8",
  [0x7879] = "\xf9\xb9", [0x787a] = "\xf9\xba", [0x787b] = "\xf9\xbb",
  [0x787c] = "\xf9\xbc", [0x787d] = "\xf9\xbd", [0x787e] = "\xf9\xbe",
  [0x787f] = "\xf9\xbf", [0x7880] = "\xf9\xc0", [0x7881] = "\xf9\xc1",
  [0x7882] = "\xf9\xc2", [0x7883] = "\xf9\xc3", [0x7884] = "\xf9\xc4",
  [0x7885] = "\xf9\xc5", [0x7886] = "\xf9\xc6", [0x7887] = "\xf9\xc7",
  [0x7888] = "\xf9\xc8", [0x7889] = "\xf9\xc9", [0x788a] = "\xf9\xca",
  [0x788b] = "\xf9\xcb", [0x788c] = "\xf9\xcc", [0x788d] = "\xf9\xcd",
  [0x788e] = "\xf9\xce", [0x788f] = "\xf9\xcf", [0x7890] = "\xf9\xd0",
  [0x7891] = "\xf9\xd1", [0x7892] = "\xf9\xd2", [0x7893] = "\xf9\xd3",
  [0x7894] = "\xf9\xd4", [0x7895] = "\xf9\xd5", [0x7896] = "\xf9\xd6",
  [0x7897] = "\xf9\xd7", [0x7898] = "\xf9\xd8", [0x7899] = "\xf9\xd9",
  [0x789a] = "\xf9\xda", [0x789b] = "\xf9\xdb", [0x789c] = "\xf9\xdc",
  [0x789d] = "\xf9\xdd", [0x789e] = "\xf9\xde", [0x789f] = "\xf9\xdf",
  [0x78a0] = "\xf9\xe0", [0x78a1] = "\xf9\xe1", [0x78a2] = "\xf9\xe2",
  [0x78a3] = "\xf9\xe3", [0x78a4] = "\xf9\xe4", [0x78a5] = "\xf9\xe5",
  [0x78a6] = "\xf9\xe6", [0x78a7] = "\xf9\xe7", [0x78a8] = "\xf9\xe8",
  [0x78a9] = "\xf9\xe9", [0x78aa] = "\xf9\xea", [0x78ab] = "\xf9\xeb",
  [0x78ac] = "\xf9\xec", [0x78ad] = "\xf9\xed", [0x78ae] = "\xf9\xee",
  [0x78af] = "\xf9\xef", [0x78b0] = "\xf9\xf0", [0x78b1] = "\xf9\xf1",
  [0x78b2] = "\xf9\xf2", [0x78b3] = "\xf9\xf3", [0x78b4] = "\xf9\xf4",
  [0x78b5] = "\xf9\xf5", [0x78b6] = "\xf9\xf6", [0x78b7] = "\xf9\xf7",
  [0x78b8] = "\xf9\xf8", [0x78b9] = "\xf9\xf9", [0x78ba] = "\xf9\xfa",
  [0x78bb] = "\xf9\xfb", [0x78bc] = "\xf9\xfc", [0x78bd] = "\xf9\xfd",
  [0x78be] = "\xf9\xfe", [0x7900] = "\xfa\x40", [0x7901] = "\xfa\x41",
  [0x7902] = "\xfa\x42", [0x7903] = "\xfa\x43", [0x7904] = "\xfa\x44",
  [0x7905] = "\xfa\x45", [0x7906] = "\xfa\x46", [0x7907] = "\xfa\x47",
  [0x7908] = "\xfa\x48", [0x7909] = "\xfa\x49", [0x790a] = "\xfa\x4a",
  [0x790b] = "\xfa\x4b", [0x790c] = "\xfa\x4c", [0x790d] = "\xfa\x4d",
  [0x790e] = "\xfa\x4e", [0x790f] = "\xfa\x4f", [0x7910] = "\xfa\x50",
  [0x7911] = "\xfa\x51", [0x7912] = "\xfa\x52", [0x7913] = "\xfa\x53",
  [0x7914] = "\xfa\x54", [0x7915] = "\xfa\x55", [0x7916] = "\xfa\x56",
  [0x7917] = "\xfa\x57", [0x7918] = "\xfa\x58", [0x7919] = "\xfa\x59",
  [0x791a] = "\xfa\x5a", [0x791b] = "\xfa\x5b", [0x791c] = "\xfa\x5c",
  [0x791d] = "\xfa\x5d", [0x791e] = "\xfa\x5e", [0x791f] = "\xfa\x5f",
  [0x7920] = "\xfa\x60", [0x7921] = "\xfa\x61", [0x7922] = "\xfa\x62",
  [0x7923] = "\xfa\x63", [0x7924] = "\xfa\x64", [0x7925] = "\xfa\x65",
  [0x7926] = "\xfa\x66", [0x7927] = "\xfa\x67", [0x7928] = "\xfa\x68",
  [0x7929] = "\xfa\x69", [0x792a] = "\xfa\x6a", [0x792b] = "\xfa\x6b",
  [0x792c] = "\xfa\x6c", [0x792d] = "\xfa\x6d", [0x792e] = "\xfa\x6e",
  [0x792f] = "\xfa\x6f", [0x7930] = "\xfa\x70", [0x7931] = "\xfa\x71",
  [0x7932] = "\xfa\x72", [0x7933] = "\xfa\x73", [0x7934] = "\xfa\x74",
  [0x7935] = "\xfa\x75", [0x7936] = "\xfa\x76", [0x7937] = "\xfa\x77",
  [0x7938] = "\xfa\x78", [0x7939] = "\xfa\x79", [0x793a] = "\xfa\x7a",
  [0x793b] = "\xfa\x7b", [0x793c] = "\xfa\x7c", [0x793d] = "\xfa\x7d",
  [0x793e] = "\xfa\x7e", [0x7940] = "\xfa\x80", [0x7941] = "\xfa\x81",
  [0x7942] = "\xfa\x82", [0x7943] = "\xfa\x83", [0x7944] = "\xfa\x84",
  [0x7945] = "\xfa\x85", [0x7946] = "\xfa\x86", [0x7947] = "\xfa\x87",
  [0x7948] = "\xfa\x88", [0x7949] = "\xfa\x89", [0x794a] = "\xfa\x8a",
  [0x794b] = "\xfa\x8b", [0x794c] = "\xfa\x8c", [0x794d] = "\xfa\x8d",
  [0x794e] = "\xfa\x8e", [0x794f] = "\xfa\x8f", [0x7950] = "\xfa\x90",
  [0x7951] = "\xfa\x91", [0x7952] = "\xfa\x92", [0x7953] = "\xfa\x93",
  [0x7954] = "\xfa\x94", [0x7955] = "\xfa\x95", [0x7956] = "\xfa\x96",
  [0x7957] = "\xfa\x97", [0x7958] = "\xfa\x98", [0x7959] = "\xfa\x99",
  [0x795a] = "\xfa\x9a", [0x795b] = "\xfa\x9b", [0x795c] = "\xfa\x9c",
  [0x795d] = "\xfa\x9d", [0x795e] = "\xfa\x9e", [0x795f] = "\xfa\x9f",
  [0x7960] = "\xfa\xa0", [0x7961] = "\xfa\xa1", [0x7962] = "\xfa\xa2",
  [0x7963] = "\xfa\xa3", [0x7964] = "\xfa\xa4", [0x7965] = "\xfa\xa5",
  [0x7966] = "\xfa\xa6", [0x7967] = "\xfa\xa7", [0x7968] = "\xfa\xa8",
  [0x7969] = "\xfa\xa9", [0x796a] = "\xfa\xaa", [0x796b] = "\xfa\xab",
  [0x796c] = "\xfa\xac", [0x796d] = "\xfa\xad", [0x796e] = "\xfa\xae",
  [0x796f] = "\xfa\xaf", [0x7970] = "\xfa\xb0", [0x7971] = "\xfa\xb1",
  [0x7972] = "\xfa\xb2", [0x7973] = "\xfa\xb3", [0x7974] = "\xfa\xb4",
  [0x7975] = "\xfa\xb5", [0x7976] = "\xfa\xb6", [0x7977] = "\xfa\xb7",
  [0x7978] = "\xfa\xb8", [0x7979] = "\xfa\xb9", [0x797a] = "\xfa\xba",
  [0x797b] = "\xfa\xbb", [0x797c] = "\xfa\xbc", [0x797d] = "\xfa\xbd",
  [0x797e] = "\xfa\xbe", [0x797f] = "\xfa\xbf", [0x7980] = "\xfa\xc0",
  [0x7981] = "\xfa\xc1", [0x7982] = "\xfa\xc2", [0x7983] = "\xfa\xc3",
  [0x7984] = "\xfa\xc4", [0x7985] = "\xfa\xc5", [0x7986] = "\xfa\xc6",
  [0x7987] = "\xfa\xc7", [0x7988] = "\xfa\xc8", [0x7989] = "\xfa\xc9",
  [0x798a] = "\xfa\xca", [0x798b] = "\xfa\xcb", [0x798c] = "\xfa\xcc",
  [0x798d] = "\xfa\xcd", [0x798e] = "\xfa\xce", [0x798f] = "\xfa\xcf",
  [0x7990] = "\xfa\xd0", [0x7991] = "\xfa\xd1", [0x7992] = "\xfa\xd2",
  [0x7993] = "\xfa\xd3", [0x7994] = "\xfa\xd4", [0x7995] = "\xfa\xd5",
  [0x7996] = "\xfa\xd6", [0x7997] = "\xfa\xd7", [0x7998] = "\xfa\xd8",
  [0x7999] = "\xfa\xd9", [0x799a] = "\xfa\xda", [0x799b] = "\xfa\xdb",
  [0x799c] = "\xfa\xdc", [0x799d] = "\xfa\xdd", [0x799e] = "\xfa\xde",
  [0x799f] = "\xfa\xdf", [0x79a0] = "\xfa\xe0", [0x79a1] = "\xfa\xe1",
  [0x79a2] = "\xfa\xe2", [0x79a3] = "\xfa\xe3", [0x79a4] = "\xfa\xe4",
  [0x79a5] = "\xfa\xe5", [0x79a6] = "\xfa\xe6", [0x79a7] = "\xfa\xe7",
  [0x79a8] = "\xfa\xe8", [0x79a9] = "\xfa\xe9", [0x79aa] = "\xfa\xea",
  [0x79ab] = "\xfa\xeb", [0x79ac] = "\xfa\xec", [0x79ad] = "\xfa\xed",
  [0x79ae] = "\xfa\xee", [0x79af] = "\xfa\xef", [0x79b0] = "\xfa\xf0",
  [0x79b1] = "\xfa\xf1", [0x79b2] = "\xfa\xf2", [0x79b3] = "\xfa\xf3",
  [0x79b4] = "\xfa\xf4", [0x79b5] = "\xfa\xf5", [0x79b6] = "\xfa\xf6",
  [0x79b7] = "\xfa\xf7", [0x79b8] = "\xfa\xf8", [0x79b9] = "\xfa\xf9",
  [0x79ba] = "\xfa\xfa", [0x79bb] = "\xfa\xfb", [0x79bc] = "\xfa\xfc",
  [0x79bd] = "\xfa\xfd", [0x79be] = "\xfa\xfe", [0x7a00] = "\xfb\x40",
  [0x7a01] = "\xfb\x41", [0x7a02] = "\xfb\x42", [0x7a03] = "\xfb\x43",
  [0x7a04] = "\xfb\x44", [0x7a05] = "\xfb\x45", [0x7a06] = "\xfb\x46",
  [0x7a07] = "\xfb\x47", [0x7a08] = "\xfb\x48", [0x7a09] = "\xfb\x49",
  [0x7a0a] = "\xfb\x4a", [0x7a0b] = "\xfb\x4b", [0x7a0c] = "\xfb\x4c",
  [0x7a0d] = "\xfb\x4d", [0x7a0e] = "\xfb\x4e", [0x7a0f] = "\xfb\x4f",
  [0x7a10] = "\xfb\x50", [0x7a11] = "\xfb\x51", [0x7a12] = "\xfb\x52",
  [0x7a13] = "\xfb\x53", [0x7a14] = "\xfb\x54", [0x7a15] = "\xfb\x55",
  [0x7a16] = "\xfb\x56", [0x7a17] = "\xfb\x57", [0x7a18] = "\xfb\x58",
  [0x7a19] = "\xfb\x59", [0x7a1a] = "\xfb\x5a", [0x7a1b] = "\xfb\x5b",
  [0x7a1c] = "\xfb\x5c", [0x7a1d] = "\xfb\x5d", [0x7a1e] = "\xfb\x5e",
  [0x7a1f] = "\xfb\x5f", [0x7a20] = "\xfb\x60", [0x7a21] = "\xfb\x61",
  [0x7a22] = "\xfb\x62", [0x7a23] = "\xfb\x63", [0x7a24] = "\xfb\x64",
  [0x7a25] = "\xfb\x65", [0x7a26] = "\xfb\x66", [0x7a27] = "\xfb\x67",
  [0x7a28] = "\xfb\x68", [0x7a29] = "\xfb\x69", [0x7a2a] = "\xfb\x6a",
  [0x7a2b] = "\xfb\x6b", [0x7a2c] = "\xfb\x6c", [0x7a2d] = "\xfb\x6d",
  [0x7a2e] = "\xfb\x6e", [0x7a2f] = "\xfb\x6f", [0x7a30] = "\xfb\x70",
  [0x7a31] = "\xfb\x71", [0x7a32] = "\xfb\x72", [0x7a33] = "\xfb\x73",
  [0x7a34] = "\xfb\x74", [0x7a35] = "\xfb\x75", [0x7a36] = "\xfb\x76",
  [0x7a37] = "\xfb\x77", [0x7a38] = "\xfb\x78", [0x7a39] = "\xfb\x79",
  [0x7a3a] = "\xfb\x7a", [0x7a3b] = "\xfb\x7b", [0x7a3c] = "\xfb\x7c",
  [0x7a3d] = "\xfb\x7d", [0x7a3e] = "\xfb\x7e", [0x7a40] = "\xfb\x80",
  [0x7a41] = "\xfb\x81", [0x7a42] = "\xfb\x82", [0x7a43] = "\xfb\x83",
  [0x7a44] = "\xfb\x84", [0x7a45] = "\xfb\x85", [0x7a46] = "\xfb\x86",
  [0x7a47] = "\xfb\x87", [0x7a48] = "\xfb\x88", [0x7a49] = "\xfb\x89",
  [0x7a4a] = "\xfb\x8a", [0x7a4b] = "\xfb\x8b", [0x7a4c] = "\xfb\x8c",
  [0x7a4d] = "\xfb\x8d", [0x7a4e] = "\xfb\x8e", [0x7a4f] = "\xfb\x8f",
  [0x7a50] = "\xfb\x90", [0x7a51] = "\xfb\x91", [0x7a52] = "\xfb\x92",
  [0x7a53] = "\xfb\x93", [0x7a54] = "\xfb\x94", [0x7a55] = "\xfb\x95",
  [0x7a56] = "\xfb\x96", [0x7a57] = "\xfb\x97", [0x7a58] = "\xfb\x98",
  [0x7a59] = "\xfb\x99", [0x7a5a] = "\xfb\x9a", [0x7a5b] = "\xfb\x9b",
  [0x7a5c] = "\xfb\x9c", [0x7a5d] = "\xfb\x9d", [0x7a5e] = "\xfb\x9e",
  [0x7a5f] = "\xfb\x9f", [0x7a60] = "\xfb\xa0", [0x7a61] = "\xfb\xa1",
  [0x7a62] = "\xfb\xa2", [0x7a63] = "\xfb\xa3", [0x7a64] = "\xfb\xa4",
  [0x7a65] = "\xfb\xa5", [0x7a66] = "\xfb\xa6", [0x7a67] = "\xfb\xa7",
  [0x7a68] = "\xfb\xa8", [0x7a69] = "\xfb\xa9", [0x7a6a] = "\xfb\xaa",
  [0x7a6b] = "\xfb\xab", [0x7a6c] = "\xfb\xac", [0x7a6d] = "\xfb\xad",
  [0x7a6e] = "\xfb\xae", [0x7a6f] = "\xfb\xaf", [0x7a70] = "\xfb\xb0",
  [0x7a71] = "\xfb\xb1", [0x7a72] = "\xfb\xb2", [0x7a73] = "\xfb\xb3",
  [0x7a74] = "\xfb\xb4", [0x7a75] = "\xfb\xb5", [0x7a76] = "\xfb\xb6",
  [0x7a77] = "\xfb\xb7", [0x7a78] = "\xfb\xb8", [0x7a79] = "\xfb\xb9",
  [0x7a7a] = "\xfb\xba", [0x7a7b] = "\xfb\xbb", [0x7a7c] = "\xfb\xbc",
  [0x7a7d] = "\xfb\xbd", [0x7a7e] = "\xfb\xbe", [0x7a7f] = "\xfb\xbf",
  [0x7a80] = "\xfb\xc0", [0x7a81] = "\xfb\xc1", [0x7a82] = "\xfb\xc2",
  [0x7a83] = "\xfb\xc3", [0x7a84] = "\xfb\xc4", [0x7a85] = "\xfb\xc5",
  [0x7a86] = "\xfb\xc6", [0x7a87] = "\xfb\xc7", [0x7a88] = "\xfb\xc8",
  [0x7a89] = "\xfb\xc9", [0x7a8a] = "\xfb\xca", [0x7a8b] = "\xfb\xcb",
  [0x7a8c] = "\xfb\xcc", [0x7a8d] = "\xfb\xcd", [0x7a8e] = "\xfb\xce",
  [0x7a8f] = "\xfb\xcf", [0x7a90] = "\xfb\xd0", [0x7a91] = "\xfb\xd1",
  [0x7a92] = "\xfb\xd2", [0x7a93] = "\xfb\xd3", [0x7a94] = "\xfb\xd4",
  [0x7a95] = "\xfb\xd5", [0x7a96] = "\xfb\xd6", [0x7a97] = "\xfb\xd7",
  [0x7a98] = "\xfb\xd8", [0x7a99] = "\xfb\xd9", [0x7a9a] = "\xfb\xda",
  [0x7a9b] = "\xfb\xdb", [0x7a9c] = "\xfb\xdc", [0x7a9d] = "\xfb\xdd",
  [0x7a9e] = "\xfb\xde", [0x7a9f] = "\xfb\xdf", [0x7aa0] = "\xfb\xe0",
  [0x7aa1] = "\xfb\xe1", [0x7aa2] = "\xfb\xe2", [0x7aa3] = "\xfb\xe3",
  [0x7aa4] = "\xfb\xe4", [0x7aa5] = "\xfb\xe5", [0x7aa6] = "\xfb\xe6",
  [0x7aa7] = "\xfb\xe7", [0x7aa8] = "\xfb\xe8", [0x7aa9] = "\xfb\xe9",
  [0x7aaa] = "\xfb\xea", [0x7aab] = "\xfb\xeb", [0x7aac] = "\xfb\xec",
  [0x7aad] = "\xfb\xed", [0x7aae] = "\xfb\xee", [0x7aaf] = "\xfb\xef",
  [0x7ab0] = "\xfb\xf0", [0x7ab1] = "\xfb\xf1", [0x7ab2] = "\xfb\xf2",
  [0x7ab3] = "\xfb\xf3", [0x7ab4] = "\xfb\xf4", [0x7ab5] = "\xfb\xf5",
  [0x7ab6] = "\xfb\xf6", [0x7ab7] = "\xfb\xf7", [0x7ab8] = "\xfb\xf8",
  [0x7ab9] = "\xfb\xf9", [0x7aba] = "\xfb\xfa", [0x7abb] = "\xfb\xfb",
  [0x7abc] = "\xfb\xfc", [0x7abd] = "\xfb\xfd", [0x7abe] = "\xfb\xfe",
  [0x7b00] = "\xfc\x40", [0x7b01] = "\xfc\x41", [0x7b02] = "\xfc\x42",
  [0x7b03] = "\xfc\x43", [0x7b04] = "\xfc\x44", [0x7b05] = "\xfc\x45",
  [0x7b06] = "\xfc\x46", [0x7b07] = "\xfc\x47", [0x7b08] = "\xfc\x48",
  [0x7b09] = "\xfc\x49", [0x7b0a] = "\xfc\x4a", [0x7b0b] = "\xfc\x4b",
  [0x7b0c] = "\xfc\x4c", [0x7b0d] = "\xfc\x4d", [0x7b0e] = "\xfc\x4e",
  [0x7b0f] = "\xfc\x4f", [0x7b10] = "\xfc\x50", [0x7b11] = "\xfc\x51",
  [0x7b12] = "\xfc\x52", [0x7b13] = "\xfc\x53", [0x7b14] = "\xfc\x54",
  [0x7b15] = "\xfc\x55", [0x7b16] = "\xfc\x56", [0x7b17] = "\xfc\x57",
  [0x7b18] = "\xfc\x58", [0x7b19] = "\xfc\x59", [0x7b1a] = "\xfc\x5a",
  [0x7b1b] = "\xfc\x5b", [0x7b1c] = "\xfc\x5c", [0x7b1d] = "\xfc\x5d",
  [0x7b1e] = "\xfc\x5e", [0x7b1f] = "\xfc\x5f", [0x7b20] = "\xfc\x60",
  [0x7b21] = "\xfc\x61", [0x7b22] = "\xfc\x62", [0x7b23] = "\xfc\x63",
  [0x7b24] = "\xfc\x64", [0x7b25] = "\xfc\x65", [0x7b26] = "\xfc\x66",
  [0x7b27] = "\xfc\x67", [0x7b28] = "\xfc\x68", [0x7b29] = "\xfc\x69",
  [0x7b2a] = "\xfc\x6a", [0x7b2b] = "\xfc\x6b", [0x7b2c] = "\xfc\x6c",
  [0x7b2d] = "\xfc\x6d", [0x7b2e] = "\xfc\x6e", [0x7b2f] = "\xfc\x6f",
  [0x7b30] = "\xfc\x70", [0x7b31] = "\xfc\x71", [0x7b32] = "\xfc\x72",
  [0x7b33] = "\xfc\x73", [0x7b34] = "\xfc\x74", [0x7b35] = "\xfc\x75",
  [0x7b36] = "\xfc\x76", [0x7b37] = "\xfc\x77", [0x7b38] = "\xfc\x78",
  [0x7b39] = "\xfc\x79", [0x7b3a] = "\xfc\x7a", [0x7b3b] = "\xfc\x7b",
  [0x7b3c] = "\xfc\x7c", [0x7b3d] = "\xfc\x7d", [0x7b3e] = "\xfc\x7e",
  [0x7b40] = "\xfc\x80", [0x7b41] = "\xfc\x81", [0x7b42] = "\xfc\x82",
  [0x7b43] = "\xfc\x83", [0x7b44] = "\xfc\x84", [0x7b45] = "\xfc\x85",
  [0x7b46] = "\xfc\x86", [0x7b47] = "\xfc\x87", [0x7b48] = "\xfc\x88",
  [0x7b49] = "\xfc\x89", [0x7b4a] = "\xfc\x8a", [0x7b4b] = "\xfc\x8b",
  [0x7b4c] = "\xfc\x8c", [0x7b4d] = "\xfc\x8d", [0x7b4e] = "\xfc\x8e",
  [0x7b4f] = "\xfc\x8f", [0x7b50] = "\xfc\x90", [0x7b51] = "\xfc\x91",
  [0x7b52] = "\xfc\x92", [0x7b53] = "\xfc\x93", [0x7b54] = "\xfc\x94",
  [0x7b55] = "\xfc\x95", [0x7b56] = "\xfc\x96", [0x7b57] = "\xfc\x97",
  [0x7b58] = "\xfc\x98", [0x7b59] = "\xfc\x99", [0x7b5a] = "\xfc\x9a",
  [0x7b5b] = "\xfc\x9b", [0x7b5c] = "\xfc\x9c", [0x7b5d] = "\xfc\x9d",
  [0x7b5e] = "\xfc\x9e", [0x7b5f] = "\xfc\x9f", [0x7b60] = "\xfc\xa0",
  [0x7b61] = "\xfc\xa1", [0x7b62] = "\xfc\xa2", [0x7b63] = "\xfc\xa3",
  [0x7b64] = "\xfc\xa4", [0x7b65] = "\xfc\xa5", [0x7b66] = "\xfc\xa6",
  [0x7b67] = "\xfc\xa7", [0x7b68] = "\xfc\xa8", [0x7b69] = "\xfc\xa9",
  [0x7b6a] = "\xfc\xaa", [0x7b6b] = "\xfc\xab", [0x7b6c] = "\xfc\xac",
  [0x7b6d] = "\xfc\xad", [0x7b6e] = "\xfc\xae", [0x7b6f] = "\xfc\xaf",
  [0x7b70] = "\xfc\xb0", [0x7b71] = "\xfc\xb1", [0x7b72] = "\xfc\xb2",
  [0x7b73] = "\xfc\xb3", [0x7b74] = "\xfc\xb4", [0x7b75] = "\xfc\xb5",
  [0x7b76] = "\xfc\xb6", [0x7b77] = "\xfc\xb7", [0x7b78] = "\xfc\xb8",
  [0x7b79] = "\xfc\xb9", [0x7b7a] = "\xfc\xba", [0x7b7b] = "\xfc\xbb",
  [0x7b7c] = "\xfc\xbc", [0x7b7d] = "\xfc\xbd", [0x7b7e] = "\xfc\xbe",
  [0x7b7f] = "\xfc\xbf", [0x7b80] = "\xfc\xc0", [0x7b81] = "\xfc\xc1",
  [0x7b82] = "\xfc\xc2", [0x7b83] = "\xfc\xc3", [0x7b84] = "\xfc\xc4",
  [0x7b85] = "\xfc\xc5", [0x7b86] = "\xfc\xc6", [0x7b87] = "\xfc\xc7",
  [0x7b88] = "\xfc\xc8", [0x7b89] = "\xfc\xc9", [0x7b8a] = "\xfc\xca",
  [0x7b8b] = "\xfc\xcb", [0x7b8c] = "\xfc\xcc", [0x7b8d] = "\xfc\xcd",
  [0x7b8e] = "\xfc\xce", [0x7b8f] = "\xfc\xcf", [0x7b90] = "\xfc\xd0",
  [0x7b91] = "\xfc\xd1", [0x7b92] = "\xfc\xd2", [0x7b93] = "\xfc\xd3",
  [0x7b94] = "\xfc\xd4", [0x7b95] = "\xfc\xd5", [0x7b96] = "\xfc\xd6",
  [0x7b97] = "\xfc\xd7", [0x7b98] = "\xfc\xd8", [0x7b99] = "\xfc\xd9",
  [0x7b9a] = "\xfc\xda", [0x7b9b] = "\xfc\xdb", [0x7b9c] = "\xfc\xdc",
  [0x7b9d] = "\xfc\xdd", [0x7b9e] = "\xfc\xde", [0x7b9f] = "\xfc\xdf",
  [0x7ba0] = "\xfc\xe0", [0x7ba1] = "\xfc\xe1", [0x7ba2] = "\xfc\xe2",
  [0x7ba3] = "\xfc\xe3", [0x7ba4] = "\xfc\xe4", [0x7ba5] = "\xfc\xe5",
  [0x7ba6] = "\xfc\xe6", [0x7ba7] = "\xfc\xe7", [0x7ba8] = "\xfc\xe8",
  [0x7ba9] = "\xfc\xe9", [0x7baa] = "\xfc\xea", [0x7bab] = "\xfc\xeb",
  [0x7bac] = "\xfc\xec", [0x7bad] = "\xfc\xed", [0x7bae] = "\xfc\xee",
  [0x7baf] = "\xfc\xef", [0x7bb0] = "\xfc\xf0", [0x7bb1] = "\xfc\xf1",
  [0x7bb2] = "\xfc\xf2", [0x7bb3] = "\xfc\xf3", [0x7bb4] = "\xfc\xf4",
  [0x7bb5] = "\xfc\xf5", [0x7bb6] = "\xfc\xf6", [0x7bb7] = "\xfc\xf7",
  [0x7bb8] = "\xfc\xf8", [0x7bb9] = "\xfc\xf9", [0x7bba] = "\xfc\xfa",
  [0x7bbb] = "\xfc\xfb", [0x7bbc] = "\xfc\xfc", [0x7bbd] = "\xfc\xfd",
  [0x7bbe] = "\xfc\xfe", [0x7c00] = "\xfd\x40", [0x7c01] = "\xfd\x41",
  [0x7c02] = "\xfd\x42", [0x7c03] = "\xfd\x43", [0x7c04] = "\xfd\x44",
  [0x7c05] = "\xfd\x45", [0x7c06] = "\xfd\x46", [0x7c07] = "\xfd\x47",
  [0x7c08] = "\xfd\x48", [0x7c09] = "\xfd\x49", [0x7c0a] = "\xfd\x4a",
  [0x7c0b] = "\xfd\x4b", [0x7c0c] = "\xfd\x4c", [0x7c0d] = "\xfd\x4d",
  [0x7c0e] = "\