%define GLIBCVERSION 	2.2.5
%define PACKAGE_RELEASE 1

%define lib_gconv lib
%ifarch s390x
%define lib_gconv lib64
%endif


name:           saplocales
version:        %{GLIBCVERSION}
release:        %{PACKAGE_RELEASE}
copyright:      LGPL
vendor:         SAP AG, Germany
summary:        additional locales
group:          System/Libraries
AutoReqProv:    0
Requires:       /%{lib_gconv}/ld-%{GLIBCVERSION}.so
Source0:        saplocales-%{GLIBCVERSION}.tgz
Buildroot:      /tmp/%{name}-%{version}-%{release}

# this is to please saplocales 1.0
Obsoletes:      saplocales-blended


%description
additional locales for glibc %{GLIBCVERSION} required for 
running an SAP Application Server

%files
%ifarch s390x %{ix86}
%attr(-, root, root) /usr/lib/locale/*
%endif
%attr(-, root, root) /usr/%{lib_gconv}/gconv/*



%prep
rm -rf saplocales-%{version}
tar -xzf %SOURCE0
exit 0

%build
cd saplocales-%{version}
%ifarch s390x %{ix86}
make
%else
make modules
%endif
exit 0

%install
cd saplocales-%{version}
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
%ifarch s390x %{ix86}
[ ! -d $RPM_BUILD_ROOT/usr/lib/locale ] && mkdir -p $RPM_BUILD_ROOT/usr/lib/locale
cp -a locale $RPM_BUILD_ROOT/usr/lib
%endif
[ ! -d $RPM_BUILD_ROOT/usr/%{lib_gconv}/gconv ] && mkdir -p $RPM_BUILD_ROOT/usr/%{lib_gconv}/gconv
cp -a gconv $RPM_BUILD_ROOT/usr/%{lib_gconv}
cp -a gconv-modules* $RPM_BUILD_ROOT/usr/%{lib_gconv}/gconv
exit 0

%clean
rm -rf "$RPM_BUILD_ROOT"




%ifarch %{ix86}
%pre
# this is to please the un-install-phase of saplocale 1.0 for i386
_f=/usr/lib/gconv/gconv-modules
if [ -f $_f ]; then
    if [ `fgrep -c 'SAP blended codepages' $_f` -ne 0 ]; then
        if [ -f $_f ]; then
            _i=0
            while [ -f $_f.$_i ]
            do
                _i=`expr $_i + 1`
            done
            cp -a $_f $_f.$_i
            [ $? -ne 0 ] && exit 1
        fi
        fgrep -v 'SAP blended codepages' $_f > /tmp/.$$
        [ $? -eq 0 ] && cp -f /tmp/.$$ $_f
        rm -f /tmp/.$$
    fi
fi
exit 0
%endif



%post
# install and upgrade
_f=/usr/%{lib_gconv}/gconv/gconv-modules
if [ -f $_f ]; then
    _g=/usr/%{lib_gconv}/gconv/gconv-modules.SAP
    if [ -f $_g ]; then
	_p=0
	_l=/tmp/.$$
	rm -f $_l
	while read _line; do
	    if [ ! -z "$_line" ]; then
		if [ `grep -c "$_line" $_f` -eq 0 ]; then
		    echo "$_line" >> $_l
		    _p=1
		fi
	    fi
	done < $_g
	if [ $_p -ne 0 ]; then
	    _i=0
	    while [ -f $_f.$_i ]; do
		_i=`expr $_i + 1`
	    done
	    cp -a $_f $_f.$_i
	    [ $? -ne 0 ] && exit 1
	    cat $_l $_f.$_i > $_f
	    chmod 644 $_f
	    rm -f $_l
	fi
    fi
fi
[ -x /usr/sbin/glibc_post_upgrade ] && /usr/sbin/glibc_post_upgrade
[ -x /usr/sbin/iconvconfig ] && /usr/sbin/iconvconfig
exit 0



%preun
if [ "$1" = "0" ]; then
    # final remove of saplocales
    _f=/usr/%{lib_gconv}/gconv/gconv-modules
    if [ -f $_f ]; then
	_g=/usr/%{lib_gconv}/gconv/gconv-modules.SAP
	if [ -f $_g ]; then
	    _p=0
	    _l=/tmp/.$$
	    rm -f $_l
	    cp -f $_f $_l
	    while read _line; do
		if [ ! -z "$_line" ]; then
		    if [ `grep -c "$_line" $_l` -ne 0 ]; then
			grep -v "$_line" $_l > /tmp/.$$.1
			mv -f /tmp/.$$.1 $_l
			_p=1
		    fi
		fi
	    done < $_g
	    if [ $_p -ne 0 ]; then
		_i=0
		while [ -f $_f.$_i ]; do
		    _i=`expr $_i + 1`
		done
		cp -a $_f $_f.$_i
		[ $? -ne 0 ] && exit 1
		cp -f $_l $_f
		chmod 644 $_f
	    fi
	    rm -f $_l
	fi
    fi
    [ -x /usr/sbin/glibc_post_upgrade ] && /usr/sbin/glibc_post_upgrade
    [ -x /usr/sbin/iconvconfig ] && /usr/sbin/iconvconfig
fi
exit 0


%ifarch s390

%package 32bit
group:          System/Libraries
summary:        additional 32bit conversion modules

%description 32bit
additional 32bit conversion modules

%files 32bit
%attr(-, root, root) /usr/%{lib_gconv}/gconv/*

%post 32bit
# install and upgrade
_f=/usr/%{lib_gconv}/gconv/gconv-modules
if [ -f $_f ]; then
    _g=/usr/%{lib_gconv}/gconv/gconv-modules.SAP
    if [ -f $_g ]; then
	_p=0
	_l=/tmp/.$$
	rm -f $_l
	while read _line; do
	    if [ ! -z "$_line" ]; then
		if [ `grep -c "$_line" $_f` -eq 0 ]; then
		    echo "$_line" >> $_l
		    _p=1
		fi
	    fi
	done < $_g
	if [ $_p -ne 0 ]; then
	    _i=0
	    while [ -f $_f.$_i ]; do
		_i=`expr $_i + 1`
	    done
	    cp -a $_f $_f.$_i
	    [ $? -ne 0 ] && exit 1
	    cat $_l $_f.$_i > $_f
	    chmod 644 $_f
	    rm -f $_l
	fi
    fi
fi
[ -x /usr/sbin/glibc_post_upgrade ] && /usr/sbin/glibc_post_upgrade
[ -x /usr/sbin/iconvconfig ] && /usr/sbin/iconvconfig
exit 0

%preun 32bit
if [ "$1" = "0" ]; then
    # final remove of saplocales
    _f=/usr/%{lib_gconv}/gconv/gconv-modules
    if [ -f $_f ]; then
	_g=/usr/%{lib_gconv}/gconv/gconv-modules.SAP
	if [ -f $_g ]; then
	    _p=0
	    _l=/tmp/.$$
	    rm -f $_l
	    cp -f $_f $_l
	    while read _line; do
		if [ ! -z "$_line" ]; then
		    if [ `grep -c "$_line" $_l` -ne 0 ]; then
			grep -v "$_line" $_l > /tmp/.$$.1
			mv -f /tmp/.$$.1 $_l
			_p=1
		    fi
		fi
	    done < $_g
	    if [ $_p -ne 0 ]; then
		_i=0
		while [ -f $_f.$_i ]; do
		    _i=`expr $_i + 1`
		done
		cp -a $_f $_f.$_i
		[ $? -ne 0 ] && exit 1
		cp -f $_l $_f
		chmod 644 $_f
	    fi
	    rm -f $_l
	fi
    fi
    [ -x /usr/sbin/glibc_post_upgrade ] && /usr/sbin/glibc_post_upgrade
    [ -x /usr/sbin/iconvconfig ] && /usr/sbin/iconvconfig
fi
exit 0

%endif
