/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.ant;

import com.sun.wts.tools.ant.PackageRenameTask;
import com.sun.wts.tools.ant.RenamePattern;
import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;

public class PackageRenameMojo
extends AbstractMojo {
    protected MavenProject project;
    private File rootDir;
    private Map patterns;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.patterns == null) {
            throw new MojoExecutionException("No replacement patterns given");
        }
        for (String dir : this.project.getCompileSourceRoots()) {
            PackageRenameTask task = new PackageRenameTask();
            task.setProject(this.createAntProject());
            task.setDestdir(this.rootDir);
            task.setSrcDir(new File(dir));
            for (Map.Entry entry : this.patterns.entrySet()) {
                task.addConfiguredPattern(new RenamePattern((String)entry.getKey(), (String)entry.getValue()));
            }
            task.execute();
        }
    }

    private Project createAntProject() {
        Project project = new Project();
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        antLogger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
        project.addBuildListener((BuildListener)antLogger);
        return project;
    }
}

