#
# Testcase for root/cimv2:RCP_SimpleDataTypes
#
# Generated by 'genprovider' for use with cmpi-bindings-ruby
require 'rubygems'
require 'sfcc'
require 'test/unit'
require_relative './helper'

class Test_RCP_SimpleDataTypes < Test::Unit::TestCase
  def setup
    @client, @op = Helper.setup 'RCP_SimpleDataTypes'
  end

  def teardown
    Helper.teardown
  end

  def test_registered
    cimclass = @client.get_class(@op)
    assert cimclass
  end

  def test_instance_names
    names = @client.instance_names(@op)
    assert names.size > 0
    names.each do |ref|
      ref.namespace = @op.namespace
      instance = @client.get_instance ref
      assert instance
    
      assert instance.Name
      assert_kind_of String, instance.Name # string
      assert instance.bool
      assert instance.bool.is_a?(TrueClass) || instance.bool.is_a?(FalseClass)
      assert instance.text
      assert_kind_of String, instance.text # string
      assert instance.char_16
      assert_kind_of Integer, instance.char_16 # char16
      assert instance.unsigned_int_8
      assert_kind_of Integer, instance.unsigned_int_8 # uint8
      assert instance.unsigned_int_16
      assert_kind_of Integer, instance.unsigned_int_16 # uint16
      assert instance.unsigned_int_32
      assert_kind_of Integer, instance.unsigned_int_32 # uint32
      assert instance.unsigned_int_64
      assert_kind_of Integer, instance.unsigned_int_64 # uint64
      assert instance.byte
      assert_kind_of Integer, instance.byte # sint8
      assert instance.short
      assert_kind_of Integer, instance.short # sint16
      assert instance.int
      assert_kind_of Integer, instance.int # sint32
      assert instance.long
      assert_kind_of Integer, instance.long # sint64
      assert instance.float
      assert_kind_of Float, instance.float # real32
      assert instance.double
      assert_kind_of Float, instance.double # real64
      assert instance.date_time
      assert_kind_of Time, instance.date_time # dateTime
    end
  end

end
