#
# Testcase for root/cimv2:RCP_ComplexMethod
#
# Generated by 'genprovider' for use with cmpi-bindings-ruby
require 'rubygems'
require 'sfcc'
require 'test/unit'
require_relative "./helper"
$: << File.dirname(__FILE__)

class Test_RCP_ComplexMethod < Test::Unit::TestCase
  def setup
    @client, @op = Helper.setup 'RCP_ComplexMethod'
  end

  def teardown
    Helper.teardown
  end

  def test_registered
    cimclass = @client.get_class(@op)
    assert cimclass
  end

  def test_instance_names
    names = @client.instance_names(@op)
    assert names.size > 0
    names.each do |ref|
      ref.namespace = @op.namespace
      instance = @client.get_instance ref
      assert instance
    
      assert instance.Name
      if instance.Name
        assert_kind_of String, instance.Name # string
      end
    end
  end

  def test_method_InOut
    @client.instances(@op).each do |inst|
      p_in_count = 3 # uint32
      p_in_str = "Ruby" # string
      expected = p_in_str * p_in_count
      p_out_result = {} # string
      res = inst.InOut(p_in_count, p_in_str, p_out_result)
      assert_kind_of Integer, res
      assert_equal expected.size, res
      assert p_out_result[:result]
      assert_equal expected, p_out_result[:result]
    end
  end

  def test_method_Size
    @client.instances(@op).each do |inst|
      p_in_str_a = (1..1024).to_a # string[]
      res = inst.Size(p_in_str_a)
      assert_kind_of Integer, res
      assert_equal p_in_str_a.size, res
    end
  end

end
