
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/equal.hpp>
#include <boost/detail/lightweight_test.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS
 
 #define BOOST_VMD_REGISTER_AN_ID1 (AN_ID1)
 #define BOOST_VMD_REGISTER_AN_ID2 (AN_ID2)
 
 #define BOOST_VMD_DETECT_AN_ID1_AN_ID1
 #define BOOST_VMD_DETECT_AN_ID2_AN_ID2
 
 #define AN_IDENTIFIER1 AN_ID1
 #define AN_IDENTIFIER2 AN_ID2
 #define AN_IDENTIFIER3 AN_ID1 // same as AN_IDENTIFIER1 = AN_ID1
 
 #define A_NUMBER1 33
 #define A_NUMBER2 145
 #define A_NUMBER3 33 // same as A_NUMBER1 = 33
 
 #define A_TUPLE1 (AN_IDENTIFIER1,A_NUMBER1)
 #define A_TUPLE2 (AN_IDENTIFIER1,A_NUMBER2)
 #define A_TUPLE3 (AN_IDENTIFIER3,A_NUMBER3) // same as A_TUPLE1 = (AN_ID1,33)
 
 #define A_SEQ1 (A_NUMBER1)(A_TUPLE1)
 #define A_SEQ2 (A_NUMBER2)(A_TUPLE2)
 #define A_SEQ3 (A_NUMBER3)(A_TUPLE3) // same as A_SEQ1 = (33)((AN_ID1,33))

 BOOST_TEST(!BOOST_VMD_EQUAL(AN_IDENTIFIER1,AN_IDENTIFIER2));
 BOOST_TEST(BOOST_VMD_EQUAL(AN_IDENTIFIER1,AN_IDENTIFIER3));
 BOOST_TEST(!BOOST_VMD_EQUAL(A_NUMBER1,A_NUMBER2));
 BOOST_TEST(BOOST_VMD_EQUAL(A_NUMBER1,A_NUMBER3));
 BOOST_TEST(!BOOST_VMD_EQUAL(A_TUPLE1,A_TUPLE2));
 BOOST_TEST(BOOST_VMD_EQUAL(A_TUPLE1,A_TUPLE3));
 BOOST_TEST(!BOOST_VMD_EQUAL(A_SEQ1,A_SEQ2));
 BOOST_TEST(BOOST_VMD_EQUAL(A_SEQ1,A_SEQ3));
 
 #define TUPLE_IS_ARRAY1 (2,(3,4))
 #define TUPLE_IS_ARRAY2 (2,(4,5))
 #define TUPLE_IS_ARRAY3 (2,(3,4))
 
 #define TUPLE_IS_LIST1 (55,BOOST_PP_NIL)
 #define TUPLE_IS_LIST2 (135,BOOST_PP_NIL)
 #define TUPLE_IS_LIST3 (55,BOOST_PP_NIL)
 
 #define TUPLE_IS_LIST_OR_ARRAY1 (2,(3,BOOST_PP_NIL))
 #define TUPLE_IS_LIST_OR_ARRAY2 (2,(4,BOOST_PP_NIL))
 #define TUPLE_IS_LIST_OR_ARRAY3 (2,(3,BOOST_PP_NIL))
 
 BOOST_TEST(!BOOST_VMD_EQUAL(TUPLE_IS_ARRAY1,TUPLE_IS_ARRAY2));
 BOOST_TEST(BOOST_VMD_EQUAL(TUPLE_IS_ARRAY1,TUPLE_IS_ARRAY3));
 BOOST_TEST(!BOOST_VMD_EQUAL(TUPLE_IS_LIST1,TUPLE_IS_LIST2));
 BOOST_TEST(BOOST_VMD_EQUAL(TUPLE_IS_LIST1,TUPLE_IS_LIST3));
 BOOST_TEST(!BOOST_VMD_EQUAL(TUPLE_IS_LIST_OR_ARRAY1,TUPLE_IS_LIST_OR_ARRAY2));
 BOOST_TEST(BOOST_VMD_EQUAL(TUPLE_IS_LIST_OR_ARRAY1,TUPLE_IS_LIST_OR_ARRAY3));
 
 #define A_TUPLE_1 (3,4,"astring")
 #define A_TUPLE_2 (3,4)
 
 BOOST_TEST(!BOOST_VMD_EQUAL(A_TUPLE_1,A_TUPLE_2));
 
#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
