PropertyMap, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), 
defines a general purpose interface for mapping key objects to corresponding value objects, thereby hiding the details of how the mapping is implemented from algorithms.

### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++03
* Header-only

### Build Status

Branch          | Travis | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
:-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
[`master`](https://github.com/boostorg/property_map/tree/master) | [![Build Status](https://travis-ci.org/boostorg/property_map.svg?branch=master)](https://travis-ci.org/boostorg/property_map) | [![Build status](https://ci.appveyor.com/api/projects/status/jo7n29t5w499dodk/branch/master?svg=true)](https://ci.appveyor.com/project/jeking3/property-map-06329/branch/master) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/15841/badge.svg)](https://scan.coverity.com/projects/boostorg-property_map) | [![codecov](https://codecov.io/gh/boostorg/property_map/branch/master/graph/badge.svg)](https://codecov.io/gh/boostorg/property_map/branch/master)| [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/property_map.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](http://www.boost.org/doc/libs/master/doc/html/property_map.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](http://www.boost.org/development/tests/master/developer/property_map.html)
[`develop`](https://github.com/boostorg/property_map/tree/develop) | [![Build Status](https://travis-ci.org/boostorg/property_map.svg?branch=develop)](https://travis-ci.org/boostorg/property_map) | [![Build status](https://ci.appveyor.com/api/projects/status/jo7n29t5w499dodk/branch/develop?svg=true)](https://ci.appveyor.com/project/jeking3/property-map-06329/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/15841/badge.svg)](https://scan.coverity.com/projects/boostorg-property_map) | [![codecov](https://codecov.io/gh/boostorg/property_map/branch/develop/graph/badge.svg)](https://codecov.io/gh/boostorg/property_map/branch/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/property_map.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](http://www.boost.org/doc/libs/develop/doc/html/property_map.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](http://www.boost.org/development/tests/develop/developer/property_map.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `doc`       | documentation                  |
| `example`   | examples                       |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-property_map)
* [Report bugs](https://github.com/boostorg/property_map/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[property_map]` tag at the beginning of the subject line.

