// Boost.Geometry
// Unit Test

// Copyright (c) 2018 Adeel Ahmad, Islamabad, Pakistan.

// Contributed and/or modified by Adeel Ahmad, as part of Google Summer of Code 2018 program.

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_TEST_INVERSE_CASES_SMALL_ANGLES_HPP
#define BOOST_GEOMETRY_TEST_INVERSE_CASES_SMALL_ANGLES_HPP

#include "inverse_cases.hpp"

struct expected_results_small_angles
{
    coordinates p1;
    coordinates p2;
    expected_result karney;
};

/*
 These values are collected from GeodTest which is associated with GeographicLib:
     https://zenodo.org/record/32156

 The conversion to C++ array format is done using this Python script:
     https://github.com/adl1995/boost-geometry-extra/blob/master/geographiclib-dataset-parse-inverse.py

 Geodesic scale (M12) is absent from the GeodTest dataset, so it is manually generated
 using GeographicLib using this C++ script:
     https://github.com/adl1995/boost-geometry-extra/blob/master/geographicLib-direct-small_angles.cpp
*/
expected_results_small_angles expected_small_angles[] =
{
    {
        { 180, 0 },{ 0, 0 },
        { 20003931.45862544700503349304, -0.00000000000000000000, 180.00000000000000000000, 67125.61229850351810455322266, -1.00000000000000000000 },
    },{
        { 180, 0 },{ 1e-300, 0 },
        { 20003931.45862544700503349304, -0.00000000000000000000, 180.00000000000000000000, 67125.61229850351810455322266, -1.00000000000000000000 },
    },{
        { 180, 0 },{ 1e-200, 0 },
        { 20003931.45862544700503349304, -0.00000000000000000000, 180.00000000000000000000, 67125.61229850351810455322266, -1.00000000000000000000 },
    },{
        { 180, 0 },{ 1e-100, 0 },
        { 20003931.45862544700503349304, -0.00000000000000000000, 180.00000000000000000000, 67125.61229850351810455322266, -1.00000000000000000000 },
    },{
        { 180, 0 },{ 1e-50, 0 },
        { 20003931.45862544700503349304, -0.00000000000000000000, 180.00000000000000000000, 67125.61229850351810455322266, -1.00000000000000000000 },
    },{
        { 180, 0 },{ 1e-20, 0 },
        { 20003931.45862544700503349304, -0.00000000000000000000, 180.00000000000000000000, 67125.61229850351810455322266, -1.00000000000000000000 },
    },{
        { 180, 0 },{ 1e-10, 0 },
        { 20003931.45862544700503349304, -9.501793528220011062168943853e-09, -179.9999999904981962117744843, 67125.61229850351810455322266, -1 },
    },{
        { 0, 1e-100 },{ 170, 1e-200},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-300 },{ 170, 1e-50},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-300 },{ 170, 1e-10},
        { 18924313.43485650792717933655, 89.99999999939157646622334141, 90.00000000060019544889655663, 1041298.80855225014965981245, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-100 },{ 170, 1e-50},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-200 },{ 170, 1e-50},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 0.0 },{ 170, 1e-10},
        { 18924313.43485650792717933655, 89.99999999939157646622334141, 90.00000000060019544889655663, 1041298.80855225014965981245, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-20 },{ 170, 1e-100},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-100 },{ 170, 0.0},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-10 },{ 170, 1e-300},
        { 18924313.43485650792717933655, 89.99999999939980455110344337, 90.00000000060842353377665859, 1041298.80855225014965981245, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-300 },{ 170, 1e-100},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-200 },{ 170, 1e-100},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 1e-10 },{ 170, 1e-50},
        { 18924313.43485650792717933655, 89.99999999939980455110344337, 90.00000000060842353377665859, 1041298.80855225014965981245, -0.9864919282563420210863114335 },
    },{
        { 0, 0.0 },{ 170, 1e-200},
        { 18924313.43485650792717933655, 90, 90, 1041298.808552250848151743412, -0.9864919282563420210863114335 },
    },{
        { 0, 0.0 },{ 170, 1e-10},
        { 18924313.43485650792717933655, 89.99999999939157646622334141, 90.00000000060019544889655663, 1041298.80855225014965981245, -0.9864919282563420210863114335 },
    }
};


size_t const expected_size_small_angles = sizeof(expected_small_angles) / sizeof(expected_results_small_angles);

#endif // BOOST_GEOMETRY_TEST_INVERSE_CASES_SMALL_ANGLES_HPP
