/* The following code was generated by JFlex 1.4.3 on 09/12/13 16:31 */

/*
* JBoss, Home of Professional Open Source
* Copyright 2008-10 Red Hat and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*
* @authors Andrew Dinn
*/

package org.jboss.byteman.rule.grammar;

import java_cup.runtime.*;
import org.jboss.byteman.rule.grammar.PrintableSymbol;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 09/12/13 16:31 from the specification file
 * <tt>/ssd/home/adinn/jboss/byteman/git/byteman/agent/grammar/flex/ECAToken.flex</tt>
 */
public class ECATokenLexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int QUOTEDIDENT = 4;
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3, 3
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\22\0\1\3\1\66\1\111"+
    "\1\107\1\5\1\104\1\65\1\112\1\53\1\54\1\74\1\10\1\60"+
    "\1\63\1\12\1\77\1\6\11\7\1\106\1\57\1\62\1\61\1\67"+
    "\1\105\1\110\1\42\1\13\1\4\1\16\1\37\1\23\1\31\1\30"+
    "\1\14\2\4\1\43\1\75\1\15\1\25\1\102\1\72\1\35\1\44"+
    "\1\27\1\36\1\100\1\50\3\4\1\55\1\113\1\56\1\70\1\4"+
    "\1\0\1\45\1\17\1\52\1\22\1\11\1\24\1\34\1\33\1\20"+
    "\2\4\1\46\1\76\1\21\1\26\1\103\1\73\1\40\1\47\1\32"+
    "\1\41\1\101\1\51\3\4\1\0\1\64\1\0\1\71\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\2\2\1\3\1\1\2\4\1\5\1\3"+
    "\1\6\30\3\1\7\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\2\3\1\27\2\3\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\1\36\2\43\1\44\1\45\2\46\3\47\2\0\1\50"+
    "\1\51\1\3\1\52\2\3\1\53\1\3\1\54\1\3"+
    "\1\53\5\3\1\55\3\3\1\23\1\56\6\3\1\16"+
    "\1\57\2\3\1\51\1\57\1\60\1\0\1\55\1\61"+
    "\1\53\1\56\1\62\6\3\1\63\1\64\1\65\1\66"+
    "\2\50\1\0\2\50\1\3\1\22\1\3\1\67\2\3"+
    "\1\22\14\3\1\61\1\3\1\15\1\70\1\3\1\30"+
    "\3\3\1\71\1\3\1\72\7\3\1\73\7\3\1\5"+
    "\4\3\1\74\1\26\1\75\2\3\1\76\1\17\1\3"+
    "\1\27\1\3\1\77\1\100";

  private static int [] zzUnpackAction() {
    int [] result = new int[201];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\114\0\230\0\344\0\u0130\0\u017c\0\u0130\0\u01c8"+
    "\0\u0214\0\u0260\0\u02ac\0\u02f8\0\u0344\0\u0130\0\u0390\0\u03dc"+
    "\0\u0428\0\u0474\0\u04c0\0\u050c\0\u0558\0\u05a4\0\u05f0\0\u063c"+
    "\0\u0688\0\u06d4\0\u0720\0\u076c\0\u07b8\0\u0804\0\u0850\0\u089c"+
    "\0\u08e8\0\u0934\0\u0980\0\u09cc\0\u0a18\0\u0a64\0\u0130\0\u0130"+
    "\0\u0130\0\u0130\0\u0130\0\u0130\0\u0ab0\0\u0afc\0\u02f8\0\u0b48"+
    "\0\u0b94\0\u0be0\0\u0c2c\0\u0130\0\u0130\0\u0130\0\u0c78\0\u0cc4"+
    "\0\u0130\0\u0d10\0\u0d5c\0\u0130\0\u0130\0\u0130\0\u0130\0\u0130"+
    "\0\u0130\0\u0da8\0\u0130\0\u0130\0\u0130\0\u0df4\0\u0e40\0\u0e8c"+
    "\0\u0130\0\u0130\0\u0130\0\u0ed8\0\u0130\0\u0f24\0\u0130\0\u0f70"+
    "\0\u0fbc\0\u1008\0\u1054\0\u01c8\0\u10a0\0\u01c8\0\u10ec\0\u1138"+
    "\0\u1184\0\u11d0\0\u01c8\0\u121c\0\u1268\0\u12b4\0\u1300\0\u134c"+
    "\0\u1398\0\u13e4\0\u01c8\0\u1430\0\u147c\0\u14c8\0\u01c8\0\u01c8"+
    "\0\u1514\0\u1560\0\u15ac\0\u15f8\0\u1644\0\u1690\0\u01c8\0\u01c8"+
    "\0\u16dc\0\u1728\0\u0130\0\u0130\0\u0130\0\u1774\0\u0130\0\u0130"+
    "\0\u0130\0\u0130\0\u17c0\0\u180c\0\u1858\0\u18a4\0\u18f0\0\u193c"+
    "\0\u1988\0\u0130\0\u0130\0\u0130\0\u0130\0\u0130\0\u19d4\0\u1a20"+
    "\0\u1a6c\0\u1ab8\0\u1b04\0\u1b50\0\u1b9c\0\u01c8\0\u1be8\0\u1c34"+
    "\0\u1c80\0\u1ccc\0\u1d18\0\u1d64\0\u1db0\0\u1dfc\0\u1e48\0\u1e94"+
    "\0\u1ee0\0\u1f2c\0\u1f78\0\u1fc4\0\u2010\0\u01c8\0\u205c\0\u0130"+
    "\0\u0130\0\u20a8\0\u01c8\0\u20f4\0\u2140\0\u218c\0\u01c8\0\u21d8"+
    "\0\u01c8\0\u2224\0\u2270\0\u22bc\0\u2308\0\u2354\0\u23a0\0\u23ec"+
    "\0\u01c8\0\u2438\0\u2484\0\u24d0\0\u251c\0\u2568\0\u25b4\0\u2600"+
    "\0\u01c8\0\u264c\0\u2698\0\u26e4\0\u2730\0\u01c8\0\u01c8\0\u01c8"+
    "\0\u277c\0\u27c8\0\u01c8\0\u01c8\0\u2814\0\u01c8\0\u2860\0\u01c8"+
    "\0\u01c8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[201];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\2\7\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\10"+
    "\1\34\1\35\1\10\1\36\1\37\1\10\1\40\1\41"+
    "\1\10\1\42\1\43\1\10\1\44\1\45\3\10\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\2\10"+
    "\1\66\1\67\1\70\1\71\2\10\1\72\1\73\1\74"+
    "\1\75\1\76\1\77\1\5\1\100\1\101\1\5\1\102"+
    "\1\103\1\104\106\102\1\105\1\102\1\106\1\107\1\110"+
    "\1\111\107\107\1\112\1\107\1\113\1\114\1\115\111\113"+
    "\116\0\1\7\115\0\4\10\1\0\1\10\1\0\40\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\1\116"+
    "\1\0\1\117\1\120\1\121\1\116\1\0\40\116\10\0"+
    "\1\121\2\0\1\117\1\0\1\117\1\0\2\116\1\117"+
    "\2\116\1\0\4\116\3\0\2\117\14\0\1\122\1\123"+
    "\24\0\1\122\62\0\2\13\1\0\1\122\1\123\24\0"+
    "\1\122\62\0\1\12\1\13\110\0\4\10\1\0\1\10"+
    "\1\0\40\10\17\0\1\10\1\124\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\1\10\1\125"+
    "\36\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\10\10\1\126\27\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\12\10\1\127\10\10\1\130\1\131\13\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\1\10\1\132\10\10\1\133\25\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\5\10\1\134\32\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\11\10\1\126\26\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\135\1\0\13\10"+
    "\1\136\12\10\1\137\11\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\5\10"+
    "\1\140\5\10\1\133\24\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\27\10"+
    "\1\141\10\10\17\0\2\10\1\0\2\10\1\0\4\10"+
    "\14\0\4\10\1\0\1\10\1\0\32\10\1\142\5\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\22\10\1\143\15\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\25\10\1\143\12\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\1\10"+
    "\1\144\13\10\1\145\4\10\1\146\15\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\14\10\1\147\7\10\1\150\13\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\5\10\1\151\12\10\1\152\4\10\1\153\12\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\150\1\0\17\10\1\147\20\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\24\10\1\154\13\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\40\10"+
    "\17\0\1\124\1\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\155\1\0\40\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\2\10\1\156\35\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\14\10\1\157"+
    "\7\10\1\160\13\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\6\10\1\161"+
    "\31\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\160\1\0\17\10\1\157\20\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\33\10\1\162\4\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\71\0\1\163\113\0\1\164\1\165"+
    "\1\166\114\0\1\167\114\0\1\170\107\0\1\171\113\0"+
    "\1\172\5\0\1\173\30\0\4\10\1\0\1\10\1\0"+
    "\1\10\1\174\10\10\1\175\25\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\5\10\1\176\5\10\1\177\24\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\30\10\1\200\7\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\33\10\1\201"+
    "\4\10\17\0\2\10\1\0\2\10\1\0\4\10\10\0"+
    "\1\102\2\0\106\102\1\0\1\102\22\0\1\202\10\0"+
    "\1\203\5\0\1\204\50\0\1\205\2\0\1\107\2\0"+
    "\107\107\1\0\1\107\2\0\1\111\113\0\1\115\115\0"+
    "\4\116\1\0\1\116\1\0\40\116\17\0\2\116\1\0"+
    "\2\116\1\0\4\116\16\0\2\120\112\0\1\117\1\120"+
    "\112\0\1\206\1\207\1\210\52\0\1\210\36\0\1\211"+
    "\1\212\1\0\1\122\25\0\1\122\60\0\4\10\1\0"+
    "\1\10\1\0\2\10\1\213\35\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\14\10\1\214\23\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\30\10\1\215"+
    "\7\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\35\10\1\216\2\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\40\10\17\0\2\10\1\0\2\10\1\0"+
    "\1\217\3\10\14\0\4\10\1\0\1\10\1\0\6\10"+
    "\1\220\31\10\17\0\2\10\1\0\2\10\1\0\4\10"+
    "\14\0\4\10\1\0\1\10\1\0\36\10\1\216\1\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\17\10\1\221\20\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\33\10\1\222\4\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\40\10"+
    "\17\0\2\10\1\0\2\10\1\0\1\10\1\223\2\10"+
    "\14\0\4\10\1\0\1\10\1\0\30\10\1\224\7\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\33\10\1\225\4\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\40\10\17\0\2\10\1\0\1\226\1\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\22\10\1\227"+
    "\15\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\23\10\1\230\14\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\40\10\17\0\2\10\1\0\1\10\1\231"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\25\10"+
    "\1\232\12\10\17\0\2\10\1\0\2\10\1\0\4\10"+
    "\14\0\4\10\1\0\1\10\1\0\26\10\1\233\11\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\14\10\1\234\23\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\17\10\1\235\20\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\3\10"+
    "\1\236\34\10\17\0\2\10\1\0\2\10\1\0\4\10"+
    "\14\0\4\10\1\0\1\10\1\0\7\10\1\236\30\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\32\10\1\237\5\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\73\0\1\240\117\0\1\241"+
    "\30\0\4\10\1\0\1\10\1\0\2\10\1\242\35\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\3\10\1\243\34\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\14\0\4\10\1\0\1\10"+
    "\1\0\6\10\1\244\31\10\17\0\2\10\1\0\2\10"+
    "\1\0\4\10\14\0\4\10\1\0\1\10\1\0\7\10"+
    "\1\243\30\10\17\0\2\10\1\0\2\10\1\0\4\10"+
    "\14\0\4\10\1\0\1\10\1\0\23\10\1\245\14\10"+
    "\17\0\2\10\1\0\2\10\1\0\4\10\14\0\4\10"+
    "\1\0\1\10\1\0\26\10\1\246\11\10\17\0\2\10"+
    "\1\0\2\10\1\0\4\10\16\0\2\207\112\0\1\206"+
    "\1\207\115\0\1\122\25\0\1\122\62\0\2\212\1\0"+
    "\1\122\25\0\1\122\60\0\4\10\1\0\1\10\1\0"+
    "\3\10\1\247\34\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\15\10\1\250"+
    "\22\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\30\10\1\251\7\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\1\10\1\252\36\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\7\10\1\247\30\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\20\10\1\253"+
    "\17\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\33\10\1\251\4\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\5\10\1\254\32\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\31\10\1\255\6\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\34\10\1\256"+
    "\3\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\24\10\1\257\13\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\12\10\1\260\25\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\24\10\1\261\13\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\262\1\0\40\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\13\10\1\263\24\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\261\1\0"+
    "\40\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\23\10\1\264\14\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\26\10\1\265\11\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\34\10\1\266\3\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\23\10\1\267"+
    "\14\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\26\10\1\270\11\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\31\10\1\271\6\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\34\10\1\271\3\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\1\10\1\272"+
    "\36\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\3\10\1\273\34\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\5\10\1\274\32\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\7\10\1\275\30\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\24\10\1\276"+
    "\13\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\276\1\0\40\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\31\10\1\277\6\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\35\10\1\300"+
    "\2\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\34\10\1\277\3\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\36\10\1\300\1\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\22\10\1\301\15\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\25\10\1\302"+
    "\12\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\34\10\1\303\3\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\31\10\1\304\6\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\34\10\1\304\3\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\2\10\1\305"+
    "\35\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\24\10\1\306\13\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\6\10\1\307\31\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\306\1\0"+
    "\40\10\17\0\2\10\1\0\2\10\1\0\4\10\14\0"+
    "\4\10\1\0\1\10\1\0\2\10\1\310\35\10\17\0"+
    "\2\10\1\0\2\10\1\0\4\10\14\0\4\10\1\0"+
    "\1\10\1\0\6\10\1\310\31\10\17\0\2\10\1\0"+
    "\2\10\1\0\4\10\14\0\4\10\1\0\1\10\1\0"+
    "\16\10\1\311\21\10\17\0\2\10\1\0\2\10\1\0"+
    "\4\10\14\0\4\10\1\0\1\10\1\0\21\10\1\311"+
    "\16\10\17\0\2\10\1\0\2\10\1\0\4\10\10\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[10412];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\11\1\1\1\11\6\1\1\11\30\1\6\11"+
    "\7\1\3\11\2\1\1\11\2\1\6\11\1\1\3\11"+
    "\3\1\3\11\1\1\1\11\1\1\1\11\1\1\2\0"+
    "\40\1\3\11\1\0\4\11\7\1\5\11\1\1\1\0"+
    "\27\1\2\11\50\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[201];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  StringBuffer string = new StringBuffer();

  private int startLine = 0;

  private String file = "";

  public void setStartLine(int startLine)
  {
    this.startLine = startLine;
  }

  public void setFile(String file)
  {
    this.file = file;
  }

  private Symbol symbol(int type) {
    return new PrintableSymbol(type, file, yyline + startLine, yycolumn);
  }
  private Symbol symbol(int type, Object value) {
    return new PrintableSymbol(type, file, yyline + startLine, yycolumn, value);
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ECATokenLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ECATokenLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 178) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2: 
          { /* ignore */
          }
        case 65: break;
        case 62: 
          { return symbol(sym.CLASS);
          }
        case 66: break;
        case 17: 
          { return symbol(sym.BAND);
          }
        case 67: break;
        case 1: 
          { throw new Error("Illegal character <"+ yytext()+">");
          }
        case 68: break;
        case 8: 
          { return symbol(sym.RPAREN);
          }
        case 69: break;
        case 33: 
          { yybegin(YYINITIAL);
			  return symbol(sym.STRING_LITERAL,
					string.toString());
          }
        case 70: break;
        case 59: 
          { return symbol(sym.BOOLEAN_LITERAL, Boolean.TRUE);
          }
        case 71: break;
        case 19: 
          { return symbol(sym.GT);
          }
        case 72: break;
        case 52: 
          { string.append('\t');
          }
        case 73: break;
        case 9: 
          { return symbol(sym.LSQUARE);
          }
        case 74: break;
        case 14: 
          { return symbol(sym.LT);
          }
        case 75: break;
        case 50: 
          { return symbol(sym.RSH);
          }
        case 76: break;
        case 28: 
          { string.setLength(0); yybegin(STRING);
          }
        case 77: break;
        case 40: 
          { return symbol(sym.FLOAT_LITERAL, Float.valueOf(yytext()));
          }
        case 78: break;
        case 61: 
          { return symbol(sym.THROW);
          }
        case 79: break;
        case 49: 
          { return symbol(sym.AND);
          }
        case 80: break;
        case 18: 
          { return symbol(sym.NOT);
          }
        case 81: break;
        case 13: 
          { return symbol(sym.ASSIGN);
          }
        case 82: break;
        case 23: 
          { return symbol(sym.DIV);
          }
        case 83: break;
        case 34: 
          { string.append('\\');
          }
        case 84: break;
        case 63: 
          { return symbol(sym.RETURN);
          }
        case 85: break;
        case 58: 
          { return symbol(sym.NULL_LITERAL);
          }
        case 86: break;
        case 53: 
          { string.append('\r');
          }
        case 87: break;
        case 38: 
          { yybegin(YYINITIAL);
          }
        case 88: break;
        case 5: 
          { return symbol(sym.PLUS);
          }
        case 89: break;
        case 24: 
          { return symbol(sym.MOD);
          }
        case 90: break;
        case 27: 
          { yybegin(COMMENT);
          }
        case 91: break;
        case 3: 
          { return symbol(sym.IDENTIFIER, yytext());
          }
        case 92: break;
        case 44: 
          { return symbol(sym.DO);
          }
        case 93: break;
        case 54: 
          { string.append('\"');
          }
        case 94: break;
        case 26: 
          { return symbol(sym.COLON);
          }
        case 95: break;
        case 20: 
          { return symbol(sym.BXOR);
          }
        case 96: break;
        case 32: 
          { throw new Error("File " + file + " line " + (yyline + startLine) + " : newline in string");
          }
        case 97: break;
        case 42: 
          { return symbol(sym.IF);
          }
        case 98: break;
        case 60: 
          { return symbol(sym.BOOLEAN_LITERAL, Boolean.FALSE);
          }
        case 99: break;
        case 7: 
          { return symbol(sym.LPAREN);
          }
        case 100: break;
        case 45: 
          { return symbol(sym.OR);
          }
        case 101: break;
        case 41: 
          { return symbol(sym.EQ);
          }
        case 102: break;
        case 51: 
          { string.append('\n');
          }
        case 103: break;
        case 11: 
          { return symbol(sym.SEMI);
          }
        case 104: break;
        case 10: 
          { return symbol(sym.RSQUARE);
          }
        case 105: break;
        case 43: 
          { return symbol(sym.NE);
          }
        case 106: break;
        case 56: 
          { return symbol(sym.URSH);
          }
        case 107: break;
        case 15: 
          { return symbol(sym.MINUS);
          }
        case 108: break;
        case 35: 
          { throw new Error("File " + file + " line " + (yyline + startLine) + " : newline in quoted identifier");
          }
        case 109: break;
        case 16: 
          { return symbol(sym.BOR);
          }
        case 110: break;
        case 29: 
          { string.setLength(0);  yybegin(QUOTEDIDENT);
          }
        case 111: break;
        case 55: 
          { return symbol(sym.NEW);
          }
        case 112: break;
        case 39: 
          { return symbol(sym.DOLLAR, yytext());
          }
        case 113: break;
        case 21: 
          { return symbol(sym.TWIDDLE);
          }
        case 114: break;
        case 31: 
          { throw new Error("File " + file + " line " + (yyline + startLine) + " : illegal character in string <"+ yytext()+">");
          }
        case 115: break;
        case 57: 
          { return symbol(sym.BIND);
          }
        case 116: break;
        case 48: 
          { return symbol(sym.LSH);
          }
        case 117: break;
        case 25: 
          { return symbol(sym.TERN_IF);
          }
        case 118: break;
        case 46: 
          { return symbol(sym.GE);
          }
        case 119: break;
        case 36: 
          { yybegin(YYINITIAL);
			  return symbol(sym.IDENTIFIER,
					string.toString());
          }
        case 120: break;
        case 12: 
          { return symbol(sym.COMMA);
          }
        case 121: break;
        case 47: 
          { return symbol(sym.LE);
          }
        case 122: break;
        case 22: 
          { return symbol(sym.MUL);
          }
        case 123: break;
        case 64: 
          { return symbol(sym.NOTHING);
          }
        case 124: break;
        case 4: 
          { return symbol(sym.INTEGER_LITERAL, Integer.valueOf(yytext()));
          }
        case 125: break;
        case 30: 
          { string.append( yytext() );
          }
        case 126: break;
        case 37: 
          { /*ignore */
          }
        case 127: break;
        case 6: 
          { return symbol(sym.DOT);
          }
        case 128: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return new java_cup.runtime.Symbol(sym.EOF); }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
