% ATOMIC(1) Atomic Man Pages
% Aaron Weitekamp
% September 2016
# NAME
atomic-trust - Manage system container trust policy


# SYNOPSIS
**atomic trust add|delete|default|reset|show**
[**-h**|**--help**]
[**-j**|**--json**]
[**--raw**]
[**-k**|**--pubkeys** KEY1 [**-k**|**--pubkeys** KEY2,...]]
[**-f**|**--pubkeysfile** KEY1 [**f**|**--pubkeysfile** KEY2,...]]
[**--keytype** GPGKeys]
[**-t**|**--type** signedBy|insecureAcceptAnything|reject]
[**-s**|**--sigstore** https://URL[:PORT][/PATH]|file:///PATH]
[**--sigstoretype** web|atomic|local]
REGISTRY[/REPOSITORY]

# DESCRIPTION
**atomic trust** manages the trust policy of the host system. Trust policy describes
a registry scope (registry and/or repository) that must be signed by public keys. Trust
is defined in **/etc/containers/policy.json**. Trust is enforced when a user attempts to pull
an image from a registry.

Trust scope is evaluated by most specific to least specific. In other words, policy may
be defined for an entire registry, but refined for a particular repository in that
registry. See below for examples.

Trust **type** provides a way to whitelist ("insecureAcceptAnything") or blacklist
("reject") registries.

Signature servers, or **sigstores**, configure where image signatures are served
for a particular registry scope. This cofiguration is a flat list of
arbitrarily named YAML files in **/etc/containers/registries.d/**. Filenames must end
in **.yaml**. A sigstore may be either an absolute path to a local directory (file:///PATH)
or a remote web server (https://URL).

Trust may be updated using the command **atomic trust add** for an existing trust scope.

The default trust policy is managed by the default command. Options are **accept** or **reject**.

The default **/etc/containers/policy.json** file may be overriden using
environment variable **TRUST_POLICY**. This is typically only useful for
testing.

# OPTIONS
**-h** **--help**
  Print usage statement.

**-k** **--pubkeys**
  A reference to a local file, download URL to an exported public key or a
  local user GPG keyring ID (see output of 'gpg2 --list-keys'). Keys are
  parsed and encoded inline with policy.json. Option may be used multiple
  times to require an image be sigend by multiple keys. One of
  **--pubkeys** or **--pubkeysfile** is required for **signedBy** type. This
  option is recommended over **--pubkeysfile**.

**-f** **--pubkeysfile**
  A path to an exported public key on the local system. Key paths
  will be referenced in policy.json. Any path may be used but path
  **/etc/pki/containers** is recommended. Option may be used multiple times to
  require an image be sigend by multiple keys. One of **--pubkeys** or
  **--pubkeysfile** is required for **signedBy** type.

**--keytype**
  The public key type. Default: GPGKeys (only supported value)

**-t** **--type**
  The trust type for this policy entry. Accepted values:
    **signedBy** (default): Require signatures with corresponding list of
                            public keys
    **insecureAcceptAnything**: do not require any signatures for this
                                registry scope
    **reject**: do not accept images for this registry scope

**-u** **--sigstore**
  A path or remote URL where signatures are found. Prefix filesystem path with
  **file:///PATH** and remote web server with **https://URL[:PORT][/PATH/TO/SIGNATURES]**.

**-s** **--sigstoretype**
  Type of signature transport. Accepted values:
    **web** (default): remote web server
    **atomic**: OpenShift-based Atomic Registry API
    **local**: Local filesystem path

# delete OPTIONS

**--save-sigstore**
  Do not remove local sigstore configuration.

# default OPTIONS

  The default trust policy is managed by the default command. Options are **accept** or **reject**.

# show OPTIONS

**--raw**
  Output trust policy file as raw JSON

**-j** **--json**
  Output trust as JSON for machine parsing

# reset

  Resets **policy.json** to the default. Removes all YAML files in 
  **/etc/containers/registries.d/** except **default.yaml**.

# EXAMPLES
Add public key trust to specific registry repository

    atomic trust add \
           --pubkeys /etc/pki/containers/foo@example.com \
           --sigstore https://s3.bucket/foobar/sigstore/ \
           docker.io/foobar

Modify a trust scope, adding a second public key and changing
the sigstore web server

    atomic trust add \
           --pubkeys https://example.com/keys/example.pub \
           --pubkeys /etc/pki/containers/foo@example.com \
           --sigstore https://server.example.com/foobar/sigstore/ \
           docker.io/foobar

Accept all unsigned images from a registry

    atomic trust add --type insecureAcceptAnything docker.io

Remove a trust scope

    atomic trust delete docker.io

Remove a trust scope but retain the sigstore configuration

    atomic trust delete docker.io --sigstore

Modify default trust policy

    atomic trust default reject

Display system trust policy

    atomic trust show

Display trust policy file

    atomic trust show --raw

Display trust as JSON

    atomic trust show --json

# HISTORY
September 2016, originally compiled by Aaron Weitekamp (aweiteka at redhat dot com)
