/**
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Copyright 2012-2017 the original author or authors.
 */
package org.assertj.core.test;

import java.sql.Timestamp;
import java.util.Comparator;

public class AlwaysEqualComparator<T> implements Comparator<T> {

  public static final AlwaysEqualComparator<Object> ALWAY_EQUALS = new AlwaysEqualComparator<>();
  public static final AlwaysEqualComparator<String> ALWAY_EQUALS_STRING = new AlwaysEqualComparator<>();
  public static final AlwaysEqualComparator<Timestamp> ALWAY_EQUALS_TIMESTAMP = new AlwaysEqualComparator<>();

  @Override
  public int compare(T o1, T o2) {
    return 0;
  }
}
