# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function

__metaclass__ = type

from ansible_collections.junipernetworks.junos.tests.unit.compat.mock import (
    patch,
)
from ansible_collections.junipernetworks.junos.plugins.modules import (
    junos_security_zones,
)
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import (
    set_module_args,
)
from .junos_module import TestJunosModule, load_fixture


class TestJunosSecurity_zonesModule(TestJunosModule):
    module = junos_security_zones

    def setUp(self):
        super(TestJunosSecurity_zonesModule, self).setUp()

        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration"
        )
        self.lock_configuration = self.mock_lock_configuration.start()

        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration"
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()

        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.security_zones.security_zones.load_config"
        )
        self.load_config = self.mock_load_config.start()

        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.security_zones.security_zones.commit_configuration"
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()

        self.mock_execute_show_command = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.security_zones.security_zones."
            "Security_zonesFacts._get_device_data"
        )
        self.execute_show_command = self.mock_execute_show_command.start()

    def tearDown(self):
        super(TestJunosSecurity_zonesModule, self).tearDown()
        self.mock_load_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()
        self.mock_execute_show_command.stop()

    def load_fixtures(
        self, commands=None, format="text", changed=False, filename=None
    ):
        def load_from_file(*args, **kwargs):
            output = load_fixture("junos_security_zones_config.cfg")
            return output

        self.execute_show_command.side_effect = load_from_file

    def sorted_xml(self, xml_string):
        temp = []
        index = 0
        while index < len(xml_string):
            temp_line = ""
            if xml_string[index] == "<":
                while index < len(xml_string) and xml_string[index] != ">":
                    temp_line += xml_string[index]
                    index += 1
                temp_line += ">"
                index += 1
                temp.append(temp_line)
            else:
                while index < len(xml_string) and xml_string[index] != "<":
                    temp_line += xml_string[index]
                    index += 1
                temp.append(temp_line)
        return sorted(temp)

    def test_junos_security_zones_merged_01(self):
        set_module_args(
            dict(
                config={
                    "functional_zone_management": {
                        "description": "test description",
                        "host_inbound_traffic": {
                            "protocols": [
                                {"name": "all"},
                                {"except": True, "name": "bgp"},
                            ],
                            "system_services": [
                                {"name": "all"},
                                {"except": True, "name": "dhcp"},
                            ],
                        },
                        "interfaces": ["ge-0/0/1.0", "ge-0/0/2.0"],
                        "screen": "test_screen",
                    },
                    "zones": [
                        {
                            "address_book": {
                                "address_sets": [
                                    {
                                        "addresses": [
                                            "test_adr1",
                                            "test_adr2",
                                        ],
                                        "name": "test_adrset1",
                                    },
                                    {
                                        "addresses": [
                                            "test_adr3",
                                            "test_adr4",
                                        ],
                                        "name": "test_adrset2",
                                    },
                                    {
                                        "address_sets": [
                                            "test_adrset1",
                                            "test_adrset2",
                                        ],
                                        "addresses": ["test_adr5"],
                                        "description": "test description",
                                        "name": "test_adrset3",
                                    },
                                ],
                                "addresses": [
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.0.0.0/24",
                                        "name": "test_adr1",
                                    },
                                    {
                                        "dns_name": {
                                            "ipv6_only": True,
                                            "name": "1.1.1.1",
                                        },
                                        "name": "test_adr2",
                                    },
                                    {
                                        "name": "test_adr3",
                                        "range_address": {
                                            "from": "10.2.0.1",
                                            "to": "10.2.0.2",
                                        },
                                    },
                                    {
                                        "name": "test_adr4",
                                        "wildcard_address": "10.3.0.1/24",
                                    },
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.1.0.0/24",
                                        "name": "test_adr5",
                                    },
                                ],
                            },
                            "advance_policy_based_routing_profile": "test_profile",
                            "advanced_connection_tracking": {
                                "mode": "allow-any-host",
                                "timeout": "20",
                                "track_all_policies_to_this_zone": True,
                            },
                            "application_tracking": True,
                            "description": "test description",
                            "enable_reverse_reroute": True,
                            "host_inbound_traffic": {
                                "protocols": [
                                    {"name": "all"},
                                    {"except": True, "name": "bgp"},
                                ],
                                "system_services": [
                                    {"name": "all"},
                                    {"except": True, "name": "dhcp"},
                                ],
                            },
                            "interfaces": ["ge-0/0/3.0", "ge-0/0/4.0"],
                            "name": "test_sec_zone1",
                            "screen": "test_screen",
                            "source_identity_log": True,
                            "tcp_rst": True,
                            "unidirectional_session_refreshing": True,
                        }
                    ],
                },
                state="merged",
            )
        )
        result = self.execute_module(changed=True)
        commands = (
            '<nc:security xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:zones><nc:functional-zone><nc:management><nc:description>t'
            "est description</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:na"
            "me>bgp</nc:name><nc:except/></nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-services><nc:system-services><n"
            "c:name>dhcp</nc:name><nc:except/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/1.0</nc:name></nc"
            ":interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen></nc:management></nc:f"
            "unctional-zone><nc:security-zone><nc:name>test_sec_zone1</nc:name><nc:address-book><nc:address><nc:name>test_adr1</nc:name><nc:i"
            "p-prefix>10.0.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:address><nc:address><nc:name>test_adr2</nc:nam"
            "e><nc:dns-name><nc:name>1.1.1.1</nc:name><nc:ipv6-only/></nc:dns-name></nc:address><nc:address><nc:name>test_adr3</nc:name><nc:r"
            "ange-address><nc:name>10.2.0.1</nc:name><nc:to><nc:range-high>10.2.0.2</nc:range-high></nc:to></nc:range-address></nc:address><n"
            "c:address><nc:name>test_adr4</nc:name><nc:wildcard-address><nc:name>10.3.0.1/24</nc:name></nc:wildcard-address></nc:address><nc:"
            "address><nc:name>test_adr5</nc:name><nc:ip-prefix>10.1.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:addre"
            "ss><nc:address-set><nc:name>test_adrset1</nc:name><nc:address><nc:name>test_adr1</nc:name></nc:address><nc:address><nc:name>test"
            "_adr2</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name><nc:address><nc:name>test_adr3</nc:n"
            "ame></nc:address><nc:address><nc:name>test_adr4</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset3</nc"
            ":name><nc:address><nc:name>test_adr5</nc:name></nc:address><nc:address-set><nc:name>test_adrset1</nc:name></nc:address-set><nc:a"
            "ddress-set><nc:name>test_adrset2</nc:name></nc:address-set><nc:description>test description</nc:description></nc:address-set></n"
            "c:address-book><nc:advance-policy-based-routing-profile><nc:profile>test_profile</nc:profile></nc:advance-policy-based-routing-p"
            "rofile><nc:advanced-connection-tracking><nc:mode>allow-any-host</nc:mode><nc:timeout>20</nc:timeout><nc:track-all-policies-to-th"
            "is-zone/></nc:advanced-connection-tracking><nc:application-tracking/><nc:description>test description</nc:description><nc:enable"
            "-reverse-reroute/><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:name>bgp</nc:nam"
            "e><nc:except/></nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-services><nc:system-services><nc:name>dhcp</n"
            "c:name><nc:except/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/3.0</nc:name></nc:interfaces><n"
            "c:interfaces><nc:name>ge-0/0/4.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen><nc:source-identity-log/><nc:tcp-rst"
            "/><nc:unidirectional-session-refreshing/></nc:security-zone></nc:zones></nc:security>"
        )
        self.assertEqual(
            self.sorted_xml(commands), self.sorted_xml(str(result["commands"]))
        )

    def test_junos_security_zones_parsed_01(self):
        parsed_str = """
        <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
            <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                <version>18.4R1-S2.4</version>
                <security>
                    <zones>
                        <functional-zone>
                            <management>
                                <description>test description</description>
                                <host-inbound-traffic>
                                    <protocols>
                                        <name>all</name>
                                    </protocols>
                                    <protocols>
                                        <name>bgp</name>
                                        <except />
                                    </protocols>
                                    <system-services>
                                        <name>all</name>
                                    </system-services>
                                    <system-services>
                                        <name>dhcp</name>
                                        <except />
                                    </system-services>
                                </host-inbound-traffic>
                                <interfaces>
                                    <name>ge-0/0/1.0</name>
                                </interfaces>
                                <interfaces>
                                    <name>ge-0/0/2.0</name>
                                </interfaces>
                                <screen>test_screen</screen>
                            </management>
                        </functional-zone>
                        <security-zone>
                            <name>test_sec_zone1</name>
                            <address-book>
                                <address>
                                    <name>test_adr1</name>
                                    <ip-prefix>10.0.0.0/24</ip-prefix>
                                    <description>test desc</description>
                                </address>
                                <address>
                                    <name>test_adr2</name>
                                    <dns-name>
                                        <name>1.1.1.1</name>
                                        <ipv6-only />
                                    </dns-name>
                                </address>
                                <address>
                                    <name>test_adr3</name>
                                    <range-address>
                                        <name>10.2.0.1</name>
                                        <to>
                                            <range-high>10.2.0.2</range-high>
                                        </to>
                                    </range-address>
                                </address>
                                <address>
                                    <name>test_adr4</name>
                                    <wildcard-address>
                                        <name>10.3.0.1/24</name>
                                    </wildcard-address>
                                </address>
                                <address>
                                    <name>test_adr5</name>
                                    <ip-prefix>10.1.0.0/24</ip-prefix>
                                    <description>test desc</description>
                                </address>
                                <address-set>
                                    <name>test_adrset1</name>
                                    <address>
                                        <name>test_adr1</name>
                                    </address>
                                    <address>
                                        <name>test_adr2</name>
                                    </address>
                                </address-set>
                                <address-set>
                                    <name>test_adrset2</name>
                                    <address>
                                        <name>test_adr3</name>
                                    </address>
                                    <address>
                                        <name>test_adr4</name>
                                    </address>
                                </address-set>
                                <address-set>
                                    <name>test_adrset3</name>
                                    <address>
                                        <name>test_adr5</name>
                                    </address>
                                    <address-set>
                                        <name>test_adrset1</name>
                                    </address-set>
                                    <address-set>
                                        <name>test_adrset2</name>
                                    </address-set>
                                    <description>test description</description>
                                </address-set>
                            </address-book>
                            <advance-policy-based-routing-profile>
                                <profile>test_profile</profile>
                            </advance-policy-based-routing-profile>
                            <advanced-connection-tracking>
                                <mode>allow-any-host</mode>
                                <timeout>20</timeout>
                                <track-all-policies-to-this-zone/>
                            </advanced-connection-tracking>
                            <application-tracking />
                            <description>test description</description>
                            <enable-reverse-reroute />
                            <host-inbound-traffic>
                                <protocols>
                                    <name>all</name>
                                </protocols>
                                <protocols>
                                    <name>bgp</name>
                                    <except />
                                </protocols>
                                <system-services>
                                    <name>all</name>
                                </system-services>
                                <system-services>
                                    <name>dhcp</name>
                                    <except />
                                </system-services>
                            </host-inbound-traffic>
                            <interfaces>
                                <name>ge-0/0/3.0</name>
                            </interfaces>
                            <interfaces>
                                <name>ge-0/0/4.0</name>
                            </interfaces>
                            <screen>test_screen</screen>
                            <source-identity-log />
                            <tcp-rst />
                            <unidirectional-session-refreshing />
                        </security-zone>
                    </zones>
                </security>
            </configuration>
        </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_dict = {
            "functional_zone_management": {
                "description": "test description 2",
                "host_inbound_traffic": {
                    "protocols": [
                        {"name": "all"},
                        {"except": True, "name": "bgp"},
                        {"except": True, "name": "bfd"},
                    ],
                    "system_services": [
                        {"name": "all"},
                        {"except": True, "name": "dhcp"},
                        {"except": True, "name": "dhcpv6"},
                    ],
                },
                "interfaces": ["ge-0/0/1.0", "ge-0/0/2.0"],
                "screen": "test_screen",
            },
            "zones": [
                {
                    "address_book": {
                        "address_sets": [
                            {
                                "addresses": ["test_adr1", "test_adr2"],
                                "name": "test_adrset1",
                            },
                            {
                                "addresses": ["test_adr3", "test_adr4"],
                                "name": "test_adrset2",
                            },
                            {
                                "address_sets": [
                                    "test_adrset1",
                                    "test_adrset2",
                                ],
                                "addresses": ["test_adr5"],
                                "description": "test description",
                                "name": "test_adrset3",
                            },
                        ],
                        "addresses": [
                            {
                                "description": "test desc",
                                "ip_prefix": "10.0.0.0/24",
                                "name": "test_adr1",
                            },
                            {
                                "dns_name": {
                                    "ipv6_only": True,
                                    "name": "1.1.1.1",
                                },
                                "name": "test_adr2",
                            },
                            {
                                "name": "test_adr3",
                                "range_address": {
                                    "from": "10.2.0.1",
                                    "to": "10.2.0.2",
                                },
                            },
                            {
                                "name": "test_adr4",
                                "wildcard_address": "10.3.0.1/24",
                            },
                            {
                                "description": "test desc",
                                "ip_prefix": "10.1.0.0/24",
                                "name": "test_adr5",
                            },
                        ],
                    },
                    "advance_policy_based_routing_profile": "test_profile",
                    "advanced_connection_tracking": {
                        "mode": "allow-any-host",
                        "timeout": "20",
                        "track_all_policies_to_this_zone": True,
                    },
                    "application_tracking": True,
                    "description": "test description",
                    "enable_reverse_reroute": True,
                    "host_inbound_traffic": {
                        "protocols": [
                            {"name": "all"},
                            {"except": True, "name": "bgp"},
                        ],
                        "system_services": [
                            {"name": "all"},
                            {"except": True, "name": "dhcp"},
                        ],
                    },
                    "interfaces": ["ge-0/0/3.0", "ge-0/0/4.0"],
                    "name": "test_sec_zone1",
                    "screen": "test_screen",
                    "source_identity_log": True,
                    "tcp_rst": True,
                    "unidirectional_session_refreshing": True,
                },
                {
                    "name": "test_sec_zone2",
                    "source_identity_log": True,
                    "tcp_rst": True,
                },
            ],
        }
        self.assertEqual(sorted(parsed_dict), sorted(result["parsed"]))

    def test_junos_security_zones_overridden_01(self):
        set_module_args(
            dict(
                config={
                    "functional_zone_management": {
                        "description": "test description 2",
                        "host_inbound_traffic": {
                            "protocols": [{"name": "all"}],
                            "system_services": [{"name": "all"}],
                        },
                        "interfaces": ["ge-0/0/1.0", "ge-0/0/2.0"],
                        "screen": "test_screen",
                    },
                    "zones": [
                        {
                            "address_book": {
                                "address_sets": [
                                    {
                                        "addresses": [
                                            "test_adr1",
                                            "test_adr2",
                                        ],
                                        "name": "test_adrset1",
                                    },
                                    {
                                        "addresses": [
                                            "test_adr3",
                                            "test_adr4",
                                        ],
                                        "name": "test_adrset2",
                                    },
                                    {
                                        "address_sets": [
                                            "test_adrset1",
                                            "test_adrset2",
                                        ],
                                        "addresses": ["test_adr5"],
                                        "description": "test description",
                                        "name": "test_adrset3",
                                    },
                                ],
                                "addresses": [
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.0.0.0/24",
                                        "name": "test_adr1",
                                    },
                                    {
                                        "dns_name": {
                                            "ipv6_only": True,
                                            "name": "1.1.1.1",
                                        },
                                        "name": "test_adr2",
                                    },
                                    {
                                        "name": "test_adr3",
                                        "range_address": {
                                            "from": "10.2.0.1",
                                            "to": "10.2.0.2",
                                        },
                                    },
                                    {
                                        "name": "test_adr4",
                                        "wildcard_address": "10.3.0.1/24",
                                    },
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.1.0.0/24",
                                        "name": "test_adr5",
                                    },
                                ],
                            },
                            "advance_policy_based_routing_profile": "test_profile",
                            "application_tracking": True,
                            "description": "test description",
                            "enable_reverse_reroute": True,
                            "host_inbound_traffic": {
                                "protocols": [
                                    {"name": "all"},
                                    {"except": True, "name": "bgp"},
                                ],
                                "system_services": [
                                    {"name": "all"},
                                    {"except": True, "name": "dhcp"},
                                ],
                            },
                            "interfaces": ["ge-0/0/3.0", "ge-0/0/4.0"],
                            "name": "test_sec_zone1",
                            "screen": "test_screen",
                            "source_identity_log": True,
                            "tcp_rst": True,
                        }
                    ],
                },
                state="overridden",
            )
        )
        result = self.execute_module(changed=True)
        commands = (
            '<nc:security xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:zones delete="delete"/><nc:zones><nc:functional-zone><nc'
            ":management><nc:description>test description 2</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc"
            ":protocols><nc:system-services><nc:name>all</nc:name></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0"
            "/0/1.0</nc:name></nc:interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen></"
            "nc:management></nc:functional-zone><nc:security-zone><nc:name>test_sec_zone1</nc:name><nc:address-book><nc:address><nc:name>test"
            "_adr1</nc:name><nc:ip-prefix>10.0.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:address><nc:address><nc:na"
            "me>test_adr2</nc:name><nc:dns-name><nc:name>1.1.1.1</nc:name><nc:ipv6-only/></nc:dns-name></nc:address><nc:address><nc:name>test"
            "_adr3</nc:name><nc:range-address><nc:name>10.2.0.1</nc:name><nc:to><nc:range-high>10.2.0.2</nc:range-high></nc:to></nc:range-add"
            "ress></nc:address><nc:address><nc:name>test_adr4</nc:name><nc:wildcard-address><nc:name>10.3.0.1/24</nc:name></nc:wildcard-addre"
            "ss></nc:address><nc:address><nc:name>test_adr5</nc:name><nc:ip-prefix>10.1.0.0/24</nc:ip-prefix><nc:description>test desc</nc:de"
            "scription></nc:address><nc:address-set><nc:name>test_adrset1</nc:name><nc:address><nc:name>test_adr1</nc:name></nc:address><nc:a"
            "ddress><nc:name>test_adr2</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name><nc:address><nc:"
            "name>test_adr3</nc:name></nc:address><nc:address><nc:name>test_adr4</nc:name></nc:address></nc:address-set><nc:address-set><nc:n"
            "ame>test_adrset3</nc:name><nc:address><nc:name>test_adr5</nc:name></nc:address><nc:address-set><nc:name>test_adrset1</nc:name></"
            "nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name></nc:address-set><nc:description>test description</nc:description>"
            "</nc:address-set></nc:address-book><nc:advance-policy-based-routing-profile><nc:profile>test_profile</nc:profile></nc:advance-po"
            "licy-based-routing-profile><nc:application-tracking/><nc:description>test description</nc:description><nc:enable-reverse-reroute"
            "/><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:name>bgp</nc:name><nc:except/></"
            "nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-services><nc:system-services><nc:name>dhcp</nc:name><nc:excep"
            "t/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/3.0</nc:name></nc:interfaces><nc:interfaces><nc"
            ":name>ge-0/0/4.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen><nc:source-identity-log/><nc:tcp-rst/></nc:security-"
            "zone></nc:zones></nc:security>"
        )
        self.assertEqual(
            self.sorted_xml(commands), self.sorted_xml(str(result["commands"]))
        )

    def test_junos_security_zones_gathered(self):
        """
        :return:
        """
        set_module_args(dict(state="gathered"))
        result = self.execute_module(changed=False)
        gather_list = {
            "functional_zone_management": {
                "description": "test description 2",
                "host_inbound_traffic": {
                    "protocols": [
                        {"name": "all"},
                        {"except": True, "name": "bgp"},
                        {"except": True, "name": "bfd"},
                    ],
                    "system_services": [
                        {"name": "all"},
                        {"except": True, "name": "dhcp"},
                        {"except": True, "name": "dhcpv6"},
                    ],
                },
                "interfaces": ["ge-0/0/1.0", "ge-0/0/2.0"],
                "screen": "test_screen",
            },
            "zones": [
                {
                    "address_book": {
                        "address_sets": [
                            {
                                "addresses": ["test_adr1", "test_adr2"],
                                "name": "test_adrset1",
                            },
                            {
                                "addresses": ["test_adr3", "test_adr4"],
                                "name": "test_adrset2",
                            },
                            {
                                "address_sets": [
                                    "test_adrset1",
                                    "test_adrset2",
                                ],
                                "addresses": ["test_adr5"],
                                "description": "test description",
                                "name": "test_adrset3",
                            },
                        ],
                        "addresses": [
                            {
                                "description": "test desc",
                                "ip_prefix": "10.0.0.0/24",
                                "name": "test_adr1",
                            },
                            {
                                "dns_name": {
                                    "ipv6_only": True,
                                    "name": "1.1.1.1",
                                },
                                "name": "test_adr2",
                            },
                            {
                                "name": "test_adr3",
                                "range_address": {
                                    "from": "10.2.0.1",
                                    "to": "10.2.0.2",
                                },
                            },
                            {
                                "name": "test_adr4",
                                "wildcard_address": "10.3.0.1/24",
                            },
                            {
                                "description": "test desc",
                                "ip_prefix": "10.1.0.0/24",
                                "name": "test_adr5",
                            },
                        ],
                    },
                    "advance_policy_based_routing_profile": "test_profile",
                    "application_tracking": True,
                    "description": "test description",
                    "enable_reverse_reroute": True,
                    "host_inbound_traffic": {
                        "protocols": [
                            {"name": "all"},
                            {"except": True, "name": "bgp"},
                        ],
                        "system_services": [
                            {"name": "all"},
                            {"except": True, "name": "dhcp"},
                        ],
                    },
                    "interfaces": ["ge-0/0/3.0", "ge-0/0/4.0"],
                    "name": "test_sec_zone1",
                    "screen": "test_screen",
                    "source_identity_log": True,
                    "tcp_rst": True,
                },
                {
                    "name": "test_sec_zone2",
                    "source_identity_log": True,
                    "tcp_rst": True,
                },
            ],
        }
        self.assertEqual(sorted(gather_list), sorted(result["gathered"]))

    def test_junos_security_zones_rendered(self):
        set_module_args(
            dict(
                config={
                    "functional_zone_management": {
                        "description": "test description",
                        "host_inbound_traffic": {
                            "protocols": [
                                {"name": "all"},
                                {"except": True, "name": "bgp"},
                            ],
                            "system_services": [
                                {"name": "all"},
                                {"except": True, "name": "dhcp"},
                            ],
                        },
                        "interfaces": ["ge-0/0/1.0", "ge-0/0/2.0"],
                        "screen": "test_screen",
                    },
                    "zones": [
                        {
                            "address_book": {
                                "address_sets": [
                                    {
                                        "addresses": [
                                            "test_adr1",
                                            "test_adr2",
                                        ],
                                        "name": "test_adrset1",
                                    },
                                    {
                                        "addresses": [
                                            "test_adr3",
                                            "test_adr4",
                                        ],
                                        "name": "test_adrset2",
                                    },
                                    {
                                        "address_sets": [
                                            "test_adrset1",
                                            "test_adrset2",
                                        ],
                                        "addresses": ["test_adr5"],
                                        "description": "test description",
                                        "name": "test_adrset3",
                                    },
                                ],
                                "addresses": [
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.0.0.0/24",
                                        "name": "test_adr1",
                                    },
                                    {
                                        "dns_name": {
                                            "ipv6_only": True,
                                            "name": "1.1.1.1",
                                        },
                                        "name": "test_adr2",
                                    },
                                    {
                                        "name": "test_adr3",
                                        "range_address": {
                                            "from": "10.2.0.1",
                                            "to": "10.2.0.2",
                                        },
                                    },
                                    {
                                        "name": "test_adr4",
                                        "wildcard_address": "10.3.0.1/24",
                                    },
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.1.0.0/24",
                                        "name": "test_adr5",
                                    },
                                ],
                            },
                            "advance_policy_based_routing_profile": "test_profile",
                            "application_tracking": True,
                            "description": "test description",
                            "enable_reverse_reroute": True,
                            "host_inbound_traffic": {
                                "protocols": [
                                    {"name": "all"},
                                    {"except": True, "name": "bgp"},
                                ],
                                "system_services": [
                                    {"name": "all"},
                                    {"except": True, "name": "dhcp"},
                                ],
                            },
                            "interfaces": ["ge-0/0/3.0", "ge-0/0/4.0"],
                            "name": "test_sec_zone1",
                            "screen": "test_screen",
                            "source_identity_log": True,
                            "tcp_rst": True,
                        }
                    ],
                },
                state="rendered",
            )
        )
        rendered = (
            '<nc:security xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:zones><nc:functional-zone><nc:management><nc:description>t'
            "est description</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:na"
            "me>bgp</nc:name><nc:except/></nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-services><nc:system-services><n"
            "c:name>dhcp</nc:name><nc:except/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/1.0</nc:name></nc"
            ":interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen></nc:management></nc:f"
            "unctional-zone><nc:security-zone><nc:name>test_sec_zone1</nc:name><nc:address-book><nc:address><nc:name>test_adr1</nc:name><nc:i"
            "p-prefix>10.0.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:address><nc:address><nc:name>test_adr2</nc:nam"
            "e><nc:dns-name><nc:name>1.1.1.1</nc:name><nc:ipv6-only/></nc:dns-name></nc:address><nc:address><nc:name>test_adr3</nc:name><nc:r"
            "ange-address><nc:name>10.2.0.1</nc:name><nc:to><nc:range-high>10.2.0.2</nc:range-high></nc:to></nc:range-address></nc:address><n"
            "c:address><nc:name>test_adr4</nc:name><nc:wildcard-address><nc:name>10.3.0.1/24</nc:name></nc:wildcard-address></nc:address><nc:"
            "address><nc:name>test_adr5</nc:name><nc:ip-prefix>10.1.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:addre"
            "ss><nc:address-set><nc:name>test_adrset1</nc:name><nc:address><nc:name>test_adr1</nc:name></nc:address><nc:address><nc:name>test"
            "_adr2</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name><nc:address><nc:name>test_adr3</nc:n"
            "ame></nc:address><nc:address><nc:name>test_adr4</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset3</nc"
            ":name><nc:address><nc:name>test_adr5</nc:name></nc:address><nc:address-set><nc:name>test_adrset1</nc:name></nc:address-set><nc:a"
            "ddress-set><nc:name>test_adrset2</nc:name></nc:address-set><nc:description>test description</nc:description></nc:address-set></n"
            "c:address-book><nc:advance-policy-based-routing-profile><nc:profile>test_profile</nc:profile></nc:advance-policy-based-routing-p"
            "rofile><nc:application-tracking/><nc:description>test description</nc:description><nc:enable-reverse-reroute/><nc:host-inbound-t"
            "raffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:name>bgp</nc:name><nc:except/></nc:protocols><nc:sys"
            "tem-services><nc:name>all</nc:name></nc:system-services><nc:system-services><nc:name>dhcp</nc:name><nc:except/></nc:system-servi"
            "ces></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/3.0</nc:name></nc:interfaces><nc:interfaces><nc:name>ge-0/0/4.0</nc"
            ":name></nc:interfaces><nc:screen>test_screen</nc:screen><nc:source-identity-log/><nc:tcp-rst/></nc:security-zone></nc:zones></nc"
            ":security>"
        )
        result = self.execute_module(changed=False)
        self.assertEqual(
            self.sorted_xml(result["rendered"]), self.sorted_xml(rendered)
        )

    def test_junos_security_zones_replaced_01(self):
        set_module_args(
            dict(
                config={
                    "functional_zone_management": {
                        "description": "test description 2",
                        "host_inbound_traffic": {
                            "protocols": [{"name": "all"}],
                            "system_services": [{"name": "all"}],
                        },
                        "interfaces": ["ge-0/0/1.0", "ge-0/0/2.0"],
                        "screen": "test_screen",
                    },
                    "zones": [
                        {
                            "address_book": {
                                "address_sets": [
                                    {
                                        "addresses": [
                                            "test_adr1",
                                            "test_adr2",
                                        ],
                                        "name": "test_adrset1",
                                    },
                                    {
                                        "addresses": [
                                            "test_adr3",
                                            "test_adr4",
                                        ],
                                        "name": "test_adrset2",
                                    },
                                    {
                                        "address_sets": [
                                            "test_adrset1",
                                            "test_adrset2",
                                        ],
                                        "addresses": ["test_adr5"],
                                        "description": "test description",
                                        "name": "test_adrset3",
                                    },
                                ],
                                "addresses": [
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.0.0.0/24",
                                        "name": "test_adr1",
                                    },
                                    {
                                        "dns_name": {
                                            "ipv6_only": True,
                                            "name": "1.1.1.1",
                                        },
                                        "name": "test_adr2",
                                    },
                                    {
                                        "name": "test_adr3",
                                        "range_address": {
                                            "from": "10.2.0.1",
                                            "to": "10.2.0.2",
                                        },
                                    },
                                    {
                                        "name": "test_adr4",
                                        "wildcard_address": "10.3.0.1/24",
                                    },
                                    {
                                        "description": "test desc",
                                        "ip_prefix": "10.1.0.0/24",
                                        "name": "test_adr5",
                                    },
                                ],
                            },
                            "advance_policy_based_routing_profile": "test_profile",
                            "application_tracking": True,
                            "description": "test description",
                            "enable_reverse_reroute": True,
                            "host_inbound_traffic": {
                                "protocols": [
                                    {"name": "all"},
                                    {"except": True, "name": "bgp"},
                                ],
                                "system_services": [
                                    {"name": "all"},
                                    {"except": True, "name": "dhcp"},
                                ],
                            },
                            "interfaces": ["ge-0/0/3.0", "ge-0/0/4.0"],
                            "name": "test_sec_zone1",
                            "screen": "test_screen",
                            "source_identity_log": True,
                            "tcp_rst": True,
                        }
                    ],
                },
                state="replaced",
            )
        )
        result = self.execute_module(changed=True)
        commands = (
            '<nc:security xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:zones delete="delete"/><nc:zones><nc:functional-zone><nc'
            ":management><nc:description>test description 2</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc"
            ":protocols><nc:system-services><nc:name>all</nc:name></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0"
            "/0/1.0</nc:name></nc:interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen></"
            "nc:management></nc:functional-zone><nc:security-zone><nc:name>test_sec_zone1</nc:name><nc:address-book><nc:address><nc:name>test"
            "_adr1</nc:name><nc:ip-prefix>10.0.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:address><nc:address><nc:na"
            "me>test_adr2</nc:name><nc:dns-name><nc:name>1.1.1.1</nc:name><nc:ipv6-only/></nc:dns-name></nc:address><nc:address><nc:name>test"
            "_adr3</nc:name><nc:range-address><nc:name>10.2.0.1</nc:name><nc:to><nc:range-high>10.2.0.2</nc:range-high></nc:to></nc:range-add"
            "ress></nc:address><nc:address><nc:name>test_adr4</nc:name><nc:wildcard-address><nc:name>10.3.0.1/24</nc:name></nc:wildcard-addre"
            "ss></nc:address><nc:address><nc:name>test_adr5</nc:name><nc:ip-prefix>10.1.0.0/24</nc:ip-prefix><nc:description>test desc</nc:de"
            "scription></nc:address><nc:address-set><nc:name>test_adrset1</nc:name><nc:address><nc:name>test_adr1</nc:name></nc:address><nc:a"
            "ddress><nc:name>test_adr2</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name><nc:address><nc:"
            "name>test_adr3</nc:name></nc:address><nc:address><nc:name>test_adr4</nc:name></nc:address></nc:address-set><nc:address-set><nc:n"
            "ame>test_adrset3</nc:name><nc:address><nc:name>test_adr5</nc:name></nc:address><nc:address-set><nc:name>test_adrset1</nc:name></"
            "nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name></nc:address-set><nc:description>test description</nc:description>"
            "</nc:address-set></nc:address-book><nc:advance-policy-based-routing-profile><nc:profile>test_profile</nc:profile></nc:advance-po"
            "licy-based-routing-profile><nc:application-tracking/><nc:description>test description</nc:description><nc:enable-reverse-reroute"
            "/><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:name>bgp</nc:name><nc:except/></"
            "nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-services><nc:system-services><nc:name>dhcp</nc:name><nc:excep"
            "t/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/3.0</nc:name></nc:interfaces><nc:interfaces><nc"
            ":name>ge-0/0/4.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen><nc:source-identity-log/><nc:tcp-rst/></nc:security-"
            "zone></nc:zones></nc:security>"
        )
        self.assertEqual(
            self.sorted_xml(commands), self.sorted_xml(str(result["commands"]))
        )
