# -*- coding: utf-8 -*-

# Authors:
#   Thomas Woerner <twoerner@redhat.com>
#
# Based on ipa-server-install code
#
# Copyright (C) 2017  Red Hat
# see file 'COPYING' for use and warranty information
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import (absolute_import, division, print_function)

__metaclass__ = type

ANSIBLE_METADATA = {
    'metadata_version': '1.0',
    'supported_by': 'community',
    'status': ['preview'],
}

DOCUMENTATION = '''
---
module: ipareplica_master_password
short_description: Generate kerberos master password if not given
description:
  Generate kerberos master password if not given
options:
  master_password:
    description: kerberos master password (normally autogenerated)
    required: yes
author:
    - Thomas Woerner
'''

EXAMPLES = '''
'''

RETURN = '''
password:
  description: The master password
  returned: always
'''

from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.ansible_ipa_replica import (
    setup_logging, ipa_generate_password
)


def main():
    module = AnsibleModule(
        argument_spec=dict(
            # basic
            master_password=dict(required=False, no_log=True),
        ),
        supports_check_mode=True,
    )

    module._ansible_debug = True
    setup_logging()

    master_password = module.params.get('master_password')

    if not master_password:
        master_password = ipa_generate_password()

    module.exit_json(changed=True,
                     password=master_password)


if __name__ == '__main__':
    main()
