#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#define N_ELEMENTS(arr) (sizeof(arr) / sizeof((arr)[0]))

#define arg_unused __attribute__((unused))

#define autofree __attribute__((cleanup(cleanup_free)))
#define autoclose __attribute__((cleanup(cleanup_close)))
#define autofclose __attribute__((cleanup(cleanup_fclose)))
#define autofreeconfig __attribute__((cleanup(cleanup_config_ptr)))
#define autounlink __attribute__((cleanup(cleanup_unlink)))
#define autofclosedir __attribute__((cleanup(cleanup_dclose)))

#define DEFAULT_ABOOT_CFG_NAME "aboot.cfg"
#define DEFAULT_ABOOT_CFG_PATH "/boot/" DEFAULT_ABOOT_CFG_NAME

typedef struct {
	char *partition_a;
	char *partition_b;
	char *vbmeta_partition_a;
	char *vbmeta_partition_b;
	char *bootlabel;
	char *boot_type;
	char *pagesize;
	char *base;
	char *kernel_offset;
	char *partition_ctl;
	char *ramdisk_offset;
	char *tags_offset;
	char *second_offset;
	char *dtb_offset;
	char *dtb_file;
	char *cmdline;
	char *compress_kernel;
} AbootConfig;

extern bool use_verbose;

extern void *xmalloc(size_t size) __attribute__((__malloc__))
__attribute__((__alloc_size__(1)));
extern void *xcalloc(size_t nmemb, size_t size)
	__attribute__((__alloc_size__(1, 2)));
extern void *xrealloc(void *ptr, size_t size) __attribute__((warn_unused_result));
extern char *xasprintf(const char *fmt, ...)
	__attribute__((__format__(printf, 1, 2)));

extern void verbose(const char *format, ...)
	__attribute__((__format__(printf, 1, 2)));
extern void error(const char *format, ...)
	__attribute__((__format__(printf, 1, 2)));
extern void fatal(const char *format, ...) __attribute__((__noreturn__))
__attribute__((__format__(printf, 1, 2)));
extern void oom(void) __attribute__((__noreturn__));

static inline void cleanup_free(void *p)
{
	free(*(void **)p);
}

static inline void cleanup_close(const int *fd)
{
	if (*fd >= 0)
		close(*fd);
}

static inline void cleanup_fclose(FILE **f)
{
	if (f && *f) {
		fclose(*f);
	}
}

static inline void cleanup_dclose(DIR **d)
{
	if (d && *d) {
		closedir(*d);
	}
}

static inline void cleanup_unlink(char **path)
{
	if (path && *path) {
		unlink(*path);
		free(*path);
	}
}

static inline void *steal_ptr(void *_pp)
{
	void **pp = (void **)_pp;
	void *p = NULL;

	p = *pp;
	*pp = NULL;

	return p;
}

extern bool str_has_prefix(const char *str, const char *prefix);
extern char *xbasename(const char *path);
extern char *xdirname(const char *path);
extern char *join_path(const char *a, const char *b);
extern char *join_3_path(const char *a, const char *b, const char *c);
extern char *resolve_relative_path(const char *dir, const char *relative);
extern char *resolve_symlink_in_root(const char *rootdir, const char *symlink_path);
extern char *read_file(const char *filename);
extern char *read_proc_cmdline(void);
extern char *resolve_kernel_cmdline(const char *rootdir);
extern char *read_cmdline_from_path(const char *path);
extern char *find_proc_cmdline_key(const char *cmdline, const char *key);
extern char *trimwhitespace(char *str);
extern int write_file_to_disk(const char *source, const char *destination);
extern off_t get_image_size(const char *image);
extern off_t get_block_dev_size(const char *destination);
extern int atomic_symlink(const char *target, const char *linkpath);
extern char *xstrdup(const char *string);
extern char *xstrndup(const char *string, size_t n);
extern char *remove_prefix(const char *full_path, const char *prefix);
extern int exec_command(const char *const argv[], int stdout_fd);
extern int aboot_config_load(AbootConfig *cfg, const char *filename);
extern void aboot_config_free(AbootConfig *cfg);
extern AbootConfig *aboot_config_new(void);

static inline void cleanup_config_ptr(void *p)
{
	AbootConfig **cfg_ptr = (AbootConfig **)p;
	if (cfg_ptr && *cfg_ptr) {
		aboot_config_free(*cfg_ptr);
	}
}

extern char *__realpath_retry(const char *path, char *resolved_path,
			    unsigned long timeout_ms, unsigned long rate_ms);
static inline char *realpath_retry(const char *path, char *resolved_path)
{
	return __realpath_retry(path, resolved_path, 2000, 100);
}
