#pragma once

#include <stdbool.h>
#include <sys/types.h>
#include <stddef.h>
#include "aboot-utils.h"

typedef enum {
	BOOT_SWITCHER_UKIBOOT,
	BOOT_SWITCHER_ABCTL,
	BOOT_SWITCHER_QBOOTCTL,
	BOOT_SWITCHER_ABOOT_GPTCTL,
	BOOT_SWITCHER_SINGLE_SLOT,
} BootSwitcher;

typedef enum {
	PARTITION_A,
	PARTITION_B,
} BootPartition;

void print_usage(void);

char *get_partition_path(const char *boot_type, BootPartition partition);

BootSwitcher detect_switcher(const char *boot_type);
int prepare_switch(BootSwitcher switcher, BootPartition partition);
int finalize_switch(BootSwitcher switcher, BootPartition partition);

BootPartition get_booted_slot(BootSwitcher switcher);

int validate_destinations(const char *destination);

char *create_vbmeta_path(const char *original_path);
