# aboot-deploy

aboot-deploy, and the related tool aboot-update are tools that
integrate traditional linux systems like Fedora and CentOS with
bootloaders using the android boot mechanism, or similar systems like
ukiboot.

## Configuration

The basic configuration file is in /boot/aboot.cfg. This file defines
what type of aboot system is used, as well as what partitions are
used, and options for creating the aboot image to match the current system.

## aboot-update

The aboot-update tool reads the configuration from aboot.cfg, and uses it
to create the aboot.img file (typically as `/boot/aboot-$KERNELVER.img`) using
the kernel, initrd, (optional) dtb and kernel commandline.

This is needed because the kernel rpm doesn't contain an aboot.img, and the
details of how to create it can vary by system.

aboot-update is always called during image build, because it is needed
to build the initial image. Additionally, it needs to be called when a
new kernel rpm is installed (or updated). This is done by a kernel
post-install script called 90-aboot.install.

Note: When using ostree-style systems, aboot-update is never run at
runtime. Instead it is run when the updated image is created and is
available directly from the image being updated to.

aboot-update calls out to external tools, like mkbootimg from
android-tools, or ukify from systemd-ukify) to do the actual creation
of the aboot.img file. While aboot-deploy itself is a small program,
these tools have rather large dependency sets (including python), so it
is advantageous for minimal system to not install it.

## aboot-deploy

The aboot-deploy tool take an existing aboot.img file, created by
aboot-update, and reads the aboot.cfg for configuration details. This
configuration will be used to pick the right tools to use for an update,
then the file will be writtent to the right partition, and the tools
will be invoked to activate the new partition.

For example, if the configuration says that the type is "ukiboot",
then it will use ukibootctl will be used to tell which boot partition
is active (say `ukiboot_a`), and then the image will be written to the
non-active one (`ukiboot_b`). Then ukibootctl will be called to make
`ukiboot_b` active.

aboot-deploy is invoked automatically as part of OS integration in two
places:
 * The 90-aboot.install script which is called after a kernel rpm is
   installed. This is called after aboot-update has been called, whic
   has created a new aboot.img.
 * When ostree deploys a new commit it, at the end it automatically
   calls out to aboot-deploy.

The above means that when you update the kernel either via rpm, or
ostree/bootc, then the new kernel will be written to the inactive
partition automatically, and on success it will be activated for the
next reboot.

Note: During image build, at least when osbuild is used, aboot-deploy
is not used, because it does direct device disk access. But during
image build it should instead write to a loopback device to modify the
disk image file being created. This means the image builder manually
does the initial partition writes.

## Details about integration

Here are some specific details on the integration points with the OS
and image builder. This is useful to figure out how exactly things are
called:


### Image build integration

At image build time, the configuration is written to either
/boot/aboot.cfg, or if ostree is used, to
/usr/lib/ostree-boot/aboot.cfg (which ostree will copy to /boot at
deploy time).

Then aboot-deploy will be invoked as `aboot-update -r $IMGROOT $KERNELVER`,
where `$IMGROOT` is the root directroy of the new image and `$KERNELVER` is
the kernel version in the image (i.e. it has a `/usr/lib/modules/$KERNELVER`
directory). Additionally, in the ostree case, the `-p` option is
supplied, to signal that files are in `/usr/lib/ostree-boot`, rather
than in `/boot`.

### Runtime integration

When ostree is used, during deploy, it will invoke aboot-deploy
something like this:

```
aboot-deploy -r /sysroot -c /ostree/deploy/default/deploy/70c7a.0/usr/lib/ostree-boot/aboot.cfg -o $KERNELOPTS /ostree/default-fa95b/aboot-$KERNELVER.img
```

This will read the config file and aboot.img specific to the new image
deployment and write them to disk.

When the kernel package post-install script is run, then instead it will invoke something like:
```
aboot-update $KERNELVER
aboot-deploy -l aboot-$KERNELVER.img
```
