'''OpenGL extension ARB.sync

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.sync to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces the concept of "sync objects". Sync
	objects are a synchronization primitive - a representation of events
	whose completion status can be tested or waited upon. One specific
	type of sync object, the "fence sync object", is supported in this
	extension, and additional types can easily be added in the future.
	
	Fence sync objects have corresponding fences, which are inserted
	into the OpenGL command stream at the time the sync object is
	created. A sync object can be queried for a given condition. The
	only condition supported for fence sync objects is completion of the
	corresponding fence command. Fence completion allows applications to
	request a partial Finish, wherein all commands prior to the fence
	will be forced to complete before control is returned to the calling
	process.
	
	These new mechanisms allow for synchronization between the host CPU
	and the GPU, which may be accessing the same resources (typically
	memory), as well as between multiple GL contexts bound to multiple
	threads in the host CPU.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/sync.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.sync import *
### END AUTOGENERATED SECTION